# LINEX2 python package

![PyPI - License](https://img.shields.io/pypi/l/linex2) ![PyPI](https://img.shields.io/pypi/v/linex2)

The software is the implementation for Lipid network computation and analysis 
for the Lipid Network Explorer (LINEX) version 2. 

The LINEX web service can be found here: 
[https://exbio.wzw.tum.de/linex/](https://exbio.wzw.tum.de/linex/)

### Publication
If you use this package, please cite our publication:

_Rose and Koehler et al. "Lipid network and moiety analyses reveal enzymatic dysregulation and altered mechanisms from lipidomics",
bioRxiv 2022.02.04.479101_; doi: [https://doi.org/10.1101/2022.02.04.479101](https://doi.org/10.1101/2022.02.04.479101)

### Data in package

The package includes data from the [Reactome](https://reactome.org/) and 
[Rhea](https://www.rhea-db.org/) databases.

* **Rhea** data is available under the 
[Creative Commons Attribution (CC BY 4.0) License](https://creativecommons.org/licenses/by/4.0/)
and is published here: Bansal et al. "Rhea, the reaction knowledgebase in 2022".
Nucleic Acids Res. (2021), DOI: [10.1093/nar/gkab1016](https://doi.org/10.1093/nar/gkab1016)
* **Reactome** data is available under the
[Creative Commons Public Domain (CC0) License](https://creativecommons.org/publicdomain/zero/1.0/)
and is published here: Jassal et al. "The reactome pathway knowledgebase".
Nucleic Acids Res. (2020), DOI: [10.1093/nar/gkz1031](https://doi.org/10.1093/nar/gkz1031)

### License

The software is published under the AGPLv3 license.

![AGPLv3 logo](https://www.gnu.org/graphics/agplv3-with-text-162x68.png)

The software includes code from the 
[LINEX webtool](https://gitlab.lrz.de/lipitum-projects/linex) 
published under the same license and written by the same authors.
