import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="qspider",
    version="0.1.4",
    author="Tishacy",
    author_email="",
    description="An easy to use tools module for writing multi-thread and multi-process programs.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=setuptools.find_packages(),
    include_package_data=True,
    install_requires=[
        'termcolor>=1.1.0',
        'colorama>=0.4.3',
        'colored>=1.4.2'
    ],
    entry_points={
        'console_scripts': [
            'genqspider=qspider.core:genqspider'
        ],
    },
    classifiers=(
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ),
)