def acceleration(value, units):
    returnDict = {}
    if units == 'g':
        returnDict['g'] = value
        returnDict['cm/min2'] = value * 3530394.0
        returnDict['cm/s2'] = value * 980.66
        returnDict['ft/min2'] = value * 115826.57
        returnDict['ft/s2'] = value * 32.17
        returnDict['Gal'] = value * 980.66
        returnDict['in/h2'] = value * 5000000000.0
        returnDict['in/min2'] = value * 1389918.9
        returnDict['in/s2'] = value * 386.09
        returnDict['km/hr2'] = value * 127094.18
        returnDict['km/min2'] = value * 35.3
        returnDict['km/s2'] = value * 0.01
        returnDict['m/d2'] = value * 73200000000.0
        returnDict['m/h2'] = value * 127000000.0
        returnDict['m/min2'] = value * 5303.94
        returnDict['m/s2'] = value * 9.81
        returnDict['mi/hr2'] = value * 78972.66
        returnDict['mi/min2'] = value * 21.94
        returnDict['mi/s2'] = value * 0.01
        returnDict['mm/s2'] = value * 9806.65
        returnDict['knot/s'] = value * 19.062602591793
    elif units == 'cm/min2':
        returnDict['g'] = value * 2.83e-07
        returnDict['cm/min2'] = value
        returnDict['cm/s2'] = value * 0.000278
        returnDict['ft/min2'] = value * 0.03
        returnDict['ft/s2'] = value * 9.1e-06
        returnDict['Gal'] = value * 0.000278
        returnDict['in/h2'] = value * 1417.32
        returnDict['in/min2'] = value * 0.39
        returnDict['in/s2'] = value * 0.000109
        returnDict['km/hr2'] = value * 0.04
        returnDict['km/min2'] = value * 1e-05
        returnDict['km/s2'] = value * 2.78e-09
        returnDict['m/d2'] = value * 20736.0
        returnDict['m/h2'] = value * 36.0
        returnDict['m/min2'] = value * 0.01
        returnDict['m/s2'] = value * 2.78e-06
        returnDict['mi/hr2'] = value * 0.02
        returnDict['mi/min2'] = value * 6.2e-06
        returnDict['mi/s2'] = value * 1.73e-09
        returnDict['mm/s2'] = value * 0.00278
        returnDict['knot/s'] = value * 5.394716533477418e-06
    elif units == 'cm/s2':
        returnDict['g'] = value * 0.00102
        returnDict['cm/min2'] = value * 3600.0
        returnDict['cm/s2'] = value
        returnDict['ft/min2'] = value * 118.11
        returnDict['ft/s2'] = value * 0.03
        returnDict['Gal'] = value
        returnDict['in/h2'] = value * 5102362.2
        returnDict['in/min2'] = value * 1417.32
        returnDict['in/s2'] = value * 0.39
        returnDict['km/hr2'] = value * 129.6
        returnDict['km/min2'] = value * 0.04
        returnDict['km/s2'] = value * 1e-05
        returnDict['m/d2'] = value * 74600000.0
        returnDict['m/h2'] = value * 129600.0
        returnDict['m/min2'] = value * 36.0
        returnDict['m/s2'] = value * 0.01
        returnDict['mi/hr2'] = value * 80.53
        returnDict['mi/min2'] = value * 0.02
        returnDict['mi/s2'] = value * 6.2e-06
        returnDict['mm/s2'] = value * 10.0
        returnDict['knot/s'] = value * 0.01944385464362886
    elif units == 'ft/min2':
        returnDict['g'] = value * 8.6e-06
        returnDict['cm/min2'] = value * 30.48
        returnDict['cm/s2'] = value * 0.01
        returnDict['ft/min2'] = value
        returnDict['ft/s2'] = value * 0.000278
        returnDict['Gal'] = value * 0.01
        returnDict['in/h2'] = value * 43200.0
        returnDict['in/min2'] = value * 12.0
        returnDict['in/s2'] = value * 0.00333
        returnDict['km/hr2'] = value * 1.1
        returnDict['km/min2'] = value * 0.000305
        returnDict['km/s2'] = value * 8.47e-08
        returnDict['m/d2'] = value * 632033.28
        returnDict['m/h2'] = value * 1097.28
        returnDict['m/min2'] = value * 0.3
        returnDict['m/s2'] = value * 8.5e-05
        returnDict['mi/hr2'] = value * 0.68
        returnDict['mi/min2'] = value * 0.000189
        returnDict['mi/s2'] = value * 5.26e-08
        returnDict['mm/s2'] = value * 0.08
        returnDict['knot/s'] = value * 0.0001639383822894198
    elif units == 'ft/s2':
        returnDict['g'] = value * 0.08
        returnDict['cm/min2'] = value * 109728.0
        returnDict['cm/s2'] = value * 30.48
        returnDict['ft/min2'] = value * 3600.0
        returnDict['ft/s2'] = value
        returnDict['Gal'] = value * 30.48
        returnDict['in/h2'] = value * 156000000.0
        returnDict['in/min2'] = value * 43200.0
        returnDict['in/s2'] = value * 12.0
        returnDict['km/hr2'] = value * 3950.21
        returnDict['km/min2'] = value * 1.1
        returnDict['km/s2'] = value * 0.000305
        returnDict['m/d2'] = value * 2280000000.0
        returnDict['m/h2'] = value * 3950208.0
        returnDict['m/min2'] = value * 1097.28
        returnDict['m/s2'] = value * 0.3
        returnDict['mi/hr2'] = value * 2454.55
        returnDict['mi/min2'] = value * 0.68
        returnDict['mi/s2'] = value * 0.000189
        returnDict['mm/s2'] = value * 304.8
        returnDict['knot/s'] = value * 1.52500820734344
    elif units == 'Gal':
        returnDict['g'] = value * 0.00102
        returnDict['cm/min2'] = value * 3600.0
        returnDict['cm/s2'] = value
        returnDict['ft/min2'] = value * 118.11
        returnDict['ft/s2'] = value * 0.03
        returnDict['Gal'] = value
        returnDict['in/h2'] = value * 5102362.2
        returnDict['in/min2'] = value * 1417.32
        returnDict['in/s2'] = value * 0.39
        returnDict['km/hr2'] = value * 129.6
        returnDict['km/min2'] = value * 0.04
        returnDict['km/s2'] = value * 1e-05
        returnDict['m/d2'] = value * 74600000.0
        returnDict['m/h2'] = value * 129600.0
        returnDict['m/min2'] = value * 36.0
        returnDict['m/s2'] = value * 0.01
        returnDict['mi/hr2'] = value * 80.53
        returnDict['mi/min2'] = value * 0.02
        returnDict['mi/s2'] = value * 6.2e-06
        returnDict['mm/s2'] = value * 10.0
        returnDict['knot/s'] = value * 0.01944385464362886
    elif units == 'in/h2':
        returnDict['g'] = value * 2e-10
        returnDict['cm/min2'] = value * 0.00071
        returnDict['cm/s2'] = value * 1.96e-07
        returnDict['ft/min2'] = value * 2.31e-05
        returnDict['ft/s2'] = value * 6.43e-09
        returnDict['Gal'] = value * 1.96e-07
        returnDict['in/h2'] = value
        returnDict['in/min2'] = value * 0.000278
        returnDict['in/s2'] = value * 7.72e-08
        returnDict['km/hr2'] = value * 2.54e-05
        returnDict['km/min2'] = value * 7.06e-09
        returnDict['km/s2'] = value * 1.96e-12
        returnDict['m/d2'] = value * 14.63
        returnDict['m/h2'] = value * 0.03
        returnDict['m/min2'] = value * 7.1e-06
        returnDict['m/s2'] = value * 1.96e-09
        returnDict['mi/hr2'] = value * 1.58e-05
        returnDict['mi/min2'] = value * 4.38e-09
        returnDict['mi/s2'] = value * 1.22e-12
        returnDict['mm/s2'] = value * 1.96e-06
        returnDict['knot/s'] = value * 3.8125205183586e-09
    elif units == 'in/min2':
        returnDict['g'] = value * 7.19e-07
        returnDict['cm/min2'] = value * 2.54
        returnDict['cm/s2'] = value * 0.00071
        returnDict['ft/min2'] = value * 0.08
        returnDict['ft/s2'] = value * 2.31e-05
        returnDict['Gal'] = value * 0.00071
        returnDict['in/h2'] = value * 3600.0
        returnDict['in/min2'] = value
        returnDict['in/s2'] = value * 0.000278
        returnDict['km/hr2'] = value * 0.09
        returnDict['km/min2'] = value * 2.54e-05
        returnDict['km/s2'] = value * 7.06e-09
        returnDict['m/d2'] = value * 52669.44
        returnDict['m/h2'] = value * 91.44
        returnDict['m/min2'] = value * 0.03
        returnDict['m/s2'] = value * 7.1e-06
        returnDict['mi/hr2'] = value * 0.06
        returnDict['mi/min2'] = value * 1.58e-05
        returnDict['mi/s2'] = value * 4.38e-09
        returnDict['mm/s2'] = value * 0.01
        returnDict['knot/s'] = value * 1.3706011263499167e-05
    elif units == 'in/s2':
        returnDict['g'] = value * 0.00259
        returnDict['cm/min2'] = value * 9144.0
        returnDict['cm/s2'] = value * 2.54
        returnDict['ft/min2'] = value * 300.0
        returnDict['ft/s2'] = value * 0.08
        returnDict['Gal'] = value * 2.54
        returnDict['in/h2'] = value * 13000000.0
        returnDict['in/min2'] = value * 3600.0
        returnDict['in/s2'] = value
        returnDict['km/hr2'] = value * 329.18
        returnDict['km/min2'] = value * 0.09
        returnDict['km/s2'] = value * 2.54e-05
        returnDict['m/d2'] = value * 190000000.0
        returnDict['m/h2'] = value * 329184.0
        returnDict['m/min2'] = value * 91.44
        returnDict['m/s2'] = value * 0.03
        returnDict['mi/hr2'] = value * 204.55
        returnDict['mi/min2'] = value * 0.06
        returnDict['mi/s2'] = value * 1.58e-05
        returnDict['mm/s2'] = value * 25.4
        returnDict['knot/s'] = value * 0.049372140712743866
    elif units == 'km/hr2':
        returnDict['g'] = value * 7.9e-06
        returnDict['cm/min2'] = value * 27.78
        returnDict['cm/s2'] = value * 0.01
        returnDict['ft/min2'] = value * 0.91
        returnDict['ft/s2'] = value * 0.000253
        returnDict['Gal'] = value * 0.01
        returnDict['in/h2'] = value * 39370.08
        returnDict['in/min2'] = value * 10.94
        returnDict['in/s2'] = value * 0.00304
        returnDict['km/hr2'] = value
        returnDict['km/min2'] = value * 0.000278
        returnDict['km/s2'] = value * 7.72e-08
        returnDict['m/d2'] = value * 576000.0
        returnDict['m/h2'] = value * 1000.0
        returnDict['m/min2'] = value * 0.28
        returnDict['m/s2'] = value * 7.7e-05
        returnDict['mi/hr2'] = value * 0.62
        returnDict['mi/min2'] = value * 0.000173
        returnDict['mi/s2'] = value * 4.79e-08
        returnDict['mm/s2'] = value * 0.08
        returnDict['knot/s'] = value * 0.0001505945604751647
    elif units == 'km/min2':
        returnDict['g'] = value * 0.03
        returnDict['cm/min2'] = value * 100000.0
        returnDict['cm/s2'] = value * 27.78
        returnDict['ft/min2'] = value * 3280.84
        returnDict['ft/s2'] = value * 0.91
        returnDict['Gal'] = value * 27.78
        returnDict['in/h2'] = value * 142000000.0
        returnDict['in/min2'] = value * 39370.08
        returnDict['in/s2'] = value * 10.94
        returnDict['km/hr2'] = value * 3600.0
        returnDict['km/min2'] = value
        returnDict['km/s2'] = value * 0.000278
        returnDict['m/d2'] = value * 2070000000.0
        returnDict['m/h2'] = value * 3600000.0
        returnDict['m/min2'] = value * 1000.0
        returnDict['m/s2'] = value * 0.28
        returnDict['mi/hr2'] = value * 2236.94
        returnDict['mi/min2'] = value * 0.62
        returnDict['mi/s2'] = value * 0.000173
        returnDict['mm/s2'] = value * 277.78
        returnDict['knot/s'] = value * 0.57187807775379
    elif units == 'km/s2':
        returnDict['g'] = value * 101.97
        returnDict['cm/min2'] = value * 360000000.0
        returnDict['cm/s2'] = value * 100000.0
        returnDict['ft/min2'] = value * 11800000.0
        returnDict['ft/s2'] = value * 3280.84
        returnDict['Gal'] = value * 100000.0
        returnDict['in/h2'] = value * 510000000000.0
        returnDict['in/min2'] = value * 142000000.0
        returnDict['in/s2'] = value * 39370.08
        returnDict['km/hr2'] = value * 13000000.0
        returnDict['km/min2'] = value * 3600.0
        returnDict['km/s2'] = value
        returnDict['m/d2'] = value * 7460000000000.0
        returnDict['m/h2'] = value * 13000000000.0
        returnDict['m/min2'] = value * 3600000.0
        returnDict['m/s2'] = value * 1000.0
        returnDict['mi/hr2'] = value * 8052970.65
        returnDict['mi/min2'] = value * 2236.94
        returnDict['mi/s2'] = value * 0.62
        returnDict['mm/s2'] = value * 1000000.0
        returnDict['knot/s'] = value * 1943.813586285132
    elif units == 'm/d2':
        returnDict['g'] = value * 1.37e-11
        returnDict['cm/min2'] = value * 4.82e-05
        returnDict['cm/s2'] = value * 1.34e-08
        returnDict['ft/min2'] = value * 1.58e-06
        returnDict['ft/s2'] = value * 4.39e-10
        returnDict['Gal'] = value * 1.34e-08
        returnDict['in/h2'] = value * 0.07
        returnDict['in/min2'] = value * 1.9e-05
        returnDict['in/s2'] = value * 5.27e-09
        returnDict['km/hr2'] = value * 1.74e-06
        returnDict['km/min2'] = value * 4.82e-10
        returnDict['km/s2'] = value * 1.34e-13
        returnDict['m/d2'] = value
        returnDict['m/h2'] = value * 0.00174
        returnDict['m/min2'] = value * 4.82e-07
        returnDict['m/s2'] = value * 1.34e-10
        returnDict['mi/hr2'] = value * 1.08e-06
        returnDict['mi/min2'] = value * 3e-10
        returnDict['mi/s2'] = value * 8.32e-14
        returnDict['mm/s2'] = value * 1.34e-07
        returnDict['knot/s'] = value * 2.611576555075641e-10
    elif units == 'm/h2':
        returnDict['g'] = value * 7.87e-09
        returnDict['cm/min2'] = value * 0.03
        returnDict['cm/s2'] = value * 7.7e-06
        returnDict['ft/min2'] = value * 0.00091
        returnDict['ft/s2'] = value * 2.53e-07
        returnDict['Gal'] = value * 7.7e-06
        returnDict['in/h2'] = value * 39.37
        returnDict['in/min2'] = value * 0.01
        returnDict['in/s2'] = value * 3.04e-06
        returnDict['km/hr2'] = value * 0.001
        returnDict['km/min2'] = value * 2.78e-07
        returnDict['km/s2'] = value * 7.72e-11
        returnDict['m/d2'] = value * 576.0
        returnDict['m/h2'] = value
        returnDict['m/min2'] = value * 0.000278
        returnDict['m/s2'] = value * 7.72e-08
        returnDict['mi/hr2'] = value * 0.00062
        returnDict['mi/min2'] = value * 1.73e-07
        returnDict['mi/s2'] = value * 4.79e-11
        returnDict['mm/s2'] = value * 7.7e-05
        returnDict['knot/s'] = value * 1.500226823974109e-07
    elif units == 'm/min2':
        returnDict['g'] = value * 2.83e-05
        returnDict['cm/min2'] = value * 100.0
        returnDict['cm/s2'] = value * 0.03
        returnDict['ft/min2'] = value * 3.28
        returnDict['ft/s2'] = value * 0.00091
        returnDict['Gal'] = value * 0.03
        returnDict['in/h2'] = value * 141732.28
        returnDict['in/min2'] = value * 39.37
        returnDict['in/s2'] = value * 0.01
        returnDict['km/hr2'] = value * 3.6
        returnDict['km/min2'] = value * 0.001
        returnDict['km/s2'] = value * 2.78e-07
        returnDict['m/d2'] = value * 2073600.0
        returnDict['m/h2'] = value * 3600.0
        returnDict['m/min2'] = value
        returnDict['m/s2'] = value * 0.000278
        returnDict['mi/hr2'] = value * 2.24
        returnDict['mi/min2'] = value * 0.00062
        returnDict['mi/s2'] = value * 1.73e-07
        returnDict['mm/s2'] = value * 0.28
        returnDict['knot/s'] = value * 0.0005394716533477418
    elif units == 'm/s2':
        returnDict['g'] = value * 0.1
        returnDict['cm/min2'] = value * 360000.0
        returnDict['cm/s2'] = value * 100.0
        returnDict['ft/min2'] = value * 11811.02
        returnDict['ft/s2'] = value * 3.28
        returnDict['Gal'] = value * 100.0
        returnDict['in/h2'] = value * 510000000.0
        returnDict['in/min2'] = value * 141732.28
        returnDict['in/s2'] = value * 39.37
        returnDict['km/hr2'] = value * 12960.0
        returnDict['km/min2'] = value * 3.6
        returnDict['km/s2'] = value * 0.001
        returnDict['m/d2'] = value * 7460000000.0
        returnDict['m/h2'] = value * 13000000.0
        returnDict['m/min2'] = value * 3600.0
        returnDict['m/s2'] = value
        returnDict['mi/hr2'] = value * 8052.97
        returnDict['mi/min2'] = value * 2.24
        returnDict['mi/s2'] = value * 0.00062
        returnDict['mm/s2'] = value * 1000.0
        returnDict['knot/s'] = value * 1.9062602591792999
    elif units == 'mi/hr2':
        returnDict['g'] = value * 1.27e-05
        returnDict['cm/min2'] = value * 44.7
        returnDict['cm/s2'] = value * 0.01
        returnDict['ft/min2'] = value * 1.47
        returnDict['ft/s2'] = value * 0.000407
        returnDict['Gal'] = value * 0.01
        returnDict['in/h2'] = value * 63360.0
        returnDict['in/min2'] = value * 17.6
        returnDict['in/s2'] = value * 0.00489
        returnDict['km/hr2'] = value * 1.61
        returnDict['km/min2'] = value * 0.000447
        returnDict['km/s2'] = value * 1.24e-07
        returnDict['m/d2'] = value * 926982.14
        returnDict['m/h2'] = value * 1609.34
        returnDict['m/min2'] = value * 0.45
        returnDict['m/s2'] = value * 0.000124
        returnDict['mi/hr2'] = value
        returnDict['mi/min2'] = value * 0.000278
        returnDict['mi/s2'] = value * 7.72e-08
        returnDict['mm/s2'] = value * 0.12
        returnDict['knot/s'] = value * 0.00024209505291577108
    elif units == 'mi/min2':
        returnDict['g'] = value * 0.05
        returnDict['cm/min2'] = value * 160934.4
        returnDict['cm/s2'] = value * 44.7
        returnDict['ft/min2'] = value * 5280.0
        returnDict['ft/s2'] = value * 1.47
        returnDict['Gal'] = value * 44.7
        returnDict['in/h2'] = value * 228000000.0
        returnDict['in/min2'] = value * 63360.0
        returnDict['in/s2'] = value * 17.6
        returnDict['km/hr2'] = value * 5793.64
        returnDict['km/min2'] = value * 1.61
        returnDict['km/s2'] = value * 0.000447
        returnDict['m/d2'] = value * 3340000000.0
        returnDict['m/h2'] = value * 5793638.4
        returnDict['m/min2'] = value * 1609.34
        returnDict['m/s2'] = value * 0.45
        returnDict['mi/hr2'] = value * 3600.0
        returnDict['mi/min2'] = value
        returnDict['mi/s2'] = value * 0.000278
        returnDict['mm/s2'] = value * 447.04
        returnDict['knot/s'] = value * 0.9531301295896499
    elif units == 'mi/s2':
        returnDict['g'] = value * 164.11
        returnDict['cm/min2'] = value * 579000000.0
        returnDict['cm/s2'] = value * 160934.4
        returnDict['ft/min2'] = value * 19000000.0
        returnDict['ft/s2'] = value * 5280.0
        returnDict['Gal'] = value * 160934.4
        returnDict['in/h2'] = value * 821000000000.0
        returnDict['in/min2'] = value * 228000000.0
        returnDict['in/s2'] = value * 63360.0
        returnDict['km/hr2'] = value * 20900000.0
        returnDict['km/min2'] = value * 5793.64
        returnDict['km/s2'] = value * 1.61
        returnDict['m/d2'] = value * 12000000000000.0
        returnDict['m/h2'] = value * 20900000000.0
        returnDict['m/min2'] = value * 5793638.4
        returnDict['m/s2'] = value * 1609.34
        returnDict['mi/hr2'] = value * 13000000.0
        returnDict['mi/min2'] = value * 3600.0
        returnDict['mi/s2'] = value
        returnDict['mm/s2'] = value * 1609344.0
        returnDict['knot/s'] = value * 3128.363711339149
    elif units == 'mm/s2':
        returnDict['g'] = value * 0.000102
        returnDict['cm/min2'] = value * 360.0
        returnDict['cm/s2'] = value * 0.1
        returnDict['ft/min2'] = value * 11.81
        returnDict['ft/s2'] = value * 0.00328
        returnDict['Gal'] = value * 0.1
        returnDict['in/h2'] = value * 510236.22
        returnDict['in/min2'] = value * 141.73
        returnDict['in/s2'] = value * 0.04
        returnDict['km/hr2'] = value * 12.96
        returnDict['km/min2'] = value * 0.0036
        returnDict['km/s2'] = value * 1e-06
        returnDict['m/d2'] = value * 7464960.0
        returnDict['m/h2'] = value * 12960.0
        returnDict['m/min2'] = value * 3.6
        returnDict['m/s2'] = value * 0.001
        returnDict['mi/hr2'] = value * 8.05
        returnDict['mi/min2'] = value * 0.00224
        returnDict['mi/s2'] = value * 6.21e-07
        returnDict['mm/s2'] = value
        returnDict['knot/s'] = value * 0.001944385464362886
    elif units == 'knot/s':
        returnDict['g'] = value * 0.052458734067597
        returnDict['cm/min2'] = value * 185200.0
        returnDict['cm/s2'] = value * 51.44
        returnDict['ft/min2'] = value * 6076.12
        returnDict['ft/s2'] = value * 1.69
        returnDict['Gal'] = value * 51.44
        returnDict['in/h2'] = value * 262000000.0
        returnDict['in/min2'] = value * 72913.39
        returnDict['in/s2'] = value * 20.25
        returnDict['km/hr2'] = value * 6667.2
        returnDict['km/min2'] = value * 1.85
        returnDict['km/s2'] = value * 0.00051
        returnDict['m/d2'] = value * 3840000000.0
        returnDict['m/h2'] = value * 6667200.0
        returnDict['m/min2'] = value * 1852.0
        returnDict['m/s2'] = value * 0.51
        returnDict['mi/hr2'] = value * 4142.81
        returnDict['mi/min2'] = value * 1.15
        returnDict['mi/s2'] = value * 0.00032
        returnDict['mm/s2'] = value * 514.44
        returnDict['knot/s'] = value
    return returnDict


def angle(value, units):
    returnDict = {}
    if units == 'deg':
        returnDict['deg'] = value
        returnDict['gon'] = value * 1.11
        returnDict['mil'] = value * 17.78
        returnDict['mrad'] = value * 17.45
        returnDict['min'] = value * 60.0
        returnDict['quad'] = value * 0.01
        returnDict['rad'] = value * 0.0174533
        returnDict['r'] = value * 0.00278
        returnDict['sec'] = value * 3600.0
    elif units == 'gon':
        returnDict['deg'] = value * 0.9
        returnDict['gon'] = value
        returnDict['mil'] = value * 16.0
        returnDict['mrad'] = value * 15.71
        returnDict['min'] = value * 54.0
        returnDict['quad'] = value * 0.01
        returnDict['rad'] = value * 0.02
        returnDict['r'] = value * 0.0025
        returnDict['sec'] = value * 3240.0
    elif units == 'mil':
        returnDict['deg'] = value * 0.06
        returnDict['gon'] = value * 0.06
        returnDict['mil'] = value
        returnDict['mrad'] = value * 0.98
        returnDict['min'] = value * 3.38
        returnDict['quad'] = value * 0.00063
        returnDict['rad'] = value * 0.00098
        returnDict['r'] = value * 0.000156
        returnDict['sec'] = value * 202.5
    elif units == 'mrad':
        returnDict['deg'] = value * 0.06
        returnDict['gon'] = value * 0.06
        returnDict['mil'] = value * 1.02
        returnDict['mrad'] = value
        returnDict['min'] = value * 3.44
        returnDict['quad'] = value * 0.00064
        returnDict['rad'] = value * 0.001
        returnDict['r'] = value * 0.000159
        returnDict['sec'] = value * 206.26
    elif units == 'min':
        returnDict['deg'] = value * 0.02
        returnDict['gon'] = value * 0.02
        returnDict['mil'] = value * 0.3
        returnDict['mrad'] = value * 0.29
        returnDict['min'] = value
        returnDict['quad'] = value * 0.000185
        returnDict['rad'] = value * 0.000291
        returnDict['r'] = value * 4.63e-05
        returnDict['sec'] = value * 60.0
    elif units == 'quad':
        returnDict['deg'] = value * 90.0
        returnDict['gon'] = value * 100.0
        returnDict['mil'] = value * 1600.0
        returnDict['mrad'] = value * 1570.8
        returnDict['min'] = value * 5400.0
        returnDict['quad'] = value
        returnDict['rad'] = value * 1.57
        returnDict['r'] = value * 0.25
        returnDict['sec'] = value * 324000.0
    elif units == 'rad':
        returnDict['deg'] = value * 57.2958
        returnDict['gon'] = value * 63.66
        returnDict['mil'] = value * 1018.59
        returnDict['mrad'] = value * 1000.0
        returnDict['min'] = value * 3437.75
        returnDict['quad'] = value * 0.64
        returnDict['rad'] = value
        returnDict['r'] = value * 0.16
        returnDict['sec'] = value * 206264.81
    elif units == 'r':
        returnDict['deg'] = value * 360.0
        returnDict['gon'] = value * 400.0
        returnDict['mil'] = value * 6400.0
        returnDict['mrad'] = value * 6283.19
        returnDict['min'] = value * 21600.0
        returnDict['quad'] = value * 4.0
        returnDict['rad'] = value * 6.28
        returnDict['r'] = value
        returnDict['sec'] = value * 1296000.0
    elif units == 'sec':
        returnDict['deg'] = value * 0.000278
        returnDict['gon'] = value * 0.000309
        returnDict['mil'] = value * 0.00494
        returnDict['mrad'] = value * 0.00485
        returnDict['min'] = value * 0.02
        returnDict['quad'] = value * 3.09e-06
        returnDict['rad'] = value * 4.85e-06
        returnDict['r'] = value * 7.72e-07
        returnDict['sec'] = value
    return returnDict


def area(value, units):
    returnDict = {}
    if units == 'acre':
        returnDict['acre'] = value
        returnDict['ha'] = value * 0.4046856
        returnDict['cm2'] = value * 40468564.224
        returnDict['dm2'] = value * 404685.64224
        returnDict['ft2'] = value * 43560.0
        returnDict['in2'] = value * 6272640.0
        returnDict['km2'] = value * 0.0040469
        returnDict['m2'] = value * 4046.8564224
        returnDict['mi2'] = value * 0.0015625
        returnDict['mm2'] = value * 4046856422.4
        returnDict['yd2'] = value * 4840.0
    elif units == 'ha':
        returnDict['acre'] = value * 2.4710538
        returnDict['ha'] = value
        returnDict['cm2'] = value * 100000000.0
        returnDict['dm2'] = value * 1000000.0
        returnDict['ft2'] = value * 107639.1041671
        returnDict['in2'] = value * 15500031.000062
        returnDict['km2'] = value * 0.01
        returnDict['m2'] = value * 10000.0
        returnDict['mi2'] = value * 0.003861
        returnDict['mm2'] = value * 10000000000.0
        returnDict['yd2'] = value * 11959.900463
    elif units == 'cm2':
        returnDict['acre'] = value * 2.47e-08
        returnDict['ha'] = value * 1e-08
        returnDict['cm2'] = value
        returnDict['dm2'] = value * 0.01
        returnDict['ft2'] = value * 0.0010764
        returnDict['in2'] = value * 0.1550003
        returnDict['km2'] = value * 1e-10
        returnDict['m2'] = value * 0.0001
        returnDict['mi2'] = value * 3.86e-11
        returnDict['mm2'] = value * 99.96
        returnDict['yd2'] = value * 0.00012
    elif units == 'dm2':
        returnDict['acre'] = value * 2.47e-06
        returnDict['ha'] = value * 1e-06
        returnDict['cm2'] = value * 100.0
        returnDict['dm2'] = value
        returnDict['ft2'] = value * 0.11
        returnDict['in2'] = value * 15.5
        returnDict['km2'] = value * 1e-08
        returnDict['m2'] = value * 0.01
        returnDict['mi2'] = value * 3.86e-09
        returnDict['mm2'] = value * 10000.0
        returnDict['yd2'] = value * 0.01
    elif units == 'ft2':
        returnDict['acre'] = value * 2.3e-05
        returnDict['ha'] = value * 9.3e-06
        returnDict['cm2'] = value * 929.03
        returnDict['dm2'] = value * 9.290304
        returnDict['ft2'] = value
        returnDict['in2'] = value * 144.0
        returnDict['km2'] = value * 9.29e-08
        returnDict['m2'] = value * 0.09
        returnDict['mi2'] = value * 3.59e-08
        returnDict['mm2'] = value * 92903.04
        returnDict['yd2'] = value * 0.11
    elif units == 'in2':
        returnDict['acre'] = value * 1.59e-07
        returnDict['ha'] = value * 6.45e-08
        returnDict['cm2'] = value * 6.45
        returnDict['dm2'] = value * 0.064516
        returnDict['ft2'] = value * 0.01
        returnDict['in2'] = value
        returnDict['km2'] = value * 6.45e-10
        returnDict['m2'] = value * 0.00065
        returnDict['mi2'] = value * 2.49e-10
        returnDict['mm2'] = value * 645.16
        returnDict['yd2'] = value * 0.00077
    elif units == 'km2':
        returnDict['acre'] = value * 247.11
        returnDict['ha'] = value * 100.0
        returnDict['cm2'] = value * 10000000000.0
        returnDict['dm2'] = value * 100000000.0
        returnDict['ft2'] = value * 10800000.0
        returnDict['in2'] = value * 1550000000.0
        returnDict['km2'] = value
        returnDict['m2'] = value * 1000000.0
        returnDict['mi2'] = value * 0.39
        returnDict['mm2'] = value * 1000000000000.0
        returnDict['yd2'] = value * 1195990.05
    elif units == 'm2':
        returnDict['acre'] = value * 0.000247
        returnDict['ha'] = value * 0.0001
        returnDict['cm2'] = value * 10000.0
        returnDict['dm2'] = value * 100.0
        returnDict['ft2'] = value * 10.76
        returnDict['in2'] = value * 1550.0
        returnDict['km2'] = value * 1e-06
        returnDict['m2'] = value
        returnDict['mi2'] = value * 3.86e-07
        returnDict['mm2'] = value * 1000000.0
        returnDict['yd2'] = value * 1.2
    elif units == 'mi2':
        returnDict['acre'] = value * 640.0
        returnDict['ha'] = value * 259.0
        returnDict['cm2'] = value * 25900000000.0
        returnDict['dm2'] = value * 258998811.0336
        returnDict['ft2'] = value * 27900000.0
        returnDict['in2'] = value * 4010000000.0
        returnDict['km2'] = value * 2.59
        returnDict['m2'] = value * 2589988.11
        returnDict['mi2'] = value
        returnDict['mm2'] = value * 2590000000000.0
        returnDict['yd2'] = value * 3097600.0
    elif units == 'mm2':
        returnDict['acre'] = value * 2.47e-10
        returnDict['ha'] = value * 1e-10
        returnDict['cm2'] = value * 0.01
        returnDict['dm2'] = value * 0.0001
        returnDict['ft2'] = value * 1.08e-05
        returnDict['in2'] = value * 0.00155
        returnDict['km2'] = value * 1e-12
        returnDict['m2'] = value * 1e-06
        returnDict['mi2'] = value * 3.86e-13
        returnDict['mm2'] = value
        returnDict['yd2'] = value * 1.2e-06
    elif units == 'yd2':
        returnDict['acre'] = value * 0.000207
        returnDict['ha'] = value * 8.4e-05
        returnDict['cm2'] = value * 8361.27
        returnDict['dm2'] = value * 83.612736
        returnDict['ft2'] = value * 9.0
        returnDict['in2'] = value * 1296.0
        returnDict['km2'] = value * 8.36e-07
        returnDict['m2'] = value * 0.84
        returnDict['mi2'] = value * 3.23e-07
        returnDict['mm2'] = value * 836127.36
        returnDict['yd2'] = value
    return returnDict


def density(value, units):
    returnDict = {}
    if units == 'g/cm3':
        returnDict['g/cm3'] = value
        returnDict['g/L'] = value * 1000.0
        returnDict['kg/cm3'] = value * 0.001
        returnDict['kg/m3'] = value * 1000.0
        returnDict['kg/L'] = value
        returnDict['oz/ft3'] = value * 998.88
        returnDict['oz/in3'] = value * 0.5780556
        returnDict['lb/ft3'] = value * 62.43
        returnDict['lb/in3'] = value * 0.0361285
        returnDict['ppg'] = value * 8.3456767
        returnDict['slug/ft3'] = value * 1.9403837
        returnDict['slug/in3'] = value * 0.0011229
        returnDict['SG'] = value
    elif units == 'g/L':
        returnDict['g/cm3'] = value * 0.001
        returnDict['g/L'] = value
        returnDict['kg/cm3'] = value * 1e-06
        returnDict['kg/m3'] = value
        returnDict['kg/L'] = value * 0.001
        returnDict['oz/ft3'] = value
        returnDict['oz/in3'] = value * 0.0005787
        returnDict['lb/ft3'] = value * 0.062428
        returnDict['lb/in3'] = value * 3.61e-05
        returnDict['ppg'] = value * 0.0083454
        returnDict['slug/ft3'] = value * 0.0019403
        returnDict['slug/in3'] = value * 1.1e-06
        returnDict['SG'] = value * 0.001
    elif units == 'kg/cm3':
        returnDict['g/cm3'] = value * 1000.0
        returnDict['g/L'] = value * 1000000.0
        returnDict['kg/cm3'] = value
        returnDict['kg/m3'] = value * 1000000.0
        returnDict['kg/L'] = value * 1000.0
        returnDict['oz/ft3'] = value * 998876.32
        returnDict['oz/in3'] = value * 578.0534259
        returnDict['lb/ft3'] = value * 62429.77
        returnDict['lb/in3'] = value * 36.1283391
        returnDict['ppg'] = value * 8345.6459246
        returnDict['slug/ft3'] = value * 1940.3765197
        returnDict['slug/in3'] = value * 1.1229031
        returnDict['SG'] = value * 1000.0
    elif units == 'kg/m3':
        returnDict['g/cm3'] = value * 0.001
        returnDict['g/L'] = value * 1.000032
        returnDict['kg/cm3'] = value * 1e-06
        returnDict['kg/m3'] = value
        returnDict['kg/L'] = value * 0.001
        returnDict['oz/ft3'] = value * 0.99888
        returnDict['oz/in3'] = value * 0.0005781
        returnDict['lb/ft3'] = value * 0.06243
        returnDict['lb/in3'] = value * 3.61e-05
        returnDict['ppg'] = value * 0.0083457
        returnDict['slug/ft3'] = value * 0.0019404
        returnDict['slug/in3'] = value * 1.1e-06
        returnDict['SG'] = value * 0.001
    elif units == 'kg/L':
        returnDict['g/cm3'] = value
        returnDict['g/L'] = value * 1000.0
        returnDict['kg/cm3'] = value * 0.001
        returnDict['kg/m3'] = value * 1000.0
        returnDict['kg/L'] = value
        returnDict['oz/ft3'] = value * 998.88
        returnDict['oz/in3'] = value * 0.5780556
        returnDict['lb/ft3'] = value * 62.43
        returnDict['lb/in3'] = value * 0.0361285
        returnDict['ppg'] = value * 8.3456767
        returnDict['slug/ft3'] = value * 1.9403837
        returnDict['slug/in3'] = value * 0.0011229
        returnDict['SG'] = value * 1.0000037
    elif units == 'oz/ft3':
        returnDict['g/cm3'] = value * 0.001
        returnDict['g/L'] = value
        returnDict['kg/cm3'] = value * 1e-06
        returnDict['kg/m3'] = value
        returnDict['kg/L'] = value * 0.001
        returnDict['oz/ft3'] = value
        returnDict['oz/in3'] = value * 0.0005787
        returnDict['lb/ft3'] = value * 0.062428
        returnDict['lb/in3'] = value * 3.61e-05
        returnDict['ppg'] = value * 0.0083454
        returnDict['slug/ft3'] = value * 0.0019403
        returnDict['slug/in3'] = value * 1.1e-06
        returnDict['SG'] = value * 0.001
    elif units == 'oz/in3':
        returnDict['g/cm3'] = value * 1.7299375
        returnDict['g/L'] = value * 1729.9929519
        returnDict['kg/cm3'] = value * 0.0017299
        returnDict['kg/m3'] = value * 1729.93753
        returnDict['kg/L'] = value * 1.7299439
        returnDict['oz/ft3'] = value * 1728.0
        returnDict['oz/in3'] = value
        returnDict['lb/ft3'] = value * 108.0
        returnDict['lb/in3'] = value * 0.0625
        returnDict['ppg'] = value * 14.4374993
        returnDict['slug/ft3'] = value * 3.3567425
        returnDict['slug/in3'] = value * 0.0019426
        returnDict['SG'] = value * 1.7299439
    elif units == 'lb/ft3':
        returnDict['g/cm3'] = value * 0.0160179
        returnDict['g/L'] = value * 16.0184533
        returnDict['kg/cm3'] = value * 1.6e-05
        returnDict['kg/m3'] = value * 16.0179401
        returnDict['kg/L'] = value * 0.016018
        returnDict['oz/ft3'] = value * 16.0
        returnDict['oz/in3'] = value * 0.0092593
        returnDict['lb/ft3'] = value
        returnDict['lb/in3'] = value * 0.0005787
        returnDict['ppg'] = value * 0.1336805
        returnDict['slug/ft3'] = value * 0.0310809
        returnDict['slug/in3'] = value * 1.8e-05
        returnDict['SG'] = value * 0.016018
    elif units == 'lb/in3':
        returnDict['g/cm3'] = value * 27.6790005
        returnDict['g/L'] = value * 27679.8872301
        returnDict['kg/cm3'] = value * 0.0276791
        returnDict['kg/m3'] = value * 27679.0004805
        returnDict['kg/L'] = value * 27.6791025
        returnDict['oz/ft3'] = value * 27648.0
        returnDict['oz/in3'] = value * 16.0
        returnDict['lb/ft3'] = value * 1728.0
        returnDict['lb/in3'] = value
        returnDict['ppg'] = value * 230.9999886
        returnDict['slug/ft3'] = value * 53.7078805
        returnDict['slug/in3'] = value * 0.0310809
        returnDict['SG'] = value * 27.6791025
    elif units == 'ppg':
        returnDict['g/cm3'] = value * 0.1198225
        returnDict['g/L'] = value * 119.8263576
        returnDict['kg/cm3'] = value * 0.0001198
        returnDict['kg/m3'] = value * 119.8225188
        returnDict['kg/L'] = value * 0.119823
        returnDict['oz/ft3'] = value * 119.6883176
        returnDict['oz/in3'] = value * 0.0692641
        returnDict['lb/ft3'] = value * 7.4805199
        returnDict['lb/in3'] = value * 0.004329
        returnDict['ppg'] = value
        returnDict['slug/ft3'] = value * 0.2325017
        returnDict['slug/in3'] = value * 0.0001345
        returnDict['SG'] = value * 0.119823
    elif units == 'slug/ft3':
        returnDict['g/cm3'] = value * 0.515362
        returnDict['g/L'] = value * 515.3785064
        returnDict['kg/cm3'] = value * 0.0005154
        returnDict['kg/m3'] = value * 515.3619958
        returnDict['kg/L'] = value * 0.5153639
        returnDict['oz/ft3'] = value * 514.7847904
        returnDict['oz/in3'] = value * 0.2979079
        returnDict['lb/ft3'] = value * 32.1740494
        returnDict['lb/in3'] = value * 0.0186192
        returnDict['ppg'] = value * 4.3010446
        returnDict['slug/ft3'] = value
        returnDict['slug/in3'] = value * 0.0005787
        returnDict['SG'] = value * 0.5153639
    elif units == 'slug/in3':
        returnDict['g/cm3'] = value * 890.5455281
        returnDict['g/L'] = value * 890574.0583857
        returnDict['kg/cm3'] = value * 0.8905488
        returnDict['kg/m3'] = value * 890545.5280618
        returnDict['kg/L'] = value * 890.548809
        returnDict['oz/ft3'] = value * 889548.1170704
        returnDict['oz/in3'] = value * 514.78479
        returnDict['lb/ft3'] = value * 55596.7573169
        returnDict['lb/in3'] = value * 32.1740494
        returnDict['ppg'] = value * 7432.2050381
        returnDict['slug/ft3'] = value * 1727.9999986
        returnDict['slug/in3'] = value
        returnDict['SG'] = value * 890.548809
    elif units == 'SG':
        returnDict['g/cm3'] = value
        returnDict['g/L'] = value * 1000.0
        returnDict['kg/cm3'] = value * 0.001
        returnDict['kg/m3'] = value * 1000.0
        returnDict['kg/L'] = value
        returnDict['oz/ft3'] = value * 998.88
        returnDict['oz/in3'] = value * 0.5780556
        returnDict['lb/ft3'] = value * 62.43
        returnDict['lb/in3'] = value * 0.0361285
        returnDict['ppg'] = value * 8.3456767
        returnDict['slug/ft3'] = value * 1.9403837
        returnDict['slug/in3'] = value * 0.0011229
        returnDict['SG'] = value
    return returnDict


def distributed_force(value, units):
    returnDict = {}
    if units == 'daN/m':
        returnDict['daN/m'] = value
        returnDict['kg/m'] = value * 1.0195177
        returnDict['kN/cm'] = value * 0.0001
        returnDict['klb/in'] = value * 5.71e-05
        returnDict['N/m'] = value * 10.0
        returnDict['lbf/ft'] = value * 0.685068
    elif units == 'kg/m':
        returnDict['daN/m'] = value * 0.9808559
        returnDict['kg/m'] = value
        returnDict['kN/cm'] = value * 9.81e-05
        returnDict['klb/in'] = value * 5.6e-05
        returnDict['N/m'] = value * 9.8085305
        returnDict['lbf/ft'] = value * 0.671953
    elif units == 'kN/cm':
        returnDict['daN/m'] = value * 9999.9941612
        returnDict['kg/m'] = value * 10195.1713885
        returnDict['kN/cm'] = value
        returnDict['klb/in'] = value * 0.5708668
        returnDict['N/m'] = value * 99999.6496708
        returnDict['lbf/ft'] = value * 6850.676
    elif units == 'klb/in':
        returnDict['daN/m'] = value * 17517.2099704
        returnDict['kg/m'] = value * 17859.1062173
        returnDict['kN/cm'] = value * 1.751722
        returnDict['klb/in'] = value
        returnDict['N/m'] = value * 175171.5883048
        returnDict['lbf/ft'] = value * 12000.48
    elif units == 'N/m':
        returnDict['daN/m'] = value * 0.1000003
        returnDict['kg/m'] = value * 0.1019521
        returnDict['kN/cm'] = value * 1e-05
        returnDict['klb/in'] = value * 5.7e-06
        returnDict['N/m'] = value
        returnDict['lbf/ft'] = value * 0.068507
    elif units == 'lbf/ft':
        returnDict['daN/m'] = value * 1.4597091
        returnDict['kg/m'] = value * 1.4881993
        returnDict['kN/cm'] = value * 0.000146
        returnDict['klb/in'] = value * 8.33e-05
        returnDict['N/m'] = value * 14.5970485
        returnDict['lbf/ft'] = value
    return returnDict


def frequency(value, units):
    returnDict = {}
    if units == 'gHz':
        returnDict['gHz'] = value
        returnDict['Hz'] = value * 1000000000.0
        returnDict['kHz'] = value * 1000000.0
        returnDict['mHz'] = value * 1000.0
        returnDict['rad/hr'] = value * 22619473230167.6
        returnDict['rad/min'] = value * 376991220502.792
        returnDict['rad/sec'] = value * 6283187008.37988
        returnDict['rph'] = value * 3600000000000.0
        returnDict['rpm'] = value * 60000000000.0
        returnDict['rps'] = value * 1000000000.0
    elif units == 'Hz':
        returnDict['gHz'] = value * 1e-09
        returnDict['Hz'] = value
        returnDict['kHz'] = value * 0.001
        returnDict['mHz'] = value * 1e-06
        returnDict['rad/hr'] = value * 22619.4732302
        returnDict['rad/min'] = value * 376.9912205
        returnDict['rad/sec'] = value * 6.283187
        returnDict['rph'] = value * 3600.0
        returnDict['rpm'] = value * 60.0
        returnDict['rps'] = value
    elif units == 'kHz':
        returnDict['gHz'] = value * 1e-06
        returnDict['Hz'] = value * 1000.0
        returnDict['kHz'] = value
        returnDict['mHz'] = value * 0.001
        returnDict['rad/hr'] = value * 22619473.2301676
        returnDict['rad/min'] = value * 376991.2205028
        returnDict['rad/sec'] = value * 6283.1870084
        returnDict['rph'] = value * 3600000.0
        returnDict['rpm'] = value * 60000.0
        returnDict['rps'] = value * 1000.0
    elif units == 'mHz':
        returnDict['gHz'] = value * 0.001
        returnDict['Hz'] = value * 1000000.0
        returnDict['kHz'] = value * 1000.0
        returnDict['mHz'] = value
        returnDict['rad/hr'] = value * 22619473230.1676
        returnDict['rad/min'] = value * 376991220.502792
        returnDict['rad/sec'] = value * 6283187.0083799
        returnDict['rph'] = value * 3600000000.0
        returnDict['rpm'] = value * 60000000.0
        returnDict['rps'] = value * 1000000.0
    elif units == 'rad/hr':
        returnDict['gHz'] = value * 4.42e-14
        returnDict['Hz'] = value * 4.42e-05
        returnDict['kHz'] = value * 4.42e-08
        returnDict['mHz'] = value * 4.42e-11
        returnDict['rad/hr'] = value
        returnDict['rad/min'] = value * 0.0166667
        returnDict['rad/sec'] = value * 0.0002778
        returnDict['rph'] = value * 0.1591549
        returnDict['rpm'] = value * 0.0026526
        returnDict['rps'] = value * 4.42e-05
    elif units == 'rad/min':
        returnDict['gHz'] = value * 2.6526e-09
        returnDict['Hz'] = value * 0.0026526
        returnDict['kHz'] = value * 2.6526e-06
        returnDict['mHz'] = value * 2.6526e-12
        returnDict['rad/hr'] = value * 60.0
        returnDict['rad/min'] = value
        returnDict['rad/sec'] = value * 0.0166667
        returnDict['rph'] = value * 9.549294
        returnDict['rpm'] = value * 0.1591549
        returnDict['rps'] = value * 0.0026526
    elif units == 'rad/sec':
        returnDict['gHz'] = value * 1.591549e-10
        returnDict['Hz'] = value * 0.1591549
        returnDict['kHz'] = value * 0.0001591549
        returnDict['mHz'] = value * 1.591549e-07
        returnDict['rad/hr'] = value * 3600.0
        returnDict['rad/min'] = value * 60.0
        returnDict['rad/sec'] = value
        returnDict['rph'] = value * 572.95764
        returnDict['rpm'] = value * 9.549294
        returnDict['rps'] = value * 0.1591549
    elif units == 'rph':
        returnDict['gHz'] = value * 2.778e-13
        returnDict['Hz'] = value * 0.0002778
        returnDict['kHz'] = value * 2.778e-07
        returnDict['mHz'] = value * 2.778e-10
        returnDict['rad/hr'] = value * 6.283187
        returnDict['rad/min'] = value * 0.1047198
        returnDict['rad/sec'] = value * 0.0017453
        returnDict['rph'] = value
        returnDict['rpm'] = value * 0.0166667
        returnDict['rps'] = value * 0.0002778
    elif units == 'rpm':
        returnDict['gHz'] = value * 1.66667e-11
        returnDict['Hz'] = value * 0.0166667
        returnDict['kHz'] = value * 1.66667e-05
        returnDict['mHz'] = value * 1.66667e-08
        returnDict['rad/hr'] = value * 376.9912205
        returnDict['rad/min'] = value * 6.283187
        returnDict['rad/sec'] = value * 0.1047198
        returnDict['rph'] = value * 60.0
        returnDict['rpm'] = value
        returnDict['rps'] = value * 0.0166667
    elif units == 'rps':
        returnDict['gHz'] = value * 1e-09
        returnDict['Hz'] = value
        returnDict['kHz'] = value * 0.001
        returnDict['mHz'] = value * 1e-06
        returnDict['rad/hr'] = value * 22619.4732302
        returnDict['rad/min'] = value * 376.9912205
        returnDict['rad/sec'] = value * 6.283187
        returnDict['rph'] = value * 3600.0
        returnDict['rpm'] = value * 60.0
        returnDict['rps'] = value
    return returnDict


def length(value, units):
    returnDict = {}
    if units == 'cm':
        returnDict['cm'] = value
        returnDict['dm'] = value * 0.1
        returnDict['dam'] = value * 0.001
        returnDict['fath'] = value * 0.0054681
        returnDict['ft'] = value * 0.0328084
        returnDict['hm'] = value * 0.0001
        returnDict['in'] = value * 0.3937008
        returnDict['km'] = value * 1e-05
        returnDict['league'] = value * 2.1e-06
        returnDict['m'] = value * 0.01
        returnDict['mi'] = value * 6.2e-06
        returnDict['mm'] = value * 10.0
        returnDict['nleague'] = value * 1.8e-06
        returnDict['nm'] = value * 5.4e-06
        returnDict['yd'] = value * 0.0109361
    elif units == 'dm':
        returnDict['cm'] = value * 10.0
        returnDict['dm'] = value
        returnDict['dam'] = value * 0.01
        returnDict['fath'] = value * 0.054681
        returnDict['ft'] = value * 0.32808400000000004
        returnDict['hm'] = value * 0.001
        returnDict['in'] = value * 3.937008
        returnDict['km'] = value * 0.0001
        returnDict['league'] = value * 2.1e-05
        returnDict['m'] = value * 0.1
        returnDict['mi'] = value * 6.2e-05
        returnDict['mm'] = value * 100.0
        returnDict['nleague'] = value * 1.8e-05
        returnDict['nm'] = value * 5.4e-05
        returnDict['yd'] = value * 0.1093613
    elif units == 'dam':
        returnDict['cm'] = value * 1000.0
        returnDict['dm'] = value * 100.0
        returnDict['dam'] = value
        returnDict['fath'] = value * 5.4681
        returnDict['ft'] = value * 32.8084
        returnDict['hm'] = value * 0.1
        returnDict['in'] = value * 393.7008
        returnDict['km'] = value * 0.01
        returnDict['league'] = value * 0.0021
        returnDict['m'] = value * 10.0
        returnDict['mi'] = value * 0.0062
        returnDict['mm'] = value * 10000.0
        returnDict['nleague'] = value * 0.0018
        returnDict['nm'] = value * 0.0054
        returnDict['yd'] = value * 10.936100000000001
    elif units == 'fath':
        returnDict['cm'] = value * 182.88
        returnDict['dm'] = value * 18.288
        returnDict['dam'] = value * 0.18288
        returnDict['fath'] = value
        returnDict['ft'] = value * 6.0
        returnDict['hm'] = value * 0.018288
        returnDict['in'] = value * 72.0
        returnDict['km'] = value * 0.0018288
        returnDict['league'] = value * 0.0003788
        returnDict['m'] = value * 1.8288
        returnDict['mi'] = value * 0.0011364
        returnDict['mm'] = value * 1828.8
        returnDict['nleague'] = value * 0.0003292
        returnDict['nm'] = value * 0.0009875
        returnDict['yd'] = value * 2.0
    elif units == 'ft':
        returnDict['cm'] = value * 30.48
        returnDict['dm'] = value * 3.048
        returnDict['dam'] = value * 0.03048
        returnDict['fath'] = value * 0.1666667
        returnDict['ft'] = value
        returnDict['hm'] = value * 0.003048
        returnDict['in'] = value * 12.0
        returnDict['km'] = value * 0.0003048
        returnDict['league'] = value * 6.31e-05
        returnDict['m'] = value * 0.3048
        returnDict['mi'] = value * 0.0001894
        returnDict['mm'] = value * 304.8
        returnDict['nleague'] = value * 5.49e-05
        returnDict['nm'] = value * 0.0001646
        returnDict['yd'] = value * 0.3333333
    elif units == 'hm':
        returnDict['cm'] = value * 10000.0
        returnDict['dm'] = value * 1000.0
        returnDict['dam'] = value * 10.0
        returnDict['fath'] = value * 54.6806649
        returnDict['ft'] = value * 328.0839895
        returnDict['hm'] = value
        returnDict['in'] = value * 3937.007874
        returnDict['km'] = value * 0.1
        returnDict['league'] = value * 0.0207123
        returnDict['m'] = value * 100.0
        returnDict['mi'] = value * 0.0621371
        returnDict['mm'] = value * 100000.0
        returnDict['nleague'] = value * 0.0179986
        returnDict['nm'] = value * 0.0539957
        returnDict['yd'] = value * 109.3613298
    elif units == 'in':
        returnDict['cm'] = value * 2.54
        returnDict['dm'] = value * 0.254
        returnDict['dam'] = value * 0.00254
        returnDict['fath'] = value * 0.0138889
        returnDict['ft'] = value * 0.0833333
        returnDict['hm'] = value * 0.000254
        returnDict['in'] = value
        returnDict['km'] = value * 2.54e-05
        returnDict['league'] = value * 5.3e-06
        returnDict['m'] = value * 0.0254
        returnDict['mi'] = value * 1.58e-05
        returnDict['mm'] = value * 25.4
        returnDict['nleague'] = value * 4.6e-06
        returnDict['nm'] = value * 1.37e-05
        returnDict['yd'] = value * 0.0277778
    elif units == 'km':
        returnDict['cm'] = value * 100000.0
        returnDict['dm'] = value * 10000.0
        returnDict['dam'] = value * 100.0
        returnDict['fath'] = value * 546.8066492
        returnDict['ft'] = value * 3280.839895
        returnDict['hm'] = value * 10.0
        returnDict['in'] = value * 39370.0787402
        returnDict['km'] = value
        returnDict['league'] = value * 0.2071233
        returnDict['m'] = value * 1000.0
        returnDict['mi'] = value * 0.6213712
        returnDict['mm'] = value * 1000000.0
        returnDict['nleague'] = value * 0.1799856
        returnDict['nm'] = value * 0.5399568
        returnDict['yd'] = value * 1093.6132983
    elif units == 'league':
        returnDict['cm'] = value * 482804.17
        returnDict['dm'] = value * 48280.417
        returnDict['dam'] = value * 482.80417
        returnDict['fath'] = value * 2640.005304
        returnDict['ft'] = value * 15840.0318241
        returnDict['hm'] = value * 48.280417
        returnDict['in'] = value * 190080.3818898
        returnDict['km'] = value * 4.8280417
        returnDict['league'] = value
        returnDict['m'] = value * 4828.0417
        returnDict['mi'] = value * 3.000006
        returnDict['mm'] = value * 4828041.7
        returnDict['nleague'] = value * 0.868978
        returnDict['nm'] = value * 2.606934
        returnDict['yd'] = value * 5280.010608
    elif units == 'm':
        returnDict['cm'] = value * 100.0
        returnDict['dm'] = value * 10.0
        returnDict['dam'] = value * 0.1
        returnDict['fath'] = value * 0.5468066
        returnDict['ft'] = value * 3.2808399
        returnDict['hm'] = value * 0.01
        returnDict['in'] = value * 39.3700787
        returnDict['km'] = value * 0.001
        returnDict['league'] = value * 0.0002071
        returnDict['m'] = value
        returnDict['mi'] = value * 0.0006214
        returnDict['mm'] = value * 1000.0
        returnDict['nleague'] = value * 0.00018
        returnDict['nm'] = value * 0.00054
        returnDict['yd'] = value * 1.0936133
    elif units == 'mi':
        returnDict['cm'] = value * 160934.4
        returnDict['dm'] = value * 16093.44
        returnDict['dam'] = value * 160.9344
        returnDict['fath'] = value * 880.0
        returnDict['ft'] = value * 5280.0
        returnDict['hm'] = value * 16.09344
        returnDict['in'] = value * 63360.0
        returnDict['km'] = value * 1.609344
        returnDict['league'] = value * 0.3333327
        returnDict['m'] = value * 1609.344
        returnDict['mi'] = value
        returnDict['mm'] = value * 1609344.0
        returnDict['nleague'] = value * 0.2896587
        returnDict['nm'] = value * 0.8689762
        returnDict['yd'] = value * 1760.0
    elif units == 'mm':
        returnDict['cm'] = value * 0.1
        returnDict['dm'] = value * 0.01
        returnDict['dam'] = value * 0.0001
        returnDict['fath'] = value * 0.0005468
        returnDict['ft'] = value * 0.0032808
        returnDict['hm'] = value * 1e-05
        returnDict['in'] = value * 0.0393701
        returnDict['km'] = value * 1e-06
        returnDict['league'] = value * 2.071237307e-07
        returnDict['m'] = value * 0.001
        returnDict['mi'] = value * 6.21371e-07
        returnDict['mm'] = value
        returnDict['nleague'] = value * 1.79986e-07
        returnDict['nm'] = value * 5.39957e-07
        returnDict['yd'] = value * 0.0010936
    elif units == 'nleague':
        returnDict['cm'] = value * 555600.0
        returnDict['dm'] = value * 55560.0
        returnDict['dam'] = value * 555.6
        returnDict['fath'] = value * 3038.0577428
        returnDict['ft'] = value * 18228.3464567
        returnDict['hm'] = value * 55.56
        returnDict['in'] = value * 218740.1574803
        returnDict['km'] = value * 5.556
        returnDict['league'] = value * 1.1507771
        returnDict['m'] = value * 5556.0
        returnDict['mi'] = value * 3.4523383
        returnDict['mm'] = value * 5556000.0
        returnDict['nleague'] = value
        returnDict['nm'] = value * 3.0
        returnDict['yd'] = value * 6076.1154856
    elif units == 'nm':
        returnDict['cm'] = value * 185200.0
        returnDict['dm'] = value * 18520.0
        returnDict['dam'] = value * 185.2
        returnDict['fath'] = value * 1012.6859143
        returnDict['ft'] = value * 6076.1154856
        returnDict['hm'] = value * 18.52
        returnDict['in'] = value * 72913.3858268
        returnDict['km'] = value * 1.852
        returnDict['league'] = value * 0.3835924
        returnDict['m'] = value * 1852.0
        returnDict['mi'] = value * 1.1507794
        returnDict['mm'] = value * 1852000.0
        returnDict['nleague'] = value * 0.3333333
        returnDict['nm'] = value
        returnDict['yd'] = value * 2025.3718285
    elif units == 'yd':
        returnDict['cm'] = value * 91.44
        returnDict['dm'] = value * 9.144
        returnDict['dam'] = value * 0.09144
        returnDict['fath'] = value * 0.5
        returnDict['ft'] = value * 3.0
        returnDict['hm'] = value * 0.009144
        returnDict['in'] = value * 36.0
        returnDict['km'] = value * 0.0009144
        returnDict['league'] = value * 0.0001894
        returnDict['m'] = value * 0.9144
        returnDict['mi'] = value * 0.0005682
        returnDict['mm'] = value * 914.4
        returnDict['nleague'] = value * 0.0001646
        returnDict['nm'] = value * 0.0004937
        returnDict['yd'] = value
    return returnDict


def pressure(value, units):
    returnDict = {}
    if units == 'atm':
        returnDict['atm'] = value
        returnDict['bar'] = value * 1.01325
        returnDict['cm_Hg'] = value * 76.0
        returnDict['cm_h2o'] = value * 1033.2274528
        returnDict['dyne/cm2'] = value * 1013250.0
        returnDict['ft_air'] = value * 26222.2234644
        returnDict['ft_hg'] = value * 2.4934379
        returnDict['ft_h2o'] = value * 33.8985387
        returnDict['in_air'] = value * 314666.6815732
        returnDict['in_hg'] = value * 29.9212553
        returnDict['in_h2o'] = value * 406.7824645
        returnDict['kg/cm2'] = value * 1.0332275
        returnDict['kg/m2'] = value * 10332.274528
        returnDict['kPa'] = value * 101.325
        returnDict['Mpa'] = value * 0.101325
        returnDict['m_Hg'] = value * 0.76
        returnDict['m_h2o'] = value * 10.3322745
        returnDict['mbar'] = value * 1013.25
        returnDict['N/cm2'] = value * 10.1325
        returnDict['N/m2'] = value * 101325.0
        returnDict['N/mm2'] = value * 0.101325
        returnDict['Pa'] = value * 101325.0
        returnDict['psf'] = value * 2116.2166237
        returnDict['psi'] = value * 14.6959488
        returnDict['torr'] = value * 760.0
    elif units == 'bar':
        returnDict['atm'] = value * 0.9869232667160128
        returnDict['bar'] = value
        returnDict['cm_Hg'] = value * 75.0061683
        returnDict['cm_h2o'] = value * 1019.716213
        returnDict['dyne/cm2'] = value * 1000000.0
        returnDict['ft_air'] = value * 25879.3224421
        returnDict['ft_hg'] = value * 2.4608319
        returnDict['ft_h2o'] = value * 33.4552566
        returnDict['in_air'] = value * 310551.8693049
        returnDict['in_hg'] = value * 29.5299831
        returnDict['in_h2o'] = value * 401.4630787
        returnDict['kg/cm2'] = value * 1.0197162
        returnDict['kg/m2'] = value * 10197.1621298
        returnDict['kPa'] = value * 100.0
        returnDict['Mpa'] = value * 0.1
        returnDict['m_Hg'] = value * 0.7500617
        returnDict['m_h2o'] = value * 10.1971621
        returnDict['mbar'] = value * 1000.0
        returnDict['N/cm2'] = value * 10.0
        returnDict['N/m2'] = value * 100000.0
        returnDict['N/mm2'] = value * 0.1
        returnDict['Pa'] = value * 100000.0
        returnDict['psf'] = value * 2088.5434233
        returnDict['psi'] = value * 14.5037738
        returnDict['torr'] = value * 750.0616827
    elif units == 'cm_Hg':
        returnDict['atm'] = value * 0.013157894736842105
        returnDict['bar'] = value * 0.013332236836846924
        returnDict['cm_Hg'] = value
        returnDict['cm_h2o'] = value * 13.5950981
        returnDict['dyne/cm2'] = value * 13332.236842
        returnDict['ft_air'] = value * 345.0292561
        returnDict['ft_hg'] = value * 0.0328084
        returnDict['ft_h2o'] = value * 0.4460334
        returnDict['in_air'] = value * 4140.3510733
        returnDict['in_hg'] = value * 0.3937007
        returnDict['in_h2o'] = value * 5.3524008
        returnDict['kg/cm2'] = value * 0.0135951
        returnDict['kg/m2'] = value * 135.9509806
        returnDict['kPa'] = value * 1.3332237
        returnDict['Mpa'] = value * 0.0013332
        returnDict['m_Hg'] = value * 0.01
        returnDict['m_h2o'] = value * 0.135951
        returnDict['mbar'] = value * 13.3322368
        returnDict['N/cm2'] = value * 0.1333224
        returnDict['N/m2'] = value * 1333.2236842
        returnDict['N/mm2'] = value * 0.0013332
        returnDict['Pa'] = value * 1333.2236842
        returnDict['psf'] = value * 27.8449556
        returnDict['psi'] = value * 0.1933677
        returnDict['torr'] = value * 10.0
    elif units == 'cm_h2o':
        returnDict['atm'] = value * 0.0009678411053539517
        returnDict['bar'] = value * 0.0009806649999787734
        returnDict['cm_Hg'] = value * 0.07355592380756708
        returnDict['cm_h2o'] = value
        returnDict['dyne/cm2'] = value * 980.665
        returnDict['ft_air'] = value * 25.3789457
        returnDict['ft_hg'] = value * 0.0024133
        returnDict['ft_h2o'] = value * 0.0328084
        returnDict['in_air'] = value * 304.5473489
        returnDict['in_hg'] = value * 0.028959
        returnDict['in_h2o'] = value * 0.3937008
        returnDict['kg/cm2'] = value * 0.001
        returnDict['kg/m2'] = value * 10.0
        returnDict['kPa'] = value * 0.0980665
        returnDict['Mpa'] = value * 9.81e-05
        returnDict['m_Hg'] = value * 0.0007356
        returnDict['m_h2o'] = value * 0.01
        returnDict['mbar'] = value * 0.980665
        returnDict['N/cm2'] = value * 0.0098067
        returnDict['N/m2'] = value * 98.0665
        returnDict['N/mm2'] = value * 9.81e-05
        returnDict['Pa'] = value * 98.0665
        returnDict['psf'] = value * 2.0481614
        returnDict['psi'] = value * 0.0142233
        returnDict['torr'] = value * 0.7355592
    elif units == 'dyne/cm2':
        returnDict['atm'] = value * 9.869232667160128e-07
        returnDict['bar'] = value * 1e-06
        returnDict['cm_Hg'] = value * 7.500616827100918e-05
        returnDict['cm_h2o'] = value * 0.0010197162129779282
        returnDict['dyne/cm2'] = value
        returnDict['ft_air'] = value * 0.0258793
        returnDict['ft_hg'] = value * 2.5e-06
        returnDict['ft_h2o'] = value * 3.35e-05
        returnDict['in_air'] = value * 0.3105519
        returnDict['in_hg'] = value * 2.95e-05
        returnDict['in_h2o'] = value * 0.0004015
        returnDict['kg/cm2'] = value * 1e-06
        returnDict['kg/m2'] = value * 0.0101972
        returnDict['kPa'] = value * 0.0001
        returnDict['Mpa'] = value * 1e-07
        returnDict['m_Hg'] = value * 7.500616827e-07
        returnDict['m_h2o'] = value * 1.0197162129799999e-05
        returnDict['mbar'] = value * 0.001
        returnDict['N/cm2'] = value * 1e-05
        returnDict['N/m2'] = value * 0.1
        returnDict['N/mm2'] = value * 1e-07
        returnDict['Pa'] = value * 0.1
        returnDict['psf'] = value * 0.0020885
        returnDict['psi'] = value * 1.45e-05
        returnDict['torr'] = value * 0.0007501
    elif units == 'ft_air':
        returnDict['atm'] = value * 3.8135591413810774e-05
        returnDict['bar'] = value * 3.8640887999958555e-05
        returnDict['cm_Hg'] = value * 0.0028983049475380415
        returnDict['cm_h2o'] = value * 0.03940274004368905
        returnDict['dyne/cm2'] = value * 38.64092150869614
        returnDict['ft_air'] = value
        returnDict['ft_hg'] = value * 9.51e-05
        returnDict['ft_h2o'] = value * 0.0012927
        returnDict['in_air'] = value * 12.0
        returnDict['in_hg'] = value * 0.0011411
        returnDict['in_h2o'] = value * 0.0155129
        returnDict['kg/cm2'] = value * 3.94e-05
        returnDict['kg/m2'] = value * 0.3940274
        returnDict['kPa'] = value * 0.0038641
        returnDict['Mpa'] = value * 3.9e-06
        returnDict['m_Hg'] = value * 2.9e-05
        returnDict['m_h2o'] = value * 0.000394
        returnDict['mbar'] = value * 0.0386409
        returnDict['N/cm2'] = value * 0.0003864
        returnDict['N/m2'] = value * 3.8640888
        returnDict['N/mm2'] = value * 3.9e-06
        returnDict['Pa'] = value * 3.8640888
        returnDict['psf'] = value * 0.0807032
        returnDict['psi'] = value * 0.0005604
        returnDict['torr'] = value * 0.028983
    elif units == 'ft_hg':
        returnDict['atm'] = value * 0.4010526991668812
        returnDict['bar'] = value * 0.40636664373539694
        returnDict['cm_Hg'] = value * 30.47999902464003
        returnDict['cm_h2o'] = value * 414.3703642315501
        returnDict['dyne/cm2'] = value * 399999.99999999994
        returnDict['ft_air'] = value * 10515.247108307045
        returnDict['ft_hg'] = value
        returnDict['ft_h2o'] = value * 13.5951002
        returnDict['in_air'] = value * 126197.9196751
        returnDict['in_hg'] = value * 12.0
        returnDict['in_h2o'] = value * 163.1412024
        returnDict['kg/cm2'] = value * 0.4143787
        returnDict['kg/m2'] = value * 4143.7865122
        returnDict['kPa'] = value * 40.636664
        returnDict['Mpa'] = value * 0.0406367
        returnDict['m_Hg'] = value * 0.3048
        returnDict['m_h2o'] = value * 4.1437865
        returnDict['mbar'] = value * 406.36664
        returnDict['N/cm2'] = value * 4.0636664
        returnDict['N/m2'] = value * 40636.664
        returnDict['N/mm2'] = value * 0.0406367
        returnDict['Pa'] = value * 40636.664
        returnDict['psf'] = value * 848.7143734
        returnDict['psi'] = value * 5.8938498
        returnDict['torr'] = value * 304.8000458
    elif units == 'ft_h2o':
        returnDict['atm'] = value * 0.029499796697726087
        returnDict['bar'] = value * 0.029890668959926616
        returnDict['cm_Hg'] = value * 2.241984568868609
        returnDict['cm_h2o'] = value * 30.47999902464003
        returnDict['dyne/cm2'] = value * 29850.746268656716
        returnDict['ft_air'] = value * 773.5746886361878
        returnDict['ft_hg'] = value * 0.07355591244557359
        returnDict['ft_h2o'] = value
        returnDict['in_air'] = value * 9282.6031327
        returnDict['in_hg'] = value * 0.8826709
        returnDict['in_h2o'] = value * 12.0
        returnDict['kg/cm2'] = value * 0.03048
        returnDict['kg/m2'] = value * 304.799998
        returnDict['kPa'] = value * 2.9890669
        returnDict['Mpa'] = value * 0.0029891
        returnDict['m_Hg'] = value * 0.0224198
        returnDict['m_h2o'] = value * 0.3048
        returnDict['mbar'] = value * 29.890669
        returnDict['N/cm2'] = value * 0.2989067
        returnDict['N/m2'] = value * 2989.0669
        returnDict['N/mm2'] = value * 0.0029891
        returnDict['Pa'] = value * 2989.0669
        returnDict['psf'] = value * 62.4279602
        returnDict['psi'] = value * 0.4335275
        returnDict['torr'] = value * 22.4198455
    elif units == 'in_air':
        returnDict['atm'] = value * 3.177965951146858e-06
        returnDict['bar'] = value * 3.220073999999657e-06
        returnDict['cm_Hg'] = value * 0.00024152541228900331
        returnDict['cm_h2o'] = value * 0.0032835616649165324
        returnDict['dyne/cm2'] = value * 3.220073681725985
        returnDict['ft_air'] = value * 0.08333333333333333
        returnDict['ft_hg'] = value * 7.924060892402405e-06
        returnDict['ft_h2o'] = value * 0.00010772840179682801
        returnDict['in_air'] = value
        returnDict['in_hg'] = value * 9.51e-05
        returnDict['in_h2o'] = value * 0.0012927
        returnDict['kg/cm2'] = value * 3.3e-06
        returnDict['kg/m2'] = value * 0.0328356
        returnDict['kPa'] = value * 0.000322
        returnDict['Mpa'] = value * 3.2201e-07
        returnDict['m_Hg'] = value * 2.4e-06
        returnDict['m_h2o'] = value * 3.28e-05
        returnDict['mbar'] = value * 0.0032201
        returnDict['N/cm2'] = value * 3.22e-05
        returnDict['N/m2'] = value * 0.3220074
        returnDict['N/mm2'] = value * 3.2201e-07
        returnDict['Pa'] = value * 0.3220074
        returnDict['psf'] = value * 0.0067253
        returnDict['psi'] = value * 4.67e-05
        returnDict['torr'] = value * 0.0024153
    elif units == 'in_hg':
        returnDict['atm'] = value * 0.03342105770542321
        returnDict['bar'] = value * 0.0338638866339209
        returnDict['cm_Hg'] = value * 2.5400005638801253
        returnDict['cm_h2o'] = value * 34.531579129113574
        returnDict['dyne/cm2'] = value * 33898.30508474576
        returnDict['ft_air'] = value * 876.3473841030585
        returnDict['ft_hg'] = value * 0.08333333333333333
        returnDict['ft_h2o'] = value * 1.132925080004337
        returnDict['in_air'] = value * 10515.247108307045
        returnDict['in_hg'] = value
        returnDict['in_h2o'] = value * 13.5951002
        returnDict['kg/cm2'] = value * 0.0345316
        returnDict['kg/m2'] = value * 345.3155427
        returnDict['kPa'] = value * 3.3863887
        returnDict['Mpa'] = value * 0.0033864
        returnDict['m_Hg'] = value * 0.0254
        returnDict['m_h2o'] = value * 0.3453155
        returnDict['mbar'] = value * 33.8638867
        returnDict['N/cm2'] = value * 0.3386389
        returnDict['N/m2'] = value * 3386.3886667
        returnDict['N/mm2'] = value * 0.0033864
        returnDict['Pa'] = value * 3386.3886667
        returnDict['psf'] = value * 70.7261978
        returnDict['psi'] = value * 0.4911542
        returnDict['torr'] = value * 25.4000038
    elif units == 'in_h2o':
        returnDict['atm'] = value * 0.0024583163908728422
        returnDict['bar'] = value * 0.002490889083096149
        returnDict['cm_Hg'] = value * 0.18683204740571746
        returnDict['cm_h2o'] = value * 2.5399999187200026
        returnDict['dyne/cm2'] = value * 2490.6600249066
        returnDict['ft_air'] = value * 64.46247961374083
        returnDict['ft_hg'] = value * 0.0061296593704644655
        returnDict['ft_h2o'] = value * 0.08333333333333333
        returnDict['in_air'] = value * 773.5746886361878
        returnDict['in_hg'] = value * 0.07355591244557359
        returnDict['in_h2o'] = value
        returnDict['kg/cm2'] = value * 0.00254
        returnDict['kg/m2'] = value * 25.3999998
        returnDict['kPa'] = value * 0.2490889
        returnDict['Mpa'] = value * 0.0002491
        returnDict['m_Hg'] = value * 0.0018683
        returnDict['m_h2o'] = value * 0.0254
        returnDict['mbar'] = value * 2.4908891
        returnDict['N/cm2'] = value * 0.0249089
        returnDict['N/m2'] = value * 249.0889083
        returnDict['N/mm2'] = value * 0.0002491
        returnDict['Pa'] = value * 249.0889083
        returnDict['psf'] = value * 5.20233
        returnDict['psi'] = value * 0.0361273
        returnDict['torr'] = value * 1.8683205
    elif units == 'kg/cm2':
        returnDict['atm'] = value * 0.9678410611409395
        returnDict['bar'] = value * 0.9806650124809236
        returnDict['cm_Hg'] = value * 73.55591352766805
        returnDict['cm_h2o'] = value * 1000.0
        returnDict['dyne/cm2'] = value * 1000000.0
        returnDict['ft_air'] = value * 25380.710659898476
        returnDict['ft_hg'] = value * 2.4132514533203566
        returnDict['ft_h2o'] = value * 32.808398950131235
        returnDict['in_air'] = value * 303030.30303030304
        returnDict['in_hg'] = value * 28.958982497190977
        returnDict['in_h2o'] = value * 393.70078740157476
        returnDict['kg/cm2'] = value
        returnDict['kg/m2'] = value * 10000.0
        returnDict['kPa'] = value * 98.0665
        returnDict['Mpa'] = value * 0.0980665
        returnDict['m_Hg'] = value * 0.7355592
        returnDict['m_h2o'] = value * 10.0
        returnDict['mbar'] = value * 980.665
        returnDict['N/cm2'] = value * 9.80665
        returnDict['N/m2'] = value * 98066.5
        returnDict['N/mm2'] = value * 0.0980665
        returnDict['Pa'] = value * 98066.5
        returnDict['psf'] = value * 2048.1614362
        returnDict['psi'] = value * 14.2233433
        returnDict['torr'] = value * 735.5592401
    elif units == 'kg/m2':
        returnDict['atm'] = value * 9.678411053539517e-05
        returnDict['bar'] = value * 9.806649999980076e-05
        returnDict['cm_Hg'] = value * 0.007355592402398603
        returnDict['cm_h2o'] = value * 0.1
        returnDict['dyne/cm2'] = value * 98.06613580198486
        returnDict['ft_air'] = value * 2.5378945728139715
        returnDict['ft_hg'] = value * 0.00024132517374045038
        returnDict['ft_h2o'] = value * 0.003280839916540944
        returnDict['in_air'] = value * 30.454750331956777
        returnDict['in_hg'] = value * 0.0028959020847456342
        returnDict['in_h2o'] = value * 0.0393700790501581
        returnDict['kg/cm2'] = value * 0.0001
        returnDict['kg/m2'] = value
        returnDict['kPa'] = value * 0.0098067
        returnDict['Mpa'] = value * 9.8e-06
        returnDict['m_Hg'] = value * 7.36e-05
        returnDict['m_h2o'] = value * 0.001
        returnDict['mbar'] = value * 0.0980665
        returnDict['N/cm2'] = value * 0.0009807
        returnDict['N/m2'] = value * 9.80665
        returnDict['N/mm2'] = value * 9.8e-06
        returnDict['Pa'] = value * 9.80665
        returnDict['psf'] = value * 0.2048161
        returnDict['psi'] = value * 0.0014223
        returnDict['torr'] = value * 0.0735559
    elif units == 'kPa':
        returnDict['atm'] = value * 0.009869232667160128
        returnDict['bar'] = value * 0.01
        returnDict['cm_Hg'] = value * 0.75006167382113
        returnDict['cm_h2o'] = value * 10.197162129779283
        returnDict['dyne/cm2'] = value * 10000.0
        returnDict['ft_air'] = value * 258.7924743148469
        returnDict['ft_hg'] = value * 0.024608319226204198
        returnDict['ft_h2o'] = value * 0.33455256555147694
        returnDict['in_air'] = value * 3105.590062111801
        returnDict['in_hg'] = value * 0.2952998278077174
        returnDict['in_h2o'] = value * 4.014630920928231
        returnDict['kg/cm2'] = value * 0.010197162129779282
        returnDict['kg/m2'] = value * 101.97110138986612
        returnDict['kPa'] = value
        returnDict['Mpa'] = value * 0.001
        returnDict['m_Hg'] = value * 0.0075006
        returnDict['m_h2o'] = value * 0.1019716
        returnDict['mbar'] = value * 10.0
        returnDict['N/cm2'] = value * 0.1
        returnDict['N/m2'] = value * 1000.0
        returnDict['N/mm2'] = value * 0.001
        returnDict['Pa'] = value * 1000.0
        returnDict['psf'] = value * 20.8854342
        returnDict['psi'] = value * 0.1450377
        returnDict['torr'] = value * 7.5006168
    elif units == 'Mpa':
        returnDict['atm'] = value * 9.869232667160128
        returnDict['bar'] = value * 10.0
        returnDict['cm_Hg'] = value * 750.0750075007501
        returnDict['cm_h2o'] = value * 10193.67991845056
        returnDict['dyne/cm2'] = value * 10000000.0
        returnDict['ft_air'] = value * 256410.2564102564
        returnDict['ft_hg'] = value * 24.608297425726008
        returnDict['ft_h2o'] = value * 334.54886086112873
        returnDict['in_air'] = value * 3105493.6182106147
        returnDict['in_hg'] = value * 295.2988424285377
        returnDict['in_h2o'] = value * 4014.452027298274
        returnDict['kg/cm2'] = value * 10.197162129779283
        returnDict['kg/m2'] = value * 102040.81632653062
        returnDict['kPa'] = value * 1000.0
        returnDict['Mpa'] = value
        returnDict['m_Hg'] = value * 7.5006168
        returnDict['m_h2o'] = value * 101.9716213
        returnDict['mbar'] = value * 10000.0
        returnDict['N/cm2'] = value * 100.0
        returnDict['N/m2'] = value * 1000000.0
        returnDict['N/mm2'] = value
        returnDict['Pa'] = value * 1000000.0
        returnDict['psf'] = value * 20885.4342333
        returnDict['psi'] = value * 145.0377377
        returnDict['torr'] = value * 7500.6168271
    elif units == 'm_Hg':
        returnDict['atm'] = value * 1.3157894736842106
        returnDict['bar'] = value * 1.3332236534674413
        returnDict['cm_Hg'] = value * 100.0
        returnDict['cm_h2o'] = value * 1359.4344752582927
        returnDict['dyne/cm2'] = value * 1333223.684217938
        returnDict['ft_air'] = value * 34482.75862068965
        returnDict['ft_hg'] = value * 3.280839895013123
        returnDict['ft_h2o'] = value * 44.60343089590451
        returnDict['in_air'] = value * 416666.6666666667
        returnDict['in_hg'] = value * 39.37007874015748
        returnDict['in_h2o'] = value * 535.2459455119628
        returnDict['kg/cm2'] = value * 1.3595098803740067
        returnDict['kg/m2'] = value * 13586.95652173913
        returnDict['kPa'] = value * 133.32266751993174
        returnDict['Mpa'] = value * 0.13332236890171484
        returnDict['m_Hg'] = value
        returnDict['m_h2o'] = value * 13.5950981
        returnDict['mbar'] = value * 1333.2236842
        returnDict['N/cm2'] = value * 13.3322368
        returnDict['N/m2'] = value * 133322.36842
        returnDict['N/mm2'] = value * 0.1333224
        returnDict['Pa'] = value * 133322.36842
        returnDict['psf'] = value * 2784.4955575
        returnDict['psi'] = value * 19.3367747
        returnDict['torr'] = value * 1000.0
    elif units == 'm_h2o':
        returnDict['atm'] = value * 0.09678411079767577
        returnDict['bar'] = value * 0.09806650028638851
        returnDict['cm_Hg'] = value * 7.355591352766806
        returnDict['cm_h2o'] = value * 100.0
        returnDict['dyne/cm2'] = value * 98066.49999980077
        returnDict['ft_air'] = value * 2538.0710659898477
        returnDict['ft_hg'] = value * 0.24132517445095206
        returnDict['ft_h2o'] = value * 3.280839895013123
        returnDict['in_air'] = value * 30487.804878048784
        returnDict['in_hg'] = value * 2.895902442838506
        returnDict['in_h2o'] = value * 39.37007874015748
        returnDict['kg/cm2'] = value * 0.1
        returnDict['kg/m2'] = value * 1000.0
        returnDict['kPa'] = value * 9.806652048217348
        returnDict['Mpa'] = value * 0.009806649999787736
        returnDict['m_Hg'] = value * 0.07355592380756708
        returnDict['m_h2o'] = value
        returnDict['mbar'] = value * 98.0665
        returnDict['N/cm2'] = value * 0.980665
        returnDict['N/m2'] = value * 9806.65
        returnDict['N/mm2'] = value * 0.0098067
        returnDict['Pa'] = value * 9806.65
        returnDict['psf'] = value * 204.8161436
        returnDict['psi'] = value * 1.4223343
        returnDict['torr'] = value * 73.555924
    elif units == 'mbar':
        returnDict['atm'] = value * 0.0009869232667160128
        returnDict['bar'] = value * 0.001
        returnDict['cm_Hg'] = value * 0.07500616850729803
        returnDict['cm_h2o'] = value * 1.0197162129779282
        returnDict['dyne/cm2'] = value * 1000.0
        returnDict['ft_air'] = value * 25.879314405202777
        returnDict['ft_hg'] = value * 0.00246083192262042
        returnDict['ft_h2o'] = value * 0.033455256555147694
        returnDict['in_air'] = value * 310.54936182106144
        returnDict['in_hg'] = value * 0.029529983042377705
        returnDict['in_h2o'] = value * 0.4014630759755623
        returnDict['kg/cm2'] = value * 0.0010197162129779282
        returnDict['kg/m2'] = value * 10.197162129779283
        returnDict['kPa'] = value * 0.1
        returnDict['Mpa'] = value * 0.0001
        returnDict['m_Hg'] = value * 0.0007500616827100918
        returnDict['m_h2o'] = value * 0.010197162129779282
        returnDict['mbar'] = value
        returnDict['N/cm2'] = value * 0.01
        returnDict['N/m2'] = value * 100.0
        returnDict['N/mm2'] = value * 0.0001
        returnDict['Pa'] = value * 100.0
        returnDict['psf'] = value * 2.0885434
        returnDict['psi'] = value * 0.0145038
        returnDict['torr'] = value * 0.7500617
    elif units == 'N/cm2':
        returnDict['atm'] = value * 0.09869232667160129
        returnDict['bar'] = value * 0.1
        returnDict['cm_Hg'] = value * 7.500615050434135
        returnDict['cm_h2o'] = value * 101.97110138986612
        returnDict['dyne/cm2'] = value * 99999.99999999999
        returnDict['ft_air'] = value * 2587.991718426501
        returnDict['ft_hg'] = value * 0.246083192262042
        returnDict['ft_h2o'] = value * 3.345525543589354
        returnDict['in_air'] = value * 31055.900621118017
        returnDict['in_hg'] = value * 2.952998016471232
        returnDict['in_h2o'] = value * 40.14629309202735
        returnDict['kg/cm2'] = value * 0.10197162129779283
        returnDict['kg/m2'] = value * 1019.6798205363517
        returnDict['kPa'] = value * 10.0
        returnDict['Mpa'] = value * 0.01
        returnDict['m_Hg'] = value * 0.07500616850729803
        returnDict['m_h2o'] = value * 1.0197162129779282
        returnDict['mbar'] = value * 100.0
        returnDict['N/cm2'] = value
        returnDict['N/m2'] = value * 10000.0
        returnDict['N/mm2'] = value * 0.01
        returnDict['Pa'] = value * 10000.0
        returnDict['psf'] = value * 208.8543423
        returnDict['psi'] = value * 1.4503774
        returnDict['torr'] = value * 75.0061683
    elif units == 'N/m2':
        returnDict['atm'] = value * 9.869232667160129e-06
        returnDict['bar'] = value * 1e-05
        returnDict['cm_Hg'] = value * 0.0007500616827100918
        returnDict['cm_h2o'] = value * 0.010197162129779282
        returnDict['dyne/cm2'] = value * 10.0
        returnDict['ft_air'] = value * 0.2587932244207224
        returnDict['ft_hg'] = value * 2.46083192262042e-05
        returnDict['ft_h2o'] = value * 0.00033455256555147697
        returnDict['in_air'] = value * 3.105518693048669
        returnDict['in_hg'] = value * 0.0002952998307115436
        returnDict['in_h2o'] = value * 0.004014630787154965
        returnDict['kg/cm2'] = value * 1.0197162129779282e-05
        returnDict['kg/m2'] = value * 0.10197162129779283
        returnDict['kPa'] = value * 0.001
        returnDict['Mpa'] = value * 1e-06
        returnDict['m_Hg'] = value * 7.500616827100917e-06
        returnDict['m_h2o'] = value * 0.00010197162129779283
        returnDict['mbar'] = value * 0.01
        returnDict['N/cm2'] = value * 0.0001
        returnDict['N/m2'] = value
        returnDict['N/mm2'] = value * 1e-06
        returnDict['Pa'] = value
        returnDict['psf'] = value * 0.0208854
        returnDict['psi'] = value * 0.000145
        returnDict['torr'] = value * 0.0075006
    elif units == 'N/mm2':
        returnDict['atm'] = value * 9.869232667160128
        returnDict['bar'] = value * 10.0
        returnDict['cm_Hg'] = value * 750.0750075007501
        returnDict['cm_h2o'] = value * 10193.67991845056
        returnDict['dyne/cm2'] = value * 10000000.0
        returnDict['ft_air'] = value * 256410.2564102564
        returnDict['ft_hg'] = value * 24.608297425726008
        returnDict['ft_h2o'] = value * 334.54886086112873
        returnDict['in_air'] = value * 3105493.6182106147
        returnDict['in_hg'] = value * 295.2988424285377
        returnDict['in_h2o'] = value * 4014.452027298274
        returnDict['kg/cm2'] = value * 10.197162129779283
        returnDict['kg/m2'] = value * 102040.81632653062
        returnDict['kPa'] = value * 1000.0
        returnDict['Mpa'] = value
        returnDict['m_Hg'] = value * 7.500615050434135
        returnDict['m_h2o'] = value * 101.97110138986612
        returnDict['mbar'] = value * 10000.0
        returnDict['N/cm2'] = value * 100.0
        returnDict['N/m2'] = value * 1000000.0
        returnDict['N/mm2'] = value
        returnDict['Pa'] = value * 1000000.0
        returnDict['psf'] = value * 20885.4342333
        returnDict['psi'] = value * 145.0377377
        returnDict['torr'] = value * 7500.6168271
    elif units == 'Pa':
        returnDict['atm'] = value * 9.869232667160129e-06
        returnDict['bar'] = value * 1e-05
        returnDict['cm_Hg'] = value * 0.0007500616827100918
        returnDict['cm_h2o'] = value * 0.010197162129779282
        returnDict['dyne/cm2'] = value * 10.0
        returnDict['ft_air'] = value * 0.2587932244207224
        returnDict['ft_hg'] = value * 2.46083192262042e-05
        returnDict['ft_h2o'] = value * 0.00033455256555147697
        returnDict['in_air'] = value * 3.105518693048669
        returnDict['in_hg'] = value * 0.0002952998307115436
        returnDict['in_h2o'] = value * 0.004014630787154965
        returnDict['kg/cm2'] = value * 1.0197162129779282e-05
        returnDict['kg/m2'] = value * 0.10197162129779283
        returnDict['kPa'] = value * 0.001
        returnDict['Mpa'] = value * 1e-06
        returnDict['m_Hg'] = value * 7.500616827100917e-06
        returnDict['m_h2o'] = value * 0.00010197162129779283
        returnDict['mbar'] = value * 0.01
        returnDict['N/cm2'] = value * 0.0001
        returnDict['N/m2'] = value
        returnDict['N/mm2'] = value * 1e-06
        returnDict['Pa'] = value
        returnDict['psf'] = value * 0.0208854
        returnDict['psi'] = value * 0.000145
        returnDict['torr'] = value * 0.0075006
    elif units == 'psf':
        returnDict['atm'] = value * 0.0004725414160349977
        returnDict['bar'] = value * 0.0004788025898068001
        returnDict['cm_Hg'] = value * 0.03591314758641598
        returnDict['cm_h2o'] = value * 0.4882427722737085
        returnDict['dyne/cm2'] = value * 478.8125448886761
        returnDict['ft_air'] = value * 12.391082385828566
        returnDict['ft_hg'] = value * 0.00117825269765839
        returnDict['ft_h2o'] = value * 0.016018463470475527
        returnDict['in_air'] = value * 148.6922516467667
        returnDict['in_hg'] = value * 0.014139032368568808
        returnDict['in_h2o'] = value * 0.19222156226152512
        returnDict['kg/cm2'] = value * 0.0004882427636443163
        returnDict['kg/m2'] = value * 4.88242867626129
        returnDict['kPa'] = value * 0.04788025905633315
        returnDict['Mpa'] = value * 4.788025897999226e-05
        returnDict['m_Hg'] = value * 0.0003591314761865983
        returnDict['m_h2o'] = value * 0.004882427636919925
        returnDict['mbar'] = value * 0.4788025951483699
        returnDict['N/cm2'] = value * 0.004788025898755757
        returnDict['N/m2'] = value * 47.88033746061843
        returnDict['N/mm2'] = value * 4.788025897999226e-05
        returnDict['Pa'] = value * 47.88033746061843
        returnDict['psf'] = value
        returnDict['psi'] = value * 0.0069444
        returnDict['torr'] = value * 0.3591315
    elif units == 'psi':
        returnDict['atm'] = value * 0.0680459637964988
        returnDict['bar'] = value * 0.06894757280343135
        returnDict['cm_Hg'] = value * 5.171494515371491
        returnDict['cm_h2o'] = value * 70.30717203461926
        returnDict['dyne/cm2'] = value * 68965.5172413793
        returnDict['ft_air'] = value * 1784.4396859386154
        returnDict['ft_hg'] = value * 0.16966838890261507
        returnDict['ft_h2o'] = value * 2.3066587471383015
        returnDict['in_air'] = value * 21413.276231263386
        returnDict['in_hg'] = value * 2.036020459562394
        returnDict['in_h2o'] = value * 27.6798985808516
        returnDict['kg/cm2'] = value * 0.07030695799910841
        returnDict['kg/m2'] = value * 703.0865499542994
        returnDict['kPa'] = value * 6.89475908677537
        returnDict['Mpa'] = value * 0.006894757294604437
        returnDict['m_Hg'] = value * 0.05171493258387088
        returnDict['m_h2o'] = value * 0.7030695948202894
        returnDict['mbar'] = value * 68.94744825494008
        returnDict['N/cm2'] = value * 0.6894757185267779
        returnDict['N/m2'] = value * 6896.551724137931
        returnDict['N/mm2'] = value * 0.006894757294604437
        returnDict['Pa'] = value * 6896.551724137931
        returnDict['psf'] = value * 144.00092160589827
        returnDict['psi'] = value
        returnDict['torr'] = value * 51.7149326
    elif units == 'torr':
        returnDict['atm'] = value * 0.0013157894736842105
        returnDict['bar'] = value * 0.001333223684217938
        returnDict['cm_Hg'] = value * 0.1
        returnDict['cm_h2o'] = value * 1.3595098803740067
        returnDict['dyne/cm2'] = value * 1333.1555792560991
        returnDict['ft_air'] = value * 34.502984508159955
        returnDict['ft_hg'] = value * 0.0032808394020261
        returnDict['ft_h2o'] = value * 0.04460334037538305
        returnDict['in_air'] = value * 414.0272429925889
        returnDict['in_hg'] = value * 0.039370072850146584
        returnDict['in_h2o'] = value * 0.535240072567849
        returnDict['kg/cm2'] = value * 0.0013595098062584993
        returnDict['kg/m2'] = value * 13.595102500275303
        returnDict['kPa'] = value * 0.13332236890171484
        returnDict['Mpa'] = value * 0.00013332236842001632
        returnDict['m_Hg'] = value * 0.001
        returnDict['m_h2o'] = value * 0.013595098064433259
        returnDict['mbar'] = value * 1.3332236534674413
        returnDict['N/cm2'] = value * 0.013332236836846924
        returnDict['N/m2'] = value * 133.32266751993174
        returnDict['N/mm2'] = value * 0.00013332236842001632
        returnDict['Pa'] = value * 133.32266751993174
        returnDict['psf'] = value * 2.7844953728648143
        returnDict['psi'] = value * 0.019336774693969147
        returnDict['torr'] = value
    return returnDict


def time(value, units):
    returnDict = {}
    if units == 'day':
        returnDict['day'] = value
        returnDict['decade'] = value * 0.000274
        returnDict['hr'] = value * 24.0
        returnDict['minute'] = value * 1440.0
        returnDict['sec'] = value * 86400.0
        returnDict['yr'] = value * 0.0027397
    elif units == 'decade':
        returnDict['day'] = value * 3650.0
        returnDict['decade'] = value
        returnDict['hr'] = value * 87600.0
        returnDict['minute'] = value * 5256000.0
        returnDict['sec'] = value * 315360000.0
        returnDict['yr'] = value * 10.0
    elif units == 'hr':
        returnDict['day'] = value * 0.0416667
        returnDict['decade'] = value * 1.14e-05
        returnDict['hr'] = value
        returnDict['minute'] = value * 60.0
        returnDict['sec'] = value * 3600.0
        returnDict['yr'] = value * 0.0001142
    elif units == 'minute':
        returnDict['day'] = value * 0.0006944
        returnDict['decade'] = value * 1.90258751e-07
        returnDict['hr'] = value * 0.0166667
        returnDict['minute'] = value
        returnDict['sec'] = value * 60.0
        returnDict['yr'] = value * 1.9e-06
    elif units == 'sec':
        returnDict['day'] = value * 1.16e-05
        returnDict['decade'] = value * 3.171e-09
        returnDict['hr'] = value * 0.0002778
        returnDict['minute'] = value * 0.0166667
        returnDict['sec'] = value
        returnDict['yr'] = value * 3.171e-08
    elif units == 'yr':
        returnDict['day'] = value * 365.0
        returnDict['decade'] = value * 0.1
        returnDict['hr'] = value * 8760.0
        returnDict['minute'] = value * 525600.0
        returnDict['sec'] = value * 31536000.0
        returnDict['yr'] = value
    return returnDict


def torque(value, units):
    returnDict = {}
    if units == 'ft-oz':
        returnDict['ft-oz'] = value
        returnDict['ft-lb'] = value * 0.0625
        returnDict['in-oz'] = value * 12.0000768
        returnDict['in-lb'] = value * 0.7500003
        returnDict['kg-cm'] = value * 0.8640934
        returnDict['kg-m'] = value * 0.0086409
        returnDict['kN-m'] = value * 8.47e-05
        returnDict['N-cm'] = value * 8.4738639
        returnDict['N-m'] = value * 0.0847386
    elif units == 'ft-lb':
        returnDict['ft-oz'] = value * 16.0
        returnDict['ft-lb'] = value
        returnDict['in-oz'] = value * 192.0012288
        returnDict['in-lb'] = value * 12.0000048
        returnDict['kg-cm'] = value * 13.8254952
        returnDict['kg-m'] = value * 0.138255
        returnDict['kN-m'] = value * 0.0013558
        returnDict['N-cm'] = value * 135.5818223
        returnDict['N-m'] = value * 1.3558182
    elif units == 'in-oz':
        returnDict['ft-oz'] = value * 0.0833328
        returnDict['ft-lb'] = value * 0.0052083
        returnDict['in-oz'] = value
        returnDict['in-lb'] = value * 0.0624996
        returnDict['kg-cm'] = value * 0.0720073
        returnDict['kg-m'] = value * 0.0007201
        returnDict['kN-m'] = value * 7.1e-06
        returnDict['N-cm'] = value * 0.7061508
        returnDict['N-m'] = value * 0.0070615
    elif units == 'in-lb':
        returnDict['ft-oz'] = value * 1.3333328
        returnDict['ft-lb'] = value * 0.0833333
        returnDict['in-oz'] = value * 16.000096
        returnDict['in-lb'] = value
        returnDict['kg-cm'] = value * 1.1521241
        returnDict['kg-m'] = value * 0.0115212
        returnDict['kN-m'] = value * 0.000113
        returnDict['N-cm'] = value * 11.2984807
        returnDict['N-m'] = value * 0.1129848
    elif units == 'kg-cm':
        returnDict['ft-oz'] = value * 1.1572822
        returnDict['ft-lb'] = value * 0.0723301
        returnDict['in-oz'] = value * 13.8874758
        returnDict['in-lb'] = value * 0.867962
        returnDict['kg-cm'] = value
        returnDict['kg-m'] = value * 0.01
        returnDict['kN-m'] = value * 9.81e-05
        returnDict['N-cm'] = value * 9.8066522
        returnDict['N-m'] = value * 0.0980665
    elif units == 'kg-m':
        returnDict['ft-oz'] = value * 115.728224
        returnDict['ft-lb'] = value * 7.233014
        returnDict['in-oz'] = value * 1388.747576
        returnDict['in-lb'] = value * 86.7962027
        returnDict['kg-cm'] = value * 100.0
        returnDict['kg-m'] = value
        returnDict['kN-m'] = value * 0.0098067
        returnDict['N-cm'] = value * 980.6652187
        returnDict['N-m'] = value * 9.8066522
    elif units == 'kN-m':
        returnDict['ft-oz'] = value * 11800.992
        returnDict['ft-lb'] = value * 737.562
        returnDict['in-oz'] = value * 141612.810322
        returnDict['in-lb'] = value * 8850.7475403
        returnDict['kg-cm'] = value * 10197.1598562
        returnDict['kg-m'] = value * 101.9715986
        returnDict['kN-m'] = value
        returnDict['N-cm'] = value * 100000.0
        returnDict['N-m'] = value * 1000.0
    elif units == 'N-cm':
        returnDict['ft-oz'] = value * 0.1180099
        returnDict['ft-lb'] = value * 0.0073756
        returnDict['in-oz'] = value * 1.4161281
        returnDict['in-lb'] = value * 0.0885075
        returnDict['kg-cm'] = value * 0.1019716
        returnDict['kg-m'] = value * 0.0010197
        returnDict['kN-m'] = value * 1e-05
        returnDict['N-cm'] = value
        returnDict['N-m'] = value * 0.01
    elif units == 'N-m':
        returnDict['ft-oz'] = value * 11.800992
        returnDict['ft-lb'] = value * 0.737562
        returnDict['in-oz'] = value * 141.6128103
        returnDict['in-lb'] = value * 8.8507475
        returnDict['kg-cm'] = value * 10.1971599
        returnDict['kg-m'] = value * 0.1019716
        returnDict['kN-m'] = value * 0.001
        returnDict['N-cm'] = value * 100.0
        returnDict['N-m'] = value
    return returnDict


def volume(value, units):
    returnDict = {}
    if units == 'bbl':
        returnDict['bbl'] = value
        returnDict['bucket'] = value * 8.4
        returnDict['bu_us'] = value * 4.5116768
        returnDict['cm3'] = value * 158987.2949285
        returnDict['ft3'] = value * 5.6145833
        returnDict['in3'] = value * 9702.0
        returnDict['m3'] = value * 0.1589873
        returnDict['mm3'] = value * 158987294.928538
        returnDict['yd3'] = value * 0.2079475
        returnDict['C'] = value * 672.0
        returnDict['dr'] = value * 43008.0
        returnDict['drum'] = value * 0.7636364
        returnDict['fl oz'] = value * 5376.0
        returnDict['gal_us'] = value * 42.0
        returnDict['gill'] = value * 1344.0
        returnDict['gal_uk'] = value * 34.9723158
        returnDict['kL'] = value * 0.1589873
        returnDict['L'] = value * 158.9872949
        returnDict['ml'] = value * 158987.2949285
        returnDict['Pt'] = value * 336.0
        returnDict['qt_dr'] = value * 144.3736563
        returnDict['qt_lq'] = value * 168.0
        returnDict['tbsp'] = value * 10752.0
        returnDict['tsp'] = value * 32256.0
        returnDict['toe'] = value * 0.1363636
    elif units == 'bucket':
        returnDict['bbl'] = value * 0.11904761904761904
        returnDict['bucket'] = value
        returnDict['bu_us'] = value * 0.5371044
        returnDict['cm3'] = value * 18927.0589201
        returnDict['ft3'] = value * 0.6684028
        returnDict['in3'] = value * 1155.0
        returnDict['m3'] = value * 0.0189271
        returnDict['mm3'] = value * 18927058.920064
        returnDict['yd3'] = value * 0.0247557
        returnDict['C'] = value * 80.0
        returnDict['dr'] = value * 5120.0
        returnDict['drum'] = value * 0.0909091
        returnDict['fl oz'] = value * 640.0
        returnDict['gal_us'] = value * 5.0
        returnDict['gill'] = value * 160.0
        returnDict['gal_uk'] = value * 4.1633709
        returnDict['kL'] = value * 0.0189271
        returnDict['L'] = value * 18.9270589
        returnDict['ml'] = value * 18927.0589201
        returnDict['Pt'] = value * 40.0
        returnDict['qt_dr'] = value * 17.18734
        returnDict['qt_lq'] = value * 20.0
        returnDict['tbsp'] = value * 1280.0
        returnDict['tsp'] = value * 3840.0
        returnDict['toe'] = value * 0.0162338
    elif units == 'bu_us':
        returnDict['bbl'] = value * 0.22164708252151394
        returnDict['bucket'] = value * 1.8618354271534545
        returnDict['bu_us'] = value
        returnDict['cm3'] = value * 35239.070208
        returnDict['ft3'] = value * 1.244456
        returnDict['in3'] = value * 2150.4200025
        returnDict['m3'] = value * 0.0352391
        returnDict['mm3'] = value * 35239070.2079668
        returnDict['yd3'] = value * 0.046091
        returnDict['C'] = value * 148.94684
        returnDict['dr'] = value * 9532.59776
        returnDict['drum'] = value * 0.1692578
        returnDict['fl oz'] = value * 1191.57472
        returnDict['gal_us'] = value * 9.3091775
        returnDict['gill'] = value * 297.89368
        returnDict['gal_uk'] = value * 7.7515118
        returnDict['kL'] = value * 0.0352391
        returnDict['L'] = value * 35.2390702
        returnDict['ml'] = value * 35239.070208
        returnDict['Pt'] = value * 74.47342
        returnDict['qt_dr'] = value * 31.9999998
        returnDict['qt_lq'] = value * 37.23671
        returnDict['tbsp'] = value * 2383.14944
        returnDict['tsp'] = value * 7149.44832
        returnDict['toe'] = value * 0.0302246
    elif units == 'cm3':
        returnDict['bbl'] = value * 6.289810770412325e-06
        returnDict['bucket'] = value * 5.2834410471350536e-05
        returnDict['bu_us'] = value * 2.8377593225288316e-05
        returnDict['cm3'] = value
        returnDict['ft3'] = value * 3.53e-05
        returnDict['in3'] = value * 0.0610237
        returnDict['m3'] = value * 1e-06
        returnDict['mm3'] = value * 1000.0
        returnDict['yd3'] = value * 1.3e-06
        returnDict['C'] = value * 0.0042268
        returnDict['dr'] = value * 0.2705122
        returnDict['drum'] = value * 4.8e-06
        returnDict['fl oz'] = value * 0.033814
        returnDict['gal_us'] = value * 0.0002642
        returnDict['gill'] = value * 0.0084535
        returnDict['gal_uk'] = value * 0.00022
        returnDict['kL'] = value * 1e-06
        returnDict['L'] = value * 0.001
        returnDict['ml'] = value
        returnDict['Pt'] = value * 0.0021134
        returnDict['qt_dr'] = value * 0.0009081
        returnDict['qt_lq'] = value * 0.0010567
        returnDict['tbsp'] = value * 0.067628
        returnDict['tsp'] = value * 0.2028841
        returnDict['toe'] = value * 8.57701e-07
    elif units == 'ft3':
        returnDict['bbl'] = value * 0.17810760773644593
        returnDict['bucket'] = value * 1.4961038463633007
        returnDict['bu_us'] = value * 0.8035639669060216
        returnDict['cm3'] = value * 28328.611898017
        returnDict['ft3'] = value
        returnDict['in3'] = value * 1728.0
        returnDict['m3'] = value * 0.0283168
        returnDict['mm3'] = value * 28316846.592
        returnDict['yd3'] = value * 0.037037
        returnDict['C'] = value * 119.6883117
        returnDict['dr'] = value * 7660.051948
        returnDict['drum'] = value * 0.1360094
        returnDict['fl oz'] = value * 957.5064935
        returnDict['gal_us'] = value * 7.4805195
        returnDict['gill'] = value * 239.3766234
        returnDict['gal_uk'] = value * 6.2288355
        returnDict['kL'] = value * 0.0283168
        returnDict['L'] = value * 28.3168466
        returnDict['ml'] = value * 28316.846592
        returnDict['Pt'] = value * 59.8441558
        returnDict['qt_dr'] = value * 25.7140464
        returnDict['qt_lq'] = value * 29.9220779
        returnDict['tbsp'] = value * 1915.012987
        returnDict['tsp'] = value * 5745.038961
        returnDict['toe'] = value * 0.0242874
    elif units == 'in3':
        returnDict['bbl'] = value * 0.00010307153164296021
        returnDict['bucket'] = value * 0.0008658008658008658
        returnDict['bu_us'] = value * 0.0004650254363507763
        returnDict['cm3'] = value * 16.3870758410257
        returnDict['ft3'] = value * 0.0005787037037037037
        returnDict['in3'] = value
        returnDict['m3'] = value * 1.64e-05
        returnDict['mm3'] = value * 16387.064
        returnDict['yd3'] = value * 2.14e-05
        returnDict['C'] = value * 0.0692641
        returnDict['dr'] = value * 4.4329004
        returnDict['drum'] = value * 7.87e-05
        returnDict['fl oz'] = value * 0.5541126
        returnDict['gal_us'] = value * 0.004329
        returnDict['gill'] = value * 0.1385281
        returnDict['gal_uk'] = value * 0.0036047
        returnDict['kL'] = value * 1.64e-05
        returnDict['L'] = value * 0.0163871
        returnDict['ml'] = value * 16.387064
        returnDict['Pt'] = value * 0.034632
        returnDict['qt_dr'] = value * 0.0148808
        returnDict['qt_lq'] = value * 0.017316
        returnDict['tbsp'] = value * 1.1082251
        returnDict['tsp'] = value * 3.3246753
        returnDict['toe'] = value * 1.41e-05
    elif units == 'm3':
        returnDict['bbl'] = value * 6.28981056977507
        returnDict['bucket'] = value * 52.83429579808846
        returnDict['bu_us'] = value * 28.377569234174537
        returnDict['cm3'] = value * 1000000.0
        returnDict['ft3'] = value * 35.31472482766414
        returnDict['in3'] = value * 60975.60975609757
        returnDict['m3'] = value
        returnDict['mm3'] = value * 1000000000.0
        returnDict['yd3'] = value * 1.3079506
        returnDict['C'] = value * 4226.7528377
        returnDict['dr'] = value * 270512.1816138
        returnDict['drum'] = value * 4.8031282
        returnDict['fl oz'] = value * 33814.0227017
        returnDict['gal_us'] = value * 264.1720524
        returnDict['gill'] = value * 8453.5056754
        returnDict['gal_uk'] = value * 219.9692483
        returnDict['kL'] = value
        returnDict['L'] = value * 1000.0
        returnDict['ml'] = value * 1000000.0
        returnDict['Pt'] = value * 2113.3764189
        returnDict['qt_dr'] = value * 908.0829783
        returnDict['qt_lq'] = value * 1056.6882094
        returnDict['tbsp'] = value * 67628.0454035
        returnDict['tsp'] = value * 202884.1362104
        returnDict['toe'] = value * 0.8577015
    elif units == 'mm3':
        returnDict['bbl'] = value * 6.289810770410821e-09
        returnDict['bucket'] = value * 5.2834410471451034e-08
        returnDict['bu_us'] = value * 2.837759322531505e-08
        returnDict['cm3'] = value * 0.001
        returnDict['ft3'] = value * 3.531466672148859e-08
        returnDict['in3'] = value * 6.102374409473229e-05
        returnDict['m3'] = value * 1e-09
        returnDict['mm3'] = value
        returnDict['yd3'] = value * 1.308e-09
        returnDict['C'] = value * 4.2269999999999995e-06
        returnDict['dr'] = value * 0.0002705
        returnDict['drum'] = value * 4.803e-09
        returnDict['fl oz'] = value * 3.3814023e-05
        returnDict['gal_us'] = value * 2.6417199999999996e-07
        returnDict['gill'] = value * 8.453506e-06
        returnDict['gal_uk'] = value * 2.19969e-07
        returnDict['kL'] = value * 1e-09
        returnDict['L'] = value * 1e-06
        returnDict['ml'] = value * 0.001
        returnDict['Pt'] = value * 2.113376419e-06
        returnDict['qt_dr'] = value * 9.08082978e-07
        returnDict['qt_lq'] = value * 1.056688209e-06
        returnDict['tbsp'] = value * 6.76e-05
        returnDict['tsp'] = value * 0.0002029
        returnDict['toe'] = value * 8.577015e-10
    elif units == 'yd3':
        returnDict['bbl'] = value * 4.808906094086248
        returnDict['bucket'] = value * 40.394737373614966
        returnDict['bu_us'] = value * 21.696209672170273
        returnDict['cm3'] = value * 769230.7692307692
        returnDict['ft3'] = value * 27.000027000027
        returnDict['in3'] = value * 46728.97196261682
        returnDict['m3'] = value * 0.7645548692741148
        returnDict['mm3'] = value * 764525993.883792
        returnDict['yd3'] = value
        returnDict['C'] = value * 3231.5844156
        returnDict['dr'] = value * 206821.4025967
        returnDict['drum'] = value * 3.672255
        returnDict['fl oz'] = value * 25852.6753246
        returnDict['gal_us'] = value * 201.974026
        returnDict['gill'] = value * 6463.1688311
        returnDict['gal_uk'] = value * 168.1785574
        returnDict['kL'] = value * 0.7645549
        returnDict['L'] = value * 764.554858
        returnDict['ml'] = value * 764554.857984
        returnDict['Pt'] = value * 1615.7922078
        returnDict['qt_dr'] = value * 694.2792525
        returnDict['qt_lq'] = value * 807.8961039
        returnDict['tbsp'] = value * 51705.3506492
        returnDict['tsp'] = value * 155116.0519475
        returnDict['toe'] = value * 0.6557598
    elif units == 'C':
        returnDict['bbl'] = value * 0.001488095238095238
        returnDict['bucket'] = value * 0.0125
        returnDict['bu_us'] = value * 0.006713804737314332
        returnDict['cm3'] = value * 236.58559666887479
        returnDict['ft3'] = value * 0.0083550347214063
        returnDict['in3'] = value * 14.43749359336222
        returnDict['m3'] = value * 0.0002365882365017002
        returnDict['mm3'] = value * 236574.40264963332
        returnDict['yd3'] = value * 0.0003094457304511826
        returnDict['C'] = value
        returnDict['dr'] = value * 64.0
        returnDict['drum'] = value * 0.0011364
        returnDict['fl oz'] = value * 8.0
        returnDict['gal_us'] = value * 0.0625
        returnDict['gill'] = value * 2.0
        returnDict['gal_uk'] = value * 0.0520421
        returnDict['kL'] = value * 0.0002366
        returnDict['L'] = value * 0.2365882
        returnDict['ml'] = value * 236.5882365
        returnDict['Pt'] = value * 0.5
        returnDict['qt_dr'] = value * 0.2148418
        returnDict['qt_lq'] = value * 0.25
        returnDict['tbsp'] = value * 16.0
        returnDict['tsp'] = value * 48.0
        returnDict['toe'] = value * 0.0002029
    elif units == 'dr':
        returnDict['bbl'] = value * 2.3251488095238094e-05
        returnDict['bucket'] = value * 0.0001953125
        returnDict['bu_us'] = value * 0.00010490319902053644
        returnDict['cm3'] = value * 3.696690944068327
        returnDict['ft3'] = value * 0.00013054741753560755
        returnDict['in3'] = value * 0.22558593917427064
        returnDict['m3'] = value * 3.6966911953254e-06
        returnDict['mm3'] = value * 3696.857670979667
        returnDict['yd3'] = value * 4.835089538339471e-06
        returnDict['C'] = value * 0.015625
        returnDict['dr'] = value
        returnDict['drum'] = value * 1.78e-05
        returnDict['fl oz'] = value * 0.125
        returnDict['gal_us'] = value * 0.0009766
        returnDict['gill'] = value * 0.03125
        returnDict['gal_uk'] = value * 0.0008132
        returnDict['kL'] = value * 3.7e-06
        returnDict['L'] = value * 0.0036967
        returnDict['ml'] = value * 3.6966912
        returnDict['Pt'] = value * 0.0078125
        returnDict['qt_dr'] = value * 0.0033569
        returnDict['qt_lq'] = value * 0.0039063
        returnDict['tbsp'] = value * 0.25
        returnDict['tsp'] = value * 0.75
        returnDict['toe'] = value * 3.2e-06
    elif units == 'drum':
        returnDict['bbl'] = value * 1.3095237471655359
        returnDict['bucket'] = value * 10.99999890000011
        returnDict['bu_us'] = value * 5.90814721684909
        returnDict['cm3'] = value * 208333.33333333334
        returnDict['ft3'] = value * 7.352432993601913
        returnDict['in3'] = value * 12706.480304955527
        returnDict['m3'] = value * 0.20819764919037556
        returnDict['mm3'] = value * 208203206.32937747
        returnDict['yd3'] = value * 0.2723122441115881
        returnDict['C'] = value * 879.9718409010911
        returnDict['dr'] = value * 56179.77528089888
        returnDict['drum'] = value
        returnDict['fl oz'] = value * 7040.0
        returnDict['gal_us'] = value * 55.0
        returnDict['gill'] = value * 1760.0
        returnDict['gal_uk'] = value * 45.7970802
        returnDict['kL'] = value * 0.2081976
        returnDict['L'] = value * 208.1976481
        returnDict['ml'] = value * 208197.6481207
        returnDict['Pt'] = value * 440.0
        returnDict['qt_dr'] = value * 189.0607404
        returnDict['qt_lq'] = value * 220.0
        returnDict['tbsp'] = value * 14080.0
        returnDict['tsp'] = value * 42240.0
        returnDict['toe'] = value * 0.1785714
    elif units == 'fl oz':
        returnDict['bbl'] = value * 0.00018601190476190475
        returnDict['bucket'] = value * 0.0015625
        returnDict['bu_us'] = value * 0.0008392255921642915
        returnDict['cm3'] = value * 29.57354941740108
        returnDict['ft3'] = value * 0.0010443793402848604
        returnDict['in3'] = value * 1.8046873505493288
        returnDict['m3'] = value * 2.9573529562625064e-05
        returnDict['mm3'] = value * 29573.52930173378
        returnDict['yd3'] = value * 3.868071630669706e-05
        returnDict['C'] = value * 0.125
        returnDict['dr'] = value * 8.0
        returnDict['drum'] = value * 0.00014204545454545454
        returnDict['fl oz'] = value
        returnDict['gal_us'] = value * 0.0078125
        returnDict['gill'] = value * 0.25
        returnDict['gal_uk'] = value * 0.0065053
        returnDict['kL'] = value * 2.96e-05
        returnDict['L'] = value * 0.0295735
        returnDict['ml'] = value * 29.5735296
        returnDict['Pt'] = value * 0.0625
        returnDict['qt_dr'] = value * 0.0268552
        returnDict['qt_lq'] = value * 0.03125
        returnDict['tbsp'] = value * 2.0
        returnDict['tsp'] = value * 6.0
        returnDict['toe'] = value * 2.54e-05
    elif units == 'gal_us':
        returnDict['bbl'] = value * 0.023809523809523808
        returnDict['bucket'] = value * 0.2
        returnDict['bu_us'] = value * 0.10742087579702932
        returnDict['cm3'] = value * 3785.0113550340648
        returnDict['ft3'] = value * 0.1336805552074291
        returnDict['in3'] = value * 231.00023100023097
        returnDict['m3'] = value * 0.0037854117834002945
        returnDict['mm3'] = value * 3785412.534257984
        returnDict['yd3'] = value * 0.0049511316866060785
        returnDict['C'] = value * 16.0
        returnDict['dr'] = value * 1023.9606799098915
        returnDict['drum'] = value * 0.01818181818181818
        returnDict['fl oz'] = value * 128.0
        returnDict['gal_us'] = value
        returnDict['gill'] = value * 32.0
        returnDict['gal_uk'] = value * 0.8326742
        returnDict['kL'] = value * 0.0037854
        returnDict['L'] = value * 3.7854118
        returnDict['ml'] = value * 3785.411784
        returnDict['Pt'] = value * 8.0
        returnDict['qt_dr'] = value * 3.437468
        returnDict['qt_lq'] = value * 4.0
        returnDict['tbsp'] = value * 256.0
        returnDict['tsp'] = value * 768.0
        returnDict['toe'] = value * 0.0032468
    elif units == 'gill':
        returnDict['bbl'] = value * 0.000744047619047619
        returnDict['bucket'] = value * 0.00625
        returnDict['bu_us'] = value * 0.003356902368657166
        returnDict['cm3'] = value * 118.29419766960432
        returnDict['ft3'] = value * 0.00417751736070315
        returnDict['in3'] = value * 7.218752007715403
        returnDict['m3'] = value * 0.0001182941182508501
        returnDict['mm3'] = value * 118294.11370856069
        returnDict['yd3'] = value * 0.00015472286522798522
        returnDict['C'] = value * 0.5
        returnDict['dr'] = value * 32.0
        returnDict['drum'] = value * 0.0005681818181818182
        returnDict['fl oz'] = value * 4.0
        returnDict['gal_us'] = value * 0.03125
        returnDict['gill'] = value
        returnDict['gal_uk'] = value * 0.0260211
        returnDict['kL'] = value * 0.0001183
        returnDict['L'] = value * 0.1182941
        returnDict['ml'] = value * 118.2941183
        returnDict['Pt'] = value * 0.25
        returnDict['qt_dr'] = value * 0.1074209
        returnDict['qt_lq'] = value * 0.125
        returnDict['tbsp'] = value * 8.0
        returnDict['tsp'] = value * 24.0
        returnDict['toe'] = value * 0.0001015
    elif units == 'gal_uk':
        returnDict['bbl'] = value * 0.02859404580808458
        returnDict['bucket'] = value * 0.24018998643623127
        returnDict['bu_us'] = value * 0.1290070925261315
        returnDict['cm3'] = value * 4545.454545454545
        returnDict['ft3'] = value * 0.16054365218025105
        returnDict['in3'] = value * 277.41559630482425
        returnDict['m3'] = value * 0.004546089999981147
        returnDict['mm3'] = value * 4546095.131586724
        returnDict['yd3'] = value * 0.005946061230752358
        returnDict['C'] = value * 19.215212299273087
        returnDict['dr'] = value * 1229.7097884899163
        returnDict['drum'] = value * 0.021835453169348554
        returnDict['fl oz'] = value * 153.72081226077196
        returnDict['gal_us'] = value * 1.2009499033355422
        returnDict['gill'] = value * 38.43035075381133
        returnDict['gal_uk'] = value
        returnDict['kL'] = value * 0.0045461
        returnDict['L'] = value * 4.54609
        returnDict['ml'] = value * 4546.09
        returnDict['Pt'] = value * 9.6075994
        returnDict['qt_dr'] = value * 4.1282269
        returnDict['qt_lq'] = value * 4.8037997
        returnDict['tbsp'] = value * 307.4431809
        returnDict['tsp'] = value * 922.3295428
        returnDict['toe'] = value * 0.0038992
    elif units == 'kL':
        returnDict['bbl'] = value * 6.28981056977507
        returnDict['bucket'] = value * 52.83429579808846
        returnDict['bu_us'] = value * 28.377569234174537
        returnDict['cm3'] = value * 1000000.0
        returnDict['ft3'] = value * 35.31472482766414
        returnDict['in3'] = value * 60975.60975609757
        returnDict['m3'] = value
        returnDict['mm3'] = value * 999999999.9999999
        returnDict['yd3'] = value * 1.307950547436162
        returnDict['C'] = value * 4226.542688081149
        returnDict['dr'] = value * 270270.27027027024
        returnDict['drum'] = value * 4.8031293348242246
        returnDict['fl oz'] = value * 33783.78378378378
        returnDict['gal_us'] = value * 264.1728747292228
        returnDict['gill'] = value * 8453.085376162298
        returnDict['gal_uk'] = value * 219.96876443545017
        returnDict['kL'] = value
        returnDict['L'] = value * 1000.0
        returnDict['ml'] = value * 1000000.0
        returnDict['Pt'] = value * 2113.3764189
        returnDict['qt_dr'] = value * 908.0829783
        returnDict['qt_lq'] = value * 1056.6882094
        returnDict['tbsp'] = value * 67628.0454035
        returnDict['tsp'] = value * 202884.1362104
        returnDict['toe'] = value * 0.8577015
    elif units == 'L':
        returnDict['bbl'] = value * 0.006289810771539834
        returnDict['bucket'] = value * 0.052834410527459186
        returnDict['bu_us'] = value * 0.028377593231730613
        returnDict['cm3'] = value * 1000.0
        returnDict['ft3'] = value * 0.03531466671151158
        returnDict['in3'] = value * 61.02361003472243
        returnDict['m3'] = value * 0.001
        returnDict['mm3'] = value * 1000000.0
        returnDict['yd3'] = value * 0.0013079506192870205
        returnDict['C'] = value * 4.226753489819019
        returnDict['dr'] = value * 270.5115373170666
        returnDict['drum'] = value * 0.004803128225155008
        returnDict['fl oz'] = value * 33.81405650328842
        returnDict['gal_us'] = value * 0.26417205124155846
        returnDict['gill'] = value * 8.453506979638037
        returnDict['gal_uk'] = value * 0.21996924829908776
        returnDict['kL'] = value * 0.001
        returnDict['L'] = value
        returnDict['ml'] = value * 1000.0
        returnDict['Pt'] = value * 2.1133764
        returnDict['qt_dr'] = value * 0.908083
        returnDict['qt_lq'] = value * 1.0566882
        returnDict['tbsp'] = value * 67.6280454
        returnDict['tsp'] = value * 202.8841362
        returnDict['toe'] = value * 0.0008577
    elif units == 'ml':
        returnDict['bbl'] = value * 6.289810770412325e-06
        returnDict['bucket'] = value * 5.2834410471350536e-05
        returnDict['bu_us'] = value * 2.8377593225288316e-05
        returnDict['cm3'] = value
        returnDict['ft3'] = value * 3.5314666721488586e-05
        returnDict['in3'] = value * 0.06102374409473229
        returnDict['m3'] = value * 1e-06
        returnDict['mm3'] = value * 1000.0
        returnDict['yd3'] = value * 1.3079506193143923e-06
        returnDict['C'] = value * 0.004226752837730375
        returnDict['dr'] = value * 0.27051218127172755
        returnDict['drum'] = value * 4.803128224677458e-06
        returnDict['fl oz'] = value * 0.03381402265896594
        returnDict['gal_us'] = value * 0.00026417205235814843
        returnDict['gill'] = value * 0.008453505671887662
        returnDict['gal_uk'] = value * 0.0002199692482990878
        returnDict['kL'] = value * 1e-06
        returnDict['L'] = value * 0.001
        returnDict['ml'] = value
        returnDict['Pt'] = value * 0.0021134
        returnDict['qt_dr'] = value * 0.0009081
        returnDict['qt_lq'] = value * 0.0010567
        returnDict['tbsp'] = value * 0.067628
        returnDict['tsp'] = value * 0.2028841
        returnDict['toe'] = value * 8.577015e-07
    elif units == 'Pt':
        returnDict['bbl'] = value * 0.002976190476190476
        returnDict['bucket'] = value * 0.025
        returnDict['bu_us'] = value * 0.013427609474628665
        returnDict['cm3'] = value * 473.17119333774957
        returnDict['ft3'] = value * 0.016710069456773922
        returnDict['in3'] = value * 28.87502887502887
        returnDict['m3'] = value * 0.00047317647299220563
        returnDict['mm3'] = value * 473176.47296981595
        returnDict['yd3'] = value * 0.0006188914609023652
        returnDict['C'] = value * 2.0
        returnDict['dr'] = value * 128.0
        returnDict['drum'] = value * 0.0022727272727272726
        returnDict['fl oz'] = value * 16.0
        returnDict['gal_us'] = value * 0.125
        returnDict['gill'] = value * 4.0
        returnDict['gal_uk'] = value * 0.10408427312237853
        returnDict['kL'] = value * 0.00047317647299220563
        returnDict['L'] = value * 0.47317647722383954
        returnDict['ml'] = value * 473.17119333774957
        returnDict['Pt'] = value
        returnDict['qt_dr'] = value * 0.4296835
        returnDict['qt_lq'] = value * 0.5
        returnDict['tbsp'] = value * 32.0
        returnDict['tsp'] = value * 96.0
        returnDict['toe'] = value * 0.0004058
    elif units == 'qt_dr':
        returnDict['bbl'] = value * 0.006926471391166119
        returnDict['bucket'] = value * 0.05818235980669493
        returnDict['bu_us'] = value * 0.0312500001953125
        returnDict['cm3'] = value * 1101.2003083360862
        returnDict['ft3'] = value * 0.03888925081818317
        returnDict['in3'] = value * 67.2006881350465
        returnDict['m3'] = value * 0.0011012209499533573
        returnDict['mm3'] = value * 1101220.9503171637
        returnDict['yd3'] = value * 0.001440342623518049
        returnDict['C'] = value * 4.654587701276009
        returnDict['dr'] = value * 297.8938901963121
        returnDict['drum'] = value * 0.005289305425781566
        returnDict['fl oz'] = value * 37.23673627453901
        returnDict['gal_us'] = value * 0.29091179903347464
        returnDict['gill'] = value * 9.309175402552018
        returnDict['gal_uk'] = value * 0.24223474731972705
        returnDict['kL'] = value * 0.0011012209499533573
        returnDict['L'] = value * 1.1012209236380375
        returnDict['ml'] = value * 1101.2003083360862
        returnDict['Pt'] = value * 2.327294392267797
        returnDict['qt_dr'] = value
        returnDict['qt_lq'] = value * 1.1636472
        returnDict['tbsp'] = value * 74.4734204
        returnDict['tsp'] = value * 223.4202612
        returnDict['toe'] = value * 0.0009445
    elif units == 'qt_lq':
        returnDict['bbl'] = value * 0.005952380952380952
        returnDict['bucket'] = value * 0.05
        returnDict['bu_us'] = value * 0.02685521894925733
        returnDict['cm3'] = value * 946.3423866754991
        returnDict['ft3'] = value * 0.033420138913547844
        returnDict['in3'] = value * 57.75005775005774
        returnDict['m3'] = value * 0.0009463529460291903
        returnDict['mm3'] = value * 946352.9463874238
        returnDict['yd3'] = value * 0.0012377829218047304
        returnDict['C'] = value * 4.0
        returnDict['dr'] = value * 255.99672324194253
        returnDict['drum'] = value * 0.004545454545454545
        returnDict['fl oz'] = value * 32.0
        returnDict['gal_us'] = value * 0.25
        returnDict['gill'] = value * 8.0
        returnDict['gal_uk'] = value * 0.20816854624475706
        returnDict['kL'] = value * 0.0009463529460291903
        returnDict['L'] = value * 0.9463529544476791
        returnDict['ml'] = value * 946.3423866754991
        returnDict['Pt'] = value * 2.0
        returnDict['qt_dr'] = value * 0.8593669971448391
        returnDict['qt_lq'] = value
        returnDict['tbsp'] = value * 64.0
        returnDict['tsp'] = value * 192.0
        returnDict['toe'] = value * 0.0008117
    elif units == 'tbsp':
        returnDict['bbl'] = value * 9.300595238095238e-05
        returnDict['bucket'] = value * 0.00078125
        returnDict['bu_us'] = value * 0.00041961279608214577
        returnDict['cm3'] = value * 14.78677470870054
        returnDict['ft3'] = value * 0.0005221896701424302
        returnDict['in3'] = value * 0.9023437566970826
        returnDict['m3'] = value * 1.4786764781290667e-05
        returnDict['mm3'] = value * 14792.899408284024
        returnDict['yd3'] = value * 1.934035815334853e-05
        returnDict['C'] = value * 0.0625
        returnDict['dr'] = value * 4.0
        returnDict['drum'] = value * 7.102272727272727e-05
        returnDict['fl oz'] = value * 0.5
        returnDict['gal_us'] = value * 0.00390625
        returnDict['gill'] = value * 0.125
        returnDict['gal_uk'] = value * 0.0032526335340163663
        returnDict['kL'] = value * 1.4786764781290667e-05
        returnDict['L'] = value * 0.014786764782055936
        returnDict['ml'] = value * 14.78677470870054
        returnDict['Pt'] = value * 0.03125
        returnDict['qt_dr'] = value * 0.01342760940250839
        returnDict['qt_lq'] = value * 0.015625
        returnDict['tbsp'] = value
        returnDict['tsp'] = value * 3.0
        returnDict['toe'] = value * 1.27e-05
    elif units == 'tsp':
        returnDict['bbl'] = value * 3.1001984126984125e-05
        returnDict['bucket'] = value * 0.00026041666666666666
        returnDict['bu_us'] = value * 0.00013987093202738192
        returnDict['cm3'] = value * 4.928922473471307
        returnDict['ft3'] = value * 0.00017406322338081007
        returnDict['in3'] = value * 0.30078125223236085
        returnDict['m3'] = value * 4.928921593765985e-06
        returnDict['mm3'] = value * 4928.536224741252
        returnDict['yd3'] = value * 6.446786051120333e-06
        returnDict['C'] = value * 0.020833333333333332
        returnDict['dr'] = value * 1.3333333333333333
        returnDict['drum'] = value * 2.3674242424242424e-05
        returnDict['fl oz'] = value * 0.16666666666666666
        returnDict['gal_us'] = value * 0.0013020833333333333
        returnDict['gill'] = value * 0.041666666666666664
        returnDict['gal_uk'] = value * 0.001084211177887904
        returnDict['kL'] = value * 4.928921593765985e-06
        returnDict['L'] = value * 0.004928921594018645
        returnDict['ml'] = value * 4.928922473471307
        returnDict['Pt'] = value * 0.010416666666666666
        returnDict['qt_dr'] = value * 0.0044758698008361296
        returnDict['qt_lq'] = value * 0.005208333333333333
        returnDict['tbsp'] = value * 0.3333333333333333
        returnDict['tsp'] = value
        returnDict['toe'] = value * 4.2e-06
    elif units == 'toe':
        returnDict['bbl'] = value * 7.33333528888941
        returnDict['bucket'] = value * 61.599871872266505
        returnDict['bu_us'] = value * 33.085632233346345
        returnDict['cm3'] = value * 1165907.4665880068
        returnDict['ft3'] = value * 41.17361265512159
        returnDict['in3'] = value * 70921.98581560283
        returnDict['m3'] = value * 1.1659067869182926
        returnDict['mm3'] = value * 1165906786.9182928
        returnDict['yd3'] = value * 1.524948616856355
        returnDict['C'] = value * 4928.536224741252
        returnDict['dr'] = value * 312500.0
        returnDict['drum'] = value * 5.600000896000144
        returnDict['fl oz'] = value * 39370.07874015748
        returnDict['gal_us'] = value * 307.9955648638659
        returnDict['gill'] = value * 9852.216748768473
        returnDict['gal_uk'] = value * 256.46286417726714
        returnDict['kL'] = value * 1.1659067869182926
        returnDict['L'] = value * 1165.9088259298123
        returnDict['ml'] = value * 1165906.7869182928
        returnDict['Pt'] = value * 2464.268112370626
        returnDict['qt_dr'] = value * 1058.7612493382742
        returnDict['qt_lq'] = value * 1231.9822594554637
        returnDict['tbsp'] = value * 78740.15748031496
        returnDict['tsp'] = value * 238095.2380952381
        returnDict['toe'] = value
    return returnDict


def weight(value, units):
    returnDict = {}
    if units == 'ct':
        returnDict['ct'] = value
        returnDict['cg'] = value * 20.0
        returnDict['dg'] = value * 2.0
        returnDict['dram'] = value * 0.1128767
        returnDict['gr'] = value * 3.0864721
        returnDict['g'] = value * 0.2
        returnDict['kg'] = value * 0.0002
        returnDict['kip'] = value * 4.4092452436976e-07
        returnDict['t_long'] = value * 1.96841e-07
        returnDict['t_metric'] = value * 2e-07
        returnDict['mg'] = value * 200.0
        returnDict['oz'] = value * 0.0070548
        returnDict['lb'] = value * 0.0004409
        returnDict['slug'] = value * 1.37e-05
        returnDict['t_short'] = value * 2.20462e-07
        returnDict['toz'] = value * 0.0064301
        returnDict['KdaN'] = value * 1.7792886548080459e-07
        returnDict['daN'] = value * 0.00017792886453104416
    elif units == 'cg':
        returnDict['ct'] = value * 0.05
        returnDict['cg'] = value
        returnDict['dg'] = value * 0.1
        returnDict['dram'] = value * 0.0056438
        returnDict['gr'] = value * 0.1543236
        returnDict['g'] = value * 0.01
        returnDict['kg'] = value * 1e-05
        returnDict['kip'] = value * 2.2046226e-08
        returnDict['t_long'] = value * 9.84207e-09
        returnDict['t_metric'] = value * 1e-08
        returnDict['mg'] = value * 10.0
        returnDict['oz'] = value * 0.00035274
        returnDict['lb'] = value * 2.20462e-05
        returnDict['slug'] = value * 6.85218e-07
        returnDict['t_short'] = value * 1.102311e-08
        returnDict['toz'] = value * 0.0003215
        returnDict['KdaN'] = value * 8.89644327404023e-09
        returnDict['daN'] = value * 8.896443226552209e-06
    elif units == 'dg':
        returnDict['ct'] = value * 0.5
        returnDict['cg'] = value * 10.0
        returnDict['dg'] = value
        returnDict['dram'] = value * 0.056438
        returnDict['gr'] = value * 1.543236
        returnDict['g'] = value * 0.1
        returnDict['kg'] = value * 0.0001
        returnDict['kip'] = value * 2.2046226e-07
        returnDict['t_long'] = value * 9.84207e-08
        returnDict['t_metric'] = value * 1e-07
        returnDict['mg'] = value * 100.0
        returnDict['oz'] = value * 0.0035274
        returnDict['lb'] = value * 0.000220462
        returnDict['slug'] = value * 6.85218e-06
        returnDict['t_short'] = value * 1.1023110000000001e-07
        returnDict['toz'] = value * 0.003215
        returnDict['KdaN'] = value * 8.896443274040229e-08
        returnDict['daN'] = value * 8.896443226552208e-05
    elif units == 'dram':
        returnDict['ct'] = value * 8.859226
        returnDict['cg'] = value * 177.18452
        returnDict['dg'] = value * 17.718452
        returnDict['dram'] = value
        returnDict['gr'] = value * 27.3437543
        returnDict['g'] = value * 1.7718452
        returnDict['kg'] = value * 0.0017718
        returnDict['kip'] = value * 3.9e-06
        returnDict['t_long'] = value * 1.7e-06
        returnDict['t_metric'] = value * 1.8e-06
        returnDict['mg'] = value * 1771.8452
        returnDict['oz'] = value * 0.0625
        returnDict['lb'] = value * 0.0039063
        returnDict['slug'] = value * 0.0001214
        returnDict['t_short'] = value * 2e-06
        returnDict['toz'] = value * 0.0569661
        returnDict['KdaN'] = value * 1.6013597893272412e-06
        returnDict['daN'] = value * 0.0016013597807793974
    elif units == 'gr':
        returnDict['ct'] = value * 0.3239945
        returnDict['cg'] = value * 6.47989
        returnDict['dg'] = value * 0.647989
        returnDict['dram'] = value * 0.0365714
        returnDict['gr'] = value
        returnDict['g'] = value * 0.0647989
        returnDict['kg'] = value * 6.48e-05
        returnDict['kip'] = value * 1.42857e-07
        returnDict['t_long'] = value * 6.37755e-08
        returnDict['t_metric'] = value * 6.47989e-08
        returnDict['mg'] = value * 64.7989
        returnDict['oz'] = value * 0.0022857
        returnDict['lb'] = value * 0.0001429
        returnDict['slug'] = value * 4.4e-06
        returnDict['t_short'] = value * 7.14286e-08
        returnDict['toz'] = value * 0.0020833
        returnDict['KdaN'] = value * 5.764797380702055e-08
        returnDict['daN'] = value * 5.764797349930339e-05
    elif units == 'g':
        returnDict['ct'] = value * 5.0
        returnDict['cg'] = value * 100.0
        returnDict['dg'] = value * 10.0
        returnDict['dram'] = value * 0.56438
        returnDict['gr'] = value * 15.432360000000001
        returnDict['g'] = value
        returnDict['kg'] = value * 0.001
        returnDict['kip'] = value * 2.2046226e-06
        returnDict['t_long'] = value * 9.84207e-07
        returnDict['t_metric'] = value * 1e-06
        returnDict['mg'] = value * 1000.0
        returnDict['oz'] = value * 0.035274
        returnDict['lb'] = value * 0.00220462
        returnDict['slug'] = value * 6.85218e-05
        returnDict['t_short'] = value * 1.1023110000000001e-06
        returnDict['toz'] = value * 0.03215
        returnDict['KdaN'] = value * 8.89644327404023e-07
        returnDict['daN'] = value * 0.0008896443226552208
    elif units == 'kg':
        returnDict['ct'] = value * 5000.0
        returnDict['cg'] = value * 100000.0
        returnDict['dg'] = value * 10000.0
        returnDict['dram'] = value * 564.38
        returnDict['gr'] = value * 15432.36
        returnDict['g'] = value * 1000.0
        returnDict['kg'] = value
        returnDict['kip'] = value * 0.0022046226
        returnDict['t_long'] = value * 0.000984207
        returnDict['t_metric'] = value * 0.001
        returnDict['mg'] = value * 1000000.0
        returnDict['oz'] = value * 35.274
        returnDict['lb'] = value * 2.20462
        returnDict['slug'] = value * 0.06852180000000001
        returnDict['t_short'] = value * 0.0011023110000000001
        returnDict['toz'] = value * 32.15
        returnDict['KdaN'] = value * 0.000889644327404023
        returnDict['daN'] = value * 0.8896443226552208
    elif units == 'kip':
        returnDict['ct'] = value * 2267961.85
        returnDict['cg'] = value * 45359237.0
        returnDict['dg'] = value * 4535923.7
        returnDict['dram'] = value * 255999.9993227
        returnDict['gr'] = value * 7000001.0802653
        returnDict['g'] = value * 453592.37
        returnDict['kg'] = value * 453.59237
        returnDict['kip'] = value
        returnDict['t_long'] = value * 0.4464286
        returnDict['t_metric'] = value * 0.4535924
        returnDict['mg'] = value * 453592370.0
        returnDict['oz'] = value * 16000.0
        returnDict['lb'] = value * 1000.0
        returnDict['slug'] = value * 31.08095
        returnDict['t_short'] = value * 0.5
        returnDict['toz'] = value * 14583.3333333
        returnDict['KdaN'] = value * 0.40353590561357655
        returnDict['daN'] = value * 403.535903459556
    elif units == 't_long':
        returnDict['ct'] = value * 5080234.544
        returnDict['cg'] = value * 101604690.88
        returnDict['dg'] = value * 10160469.088
        returnDict['dram'] = value * 573439.9984829
        returnDict['gr'] = value * 15680002.4197942
        returnDict['g'] = value * 1016046.9088
        returnDict['kg'] = value * 1016.0469088
        returnDict['kip'] = value * 2.24
        returnDict['t_long'] = value
        returnDict['t_metric'] = value * 1.0160469
        returnDict['mg'] = value * 1016046908.8
        returnDict['oz'] = value * 35840.0
        returnDict['lb'] = value * 2240.0
        returnDict['slug'] = value * 69.6213281
        returnDict['t_short'] = value * 1.12
        returnDict['toz'] = value * 32666.6666667
        returnDict['KdaN'] = value * 0.9039203609614427
        returnDict['daN'] = value * 903.9203561364369
    elif units == 't_metric':
        returnDict['ct'] = value * 5000000.0
        returnDict['cg'] = value * 100000000.0
        returnDict['dg'] = value * 10000000.0
        returnDict['dram'] = value * 564383.3897002
        returnDict['gr'] = value * 15432360.7345186
        returnDict['g'] = value * 1000000.0
        returnDict['kg'] = value * 1000.0
        returnDict['kip'] = value * 2.2046226
        returnDict['t_long'] = value * 0.9842065
        returnDict['t_metric'] = value
        returnDict['mg'] = value * 1000000000.0
        returnDict['oz'] = value * 35273.9619496
        returnDict['lb'] = value * 2204.6226218
        returnDict['slug'] = value * 68.5217656
        returnDict['t_short'] = value * 1.1023113
        returnDict['toz'] = value * 32150.7465686
        returnDict['KdaN'] = value * 0.889644327404023
        returnDict['daN'] = value * 889.6443226552208
    elif units == 'mg':
        returnDict['ct'] = value * 0.005
        returnDict['cg'] = value * 0.1
        returnDict['dg'] = value * 0.01
        returnDict['dram'] = value * 0.0005644
        returnDict['gr'] = value * 0.0154324
        returnDict['g'] = value * 0.001
        returnDict['kg'] = value * 1e-06
        returnDict['kip'] = value * 2.2046226218488e-09
        returnDict['t_long'] = value * 9.84207e-10
        returnDict['t_metric'] = value * 1e-09
        returnDict['mg'] = value
        returnDict['oz'] = value * 3.53e-05
        returnDict['lb'] = value * 2.2e-06
        returnDict['slug'] = value * 6.85218e-08
        returnDict['t_short'] = value * 1.10231e-09
        returnDict['toz'] = value * 3.22e-05
        returnDict['KdaN'] = value * 8.89644327404023e-10
        returnDict['daN'] = value * 8.896443226552208e-07
    elif units == 'oz':
        returnDict['ct'] = value * 141.7476156
        returnDict['cg'] = value * 2834.9523125
        returnDict['dg'] = value * 283.4952313
        returnDict['dram'] = value * 16.0
        returnDict['gr'] = value * 437.5000675
        returnDict['g'] = value * 28.3495231
        returnDict['kg'] = value * 0.0283495
        returnDict['kip'] = value * 6.25e-05
        returnDict['t_long'] = value * 2.7902e-05
        returnDict['t_metric'] = value * 2.83495e-05
        returnDict['mg'] = value * 28349.523125
        returnDict['oz'] = value
        returnDict['lb'] = value * 0.0625
        returnDict['slug'] = value * 0.00194256
        returnDict['t_short'] = value * 3.125024e-05
        returnDict['toz'] = value * 0.9114583
        returnDict['KdaN'] = value * 2.5220971859740348e-05
        returnDict['daN'] = value * 0.025220971725114182
    elif units == 'lb':
        returnDict['ct'] = value * 2267.96185
        returnDict['cg'] = value * 45359.237
        returnDict['dg'] = value * 4535.9237
        returnDict['dram'] = value * 255.9999993
        returnDict['gr'] = value * 7000.0010803
        returnDict['g'] = value * 453.59237
        returnDict['kg'] = value * 0.4535924
        returnDict['kip'] = value * 0.001
        returnDict['t_long'] = value * 0.0004464
        returnDict['t_metric'] = value * 0.0004536
        returnDict['mg'] = value * 453592.37
        returnDict['oz'] = value * 16.0
        returnDict['lb'] = value
        returnDict['slug'] = value * 0.031081
        returnDict['t_short'] = value * 0.0005
        returnDict['toz'] = value * 14.5833333
        returnDict['KdaN'] = value * 0.00040354266691046485
        returnDict['daN'] = value * 0.40354266475640815
    elif units == 'slug':
        returnDict['ct'] = value * 72969.515
        returnDict['cg'] = value * 1459390.3
        returnDict['dg'] = value * 145939.03
        returnDict['dram'] = value * 8236.5564441
        returnDict['gr'] = value * 225218.3756206
        returnDict['g'] = value * 14593.903
        returnDict['kg'] = value * 14.593903
        returnDict['kip'] = value * 0.032174
        returnDict['t_long'] = value * 0.0143634
        returnDict['t_metric'] = value * 0.0145939
        returnDict['mg'] = value * 14593903.0
        returnDict['oz'] = value * 514.7847791
        returnDict['lb'] = value * 32.1740487
        returnDict['slug'] = value
        returnDict['t_short'] = value * 32.1740487
        returnDict['toz'] = value * 469.2048768
        returnDict['KdaN'] = value * 0.01298338034970157
        returnDict['daN'] = value * 12.983380280398027
    elif units == 't_short':
        returnDict['ct'] = value * 4535923.7
        returnDict['cg'] = value * 90718474.0
        returnDict['dg'] = value * 9071847.4
        returnDict['dram'] = value * 511999.9986455
        returnDict['gr'] = value * 14000002.1605305
        returnDict['g'] = value * 907184.74
        returnDict['kg'] = value * 907.18474
        returnDict['kip'] = value * 2.0
        returnDict['t_long'] = value * 0.8928571
        returnDict['t_metric'] = value * 0.9071847
        returnDict['mg'] = value * 907184740.0
        returnDict['oz'] = value * 32000.0
        returnDict['lb'] = value * 2000.0
        returnDict['slug'] = value * 62.1619001
        returnDict['t_short'] = value
        returnDict['toz'] = value * 29166.6666667
        returnDict['KdaN'] = value * 0.8070717222627203
        returnDict['daN'] = value * 807.0717179546796
    elif units == 'toz':
        returnDict['ct'] = value * 155.517384
        returnDict['cg'] = value * 3110.34768
        returnDict['dg'] = value * 311.034768
        returnDict['dram'] = value * 17.5542857
        returnDict['gr'] = value * 480.0000741
        returnDict['g'] = value * 31.1034768
        returnDict['kg'] = value * 0.0311035
        returnDict['kip'] = value * 6.86e-05
        returnDict['t_long'] = value * 3.06e-05
        returnDict['t_metric'] = value * 3.11e-05
        returnDict['mg'] = value * 31103.4768
        returnDict['oz'] = value * 1.0971429
        returnDict['lb'] = value * 0.0685714
        returnDict['slug'] = value * 0.0021313
        returnDict['t_short'] = value * 3.43e-05
        returnDict['toz'] = value
        returnDict['KdaN'] = value * 2.7667938582265112e-05
        returnDict['daN'] = value * 0.027667938434577363
    elif units == 'KdaN':
        returnDict['ct'] = value * 5620223.55
        returnDict['cg'] = value * 112404471.0
        returnDict['dg'] = value * 11240447.1
        returnDict['dram'] = value * 634392.1636044
        returnDict['gr'] = value * 17346663.4464474
        returnDict['g'] = value * 1124044.71
        returnDict['kg'] = value * 1124.04471
        returnDict['kip'] = value * 2.4780944
        returnDict['t_long'] = value * 1.1062921
        returnDict['t_metric'] = value * 1.12404471
        returnDict['mg'] = value * 1124044710.0
        returnDict['oz'] = value * 39649.5103302
        returnDict['lb'] = value * 2478.0943956
        returnDict['slug'] = value * 77.0215281
        returnDict['t_short'] = value * 1.2390472
        returnDict['toz'] = value * 36138.876603
        returnDict['KdaN'] = value
        returnDict['daN'] = value * 999.999994662134
    elif units == 'daN':
        returnDict['ct'] = value * 5620.2
        returnDict['cg'] = value * 112404.0
        returnDict['dg'] = value * 11240.4
        returnDict['dram'] = value * 634.3895054
        returnDict['gr'] = value * 17346.59076
        returnDict['g'] = value * 1124.04
        returnDict['kg'] = value * 1.12404
        returnDict['kip'] = value * 0.0024781
        returnDict['t_long'] = value * 0.0011063
        returnDict['t_metric'] = value * 0.001124044716
        returnDict['mg'] = value * 1124040.0
        returnDict['oz'] = value * 39.6493442
        returnDict['lb'] = value * 2.478084
        returnDict['slug'] = value * 0.0770212
        returnDict['t_short'] = value * 0.001239
        returnDict['toz'] = value * 36.1387252
        returnDict['KdaN'] = value * 0.001000000005337866
        returnDict['daN'] = value
    return returnDict


def flowrate_mass(value, units):
    returnDict = {}
    if units == 'g/day':
        returnDict['g/day'] = value
        returnDict['kg/day'] = value * 0.001
        returnDict['lb/day'] = value * 0.0022046223
        returnDict['ton/day(l)'] = value * 9.842065e-07
        returnDict['ton/day(m)'] = value * 1e-06
        returnDict['ton/day(s)'] = value * 1.1023e-06
        returnDict['g/hr'] = value * 0.0416666667
        returnDict['kg/hr'] = value * 4.16667e-05
        returnDict['lb/hr'] = value * 9.18593e-05
        returnDict['ton/hr(l)'] = value * 4.1008604167e-08
        returnDict['ton/hr(m)'] = value * 4.1666666667e-08
        returnDict['ton/hr(s)'] = value * 4.5929625e-08
        returnDict['g/min'] = value * 0.0006944444
        returnDict['kg/min'] = value * 6.9444444444e-07
        returnDict['lb/min'] = value * 1.531e-06
        returnDict['ton/min(l)'] = value * 6.8347673611e-10
        returnDict['ton/min(m)'] = value * 6.9444444444e-10
        returnDict['ton/min(s)'] = value * 7.6549375e-10
        returnDict['g/sec'] = value * 1.15741e-05
        returnDict['kg/sec'] = value * 1.1574074074e-08
        returnDict['lb/sec'] = value * 2.5516462269e-08
        returnDict['ton/sec(l)'] = value * 1.1391278935e-11
        returnDict['ton/sec(m)'] = value * 1.1574074074e-11
        returnDict['ton/sec(s)'] = value * 1.2758229167e-11
    elif units == 'kg/day':
        returnDict['g/day'] = value * 1000.0
        returnDict['kg/day'] = value
        returnDict['lb/day'] = value * 2.20462234
        returnDict['ton/day(l)'] = value * 0.0009842065
        returnDict['ton/day(m)'] = value * 0.001
        returnDict['ton/day(s)'] = value * 0.001102311
        returnDict['g/hr'] = value * 41.666666667
        returnDict['kg/hr'] = value * 0.0416666667
        returnDict['lb/hr'] = value * 0.0918592642
        returnDict['ton/hr(l)'] = value * 4.10086e-05
        returnDict['ton/hr(m)'] = value * 4.16667e-05
        returnDict['ton/hr(s)'] = value * 4.59296e-05
        returnDict['g/min'] = value * 0.6944444444
        returnDict['kg/min'] = value * 0.0006944444
        returnDict['lb/min'] = value * 0.0015309877
        returnDict['ton/min(l)'] = value * 6.8347673611e-07
        returnDict['ton/min(m)'] = value * 6.9444444444e-07
        returnDict['ton/min(s)'] = value * 7.6549375e-07
        returnDict['g/sec'] = value * 0.0115740741
        returnDict['kg/sec'] = value * 1.15741e-05
        returnDict['lb/sec'] = value * 2.55165e-05
        returnDict['ton/sec(l)'] = value * 1.1391278935e-08
        returnDict['ton/sec(m)'] = value * 1.1574074074e-08
        returnDict['ton/sec(s)'] = value * 1.2758229167e-08
    elif units == 'lb/day':
        returnDict['g/day'] = value * 453.59242799
        returnDict['kg/day'] = value * 0.453592428
        returnDict['lb/day'] = value
        returnDict['ton/day(l)'] = value * 0.0004464286
        returnDict['ton/day(m)'] = value * 0.0004535924
        returnDict['ton/day(s)'] = value * 0.0004999999
        returnDict['g/hr'] = value * 18.8996845
        returnDict['kg/hr'] = value * 0.0188996845
        returnDict['lb/hr'] = value * 0.0416666667
        returnDict['ton/hr(l)'] = value * 1.86012e-05
        returnDict['ton/hr(m)'] = value * 1.88997e-05
        returnDict['ton/hr(s)'] = value * 2.08333e-05
        returnDict['g/min'] = value * 0.3149947417
        returnDict['kg/min'] = value * 0.0003149947
        returnDict['lb/min'] = value * 0.0006944444
        returnDict['ton/min(l)'] = value * 3.1001987221e-07
        returnDict['ton/min(m)'] = value * 3.1499474166e-07
        returnDict['ton/min(s)'] = value * 3.4722216867e-07
        returnDict['g/sec'] = value * 0.0052499124
        returnDict['kg/sec'] = value * 5.2499e-06
        returnDict['lb/sec'] = value * 1.15741e-05
        returnDict['ton/sec(l)'] = value * 5.1669978701e-09
        returnDict['ton/sec(m)'] = value * 5.249912361e-09
        returnDict['ton/sec(s)'] = value * 5.7870361446e-09
    elif units == 'ton/day(l)':
        returnDict['g/day'] = value * 1016046.9373
        returnDict['kg/day'] = value * 1016.0469373
        returnDict['lb/day'] = value * 2239.9997765
        returnDict['ton/day(l)'] = value
        returnDict['ton/day(m)'] = value * 1.0160469373
        returnDict['ton/day(s)'] = value * 1.1199997155
        returnDict['g/hr'] = value * 42335.289054
        returnDict['kg/hr'] = value * 42.335289054
        returnDict['lb/hr'] = value * 93.33332402
        returnDict['ton/hr(l)'] = value * 0.0416666667
        returnDict['ton/hr(m)'] = value * 0.0423352891
        returnDict['ton/hr(s)'] = value * 0.0466666548
        returnDict['g/min'] = value * 705.58815091
        returnDict['kg/min'] = value * 0.7055881509
        returnDict['lb/min'] = value * 1.5555554003
        returnDict['ton/min(l)'] = value * 0.0006944444
        returnDict['ton/min(m)'] = value * 0.0007055882
        returnDict['ton/min(s)'] = value * 0.0007777776
        returnDict['g/sec'] = value * 11.759802515
        returnDict['kg/sec'] = value * 0.0117598025
        returnDict['lb/sec'] = value * 0.0259259233
        returnDict['ton/sec(l)'] = value * 1.15741e-05
        returnDict['ton/sec(m)'] = value * 1.17598e-05
        returnDict['ton/sec(s)'] = value * 1.2963e-05
    elif units == 'ton/day(m)':
        returnDict['g/day'] = value * 1000000.0
        returnDict['kg/day'] = value * 1000.0
        returnDict['lb/day'] = value * 2204.62234
        returnDict['ton/day(l)'] = value * 0.9842065
        returnDict['ton/day(m)'] = value
        returnDict['ton/day(s)'] = value * 1.102311
        returnDict['g/hr'] = value * 41666.666667
        returnDict['kg/hr'] = value * 41.6666667
        returnDict['lb/hr'] = value * 91.859264167
        returnDict['ton/hr(l)'] = value * 0.0410086042
        returnDict['ton/hr(m)'] = value * 0.0416666667
        returnDict['ton/hr(s)'] = value * 0.045929625
        returnDict['g/min'] = value * 694.44444444
        returnDict['kg/min'] = value * 0.6944444444
        returnDict['lb/min'] = value * 1.5309877361
        returnDict['ton/min(l)'] = value * 0.0006834767
        returnDict['ton/min(m)'] = value * 0.0006944444
        returnDict['ton/min(s)'] = value * 0.0007654937
        returnDict['g/sec'] = value * 11.574074074
        returnDict['kg/sec'] = value * 0.0115740741
        returnDict['lb/sec'] = value * 0.0255164623
        returnDict['ton/sec(l)'] = value * 1.13913e-05
        returnDict['ton/sec(m)'] = value * 1.15741e-05
        returnDict['ton/sec(s)'] = value * 1.27582e-05
    elif units == 'ton/day(s)':
        returnDict['g/day'] = value * 907184.99589
        returnDict['kg/day'] = value * 907.18499589
        returnDict['lb/day'] = value * 2000.0003084
        returnDict['ton/day(l)'] = value * 0.8928573697
        returnDict['ton/day(m)'] = value * 0.9071849959
        returnDict['ton/day(s)'] = value
        returnDict['g/hr'] = value * 37799.374829
        returnDict['kg/hr'] = value * 37.799374829
        returnDict['lb/hr'] = value * 83.333346185
        returnDict['ton/hr(l)'] = value * 0.0372023904
        returnDict['ton/hr(m)'] = value * 0.0377993748
        returnDict['ton/hr(s)'] = value * 0.0416666667
        returnDict['g/min'] = value * 629.98958048
        returnDict['kg/min'] = value * 0.6299895805
        returnDict['lb/min'] = value * 1.3888891031
        returnDict['ton/min(l)'] = value * 0.0006200398
        returnDict['ton/min(m)'] = value * 0.0006299896
        returnDict['ton/min(s)'] = value * 0.0006944444
        returnDict['g/sec'] = value * 10.499826341
        returnDict['kg/sec'] = value * 0.0104998263
        returnDict['lb/sec'] = value * 0.0231481517
        returnDict['ton/sec(l)'] = value * 1.0334e-05
        returnDict['ton/sec(m)'] = value * 1.04998e-05
        returnDict['ton/sec(s)'] = value * 1.15741e-05
    elif units == 'g/hr':
        returnDict['g/day'] = value * 24.0
        returnDict['kg/day'] = value * 0.024
        returnDict['lb/day'] = value * 0.0529109362
        returnDict['ton/day(l)'] = value * 2.3621e-05
        returnDict['ton/day(m)'] = value * 2.4e-05
        returnDict['ton/day(s)'] = value * 2.64555e-05
        returnDict['g/hr'] = value
        returnDict['kg/hr'] = value * 0.001
        returnDict['lb/hr'] = value * 0.0022046223416666666
        returnDict['ton/hr(l)'] = value * 9.842083333333334e-07
        returnDict['ton/hr(m)'] = value * 1e-06
        returnDict['ton/hr(s)'] = value * 1.1023125e-06
        returnDict['g/min'] = value * 0.016666666666666666
        returnDict['kg/min'] = value * 1.6666666666666667e-05
        returnDict['lb/min'] = value * 3.674370569444444e-05
        returnDict['ton/min(l)'] = value * 1.6403472222222223e-08
        returnDict['ton/min(m)'] = value * 1.6666666666666667e-08
        returnDict['ton/min(s)'] = value * 1.8371875e-08
        returnDict['g/sec'] = value * 0.0002777777777777778
        returnDict['kg/sec'] = value * 2.777777777777778e-07
        returnDict['lb/sec'] = value * 6.123950949074073e-07
        returnDict['ton/sec(l)'] = value * 2.733912037037037e-10
        returnDict['ton/sec(m)'] = value * 2.7777777777777777e-10
        returnDict['ton/sec(s)'] = value * 3.061979166666667e-10
    elif units == 'kg/hr':
        returnDict['g/day'] = value * 24000.0
        returnDict['kg/day'] = value * 24.0
        returnDict['lb/day'] = value * 52.91093616
        returnDict['ton/day(l)'] = value * 0.023620956
        returnDict['ton/day(m)'] = value * 0.024
        returnDict['ton/day(s)'] = value * 0.026455464
        returnDict['g/hr'] = value * 1000.0
        returnDict['kg/hr'] = value
        returnDict['lb/hr'] = value * 2.20462234
        returnDict['ton/hr(l)'] = value * 0.0009842065
        returnDict['ton/hr(m)'] = value * 0.001
        returnDict['ton/hr(s)'] = value * 0.0011023110000000001
        returnDict['g/min'] = value * 16.666666666666668
        returnDict['kg/min'] = value * 0.016666666666666666
        returnDict['lb/min'] = value * 0.03674370566666666
        returnDict['ton/min(l)'] = value * 1.6403441666666668e-05
        returnDict['ton/min(m)'] = value * 1.6666666666666667e-05
        returnDict['ton/min(s)'] = value * 1.8371850000000003e-05
        returnDict['g/sec'] = value * 0.2777777777777778
        returnDict['kg/sec'] = value * 0.0002777777777777778
        returnDict['lb/sec'] = value * 0.0006123950944444443
        returnDict['ton/sec(l)'] = value * 2.7339069444444445e-07
        returnDict['ton/sec(m)'] = value * 2.777777777777778e-07
        returnDict['ton/sec(s)'] = value * 3.0619750000000007e-07
    elif units == 'lb/hr':
        returnDict['g/day'] = value * 10886.218272
        returnDict['kg/day'] = value * 10.886218272
        returnDict['lb/day'] = value * 24.0
        returnDict['ton/day(l)'] = value * 0.0107142868
        returnDict['ton/day(m)'] = value * 0.0108862183
        returnDict['ton/day(s)'] = value * 0.0119999981
        returnDict['g/hr'] = value * 453.592428
        returnDict['kg/hr'] = value * 0.45359242800000005
        returnDict['lb/hr'] = value
        returnDict['ton/hr(l)'] = value * 0.0004464286166666667
        returnDict['ton/hr(m)'] = value * 0.00045359242916666667
        returnDict['ton/hr(s)'] = value * 0.0004999999208333333
        returnDict['g/min'] = value * 7.5598738
        returnDict['kg/min'] = value * 0.007559873800000001
        returnDict['lb/min'] = value * 0.016666666666666666
        returnDict['ton/min(l)'] = value * 7.4404769444444445e-06
        returnDict['ton/min(m)'] = value * 7.559873819444444e-06
        returnDict['ton/min(s)'] = value * 8.333332013888889e-06
        returnDict['g/sec'] = value * 0.12599789666666666
        returnDict['kg/sec'] = value * 0.00012599789666666668
        returnDict['lb/sec'] = value * 0.0002777777777777778
        returnDict['ton/sec(l)'] = value * 1.2400794907407407e-07
        returnDict['ton/sec(m)'] = value * 1.2599789699074075e-07
        returnDict['ton/sec(s)'] = value * 1.3888886689814814e-07
    elif units == 'ton/hr(l)':
        returnDict['g/day'] = value * 24385126.495
        returnDict['kg/day'] = value * 24385.126495
        returnDict['lb/day'] = value * 53759.994635
        returnDict['ton/day(l)'] = value * 24.0
        returnDict['ton/day(m)'] = value * 24.385126495
        returnDict['ton/day(s)'] = value * 26.879993172
        returnDict['g/hr'] = value * 1016046.9372916667
        returnDict['kg/hr'] = value * 1016.0469372916667
        returnDict['lb/hr'] = value * 2239.9997764583336
        returnDict['ton/hr(l)'] = value
        returnDict['ton/hr(m)'] = value * 1.0160469372916667
        returnDict['ton/hr(s)'] = value * 1.1199997154999999
        returnDict['g/min'] = value * 16934.11562152778
        returnDict['kg/min'] = value * 16.934115621527777
        returnDict['lb/min'] = value * 37.333329607638895
        returnDict['ton/min(l)'] = value * 0.016666666666666666
        returnDict['ton/min(m)'] = value * 0.01693411562152778
        returnDict['ton/min(s)'] = value * 0.018666661924999998
        returnDict['g/sec'] = value * 282.2352603587963
        returnDict['kg/sec'] = value * 0.28223526035879626
        returnDict['lb/sec'] = value * 0.6222221601273149
        returnDict['ton/sec(l)'] = value * 0.0002777777777777778
        returnDict['ton/sec(m)'] = value * 0.00028223526035879635
        returnDict['ton/sec(s)'] = value * 0.0003111110320833333
    elif units == 'ton/hr(m)':
        returnDict['g/day'] = value * 24000000.0
        returnDict['kg/day'] = value * 24000.0
        returnDict['lb/day'] = value * 52910.93616
        returnDict['ton/day(l)'] = value * 23.620956
        returnDict['ton/day(m)'] = value * 24.0
        returnDict['ton/day(s)'] = value * 26.455464
        returnDict['g/hr'] = value * 1000000.0
        returnDict['kg/hr'] = value * 1000.0
        returnDict['lb/hr'] = value * 2204.62234
        returnDict['ton/hr(l)'] = value * 0.9842065
        returnDict['ton/hr(m)'] = value
        returnDict['ton/hr(s)'] = value * 1.102311
        returnDict['g/min'] = value * 16666.666666666668
        returnDict['kg/min'] = value * 16.666666666666668
        returnDict['lb/min'] = value * 36.74370566666666
        returnDict['ton/min(l)'] = value * 0.016403441666666668
        returnDict['ton/min(m)'] = value * 0.016666666666666666
        returnDict['ton/min(s)'] = value * 0.018371850000000002
        returnDict['g/sec'] = value * 277.77777777777777
        returnDict['kg/sec'] = value * 0.2777777777777778
        returnDict['lb/sec'] = value * 0.6123950944444444
        returnDict['ton/sec(l)'] = value * 0.0002733906944444445
        returnDict['ton/sec(m)'] = value * 0.0002777777777777778
        returnDict['ton/sec(s)'] = value * 0.00030619750000000003
    elif units == 'ton/hr(s)':
        returnDict['g/day'] = value * 907184.99589
        returnDict['kg/day'] = value * 907.18499589
        returnDict['lb/day'] = value * 2000.0003084
        returnDict['ton/day(l)'] = value * 0.8928573697
        returnDict['ton/day(m)'] = value * 0.9071849959
        returnDict['ton/day(s)'] = value * 24.0
        returnDict['g/hr'] = value * 37799.37482875
        returnDict['kg/hr'] = value * 37.79937482875
        returnDict['lb/hr'] = value * 83.33334618333333
        returnDict['ton/hr(l)'] = value * 0.03720239040416667
        returnDict['ton/hr(m)'] = value * 0.03779937482916667
        returnDict['ton/hr(s)'] = value
        returnDict['g/min'] = value * 629.9895804791666
        returnDict['kg/min'] = value * 0.6299895804791666
        returnDict['lb/min'] = value * 1.3888891030555555
        returnDict['ton/min(l)'] = value * 0.0006200398400694444
        returnDict['ton/min(m)'] = value * 0.0006299895804861112
        returnDict['ton/min(s)'] = value * 0.016666666666666666
        returnDict['g/sec'] = value * 10.499826341319444
        returnDict['kg/sec'] = value * 0.010499826341319443
        returnDict['lb/sec'] = value * 0.023148151717592592
        returnDict['ton/sec(l)'] = value * 1.033399733449074e-05
        returnDict['ton/sec(m)'] = value * 1.0499826341435186e-05
        returnDict['ton/sec(s)'] = value * 0.0002777777777777778
    elif units == 'g/min':
        returnDict['g/day'] = value * 1440.0
        returnDict['kg/day'] = value * 1.44
        returnDict['lb/day'] = value * 3.1746561696
        returnDict['ton/day(l)'] = value * 0.0014172574
        returnDict['ton/day(m)'] = value * 0.00144
        returnDict['ton/day(s)'] = value * 0.0015873278
        returnDict['g/hr'] = value * 60.0
        returnDict['kg/hr'] = value * 0.06
        returnDict['lb/hr'] = value * 0.1322773404
        returnDict['ton/hr(l)'] = value * 5.9052391666666666e-05
        returnDict['ton/hr(m)'] = value * 6e-05
        returnDict['ton/hr(s)'] = value * 6.613865833333333e-05
        returnDict['g/min'] = value
        returnDict['kg/min'] = value * 0.001
        returnDict['lb/min'] = value * 0.0022046223399999998
        returnDict['ton/min(l)'] = value * 9.842065277777777e-07
        returnDict['ton/min(m)'] = value * 1e-06
        returnDict['ton/min(s)'] = value * 1.1023109722222223e-06
        returnDict['g/sec'] = value * 0.016666666666666666
        returnDict['kg/sec'] = value * 1.6666666666666667e-05
        returnDict['lb/sec'] = value * 3.6743705666666665e-05
        returnDict['ton/sec(l)'] = value * 1.6403442129629628e-08
        returnDict['ton/sec(m)'] = value * 1.6666666666666667e-08
        returnDict['ton/sec(s)'] = value * 1.837184953703704e-08
    elif units == 'kg/min':
        returnDict['g/day'] = value * 1440000.0
        returnDict['kg/day'] = value * 1440.0
        returnDict['lb/day'] = value * 3174.6561696
        returnDict['ton/day(l)'] = value * 1.41725736
        returnDict['ton/day(m)'] = value * 1.44
        returnDict['ton/day(s)'] = value * 1.58732784
        returnDict['g/hr'] = value * 60000.0
        returnDict['kg/hr'] = value * 60.0
        returnDict['lb/hr'] = value * 132.27734039999999
        returnDict['ton/hr(l)'] = value * 0.05905239
        returnDict['ton/hr(m)'] = value * 0.06
        returnDict['ton/hr(s)'] = value * 0.06613866
        returnDict['g/min'] = value * 1000.0
        returnDict['kg/min'] = value
        returnDict['lb/min'] = value * 2.20462234
        returnDict['ton/min(l)'] = value * 0.0009842065
        returnDict['ton/min(m)'] = value * 0.001
        returnDict['ton/min(s)'] = value * 0.0011023110000000001
        returnDict['g/sec'] = value * 16.666666666666668
        returnDict['kg/sec'] = value * 0.016666666666666666
        returnDict['lb/sec'] = value * 0.03674370566666666
        returnDict['ton/sec(l)'] = value * 1.6403441666666668e-05
        returnDict['ton/sec(m)'] = value * 1.6666666666666667e-05
        returnDict['ton/sec(s)'] = value * 1.8371850000000003e-05
    elif units == 'lb/min':
        returnDict['g/day'] = value * 653173.0963
        returnDict['kg/day'] = value * 653.1730963
        returnDict['lb/day'] = value * 1440.0
        returnDict['ton/day(l)'] = value * 0.642857207
        returnDict['ton/day(m)'] = value * 0.6531730963
        returnDict['ton/day(s)'] = value * 0.719999889
        returnDict['g/hr'] = value * 27215.545679166666
        returnDict['kg/hr'] = value * 27.215545679166667
        returnDict['lb/hr'] = value * 60.0
        returnDict['ton/hr(l)'] = value * 0.026785716958333334
        returnDict['ton/hr(m)'] = value * 0.027215545679166665
        returnDict['ton/hr(s)'] = value * 0.029999995375
        returnDict['g/min'] = value * 453.5924279861111
        returnDict['kg/min'] = value * 0.4535924279861111
        returnDict['lb/min'] = value
        returnDict['ton/min(l)'] = value * 0.00044642861597222225
        returnDict['ton/min(m)'] = value * 0.00045359242798611107
        returnDict['ton/min(s)'] = value * 0.0004999999229166667
        returnDict['g/sec'] = value * 7.559873799768519
        returnDict['kg/sec'] = value * 0.007559873799768519
        returnDict['lb/sec'] = value * 0.016666666666666666
        returnDict['ton/sec(l)'] = value * 7.440476932870371e-06
        returnDict['ton/sec(m)'] = value * 7.559873799768518e-06
        returnDict['ton/sec(s)'] = value * 8.333332048611112e-06
    elif units == 'ton/min(l)':
        returnDict['g/day'] = value * 1463107589.7
        returnDict['kg/day'] = value * 1463107.5897
        returnDict['lb/day'] = value * 3225599.6781
        returnDict['ton/day(l)'] = value * 1440.0
        returnDict['ton/day(m)'] = value * 1463.1075897
        returnDict['ton/day(s)'] = value * 1612.7995903
        returnDict['g/hr'] = value * 60962816.237500004
        returnDict['kg/hr'] = value * 60962.816237499996
        returnDict['lb/hr'] = value * 134399.9865875
        returnDict['ton/hr(l)'] = value * 60.0
        returnDict['ton/hr(m)'] = value * 60.9628162375
        returnDict['ton/hr(s)'] = value * 67.19998292916667
        returnDict['g/min'] = value * 1016046.9372916667
        returnDict['kg/min'] = value * 1016.0469372916666
        returnDict['lb/min'] = value * 2239.999776458333
        returnDict['ton/min(l)'] = value
        returnDict['ton/min(m)'] = value * 1.0160469372916667
        returnDict['ton/min(s)'] = value * 1.119999715486111
        returnDict['g/sec'] = value * 16934.11562152778
        returnDict['kg/sec'] = value * 16.934115621527777
        returnDict['lb/sec'] = value * 37.33332960763889
        returnDict['ton/sec(l)'] = value * 0.016666666666666666
        returnDict['ton/sec(m)'] = value * 0.01693411562152778
        returnDict['ton/sec(s)'] = value * 0.018666661924768516
    elif units == 'ton/min(m)':
        returnDict['g/day'] = value * 1440000000.0
        returnDict['kg/day'] = value * 1440000.0
        returnDict['lb/day'] = value * 3174656.1696
        returnDict['ton/day(l)'] = value * 1417.25736
        returnDict['ton/day(m)'] = value * 1440.0
        returnDict['ton/day(s)'] = value * 1587.32784
        returnDict['g/hr'] = value * 60000000.0
        returnDict['kg/hr'] = value * 60000.0
        returnDict['lb/hr'] = value * 132277.34040000002
        returnDict['ton/hr(l)'] = value * 59.05239
        returnDict['ton/hr(m)'] = value * 60.0
        returnDict['ton/hr(s)'] = value * 66.13866
        returnDict['g/min'] = value * 1000000.0
        returnDict['kg/min'] = value * 1000.0
        returnDict['lb/min'] = value * 2204.6223400000003
        returnDict['ton/min(l)'] = value * 0.9842065000000001
        returnDict['ton/min(m)'] = value
        returnDict['ton/min(s)'] = value * 1.102311
        returnDict['g/sec'] = value * 16666.666666666668
        returnDict['kg/sec'] = value * 16.666666666666668
        returnDict['lb/sec'] = value * 36.74370566666667
        returnDict['ton/sec(l)'] = value * 0.016403441666666668
        returnDict['ton/sec(m)'] = value * 0.016666666666666666
        returnDict['ton/sec(s)'] = value * 0.018371850000000002
    elif units == 'ton/min(s)':
        returnDict['g/day'] = value * 1306346394.1
        returnDict['kg/day'] = value * 1306346.3941
        returnDict['lb/day'] = value * 2880000.4442
        returnDict['ton/day(l)'] = value * 1285.7146123
        returnDict['ton/day(m)'] = value * 1306.3463941
        returnDict['ton/day(s)'] = value * 1440.0
        returnDict['g/hr'] = value * 54431099.75416666
        returnDict['kg/hr'] = value * 54431.099754166666
        returnDict['lb/hr'] = value * 120000.01850833332
        returnDict['ton/hr(l)'] = value * 53.57144217916667
        returnDict['ton/hr(m)'] = value * 54.43109975416667
        returnDict['ton/hr(s)'] = value * 60.0
        returnDict['g/min'] = value * 907184.9959027778
        returnDict['kg/min'] = value * 907.1849959027778
        returnDict['lb/min'] = value * 2000.000308472222
        returnDict['ton/min(l)'] = value * 0.8928573696527777
        returnDict['ton/min(m)'] = value * 0.9071849959027778
        returnDict['ton/min(s)'] = value
        returnDict['g/sec'] = value * 15119.749931712962
        returnDict['kg/sec'] = value * 15.119749931712963
        returnDict['lb/sec'] = value * 33.33333847453704
        returnDict['ton/sec(l)'] = value * 0.014880956160879628
        returnDict['ton/sec(m)'] = value * 0.015119749931712964
        returnDict['ton/sec(s)'] = value * 0.016666666666666666
    elif units == 'g/sec':
        returnDict['g/day'] = value * 86400.0
        returnDict['kg/day'] = value * 86.4
        returnDict['lb/day'] = value * 190.47937018
        returnDict['ton/day(l)'] = value * 0.0850354416
        returnDict['ton/day(m)'] = value * 0.0864
        returnDict['ton/day(s)'] = value * 0.0952396704
        returnDict['g/hr'] = value * 3600.0
        returnDict['kg/hr'] = value * 3.6
        returnDict['lb/hr'] = value * 7.936640424166666
        returnDict['ton/hr(l)'] = value * 0.0035431434
        returnDict['ton/hr(m)'] = value * 0.0036000000000000003
        returnDict['ton/hr(s)'] = value * 0.0039683196
        returnDict['g/min'] = value * 60.0
        returnDict['kg/min'] = value * 0.060000000000000005
        returnDict['lb/min'] = value * 0.13227734040277778
        returnDict['ton/min(l)'] = value * 5.905239e-05
        returnDict['ton/min(m)'] = value * 6.000000000000001e-05
        returnDict['ton/min(s)'] = value * 6.613866e-05
        returnDict['g/sec'] = value
        returnDict['kg/sec'] = value * 0.001
        returnDict['lb/sec'] = value * 0.002204622340046296
        returnDict['ton/sec(l)'] = value * 9.842065000000001e-07
        returnDict['ton/sec(m)'] = value * 1.0000000000000002e-06
        returnDict['ton/sec(s)'] = value * 1.1023110000000001e-06
    elif units == 'kg/sec':
        returnDict['g/day'] = value * 86400000.0
        returnDict['kg/day'] = value * 86400.0
        returnDict['lb/day'] = value * 190479.37018
        returnDict['ton/day(l)'] = value * 85.0354416
        returnDict['ton/day(m)'] = value * 86.4
        returnDict['ton/day(s)'] = value * 95.2396704
        returnDict['g/hr'] = value * 3600000.0
        returnDict['kg/hr'] = value * 3600.0
        returnDict['lb/hr'] = value * 7936.640424166667
        returnDict['ton/hr(l)'] = value * 3.5431434
        returnDict['ton/hr(m)'] = value * 3.6
        returnDict['ton/hr(s)'] = value * 3.9683195999999996
        returnDict['g/min'] = value * 60000.0
        returnDict['kg/min'] = value * 60.0
        returnDict['lb/min'] = value * 132.27734040277778
        returnDict['ton/min(l)'] = value * 0.059052389999999996
        returnDict['ton/min(m)'] = value * 0.060000000000000005
        returnDict['ton/min(s)'] = value * 0.06613865999999999
        returnDict['g/sec'] = value * 1000.0
        returnDict['kg/sec'] = value
        returnDict['lb/sec'] = value * 2.2046223400462965
        returnDict['ton/sec(l)'] = value * 0.0009842065
        returnDict['ton/sec(m)'] = value * 0.001
        returnDict['ton/sec(s)'] = value * 0.0011023109999999997
    elif units == 'lb/sec':
        returnDict['g/day'] = value * 39190385.778
        returnDict['kg/day'] = value * 39190.385778
        returnDict['lb/day'] = value * 86400.0
        returnDict['ton/day(l)'] = value * 38.57143242
        returnDict['ton/day(m)'] = value * 39.190385778
        returnDict['ton/day(s)'] = value * 43.199993338
        returnDict['g/hr'] = value * 1632932.7407499999
        returnDict['kg/hr'] = value * 1632.9327407500002
        returnDict['lb/hr'] = value * 3600.0
        returnDict['ton/hr(l)'] = value * 1.6071430175
        returnDict['ton/hr(m)'] = value * 1.63293274075
        returnDict['ton/hr(s)'] = value * 1.7999997224166666
        returnDict['g/min'] = value * 27215.545679166666
        returnDict['kg/min'] = value * 27.21554567916667
        returnDict['lb/min'] = value * 60.0
        returnDict['ton/min(l)'] = value * 0.026785716958333334
        returnDict['ton/min(m)'] = value * 0.027215545679166668
        returnDict['ton/min(s)'] = value * 0.02999999537361111
        returnDict['g/sec'] = value * 453.5924279861111
        returnDict['kg/sec'] = value * 0.45359242798611116
        returnDict['lb/sec'] = value
        returnDict['ton/sec(l)'] = value * 0.00044642861597222225
        returnDict['ton/sec(m)'] = value * 0.0004535924279861111
        returnDict['ton/sec(s)'] = value * 0.0004999999228935184
    elif units == 'ton/sec(l)':
        returnDict['g/day'] = value * 87786455383.0
        returnDict['kg/day'] = value * 87786455.383
        returnDict['lb/day'] = value * 193535980.69
        returnDict['ton/day(l)'] = value * 86400.0
        returnDict['ton/day(m)'] = value * 87786.455383
        returnDict['ton/day(s)'] = value * 96767.97542
        returnDict['g/hr'] = value * 3657768974.2916665
        returnDict['kg/hr'] = value * 3657768.974291667
        returnDict['lb/hr'] = value * 8063999.195416667
        returnDict['ton/hr(l)'] = value * 3600.0
        returnDict['ton/hr(m)'] = value * 3657.7689742916664
        returnDict['ton/hr(s)'] = value * 4031.9989758333336
        returnDict['g/min'] = value * 60962816.23819444
        returnDict['kg/min'] = value * 60962.81623819445
        returnDict['lb/min'] = value * 134399.98659027778
        returnDict['ton/min(l)'] = value * 60.0
        returnDict['ton/min(m)'] = value * 60.96281623819444
        returnDict['ton/min(s)'] = value * 67.19998293055556
        returnDict['g/sec'] = value * 1016046.9373032408
        returnDict['kg/sec'] = value * 1016.0469373032408
        returnDict['lb/sec'] = value * 2239.9997765046296
        returnDict['ton/sec(l)'] = value
        returnDict['ton/sec(m)'] = value * 1.0160469373032408
        returnDict['ton/sec(s)'] = value * 1.1199997155092594
    elif units == 'ton/sec(m)':
        returnDict['g/day'] = value * 86400000000.0
        returnDict['kg/day'] = value * 86400000.0
        returnDict['lb/day'] = value * 190479370.18
        returnDict['ton/day(l)'] = value * 85035.4416
        returnDict['ton/day(m)'] = value * 86400.0
        returnDict['ton/day(s)'] = value * 95239.6704
        returnDict['g/hr'] = value * 3600000000.0
        returnDict['kg/hr'] = value * 3600000.0
        returnDict['lb/hr'] = value * 7936640.424166667
        returnDict['ton/hr(l)'] = value * 3543.1434000000004
        returnDict['ton/hr(m)'] = value * 3600.0
        returnDict['ton/hr(s)'] = value * 3968.3196000000003
        returnDict['g/min'] = value * 60000000.0
        returnDict['kg/min'] = value * 60000.0
        returnDict['lb/min'] = value * 132277.3404027778
        returnDict['ton/min(l)'] = value * 59.05239000000001
        returnDict['ton/min(m)'] = value * 60.0
        returnDict['ton/min(s)'] = value * 66.13866
        returnDict['g/sec'] = value * 1000000.0
        returnDict['kg/sec'] = value * 1000.0
        returnDict['lb/sec'] = value * 2204.622340046297
        returnDict['ton/sec(l)'] = value * 0.9842065000000002
        returnDict['ton/sec(m)'] = value
        returnDict['ton/sec(s)'] = value * 1.102311
    elif units == 'ton/sec(s)':
        returnDict['g/day'] = value * 78380783645.0
        returnDict['kg/day'] = value * 78380783.645
        returnDict['lb/day'] = value * 172800026.65
        returnDict['ton/day(l)'] = value * 77142.876738
        returnDict['ton/day(m)'] = value * 78380.783645
        returnDict['ton/day(s)'] = value * 86400.0
        returnDict['g/hr'] = value * 3265865985.2083335
        returnDict['kg/hr'] = value * 3265865.985208333
        returnDict['lb/hr'] = value * 7200001.110416667
        returnDict['ton/hr(l)'] = value * 3214.28653075
        returnDict['ton/hr(m)'] = value * 3265.8659852083333
        returnDict['ton/hr(s)'] = value * 3600.0
        returnDict['g/min'] = value * 54431099.753472224
        returnDict['kg/min'] = value * 54431.09975347222
        returnDict['lb/min'] = value * 120000.01850694444
        returnDict['ton/min(l)'] = value * 53.57144217916667
        returnDict['ton/min(m)'] = value * 54.431099753472225
        returnDict['ton/min(s)'] = value * 60.0
        returnDict['g/sec'] = value * 907184.9958912038
        returnDict['kg/sec'] = value * 907.1849958912037
        returnDict['lb/sec'] = value * 2000.000308449074
        returnDict['ton/sec(l)'] = value * 0.8928573696527777
        returnDict['ton/sec(m)'] = value * 0.9071849958912037
        returnDict['ton/sec(s)'] = value
    return returnDict


def flowrate_vol(value, units):
    returnDict = {}
    if units == 'BPD':
        returnDict['BPD'] = value
        returnDict['ft3/day'] = value * 5.6145928
        returnDict['m3/day'] = value * 0.0001104
        returnDict['gal/day'] = value * 42.0000211
        returnDict['BPH'] = value * 0.041666666666666664
        returnDict['ft3/hr'] = value * 0.23394136666666665
        returnDict['m3/hr'] = value * 4.6e-06
        returnDict['gph'] = value * 1.7500008791666666
        returnDict['BPM'] = value * 0.0006944444444444444
        returnDict['ft3/min'] = value * 0.0038990227777777773
        returnDict['m3/min'] = value * 7.666666666666666e-08
        returnDict['gpm'] = value * 0.029166681319444443
        returnDict['BPS'] = value * 1.1574074074074073e-05
        returnDict['ft3/sec'] = value * 6.498371296296296e-05
        returnDict['m3/sec'] = value * 1.2777777777777778e-09
        returnDict['gal/sec'] = value * 0.00048611135532407405
    elif units == 'ft3/day':
        returnDict['BPD'] = value * 0.1781073
        returnDict['ft3/day'] = value
        returnDict['m3/day'] = value * 1.97e-05
        returnDict['gal/day'] = value * 7.4805107
        returnDict['BPH'] = value * 0.0074211375
        returnDict['ft3/hr'] = value * 0.041666666666666664
        returnDict['m3/hr'] = value * 8.208333333333333e-07
        returnDict['gph'] = value * 0.3116879458333333
        returnDict['BPM'] = value * 0.000123685625
        returnDict['ft3/min'] = value * 0.0006944444444444444
        returnDict['m3/min'] = value * 1.3680555555555555e-08
        returnDict['gpm'] = value * 0.0051947990972222215
        returnDict['BPS'] = value * 2.0614270833333333e-06
        returnDict['ft3/sec'] = value * 1.1574074074074073e-05
        returnDict['m3/sec'] = value * 2.2800925925925925e-10
        returnDict['gal/sec'] = value * 8.657998495370369e-05
    elif units == 'm3/day':
        returnDict['BPD'] = value * 6.2898106
        returnDict['ft3/day'] = value * 35.3147248
        returnDict['m3/day'] = value
        returnDict['gal/day'] = value * 264.1721769
        returnDict['BPH'] = value * 0.2620754416666667
        returnDict['ft3/hr'] = value * 1.4714468666666667
        returnDict['m3/hr'] = value * 0.041666666666666664
        returnDict['gph'] = value * 11.0071740375
        returnDict['BPM'] = value * 0.004367924027777778
        returnDict['ft3/min'] = value * 0.024524114444444446
        returnDict['m3/min'] = value * 0.0006944444444444444
        returnDict['gpm'] = value * 0.183452900625
        returnDict['BPS'] = value * 7.27987337962963e-05
        returnDict['ft3/sec'] = value * 0.0004087352407407408
        returnDict['m3/sec'] = value * 1.1574074074074073e-05
        returnDict['gal/sec'] = value * 0.00305754834375
    elif units == 'gal/day':
        returnDict['BPD'] = value * 0.0238095
        returnDict['ft3/day'] = value * 0.1336807
        returnDict['m3/day'] = value * 0.0037854
        returnDict['gal/day'] = value
        returnDict['BPH'] = value * 0.0009920625
        returnDict['ft3/hr'] = value * 0.005570029166666667
        returnDict['m3/hr'] = value * 0.000157725
        returnDict['gph'] = value * 0.041666666666666664
        returnDict['BPM'] = value * 1.6534375e-05
        returnDict['ft3/min'] = value * 9.283381944444445e-05
        returnDict['m3/min'] = value * 2.62875e-06
        returnDict['gpm'] = value * 0.0006944444444444444
        returnDict['BPS'] = value * 2.7557291666666667e-07
        returnDict['ft3/sec'] = value * 1.5472303240740742e-06
        returnDict['m3/sec'] = value * 4.38125e-08
        returnDict['gal/sec'] = value * 1.1574074074074073e-05
    elif units == 'BPH':
        returnDict['BPD'] = value * 24.0
        returnDict['ft3/day'] = value * 134.750226
        returnDict['m3/day'] = value * 3.8156952
        returnDict['gal/day'] = value * 1008.0005072
        returnDict['BPH'] = value
        returnDict['ft3/hr'] = value * 5.61459275
        returnDict['m3/hr'] = value * 0.1589873
        returnDict['gph'] = value * 42.000021133333334
        returnDict['BPM'] = value * 0.016666666666666666
        returnDict['ft3/min'] = value * 0.09357654583333333
        returnDict['m3/min'] = value * 0.0026497883333333333
        returnDict['gpm'] = value * 0.7000003522222222
        returnDict['BPS'] = value * 0.0002777777777777778
        returnDict['ft3/sec'] = value * 0.0015596090972222222
        returnDict['m3/sec'] = value * 4.4163138888888885e-05
        returnDict['gal/sec'] = value * 0.011666672537037038
    elif units == 'ft3/hr':
        returnDict['BPD'] = value * 4.2745754
        returnDict['ft3/day'] = value * 24.0
        returnDict['m3/day'] = value * 0.6796032
        returnDict['gal/day'] = value * 179.5322567
        returnDict['BPH'] = value * 0.17810730833333333
        returnDict['ft3/hr'] = value
        returnDict['m3/hr'] = value * 0.0283168
        returnDict['gph'] = value * 7.480510695833334
        returnDict['BPM'] = value * 0.0029684551388888887
        returnDict['ft3/min'] = value * 0.016666666666666666
        returnDict['m3/min'] = value * 0.00047194666666666664
        returnDict['gpm'] = value * 0.1246751782638889
        returnDict['BPS'] = value * 4.9474252314814815e-05
        returnDict['ft3/sec'] = value * 0.0002777777777777778
        returnDict['m3/sec'] = value * 7.865777777777777e-06
        returnDict['gal/sec'] = value * 0.0020779196377314815
    elif units == 'm3/hr':
        returnDict['BPD'] = value * 150.9554537
        returnDict['ft3/day'] = value * 847.5533959
        returnDict['m3/day'] = value * 24.0
        returnDict['gal/day'] = value * 6340.1322446
        returnDict['BPH'] = value * 6.289810570833333
        returnDict['ft3/hr'] = value * 35.31472482916667
        returnDict['m3/hr'] = value
        returnDict['gph'] = value * 264.17217685833333
        returnDict['BPM'] = value * 0.10483017618055554
        returnDict['ft3/min'] = value * 0.5885787471527778
        returnDict['m3/min'] = value * 0.016666666666666666
        returnDict['gpm'] = value * 4.402869614305556
        returnDict['BPS'] = value * 0.001747169603009259
        returnDict['ft3/sec'] = value * 0.00980964578587963
        returnDict['m3/sec'] = value * 0.0002777777777777778
        returnDict['gal/sec'] = value * 0.07338116023842593
    elif units == 'gph':
        returnDict['BPD'] = value * 0.5714283
        returnDict['ft3/day'] = value * 3.2083371
        returnDict['m3/day'] = value * 0.0908498
        returnDict['gal/day'] = value * 24.0
        returnDict['BPH'] = value * 0.0238095125
        returnDict['ft3/hr'] = value * 0.1336807125
        returnDict['m3/hr'] = value * 0.0037854083333333332
        returnDict['gph'] = value
        returnDict['BPM'] = value * 0.00039682520833333334
        returnDict['ft3/min'] = value * 0.0022280118749999998
        returnDict['m3/min'] = value * 6.309013888888888e-05
        returnDict['gpm'] = value * 0.016666666666666666
        returnDict['BPS'] = value * 6.613753472222222e-06
        returnDict['ft3/sec'] = value * 3.7133531249999997e-05
        returnDict['m3/sec'] = value * 1.0515023148148147e-06
        returnDict['gal/sec'] = value * 0.0002777777777777778
    elif units == 'BPM':
        returnDict['BPD'] = value * 1440.0
        returnDict['ft3/day'] = value * 8085.0135609
        returnDict['m3/day'] = value * 228.941712
        returnDict['gal/day'] = value * 60480.0304326
        returnDict['BPH'] = value * 60.0
        returnDict['ft3/hr'] = value * 336.8755650375
        returnDict['m3/hr'] = value * 9.539238
        returnDict['gph'] = value * 2520.0012680249997
        returnDict['BPM'] = value
        returnDict['ft3/min'] = value * 5.6145927506249995
        returnDict['m3/min'] = value * 0.1589873
        returnDict['gpm'] = value * 42.000021133749996
        returnDict['BPS'] = value * 0.016666666666666666
        returnDict['ft3/sec'] = value * 0.09357654584375
        returnDict['m3/sec'] = value * 0.0026497883333333333
        returnDict['gal/sec'] = value * 0.7000003522291666
    elif units == 'ft3/min':
        returnDict['BPD'] = value * 256.4745234
        returnDict['ft3/day'] = value * 1440.0
        returnDict['m3/day'] = value * 40.776192
        returnDict['gal/day'] = value * 10771.9354046
        returnDict['BPH'] = value * 10.686438475000001
        returnDict['ft3/hr'] = value * 60.0
        returnDict['m3/hr'] = value * 1.699008
        returnDict['gph'] = value * 448.83064185833337
        returnDict['BPM'] = value * 0.17810730791666668
        returnDict['ft3/min'] = value
        returnDict['m3/min'] = value * 0.0283168
        returnDict['gpm'] = value * 7.4805106976388895
        returnDict['BPS'] = value * 0.0029684551319444446
        returnDict['ft3/sec'] = value * 0.016666666666666666
        returnDict['m3/sec'] = value * 0.00047194666666666664
        returnDict['gal/sec'] = value * 0.12467517829398149
    elif units == 'm3/min':
        returnDict['BPD'] = value * 9057.3272205
        returnDict['ft3/day'] = value * 50853.2037518
        returnDict['m3/day'] = value * 1440.0
        returnDict['gal/day'] = value * 380407.9346755
        returnDict['BPH'] = value * 377.3886341875
        returnDict['ft3/hr'] = value * 2118.8834896583335
        returnDict['m3/hr'] = value * 60.0
        returnDict['gph'] = value * 15850.330611479165
        returnDict['BPM'] = value * 6.289810569791666
        returnDict['ft3/min'] = value * 35.31472482763889
        returnDict['m3/min'] = value
        returnDict['gpm'] = value * 264.1721768579861
        returnDict['BPS'] = value * 0.10483017616319444
        returnDict['ft3/sec'] = value * 0.5885787471273148
        returnDict['m3/sec'] = value * 0.016666666666666666
        returnDict['gal/sec'] = value * 4.402869614299768
    elif units == 'gpm':
        returnDict['BPD'] = value * 34.285697
        returnDict['ft3/day'] = value * 192.500226
        returnDict['m3/day'] = value * 5.4509904
        returnDict['gal/day'] = value * 1440.0
        returnDict['BPH'] = value * 1.4285707083333332
        returnDict['ft3/hr'] = value * 8.02084275
        returnDict['m3/hr'] = value * 0.2271246
        returnDict['gph'] = value * 60.0
        returnDict['BPM'] = value * 0.023809511805555555
        returnDict['ft3/min'] = value * 0.1336807125
        returnDict['m3/min'] = value * 0.0037854100000000003
        returnDict['gpm'] = value
        returnDict['BPS'] = value * 0.00039682519675925923
        returnDict['ft3/sec'] = value * 0.0022280118749999998
        returnDict['m3/sec'] = value * 6.309016666666667e-05
        returnDict['gal/sec'] = value * 0.016666666666666666
    elif units == 'BPS':
        returnDict['BPD'] = value * 86400.0
        returnDict['ft3/day'] = value * 485100.8136513
        returnDict['m3/day'] = value * 13736.50272
        returnDict['gal/day'] = value * 3628801.8259581
        returnDict['BPH'] = value * 3600.0
        returnDict['ft3/hr'] = value * 20212.5339021375
        returnDict['m3/hr'] = value * 572.35428
        returnDict['gph'] = value * 151200.0760815875
        returnDict['BPM'] = value * 60.0
        returnDict['ft3/min'] = value * 336.875565035625
        returnDict['m3/min'] = value * 9.539238000000001
        returnDict['gpm'] = value * 2520.001268026458
        returnDict['BPS'] = value
        returnDict['ft3/sec'] = value * 5.61459275059375
        returnDict['m3/sec'] = value * 0.15898730000000003
        returnDict['gal/sec'] = value * 42.000021133774304
    elif units == 'ft3/sec':
        returnDict['BPD'] = value * 15388.4714062
        returnDict['ft3/day'] = value * 86400.0
        returnDict['m3/day'] = value * 2446.57152
        returnDict['gal/day'] = value * 646316.1242772
        returnDict['BPH'] = value * 641.1863085916667
        returnDict['ft3/hr'] = value * 3600.0
        returnDict['m3/hr'] = value * 101.94048
        returnDict['gph'] = value * 26929.83851155
        returnDict['BPM'] = value * 10.686438476527778
        returnDict['ft3/min'] = value * 60.0
        returnDict['m3/min'] = value * 1.6990079999999999
        returnDict['gpm'] = value * 448.83064185916663
        returnDict['BPS'] = value * 0.17810730794212964
        returnDict['ft3/sec'] = value
        returnDict['m3/sec'] = value * 0.028316799999999996
        returnDict['gal/sec'] = value * 7.480510697652777
    elif units == 'm3/sec':
        returnDict['BPD'] = value * 543439.6332286
        returnDict['ft3/day'] = value * 3051192.2251102
        returnDict['m3/day'] = value * 86400.0
        returnDict['gal/day'] = value * 22824476.0805302
        returnDict['BPH'] = value * 22643.31805119167
        returnDict['ft3/hr'] = value * 127133.00937959166
        returnDict['m3/hr'] = value * 3600.0
        returnDict['gph'] = value * 951019.8366887583
        returnDict['BPM'] = value * 377.38863418652784
        returnDict['ft3/min'] = value * 2118.883489659861
        returnDict['m3/min'] = value * 60.0
        returnDict['gpm'] = value * 15850.330611479305
        returnDict['BPS'] = value * 6.289810569775464
        returnDict['ft3/sec'] = value * 35.31472482766435
        returnDict['m3/sec'] = value
        returnDict['gal/sec'] = value * 264.1721768579884
    elif units == 'gal/sec':
        returnDict['BPD'] = value * 2057.141822
        returnDict['ft3/day'] = value * 11550.0135609
        returnDict['m3/day'] = value * 327.059424
        returnDict['gal/day'] = value * 86400.0
        returnDict['BPH'] = value * 85.71424258333333
        returnDict['ft3/hr'] = value * 481.25056503750005
        returnDict['m3/hr'] = value * 13.627476
        returnDict['gph'] = value * 3600.0
        returnDict['BPM'] = value * 1.4285707097222222
        returnDict['ft3/min'] = value * 8.020842750625
        returnDict['m3/min'] = value * 0.22712459999999998
        returnDict['gpm'] = value * 60.0
        returnDict['BPS'] = value * 0.023809511828703705
        returnDict['ft3/sec'] = value * 0.13368071251041666
        returnDict['m3/sec'] = value * 0.00378541
        returnDict['gal/sec'] = value
    return returnDict


def volumetric_flow_rate(value, units):
    returnDict = {}
    if units == 'L/hour':
        returnDict['L/hour'] = value * 1.0
        returnDict['L/min'] = value * 0.0166666666666666
        returnDict['L/sec'] = value * 0.000277777777777777
        returnDict['mL/hour'] = value * 1000.0
        returnDict['mL/min'] = value * 16.6666666666666
        returnDict['mL/sec'] = value * 0.277777777777777
        returnDict['m3/hour'] = value * 0.001
        returnDict['m3/min'] = value * 1.66666666666666e-05
        returnDict['m3/sec'] = value * 2.77777777777777e-07
        returnDict['mm3/hour'] = value * 1000000.0
        returnDict['mm3/min'] = value * 16666.6666666666
        returnDict['mm3/sec'] = value * 277.777777777777
        returnDict['ft3/hour'] = value * 0.0353146667214885
        returnDict['ft3/min'] = value * 0.000588577778691476
        returnDict['ft3/sec'] = value * 9.80962964485794e-06
        returnDict['gal(us)/hour'] = value * 0.264172052358148
        returnDict['gal(us)/min'] = value * 0.00440286753930247
        returnDict['gal(us)/sec'] = value * 7.33811256550412e-05
        returnDict['gal(I)/hour'] = value * 0.219969248299087
        returnDict['gal(I)/min'] = value * 0.00366615413831812
        returnDict['gal(I)/sec'] = value * 6.11025689719688e-05
        returnDict['cm3/hour'] = value * 1000.0
        returnDict['cm3/min'] = value * 16.6666666666666
        returnDict['cm3/sec'] = value * 0.277777777777777
    elif units == 'L/min':
        returnDict['L/hour'] = value * 60.00000000000024
        returnDict['L/min'] = value * 1.0
        returnDict['L/sec'] = value * 0.0166666666666666
        returnDict['mL/hour'] = value * 60000.0
        returnDict['mL/min'] = value * 1000.0
        returnDict['mL/sec'] = value * 16.6666666666666
        returnDict['m3/hour'] = value * 0.06
        returnDict['m3/min'] = value * 0.001
        returnDict['m3/sec'] = value * 1.66666666666666e-05
        returnDict['mm3/hour'] = value * 60000000.0
        returnDict['mm3/min'] = value * 1000000.0
        returnDict['mm3/sec'] = value * 16666.6666666666
        returnDict['ft3/hour'] = value * 2.11888000328931
        returnDict['ft3/min'] = value * 0.0353146667214885
        returnDict['ft3/sec'] = value * 0.000588577778691476
        returnDict['gal(us)/hour'] = value * 15.8503231414889
        returnDict['gal(us)/min'] = value * 0.264172052358148
        returnDict['gal(us)/sec'] = value * 0.00440286753930247
        returnDict['gal(I)/hour'] = value * 13.1981548979452
        returnDict['gal(I)/min'] = value * 0.219969248299087
        returnDict['gal(I)/sec'] = value * 0.00366615413831812
        returnDict['cm3/hour'] = value * 60000.0
        returnDict['cm3/min'] = value * 1000.0
        returnDict['cm3/sec'] = value * 16.6666666666666
    elif units == 'L/sec':
        returnDict['L/hour'] = value * 3600.00000000001
        returnDict['L/min'] = value * 60.00000000000024
        returnDict['L/sec'] = value * 1.0
        returnDict['mL/hour'] = value * 3600000.0
        returnDict['mL/min'] = value * 60000.0
        returnDict['mL/sec'] = value * 1000.0
        returnDict['m3/hour'] = value * 3.6
        returnDict['m3/min'] = value * 0.06
        returnDict['m3/sec'] = value * 0.001
        returnDict['mm3/hour'] = value * 3600000000.0
        returnDict['mm3/min'] = value * 60000000.0
        returnDict['mm3/sec'] = value * 1000000.0
        returnDict['ft3/hour'] = value * 127.132800197358
        returnDict['ft3/min'] = value * 2.11888000328931
        returnDict['ft3/sec'] = value * 0.0353146667214885
        returnDict['gal(us)/hour'] = value * 951.019388489334
        returnDict['gal(us)/min'] = value * 15.8503231414889
        returnDict['gal(us)/sec'] = value * 0.264172052358148
        returnDict['gal(I)/hour'] = value * 791.889293876716
        returnDict['gal(I)/min'] = value * 13.1981548979452
        returnDict['gal(I)/sec'] = value * 0.219969248299087
        returnDict['cm3/hour'] = value * 3600000.0
        returnDict['cm3/min'] = value * 60000.0
        returnDict['cm3/sec'] = value * 1000.0
    elif units == 'mL/hour':
        returnDict['L/hour'] = value * 0.001
        returnDict['L/min'] = value * 1.6666666666666667e-05
        returnDict['L/sec'] = value * 2.7777777777777776e-07
        returnDict['mL/hour'] = value * 1.0
        returnDict['mL/min'] = value * 0.0166666666666666
        returnDict['mL/sec'] = value * 0.000277777777777777
        returnDict['m3/hour'] = value * 1e-06
        returnDict['m3/min'] = value * 1.66666666666666e-08
        returnDict['m3/sec'] = value * 2.77777777777777e-10
        returnDict['mm3/hour'] = value * 1000.0
        returnDict['mm3/min'] = value * 16.6666666666666
        returnDict['mm3/sec'] = value * 0.277777777777777
        returnDict['ft3/hour'] = value * 3.53146667214885e-05
        returnDict['ft3/min'] = value * 5.88577778691476e-07
        returnDict['ft3/sec'] = value * 9.80962964485794e-09
        returnDict['gal(us)/hour'] = value * 0.000264172052358148
        returnDict['gal(us)/min'] = value * 4.40286753930247e-06
        returnDict['gal(us)/sec'] = value * 7.33811256550412e-08
        returnDict['gal(I)/hour'] = value * 0.000219969248299087
        returnDict['gal(I)/min'] = value * 3.66615413831812e-06
        returnDict['gal(I)/sec'] = value * 6.11025689719688e-08
        returnDict['cm3/hour'] = value * 1.0
        returnDict['cm3/min'] = value * 0.0166666666666666
        returnDict['cm3/sec'] = value * 0.000277777777777777
    elif units == 'mL/min':
        returnDict['L/hour'] = value * 0.06000000000000024
        returnDict['L/min'] = value * 0.001
        returnDict['L/sec'] = value * 1.6666666666666667e-05
        returnDict['mL/hour'] = value * 60.00000000000024
        returnDict['mL/min'] = value * 1.0
        returnDict['mL/sec'] = value * 0.0166666666666666
        returnDict['m3/hour'] = value * 6e-05
        returnDict['m3/min'] = value * 1e-06
        returnDict['m3/sec'] = value * 1.66666666666666e-08
        returnDict['mm3/hour'] = value * 60000.0
        returnDict['mm3/min'] = value * 1000.0
        returnDict['mm3/sec'] = value * 16.6666666666666
        returnDict['ft3/hour'] = value * 0.00211888000328931
        returnDict['ft3/min'] = value * 3.53146667214885e-05
        returnDict['ft3/sec'] = value * 5.88577778691476e-07
        returnDict['gal(us)/hour'] = value * 0.0158503231414889
        returnDict['gal(us)/min'] = value * 0.000264172052358148
        returnDict['gal(us)/sec'] = value * 4.40286753930247e-06
        returnDict['gal(I)/hour'] = value * 0.0131981548979452
        returnDict['gal(I)/min'] = value * 0.000219969248299087
        returnDict['gal(I)/sec'] = value * 3.66615413831812e-06
        returnDict['cm3/hour'] = value * 60.00000000000024
        returnDict['cm3/min'] = value * 1.0
        returnDict['cm3/sec'] = value * 0.0166666666666666
    elif units == 'mL/sec':
        returnDict['L/hour'] = value * 3.60000000000001
        returnDict['L/min'] = value * 0.06000000000000024
        returnDict['L/sec'] = value * 0.001
        returnDict['mL/hour'] = value * 3600.00000000001
        returnDict['mL/min'] = value * 60.00000000000024
        returnDict['mL/sec'] = value * 1.0
        returnDict['m3/hour'] = value * 0.0036
        returnDict['m3/min'] = value * 6e-05
        returnDict['m3/sec'] = value * 1e-06
        returnDict['mm3/hour'] = value * 3600000.0
        returnDict['mm3/min'] = value * 60000.0
        returnDict['mm3/sec'] = value * 1000.0
        returnDict['ft3/hour'] = value * 0.127132800197358
        returnDict['ft3/min'] = value * 0.00211888000328931
        returnDict['ft3/sec'] = value * 3.53146667214885e-05
        returnDict['gal(us)/hour'] = value * 0.951019388489334
        returnDict['gal(us)/min'] = value * 0.0158503231414889
        returnDict['gal(us)/sec'] = value * 0.000264172052358148
        returnDict['gal(I)/hour'] = value * 0.791889293876716
        returnDict['gal(I)/min'] = value * 0.0131981548979452
        returnDict['gal(I)/sec'] = value * 0.000219969248299087
        returnDict['cm3/hour'] = value * 3600.00000000001
        returnDict['cm3/min'] = value * 60.00000000000024
        returnDict['cm3/sec'] = value * 1.0
    elif units == 'm3/hour':
        returnDict['L/hour'] = value * 1000.0
        returnDict['L/min'] = value * 16.666666666666668
        returnDict['L/sec'] = value * 0.2777777777777778
        returnDict['mL/hour'] = value * 1000000.0
        returnDict['mL/min'] = value * 16666.666666666668
        returnDict['mL/sec'] = value * 277.77777777777777
        returnDict['m3/hour'] = value * 1.0
        returnDict['m3/min'] = value * 0.0166666666666666
        returnDict['m3/sec'] = value * 0.000277777777777777
        returnDict['mm3/hour'] = value * 1000000000.0
        returnDict['mm3/min'] = value * 16666666.6666666
        returnDict['mm3/sec'] = value * 277777.777777777
        returnDict['ft3/hour'] = value * 35.3146667214885
        returnDict['ft3/min'] = value * 0.588577778691476
        returnDict['ft3/sec'] = value * 0.00980962964485794
        returnDict['gal(us)/hour'] = value * 264.172052358148
        returnDict['gal(us)/min'] = value * 4.40286753930247
        returnDict['gal(us)/sec'] = value * 0.0733811256550412
        returnDict['gal(I)/hour'] = value * 219.969248299087
        returnDict['gal(I)/min'] = value * 3.66615413831812
        returnDict['gal(I)/sec'] = value * 0.0611025689719688
        returnDict['cm3/hour'] = value * 1000000.0
        returnDict['cm3/min'] = value * 16666.666666666668
        returnDict['cm3/sec'] = value * 277.77777777777777
    elif units == 'm3/min':
        returnDict['L/hour'] = value * 60000.00000000024
        returnDict['L/min'] = value * 1000.0
        returnDict['L/sec'] = value * 16.666666666666668
        returnDict['mL/hour'] = value * 60000000.00000024
        returnDict['mL/min'] = value * 1000000.0
        returnDict['mL/sec'] = value * 16666.666666666668
        returnDict['m3/hour'] = value * 60.00000000000024
        returnDict['m3/min'] = value * 1.0
        returnDict['m3/sec'] = value * 0.0166666666666666
        returnDict['mm3/hour'] = value * 60000000000.0
        returnDict['mm3/min'] = value * 1000000000.0
        returnDict['mm3/sec'] = value * 16666666.6666666
        returnDict['ft3/hour'] = value * 2118.88000328931
        returnDict['ft3/min'] = value * 35.3146667214885
        returnDict['ft3/sec'] = value * 0.588577778691476
        returnDict['gal(us)/hour'] = value * 15850.3231414889
        returnDict['gal(us)/min'] = value * 264.172052358148
        returnDict['gal(us)/sec'] = value * 4.40286753930247
        returnDict['gal(I)/hour'] = value * 13198.1548979452
        returnDict['gal(I)/min'] = value * 219.969248299087
        returnDict['gal(I)/sec'] = value * 3.66615413831812
        returnDict['cm3/hour'] = value * 60000000.00000024
        returnDict['cm3/min'] = value * 1000000.0
        returnDict['cm3/sec'] = value * 16666.666666666668
    elif units == 'm3/sec':
        returnDict['L/hour'] = value * 3600000.00000001
        returnDict['L/min'] = value * 60000.00000000024
        returnDict['L/sec'] = value * 1000.0
        returnDict['mL/hour'] = value * 3600000000.00001
        returnDict['mL/min'] = value * 60000000.00000024
        returnDict['mL/sec'] = value * 1000000.0
        returnDict['m3/hour'] = value * 3600.00000000001
        returnDict['m3/min'] = value * 60.00000000000024
        returnDict['m3/sec'] = value * 1.0
        returnDict['mm3/hour'] = value * 3600000000000.0
        returnDict['mm3/min'] = value * 60000000000.0
        returnDict['mm3/sec'] = value * 1000000000.0
        returnDict['ft3/hour'] = value * 127132.800197358
        returnDict['ft3/min'] = value * 2118.88000328931
        returnDict['ft3/sec'] = value * 35.3146667214885
        returnDict['gal(us)/hour'] = value * 951019.388489334
        returnDict['gal(us)/min'] = value * 15850.3231414889
        returnDict['gal(us)/sec'] = value * 264.172052358148
        returnDict['gal(I)/hour'] = value * 791889.293876716
        returnDict['gal(I)/min'] = value * 13198.1548979452
        returnDict['gal(I)/sec'] = value * 219.969248299087
        returnDict['cm3/hour'] = value * 3600000000.00001
        returnDict['cm3/min'] = value * 60000000.00000024
        returnDict['cm3/sec'] = value * 1000000.0
    elif units == 'mm3/hour':
        returnDict['L/hour'] = value * 1e-06
        returnDict['L/min'] = value * 1.6666666666666667e-08
        returnDict['L/sec'] = value * 2.7777777777777777e-10
        returnDict['mL/hour'] = value * 0.001
        returnDict['mL/min'] = value * 1.6666666666666667e-05
        returnDict['mL/sec'] = value * 2.7777777777777776e-07
        returnDict['m3/hour'] = value * 1e-09
        returnDict['m3/min'] = value * 1.6666666666666667e-11
        returnDict['m3/sec'] = value * 2.777777777777778e-13
        returnDict['mm3/hour'] = value * 1.0
        returnDict['mm3/min'] = value * 0.0166666666666666
        returnDict['mm3/sec'] = value * 0.000277777777777777
        returnDict['ft3/hour'] = value * 3.53146667214885e-08
        returnDict['ft3/min'] = value * 5.88577778691476e-10
        returnDict['ft3/sec'] = value * 9.80962964485794e-12
        returnDict['gal(us)/hour'] = value * 2.64172052358148e-07
        returnDict['gal(us)/min'] = value * 4.40286753930247e-09
        returnDict['gal(us)/sec'] = value * 7.33811256550412e-11
        returnDict['gal(I)/hour'] = value * 2.19969248299087e-07
        returnDict['gal(I)/min'] = value * 3.66615413831812e-09
        returnDict['gal(I)/sec'] = value * 6.11025689719688e-11
        returnDict['cm3/hour'] = value * 0.001
        returnDict['cm3/min'] = value * 1.6666666666666667e-05
        returnDict['cm3/sec'] = value * 2.7777777777777776e-07
    elif units == 'mm3/min':
        returnDict['L/hour'] = value * 6.0000000000000245e-05
        returnDict['L/min'] = value * 1e-06
        returnDict['L/sec'] = value * 1.6666666666666667e-08
        returnDict['mL/hour'] = value * 0.06000000000000024
        returnDict['mL/min'] = value * 0.001
        returnDict['mL/sec'] = value * 1.6666666666666667e-05
        returnDict['m3/hour'] = value * 6.000000000000023e-08
        returnDict['m3/min'] = value * 1e-09
        returnDict['m3/sec'] = value * 1.6666666666666667e-11
        returnDict['mm3/hour'] = value * 60.00000000000024
        returnDict['mm3/min'] = value * 1.0
        returnDict['mm3/sec'] = value * 0.0166666666666666
        returnDict['ft3/hour'] = value * 2.11888000328931e-06
        returnDict['ft3/min'] = value * 3.53146667214885e-08
        returnDict['ft3/sec'] = value * 5.88577778691476e-10
        returnDict['gal(us)/hour'] = value * 1.58503231414889e-05
        returnDict['gal(us)/min'] = value * 2.64172052358148e-07
        returnDict['gal(us)/sec'] = value * 4.40286753930247e-09
        returnDict['gal(I)/hour'] = value * 1.31981548979452e-05
        returnDict['gal(I)/min'] = value * 2.19969248299087e-07
        returnDict['gal(I)/sec'] = value * 3.66615413831812e-09
        returnDict['cm3/hour'] = value * 0.06000000000000024
        returnDict['cm3/min'] = value * 0.001
        returnDict['cm3/sec'] = value * 1.6666666666666667e-05
    elif units == 'mm3/sec':
        returnDict['L/hour'] = value * 0.0036000000000000103
        returnDict['L/min'] = value * 6.0000000000000245e-05
        returnDict['L/sec'] = value * 1e-06
        returnDict['mL/hour'] = value * 3.60000000000001
        returnDict['mL/min'] = value * 0.06000000000000024
        returnDict['mL/sec'] = value * 0.001
        returnDict['m3/hour'] = value * 3.60000000000001e-06
        returnDict['m3/min'] = value * 6.000000000000023e-08
        returnDict['m3/sec'] = value * 1e-09
        returnDict['mm3/hour'] = value * 3600.00000000001
        returnDict['mm3/min'] = value * 60.00000000000024
        returnDict['mm3/sec'] = value * 1.0
        returnDict['ft3/hour'] = value * 0.000127132800197358
        returnDict['ft3/min'] = value * 2.11888000328931e-06
        returnDict['ft3/sec'] = value * 3.53146667214885e-08
        returnDict['gal(us)/hour'] = value * 0.000951019388489334
        returnDict['gal(us)/min'] = value * 1.58503231414889e-05
        returnDict['gal(us)/sec'] = value * 2.64172052358148e-07
        returnDict['gal(I)/hour'] = value * 0.000791889293876716
        returnDict['gal(I)/min'] = value * 1.31981548979452e-05
        returnDict['gal(I)/sec'] = value * 2.19969248299087e-07
        returnDict['cm3/hour'] = value * 3.60000000000001
        returnDict['cm3/min'] = value * 0.06000000000000024
        returnDict['cm3/sec'] = value * 0.001
    elif units == 'ft3/hour':
        returnDict['L/hour'] = value * 28.316846592000072
        returnDict['L/min'] = value * 0.4719474432000012
        returnDict['L/sec'] = value * 0.007865790720000057
        returnDict['mL/hour'] = value * 28316.846592000074
        returnDict['mL/min'] = value * 471.94744320000126
        returnDict['mL/sec'] = value * 7.8657907200000565
        returnDict['m3/hour'] = value * 0.028316846592000074
        returnDict['m3/min'] = value * 0.0004719474432000012
        returnDict['m3/sec'] = value * 7.865790720000058e-06
        returnDict['mm3/hour'] = value * 28316846.592000075
        returnDict['mm3/min'] = value * 471947.44320000114
        returnDict['mm3/sec'] = value * 7865.790720000058
        returnDict['ft3/hour'] = value * 1.0
        returnDict['ft3/min'] = value * 0.0166666666666666
        returnDict['ft3/sec'] = value * 0.000277777777777777
        returnDict['gal(us)/hour'] = value * 7.48051948051948
        returnDict['gal(us)/min'] = value * 0.124675324675324
        returnDict['gal(us)/sec'] = value * 0.00207792207792207
        returnDict['gal(I)/hour'] = value * 6.22883545904282
        returnDict['gal(I)/min'] = value * 0.10381392431738
        returnDict['gal(I)/sec'] = value * 0.00173023207195634
        returnDict['cm3/hour'] = value * 28316.846592000074
        returnDict['cm3/min'] = value * 471.94744320000126
        returnDict['cm3/sec'] = value * 7.8657907200000565
    elif units == 'ft3/min':
        returnDict['L/hour'] = value * 1699.0107955200017
        returnDict['L/min'] = value * 28.316846592000072
        returnDict['L/sec'] = value * 0.4719474432000012
        returnDict['mL/hour'] = value * 1699010.7955200013
        returnDict['mL/min'] = value * 28316.846592000074
        returnDict['mL/sec'] = value * 471.94744320000126
        returnDict['m3/hour'] = value * 1.6990107955200016
        returnDict['m3/min'] = value * 0.028316846592000074
        returnDict['m3/sec'] = value * 0.0004719474432000012
        returnDict['mm3/hour'] = value * 1699010795.5200014
        returnDict['mm3/min'] = value * 28316846.592000075
        returnDict['mm3/sec'] = value * 471947.44320000114
        returnDict['ft3/hour'] = value * 60.00000000000024
        returnDict['ft3/min'] = value * 1.0
        returnDict['ft3/sec'] = value * 0.0166666666666666
        returnDict['gal(us)/hour'] = value * 448.831168831168
        returnDict['gal(us)/min'] = value * 7.48051948051948
        returnDict['gal(us)/sec'] = value * 0.124675324675324
        returnDict['gal(I)/hour'] = value * 373.730127542569
        returnDict['gal(I)/min'] = value * 6.22883545904282
        returnDict['gal(I)/sec'] = value * 0.10381392431738
        returnDict['cm3/hour'] = value * 1699010.7955200013
        returnDict['cm3/min'] = value * 28316.846592000074
        returnDict['cm3/sec'] = value * 471.94744320000126
    elif units == 'ft3/sec':
        returnDict['L/hour'] = value * 101940.6477312
        returnDict['L/min'] = value * 1699.0107955200017
        returnDict['L/sec'] = value * 28.316846592000072
        returnDict['mL/hour'] = value * 101940647.73120002
        returnDict['mL/min'] = value * 1699010.7955200013
        returnDict['mL/sec'] = value * 28316.846592000074
        returnDict['m3/hour'] = value * 101.94064773120002
        returnDict['m3/min'] = value * 1.6990107955200016
        returnDict['m3/sec'] = value * 0.028316846592000074
        returnDict['mm3/hour'] = value * 101940647731.20001
        returnDict['mm3/min'] = value * 1699010795.5200014
        returnDict['mm3/sec'] = value * 28316846.592000075
        returnDict['ft3/hour'] = value * 3600.00000000001
        returnDict['ft3/min'] = value * 60.00000000000024
        returnDict['ft3/sec'] = value * 1.0
        returnDict['gal(us)/hour'] = value * 26929.8701298701
        returnDict['gal(us)/min'] = value * 448.831168831168
        returnDict['gal(us)/sec'] = value * 7.48051948051948
        returnDict['gal(I)/hour'] = value * 22423.8076525541
        returnDict['gal(I)/min'] = value * 373.730127542569
        returnDict['gal(I)/sec'] = value * 6.22883545904282
        returnDict['cm3/hour'] = value * 101940647.73120002
        returnDict['cm3/min'] = value * 1699010.7955200013
        returnDict['cm3/sec'] = value * 28316.846592000074
    elif units == 'gal(us)/hour':
        returnDict['L/hour'] = value * 3.785411784000006
        returnDict['L/min'] = value * 0.06309019640000002
        returnDict['L/sec'] = value * 0.0010515032733333337
        returnDict['mL/hour'] = value * 3785.411784000006
        returnDict['mL/min'] = value * 63.09019640000002
        returnDict['mL/sec'] = value * 1.0515032733333336
        returnDict['m3/hour'] = value * 0.0037854117840000062
        returnDict['m3/min'] = value * 6.309019640000002e-05
        returnDict['m3/sec'] = value * 1.0515032733333336e-06
        returnDict['mm3/hour'] = value * 3785411.7840000056
        returnDict['mm3/min'] = value * 63090.196400000015
        returnDict['mm3/sec'] = value * 1051.5032733333337
        returnDict['ft3/hour'] = value * 0.13368055555555555
        returnDict['ft3/min'] = value * 0.0022280092592592633
        returnDict['ft3/sec'] = value * 3.713348765432103e-05
        returnDict['gal(us)/hour'] = value * 1.0
        returnDict['gal(us)/min'] = value * 0.0166666666666666
        returnDict['gal(us)/sec'] = value * 0.000277777777777777
        returnDict['gal(I)/hour'] = value * 0.832674184628988
        returnDict['gal(I)/min'] = value * 0.0138779030771498
        returnDict['gal(I)/sec'] = value * 0.000231298384619163
        returnDict['cm3/hour'] = value * 3785.411784000006
        returnDict['cm3/min'] = value * 63.09019640000002
        returnDict['cm3/sec'] = value * 1.0515032733333336
    elif units == 'gal(us)/min':
        returnDict['L/hour'] = value * 227.12470704000017
        returnDict['L/min'] = value * 3.785411784000006
        returnDict['L/sec'] = value * 0.06309019640000002
        returnDict['mL/hour'] = value * 227124.70704000018
        returnDict['mL/min'] = value * 3785.411784000006
        returnDict['mL/sec'] = value * 63.09019640000002
        returnDict['m3/hour'] = value * 0.22712470704000018
        returnDict['m3/min'] = value * 0.0037854117840000062
        returnDict['m3/sec'] = value * 6.309019640000002e-05
        returnDict['mm3/hour'] = value * 227124707.0400002
        returnDict['mm3/min'] = value * 3785411.7840000056
        returnDict['mm3/sec'] = value * 63090.196400000015
        returnDict['ft3/hour'] = value * 8.020833333333377
        returnDict['ft3/min'] = value * 0.13368055555555555
        returnDict['ft3/sec'] = value * 0.0022280092592592633
        returnDict['gal(us)/hour'] = value * 60.00000000000024
        returnDict['gal(us)/min'] = value * 1.0
        returnDict['gal(us)/sec'] = value * 0.0166666666666666
        returnDict['gal(I)/hour'] = value * 49.9604510777393
        returnDict['gal(I)/min'] = value * 0.832674184628988
        returnDict['gal(I)/sec'] = value * 0.0138779030771498
        returnDict['cm3/hour'] = value * 227124.70704000018
        returnDict['cm3/min'] = value * 3785.411784000006
        returnDict['cm3/sec'] = value * 63.09019640000002
    elif units == 'gal(us)/sec':
        returnDict['L/hour'] = value * 13627.482422400004
        returnDict['L/min'] = value * 227.12470704000017
        returnDict['L/sec'] = value * 3.785411784000006
        returnDict['mL/hour'] = value * 13627482.422400005
        returnDict['mL/min'] = value * 227124.70704000018
        returnDict['mL/sec'] = value * 3785.411784000006
        returnDict['m3/hour'] = value * 13.627482422400005
        returnDict['m3/min'] = value * 0.22712470704000018
        returnDict['m3/sec'] = value * 0.0037854117840000062
        returnDict['mm3/hour'] = value * 13627482422.400003
        returnDict['mm3/min'] = value * 227124707.0400002
        returnDict['mm3/sec'] = value * 3785411.7840000056
        returnDict['ft3/hour'] = value * 481.2500000000018
        returnDict['ft3/min'] = value * 8.020833333333377
        returnDict['ft3/sec'] = value * 0.13368055555555555
        returnDict['gal(us)/hour'] = value * 3600.00000000001
        returnDict['gal(us)/min'] = value * 60.00000000000024
        returnDict['gal(us)/sec'] = value * 1.0
        returnDict['gal(I)/hour'] = value * 2997.62706466435
        returnDict['gal(I)/min'] = value * 49.9604510777393
        returnDict['gal(I)/sec'] = value * 0.832674184628988
        returnDict['cm3/hour'] = value * 13627482.422400005
        returnDict['cm3/min'] = value * 227124.70704000018
        returnDict['cm3/sec'] = value * 3785.411784000006
    elif units == 'gal(I)/hour':
        returnDict['L/hour'] = value * 4.546090000000016
        returnDict['L/min'] = value * 0.07576816666666705
        returnDict['L/sec'] = value * 0.0012628027777777779
        returnDict['mL/hour'] = value * 4546.0900000000165
        returnDict['mL/min'] = value * 75.76816666666706
        returnDict['mL/sec'] = value * 1.2628027777777777
        returnDict['m3/hour'] = value * 0.004546090000000016
        returnDict['m3/min'] = value * 7.576816666666705e-05
        returnDict['m3/sec'] = value * 1.2628027777777776e-06
        returnDict['mm3/hour'] = value * 4546090.000000017
        returnDict['mm3/min'] = value * 75768.16666666705
        returnDict['mm3/sec'] = value * 1262.802777777778
        returnDict['ft3/hour'] = value * 0.16054365323589223
        returnDict['ft3/min'] = value * 0.0026757275539315384
        returnDict['ft3/sec'] = value * 4.459545923219238e-05
        returnDict['gal(us)/hour'] = value * 1.2009499255048561
        returnDict['gal(us)/min'] = value * 0.020015832091747596
        returnDict['gal(us)/sec'] = value * 0.00033359720152912746
        returnDict['gal(I)/hour'] = value * 1.0
        returnDict['gal(I)/min'] = value * 0.0166666666666666
        returnDict['gal(I)/sec'] = value * 0.000277777777777777
        returnDict['cm3/hour'] = value * 4546.0900000000165
        returnDict['cm3/min'] = value * 75.76816666666706
        returnDict['cm3/sec'] = value * 1.2628027777777777
    elif units == 'gal(I)/min':
        returnDict['L/hour'] = value * 272.76540000000074
        returnDict['L/min'] = value * 4.546090000000016
        returnDict['L/sec'] = value * 0.07576816666666705
        returnDict['mL/hour'] = value * 272765.4000000007
        returnDict['mL/min'] = value * 4546.0900000000165
        returnDict['mL/sec'] = value * 75.76816666666706
        returnDict['m3/hour'] = value * 0.2727654000000007
        returnDict['m3/min'] = value * 0.004546090000000016
        returnDict['m3/sec'] = value * 7.576816666666705e-05
        returnDict['mm3/hour'] = value * 272765400.0000007
        returnDict['mm3/min'] = value * 4546090.000000017
        returnDict['mm3/sec'] = value * 75768.16666666705
        returnDict['ft3/hour'] = value * 9.632619194153564
        returnDict['ft3/min'] = value * 0.16054365323589223
        returnDict['ft3/sec'] = value * 0.0026757275539315384
        returnDict['gal(us)/hour'] = value * 72.05699553029137
        returnDict['gal(us)/min'] = value * 1.2009499255048561
        returnDict['gal(us)/sec'] = value * 0.020015832091747596
        returnDict['gal(I)/hour'] = value * 60.00000000000024
        returnDict['gal(I)/min'] = value * 1.0
        returnDict['gal(I)/sec'] = value * 0.0166666666666666
        returnDict['cm3/hour'] = value * 272765.4000000007
        returnDict['cm3/min'] = value * 4546.0900000000165
        returnDict['cm3/sec'] = value * 75.76816666666706
    elif units == 'gal(I)/sec':
        returnDict['L/hour'] = value * 16365.92400000001
        returnDict['L/min'] = value * 272.76540000000074
        returnDict['L/sec'] = value * 4.546090000000016
        returnDict['mL/hour'] = value * 16365924.00000001
        returnDict['mL/min'] = value * 272765.4000000007
        returnDict['mL/sec'] = value * 4546.0900000000165
        returnDict['m3/hour'] = value * 16.365924000000007
        returnDict['m3/min'] = value * 0.2727654000000007
        returnDict['m3/sec'] = value * 0.004546090000000016
        returnDict['mm3/hour'] = value * 16365924000.000008
        returnDict['mm3/min'] = value * 272765400.0000007
        returnDict['mm3/sec'] = value * 4546090.000000017
        returnDict['ft3/hour'] = value * 577.9571516492116
        returnDict['ft3/min'] = value * 9.632619194153564
        returnDict['ft3/sec'] = value * 0.16054365323589223
        returnDict['gal(us)/hour'] = value * 4323.419731817488
        returnDict['gal(us)/min'] = value * 72.05699553029137
        returnDict['gal(us)/sec'] = value * 1.2009499255048561
        returnDict['gal(I)/hour'] = value * 3600.00000000001
        returnDict['gal(I)/min'] = value * 60.00000000000024
        returnDict['gal(I)/sec'] = value * 1.0
        returnDict['cm3/hour'] = value * 16365924.00000001
        returnDict['cm3/min'] = value * 272765.4000000007
        returnDict['cm3/sec'] = value * 4546.0900000000165
    elif units == 'cm3/hour':
        returnDict['L/hour'] = value * 0.001
        returnDict['L/min'] = value * 1.6666666666666667e-05
        returnDict['L/sec'] = value * 2.7777777777777776e-07
        returnDict['mL/hour'] = value * 1.0
        returnDict['mL/min'] = value * 0.0166666666666666
        returnDict['mL/sec'] = value * 0.000277777777777777
        returnDict['m3/hour'] = value * 1e-06
        returnDict['m3/min'] = value * 1.66666666666666e-08
        returnDict['m3/sec'] = value * 2.77777777777777e-10
        returnDict['mm3/hour'] = value * 1000.0
        returnDict['mm3/min'] = value * 16.6666666666666
        returnDict['mm3/sec'] = value * 0.277777777777777
        returnDict['ft3/hour'] = value * 3.53146667214885e-05
        returnDict['ft3/min'] = value * 5.88577778691476e-07
        returnDict['ft3/sec'] = value * 9.80962964485794e-09
        returnDict['gal(us)/hour'] = value * 0.000264172052358148
        returnDict['gal(us)/min'] = value * 4.40286753930247e-06
        returnDict['gal(us)/sec'] = value * 7.33811256550412e-08
        returnDict['gal(I)/hour'] = value * 0.000219969248299087
        returnDict['gal(I)/min'] = value * 3.66615413831812e-06
        returnDict['gal(I)/sec'] = value * 6.11025689719688e-08
        returnDict['cm3/hour'] = value * 1.0
        returnDict['cm3/min'] = value * 0.0166666666666666
        returnDict['cm3/sec'] = value * 0.000277777777777777
    elif units == 'cm3/min':
        returnDict['L/hour'] = value * 0.06000000000000024
        returnDict['L/min'] = value * 0.001
        returnDict['L/sec'] = value * 1.6666666666666667e-05
        returnDict['mL/hour'] = value * 60.00000000000024
        returnDict['mL/min'] = value * 1.0
        returnDict['mL/sec'] = value * 0.0166666666666666
        returnDict['m3/hour'] = value * 5.9999999999999995e-05
        returnDict['m3/min'] = value * 1e-06
        returnDict['m3/sec'] = value * 1.66666666666666e-08
        returnDict['mm3/hour'] = value * 60000.0
        returnDict['mm3/min'] = value * 1000.0
        returnDict['mm3/sec'] = value * 16.6666666666666
        returnDict['ft3/hour'] = value * 0.00211888000328931
        returnDict['ft3/min'] = value * 3.53146667214885e-05
        returnDict['ft3/sec'] = value * 5.88577778691476e-07
        returnDict['gal(us)/hour'] = value * 0.0158503231414889
        returnDict['gal(us)/min'] = value * 0.000264172052358148
        returnDict['gal(us)/sec'] = value * 4.40286753930247e-06
        returnDict['gal(I)/hour'] = value * 0.0131981548979452
        returnDict['gal(I)/min'] = value * 0.000219969248299087
        returnDict['gal(I)/sec'] = value * 3.66615413831812e-06
        returnDict['cm3/hour'] = value * 60.00000000000024
        returnDict['cm3/min'] = value * 1.0
        returnDict['cm3/sec'] = value * 0.0166666666666666
    elif units == 'cm3/sec':
        returnDict['L/hour'] = value * 3.60000000000001
        returnDict['L/min'] = value * 0.06000000000000024
        returnDict['L/sec'] = value * 0.001
        returnDict['mL/hour'] = value * 3600.00000000001
        returnDict['mL/min'] = value * 60.00000000000024
        returnDict['mL/sec'] = value * 1.0
        returnDict['m3/hour'] = value * 0.0036
        returnDict['m3/min'] = value * 5.9999999999999995e-05
        returnDict['m3/sec'] = value * 1e-06
        returnDict['mm3/hour'] = value * 3600000.0000000005
        returnDict['mm3/min'] = value * 60000.0
        returnDict['mm3/sec'] = value * 1000.0
        returnDict['ft3/hour'] = value * 0.127132800197358
        returnDict['ft3/min'] = value * 0.00211888000328931
        returnDict['ft3/sec'] = value * 3.53146667214885e-05
        returnDict['gal(us)/hour'] = value * 0.9510193884893341
        returnDict['gal(us)/min'] = value * 0.0158503231414889
        returnDict['gal(us)/sec'] = value * 0.000264172052358148
        returnDict['gal(I)/hour'] = value * 0.791889293876716
        returnDict['gal(I)/min'] = value * 0.0131981548979452
        returnDict['gal(I)/sec'] = value * 0.000219969248299087
        returnDict['cm3/hour'] = value * 3600.00000000001
        returnDict['cm3/min'] = value * 60.00000000000024
        returnDict['cm3/sec'] = value * 1.0
    return returnDict


def energy(value, units):
    returnDict = {}
    if units == 'boe':
        returnDict['boe'] = value
        returnDict['BTU'] = value * 5581322.842616
        returnDict['cal'] = value * 1406469952.67921
        returnDict['nat gas ft3'] = value * 5416.3057397
        returnDict['ft-lb'] = value * 4343441900.86848
        returnDict['ft-pdl'] = value * 139882778010.426
        returnDict['gJ'] = value * 5.8886076
        returnDict['HP-hr'] = value * 2192.343481
        returnDict['J'] = value * 5888589439.57291
        returnDict['kcal'] = value * 1406469.9526792
        returnDict['kg-m'] = value * 600471531.981624
        returnDict['kJ'] = value * 5888589.4395729
        returnDict['kW-hr'] = value * 1635.7243319
        returnDict['L-atm'] = value * 58116017.5037277
        returnDict['mJ'] = value * 5888.5894396
        returnDict['Nm'] = value * 5888713697.63241
        returnDict['therm'] = value * 55.8132284
        returnDict['thermie'] = value * 1406.8057707
        returnDict['ton-exp'] = value * 1.407411
        returnDict['tce'] = value * 0.2009243
        returnDict['toe'] = value * 0.140647
        returnDict['W-hr'] = value * 1635724.3222815
    elif units == 'BTU':
        returnDict['boe'] = value * 1.7246e-07
        returnDict['BTU'] = value
        returnDict['cal'] = value * 251.9958068
        returnDict['nat gas ft3'] = value * 0.0009704
        returnDict['ft-lb'] = value * 778.2101167
        returnDict['ft-pdl'] = value * 25062.6566416
        returnDict['gJ'] = value * 1.1e-06
        returnDict['HP-hr'] = value * 0.0003928
        returnDict['J'] = value * 1055.0526471
        returnDict['kcal'] = value * 0.2519958
        returnDict['kg-m'] = value * 107.5858804
        returnDict['kJ'] = value * 1.0550526
        returnDict['kW-hr'] = value * 0.0002931
        returnDict['L-atm'] = value * 10.4125884
        returnDict['mJ'] = value * 0.0010551
        returnDict['Nm'] = value * 1055.0749103
        returnDict['therm'] = value * 1e-05
        returnDict['thermie'] = value * 0.0002521
        returnDict['ton-exp'] = value * 2.521644e-07
        returnDict['tce'] = value * 3.6e-08
        returnDict['toe'] = value * 2.5219e-08
        returnDict['W-hr'] = value * 0.2930711
    elif units == 'cal':
        returnDict['boe'] = value * 6.839e-07
        returnDict['BTU'] = value * 0.0039683
        returnDict['cal'] = value
        returnDict['nat gas ft3'] = value * 3.9e-06
        returnDict['ft-lb'] = value * 3.0881868
        returnDict['ft-pdl'] = value * 99.4566416
        returnDict['gJ'] = value * 4.1858e-09
        returnDict['HP-hr'] = value * 1.6e-06
        returnDict['J'] = value * 4.1867865
        returnDict['kcal'] = value * 0.001
        returnDict['kg-m'] = value * 0.4269352
        returnDict['kJ'] = value * 0.0041868
        returnDict['kW-hr'] = value * 1.2e-06
        returnDict['L-atm'] = value * 0.0413205
        returnDict['mJ'] = value * 4.2e-06
        returnDict['Nm'] = value * 4.1868749
        returnDict['therm'] = value * 3.96661e-05
        returnDict['thermie'] = value * 1e-06
        returnDict['ton-exp'] = value * 1.000430210325e-09
        returnDict['tce'] = value * 1.42761604e-10
        returnDict['toe'] = value * 9.9933123e-11
        returnDict['W-hr'] = value * 0.001163
    elif units == 'nat gas ft3':
        returnDict['boe'] = value * 0.0001846
        returnDict['BTU'] = value * 1030.466726
        returnDict['cal'] = value * 259673.2939884
        returnDict['nat gas ft3'] = value
        returnDict['ft-lb'] = value * 801919.6311284
        returnDict['ft-pdl'] = value * 25826233.7343358
        returnDict['gJ'] = value * 0.0010872
        returnDict['HP-hr'] = value * 0.4047673
        returnDict['J'] = value * 1087196.6470427
        returnDict['kcal'] = value * 259.673294
        returnDict['kg-m'] = value * 110863.6699696
        returnDict['kJ'] = value * 1087.196647
        returnDict['kW-hr'] = value * 0.302
        returnDict['L-atm'] = value * 10729.8258807
        returnDict['mJ'] = value * 1.0871966
        returnDict['Nm'] = value * 1087219.5885208
        returnDict['therm'] = value * 0.0103047
        returnDict['thermie'] = value * 0.2597353
        returnDict['ton-exp'] = value * 0.0002598
        returnDict['tce'] = value * 3.71e-05
        returnDict['toe'] = value * 2.6e-05
        returnDict['W-hr'] = value * 301.9999979
    elif units == 'ft-lb':
        returnDict['boe'] = value * 2.2e-10
        returnDict['BTU'] = value * 0.001285
        returnDict['cal'] = value * 0.3238146
        returnDict['nat gas ft3'] = value * 1.2e-06
        returnDict['ft-lb'] = value
        returnDict['ft-pdl'] = value * 32.2055138
        returnDict['gJ'] = value * 1.3558179e-09
        returnDict['HP-hr'] = value * 0.000000505
        returnDict['J'] = value * 1.3557427
        returnDict['kcal'] = value * 0.0003238
        returnDict['kg-m'] = value * 0.1382479
        returnDict['kJ'] = value * 0.0013557
        returnDict['kW-hr'] = value * 3.76616e-07
        returnDict['L-atm'] = value * 0.0133802
        returnDict['mJ'] = value * 1.4e-06
        returnDict['Nm'] = value * 1.3557713
        returnDict['therm'] = value * 1.28537e-08
        returnDict['thermie'] = value * 3.2390891646752e-07
        returnDict['ton-exp'] = value * 3.24e-10
        returnDict['tce'] = value * 4.6e-11
        returnDict['toe'] = value * 3.2383155353287e-11
        returnDict['W-hr'] = value * 0.0003766
    elif units == 'ft-pdl':
        returnDict['boe'] = value * 6.88804386698e-12
        returnDict['BTU'] = value * 3.99e-05
        returnDict['cal'] = value * 0.010071728
        returnDict['nat gas ft3'] = value * 3.99411177988e-08
        returnDict['ft-lb'] = value * 0.0310506
        returnDict['ft-pdl'] = value
        returnDict['gJ'] = value * 4.2140110093805e-11
        returnDict['HP-hr'] = value * 1.56974495816e-08
        returnDict['J'] = value * 0.0420966
        returnDict['kcal'] = value * 1.01e-05
        returnDict['kg-m'] = value * 0.0042927
        returnDict['kJ'] = value * 4.21e-05
        returnDict['kW-hr'] = value * 1.17055861372e-08
        returnDict['L-atm'] = value * 0.0004155
        returnDict['mJ'] = value * 4.21401100938e-08
        returnDict['Nm'] = value * 0.0420975
        returnDict['therm'] = value * 3.99506544285e-06
        returnDict['thermie'] = value * 0.00010064992379335
        returnDict['ton-exp'] = value * 1.0071728033891e-07
        returnDict['tce'] = value * 1.43785605419e-12
        returnDict['toe'] = value * 1.00649923793e-12
        returnDict['W-hr'] = value * 1.17e-05
    elif units == 'gJ':
        returnDict['boe'] = value * 0.1698194
        returnDict['BTU'] = value * 947817.0777
        returnDict['cal'] = value * 238845929.184138
        returnDict['nat gas ft3'] = value * 919.7939669
        returnDict['ft-lb'] = value * 737600838.677042
        returnDict['ft-pdl'] = value * 23754813977.4436
        returnDict['gJ'] = value
        returnDict['HP-hr'] = value * 372.3025258
        returnDict['J'] = value * 999996916.819649
        returnDict['kcal'] = value * 238845.9291841
        returnDict['kg-m'] = value * 101971734.790046
        returnDict['kJ'] = value * 999996.9168196
        returnDict['kW-hr'] = value * 277.7777778
        returnDict['L-atm'] = value * 9869229.1113064
        returnDict['mJ'] = value * 999.9969168
        returnDict['Nm'] = value * 1000018018.25279
        returnDict['therm'] = value * 9.4781708
        returnDict['thermie'] = value * 238.9029576
        returnDict['ton-exp'] = value * 0.2390057
        returnDict['tce'] = value * 0.0341208
        returnDict['toe'] = value * 0.0238846
        returnDict['W-hr'] = value * 277777.7761268
    elif units == 'HP-hr':
        returnDict['boe'] = value * 0.0004561
        returnDict['BTU'] = value * 2545.825
        returnDict['cal'] = value * 641537.2248206
        returnDict['nat gas ft3'] = value * 2.4705553
        returnDict['ft-lb'] = value * 1981186.770428
        returnDict['ft-pdl'] = value * 63805137.8446115
        returnDict['gJ'] = value * 0.002686
        returnDict['HP-hr'] = value * 1
        returnDict['J'] = value * 2685979.4053723
        returnDict['kcal'] = value * 641.5372248
        returnDict['kg-m'] = value * 273894.8240433
        returnDict['kJ'] = value * 2685.9794054
        returnDict['kW-hr'] = value * 0.7461077
        returnDict['L-atm'] = value * 26508.6278708
        returnDict['mJ'] = value * 2.6859794
        returnDict['Nm'] = value * 2686036.0835619
        returnDict['therm'] = value * 0.0254582
        returnDict['thermie'] = value * 0.6416904
        returnDict['ton-exp'] = value * 0.000642
        returnDict['tce'] = value * 9.16e-05
        returnDict['toe'] = value * 6.42e-05
        returnDict['W-hr'] = value * 746.1076863
    elif units == 'J':
        returnDict['boe'] = value * 1.63456e-10
        returnDict['BTU'] = value * 0.0009478
        returnDict['cal'] = value * 0.2388467
        returnDict['nat gas ft3'] = value * 9.4781712e-07
        returnDict['ft-lb'] = value * 0.7376031
        returnDict['ft-pdl'] = value * 23.7548872
        returnDict['gJ'] = value * 1e-09
        returnDict['HP-hr'] = value * 3.7250613599862e-07
        returnDict['J'] = value
        returnDict['kcal'] = value * 0.0002388
        returnDict['kg-m'] = value * 0.101972
        returnDict['kJ'] = value * 0.001
        returnDict['kW-hr'] = value * 2.7777777777778e-07
        returnDict['L-atm'] = value * 0.0098693
        returnDict['mJ'] = value * 1e-06
        returnDict['Nm'] = value * 1.0000211
        returnDict['therm'] = value * 9.4804342797335e-09
        returnDict['thermie'] = value * 2.388458966275e-07
        returnDict['ton-exp'] = value * 2.3900573613767e-10
        returnDict['tce'] = value * 3.4143676591095e-11
        returnDict['toe'] = value * 2.388458966275e-11
        returnDict['W-hr'] = value * 0.00027777777777778
    elif units == 'kcal':
        returnDict['boe'] = value * 0.0006839
        returnDict['BTU'] = value * 3.9683
        returnDict['cal'] = value * 1000.0
        returnDict['nat gas ft3'] = value * 0.0039
        returnDict['ft-lb'] = value * 3088.1868
        returnDict['ft-pdl'] = value * 99456.6416
        returnDict['gJ'] = value * 4.1858e-06
        returnDict['HP-hr'] = value * 0.0015999999999999999
        returnDict['J'] = value * 4186.7865
        returnDict['kcal'] = value
        returnDict['kg-m'] = value * 426.9352
        returnDict['kJ'] = value * 4.1868
        returnDict['kW-hr'] = value * 0.0012
        returnDict['L-atm'] = value * 41.3205
        returnDict['mJ'] = value * 0.0042
        returnDict['Nm'] = value * 4186.874900000001
        returnDict['therm'] = value * 0.0396661
        returnDict['thermie'] = value * 0.001
        returnDict['ton-exp'] = value * 1.000430210325e-06
        returnDict['tce'] = value * 1.42761604e-07
        returnDict['toe'] = value * 9.9933123e-08
        returnDict['W-hr'] = value * 1.1629998
    elif units == 'kg-m':
        returnDict['boe'] = value * 1.6029516065e-09
        returnDict['BTU'] = value * 0.0092949
        returnDict['cal'] = value * 2.3422758
        returnDict['nat gas ft3'] = value * 9e-06
        returnDict['ft-lb'] = value * 7.2333852
        returnDict['ft-pdl'] = value * 232.9548872
        returnDict['gJ'] = value * 9.8068158e-09
        returnDict['HP-hr'] = value * 3.7e-06
        returnDict['J'] = value * 9.8066088
        returnDict['kcal'] = value * 0.0023423
        returnDict['kg-m'] = value
        returnDict['kJ'] = value * 0.0098066
        returnDict['kW-hr'] = value * 2.7e-06
        returnDict['L-atm'] = value * 0.096784
        returnDict['mJ'] = value * 9.8e-06
        returnDict['Nm'] = value * 9.8068158
        returnDict['therm'] = value * 9.29728726853521e-08
        returnDict['thermie'] = value * 2.3e-06
        returnDict['ton-exp'] = value * 2.3438e-09
        returnDict['tce'] = value * 3.3484074706364e-10
        returnDict['toe'] = value * 2.3423177128117e-10
        returnDict['W-hr'] = value * 0.0027241
    elif units == 'kJ':
        returnDict['boe'] = value * 1.6345626e-07
        returnDict['BTU'] = value * 0.94782
        returnDict['cal'] = value * 238.8466656
        returnDict['nat gas ft3'] = value * 0.0009198
        returnDict['ft-lb'] = value * 737.6031128
        returnDict['ft-pdl'] = value * 23754.887218
        returnDict['gJ'] = value * 1e-06
        returnDict['HP-hr'] = value * 0.0003723
        returnDict['J'] = value * 1000.0
        returnDict['kcal'] = value * 0.2388467
        returnDict['kg-m'] = value * 101.9720492
        returnDict['kJ'] = value
        returnDict['kW-hr'] = value * 0.0002778
        returnDict['L-atm'] = value * 9.8692595
        returnDict['mJ'] = value * 0.001
        returnDict['Nm'] = value * 1000.0211015
        returnDict['therm'] = value * 9.5e-06
        returnDict['thermie'] = value * 0.0002389
        returnDict['ton-exp'] = value * 2.3900573613767e-07
        returnDict['tce'] = value * 3.41208423754e-08
        returnDict['toe'] = value * 2.388458966275e-08
        returnDict['W-hr'] = value * 0.2777786
    elif units == 'kW-hr':
        returnDict['boe'] = value * 0.0006113
        returnDict['BTU'] = value * 3412.1414799
        returnDict['cal'] = value * 859845.3451083
        returnDict['nat gas ft3'] = value * 3.3112583
        returnDict['ft-lb'] = value * 2655363.0193774
        returnDict['ft-pdl'] = value * 85517330.3233083
        returnDict['gJ'] = value * 0.0036
        returnDict['HP-hr'] = value * 1.3402891
        returnDict['J'] = value * 3599988.9007406
        returnDict['kcal'] = value * 859.8453451
        returnDict['kg-m'] = value * 367098.2452635
        returnDict['kJ'] = value * 3599.9889007
        returnDict['kW-hr'] = value
        returnDict['L-atm'] = value * 35529.2248026
        returnDict['mJ'] = value * 3.5999889
        returnDict['Nm'] = value * 3600064.8659
        returnDict['therm'] = value * 0.0341214
        returnDict['thermie'] = value * 0.8600506
        returnDict['ton-exp'] = value * 0.0008604
        returnDict['tce'] = value * 0.0001228
        returnDict['toe'] = value * 8.6e-05
        returnDict['W-hr'] = value * 999.9999941
    elif units == 'L-atm':
        returnDict['boe'] = value * 1.7e-08
        returnDict['BTU'] = value * 0.0960376
        returnDict['cal'] = value * 24.2010725
        returnDict['nat gas ft3'] = value * 9.32e-05
        returnDict['ft-lb'] = value * 74.7374319
        returnDict['ft-pdl'] = value * 2406.9573935
        returnDict['gJ'] = value * 1.01325e-07
        returnDict['HP-hr'] = value * 3.77e-05
        returnDict['J'] = value * 101.3247241
        returnDict['kcal'] = value * 0.0242011
        returnDict['kg-m'] = value * 10.3322898
        returnDict['kJ'] = value * 0.1013247
        returnDict['kW-hr'] = value * 2.81e-05
        returnDict['L-atm'] = value
        returnDict['mJ'] = value * 0.0001013
        returnDict['Nm'] = value * 101.3268622
        returnDict['therm'] = value * 1e-06
        returnDict['thermie'] = value * 2.42e-05
        returnDict['ton-exp'] = value * 2.4e-08
        returnDict['tce'] = value * 3.457e-09
        returnDict['toe'] = value * 2.42e-09
        returnDict['W-hr'] = value * 0.0281458
    elif units == 'mJ':
        returnDict['boe'] = value * 0.0001698
        returnDict['BTU'] = value * 947.82
        returnDict['cal'] = value * 238846.6655915
        returnDict['nat gas ft3'] = value * 0.9197968
        returnDict['ft-lb'] = value * 737603.1128405
        returnDict['ft-pdl'] = value * 23754887.2180451
        returnDict['gJ'] = value * 0.001
        returnDict['HP-hr'] = value * 0.3723037
        returnDict['J'] = value * 1000000.0
        returnDict['kcal'] = value * 238.8466656
        returnDict['kg-m'] = value * 101972.0491883
        returnDict['kJ'] = value * 1000.0
        returnDict['kW-hr'] = value * 0.2777786
        returnDict['L-atm'] = value * 9869.25954
        returnDict['mJ'] = value
        returnDict['Nm'] = value * 1000021.1014982
        returnDict['therm'] = value * 0.0094782
        returnDict['thermie'] = value * 0.2389037
        returnDict['ton-exp'] = value * 0.000239
        returnDict['tce'] = value * 3.41e-05
        returnDict['toe'] = value * 2.39e-05
        returnDict['W-hr'] = value * 277.7786326
    elif units == 'Nm':
        returnDict['boe'] = value * 1.63457588e-10
        returnDict['BTU'] = value * 0.0009478
        returnDict['cal'] = value * 0.2388416
        returnDict['nat gas ft3'] = value * 9.314822399999999e-07
        returnDict['ft-lb'] = value * 0.7375875
        returnDict['ft-pdl'] = value * 23.754386
        returnDict['gJ'] = value * 1e-09
        returnDict['HP-hr'] = value * 3.72506e-07
        returnDict['J'] = value * 0.9999789
        returnDict['kcal'] = value * 0.0002388
        returnDict['kg-m'] = value * 0.1019699
        returnDict['kJ'] = value * 0.001
        returnDict['kW-hr'] = value * 2.77778e-07
        returnDict['L-atm'] = value * 0.0098691
        returnDict['mJ'] = value * 1e-06
        returnDict['Nm'] = value
        returnDict['therm'] = value * 9.4804342797335e-09
        returnDict['thermie'] = value * 2.38902957618615e-07
        returnDict['ton-exp'] = value * 2.39e-10
        returnDict['tce'] = value * 3.4e-11
        returnDict['toe'] = value * 2.4e-11
        returnDict['W-hr'] = value * 0.0002778
    elif units == 'therm':
        returnDict['boe'] = value * 0.0179169
        returnDict['BTU'] = value * 100000.0
        returnDict['cal'] = value * 25199580.6789775
        returnDict['nat gas ft3'] = value * 97.0434052
        returnDict['ft-lb'] = value * 77821011.6731518
        returnDict['ft-pdl'] = value * 2506265664.1604
        returnDict['gJ'] = value * 0.1055056
        returnDict['HP-hr'] = value * 39.2799976
        returnDict['J'] = value * 105505264.712709
        returnDict['kcal'] = value * 25199.580679
        returnDict['kg-m'] = value * 10758588.0429052
        returnDict['kJ'] = value * 105505.2647127
        returnDict['kW-hr'] = value * 29.3071083
        returnDict['L-atm'] = value * 1041258.8402876
        returnDict['mJ'] = value * 105.5052647
        returnDict['Nm'] = value * 105507491.031863
        returnDict['therm'] = value
        returnDict['thermie'] = value * 25.2055975
        returnDict['ton-exp'] = value * 0.0252164
        returnDict['tce'] = value * 0.0035999
        returnDict['toe'] = value * 0.00252
        returnDict['W-hr'] = value * 29307.1081607
    elif units == 'thermie':
        returnDict['boe'] = value * 0.0007108
        returnDict['BTU'] = value * 3967.372724
        returnDict['cal'] = value * 999761.2904201
        returnDict['nat gas ft3'] = value * 3.8500736
        returnDict['ft-lb'] = value * 3087449.5906615
        returnDict['ft-pdl'] = value * 99432900.3508772
        returnDict['gJ'] = value * 0.0041858
        returnDict['HP-hr'] = value * 1.5583839
        returnDict['J'] = value * 4185787.094596
        returnDict['kcal'] = value * 999.7612904
        returnDict['kg-m'] = value * 426833.2875017
        returnDict['kJ'] = value * 4185.7870946
        returnDict['kW-hr'] = value * 1.1627222
        returnDict['L-atm'] = value * 41310.6192158
        returnDict['mJ'] = value * 4.1857871
        returnDict['Nm'] = value * 4185875.4209749
        returnDict['therm'] = value * 0.0396737
        returnDict['thermie'] = value
        returnDict['ton-exp'] = value * 0.0010004
        returnDict['tce'] = value * 0.0001428
        returnDict['toe'] = value * 0.0001
        returnDict['W-hr'] = value * 1162.7222154
    elif units == 'ton-exp':
        returnDict['boe'] = value * 0.7105245
        returnDict['BTU'] = value * 3965666.6533024
        returnDict['cal'] = value * 999331367.758245
        returnDict['nat gas ft3'] = value * 3848.4179578
        returnDict['ft-lb'] = value * 3086121909.18474
        returnDict['ft-pdl'] = value * 99390141686.7769
        returnDict['gJ'] = value * 4.184
        returnDict['HP-hr'] = value * 1557.713768
        returnDict['J'] = value * 4183987100.19033
        returnDict['kcal'] = value * 999331.3677582
        returnDict['kg-m'] = value * 426649738.383672
        returnDict['kJ'] = value * 4183987.1001903
        returnDict['kW-hr'] = value * 1162.2222222
        returnDict['L-atm'] = value * 41292854.6038468
        returnDict['mJ'] = value * 4183.9871002
        returnDict['Nm'] = value * 4184075388.58662
        returnDict['therm'] = value * 39.6566665
        returnDict['thermie'] = value * 999.5699747
        returnDict['ton-exp'] = value
        returnDict['tce'] = value * 0.1427616
        returnDict['toe'] = value * 0.0999331
        returnDict['W-hr'] = value * 1162222.2153748
    elif units == 'tce':
        returnDict['boe'] = value * 4.977
        returnDict['BTU'] = value * 27778243.787841
        returnDict['cal'] = value * 7000000954.52004
        returnDict['nat gas ft3'] = value * 26956.9536667
        returnDict['ft-lb'] = value * 21617310340.7322
        returnDict['ft-pdl'] = value * 696196586161.428
        returnDict['gJ'] = value * 29.3076
        returnDict['HP-hr'] = value * 10911.2935052
        returnDict['J'] = value * 29307509640.9033
        returnDict['kcal'] = value * 7000000.95452
        returnDict['kg-m'] = value * 2988546814.68773
        returnDict['kJ'] = value * 29307509.6409033
        returnDict['kW-hr'] = value * 8141.0
        returnDict['L-atm'] = value * 289243419.117522
        returnDict['mJ'] = value * 29307.5096409
        returnDict['Nm'] = value * 29308128073.2654
        returnDict['therm'] = value * 277.7824379
        returnDict['thermie'] = value * 7001.6723208
        returnDict['ton-exp'] = value * 7.0046845
        returnDict['tce'] = value
        returnDict['toe'] = value * 0.7
        returnDict['W-hr'] = value * 8140999.9520363
    elif units == 'toe':
        returnDict['boe'] = value * 7.11
        returnDict['BTU'] = value * 39683205.4112014
        returnDict['cal'] = value * 10000001363.6
        returnDict['nat gas ft3'] = value * 38509.9338095
        returnDict['ft-lb'] = value * 30881871915.3318
        returnDict['ft-pdl'] = value * 994566551659.183
        returnDict['gJ'] = value * 41.868
        returnDict['HP-hr'] = value * 15587.5621503
        returnDict['J'] = value * 41867870915.5761
        returnDict['kcal'] = value * 10000001.3636001
        returnDict['kg-m'] = value * 4269352592.41104
        returnDict['kJ'] = value * 41867870.9155762
        returnDict['kW-hr'] = value * 11630.0
        returnDict['L-atm'] = value * 413204884.453603
        returnDict['mJ'] = value * 41867.8709156
        returnDict['Nm'] = value * 41868754390.3791
        returnDict['therm'] = value * 396.8320541
        returnDict['thermie'] = value * 10002.3890297
        returnDict['ton-exp'] = value * 10.0066922
        returnDict['tce'] = value * 1.4285714
        returnDict['toe'] = value
        returnDict['W-hr'] = value * 11629999.9314804
    elif units == 'W-hr':
        returnDict['boe'] = value * 6.113499606126813e-07
        returnDict['BTU'] = value * 3.4121415
        returnDict['cal'] = value * 859.8453502
        returnDict['nat gas ft3'] = value * 0.0033113
        returnDict['ft-lb'] = value * 2655.363035
        returnDict['ft-pdl'] = value * 85517.3308271
        returnDict['gJ'] = value * 3.6e-06
        returnDict['HP-hr'] = value * 0.0013403
        returnDict['J'] = value * 3599.9889219
        returnDict['kcal'] = value * 0.8598454
        returnDict['kg-m'] = value * 367.0982474
        returnDict['kJ'] = value * 3.5999889
        returnDict['kW-hr'] = value * 0.001
        returnDict['L-atm'] = value * 35.529225
        returnDict['mJ'] = value * 0.0036
        returnDict['Nm'] = value * 3600.0648871
        returnDict['therm'] = value * 3.41e-05
        returnDict['thermie'] = value * 0.0008601
        returnDict['ton-exp'] = value * 8.604206551649113e-07
        returnDict['tce'] = value * 1.228350332749813e-07
        returnDict['toe'] = value * 8.598452329248711e-08
        returnDict['W-hr'] = value
    return returnDict


def temperature(value, units):
    returnDict = {}
    if units == 'c':
        returnDict['c'] = value
        returnDict['f'] = ((9/5) * value) + 32
        returnDict['k'] = value + 273.15
    elif units == 'f':
        returnDict['c'] = (5/9) * (value - 32)
        returnDict['f'] = value
        returnDict['k'] = ((5/9) * (value - 32)) + 273.15
    elif units == 'k':
        returnDict['c'] = value - 273.15
        returnDict['f'] = ((9/5) * (value - 273.15)) + 32
        returnDict['k'] = value
    return returnDict
