"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'Origin Access Identity with automatic comment'(test) {
        const stack = new cdk.Stack();
        new lib_1.OriginAccessIdentity(stack, 'OAI');
        assert_1.expect(stack).toMatch({
            'Resources': {
                'OAIE1EFC67F': {
                    'Type': 'AWS::CloudFront::CloudFrontOriginAccessIdentity',
                    'Properties': {
                        'CloudFrontOriginAccessIdentityConfig': {
                            'Comment': 'Allows CloudFront to reach the bucket'
                        }
                    }
                }
            }
        });
        test.done();
    },
    'Origin Access Identity with comment'(test) {
        const stack = new cdk.Stack();
        new lib_1.OriginAccessIdentity(stack, 'OAI', {
            comment: 'test comment'
        });
        assert_1.expect(stack).toMatch({
            'Resources': {
                'OAIE1EFC67F': {
                    'Type': 'AWS::CloudFront::CloudFrontOriginAccessIdentity',
                    'Properties': {
                        'CloudFrontOriginAccessIdentityConfig': {
                            'Comment': 'test comment'
                        }
                    }
                }
            }
        });
        test.done();
    },
    'Builds ARN of CloudFront user'(test) {
        const stack = new cdk.Stack();
        const oai = lib_1.OriginAccessIdentity.fromOriginAccessIdentityName(stack, 'OAI', 'OAITest');
        test.ok(oai.grantPrincipal.policyFragment.principalJson.AWS[0].endsWith(':iam::cloudfront:user/CloudFront Origin Access Identity OAITest'));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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