# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSimulationResult',
    'AwaitableGetSimulationResult',
    'get_simulation',
    'get_simulation_output',
]

@pulumi.output_type
class GetSimulationResult:
    def __init__(__self__, describe_payload=None, role_arn=None, schema_s3_location=None):
        if describe_payload and not isinstance(describe_payload, str):
            raise TypeError("Expected argument 'describe_payload' to be a str")
        pulumi.set(__self__, "describe_payload", describe_payload)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if schema_s3_location and not isinstance(schema_s3_location, dict):
            raise TypeError("Expected argument 'schema_s3_location' to be a dict")
        pulumi.set(__self__, "schema_s3_location", schema_s3_location)

    @property
    @pulumi.getter(name="describePayload")
    def describe_payload(self) -> Optional[str]:
        """
        Json object with all simulation details
        """
        return pulumi.get(self, "describe_payload")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        Role ARN.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="schemaS3Location")
    def schema_s3_location(self) -> Optional['outputs.SimulationS3Location']:
        return pulumi.get(self, "schema_s3_location")


class AwaitableGetSimulationResult(GetSimulationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSimulationResult(
            describe_payload=self.describe_payload,
            role_arn=self.role_arn,
            schema_s3_location=self.schema_s3_location)


def get_simulation(name: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSimulationResult:
    """
    AWS::SimSpaceWeaver::Simulation resource creates an AWS Simulation.


    :param str name: The name of the simulation.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:simspaceweaver:getSimulation', __args__, opts=opts, typ=GetSimulationResult).value

    return AwaitableGetSimulationResult(
        describe_payload=__ret__.describe_payload,
        role_arn=__ret__.role_arn,
        schema_s3_location=__ret__.schema_s3_location)


@_utilities.lift_output_func(get_simulation)
def get_simulation_output(name: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSimulationResult]:
    """
    AWS::SimSpaceWeaver::Simulation resource creates an AWS Simulation.


    :param str name: The name of the simulation.
    """
    ...
