# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SpaceArgs', 'Space']

@pulumi.input_type
class SpaceArgs:
    def __init__(__self__, *,
                 domain_id: pulumi.Input[str],
                 space_name: Optional[pulumi.Input[str]] = None,
                 space_settings: Optional[pulumi.Input['SpaceSettingsArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['SpaceTagArgs']]]] = None):
        """
        The set of arguments for constructing a Space resource.
        :param pulumi.Input[str] domain_id: The ID of the associated Domain.
        :param pulumi.Input[str] space_name: A name for the Space.
        :param pulumi.Input['SpaceSettingsArgs'] space_settings: A collection of settings.
        :param pulumi.Input[Sequence[pulumi.Input['SpaceTagArgs']]] tags: A list of tags to apply to the space.
        """
        pulumi.set(__self__, "domain_id", domain_id)
        if space_name is not None:
            pulumi.set(__self__, "space_name", space_name)
        if space_settings is not None:
            pulumi.set(__self__, "space_settings", space_settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Input[str]:
        """
        The ID of the associated Domain.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the Space.
        """
        return pulumi.get(self, "space_name")

    @space_name.setter
    def space_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_name", value)

    @property
    @pulumi.getter(name="spaceSettings")
    def space_settings(self) -> Optional[pulumi.Input['SpaceSettingsArgs']]:
        """
        A collection of settings.
        """
        return pulumi.get(self, "space_settings")

    @space_settings.setter
    def space_settings(self, value: Optional[pulumi.Input['SpaceSettingsArgs']]):
        pulumi.set(self, "space_settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpaceTagArgs']]]]:
        """
        A list of tags to apply to the space.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpaceTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Space(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 space_name: Optional[pulumi.Input[str]] = None,
                 space_settings: Optional[pulumi.Input[pulumi.InputType['SpaceSettingsArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SpaceTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::Space

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_id: The ID of the associated Domain.
        :param pulumi.Input[str] space_name: A name for the Space.
        :param pulumi.Input[pulumi.InputType['SpaceSettingsArgs']] space_settings: A collection of settings.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SpaceTagArgs']]]] tags: A list of tags to apply to the space.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::Space

        :param str resource_name: The name of the resource.
        :param SpaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 space_name: Optional[pulumi.Input[str]] = None,
                 space_settings: Optional[pulumi.Input[pulumi.InputType['SpaceSettingsArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SpaceTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpaceArgs.__new__(SpaceArgs)

            if domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_id'")
            __props__.__dict__["domain_id"] = domain_id
            __props__.__dict__["space_name"] = space_name
            __props__.__dict__["space_settings"] = space_settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["space_arn"] = None
        super(Space, __self__).__init__(
            'aws-native:sagemaker:Space',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Space':
        """
        Get an existing Space resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SpaceArgs.__new__(SpaceArgs)

        __props__.__dict__["domain_id"] = None
        __props__.__dict__["space_arn"] = None
        __props__.__dict__["space_name"] = None
        __props__.__dict__["space_settings"] = None
        __props__.__dict__["tags"] = None
        return Space(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[str]:
        """
        The ID of the associated Domain.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="spaceArn")
    def space_arn(self) -> pulumi.Output[str]:
        """
        The space Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "space_arn")

    @property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> pulumi.Output[str]:
        """
        A name for the Space.
        """
        return pulumi.get(self, "space_name")

    @property
    @pulumi.getter(name="spaceSettings")
    def space_settings(self) -> pulumi.Output[Optional['outputs.SpaceSettings']]:
        """
        A collection of settings.
        """
        return pulumi.get(self, "space_settings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.SpaceTag']]]:
        """
        A list of tags to apply to the space.
        """
        return pulumi.get(self, "tags")

