# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['StreamGroupArgs', 'StreamGroup']

@pulumi.input_type
class StreamGroupArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 default_application: Optional[pulumi.Input['StreamGroupDefaultApplicationArgs']] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 stream_class: Optional[pulumi.Input['StreamGroupStreamClass']] = None,
                 tags: Optional[pulumi.Input['StreamGroupTagsArgs']] = None):
        """
        The set of arguments for constructing a StreamGroup resource.
        :param pulumi.Input[str] description: Descriptive label for the resource, not a unique ID.
        :param pulumi.Input[int] desired_capacity: DesiredCapacity is the target number of stream sessions customer sets.
        """
        pulumi.set(__self__, "description", description)
        if default_application is not None:
            pulumi.set(__self__, "default_application", default_application)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if stream_class is not None:
            pulumi.set(__self__, "stream_class", stream_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Descriptive label for the resource, not a unique ID.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="defaultApplication")
    def default_application(self) -> Optional[pulumi.Input['StreamGroupDefaultApplicationArgs']]:
        return pulumi.get(self, "default_application")

    @default_application.setter
    def default_application(self, value: Optional[pulumi.Input['StreamGroupDefaultApplicationArgs']]):
        pulumi.set(self, "default_application", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        DesiredCapacity is the target number of stream sessions customer sets.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="streamClass")
    def stream_class(self) -> Optional[pulumi.Input['StreamGroupStreamClass']]:
        return pulumi.get(self, "stream_class")

    @stream_class.setter
    def stream_class(self, value: Optional[pulumi.Input['StreamGroupStreamClass']]):
        pulumi.set(self, "stream_class", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['StreamGroupTagsArgs']]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['StreamGroupTagsArgs']]):
        pulumi.set(self, "tags", value)


class StreamGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_application: Optional[pulumi.Input[pulumi.InputType['StreamGroupDefaultApplicationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 stream_class: Optional[pulumi.Input['StreamGroupStreamClass']] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['StreamGroupTagsArgs']]] = None,
                 __props__=None):
        """
        Definition of AWS::GameCast::StreamGroup Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Descriptive label for the resource, not a unique ID.
        :param pulumi.Input[int] desired_capacity: DesiredCapacity is the target number of stream sessions customer sets.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::GameCast::StreamGroup Resource Type

        :param str resource_name: The name of the resource.
        :param StreamGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_application: Optional[pulumi.Input[pulumi.InputType['StreamGroupDefaultApplicationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 stream_class: Optional[pulumi.Input['StreamGroupStreamClass']] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['StreamGroupTagsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamGroupArgs.__new__(StreamGroupArgs)

            __props__.__dict__["default_application"] = default_application
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["stream_class"] = stream_class
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        super(StreamGroup, __self__).__init__(
            'aws-native:gamecast:StreamGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StreamGroup':
        """
        Get an existing StreamGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StreamGroupArgs.__new__(StreamGroupArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["default_application"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["desired_capacity"] = None
        __props__.__dict__["stream_class"] = None
        __props__.__dict__["tags"] = None
        return StreamGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultApplication")
    def default_application(self) -> pulumi.Output[Optional['outputs.StreamGroupDefaultApplication']]:
        return pulumi.get(self, "default_application")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Descriptive label for the resource, not a unique ID.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        DesiredCapacity is the target number of stream sessions customer sets.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="streamClass")
    def stream_class(self) -> pulumi.Output[Optional['StreamGroupStreamClass']]:
        return pulumi.get(self, "stream_class")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional['outputs.StreamGroupTags']]:
        return pulumi.get(self, "tags")

