# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 application_source_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 executable_path: Optional[pulumi.Input[str]] = None,
                 log_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_environment: Optional[pulumi.Input['ApplicationRuntimeEnvironmentArgs']] = None,
                 save_configuration: Optional[pulumi.Input['ApplicationSaveConfigurationArgs']] = None,
                 save_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input['ApplicationTagsArgs']] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[str] application_source_uri: ApplicationSourceUri points to a S3 Uri to replicate game files from customer S3 bucket into Motif internal S3 bucket.
               The uri points to a S3 prefix that could contain many objects. Motif will attempt to copy all the S3 objects under that prefix.
        :param pulumi.Input[str] description: Descriptive label for the resource, not a unique ID.
        :param pulumi.Input[str] executable_path: Executable path is a relative path to the game launcher executable.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_locations: A list of save file, registry key or log paths that are absolute paths that store game save files when the games
               are running on a Windows environment.
        :param pulumi.Input[str] save_key: SaveKey is used as key to manage save files, meaning that different applications with the
               same SaveKey can share game save files generated by the game itself.
        """
        if application_source_uri is not None:
            pulumi.set(__self__, "application_source_uri", application_source_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if executable_path is not None:
            pulumi.set(__self__, "executable_path", executable_path)
        if log_locations is not None:
            pulumi.set(__self__, "log_locations", log_locations)
        if runtime_environment is not None:
            pulumi.set(__self__, "runtime_environment", runtime_environment)
        if save_configuration is not None:
            pulumi.set(__self__, "save_configuration", save_configuration)
        if save_key is not None:
            pulumi.set(__self__, "save_key", save_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationSourceUri")
    def application_source_uri(self) -> Optional[pulumi.Input[str]]:
        """
        ApplicationSourceUri points to a S3 Uri to replicate game files from customer S3 bucket into Motif internal S3 bucket.
        The uri points to a S3 prefix that could contain many objects. Motif will attempt to copy all the S3 objects under that prefix.
        """
        return pulumi.get(self, "application_source_uri")

    @application_source_uri.setter
    def application_source_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_source_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptive label for the resource, not a unique ID.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executablePath")
    def executable_path(self) -> Optional[pulumi.Input[str]]:
        """
        Executable path is a relative path to the game launcher executable.
        """
        return pulumi.get(self, "executable_path")

    @executable_path.setter
    def executable_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "executable_path", value)

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of save file, registry key or log paths that are absolute paths that store game save files when the games
        are running on a Windows environment.
        """
        return pulumi.get(self, "log_locations")

    @log_locations.setter
    def log_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "log_locations", value)

    @property
    @pulumi.getter(name="runtimeEnvironment")
    def runtime_environment(self) -> Optional[pulumi.Input['ApplicationRuntimeEnvironmentArgs']]:
        return pulumi.get(self, "runtime_environment")

    @runtime_environment.setter
    def runtime_environment(self, value: Optional[pulumi.Input['ApplicationRuntimeEnvironmentArgs']]):
        pulumi.set(self, "runtime_environment", value)

    @property
    @pulumi.getter(name="saveConfiguration")
    def save_configuration(self) -> Optional[pulumi.Input['ApplicationSaveConfigurationArgs']]:
        return pulumi.get(self, "save_configuration")

    @save_configuration.setter
    def save_configuration(self, value: Optional[pulumi.Input['ApplicationSaveConfigurationArgs']]):
        pulumi.set(self, "save_configuration", value)

    @property
    @pulumi.getter(name="saveKey")
    def save_key(self) -> Optional[pulumi.Input[str]]:
        """
        SaveKey is used as key to manage save files, meaning that different applications with the
        same SaveKey can share game save files generated by the game itself.
        """
        return pulumi.get(self, "save_key")

    @save_key.setter
    def save_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "save_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['ApplicationTagsArgs']]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['ApplicationTagsArgs']]):
        pulumi.set(self, "tags", value)


class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_source_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 executable_path: Optional[pulumi.Input[str]] = None,
                 log_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_environment: Optional[pulumi.Input[pulumi.InputType['ApplicationRuntimeEnvironmentArgs']]] = None,
                 save_configuration: Optional[pulumi.Input[pulumi.InputType['ApplicationSaveConfigurationArgs']]] = None,
                 save_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['ApplicationTagsArgs']]] = None,
                 __props__=None):
        """
        Definition of AWS::GameCast::Application Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_source_uri: ApplicationSourceUri points to a S3 Uri to replicate game files from customer S3 bucket into Motif internal S3 bucket.
               The uri points to a S3 prefix that could contain many objects. Motif will attempt to copy all the S3 objects under that prefix.
        :param pulumi.Input[str] description: Descriptive label for the resource, not a unique ID.
        :param pulumi.Input[str] executable_path: Executable path is a relative path to the game launcher executable.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_locations: A list of save file, registry key or log paths that are absolute paths that store game save files when the games
               are running on a Windows environment.
        :param pulumi.Input[str] save_key: SaveKey is used as key to manage save files, meaning that different applications with the
               same SaveKey can share game save files generated by the game itself.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApplicationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::GameCast::Application Resource Type

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_source_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 executable_path: Optional[pulumi.Input[str]] = None,
                 log_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 runtime_environment: Optional[pulumi.Input[pulumi.InputType['ApplicationRuntimeEnvironmentArgs']]] = None,
                 save_configuration: Optional[pulumi.Input[pulumi.InputType['ApplicationSaveConfigurationArgs']]] = None,
                 save_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['ApplicationTagsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["application_source_uri"] = application_source_uri
            __props__.__dict__["description"] = description
            __props__.__dict__["executable_path"] = executable_path
            __props__.__dict__["log_locations"] = log_locations
            __props__.__dict__["runtime_environment"] = runtime_environment
            __props__.__dict__["save_configuration"] = save_configuration
            __props__.__dict__["save_key"] = save_key
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        super(Application, __self__).__init__(
            'aws-native:gamecast:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApplicationArgs.__new__(ApplicationArgs)

        __props__.__dict__["application_source_uri"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["executable_path"] = None
        __props__.__dict__["log_locations"] = None
        __props__.__dict__["runtime_environment"] = None
        __props__.__dict__["save_configuration"] = None
        __props__.__dict__["save_key"] = None
        __props__.__dict__["tags"] = None
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationSourceUri")
    def application_source_uri(self) -> pulumi.Output[Optional[str]]:
        """
        ApplicationSourceUri points to a S3 Uri to replicate game files from customer S3 bucket into Motif internal S3 bucket.
        The uri points to a S3 prefix that could contain many objects. Motif will attempt to copy all the S3 objects under that prefix.
        """
        return pulumi.get(self, "application_source_uri")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Descriptive label for the resource, not a unique ID.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executablePath")
    def executable_path(self) -> pulumi.Output[Optional[str]]:
        """
        Executable path is a relative path to the game launcher executable.
        """
        return pulumi.get(self, "executable_path")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of save file, registry key or log paths that are absolute paths that store game save files when the games
        are running on a Windows environment.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter(name="runtimeEnvironment")
    def runtime_environment(self) -> pulumi.Output[Optional['outputs.ApplicationRuntimeEnvironment']]:
        return pulumi.get(self, "runtime_environment")

    @property
    @pulumi.getter(name="saveConfiguration")
    def save_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationSaveConfiguration']]:
        return pulumi.get(self, "save_configuration")

    @property
    @pulumi.getter(name="saveKey")
    def save_key(self) -> pulumi.Output[Optional[str]]:
        """
        SaveKey is used as key to manage save files, meaning that different applications with the
        same SaveKey can share game save files generated by the game itself.
        """
        return pulumi.get(self, "save_key")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional['outputs.ApplicationTags']]:
        return pulumi.get(self, "tags")

