# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = ['ReportDefinitionArgs', 'ReportDefinition']

@pulumi.input_type
class ReportDefinitionArgs:
    def __init__(__self__, *,
                 compression: pulumi.Input['ReportDefinitionCompression'],
                 format: pulumi.Input['ReportDefinitionFormat'],
                 refresh_closed_reports: pulumi.Input[bool],
                 report_name: pulumi.Input[str],
                 report_versioning: pulumi.Input['ReportDefinitionReportVersioning'],
                 s3_bucket: pulumi.Input[str],
                 s3_prefix: pulumi.Input[str],
                 s3_region: pulumi.Input[str],
                 time_unit: pulumi.Input['ReportDefinitionTimeUnit'],
                 additional_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalArtifactsItem']]]] = None,
                 additional_schema_elements: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalSchemaElementsItem']]]] = None,
                 billing_view_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ReportDefinition resource.
        :param pulumi.Input['ReportDefinitionCompression'] compression: The compression format that AWS uses for the report.
        :param pulumi.Input['ReportDefinitionFormat'] format: The format that AWS saves the report in.
        :param pulumi.Input[bool] refresh_closed_reports: Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web Services detects charges related to previous months. These charges can include refunds, credits, or support fees.
        :param pulumi.Input[str] report_name: The name of the report that you want to create. The name must be unique, is case sensitive, and can't include spaces.
        :param pulumi.Input['ReportDefinitionReportVersioning'] report_versioning: Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
        :param pulumi.Input[str] s3_bucket: The S3 bucket where AWS delivers the report.
        :param pulumi.Input[str] s3_prefix: The prefix that AWS adds to the report name when AWS delivers the report. Your prefix can't include spaces.
        :param pulumi.Input[str] s3_region: The region of the S3 bucket that AWS delivers the report into.
        :param pulumi.Input['ReportDefinitionTimeUnit'] time_unit: The granularity of the line items in the report.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalArtifactsItem']]] additional_artifacts: A list of manifests that you want Amazon Web Services to create for this report.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalSchemaElementsItem']]] additional_schema_elements: A list of strings that indicate additional content that Amazon Web Services includes in the report, such as individual resource IDs.
        :param pulumi.Input[str] billing_view_arn: The Amazon resource name of the billing view. You can get this value by using the billing view service public APIs.
        """
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "refresh_closed_reports", refresh_closed_reports)
        pulumi.set(__self__, "report_name", report_name)
        pulumi.set(__self__, "report_versioning", report_versioning)
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_prefix", s3_prefix)
        pulumi.set(__self__, "s3_region", s3_region)
        pulumi.set(__self__, "time_unit", time_unit)
        if additional_artifacts is not None:
            pulumi.set(__self__, "additional_artifacts", additional_artifacts)
        if additional_schema_elements is not None:
            pulumi.set(__self__, "additional_schema_elements", additional_schema_elements)
        if billing_view_arn is not None:
            pulumi.set(__self__, "billing_view_arn", billing_view_arn)

    @property
    @pulumi.getter
    def compression(self) -> pulumi.Input['ReportDefinitionCompression']:
        """
        The compression format that AWS uses for the report.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: pulumi.Input['ReportDefinitionCompression']):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input['ReportDefinitionFormat']:
        """
        The format that AWS saves the report in.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input['ReportDefinitionFormat']):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="refreshClosedReports")
    def refresh_closed_reports(self) -> pulumi.Input[bool]:
        """
        Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web Services detects charges related to previous months. These charges can include refunds, credits, or support fees.
        """
        return pulumi.get(self, "refresh_closed_reports")

    @refresh_closed_reports.setter
    def refresh_closed_reports(self, value: pulumi.Input[bool]):
        pulumi.set(self, "refresh_closed_reports", value)

    @property
    @pulumi.getter(name="reportName")
    def report_name(self) -> pulumi.Input[str]:
        """
        The name of the report that you want to create. The name must be unique, is case sensitive, and can't include spaces.
        """
        return pulumi.get(self, "report_name")

    @report_name.setter
    def report_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "report_name", value)

    @property
    @pulumi.getter(name="reportVersioning")
    def report_versioning(self) -> pulumi.Input['ReportDefinitionReportVersioning']:
        """
        Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
        """
        return pulumi.get(self, "report_versioning")

    @report_versioning.setter
    def report_versioning(self, value: pulumi.Input['ReportDefinitionReportVersioning']):
        pulumi.set(self, "report_versioning", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Input[str]:
        """
        The S3 bucket where AWS delivers the report.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> pulumi.Input[str]:
        """
        The prefix that AWS adds to the report name when AWS delivers the report. Your prefix can't include spaces.
        """
        return pulumi.get(self, "s3_prefix")

    @s3_prefix.setter
    def s3_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_prefix", value)

    @property
    @pulumi.getter(name="s3Region")
    def s3_region(self) -> pulumi.Input[str]:
        """
        The region of the S3 bucket that AWS delivers the report into.
        """
        return pulumi.get(self, "s3_region")

    @s3_region.setter
    def s3_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_region", value)

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> pulumi.Input['ReportDefinitionTimeUnit']:
        """
        The granularity of the line items in the report.
        """
        return pulumi.get(self, "time_unit")

    @time_unit.setter
    def time_unit(self, value: pulumi.Input['ReportDefinitionTimeUnit']):
        pulumi.set(self, "time_unit", value)

    @property
    @pulumi.getter(name="additionalArtifacts")
    def additional_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalArtifactsItem']]]]:
        """
        A list of manifests that you want Amazon Web Services to create for this report.
        """
        return pulumi.get(self, "additional_artifacts")

    @additional_artifacts.setter
    def additional_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalArtifactsItem']]]]):
        pulumi.set(self, "additional_artifacts", value)

    @property
    @pulumi.getter(name="additionalSchemaElements")
    def additional_schema_elements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalSchemaElementsItem']]]]:
        """
        A list of strings that indicate additional content that Amazon Web Services includes in the report, such as individual resource IDs.
        """
        return pulumi.get(self, "additional_schema_elements")

    @additional_schema_elements.setter
    def additional_schema_elements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalSchemaElementsItem']]]]):
        pulumi.set(self, "additional_schema_elements", value)

    @property
    @pulumi.getter(name="billingViewArn")
    def billing_view_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon resource name of the billing view. You can get this value by using the billing view service public APIs.
        """
        return pulumi.get(self, "billing_view_arn")

    @billing_view_arn.setter
    def billing_view_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_view_arn", value)


warnings.warn("""ReportDefinition is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class ReportDefinition(pulumi.CustomResource):
    warnings.warn("""ReportDefinition is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalArtifactsItem']]]] = None,
                 additional_schema_elements: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalSchemaElementsItem']]]] = None,
                 billing_view_arn: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input['ReportDefinitionCompression']] = None,
                 format: Optional[pulumi.Input['ReportDefinitionFormat']] = None,
                 refresh_closed_reports: Optional[pulumi.Input[bool]] = None,
                 report_name: Optional[pulumi.Input[str]] = None,
                 report_versioning: Optional[pulumi.Input['ReportDefinitionReportVersioning']] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_prefix: Optional[pulumi.Input[str]] = None,
                 s3_region: Optional[pulumi.Input[str]] = None,
                 time_unit: Optional[pulumi.Input['ReportDefinitionTimeUnit']] = None,
                 __props__=None):
        """
        The AWS::CUR::ReportDefinition resource creates a Cost & Usage Report with user-defined settings. You can use this resource to define settings like time granularity (hourly, daily, monthly), file format (Parquet, CSV), and S3 bucket for delivery of these reports.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalArtifactsItem']]] additional_artifacts: A list of manifests that you want Amazon Web Services to create for this report.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalSchemaElementsItem']]] additional_schema_elements: A list of strings that indicate additional content that Amazon Web Services includes in the report, such as individual resource IDs.
        :param pulumi.Input[str] billing_view_arn: The Amazon resource name of the billing view. You can get this value by using the billing view service public APIs.
        :param pulumi.Input['ReportDefinitionCompression'] compression: The compression format that AWS uses for the report.
        :param pulumi.Input['ReportDefinitionFormat'] format: The format that AWS saves the report in.
        :param pulumi.Input[bool] refresh_closed_reports: Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web Services detects charges related to previous months. These charges can include refunds, credits, or support fees.
        :param pulumi.Input[str] report_name: The name of the report that you want to create. The name must be unique, is case sensitive, and can't include spaces.
        :param pulumi.Input['ReportDefinitionReportVersioning'] report_versioning: Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
        :param pulumi.Input[str] s3_bucket: The S3 bucket where AWS delivers the report.
        :param pulumi.Input[str] s3_prefix: The prefix that AWS adds to the report name when AWS delivers the report. Your prefix can't include spaces.
        :param pulumi.Input[str] s3_region: The region of the S3 bucket that AWS delivers the report into.
        :param pulumi.Input['ReportDefinitionTimeUnit'] time_unit: The granularity of the line items in the report.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReportDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::CUR::ReportDefinition resource creates a Cost & Usage Report with user-defined settings. You can use this resource to define settings like time granularity (hourly, daily, monthly), file format (Parquet, CSV), and S3 bucket for delivery of these reports.

        :param str resource_name: The name of the resource.
        :param ReportDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReportDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalArtifactsItem']]]] = None,
                 additional_schema_elements: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionAdditionalSchemaElementsItem']]]] = None,
                 billing_view_arn: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input['ReportDefinitionCompression']] = None,
                 format: Optional[pulumi.Input['ReportDefinitionFormat']] = None,
                 refresh_closed_reports: Optional[pulumi.Input[bool]] = None,
                 report_name: Optional[pulumi.Input[str]] = None,
                 report_versioning: Optional[pulumi.Input['ReportDefinitionReportVersioning']] = None,
                 s3_bucket: Optional[pulumi.Input[str]] = None,
                 s3_prefix: Optional[pulumi.Input[str]] = None,
                 s3_region: Optional[pulumi.Input[str]] = None,
                 time_unit: Optional[pulumi.Input['ReportDefinitionTimeUnit']] = None,
                 __props__=None):
        pulumi.log.warn("""ReportDefinition is deprecated: ReportDefinition is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReportDefinitionArgs.__new__(ReportDefinitionArgs)

            __props__.__dict__["additional_artifacts"] = additional_artifacts
            __props__.__dict__["additional_schema_elements"] = additional_schema_elements
            __props__.__dict__["billing_view_arn"] = billing_view_arn
            if compression is None and not opts.urn:
                raise TypeError("Missing required property 'compression'")
            __props__.__dict__["compression"] = compression
            if format is None and not opts.urn:
                raise TypeError("Missing required property 'format'")
            __props__.__dict__["format"] = format
            if refresh_closed_reports is None and not opts.urn:
                raise TypeError("Missing required property 'refresh_closed_reports'")
            __props__.__dict__["refresh_closed_reports"] = refresh_closed_reports
            if report_name is None and not opts.urn:
                raise TypeError("Missing required property 'report_name'")
            __props__.__dict__["report_name"] = report_name
            if report_versioning is None and not opts.urn:
                raise TypeError("Missing required property 'report_versioning'")
            __props__.__dict__["report_versioning"] = report_versioning
            if s3_bucket is None and not opts.urn:
                raise TypeError("Missing required property 's3_bucket'")
            __props__.__dict__["s3_bucket"] = s3_bucket
            if s3_prefix is None and not opts.urn:
                raise TypeError("Missing required property 's3_prefix'")
            __props__.__dict__["s3_prefix"] = s3_prefix
            if s3_region is None and not opts.urn:
                raise TypeError("Missing required property 's3_region'")
            __props__.__dict__["s3_region"] = s3_region
            if time_unit is None and not opts.urn:
                raise TypeError("Missing required property 'time_unit'")
            __props__.__dict__["time_unit"] = time_unit
        super(ReportDefinition, __self__).__init__(
            'aws-native:cur:ReportDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ReportDefinition':
        """
        Get an existing ReportDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ReportDefinitionArgs.__new__(ReportDefinitionArgs)

        __props__.__dict__["additional_artifacts"] = None
        __props__.__dict__["additional_schema_elements"] = None
        __props__.__dict__["billing_view_arn"] = None
        __props__.__dict__["compression"] = None
        __props__.__dict__["format"] = None
        __props__.__dict__["refresh_closed_reports"] = None
        __props__.__dict__["report_name"] = None
        __props__.__dict__["report_versioning"] = None
        __props__.__dict__["s3_bucket"] = None
        __props__.__dict__["s3_prefix"] = None
        __props__.__dict__["s3_region"] = None
        __props__.__dict__["time_unit"] = None
        return ReportDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalArtifacts")
    def additional_artifacts(self) -> pulumi.Output[Optional[Sequence['ReportDefinitionAdditionalArtifactsItem']]]:
        """
        A list of manifests that you want Amazon Web Services to create for this report.
        """
        return pulumi.get(self, "additional_artifacts")

    @property
    @pulumi.getter(name="additionalSchemaElements")
    def additional_schema_elements(self) -> pulumi.Output[Optional[Sequence['ReportDefinitionAdditionalSchemaElementsItem']]]:
        """
        A list of strings that indicate additional content that Amazon Web Services includes in the report, such as individual resource IDs.
        """
        return pulumi.get(self, "additional_schema_elements")

    @property
    @pulumi.getter(name="billingViewArn")
    def billing_view_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon resource name of the billing view. You can get this value by using the billing view service public APIs.
        """
        return pulumi.get(self, "billing_view_arn")

    @property
    @pulumi.getter
    def compression(self) -> pulumi.Output['ReportDefinitionCompression']:
        """
        The compression format that AWS uses for the report.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output['ReportDefinitionFormat']:
        """
        The format that AWS saves the report in.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="refreshClosedReports")
    def refresh_closed_reports(self) -> pulumi.Output[bool]:
        """
        Whether you want Amazon Web Services to update your reports after they have been finalized if Amazon Web Services detects charges related to previous months. These charges can include refunds, credits, or support fees.
        """
        return pulumi.get(self, "refresh_closed_reports")

    @property
    @pulumi.getter(name="reportName")
    def report_name(self) -> pulumi.Output[str]:
        """
        The name of the report that you want to create. The name must be unique, is case sensitive, and can't include spaces.
        """
        return pulumi.get(self, "report_name")

    @property
    @pulumi.getter(name="reportVersioning")
    def report_versioning(self) -> pulumi.Output['ReportDefinitionReportVersioning']:
        """
        Whether you want Amazon Web Services to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
        """
        return pulumi.get(self, "report_versioning")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Output[str]:
        """
        The S3 bucket where AWS delivers the report.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> pulumi.Output[str]:
        """
        The prefix that AWS adds to the report name when AWS delivers the report. Your prefix can't include spaces.
        """
        return pulumi.get(self, "s3_prefix")

    @property
    @pulumi.getter(name="s3Region")
    def s3_region(self) -> pulumi.Output[str]:
        """
        The region of the S3 bucket that AWS delivers the report into.
        """
        return pulumi.get(self, "s3_region")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> pulumi.Output['ReportDefinitionTimeUnit']:
        """
        The granularity of the line items in the report.
        """
        return pulumi.get(self, "time_unit")

