# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainResult',
    'AwaitableGetDomainResult',
    'get_domain',
    'get_domain_output',
]

@pulumi.output_type
class GetDomainResult:
    def __init__(__self__, arn=None, auto_sub_domain_creation_patterns=None, auto_sub_domain_iam_role=None, certificate_record=None, domain_status=None, enable_auto_sub_domain=None, status_reason=None, sub_domain_settings=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_sub_domain_creation_patterns and not isinstance(auto_sub_domain_creation_patterns, list):
            raise TypeError("Expected argument 'auto_sub_domain_creation_patterns' to be a list")
        pulumi.set(__self__, "auto_sub_domain_creation_patterns", auto_sub_domain_creation_patterns)
        if auto_sub_domain_iam_role and not isinstance(auto_sub_domain_iam_role, str):
            raise TypeError("Expected argument 'auto_sub_domain_iam_role' to be a str")
        pulumi.set(__self__, "auto_sub_domain_iam_role", auto_sub_domain_iam_role)
        if certificate_record and not isinstance(certificate_record, str):
            raise TypeError("Expected argument 'certificate_record' to be a str")
        pulumi.set(__self__, "certificate_record", certificate_record)
        if domain_status and not isinstance(domain_status, str):
            raise TypeError("Expected argument 'domain_status' to be a str")
        pulumi.set(__self__, "domain_status", domain_status)
        if enable_auto_sub_domain and not isinstance(enable_auto_sub_domain, bool):
            raise TypeError("Expected argument 'enable_auto_sub_domain' to be a bool")
        pulumi.set(__self__, "enable_auto_sub_domain", enable_auto_sub_domain)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if sub_domain_settings and not isinstance(sub_domain_settings, list):
            raise TypeError("Expected argument 'sub_domain_settings' to be a list")
        pulumi.set(__self__, "sub_domain_settings", sub_domain_settings)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoSubDomainCreationPatterns")
    def auto_sub_domain_creation_patterns(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "auto_sub_domain_creation_patterns")

    @property
    @pulumi.getter(name="autoSubDomainIAMRole")
    def auto_sub_domain_iam_role(self) -> Optional[str]:
        return pulumi.get(self, "auto_sub_domain_iam_role")

    @property
    @pulumi.getter(name="certificateRecord")
    def certificate_record(self) -> Optional[str]:
        return pulumi.get(self, "certificate_record")

    @property
    @pulumi.getter(name="domainStatus")
    def domain_status(self) -> Optional[str]:
        return pulumi.get(self, "domain_status")

    @property
    @pulumi.getter(name="enableAutoSubDomain")
    def enable_auto_sub_domain(self) -> Optional[bool]:
        return pulumi.get(self, "enable_auto_sub_domain")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[str]:
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter(name="subDomainSettings")
    def sub_domain_settings(self) -> Optional[Sequence['outputs.DomainSubDomainSetting']]:
        return pulumi.get(self, "sub_domain_settings")


class AwaitableGetDomainResult(GetDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainResult(
            arn=self.arn,
            auto_sub_domain_creation_patterns=self.auto_sub_domain_creation_patterns,
            auto_sub_domain_iam_role=self.auto_sub_domain_iam_role,
            certificate_record=self.certificate_record,
            domain_status=self.domain_status,
            enable_auto_sub_domain=self.enable_auto_sub_domain,
            status_reason=self.status_reason,
            sub_domain_settings=self.sub_domain_settings)


def get_domain(arn: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainResult:
    """
    The AWS::Amplify::Domain resource allows you to connect a custom domain to your app.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:amplify:getDomain', __args__, opts=opts, typ=GetDomainResult).value

    return AwaitableGetDomainResult(
        arn=__ret__.arn,
        auto_sub_domain_creation_patterns=__ret__.auto_sub_domain_creation_patterns,
        auto_sub_domain_iam_role=__ret__.auto_sub_domain_iam_role,
        certificate_record=__ret__.certificate_record,
        domain_status=__ret__.domain_status,
        enable_auto_sub_domain=__ret__.enable_auto_sub_domain,
        status_reason=__ret__.status_reason,
        sub_domain_settings=__ret__.sub_domain_settings)


@_utilities.lift_output_func(get_domain)
def get_domain_output(arn: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDomainResult]:
    """
    The AWS::Amplify::Domain resource allows you to connect a custom domain to your app.
    """
    ...
