/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;

final class WirePointer {
    public static final byte STRUCT = 0;
    public static final byte LIST = 1;
    public static final byte FAR = 2;
    public static final byte OTHER = 3;

    WirePointer() {
    }

    public static boolean isNull(long l2) {
        return l2 == 0L;
    }

    public static int offsetAndKind(long l2) {
        return (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte kind(long l2) {
        return (byte)(WirePointer.offsetAndKind(l2) & 3);
    }

    public static int target(int n2, long l2) {
        return n2 + 1 + (WirePointer.offsetAndKind(l2) >>> 2);
    }

    public static void setKindAndTarget(ByteBuffer byteBuffer, int n2, byte by, int n3) {
        byteBuffer.putInt(n2 * 8, n3 - n2 - 1 << 2 | by);
    }

    public static void setKindWithZeroOffset(ByteBuffer byteBuffer, int n2, byte by) {
        byteBuffer.putInt(n2 * 8, by);
    }

    public static void setKindAndTargetForEmptyStruct(ByteBuffer byteBuffer, int n2) {
        byteBuffer.putInt(n2 * 8, -4);
    }

    public static void setOffsetAndKind(ByteBuffer byteBuffer, int n2, int n3) {
        byteBuffer.putInt(n2 * 8, n3);
    }

    public static int inlineCompositeListElementCount(long l2) {
        return WirePointer.offsetAndKind(l2) >>> 2;
    }

    public static void setKindAndInlineCompositeListElementCount(ByteBuffer byteBuffer, int n2, byte by, int n3) {
        byteBuffer.putInt(n2 * 8, n3 << 2 | by);
    }

    public static int upper32Bits(long l2) {
        return (int)(l2 >>> 32);
    }
}

