"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SourceActionBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const codecommit = require("aws-cdk-lib/aws-codecommit");
const codepipeline = require("aws-cdk-lib/aws-codepipeline");
const codepipeline_actions = require("aws-cdk-lib/aws-codepipeline-actions");
const s3 = require("aws-cdk-lib/aws-s3");
const source_action_1 = require("./source_action");
class SourceActionBuilder {
    constructor(scope, sources, idPrefix) {
        this.sources = sources;
        this.idPrefix = idPrefix;
        this.scope = scope;
    }
    createPipelineSources() {
        if (this.sources) {
            return this.sources.map((s) => createSource(this.scope, s, this.idPrefix));
        }
        return [];
    }
}
exports.SourceActionBuilder = SourceActionBuilder;
_a = JSII_RTTI_SYMBOL_1;
SourceActionBuilder[_a] = { fqn: "halloumi-ami-pipelines.SourceActionBuilder", version: "0.0.37" };
function createSource(scope, source, idPrefix) {
    let action = null;
    let sourceOutput = new codepipeline.Artifact();
    switch (source.type) {
        case 's3':
            action = new codepipeline_actions.S3SourceAction({
                actionName: source.name,
                bucket: s3.Bucket.fromBucketName(scope, `${idPrefix}${source.name}`, source.bucket),
                bucketKey: source.object,
                output: sourceOutput,
            });
            break;
        case 'codecommit':
            action = new codepipeline_actions.CodeCommitSourceAction({
                actionName: source.name,
                repository: codecommit.Repository.fromRepositoryName(scope, `${idPrefix}${source.name}`, source.repo_name),
                branch: source.branch,
                output: sourceOutput,
            });
            break;
        case 'github':
            action = new codepipeline_actions.GitHubSourceAction({
                actionName: source.name,
                output: sourceOutput,
                owner: source.owner,
                repo: source.repo_name,
                oauthToken: cdk.SecretValue.plainText(source.github_token),
                trigger: codepipeline_actions.GitHubTrigger.WEBHOOK,
            });
            break;
        default:
            action = new codepipeline_actions.S3SourceAction({
                actionName: source.name,
                bucket: s3.Bucket.fromBucketName(scope, `${idPrefix}${source.name}`, source.bucket),
                bucketKey: source.object,
                output: sourceOutput,
            });
    }
    return new source_action_1.SourceAction(sourceOutput, action);
}
//# sourceMappingURL=data:application/json;base64,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