import * as codepipeline from 'aws-cdk-lib/aws-codepipeline';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as imagebuilder from 'aws-cdk-lib/aws-imagebuilder';
import * as kms from 'aws-cdk-lib/aws-kms';
import * as sns from 'aws-cdk-lib/aws-sns';
import { Construct } from 'constructs';
import { ComponentBuilder } from './component_builder';
import { SlackConfiguration } from './slack_notification';
import { SourceActionBuilder } from './source_action_builder';
/**
 * Construct for creating a Codepipeline, EC2 Image builder pipeline from 1 pipeline configuration.
 */
export declare class AmiPipelineLib extends Construct {
    pipelineConfig: any;
    componentDepsConfig: any[];
    id: string;
    sourceActionBuilder: SourceActionBuilder;
    componentBuilder: ComponentBuilder;
    imagePipeline: imagebuilder.CfnImagePipeline | undefined;
    topic: sns.Topic | undefined;
    codepipeline: codepipeline.Pipeline | undefined;
    slackConfig: SlackConfiguration;
    recipe: imagebuilder.CfnImageRecipe | undefined;
    infrastructure: imagebuilder.CfnInfrastructureConfiguration | undefined;
    distributionConfig: imagebuilder.CfnDistributionConfiguration | undefined;
    diskSize: number | undefined;
    ebsEncryptionKey: kms.Key | undefined;
    extraParameters: ComponentParameter[] | undefined;
    /**
     * Constructor
     * @param scope
     * @param id
     * @param pipelineConfig
     * @param componentDepsConfig
     */
    constructor(scope: Construct, id: string, pipelineConfig: any, componentDepsConfig: any[], componentBuilder: ComponentBuilder, optionalParams: AmiPipelineOptional);
    createCleanerTask(): void;
    createScheduledTask(): void;
    createImagebuilderPipeline(): void;
    private getComponents;
    private createDistributionConfig;
    private getInlinePolicies;
    private createBlockDeviceMapping;
    getNextRecipeVersion(recipeName: string): string;
    createCodepipelineProject(): void;
    getLookupCriteria(parentImage: any, cpuType: string): ec2.LookupMachineImageProps;
}
export interface ComponentParameter {
    readonly parameters: {
        [name: string]: string;
    };
    readonly componentName: string;
}
export interface AmiPipelineOptional {
    readonly slackWebhookUrl?: string | undefined;
    readonly channel?: string | undefined;
    readonly username?: string | undefined;
    readonly extraParams?: ComponentParameter[] | undefined;
}
