/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./geometry.js":
/*!*********************!*\
  !*** ./geometry.js ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Mesh\": () => (/* binding */ Mesh),\n/* harmony export */   \"Points\": () => (/* binding */ Points),\n/* harmony export */   \"Lines\": () => (/* binding */ Lines)\n/* harmony export */ });\nconst THREE = __webpack_require__(/*! three */ \"./node_modules/three/build/three.module.js\")\nclass Grid extends THREE.LineSegments {\n\tstatic attributes(step, divisions, centerLineColor, commonLineColor) {\n\t\tconst center = divisions / 2;\n\t\tconst halfSize = step * divisions / 2;\n\t\tconst vertices = []\n\t\tconst colors = [];\n\t\tfor (let i = 0, j = 0, k = - halfSize; i <= divisions; i++, k += step) {\n\t\t\tvertices.push(- halfSize, 0, k, halfSize, 0, k);\n\t\t\tvertices.push(k, 0, - halfSize, k, 0, halfSize);\n\t\t\tconst color = i === center ? centerLineColor : commonLineColor;\n\n\t\t\tcolor.toArray(colors, j); j += 3;\n\t\t\tcolor.toArray(colors, j); j += 3;\n\t\t\tcolor.toArray(colors, j); j += 3;\n\t\t\tcolor.toArray(colors, j); j += 3;\n\n\t\t}\n\t\treturn {\n\t\t\t\"vertices\": vertices,\n\t\t\t\"colors\": colors\n\t\t}\n\t}\n\tconstructor(step, divisions, centerLineColor, commonLineColor) {\n\t\tstep = step || 1;\n\t\tdivisions = divisions || 10;\n\t\tcenterLineColor = new THREE.Color(centerLineColor !== undefined ? centerLineColor : 0x444444);\n\t\tcommonLineColor = new THREE.Color(commonLineColor !== undefined ? commonLineColor : 0x888888);\n\t\tconst attributes = Grid.attributes(step, divisions, centerLineColor, commonLineColor)\n\t\tconst geometry = new THREE.BufferGeometry();\n\t\tgeometry.setAttribute('position', new THREE.Float32BufferAttribute(attributes.vertices, 3));\n\t\tgeometry.setAttribute('color', new THREE.Float32BufferAttribute(attributes.colors, 3));\n\t\tconst material = new THREE.LineBasicMaterial({ vertexColors: true, toneMapped: false });\n\t\tsuper(geometry, material)\n\t\tthis.centerLineColor = centerLineColor\n\t\tthis.commonLineColor = commonLineColor\n\t}\n\tset(step, divisions) {\n\t\tconst attributes = Grid.attributes(step, divisions, this.centerLineColor, this.commonLineColor)\n\t\tthis.geometry.setAttribute('position', new THREE.Float32BufferAttribute(attributes.vertices, 3));\n\t\tthis.geometry.setAttribute('color', new THREE.Float32BufferAttribute(attributes.colors, 3));\n\t\tthis.geometry.colorsNeedUpdate = true\n\t\tthis.geometry.verticesNeedUpdate = true\n\t\tthis.geometry.computeBoundingSphere()\n\t}\n}\n\nclass Line extends THREE.Line {\n\tconstructor() {\n\t\tlet geometry = new THREE.BufferGeometry()\n\t\tconst material = new THREE.LineBasicMaterial()\n\t\tsuper(geometry, material)\n\t\tthis.color = this.material.color\n\t\tthis.lineWidth = this.material.linewidth\n\t\tthis.points = []\n\t}\n\tset(points) {\n\t\tthis.points = points\n\t\tthis.geometry.setFromPoints(points)\n\t}\n\taddPoint(point) {\n\t\tthis.points.push(point)\n\t\tthis.geometry.setFromPoints(this.points)\n\t}\n\tlength() {\n\t\tlet ret = 0\n\t\tfor (let i = 0, l = this.points.length; i + 1 < l; i++) {\n\t\t\tret += new THREE.Vector3().subVectors(this.points[i], this.points[i + 1]).length()\n\t\t}\n\t\treturn ret\n\t}\n}\n\nclass Mesh extends THREE.Mesh {\n\tconstructor() {\n\t\tconst geometry = new THREE.BufferGeometry();\n\t\tconst material = new THREE.MeshLambertMaterial({ color: 0xff0000, side: 2 });\n\t\tsuper(geometry, material);\n\t}\n\tset(points, color = undefined) {\n\t\tif (points.length && points[0].x) {\n\t\t\tthis.geometry.setFromPoints(points)\n\t\t} else {\n\t\t\tthis.geometry.setAttribute('position', new THREE.BufferAttribute(new Float32Array(points.flat()), 3))\n\t\t}\n\t\tthis.geometry.computeVertexNormals()//lambert need to know face directions\n\t\tthis.geometry.verticesNeedUpdate = true\n\t\tif (color) {\n\t\t\tthis.material.color.set(color)\n\t\t}\n\t}\n}\n\nclass Points extends THREE.Points {\n\tconstructor() {\n\t\tconst geometry = new THREE.BufferGeometry()\n\t\tconst material = new THREE.PointsMaterial({\n\t\t\tsizeAttenuation: true,\n\t\t\tsize: 0.1\n\t\t})\n\t\tsuper(geometry, material)\n\t\tthis.color = this.material.color\n\t}\n\tset(points, color = undefined, size = undefined) {\n\t\tif (points.length && points[0].x) {\n\t\t\tthis.geometry.setFromPoints(points)\n\t\t} else {\n\t\t\tthis.geometry.setAttribute('position', new THREE.Float32BufferAttribute(points.flat(), 3))\n\t\t}\n\t\tthis.geometry.computeBoundingSphere()\n\t\tif (color) {\n\t\t\tthis.color.set(color)\n\t\t}\n\t\tif (size) {\n\t\t\tthis.material.size = size\n\t\t}\n\t\treturn this\n\t}\n}\n\n\nclass Lines extends THREE.LineSegments{\n\tconstructor(){\n\t\tconst geometry = new THREE.BufferGeometry()\n\t\tconst material = new THREE.LineBasicMaterial()\n\t\tsuper(geometry,material)\n\t}\n\tset(points,color){\n\t\tthis.geometry.setAttribute('position', new THREE.Float32BufferAttribute(points.flat(), 3))\n\t\tif(color)\n\t\t\tthis.material.color.set(color)\n\t\treturn this\n\t}\n}\n\n//# sourceURL=webpack://toweb/./geometry.js?");

/***/ }),

/***/ "./main.js":
/*!*****************!*\
  !*** ./main.js ***!
  \*****************/
/***/ (function(__unused_webpack_module, __unused_webpack_exports, __webpack_require__) {

eval("const CHART = __webpack_require__(/*! chart.js */ \"./node_modules/chart.js/dist/chart.esm.js\")\nCHART.Chart.register(CHART.ScatterController, CHART.LinearScale, CHART.PointElement, CHART.LineElement, CHART.Tooltip)\nconst THREE = __webpack_require__(/*! three */ \"./node_modules/three/build/three.module.js\")\nconst GEO = __webpack_require__(/*! ./geometry */ \"./geometry.js\")\nconst { OrbitControls } = __webpack_require__(/*! ./orbit */ \"./orbit.js\")\nvar ws = new WebSocket(\"ws://localhost:\"+port_+\"/ws/\"+id_);\nws.onopen=()=>{console.log(\"connected\")}\nconsole.log(\"ready\")\nconst create_chart = () => {\n    console.log(\"create_chart\")\n    const canvas = create_canvas(\"chart\")\n    var ctx = canvas.getContext('2d');\n    let config = {\n        type: 'scatter',\n        data: {\n            datasets: [],\n        },\n        options: {\n            elements: {\n                line: {\n                    tension: 0 // ���ñ���������\n                }\n            },\n            animation: {\n                duration: 0 // һ�㶯��ʱ��\n            },\n            hover: {\n                animationDuration: 0 // ��ͣ��Ŀʱ�����ĳ���ʱ��\n            },\n            responsiveAnimationDuration: 0, // ������С��Ķ�������ʱ��\n        }\n    }\n    return new CHART.Chart(ctx, config)\n}\nconst create_canvas = (name) => {\n    let canvas = document.createElement(\"canvas\")\n    canvas.id = name\n    canvas.width = document.body.clientWidth\n    canvas.height = document.body.clientHeight\n    document.body.onresize = (ev) => {\n        canvas.width = document.body.clientWidth\n        canvas.height = document.body.clientHeight\n        canvas.onresize(ev)\n        console.log(canvas.width, canvas.height)\n    }\n    document.body.appendChild(canvas)\n    return canvas\n}\nconst init_3d_canvas = (canvas) => {\n    const scene = new THREE.Scene()\n    scene.background = \"white\"\n    let renderer = new THREE.WebGLRenderer({\n        canvas: canvas,\n        antialias: true,\n    });\n    console.log(canvas.width, canvas.height)\n    const aspect = canvas.width / canvas.height\n    let perspCamera = new THREE.PerspectiveCamera(60, aspect, 0.1, 1000);\n    perspCamera.up.set(0, 0, 1)\n    perspCamera.position.set(0, 0, 30)\n    let Z = perspCamera.position.length();\n    let depht_s = Math.tan(60 / 2.0 * Math.PI / 180.0) * 2.0\n    let size_y = depht_s * Z;\n    let size_x = depht_s * Z * aspect\n    let orthoCamera = new THREE.OrthographicCamera(\n        -size_x / 2, size_x / 2,\n        size_y / 2, -size_y / 2,\n        1, 1000);\n    orthoCamera.up.set(0, 0, 1)\n    orthoCamera.position.copy(perspCamera.position)\n    let light = new THREE.PointLight(0xffffff, 1);\n    scene.add(light)\n    scene.add(new THREE.AxesHelper(5))\n    const control = new OrbitControls(perspCamera, orthoCamera, renderer.domElement)\n    let animate = function () {\n        light.position.copy(control.object.position)\n        requestAnimationFrame(animate)\n        renderer.render(scene, control.object);\n    }\n    canvas.onresize = (ev) => {\n        perspCamera.aspect = canvas.width / canvas.height\n        perspCamera.updateProjectionMatrix()\n        renderer.setSize(canvas.width, canvas.height)\n        console.log(\"canvas resize\")\n    }\n    animate()\n    return scene\n}\nws.onmessage = (message) => {\n    console.log(message)\n    try {\n        const cmds = JSON.parse(message.data.replace(/\"/g, '\\\"'))\n        for (let cmd of cmds) {\n            methods[cmd.method](cmd.time, cmd.data)\n        }\n    } catch (e) {\n        console.log(message.data)\n    }\n}\nconst methods = {}\nmethods.clear = (time, data) => {\n    console.log(time, \"clear\")\n    document.body.innerHTML = \"\"\n    this.chart = undefined\n}\nmethods.plot = (time, data) => {\n    if (!this.chart) {\n        this.chart = create_chart()\n        this.chart.indexes = {}\n    }\n    let index = -1\n    if (data.key in this.chart.indexes) {\n        index = this.chart.indexes[data.key]\n    } else {\n        index = Object.keys(this.chart.indexes).length\n        this.chart.indexes[data.key] = index\n        let rand_color = '#' + (Math.random() * 0xffffff << 0).toString(16)\n        this.chart.data.datasets.push({\n            label: data.key,\n            data: [],\n            borderWidth: 1,\n            showLine: true,\n            borderColor: rand_color,\n            pointBackgroundColor: rand_color,\n        })\n    }\n    if (data.y != null) {\n        this.chart.data.datasets[index].data.push({ x: data.x, y: data.y })\n    } else {\n        this.chart.data.datasets[index].data.push({ x: time, y: data.x })\n    }\n    this.chart.update()\n}\nmethods.info = (time, data) => {\n    var new_div = document.createElement(\"div\")\n    document.body.appendChild(new_div)\n    new_div.innerHTML = time + \" \" + data\n    return new_div\n}\nmethods.err = (time, data) => {\n    let div = methods.info(time, data)\n    div.style.color = \"red\"\n}\nmethods.warn = (time, data) => {\n    let div = methods.info(time, data)\n    div.style.color = \"orange\"\n}\nmethods.points = (time, data) => {\n    console.log(time,data)\n    if (!this.chart) {\n        this.chart = init_3d_canvas(create_canvas(\"3d_canvas\"))\n    }\n    const mesh = new GEO.Points\n    mesh.set(data.vertices,data.color)\n    this.chart.add(mesh)\n}\nmethods.mesh = (time, data) => {\n    if (!this.chart) {\n        this.chart = init_3d_canvas(create_canvas(\"3d_canvas\"))\n    }\n    const mesh = new GEO.Mesh\n    mesh.set(data.vertices,data.color)\n    this.chart.add(mesh)\n}\nmethods.lines = (time, data) => {\n    if (!this.chart) {\n        this.chart = init_3d_canvas(create_canvas(\"3d_canvas\"))\n    }\n    const mesh = new GEO.Lines\n    mesh.set(data.vertices,data.color)\n    this.chart.add(mesh)\n}\n\n\n//# sourceURL=webpack://toweb/./main.js?");

/***/ }),

/***/ "./node_modules/chart.js/dist/chart.esm.js":
/*!*************************************************!*\
  !*** ./node_modules/chart.js/dist/chart.esm.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"defaults\": () => (/* reexport safe */ _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d),\n/* harmony export */   \"Animation\": () => (/* binding */ Animation),\n/* harmony export */   \"Animations\": () => (/* binding */ Animations),\n/* harmony export */   \"ArcElement\": () => (/* binding */ ArcElement),\n/* harmony export */   \"BarController\": () => (/* binding */ BarController),\n/* harmony export */   \"BarElement\": () => (/* binding */ BarElement),\n/* harmony export */   \"BasePlatform\": () => (/* binding */ BasePlatform),\n/* harmony export */   \"BasicPlatform\": () => (/* binding */ BasicPlatform),\n/* harmony export */   \"BubbleController\": () => (/* binding */ BubbleController),\n/* harmony export */   \"CategoryScale\": () => (/* binding */ CategoryScale),\n/* harmony export */   \"Chart\": () => (/* binding */ Chart),\n/* harmony export */   \"DatasetController\": () => (/* binding */ DatasetController),\n/* harmony export */   \"Decimation\": () => (/* binding */ plugin_decimation),\n/* harmony export */   \"DomPlatform\": () => (/* binding */ DomPlatform),\n/* harmony export */   \"DoughnutController\": () => (/* binding */ DoughnutController),\n/* harmony export */   \"Element\": () => (/* binding */ Element),\n/* harmony export */   \"Filler\": () => (/* binding */ plugin_filler),\n/* harmony export */   \"Interaction\": () => (/* binding */ Interaction),\n/* harmony export */   \"Legend\": () => (/* binding */ plugin_legend),\n/* harmony export */   \"LineController\": () => (/* binding */ LineController),\n/* harmony export */   \"LineElement\": () => (/* binding */ LineElement),\n/* harmony export */   \"LinearScale\": () => (/* binding */ LinearScale),\n/* harmony export */   \"LogarithmicScale\": () => (/* binding */ LogarithmicScale),\n/* harmony export */   \"PieController\": () => (/* binding */ PieController),\n/* harmony export */   \"PointElement\": () => (/* binding */ PointElement),\n/* harmony export */   \"PolarAreaController\": () => (/* binding */ PolarAreaController),\n/* harmony export */   \"RadarController\": () => (/* binding */ RadarController),\n/* harmony export */   \"RadialLinearScale\": () => (/* binding */ RadialLinearScale),\n/* harmony export */   \"Scale\": () => (/* binding */ Scale),\n/* harmony export */   \"ScatterController\": () => (/* binding */ ScatterController),\n/* harmony export */   \"SubTitle\": () => (/* binding */ plugin_subtitle),\n/* harmony export */   \"Ticks\": () => (/* binding */ Ticks),\n/* harmony export */   \"TimeScale\": () => (/* binding */ TimeScale),\n/* harmony export */   \"TimeSeriesScale\": () => (/* binding */ TimeSeriesScale),\n/* harmony export */   \"Title\": () => (/* binding */ plugin_title),\n/* harmony export */   \"Tooltip\": () => (/* binding */ plugin_tooltip),\n/* harmony export */   \"_adapters\": () => (/* binding */ adapters),\n/* harmony export */   \"_detectPlatform\": () => (/* binding */ _detectPlatform),\n/* harmony export */   \"animator\": () => (/* binding */ animator),\n/* harmony export */   \"controllers\": () => (/* binding */ controllers),\n/* harmony export */   \"elements\": () => (/* binding */ elements),\n/* harmony export */   \"layouts\": () => (/* binding */ layouts),\n/* harmony export */   \"plugins\": () => (/* binding */ plugins),\n/* harmony export */   \"registerables\": () => (/* binding */ registerables),\n/* harmony export */   \"registry\": () => (/* binding */ registry),\n/* harmony export */   \"scales\": () => (/* binding */ scales)\n/* harmony export */ });\n/* harmony import */ var _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./chunks/helpers.segment.js */ \"./node_modules/chart.js/dist/chunks/helpers.segment.js\");\n/*!\n * Chart.js v3.5.1\n * https://www.chartjs.org\n * (c) 2021 Chart.js Contributors\n * Released under the MIT License\n */\n\n\n\nclass Animator {\n  constructor() {\n    this._request = null;\n    this._charts = new Map();\n    this._running = false;\n    this._lastDate = undefined;\n  }\n  _notify(chart, anims, date, type) {\n    const callbacks = anims.listeners[type];\n    const numSteps = anims.duration;\n    callbacks.forEach(fn => fn({\n      chart,\n      initial: anims.initial,\n      numSteps,\n      currentStep: Math.min(date - anims.start, numSteps)\n    }));\n  }\n  _refresh() {\n    const me = this;\n    if (me._request) {\n      return;\n    }\n    me._running = true;\n    me._request = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.r.call(window, () => {\n      me._update();\n      me._request = null;\n      if (me._running) {\n        me._refresh();\n      }\n    });\n  }\n  _update(date = Date.now()) {\n    const me = this;\n    let remaining = 0;\n    me._charts.forEach((anims, chart) => {\n      if (!anims.running || !anims.items.length) {\n        return;\n      }\n      const items = anims.items;\n      let i = items.length - 1;\n      let draw = false;\n      let item;\n      for (; i >= 0; --i) {\n        item = items[i];\n        if (item._active) {\n          if (item._total > anims.duration) {\n            anims.duration = item._total;\n          }\n          item.tick(date);\n          draw = true;\n        } else {\n          items[i] = items[items.length - 1];\n          items.pop();\n        }\n      }\n      if (draw) {\n        chart.draw();\n        me._notify(chart, anims, date, 'progress');\n      }\n      if (!items.length) {\n        anims.running = false;\n        me._notify(chart, anims, date, 'complete');\n        anims.initial = false;\n      }\n      remaining += items.length;\n    });\n    me._lastDate = date;\n    if (remaining === 0) {\n      me._running = false;\n    }\n  }\n  _getAnims(chart) {\n    const charts = this._charts;\n    let anims = charts.get(chart);\n    if (!anims) {\n      anims = {\n        running: false,\n        initial: true,\n        items: [],\n        listeners: {\n          complete: [],\n          progress: []\n        }\n      };\n      charts.set(chart, anims);\n    }\n    return anims;\n  }\n  listen(chart, event, cb) {\n    this._getAnims(chart).listeners[event].push(cb);\n  }\n  add(chart, items) {\n    if (!items || !items.length) {\n      return;\n    }\n    this._getAnims(chart).items.push(...items);\n  }\n  has(chart) {\n    return this._getAnims(chart).items.length > 0;\n  }\n  start(chart) {\n    const anims = this._charts.get(chart);\n    if (!anims) {\n      return;\n    }\n    anims.running = true;\n    anims.start = Date.now();\n    anims.duration = anims.items.reduce((acc, cur) => Math.max(acc, cur._duration), 0);\n    this._refresh();\n  }\n  running(chart) {\n    if (!this._running) {\n      return false;\n    }\n    const anims = this._charts.get(chart);\n    if (!anims || !anims.running || !anims.items.length) {\n      return false;\n    }\n    return true;\n  }\n  stop(chart) {\n    const anims = this._charts.get(chart);\n    if (!anims || !anims.items.length) {\n      return;\n    }\n    const items = anims.items;\n    let i = items.length - 1;\n    for (; i >= 0; --i) {\n      items[i].cancel();\n    }\n    anims.items = [];\n    this._notify(chart, anims, Date.now(), 'complete');\n  }\n  remove(chart) {\n    return this._charts.delete(chart);\n  }\n}\nvar animator = new Animator();\n\nconst transparent = 'transparent';\nconst interpolators = {\n  boolean(from, to, factor) {\n    return factor > 0.5 ? to : from;\n  },\n  color(from, to, factor) {\n    const c0 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.c)(from || transparent);\n    const c1 = c0.valid && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.c)(to || transparent);\n    return c1 && c1.valid\n      ? c1.mix(c0, factor).hexString()\n      : to;\n  },\n  number(from, to, factor) {\n    return from + (to - from) * factor;\n  }\n};\nclass Animation {\n  constructor(cfg, target, prop, to) {\n    const currentValue = target[prop];\n    to = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([cfg.to, to, currentValue, cfg.from]);\n    const from = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([cfg.from, currentValue, to]);\n    this._active = true;\n    this._fn = cfg.fn || interpolators[cfg.type || typeof from];\n    this._easing = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.e[cfg.easing] || _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.e.linear;\n    this._start = Math.floor(Date.now() + (cfg.delay || 0));\n    this._duration = this._total = Math.floor(cfg.duration);\n    this._loop = !!cfg.loop;\n    this._target = target;\n    this._prop = prop;\n    this._from = from;\n    this._to = to;\n    this._promises = undefined;\n  }\n  active() {\n    return this._active;\n  }\n  update(cfg, to, date) {\n    const me = this;\n    if (me._active) {\n      me._notify(false);\n      const currentValue = me._target[me._prop];\n      const elapsed = date - me._start;\n      const remain = me._duration - elapsed;\n      me._start = date;\n      me._duration = Math.floor(Math.max(remain, cfg.duration));\n      me._total += elapsed;\n      me._loop = !!cfg.loop;\n      me._to = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([cfg.to, to, currentValue, cfg.from]);\n      me._from = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([cfg.from, currentValue, to]);\n    }\n  }\n  cancel() {\n    const me = this;\n    if (me._active) {\n      me.tick(Date.now());\n      me._active = false;\n      me._notify(false);\n    }\n  }\n  tick(date) {\n    const me = this;\n    const elapsed = date - me._start;\n    const duration = me._duration;\n    const prop = me._prop;\n    const from = me._from;\n    const loop = me._loop;\n    const to = me._to;\n    let factor;\n    me._active = from !== to && (loop || (elapsed < duration));\n    if (!me._active) {\n      me._target[prop] = to;\n      me._notify(true);\n      return;\n    }\n    if (elapsed < 0) {\n      me._target[prop] = from;\n      return;\n    }\n    factor = (elapsed / duration) % 2;\n    factor = loop && factor > 1 ? 2 - factor : factor;\n    factor = me._easing(Math.min(1, Math.max(0, factor)));\n    me._target[prop] = me._fn(from, to, factor);\n  }\n  wait() {\n    const promises = this._promises || (this._promises = []);\n    return new Promise((res, rej) => {\n      promises.push({res, rej});\n    });\n  }\n  _notify(resolved) {\n    const method = resolved ? 'res' : 'rej';\n    const promises = this._promises || [];\n    for (let i = 0; i < promises.length; i++) {\n      promises[i][method]();\n    }\n  }\n}\n\nconst numbers = ['x', 'y', 'borderWidth', 'radius', 'tension'];\nconst colors = ['color', 'borderColor', 'backgroundColor'];\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.set('animation', {\n  delay: undefined,\n  duration: 1000,\n  easing: 'easeOutQuart',\n  fn: undefined,\n  from: undefined,\n  loop: undefined,\n  to: undefined,\n  type: undefined,\n});\nconst animationOptions = Object.keys(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.animation);\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.describe('animation', {\n  _fallback: false,\n  _indexable: false,\n  _scriptable: (name) => name !== 'onProgress' && name !== 'onComplete' && name !== 'fn',\n});\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.set('animations', {\n  colors: {\n    type: 'color',\n    properties: colors\n  },\n  numbers: {\n    type: 'number',\n    properties: numbers\n  },\n});\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.describe('animations', {\n  _fallback: 'animation',\n});\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.set('transitions', {\n  active: {\n    animation: {\n      duration: 400\n    }\n  },\n  resize: {\n    animation: {\n      duration: 0\n    }\n  },\n  show: {\n    animations: {\n      colors: {\n        from: 'transparent'\n      },\n      visible: {\n        type: 'boolean',\n        duration: 0\n      },\n    }\n  },\n  hide: {\n    animations: {\n      colors: {\n        to: 'transparent'\n      },\n      visible: {\n        type: 'boolean',\n        easing: 'linear',\n        fn: v => v | 0\n      },\n    }\n  }\n});\nclass Animations {\n  constructor(chart, config) {\n    this._chart = chart;\n    this._properties = new Map();\n    this.configure(config);\n  }\n  configure(config) {\n    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(config)) {\n      return;\n    }\n    const animatedProps = this._properties;\n    Object.getOwnPropertyNames(config).forEach(key => {\n      const cfg = config[key];\n      if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(cfg)) {\n        return;\n      }\n      const resolved = {};\n      for (const option of animationOptions) {\n        resolved[option] = cfg[option];\n      }\n      ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(cfg.properties) && cfg.properties || [key]).forEach((prop) => {\n        if (prop === key || !animatedProps.has(prop)) {\n          animatedProps.set(prop, resolved);\n        }\n      });\n    });\n  }\n  _animateOptions(target, values) {\n    const newOptions = values.options;\n    const options = resolveTargetOptions(target, newOptions);\n    if (!options) {\n      return [];\n    }\n    const animations = this._createAnimations(options, newOptions);\n    if (newOptions.$shared) {\n      awaitAll(target.options.$animations, newOptions).then(() => {\n        target.options = newOptions;\n      }, () => {\n      });\n    }\n    return animations;\n  }\n  _createAnimations(target, values) {\n    const animatedProps = this._properties;\n    const animations = [];\n    const running = target.$animations || (target.$animations = {});\n    const props = Object.keys(values);\n    const date = Date.now();\n    let i;\n    for (i = props.length - 1; i >= 0; --i) {\n      const prop = props[i];\n      if (prop.charAt(0) === '$') {\n        continue;\n      }\n      if (prop === 'options') {\n        animations.push(...this._animateOptions(target, values));\n        continue;\n      }\n      const value = values[prop];\n      let animation = running[prop];\n      const cfg = animatedProps.get(prop);\n      if (animation) {\n        if (cfg && animation.active()) {\n          animation.update(cfg, value, date);\n          continue;\n        } else {\n          animation.cancel();\n        }\n      }\n      if (!cfg || !cfg.duration) {\n        target[prop] = value;\n        continue;\n      }\n      running[prop] = animation = new Animation(cfg, target, prop, value);\n      animations.push(animation);\n    }\n    return animations;\n  }\n  update(target, values) {\n    if (this._properties.size === 0) {\n      Object.assign(target, values);\n      return;\n    }\n    const animations = this._createAnimations(target, values);\n    if (animations.length) {\n      animator.add(this._chart, animations);\n      return true;\n    }\n  }\n}\nfunction awaitAll(animations, properties) {\n  const running = [];\n  const keys = Object.keys(properties);\n  for (let i = 0; i < keys.length; i++) {\n    const anim = animations[keys[i]];\n    if (anim && anim.active()) {\n      running.push(anim.wait());\n    }\n  }\n  return Promise.all(running);\n}\nfunction resolveTargetOptions(target, newOptions) {\n  if (!newOptions) {\n    return;\n  }\n  let options = target.options;\n  if (!options) {\n    target.options = newOptions;\n    return;\n  }\n  if (options.$shared) {\n    target.options = options = Object.assign({}, options, {$shared: false, $animations: {}});\n  }\n  return options;\n}\n\nfunction scaleClip(scale, allowedOverflow) {\n  const opts = scale && scale.options || {};\n  const reverse = opts.reverse;\n  const min = opts.min === undefined ? allowedOverflow : 0;\n  const max = opts.max === undefined ? allowedOverflow : 0;\n  return {\n    start: reverse ? max : min,\n    end: reverse ? min : max\n  };\n}\nfunction defaultClip(xScale, yScale, allowedOverflow) {\n  if (allowedOverflow === false) {\n    return false;\n  }\n  const x = scaleClip(xScale, allowedOverflow);\n  const y = scaleClip(yScale, allowedOverflow);\n  return {\n    top: y.end,\n    right: x.end,\n    bottom: y.start,\n    left: x.start\n  };\n}\nfunction toClip(value) {\n  let t, r, b, l;\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(value)) {\n    t = value.top;\n    r = value.right;\n    b = value.bottom;\n    l = value.left;\n  } else {\n    t = r = b = l = value;\n  }\n  return {\n    top: t,\n    right: r,\n    bottom: b,\n    left: l,\n    disabled: value === false\n  };\n}\nfunction getSortedDatasetIndices(chart, filterVisible) {\n  const keys = [];\n  const metasets = chart._getSortedDatasetMetas(filterVisible);\n  let i, ilen;\n  for (i = 0, ilen = metasets.length; i < ilen; ++i) {\n    keys.push(metasets[i].index);\n  }\n  return keys;\n}\nfunction applyStack(stack, value, dsIndex, options) {\n  const keys = stack.keys;\n  const singleMode = options.mode === 'single';\n  let i, ilen, datasetIndex, otherValue;\n  if (value === null) {\n    return;\n  }\n  for (i = 0, ilen = keys.length; i < ilen; ++i) {\n    datasetIndex = +keys[i];\n    if (datasetIndex === dsIndex) {\n      if (options.all) {\n        continue;\n      }\n      break;\n    }\n    otherValue = stack.values[datasetIndex];\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(otherValue) && (singleMode || (value === 0 || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(value) === (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(otherValue)))) {\n      value += otherValue;\n    }\n  }\n  return value;\n}\nfunction convertObjectDataToArray(data) {\n  const keys = Object.keys(data);\n  const adata = new Array(keys.length);\n  let i, ilen, key;\n  for (i = 0, ilen = keys.length; i < ilen; ++i) {\n    key = keys[i];\n    adata[i] = {\n      x: key,\n      y: data[key]\n    };\n  }\n  return adata;\n}\nfunction isStacked(scale, meta) {\n  const stacked = scale && scale.options.stacked;\n  return stacked || (stacked === undefined && meta.stack !== undefined);\n}\nfunction getStackKey(indexScale, valueScale, meta) {\n  return `${indexScale.id}.${valueScale.id}.${meta.stack || meta.type}`;\n}\nfunction getUserBounds(scale) {\n  const {min, max, minDefined, maxDefined} = scale.getUserBounds();\n  return {\n    min: minDefined ? min : Number.NEGATIVE_INFINITY,\n    max: maxDefined ? max : Number.POSITIVE_INFINITY\n  };\n}\nfunction getOrCreateStack(stacks, stackKey, indexValue) {\n  const subStack = stacks[stackKey] || (stacks[stackKey] = {});\n  return subStack[indexValue] || (subStack[indexValue] = {});\n}\nfunction getLastIndexInStack(stack, vScale, positive) {\n  for (const meta of vScale.getMatchingVisibleMetas('bar').reverse()) {\n    const value = stack[meta.index];\n    if ((positive && value > 0) || (!positive && value < 0)) {\n      return meta.index;\n    }\n  }\n  return null;\n}\nfunction updateStacks(controller, parsed) {\n  const {chart, _cachedMeta: meta} = controller;\n  const stacks = chart._stacks || (chart._stacks = {});\n  const {iScale, vScale, index: datasetIndex} = meta;\n  const iAxis = iScale.axis;\n  const vAxis = vScale.axis;\n  const key = getStackKey(iScale, vScale, meta);\n  const ilen = parsed.length;\n  let stack;\n  for (let i = 0; i < ilen; ++i) {\n    const item = parsed[i];\n    const {[iAxis]: index, [vAxis]: value} = item;\n    const itemStacks = item._stacks || (item._stacks = {});\n    stack = itemStacks[vAxis] = getOrCreateStack(stacks, key, index);\n    stack[datasetIndex] = value;\n    stack._top = getLastIndexInStack(stack, vScale, true);\n    stack._bottom = getLastIndexInStack(stack, vScale, false);\n  }\n}\nfunction getFirstScaleId(chart, axis) {\n  const scales = chart.scales;\n  return Object.keys(scales).filter(key => scales[key].axis === axis).shift();\n}\nfunction createDatasetContext(parent, index) {\n  return Object.assign(Object.create(parent),\n    {\n      active: false,\n      dataset: undefined,\n      datasetIndex: index,\n      index,\n      mode: 'default',\n      type: 'dataset'\n    }\n  );\n}\nfunction createDataContext(parent, index, element) {\n  return Object.assign(Object.create(parent), {\n    active: false,\n    dataIndex: index,\n    parsed: undefined,\n    raw: undefined,\n    element,\n    index,\n    mode: 'default',\n    type: 'data'\n  });\n}\nfunction clearStacks(meta, items) {\n  const datasetIndex = meta.controller.index;\n  const axis = meta.vScale && meta.vScale.axis;\n  if (!axis) {\n    return;\n  }\n  items = items || meta._parsed;\n  for (const parsed of items) {\n    const stacks = parsed._stacks;\n    if (!stacks || stacks[axis] === undefined || stacks[axis][datasetIndex] === undefined) {\n      return;\n    }\n    delete stacks[axis][datasetIndex];\n  }\n}\nconst isDirectUpdateMode = (mode) => mode === 'reset' || mode === 'none';\nconst cloneIfNotShared = (cached, shared) => shared ? cached : Object.assign({}, cached);\nclass DatasetController {\n  constructor(chart, datasetIndex) {\n    this.chart = chart;\n    this._ctx = chart.ctx;\n    this.index = datasetIndex;\n    this._cachedDataOpts = {};\n    this._cachedMeta = this.getMeta();\n    this._type = this._cachedMeta.type;\n    this.options = undefined;\n    this._parsing = false;\n    this._data = undefined;\n    this._objectData = undefined;\n    this._sharedOptions = undefined;\n    this._drawStart = undefined;\n    this._drawCount = undefined;\n    this.enableOptionSharing = false;\n    this.$context = undefined;\n    this._syncList = [];\n    this.initialize();\n  }\n  initialize() {\n    const me = this;\n    const meta = me._cachedMeta;\n    me.configure();\n    me.linkScales();\n    meta._stacked = isStacked(meta.vScale, meta);\n    me.addElements();\n  }\n  updateIndex(datasetIndex) {\n    if (this.index !== datasetIndex) {\n      clearStacks(this._cachedMeta);\n    }\n    this.index = datasetIndex;\n  }\n  linkScales() {\n    const me = this;\n    const chart = me.chart;\n    const meta = me._cachedMeta;\n    const dataset = me.getDataset();\n    const chooseId = (axis, x, y, r) => axis === 'x' ? x : axis === 'r' ? r : y;\n    const xid = meta.xAxisID = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(dataset.xAxisID, getFirstScaleId(chart, 'x'));\n    const yid = meta.yAxisID = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(dataset.yAxisID, getFirstScaleId(chart, 'y'));\n    const rid = meta.rAxisID = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(dataset.rAxisID, getFirstScaleId(chart, 'r'));\n    const indexAxis = meta.indexAxis;\n    const iid = meta.iAxisID = chooseId(indexAxis, xid, yid, rid);\n    const vid = meta.vAxisID = chooseId(indexAxis, yid, xid, rid);\n    meta.xScale = me.getScaleForId(xid);\n    meta.yScale = me.getScaleForId(yid);\n    meta.rScale = me.getScaleForId(rid);\n    meta.iScale = me.getScaleForId(iid);\n    meta.vScale = me.getScaleForId(vid);\n  }\n  getDataset() {\n    return this.chart.data.datasets[this.index];\n  }\n  getMeta() {\n    return this.chart.getDatasetMeta(this.index);\n  }\n  getScaleForId(scaleID) {\n    return this.chart.scales[scaleID];\n  }\n  _getOtherScale(scale) {\n    const meta = this._cachedMeta;\n    return scale === meta.iScale\n      ? meta.vScale\n      : meta.iScale;\n  }\n  reset() {\n    this._update('reset');\n  }\n  _destroy() {\n    const meta = this._cachedMeta;\n    if (this._data) {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.u)(this._data, this);\n    }\n    if (meta._stacked) {\n      clearStacks(meta);\n    }\n  }\n  _dataCheck() {\n    const me = this;\n    const dataset = me.getDataset();\n    const data = dataset.data || (dataset.data = []);\n    const _data = me._data;\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(data)) {\n      me._data = convertObjectDataToArray(data);\n    } else if (_data !== data) {\n      if (_data) {\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.u)(_data, me);\n        const meta = me._cachedMeta;\n        clearStacks(meta);\n        meta._parsed = [];\n      }\n      if (data && Object.isExtensible(data)) {\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.l)(data, me);\n      }\n      me._syncList = [];\n      me._data = data;\n    }\n  }\n  addElements() {\n    const me = this;\n    const meta = me._cachedMeta;\n    me._dataCheck();\n    if (me.datasetElementType) {\n      meta.dataset = new me.datasetElementType();\n    }\n  }\n  buildOrUpdateElements(resetNewElements) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const dataset = me.getDataset();\n    let stackChanged = false;\n    me._dataCheck();\n    const oldStacked = meta._stacked;\n    meta._stacked = isStacked(meta.vScale, meta);\n    if (meta.stack !== dataset.stack) {\n      stackChanged = true;\n      clearStacks(meta);\n      meta.stack = dataset.stack;\n    }\n    me._resyncElements(resetNewElements);\n    if (stackChanged || oldStacked !== meta._stacked) {\n      updateStacks(me, meta._parsed);\n    }\n  }\n  configure() {\n    const me = this;\n    const config = me.chart.config;\n    const scopeKeys = config.datasetScopeKeys(me._type);\n    const scopes = config.getOptionScopes(me.getDataset(), scopeKeys, true);\n    me.options = config.createResolver(scopes, me.getContext());\n    me._parsing = me.options.parsing;\n  }\n  parse(start, count) {\n    const me = this;\n    const {_cachedMeta: meta, _data: data} = me;\n    const {iScale, _stacked} = meta;\n    const iAxis = iScale.axis;\n    let sorted = start === 0 && count === data.length ? true : meta._sorted;\n    let prev = start > 0 && meta._parsed[start - 1];\n    let i, cur, parsed;\n    if (me._parsing === false) {\n      meta._parsed = data;\n      meta._sorted = true;\n      parsed = data;\n    } else {\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(data[start])) {\n        parsed = me.parseArrayData(meta, data, start, count);\n      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(data[start])) {\n        parsed = me.parseObjectData(meta, data, start, count);\n      } else {\n        parsed = me.parsePrimitiveData(meta, data, start, count);\n      }\n      const isNotInOrderComparedToPrev = () => cur[iAxis] === null || (prev && cur[iAxis] < prev[iAxis]);\n      for (i = 0; i < count; ++i) {\n        meta._parsed[i + start] = cur = parsed[i];\n        if (sorted) {\n          if (isNotInOrderComparedToPrev()) {\n            sorted = false;\n          }\n          prev = cur;\n        }\n      }\n      meta._sorted = sorted;\n    }\n    if (_stacked) {\n      updateStacks(me, parsed);\n    }\n  }\n  parsePrimitiveData(meta, data, start, count) {\n    const {iScale, vScale} = meta;\n    const iAxis = iScale.axis;\n    const vAxis = vScale.axis;\n    const labels = iScale.getLabels();\n    const singleScale = iScale === vScale;\n    const parsed = new Array(count);\n    let i, ilen, index;\n    for (i = 0, ilen = count; i < ilen; ++i) {\n      index = i + start;\n      parsed[i] = {\n        [iAxis]: singleScale || iScale.parse(labels[index], index),\n        [vAxis]: vScale.parse(data[index], index)\n      };\n    }\n    return parsed;\n  }\n  parseArrayData(meta, data, start, count) {\n    const {xScale, yScale} = meta;\n    const parsed = new Array(count);\n    let i, ilen, index, item;\n    for (i = 0, ilen = count; i < ilen; ++i) {\n      index = i + start;\n      item = data[index];\n      parsed[i] = {\n        x: xScale.parse(item[0], index),\n        y: yScale.parse(item[1], index)\n      };\n    }\n    return parsed;\n  }\n  parseObjectData(meta, data, start, count) {\n    const {xScale, yScale} = meta;\n    const {xAxisKey = 'x', yAxisKey = 'y'} = this._parsing;\n    const parsed = new Array(count);\n    let i, ilen, index, item;\n    for (i = 0, ilen = count; i < ilen; ++i) {\n      index = i + start;\n      item = data[index];\n      parsed[i] = {\n        x: xScale.parse((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(item, xAxisKey), index),\n        y: yScale.parse((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(item, yAxisKey), index)\n      };\n    }\n    return parsed;\n  }\n  getParsed(index) {\n    return this._cachedMeta._parsed[index];\n  }\n  getDataElement(index) {\n    return this._cachedMeta.data[index];\n  }\n  applyStack(scale, parsed, mode) {\n    const chart = this.chart;\n    const meta = this._cachedMeta;\n    const value = parsed[scale.axis];\n    const stack = {\n      keys: getSortedDatasetIndices(chart, true),\n      values: parsed._stacks[scale.axis]\n    };\n    return applyStack(stack, value, meta.index, {mode});\n  }\n  updateRangeFromParsed(range, scale, parsed, stack) {\n    const parsedValue = parsed[scale.axis];\n    let value = parsedValue === null ? NaN : parsedValue;\n    const values = stack && parsed._stacks[scale.axis];\n    if (stack && values) {\n      stack.values = values;\n      range.min = Math.min(range.min, value);\n      range.max = Math.max(range.max, value);\n      value = applyStack(stack, parsedValue, this._cachedMeta.index, {all: true});\n    }\n    range.min = Math.min(range.min, value);\n    range.max = Math.max(range.max, value);\n  }\n  getMinMax(scale, canStack) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const _parsed = meta._parsed;\n    const sorted = meta._sorted && scale === meta.iScale;\n    const ilen = _parsed.length;\n    const otherScale = me._getOtherScale(scale);\n    const stack = canStack && meta._stacked && {keys: getSortedDatasetIndices(me.chart, true), values: null};\n    const range = {min: Number.POSITIVE_INFINITY, max: Number.NEGATIVE_INFINITY};\n    const {min: otherMin, max: otherMax} = getUserBounds(otherScale);\n    let i, value, parsed, otherValue;\n    function _skip() {\n      parsed = _parsed[i];\n      value = parsed[scale.axis];\n      otherValue = parsed[otherScale.axis];\n      return !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(value) || otherMin > otherValue || otherMax < otherValue;\n    }\n    for (i = 0; i < ilen; ++i) {\n      if (_skip()) {\n        continue;\n      }\n      me.updateRangeFromParsed(range, scale, parsed, stack);\n      if (sorted) {\n        break;\n      }\n    }\n    if (sorted) {\n      for (i = ilen - 1; i >= 0; --i) {\n        if (_skip()) {\n          continue;\n        }\n        me.updateRangeFromParsed(range, scale, parsed, stack);\n        break;\n      }\n    }\n    return range;\n  }\n  getAllParsedValues(scale) {\n    const parsed = this._cachedMeta._parsed;\n    const values = [];\n    let i, ilen, value;\n    for (i = 0, ilen = parsed.length; i < ilen; ++i) {\n      value = parsed[i][scale.axis];\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(value)) {\n        values.push(value);\n      }\n    }\n    return values;\n  }\n  getMaxOverflow() {\n    return false;\n  }\n  getLabelAndValue(index) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const iScale = meta.iScale;\n    const vScale = meta.vScale;\n    const parsed = me.getParsed(index);\n    return {\n      label: iScale ? '' + iScale.getLabelForValue(parsed[iScale.axis]) : '',\n      value: vScale ? '' + vScale.getLabelForValue(parsed[vScale.axis]) : ''\n    };\n  }\n  _update(mode) {\n    const me = this;\n    const meta = me._cachedMeta;\n    me.configure();\n    me._cachedDataOpts = {};\n    me.update(mode || 'default');\n    meta._clip = toClip((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(me.options.clip, defaultClip(meta.xScale, meta.yScale, me.getMaxOverflow())));\n  }\n  update(mode) {}\n  draw() {\n    const me = this;\n    const ctx = me._ctx;\n    const chart = me.chart;\n    const meta = me._cachedMeta;\n    const elements = meta.data || [];\n    const area = chart.chartArea;\n    const active = [];\n    const start = me._drawStart || 0;\n    const count = me._drawCount || (elements.length - start);\n    let i;\n    if (meta.dataset) {\n      meta.dataset.draw(ctx, area, start, count);\n    }\n    for (i = start; i < start + count; ++i) {\n      const element = elements[i];\n      if (element.hidden) {\n        continue;\n      }\n      if (element.active) {\n        active.push(element);\n      } else {\n        element.draw(ctx, area);\n      }\n    }\n    for (i = 0; i < active.length; ++i) {\n      active[i].draw(ctx, area);\n    }\n  }\n  getStyle(index, active) {\n    const mode = active ? 'active' : 'default';\n    return index === undefined && this._cachedMeta.dataset\n      ? this.resolveDatasetElementOptions(mode)\n      : this.resolveDataElementOptions(index || 0, mode);\n  }\n  getContext(index, active, mode) {\n    const me = this;\n    const dataset = me.getDataset();\n    let context;\n    if (index >= 0 && index < me._cachedMeta.data.length) {\n      const element = me._cachedMeta.data[index];\n      context = element.$context ||\n        (element.$context = createDataContext(me.getContext(), index, element));\n      context.parsed = me.getParsed(index);\n      context.raw = dataset.data[index];\n      context.index = context.dataIndex = index;\n    } else {\n      context = me.$context ||\n        (me.$context = createDatasetContext(me.chart.getContext(), me.index));\n      context.dataset = dataset;\n      context.index = context.datasetIndex = me.index;\n    }\n    context.active = !!active;\n    context.mode = mode;\n    return context;\n  }\n  resolveDatasetElementOptions(mode) {\n    return this._resolveElementOptions(this.datasetElementType.id, mode);\n  }\n  resolveDataElementOptions(index, mode) {\n    return this._resolveElementOptions(this.dataElementType.id, mode, index);\n  }\n  _resolveElementOptions(elementType, mode = 'default', index) {\n    const me = this;\n    const active = mode === 'active';\n    const cache = me._cachedDataOpts;\n    const cacheKey = elementType + '-' + mode;\n    const cached = cache[cacheKey];\n    const sharing = me.enableOptionSharing && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(index);\n    if (cached) {\n      return cloneIfNotShared(cached, sharing);\n    }\n    const config = me.chart.config;\n    const scopeKeys = config.datasetElementScopeKeys(me._type, elementType);\n    const prefixes = active ? [`${elementType}Hover`, 'hover', elementType, ''] : [elementType, ''];\n    const scopes = config.getOptionScopes(me.getDataset(), scopeKeys);\n    const names = Object.keys(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.elements[elementType]);\n    const context = () => me.getContext(index, active);\n    const values = config.resolveNamedOptions(scopes, names, context, prefixes);\n    if (values.$shared) {\n      values.$shared = sharing;\n      cache[cacheKey] = Object.freeze(cloneIfNotShared(values, sharing));\n    }\n    return values;\n  }\n  _resolveAnimations(index, transition, active) {\n    const me = this;\n    const chart = me.chart;\n    const cache = me._cachedDataOpts;\n    const cacheKey = `animation-${transition}`;\n    const cached = cache[cacheKey];\n    if (cached) {\n      return cached;\n    }\n    let options;\n    if (chart.options.animation !== false) {\n      const config = me.chart.config;\n      const scopeKeys = config.datasetAnimationScopeKeys(me._type, transition);\n      const scopes = config.getOptionScopes(me.getDataset(), scopeKeys);\n      options = config.createResolver(scopes, me.getContext(index, active, transition));\n    }\n    const animations = new Animations(chart, options && options.animations);\n    if (options && options._cacheable) {\n      cache[cacheKey] = Object.freeze(animations);\n    }\n    return animations;\n  }\n  getSharedOptions(options) {\n    if (!options.$shared) {\n      return;\n    }\n    return this._sharedOptions || (this._sharedOptions = Object.assign({}, options));\n  }\n  includeOptions(mode, sharedOptions) {\n    return !sharedOptions || isDirectUpdateMode(mode) || this.chart._animationsDisabled;\n  }\n  updateElement(element, index, properties, mode) {\n    if (isDirectUpdateMode(mode)) {\n      Object.assign(element, properties);\n    } else {\n      this._resolveAnimations(index, mode).update(element, properties);\n    }\n  }\n  updateSharedOptions(sharedOptions, mode, newOptions) {\n    if (sharedOptions && !isDirectUpdateMode(mode)) {\n      this._resolveAnimations(undefined, mode).update(sharedOptions, newOptions);\n    }\n  }\n  _setStyle(element, index, mode, active) {\n    element.active = active;\n    const options = this.getStyle(index, active);\n    this._resolveAnimations(index, mode, active).update(element, {\n      options: (!active && this.getSharedOptions(options)) || options\n    });\n  }\n  removeHoverStyle(element, datasetIndex, index) {\n    this._setStyle(element, index, 'active', false);\n  }\n  setHoverStyle(element, datasetIndex, index) {\n    this._setStyle(element, index, 'active', true);\n  }\n  _removeDatasetHoverStyle() {\n    const element = this._cachedMeta.dataset;\n    if (element) {\n      this._setStyle(element, undefined, 'active', false);\n    }\n  }\n  _setDatasetHoverStyle() {\n    const element = this._cachedMeta.dataset;\n    if (element) {\n      this._setStyle(element, undefined, 'active', true);\n    }\n  }\n  _resyncElements(resetNewElements) {\n    const me = this;\n    const data = me._data;\n    const elements = me._cachedMeta.data;\n    for (const [method, arg1, arg2] of me._syncList) {\n      me[method](arg1, arg2);\n    }\n    me._syncList = [];\n    const numMeta = elements.length;\n    const numData = data.length;\n    const count = Math.min(numData, numMeta);\n    if (count) {\n      me.parse(0, count);\n    }\n    if (numData > numMeta) {\n      me._insertElements(numMeta, numData - numMeta, resetNewElements);\n    } else if (numData < numMeta) {\n      me._removeElements(numData, numMeta - numData);\n    }\n  }\n  _insertElements(start, count, resetNewElements = true) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const data = meta.data;\n    const end = start + count;\n    let i;\n    const move = (arr) => {\n      arr.length += count;\n      for (i = arr.length - 1; i >= end; i--) {\n        arr[i] = arr[i - count];\n      }\n    };\n    move(data);\n    for (i = start; i < end; ++i) {\n      data[i] = new me.dataElementType();\n    }\n    if (me._parsing) {\n      move(meta._parsed);\n    }\n    me.parse(start, count);\n    if (resetNewElements) {\n      me.updateElements(data, start, count, 'reset');\n    }\n  }\n  updateElements(element, start, count, mode) {}\n  _removeElements(start, count) {\n    const me = this;\n    const meta = me._cachedMeta;\n    if (me._parsing) {\n      const removed = meta._parsed.splice(start, count);\n      if (meta._stacked) {\n        clearStacks(meta, removed);\n      }\n    }\n    meta.data.splice(start, count);\n  }\n  _sync(args) {\n    if (this._parsing) {\n      this._syncList.push(args);\n    } else {\n      const [method, arg1, arg2] = args;\n      this[method](arg1, arg2);\n    }\n  }\n  _onDataPush() {\n    const count = arguments.length;\n    this._sync(['_insertElements', this.getDataset().data.length - count, count]);\n  }\n  _onDataPop() {\n    this._sync(['_removeElements', this._cachedMeta.data.length - 1, 1]);\n  }\n  _onDataShift() {\n    this._sync(['_removeElements', 0, 1]);\n  }\n  _onDataSplice(start, count) {\n    this._sync(['_removeElements', start, count]);\n    this._sync(['_insertElements', start, arguments.length - 2]);\n  }\n  _onDataUnshift() {\n    this._sync(['_insertElements', 0, arguments.length]);\n  }\n}\nDatasetController.defaults = {};\nDatasetController.prototype.datasetElementType = null;\nDatasetController.prototype.dataElementType = null;\n\nfunction getAllScaleValues(scale) {\n  if (!scale._cache.$bar) {\n    const metas = scale.getMatchingVisibleMetas('bar');\n    let values = [];\n    for (let i = 0, ilen = metas.length; i < ilen; i++) {\n      values = values.concat(metas[i].controller.getAllParsedValues(scale));\n    }\n    scale._cache.$bar = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__._)(values.sort((a, b) => a - b));\n  }\n  return scale._cache.$bar;\n}\nfunction computeMinSampleSize(scale) {\n  const values = getAllScaleValues(scale);\n  let min = scale._length;\n  let i, ilen, curr, prev;\n  const updateMinAndPrev = () => {\n    if (curr === 32767 || curr === -32768) {\n      return;\n    }\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(prev)) {\n      min = Math.min(min, Math.abs(curr - prev) || min);\n    }\n    prev = curr;\n  };\n  for (i = 0, ilen = values.length; i < ilen; ++i) {\n    curr = scale.getPixelForValue(values[i]);\n    updateMinAndPrev();\n  }\n  prev = undefined;\n  for (i = 0, ilen = scale.ticks.length; i < ilen; ++i) {\n    curr = scale.getPixelForTick(i);\n    updateMinAndPrev();\n  }\n  return min;\n}\nfunction computeFitCategoryTraits(index, ruler, options, stackCount) {\n  const thickness = options.barThickness;\n  let size, ratio;\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(thickness)) {\n    size = ruler.min * options.categoryPercentage;\n    ratio = options.barPercentage;\n  } else {\n    size = thickness * stackCount;\n    ratio = 1;\n  }\n  return {\n    chunk: size / stackCount,\n    ratio,\n    start: ruler.pixels[index] - (size / 2)\n  };\n}\nfunction computeFlexCategoryTraits(index, ruler, options, stackCount) {\n  const pixels = ruler.pixels;\n  const curr = pixels[index];\n  let prev = index > 0 ? pixels[index - 1] : null;\n  let next = index < pixels.length - 1 ? pixels[index + 1] : null;\n  const percent = options.categoryPercentage;\n  if (prev === null) {\n    prev = curr - (next === null ? ruler.end - ruler.start : next - curr);\n  }\n  if (next === null) {\n    next = curr + curr - prev;\n  }\n  const start = curr - (curr - Math.min(prev, next)) / 2 * percent;\n  const size = Math.abs(next - prev) / 2 * percent;\n  return {\n    chunk: size / stackCount,\n    ratio: options.barPercentage,\n    start\n  };\n}\nfunction parseFloatBar(entry, item, vScale, i) {\n  const startValue = vScale.parse(entry[0], i);\n  const endValue = vScale.parse(entry[1], i);\n  const min = Math.min(startValue, endValue);\n  const max = Math.max(startValue, endValue);\n  let barStart = min;\n  let barEnd = max;\n  if (Math.abs(min) > Math.abs(max)) {\n    barStart = max;\n    barEnd = min;\n  }\n  item[vScale.axis] = barEnd;\n  item._custom = {\n    barStart,\n    barEnd,\n    start: startValue,\n    end: endValue,\n    min,\n    max\n  };\n}\nfunction parseValue(entry, item, vScale, i) {\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(entry)) {\n    parseFloatBar(entry, item, vScale, i);\n  } else {\n    item[vScale.axis] = vScale.parse(entry, i);\n  }\n  return item;\n}\nfunction parseArrayOrPrimitive(meta, data, start, count) {\n  const iScale = meta.iScale;\n  const vScale = meta.vScale;\n  const labels = iScale.getLabels();\n  const singleScale = iScale === vScale;\n  const parsed = [];\n  let i, ilen, item, entry;\n  for (i = start, ilen = start + count; i < ilen; ++i) {\n    entry = data[i];\n    item = {};\n    item[iScale.axis] = singleScale || iScale.parse(labels[i], i);\n    parsed.push(parseValue(entry, item, vScale, i));\n  }\n  return parsed;\n}\nfunction isFloatBar(custom) {\n  return custom && custom.barStart !== undefined && custom.barEnd !== undefined;\n}\nfunction barSign(size, vScale, actualBase) {\n  if (size !== 0) {\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(size);\n  }\n  return (vScale.isHorizontal() ? 1 : -1) * (vScale.min >= actualBase ? 1 : -1);\n}\nfunction borderProps(properties) {\n  let reverse, start, end, top, bottom;\n  if (properties.horizontal) {\n    reverse = properties.base > properties.x;\n    start = 'left';\n    end = 'right';\n  } else {\n    reverse = properties.base < properties.y;\n    start = 'bottom';\n    end = 'top';\n  }\n  if (reverse) {\n    top = 'end';\n    bottom = 'start';\n  } else {\n    top = 'start';\n    bottom = 'end';\n  }\n  return {start, end, reverse, top, bottom};\n}\nfunction setBorderSkipped(properties, options, stack, index) {\n  let edge = options.borderSkipped;\n  const res = {};\n  if (!edge) {\n    properties.borderSkipped = res;\n    return;\n  }\n  const {start, end, reverse, top, bottom} = borderProps(properties);\n  if (edge === 'middle' && stack) {\n    properties.enableBorderRadius = true;\n    if ((stack._top || 0) === index) {\n      edge = top;\n    } else if ((stack._bottom || 0) === index) {\n      edge = bottom;\n    } else {\n      res[parseEdge(bottom, start, end, reverse)] = true;\n      edge = top;\n    }\n  }\n  res[parseEdge(edge, start, end, reverse)] = true;\n  properties.borderSkipped = res;\n}\nfunction parseEdge(edge, a, b, reverse) {\n  if (reverse) {\n    edge = swap(edge, a, b);\n    edge = startEnd(edge, b, a);\n  } else {\n    edge = startEnd(edge, a, b);\n  }\n  return edge;\n}\nfunction swap(orig, v1, v2) {\n  return orig === v1 ? v2 : orig === v2 ? v1 : orig;\n}\nfunction startEnd(v, start, end) {\n  return v === 'start' ? start : v === 'end' ? end : v;\n}\nclass BarController extends DatasetController {\n  parsePrimitiveData(meta, data, start, count) {\n    return parseArrayOrPrimitive(meta, data, start, count);\n  }\n  parseArrayData(meta, data, start, count) {\n    return parseArrayOrPrimitive(meta, data, start, count);\n  }\n  parseObjectData(meta, data, start, count) {\n    const {iScale, vScale} = meta;\n    const {xAxisKey = 'x', yAxisKey = 'y'} = this._parsing;\n    const iAxisKey = iScale.axis === 'x' ? xAxisKey : yAxisKey;\n    const vAxisKey = vScale.axis === 'x' ? xAxisKey : yAxisKey;\n    const parsed = [];\n    let i, ilen, item, obj;\n    for (i = start, ilen = start + count; i < ilen; ++i) {\n      obj = data[i];\n      item = {};\n      item[iScale.axis] = iScale.parse((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(obj, iAxisKey), i);\n      parsed.push(parseValue((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(obj, vAxisKey), item, vScale, i));\n    }\n    return parsed;\n  }\n  updateRangeFromParsed(range, scale, parsed, stack) {\n    super.updateRangeFromParsed(range, scale, parsed, stack);\n    const custom = parsed._custom;\n    if (custom && scale === this._cachedMeta.vScale) {\n      range.min = Math.min(range.min, custom.min);\n      range.max = Math.max(range.max, custom.max);\n    }\n  }\n  getMaxOverflow() {\n    return 0;\n  }\n  getLabelAndValue(index) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const {iScale, vScale} = meta;\n    const parsed = me.getParsed(index);\n    const custom = parsed._custom;\n    const value = isFloatBar(custom)\n      ? '[' + custom.start + ', ' + custom.end + ']'\n      : '' + vScale.getLabelForValue(parsed[vScale.axis]);\n    return {\n      label: '' + iScale.getLabelForValue(parsed[iScale.axis]),\n      value\n    };\n  }\n  initialize() {\n    const me = this;\n    me.enableOptionSharing = true;\n    super.initialize();\n    const meta = me._cachedMeta;\n    meta.stack = me.getDataset().stack;\n  }\n  update(mode) {\n    const me = this;\n    const meta = me._cachedMeta;\n    me.updateElements(meta.data, 0, meta.data.length, mode);\n  }\n  updateElements(bars, start, count, mode) {\n    const me = this;\n    const reset = mode === 'reset';\n    const {index, _cachedMeta: {vScale}} = me;\n    const base = vScale.getBasePixel();\n    const horizontal = vScale.isHorizontal();\n    const ruler = me._getRuler();\n    const firstOpts = me.resolveDataElementOptions(start, mode);\n    const sharedOptions = me.getSharedOptions(firstOpts);\n    const includeOptions = me.includeOptions(mode, sharedOptions);\n    me.updateSharedOptions(sharedOptions, mode, firstOpts);\n    for (let i = start; i < start + count; i++) {\n      const parsed = me.getParsed(i);\n      const vpixels = reset || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(parsed[vScale.axis]) ? {base, head: base} : me._calculateBarValuePixels(i);\n      const ipixels = me._calculateBarIndexPixels(i, ruler);\n      const stack = (parsed._stacks || {})[vScale.axis];\n      const properties = {\n        horizontal,\n        base: vpixels.base,\n        enableBorderRadius: !stack || isFloatBar(parsed._custom) || (index === stack._top || index === stack._bottom),\n        x: horizontal ? vpixels.head : ipixels.center,\n        y: horizontal ? ipixels.center : vpixels.head,\n        height: horizontal ? ipixels.size : Math.abs(vpixels.size),\n        width: horizontal ? Math.abs(vpixels.size) : ipixels.size\n      };\n      if (includeOptions) {\n        properties.options = sharedOptions || me.resolveDataElementOptions(i, bars[i].active ? 'active' : mode);\n      }\n      setBorderSkipped(properties, properties.options || bars[i].options, stack, index);\n      me.updateElement(bars[i], i, properties, mode);\n    }\n  }\n  _getStacks(last, dataIndex) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const iScale = meta.iScale;\n    const metasets = iScale.getMatchingVisibleMetas(me._type);\n    const stacked = iScale.options.stacked;\n    const ilen = metasets.length;\n    const stacks = [];\n    let i, item;\n    for (i = 0; i < ilen; ++i) {\n      item = metasets[i];\n      if (!item.controller.options.grouped) {\n        continue;\n      }\n      if (typeof dataIndex !== 'undefined') {\n        const val = item.controller.getParsed(dataIndex)[\n          item.controller._cachedMeta.vScale.axis\n        ];\n        if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(val) || isNaN(val)) {\n          continue;\n        }\n      }\n      if (stacked === false || stacks.indexOf(item.stack) === -1 ||\n\t\t\t\t(stacked === undefined && item.stack === undefined)) {\n        stacks.push(item.stack);\n      }\n      if (item.index === last) {\n        break;\n      }\n    }\n    if (!stacks.length) {\n      stacks.push(undefined);\n    }\n    return stacks;\n  }\n  _getStackCount(index) {\n    return this._getStacks(undefined, index).length;\n  }\n  _getStackIndex(datasetIndex, name, dataIndex) {\n    const stacks = this._getStacks(datasetIndex, dataIndex);\n    const index = (name !== undefined)\n      ? stacks.indexOf(name)\n      : -1;\n    return (index === -1)\n      ? stacks.length - 1\n      : index;\n  }\n  _getRuler() {\n    const me = this;\n    const opts = me.options;\n    const meta = me._cachedMeta;\n    const iScale = meta.iScale;\n    const pixels = [];\n    let i, ilen;\n    for (i = 0, ilen = meta.data.length; i < ilen; ++i) {\n      pixels.push(iScale.getPixelForValue(me.getParsed(i)[iScale.axis], i));\n    }\n    const barThickness = opts.barThickness;\n    const min = barThickness || computeMinSampleSize(iScale);\n    return {\n      min,\n      pixels,\n      start: iScale._startPixel,\n      end: iScale._endPixel,\n      stackCount: me._getStackCount(),\n      scale: iScale,\n      grouped: opts.grouped,\n      ratio: barThickness ? 1 : opts.categoryPercentage * opts.barPercentage\n    };\n  }\n  _calculateBarValuePixels(index) {\n    const me = this;\n    const {_cachedMeta: {vScale, _stacked}, options: {base: baseValue, minBarLength}} = me;\n    const actualBase = baseValue || 0;\n    const parsed = me.getParsed(index);\n    const custom = parsed._custom;\n    const floating = isFloatBar(custom);\n    let value = parsed[vScale.axis];\n    let start = 0;\n    let length = _stacked ? me.applyStack(vScale, parsed, _stacked) : value;\n    let head, size;\n    if (length !== value) {\n      start = length - value;\n      length = value;\n    }\n    if (floating) {\n      value = custom.barStart;\n      length = custom.barEnd - custom.barStart;\n      if (value !== 0 && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(value) !== (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(custom.barEnd)) {\n        start = 0;\n      }\n      start += value;\n    }\n    const startValue = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(baseValue) && !floating ? baseValue : start;\n    let base = vScale.getPixelForValue(startValue);\n    if (me.chart.getDataVisibility(index)) {\n      head = vScale.getPixelForValue(start + length);\n    } else {\n      head = base;\n    }\n    size = head - base;\n    if (Math.abs(size) < minBarLength) {\n      size = barSign(size, vScale, actualBase) * minBarLength;\n      if (value === actualBase) {\n        base -= size / 2;\n      }\n      head = base + size;\n    }\n    if (base === vScale.getPixelForValue(actualBase)) {\n      const halfGrid = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(size) * vScale.getLineWidthForValue(actualBase) / 2;\n      base += halfGrid;\n      size -= halfGrid;\n    }\n    return {\n      size,\n      base,\n      head,\n      center: head + size / 2\n    };\n  }\n  _calculateBarIndexPixels(index, ruler) {\n    const me = this;\n    const scale = ruler.scale;\n    const options = me.options;\n    const skipNull = options.skipNull;\n    const maxBarThickness = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.maxBarThickness, Infinity);\n    let center, size;\n    if (ruler.grouped) {\n      const stackCount = skipNull ? me._getStackCount(index) : ruler.stackCount;\n      const range = options.barThickness === 'flex'\n        ? computeFlexCategoryTraits(index, ruler, options, stackCount)\n        : computeFitCategoryTraits(index, ruler, options, stackCount);\n      const stackIndex = me._getStackIndex(me.index, me._cachedMeta.stack, skipNull ? index : undefined);\n      center = range.start + (range.chunk * stackIndex) + (range.chunk / 2);\n      size = Math.min(maxBarThickness, range.chunk * range.ratio);\n    } else {\n      center = scale.getPixelForValue(me.getParsed(index)[scale.axis], index);\n      size = Math.min(maxBarThickness, ruler.min * ruler.ratio);\n    }\n    return {\n      base: center - size / 2,\n      head: center + size / 2,\n      center,\n      size\n    };\n  }\n  draw() {\n    const me = this;\n    const meta = me._cachedMeta;\n    const vScale = meta.vScale;\n    const rects = meta.data;\n    const ilen = rects.length;\n    let i = 0;\n    for (; i < ilen; ++i) {\n      if (me.getParsed(i)[vScale.axis] !== null) {\n        rects[i].draw(me._ctx);\n      }\n    }\n  }\n}\nBarController.id = 'bar';\nBarController.defaults = {\n  datasetElementType: false,\n  dataElementType: 'bar',\n  categoryPercentage: 0.8,\n  barPercentage: 0.9,\n  grouped: true,\n  animations: {\n    numbers: {\n      type: 'number',\n      properties: ['x', 'y', 'base', 'width', 'height']\n    }\n  }\n};\nBarController.overrides = {\n  scales: {\n    _index_: {\n      type: 'category',\n      offset: true,\n      grid: {\n        offset: true\n      }\n    },\n    _value_: {\n      type: 'linear',\n      beginAtZero: true,\n    }\n  }\n};\n\nclass BubbleController extends DatasetController {\n  initialize() {\n    this.enableOptionSharing = true;\n    super.initialize();\n  }\n  parseObjectData(meta, data, start, count) {\n    const {xScale, yScale} = meta;\n    const {xAxisKey = 'x', yAxisKey = 'y'} = this._parsing;\n    const parsed = [];\n    let i, ilen, item;\n    for (i = start, ilen = start + count; i < ilen; ++i) {\n      item = data[i];\n      parsed.push({\n        x: xScale.parse((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(item, xAxisKey), i),\n        y: yScale.parse((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(item, yAxisKey), i),\n        _custom: item && item.r && +item.r\n      });\n    }\n    return parsed;\n  }\n  getMaxOverflow() {\n    const {data, _parsed} = this._cachedMeta;\n    let max = 0;\n    for (let i = data.length - 1; i >= 0; --i) {\n      max = Math.max(max, data[i].size() / 2, _parsed[i]._custom);\n    }\n    return max > 0 && max;\n  }\n  getLabelAndValue(index) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const {xScale, yScale} = meta;\n    const parsed = me.getParsed(index);\n    const x = xScale.getLabelForValue(parsed.x);\n    const y = yScale.getLabelForValue(parsed.y);\n    const r = parsed._custom;\n    return {\n      label: meta.label,\n      value: '(' + x + ', ' + y + (r ? ', ' + r : '') + ')'\n    };\n  }\n  update(mode) {\n    const me = this;\n    const points = me._cachedMeta.data;\n    me.updateElements(points, 0, points.length, mode);\n  }\n  updateElements(points, start, count, mode) {\n    const me = this;\n    const reset = mode === 'reset';\n    const {iScale, vScale} = me._cachedMeta;\n    const firstOpts = me.resolveDataElementOptions(start, mode);\n    const sharedOptions = me.getSharedOptions(firstOpts);\n    const includeOptions = me.includeOptions(mode, sharedOptions);\n    const iAxis = iScale.axis;\n    const vAxis = vScale.axis;\n    for (let i = start; i < start + count; i++) {\n      const point = points[i];\n      const parsed = !reset && me.getParsed(i);\n      const properties = {};\n      const iPixel = properties[iAxis] = reset ? iScale.getPixelForDecimal(0.5) : iScale.getPixelForValue(parsed[iAxis]);\n      const vPixel = properties[vAxis] = reset ? vScale.getBasePixel() : vScale.getPixelForValue(parsed[vAxis]);\n      properties.skip = isNaN(iPixel) || isNaN(vPixel);\n      if (includeOptions) {\n        properties.options = me.resolveDataElementOptions(i, point.active ? 'active' : mode);\n        if (reset) {\n          properties.options.radius = 0;\n        }\n      }\n      me.updateElement(point, i, properties, mode);\n    }\n    me.updateSharedOptions(sharedOptions, mode, firstOpts);\n  }\n  resolveDataElementOptions(index, mode) {\n    const parsed = this.getParsed(index);\n    let values = super.resolveDataElementOptions(index, mode);\n    if (values.$shared) {\n      values = Object.assign({}, values, {$shared: false});\n    }\n    const radius = values.radius;\n    if (mode !== 'active') {\n      values.radius = 0;\n    }\n    values.radius += (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(parsed && parsed._custom, radius);\n    return values;\n  }\n}\nBubbleController.id = 'bubble';\nBubbleController.defaults = {\n  datasetElementType: false,\n  dataElementType: 'point',\n  animations: {\n    numbers: {\n      type: 'number',\n      properties: ['x', 'y', 'borderWidth', 'radius']\n    }\n  }\n};\nBubbleController.overrides = {\n  scales: {\n    x: {\n      type: 'linear'\n    },\n    y: {\n      type: 'linear'\n    }\n  },\n  plugins: {\n    tooltip: {\n      callbacks: {\n        title() {\n          return '';\n        }\n      }\n    }\n  }\n};\n\nfunction getRatioAndOffset(rotation, circumference, cutout) {\n  let ratioX = 1;\n  let ratioY = 1;\n  let offsetX = 0;\n  let offsetY = 0;\n  if (circumference < _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T) {\n    const startAngle = rotation;\n    const endAngle = startAngle + circumference;\n    const startX = Math.cos(startAngle);\n    const startY = Math.sin(startAngle);\n    const endX = Math.cos(endAngle);\n    const endY = Math.sin(endAngle);\n    const calcMax = (angle, a, b) => (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.o)(angle, startAngle, endAngle, true) ? 1 : Math.max(a, a * cutout, b, b * cutout);\n    const calcMin = (angle, a, b) => (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.o)(angle, startAngle, endAngle, true) ? -1 : Math.min(a, a * cutout, b, b * cutout);\n    const maxX = calcMax(0, startX, endX);\n    const maxY = calcMax(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, startY, endY);\n    const minX = calcMin(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P, startX, endX);\n    const minY = calcMin(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, startY, endY);\n    ratioX = (maxX - minX) / 2;\n    ratioY = (maxY - minY) / 2;\n    offsetX = -(maxX + minX) / 2;\n    offsetY = -(maxY + minY) / 2;\n  }\n  return {ratioX, ratioY, offsetX, offsetY};\n}\nclass DoughnutController extends DatasetController {\n  constructor(chart, datasetIndex) {\n    super(chart, datasetIndex);\n    this.enableOptionSharing = true;\n    this.innerRadius = undefined;\n    this.outerRadius = undefined;\n    this.offsetX = undefined;\n    this.offsetY = undefined;\n  }\n  linkScales() {}\n  parse(start, count) {\n    const data = this.getDataset().data;\n    const meta = this._cachedMeta;\n    let i, ilen;\n    for (i = start, ilen = start + count; i < ilen; ++i) {\n      meta._parsed[i] = +data[i];\n    }\n  }\n  _getRotation() {\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.options.rotation - 90);\n  }\n  _getCircumference() {\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.options.circumference);\n  }\n  _getRotationExtents() {\n    let min = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T;\n    let max = -_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T;\n    const me = this;\n    for (let i = 0; i < me.chart.data.datasets.length; ++i) {\n      if (me.chart.isDatasetVisible(i)) {\n        const controller = me.chart.getDatasetMeta(i).controller;\n        const rotation = controller._getRotation();\n        const circumference = controller._getCircumference();\n        min = Math.min(min, rotation);\n        max = Math.max(max, rotation + circumference);\n      }\n    }\n    return {\n      rotation: min,\n      circumference: max - min,\n    };\n  }\n  update(mode) {\n    const me = this;\n    const chart = me.chart;\n    const {chartArea} = chart;\n    const meta = me._cachedMeta;\n    const arcs = meta.data;\n    const spacing = me.getMaxBorderWidth() + me.getMaxOffset(arcs) + me.options.spacing;\n    const maxSize = Math.max((Math.min(chartArea.width, chartArea.height) - spacing) / 2, 0);\n    const cutout = Math.min((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(me.options.cutout, maxSize), 1);\n    const chartWeight = me._getRingWeight(me.index);\n    const {circumference, rotation} = me._getRotationExtents();\n    const {ratioX, ratioY, offsetX, offsetY} = getRatioAndOffset(rotation, circumference, cutout);\n    const maxWidth = (chartArea.width - spacing) / ratioX;\n    const maxHeight = (chartArea.height - spacing) / ratioY;\n    const maxRadius = Math.max(Math.min(maxWidth, maxHeight) / 2, 0);\n    const outerRadius = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.m)(me.options.radius, maxRadius);\n    const innerRadius = Math.max(outerRadius * cutout, 0);\n    const radiusLength = (outerRadius - innerRadius) / me._getVisibleDatasetWeightTotal();\n    me.offsetX = offsetX * outerRadius;\n    me.offsetY = offsetY * outerRadius;\n    meta.total = me.calculateTotal();\n    me.outerRadius = outerRadius - radiusLength * me._getRingWeightOffset(me.index);\n    me.innerRadius = Math.max(me.outerRadius - radiusLength * chartWeight, 0);\n    me.updateElements(arcs, 0, arcs.length, mode);\n  }\n  _circumference(i, reset) {\n    const me = this;\n    const opts = me.options;\n    const meta = me._cachedMeta;\n    const circumference = me._getCircumference();\n    if ((reset && opts.animation.animateRotate) || !this.chart.getDataVisibility(i) || meta._parsed[i] === null || meta.data[i].hidden) {\n      return 0;\n    }\n    return me.calculateCircumference(meta._parsed[i] * circumference / _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T);\n  }\n  updateElements(arcs, start, count, mode) {\n    const me = this;\n    const reset = mode === 'reset';\n    const chart = me.chart;\n    const chartArea = chart.chartArea;\n    const opts = chart.options;\n    const animationOpts = opts.animation;\n    const centerX = (chartArea.left + chartArea.right) / 2;\n    const centerY = (chartArea.top + chartArea.bottom) / 2;\n    const animateScale = reset && animationOpts.animateScale;\n    const innerRadius = animateScale ? 0 : me.innerRadius;\n    const outerRadius = animateScale ? 0 : me.outerRadius;\n    const firstOpts = me.resolveDataElementOptions(start, mode);\n    const sharedOptions = me.getSharedOptions(firstOpts);\n    const includeOptions = me.includeOptions(mode, sharedOptions);\n    let startAngle = me._getRotation();\n    let i;\n    for (i = 0; i < start; ++i) {\n      startAngle += me._circumference(i, reset);\n    }\n    for (i = start; i < start + count; ++i) {\n      const circumference = me._circumference(i, reset);\n      const arc = arcs[i];\n      const properties = {\n        x: centerX + me.offsetX,\n        y: centerY + me.offsetY,\n        startAngle,\n        endAngle: startAngle + circumference,\n        circumference,\n        outerRadius,\n        innerRadius\n      };\n      if (includeOptions) {\n        properties.options = sharedOptions || me.resolveDataElementOptions(i, arc.active ? 'active' : mode);\n      }\n      startAngle += circumference;\n      me.updateElement(arc, i, properties, mode);\n    }\n    me.updateSharedOptions(sharedOptions, mode, firstOpts);\n  }\n  calculateTotal() {\n    const meta = this._cachedMeta;\n    const metaData = meta.data;\n    let total = 0;\n    let i;\n    for (i = 0; i < metaData.length; i++) {\n      const value = meta._parsed[i];\n      if (value !== null && !isNaN(value) && this.chart.getDataVisibility(i) && !metaData[i].hidden) {\n        total += Math.abs(value);\n      }\n    }\n    return total;\n  }\n  calculateCircumference(value) {\n    const total = this._cachedMeta.total;\n    if (total > 0 && !isNaN(value)) {\n      return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T * (Math.abs(value) / total);\n    }\n    return 0;\n  }\n  getLabelAndValue(index) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const chart = me.chart;\n    const labels = chart.data.labels || [];\n    const value = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.n)(meta._parsed[index], chart.options.locale);\n    return {\n      label: labels[index] || '',\n      value,\n    };\n  }\n  getMaxBorderWidth(arcs) {\n    const me = this;\n    let max = 0;\n    const chart = me.chart;\n    let i, ilen, meta, controller, options;\n    if (!arcs) {\n      for (i = 0, ilen = chart.data.datasets.length; i < ilen; ++i) {\n        if (chart.isDatasetVisible(i)) {\n          meta = chart.getDatasetMeta(i);\n          arcs = meta.data;\n          controller = meta.controller;\n          if (controller !== me) {\n            controller.configure();\n          }\n          break;\n        }\n      }\n    }\n    if (!arcs) {\n      return 0;\n    }\n    for (i = 0, ilen = arcs.length; i < ilen; ++i) {\n      options = controller.resolveDataElementOptions(i);\n      if (options.borderAlign !== 'inner') {\n        max = Math.max(max, options.borderWidth || 0, options.hoverBorderWidth || 0);\n      }\n    }\n    return max;\n  }\n  getMaxOffset(arcs) {\n    let max = 0;\n    for (let i = 0, ilen = arcs.length; i < ilen; ++i) {\n      const options = this.resolveDataElementOptions(i);\n      max = Math.max(max, options.offset || 0, options.hoverOffset || 0);\n    }\n    return max;\n  }\n  _getRingWeightOffset(datasetIndex) {\n    let ringWeightOffset = 0;\n    for (let i = 0; i < datasetIndex; ++i) {\n      if (this.chart.isDatasetVisible(i)) {\n        ringWeightOffset += this._getRingWeight(i);\n      }\n    }\n    return ringWeightOffset;\n  }\n  _getRingWeight(datasetIndex) {\n    return Math.max((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(this.chart.data.datasets[datasetIndex].weight, 1), 0);\n  }\n  _getVisibleDatasetWeightTotal() {\n    return this._getRingWeightOffset(this.chart.data.datasets.length) || 1;\n  }\n}\nDoughnutController.id = 'doughnut';\nDoughnutController.defaults = {\n  datasetElementType: false,\n  dataElementType: 'arc',\n  animation: {\n    animateRotate: true,\n    animateScale: false\n  },\n  animations: {\n    numbers: {\n      type: 'number',\n      properties: ['circumference', 'endAngle', 'innerRadius', 'outerRadius', 'startAngle', 'x', 'y', 'offset', 'borderWidth', 'spacing']\n    },\n  },\n  cutout: '50%',\n  rotation: 0,\n  circumference: 360,\n  radius: '100%',\n  spacing: 0,\n  indexAxis: 'r',\n};\nDoughnutController.descriptors = {\n  _scriptable: (name) => name !== 'spacing',\n  _indexable: (name) => name !== 'spacing',\n};\nDoughnutController.overrides = {\n  aspectRatio: 1,\n  plugins: {\n    legend: {\n      labels: {\n        generateLabels(chart) {\n          const data = chart.data;\n          if (data.labels.length && data.datasets.length) {\n            const {labels: {pointStyle}} = chart.legend.options;\n            return data.labels.map((label, i) => {\n              const meta = chart.getDatasetMeta(0);\n              const style = meta.controller.getStyle(i);\n              return {\n                text: label,\n                fillStyle: style.backgroundColor,\n                strokeStyle: style.borderColor,\n                lineWidth: style.borderWidth,\n                pointStyle: pointStyle,\n                hidden: !chart.getDataVisibility(i),\n                index: i\n              };\n            });\n          }\n          return [];\n        }\n      },\n      onClick(e, legendItem, legend) {\n        legend.chart.toggleDataVisibility(legendItem.index);\n        legend.chart.update();\n      }\n    },\n    tooltip: {\n      callbacks: {\n        title() {\n          return '';\n        },\n        label(tooltipItem) {\n          let dataLabel = tooltipItem.label;\n          const value = ': ' + tooltipItem.formattedValue;\n          if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(dataLabel)) {\n            dataLabel = dataLabel.slice();\n            dataLabel[0] += value;\n          } else {\n            dataLabel += value;\n          }\n          return dataLabel;\n        }\n      }\n    }\n  }\n};\n\nclass LineController extends DatasetController {\n  initialize() {\n    this.enableOptionSharing = true;\n    super.initialize();\n  }\n  update(mode) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const {dataset: line, data: points = [], _dataset} = meta;\n    const animationsDisabled = me.chart._animationsDisabled;\n    let {start, count} = getStartAndCountOfVisiblePoints(meta, points, animationsDisabled);\n    me._drawStart = start;\n    me._drawCount = count;\n    if (scaleRangesChanged(meta)) {\n      start = 0;\n      count = points.length;\n    }\n    line._datasetIndex = me.index;\n    line._decimated = !!_dataset._decimated;\n    line.points = points;\n    const options = me.resolveDatasetElementOptions(mode);\n    if (!me.options.showLine) {\n      options.borderWidth = 0;\n    }\n    options.segment = me.options.segment;\n    me.updateElement(line, undefined, {\n      animated: !animationsDisabled,\n      options\n    }, mode);\n    me.updateElements(points, start, count, mode);\n  }\n  updateElements(points, start, count, mode) {\n    const me = this;\n    const reset = mode === 'reset';\n    const {iScale, vScale, _stacked} = me._cachedMeta;\n    const firstOpts = me.resolveDataElementOptions(start, mode);\n    const sharedOptions = me.getSharedOptions(firstOpts);\n    const includeOptions = me.includeOptions(mode, sharedOptions);\n    const iAxis = iScale.axis;\n    const vAxis = vScale.axis;\n    const spanGaps = me.options.spanGaps;\n    const maxGapLength = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(spanGaps) ? spanGaps : Number.POSITIVE_INFINITY;\n    const directUpdate = me.chart._animationsDisabled || reset || mode === 'none';\n    let prevParsed = start > 0 && me.getParsed(start - 1);\n    for (let i = start; i < start + count; ++i) {\n      const point = points[i];\n      const parsed = me.getParsed(i);\n      const properties = directUpdate ? point : {};\n      const nullData = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(parsed[vAxis]);\n      const iPixel = properties[iAxis] = iScale.getPixelForValue(parsed[iAxis], i);\n      const vPixel = properties[vAxis] = reset || nullData ? vScale.getBasePixel() : vScale.getPixelForValue(_stacked ? me.applyStack(vScale, parsed, _stacked) : parsed[vAxis], i);\n      properties.skip = isNaN(iPixel) || isNaN(vPixel) || nullData;\n      properties.stop = i > 0 && (parsed[iAxis] - prevParsed[iAxis]) > maxGapLength;\n      properties.parsed = parsed;\n      if (includeOptions) {\n        properties.options = sharedOptions || me.resolveDataElementOptions(i, point.active ? 'active' : mode);\n      }\n      if (!directUpdate) {\n        me.updateElement(point, i, properties, mode);\n      }\n      prevParsed = parsed;\n    }\n    me.updateSharedOptions(sharedOptions, mode, firstOpts);\n  }\n  getMaxOverflow() {\n    const me = this;\n    const meta = me._cachedMeta;\n    const dataset = meta.dataset;\n    const border = dataset.options && dataset.options.borderWidth || 0;\n    const data = meta.data || [];\n    if (!data.length) {\n      return border;\n    }\n    const firstPoint = data[0].size(me.resolveDataElementOptions(0));\n    const lastPoint = data[data.length - 1].size(me.resolveDataElementOptions(data.length - 1));\n    return Math.max(border, firstPoint, lastPoint) / 2;\n  }\n  draw() {\n    const meta = this._cachedMeta;\n    meta.dataset.updateControlPoints(this.chart.chartArea, meta.iScale.axis);\n    super.draw();\n  }\n}\nLineController.id = 'line';\nLineController.defaults = {\n  datasetElementType: 'line',\n  dataElementType: 'point',\n  showLine: true,\n  spanGaps: false,\n};\nLineController.overrides = {\n  scales: {\n    _index_: {\n      type: 'category',\n    },\n    _value_: {\n      type: 'linear',\n    },\n  }\n};\nfunction getStartAndCountOfVisiblePoints(meta, points, animationsDisabled) {\n  const pointCount = points.length;\n  let start = 0;\n  let count = pointCount;\n  if (meta._sorted) {\n    const {iScale, _parsed} = meta;\n    const axis = iScale.axis;\n    const {min, max, minDefined, maxDefined} = iScale.getUserBounds();\n    if (minDefined) {\n      start = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(Math.min(\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(_parsed, iScale.axis, min).lo,\n        animationsDisabled ? pointCount : (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(points, axis, iScale.getPixelForValue(min)).lo),\n      0, pointCount - 1);\n    }\n    if (maxDefined) {\n      count = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(Math.max(\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(_parsed, iScale.axis, max).hi + 1,\n        animationsDisabled ? 0 : (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(points, axis, iScale.getPixelForValue(max)).hi + 1),\n      start, pointCount) - start;\n    } else {\n      count = pointCount - start;\n    }\n  }\n  return {start, count};\n}\nfunction scaleRangesChanged(meta) {\n  const {xScale, yScale, _scaleRanges} = meta;\n  const newRanges = {\n    xmin: xScale.min,\n    xmax: xScale.max,\n    ymin: yScale.min,\n    ymax: yScale.max\n  };\n  if (!_scaleRanges) {\n    meta._scaleRanges = newRanges;\n    return true;\n  }\n  const changed = _scaleRanges.xmin !== xScale.min\n\t\t|| _scaleRanges.xmax !== xScale.max\n\t\t|| _scaleRanges.ymin !== yScale.min\n\t\t|| _scaleRanges.ymax !== yScale.max;\n  Object.assign(_scaleRanges, newRanges);\n  return changed;\n}\n\nclass PolarAreaController extends DatasetController {\n  constructor(chart, datasetIndex) {\n    super(chart, datasetIndex);\n    this.innerRadius = undefined;\n    this.outerRadius = undefined;\n  }\n  getLabelAndValue(index) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const chart = me.chart;\n    const labels = chart.data.labels || [];\n    const value = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.n)(meta._parsed[index].r, chart.options.locale);\n    return {\n      label: labels[index] || '',\n      value,\n    };\n  }\n  update(mode) {\n    const arcs = this._cachedMeta.data;\n    this._updateRadius();\n    this.updateElements(arcs, 0, arcs.length, mode);\n  }\n  _updateRadius() {\n    const me = this;\n    const chart = me.chart;\n    const chartArea = chart.chartArea;\n    const opts = chart.options;\n    const minSize = Math.min(chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);\n    const outerRadius = Math.max(minSize / 2, 0);\n    const innerRadius = Math.max(opts.cutoutPercentage ? (outerRadius / 100) * (opts.cutoutPercentage) : 1, 0);\n    const radiusLength = (outerRadius - innerRadius) / chart.getVisibleDatasetCount();\n    me.outerRadius = outerRadius - (radiusLength * me.index);\n    me.innerRadius = me.outerRadius - radiusLength;\n  }\n  updateElements(arcs, start, count, mode) {\n    const me = this;\n    const reset = mode === 'reset';\n    const chart = me.chart;\n    const dataset = me.getDataset();\n    const opts = chart.options;\n    const animationOpts = opts.animation;\n    const scale = me._cachedMeta.rScale;\n    const centerX = scale.xCenter;\n    const centerY = scale.yCenter;\n    const datasetStartAngle = scale.getIndexAngle(0) - 0.5 * _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P;\n    let angle = datasetStartAngle;\n    let i;\n    const defaultAngle = 360 / me.countVisibleElements();\n    for (i = 0; i < start; ++i) {\n      angle += me._computeAngle(i, mode, defaultAngle);\n    }\n    for (i = start; i < start + count; i++) {\n      const arc = arcs[i];\n      let startAngle = angle;\n      let endAngle = angle + me._computeAngle(i, mode, defaultAngle);\n      let outerRadius = chart.getDataVisibility(i) ? scale.getDistanceFromCenterForValue(dataset.data[i]) : 0;\n      angle = endAngle;\n      if (reset) {\n        if (animationOpts.animateScale) {\n          outerRadius = 0;\n        }\n        if (animationOpts.animateRotate) {\n          startAngle = endAngle = datasetStartAngle;\n        }\n      }\n      const properties = {\n        x: centerX,\n        y: centerY,\n        innerRadius: 0,\n        outerRadius,\n        startAngle,\n        endAngle,\n        options: me.resolveDataElementOptions(i, arc.active ? 'active' : mode)\n      };\n      me.updateElement(arc, i, properties, mode);\n    }\n  }\n  countVisibleElements() {\n    const dataset = this.getDataset();\n    const meta = this._cachedMeta;\n    let count = 0;\n    meta.data.forEach((element, index) => {\n      if (!isNaN(dataset.data[index]) && this.chart.getDataVisibility(index)) {\n        count++;\n      }\n    });\n    return count;\n  }\n  _computeAngle(index, mode, defaultAngle) {\n    return this.chart.getDataVisibility(index)\n      ? (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.resolveDataElementOptions(index, mode).angle || defaultAngle)\n      : 0;\n  }\n}\nPolarAreaController.id = 'polarArea';\nPolarAreaController.defaults = {\n  dataElementType: 'arc',\n  animation: {\n    animateRotate: true,\n    animateScale: true\n  },\n  animations: {\n    numbers: {\n      type: 'number',\n      properties: ['x', 'y', 'startAngle', 'endAngle', 'innerRadius', 'outerRadius']\n    },\n  },\n  indexAxis: 'r',\n  startAngle: 0,\n};\nPolarAreaController.overrides = {\n  aspectRatio: 1,\n  plugins: {\n    legend: {\n      labels: {\n        generateLabels(chart) {\n          const data = chart.data;\n          if (data.labels.length && data.datasets.length) {\n            const {labels: {pointStyle}} = chart.legend.options;\n            return data.labels.map((label, i) => {\n              const meta = chart.getDatasetMeta(0);\n              const style = meta.controller.getStyle(i);\n              return {\n                text: label,\n                fillStyle: style.backgroundColor,\n                strokeStyle: style.borderColor,\n                lineWidth: style.borderWidth,\n                pointStyle: pointStyle,\n                hidden: !chart.getDataVisibility(i),\n                index: i\n              };\n            });\n          }\n          return [];\n        }\n      },\n      onClick(e, legendItem, legend) {\n        legend.chart.toggleDataVisibility(legendItem.index);\n        legend.chart.update();\n      }\n    },\n    tooltip: {\n      callbacks: {\n        title() {\n          return '';\n        },\n        label(context) {\n          return context.chart.data.labels[context.dataIndex] + ': ' + context.formattedValue;\n        }\n      }\n    }\n  },\n  scales: {\n    r: {\n      type: 'radialLinear',\n      angleLines: {\n        display: false\n      },\n      beginAtZero: true,\n      grid: {\n        circular: true\n      },\n      pointLabels: {\n        display: false\n      },\n      startAngle: 0\n    }\n  }\n};\n\nclass PieController extends DoughnutController {\n}\nPieController.id = 'pie';\nPieController.defaults = {\n  cutout: 0,\n  rotation: 0,\n  circumference: 360,\n  radius: '100%'\n};\n\nclass RadarController extends DatasetController {\n  getLabelAndValue(index) {\n    const me = this;\n    const vScale = me._cachedMeta.vScale;\n    const parsed = me.getParsed(index);\n    return {\n      label: vScale.getLabels()[index],\n      value: '' + vScale.getLabelForValue(parsed[vScale.axis])\n    };\n  }\n  update(mode) {\n    const me = this;\n    const meta = me._cachedMeta;\n    const line = meta.dataset;\n    const points = meta.data || [];\n    const labels = meta.iScale.getLabels();\n    line.points = points;\n    if (mode !== 'resize') {\n      const options = me.resolveDatasetElementOptions(mode);\n      if (!me.options.showLine) {\n        options.borderWidth = 0;\n      }\n      const properties = {\n        _loop: true,\n        _fullLoop: labels.length === points.length,\n        options\n      };\n      me.updateElement(line, undefined, properties, mode);\n    }\n    me.updateElements(points, 0, points.length, mode);\n  }\n  updateElements(points, start, count, mode) {\n    const me = this;\n    const dataset = me.getDataset();\n    const scale = me._cachedMeta.rScale;\n    const reset = mode === 'reset';\n    for (let i = start; i < start + count; i++) {\n      const point = points[i];\n      const options = me.resolveDataElementOptions(i, point.active ? 'active' : mode);\n      const pointPosition = scale.getPointPositionForValue(i, dataset.data[i]);\n      const x = reset ? scale.xCenter : pointPosition.x;\n      const y = reset ? scale.yCenter : pointPosition.y;\n      const properties = {\n        x,\n        y,\n        angle: pointPosition.angle,\n        skip: isNaN(x) || isNaN(y),\n        options\n      };\n      me.updateElement(point, i, properties, mode);\n    }\n  }\n}\nRadarController.id = 'radar';\nRadarController.defaults = {\n  datasetElementType: 'line',\n  dataElementType: 'point',\n  indexAxis: 'r',\n  showLine: true,\n  elements: {\n    line: {\n      fill: 'start'\n    }\n  },\n};\nRadarController.overrides = {\n  aspectRatio: 1,\n  scales: {\n    r: {\n      type: 'radialLinear',\n    }\n  }\n};\n\nclass ScatterController extends LineController {\n}\nScatterController.id = 'scatter';\nScatterController.defaults = {\n  showLine: false,\n  fill: false\n};\nScatterController.overrides = {\n  interaction: {\n    mode: 'point'\n  },\n  plugins: {\n    tooltip: {\n      callbacks: {\n        title() {\n          return '';\n        },\n        label(item) {\n          return '(' + item.label + ', ' + item.formattedValue + ')';\n        }\n      }\n    }\n  },\n  scales: {\n    x: {\n      type: 'linear'\n    },\n    y: {\n      type: 'linear'\n    }\n  }\n};\n\nvar controllers = /*#__PURE__*/Object.freeze({\n__proto__: null,\nBarController: BarController,\nBubbleController: BubbleController,\nDoughnutController: DoughnutController,\nLineController: LineController,\nPolarAreaController: PolarAreaController,\nPieController: PieController,\nRadarController: RadarController,\nScatterController: ScatterController\n});\n\nfunction abstract() {\n  throw new Error('This method is not implemented: Check that a complete date adapter is provided.');\n}\nclass DateAdapter {\n  constructor(options) {\n    this.options = options || {};\n  }\n  formats() {\n    return abstract();\n  }\n  parse(value, format) {\n    return abstract();\n  }\n  format(timestamp, format) {\n    return abstract();\n  }\n  add(timestamp, amount, unit) {\n    return abstract();\n  }\n  diff(a, b, unit) {\n    return abstract();\n  }\n  startOf(timestamp, unit, weekday) {\n    return abstract();\n  }\n  endOf(timestamp, unit) {\n    return abstract();\n  }\n}\nDateAdapter.override = function(members) {\n  Object.assign(DateAdapter.prototype, members);\n};\nvar adapters = {\n  _date: DateAdapter\n};\n\nfunction getRelativePosition(e, chart) {\n  if ('native' in e) {\n    return {\n      x: e.x,\n      y: e.y\n    };\n  }\n  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.x)(e, chart);\n}\nfunction evaluateAllVisibleItems(chart, handler) {\n  const metasets = chart.getSortedVisibleDatasetMetas();\n  let index, data, element;\n  for (let i = 0, ilen = metasets.length; i < ilen; ++i) {\n    ({index, data} = metasets[i]);\n    for (let j = 0, jlen = data.length; j < jlen; ++j) {\n      element = data[j];\n      if (!element.skip) {\n        handler(element, index, j);\n      }\n    }\n  }\n}\nfunction binarySearch(metaset, axis, value, intersect) {\n  const {controller, data, _sorted} = metaset;\n  const iScale = controller._cachedMeta.iScale;\n  if (iScale && axis === iScale.axis && _sorted && data.length) {\n    const lookupMethod = iScale._reversePixels ? _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.z : _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w;\n    if (!intersect) {\n      return lookupMethod(data, axis, value);\n    } else if (controller._sharedOptions) {\n      const el = data[0];\n      const range = typeof el.getRange === 'function' && el.getRange(axis);\n      if (range) {\n        const start = lookupMethod(data, axis, value - range);\n        const end = lookupMethod(data, axis, value + range);\n        return {lo: start.lo, hi: end.hi};\n      }\n    }\n  }\n  return {lo: 0, hi: data.length - 1};\n}\nfunction optimizedEvaluateItems(chart, axis, position, handler, intersect) {\n  const metasets = chart.getSortedVisibleDatasetMetas();\n  const value = position[axis];\n  for (let i = 0, ilen = metasets.length; i < ilen; ++i) {\n    const {index, data} = metasets[i];\n    const {lo, hi} = binarySearch(metasets[i], axis, value, intersect);\n    for (let j = lo; j <= hi; ++j) {\n      const element = data[j];\n      if (!element.skip) {\n        handler(element, index, j);\n      }\n    }\n  }\n}\nfunction getDistanceMetricForAxis(axis) {\n  const useX = axis.indexOf('x') !== -1;\n  const useY = axis.indexOf('y') !== -1;\n  return function(pt1, pt2) {\n    const deltaX = useX ? Math.abs(pt1.x - pt2.x) : 0;\n    const deltaY = useY ? Math.abs(pt1.y - pt2.y) : 0;\n    return Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));\n  };\n}\nfunction getIntersectItems(chart, position, axis, useFinalPosition) {\n  const items = [];\n  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.y)(position, chart.chartArea, chart._minPadding)) {\n    return items;\n  }\n  const evaluationFunc = function(element, datasetIndex, index) {\n    if (element.inRange(position.x, position.y, useFinalPosition)) {\n      items.push({element, datasetIndex, index});\n    }\n  };\n  optimizedEvaluateItems(chart, axis, position, evaluationFunc, true);\n  return items;\n}\nfunction getNearestItems(chart, position, axis, intersect, useFinalPosition) {\n  const distanceMetric = getDistanceMetricForAxis(axis);\n  let minDistance = Number.POSITIVE_INFINITY;\n  let items = [];\n  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.y)(position, chart.chartArea, chart._minPadding)) {\n    return items;\n  }\n  const evaluationFunc = function(element, datasetIndex, index) {\n    if (intersect && !element.inRange(position.x, position.y, useFinalPosition)) {\n      return;\n    }\n    const center = element.getCenterPoint(useFinalPosition);\n    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.y)(center, chart.chartArea, chart._minPadding) && !element.inRange(position.x, position.y, useFinalPosition)) {\n      return;\n    }\n    const distance = distanceMetric(position, center);\n    if (distance < minDistance) {\n      items = [{element, datasetIndex, index}];\n      minDistance = distance;\n    } else if (distance === minDistance) {\n      items.push({element, datasetIndex, index});\n    }\n  };\n  optimizedEvaluateItems(chart, axis, position, evaluationFunc);\n  return items;\n}\nfunction getAxisItems(chart, e, options, useFinalPosition) {\n  const position = getRelativePosition(e, chart);\n  const items = [];\n  const axis = options.axis;\n  const rangeMethod = axis === 'x' ? 'inXRange' : 'inYRange';\n  let intersectsItem = false;\n  evaluateAllVisibleItems(chart, (element, datasetIndex, index) => {\n    if (element[rangeMethod](position[axis], useFinalPosition)) {\n      items.push({element, datasetIndex, index});\n    }\n    if (element.inRange(position.x, position.y, useFinalPosition)) {\n      intersectsItem = true;\n    }\n  });\n  if (options.intersect && !intersectsItem) {\n    return [];\n  }\n  return items;\n}\nvar Interaction = {\n  modes: {\n    index(chart, e, options, useFinalPosition) {\n      const position = getRelativePosition(e, chart);\n      const axis = options.axis || 'x';\n      const items = options.intersect\n        ? getIntersectItems(chart, position, axis, useFinalPosition)\n        : getNearestItems(chart, position, axis, false, useFinalPosition);\n      const elements = [];\n      if (!items.length) {\n        return [];\n      }\n      chart.getSortedVisibleDatasetMetas().forEach((meta) => {\n        const index = items[0].index;\n        const element = meta.data[index];\n        if (element && !element.skip) {\n          elements.push({element, datasetIndex: meta.index, index});\n        }\n      });\n      return elements;\n    },\n    dataset(chart, e, options, useFinalPosition) {\n      const position = getRelativePosition(e, chart);\n      const axis = options.axis || 'xy';\n      let items = options.intersect\n        ? getIntersectItems(chart, position, axis, useFinalPosition) :\n        getNearestItems(chart, position, axis, false, useFinalPosition);\n      if (items.length > 0) {\n        const datasetIndex = items[0].datasetIndex;\n        const data = chart.getDatasetMeta(datasetIndex).data;\n        items = [];\n        for (let i = 0; i < data.length; ++i) {\n          items.push({element: data[i], datasetIndex, index: i});\n        }\n      }\n      return items;\n    },\n    point(chart, e, options, useFinalPosition) {\n      const position = getRelativePosition(e, chart);\n      const axis = options.axis || 'xy';\n      return getIntersectItems(chart, position, axis, useFinalPosition);\n    },\n    nearest(chart, e, options, useFinalPosition) {\n      const position = getRelativePosition(e, chart);\n      const axis = options.axis || 'xy';\n      return getNearestItems(chart, position, axis, options.intersect, useFinalPosition);\n    },\n    x(chart, e, options, useFinalPosition) {\n      options.axis = 'x';\n      return getAxisItems(chart, e, options, useFinalPosition);\n    },\n    y(chart, e, options, useFinalPosition) {\n      options.axis = 'y';\n      return getAxisItems(chart, e, options, useFinalPosition);\n    }\n  }\n};\n\nconst STATIC_POSITIONS = ['left', 'top', 'right', 'bottom'];\nfunction filterByPosition(array, position) {\n  return array.filter(v => v.pos === position);\n}\nfunction filterDynamicPositionByAxis(array, axis) {\n  return array.filter(v => STATIC_POSITIONS.indexOf(v.pos) === -1 && v.box.axis === axis);\n}\nfunction sortByWeight(array, reverse) {\n  return array.sort((a, b) => {\n    const v0 = reverse ? b : a;\n    const v1 = reverse ? a : b;\n    return v0.weight === v1.weight ?\n      v0.index - v1.index :\n      v0.weight - v1.weight;\n  });\n}\nfunction wrapBoxes(boxes) {\n  const layoutBoxes = [];\n  let i, ilen, box, pos, stack, stackWeight;\n  for (i = 0, ilen = (boxes || []).length; i < ilen; ++i) {\n    box = boxes[i];\n    ({position: pos, options: {stack, stackWeight = 1}} = box);\n    layoutBoxes.push({\n      index: i,\n      box,\n      pos,\n      horizontal: box.isHorizontal(),\n      weight: box.weight,\n      stack: stack && (pos + stack),\n      stackWeight\n    });\n  }\n  return layoutBoxes;\n}\nfunction buildStacks(layouts) {\n  const stacks = {};\n  for (const wrap of layouts) {\n    const {stack, pos, stackWeight} = wrap;\n    if (!stack || !STATIC_POSITIONS.includes(pos)) {\n      continue;\n    }\n    const _stack = stacks[stack] || (stacks[stack] = {count: 0, placed: 0, weight: 0, size: 0});\n    _stack.count++;\n    _stack.weight += stackWeight;\n  }\n  return stacks;\n}\nfunction setLayoutDims(layouts, params) {\n  const stacks = buildStacks(layouts);\n  const {vBoxMaxWidth, hBoxMaxHeight} = params;\n  let i, ilen, layout;\n  for (i = 0, ilen = layouts.length; i < ilen; ++i) {\n    layout = layouts[i];\n    const {fullSize} = layout.box;\n    const stack = stacks[layout.stack];\n    const factor = stack && layout.stackWeight / stack.weight;\n    if (layout.horizontal) {\n      layout.width = factor ? factor * vBoxMaxWidth : fullSize && params.availableWidth;\n      layout.height = hBoxMaxHeight;\n    } else {\n      layout.width = vBoxMaxWidth;\n      layout.height = factor ? factor * hBoxMaxHeight : fullSize && params.availableHeight;\n    }\n  }\n  return stacks;\n}\nfunction buildLayoutBoxes(boxes) {\n  const layoutBoxes = wrapBoxes(boxes);\n  const fullSize = sortByWeight(layoutBoxes.filter(wrap => wrap.box.fullSize), true);\n  const left = sortByWeight(filterByPosition(layoutBoxes, 'left'), true);\n  const right = sortByWeight(filterByPosition(layoutBoxes, 'right'));\n  const top = sortByWeight(filterByPosition(layoutBoxes, 'top'), true);\n  const bottom = sortByWeight(filterByPosition(layoutBoxes, 'bottom'));\n  const centerHorizontal = filterDynamicPositionByAxis(layoutBoxes, 'x');\n  const centerVertical = filterDynamicPositionByAxis(layoutBoxes, 'y');\n  return {\n    fullSize,\n    leftAndTop: left.concat(top),\n    rightAndBottom: right.concat(centerVertical).concat(bottom).concat(centerHorizontal),\n    chartArea: filterByPosition(layoutBoxes, 'chartArea'),\n    vertical: left.concat(right).concat(centerVertical),\n    horizontal: top.concat(bottom).concat(centerHorizontal)\n  };\n}\nfunction getCombinedMax(maxPadding, chartArea, a, b) {\n  return Math.max(maxPadding[a], chartArea[a]) + Math.max(maxPadding[b], chartArea[b]);\n}\nfunction updateMaxPadding(maxPadding, boxPadding) {\n  maxPadding.top = Math.max(maxPadding.top, boxPadding.top);\n  maxPadding.left = Math.max(maxPadding.left, boxPadding.left);\n  maxPadding.bottom = Math.max(maxPadding.bottom, boxPadding.bottom);\n  maxPadding.right = Math.max(maxPadding.right, boxPadding.right);\n}\nfunction updateDims(chartArea, params, layout, stacks) {\n  const {pos, box} = layout;\n  const maxPadding = chartArea.maxPadding;\n  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(pos)) {\n    if (layout.size) {\n      chartArea[pos] -= layout.size;\n    }\n    const stack = stacks[layout.stack] || {size: 0, count: 1};\n    stack.size = Math.max(stack.size, layout.horizontal ? box.height : box.width);\n    layout.size = stack.size / stack.count;\n    chartArea[pos] += layout.size;\n  }\n  if (box.getPadding) {\n    updateMaxPadding(maxPadding, box.getPadding());\n  }\n  const newWidth = Math.max(0, params.outerWidth - getCombinedMax(maxPadding, chartArea, 'left', 'right'));\n  const newHeight = Math.max(0, params.outerHeight - getCombinedMax(maxPadding, chartArea, 'top', 'bottom'));\n  const widthChanged = newWidth !== chartArea.w;\n  const heightChanged = newHeight !== chartArea.h;\n  chartArea.w = newWidth;\n  chartArea.h = newHeight;\n  return layout.horizontal\n    ? {same: widthChanged, other: heightChanged}\n    : {same: heightChanged, other: widthChanged};\n}\nfunction handleMaxPadding(chartArea) {\n  const maxPadding = chartArea.maxPadding;\n  function updatePos(pos) {\n    const change = Math.max(maxPadding[pos] - chartArea[pos], 0);\n    chartArea[pos] += change;\n    return change;\n  }\n  chartArea.y += updatePos('top');\n  chartArea.x += updatePos('left');\n  updatePos('right');\n  updatePos('bottom');\n}\nfunction getMargins(horizontal, chartArea) {\n  const maxPadding = chartArea.maxPadding;\n  function marginForPositions(positions) {\n    const margin = {left: 0, top: 0, right: 0, bottom: 0};\n    positions.forEach((pos) => {\n      margin[pos] = Math.max(chartArea[pos], maxPadding[pos]);\n    });\n    return margin;\n  }\n  return horizontal\n    ? marginForPositions(['left', 'right'])\n    : marginForPositions(['top', 'bottom']);\n}\nfunction fitBoxes(boxes, chartArea, params, stacks) {\n  const refitBoxes = [];\n  let i, ilen, layout, box, refit, changed;\n  for (i = 0, ilen = boxes.length, refit = 0; i < ilen; ++i) {\n    layout = boxes[i];\n    box = layout.box;\n    box.update(\n      layout.width || chartArea.w,\n      layout.height || chartArea.h,\n      getMargins(layout.horizontal, chartArea)\n    );\n    const {same, other} = updateDims(chartArea, params, layout, stacks);\n    refit |= same && refitBoxes.length;\n    changed = changed || other;\n    if (!box.fullSize) {\n      refitBoxes.push(layout);\n    }\n  }\n  return refit && fitBoxes(refitBoxes, chartArea, params, stacks) || changed;\n}\nfunction setBoxDims(box, left, top, width, height) {\n  box.top = top;\n  box.left = left;\n  box.right = left + width;\n  box.bottom = top + height;\n  box.width = width;\n  box.height = height;\n}\nfunction placeBoxes(boxes, chartArea, params, stacks) {\n  const userPadding = params.padding;\n  let {x, y} = chartArea;\n  for (const layout of boxes) {\n    const box = layout.box;\n    const stack = stacks[layout.stack] || {count: 1, placed: 0, weight: 1};\n    const weight = (layout.stackWeight / stack.weight) || 1;\n    if (layout.horizontal) {\n      const width = chartArea.w * weight;\n      const height = stack.size || box.height;\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(stack.start)) {\n        y = stack.start;\n      }\n      if (box.fullSize) {\n        setBoxDims(box, userPadding.left, y, params.outerWidth - userPadding.right - userPadding.left, height);\n      } else {\n        setBoxDims(box, chartArea.left + stack.placed, y, width, height);\n      }\n      stack.start = y;\n      stack.placed += width;\n      y = box.bottom;\n    } else {\n      const height = chartArea.h * weight;\n      const width = stack.size || box.width;\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(stack.start)) {\n        x = stack.start;\n      }\n      if (box.fullSize) {\n        setBoxDims(box, x, userPadding.top, width, params.outerHeight - userPadding.bottom - userPadding.top);\n      } else {\n        setBoxDims(box, x, chartArea.top + stack.placed, width, height);\n      }\n      stack.start = x;\n      stack.placed += height;\n      x = box.right;\n    }\n  }\n  chartArea.x = x;\n  chartArea.y = y;\n}\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.set('layout', {\n  padding: {\n    top: 0,\n    right: 0,\n    bottom: 0,\n    left: 0\n  }\n});\nvar layouts = {\n  addBox(chart, item) {\n    if (!chart.boxes) {\n      chart.boxes = [];\n    }\n    item.fullSize = item.fullSize || false;\n    item.position = item.position || 'top';\n    item.weight = item.weight || 0;\n    item._layers = item._layers || function() {\n      return [{\n        z: 0,\n        draw(chartArea) {\n          item.draw(chartArea);\n        }\n      }];\n    };\n    chart.boxes.push(item);\n  },\n  removeBox(chart, layoutItem) {\n    const index = chart.boxes ? chart.boxes.indexOf(layoutItem) : -1;\n    if (index !== -1) {\n      chart.boxes.splice(index, 1);\n    }\n  },\n  configure(chart, item, options) {\n    item.fullSize = options.fullSize;\n    item.position = options.position;\n    item.weight = options.weight;\n  },\n  update(chart, width, height, minPadding) {\n    if (!chart) {\n      return;\n    }\n    const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(chart.options.layout.padding);\n    const availableWidth = Math.max(width - padding.width, 0);\n    const availableHeight = Math.max(height - padding.height, 0);\n    const boxes = buildLayoutBoxes(chart.boxes);\n    const verticalBoxes = boxes.vertical;\n    const horizontalBoxes = boxes.horizontal;\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(chart.boxes, box => {\n      if (typeof box.beforeLayout === 'function') {\n        box.beforeLayout();\n      }\n    });\n    const visibleVerticalBoxCount = verticalBoxes.reduce((total, wrap) =>\n      wrap.box.options && wrap.box.options.display === false ? total : total + 1, 0) || 1;\n    const params = Object.freeze({\n      outerWidth: width,\n      outerHeight: height,\n      padding,\n      availableWidth,\n      availableHeight,\n      vBoxMaxWidth: availableWidth / 2 / visibleVerticalBoxCount,\n      hBoxMaxHeight: availableHeight / 2\n    });\n    const maxPadding = Object.assign({}, padding);\n    updateMaxPadding(maxPadding, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(minPadding));\n    const chartArea = Object.assign({\n      maxPadding,\n      w: availableWidth,\n      h: availableHeight,\n      x: padding.left,\n      y: padding.top\n    }, padding);\n    const stacks = setLayoutDims(verticalBoxes.concat(horizontalBoxes), params);\n    fitBoxes(boxes.fullSize, chartArea, params, stacks);\n    fitBoxes(verticalBoxes, chartArea, params, stacks);\n    if (fitBoxes(horizontalBoxes, chartArea, params, stacks)) {\n      fitBoxes(verticalBoxes, chartArea, params, stacks);\n    }\n    handleMaxPadding(chartArea);\n    placeBoxes(boxes.leftAndTop, chartArea, params, stacks);\n    chartArea.x += chartArea.w;\n    chartArea.y += chartArea.h;\n    placeBoxes(boxes.rightAndBottom, chartArea, params, stacks);\n    chart.chartArea = {\n      left: chartArea.left,\n      top: chartArea.top,\n      right: chartArea.left + chartArea.w,\n      bottom: chartArea.top + chartArea.h,\n      height: chartArea.h,\n      width: chartArea.w,\n    };\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(boxes.chartArea, (layout) => {\n      const box = layout.box;\n      Object.assign(box, chart.chartArea);\n      box.update(chartArea.w, chartArea.h);\n    });\n  }\n};\n\nclass BasePlatform {\n  acquireContext(canvas, aspectRatio) {}\n  releaseContext(context) {\n    return false;\n  }\n  addEventListener(chart, type, listener) {}\n  removeEventListener(chart, type, listener) {}\n  getDevicePixelRatio() {\n    return 1;\n  }\n  getMaximumSize(element, width, height, aspectRatio) {\n    width = Math.max(0, width || element.width);\n    height = height || element.height;\n    return {\n      width,\n      height: Math.max(0, aspectRatio ? Math.floor(width / aspectRatio) : height)\n    };\n  }\n  isAttached(canvas) {\n    return true;\n  }\n}\n\nclass BasicPlatform extends BasePlatform {\n  acquireContext(item) {\n    return item && item.getContext && item.getContext('2d') || null;\n  }\n}\n\nconst EXPANDO_KEY = '$chartjs';\nconst EVENT_TYPES = {\n  touchstart: 'mousedown',\n  touchmove: 'mousemove',\n  touchend: 'mouseup',\n  pointerenter: 'mouseenter',\n  pointerdown: 'mousedown',\n  pointermove: 'mousemove',\n  pointerup: 'mouseup',\n  pointerleave: 'mouseout',\n  pointerout: 'mouseout'\n};\nconst isNullOrEmpty = value => value === null || value === '';\nfunction initCanvas(canvas, aspectRatio) {\n  const style = canvas.style;\n  const renderHeight = canvas.getAttribute('height');\n  const renderWidth = canvas.getAttribute('width');\n  canvas[EXPANDO_KEY] = {\n    initial: {\n      height: renderHeight,\n      width: renderWidth,\n      style: {\n        display: style.display,\n        height: style.height,\n        width: style.width\n      }\n    }\n  };\n  style.display = style.display || 'block';\n  style.boxSizing = style.boxSizing || 'border-box';\n  if (isNullOrEmpty(renderWidth)) {\n    const displayWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(canvas, 'width');\n    if (displayWidth !== undefined) {\n      canvas.width = displayWidth;\n    }\n  }\n  if (isNullOrEmpty(renderHeight)) {\n    if (canvas.style.height === '') {\n      canvas.height = canvas.width / (aspectRatio || 2);\n    } else {\n      const displayHeight = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(canvas, 'height');\n      if (displayHeight !== undefined) {\n        canvas.height = displayHeight;\n      }\n    }\n  }\n  return canvas;\n}\nconst eventListenerOptions = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.G ? {passive: true} : false;\nfunction addListener(node, type, listener) {\n  node.addEventListener(type, listener, eventListenerOptions);\n}\nfunction removeListener(chart, type, listener) {\n  chart.canvas.removeEventListener(type, listener, eventListenerOptions);\n}\nfunction fromNativeEvent(event, chart) {\n  const type = EVENT_TYPES[event.type] || event.type;\n  const {x, y} = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.x)(event, chart);\n  return {\n    type,\n    chart,\n    native: event,\n    x: x !== undefined ? x : null,\n    y: y !== undefined ? y : null,\n  };\n}\nfunction createAttachObserver(chart, type, listener) {\n  const canvas = chart.canvas;\n  const container = canvas && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.D)(canvas);\n  const element = container || canvas;\n  const observer = new MutationObserver(entries => {\n    const parent = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.D)(element);\n    entries.forEach(entry => {\n      for (let i = 0; i < entry.addedNodes.length; i++) {\n        const added = entry.addedNodes[i];\n        if (added === element || added === parent) {\n          listener(entry.target);\n        }\n      }\n    });\n  });\n  observer.observe(document, {childList: true, subtree: true});\n  return observer;\n}\nfunction createDetachObserver(chart, type, listener) {\n  const canvas = chart.canvas;\n  const container = canvas && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.D)(canvas);\n  if (!container) {\n    return;\n  }\n  const observer = new MutationObserver(entries => {\n    entries.forEach(entry => {\n      for (let i = 0; i < entry.removedNodes.length; i++) {\n        if (entry.removedNodes[i] === canvas) {\n          listener();\n          break;\n        }\n      }\n    });\n  });\n  observer.observe(container, {childList: true});\n  return observer;\n}\nconst drpListeningCharts = new Map();\nlet oldDevicePixelRatio = 0;\nfunction onWindowResize() {\n  const dpr = window.devicePixelRatio;\n  if (dpr === oldDevicePixelRatio) {\n    return;\n  }\n  oldDevicePixelRatio = dpr;\n  drpListeningCharts.forEach((resize, chart) => {\n    if (chart.currentDevicePixelRatio !== dpr) {\n      resize();\n    }\n  });\n}\nfunction listenDevicePixelRatioChanges(chart, resize) {\n  if (!drpListeningCharts.size) {\n    window.addEventListener('resize', onWindowResize);\n  }\n  drpListeningCharts.set(chart, resize);\n}\nfunction unlistenDevicePixelRatioChanges(chart) {\n  drpListeningCharts.delete(chart);\n  if (!drpListeningCharts.size) {\n    window.removeEventListener('resize', onWindowResize);\n  }\n}\nfunction createResizeObserver(chart, type, listener) {\n  const canvas = chart.canvas;\n  const container = canvas && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.D)(canvas);\n  if (!container) {\n    return;\n  }\n  const resize = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)((width, height) => {\n    const w = container.clientWidth;\n    listener(width, height);\n    if (w < container.clientWidth) {\n      listener();\n    }\n  }, window);\n  const observer = new ResizeObserver(entries => {\n    const entry = entries[0];\n    const width = entry.contentRect.width;\n    const height = entry.contentRect.height;\n    if (width === 0 && height === 0) {\n      return;\n    }\n    resize(width, height);\n  });\n  observer.observe(container);\n  listenDevicePixelRatioChanges(chart, resize);\n  return observer;\n}\nfunction releaseObserver(chart, type, observer) {\n  if (observer) {\n    observer.disconnect();\n  }\n  if (type === 'resize') {\n    unlistenDevicePixelRatioChanges(chart);\n  }\n}\nfunction createProxyAndListen(chart, type, listener) {\n  const canvas = chart.canvas;\n  const proxy = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)((event) => {\n    if (chart.ctx !== null) {\n      listener(fromNativeEvent(event, chart));\n    }\n  }, chart, (args) => {\n    const event = args[0];\n    return [event, event.offsetX, event.offsetY];\n  });\n  addListener(canvas, type, proxy);\n  return proxy;\n}\nclass DomPlatform extends BasePlatform {\n  acquireContext(canvas, aspectRatio) {\n    const context = canvas && canvas.getContext && canvas.getContext('2d');\n    if (context && context.canvas === canvas) {\n      initCanvas(canvas, aspectRatio);\n      return context;\n    }\n    return null;\n  }\n  releaseContext(context) {\n    const canvas = context.canvas;\n    if (!canvas[EXPANDO_KEY]) {\n      return false;\n    }\n    const initial = canvas[EXPANDO_KEY].initial;\n    ['height', 'width'].forEach((prop) => {\n      const value = initial[prop];\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(value)) {\n        canvas.removeAttribute(prop);\n      } else {\n        canvas.setAttribute(prop, value);\n      }\n    });\n    const style = initial.style || {};\n    Object.keys(style).forEach((key) => {\n      canvas.style[key] = style[key];\n    });\n    canvas.width = canvas.width;\n    delete canvas[EXPANDO_KEY];\n    return true;\n  }\n  addEventListener(chart, type, listener) {\n    this.removeEventListener(chart, type);\n    const proxies = chart.$proxies || (chart.$proxies = {});\n    const handlers = {\n      attach: createAttachObserver,\n      detach: createDetachObserver,\n      resize: createResizeObserver\n    };\n    const handler = handlers[type] || createProxyAndListen;\n    proxies[type] = handler(chart, type, listener);\n  }\n  removeEventListener(chart, type) {\n    const proxies = chart.$proxies || (chart.$proxies = {});\n    const proxy = proxies[type];\n    if (!proxy) {\n      return;\n    }\n    const handlers = {\n      attach: releaseObserver,\n      detach: releaseObserver,\n      resize: releaseObserver\n    };\n    const handler = handlers[type] || removeListener;\n    handler(chart, type, proxy);\n    proxies[type] = undefined;\n  }\n  getDevicePixelRatio() {\n    return window.devicePixelRatio;\n  }\n  getMaximumSize(canvas, width, height, aspectRatio) {\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.C)(canvas, width, height, aspectRatio);\n  }\n  isAttached(canvas) {\n    const container = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.D)(canvas);\n    return !!(container && container.isConnected);\n  }\n}\n\nfunction _detectPlatform(canvas) {\n  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.I)() || (typeof OffscreenCanvas !== 'undefined' && canvas instanceof OffscreenCanvas)) {\n    return BasicPlatform;\n  }\n  return DomPlatform;\n}\n\nclass Element {\n  constructor() {\n    this.x = undefined;\n    this.y = undefined;\n    this.active = false;\n    this.options = undefined;\n    this.$animations = undefined;\n  }\n  tooltipPosition(useFinalPosition) {\n    const {x, y} = this.getProps(['x', 'y'], useFinalPosition);\n    return {x, y};\n  }\n  hasValue() {\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(this.x) && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(this.y);\n  }\n  getProps(props, final) {\n    const me = this;\n    const anims = this.$animations;\n    if (!final || !anims) {\n      return me;\n    }\n    const ret = {};\n    props.forEach(prop => {\n      ret[prop] = anims[prop] && anims[prop].active() ? anims[prop]._to : me[prop];\n    });\n    return ret;\n  }\n}\nElement.defaults = {};\nElement.defaultRoutes = undefined;\n\nconst formatters = {\n  values(value) {\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(value) ? value : '' + value;\n  },\n  numeric(tickValue, index, ticks) {\n    if (tickValue === 0) {\n      return '0';\n    }\n    const locale = this.chart.options.locale;\n    let notation;\n    let delta = tickValue;\n    if (ticks.length > 1) {\n      const maxTick = Math.max(Math.abs(ticks[0].value), Math.abs(ticks[ticks.length - 1].value));\n      if (maxTick < 1e-4 || maxTick > 1e+15) {\n        notation = 'scientific';\n      }\n      delta = calculateDelta(tickValue, ticks);\n    }\n    const logDelta = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(Math.abs(delta));\n    const numDecimal = Math.max(Math.min(-1 * Math.floor(logDelta), 20), 0);\n    const options = {notation, minimumFractionDigits: numDecimal, maximumFractionDigits: numDecimal};\n    Object.assign(options, this.options.ticks.format);\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.n)(tickValue, locale, options);\n  },\n  logarithmic(tickValue, index, ticks) {\n    if (tickValue === 0) {\n      return '0';\n    }\n    const remain = tickValue / (Math.pow(10, Math.floor((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(tickValue))));\n    if (remain === 1 || remain === 2 || remain === 5) {\n      return formatters.numeric.call(this, tickValue, index, ticks);\n    }\n    return '';\n  }\n};\nfunction calculateDelta(tickValue, ticks) {\n  let delta = ticks.length > 3 ? ticks[2].value - ticks[1].value : ticks[1].value - ticks[0].value;\n  if (Math.abs(delta) >= 1 && tickValue !== Math.floor(tickValue)) {\n    delta = tickValue - Math.floor(tickValue);\n  }\n  return delta;\n}\nvar Ticks = {formatters};\n\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.set('scale', {\n  display: true,\n  offset: false,\n  reverse: false,\n  beginAtZero: false,\n  bounds: 'ticks',\n  grace: 0,\n  grid: {\n    display: true,\n    lineWidth: 1,\n    drawBorder: true,\n    drawOnChartArea: true,\n    drawTicks: true,\n    tickLength: 8,\n    tickWidth: (_ctx, options) => options.lineWidth,\n    tickColor: (_ctx, options) => options.color,\n    offset: false,\n    borderDash: [],\n    borderDashOffset: 0.0,\n    borderWidth: 1\n  },\n  title: {\n    display: false,\n    text: '',\n    padding: {\n      top: 4,\n      bottom: 4\n    }\n  },\n  ticks: {\n    minRotation: 0,\n    maxRotation: 50,\n    mirror: false,\n    textStrokeWidth: 0,\n    textStrokeColor: '',\n    padding: 3,\n    display: true,\n    autoSkip: true,\n    autoSkipPadding: 3,\n    labelOffset: 0,\n    callback: Ticks.formatters.values,\n    minor: {},\n    major: {},\n    align: 'center',\n    crossAlign: 'near',\n    showLabelBackdrop: false,\n    backdropColor: 'rgba(255, 255, 255, 0.75)',\n    backdropPadding: 2,\n  }\n});\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.route('scale.ticks', 'color', '', 'color');\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.route('scale.grid', 'color', '', 'borderColor');\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.route('scale.grid', 'borderColor', '', 'borderColor');\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.route('scale.title', 'color', '', 'color');\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.describe('scale', {\n  _fallback: false,\n  _scriptable: (name) => !name.startsWith('before') && !name.startsWith('after') && name !== 'callback' && name !== 'parser',\n  _indexable: (name) => name !== 'borderDash' && name !== 'tickBorderDash',\n});\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.describe('scales', {\n  _fallback: 'scale',\n});\n_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.describe('scale.ticks', {\n  _scriptable: (name) => name !== 'backdropPadding' && name !== 'callback',\n  _indexable: (name) => name !== 'backdropPadding',\n});\n\nfunction autoSkip(scale, ticks) {\n  const tickOpts = scale.options.ticks;\n  const ticksLimit = tickOpts.maxTicksLimit || determineMaxTicks(scale);\n  const majorIndices = tickOpts.major.enabled ? getMajorIndices(ticks) : [];\n  const numMajorIndices = majorIndices.length;\n  const first = majorIndices[0];\n  const last = majorIndices[numMajorIndices - 1];\n  const newTicks = [];\n  if (numMajorIndices > ticksLimit) {\n    skipMajors(ticks, newTicks, majorIndices, numMajorIndices / ticksLimit);\n    return newTicks;\n  }\n  const spacing = calculateSpacing(majorIndices, ticks, ticksLimit);\n  if (numMajorIndices > 0) {\n    let i, ilen;\n    const avgMajorSpacing = numMajorIndices > 1 ? Math.round((last - first) / (numMajorIndices - 1)) : null;\n    skip(ticks, newTicks, spacing, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(avgMajorSpacing) ? 0 : first - avgMajorSpacing, first);\n    for (i = 0, ilen = numMajorIndices - 1; i < ilen; i++) {\n      skip(ticks, newTicks, spacing, majorIndices[i], majorIndices[i + 1]);\n    }\n    skip(ticks, newTicks, spacing, last, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(avgMajorSpacing) ? ticks.length : last + avgMajorSpacing);\n    return newTicks;\n  }\n  skip(ticks, newTicks, spacing);\n  return newTicks;\n}\nfunction determineMaxTicks(scale) {\n  const offset = scale.options.offset;\n  const tickLength = scale._tickSize();\n  const maxScale = scale._length / tickLength + (offset ? 0 : 1);\n  const maxChart = scale._maxLength / tickLength;\n  return Math.floor(Math.min(maxScale, maxChart));\n}\nfunction calculateSpacing(majorIndices, ticks, ticksLimit) {\n  const evenMajorSpacing = getEvenSpacing(majorIndices);\n  const spacing = ticks.length / ticksLimit;\n  if (!evenMajorSpacing) {\n    return Math.max(spacing, 1);\n  }\n  const factors = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.K)(evenMajorSpacing);\n  for (let i = 0, ilen = factors.length - 1; i < ilen; i++) {\n    const factor = factors[i];\n    if (factor > spacing) {\n      return factor;\n    }\n  }\n  return Math.max(spacing, 1);\n}\nfunction getMajorIndices(ticks) {\n  const result = [];\n  let i, ilen;\n  for (i = 0, ilen = ticks.length; i < ilen; i++) {\n    if (ticks[i].major) {\n      result.push(i);\n    }\n  }\n  return result;\n}\nfunction skipMajors(ticks, newTicks, majorIndices, spacing) {\n  let count = 0;\n  let next = majorIndices[0];\n  let i;\n  spacing = Math.ceil(spacing);\n  for (i = 0; i < ticks.length; i++) {\n    if (i === next) {\n      newTicks.push(ticks[i]);\n      count++;\n      next = majorIndices[count * spacing];\n    }\n  }\n}\nfunction skip(ticks, newTicks, spacing, majorStart, majorEnd) {\n  const start = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(majorStart, 0);\n  const end = Math.min((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(majorEnd, ticks.length), ticks.length);\n  let count = 0;\n  let length, i, next;\n  spacing = Math.ceil(spacing);\n  if (majorEnd) {\n    length = majorEnd - majorStart;\n    spacing = length / Math.floor(length / spacing);\n  }\n  next = start;\n  while (next < 0) {\n    count++;\n    next = Math.round(start + count * spacing);\n  }\n  for (i = Math.max(start, 0); i < end; i++) {\n    if (i === next) {\n      newTicks.push(ticks[i]);\n      count++;\n      next = Math.round(start + count * spacing);\n    }\n  }\n}\nfunction getEvenSpacing(arr) {\n  const len = arr.length;\n  let i, diff;\n  if (len < 2) {\n    return false;\n  }\n  for (diff = arr[0], i = 1; i < len; ++i) {\n    if (arr[i] - arr[i - 1] !== diff) {\n      return false;\n    }\n  }\n  return diff;\n}\n\nconst reverseAlign = (align) => align === 'left' ? 'right' : align === 'right' ? 'left' : align;\nconst offsetFromEdge = (scale, edge, offset) => edge === 'top' || edge === 'left' ? scale[edge] + offset : scale[edge] - offset;\nfunction sample(arr, numItems) {\n  const result = [];\n  const increment = arr.length / numItems;\n  const len = arr.length;\n  let i = 0;\n  for (; i < len; i += increment) {\n    result.push(arr[Math.floor(i)]);\n  }\n  return result;\n}\nfunction getPixelForGridLine(scale, index, offsetGridLines) {\n  const length = scale.ticks.length;\n  const validIndex = Math.min(index, length - 1);\n  const start = scale._startPixel;\n  const end = scale._endPixel;\n  const epsilon = 1e-6;\n  let lineValue = scale.getPixelForTick(validIndex);\n  let offset;\n  if (offsetGridLines) {\n    if (length === 1) {\n      offset = Math.max(lineValue - start, end - lineValue);\n    } else if (index === 0) {\n      offset = (scale.getPixelForTick(1) - lineValue) / 2;\n    } else {\n      offset = (lineValue - scale.getPixelForTick(validIndex - 1)) / 2;\n    }\n    lineValue += validIndex < index ? offset : -offset;\n    if (lineValue < start - epsilon || lineValue > end + epsilon) {\n      return;\n    }\n  }\n  return lineValue;\n}\nfunction garbageCollect(caches, length) {\n  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(caches, (cache) => {\n    const gc = cache.gc;\n    const gcLen = gc.length / 2;\n    let i;\n    if (gcLen > length) {\n      for (i = 0; i < gcLen; ++i) {\n        delete cache.data[gc[i]];\n      }\n      gc.splice(0, gcLen);\n    }\n  });\n}\nfunction getTickMarkLength(options) {\n  return options.drawTicks ? options.tickLength : 0;\n}\nfunction getTitleHeight(options, fallback) {\n  if (!options.display) {\n    return 0;\n  }\n  const font = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(options.font, fallback);\n  const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(options.padding);\n  const lines = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(options.text) ? options.text.length : 1;\n  return (lines * font.lineHeight) + padding.height;\n}\nfunction createScaleContext(parent, scale) {\n  return Object.assign(Object.create(parent), {\n    scale,\n    type: 'scale'\n  });\n}\nfunction createTickContext(parent, index, tick) {\n  return Object.assign(Object.create(parent), {\n    tick,\n    index,\n    type: 'tick'\n  });\n}\nfunction titleAlign(align, position, reverse) {\n  let ret = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Y)(align);\n  if ((reverse && position !== 'right') || (!reverse && position === 'right')) {\n    ret = reverseAlign(ret);\n  }\n  return ret;\n}\nfunction titleArgs(scale, offset, position, align) {\n  const {top, left, bottom, right, chart} = scale;\n  const {chartArea, scales} = chart;\n  let rotation = 0;\n  let maxWidth, titleX, titleY;\n  const height = bottom - top;\n  const width = right - left;\n  if (scale.isHorizontal()) {\n    titleX = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, left, right);\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n      const positionAxisID = Object.keys(position)[0];\n      const value = position[positionAxisID];\n      titleY = scales[positionAxisID].getPixelForValue(value) + height - offset;\n    } else if (position === 'center') {\n      titleY = (chartArea.bottom + chartArea.top) / 2 + height - offset;\n    } else {\n      titleY = offsetFromEdge(scale, position, offset);\n    }\n    maxWidth = right - left;\n  } else {\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n      const positionAxisID = Object.keys(position)[0];\n      const value = position[positionAxisID];\n      titleX = scales[positionAxisID].getPixelForValue(value) - width + offset;\n    } else if (position === 'center') {\n      titleX = (chartArea.left + chartArea.right) / 2 - width + offset;\n    } else {\n      titleX = offsetFromEdge(scale, position, offset);\n    }\n    titleY = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, bottom, top);\n    rotation = position === 'left' ? -_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H : _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H;\n  }\n  return {titleX, titleY, maxWidth, rotation};\n}\nclass Scale extends Element {\n  constructor(cfg) {\n    super();\n    this.id = cfg.id;\n    this.type = cfg.type;\n    this.options = undefined;\n    this.ctx = cfg.ctx;\n    this.chart = cfg.chart;\n    this.top = undefined;\n    this.bottom = undefined;\n    this.left = undefined;\n    this.right = undefined;\n    this.width = undefined;\n    this.height = undefined;\n    this._margins = {\n      left: 0,\n      right: 0,\n      top: 0,\n      bottom: 0\n    };\n    this.maxWidth = undefined;\n    this.maxHeight = undefined;\n    this.paddingTop = undefined;\n    this.paddingBottom = undefined;\n    this.paddingLeft = undefined;\n    this.paddingRight = undefined;\n    this.axis = undefined;\n    this.labelRotation = undefined;\n    this.min = undefined;\n    this.max = undefined;\n    this._range = undefined;\n    this.ticks = [];\n    this._gridLineItems = null;\n    this._labelItems = null;\n    this._labelSizes = null;\n    this._length = 0;\n    this._maxLength = 0;\n    this._longestTextCache = {};\n    this._startPixel = undefined;\n    this._endPixel = undefined;\n    this._reversePixels = false;\n    this._userMax = undefined;\n    this._userMin = undefined;\n    this._suggestedMax = undefined;\n    this._suggestedMin = undefined;\n    this._ticksLength = 0;\n    this._borderValue = 0;\n    this._cache = {};\n    this._dataLimitsCached = false;\n    this.$context = undefined;\n  }\n  init(options) {\n    const me = this;\n    me.options = options.setContext(me.getContext());\n    me.axis = options.axis;\n    me._userMin = me.parse(options.min);\n    me._userMax = me.parse(options.max);\n    me._suggestedMin = me.parse(options.suggestedMin);\n    me._suggestedMax = me.parse(options.suggestedMax);\n  }\n  parse(raw, index) {\n    return raw;\n  }\n  getUserBounds() {\n    let {_userMin, _userMax, _suggestedMin, _suggestedMax} = this;\n    _userMin = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(_userMin, Number.POSITIVE_INFINITY);\n    _userMax = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(_userMax, Number.NEGATIVE_INFINITY);\n    _suggestedMin = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(_suggestedMin, Number.POSITIVE_INFINITY);\n    _suggestedMax = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(_suggestedMax, Number.NEGATIVE_INFINITY);\n    return {\n      min: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(_userMin, _suggestedMin),\n      max: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(_userMax, _suggestedMax),\n      minDefined: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(_userMin),\n      maxDefined: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(_userMax)\n    };\n  }\n  getMinMax(canStack) {\n    const me = this;\n    let {min, max, minDefined, maxDefined} = me.getUserBounds();\n    let range;\n    if (minDefined && maxDefined) {\n      return {min, max};\n    }\n    const metas = me.getMatchingVisibleMetas();\n    for (let i = 0, ilen = metas.length; i < ilen; ++i) {\n      range = metas[i].controller.getMinMax(me, canStack);\n      if (!minDefined) {\n        min = Math.min(min, range.min);\n      }\n      if (!maxDefined) {\n        max = Math.max(max, range.max);\n      }\n    }\n    return {\n      min: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(min, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(max, min)),\n      max: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(max, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(min, max))\n    };\n  }\n  getPadding() {\n    const me = this;\n    return {\n      left: me.paddingLeft || 0,\n      top: me.paddingTop || 0,\n      right: me.paddingRight || 0,\n      bottom: me.paddingBottom || 0\n    };\n  }\n  getTicks() {\n    return this.ticks;\n  }\n  getLabels() {\n    const data = this.chart.data;\n    return this.options.labels || (this.isHorizontal() ? data.xLabels : data.yLabels) || data.labels || [];\n  }\n  beforeLayout() {\n    this._cache = {};\n    this._dataLimitsCached = false;\n  }\n  beforeUpdate() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.beforeUpdate, [this]);\n  }\n  update(maxWidth, maxHeight, margins) {\n    const me = this;\n    const tickOpts = me.options.ticks;\n    const sampleSize = tickOpts.sampleSize;\n    me.beforeUpdate();\n    me.maxWidth = maxWidth;\n    me.maxHeight = maxHeight;\n    me._margins = margins = Object.assign({\n      left: 0,\n      right: 0,\n      top: 0,\n      bottom: 0\n    }, margins);\n    me.ticks = null;\n    me._labelSizes = null;\n    me._gridLineItems = null;\n    me._labelItems = null;\n    me.beforeSetDimensions();\n    me.setDimensions();\n    me.afterSetDimensions();\n    me._maxLength = me.isHorizontal()\n      ? me.width + margins.left + margins.right\n      : me.height + margins.top + margins.bottom;\n    if (!me._dataLimitsCached) {\n      me.beforeDataLimits();\n      me.determineDataLimits();\n      me.afterDataLimits();\n      me._range = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.N)(me, me.options.grace);\n      me._dataLimitsCached = true;\n    }\n    me.beforeBuildTicks();\n    me.ticks = me.buildTicks() || [];\n    me.afterBuildTicks();\n    const samplingEnabled = sampleSize < me.ticks.length;\n    me._convertTicksToLabels(samplingEnabled ? sample(me.ticks, sampleSize) : me.ticks);\n    me.configure();\n    me.beforeCalculateLabelRotation();\n    me.calculateLabelRotation();\n    me.afterCalculateLabelRotation();\n    if (tickOpts.display && (tickOpts.autoSkip || tickOpts.source === 'auto')) {\n      me.ticks = autoSkip(me, me.ticks);\n      me._labelSizes = null;\n    }\n    if (samplingEnabled) {\n      me._convertTicksToLabels(me.ticks);\n    }\n    me.beforeFit();\n    me.fit();\n    me.afterFit();\n    me.afterUpdate();\n  }\n  configure() {\n    const me = this;\n    let reversePixels = me.options.reverse;\n    let startPixel, endPixel;\n    if (me.isHorizontal()) {\n      startPixel = me.left;\n      endPixel = me.right;\n    } else {\n      startPixel = me.top;\n      endPixel = me.bottom;\n      reversePixels = !reversePixels;\n    }\n    me._startPixel = startPixel;\n    me._endPixel = endPixel;\n    me._reversePixels = reversePixels;\n    me._length = endPixel - startPixel;\n    me._alignToPixels = me.options.alignToPixels;\n  }\n  afterUpdate() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.afterUpdate, [this]);\n  }\n  beforeSetDimensions() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.beforeSetDimensions, [this]);\n  }\n  setDimensions() {\n    const me = this;\n    if (me.isHorizontal()) {\n      me.width = me.maxWidth;\n      me.left = 0;\n      me.right = me.width;\n    } else {\n      me.height = me.maxHeight;\n      me.top = 0;\n      me.bottom = me.height;\n    }\n    me.paddingLeft = 0;\n    me.paddingTop = 0;\n    me.paddingRight = 0;\n    me.paddingBottom = 0;\n  }\n  afterSetDimensions() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.afterSetDimensions, [this]);\n  }\n  _callHooks(name) {\n    const me = this;\n    me.chart.notifyPlugins(name, me.getContext());\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(me.options[name], [me]);\n  }\n  beforeDataLimits() {\n    this._callHooks('beforeDataLimits');\n  }\n  determineDataLimits() {}\n  afterDataLimits() {\n    this._callHooks('afterDataLimits');\n  }\n  beforeBuildTicks() {\n    this._callHooks('beforeBuildTicks');\n  }\n  buildTicks() {\n    return [];\n  }\n  afterBuildTicks() {\n    this._callHooks('afterBuildTicks');\n  }\n  beforeTickToLabelConversion() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.beforeTickToLabelConversion, [this]);\n  }\n  generateTickLabels(ticks) {\n    const me = this;\n    const tickOpts = me.options.ticks;\n    let i, ilen, tick;\n    for (i = 0, ilen = ticks.length; i < ilen; i++) {\n      tick = ticks[i];\n      tick.label = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(tickOpts.callback, [tick.value, i, ticks], me);\n    }\n  }\n  afterTickToLabelConversion() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.afterTickToLabelConversion, [this]);\n  }\n  beforeCalculateLabelRotation() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.beforeCalculateLabelRotation, [this]);\n  }\n  calculateLabelRotation() {\n    const me = this;\n    const options = me.options;\n    const tickOpts = options.ticks;\n    const numTicks = me.ticks.length;\n    const minRotation = tickOpts.minRotation || 0;\n    const maxRotation = tickOpts.maxRotation;\n    let labelRotation = minRotation;\n    let tickWidth, maxHeight, maxLabelDiagonal;\n    if (!me._isVisible() || !tickOpts.display || minRotation >= maxRotation || numTicks <= 1 || !me.isHorizontal()) {\n      me.labelRotation = minRotation;\n      return;\n    }\n    const labelSizes = me._getLabelSizes();\n    const maxLabelWidth = labelSizes.widest.width;\n    const maxLabelHeight = labelSizes.highest.height;\n    const maxWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(me.chart.width - maxLabelWidth, 0, me.maxWidth);\n    tickWidth = options.offset ? me.maxWidth / numTicks : maxWidth / (numTicks - 1);\n    if (maxLabelWidth + 6 > tickWidth) {\n      tickWidth = maxWidth / (numTicks - (options.offset ? 0.5 : 1));\n      maxHeight = me.maxHeight - getTickMarkLength(options.grid)\n\t\t\t\t- tickOpts.padding - getTitleHeight(options.title, me.chart.options.font);\n      maxLabelDiagonal = Math.sqrt(maxLabelWidth * maxLabelWidth + maxLabelHeight * maxLabelHeight);\n      labelRotation = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(Math.min(\n        Math.asin((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)((labelSizes.highest.height + 6) / tickWidth, -1, 1)),\n        Math.asin((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(maxHeight / maxLabelDiagonal, -1, 1)) - Math.asin((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(maxLabelHeight / maxLabelDiagonal, -1, 1))\n      ));\n      labelRotation = Math.max(minRotation, Math.min(maxRotation, labelRotation));\n    }\n    me.labelRotation = labelRotation;\n  }\n  afterCalculateLabelRotation() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.afterCalculateLabelRotation, [this]);\n  }\n  beforeFit() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.beforeFit, [this]);\n  }\n  fit() {\n    const me = this;\n    const minSize = {\n      width: 0,\n      height: 0\n    };\n    const {chart, options: {ticks: tickOpts, title: titleOpts, grid: gridOpts}} = me;\n    const display = me._isVisible();\n    const isHorizontal = me.isHorizontal();\n    if (display) {\n      const titleHeight = getTitleHeight(titleOpts, chart.options.font);\n      if (isHorizontal) {\n        minSize.width = me.maxWidth;\n        minSize.height = getTickMarkLength(gridOpts) + titleHeight;\n      } else {\n        minSize.height = me.maxHeight;\n        minSize.width = getTickMarkLength(gridOpts) + titleHeight;\n      }\n      if (tickOpts.display && me.ticks.length) {\n        const {first, last, widest, highest} = me._getLabelSizes();\n        const tickPadding = tickOpts.padding * 2;\n        const angleRadians = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(me.labelRotation);\n        const cos = Math.cos(angleRadians);\n        const sin = Math.sin(angleRadians);\n        if (isHorizontal) {\n          const labelHeight = tickOpts.mirror ? 0 : sin * widest.width + cos * highest.height;\n          minSize.height = Math.min(me.maxHeight, minSize.height + labelHeight + tickPadding);\n        } else {\n          const labelWidth = tickOpts.mirror ? 0 : cos * widest.width + sin * highest.height;\n          minSize.width = Math.min(me.maxWidth, minSize.width + labelWidth + tickPadding);\n        }\n        me._calculatePadding(first, last, sin, cos);\n      }\n    }\n    me._handleMargins();\n    if (isHorizontal) {\n      me.width = me._length = chart.width - me._margins.left - me._margins.right;\n      me.height = minSize.height;\n    } else {\n      me.width = minSize.width;\n      me.height = me._length = chart.height - me._margins.top - me._margins.bottom;\n    }\n  }\n  _calculatePadding(first, last, sin, cos) {\n    const me = this;\n    const {ticks: {align, padding}, position} = me.options;\n    const isRotated = me.labelRotation !== 0;\n    const labelsBelowTicks = position !== 'top' && me.axis === 'x';\n    if (me.isHorizontal()) {\n      const offsetLeft = me.getPixelForTick(0) - me.left;\n      const offsetRight = me.right - me.getPixelForTick(me.ticks.length - 1);\n      let paddingLeft = 0;\n      let paddingRight = 0;\n      if (isRotated) {\n        if (labelsBelowTicks) {\n          paddingLeft = cos * first.width;\n          paddingRight = sin * last.height;\n        } else {\n          paddingLeft = sin * first.height;\n          paddingRight = cos * last.width;\n        }\n      } else if (align === 'start') {\n        paddingRight = last.width;\n      } else if (align === 'end') {\n        paddingLeft = first.width;\n      } else {\n        paddingLeft = first.width / 2;\n        paddingRight = last.width / 2;\n      }\n      me.paddingLeft = Math.max((paddingLeft - offsetLeft + padding) * me.width / (me.width - offsetLeft), 0);\n      me.paddingRight = Math.max((paddingRight - offsetRight + padding) * me.width / (me.width - offsetRight), 0);\n    } else {\n      let paddingTop = last.height / 2;\n      let paddingBottom = first.height / 2;\n      if (align === 'start') {\n        paddingTop = 0;\n        paddingBottom = first.height;\n      } else if (align === 'end') {\n        paddingTop = last.height;\n        paddingBottom = 0;\n      }\n      me.paddingTop = paddingTop + padding;\n      me.paddingBottom = paddingBottom + padding;\n    }\n  }\n  _handleMargins() {\n    const me = this;\n    if (me._margins) {\n      me._margins.left = Math.max(me.paddingLeft, me._margins.left);\n      me._margins.top = Math.max(me.paddingTop, me._margins.top);\n      me._margins.right = Math.max(me.paddingRight, me._margins.right);\n      me._margins.bottom = Math.max(me.paddingBottom, me._margins.bottom);\n    }\n  }\n  afterFit() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(this.options.afterFit, [this]);\n  }\n  isHorizontal() {\n    const {axis, position} = this.options;\n    return position === 'top' || position === 'bottom' || axis === 'x';\n  }\n  isFullSize() {\n    return this.options.fullSize;\n  }\n  _convertTicksToLabels(ticks) {\n    const me = this;\n    me.beforeTickToLabelConversion();\n    me.generateTickLabels(ticks);\n    let i, ilen;\n    for (i = 0, ilen = ticks.length; i < ilen; i++) {\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(ticks[i].label)) {\n        ticks.splice(i, 1);\n        ilen--;\n        i--;\n      }\n    }\n    me.afterTickToLabelConversion();\n  }\n  _getLabelSizes() {\n    const me = this;\n    let labelSizes = me._labelSizes;\n    if (!labelSizes) {\n      const sampleSize = me.options.ticks.sampleSize;\n      let ticks = me.ticks;\n      if (sampleSize < ticks.length) {\n        ticks = sample(ticks, sampleSize);\n      }\n      me._labelSizes = labelSizes = me._computeLabelSizes(ticks, ticks.length);\n    }\n    return labelSizes;\n  }\n  _computeLabelSizes(ticks, length) {\n    const {ctx, _longestTextCache: caches} = this;\n    const widths = [];\n    const heights = [];\n    let widestLabelSize = 0;\n    let highestLabelSize = 0;\n    let i, j, jlen, label, tickFont, fontString, cache, lineHeight, width, height, nestedLabel;\n    for (i = 0; i < length; ++i) {\n      label = ticks[i].label;\n      tickFont = this._resolveTickFontOptions(i);\n      ctx.font = fontString = tickFont.string;\n      cache = caches[fontString] = caches[fontString] || {data: {}, gc: []};\n      lineHeight = tickFont.lineHeight;\n      width = height = 0;\n      if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(label) && !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(label)) {\n        width = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(ctx, cache.data, cache.gc, width, label);\n        height = lineHeight;\n      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(label)) {\n        for (j = 0, jlen = label.length; j < jlen; ++j) {\n          nestedLabel = label[j];\n          if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(nestedLabel) && !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(nestedLabel)) {\n            width = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(ctx, cache.data, cache.gc, width, nestedLabel);\n            height += lineHeight;\n          }\n        }\n      }\n      widths.push(width);\n      heights.push(height);\n      widestLabelSize = Math.max(width, widestLabelSize);\n      highestLabelSize = Math.max(height, highestLabelSize);\n    }\n    garbageCollect(caches, length);\n    const widest = widths.indexOf(widestLabelSize);\n    const highest = heights.indexOf(highestLabelSize);\n    const valueAt = (idx) => ({width: widths[idx] || 0, height: heights[idx] || 0});\n    return {\n      first: valueAt(0),\n      last: valueAt(length - 1),\n      widest: valueAt(widest),\n      highest: valueAt(highest),\n      widths,\n      heights,\n    };\n  }\n  getLabelForValue(value) {\n    return value;\n  }\n  getPixelForValue(value, index) {\n    return NaN;\n  }\n  getValueForPixel(pixel) {}\n  getPixelForTick(index) {\n    const ticks = this.ticks;\n    if (index < 0 || index > ticks.length - 1) {\n      return null;\n    }\n    return this.getPixelForValue(ticks[index].value);\n  }\n  getPixelForDecimal(decimal) {\n    const me = this;\n    if (me._reversePixels) {\n      decimal = 1 - decimal;\n    }\n    const pixel = me._startPixel + decimal * me._length;\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.R)(me._alignToPixels ? (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(me.chart, pixel, 0) : pixel);\n  }\n  getDecimalForPixel(pixel) {\n    const decimal = (pixel - this._startPixel) / this._length;\n    return this._reversePixels ? 1 - decimal : decimal;\n  }\n  getBasePixel() {\n    return this.getPixelForValue(this.getBaseValue());\n  }\n  getBaseValue() {\n    const {min, max} = this;\n    return min < 0 && max < 0 ? max :\n      min > 0 && max > 0 ? min :\n      0;\n  }\n  getContext(index) {\n    const me = this;\n    const ticks = me.ticks || [];\n    if (index >= 0 && index < ticks.length) {\n      const tick = ticks[index];\n      return tick.$context ||\n\t\t\t\t(tick.$context = createTickContext(me.getContext(), index, tick));\n    }\n    return me.$context ||\n\t\t\t(me.$context = createScaleContext(me.chart.getContext(), me));\n  }\n  _tickSize() {\n    const me = this;\n    const optionTicks = me.options.ticks;\n    const rot = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(me.labelRotation);\n    const cos = Math.abs(Math.cos(rot));\n    const sin = Math.abs(Math.sin(rot));\n    const labelSizes = me._getLabelSizes();\n    const padding = optionTicks.autoSkipPadding || 0;\n    const w = labelSizes ? labelSizes.widest.width + padding : 0;\n    const h = labelSizes ? labelSizes.highest.height + padding : 0;\n    return me.isHorizontal()\n      ? h * cos > w * sin ? w / cos : h / sin\n      : h * sin < w * cos ? h / cos : w / sin;\n  }\n  _isVisible() {\n    const display = this.options.display;\n    if (display !== 'auto') {\n      return !!display;\n    }\n    return this.getMatchingVisibleMetas().length > 0;\n  }\n  _computeGridLineItems(chartArea) {\n    const me = this;\n    const axis = me.axis;\n    const chart = me.chart;\n    const options = me.options;\n    const {grid, position} = options;\n    const offset = grid.offset;\n    const isHorizontal = me.isHorizontal();\n    const ticks = me.ticks;\n    const ticksLength = ticks.length + (offset ? 1 : 0);\n    const tl = getTickMarkLength(grid);\n    const items = [];\n    const borderOpts = grid.setContext(me.getContext());\n    const axisWidth = borderOpts.drawBorder ? borderOpts.borderWidth : 0;\n    const axisHalfWidth = axisWidth / 2;\n    const alignBorderValue = function(pixel) {\n      return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(chart, pixel, axisWidth);\n    };\n    let borderValue, i, lineValue, alignedLineValue;\n    let tx1, ty1, tx2, ty2, x1, y1, x2, y2;\n    if (position === 'top') {\n      borderValue = alignBorderValue(me.bottom);\n      ty1 = me.bottom - tl;\n      ty2 = borderValue - axisHalfWidth;\n      y1 = alignBorderValue(chartArea.top) + axisHalfWidth;\n      y2 = chartArea.bottom;\n    } else if (position === 'bottom') {\n      borderValue = alignBorderValue(me.top);\n      y1 = chartArea.top;\n      y2 = alignBorderValue(chartArea.bottom) - axisHalfWidth;\n      ty1 = borderValue + axisHalfWidth;\n      ty2 = me.top + tl;\n    } else if (position === 'left') {\n      borderValue = alignBorderValue(me.right);\n      tx1 = me.right - tl;\n      tx2 = borderValue - axisHalfWidth;\n      x1 = alignBorderValue(chartArea.left) + axisHalfWidth;\n      x2 = chartArea.right;\n    } else if (position === 'right') {\n      borderValue = alignBorderValue(me.left);\n      x1 = chartArea.left;\n      x2 = alignBorderValue(chartArea.right) - axisHalfWidth;\n      tx1 = borderValue + axisHalfWidth;\n      tx2 = me.left + tl;\n    } else if (axis === 'x') {\n      if (position === 'center') {\n        borderValue = alignBorderValue((chartArea.top + chartArea.bottom) / 2 + 0.5);\n      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n        const positionAxisID = Object.keys(position)[0];\n        const value = position[positionAxisID];\n        borderValue = alignBorderValue(me.chart.scales[positionAxisID].getPixelForValue(value));\n      }\n      y1 = chartArea.top;\n      y2 = chartArea.bottom;\n      ty1 = borderValue + axisHalfWidth;\n      ty2 = ty1 + tl;\n    } else if (axis === 'y') {\n      if (position === 'center') {\n        borderValue = alignBorderValue((chartArea.left + chartArea.right) / 2);\n      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n        const positionAxisID = Object.keys(position)[0];\n        const value = position[positionAxisID];\n        borderValue = alignBorderValue(me.chart.scales[positionAxisID].getPixelForValue(value));\n      }\n      tx1 = borderValue - axisHalfWidth;\n      tx2 = tx1 - tl;\n      x1 = chartArea.left;\n      x2 = chartArea.right;\n    }\n    const limit = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.ticks.maxTicksLimit, ticksLength);\n    const step = Math.max(1, Math.ceil(ticksLength / limit));\n    for (i = 0; i < ticksLength; i += step) {\n      const optsAtIndex = grid.setContext(me.getContext(i));\n      const lineWidth = optsAtIndex.lineWidth;\n      const lineColor = optsAtIndex.color;\n      const borderDash = grid.borderDash || [];\n      const borderDashOffset = optsAtIndex.borderDashOffset;\n      const tickWidth = optsAtIndex.tickWidth;\n      const tickColor = optsAtIndex.tickColor;\n      const tickBorderDash = optsAtIndex.tickBorderDash || [];\n      const tickBorderDashOffset = optsAtIndex.tickBorderDashOffset;\n      lineValue = getPixelForGridLine(me, i, offset);\n      if (lineValue === undefined) {\n        continue;\n      }\n      alignedLineValue = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(chart, lineValue, lineWidth);\n      if (isHorizontal) {\n        tx1 = tx2 = x1 = x2 = alignedLineValue;\n      } else {\n        ty1 = ty2 = y1 = y2 = alignedLineValue;\n      }\n      items.push({\n        tx1,\n        ty1,\n        tx2,\n        ty2,\n        x1,\n        y1,\n        x2,\n        y2,\n        width: lineWidth,\n        color: lineColor,\n        borderDash,\n        borderDashOffset,\n        tickWidth,\n        tickColor,\n        tickBorderDash,\n        tickBorderDashOffset,\n      });\n    }\n    me._ticksLength = ticksLength;\n    me._borderValue = borderValue;\n    return items;\n  }\n  _computeLabelItems(chartArea) {\n    const me = this;\n    const axis = me.axis;\n    const options = me.options;\n    const {position, ticks: optionTicks} = options;\n    const isHorizontal = me.isHorizontal();\n    const ticks = me.ticks;\n    const {align, crossAlign, padding, mirror} = optionTicks;\n    const tl = getTickMarkLength(options.grid);\n    const tickAndPadding = tl + padding;\n    const hTickAndPadding = mirror ? -padding : tickAndPadding;\n    const rotation = -(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(me.labelRotation);\n    const items = [];\n    let i, ilen, tick, label, x, y, textAlign, pixel, font, lineHeight, lineCount, textOffset;\n    let textBaseline = 'middle';\n    if (position === 'top') {\n      y = me.bottom - hTickAndPadding;\n      textAlign = me._getXAxisLabelAlignment();\n    } else if (position === 'bottom') {\n      y = me.top + hTickAndPadding;\n      textAlign = me._getXAxisLabelAlignment();\n    } else if (position === 'left') {\n      const ret = me._getYAxisLabelAlignment(tl);\n      textAlign = ret.textAlign;\n      x = ret.x;\n    } else if (position === 'right') {\n      const ret = me._getYAxisLabelAlignment(tl);\n      textAlign = ret.textAlign;\n      x = ret.x;\n    } else if (axis === 'x') {\n      if (position === 'center') {\n        y = ((chartArea.top + chartArea.bottom) / 2) + tickAndPadding;\n      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n        const positionAxisID = Object.keys(position)[0];\n        const value = position[positionAxisID];\n        y = me.chart.scales[positionAxisID].getPixelForValue(value) + tickAndPadding;\n      }\n      textAlign = me._getXAxisLabelAlignment();\n    } else if (axis === 'y') {\n      if (position === 'center') {\n        x = ((chartArea.left + chartArea.right) / 2) - tickAndPadding;\n      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n        const positionAxisID = Object.keys(position)[0];\n        const value = position[positionAxisID];\n        x = me.chart.scales[positionAxisID].getPixelForValue(value);\n      }\n      textAlign = me._getYAxisLabelAlignment(tl).textAlign;\n    }\n    if (axis === 'y') {\n      if (align === 'start') {\n        textBaseline = 'top';\n      } else if (align === 'end') {\n        textBaseline = 'bottom';\n      }\n    }\n    const labelSizes = me._getLabelSizes();\n    for (i = 0, ilen = ticks.length; i < ilen; ++i) {\n      tick = ticks[i];\n      label = tick.label;\n      const optsAtIndex = optionTicks.setContext(me.getContext(i));\n      pixel = me.getPixelForTick(i) + optionTicks.labelOffset;\n      font = me._resolveTickFontOptions(i);\n      lineHeight = font.lineHeight;\n      lineCount = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(label) ? label.length : 1;\n      const halfCount = lineCount / 2;\n      const color = optsAtIndex.color;\n      const strokeColor = optsAtIndex.textStrokeColor;\n      const strokeWidth = optsAtIndex.textStrokeWidth;\n      if (isHorizontal) {\n        x = pixel;\n        if (position === 'top') {\n          if (crossAlign === 'near' || rotation !== 0) {\n            textOffset = -lineCount * lineHeight + lineHeight / 2;\n          } else if (crossAlign === 'center') {\n            textOffset = -labelSizes.highest.height / 2 - halfCount * lineHeight + lineHeight;\n          } else {\n            textOffset = -labelSizes.highest.height + lineHeight / 2;\n          }\n        } else {\n          if (crossAlign === 'near' || rotation !== 0) {\n            textOffset = lineHeight / 2;\n          } else if (crossAlign === 'center') {\n            textOffset = labelSizes.highest.height / 2 - halfCount * lineHeight;\n          } else {\n            textOffset = labelSizes.highest.height - lineCount * lineHeight;\n          }\n        }\n        if (mirror) {\n          textOffset *= -1;\n        }\n      } else {\n        y = pixel;\n        textOffset = (1 - lineCount) * lineHeight / 2;\n      }\n      let backdrop;\n      if (optsAtIndex.showLabelBackdrop) {\n        const labelPadding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(optsAtIndex.backdropPadding);\n        const height = labelSizes.heights[i];\n        const width = labelSizes.widths[i];\n        let top = y + textOffset - labelPadding.top;\n        let left = x - labelPadding.left;\n        switch (textBaseline) {\n        case 'middle':\n          top -= height / 2;\n          break;\n        case 'bottom':\n          top -= height;\n          break;\n        }\n        switch (textAlign) {\n        case 'center':\n          left -= width / 2;\n          break;\n        case 'right':\n          left -= width;\n          break;\n        }\n        backdrop = {\n          left,\n          top,\n          width: width + labelPadding.width,\n          height: height + labelPadding.height,\n          color: optsAtIndex.backdropColor,\n        };\n      }\n      items.push({\n        rotation,\n        label,\n        font,\n        color,\n        strokeColor,\n        strokeWidth,\n        textOffset,\n        textAlign,\n        textBaseline,\n        translation: [x, y],\n        backdrop,\n      });\n    }\n    return items;\n  }\n  _getXAxisLabelAlignment() {\n    const me = this;\n    const {position, ticks} = me.options;\n    const rotation = -(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(me.labelRotation);\n    if (rotation) {\n      return position === 'top' ? 'left' : 'right';\n    }\n    let align = 'center';\n    if (ticks.align === 'start') {\n      align = 'left';\n    } else if (ticks.align === 'end') {\n      align = 'right';\n    }\n    return align;\n  }\n  _getYAxisLabelAlignment(tl) {\n    const me = this;\n    const {position, ticks: {crossAlign, mirror, padding}} = me.options;\n    const labelSizes = me._getLabelSizes();\n    const tickAndPadding = tl + padding;\n    const widest = labelSizes.widest.width;\n    let textAlign;\n    let x;\n    if (position === 'left') {\n      if (mirror) {\n        x = me.right + padding;\n        if (crossAlign === 'near') {\n          textAlign = 'left';\n        } else if (crossAlign === 'center') {\n          textAlign = 'center';\n          x += (widest / 2);\n        } else {\n          textAlign = 'right';\n          x += widest;\n        }\n      } else {\n        x = me.right - tickAndPadding;\n        if (crossAlign === 'near') {\n          textAlign = 'right';\n        } else if (crossAlign === 'center') {\n          textAlign = 'center';\n          x -= (widest / 2);\n        } else {\n          textAlign = 'left';\n          x = me.left;\n        }\n      }\n    } else if (position === 'right') {\n      if (mirror) {\n        x = me.left + padding;\n        if (crossAlign === 'near') {\n          textAlign = 'right';\n        } else if (crossAlign === 'center') {\n          textAlign = 'center';\n          x -= (widest / 2);\n        } else {\n          textAlign = 'left';\n          x -= widest;\n        }\n      } else {\n        x = me.left + tickAndPadding;\n        if (crossAlign === 'near') {\n          textAlign = 'left';\n        } else if (crossAlign === 'center') {\n          textAlign = 'center';\n          x += widest / 2;\n        } else {\n          textAlign = 'right';\n          x = me.right;\n        }\n      }\n    } else {\n      textAlign = 'right';\n    }\n    return {textAlign, x};\n  }\n  _computeLabelArea() {\n    const me = this;\n    if (me.options.ticks.mirror) {\n      return;\n    }\n    const chart = me.chart;\n    const position = me.options.position;\n    if (position === 'left' || position === 'right') {\n      return {top: 0, left: me.left, bottom: chart.height, right: me.right};\n    } if (position === 'top' || position === 'bottom') {\n      return {top: me.top, left: 0, bottom: me.bottom, right: chart.width};\n    }\n  }\n  drawBackground() {\n    const {ctx, options: {backgroundColor}, left, top, width, height} = this;\n    if (backgroundColor) {\n      ctx.save();\n      ctx.fillStyle = backgroundColor;\n      ctx.fillRect(left, top, width, height);\n      ctx.restore();\n    }\n  }\n  getLineWidthForValue(value) {\n    const me = this;\n    const grid = me.options.grid;\n    if (!me._isVisible() || !grid.display) {\n      return 0;\n    }\n    const ticks = me.ticks;\n    const index = ticks.findIndex(t => t.value === value);\n    if (index >= 0) {\n      const opts = grid.setContext(me.getContext(index));\n      return opts.lineWidth;\n    }\n    return 0;\n  }\n  drawGrid(chartArea) {\n    const me = this;\n    const grid = me.options.grid;\n    const ctx = me.ctx;\n    const items = me._gridLineItems || (me._gridLineItems = me._computeGridLineItems(chartArea));\n    let i, ilen;\n    const drawLine = (p1, p2, style) => {\n      if (!style.width || !style.color) {\n        return;\n      }\n      ctx.save();\n      ctx.lineWidth = style.width;\n      ctx.strokeStyle = style.color;\n      ctx.setLineDash(style.borderDash || []);\n      ctx.lineDashOffset = style.borderDashOffset;\n      ctx.beginPath();\n      ctx.moveTo(p1.x, p1.y);\n      ctx.lineTo(p2.x, p2.y);\n      ctx.stroke();\n      ctx.restore();\n    };\n    if (grid.display) {\n      for (i = 0, ilen = items.length; i < ilen; ++i) {\n        const item = items[i];\n        if (grid.drawOnChartArea) {\n          drawLine(\n            {x: item.x1, y: item.y1},\n            {x: item.x2, y: item.y2},\n            item\n          );\n        }\n        if (grid.drawTicks) {\n          drawLine(\n            {x: item.tx1, y: item.ty1},\n            {x: item.tx2, y: item.ty2},\n            {\n              color: item.tickColor,\n              width: item.tickWidth,\n              borderDash: item.tickBorderDash,\n              borderDashOffset: item.tickBorderDashOffset\n            }\n          );\n        }\n      }\n    }\n  }\n  drawBorder() {\n    const me = this;\n    const {chart, ctx, options: {grid}} = me;\n    const borderOpts = grid.setContext(me.getContext());\n    const axisWidth = grid.drawBorder ? borderOpts.borderWidth : 0;\n    if (!axisWidth) {\n      return;\n    }\n    const lastLineWidth = grid.setContext(me.getContext(0)).lineWidth;\n    const borderValue = me._borderValue;\n    let x1, x2, y1, y2;\n    if (me.isHorizontal()) {\n      x1 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(chart, me.left, axisWidth) - axisWidth / 2;\n      x2 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(chart, me.right, lastLineWidth) + lastLineWidth / 2;\n      y1 = y2 = borderValue;\n    } else {\n      y1 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(chart, me.top, axisWidth) - axisWidth / 2;\n      y2 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(chart, me.bottom, lastLineWidth) + lastLineWidth / 2;\n      x1 = x2 = borderValue;\n    }\n    ctx.save();\n    ctx.lineWidth = borderOpts.borderWidth;\n    ctx.strokeStyle = borderOpts.borderColor;\n    ctx.beginPath();\n    ctx.moveTo(x1, y1);\n    ctx.lineTo(x2, y2);\n    ctx.stroke();\n    ctx.restore();\n  }\n  drawLabels(chartArea) {\n    const me = this;\n    const optionTicks = me.options.ticks;\n    if (!optionTicks.display) {\n      return;\n    }\n    const ctx = me.ctx;\n    const area = me._computeLabelArea();\n    if (area) {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.U)(ctx, area);\n    }\n    const items = me._labelItems || (me._labelItems = me._computeLabelItems(chartArea));\n    let i, ilen;\n    for (i = 0, ilen = items.length; i < ilen; ++i) {\n      const item = items[i];\n      const tickFont = item.font;\n      const label = item.label;\n      if (item.backdrop) {\n        ctx.fillStyle = item.backdrop.color;\n        ctx.fillRect(item.backdrop.left, item.backdrop.top, item.backdrop.width, item.backdrop.height);\n      }\n      let y = item.textOffset;\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, label, 0, y, tickFont, item);\n    }\n    if (area) {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.W)(ctx);\n    }\n  }\n  drawTitle() {\n    const {ctx, options: {position, title, reverse}} = this;\n    if (!title.display) {\n      return;\n    }\n    const font = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(title.font);\n    const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(title.padding);\n    const align = title.align;\n    let offset = font.lineHeight / 2;\n    if (position === 'bottom' || position === 'center' || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {\n      offset += padding.bottom;\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(title.text)) {\n        offset += font.lineHeight * (title.text.length - 1);\n      }\n    } else {\n      offset += padding.top;\n    }\n    const {titleX, titleY, maxWidth, rotation} = titleArgs(this, offset, position, align);\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, title.text, 0, 0, font, {\n      color: title.color,\n      maxWidth,\n      rotation,\n      textAlign: titleAlign(align, position, reverse),\n      textBaseline: 'middle',\n      translation: [titleX, titleY],\n    });\n  }\n  draw(chartArea) {\n    const me = this;\n    if (!me._isVisible()) {\n      return;\n    }\n    me.drawBackground();\n    me.drawGrid(chartArea);\n    me.drawBorder();\n    me.drawTitle();\n    me.drawLabels(chartArea);\n  }\n  _layers() {\n    const me = this;\n    const opts = me.options;\n    const tz = opts.ticks && opts.ticks.z || 0;\n    const gz = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(opts.grid && opts.grid.z, -1);\n    if (!me._isVisible() || me.draw !== Scale.prototype.draw) {\n      return [{\n        z: tz,\n        draw(chartArea) {\n          me.draw(chartArea);\n        }\n      }];\n    }\n    return [{\n      z: gz,\n      draw(chartArea) {\n        me.drawBackground();\n        me.drawGrid(chartArea);\n        me.drawTitle();\n      }\n    }, {\n      z: gz + 1,\n      draw() {\n        me.drawBorder();\n      }\n    }, {\n      z: tz,\n      draw(chartArea) {\n        me.drawLabels(chartArea);\n      }\n    }];\n  }\n  getMatchingVisibleMetas(type) {\n    const me = this;\n    const metas = me.chart.getSortedVisibleDatasetMetas();\n    const axisID = me.axis + 'AxisID';\n    const result = [];\n    let i, ilen;\n    for (i = 0, ilen = metas.length; i < ilen; ++i) {\n      const meta = metas[i];\n      if (meta[axisID] === me.id && (!type || meta.type === type)) {\n        result.push(meta);\n      }\n    }\n    return result;\n  }\n  _resolveTickFontOptions(index) {\n    const opts = this.options.ticks.setContext(this.getContext(index));\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(opts.font);\n  }\n  _maxDigits() {\n    const me = this;\n    const fontSize = me._resolveTickFontOptions(0).lineHeight;\n    return (me.isHorizontal() ? me.width : me.height) / fontSize;\n  }\n}\n\nclass TypedRegistry {\n  constructor(type, scope, override) {\n    this.type = type;\n    this.scope = scope;\n    this.override = override;\n    this.items = Object.create(null);\n  }\n  isForType(type) {\n    return Object.prototype.isPrototypeOf.call(this.type.prototype, type.prototype);\n  }\n  register(item) {\n    const me = this;\n    const proto = Object.getPrototypeOf(item);\n    let parentScope;\n    if (isIChartComponent(proto)) {\n      parentScope = me.register(proto);\n    }\n    const items = me.items;\n    const id = item.id;\n    const scope = me.scope + '.' + id;\n    if (!id) {\n      throw new Error('class does not have id: ' + item);\n    }\n    if (id in items) {\n      return scope;\n    }\n    items[id] = item;\n    registerDefaults(item, scope, parentScope);\n    if (me.override) {\n      _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.override(item.id, item.overrides);\n    }\n    return scope;\n  }\n  get(id) {\n    return this.items[id];\n  }\n  unregister(item) {\n    const items = this.items;\n    const id = item.id;\n    const scope = this.scope;\n    if (id in items) {\n      delete items[id];\n    }\n    if (scope && id in _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d[scope]) {\n      delete _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d[scope][id];\n      if (this.override) {\n        delete _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$[id];\n      }\n    }\n  }\n}\nfunction registerDefaults(item, scope, parentScope) {\n  const itemDefaults = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(Object.create(null), [\n    parentScope ? _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.get(parentScope) : {},\n    _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.get(scope),\n    item.defaults\n  ]);\n  _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.set(scope, itemDefaults);\n  if (item.defaultRoutes) {\n    routeDefaults(scope, item.defaultRoutes);\n  }\n  if (item.descriptors) {\n    _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.describe(scope, item.descriptors);\n  }\n}\nfunction routeDefaults(scope, routes) {\n  Object.keys(routes).forEach(property => {\n    const propertyParts = property.split('.');\n    const sourceName = propertyParts.pop();\n    const sourceScope = [scope].concat(propertyParts).join('.');\n    const parts = routes[property].split('.');\n    const targetName = parts.pop();\n    const targetScope = parts.join('.');\n    _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.route(sourceScope, sourceName, targetScope, targetName);\n  });\n}\nfunction isIChartComponent(proto) {\n  return 'id' in proto && 'defaults' in proto;\n}\n\nclass Registry {\n  constructor() {\n    this.controllers = new TypedRegistry(DatasetController, 'datasets', true);\n    this.elements = new TypedRegistry(Element, 'elements');\n    this.plugins = new TypedRegistry(Object, 'plugins');\n    this.scales = new TypedRegistry(Scale, 'scales');\n    this._typedRegistries = [this.controllers, this.scales, this.elements];\n  }\n  add(...args) {\n    this._each('register', args);\n  }\n  remove(...args) {\n    this._each('unregister', args);\n  }\n  addControllers(...args) {\n    this._each('register', args, this.controllers);\n  }\n  addElements(...args) {\n    this._each('register', args, this.elements);\n  }\n  addPlugins(...args) {\n    this._each('register', args, this.plugins);\n  }\n  addScales(...args) {\n    this._each('register', args, this.scales);\n  }\n  getController(id) {\n    return this._get(id, this.controllers, 'controller');\n  }\n  getElement(id) {\n    return this._get(id, this.elements, 'element');\n  }\n  getPlugin(id) {\n    return this._get(id, this.plugins, 'plugin');\n  }\n  getScale(id) {\n    return this._get(id, this.scales, 'scale');\n  }\n  removeControllers(...args) {\n    this._each('unregister', args, this.controllers);\n  }\n  removeElements(...args) {\n    this._each('unregister', args, this.elements);\n  }\n  removePlugins(...args) {\n    this._each('unregister', args, this.plugins);\n  }\n  removeScales(...args) {\n    this._each('unregister', args, this.scales);\n  }\n  _each(method, args, typedRegistry) {\n    const me = this;\n    [...args].forEach(arg => {\n      const reg = typedRegistry || me._getRegistryForType(arg);\n      if (typedRegistry || reg.isForType(arg) || (reg === me.plugins && arg.id)) {\n        me._exec(method, reg, arg);\n      } else {\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(arg, item => {\n          const itemReg = typedRegistry || me._getRegistryForType(item);\n          me._exec(method, itemReg, item);\n        });\n      }\n    });\n  }\n  _exec(method, registry, component) {\n    const camelMethod = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a1)(method);\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(component['before' + camelMethod], [], component);\n    registry[method](component);\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(component['after' + camelMethod], [], component);\n  }\n  _getRegistryForType(type) {\n    for (let i = 0; i < this._typedRegistries.length; i++) {\n      const reg = this._typedRegistries[i];\n      if (reg.isForType(type)) {\n        return reg;\n      }\n    }\n    return this.plugins;\n  }\n  _get(id, typedRegistry, type) {\n    const item = typedRegistry.get(id);\n    if (item === undefined) {\n      throw new Error('\"' + id + '\" is not a registered ' + type + '.');\n    }\n    return item;\n  }\n}\nvar registry = new Registry();\n\nclass PluginService {\n  constructor() {\n    this._init = [];\n  }\n  notify(chart, hook, args, filter) {\n    const me = this;\n    if (hook === 'beforeInit') {\n      me._init = me._createDescriptors(chart, true);\n      me._notify(me._init, chart, 'install');\n    }\n    const descriptors = filter ? me._descriptors(chart).filter(filter) : me._descriptors(chart);\n    const result = me._notify(descriptors, chart, hook, args);\n    if (hook === 'destroy') {\n      me._notify(descriptors, chart, 'stop');\n      me._notify(me._init, chart, 'uninstall');\n    }\n    return result;\n  }\n  _notify(descriptors, chart, hook, args) {\n    args = args || {};\n    for (const descriptor of descriptors) {\n      const plugin = descriptor.plugin;\n      const method = plugin[hook];\n      const params = [chart, args, descriptor.options];\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(method, params, plugin) === false && args.cancelable) {\n        return false;\n      }\n    }\n    return true;\n  }\n  invalidate() {\n    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(this._cache)) {\n      this._oldCache = this._cache;\n      this._cache = undefined;\n    }\n  }\n  _descriptors(chart) {\n    if (this._cache) {\n      return this._cache;\n    }\n    const descriptors = this._cache = this._createDescriptors(chart);\n    this._notifyStateChanges(chart);\n    return descriptors;\n  }\n  _createDescriptors(chart, all) {\n    const config = chart && chart.config;\n    const options = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(config.options && config.options.plugins, {});\n    const plugins = allPlugins(config);\n    return options === false && !all ? [] : createDescriptors(chart, plugins, options, all);\n  }\n  _notifyStateChanges(chart) {\n    const previousDescriptors = this._oldCache || [];\n    const descriptors = this._cache;\n    const diff = (a, b) => a.filter(x => !b.some(y => x.plugin.id === y.plugin.id));\n    this._notify(diff(previousDescriptors, descriptors), chart, 'stop');\n    this._notify(diff(descriptors, previousDescriptors), chart, 'start');\n  }\n}\nfunction allPlugins(config) {\n  const plugins = [];\n  const keys = Object.keys(registry.plugins.items);\n  for (let i = 0; i < keys.length; i++) {\n    plugins.push(registry.getPlugin(keys[i]));\n  }\n  const local = config.plugins || [];\n  for (let i = 0; i < local.length; i++) {\n    const plugin = local[i];\n    if (plugins.indexOf(plugin) === -1) {\n      plugins.push(plugin);\n    }\n  }\n  return plugins;\n}\nfunction getOpts(options, all) {\n  if (!all && options === false) {\n    return null;\n  }\n  if (options === true) {\n    return {};\n  }\n  return options;\n}\nfunction createDescriptors(chart, plugins, options, all) {\n  const result = [];\n  const context = chart.getContext();\n  for (let i = 0; i < plugins.length; i++) {\n    const plugin = plugins[i];\n    const id = plugin.id;\n    const opts = getOpts(options[id], all);\n    if (opts === null) {\n      continue;\n    }\n    result.push({\n      plugin,\n      options: pluginOpts(chart.config, plugin, opts, context)\n    });\n  }\n  return result;\n}\nfunction pluginOpts(config, plugin, opts, context) {\n  const keys = config.pluginScopeKeys(plugin);\n  const scopes = config.getOptionScopes(opts, keys);\n  return config.createResolver(scopes, context, [''], {scriptable: false, indexable: false, allKeys: true});\n}\n\nfunction getIndexAxis(type, options) {\n  const datasetDefaults = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.datasets[type] || {};\n  const datasetOptions = (options.datasets || {})[type] || {};\n  return datasetOptions.indexAxis || options.indexAxis || datasetDefaults.indexAxis || 'x';\n}\nfunction getAxisFromDefaultScaleID(id, indexAxis) {\n  let axis = id;\n  if (id === '_index_') {\n    axis = indexAxis;\n  } else if (id === '_value_') {\n    axis = indexAxis === 'x' ? 'y' : 'x';\n  }\n  return axis;\n}\nfunction getDefaultScaleIDFromAxis(axis, indexAxis) {\n  return axis === indexAxis ? '_index_' : '_value_';\n}\nfunction axisFromPosition(position) {\n  if (position === 'top' || position === 'bottom') {\n    return 'x';\n  }\n  if (position === 'left' || position === 'right') {\n    return 'y';\n  }\n}\nfunction determineAxis(id, scaleOptions) {\n  if (id === 'x' || id === 'y') {\n    return id;\n  }\n  return scaleOptions.axis || axisFromPosition(scaleOptions.position) || id.charAt(0).toLowerCase();\n}\nfunction mergeScaleConfig(config, options) {\n  const chartDefaults = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$[config.type] || {scales: {}};\n  const configScales = options.scales || {};\n  const chartIndexAxis = getIndexAxis(config.type, options);\n  const firstIDs = Object.create(null);\n  const scales = Object.create(null);\n  Object.keys(configScales).forEach(id => {\n    const scaleConf = configScales[id];\n    const axis = determineAxis(id, scaleConf);\n    const defaultId = getDefaultScaleIDFromAxis(axis, chartIndexAxis);\n    const defaultScaleOptions = chartDefaults.scales || {};\n    firstIDs[axis] = firstIDs[axis] || id;\n    scales[id] = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a7)(Object.create(null), [{axis}, scaleConf, defaultScaleOptions[axis], defaultScaleOptions[defaultId]]);\n  });\n  config.data.datasets.forEach(dataset => {\n    const type = dataset.type || config.type;\n    const indexAxis = dataset.indexAxis || getIndexAxis(type, options);\n    const datasetDefaults = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$[type] || {};\n    const defaultScaleOptions = datasetDefaults.scales || {};\n    Object.keys(defaultScaleOptions).forEach(defaultID => {\n      const axis = getAxisFromDefaultScaleID(defaultID, indexAxis);\n      const id = dataset[axis + 'AxisID'] || firstIDs[axis] || axis;\n      scales[id] = scales[id] || Object.create(null);\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a7)(scales[id], [{axis}, configScales[id], defaultScaleOptions[defaultID]]);\n    });\n  });\n  Object.keys(scales).forEach(key => {\n    const scale = scales[key];\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a7)(scale, [_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.scales[scale.type], _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.scale]);\n  });\n  return scales;\n}\nfunction initOptions(config) {\n  const options = config.options || (config.options = {});\n  options.plugins = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.plugins, {});\n  options.scales = mergeScaleConfig(config, options);\n}\nfunction initData(data) {\n  data = data || {};\n  data.datasets = data.datasets || [];\n  data.labels = data.labels || [];\n  return data;\n}\nfunction initConfig(config) {\n  config = config || {};\n  config.data = initData(config.data);\n  initOptions(config);\n  return config;\n}\nconst keyCache = new Map();\nconst keysCached = new Set();\nfunction cachedKeys(cacheKey, generate) {\n  let keys = keyCache.get(cacheKey);\n  if (!keys) {\n    keys = generate();\n    keyCache.set(cacheKey, keys);\n    keysCached.add(keys);\n  }\n  return keys;\n}\nconst addIfFound = (set, obj, key) => {\n  const opts = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(obj, key);\n  if (opts !== undefined) {\n    set.add(opts);\n  }\n};\nclass Config {\n  constructor(config) {\n    this._config = initConfig(config);\n    this._scopeCache = new Map();\n    this._resolverCache = new Map();\n  }\n  get platform() {\n    return this._config.platform;\n  }\n  get type() {\n    return this._config.type;\n  }\n  set type(type) {\n    this._config.type = type;\n  }\n  get data() {\n    return this._config.data;\n  }\n  set data(data) {\n    this._config.data = initData(data);\n  }\n  get options() {\n    return this._config.options;\n  }\n  set options(options) {\n    this._config.options = options;\n  }\n  get plugins() {\n    return this._config.plugins;\n  }\n  update() {\n    const config = this._config;\n    this.clearCache();\n    initOptions(config);\n  }\n  clearCache() {\n    this._scopeCache.clear();\n    this._resolverCache.clear();\n  }\n  datasetScopeKeys(datasetType) {\n    return cachedKeys(datasetType,\n      () => [[\n        `datasets.${datasetType}`,\n        ''\n      ]]);\n  }\n  datasetAnimationScopeKeys(datasetType, transition) {\n    return cachedKeys(`${datasetType}.transition.${transition}`,\n      () => [\n        [\n          `datasets.${datasetType}.transitions.${transition}`,\n          `transitions.${transition}`,\n        ],\n        [\n          `datasets.${datasetType}`,\n          ''\n        ]\n      ]);\n  }\n  datasetElementScopeKeys(datasetType, elementType) {\n    return cachedKeys(`${datasetType}-${elementType}`,\n      () => [[\n        `datasets.${datasetType}.elements.${elementType}`,\n        `datasets.${datasetType}`,\n        `elements.${elementType}`,\n        ''\n      ]]);\n  }\n  pluginScopeKeys(plugin) {\n    const id = plugin.id;\n    const type = this.type;\n    return cachedKeys(`${type}-plugin-${id}`,\n      () => [[\n        `plugins.${id}`,\n        ...plugin.additionalOptionScopes || [],\n      ]]);\n  }\n  _cachedScopes(mainScope, resetCache) {\n    const _scopeCache = this._scopeCache;\n    let cache = _scopeCache.get(mainScope);\n    if (!cache || resetCache) {\n      cache = new Map();\n      _scopeCache.set(mainScope, cache);\n    }\n    return cache;\n  }\n  getOptionScopes(mainScope, keyLists, resetCache) {\n    const {options, type} = this;\n    const cache = this._cachedScopes(mainScope, resetCache);\n    const cached = cache.get(keyLists);\n    if (cached) {\n      return cached;\n    }\n    const scopes = new Set();\n    keyLists.forEach(keys => {\n      if (mainScope) {\n        scopes.add(mainScope);\n        keys.forEach(key => addIfFound(scopes, mainScope, key));\n      }\n      keys.forEach(key => addIfFound(scopes, options, key));\n      keys.forEach(key => addIfFound(scopes, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$[type] || {}, key));\n      keys.forEach(key => addIfFound(scopes, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d, key));\n      keys.forEach(key => addIfFound(scopes, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2, key));\n    });\n    const array = Array.from(scopes);\n    if (array.length === 0) {\n      array.push(Object.create(null));\n    }\n    if (keysCached.has(keyLists)) {\n      cache.set(keyLists, array);\n    }\n    return array;\n  }\n  chartOptionScopes() {\n    const {options, type} = this;\n    return [\n      options,\n      _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$[type] || {},\n      _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.datasets[type] || {},\n      {type},\n      _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d,\n      _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2\n    ];\n  }\n  resolveNamedOptions(scopes, names, context, prefixes = ['']) {\n    const result = {$shared: true};\n    const {resolver, subPrefixes} = getResolver(this._resolverCache, scopes, prefixes);\n    let options = resolver;\n    if (needContext(resolver, names)) {\n      result.$shared = false;\n      context = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a3)(context) ? context() : context;\n      const subResolver = this.createResolver(scopes, context, subPrefixes);\n      options = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a4)(resolver, context, subResolver);\n    }\n    for (const prop of names) {\n      result[prop] = options[prop];\n    }\n    return result;\n  }\n  createResolver(scopes, context, prefixes = [''], descriptorDefaults) {\n    const {resolver} = getResolver(this._resolverCache, scopes, prefixes);\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(context)\n      ? (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a4)(resolver, context, undefined, descriptorDefaults)\n      : resolver;\n  }\n}\nfunction getResolver(resolverCache, scopes, prefixes) {\n  let cache = resolverCache.get(scopes);\n  if (!cache) {\n    cache = new Map();\n    resolverCache.set(scopes, cache);\n  }\n  const cacheKey = prefixes.join();\n  let cached = cache.get(cacheKey);\n  if (!cached) {\n    const resolver = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a5)(scopes, prefixes);\n    cached = {\n      resolver,\n      subPrefixes: prefixes.filter(p => !p.toLowerCase().includes('hover'))\n    };\n    cache.set(cacheKey, cached);\n  }\n  return cached;\n}\nfunction needContext(proxy, names) {\n  const {isScriptable, isIndexable} = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a6)(proxy);\n  for (const prop of names) {\n    if ((isScriptable(prop) && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a3)(proxy[prop]))\n      || (isIndexable(prop) && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(proxy[prop]))) {\n      return true;\n    }\n  }\n  return false;\n}\n\nvar version = \"3.5.1\";\n\nconst KNOWN_POSITIONS = ['top', 'bottom', 'left', 'right', 'chartArea'];\nfunction positionIsHorizontal(position, axis) {\n  return position === 'top' || position === 'bottom' || (KNOWN_POSITIONS.indexOf(position) === -1 && axis === 'x');\n}\nfunction compare2Level(l1, l2) {\n  return function(a, b) {\n    return a[l1] === b[l1]\n      ? a[l2] - b[l2]\n      : a[l1] - b[l1];\n  };\n}\nfunction onAnimationsComplete(context) {\n  const chart = context.chart;\n  const animationOptions = chart.options.animation;\n  chart.notifyPlugins('afterRender');\n  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(animationOptions && animationOptions.onComplete, [context], chart);\n}\nfunction onAnimationProgress(context) {\n  const chart = context.chart;\n  const animationOptions = chart.options.animation;\n  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(animationOptions && animationOptions.onProgress, [context], chart);\n}\nfunction getCanvas(item) {\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.I)() && typeof item === 'string') {\n    item = document.getElementById(item);\n  } else if (item && item.length) {\n    item = item[0];\n  }\n  if (item && item.canvas) {\n    item = item.canvas;\n  }\n  return item;\n}\nconst instances = {};\nconst getChart = (key) => {\n  const canvas = getCanvas(key);\n  return Object.values(instances).filter((c) => c.canvas === canvas).pop();\n};\nclass Chart {\n  constructor(item, userConfig) {\n    const me = this;\n    const config = this.config = new Config(userConfig);\n    const initialCanvas = getCanvas(item);\n    const existingChart = getChart(initialCanvas);\n    if (existingChart) {\n      throw new Error(\n        'Canvas is already in use. Chart with ID \\'' + existingChart.id + '\\'' +\n\t\t\t\t' must be destroyed before the canvas can be reused.'\n      );\n    }\n    const options = config.createResolver(config.chartOptionScopes(), me.getContext());\n    this.platform = new (config.platform || _detectPlatform(initialCanvas))();\n    const context = me.platform.acquireContext(initialCanvas, options.aspectRatio);\n    const canvas = context && context.canvas;\n    const height = canvas && canvas.height;\n    const width = canvas && canvas.width;\n    this.id = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a8)();\n    this.ctx = context;\n    this.canvas = canvas;\n    this.width = width;\n    this.height = height;\n    this._options = options;\n    this._aspectRatio = this.aspectRatio;\n    this._layers = [];\n    this._metasets = [];\n    this._stacks = undefined;\n    this.boxes = [];\n    this.currentDevicePixelRatio = undefined;\n    this.chartArea = undefined;\n    this._active = [];\n    this._lastEvent = undefined;\n    this._listeners = {};\n    this._responsiveListeners = undefined;\n    this._sortedMetasets = [];\n    this.scales = {};\n    this._plugins = new PluginService();\n    this.$proxies = {};\n    this._hiddenIndices = {};\n    this.attached = false;\n    this._animationsDisabled = undefined;\n    this.$context = undefined;\n    this._doResize = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a9)(() => this.update('resize'), options.resizeDelay || 0);\n    instances[me.id] = me;\n    if (!context || !canvas) {\n      console.error(\"Failed to create chart: can't acquire context from the given item\");\n      return;\n    }\n    animator.listen(me, 'complete', onAnimationsComplete);\n    animator.listen(me, 'progress', onAnimationProgress);\n    me._initialize();\n    if (me.attached) {\n      me.update();\n    }\n  }\n  get aspectRatio() {\n    const {options: {aspectRatio, maintainAspectRatio}, width, height, _aspectRatio} = this;\n    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(aspectRatio)) {\n      return aspectRatio;\n    }\n    if (maintainAspectRatio && _aspectRatio) {\n      return _aspectRatio;\n    }\n    return height ? width / height : null;\n  }\n  get data() {\n    return this.config.data;\n  }\n  set data(data) {\n    this.config.data = data;\n  }\n  get options() {\n    return this._options;\n  }\n  set options(options) {\n    this.config.options = options;\n  }\n  _initialize() {\n    const me = this;\n    me.notifyPlugins('beforeInit');\n    if (me.options.responsive) {\n      me.resize();\n    } else {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aa)(me, me.options.devicePixelRatio);\n    }\n    me.bindEvents();\n    me.notifyPlugins('afterInit');\n    return me;\n  }\n  clear() {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ab)(this.canvas, this.ctx);\n    return this;\n  }\n  stop() {\n    animator.stop(this);\n    return this;\n  }\n  resize(width, height) {\n    if (!animator.running(this)) {\n      this._resize(width, height);\n    } else {\n      this._resizeBeforeDraw = {width, height};\n    }\n  }\n  _resize(width, height) {\n    const me = this;\n    const options = me.options;\n    const canvas = me.canvas;\n    const aspectRatio = options.maintainAspectRatio && me.aspectRatio;\n    const newSize = me.platform.getMaximumSize(canvas, width, height, aspectRatio);\n    const newRatio = options.devicePixelRatio || me.platform.getDevicePixelRatio();\n    me.width = newSize.width;\n    me.height = newSize.height;\n    me._aspectRatio = me.aspectRatio;\n    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aa)(me, newRatio, true)) {\n      return;\n    }\n    me.notifyPlugins('resize', {size: newSize});\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(options.onResize, [me, newSize], me);\n    if (me.attached) {\n      if (me._doResize()) {\n        me.render();\n      }\n    }\n  }\n  ensureScalesHaveIDs() {\n    const options = this.options;\n    const scalesOptions = options.scales || {};\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(scalesOptions, (axisOptions, axisID) => {\n      axisOptions.id = axisID;\n    });\n  }\n  buildOrUpdateScales() {\n    const me = this;\n    const options = me.options;\n    const scaleOpts = options.scales;\n    const scales = me.scales;\n    const updated = Object.keys(scales).reduce((obj, id) => {\n      obj[id] = false;\n      return obj;\n    }, {});\n    let items = [];\n    if (scaleOpts) {\n      items = items.concat(\n        Object.keys(scaleOpts).map((id) => {\n          const scaleOptions = scaleOpts[id];\n          const axis = determineAxis(id, scaleOptions);\n          const isRadial = axis === 'r';\n          const isHorizontal = axis === 'x';\n          return {\n            options: scaleOptions,\n            dposition: isRadial ? 'chartArea' : isHorizontal ? 'bottom' : 'left',\n            dtype: isRadial ? 'radialLinear' : isHorizontal ? 'category' : 'linear'\n          };\n        })\n      );\n    }\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(items, (item) => {\n      const scaleOptions = item.options;\n      const id = scaleOptions.id;\n      const axis = determineAxis(id, scaleOptions);\n      const scaleType = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(scaleOptions.type, item.dtype);\n      if (scaleOptions.position === undefined || positionIsHorizontal(scaleOptions.position, axis) !== positionIsHorizontal(item.dposition)) {\n        scaleOptions.position = item.dposition;\n      }\n      updated[id] = true;\n      let scale = null;\n      if (id in scales && scales[id].type === scaleType) {\n        scale = scales[id];\n      } else {\n        const scaleClass = registry.getScale(scaleType);\n        scale = new scaleClass({\n          id,\n          type: scaleType,\n          ctx: me.ctx,\n          chart: me\n        });\n        scales[scale.id] = scale;\n      }\n      scale.init(scaleOptions, options);\n    });\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(updated, (hasUpdated, id) => {\n      if (!hasUpdated) {\n        delete scales[id];\n      }\n    });\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(scales, (scale) => {\n      layouts.configure(me, scale, scale.options);\n      layouts.addBox(me, scale);\n    });\n  }\n  _updateMetasets() {\n    const me = this;\n    const metasets = me._metasets;\n    const numData = me.data.datasets.length;\n    const numMeta = metasets.length;\n    metasets.sort((a, b) => a.index - b.index);\n    if (numMeta > numData) {\n      for (let i = numData; i < numMeta; ++i) {\n        me._destroyDatasetMeta(i);\n      }\n      metasets.splice(numData, numMeta - numData);\n    }\n    me._sortedMetasets = metasets.slice(0).sort(compare2Level('order', 'index'));\n  }\n  _removeUnreferencedMetasets() {\n    const me = this;\n    const {_metasets: metasets, data: {datasets}} = me;\n    if (metasets.length > datasets.length) {\n      delete me._stacks;\n    }\n    metasets.forEach((meta, index) => {\n      if (datasets.filter(x => x === meta._dataset).length === 0) {\n        me._destroyDatasetMeta(index);\n      }\n    });\n  }\n  buildOrUpdateControllers() {\n    const me = this;\n    const newControllers = [];\n    const datasets = me.data.datasets;\n    let i, ilen;\n    me._removeUnreferencedMetasets();\n    for (i = 0, ilen = datasets.length; i < ilen; i++) {\n      const dataset = datasets[i];\n      let meta = me.getDatasetMeta(i);\n      const type = dataset.type || me.config.type;\n      if (meta.type && meta.type !== type) {\n        me._destroyDatasetMeta(i);\n        meta = me.getDatasetMeta(i);\n      }\n      meta.type = type;\n      meta.indexAxis = dataset.indexAxis || getIndexAxis(type, me.options);\n      meta.order = dataset.order || 0;\n      meta.index = i;\n      meta.label = '' + dataset.label;\n      meta.visible = me.isDatasetVisible(i);\n      if (meta.controller) {\n        meta.controller.updateIndex(i);\n        meta.controller.linkScales();\n      } else {\n        const ControllerClass = registry.getController(type);\n        const {datasetElementType, dataElementType} = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.datasets[type];\n        Object.assign(ControllerClass.prototype, {\n          dataElementType: registry.getElement(dataElementType),\n          datasetElementType: datasetElementType && registry.getElement(datasetElementType)\n        });\n        meta.controller = new ControllerClass(me, i);\n        newControllers.push(meta.controller);\n      }\n    }\n    me._updateMetasets();\n    return newControllers;\n  }\n  _resetElements() {\n    const me = this;\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(me.data.datasets, (dataset, datasetIndex) => {\n      me.getDatasetMeta(datasetIndex).controller.reset();\n    }, me);\n  }\n  reset() {\n    this._resetElements();\n    this.notifyPlugins('reset');\n  }\n  update(mode) {\n    const me = this;\n    const config = me.config;\n    config.update();\n    me._options = config.createResolver(config.chartOptionScopes(), me.getContext());\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(me.scales, (scale) => {\n      layouts.removeBox(me, scale);\n    });\n    const animsDisabled = me._animationsDisabled = !me.options.animation;\n    me.ensureScalesHaveIDs();\n    me.buildOrUpdateScales();\n    const existingEvents = new Set(Object.keys(me._listeners));\n    const newEvents = new Set(me.options.events);\n    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ac)(existingEvents, newEvents) || !!this._responsiveListeners !== me.options.responsive) {\n      me.unbindEvents();\n      me.bindEvents();\n    }\n    me._plugins.invalidate();\n    if (me.notifyPlugins('beforeUpdate', {mode, cancelable: true}) === false) {\n      return;\n    }\n    const newControllers = me.buildOrUpdateControllers();\n    me.notifyPlugins('beforeElementsUpdate');\n    let minPadding = 0;\n    for (let i = 0, ilen = me.data.datasets.length; i < ilen; i++) {\n      const {controller} = me.getDatasetMeta(i);\n      const reset = !animsDisabled && newControllers.indexOf(controller) === -1;\n      controller.buildOrUpdateElements(reset);\n      minPadding = Math.max(+controller.getMaxOverflow(), minPadding);\n    }\n    me._minPadding = minPadding;\n    me._updateLayout(minPadding);\n    if (!animsDisabled) {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(newControllers, (controller) => {\n        controller.reset();\n      });\n    }\n    me._updateDatasets(mode);\n    me.notifyPlugins('afterUpdate', {mode});\n    me._layers.sort(compare2Level('z', '_idx'));\n    if (me._lastEvent) {\n      me._eventHandler(me._lastEvent, true);\n    }\n    me.render();\n  }\n  _updateLayout(minPadding) {\n    const me = this;\n    if (me.notifyPlugins('beforeLayout', {cancelable: true}) === false) {\n      return;\n    }\n    layouts.update(me, me.width, me.height, minPadding);\n    const area = me.chartArea;\n    const noArea = area.width <= 0 || area.height <= 0;\n    me._layers = [];\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(me.boxes, (box) => {\n      if (noArea && box.position === 'chartArea') {\n        return;\n      }\n      if (box.configure) {\n        box.configure();\n      }\n      me._layers.push(...box._layers());\n    }, me);\n    me._layers.forEach((item, index) => {\n      item._idx = index;\n    });\n    me.notifyPlugins('afterLayout');\n  }\n  _updateDatasets(mode) {\n    const me = this;\n    const isFunction = typeof mode === 'function';\n    if (me.notifyPlugins('beforeDatasetsUpdate', {mode, cancelable: true}) === false) {\n      return;\n    }\n    for (let i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {\n      me._updateDataset(i, isFunction ? mode({datasetIndex: i}) : mode);\n    }\n    me.notifyPlugins('afterDatasetsUpdate', {mode});\n  }\n  _updateDataset(index, mode) {\n    const me = this;\n    const meta = me.getDatasetMeta(index);\n    const args = {meta, index, mode, cancelable: true};\n    if (me.notifyPlugins('beforeDatasetUpdate', args) === false) {\n      return;\n    }\n    meta.controller._update(mode);\n    args.cancelable = false;\n    me.notifyPlugins('afterDatasetUpdate', args);\n  }\n  render() {\n    const me = this;\n    if (me.notifyPlugins('beforeRender', {cancelable: true}) === false) {\n      return;\n    }\n    if (animator.has(me)) {\n      if (me.attached && !animator.running(me)) {\n        animator.start(me);\n      }\n    } else {\n      me.draw();\n      onAnimationsComplete({chart: me});\n    }\n  }\n  draw() {\n    const me = this;\n    let i;\n    if (me._resizeBeforeDraw) {\n      const {width, height} = me._resizeBeforeDraw;\n      me._resize(width, height);\n      me._resizeBeforeDraw = null;\n    }\n    me.clear();\n    if (me.width <= 0 || me.height <= 0) {\n      return;\n    }\n    if (me.notifyPlugins('beforeDraw', {cancelable: true}) === false) {\n      return;\n    }\n    const layers = me._layers;\n    for (i = 0; i < layers.length && layers[i].z <= 0; ++i) {\n      layers[i].draw(me.chartArea);\n    }\n    me._drawDatasets();\n    for (; i < layers.length; ++i) {\n      layers[i].draw(me.chartArea);\n    }\n    me.notifyPlugins('afterDraw');\n  }\n  _getSortedDatasetMetas(filterVisible) {\n    const me = this;\n    const metasets = me._sortedMetasets;\n    const result = [];\n    let i, ilen;\n    for (i = 0, ilen = metasets.length; i < ilen; ++i) {\n      const meta = metasets[i];\n      if (!filterVisible || meta.visible) {\n        result.push(meta);\n      }\n    }\n    return result;\n  }\n  getSortedVisibleDatasetMetas() {\n    return this._getSortedDatasetMetas(true);\n  }\n  _drawDatasets() {\n    const me = this;\n    if (me.notifyPlugins('beforeDatasetsDraw', {cancelable: true}) === false) {\n      return;\n    }\n    const metasets = me.getSortedVisibleDatasetMetas();\n    for (let i = metasets.length - 1; i >= 0; --i) {\n      me._drawDataset(metasets[i]);\n    }\n    me.notifyPlugins('afterDatasetsDraw');\n  }\n  _drawDataset(meta) {\n    const me = this;\n    const ctx = me.ctx;\n    const clip = meta._clip;\n    const useClip = !clip.disabled;\n    const area = me.chartArea;\n    const args = {\n      meta,\n      index: meta.index,\n      cancelable: true\n    };\n    if (me.notifyPlugins('beforeDatasetDraw', args) === false) {\n      return;\n    }\n    if (useClip) {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.U)(ctx, {\n        left: clip.left === false ? 0 : area.left - clip.left,\n        right: clip.right === false ? me.width : area.right + clip.right,\n        top: clip.top === false ? 0 : area.top - clip.top,\n        bottom: clip.bottom === false ? me.height : area.bottom + clip.bottom\n      });\n    }\n    meta.controller.draw();\n    if (useClip) {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.W)(ctx);\n    }\n    args.cancelable = false;\n    me.notifyPlugins('afterDatasetDraw', args);\n  }\n  getElementsAtEventForMode(e, mode, options, useFinalPosition) {\n    const method = Interaction.modes[mode];\n    if (typeof method === 'function') {\n      return method(this, e, options, useFinalPosition);\n    }\n    return [];\n  }\n  getDatasetMeta(datasetIndex) {\n    const me = this;\n    const dataset = me.data.datasets[datasetIndex];\n    const metasets = me._metasets;\n    let meta = metasets.filter(x => x && x._dataset === dataset).pop();\n    if (!meta) {\n      meta = {\n        type: null,\n        data: [],\n        dataset: null,\n        controller: null,\n        hidden: null,\n        xAxisID: null,\n        yAxisID: null,\n        order: dataset && dataset.order || 0,\n        index: datasetIndex,\n        _dataset: dataset,\n        _parsed: [],\n        _sorted: false\n      };\n      metasets.push(meta);\n    }\n    return meta;\n  }\n  getContext() {\n    return this.$context || (this.$context = {chart: this, type: 'chart'});\n  }\n  getVisibleDatasetCount() {\n    return this.getSortedVisibleDatasetMetas().length;\n  }\n  isDatasetVisible(datasetIndex) {\n    const dataset = this.data.datasets[datasetIndex];\n    if (!dataset) {\n      return false;\n    }\n    const meta = this.getDatasetMeta(datasetIndex);\n    return typeof meta.hidden === 'boolean' ? !meta.hidden : !dataset.hidden;\n  }\n  setDatasetVisibility(datasetIndex, visible) {\n    const meta = this.getDatasetMeta(datasetIndex);\n    meta.hidden = !visible;\n  }\n  toggleDataVisibility(index) {\n    this._hiddenIndices[index] = !this._hiddenIndices[index];\n  }\n  getDataVisibility(index) {\n    return !this._hiddenIndices[index];\n  }\n  _updateVisibility(datasetIndex, dataIndex, visible) {\n    const me = this;\n    const mode = visible ? 'show' : 'hide';\n    const meta = me.getDatasetMeta(datasetIndex);\n    const anims = meta.controller._resolveAnimations(undefined, mode);\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(dataIndex)) {\n      meta.data[dataIndex].hidden = !visible;\n      me.update();\n    } else {\n      me.setDatasetVisibility(datasetIndex, visible);\n      anims.update(meta, {visible});\n      me.update((ctx) => ctx.datasetIndex === datasetIndex ? mode : undefined);\n    }\n  }\n  hide(datasetIndex, dataIndex) {\n    this._updateVisibility(datasetIndex, dataIndex, false);\n  }\n  show(datasetIndex, dataIndex) {\n    this._updateVisibility(datasetIndex, dataIndex, true);\n  }\n  _destroyDatasetMeta(datasetIndex) {\n    const me = this;\n    const meta = me._metasets && me._metasets[datasetIndex];\n    if (meta && meta.controller) {\n      meta.controller._destroy();\n      delete me._metasets[datasetIndex];\n    }\n  }\n  destroy() {\n    const me = this;\n    const {canvas, ctx} = me;\n    let i, ilen;\n    me.stop();\n    animator.remove(me);\n    for (i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {\n      me._destroyDatasetMeta(i);\n    }\n    me.config.clearCache();\n    if (canvas) {\n      me.unbindEvents();\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ab)(canvas, ctx);\n      me.platform.releaseContext(ctx);\n      me.canvas = null;\n      me.ctx = null;\n    }\n    me.notifyPlugins('destroy');\n    delete instances[me.id];\n  }\n  toBase64Image(...args) {\n    return this.canvas.toDataURL(...args);\n  }\n  bindEvents() {\n    this.bindUserEvents();\n    if (this.options.responsive) {\n      this.bindResponsiveEvents();\n    } else {\n      this.attached = true;\n    }\n  }\n  bindUserEvents() {\n    const me = this;\n    const listeners = me._listeners;\n    const platform = me.platform;\n    const _add = (type, listener) => {\n      platform.addEventListener(me, type, listener);\n      listeners[type] = listener;\n    };\n    const listener = function(e, x, y) {\n      e.offsetX = x;\n      e.offsetY = y;\n      me._eventHandler(e);\n    };\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(me.options.events, (type) => _add(type, listener));\n  }\n  bindResponsiveEvents() {\n    const me = this;\n    if (!me._responsiveListeners) {\n      me._responsiveListeners = {};\n    }\n    const listeners = me._responsiveListeners;\n    const platform = me.platform;\n    const _add = (type, listener) => {\n      platform.addEventListener(me, type, listener);\n      listeners[type] = listener;\n    };\n    const _remove = (type, listener) => {\n      if (listeners[type]) {\n        platform.removeEventListener(me, type, listener);\n        delete listeners[type];\n      }\n    };\n    const listener = (width, height) => {\n      if (me.canvas) {\n        me.resize(width, height);\n      }\n    };\n    let detached;\n    const attached = () => {\n      _remove('attach', attached);\n      me.attached = true;\n      me.resize();\n      _add('resize', listener);\n      _add('detach', detached);\n    };\n    detached = () => {\n      me.attached = false;\n      _remove('resize', listener);\n      _add('attach', attached);\n    };\n    if (platform.isAttached(me.canvas)) {\n      attached();\n    } else {\n      detached();\n    }\n  }\n  unbindEvents() {\n    const me = this;\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(me._listeners, (listener, type) => {\n      me.platform.removeEventListener(me, type, listener);\n    });\n    me._listeners = {};\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(me._responsiveListeners, (listener, type) => {\n      me.platform.removeEventListener(me, type, listener);\n    });\n    me._responsiveListeners = undefined;\n  }\n  updateHoverStyle(items, mode, enabled) {\n    const prefix = enabled ? 'set' : 'remove';\n    let meta, item, i, ilen;\n    if (mode === 'dataset') {\n      meta = this.getDatasetMeta(items[0].datasetIndex);\n      meta.controller['_' + prefix + 'DatasetHoverStyle']();\n    }\n    for (i = 0, ilen = items.length; i < ilen; ++i) {\n      item = items[i];\n      const controller = item && this.getDatasetMeta(item.datasetIndex).controller;\n      if (controller) {\n        controller[prefix + 'HoverStyle'](item.element, item.datasetIndex, item.index);\n      }\n    }\n  }\n  getActiveElements() {\n    return this._active || [];\n  }\n  setActiveElements(activeElements) {\n    const me = this;\n    const lastActive = me._active || [];\n    const active = activeElements.map(({datasetIndex, index}) => {\n      const meta = me.getDatasetMeta(datasetIndex);\n      if (!meta) {\n        throw new Error('No dataset found at index ' + datasetIndex);\n      }\n      return {\n        datasetIndex,\n        element: meta.data[index],\n        index,\n      };\n    });\n    const changed = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ad)(active, lastActive);\n    if (changed) {\n      me._active = active;\n      me._updateHoverStyles(active, lastActive);\n    }\n  }\n  notifyPlugins(hook, args, filter) {\n    return this._plugins.notify(this, hook, args, filter);\n  }\n  _updateHoverStyles(active, lastActive, replay) {\n    const me = this;\n    const hoverOptions = me.options.hover;\n    const diff = (a, b) => a.filter(x => !b.some(y => x.datasetIndex === y.datasetIndex && x.index === y.index));\n    const deactivated = diff(lastActive, active);\n    const activated = replay ? active : diff(active, lastActive);\n    if (deactivated.length) {\n      me.updateHoverStyle(deactivated, hoverOptions.mode, false);\n    }\n    if (activated.length && hoverOptions.mode) {\n      me.updateHoverStyle(activated, hoverOptions.mode, true);\n    }\n  }\n  _eventHandler(e, replay) {\n    const me = this;\n    const args = {event: e, replay, cancelable: true};\n    const eventFilter = (plugin) => (plugin.options.events || this.options.events).includes(e.type);\n    if (me.notifyPlugins('beforeEvent', args, eventFilter) === false) {\n      return;\n    }\n    const changed = me._handleEvent(e, replay);\n    args.cancelable = false;\n    me.notifyPlugins('afterEvent', args, eventFilter);\n    if (changed || args.changed) {\n      me.render();\n    }\n    return me;\n  }\n  _handleEvent(e, replay) {\n    const me = this;\n    const {_active: lastActive = [], options} = me;\n    const hoverOptions = options.hover;\n    const useFinalPosition = replay;\n    let active = [];\n    let changed = false;\n    let lastEvent = null;\n    if (e.type !== 'mouseout') {\n      active = me.getElementsAtEventForMode(e, hoverOptions.mode, hoverOptions, useFinalPosition);\n      lastEvent = e.type === 'click' ? me._lastEvent : e;\n    }\n    me._lastEvent = null;\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.y)(e, me.chartArea, me._minPadding)) {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(options.onHover, [e, active, me], me);\n      if (e.type === 'mouseup' || e.type === 'click' || e.type === 'contextmenu') {\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(options.onClick, [e, active, me], me);\n      }\n    }\n    changed = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ad)(active, lastActive);\n    if (changed || replay) {\n      me._active = active;\n      me._updateHoverStyles(active, lastActive, replay);\n    }\n    me._lastEvent = lastEvent;\n    return changed;\n  }\n}\nconst invalidatePlugins = () => (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(Chart.instances, (chart) => chart._plugins.invalidate());\nconst enumerable = true;\nObject.defineProperties(Chart, {\n  defaults: {\n    enumerable,\n    value: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d\n  },\n  instances: {\n    enumerable,\n    value: instances\n  },\n  overrides: {\n    enumerable,\n    value: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$\n  },\n  registry: {\n    enumerable,\n    value: registry\n  },\n  version: {\n    enumerable,\n    value: version\n  },\n  getChart: {\n    enumerable,\n    value: getChart\n  },\n  register: {\n    enumerable,\n    value: (...items) => {\n      registry.add(...items);\n      invalidatePlugins();\n    }\n  },\n  unregister: {\n    enumerable,\n    value: (...items) => {\n      registry.remove(...items);\n      invalidatePlugins();\n    }\n  }\n});\n\nfunction clipArc(ctx, element, endAngle) {\n  const {startAngle, pixelMargin, x, y, outerRadius, innerRadius} = element;\n  let angleMargin = pixelMargin / outerRadius;\n  ctx.beginPath();\n  ctx.arc(x, y, outerRadius, startAngle - angleMargin, endAngle + angleMargin);\n  if (innerRadius > pixelMargin) {\n    angleMargin = pixelMargin / innerRadius;\n    ctx.arc(x, y, innerRadius, endAngle + angleMargin, startAngle - angleMargin, true);\n  } else {\n    ctx.arc(x, y, pixelMargin, endAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, startAngle - _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H);\n  }\n  ctx.closePath();\n  ctx.clip();\n}\nfunction toRadiusCorners(value) {\n  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.af)(value, ['outerStart', 'outerEnd', 'innerStart', 'innerEnd']);\n}\nfunction parseBorderRadius$1(arc, innerRadius, outerRadius, angleDelta) {\n  const o = toRadiusCorners(arc.options.borderRadius);\n  const halfThickness = (outerRadius - innerRadius) / 2;\n  const innerLimit = Math.min(halfThickness, angleDelta * innerRadius / 2);\n  const computeOuterLimit = (val) => {\n    const outerArcLimit = (outerRadius - Math.min(halfThickness, val)) * angleDelta / 2;\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(val, 0, Math.min(halfThickness, outerArcLimit));\n  };\n  return {\n    outerStart: computeOuterLimit(o.outerStart),\n    outerEnd: computeOuterLimit(o.outerEnd),\n    innerStart: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(o.innerStart, 0, innerLimit),\n    innerEnd: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(o.innerEnd, 0, innerLimit),\n  };\n}\nfunction rThetaToXY(r, theta, x, y) {\n  return {\n    x: x + r * Math.cos(theta),\n    y: y + r * Math.sin(theta),\n  };\n}\nfunction pathArc(ctx, element, offset, spacing, end) {\n  const {x, y, startAngle: start, pixelMargin, innerRadius: innerR} = element;\n  const outerRadius = Math.max(element.outerRadius + spacing + offset - pixelMargin, 0);\n  const innerRadius = innerR > 0 ? innerR + spacing + offset + pixelMargin : 0;\n  let spacingOffset = 0;\n  const alpha = end - start;\n  if (spacing) {\n    const noSpacingInnerRadius = innerR > 0 ? innerR - spacing : 0;\n    const noSpacingOuterRadius = outerRadius > 0 ? outerRadius - spacing : 0;\n    const avNogSpacingRadius = (noSpacingInnerRadius + noSpacingOuterRadius) / 2;\n    const adjustedAngle = avNogSpacingRadius !== 0 ? (alpha * avNogSpacingRadius) / (avNogSpacingRadius + spacing) : alpha;\n    spacingOffset = (alpha - adjustedAngle) / 2;\n  }\n  const beta = Math.max(0.001, alpha * outerRadius - offset / _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P) / outerRadius;\n  const angleOffset = (alpha - beta) / 2;\n  const startAngle = start + angleOffset + spacingOffset;\n  const endAngle = end - angleOffset - spacingOffset;\n  const {outerStart, outerEnd, innerStart, innerEnd} = parseBorderRadius$1(element, innerRadius, outerRadius, endAngle - startAngle);\n  const outerStartAdjustedRadius = outerRadius - outerStart;\n  const outerEndAdjustedRadius = outerRadius - outerEnd;\n  const outerStartAdjustedAngle = startAngle + outerStart / outerStartAdjustedRadius;\n  const outerEndAdjustedAngle = endAngle - outerEnd / outerEndAdjustedRadius;\n  const innerStartAdjustedRadius = innerRadius + innerStart;\n  const innerEndAdjustedRadius = innerRadius + innerEnd;\n  const innerStartAdjustedAngle = startAngle + innerStart / innerStartAdjustedRadius;\n  const innerEndAdjustedAngle = endAngle - innerEnd / innerEndAdjustedRadius;\n  ctx.beginPath();\n  ctx.arc(x, y, outerRadius, outerStartAdjustedAngle, outerEndAdjustedAngle);\n  if (outerEnd > 0) {\n    const pCenter = rThetaToXY(outerEndAdjustedRadius, outerEndAdjustedAngle, x, y);\n    ctx.arc(pCenter.x, pCenter.y, outerEnd, outerEndAdjustedAngle, endAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H);\n  }\n  const p4 = rThetaToXY(innerEndAdjustedRadius, endAngle, x, y);\n  ctx.lineTo(p4.x, p4.y);\n  if (innerEnd > 0) {\n    const pCenter = rThetaToXY(innerEndAdjustedRadius, innerEndAdjustedAngle, x, y);\n    ctx.arc(pCenter.x, pCenter.y, innerEnd, endAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, innerEndAdjustedAngle + Math.PI);\n  }\n  ctx.arc(x, y, innerRadius, endAngle - (innerEnd / innerRadius), startAngle + (innerStart / innerRadius), true);\n  if (innerStart > 0) {\n    const pCenter = rThetaToXY(innerStartAdjustedRadius, innerStartAdjustedAngle, x, y);\n    ctx.arc(pCenter.x, pCenter.y, innerStart, innerStartAdjustedAngle + Math.PI, startAngle - _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H);\n  }\n  const p8 = rThetaToXY(outerStartAdjustedRadius, startAngle, x, y);\n  ctx.lineTo(p8.x, p8.y);\n  if (outerStart > 0) {\n    const pCenter = rThetaToXY(outerStartAdjustedRadius, outerStartAdjustedAngle, x, y);\n    ctx.arc(pCenter.x, pCenter.y, outerStart, startAngle - _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, outerStartAdjustedAngle);\n  }\n  ctx.closePath();\n}\nfunction drawArc(ctx, element, offset, spacing) {\n  const {fullCircles, startAngle, circumference} = element;\n  let endAngle = element.endAngle;\n  if (fullCircles) {\n    pathArc(ctx, element, offset, spacing, startAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T);\n    for (let i = 0; i < fullCircles; ++i) {\n      ctx.fill();\n    }\n    if (!isNaN(circumference)) {\n      endAngle = startAngle + circumference % _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T;\n      if (circumference % _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T === 0) {\n        endAngle += _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T;\n      }\n    }\n  }\n  pathArc(ctx, element, offset, spacing, endAngle);\n  ctx.fill();\n  return endAngle;\n}\nfunction drawFullCircleBorders(ctx, element, inner) {\n  const {x, y, startAngle, pixelMargin, fullCircles} = element;\n  const outerRadius = Math.max(element.outerRadius - pixelMargin, 0);\n  const innerRadius = element.innerRadius + pixelMargin;\n  let i;\n  if (inner) {\n    clipArc(ctx, element, startAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T);\n  }\n  ctx.beginPath();\n  ctx.arc(x, y, innerRadius, startAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T, startAngle, true);\n  for (i = 0; i < fullCircles; ++i) {\n    ctx.stroke();\n  }\n  ctx.beginPath();\n  ctx.arc(x, y, outerRadius, startAngle, startAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T);\n  for (i = 0; i < fullCircles; ++i) {\n    ctx.stroke();\n  }\n}\nfunction drawBorder(ctx, element, offset, spacing, endAngle) {\n  const {options} = element;\n  const inner = options.borderAlign === 'inner';\n  if (!options.borderWidth) {\n    return;\n  }\n  if (inner) {\n    ctx.lineWidth = options.borderWidth * 2;\n    ctx.lineJoin = 'round';\n  } else {\n    ctx.lineWidth = options.borderWidth;\n    ctx.lineJoin = 'bevel';\n  }\n  if (element.fullCircles) {\n    drawFullCircleBorders(ctx, element, inner);\n  }\n  if (inner) {\n    clipArc(ctx, element, endAngle);\n  }\n  pathArc(ctx, element, offset, spacing, endAngle);\n  ctx.stroke();\n}\nclass ArcElement extends Element {\n  constructor(cfg) {\n    super();\n    this.options = undefined;\n    this.circumference = undefined;\n    this.startAngle = undefined;\n    this.endAngle = undefined;\n    this.innerRadius = undefined;\n    this.outerRadius = undefined;\n    this.pixelMargin = 0;\n    this.fullCircles = 0;\n    if (cfg) {\n      Object.assign(this, cfg);\n    }\n  }\n  inRange(chartX, chartY, useFinalPosition) {\n    const point = this.getProps(['x', 'y'], useFinalPosition);\n    const {angle, distance} = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ae)(point, {x: chartX, y: chartY});\n    const {startAngle, endAngle, innerRadius, outerRadius, circumference} = this.getProps([\n      'startAngle',\n      'endAngle',\n      'innerRadius',\n      'outerRadius',\n      'circumference'\n    ], useFinalPosition);\n    const rAdjust = this.options.spacing / 2;\n    const betweenAngles = circumference >= _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.o)(angle, startAngle, endAngle);\n    const withinRadius = (distance >= innerRadius + rAdjust && distance <= outerRadius + rAdjust);\n    return (betweenAngles && withinRadius);\n  }\n  getCenterPoint(useFinalPosition) {\n    const {x, y, startAngle, endAngle, innerRadius, outerRadius} = this.getProps([\n      'x',\n      'y',\n      'startAngle',\n      'endAngle',\n      'innerRadius',\n      'outerRadius',\n      'circumference',\n    ], useFinalPosition);\n    const {offset, spacing} = this.options;\n    const halfAngle = (startAngle + endAngle) / 2;\n    const halfRadius = (innerRadius + outerRadius + spacing + offset) / 2;\n    return {\n      x: x + Math.cos(halfAngle) * halfRadius,\n      y: y + Math.sin(halfAngle) * halfRadius\n    };\n  }\n  tooltipPosition(useFinalPosition) {\n    return this.getCenterPoint(useFinalPosition);\n  }\n  draw(ctx) {\n    const me = this;\n    const {options, circumference} = me;\n    const offset = (options.offset || 0) / 2;\n    const spacing = (options.spacing || 0) / 2;\n    me.pixelMargin = (options.borderAlign === 'inner') ? 0.33 : 0;\n    me.fullCircles = circumference > _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T ? Math.floor(circumference / _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T) : 0;\n    if (circumference === 0 || me.innerRadius < 0 || me.outerRadius < 0) {\n      return;\n    }\n    ctx.save();\n    let radiusOffset = 0;\n    if (offset) {\n      radiusOffset = offset / 2;\n      const halfAngle = (me.startAngle + me.endAngle) / 2;\n      ctx.translate(Math.cos(halfAngle) * radiusOffset, Math.sin(halfAngle) * radiusOffset);\n      if (me.circumference >= _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P) {\n        radiusOffset = offset;\n      }\n    }\n    ctx.fillStyle = options.backgroundColor;\n    ctx.strokeStyle = options.borderColor;\n    const endAngle = drawArc(ctx, me, radiusOffset, spacing);\n    drawBorder(ctx, me, radiusOffset, spacing, endAngle);\n    ctx.restore();\n  }\n}\nArcElement.id = 'arc';\nArcElement.defaults = {\n  borderAlign: 'center',\n  borderColor: '#fff',\n  borderRadius: 0,\n  borderWidth: 2,\n  offset: 0,\n  spacing: 0,\n  angle: undefined,\n};\nArcElement.defaultRoutes = {\n  backgroundColor: 'backgroundColor'\n};\n\nfunction setStyle(ctx, options, style = options) {\n  ctx.lineCap = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderCapStyle, options.borderCapStyle);\n  ctx.setLineDash((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderDash, options.borderDash));\n  ctx.lineDashOffset = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderDashOffset, options.borderDashOffset);\n  ctx.lineJoin = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderJoinStyle, options.borderJoinStyle);\n  ctx.lineWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderWidth, options.borderWidth);\n  ctx.strokeStyle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderColor, options.borderColor);\n}\nfunction lineTo(ctx, previous, target) {\n  ctx.lineTo(target.x, target.y);\n}\nfunction getLineMethod(options) {\n  if (options.stepped) {\n    return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.am;\n  }\n  if (options.tension || options.cubicInterpolationMode === 'monotone') {\n    return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.an;\n  }\n  return lineTo;\n}\nfunction pathVars(points, segment, params = {}) {\n  const count = points.length;\n  const {start: paramsStart = 0, end: paramsEnd = count - 1} = params;\n  const {start: segmentStart, end: segmentEnd} = segment;\n  const start = Math.max(paramsStart, segmentStart);\n  const end = Math.min(paramsEnd, segmentEnd);\n  const outside = paramsStart < segmentStart && paramsEnd < segmentStart || paramsStart > segmentEnd && paramsEnd > segmentEnd;\n  return {\n    count,\n    start,\n    loop: segment.loop,\n    ilen: end < start && !outside ? count + end - start : end - start\n  };\n}\nfunction pathSegment(ctx, line, segment, params) {\n  const {points, options} = line;\n  const {count, start, loop, ilen} = pathVars(points, segment, params);\n  const lineMethod = getLineMethod(options);\n  let {move = true, reverse} = params || {};\n  let i, point, prev;\n  for (i = 0; i <= ilen; ++i) {\n    point = points[(start + (reverse ? ilen - i : i)) % count];\n    if (point.skip) {\n      continue;\n    } else if (move) {\n      ctx.moveTo(point.x, point.y);\n      move = false;\n    } else {\n      lineMethod(ctx, prev, point, reverse, options.stepped);\n    }\n    prev = point;\n  }\n  if (loop) {\n    point = points[(start + (reverse ? ilen : 0)) % count];\n    lineMethod(ctx, prev, point, reverse, options.stepped);\n  }\n  return !!loop;\n}\nfunction fastPathSegment(ctx, line, segment, params) {\n  const points = line.points;\n  const {count, start, ilen} = pathVars(points, segment, params);\n  const {move = true, reverse} = params || {};\n  let avgX = 0;\n  let countX = 0;\n  let i, point, prevX, minY, maxY, lastY;\n  const pointIndex = (index) => (start + (reverse ? ilen - index : index)) % count;\n  const drawX = () => {\n    if (minY !== maxY) {\n      ctx.lineTo(avgX, maxY);\n      ctx.lineTo(avgX, minY);\n      ctx.lineTo(avgX, lastY);\n    }\n  };\n  if (move) {\n    point = points[pointIndex(0)];\n    ctx.moveTo(point.x, point.y);\n  }\n  for (i = 0; i <= ilen; ++i) {\n    point = points[pointIndex(i)];\n    if (point.skip) {\n      continue;\n    }\n    const x = point.x;\n    const y = point.y;\n    const truncX = x | 0;\n    if (truncX === prevX) {\n      if (y < minY) {\n        minY = y;\n      } else if (y > maxY) {\n        maxY = y;\n      }\n      avgX = (countX * avgX + x) / ++countX;\n    } else {\n      drawX();\n      ctx.lineTo(x, y);\n      prevX = truncX;\n      countX = 0;\n      minY = maxY = y;\n    }\n    lastY = y;\n  }\n  drawX();\n}\nfunction _getSegmentMethod(line) {\n  const opts = line.options;\n  const borderDash = opts.borderDash && opts.borderDash.length;\n  const useFastPath = !line._decimated && !line._loop && !opts.tension && opts.cubicInterpolationMode !== 'monotone' && !opts.stepped && !borderDash;\n  return useFastPath ? fastPathSegment : pathSegment;\n}\nfunction _getInterpolationMethod(options) {\n  if (options.stepped) {\n    return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aj;\n  }\n  if (options.tension || options.cubicInterpolationMode === 'monotone') {\n    return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ak;\n  }\n  return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.al;\n}\nfunction strokePathWithCache(ctx, line, start, count) {\n  let path = line._path;\n  if (!path) {\n    path = line._path = new Path2D();\n    if (line.path(path, start, count)) {\n      path.closePath();\n    }\n  }\n  setStyle(ctx, line.options);\n  ctx.stroke(path);\n}\nfunction strokePathDirect(ctx, line, start, count) {\n  const {segments, options} = line;\n  const segmentMethod = _getSegmentMethod(line);\n  for (const segment of segments) {\n    setStyle(ctx, options, segment.style);\n    ctx.beginPath();\n    if (segmentMethod(ctx, line, segment, {start, end: start + count - 1})) {\n      ctx.closePath();\n    }\n    ctx.stroke();\n  }\n}\nconst usePath2D = typeof Path2D === 'function';\nfunction draw(ctx, line, start, count) {\n  if (usePath2D && line.segments.length === 1) {\n    strokePathWithCache(ctx, line, start, count);\n  } else {\n    strokePathDirect(ctx, line, start, count);\n  }\n}\nclass LineElement extends Element {\n  constructor(cfg) {\n    super();\n    this.animated = true;\n    this.options = undefined;\n    this._loop = undefined;\n    this._fullLoop = undefined;\n    this._path = undefined;\n    this._points = undefined;\n    this._segments = undefined;\n    this._decimated = false;\n    this._pointsUpdated = false;\n    this._datasetIndex = undefined;\n    if (cfg) {\n      Object.assign(this, cfg);\n    }\n  }\n  updateControlPoints(chartArea, indexAxis) {\n    const me = this;\n    const options = me.options;\n    if ((options.tension || options.cubicInterpolationMode === 'monotone') && !options.stepped && !me._pointsUpdated) {\n      const loop = options.spanGaps ? me._loop : me._fullLoop;\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ag)(me._points, options, chartArea, loop, indexAxis);\n      me._pointsUpdated = true;\n    }\n  }\n  set points(points) {\n    const me = this;\n    me._points = points;\n    delete me._segments;\n    delete me._path;\n    me._pointsUpdated = false;\n  }\n  get points() {\n    return this._points;\n  }\n  get segments() {\n    return this._segments || (this._segments = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ah)(this, this.options.segment));\n  }\n  first() {\n    const segments = this.segments;\n    const points = this.points;\n    return segments.length && points[segments[0].start];\n  }\n  last() {\n    const segments = this.segments;\n    const points = this.points;\n    const count = segments.length;\n    return count && points[segments[count - 1].end];\n  }\n  interpolate(point, property) {\n    const me = this;\n    const options = me.options;\n    const value = point[property];\n    const points = me.points;\n    const segments = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ai)(me, {property, start: value, end: value});\n    if (!segments.length) {\n      return;\n    }\n    const result = [];\n    const _interpolate = _getInterpolationMethod(options);\n    let i, ilen;\n    for (i = 0, ilen = segments.length; i < ilen; ++i) {\n      const {start, end} = segments[i];\n      const p1 = points[start];\n      const p2 = points[end];\n      if (p1 === p2) {\n        result.push(p1);\n        continue;\n      }\n      const t = Math.abs((value - p1[property]) / (p2[property] - p1[property]));\n      const interpolated = _interpolate(p1, p2, t, options.stepped);\n      interpolated[property] = point[property];\n      result.push(interpolated);\n    }\n    return result.length === 1 ? result[0] : result;\n  }\n  pathSegment(ctx, segment, params) {\n    const segmentMethod = _getSegmentMethod(this);\n    return segmentMethod(ctx, this, segment, params);\n  }\n  path(ctx, start, count) {\n    const me = this;\n    const segments = me.segments;\n    const segmentMethod = _getSegmentMethod(me);\n    let loop = me._loop;\n    start = start || 0;\n    count = count || (me.points.length - start);\n    for (const segment of segments) {\n      loop &= segmentMethod(ctx, me, segment, {start, end: start + count - 1});\n    }\n    return !!loop;\n  }\n  draw(ctx, chartArea, start, count) {\n    const me = this;\n    const options = me.options || {};\n    const points = me.points || [];\n    if (!points.length || !options.borderWidth) {\n      return;\n    }\n    ctx.save();\n    draw(ctx, me, start, count);\n    ctx.restore();\n    if (me.animated) {\n      me._pointsUpdated = false;\n      me._path = undefined;\n    }\n  }\n}\nLineElement.id = 'line';\nLineElement.defaults = {\n  borderCapStyle: 'butt',\n  borderDash: [],\n  borderDashOffset: 0,\n  borderJoinStyle: 'miter',\n  borderWidth: 3,\n  capBezierPoints: true,\n  cubicInterpolationMode: 'default',\n  fill: false,\n  spanGaps: false,\n  stepped: false,\n  tension: 0,\n};\nLineElement.defaultRoutes = {\n  backgroundColor: 'backgroundColor',\n  borderColor: 'borderColor'\n};\nLineElement.descriptors = {\n  _scriptable: true,\n  _indexable: (name) => name !== 'borderDash' && name !== 'fill',\n};\n\nfunction inRange$1(el, pos, axis, useFinalPosition) {\n  const options = el.options;\n  const {[axis]: value} = el.getProps([axis], useFinalPosition);\n  return (Math.abs(pos - value) < options.radius + options.hitRadius);\n}\nclass PointElement extends Element {\n  constructor(cfg) {\n    super();\n    this.options = undefined;\n    this.parsed = undefined;\n    this.skip = undefined;\n    this.stop = undefined;\n    if (cfg) {\n      Object.assign(this, cfg);\n    }\n  }\n  inRange(mouseX, mouseY, useFinalPosition) {\n    const options = this.options;\n    const {x, y} = this.getProps(['x', 'y'], useFinalPosition);\n    return ((Math.pow(mouseX - x, 2) + Math.pow(mouseY - y, 2)) < Math.pow(options.hitRadius + options.radius, 2));\n  }\n  inXRange(mouseX, useFinalPosition) {\n    return inRange$1(this, mouseX, 'x', useFinalPosition);\n  }\n  inYRange(mouseY, useFinalPosition) {\n    return inRange$1(this, mouseY, 'y', useFinalPosition);\n  }\n  getCenterPoint(useFinalPosition) {\n    const {x, y} = this.getProps(['x', 'y'], useFinalPosition);\n    return {x, y};\n  }\n  size(options) {\n    options = options || this.options || {};\n    let radius = options.radius || 0;\n    radius = Math.max(radius, radius && options.hoverRadius || 0);\n    const borderWidth = radius && options.borderWidth || 0;\n    return (radius + borderWidth) * 2;\n  }\n  draw(ctx, area) {\n    const me = this;\n    const options = me.options;\n    if (me.skip || options.radius < 0.1 || !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.y)(me, area, me.size(options) / 2)) {\n      return;\n    }\n    ctx.strokeStyle = options.borderColor;\n    ctx.lineWidth = options.borderWidth;\n    ctx.fillStyle = options.backgroundColor;\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ao)(ctx, options, me.x, me.y);\n  }\n  getRange() {\n    const options = this.options || {};\n    return options.radius + options.hitRadius;\n  }\n}\nPointElement.id = 'point';\nPointElement.defaults = {\n  borderWidth: 1,\n  hitRadius: 1,\n  hoverBorderWidth: 1,\n  hoverRadius: 4,\n  pointStyle: 'circle',\n  radius: 3,\n  rotation: 0\n};\nPointElement.defaultRoutes = {\n  backgroundColor: 'backgroundColor',\n  borderColor: 'borderColor'\n};\n\nfunction getBarBounds(bar, useFinalPosition) {\n  const {x, y, base, width, height} = bar.getProps(['x', 'y', 'base', 'width', 'height'], useFinalPosition);\n  let left, right, top, bottom, half;\n  if (bar.horizontal) {\n    half = height / 2;\n    left = Math.min(x, base);\n    right = Math.max(x, base);\n    top = y - half;\n    bottom = y + half;\n  } else {\n    half = width / 2;\n    left = x - half;\n    right = x + half;\n    top = Math.min(y, base);\n    bottom = Math.max(y, base);\n  }\n  return {left, top, right, bottom};\n}\nfunction skipOrLimit(skip, value, min, max) {\n  return skip ? 0 : (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(value, min, max);\n}\nfunction parseBorderWidth(bar, maxW, maxH) {\n  const value = bar.options.borderWidth;\n  const skip = bar.borderSkipped;\n  const o = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aq)(value);\n  return {\n    t: skipOrLimit(skip.top, o.top, 0, maxH),\n    r: skipOrLimit(skip.right, o.right, 0, maxW),\n    b: skipOrLimit(skip.bottom, o.bottom, 0, maxH),\n    l: skipOrLimit(skip.left, o.left, 0, maxW)\n  };\n}\nfunction parseBorderRadius(bar, maxW, maxH) {\n  const {enableBorderRadius} = bar.getProps(['enableBorderRadius']);\n  const value = bar.options.borderRadius;\n  const o = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ar)(value);\n  const maxR = Math.min(maxW, maxH);\n  const skip = bar.borderSkipped;\n  const enableBorder = enableBorderRadius || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(value);\n  return {\n    topLeft: skipOrLimit(!enableBorder || skip.top || skip.left, o.topLeft, 0, maxR),\n    topRight: skipOrLimit(!enableBorder || skip.top || skip.right, o.topRight, 0, maxR),\n    bottomLeft: skipOrLimit(!enableBorder || skip.bottom || skip.left, o.bottomLeft, 0, maxR),\n    bottomRight: skipOrLimit(!enableBorder || skip.bottom || skip.right, o.bottomRight, 0, maxR)\n  };\n}\nfunction boundingRects(bar) {\n  const bounds = getBarBounds(bar);\n  const width = bounds.right - bounds.left;\n  const height = bounds.bottom - bounds.top;\n  const border = parseBorderWidth(bar, width / 2, height / 2);\n  const radius = parseBorderRadius(bar, width / 2, height / 2);\n  return {\n    outer: {\n      x: bounds.left,\n      y: bounds.top,\n      w: width,\n      h: height,\n      radius\n    },\n    inner: {\n      x: bounds.left + border.l,\n      y: bounds.top + border.t,\n      w: width - border.l - border.r,\n      h: height - border.t - border.b,\n      radius: {\n        topLeft: Math.max(0, radius.topLeft - Math.max(border.t, border.l)),\n        topRight: Math.max(0, radius.topRight - Math.max(border.t, border.r)),\n        bottomLeft: Math.max(0, radius.bottomLeft - Math.max(border.b, border.l)),\n        bottomRight: Math.max(0, radius.bottomRight - Math.max(border.b, border.r)),\n      }\n    }\n  };\n}\nfunction inRange(bar, x, y, useFinalPosition) {\n  const skipX = x === null;\n  const skipY = y === null;\n  const skipBoth = skipX && skipY;\n  const bounds = bar && !skipBoth && getBarBounds(bar, useFinalPosition);\n  return bounds\n\t\t&& (skipX || x >= bounds.left && x <= bounds.right)\n\t\t&& (skipY || y >= bounds.top && y <= bounds.bottom);\n}\nfunction hasRadius(radius) {\n  return radius.topLeft || radius.topRight || radius.bottomLeft || radius.bottomRight;\n}\nfunction addNormalRectPath(ctx, rect) {\n  ctx.rect(rect.x, rect.y, rect.w, rect.h);\n}\nfunction inflateRect(rect, amount, refRect = {}) {\n  const x = rect.x !== refRect.x ? -amount : 0;\n  const y = rect.y !== refRect.y ? -amount : 0;\n  const w = (rect.x + rect.w !== refRect.x + refRect.w ? amount : 0) - x;\n  const h = (rect.y + rect.h !== refRect.y + refRect.h ? amount : 0) - y;\n  return {\n    x: rect.x + x,\n    y: rect.y + y,\n    w: rect.w + w,\n    h: rect.h + h,\n    radius: rect.radius\n  };\n}\nclass BarElement extends Element {\n  constructor(cfg) {\n    super();\n    this.options = undefined;\n    this.horizontal = undefined;\n    this.base = undefined;\n    this.width = undefined;\n    this.height = undefined;\n    if (cfg) {\n      Object.assign(this, cfg);\n    }\n  }\n  draw(ctx) {\n    const options = this.options;\n    const {inner, outer} = boundingRects(this);\n    const addRectPath = hasRadius(outer.radius) ? _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ap : addNormalRectPath;\n    const inflateAmount = 0.33;\n    ctx.save();\n    if (outer.w !== inner.w || outer.h !== inner.h) {\n      ctx.beginPath();\n      addRectPath(ctx, inflateRect(outer, inflateAmount, inner));\n      ctx.clip();\n      addRectPath(ctx, inflateRect(inner, -inflateAmount, outer));\n      ctx.fillStyle = options.borderColor;\n      ctx.fill('evenodd');\n    }\n    ctx.beginPath();\n    addRectPath(ctx, inflateRect(inner, inflateAmount, outer));\n    ctx.fillStyle = options.backgroundColor;\n    ctx.fill();\n    ctx.restore();\n  }\n  inRange(mouseX, mouseY, useFinalPosition) {\n    return inRange(this, mouseX, mouseY, useFinalPosition);\n  }\n  inXRange(mouseX, useFinalPosition) {\n    return inRange(this, mouseX, null, useFinalPosition);\n  }\n  inYRange(mouseY, useFinalPosition) {\n    return inRange(this, null, mouseY, useFinalPosition);\n  }\n  getCenterPoint(useFinalPosition) {\n    const {x, y, base, horizontal} = this.getProps(['x', 'y', 'base', 'horizontal'], useFinalPosition);\n    return {\n      x: horizontal ? (x + base) / 2 : x,\n      y: horizontal ? y : (y + base) / 2\n    };\n  }\n  getRange(axis) {\n    return axis === 'x' ? this.width / 2 : this.height / 2;\n  }\n}\nBarElement.id = 'bar';\nBarElement.defaults = {\n  borderSkipped: 'start',\n  borderWidth: 0,\n  borderRadius: 0,\n  enableBorderRadius: true,\n  pointStyle: undefined\n};\nBarElement.defaultRoutes = {\n  backgroundColor: 'backgroundColor',\n  borderColor: 'borderColor'\n};\n\nvar elements = /*#__PURE__*/Object.freeze({\n__proto__: null,\nArcElement: ArcElement,\nLineElement: LineElement,\nPointElement: PointElement,\nBarElement: BarElement\n});\n\nfunction lttbDecimation(data, start, count, availableWidth, options) {\n  const samples = options.samples || availableWidth;\n  if (samples >= count) {\n    return data.slice(start, start + count);\n  }\n  const decimated = [];\n  const bucketWidth = (count - 2) / (samples - 2);\n  let sampledIndex = 0;\n  const endIndex = start + count - 1;\n  let a = start;\n  let i, maxAreaPoint, maxArea, area, nextA;\n  decimated[sampledIndex++] = data[a];\n  for (i = 0; i < samples - 2; i++) {\n    let avgX = 0;\n    let avgY = 0;\n    let j;\n    const avgRangeStart = Math.floor((i + 1) * bucketWidth) + 1 + start;\n    const avgRangeEnd = Math.min(Math.floor((i + 2) * bucketWidth) + 1, count) + start;\n    const avgRangeLength = avgRangeEnd - avgRangeStart;\n    for (j = avgRangeStart; j < avgRangeEnd; j++) {\n      avgX += data[j].x;\n      avgY += data[j].y;\n    }\n    avgX /= avgRangeLength;\n    avgY /= avgRangeLength;\n    const rangeOffs = Math.floor(i * bucketWidth) + 1 + start;\n    const rangeTo = Math.min(Math.floor((i + 1) * bucketWidth) + 1, count) + start;\n    const {x: pointAx, y: pointAy} = data[a];\n    maxArea = area = -1;\n    for (j = rangeOffs; j < rangeTo; j++) {\n      area = 0.5 * Math.abs(\n        (pointAx - avgX) * (data[j].y - pointAy) -\n        (pointAx - data[j].x) * (avgY - pointAy)\n      );\n      if (area > maxArea) {\n        maxArea = area;\n        maxAreaPoint = data[j];\n        nextA = j;\n      }\n    }\n    decimated[sampledIndex++] = maxAreaPoint;\n    a = nextA;\n  }\n  decimated[sampledIndex++] = data[endIndex];\n  return decimated;\n}\nfunction minMaxDecimation(data, start, count, availableWidth) {\n  let avgX = 0;\n  let countX = 0;\n  let i, point, x, y, prevX, minIndex, maxIndex, startIndex, minY, maxY;\n  const decimated = [];\n  const endIndex = start + count - 1;\n  const xMin = data[start].x;\n  const xMax = data[endIndex].x;\n  const dx = xMax - xMin;\n  for (i = start; i < start + count; ++i) {\n    point = data[i];\n    x = (point.x - xMin) / dx * availableWidth;\n    y = point.y;\n    const truncX = x | 0;\n    if (truncX === prevX) {\n      if (y < minY) {\n        minY = y;\n        minIndex = i;\n      } else if (y > maxY) {\n        maxY = y;\n        maxIndex = i;\n      }\n      avgX = (countX * avgX + point.x) / ++countX;\n    } else {\n      const lastIndex = i - 1;\n      if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(minIndex) && !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(maxIndex)) {\n        const intermediateIndex1 = Math.min(minIndex, maxIndex);\n        const intermediateIndex2 = Math.max(minIndex, maxIndex);\n        if (intermediateIndex1 !== startIndex && intermediateIndex1 !== lastIndex) {\n          decimated.push({\n            ...data[intermediateIndex1],\n            x: avgX,\n          });\n        }\n        if (intermediateIndex2 !== startIndex && intermediateIndex2 !== lastIndex) {\n          decimated.push({\n            ...data[intermediateIndex2],\n            x: avgX\n          });\n        }\n      }\n      if (i > 0 && lastIndex !== startIndex) {\n        decimated.push(data[lastIndex]);\n      }\n      decimated.push(point);\n      prevX = truncX;\n      countX = 0;\n      minY = maxY = y;\n      minIndex = maxIndex = startIndex = i;\n    }\n  }\n  return decimated;\n}\nfunction cleanDecimatedDataset(dataset) {\n  if (dataset._decimated) {\n    const data = dataset._data;\n    delete dataset._decimated;\n    delete dataset._data;\n    Object.defineProperty(dataset, 'data', {value: data});\n  }\n}\nfunction cleanDecimatedData(chart) {\n  chart.data.datasets.forEach((dataset) => {\n    cleanDecimatedDataset(dataset);\n  });\n}\nfunction getStartAndCountOfVisiblePointsSimplified(meta, points) {\n  const pointCount = points.length;\n  let start = 0;\n  let count;\n  const {iScale} = meta;\n  const {min, max, minDefined, maxDefined} = iScale.getUserBounds();\n  if (minDefined) {\n    start = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(points, iScale.axis, min).lo, 0, pointCount - 1);\n  }\n  if (maxDefined) {\n    count = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(points, iScale.axis, max).hi + 1, start, pointCount) - start;\n  } else {\n    count = pointCount - start;\n  }\n  return {start, count};\n}\nvar plugin_decimation = {\n  id: 'decimation',\n  defaults: {\n    algorithm: 'min-max',\n    enabled: false,\n  },\n  beforeElementsUpdate: (chart, args, options) => {\n    if (!options.enabled) {\n      cleanDecimatedData(chart);\n      return;\n    }\n    const availableWidth = chart.width;\n    chart.data.datasets.forEach((dataset, datasetIndex) => {\n      const {_data, indexAxis} = dataset;\n      const meta = chart.getDatasetMeta(datasetIndex);\n      const data = _data || dataset.data;\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([indexAxis, chart.options.indexAxis]) === 'y') {\n        return;\n      }\n      if (meta.type !== 'line') {\n        return;\n      }\n      const xAxis = chart.scales[meta.xAxisID];\n      if (xAxis.type !== 'linear' && xAxis.type !== 'time') {\n        return;\n      }\n      if (chart.options.parsing) {\n        return;\n      }\n      let {start, count} = getStartAndCountOfVisiblePointsSimplified(meta, data);\n      const threshold = options.threshold || 4 * availableWidth;\n      if (count <= threshold) {\n        cleanDecimatedDataset(dataset);\n        return;\n      }\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(_data)) {\n        dataset._data = data;\n        delete dataset.data;\n        Object.defineProperty(dataset, 'data', {\n          configurable: true,\n          enumerable: true,\n          get: function() {\n            return this._decimated;\n          },\n          set: function(d) {\n            this._data = d;\n          }\n        });\n      }\n      let decimated;\n      switch (options.algorithm) {\n      case 'lttb':\n        decimated = lttbDecimation(data, start, count, availableWidth, options);\n        break;\n      case 'min-max':\n        decimated = minMaxDecimation(data, start, count, availableWidth);\n        break;\n      default:\n        throw new Error(`Unsupported decimation algorithm '${options.algorithm}'`);\n      }\n      dataset._decimated = decimated;\n    });\n  },\n  destroy(chart) {\n    cleanDecimatedData(chart);\n  }\n};\n\nfunction getLineByIndex(chart, index) {\n  const meta = chart.getDatasetMeta(index);\n  const visible = meta && chart.isDatasetVisible(index);\n  return visible ? meta.dataset : null;\n}\nfunction parseFillOption(line) {\n  const options = line.options;\n  const fillOption = options.fill;\n  let fill = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(fillOption && fillOption.target, fillOption);\n  if (fill === undefined) {\n    fill = !!options.backgroundColor;\n  }\n  if (fill === false || fill === null) {\n    return false;\n  }\n  if (fill === true) {\n    return 'origin';\n  }\n  return fill;\n}\nfunction decodeFill(line, index, count) {\n  const fill = parseFillOption(line);\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(fill)) {\n    return isNaN(fill.value) ? false : fill;\n  }\n  let target = parseFloat(fill);\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(target) && Math.floor(target) === target) {\n    if (fill[0] === '-' || fill[0] === '+') {\n      target = index + target;\n    }\n    if (target === index || target < 0 || target >= count) {\n      return false;\n    }\n    return target;\n  }\n  return ['origin', 'start', 'end', 'stack', 'shape'].indexOf(fill) >= 0 && fill;\n}\nfunction computeLinearBoundary(source) {\n  const {scale = {}, fill} = source;\n  let target = null;\n  let horizontal;\n  if (fill === 'start') {\n    target = scale.bottom;\n  } else if (fill === 'end') {\n    target = scale.top;\n  } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(fill)) {\n    target = scale.getPixelForValue(fill.value);\n  } else if (scale.getBasePixel) {\n    target = scale.getBasePixel();\n  }\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(target)) {\n    horizontal = scale.isHorizontal();\n    return {\n      x: horizontal ? target : null,\n      y: horizontal ? null : target\n    };\n  }\n  return null;\n}\nclass simpleArc {\n  constructor(opts) {\n    this.x = opts.x;\n    this.y = opts.y;\n    this.radius = opts.radius;\n  }\n  pathSegment(ctx, bounds, opts) {\n    const {x, y, radius} = this;\n    bounds = bounds || {start: 0, end: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T};\n    ctx.arc(x, y, radius, bounds.end, bounds.start, true);\n    return !opts.bounds;\n  }\n  interpolate(point) {\n    const {x, y, radius} = this;\n    const angle = point.angle;\n    return {\n      x: x + Math.cos(angle) * radius,\n      y: y + Math.sin(angle) * radius,\n      angle\n    };\n  }\n}\nfunction computeCircularBoundary(source) {\n  const {scale, fill} = source;\n  const options = scale.options;\n  const length = scale.getLabels().length;\n  const target = [];\n  const start = options.reverse ? scale.max : scale.min;\n  const end = options.reverse ? scale.min : scale.max;\n  let i, center, value;\n  if (fill === 'start') {\n    value = start;\n  } else if (fill === 'end') {\n    value = end;\n  } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(fill)) {\n    value = fill.value;\n  } else {\n    value = scale.getBaseValue();\n  }\n  if (options.grid.circular) {\n    center = scale.getPointPositionForValue(0, start);\n    return new simpleArc({\n      x: center.x,\n      y: center.y,\n      radius: scale.getDistanceFromCenterForValue(value)\n    });\n  }\n  for (i = 0; i < length; ++i) {\n    target.push(scale.getPointPositionForValue(i, value));\n  }\n  return target;\n}\nfunction computeBoundary(source) {\n  const scale = source.scale || {};\n  if (scale.getPointPositionForValue) {\n    return computeCircularBoundary(source);\n  }\n  return computeLinearBoundary(source);\n}\nfunction findSegmentEnd(start, end, points) {\n  for (;end > start; end--) {\n    const point = points[end];\n    if (!isNaN(point.x) && !isNaN(point.y)) {\n      break;\n    }\n  }\n  return end;\n}\nfunction pointsFromSegments(boundary, line) {\n  const {x = null, y = null} = boundary || {};\n  const linePoints = line.points;\n  const points = [];\n  line.segments.forEach(({start, end}) => {\n    end = findSegmentEnd(start, end, linePoints);\n    const first = linePoints[start];\n    const last = linePoints[end];\n    if (y !== null) {\n      points.push({x: first.x, y});\n      points.push({x: last.x, y});\n    } else if (x !== null) {\n      points.push({x, y: first.y});\n      points.push({x, y: last.y});\n    }\n  });\n  return points;\n}\nfunction buildStackLine(source) {\n  const {chart, scale, index, line} = source;\n  const points = [];\n  const segments = line.segments;\n  const sourcePoints = line.points;\n  const linesBelow = getLinesBelow(chart, index);\n  linesBelow.push(createBoundaryLine({x: null, y: scale.bottom}, line));\n  for (let i = 0; i < segments.length; i++) {\n    const segment = segments[i];\n    for (let j = segment.start; j <= segment.end; j++) {\n      addPointsBelow(points, sourcePoints[j], linesBelow);\n    }\n  }\n  return new LineElement({points, options: {}});\n}\nconst isLineAndNotInHideAnimation = (meta) => meta.type === 'line' && !meta.hidden;\nfunction getLinesBelow(chart, index) {\n  const below = [];\n  const metas = chart.getSortedVisibleDatasetMetas();\n  for (let i = 0; i < metas.length; i++) {\n    const meta = metas[i];\n    if (meta.index === index) {\n      break;\n    }\n    if (isLineAndNotInHideAnimation(meta)) {\n      below.unshift(meta.dataset);\n    }\n  }\n  return below;\n}\nfunction addPointsBelow(points, sourcePoint, linesBelow) {\n  const postponed = [];\n  for (let j = 0; j < linesBelow.length; j++) {\n    const line = linesBelow[j];\n    const {first, last, point} = findPoint(line, sourcePoint, 'x');\n    if (!point || (first && last)) {\n      continue;\n    }\n    if (first) {\n      postponed.unshift(point);\n    } else {\n      points.push(point);\n      if (!last) {\n        break;\n      }\n    }\n  }\n  points.push(...postponed);\n}\nfunction findPoint(line, sourcePoint, property) {\n  const point = line.interpolate(sourcePoint, property);\n  if (!point) {\n    return {};\n  }\n  const pointValue = point[property];\n  const segments = line.segments;\n  const linePoints = line.points;\n  let first = false;\n  let last = false;\n  for (let i = 0; i < segments.length; i++) {\n    const segment = segments[i];\n    const firstValue = linePoints[segment.start][property];\n    const lastValue = linePoints[segment.end][property];\n    if (pointValue >= firstValue && pointValue <= lastValue) {\n      first = pointValue === firstValue;\n      last = pointValue === lastValue;\n      break;\n    }\n  }\n  return {first, last, point};\n}\nfunction getTarget(source) {\n  const {chart, fill, line} = source;\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(fill)) {\n    return getLineByIndex(chart, fill);\n  }\n  if (fill === 'stack') {\n    return buildStackLine(source);\n  }\n  if (fill === 'shape') {\n    return true;\n  }\n  const boundary = computeBoundary(source);\n  if (boundary instanceof simpleArc) {\n    return boundary;\n  }\n  return createBoundaryLine(boundary, line);\n}\nfunction createBoundaryLine(boundary, line) {\n  let points = [];\n  let _loop = false;\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(boundary)) {\n    _loop = true;\n    points = boundary;\n  } else {\n    points = pointsFromSegments(boundary, line);\n  }\n  return points.length ? new LineElement({\n    points,\n    options: {tension: 0},\n    _loop,\n    _fullLoop: _loop\n  }) : null;\n}\nfunction resolveTarget(sources, index, propagate) {\n  const source = sources[index];\n  let fill = source.fill;\n  const visited = [index];\n  let target;\n  if (!propagate) {\n    return fill;\n  }\n  while (fill !== false && visited.indexOf(fill) === -1) {\n    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(fill)) {\n      return fill;\n    }\n    target = sources[fill];\n    if (!target) {\n      return false;\n    }\n    if (target.visible) {\n      return fill;\n    }\n    visited.push(fill);\n    fill = target.fill;\n  }\n  return false;\n}\nfunction _clip(ctx, target, clipY) {\n  ctx.beginPath();\n  target.path(ctx);\n  ctx.lineTo(target.last().x, clipY);\n  ctx.lineTo(target.first().x, clipY);\n  ctx.closePath();\n  ctx.clip();\n}\nfunction getBounds(property, first, last, loop) {\n  if (loop) {\n    return;\n  }\n  let start = first[property];\n  let end = last[property];\n  if (property === 'angle') {\n    start = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.at)(start);\n    end = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.at)(end);\n  }\n  return {property, start, end};\n}\nfunction _getEdge(a, b, prop, fn) {\n  if (a && b) {\n    return fn(a[prop], b[prop]);\n  }\n  return a ? a[prop] : b ? b[prop] : 0;\n}\nfunction _segments(line, target, property) {\n  const segments = line.segments;\n  const points = line.points;\n  const tpoints = target.points;\n  const parts = [];\n  for (const segment of segments) {\n    let {start, end} = segment;\n    end = findSegmentEnd(start, end, points);\n    const bounds = getBounds(property, points[start], points[end], segment.loop);\n    if (!target.segments) {\n      parts.push({\n        source: segment,\n        target: bounds,\n        start: points[start],\n        end: points[end]\n      });\n      continue;\n    }\n    const targetSegments = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ai)(target, bounds);\n    for (const tgt of targetSegments) {\n      const subBounds = getBounds(property, tpoints[tgt.start], tpoints[tgt.end], tgt.loop);\n      const fillSources = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.as)(segment, points, subBounds);\n      for (const fillSource of fillSources) {\n        parts.push({\n          source: fillSource,\n          target: tgt,\n          start: {\n            [property]: _getEdge(bounds, subBounds, 'start', Math.max)\n          },\n          end: {\n            [property]: _getEdge(bounds, subBounds, 'end', Math.min)\n          }\n        });\n      }\n    }\n  }\n  return parts;\n}\nfunction clipBounds(ctx, scale, bounds) {\n  const {top, bottom} = scale.chart.chartArea;\n  const {property, start, end} = bounds || {};\n  if (property === 'x') {\n    ctx.beginPath();\n    ctx.rect(start, top, end - start, bottom - top);\n    ctx.clip();\n  }\n}\nfunction interpolatedLineTo(ctx, target, point, property) {\n  const interpolatedPoint = target.interpolate(point, property);\n  if (interpolatedPoint) {\n    ctx.lineTo(interpolatedPoint.x, interpolatedPoint.y);\n  }\n}\nfunction _fill(ctx, cfg) {\n  const {line, target, property, color, scale} = cfg;\n  const segments = _segments(line, target, property);\n  for (const {source: src, target: tgt, start, end} of segments) {\n    const {style: {backgroundColor = color} = {}} = src;\n    const notShape = target !== true;\n    ctx.save();\n    ctx.fillStyle = backgroundColor;\n    clipBounds(ctx, scale, notShape && getBounds(property, start, end));\n    ctx.beginPath();\n    const lineLoop = !!line.pathSegment(ctx, src);\n    let loop;\n    if (notShape) {\n      if (lineLoop) {\n        ctx.closePath();\n      } else {\n        interpolatedLineTo(ctx, target, end, property);\n      }\n      const targetLoop = !!target.pathSegment(ctx, tgt, {move: lineLoop, reverse: true});\n      loop = lineLoop && targetLoop;\n      if (!loop) {\n        interpolatedLineTo(ctx, target, start, property);\n      }\n    }\n    ctx.closePath();\n    ctx.fill(loop ? 'evenodd' : 'nonzero');\n    ctx.restore();\n  }\n}\nfunction doFill(ctx, cfg) {\n  const {line, target, above, below, area, scale} = cfg;\n  const property = line._loop ? 'angle' : cfg.axis;\n  ctx.save();\n  if (property === 'x' && below !== above) {\n    _clip(ctx, target, area.top);\n    _fill(ctx, {line, target, color: above, scale, property});\n    ctx.restore();\n    ctx.save();\n    _clip(ctx, target, area.bottom);\n  }\n  _fill(ctx, {line, target, color: below, scale, property});\n  ctx.restore();\n}\nfunction drawfill(ctx, source, area) {\n  const target = getTarget(source);\n  const {line, scale, axis} = source;\n  const lineOpts = line.options;\n  const fillOption = lineOpts.fill;\n  const color = lineOpts.backgroundColor;\n  const {above = color, below = color} = fillOption || {};\n  if (target && line.points.length) {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.U)(ctx, area);\n    doFill(ctx, {line, target, above, below, area, scale, axis});\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.W)(ctx);\n  }\n}\nvar plugin_filler = {\n  id: 'filler',\n  afterDatasetsUpdate(chart, _args, options) {\n    const count = (chart.data.datasets || []).length;\n    const sources = [];\n    let meta, i, line, source;\n    for (i = 0; i < count; ++i) {\n      meta = chart.getDatasetMeta(i);\n      line = meta.dataset;\n      source = null;\n      if (line && line.options && line instanceof LineElement) {\n        source = {\n          visible: chart.isDatasetVisible(i),\n          index: i,\n          fill: decodeFill(line, i, count),\n          chart,\n          axis: meta.controller.options.indexAxis,\n          scale: meta.vScale,\n          line,\n        };\n      }\n      meta.$filler = source;\n      sources.push(source);\n    }\n    for (i = 0; i < count; ++i) {\n      source = sources[i];\n      if (!source || source.fill === false) {\n        continue;\n      }\n      source.fill = resolveTarget(sources, i, options.propagate);\n    }\n  },\n  beforeDraw(chart, _args, options) {\n    const draw = options.drawTime === 'beforeDraw';\n    const metasets = chart.getSortedVisibleDatasetMetas();\n    const area = chart.chartArea;\n    for (let i = metasets.length - 1; i >= 0; --i) {\n      const source = metasets[i].$filler;\n      if (!source) {\n        continue;\n      }\n      source.line.updateControlPoints(area, source.axis);\n      if (draw) {\n        drawfill(chart.ctx, source, area);\n      }\n    }\n  },\n  beforeDatasetsDraw(chart, _args, options) {\n    if (options.drawTime !== 'beforeDatasetsDraw') {\n      return;\n    }\n    const metasets = chart.getSortedVisibleDatasetMetas();\n    for (let i = metasets.length - 1; i >= 0; --i) {\n      const source = metasets[i].$filler;\n      if (source) {\n        drawfill(chart.ctx, source, chart.chartArea);\n      }\n    }\n  },\n  beforeDatasetDraw(chart, args, options) {\n    const source = args.meta.$filler;\n    if (!source || source.fill === false || options.drawTime !== 'beforeDatasetDraw') {\n      return;\n    }\n    drawfill(chart.ctx, source, chart.chartArea);\n  },\n  defaults: {\n    propagate: true,\n    drawTime: 'beforeDatasetDraw'\n  }\n};\n\nconst getBoxSize = (labelOpts, fontSize) => {\n  let {boxHeight = fontSize, boxWidth = fontSize} = labelOpts;\n  if (labelOpts.usePointStyle) {\n    boxHeight = Math.min(boxHeight, fontSize);\n    boxWidth = Math.min(boxWidth, fontSize);\n  }\n  return {\n    boxWidth,\n    boxHeight,\n    itemHeight: Math.max(fontSize, boxHeight)\n  };\n};\nconst itemsEqual = (a, b) => a !== null && b !== null && a.datasetIndex === b.datasetIndex && a.index === b.index;\nclass Legend extends Element {\n  constructor(config) {\n    super();\n    this._added = false;\n    this.legendHitBoxes = [];\n    this._hoveredItem = null;\n    this.doughnutMode = false;\n    this.chart = config.chart;\n    this.options = config.options;\n    this.ctx = config.ctx;\n    this.legendItems = undefined;\n    this.columnSizes = undefined;\n    this.lineWidths = undefined;\n    this.maxHeight = undefined;\n    this.maxWidth = undefined;\n    this.top = undefined;\n    this.bottom = undefined;\n    this.left = undefined;\n    this.right = undefined;\n    this.height = undefined;\n    this.width = undefined;\n    this._margins = undefined;\n    this.position = undefined;\n    this.weight = undefined;\n    this.fullSize = undefined;\n  }\n  update(maxWidth, maxHeight, margins) {\n    const me = this;\n    me.maxWidth = maxWidth;\n    me.maxHeight = maxHeight;\n    me._margins = margins;\n    me.setDimensions();\n    me.buildLabels();\n    me.fit();\n  }\n  setDimensions() {\n    const me = this;\n    if (me.isHorizontal()) {\n      me.width = me.maxWidth;\n      me.left = me._margins.left;\n      me.right = me.width;\n    } else {\n      me.height = me.maxHeight;\n      me.top = me._margins.top;\n      me.bottom = me.height;\n    }\n  }\n  buildLabels() {\n    const me = this;\n    const labelOpts = me.options.labels || {};\n    let legendItems = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(labelOpts.generateLabels, [me.chart], me) || [];\n    if (labelOpts.filter) {\n      legendItems = legendItems.filter((item) => labelOpts.filter(item, me.chart.data));\n    }\n    if (labelOpts.sort) {\n      legendItems = legendItems.sort((a, b) => labelOpts.sort(a, b, me.chart.data));\n    }\n    if (me.options.reverse) {\n      legendItems.reverse();\n    }\n    me.legendItems = legendItems;\n  }\n  fit() {\n    const me = this;\n    const {options, ctx} = me;\n    if (!options.display) {\n      me.width = me.height = 0;\n      return;\n    }\n    const labelOpts = options.labels;\n    const labelFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(labelOpts.font);\n    const fontSize = labelFont.size;\n    const titleHeight = me._computeTitleHeight();\n    const {boxWidth, itemHeight} = getBoxSize(labelOpts, fontSize);\n    let width, height;\n    ctx.font = labelFont.string;\n    if (me.isHorizontal()) {\n      width = me.maxWidth;\n      height = me._fitRows(titleHeight, fontSize, boxWidth, itemHeight) + 10;\n    } else {\n      height = me.maxHeight;\n      width = me._fitCols(titleHeight, fontSize, boxWidth, itemHeight) + 10;\n    }\n    me.width = Math.min(width, options.maxWidth || me.maxWidth);\n    me.height = Math.min(height, options.maxHeight || me.maxHeight);\n  }\n  _fitRows(titleHeight, fontSize, boxWidth, itemHeight) {\n    const me = this;\n    const {ctx, maxWidth, options: {labels: {padding}}} = me;\n    const hitboxes = me.legendHitBoxes = [];\n    const lineWidths = me.lineWidths = [0];\n    const lineHeight = itemHeight + padding;\n    let totalHeight = titleHeight;\n    ctx.textAlign = 'left';\n    ctx.textBaseline = 'middle';\n    let row = -1;\n    let top = -lineHeight;\n    me.legendItems.forEach((legendItem, i) => {\n      const itemWidth = boxWidth + (fontSize / 2) + ctx.measureText(legendItem.text).width;\n      if (i === 0 || lineWidths[lineWidths.length - 1] + itemWidth + 2 * padding > maxWidth) {\n        totalHeight += lineHeight;\n        lineWidths[lineWidths.length - (i > 0 ? 0 : 1)] = 0;\n        top += lineHeight;\n        row++;\n      }\n      hitboxes[i] = {left: 0, top, row, width: itemWidth, height: itemHeight};\n      lineWidths[lineWidths.length - 1] += itemWidth + padding;\n    });\n    return totalHeight;\n  }\n  _fitCols(titleHeight, fontSize, boxWidth, itemHeight) {\n    const me = this;\n    const {ctx, maxHeight, options: {labels: {padding}}} = me;\n    const hitboxes = me.legendHitBoxes = [];\n    const columnSizes = me.columnSizes = [];\n    const heightLimit = maxHeight - titleHeight;\n    let totalWidth = padding;\n    let currentColWidth = 0;\n    let currentColHeight = 0;\n    let left = 0;\n    let col = 0;\n    me.legendItems.forEach((legendItem, i) => {\n      const itemWidth = boxWidth + (fontSize / 2) + ctx.measureText(legendItem.text).width;\n      if (i > 0 && currentColHeight + itemHeight + 2 * padding > heightLimit) {\n        totalWidth += currentColWidth + padding;\n        columnSizes.push({width: currentColWidth, height: currentColHeight});\n        left += currentColWidth + padding;\n        col++;\n        currentColWidth = currentColHeight = 0;\n      }\n      hitboxes[i] = {left, top: currentColHeight, col, width: itemWidth, height: itemHeight};\n      currentColWidth = Math.max(currentColWidth, itemWidth);\n      currentColHeight += itemHeight + padding;\n    });\n    totalWidth += currentColWidth;\n    columnSizes.push({width: currentColWidth, height: currentColHeight});\n    return totalWidth;\n  }\n  adjustHitBoxes() {\n    const me = this;\n    if (!me.options.display) {\n      return;\n    }\n    const titleHeight = me._computeTitleHeight();\n    const {legendHitBoxes: hitboxes, options: {align, labels: {padding}, rtl}} = me;\n    const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(rtl, me.left, me.width);\n    if (this.isHorizontal()) {\n      let row = 0;\n      let left = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, me.left + padding, me.right - me.lineWidths[row]);\n      for (const hitbox of hitboxes) {\n        if (row !== hitbox.row) {\n          row = hitbox.row;\n          left = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, me.left + padding, me.right - me.lineWidths[row]);\n        }\n        hitbox.top += me.top + titleHeight + padding;\n        hitbox.left = rtlHelper.leftForLtr(rtlHelper.x(left), hitbox.width);\n        left += hitbox.width + padding;\n      }\n    } else {\n      let col = 0;\n      let top = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, me.top + titleHeight + padding, me.bottom - me.columnSizes[col].height);\n      for (const hitbox of hitboxes) {\n        if (hitbox.col !== col) {\n          col = hitbox.col;\n          top = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, me.top + titleHeight + padding, me.bottom - me.columnSizes[col].height);\n        }\n        hitbox.top = top;\n        hitbox.left += me.left + padding;\n        hitbox.left = rtlHelper.leftForLtr(rtlHelper.x(hitbox.left), hitbox.width);\n        top += hitbox.height + padding;\n      }\n    }\n  }\n  isHorizontal() {\n    return this.options.position === 'top' || this.options.position === 'bottom';\n  }\n  draw() {\n    const me = this;\n    if (me.options.display) {\n      const ctx = me.ctx;\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.U)(ctx, me);\n      me._draw();\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.W)(ctx);\n    }\n  }\n  _draw() {\n    const me = this;\n    const {options: opts, columnSizes, lineWidths, ctx} = me;\n    const {align, labels: labelOpts} = opts;\n    const defaultColor = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.color;\n    const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(opts.rtl, me.left, me.width);\n    const labelFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(labelOpts.font);\n    const {color: fontColor, padding} = labelOpts;\n    const fontSize = labelFont.size;\n    const halfFontSize = fontSize / 2;\n    let cursor;\n    me.drawTitle();\n    ctx.textAlign = rtlHelper.textAlign('left');\n    ctx.textBaseline = 'middle';\n    ctx.lineWidth = 0.5;\n    ctx.font = labelFont.string;\n    const {boxWidth, boxHeight, itemHeight} = getBoxSize(labelOpts, fontSize);\n    const drawLegendBox = function(x, y, legendItem) {\n      if (isNaN(boxWidth) || boxWidth <= 0 || isNaN(boxHeight) || boxHeight < 0) {\n        return;\n      }\n      ctx.save();\n      const lineWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineWidth, 1);\n      ctx.fillStyle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.fillStyle, defaultColor);\n      ctx.lineCap = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineCap, 'butt');\n      ctx.lineDashOffset = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineDashOffset, 0);\n      ctx.lineJoin = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineJoin, 'miter');\n      ctx.lineWidth = lineWidth;\n      ctx.strokeStyle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.strokeStyle, defaultColor);\n      ctx.setLineDash((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineDash, []));\n      if (labelOpts.usePointStyle) {\n        const drawOptions = {\n          radius: boxWidth * Math.SQRT2 / 2,\n          pointStyle: legendItem.pointStyle,\n          rotation: legendItem.rotation,\n          borderWidth: lineWidth\n        };\n        const centerX = rtlHelper.xPlus(x, boxWidth / 2);\n        const centerY = y + halfFontSize;\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ao)(ctx, drawOptions, centerX, centerY);\n      } else {\n        const yBoxTop = y + Math.max((fontSize - boxHeight) / 2, 0);\n        const xBoxLeft = rtlHelper.leftForLtr(x, boxWidth);\n        const borderRadius = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ar)(legendItem.borderRadius);\n        ctx.beginPath();\n        if (Object.values(borderRadius).some(v => v !== 0)) {\n          (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ap)(ctx, {\n            x: xBoxLeft,\n            y: yBoxTop,\n            w: boxWidth,\n            h: boxHeight,\n            radius: borderRadius,\n          });\n        } else {\n          ctx.rect(xBoxLeft, yBoxTop, boxWidth, boxHeight);\n        }\n        ctx.fill();\n        if (lineWidth !== 0) {\n          ctx.stroke();\n        }\n      }\n      ctx.restore();\n    };\n    const fillText = function(x, y, legendItem) {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, legendItem.text, x, y + (itemHeight / 2), labelFont, {\n        strikethrough: legendItem.hidden,\n        textAlign: rtlHelper.textAlign(legendItem.textAlign)\n      });\n    };\n    const isHorizontal = me.isHorizontal();\n    const titleHeight = this._computeTitleHeight();\n    if (isHorizontal) {\n      cursor = {\n        x: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, me.left + padding, me.right - lineWidths[0]),\n        y: me.top + padding + titleHeight,\n        line: 0\n      };\n    } else {\n      cursor = {\n        x: me.left + padding,\n        y: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, me.top + titleHeight + padding, me.bottom - columnSizes[0].height),\n        line: 0\n      };\n    }\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.av)(me.ctx, opts.textDirection);\n    const lineHeight = itemHeight + padding;\n    me.legendItems.forEach((legendItem, i) => {\n      ctx.strokeStyle = legendItem.fontColor || fontColor;\n      ctx.fillStyle = legendItem.fontColor || fontColor;\n      const textWidth = ctx.measureText(legendItem.text).width;\n      const textAlign = rtlHelper.textAlign(legendItem.textAlign || (legendItem.textAlign = labelOpts.textAlign));\n      const width = boxWidth + halfFontSize + textWidth;\n      let x = cursor.x;\n      let y = cursor.y;\n      rtlHelper.setWidth(me.width);\n      if (isHorizontal) {\n        if (i > 0 && x + width + padding > me.right) {\n          y = cursor.y += lineHeight;\n          cursor.line++;\n          x = cursor.x = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, me.left + padding, me.right - lineWidths[cursor.line]);\n        }\n      } else if (i > 0 && y + lineHeight > me.bottom) {\n        x = cursor.x = x + columnSizes[cursor.line].width + padding;\n        cursor.line++;\n        y = cursor.y = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, me.top + titleHeight + padding, me.bottom - columnSizes[cursor.line].height);\n      }\n      const realX = rtlHelper.x(x);\n      drawLegendBox(realX, y, legendItem);\n      x = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aw)(textAlign, x + boxWidth + halfFontSize, isHorizontal ? x + width : me.right, opts.rtl);\n      fillText(rtlHelper.x(x), y, legendItem);\n      if (isHorizontal) {\n        cursor.x += width + padding;\n      } else {\n        cursor.y += lineHeight;\n      }\n    });\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ax)(me.ctx, opts.textDirection);\n  }\n  drawTitle() {\n    const me = this;\n    const opts = me.options;\n    const titleOpts = opts.title;\n    const titleFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(titleOpts.font);\n    const titlePadding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(titleOpts.padding);\n    if (!titleOpts.display) {\n      return;\n    }\n    const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(opts.rtl, me.left, me.width);\n    const ctx = me.ctx;\n    const position = titleOpts.position;\n    const halfFontSize = titleFont.size / 2;\n    const topPaddingPlusHalfFontSize = titlePadding.top + halfFontSize;\n    let y;\n    let left = me.left;\n    let maxWidth = me.width;\n    if (this.isHorizontal()) {\n      maxWidth = Math.max(...me.lineWidths);\n      y = me.top + topPaddingPlusHalfFontSize;\n      left = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(opts.align, left, me.right - maxWidth);\n    } else {\n      const maxHeight = me.columnSizes.reduce((acc, size) => Math.max(acc, size.height), 0);\n      y = topPaddingPlusHalfFontSize + (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(opts.align, me.top, me.bottom - maxHeight - opts.labels.padding - me._computeTitleHeight());\n    }\n    const x = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(position, left, left + maxWidth);\n    ctx.textAlign = rtlHelper.textAlign((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Y)(position));\n    ctx.textBaseline = 'middle';\n    ctx.strokeStyle = titleOpts.color;\n    ctx.fillStyle = titleOpts.color;\n    ctx.font = titleFont.string;\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, titleOpts.text, x, y, titleFont);\n  }\n  _computeTitleHeight() {\n    const titleOpts = this.options.title;\n    const titleFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(titleOpts.font);\n    const titlePadding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(titleOpts.padding);\n    return titleOpts.display ? titleFont.lineHeight + titlePadding.height : 0;\n  }\n  _getLegendItemAt(x, y) {\n    const me = this;\n    let i, hitBox, lh;\n    if (x >= me.left && x <= me.right && y >= me.top && y <= me.bottom) {\n      lh = me.legendHitBoxes;\n      for (i = 0; i < lh.length; ++i) {\n        hitBox = lh[i];\n        if (x >= hitBox.left && x <= hitBox.left + hitBox.width && y >= hitBox.top && y <= hitBox.top + hitBox.height) {\n          return me.legendItems[i];\n        }\n      }\n    }\n    return null;\n  }\n  handleEvent(e) {\n    const me = this;\n    const opts = me.options;\n    if (!isListened(e.type, opts)) {\n      return;\n    }\n    const hoveredItem = me._getLegendItemAt(e.x, e.y);\n    if (e.type === 'mousemove') {\n      const previous = me._hoveredItem;\n      const sameItem = itemsEqual(previous, hoveredItem);\n      if (previous && !sameItem) {\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(opts.onLeave, [e, previous, me], me);\n      }\n      me._hoveredItem = hoveredItem;\n      if (hoveredItem && !sameItem) {\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(opts.onHover, [e, hoveredItem, me], me);\n      }\n    } else if (hoveredItem) {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(opts.onClick, [e, hoveredItem, me], me);\n    }\n  }\n}\nfunction isListened(type, opts) {\n  if (type === 'mousemove' && (opts.onHover || opts.onLeave)) {\n    return true;\n  }\n  if (opts.onClick && (type === 'click' || type === 'mouseup')) {\n    return true;\n  }\n  return false;\n}\nvar plugin_legend = {\n  id: 'legend',\n  _element: Legend,\n  start(chart, _args, options) {\n    const legend = chart.legend = new Legend({ctx: chart.ctx, options, chart});\n    layouts.configure(chart, legend, options);\n    layouts.addBox(chart, legend);\n  },\n  stop(chart) {\n    layouts.removeBox(chart, chart.legend);\n    delete chart.legend;\n  },\n  beforeUpdate(chart, _args, options) {\n    const legend = chart.legend;\n    layouts.configure(chart, legend, options);\n    legend.options = options;\n  },\n  afterUpdate(chart) {\n    const legend = chart.legend;\n    legend.buildLabels();\n    legend.adjustHitBoxes();\n  },\n  afterEvent(chart, args) {\n    if (!args.replay) {\n      chart.legend.handleEvent(args.event);\n    }\n  },\n  defaults: {\n    display: true,\n    position: 'top',\n    align: 'center',\n    fullSize: true,\n    reverse: false,\n    weight: 1000,\n    onClick(e, legendItem, legend) {\n      const index = legendItem.datasetIndex;\n      const ci = legend.chart;\n      if (ci.isDatasetVisible(index)) {\n        ci.hide(index);\n        legendItem.hidden = true;\n      } else {\n        ci.show(index);\n        legendItem.hidden = false;\n      }\n    },\n    onHover: null,\n    onLeave: null,\n    labels: {\n      color: (ctx) => ctx.chart.options.color,\n      boxWidth: 40,\n      padding: 10,\n      generateLabels(chart) {\n        const datasets = chart.data.datasets;\n        const {labels: {usePointStyle, pointStyle, textAlign, color}} = chart.legend.options;\n        return chart._getSortedDatasetMetas().map((meta) => {\n          const style = meta.controller.getStyle(usePointStyle ? 0 : undefined);\n          const borderWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(style.borderWidth);\n          return {\n            text: datasets[meta.index].label,\n            fillStyle: style.backgroundColor,\n            fontColor: color,\n            hidden: !meta.visible,\n            lineCap: style.borderCapStyle,\n            lineDash: style.borderDash,\n            lineDashOffset: style.borderDashOffset,\n            lineJoin: style.borderJoinStyle,\n            lineWidth: (borderWidth.width + borderWidth.height) / 4,\n            strokeStyle: style.borderColor,\n            pointStyle: pointStyle || style.pointStyle,\n            rotation: style.rotation,\n            textAlign: textAlign || style.textAlign,\n            borderRadius: 0,\n            datasetIndex: meta.index\n          };\n        }, this);\n      }\n    },\n    title: {\n      color: (ctx) => ctx.chart.options.color,\n      display: false,\n      position: 'center',\n      text: '',\n    }\n  },\n  descriptors: {\n    _scriptable: (name) => !name.startsWith('on'),\n    labels: {\n      _scriptable: (name) => !['generateLabels', 'filter', 'sort'].includes(name),\n    }\n  },\n};\n\nclass Title extends Element {\n  constructor(config) {\n    super();\n    this.chart = config.chart;\n    this.options = config.options;\n    this.ctx = config.ctx;\n    this._padding = undefined;\n    this.top = undefined;\n    this.bottom = undefined;\n    this.left = undefined;\n    this.right = undefined;\n    this.width = undefined;\n    this.height = undefined;\n    this.position = undefined;\n    this.weight = undefined;\n    this.fullSize = undefined;\n  }\n  update(maxWidth, maxHeight) {\n    const me = this;\n    const opts = me.options;\n    me.left = 0;\n    me.top = 0;\n    if (!opts.display) {\n      me.width = me.height = me.right = me.bottom = 0;\n      return;\n    }\n    me.width = me.right = maxWidth;\n    me.height = me.bottom = maxHeight;\n    const lineCount = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(opts.text) ? opts.text.length : 1;\n    me._padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(opts.padding);\n    const textSize = lineCount * (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(opts.font).lineHeight + me._padding.height;\n    if (me.isHorizontal()) {\n      me.height = textSize;\n    } else {\n      me.width = textSize;\n    }\n  }\n  isHorizontal() {\n    const pos = this.options.position;\n    return pos === 'top' || pos === 'bottom';\n  }\n  _drawArgs(offset) {\n    const {top, left, bottom, right, options} = this;\n    const align = options.align;\n    let rotation = 0;\n    let maxWidth, titleX, titleY;\n    if (this.isHorizontal()) {\n      titleX = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, left, right);\n      titleY = top + offset;\n      maxWidth = right - left;\n    } else {\n      if (options.position === 'left') {\n        titleX = left + offset;\n        titleY = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, bottom, top);\n        rotation = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P * -0.5;\n      } else {\n        titleX = right - offset;\n        titleY = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(align, top, bottom);\n        rotation = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P * 0.5;\n      }\n      maxWidth = bottom - top;\n    }\n    return {titleX, titleY, maxWidth, rotation};\n  }\n  draw() {\n    const me = this;\n    const ctx = me.ctx;\n    const opts = me.options;\n    if (!opts.display) {\n      return;\n    }\n    const fontOpts = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(opts.font);\n    const lineHeight = fontOpts.lineHeight;\n    const offset = lineHeight / 2 + me._padding.top;\n    const {titleX, titleY, maxWidth, rotation} = me._drawArgs(offset);\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, opts.text, 0, 0, fontOpts, {\n      color: opts.color,\n      maxWidth,\n      rotation,\n      textAlign: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Y)(opts.align),\n      textBaseline: 'middle',\n      translation: [titleX, titleY],\n    });\n  }\n}\nfunction createTitle(chart, titleOpts) {\n  const title = new Title({\n    ctx: chart.ctx,\n    options: titleOpts,\n    chart\n  });\n  layouts.configure(chart, title, titleOpts);\n  layouts.addBox(chart, title);\n  chart.titleBlock = title;\n}\nvar plugin_title = {\n  id: 'title',\n  _element: Title,\n  start(chart, _args, options) {\n    createTitle(chart, options);\n  },\n  stop(chart) {\n    const titleBlock = chart.titleBlock;\n    layouts.removeBox(chart, titleBlock);\n    delete chart.titleBlock;\n  },\n  beforeUpdate(chart, _args, options) {\n    const title = chart.titleBlock;\n    layouts.configure(chart, title, options);\n    title.options = options;\n  },\n  defaults: {\n    align: 'center',\n    display: false,\n    font: {\n      weight: 'bold',\n    },\n    fullSize: true,\n    padding: 10,\n    position: 'top',\n    text: '',\n    weight: 2000\n  },\n  defaultRoutes: {\n    color: 'color'\n  },\n  descriptors: {\n    _scriptable: true,\n    _indexable: false,\n  },\n};\n\nconst map = new WeakMap();\nvar plugin_subtitle = {\n  id: 'subtitle',\n  start(chart, _args, options) {\n    const title = new Title({\n      ctx: chart.ctx,\n      options,\n      chart\n    });\n    layouts.configure(chart, title, options);\n    layouts.addBox(chart, title);\n    map.set(chart, title);\n  },\n  stop(chart) {\n    layouts.removeBox(chart, map.get(chart));\n    map.delete(chart);\n  },\n  beforeUpdate(chart, _args, options) {\n    const title = map.get(chart);\n    layouts.configure(chart, title, options);\n    title.options = options;\n  },\n  defaults: {\n    align: 'center',\n    display: false,\n    font: {\n      weight: 'normal',\n    },\n    fullSize: true,\n    padding: 0,\n    position: 'top',\n    text: '',\n    weight: 1500\n  },\n  defaultRoutes: {\n    color: 'color'\n  },\n  descriptors: {\n    _scriptable: true,\n    _indexable: false,\n  },\n};\n\nconst positioners = {\n  average(items) {\n    if (!items.length) {\n      return false;\n    }\n    let i, len;\n    let x = 0;\n    let y = 0;\n    let count = 0;\n    for (i = 0, len = items.length; i < len; ++i) {\n      const el = items[i].element;\n      if (el && el.hasValue()) {\n        const pos = el.tooltipPosition();\n        x += pos.x;\n        y += pos.y;\n        ++count;\n      }\n    }\n    return {\n      x: x / count,\n      y: y / count\n    };\n  },\n  nearest(items, eventPosition) {\n    if (!items.length) {\n      return false;\n    }\n    let x = eventPosition.x;\n    let y = eventPosition.y;\n    let minDistance = Number.POSITIVE_INFINITY;\n    let i, len, nearestElement;\n    for (i = 0, len = items.length; i < len; ++i) {\n      const el = items[i].element;\n      if (el && el.hasValue()) {\n        const center = el.getCenterPoint();\n        const d = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.az)(eventPosition, center);\n        if (d < minDistance) {\n          minDistance = d;\n          nearestElement = el;\n        }\n      }\n    }\n    if (nearestElement) {\n      const tp = nearestElement.tooltipPosition();\n      x = tp.x;\n      y = tp.y;\n    }\n    return {\n      x,\n      y\n    };\n  }\n};\nfunction pushOrConcat(base, toPush) {\n  if (toPush) {\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(toPush)) {\n      Array.prototype.push.apply(base, toPush);\n    } else {\n      base.push(toPush);\n    }\n  }\n  return base;\n}\nfunction splitNewlines(str) {\n  if ((typeof str === 'string' || str instanceof String) && str.indexOf('\\n') > -1) {\n    return str.split('\\n');\n  }\n  return str;\n}\nfunction createTooltipItem(chart, item) {\n  const {element, datasetIndex, index} = item;\n  const controller = chart.getDatasetMeta(datasetIndex).controller;\n  const {label, value} = controller.getLabelAndValue(index);\n  return {\n    chart,\n    label,\n    parsed: controller.getParsed(index),\n    raw: chart.data.datasets[datasetIndex].data[index],\n    formattedValue: value,\n    dataset: controller.getDataset(),\n    dataIndex: index,\n    datasetIndex,\n    element\n  };\n}\nfunction getTooltipSize(tooltip, options) {\n  const ctx = tooltip._chart.ctx;\n  const {body, footer, title} = tooltip;\n  const {boxWidth, boxHeight} = options;\n  const bodyFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(options.bodyFont);\n  const titleFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(options.titleFont);\n  const footerFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(options.footerFont);\n  const titleLineCount = title.length;\n  const footerLineCount = footer.length;\n  const bodyLineItemCount = body.length;\n  const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(options.padding);\n  let height = padding.height;\n  let width = 0;\n  let combinedBodyLength = body.reduce((count, bodyItem) => count + bodyItem.before.length + bodyItem.lines.length + bodyItem.after.length, 0);\n  combinedBodyLength += tooltip.beforeBody.length + tooltip.afterBody.length;\n  if (titleLineCount) {\n    height += titleLineCount * titleFont.lineHeight\n\t\t\t+ (titleLineCount - 1) * options.titleSpacing\n\t\t\t+ options.titleMarginBottom;\n  }\n  if (combinedBodyLength) {\n    const bodyLineHeight = options.displayColors ? Math.max(boxHeight, bodyFont.lineHeight) : bodyFont.lineHeight;\n    height += bodyLineItemCount * bodyLineHeight\n\t\t\t+ (combinedBodyLength - bodyLineItemCount) * bodyFont.lineHeight\n\t\t\t+ (combinedBodyLength - 1) * options.bodySpacing;\n  }\n  if (footerLineCount) {\n    height += options.footerMarginTop\n\t\t\t+ footerLineCount * footerFont.lineHeight\n\t\t\t+ (footerLineCount - 1) * options.footerSpacing;\n  }\n  let widthPadding = 0;\n  const maxLineWidth = function(line) {\n    width = Math.max(width, ctx.measureText(line).width + widthPadding);\n  };\n  ctx.save();\n  ctx.font = titleFont.string;\n  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(tooltip.title, maxLineWidth);\n  ctx.font = bodyFont.string;\n  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(tooltip.beforeBody.concat(tooltip.afterBody), maxLineWidth);\n  widthPadding = options.displayColors ? (boxWidth + 2) : 0;\n  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(body, (bodyItem) => {\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(bodyItem.before, maxLineWidth);\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(bodyItem.lines, maxLineWidth);\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(bodyItem.after, maxLineWidth);\n  });\n  widthPadding = 0;\n  ctx.font = footerFont.string;\n  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(tooltip.footer, maxLineWidth);\n  ctx.restore();\n  width += padding.width;\n  return {width, height};\n}\nfunction determineYAlign(chart, size) {\n  const {y, height} = size;\n  if (y < height / 2) {\n    return 'top';\n  } else if (y > (chart.height - height / 2)) {\n    return 'bottom';\n  }\n  return 'center';\n}\nfunction doesNotFitWithAlign(xAlign, chart, options, size) {\n  const {x, width} = size;\n  const caret = options.caretSize + options.caretPadding;\n  if (xAlign === 'left' && x + width + caret > chart.width) {\n    return true;\n  }\n  if (xAlign === 'right' && x - width - caret < 0) {\n    return true;\n  }\n}\nfunction determineXAlign(chart, options, size, yAlign) {\n  const {x, width} = size;\n  const {width: chartWidth, chartArea: {left, right}} = chart;\n  let xAlign = 'center';\n  if (yAlign === 'center') {\n    xAlign = x <= (left + right) / 2 ? 'left' : 'right';\n  } else if (x <= width / 2) {\n    xAlign = 'left';\n  } else if (x >= chartWidth - width / 2) {\n    xAlign = 'right';\n  }\n  if (doesNotFitWithAlign(xAlign, chart, options, size)) {\n    xAlign = 'center';\n  }\n  return xAlign;\n}\nfunction determineAlignment(chart, options, size) {\n  const yAlign = options.yAlign || determineYAlign(chart, size);\n  return {\n    xAlign: options.xAlign || determineXAlign(chart, options, size, yAlign),\n    yAlign\n  };\n}\nfunction alignX(size, xAlign) {\n  let {x, width} = size;\n  if (xAlign === 'right') {\n    x -= width;\n  } else if (xAlign === 'center') {\n    x -= (width / 2);\n  }\n  return x;\n}\nfunction alignY(size, yAlign, paddingAndSize) {\n  let {y, height} = size;\n  if (yAlign === 'top') {\n    y += paddingAndSize;\n  } else if (yAlign === 'bottom') {\n    y -= height + paddingAndSize;\n  } else {\n    y -= (height / 2);\n  }\n  return y;\n}\nfunction getBackgroundPoint(options, size, alignment, chart) {\n  const {caretSize, caretPadding, cornerRadius} = options;\n  const {xAlign, yAlign} = alignment;\n  const paddingAndSize = caretSize + caretPadding;\n  const radiusAndPadding = cornerRadius + caretPadding;\n  let x = alignX(size, xAlign);\n  const y = alignY(size, yAlign, paddingAndSize);\n  if (yAlign === 'center') {\n    if (xAlign === 'left') {\n      x += paddingAndSize;\n    } else if (xAlign === 'right') {\n      x -= paddingAndSize;\n    }\n  } else if (xAlign === 'left') {\n    x -= radiusAndPadding;\n  } else if (xAlign === 'right') {\n    x += radiusAndPadding;\n  }\n  return {\n    x: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(x, 0, chart.width - size.width),\n    y: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(y, 0, chart.height - size.height)\n  };\n}\nfunction getAlignedX(tooltip, align, options) {\n  const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(options.padding);\n  return align === 'center'\n    ? tooltip.x + tooltip.width / 2\n    : align === 'right'\n      ? tooltip.x + tooltip.width - padding.right\n      : tooltip.x + padding.left;\n}\nfunction getBeforeAfterBodyLines(callback) {\n  return pushOrConcat([], splitNewlines(callback));\n}\nfunction createTooltipContext(parent, tooltip, tooltipItems) {\n  return Object.assign(Object.create(parent), {\n    tooltip,\n    tooltipItems,\n    type: 'tooltip'\n  });\n}\nfunction overrideCallbacks(callbacks, context) {\n  const override = context && context.dataset && context.dataset.tooltip && context.dataset.tooltip.callbacks;\n  return override ? callbacks.override(override) : callbacks;\n}\nclass Tooltip extends Element {\n  constructor(config) {\n    super();\n    this.opacity = 0;\n    this._active = [];\n    this._chart = config._chart;\n    this._eventPosition = undefined;\n    this._size = undefined;\n    this._cachedAnimations = undefined;\n    this._tooltipItems = [];\n    this.$animations = undefined;\n    this.$context = undefined;\n    this.options = config.options;\n    this.dataPoints = undefined;\n    this.title = undefined;\n    this.beforeBody = undefined;\n    this.body = undefined;\n    this.afterBody = undefined;\n    this.footer = undefined;\n    this.xAlign = undefined;\n    this.yAlign = undefined;\n    this.x = undefined;\n    this.y = undefined;\n    this.height = undefined;\n    this.width = undefined;\n    this.caretX = undefined;\n    this.caretY = undefined;\n    this.labelColors = undefined;\n    this.labelPointStyles = undefined;\n    this.labelTextColors = undefined;\n  }\n  initialize(options) {\n    this.options = options;\n    this._cachedAnimations = undefined;\n    this.$context = undefined;\n  }\n  _resolveAnimations() {\n    const me = this;\n    const cached = me._cachedAnimations;\n    if (cached) {\n      return cached;\n    }\n    const chart = me._chart;\n    const options = me.options.setContext(me.getContext());\n    const opts = options.enabled && chart.options.animation && options.animations;\n    const animations = new Animations(me._chart, opts);\n    if (opts._cacheable) {\n      me._cachedAnimations = Object.freeze(animations);\n    }\n    return animations;\n  }\n  getContext() {\n    const me = this;\n    return me.$context ||\n\t\t\t(me.$context = createTooltipContext(me._chart.getContext(), me, me._tooltipItems));\n  }\n  getTitle(context, options) {\n    const me = this;\n    const {callbacks} = options;\n    const beforeTitle = callbacks.beforeTitle.apply(me, [context]);\n    const title = callbacks.title.apply(me, [context]);\n    const afterTitle = callbacks.afterTitle.apply(me, [context]);\n    let lines = [];\n    lines = pushOrConcat(lines, splitNewlines(beforeTitle));\n    lines = pushOrConcat(lines, splitNewlines(title));\n    lines = pushOrConcat(lines, splitNewlines(afterTitle));\n    return lines;\n  }\n  getBeforeBody(tooltipItems, options) {\n    return getBeforeAfterBodyLines(options.callbacks.beforeBody.apply(this, [tooltipItems]));\n  }\n  getBody(tooltipItems, options) {\n    const me = this;\n    const {callbacks} = options;\n    const bodyItems = [];\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(tooltipItems, (context) => {\n      const bodyItem = {\n        before: [],\n        lines: [],\n        after: []\n      };\n      const scoped = overrideCallbacks(callbacks, context);\n      pushOrConcat(bodyItem.before, splitNewlines(scoped.beforeLabel.call(me, context)));\n      pushOrConcat(bodyItem.lines, scoped.label.call(me, context));\n      pushOrConcat(bodyItem.after, splitNewlines(scoped.afterLabel.call(me, context)));\n      bodyItems.push(bodyItem);\n    });\n    return bodyItems;\n  }\n  getAfterBody(tooltipItems, options) {\n    return getBeforeAfterBodyLines(options.callbacks.afterBody.apply(this, [tooltipItems]));\n  }\n  getFooter(tooltipItems, options) {\n    const me = this;\n    const {callbacks} = options;\n    const beforeFooter = callbacks.beforeFooter.apply(me, [tooltipItems]);\n    const footer = callbacks.footer.apply(me, [tooltipItems]);\n    const afterFooter = callbacks.afterFooter.apply(me, [tooltipItems]);\n    let lines = [];\n    lines = pushOrConcat(lines, splitNewlines(beforeFooter));\n    lines = pushOrConcat(lines, splitNewlines(footer));\n    lines = pushOrConcat(lines, splitNewlines(afterFooter));\n    return lines;\n  }\n  _createItems(options) {\n    const me = this;\n    const active = me._active;\n    const data = me._chart.data;\n    const labelColors = [];\n    const labelPointStyles = [];\n    const labelTextColors = [];\n    let tooltipItems = [];\n    let i, len;\n    for (i = 0, len = active.length; i < len; ++i) {\n      tooltipItems.push(createTooltipItem(me._chart, active[i]));\n    }\n    if (options.filter) {\n      tooltipItems = tooltipItems.filter((element, index, array) => options.filter(element, index, array, data));\n    }\n    if (options.itemSort) {\n      tooltipItems = tooltipItems.sort((a, b) => options.itemSort(a, b, data));\n    }\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(tooltipItems, (context) => {\n      const scoped = overrideCallbacks(options.callbacks, context);\n      labelColors.push(scoped.labelColor.call(me, context));\n      labelPointStyles.push(scoped.labelPointStyle.call(me, context));\n      labelTextColors.push(scoped.labelTextColor.call(me, context));\n    });\n    me.labelColors = labelColors;\n    me.labelPointStyles = labelPointStyles;\n    me.labelTextColors = labelTextColors;\n    me.dataPoints = tooltipItems;\n    return tooltipItems;\n  }\n  update(changed, replay) {\n    const me = this;\n    const options = me.options.setContext(me.getContext());\n    const active = me._active;\n    let properties;\n    let tooltipItems = [];\n    if (!active.length) {\n      if (me.opacity !== 0) {\n        properties = {\n          opacity: 0\n        };\n      }\n    } else {\n      const position = positioners[options.position].call(me, active, me._eventPosition);\n      tooltipItems = me._createItems(options);\n      me.title = me.getTitle(tooltipItems, options);\n      me.beforeBody = me.getBeforeBody(tooltipItems, options);\n      me.body = me.getBody(tooltipItems, options);\n      me.afterBody = me.getAfterBody(tooltipItems, options);\n      me.footer = me.getFooter(tooltipItems, options);\n      const size = me._size = getTooltipSize(me, options);\n      const positionAndSize = Object.assign({}, position, size);\n      const alignment = determineAlignment(me._chart, options, positionAndSize);\n      const backgroundPoint = getBackgroundPoint(options, positionAndSize, alignment, me._chart);\n      me.xAlign = alignment.xAlign;\n      me.yAlign = alignment.yAlign;\n      properties = {\n        opacity: 1,\n        x: backgroundPoint.x,\n        y: backgroundPoint.y,\n        width: size.width,\n        height: size.height,\n        caretX: position.x,\n        caretY: position.y\n      };\n    }\n    me._tooltipItems = tooltipItems;\n    me.$context = undefined;\n    if (properties) {\n      me._resolveAnimations().update(me, properties);\n    }\n    if (changed && options.external) {\n      options.external.call(me, {chart: me._chart, tooltip: me, replay});\n    }\n  }\n  drawCaret(tooltipPoint, ctx, size, options) {\n    const caretPosition = this.getCaretPosition(tooltipPoint, size, options);\n    ctx.lineTo(caretPosition.x1, caretPosition.y1);\n    ctx.lineTo(caretPosition.x2, caretPosition.y2);\n    ctx.lineTo(caretPosition.x3, caretPosition.y3);\n  }\n  getCaretPosition(tooltipPoint, size, options) {\n    const {xAlign, yAlign} = this;\n    const {cornerRadius, caretSize} = options;\n    const {x: ptX, y: ptY} = tooltipPoint;\n    const {width, height} = size;\n    let x1, x2, x3, y1, y2, y3;\n    if (yAlign === 'center') {\n      y2 = ptY + (height / 2);\n      if (xAlign === 'left') {\n        x1 = ptX;\n        x2 = x1 - caretSize;\n        y1 = y2 + caretSize;\n        y3 = y2 - caretSize;\n      } else {\n        x1 = ptX + width;\n        x2 = x1 + caretSize;\n        y1 = y2 - caretSize;\n        y3 = y2 + caretSize;\n      }\n      x3 = x1;\n    } else {\n      if (xAlign === 'left') {\n        x2 = ptX + cornerRadius + (caretSize);\n      } else if (xAlign === 'right') {\n        x2 = ptX + width - cornerRadius - caretSize;\n      } else {\n        x2 = this.caretX;\n      }\n      if (yAlign === 'top') {\n        y1 = ptY;\n        y2 = y1 - caretSize;\n        x1 = x2 - caretSize;\n        x3 = x2 + caretSize;\n      } else {\n        y1 = ptY + height;\n        y2 = y1 + caretSize;\n        x1 = x2 + caretSize;\n        x3 = x2 - caretSize;\n      }\n      y3 = y1;\n    }\n    return {x1, x2, x3, y1, y2, y3};\n  }\n  drawTitle(pt, ctx, options) {\n    const me = this;\n    const title = me.title;\n    const length = title.length;\n    let titleFont, titleSpacing, i;\n    if (length) {\n      const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(options.rtl, me.x, me.width);\n      pt.x = getAlignedX(me, options.titleAlign, options);\n      ctx.textAlign = rtlHelper.textAlign(options.titleAlign);\n      ctx.textBaseline = 'middle';\n      titleFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(options.titleFont);\n      titleSpacing = options.titleSpacing;\n      ctx.fillStyle = options.titleColor;\n      ctx.font = titleFont.string;\n      for (i = 0; i < length; ++i) {\n        ctx.fillText(title[i], rtlHelper.x(pt.x), pt.y + titleFont.lineHeight / 2);\n        pt.y += titleFont.lineHeight + titleSpacing;\n        if (i + 1 === length) {\n          pt.y += options.titleMarginBottom - titleSpacing;\n        }\n      }\n    }\n  }\n  _drawColorBox(ctx, pt, i, rtlHelper, options) {\n    const me = this;\n    const labelColors = me.labelColors[i];\n    const labelPointStyle = me.labelPointStyles[i];\n    const {boxHeight, boxWidth} = options;\n    const bodyFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(options.bodyFont);\n    const colorX = getAlignedX(me, 'left', options);\n    const rtlColorX = rtlHelper.x(colorX);\n    const yOffSet = boxHeight < bodyFont.lineHeight ? (bodyFont.lineHeight - boxHeight) / 2 : 0;\n    const colorY = pt.y + yOffSet;\n    if (options.usePointStyle) {\n      const drawOptions = {\n        radius: Math.min(boxWidth, boxHeight) / 2,\n        pointStyle: labelPointStyle.pointStyle,\n        rotation: labelPointStyle.rotation,\n        borderWidth: 1\n      };\n      const centerX = rtlHelper.leftForLtr(rtlColorX, boxWidth) + boxWidth / 2;\n      const centerY = colorY + boxHeight / 2;\n      ctx.strokeStyle = options.multiKeyBackground;\n      ctx.fillStyle = options.multiKeyBackground;\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ao)(ctx, drawOptions, centerX, centerY);\n      ctx.strokeStyle = labelColors.borderColor;\n      ctx.fillStyle = labelColors.backgroundColor;\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ao)(ctx, drawOptions, centerX, centerY);\n    } else {\n      ctx.lineWidth = labelColors.borderWidth || 1;\n      ctx.strokeStyle = labelColors.borderColor;\n      ctx.setLineDash(labelColors.borderDash || []);\n      ctx.lineDashOffset = labelColors.borderDashOffset || 0;\n      const outerX = rtlHelper.leftForLtr(rtlColorX, boxWidth);\n      const innerX = rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX, 1), boxWidth - 2);\n      const borderRadius = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ar)(labelColors.borderRadius);\n      if (Object.values(borderRadius).some(v => v !== 0)) {\n        ctx.beginPath();\n        ctx.fillStyle = options.multiKeyBackground;\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ap)(ctx, {\n          x: outerX,\n          y: colorY,\n          w: boxWidth,\n          h: boxHeight,\n          radius: borderRadius,\n        });\n        ctx.fill();\n        ctx.stroke();\n        ctx.fillStyle = labelColors.backgroundColor;\n        ctx.beginPath();\n        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ap)(ctx, {\n          x: innerX,\n          y: colorY + 1,\n          w: boxWidth - 2,\n          h: boxHeight - 2,\n          radius: borderRadius,\n        });\n        ctx.fill();\n      } else {\n        ctx.fillStyle = options.multiKeyBackground;\n        ctx.fillRect(outerX, colorY, boxWidth, boxHeight);\n        ctx.strokeRect(outerX, colorY, boxWidth, boxHeight);\n        ctx.fillStyle = labelColors.backgroundColor;\n        ctx.fillRect(innerX, colorY + 1, boxWidth - 2, boxHeight - 2);\n      }\n    }\n    ctx.fillStyle = me.labelTextColors[i];\n  }\n  drawBody(pt, ctx, options) {\n    const me = this;\n    const {body} = me;\n    const {bodySpacing, bodyAlign, displayColors, boxHeight, boxWidth} = options;\n    const bodyFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(options.bodyFont);\n    let bodyLineHeight = bodyFont.lineHeight;\n    let xLinePadding = 0;\n    const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(options.rtl, me.x, me.width);\n    const fillLineOfText = function(line) {\n      ctx.fillText(line, rtlHelper.x(pt.x + xLinePadding), pt.y + bodyLineHeight / 2);\n      pt.y += bodyLineHeight + bodySpacing;\n    };\n    const bodyAlignForCalculation = rtlHelper.textAlign(bodyAlign);\n    let bodyItem, textColor, lines, i, j, ilen, jlen;\n    ctx.textAlign = bodyAlign;\n    ctx.textBaseline = 'middle';\n    ctx.font = bodyFont.string;\n    pt.x = getAlignedX(me, bodyAlignForCalculation, options);\n    ctx.fillStyle = options.bodyColor;\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(me.beforeBody, fillLineOfText);\n    xLinePadding = displayColors && bodyAlignForCalculation !== 'right'\n      ? bodyAlign === 'center' ? (boxWidth / 2 + 1) : (boxWidth + 2)\n      : 0;\n    for (i = 0, ilen = body.length; i < ilen; ++i) {\n      bodyItem = body[i];\n      textColor = me.labelTextColors[i];\n      ctx.fillStyle = textColor;\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(bodyItem.before, fillLineOfText);\n      lines = bodyItem.lines;\n      if (displayColors && lines.length) {\n        me._drawColorBox(ctx, pt, i, rtlHelper, options);\n        bodyLineHeight = Math.max(bodyFont.lineHeight, boxHeight);\n      }\n      for (j = 0, jlen = lines.length; j < jlen; ++j) {\n        fillLineOfText(lines[j]);\n        bodyLineHeight = bodyFont.lineHeight;\n      }\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(bodyItem.after, fillLineOfText);\n    }\n    xLinePadding = 0;\n    bodyLineHeight = bodyFont.lineHeight;\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(me.afterBody, fillLineOfText);\n    pt.y -= bodySpacing;\n  }\n  drawFooter(pt, ctx, options) {\n    const me = this;\n    const footer = me.footer;\n    const length = footer.length;\n    let footerFont, i;\n    if (length) {\n      const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(options.rtl, me.x, me.width);\n      pt.x = getAlignedX(me, options.footerAlign, options);\n      pt.y += options.footerMarginTop;\n      ctx.textAlign = rtlHelper.textAlign(options.footerAlign);\n      ctx.textBaseline = 'middle';\n      footerFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(options.footerFont);\n      ctx.fillStyle = options.footerColor;\n      ctx.font = footerFont.string;\n      for (i = 0; i < length; ++i) {\n        ctx.fillText(footer[i], rtlHelper.x(pt.x), pt.y + footerFont.lineHeight / 2);\n        pt.y += footerFont.lineHeight + options.footerSpacing;\n      }\n    }\n  }\n  drawBackground(pt, ctx, tooltipSize, options) {\n    const {xAlign, yAlign} = this;\n    const {x, y} = pt;\n    const {width, height} = tooltipSize;\n    const radius = options.cornerRadius;\n    ctx.fillStyle = options.backgroundColor;\n    ctx.strokeStyle = options.borderColor;\n    ctx.lineWidth = options.borderWidth;\n    ctx.beginPath();\n    ctx.moveTo(x + radius, y);\n    if (yAlign === 'top') {\n      this.drawCaret(pt, ctx, tooltipSize, options);\n    }\n    ctx.lineTo(x + width - radius, y);\n    ctx.quadraticCurveTo(x + width, y, x + width, y + radius);\n    if (yAlign === 'center' && xAlign === 'right') {\n      this.drawCaret(pt, ctx, tooltipSize, options);\n    }\n    ctx.lineTo(x + width, y + height - radius);\n    ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);\n    if (yAlign === 'bottom') {\n      this.drawCaret(pt, ctx, tooltipSize, options);\n    }\n    ctx.lineTo(x + radius, y + height);\n    ctx.quadraticCurveTo(x, y + height, x, y + height - radius);\n    if (yAlign === 'center' && xAlign === 'left') {\n      this.drawCaret(pt, ctx, tooltipSize, options);\n    }\n    ctx.lineTo(x, y + radius);\n    ctx.quadraticCurveTo(x, y, x + radius, y);\n    ctx.closePath();\n    ctx.fill();\n    if (options.borderWidth > 0) {\n      ctx.stroke();\n    }\n  }\n  _updateAnimationTarget(options) {\n    const me = this;\n    const chart = me._chart;\n    const anims = me.$animations;\n    const animX = anims && anims.x;\n    const animY = anims && anims.y;\n    if (animX || animY) {\n      const position = positioners[options.position].call(me, me._active, me._eventPosition);\n      if (!position) {\n        return;\n      }\n      const size = me._size = getTooltipSize(me, options);\n      const positionAndSize = Object.assign({}, position, me._size);\n      const alignment = determineAlignment(chart, options, positionAndSize);\n      const point = getBackgroundPoint(options, positionAndSize, alignment, chart);\n      if (animX._to !== point.x || animY._to !== point.y) {\n        me.xAlign = alignment.xAlign;\n        me.yAlign = alignment.yAlign;\n        me.width = size.width;\n        me.height = size.height;\n        me.caretX = position.x;\n        me.caretY = position.y;\n        me._resolveAnimations().update(me, point);\n      }\n    }\n  }\n  draw(ctx) {\n    const me = this;\n    const options = me.options.setContext(me.getContext());\n    let opacity = me.opacity;\n    if (!opacity) {\n      return;\n    }\n    me._updateAnimationTarget(options);\n    const tooltipSize = {\n      width: me.width,\n      height: me.height\n    };\n    const pt = {\n      x: me.x,\n      y: me.y\n    };\n    opacity = Math.abs(opacity) < 1e-3 ? 0 : opacity;\n    const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(options.padding);\n    const hasTooltipContent = me.title.length || me.beforeBody.length || me.body.length || me.afterBody.length || me.footer.length;\n    if (options.enabled && hasTooltipContent) {\n      ctx.save();\n      ctx.globalAlpha = opacity;\n      me.drawBackground(pt, ctx, tooltipSize, options);\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.av)(ctx, options.textDirection);\n      pt.y += padding.top;\n      me.drawTitle(pt, ctx, options);\n      me.drawBody(pt, ctx, options);\n      me.drawFooter(pt, ctx, options);\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ax)(ctx, options.textDirection);\n      ctx.restore();\n    }\n  }\n  getActiveElements() {\n    return this._active || [];\n  }\n  setActiveElements(activeElements, eventPosition) {\n    const me = this;\n    const lastActive = me._active;\n    const active = activeElements.map(({datasetIndex, index}) => {\n      const meta = me._chart.getDatasetMeta(datasetIndex);\n      if (!meta) {\n        throw new Error('Cannot find a dataset at index ' + datasetIndex);\n      }\n      return {\n        datasetIndex,\n        element: meta.data[index],\n        index,\n      };\n    });\n    const changed = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ad)(lastActive, active);\n    const positionChanged = me._positionChanged(active, eventPosition);\n    if (changed || positionChanged) {\n      me._active = active;\n      me._eventPosition = eventPosition;\n      me.update(true);\n    }\n  }\n  handleEvent(e, replay) {\n    const me = this;\n    const options = me.options;\n    const lastActive = me._active || [];\n    let changed = false;\n    let active = [];\n    if (e.type !== 'mouseout') {\n      active = me._chart.getElementsAtEventForMode(e, options.mode, options, replay);\n      if (options.reverse) {\n        active.reverse();\n      }\n    }\n    const positionChanged = me._positionChanged(active, e);\n    changed = replay || !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ad)(active, lastActive) || positionChanged;\n    if (changed) {\n      me._active = active;\n      if (options.enabled || options.external) {\n        me._eventPosition = {\n          x: e.x,\n          y: e.y\n        };\n        me.update(true, replay);\n      }\n    }\n    return changed;\n  }\n  _positionChanged(active, e) {\n    const {caretX, caretY, options} = this;\n    const position = positioners[options.position].call(this, active, e);\n    return position !== false && (caretX !== position.x || caretY !== position.y);\n  }\n}\nTooltip.positioners = positioners;\nvar plugin_tooltip = {\n  id: 'tooltip',\n  _element: Tooltip,\n  positioners,\n  afterInit(chart, _args, options) {\n    if (options) {\n      chart.tooltip = new Tooltip({_chart: chart, options});\n    }\n  },\n  beforeUpdate(chart, _args, options) {\n    if (chart.tooltip) {\n      chart.tooltip.initialize(options);\n    }\n  },\n  reset(chart, _args, options) {\n    if (chart.tooltip) {\n      chart.tooltip.initialize(options);\n    }\n  },\n  afterDraw(chart) {\n    const tooltip = chart.tooltip;\n    const args = {\n      tooltip\n    };\n    if (chart.notifyPlugins('beforeTooltipDraw', args) === false) {\n      return;\n    }\n    if (tooltip) {\n      tooltip.draw(chart.ctx);\n    }\n    chart.notifyPlugins('afterTooltipDraw', args);\n  },\n  afterEvent(chart, args) {\n    if (chart.tooltip) {\n      const useFinalPosition = args.replay;\n      if (chart.tooltip.handleEvent(args.event, useFinalPosition)) {\n        args.changed = true;\n      }\n    }\n  },\n  defaults: {\n    enabled: true,\n    external: null,\n    position: 'average',\n    backgroundColor: 'rgba(0,0,0,0.8)',\n    titleColor: '#fff',\n    titleFont: {\n      weight: 'bold',\n    },\n    titleSpacing: 2,\n    titleMarginBottom: 6,\n    titleAlign: 'left',\n    bodyColor: '#fff',\n    bodySpacing: 2,\n    bodyFont: {\n    },\n    bodyAlign: 'left',\n    footerColor: '#fff',\n    footerSpacing: 2,\n    footerMarginTop: 6,\n    footerFont: {\n      weight: 'bold',\n    },\n    footerAlign: 'left',\n    padding: 6,\n    caretPadding: 2,\n    caretSize: 5,\n    cornerRadius: 6,\n    boxHeight: (ctx, opts) => opts.bodyFont.size,\n    boxWidth: (ctx, opts) => opts.bodyFont.size,\n    multiKeyBackground: '#fff',\n    displayColors: true,\n    borderColor: 'rgba(0,0,0,0)',\n    borderWidth: 0,\n    animation: {\n      duration: 400,\n      easing: 'easeOutQuart',\n    },\n    animations: {\n      numbers: {\n        type: 'number',\n        properties: ['x', 'y', 'width', 'height', 'caretX', 'caretY'],\n      },\n      opacity: {\n        easing: 'linear',\n        duration: 200\n      }\n    },\n    callbacks: {\n      beforeTitle: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay,\n      title(tooltipItems) {\n        if (tooltipItems.length > 0) {\n          const item = tooltipItems[0];\n          const labels = item.chart.data.labels;\n          const labelCount = labels ? labels.length : 0;\n          if (this && this.options && this.options.mode === 'dataset') {\n            return item.dataset.label || '';\n          } else if (item.label) {\n            return item.label;\n          } else if (labelCount > 0 && item.dataIndex < labelCount) {\n            return labels[item.dataIndex];\n          }\n        }\n        return '';\n      },\n      afterTitle: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay,\n      beforeBody: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay,\n      beforeLabel: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay,\n      label(tooltipItem) {\n        if (this && this.options && this.options.mode === 'dataset') {\n          return tooltipItem.label + ': ' + tooltipItem.formattedValue || tooltipItem.formattedValue;\n        }\n        let label = tooltipItem.dataset.label || '';\n        if (label) {\n          label += ': ';\n        }\n        const value = tooltipItem.formattedValue;\n        if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(value)) {\n          label += value;\n        }\n        return label;\n      },\n      labelColor(tooltipItem) {\n        const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);\n        const options = meta.controller.getStyle(tooltipItem.dataIndex);\n        return {\n          borderColor: options.borderColor,\n          backgroundColor: options.backgroundColor,\n          borderWidth: options.borderWidth,\n          borderDash: options.borderDash,\n          borderDashOffset: options.borderDashOffset,\n          borderRadius: 0,\n        };\n      },\n      labelTextColor() {\n        return this.options.bodyColor;\n      },\n      labelPointStyle(tooltipItem) {\n        const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);\n        const options = meta.controller.getStyle(tooltipItem.dataIndex);\n        return {\n          pointStyle: options.pointStyle,\n          rotation: options.rotation,\n        };\n      },\n      afterLabel: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay,\n      afterBody: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay,\n      beforeFooter: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay,\n      footer: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay,\n      afterFooter: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay\n    }\n  },\n  defaultRoutes: {\n    bodyFont: 'font',\n    footerFont: 'font',\n    titleFont: 'font'\n  },\n  descriptors: {\n    _scriptable: (name) => name !== 'filter' && name !== 'itemSort' && name !== 'external',\n    _indexable: false,\n    callbacks: {\n      _scriptable: false,\n      _indexable: false,\n    },\n    animation: {\n      _fallback: false\n    },\n    animations: {\n      _fallback: 'animation'\n    }\n  },\n  additionalOptionScopes: ['interaction']\n};\n\nvar plugins = /*#__PURE__*/Object.freeze({\n__proto__: null,\nDecimation: plugin_decimation,\nFiller: plugin_filler,\nLegend: plugin_legend,\nSubTitle: plugin_subtitle,\nTitle: plugin_title,\nTooltip: plugin_tooltip\n});\n\nconst addIfString = (labels, raw, index) => typeof raw === 'string'\n  ? labels.push(raw) - 1\n  : isNaN(raw) ? null : index;\nfunction findOrAddLabel(labels, raw, index) {\n  const first = labels.indexOf(raw);\n  if (first === -1) {\n    return addIfString(labels, raw, index);\n  }\n  const last = labels.lastIndexOf(raw);\n  return first !== last ? index : first;\n}\nconst validIndex = (index, max) => index === null ? null : (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(Math.round(index), 0, max);\nclass CategoryScale extends Scale {\n  constructor(cfg) {\n    super(cfg);\n    this._startValue = undefined;\n    this._valueRange = 0;\n  }\n  parse(raw, index) {\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(raw)) {\n      return null;\n    }\n    const labels = this.getLabels();\n    index = isFinite(index) && labels[index] === raw ? index\n      : findOrAddLabel(labels, raw, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(index, raw));\n    return validIndex(index, labels.length - 1);\n  }\n  determineDataLimits() {\n    const me = this;\n    const {minDefined, maxDefined} = me.getUserBounds();\n    let {min, max} = me.getMinMax(true);\n    if (me.options.bounds === 'ticks') {\n      if (!minDefined) {\n        min = 0;\n      }\n      if (!maxDefined) {\n        max = me.getLabels().length - 1;\n      }\n    }\n    me.min = min;\n    me.max = max;\n  }\n  buildTicks() {\n    const me = this;\n    const min = me.min;\n    const max = me.max;\n    const offset = me.options.offset;\n    const ticks = [];\n    let labels = me.getLabels();\n    labels = (min === 0 && max === labels.length - 1) ? labels : labels.slice(min, max + 1);\n    me._valueRange = Math.max(labels.length - (offset ? 0 : 1), 1);\n    me._startValue = me.min - (offset ? 0.5 : 0);\n    for (let value = min; value <= max; value++) {\n      ticks.push({value});\n    }\n    return ticks;\n  }\n  getLabelForValue(value) {\n    const me = this;\n    const labels = me.getLabels();\n    if (value >= 0 && value < labels.length) {\n      return labels[value];\n    }\n    return value;\n  }\n  configure() {\n    const me = this;\n    super.configure();\n    if (!me.isHorizontal()) {\n      me._reversePixels = !me._reversePixels;\n    }\n  }\n  getPixelForValue(value) {\n    const me = this;\n    if (typeof value !== 'number') {\n      value = me.parse(value);\n    }\n    return value === null ? NaN : me.getPixelForDecimal((value - me._startValue) / me._valueRange);\n  }\n  getPixelForTick(index) {\n    const me = this;\n    const ticks = me.ticks;\n    if (index < 0 || index > ticks.length - 1) {\n      return null;\n    }\n    return me.getPixelForValue(ticks[index].value);\n  }\n  getValueForPixel(pixel) {\n    const me = this;\n    return Math.round(me._startValue + me.getDecimalForPixel(pixel) * me._valueRange);\n  }\n  getBasePixel() {\n    return this.bottom;\n  }\n}\nCategoryScale.id = 'category';\nCategoryScale.defaults = {\n  ticks: {\n    callback: CategoryScale.prototype.getLabelForValue\n  }\n};\n\nfunction generateTicks$1(generationOptions, dataRange) {\n  const ticks = [];\n  const MIN_SPACING = 1e-14;\n  const {bounds, step, min, max, precision, count, maxTicks, maxDigits, includeBounds} = generationOptions;\n  const unit = step || 1;\n  const maxSpaces = maxTicks - 1;\n  const {min: rmin, max: rmax} = dataRange;\n  const minDefined = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(min);\n  const maxDefined = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(max);\n  const countDefined = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(count);\n  const minSpacing = (rmax - rmin) / (maxDigits + 1);\n  let spacing = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aB)((rmax - rmin) / maxSpaces / unit) * unit;\n  let factor, niceMin, niceMax, numSpaces;\n  if (spacing < MIN_SPACING && !minDefined && !maxDefined) {\n    return [{value: rmin}, {value: rmax}];\n  }\n  numSpaces = Math.ceil(rmax / spacing) - Math.floor(rmin / spacing);\n  if (numSpaces > maxSpaces) {\n    spacing = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aB)(numSpaces * spacing / maxSpaces / unit) * unit;\n  }\n  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(precision)) {\n    factor = Math.pow(10, precision);\n    spacing = Math.ceil(spacing * factor) / factor;\n  }\n  if (bounds === 'ticks') {\n    niceMin = Math.floor(rmin / spacing) * spacing;\n    niceMax = Math.ceil(rmax / spacing) * spacing;\n  } else {\n    niceMin = rmin;\n    niceMax = rmax;\n  }\n  if (minDefined && maxDefined && step && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aC)((max - min) / step, spacing / 1000)) {\n    numSpaces = Math.round(Math.min((max - min) / spacing, maxTicks));\n    spacing = (max - min) / numSpaces;\n    niceMin = min;\n    niceMax = max;\n  } else if (countDefined) {\n    niceMin = minDefined ? min : niceMin;\n    niceMax = maxDefined ? max : niceMax;\n    numSpaces = count - 1;\n    spacing = (niceMax - niceMin) / numSpaces;\n  } else {\n    numSpaces = (niceMax - niceMin) / spacing;\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aD)(numSpaces, Math.round(numSpaces), spacing / 1000)) {\n      numSpaces = Math.round(numSpaces);\n    } else {\n      numSpaces = Math.ceil(numSpaces);\n    }\n  }\n  const decimalPlaces = Math.max(\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aE)(spacing),\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aE)(niceMin)\n  );\n  factor = Math.pow(10, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(precision) ? decimalPlaces : precision);\n  niceMin = Math.round(niceMin * factor) / factor;\n  niceMax = Math.round(niceMax * factor) / factor;\n  let j = 0;\n  if (minDefined) {\n    if (includeBounds && niceMin !== min) {\n      ticks.push({value: min});\n      if (niceMin < min) {\n        j++;\n      }\n      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aD)(Math.round((niceMin + j * spacing) * factor) / factor, min, relativeLabelSize(min, minSpacing, generationOptions))) {\n        j++;\n      }\n    } else if (niceMin < min) {\n      j++;\n    }\n  }\n  for (; j < numSpaces; ++j) {\n    ticks.push({value: Math.round((niceMin + j * spacing) * factor) / factor});\n  }\n  if (maxDefined && includeBounds && niceMax !== max) {\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aD)(ticks[ticks.length - 1].value, max, relativeLabelSize(max, minSpacing, generationOptions))) {\n      ticks[ticks.length - 1].value = max;\n    } else {\n      ticks.push({value: max});\n    }\n  } else if (!maxDefined || niceMax === max) {\n    ticks.push({value: niceMax});\n  }\n  return ticks;\n}\nfunction relativeLabelSize(value, minSpacing, {horizontal, minRotation}) {\n  const rad = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(minRotation);\n  const ratio = (horizontal ? Math.sin(rad) : Math.cos(rad)) || 0.001;\n  const length = 0.75 * minSpacing * ('' + value).length;\n  return Math.min(minSpacing / ratio, length);\n}\nclass LinearScaleBase extends Scale {\n  constructor(cfg) {\n    super(cfg);\n    this.start = undefined;\n    this.end = undefined;\n    this._startValue = undefined;\n    this._endValue = undefined;\n    this._valueRange = 0;\n  }\n  parse(raw, index) {\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(raw)) {\n      return null;\n    }\n    if ((typeof raw === 'number' || raw instanceof Number) && !isFinite(+raw)) {\n      return null;\n    }\n    return +raw;\n  }\n  handleTickRangeOptions() {\n    const me = this;\n    const {beginAtZero} = me.options;\n    const {minDefined, maxDefined} = me.getUserBounds();\n    let {min, max} = me;\n    const setMin = v => (min = minDefined ? min : v);\n    const setMax = v => (max = maxDefined ? max : v);\n    if (beginAtZero) {\n      const minSign = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(min);\n      const maxSign = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(max);\n      if (minSign < 0 && maxSign < 0) {\n        setMax(0);\n      } else if (minSign > 0 && maxSign > 0) {\n        setMin(0);\n      }\n    }\n    if (min === max) {\n      let offset = 1;\n      if (max >= Number.MAX_SAFE_INTEGER || min <= Number.MIN_SAFE_INTEGER) {\n        offset = Math.abs(max * 0.05);\n      }\n      setMax(max + offset);\n      if (!beginAtZero) {\n        setMin(min - offset);\n      }\n    }\n    me.min = min;\n    me.max = max;\n  }\n  getTickLimit() {\n    const me = this;\n    const tickOpts = me.options.ticks;\n    let {maxTicksLimit, stepSize} = tickOpts;\n    let maxTicks;\n    if (stepSize) {\n      maxTicks = Math.ceil(me.max / stepSize) - Math.floor(me.min / stepSize) + 1;\n    } else {\n      maxTicks = me.computeTickLimit();\n      maxTicksLimit = maxTicksLimit || 11;\n    }\n    if (maxTicksLimit) {\n      maxTicks = Math.min(maxTicksLimit, maxTicks);\n    }\n    return maxTicks;\n  }\n  computeTickLimit() {\n    return Number.POSITIVE_INFINITY;\n  }\n  buildTicks() {\n    const me = this;\n    const opts = me.options;\n    const tickOpts = opts.ticks;\n    let maxTicks = me.getTickLimit();\n    maxTicks = Math.max(2, maxTicks);\n    const numericGeneratorOptions = {\n      maxTicks,\n      bounds: opts.bounds,\n      min: opts.min,\n      max: opts.max,\n      precision: tickOpts.precision,\n      step: tickOpts.stepSize,\n      count: tickOpts.count,\n      maxDigits: me._maxDigits(),\n      horizontal: me.isHorizontal(),\n      minRotation: tickOpts.minRotation || 0,\n      includeBounds: tickOpts.includeBounds !== false\n    };\n    const dataRange = me._range || me;\n    const ticks = generateTicks$1(numericGeneratorOptions, dataRange);\n    if (opts.bounds === 'ticks') {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aA)(ticks, me, 'value');\n    }\n    if (opts.reverse) {\n      ticks.reverse();\n      me.start = me.max;\n      me.end = me.min;\n    } else {\n      me.start = me.min;\n      me.end = me.max;\n    }\n    return ticks;\n  }\n  configure() {\n    const me = this;\n    const ticks = me.ticks;\n    let start = me.min;\n    let end = me.max;\n    super.configure();\n    if (me.options.offset && ticks.length) {\n      const offset = (end - start) / Math.max(ticks.length - 1, 1) / 2;\n      start -= offset;\n      end += offset;\n    }\n    me._startValue = start;\n    me._endValue = end;\n    me._valueRange = end - start;\n  }\n  getLabelForValue(value) {\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.n)(value, this.chart.options.locale);\n  }\n}\n\nclass LinearScale extends LinearScaleBase {\n  determineDataLimits() {\n    const me = this;\n    const {min, max} = me.getMinMax(true);\n    me.min = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) ? min : 0;\n    me.max = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) ? max : 1;\n    me.handleTickRangeOptions();\n  }\n  computeTickLimit() {\n    const me = this;\n    const horizontal = me.isHorizontal();\n    const length = horizontal ? me.width : me.height;\n    const minRotation = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(me.options.ticks.minRotation);\n    const ratio = (horizontal ? Math.sin(minRotation) : Math.cos(minRotation)) || 0.001;\n    const tickFont = me._resolveTickFontOptions(0);\n    return Math.ceil(length / Math.min(40, tickFont.lineHeight / ratio));\n  }\n  getPixelForValue(value) {\n    return value === null ? NaN : this.getPixelForDecimal((value - this._startValue) / this._valueRange);\n  }\n  getValueForPixel(pixel) {\n    return this._startValue + this.getDecimalForPixel(pixel) * this._valueRange;\n  }\n}\nLinearScale.id = 'linear';\nLinearScale.defaults = {\n  ticks: {\n    callback: Ticks.formatters.numeric\n  }\n};\n\nfunction isMajor(tickVal) {\n  const remain = tickVal / (Math.pow(10, Math.floor((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(tickVal))));\n  return remain === 1;\n}\nfunction generateTicks(generationOptions, dataRange) {\n  const endExp = Math.floor((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(dataRange.max));\n  const endSignificand = Math.ceil(dataRange.max / Math.pow(10, endExp));\n  const ticks = [];\n  let tickVal = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(generationOptions.min, Math.pow(10, Math.floor((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(dataRange.min))));\n  let exp = Math.floor((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(tickVal));\n  let significand = Math.floor(tickVal / Math.pow(10, exp));\n  let precision = exp < 0 ? Math.pow(10, Math.abs(exp)) : 1;\n  do {\n    ticks.push({value: tickVal, major: isMajor(tickVal)});\n    ++significand;\n    if (significand === 10) {\n      significand = 1;\n      ++exp;\n      precision = exp >= 0 ? 1 : precision;\n    }\n    tickVal = Math.round(significand * Math.pow(10, exp) * precision) / precision;\n  } while (exp < endExp || (exp === endExp && significand < endSignificand));\n  const lastTick = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(generationOptions.max, tickVal);\n  ticks.push({value: lastTick, major: isMajor(tickVal)});\n  return ticks;\n}\nclass LogarithmicScale extends Scale {\n  constructor(cfg) {\n    super(cfg);\n    this.start = undefined;\n    this.end = undefined;\n    this._startValue = undefined;\n    this._valueRange = 0;\n  }\n  parse(raw, index) {\n    const value = LinearScaleBase.prototype.parse.apply(this, [raw, index]);\n    if (value === 0) {\n      this._zero = true;\n      return undefined;\n    }\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(value) && value > 0 ? value : null;\n  }\n  determineDataLimits() {\n    const me = this;\n    const {min, max} = me.getMinMax(true);\n    me.min = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) ? Math.max(0, min) : null;\n    me.max = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) ? Math.max(0, max) : null;\n    if (me.options.beginAtZero) {\n      me._zero = true;\n    }\n    me.handleTickRangeOptions();\n  }\n  handleTickRangeOptions() {\n    const me = this;\n    const {minDefined, maxDefined} = me.getUserBounds();\n    let min = me.min;\n    let max = me.max;\n    const setMin = v => (min = minDefined ? min : v);\n    const setMax = v => (max = maxDefined ? max : v);\n    const exp = (v, m) => Math.pow(10, Math.floor((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(v)) + m);\n    if (min === max) {\n      if (min <= 0) {\n        setMin(1);\n        setMax(10);\n      } else {\n        setMin(exp(min, -1));\n        setMax(exp(max, +1));\n      }\n    }\n    if (min <= 0) {\n      setMin(exp(max, -1));\n    }\n    if (max <= 0) {\n      setMax(exp(min, +1));\n    }\n    if (me._zero && me.min !== me._suggestedMin && min === exp(me.min, 0)) {\n      setMin(exp(min, -1));\n    }\n    me.min = min;\n    me.max = max;\n  }\n  buildTicks() {\n    const me = this;\n    const opts = me.options;\n    const generationOptions = {\n      min: me._userMin,\n      max: me._userMax\n    };\n    const ticks = generateTicks(generationOptions, me);\n    if (opts.bounds === 'ticks') {\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aA)(ticks, me, 'value');\n    }\n    if (opts.reverse) {\n      ticks.reverse();\n      me.start = me.max;\n      me.end = me.min;\n    } else {\n      me.start = me.min;\n      me.end = me.max;\n    }\n    return ticks;\n  }\n  getLabelForValue(value) {\n    return value === undefined ? '0' : (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.n)(value, this.chart.options.locale);\n  }\n  configure() {\n    const me = this;\n    const start = me.min;\n    super.configure();\n    me._startValue = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(start);\n    me._valueRange = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(me.max) - (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(start);\n  }\n  getPixelForValue(value) {\n    const me = this;\n    if (value === undefined || value === 0) {\n      value = me.min;\n    }\n    if (value === null || isNaN(value)) {\n      return NaN;\n    }\n    return me.getPixelForDecimal(value === me.min\n      ? 0\n      : ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(value) - me._startValue) / me._valueRange);\n  }\n  getValueForPixel(pixel) {\n    const me = this;\n    const decimal = me.getDecimalForPixel(pixel);\n    return Math.pow(10, me._startValue + decimal * me._valueRange);\n  }\n}\nLogarithmicScale.id = 'logarithmic';\nLogarithmicScale.defaults = {\n  ticks: {\n    callback: Ticks.formatters.logarithmic,\n    major: {\n      enabled: true\n    }\n  }\n};\n\nfunction getTickBackdropHeight(opts) {\n  const tickOpts = opts.ticks;\n  if (tickOpts.display && opts.display) {\n    const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(tickOpts.backdropPadding);\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(tickOpts.font && tickOpts.font.size, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.font.size) + padding.height;\n  }\n  return 0;\n}\nfunction measureLabelSize(ctx, font, label) {\n  label = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(label) ? label : [label];\n  return {\n    w: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF)(ctx, font.string, label),\n    h: label.length * font.lineHeight\n  };\n}\nfunction determineLimits(angle, pos, size, min, max) {\n  if (angle === min || angle === max) {\n    return {\n      start: pos - (size / 2),\n      end: pos + (size / 2)\n    };\n  } else if (angle < min || angle > max) {\n    return {\n      start: pos - size,\n      end: pos\n    };\n  }\n  return {\n    start: pos,\n    end: pos + size\n  };\n}\nfunction fitWithPointLabels(scale) {\n  const furthestLimits = {\n    l: 0,\n    r: scale.width,\n    t: 0,\n    b: scale.height - scale.paddingTop\n  };\n  const furthestAngles = {};\n  const labelSizes = [];\n  const padding = [];\n  const valueCount = scale.getLabels().length;\n  for (let i = 0; i < valueCount; i++) {\n    const opts = scale.options.pointLabels.setContext(scale.getPointLabelContext(i));\n    padding[i] = opts.padding;\n    const pointPosition = scale.getPointPosition(i, scale.drawingArea + padding[i]);\n    const plFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(opts.font);\n    const textSize = measureLabelSize(scale.ctx, plFont, scale._pointLabels[i]);\n    labelSizes[i] = textSize;\n    const angleRadians = scale.getIndexAngle(i);\n    const angle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(angleRadians);\n    const hLimits = determineLimits(angle, pointPosition.x, textSize.w, 0, 180);\n    const vLimits = determineLimits(angle, pointPosition.y, textSize.h, 90, 270);\n    if (hLimits.start < furthestLimits.l) {\n      furthestLimits.l = hLimits.start;\n      furthestAngles.l = angleRadians;\n    }\n    if (hLimits.end > furthestLimits.r) {\n      furthestLimits.r = hLimits.end;\n      furthestAngles.r = angleRadians;\n    }\n    if (vLimits.start < furthestLimits.t) {\n      furthestLimits.t = vLimits.start;\n      furthestAngles.t = angleRadians;\n    }\n    if (vLimits.end > furthestLimits.b) {\n      furthestLimits.b = vLimits.end;\n      furthestAngles.b = angleRadians;\n    }\n  }\n  scale._setReductions(scale.drawingArea, furthestLimits, furthestAngles);\n  scale._pointLabelItems = buildPointLabelItems(scale, labelSizes, padding);\n}\nfunction buildPointLabelItems(scale, labelSizes, padding) {\n  const items = [];\n  const valueCount = scale.getLabels().length;\n  const opts = scale.options;\n  const tickBackdropHeight = getTickBackdropHeight(opts);\n  const outerDistance = scale.getDistanceFromCenterForValue(opts.ticks.reverse ? scale.min : scale.max);\n  for (let i = 0; i < valueCount; i++) {\n    const extra = (i === 0 ? tickBackdropHeight / 2 : 0);\n    const pointLabelPosition = scale.getPointPosition(i, outerDistance + extra + padding[i]);\n    const angle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(scale.getIndexAngle(i));\n    const size = labelSizes[i];\n    const y = yForAngle(pointLabelPosition.y, size.h, angle);\n    const textAlign = getTextAlignForAngle(angle);\n    const left = leftForTextAlign(pointLabelPosition.x, size.w, textAlign);\n    items.push({\n      x: pointLabelPosition.x,\n      y,\n      textAlign,\n      left,\n      top: y,\n      right: left + size.w,\n      bottom: y + size.h\n    });\n  }\n  return items;\n}\nfunction getTextAlignForAngle(angle) {\n  if (angle === 0 || angle === 180) {\n    return 'center';\n  } else if (angle < 180) {\n    return 'left';\n  }\n  return 'right';\n}\nfunction leftForTextAlign(x, w, align) {\n  if (align === 'right') {\n    x -= w;\n  } else if (align === 'center') {\n    x -= (w / 2);\n  }\n  return x;\n}\nfunction yForAngle(y, h, angle) {\n  if (angle === 90 || angle === 270) {\n    y -= (h / 2);\n  } else if (angle > 270 || angle < 90) {\n    y -= h;\n  }\n  return y;\n}\nfunction drawPointLabels(scale, labelCount) {\n  const {ctx, options: {pointLabels}} = scale;\n  for (let i = labelCount - 1; i >= 0; i--) {\n    const optsAtIndex = pointLabels.setContext(scale.getPointLabelContext(i));\n    const plFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(optsAtIndex.font);\n    const {x, y, textAlign, left, top, right, bottom} = scale._pointLabelItems[i];\n    const {backdropColor} = optsAtIndex;\n    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(backdropColor)) {\n      const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(optsAtIndex.backdropPadding);\n      ctx.fillStyle = backdropColor;\n      ctx.fillRect(left - padding.left, top - padding.top, right - left + padding.width, bottom - top + padding.height);\n    }\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.V)(\n      ctx,\n      scale._pointLabels[i],\n      x,\n      y + (plFont.lineHeight / 2),\n      plFont,\n      {\n        color: optsAtIndex.color,\n        textAlign: textAlign,\n        textBaseline: 'middle'\n      }\n    );\n  }\n}\nfunction pathRadiusLine(scale, radius, circular, labelCount) {\n  const {ctx} = scale;\n  if (circular) {\n    ctx.arc(scale.xCenter, scale.yCenter, radius, 0, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T);\n  } else {\n    let pointPosition = scale.getPointPosition(0, radius);\n    ctx.moveTo(pointPosition.x, pointPosition.y);\n    for (let i = 1; i < labelCount; i++) {\n      pointPosition = scale.getPointPosition(i, radius);\n      ctx.lineTo(pointPosition.x, pointPosition.y);\n    }\n  }\n}\nfunction drawRadiusLine(scale, gridLineOpts, radius, labelCount) {\n  const ctx = scale.ctx;\n  const circular = gridLineOpts.circular;\n  const {color, lineWidth} = gridLineOpts;\n  if ((!circular && !labelCount) || !color || !lineWidth || radius < 0) {\n    return;\n  }\n  ctx.save();\n  ctx.strokeStyle = color;\n  ctx.lineWidth = lineWidth;\n  ctx.setLineDash(gridLineOpts.borderDash);\n  ctx.lineDashOffset = gridLineOpts.borderDashOffset;\n  ctx.beginPath();\n  pathRadiusLine(scale, radius, circular, labelCount);\n  ctx.closePath();\n  ctx.stroke();\n  ctx.restore();\n}\nfunction numberOrZero(param) {\n  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(param) ? param : 0;\n}\nfunction createPointLabelContext(parent, index, label) {\n  return Object.assign(Object.create(parent), {\n    label,\n    index,\n    type: 'pointLabel'\n  });\n}\nclass RadialLinearScale extends LinearScaleBase {\n  constructor(cfg) {\n    super(cfg);\n    this.xCenter = undefined;\n    this.yCenter = undefined;\n    this.drawingArea = undefined;\n    this._pointLabels = [];\n    this._pointLabelItems = [];\n  }\n  setDimensions() {\n    const me = this;\n    me.width = me.maxWidth;\n    me.height = me.maxHeight;\n    me.paddingTop = getTickBackdropHeight(me.options) / 2;\n    me.xCenter = Math.floor(me.width / 2);\n    me.yCenter = Math.floor((me.height - me.paddingTop) / 2);\n    me.drawingArea = Math.min(me.height - me.paddingTop, me.width) / 2;\n  }\n  determineDataLimits() {\n    const me = this;\n    const {min, max} = me.getMinMax(false);\n    me.min = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) && !isNaN(min) ? min : 0;\n    me.max = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) && !isNaN(max) ? max : 0;\n    me.handleTickRangeOptions();\n  }\n  computeTickLimit() {\n    return Math.ceil(this.drawingArea / getTickBackdropHeight(this.options));\n  }\n  generateTickLabels(ticks) {\n    const me = this;\n    LinearScaleBase.prototype.generateTickLabels.call(me, ticks);\n    me._pointLabels = me.getLabels().map((value, index) => {\n      const label = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(me.options.pointLabels.callback, [value, index], me);\n      return label || label === 0 ? label : '';\n    });\n  }\n  fit() {\n    const me = this;\n    const opts = me.options;\n    if (opts.display && opts.pointLabels.display) {\n      fitWithPointLabels(me);\n    } else {\n      me.setCenterPoint(0, 0, 0, 0);\n    }\n  }\n  _setReductions(largestPossibleRadius, furthestLimits, furthestAngles) {\n    const me = this;\n    let radiusReductionLeft = furthestLimits.l / Math.sin(furthestAngles.l);\n    let radiusReductionRight = Math.max(furthestLimits.r - me.width, 0) / Math.sin(furthestAngles.r);\n    let radiusReductionTop = -furthestLimits.t / Math.cos(furthestAngles.t);\n    let radiusReductionBottom = -Math.max(furthestLimits.b - (me.height - me.paddingTop), 0) / Math.cos(furthestAngles.b);\n    radiusReductionLeft = numberOrZero(radiusReductionLeft);\n    radiusReductionRight = numberOrZero(radiusReductionRight);\n    radiusReductionTop = numberOrZero(radiusReductionTop);\n    radiusReductionBottom = numberOrZero(radiusReductionBottom);\n    me.drawingArea = Math.max(largestPossibleRadius / 2, Math.min(\n      Math.floor(largestPossibleRadius - (radiusReductionLeft + radiusReductionRight) / 2),\n      Math.floor(largestPossibleRadius - (radiusReductionTop + radiusReductionBottom) / 2)));\n    me.setCenterPoint(radiusReductionLeft, radiusReductionRight, radiusReductionTop, radiusReductionBottom);\n  }\n  setCenterPoint(leftMovement, rightMovement, topMovement, bottomMovement) {\n    const me = this;\n    const maxRight = me.width - rightMovement - me.drawingArea;\n    const maxLeft = leftMovement + me.drawingArea;\n    const maxTop = topMovement + me.drawingArea;\n    const maxBottom = (me.height - me.paddingTop) - bottomMovement - me.drawingArea;\n    me.xCenter = Math.floor(((maxLeft + maxRight) / 2) + me.left);\n    me.yCenter = Math.floor(((maxTop + maxBottom) / 2) + me.top + me.paddingTop);\n  }\n  getIndexAngle(index) {\n    const angleMultiplier = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T / this.getLabels().length;\n    const startAngle = this.options.startAngle || 0;\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.at)(index * angleMultiplier + (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(startAngle));\n  }\n  getDistanceFromCenterForValue(value) {\n    const me = this;\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(value)) {\n      return NaN;\n    }\n    const scalingFactor = me.drawingArea / (me.max - me.min);\n    if (me.options.reverse) {\n      return (me.max - value) * scalingFactor;\n    }\n    return (value - me.min) * scalingFactor;\n  }\n  getValueForDistanceFromCenter(distance) {\n    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(distance)) {\n      return NaN;\n    }\n    const me = this;\n    const scaledDistance = distance / (me.drawingArea / (me.max - me.min));\n    return me.options.reverse ? me.max - scaledDistance : me.min + scaledDistance;\n  }\n  getPointLabelContext(index) {\n    const me = this;\n    const pointLabels = me._pointLabels || [];\n    if (index >= 0 && index < pointLabels.length) {\n      const pointLabel = pointLabels[index];\n      return createPointLabelContext(me.getContext(), index, pointLabel);\n    }\n  }\n  getPointPosition(index, distanceFromCenter) {\n    const me = this;\n    const angle = me.getIndexAngle(index) - _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H;\n    return {\n      x: Math.cos(angle) * distanceFromCenter + me.xCenter,\n      y: Math.sin(angle) * distanceFromCenter + me.yCenter,\n      angle\n    };\n  }\n  getPointPositionForValue(index, value) {\n    return this.getPointPosition(index, this.getDistanceFromCenterForValue(value));\n  }\n  getBasePosition(index) {\n    return this.getPointPositionForValue(index || 0, this.getBaseValue());\n  }\n  getPointLabelPosition(index) {\n    const {left, top, right, bottom} = this._pointLabelItems[index];\n    return {\n      left,\n      top,\n      right,\n      bottom,\n    };\n  }\n  drawBackground() {\n    const me = this;\n    const {backgroundColor, grid: {circular}} = me.options;\n    if (backgroundColor) {\n      const ctx = me.ctx;\n      ctx.save();\n      ctx.beginPath();\n      pathRadiusLine(me, me.getDistanceFromCenterForValue(me._endValue), circular, me.getLabels().length);\n      ctx.closePath();\n      ctx.fillStyle = backgroundColor;\n      ctx.fill();\n      ctx.restore();\n    }\n  }\n  drawGrid() {\n    const me = this;\n    const ctx = me.ctx;\n    const opts = me.options;\n    const {angleLines, grid} = opts;\n    const labelCount = me.getLabels().length;\n    let i, offset, position;\n    if (opts.pointLabels.display) {\n      drawPointLabels(me, labelCount);\n    }\n    if (grid.display) {\n      me.ticks.forEach((tick, index) => {\n        if (index !== 0) {\n          offset = me.getDistanceFromCenterForValue(tick.value);\n          const optsAtIndex = grid.setContext(me.getContext(index - 1));\n          drawRadiusLine(me, optsAtIndex, offset, labelCount);\n        }\n      });\n    }\n    if (angleLines.display) {\n      ctx.save();\n      for (i = me.getLabels().length - 1; i >= 0; i--) {\n        const optsAtIndex = angleLines.setContext(me.getPointLabelContext(i));\n        const {color, lineWidth} = optsAtIndex;\n        if (!lineWidth || !color) {\n          continue;\n        }\n        ctx.lineWidth = lineWidth;\n        ctx.strokeStyle = color;\n        ctx.setLineDash(optsAtIndex.borderDash);\n        ctx.lineDashOffset = optsAtIndex.borderDashOffset;\n        offset = me.getDistanceFromCenterForValue(opts.ticks.reverse ? me.min : me.max);\n        position = me.getPointPosition(i, offset);\n        ctx.beginPath();\n        ctx.moveTo(me.xCenter, me.yCenter);\n        ctx.lineTo(position.x, position.y);\n        ctx.stroke();\n      }\n      ctx.restore();\n    }\n  }\n  drawBorder() {}\n  drawLabels() {\n    const me = this;\n    const ctx = me.ctx;\n    const opts = me.options;\n    const tickOpts = opts.ticks;\n    if (!tickOpts.display) {\n      return;\n    }\n    const startAngle = me.getIndexAngle(0);\n    let offset, width;\n    ctx.save();\n    ctx.translate(me.xCenter, me.yCenter);\n    ctx.rotate(startAngle);\n    ctx.textAlign = 'center';\n    ctx.textBaseline = 'middle';\n    me.ticks.forEach((tick, index) => {\n      if (index === 0 && !opts.reverse) {\n        return;\n      }\n      const optsAtIndex = tickOpts.setContext(me.getContext(index));\n      const tickFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(optsAtIndex.font);\n      offset = me.getDistanceFromCenterForValue(me.ticks[index].value);\n      if (optsAtIndex.showLabelBackdrop) {\n        ctx.font = tickFont.string;\n        width = ctx.measureText(tick.label).width;\n        ctx.fillStyle = optsAtIndex.backdropColor;\n        const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A)(optsAtIndex.backdropPadding);\n        ctx.fillRect(\n          -width / 2 - padding.left,\n          -offset - tickFont.size / 2 - padding.top,\n          width + padding.width,\n          tickFont.size + padding.height\n        );\n      }\n      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, tick.label, 0, -offset, tickFont, {\n        color: optsAtIndex.color,\n      });\n    });\n    ctx.restore();\n  }\n  drawTitle() {}\n}\nRadialLinearScale.id = 'radialLinear';\nRadialLinearScale.defaults = {\n  display: true,\n  animate: true,\n  position: 'chartArea',\n  angleLines: {\n    display: true,\n    lineWidth: 1,\n    borderDash: [],\n    borderDashOffset: 0.0\n  },\n  grid: {\n    circular: false\n  },\n  startAngle: 0,\n  ticks: {\n    showLabelBackdrop: true,\n    callback: Ticks.formatters.numeric\n  },\n  pointLabels: {\n    backdropColor: undefined,\n    backdropPadding: 2,\n    display: true,\n    font: {\n      size: 10\n    },\n    callback(label) {\n      return label;\n    },\n    padding: 5\n  }\n};\nRadialLinearScale.defaultRoutes = {\n  'angleLines.color': 'borderColor',\n  'pointLabels.color': 'color',\n  'ticks.color': 'color'\n};\nRadialLinearScale.descriptors = {\n  angleLines: {\n    _fallback: 'grid'\n  }\n};\n\nconst INTERVALS = {\n  millisecond: {common: true, size: 1, steps: 1000},\n  second: {common: true, size: 1000, steps: 60},\n  minute: {common: true, size: 60000, steps: 60},\n  hour: {common: true, size: 3600000, steps: 24},\n  day: {common: true, size: 86400000, steps: 30},\n  week: {common: false, size: 604800000, steps: 4},\n  month: {common: true, size: 2.628e9, steps: 12},\n  quarter: {common: false, size: 7.884e9, steps: 4},\n  year: {common: true, size: 3.154e10}\n};\nconst UNITS = (Object.keys(INTERVALS));\nfunction sorter(a, b) {\n  return a - b;\n}\nfunction parse(scale, input) {\n  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(input)) {\n    return null;\n  }\n  const adapter = scale._adapter;\n  const {parser, round, isoWeekday} = scale._parseOpts;\n  let value = input;\n  if (typeof parser === 'function') {\n    value = parser(value);\n  }\n  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(value)) {\n    value = typeof parser === 'string'\n      ? adapter.parse(value, parser)\n      : adapter.parse(value);\n  }\n  if (value === null) {\n    return null;\n  }\n  if (round) {\n    value = round === 'week' && ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(isoWeekday) || isoWeekday === true)\n      ? adapter.startOf(value, 'isoWeek', isoWeekday)\n      : adapter.startOf(value, round);\n  }\n  return +value;\n}\nfunction determineUnitForAutoTicks(minUnit, min, max, capacity) {\n  const ilen = UNITS.length;\n  for (let i = UNITS.indexOf(minUnit); i < ilen - 1; ++i) {\n    const interval = INTERVALS[UNITS[i]];\n    const factor = interval.steps ? interval.steps : Number.MAX_SAFE_INTEGER;\n    if (interval.common && Math.ceil((max - min) / (factor * interval.size)) <= capacity) {\n      return UNITS[i];\n    }\n  }\n  return UNITS[ilen - 1];\n}\nfunction determineUnitForFormatting(scale, numTicks, minUnit, min, max) {\n  for (let i = UNITS.length - 1; i >= UNITS.indexOf(minUnit); i--) {\n    const unit = UNITS[i];\n    if (INTERVALS[unit].common && scale._adapter.diff(max, min, unit) >= numTicks - 1) {\n      return unit;\n    }\n  }\n  return UNITS[minUnit ? UNITS.indexOf(minUnit) : 0];\n}\nfunction determineMajorUnit(unit) {\n  for (let i = UNITS.indexOf(unit) + 1, ilen = UNITS.length; i < ilen; ++i) {\n    if (INTERVALS[UNITS[i]].common) {\n      return UNITS[i];\n    }\n  }\n}\nfunction addTick(ticks, time, timestamps) {\n  if (!timestamps) {\n    ticks[time] = true;\n  } else if (timestamps.length) {\n    const {lo, hi} = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aH)(timestamps, time);\n    const timestamp = timestamps[lo] >= time ? timestamps[lo] : timestamps[hi];\n    ticks[timestamp] = true;\n  }\n}\nfunction setMajorTicks(scale, ticks, map, majorUnit) {\n  const adapter = scale._adapter;\n  const first = +adapter.startOf(ticks[0].value, majorUnit);\n  const last = ticks[ticks.length - 1].value;\n  let major, index;\n  for (major = first; major <= last; major = +adapter.add(major, 1, majorUnit)) {\n    index = map[major];\n    if (index >= 0) {\n      ticks[index].major = true;\n    }\n  }\n  return ticks;\n}\nfunction ticksFromTimestamps(scale, values, majorUnit) {\n  const ticks = [];\n  const map = {};\n  const ilen = values.length;\n  let i, value;\n  for (i = 0; i < ilen; ++i) {\n    value = values[i];\n    map[value] = i;\n    ticks.push({\n      value,\n      major: false\n    });\n  }\n  return (ilen === 0 || !majorUnit) ? ticks : setMajorTicks(scale, ticks, map, majorUnit);\n}\nclass TimeScale extends Scale {\n  constructor(props) {\n    super(props);\n    this._cache = {\n      data: [],\n      labels: [],\n      all: []\n    };\n    this._unit = 'day';\n    this._majorUnit = undefined;\n    this._offsets = {};\n    this._normalized = false;\n    this._parseOpts = undefined;\n  }\n  init(scaleOpts, opts) {\n    const time = scaleOpts.time || (scaleOpts.time = {});\n    const adapter = this._adapter = new adapters._date(scaleOpts.adapters.date);\n    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a7)(time.displayFormats, adapter.formats());\n    this._parseOpts = {\n      parser: time.parser,\n      round: time.round,\n      isoWeekday: time.isoWeekday\n    };\n    super.init(scaleOpts);\n    this._normalized = opts.normalized;\n  }\n  parse(raw, index) {\n    if (raw === undefined) {\n      return null;\n    }\n    return parse(this, raw);\n  }\n  beforeLayout() {\n    super.beforeLayout();\n    this._cache = {\n      data: [],\n      labels: [],\n      all: []\n    };\n  }\n  determineDataLimits() {\n    const me = this;\n    const options = me.options;\n    const adapter = me._adapter;\n    const unit = options.time.unit || 'day';\n    let {min, max, minDefined, maxDefined} = me.getUserBounds();\n    function _applyBounds(bounds) {\n      if (!minDefined && !isNaN(bounds.min)) {\n        min = Math.min(min, bounds.min);\n      }\n      if (!maxDefined && !isNaN(bounds.max)) {\n        max = Math.max(max, bounds.max);\n      }\n    }\n    if (!minDefined || !maxDefined) {\n      _applyBounds(me._getLabelBounds());\n      if (options.bounds !== 'ticks' || options.ticks.source !== 'labels') {\n        _applyBounds(me.getMinMax(false));\n      }\n    }\n    min = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) && !isNaN(min) ? min : +adapter.startOf(Date.now(), unit);\n    max = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) && !isNaN(max) ? max : +adapter.endOf(Date.now(), unit) + 1;\n    me.min = Math.min(min, max - 1);\n    me.max = Math.max(min + 1, max);\n  }\n  _getLabelBounds() {\n    const arr = this.getLabelTimestamps();\n    let min = Number.POSITIVE_INFINITY;\n    let max = Number.NEGATIVE_INFINITY;\n    if (arr.length) {\n      min = arr[0];\n      max = arr[arr.length - 1];\n    }\n    return {min, max};\n  }\n  buildTicks() {\n    const me = this;\n    const options = me.options;\n    const timeOpts = options.time;\n    const tickOpts = options.ticks;\n    const timestamps = tickOpts.source === 'labels' ? me.getLabelTimestamps() : me._generate();\n    if (options.bounds === 'ticks' && timestamps.length) {\n      me.min = me._userMin || timestamps[0];\n      me.max = me._userMax || timestamps[timestamps.length - 1];\n    }\n    const min = me.min;\n    const max = me.max;\n    const ticks = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aG)(timestamps, min, max);\n    me._unit = timeOpts.unit || (tickOpts.autoSkip\n      ? determineUnitForAutoTicks(timeOpts.minUnit, me.min, me.max, me._getLabelCapacity(min))\n      : determineUnitForFormatting(me, ticks.length, timeOpts.minUnit, me.min, me.max));\n    me._majorUnit = !tickOpts.major.enabled || me._unit === 'year' ? undefined\n      : determineMajorUnit(me._unit);\n    me.initOffsets(timestamps);\n    if (options.reverse) {\n      ticks.reverse();\n    }\n    return ticksFromTimestamps(me, ticks, me._majorUnit);\n  }\n  initOffsets(timestamps) {\n    const me = this;\n    let start = 0;\n    let end = 0;\n    let first, last;\n    if (me.options.offset && timestamps.length) {\n      first = me.getDecimalForValue(timestamps[0]);\n      if (timestamps.length === 1) {\n        start = 1 - first;\n      } else {\n        start = (me.getDecimalForValue(timestamps[1]) - first) / 2;\n      }\n      last = me.getDecimalForValue(timestamps[timestamps.length - 1]);\n      if (timestamps.length === 1) {\n        end = last;\n      } else {\n        end = (last - me.getDecimalForValue(timestamps[timestamps.length - 2])) / 2;\n      }\n    }\n    const limit = timestamps.length < 3 ? 0.5 : 0.25;\n    start = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(start, 0, limit);\n    end = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(end, 0, limit);\n    me._offsets = {start, end, factor: 1 / (start + 1 + end)};\n  }\n  _generate() {\n    const me = this;\n    const adapter = me._adapter;\n    const min = me.min;\n    const max = me.max;\n    const options = me.options;\n    const timeOpts = options.time;\n    const minor = timeOpts.unit || determineUnitForAutoTicks(timeOpts.minUnit, min, max, me._getLabelCapacity(min));\n    const stepSize = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(timeOpts.stepSize, 1);\n    const weekday = minor === 'week' ? timeOpts.isoWeekday : false;\n    const hasWeekday = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(weekday) || weekday === true;\n    const ticks = {};\n    let first = min;\n    let time, count;\n    if (hasWeekday) {\n      first = +adapter.startOf(first, 'isoWeek', weekday);\n    }\n    first = +adapter.startOf(first, hasWeekday ? 'day' : minor);\n    if (adapter.diff(max, min, minor) > 100000 * stepSize) {\n      throw new Error(min + ' and ' + max + ' are too far apart with stepSize of ' + stepSize + ' ' + minor);\n    }\n    const timestamps = options.ticks.source === 'data' && me.getDataTimestamps();\n    for (time = first, count = 0; time < max; time = +adapter.add(time, stepSize, minor), count++) {\n      addTick(ticks, time, timestamps);\n    }\n    if (time === max || options.bounds === 'ticks' || count === 1) {\n      addTick(ticks, time, timestamps);\n    }\n    return Object.keys(ticks).sort((a, b) => a - b).map(x => +x);\n  }\n  getLabelForValue(value) {\n    const me = this;\n    const adapter = me._adapter;\n    const timeOpts = me.options.time;\n    if (timeOpts.tooltipFormat) {\n      return adapter.format(value, timeOpts.tooltipFormat);\n    }\n    return adapter.format(value, timeOpts.displayFormats.datetime);\n  }\n  _tickFormatFunction(time, index, ticks, format) {\n    const me = this;\n    const options = me.options;\n    const formats = options.time.displayFormats;\n    const unit = me._unit;\n    const majorUnit = me._majorUnit;\n    const minorFormat = unit && formats[unit];\n    const majorFormat = majorUnit && formats[majorUnit];\n    const tick = ticks[index];\n    const major = majorUnit && majorFormat && tick && tick.major;\n    const label = me._adapter.format(time, format || (major ? majorFormat : minorFormat));\n    const formatter = options.ticks.callback;\n    return formatter ? (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)(formatter, [label, index, ticks], me) : label;\n  }\n  generateTickLabels(ticks) {\n    let i, ilen, tick;\n    for (i = 0, ilen = ticks.length; i < ilen; ++i) {\n      tick = ticks[i];\n      tick.label = this._tickFormatFunction(tick.value, i, ticks);\n    }\n  }\n  getDecimalForValue(value) {\n    const me = this;\n    return value === null ? NaN : (value - me.min) / (me.max - me.min);\n  }\n  getPixelForValue(value) {\n    const me = this;\n    const offsets = me._offsets;\n    const pos = me.getDecimalForValue(value);\n    return me.getPixelForDecimal((offsets.start + pos) * offsets.factor);\n  }\n  getValueForPixel(pixel) {\n    const me = this;\n    const offsets = me._offsets;\n    const pos = me.getDecimalForPixel(pixel) / offsets.factor - offsets.end;\n    return me.min + pos * (me.max - me.min);\n  }\n  _getLabelSize(label) {\n    const me = this;\n    const ticksOpts = me.options.ticks;\n    const tickLabelWidth = me.ctx.measureText(label).width;\n    const angle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(me.isHorizontal() ? ticksOpts.maxRotation : ticksOpts.minRotation);\n    const cosRotation = Math.cos(angle);\n    const sinRotation = Math.sin(angle);\n    const tickFontSize = me._resolveTickFontOptions(0).size;\n    return {\n      w: (tickLabelWidth * cosRotation) + (tickFontSize * sinRotation),\n      h: (tickLabelWidth * sinRotation) + (tickFontSize * cosRotation)\n    };\n  }\n  _getLabelCapacity(exampleTime) {\n    const me = this;\n    const timeOpts = me.options.time;\n    const displayFormats = timeOpts.displayFormats;\n    const format = displayFormats[timeOpts.unit] || displayFormats.millisecond;\n    const exampleLabel = me._tickFormatFunction(exampleTime, 0, ticksFromTimestamps(me, [exampleTime], me._majorUnit), format);\n    const size = me._getLabelSize(exampleLabel);\n    const capacity = Math.floor(me.isHorizontal() ? me.width / size.w : me.height / size.h) - 1;\n    return capacity > 0 ? capacity : 1;\n  }\n  getDataTimestamps() {\n    const me = this;\n    let timestamps = me._cache.data || [];\n    let i, ilen;\n    if (timestamps.length) {\n      return timestamps;\n    }\n    const metas = me.getMatchingVisibleMetas();\n    if (me._normalized && metas.length) {\n      return (me._cache.data = metas[0].controller.getAllParsedValues(me));\n    }\n    for (i = 0, ilen = metas.length; i < ilen; ++i) {\n      timestamps = timestamps.concat(metas[i].controller.getAllParsedValues(me));\n    }\n    return (me._cache.data = me.normalize(timestamps));\n  }\n  getLabelTimestamps() {\n    const me = this;\n    const timestamps = me._cache.labels || [];\n    let i, ilen;\n    if (timestamps.length) {\n      return timestamps;\n    }\n    const labels = me.getLabels();\n    for (i = 0, ilen = labels.length; i < ilen; ++i) {\n      timestamps.push(parse(me, labels[i]));\n    }\n    return (me._cache.labels = me._normalized ? timestamps : me.normalize(timestamps));\n  }\n  normalize(values) {\n    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__._)(values.sort(sorter));\n  }\n}\nTimeScale.id = 'time';\nTimeScale.defaults = {\n  bounds: 'data',\n  adapters: {},\n  time: {\n    parser: false,\n    unit: false,\n    round: false,\n    isoWeekday: false,\n    minUnit: 'millisecond',\n    displayFormats: {}\n  },\n  ticks: {\n    source: 'auto',\n    major: {\n      enabled: false\n    }\n  }\n};\n\nfunction interpolate(table, val, reverse) {\n  let lo = 0;\n  let hi = table.length - 1;\n  let prevSource, nextSource, prevTarget, nextTarget;\n  if (reverse) {\n    if (val >= table[lo].pos && val <= table[hi].pos) {\n      ({lo, hi} = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(table, 'pos', val));\n    }\n    ({pos: prevSource, time: prevTarget} = table[lo]);\n    ({pos: nextSource, time: nextTarget} = table[hi]);\n  } else {\n    if (val >= table[lo].time && val <= table[hi].time) {\n      ({lo, hi} = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(table, 'time', val));\n    }\n    ({time: prevSource, pos: prevTarget} = table[lo]);\n    ({time: nextSource, pos: nextTarget} = table[hi]);\n  }\n  const span = nextSource - prevSource;\n  return span ? prevTarget + (nextTarget - prevTarget) * (val - prevSource) / span : prevTarget;\n}\nclass TimeSeriesScale extends TimeScale {\n  constructor(props) {\n    super(props);\n    this._table = [];\n    this._minPos = undefined;\n    this._tableRange = undefined;\n  }\n  initOffsets() {\n    const me = this;\n    const timestamps = me._getTimestampsForTable();\n    const table = me._table = me.buildLookupTable(timestamps);\n    me._minPos = interpolate(table, me.min);\n    me._tableRange = interpolate(table, me.max) - me._minPos;\n    super.initOffsets(timestamps);\n  }\n  buildLookupTable(timestamps) {\n    const {min, max} = this;\n    const items = [];\n    const table = [];\n    let i, ilen, prev, curr, next;\n    for (i = 0, ilen = timestamps.length; i < ilen; ++i) {\n      curr = timestamps[i];\n      if (curr >= min && curr <= max) {\n        items.push(curr);\n      }\n    }\n    if (items.length < 2) {\n      return [\n        {time: min, pos: 0},\n        {time: max, pos: 1}\n      ];\n    }\n    for (i = 0, ilen = items.length; i < ilen; ++i) {\n      next = items[i + 1];\n      prev = items[i - 1];\n      curr = items[i];\n      if (Math.round((next + prev) / 2) !== curr) {\n        table.push({time: curr, pos: i / (ilen - 1)});\n      }\n    }\n    return table;\n  }\n  _getTimestampsForTable() {\n    const me = this;\n    let timestamps = me._cache.all || [];\n    if (timestamps.length) {\n      return timestamps;\n    }\n    const data = me.getDataTimestamps();\n    const label = me.getLabelTimestamps();\n    if (data.length && label.length) {\n      timestamps = me.normalize(data.concat(label));\n    } else {\n      timestamps = data.length ? data : label;\n    }\n    timestamps = me._cache.all = timestamps;\n    return timestamps;\n  }\n  getDecimalForValue(value) {\n    return (interpolate(this._table, value) - this._minPos) / this._tableRange;\n  }\n  getValueForPixel(pixel) {\n    const me = this;\n    const offsets = me._offsets;\n    const decimal = me.getDecimalForPixel(pixel) / offsets.factor - offsets.end;\n    return interpolate(me._table, decimal * me._tableRange + me._minPos, true);\n  }\n}\nTimeSeriesScale.id = 'timeseries';\nTimeSeriesScale.defaults = TimeScale.defaults;\n\nvar scales = /*#__PURE__*/Object.freeze({\n__proto__: null,\nCategoryScale: CategoryScale,\nLinearScale: LinearScale,\nLogarithmicScale: LogarithmicScale,\nRadialLinearScale: RadialLinearScale,\nTimeScale: TimeScale,\nTimeSeriesScale: TimeSeriesScale\n});\n\nconst registerables = [\n  controllers,\n  elements,\n  plugins,\n  scales,\n];\n\n\n\n\n//# sourceURL=webpack://toweb/./node_modules/chart.js/dist/chart.esm.js?");

/***/ }),

/***/ "./node_modules/chart.js/dist/chunks/helpers.segment.js":
/*!**************************************************************!*\
  !*** ./node_modules/chart.js/dist/chunks/helpers.segment.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"$\": () => (/* binding */ overrides),\n/* harmony export */   \"A\": () => (/* binding */ toPadding),\n/* harmony export */   \"B\": () => (/* binding */ each),\n/* harmony export */   \"C\": () => (/* binding */ getMaximumSize),\n/* harmony export */   \"D\": () => (/* binding */ _getParentNode),\n/* harmony export */   \"E\": () => (/* binding */ readUsedSize),\n/* harmony export */   \"F\": () => (/* binding */ throttled),\n/* harmony export */   \"G\": () => (/* binding */ supportsEventListenerOptions),\n/* harmony export */   \"H\": () => (/* binding */ HALF_PI),\n/* harmony export */   \"I\": () => (/* binding */ _isDomSupported),\n/* harmony export */   \"J\": () => (/* binding */ log10),\n/* harmony export */   \"K\": () => (/* binding */ _factorize),\n/* harmony export */   \"L\": () => (/* binding */ finiteOrDefault),\n/* harmony export */   \"M\": () => (/* binding */ callback),\n/* harmony export */   \"N\": () => (/* binding */ _addGrace),\n/* harmony export */   \"O\": () => (/* binding */ toDegrees),\n/* harmony export */   \"P\": () => (/* binding */ PI),\n/* harmony export */   \"Q\": () => (/* binding */ _measureText),\n/* harmony export */   \"R\": () => (/* binding */ _int16Range),\n/* harmony export */   \"S\": () => (/* binding */ _alignPixel),\n/* harmony export */   \"T\": () => (/* binding */ TAU),\n/* harmony export */   \"U\": () => (/* binding */ clipArea),\n/* harmony export */   \"V\": () => (/* binding */ renderText),\n/* harmony export */   \"W\": () => (/* binding */ unclipArea),\n/* harmony export */   \"X\": () => (/* binding */ toFont),\n/* harmony export */   \"Y\": () => (/* binding */ _toLeftRightCenter),\n/* harmony export */   \"Z\": () => (/* binding */ _alignStartEnd),\n/* harmony export */   \"_\": () => (/* binding */ _arrayUnique),\n/* harmony export */   \"a\": () => (/* binding */ resolve),\n/* harmony export */   \"a0\": () => (/* binding */ merge),\n/* harmony export */   \"a1\": () => (/* binding */ _capitalize),\n/* harmony export */   \"a2\": () => (/* binding */ descriptors),\n/* harmony export */   \"a3\": () => (/* binding */ isFunction),\n/* harmony export */   \"a4\": () => (/* binding */ _attachContext),\n/* harmony export */   \"a5\": () => (/* binding */ _createResolver),\n/* harmony export */   \"a6\": () => (/* binding */ _descriptors),\n/* harmony export */   \"a7\": () => (/* binding */ mergeIf),\n/* harmony export */   \"a8\": () => (/* binding */ uid),\n/* harmony export */   \"a9\": () => (/* binding */ debounce),\n/* harmony export */   \"aA\": () => (/* binding */ _setMinAndMaxByKey),\n/* harmony export */   \"aB\": () => (/* binding */ niceNum),\n/* harmony export */   \"aC\": () => (/* binding */ almostWhole),\n/* harmony export */   \"aD\": () => (/* binding */ almostEquals),\n/* harmony export */   \"aE\": () => (/* binding */ _decimalPlaces),\n/* harmony export */   \"aF\": () => (/* binding */ _longestText),\n/* harmony export */   \"aG\": () => (/* binding */ _filterBetween),\n/* harmony export */   \"aH\": () => (/* binding */ _lookup),\n/* harmony export */   \"aI\": () => (/* binding */ getHoverColor),\n/* harmony export */   \"aJ\": () => (/* binding */ clone$1),\n/* harmony export */   \"aK\": () => (/* binding */ _merger),\n/* harmony export */   \"aL\": () => (/* binding */ _mergerIf),\n/* harmony export */   \"aM\": () => (/* binding */ _deprecated),\n/* harmony export */   \"aN\": () => (/* binding */ toFontString),\n/* harmony export */   \"aO\": () => (/* binding */ splineCurve),\n/* harmony export */   \"aP\": () => (/* binding */ splineCurveMonotone),\n/* harmony export */   \"aQ\": () => (/* binding */ getStyle),\n/* harmony export */   \"aR\": () => (/* binding */ fontString),\n/* harmony export */   \"aS\": () => (/* binding */ toLineHeight),\n/* harmony export */   \"aT\": () => (/* binding */ PITAU),\n/* harmony export */   \"aU\": () => (/* binding */ INFINITY),\n/* harmony export */   \"aV\": () => (/* binding */ RAD_PER_DEG),\n/* harmony export */   \"aW\": () => (/* binding */ QUARTER_PI),\n/* harmony export */   \"aX\": () => (/* binding */ TWO_THIRDS_PI),\n/* harmony export */   \"aY\": () => (/* binding */ _angleDiff),\n/* harmony export */   \"aa\": () => (/* binding */ retinaScale),\n/* harmony export */   \"ab\": () => (/* binding */ clearCanvas),\n/* harmony export */   \"ac\": () => (/* binding */ setsEqual),\n/* harmony export */   \"ad\": () => (/* binding */ _elementsEqual),\n/* harmony export */   \"ae\": () => (/* binding */ getAngleFromPoint),\n/* harmony export */   \"af\": () => (/* binding */ _readValueToProps),\n/* harmony export */   \"ag\": () => (/* binding */ _updateBezierControlPoints),\n/* harmony export */   \"ah\": () => (/* binding */ _computeSegments),\n/* harmony export */   \"ai\": () => (/* binding */ _boundSegments),\n/* harmony export */   \"aj\": () => (/* binding */ _steppedInterpolation),\n/* harmony export */   \"ak\": () => (/* binding */ _bezierInterpolation),\n/* harmony export */   \"al\": () => (/* binding */ _pointInLine),\n/* harmony export */   \"am\": () => (/* binding */ _steppedLineTo),\n/* harmony export */   \"an\": () => (/* binding */ _bezierCurveTo),\n/* harmony export */   \"ao\": () => (/* binding */ drawPoint),\n/* harmony export */   \"ap\": () => (/* binding */ addRoundedRectPath),\n/* harmony export */   \"aq\": () => (/* binding */ toTRBL),\n/* harmony export */   \"ar\": () => (/* binding */ toTRBLCorners),\n/* harmony export */   \"as\": () => (/* binding */ _boundSegment),\n/* harmony export */   \"at\": () => (/* binding */ _normalizeAngle),\n/* harmony export */   \"au\": () => (/* binding */ getRtlAdapter),\n/* harmony export */   \"av\": () => (/* binding */ overrideTextDirection),\n/* harmony export */   \"aw\": () => (/* binding */ _textX),\n/* harmony export */   \"ax\": () => (/* binding */ restoreTextDirection),\n/* harmony export */   \"ay\": () => (/* binding */ noop),\n/* harmony export */   \"az\": () => (/* binding */ distanceBetweenPoints),\n/* harmony export */   \"b\": () => (/* binding */ isArray),\n/* harmony export */   \"c\": () => (/* binding */ color),\n/* harmony export */   \"d\": () => (/* binding */ defaults),\n/* harmony export */   \"e\": () => (/* binding */ effects),\n/* harmony export */   \"f\": () => (/* binding */ resolveObjectKey),\n/* harmony export */   \"g\": () => (/* binding */ isNumberFinite),\n/* harmony export */   \"h\": () => (/* binding */ defined),\n/* harmony export */   \"i\": () => (/* binding */ isObject),\n/* harmony export */   \"j\": () => (/* binding */ isNullOrUndef),\n/* harmony export */   \"k\": () => (/* binding */ toPercentage),\n/* harmony export */   \"l\": () => (/* binding */ listenArrayEvents),\n/* harmony export */   \"m\": () => (/* binding */ toDimension),\n/* harmony export */   \"n\": () => (/* binding */ formatNumber),\n/* harmony export */   \"o\": () => (/* binding */ _angleBetween),\n/* harmony export */   \"p\": () => (/* binding */ isNumber),\n/* harmony export */   \"q\": () => (/* binding */ _limitValue),\n/* harmony export */   \"r\": () => (/* binding */ requestAnimFrame),\n/* harmony export */   \"s\": () => (/* binding */ sign),\n/* harmony export */   \"t\": () => (/* binding */ toRadians),\n/* harmony export */   \"u\": () => (/* binding */ unlistenArrayEvents),\n/* harmony export */   \"v\": () => (/* binding */ valueOrDefault),\n/* harmony export */   \"w\": () => (/* binding */ _lookupByKey),\n/* harmony export */   \"x\": () => (/* binding */ getRelativePosition),\n/* harmony export */   \"y\": () => (/* binding */ _isPointInArea),\n/* harmony export */   \"z\": () => (/* binding */ _rlookupByKey)\n/* harmony export */ });\n/*!\n * Chart.js v3.5.1\n * https://www.chartjs.org\n * (c) 2021 Chart.js Contributors\n * Released under the MIT License\n */\nfunction fontString(pixelSize, fontStyle, fontFamily) {\n  return fontStyle + ' ' + pixelSize + 'px ' + fontFamily;\n}\nconst requestAnimFrame = (function() {\n  if (typeof window === 'undefined') {\n    return function(callback) {\n      return callback();\n    };\n  }\n  return window.requestAnimationFrame;\n}());\nfunction throttled(fn, thisArg, updateFn) {\n  const updateArgs = updateFn || ((args) => Array.prototype.slice.call(args));\n  let ticking = false;\n  let args = [];\n  return function(...rest) {\n    args = updateArgs(rest);\n    if (!ticking) {\n      ticking = true;\n      requestAnimFrame.call(window, () => {\n        ticking = false;\n        fn.apply(thisArg, args);\n      });\n    }\n  };\n}\nfunction debounce(fn, delay) {\n  let timeout;\n  return function() {\n    if (delay) {\n      clearTimeout(timeout);\n      timeout = setTimeout(fn, delay);\n    } else {\n      fn();\n    }\n    return delay;\n  };\n}\nconst _toLeftRightCenter = (align) => align === 'start' ? 'left' : align === 'end' ? 'right' : 'center';\nconst _alignStartEnd = (align, start, end) => align === 'start' ? start : align === 'end' ? end : (start + end) / 2;\nconst _textX = (align, left, right, rtl) => {\n  const check = rtl ? 'left' : 'right';\n  return align === check ? right : align === 'center' ? (left + right) / 2 : left;\n};\n\nfunction noop() {}\nconst uid = (function() {\n  let id = 0;\n  return function() {\n    return id++;\n  };\n}());\nfunction isNullOrUndef(value) {\n  return value === null || typeof value === 'undefined';\n}\nfunction isArray(value) {\n  if (Array.isArray && Array.isArray(value)) {\n    return true;\n  }\n  const type = Object.prototype.toString.call(value);\n  if (type.substr(0, 7) === '[object' && type.substr(-6) === 'Array]') {\n    return true;\n  }\n  return false;\n}\nfunction isObject(value) {\n  return value !== null && Object.prototype.toString.call(value) === '[object Object]';\n}\nconst isNumberFinite = (value) => (typeof value === 'number' || value instanceof Number) && isFinite(+value);\nfunction finiteOrDefault(value, defaultValue) {\n  return isNumberFinite(value) ? value : defaultValue;\n}\nfunction valueOrDefault(value, defaultValue) {\n  return typeof value === 'undefined' ? defaultValue : value;\n}\nconst toPercentage = (value, dimension) =>\n  typeof value === 'string' && value.endsWith('%') ?\n    parseFloat(value) / 100\n    : value / dimension;\nconst toDimension = (value, dimension) =>\n  typeof value === 'string' && value.endsWith('%') ?\n    parseFloat(value) / 100 * dimension\n    : +value;\nfunction callback(fn, args, thisArg) {\n  if (fn && typeof fn.call === 'function') {\n    return fn.apply(thisArg, args);\n  }\n}\nfunction each(loopable, fn, thisArg, reverse) {\n  let i, len, keys;\n  if (isArray(loopable)) {\n    len = loopable.length;\n    if (reverse) {\n      for (i = len - 1; i >= 0; i--) {\n        fn.call(thisArg, loopable[i], i);\n      }\n    } else {\n      for (i = 0; i < len; i++) {\n        fn.call(thisArg, loopable[i], i);\n      }\n    }\n  } else if (isObject(loopable)) {\n    keys = Object.keys(loopable);\n    len = keys.length;\n    for (i = 0; i < len; i++) {\n      fn.call(thisArg, loopable[keys[i]], keys[i]);\n    }\n  }\n}\nfunction _elementsEqual(a0, a1) {\n  let i, ilen, v0, v1;\n  if (!a0 || !a1 || a0.length !== a1.length) {\n    return false;\n  }\n  for (i = 0, ilen = a0.length; i < ilen; ++i) {\n    v0 = a0[i];\n    v1 = a1[i];\n    if (v0.datasetIndex !== v1.datasetIndex || v0.index !== v1.index) {\n      return false;\n    }\n  }\n  return true;\n}\nfunction clone$1(source) {\n  if (isArray(source)) {\n    return source.map(clone$1);\n  }\n  if (isObject(source)) {\n    const target = Object.create(null);\n    const keys = Object.keys(source);\n    const klen = keys.length;\n    let k = 0;\n    for (; k < klen; ++k) {\n      target[keys[k]] = clone$1(source[keys[k]]);\n    }\n    return target;\n  }\n  return source;\n}\nfunction isValidKey(key) {\n  return ['__proto__', 'prototype', 'constructor'].indexOf(key) === -1;\n}\nfunction _merger(key, target, source, options) {\n  if (!isValidKey(key)) {\n    return;\n  }\n  const tval = target[key];\n  const sval = source[key];\n  if (isObject(tval) && isObject(sval)) {\n    merge(tval, sval, options);\n  } else {\n    target[key] = clone$1(sval);\n  }\n}\nfunction merge(target, source, options) {\n  const sources = isArray(source) ? source : [source];\n  const ilen = sources.length;\n  if (!isObject(target)) {\n    return target;\n  }\n  options = options || {};\n  const merger = options.merger || _merger;\n  for (let i = 0; i < ilen; ++i) {\n    source = sources[i];\n    if (!isObject(source)) {\n      continue;\n    }\n    const keys = Object.keys(source);\n    for (let k = 0, klen = keys.length; k < klen; ++k) {\n      merger(keys[k], target, source, options);\n    }\n  }\n  return target;\n}\nfunction mergeIf(target, source) {\n  return merge(target, source, {merger: _mergerIf});\n}\nfunction _mergerIf(key, target, source) {\n  if (!isValidKey(key)) {\n    return;\n  }\n  const tval = target[key];\n  const sval = source[key];\n  if (isObject(tval) && isObject(sval)) {\n    mergeIf(tval, sval);\n  } else if (!Object.prototype.hasOwnProperty.call(target, key)) {\n    target[key] = clone$1(sval);\n  }\n}\nfunction _deprecated(scope, value, previous, current) {\n  if (value !== undefined) {\n    console.warn(scope + ': \"' + previous +\n\t\t\t'\" is deprecated. Please use \"' + current + '\" instead');\n  }\n}\nconst emptyString = '';\nconst dot = '.';\nfunction indexOfDotOrLength(key, start) {\n  const idx = key.indexOf(dot, start);\n  return idx === -1 ? key.length : idx;\n}\nfunction resolveObjectKey(obj, key) {\n  if (key === emptyString) {\n    return obj;\n  }\n  let pos = 0;\n  let idx = indexOfDotOrLength(key, pos);\n  while (obj && idx > pos) {\n    obj = obj[key.substr(pos, idx - pos)];\n    pos = idx + 1;\n    idx = indexOfDotOrLength(key, pos);\n  }\n  return obj;\n}\nfunction _capitalize(str) {\n  return str.charAt(0).toUpperCase() + str.slice(1);\n}\nconst defined = (value) => typeof value !== 'undefined';\nconst isFunction = (value) => typeof value === 'function';\nconst setsEqual = (a, b) => {\n  if (a.size !== b.size) {\n    return false;\n  }\n  for (const item of a) {\n    if (!b.has(item)) {\n      return false;\n    }\n  }\n  return true;\n};\n\nconst PI = Math.PI;\nconst TAU = 2 * PI;\nconst PITAU = TAU + PI;\nconst INFINITY = Number.POSITIVE_INFINITY;\nconst RAD_PER_DEG = PI / 180;\nconst HALF_PI = PI / 2;\nconst QUARTER_PI = PI / 4;\nconst TWO_THIRDS_PI = PI * 2 / 3;\nconst log10 = Math.log10;\nconst sign = Math.sign;\nfunction niceNum(range) {\n  const roundedRange = Math.round(range);\n  range = almostEquals(range, roundedRange, range / 1000) ? roundedRange : range;\n  const niceRange = Math.pow(10, Math.floor(log10(range)));\n  const fraction = range / niceRange;\n  const niceFraction = fraction <= 1 ? 1 : fraction <= 2 ? 2 : fraction <= 5 ? 5 : 10;\n  return niceFraction * niceRange;\n}\nfunction _factorize(value) {\n  const result = [];\n  const sqrt = Math.sqrt(value);\n  let i;\n  for (i = 1; i < sqrt; i++) {\n    if (value % i === 0) {\n      result.push(i);\n      result.push(value / i);\n    }\n  }\n  if (sqrt === (sqrt | 0)) {\n    result.push(sqrt);\n  }\n  result.sort((a, b) => a - b).pop();\n  return result;\n}\nfunction isNumber(n) {\n  return !isNaN(parseFloat(n)) && isFinite(n);\n}\nfunction almostEquals(x, y, epsilon) {\n  return Math.abs(x - y) < epsilon;\n}\nfunction almostWhole(x, epsilon) {\n  const rounded = Math.round(x);\n  return ((rounded - epsilon) <= x) && ((rounded + epsilon) >= x);\n}\nfunction _setMinAndMaxByKey(array, target, property) {\n  let i, ilen, value;\n  for (i = 0, ilen = array.length; i < ilen; i++) {\n    value = array[i][property];\n    if (!isNaN(value)) {\n      target.min = Math.min(target.min, value);\n      target.max = Math.max(target.max, value);\n    }\n  }\n}\nfunction toRadians(degrees) {\n  return degrees * (PI / 180);\n}\nfunction toDegrees(radians) {\n  return radians * (180 / PI);\n}\nfunction _decimalPlaces(x) {\n  if (!isNumberFinite(x)) {\n    return;\n  }\n  let e = 1;\n  let p = 0;\n  while (Math.round(x * e) / e !== x) {\n    e *= 10;\n    p++;\n  }\n  return p;\n}\nfunction getAngleFromPoint(centrePoint, anglePoint) {\n  const distanceFromXCenter = anglePoint.x - centrePoint.x;\n  const distanceFromYCenter = anglePoint.y - centrePoint.y;\n  const radialDistanceFromCenter = Math.sqrt(distanceFromXCenter * distanceFromXCenter + distanceFromYCenter * distanceFromYCenter);\n  let angle = Math.atan2(distanceFromYCenter, distanceFromXCenter);\n  if (angle < (-0.5 * PI)) {\n    angle += TAU;\n  }\n  return {\n    angle,\n    distance: radialDistanceFromCenter\n  };\n}\nfunction distanceBetweenPoints(pt1, pt2) {\n  return Math.sqrt(Math.pow(pt2.x - pt1.x, 2) + Math.pow(pt2.y - pt1.y, 2));\n}\nfunction _angleDiff(a, b) {\n  return (a - b + PITAU) % TAU - PI;\n}\nfunction _normalizeAngle(a) {\n  return (a % TAU + TAU) % TAU;\n}\nfunction _angleBetween(angle, start, end, sameAngleIsFullCircle) {\n  const a = _normalizeAngle(angle);\n  const s = _normalizeAngle(start);\n  const e = _normalizeAngle(end);\n  const angleToStart = _normalizeAngle(s - a);\n  const angleToEnd = _normalizeAngle(e - a);\n  const startToAngle = _normalizeAngle(a - s);\n  const endToAngle = _normalizeAngle(a - e);\n  return a === s || a === e || (sameAngleIsFullCircle && s === e)\n    || (angleToStart > angleToEnd && startToAngle < endToAngle);\n}\nfunction _limitValue(value, min, max) {\n  return Math.max(min, Math.min(max, value));\n}\nfunction _int16Range(value) {\n  return _limitValue(value, -32768, 32767);\n}\n\nconst atEdge = (t) => t === 0 || t === 1;\nconst elasticIn = (t, s, p) => -(Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * TAU / p));\nconst elasticOut = (t, s, p) => Math.pow(2, -10 * t) * Math.sin((t - s) * TAU / p) + 1;\nconst effects = {\n  linear: t => t,\n  easeInQuad: t => t * t,\n  easeOutQuad: t => -t * (t - 2),\n  easeInOutQuad: t => ((t /= 0.5) < 1)\n    ? 0.5 * t * t\n    : -0.5 * ((--t) * (t - 2) - 1),\n  easeInCubic: t => t * t * t,\n  easeOutCubic: t => (t -= 1) * t * t + 1,\n  easeInOutCubic: t => ((t /= 0.5) < 1)\n    ? 0.5 * t * t * t\n    : 0.5 * ((t -= 2) * t * t + 2),\n  easeInQuart: t => t * t * t * t,\n  easeOutQuart: t => -((t -= 1) * t * t * t - 1),\n  easeInOutQuart: t => ((t /= 0.5) < 1)\n    ? 0.5 * t * t * t * t\n    : -0.5 * ((t -= 2) * t * t * t - 2),\n  easeInQuint: t => t * t * t * t * t,\n  easeOutQuint: t => (t -= 1) * t * t * t * t + 1,\n  easeInOutQuint: t => ((t /= 0.5) < 1)\n    ? 0.5 * t * t * t * t * t\n    : 0.5 * ((t -= 2) * t * t * t * t + 2),\n  easeInSine: t => -Math.cos(t * HALF_PI) + 1,\n  easeOutSine: t => Math.sin(t * HALF_PI),\n  easeInOutSine: t => -0.5 * (Math.cos(PI * t) - 1),\n  easeInExpo: t => (t === 0) ? 0 : Math.pow(2, 10 * (t - 1)),\n  easeOutExpo: t => (t === 1) ? 1 : -Math.pow(2, -10 * t) + 1,\n  easeInOutExpo: t => atEdge(t) ? t : t < 0.5\n    ? 0.5 * Math.pow(2, 10 * (t * 2 - 1))\n    : 0.5 * (-Math.pow(2, -10 * (t * 2 - 1)) + 2),\n  easeInCirc: t => (t >= 1) ? t : -(Math.sqrt(1 - t * t) - 1),\n  easeOutCirc: t => Math.sqrt(1 - (t -= 1) * t),\n  easeInOutCirc: t => ((t /= 0.5) < 1)\n    ? -0.5 * (Math.sqrt(1 - t * t) - 1)\n    : 0.5 * (Math.sqrt(1 - (t -= 2) * t) + 1),\n  easeInElastic: t => atEdge(t) ? t : elasticIn(t, 0.075, 0.3),\n  easeOutElastic: t => atEdge(t) ? t : elasticOut(t, 0.075, 0.3),\n  easeInOutElastic(t) {\n    const s = 0.1125;\n    const p = 0.45;\n    return atEdge(t) ? t :\n      t < 0.5\n        ? 0.5 * elasticIn(t * 2, s, p)\n        : 0.5 + 0.5 * elasticOut(t * 2 - 1, s, p);\n  },\n  easeInBack(t) {\n    const s = 1.70158;\n    return t * t * ((s + 1) * t - s);\n  },\n  easeOutBack(t) {\n    const s = 1.70158;\n    return (t -= 1) * t * ((s + 1) * t + s) + 1;\n  },\n  easeInOutBack(t) {\n    let s = 1.70158;\n    if ((t /= 0.5) < 1) {\n      return 0.5 * (t * t * (((s *= (1.525)) + 1) * t - s));\n    }\n    return 0.5 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2);\n  },\n  easeInBounce: t => 1 - effects.easeOutBounce(1 - t),\n  easeOutBounce(t) {\n    const m = 7.5625;\n    const d = 2.75;\n    if (t < (1 / d)) {\n      return m * t * t;\n    }\n    if (t < (2 / d)) {\n      return m * (t -= (1.5 / d)) * t + 0.75;\n    }\n    if (t < (2.5 / d)) {\n      return m * (t -= (2.25 / d)) * t + 0.9375;\n    }\n    return m * (t -= (2.625 / d)) * t + 0.984375;\n  },\n  easeInOutBounce: t => (t < 0.5)\n    ? effects.easeInBounce(t * 2) * 0.5\n    : effects.easeOutBounce(t * 2 - 1) * 0.5 + 0.5,\n};\n\n/*!\n * @kurkle/color v0.1.9\n * https://github.com/kurkle/color#readme\n * (c) 2020 Jukka Kurkela\n * Released under the MIT License\n */\nconst map = {0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, A: 10, B: 11, C: 12, D: 13, E: 14, F: 15, a: 10, b: 11, c: 12, d: 13, e: 14, f: 15};\nconst hex = '0123456789ABCDEF';\nconst h1 = (b) => hex[b & 0xF];\nconst h2 = (b) => hex[(b & 0xF0) >> 4] + hex[b & 0xF];\nconst eq = (b) => (((b & 0xF0) >> 4) === (b & 0xF));\nfunction isShort(v) {\n\treturn eq(v.r) && eq(v.g) && eq(v.b) && eq(v.a);\n}\nfunction hexParse(str) {\n\tvar len = str.length;\n\tvar ret;\n\tif (str[0] === '#') {\n\t\tif (len === 4 || len === 5) {\n\t\t\tret = {\n\t\t\t\tr: 255 & map[str[1]] * 17,\n\t\t\t\tg: 255 & map[str[2]] * 17,\n\t\t\t\tb: 255 & map[str[3]] * 17,\n\t\t\t\ta: len === 5 ? map[str[4]] * 17 : 255\n\t\t\t};\n\t\t} else if (len === 7 || len === 9) {\n\t\t\tret = {\n\t\t\t\tr: map[str[1]] << 4 | map[str[2]],\n\t\t\t\tg: map[str[3]] << 4 | map[str[4]],\n\t\t\t\tb: map[str[5]] << 4 | map[str[6]],\n\t\t\t\ta: len === 9 ? (map[str[7]] << 4 | map[str[8]]) : 255\n\t\t\t};\n\t\t}\n\t}\n\treturn ret;\n}\nfunction hexString(v) {\n\tvar f = isShort(v) ? h1 : h2;\n\treturn v\n\t\t? '#' + f(v.r) + f(v.g) + f(v.b) + (v.a < 255 ? f(v.a) : '')\n\t\t: v;\n}\nfunction round(v) {\n\treturn v + 0.5 | 0;\n}\nconst lim = (v, l, h) => Math.max(Math.min(v, h), l);\nfunction p2b(v) {\n\treturn lim(round(v * 2.55), 0, 255);\n}\nfunction n2b(v) {\n\treturn lim(round(v * 255), 0, 255);\n}\nfunction b2n(v) {\n\treturn lim(round(v / 2.55) / 100, 0, 1);\n}\nfunction n2p(v) {\n\treturn lim(round(v * 100), 0, 100);\n}\nconst RGB_RE = /^rgba?\\(\\s*([-+.\\d]+)(%)?[\\s,]+([-+.e\\d]+)(%)?[\\s,]+([-+.e\\d]+)(%)?(?:[\\s,/]+([-+.e\\d]+)(%)?)?\\s*\\)$/;\nfunction rgbParse(str) {\n\tconst m = RGB_RE.exec(str);\n\tlet a = 255;\n\tlet r, g, b;\n\tif (!m) {\n\t\treturn;\n\t}\n\tif (m[7] !== r) {\n\t\tconst v = +m[7];\n\t\ta = 255 & (m[8] ? p2b(v) : v * 255);\n\t}\n\tr = +m[1];\n\tg = +m[3];\n\tb = +m[5];\n\tr = 255 & (m[2] ? p2b(r) : r);\n\tg = 255 & (m[4] ? p2b(g) : g);\n\tb = 255 & (m[6] ? p2b(b) : b);\n\treturn {\n\t\tr: r,\n\t\tg: g,\n\t\tb: b,\n\t\ta: a\n\t};\n}\nfunction rgbString(v) {\n\treturn v && (\n\t\tv.a < 255\n\t\t\t? `rgba(${v.r}, ${v.g}, ${v.b}, ${b2n(v.a)})`\n\t\t\t: `rgb(${v.r}, ${v.g}, ${v.b})`\n\t);\n}\nconst HUE_RE = /^(hsla?|hwb|hsv)\\(\\s*([-+.e\\d]+)(?:deg)?[\\s,]+([-+.e\\d]+)%[\\s,]+([-+.e\\d]+)%(?:[\\s,]+([-+.e\\d]+)(%)?)?\\s*\\)$/;\nfunction hsl2rgbn(h, s, l) {\n\tconst a = s * Math.min(l, 1 - l);\n\tconst f = (n, k = (n + h / 30) % 12) => l - a * Math.max(Math.min(k - 3, 9 - k, 1), -1);\n\treturn [f(0), f(8), f(4)];\n}\nfunction hsv2rgbn(h, s, v) {\n\tconst f = (n, k = (n + h / 60) % 6) => v - v * s * Math.max(Math.min(k, 4 - k, 1), 0);\n\treturn [f(5), f(3), f(1)];\n}\nfunction hwb2rgbn(h, w, b) {\n\tconst rgb = hsl2rgbn(h, 1, 0.5);\n\tlet i;\n\tif (w + b > 1) {\n\t\ti = 1 / (w + b);\n\t\tw *= i;\n\t\tb *= i;\n\t}\n\tfor (i = 0; i < 3; i++) {\n\t\trgb[i] *= 1 - w - b;\n\t\trgb[i] += w;\n\t}\n\treturn rgb;\n}\nfunction rgb2hsl(v) {\n\tconst range = 255;\n\tconst r = v.r / range;\n\tconst g = v.g / range;\n\tconst b = v.b / range;\n\tconst max = Math.max(r, g, b);\n\tconst min = Math.min(r, g, b);\n\tconst l = (max + min) / 2;\n\tlet h, s, d;\n\tif (max !== min) {\n\t\td = max - min;\n\t\ts = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n\t\th = max === r\n\t\t\t? ((g - b) / d) + (g < b ? 6 : 0)\n\t\t\t: max === g\n\t\t\t\t? (b - r) / d + 2\n\t\t\t\t: (r - g) / d + 4;\n\t\th = h * 60 + 0.5;\n\t}\n\treturn [h | 0, s || 0, l];\n}\nfunction calln(f, a, b, c) {\n\treturn (\n\t\tArray.isArray(a)\n\t\t\t? f(a[0], a[1], a[2])\n\t\t\t: f(a, b, c)\n\t).map(n2b);\n}\nfunction hsl2rgb(h, s, l) {\n\treturn calln(hsl2rgbn, h, s, l);\n}\nfunction hwb2rgb(h, w, b) {\n\treturn calln(hwb2rgbn, h, w, b);\n}\nfunction hsv2rgb(h, s, v) {\n\treturn calln(hsv2rgbn, h, s, v);\n}\nfunction hue(h) {\n\treturn (h % 360 + 360) % 360;\n}\nfunction hueParse(str) {\n\tconst m = HUE_RE.exec(str);\n\tlet a = 255;\n\tlet v;\n\tif (!m) {\n\t\treturn;\n\t}\n\tif (m[5] !== v) {\n\t\ta = m[6] ? p2b(+m[5]) : n2b(+m[5]);\n\t}\n\tconst h = hue(+m[2]);\n\tconst p1 = +m[3] / 100;\n\tconst p2 = +m[4] / 100;\n\tif (m[1] === 'hwb') {\n\t\tv = hwb2rgb(h, p1, p2);\n\t} else if (m[1] === 'hsv') {\n\t\tv = hsv2rgb(h, p1, p2);\n\t} else {\n\t\tv = hsl2rgb(h, p1, p2);\n\t}\n\treturn {\n\t\tr: v[0],\n\t\tg: v[1],\n\t\tb: v[2],\n\t\ta: a\n\t};\n}\nfunction rotate(v, deg) {\n\tvar h = rgb2hsl(v);\n\th[0] = hue(h[0] + deg);\n\th = hsl2rgb(h);\n\tv.r = h[0];\n\tv.g = h[1];\n\tv.b = h[2];\n}\nfunction hslString(v) {\n\tif (!v) {\n\t\treturn;\n\t}\n\tconst a = rgb2hsl(v);\n\tconst h = a[0];\n\tconst s = n2p(a[1]);\n\tconst l = n2p(a[2]);\n\treturn v.a < 255\n\t\t? `hsla(${h}, ${s}%, ${l}%, ${b2n(v.a)})`\n\t\t: `hsl(${h}, ${s}%, ${l}%)`;\n}\nconst map$1 = {\n\tx: 'dark',\n\tZ: 'light',\n\tY: 're',\n\tX: 'blu',\n\tW: 'gr',\n\tV: 'medium',\n\tU: 'slate',\n\tA: 'ee',\n\tT: 'ol',\n\tS: 'or',\n\tB: 'ra',\n\tC: 'lateg',\n\tD: 'ights',\n\tR: 'in',\n\tQ: 'turquois',\n\tE: 'hi',\n\tP: 'ro',\n\tO: 'al',\n\tN: 'le',\n\tM: 'de',\n\tL: 'yello',\n\tF: 'en',\n\tK: 'ch',\n\tG: 'arks',\n\tH: 'ea',\n\tI: 'ightg',\n\tJ: 'wh'\n};\nconst names = {\n\tOiceXe: 'f0f8ff',\n\tantiquewEte: 'faebd7',\n\taqua: 'ffff',\n\taquamarRe: '7fffd4',\n\tazuY: 'f0ffff',\n\tbeige: 'f5f5dc',\n\tbisque: 'ffe4c4',\n\tblack: '0',\n\tblanKedOmond: 'ffebcd',\n\tXe: 'ff',\n\tXeviTet: '8a2be2',\n\tbPwn: 'a52a2a',\n\tburlywood: 'deb887',\n\tcaMtXe: '5f9ea0',\n\tKartYuse: '7fff00',\n\tKocTate: 'd2691e',\n\tcSO: 'ff7f50',\n\tcSnflowerXe: '6495ed',\n\tcSnsilk: 'fff8dc',\n\tcrimson: 'dc143c',\n\tcyan: 'ffff',\n\txXe: '8b',\n\txcyan: '8b8b',\n\txgTMnPd: 'b8860b',\n\txWay: 'a9a9a9',\n\txgYF: '6400',\n\txgYy: 'a9a9a9',\n\txkhaki: 'bdb76b',\n\txmagFta: '8b008b',\n\txTivegYF: '556b2f',\n\txSange: 'ff8c00',\n\txScEd: '9932cc',\n\txYd: '8b0000',\n\txsOmon: 'e9967a',\n\txsHgYF: '8fbc8f',\n\txUXe: '483d8b',\n\txUWay: '2f4f4f',\n\txUgYy: '2f4f4f',\n\txQe: 'ced1',\n\txviTet: '9400d3',\n\tdAppRk: 'ff1493',\n\tdApskyXe: 'bfff',\n\tdimWay: '696969',\n\tdimgYy: '696969',\n\tdodgerXe: '1e90ff',\n\tfiYbrick: 'b22222',\n\tflSOwEte: 'fffaf0',\n\tfoYstWAn: '228b22',\n\tfuKsia: 'ff00ff',\n\tgaRsbSo: 'dcdcdc',\n\tghostwEte: 'f8f8ff',\n\tgTd: 'ffd700',\n\tgTMnPd: 'daa520',\n\tWay: '808080',\n\tgYF: '8000',\n\tgYFLw: 'adff2f',\n\tgYy: '808080',\n\thoneyMw: 'f0fff0',\n\thotpRk: 'ff69b4',\n\tRdianYd: 'cd5c5c',\n\tRdigo: '4b0082',\n\tivSy: 'fffff0',\n\tkhaki: 'f0e68c',\n\tlavFMr: 'e6e6fa',\n\tlavFMrXsh: 'fff0f5',\n\tlawngYF: '7cfc00',\n\tNmoncEffon: 'fffacd',\n\tZXe: 'add8e6',\n\tZcSO: 'f08080',\n\tZcyan: 'e0ffff',\n\tZgTMnPdLw: 'fafad2',\n\tZWay: 'd3d3d3',\n\tZgYF: '90ee90',\n\tZgYy: 'd3d3d3',\n\tZpRk: 'ffb6c1',\n\tZsOmon: 'ffa07a',\n\tZsHgYF: '20b2aa',\n\tZskyXe: '87cefa',\n\tZUWay: '778899',\n\tZUgYy: '778899',\n\tZstAlXe: 'b0c4de',\n\tZLw: 'ffffe0',\n\tlime: 'ff00',\n\tlimegYF: '32cd32',\n\tlRF: 'faf0e6',\n\tmagFta: 'ff00ff',\n\tmaPon: '800000',\n\tVaquamarRe: '66cdaa',\n\tVXe: 'cd',\n\tVScEd: 'ba55d3',\n\tVpurpN: '9370db',\n\tVsHgYF: '3cb371',\n\tVUXe: '7b68ee',\n\tVsprRggYF: 'fa9a',\n\tVQe: '48d1cc',\n\tVviTetYd: 'c71585',\n\tmidnightXe: '191970',\n\tmRtcYam: 'f5fffa',\n\tmistyPse: 'ffe4e1',\n\tmoccasR: 'ffe4b5',\n\tnavajowEte: 'ffdead',\n\tnavy: '80',\n\tTdlace: 'fdf5e6',\n\tTive: '808000',\n\tTivedBb: '6b8e23',\n\tSange: 'ffa500',\n\tSangeYd: 'ff4500',\n\tScEd: 'da70d6',\n\tpOegTMnPd: 'eee8aa',\n\tpOegYF: '98fb98',\n\tpOeQe: 'afeeee',\n\tpOeviTetYd: 'db7093',\n\tpapayawEp: 'ffefd5',\n\tpHKpuff: 'ffdab9',\n\tperu: 'cd853f',\n\tpRk: 'ffc0cb',\n\tplum: 'dda0dd',\n\tpowMrXe: 'b0e0e6',\n\tpurpN: '800080',\n\tYbeccapurpN: '663399',\n\tYd: 'ff0000',\n\tPsybrown: 'bc8f8f',\n\tPyOXe: '4169e1',\n\tsaddNbPwn: '8b4513',\n\tsOmon: 'fa8072',\n\tsandybPwn: 'f4a460',\n\tsHgYF: '2e8b57',\n\tsHshell: 'fff5ee',\n\tsiFna: 'a0522d',\n\tsilver: 'c0c0c0',\n\tskyXe: '87ceeb',\n\tUXe: '6a5acd',\n\tUWay: '708090',\n\tUgYy: '708090',\n\tsnow: 'fffafa',\n\tsprRggYF: 'ff7f',\n\tstAlXe: '4682b4',\n\ttan: 'd2b48c',\n\tteO: '8080',\n\ttEstN: 'd8bfd8',\n\ttomato: 'ff6347',\n\tQe: '40e0d0',\n\tviTet: 'ee82ee',\n\tJHt: 'f5deb3',\n\twEte: 'ffffff',\n\twEtesmoke: 'f5f5f5',\n\tLw: 'ffff00',\n\tLwgYF: '9acd32'\n};\nfunction unpack() {\n\tconst unpacked = {};\n\tconst keys = Object.keys(names);\n\tconst tkeys = Object.keys(map$1);\n\tlet i, j, k, ok, nk;\n\tfor (i = 0; i < keys.length; i++) {\n\t\tok = nk = keys[i];\n\t\tfor (j = 0; j < tkeys.length; j++) {\n\t\t\tk = tkeys[j];\n\t\t\tnk = nk.replace(k, map$1[k]);\n\t\t}\n\t\tk = parseInt(names[ok], 16);\n\t\tunpacked[nk] = [k >> 16 & 0xFF, k >> 8 & 0xFF, k & 0xFF];\n\t}\n\treturn unpacked;\n}\nlet names$1;\nfunction nameParse(str) {\n\tif (!names$1) {\n\t\tnames$1 = unpack();\n\t\tnames$1.transparent = [0, 0, 0, 0];\n\t}\n\tconst a = names$1[str.toLowerCase()];\n\treturn a && {\n\t\tr: a[0],\n\t\tg: a[1],\n\t\tb: a[2],\n\t\ta: a.length === 4 ? a[3] : 255\n\t};\n}\nfunction modHSL(v, i, ratio) {\n\tif (v) {\n\t\tlet tmp = rgb2hsl(v);\n\t\ttmp[i] = Math.max(0, Math.min(tmp[i] + tmp[i] * ratio, i === 0 ? 360 : 1));\n\t\ttmp = hsl2rgb(tmp);\n\t\tv.r = tmp[0];\n\t\tv.g = tmp[1];\n\t\tv.b = tmp[2];\n\t}\n}\nfunction clone(v, proto) {\n\treturn v ? Object.assign(proto || {}, v) : v;\n}\nfunction fromObject(input) {\n\tvar v = {r: 0, g: 0, b: 0, a: 255};\n\tif (Array.isArray(input)) {\n\t\tif (input.length >= 3) {\n\t\t\tv = {r: input[0], g: input[1], b: input[2], a: 255};\n\t\t\tif (input.length > 3) {\n\t\t\t\tv.a = n2b(input[3]);\n\t\t\t}\n\t\t}\n\t} else {\n\t\tv = clone(input, {r: 0, g: 0, b: 0, a: 1});\n\t\tv.a = n2b(v.a);\n\t}\n\treturn v;\n}\nfunction functionParse(str) {\n\tif (str.charAt(0) === 'r') {\n\t\treturn rgbParse(str);\n\t}\n\treturn hueParse(str);\n}\nclass Color {\n\tconstructor(input) {\n\t\tif (input instanceof Color) {\n\t\t\treturn input;\n\t\t}\n\t\tconst type = typeof input;\n\t\tlet v;\n\t\tif (type === 'object') {\n\t\t\tv = fromObject(input);\n\t\t} else if (type === 'string') {\n\t\t\tv = hexParse(input) || nameParse(input) || functionParse(input);\n\t\t}\n\t\tthis._rgb = v;\n\t\tthis._valid = !!v;\n\t}\n\tget valid() {\n\t\treturn this._valid;\n\t}\n\tget rgb() {\n\t\tvar v = clone(this._rgb);\n\t\tif (v) {\n\t\t\tv.a = b2n(v.a);\n\t\t}\n\t\treturn v;\n\t}\n\tset rgb(obj) {\n\t\tthis._rgb = fromObject(obj);\n\t}\n\trgbString() {\n\t\treturn this._valid ? rgbString(this._rgb) : this._rgb;\n\t}\n\thexString() {\n\t\treturn this._valid ? hexString(this._rgb) : this._rgb;\n\t}\n\thslString() {\n\t\treturn this._valid ? hslString(this._rgb) : this._rgb;\n\t}\n\tmix(color, weight) {\n\t\tconst me = this;\n\t\tif (color) {\n\t\t\tconst c1 = me.rgb;\n\t\t\tconst c2 = color.rgb;\n\t\t\tlet w2;\n\t\t\tconst p = weight === w2 ? 0.5 : weight;\n\t\t\tconst w = 2 * p - 1;\n\t\t\tconst a = c1.a - c2.a;\n\t\t\tconst w1 = ((w * a === -1 ? w : (w + a) / (1 + w * a)) + 1) / 2.0;\n\t\t\tw2 = 1 - w1;\n\t\t\tc1.r = 0xFF & w1 * c1.r + w2 * c2.r + 0.5;\n\t\t\tc1.g = 0xFF & w1 * c1.g + w2 * c2.g + 0.5;\n\t\t\tc1.b = 0xFF & w1 * c1.b + w2 * c2.b + 0.5;\n\t\t\tc1.a = p * c1.a + (1 - p) * c2.a;\n\t\t\tme.rgb = c1;\n\t\t}\n\t\treturn me;\n\t}\n\tclone() {\n\t\treturn new Color(this.rgb);\n\t}\n\talpha(a) {\n\t\tthis._rgb.a = n2b(a);\n\t\treturn this;\n\t}\n\tclearer(ratio) {\n\t\tconst rgb = this._rgb;\n\t\trgb.a *= 1 - ratio;\n\t\treturn this;\n\t}\n\tgreyscale() {\n\t\tconst rgb = this._rgb;\n\t\tconst val = round(rgb.r * 0.3 + rgb.g * 0.59 + rgb.b * 0.11);\n\t\trgb.r = rgb.g = rgb.b = val;\n\t\treturn this;\n\t}\n\topaquer(ratio) {\n\t\tconst rgb = this._rgb;\n\t\trgb.a *= 1 + ratio;\n\t\treturn this;\n\t}\n\tnegate() {\n\t\tconst v = this._rgb;\n\t\tv.r = 255 - v.r;\n\t\tv.g = 255 - v.g;\n\t\tv.b = 255 - v.b;\n\t\treturn this;\n\t}\n\tlighten(ratio) {\n\t\tmodHSL(this._rgb, 2, ratio);\n\t\treturn this;\n\t}\n\tdarken(ratio) {\n\t\tmodHSL(this._rgb, 2, -ratio);\n\t\treturn this;\n\t}\n\tsaturate(ratio) {\n\t\tmodHSL(this._rgb, 1, ratio);\n\t\treturn this;\n\t}\n\tdesaturate(ratio) {\n\t\tmodHSL(this._rgb, 1, -ratio);\n\t\treturn this;\n\t}\n\trotate(deg) {\n\t\trotate(this._rgb, deg);\n\t\treturn this;\n\t}\n}\nfunction index_esm(input) {\n\treturn new Color(input);\n}\n\nconst isPatternOrGradient = (value) => value instanceof CanvasGradient || value instanceof CanvasPattern;\nfunction color(value) {\n  return isPatternOrGradient(value) ? value : index_esm(value);\n}\nfunction getHoverColor(value) {\n  return isPatternOrGradient(value)\n    ? value\n    : index_esm(value).saturate(0.5).darken(0.1).hexString();\n}\n\nconst overrides = Object.create(null);\nconst descriptors = Object.create(null);\nfunction getScope$1(node, key) {\n  if (!key) {\n    return node;\n  }\n  const keys = key.split('.');\n  for (let i = 0, n = keys.length; i < n; ++i) {\n    const k = keys[i];\n    node = node[k] || (node[k] = Object.create(null));\n  }\n  return node;\n}\nfunction set(root, scope, values) {\n  if (typeof scope === 'string') {\n    return merge(getScope$1(root, scope), values);\n  }\n  return merge(getScope$1(root, ''), scope);\n}\nclass Defaults {\n  constructor(_descriptors) {\n    this.animation = undefined;\n    this.backgroundColor = 'rgba(0,0,0,0.1)';\n    this.borderColor = 'rgba(0,0,0,0.1)';\n    this.color = '#666';\n    this.datasets = {};\n    this.devicePixelRatio = (context) => context.chart.platform.getDevicePixelRatio();\n    this.elements = {};\n    this.events = [\n      'mousemove',\n      'mouseout',\n      'click',\n      'touchstart',\n      'touchmove'\n    ];\n    this.font = {\n      family: \"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif\",\n      size: 12,\n      style: 'normal',\n      lineHeight: 1.2,\n      weight: null\n    };\n    this.hover = {};\n    this.hoverBackgroundColor = (ctx, options) => getHoverColor(options.backgroundColor);\n    this.hoverBorderColor = (ctx, options) => getHoverColor(options.borderColor);\n    this.hoverColor = (ctx, options) => getHoverColor(options.color);\n    this.indexAxis = 'x';\n    this.interaction = {\n      mode: 'nearest',\n      intersect: true\n    };\n    this.maintainAspectRatio = true;\n    this.onHover = null;\n    this.onClick = null;\n    this.parsing = true;\n    this.plugins = {};\n    this.responsive = true;\n    this.scale = undefined;\n    this.scales = {};\n    this.showLine = true;\n    this.describe(_descriptors);\n  }\n  set(scope, values) {\n    return set(this, scope, values);\n  }\n  get(scope) {\n    return getScope$1(this, scope);\n  }\n  describe(scope, values) {\n    return set(descriptors, scope, values);\n  }\n  override(scope, values) {\n    return set(overrides, scope, values);\n  }\n  route(scope, name, targetScope, targetName) {\n    const scopeObject = getScope$1(this, scope);\n    const targetScopeObject = getScope$1(this, targetScope);\n    const privateName = '_' + name;\n    Object.defineProperties(scopeObject, {\n      [privateName]: {\n        value: scopeObject[name],\n        writable: true\n      },\n      [name]: {\n        enumerable: true,\n        get() {\n          const local = this[privateName];\n          const target = targetScopeObject[targetName];\n          if (isObject(local)) {\n            return Object.assign({}, target, local);\n          }\n          return valueOrDefault(local, target);\n        },\n        set(value) {\n          this[privateName] = value;\n        }\n      }\n    });\n  }\n}\nvar defaults = new Defaults({\n  _scriptable: (name) => !name.startsWith('on'),\n  _indexable: (name) => name !== 'events',\n  hover: {\n    _fallback: 'interaction'\n  },\n  interaction: {\n    _scriptable: false,\n    _indexable: false,\n  }\n});\n\nfunction toFontString(font) {\n  if (!font || isNullOrUndef(font.size) || isNullOrUndef(font.family)) {\n    return null;\n  }\n  return (font.style ? font.style + ' ' : '')\n\t\t+ (font.weight ? font.weight + ' ' : '')\n\t\t+ font.size + 'px '\n\t\t+ font.family;\n}\nfunction _measureText(ctx, data, gc, longest, string) {\n  let textWidth = data[string];\n  if (!textWidth) {\n    textWidth = data[string] = ctx.measureText(string).width;\n    gc.push(string);\n  }\n  if (textWidth > longest) {\n    longest = textWidth;\n  }\n  return longest;\n}\nfunction _longestText(ctx, font, arrayOfThings, cache) {\n  cache = cache || {};\n  let data = cache.data = cache.data || {};\n  let gc = cache.garbageCollect = cache.garbageCollect || [];\n  if (cache.font !== font) {\n    data = cache.data = {};\n    gc = cache.garbageCollect = [];\n    cache.font = font;\n  }\n  ctx.save();\n  ctx.font = font;\n  let longest = 0;\n  const ilen = arrayOfThings.length;\n  let i, j, jlen, thing, nestedThing;\n  for (i = 0; i < ilen; i++) {\n    thing = arrayOfThings[i];\n    if (thing !== undefined && thing !== null && isArray(thing) !== true) {\n      longest = _measureText(ctx, data, gc, longest, thing);\n    } else if (isArray(thing)) {\n      for (j = 0, jlen = thing.length; j < jlen; j++) {\n        nestedThing = thing[j];\n        if (nestedThing !== undefined && nestedThing !== null && !isArray(nestedThing)) {\n          longest = _measureText(ctx, data, gc, longest, nestedThing);\n        }\n      }\n    }\n  }\n  ctx.restore();\n  const gcLen = gc.length / 2;\n  if (gcLen > arrayOfThings.length) {\n    for (i = 0; i < gcLen; i++) {\n      delete data[gc[i]];\n    }\n    gc.splice(0, gcLen);\n  }\n  return longest;\n}\nfunction _alignPixel(chart, pixel, width) {\n  const devicePixelRatio = chart.currentDevicePixelRatio;\n  const halfWidth = width !== 0 ? Math.max(width / 2, 0.5) : 0;\n  return Math.round((pixel - halfWidth) * devicePixelRatio) / devicePixelRatio + halfWidth;\n}\nfunction clearCanvas(canvas, ctx) {\n  ctx = ctx || canvas.getContext('2d');\n  ctx.save();\n  ctx.resetTransform();\n  ctx.clearRect(0, 0, canvas.width, canvas.height);\n  ctx.restore();\n}\nfunction drawPoint(ctx, options, x, y) {\n  let type, xOffset, yOffset, size, cornerRadius;\n  const style = options.pointStyle;\n  const rotation = options.rotation;\n  const radius = options.radius;\n  let rad = (rotation || 0) * RAD_PER_DEG;\n  if (style && typeof style === 'object') {\n    type = style.toString();\n    if (type === '[object HTMLImageElement]' || type === '[object HTMLCanvasElement]') {\n      ctx.save();\n      ctx.translate(x, y);\n      ctx.rotate(rad);\n      ctx.drawImage(style, -style.width / 2, -style.height / 2, style.width, style.height);\n      ctx.restore();\n      return;\n    }\n  }\n  if (isNaN(radius) || radius <= 0) {\n    return;\n  }\n  ctx.beginPath();\n  switch (style) {\n  default:\n    ctx.arc(x, y, radius, 0, TAU);\n    ctx.closePath();\n    break;\n  case 'triangle':\n    ctx.moveTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);\n    rad += TWO_THIRDS_PI;\n    ctx.lineTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);\n    rad += TWO_THIRDS_PI;\n    ctx.lineTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);\n    ctx.closePath();\n    break;\n  case 'rectRounded':\n    cornerRadius = radius * 0.516;\n    size = radius - cornerRadius;\n    xOffset = Math.cos(rad + QUARTER_PI) * size;\n    yOffset = Math.sin(rad + QUARTER_PI) * size;\n    ctx.arc(x - xOffset, y - yOffset, cornerRadius, rad - PI, rad - HALF_PI);\n    ctx.arc(x + yOffset, y - xOffset, cornerRadius, rad - HALF_PI, rad);\n    ctx.arc(x + xOffset, y + yOffset, cornerRadius, rad, rad + HALF_PI);\n    ctx.arc(x - yOffset, y + xOffset, cornerRadius, rad + HALF_PI, rad + PI);\n    ctx.closePath();\n    break;\n  case 'rect':\n    if (!rotation) {\n      size = Math.SQRT1_2 * radius;\n      ctx.rect(x - size, y - size, 2 * size, 2 * size);\n      break;\n    }\n    rad += QUARTER_PI;\n  case 'rectRot':\n    xOffset = Math.cos(rad) * radius;\n    yOffset = Math.sin(rad) * radius;\n    ctx.moveTo(x - xOffset, y - yOffset);\n    ctx.lineTo(x + yOffset, y - xOffset);\n    ctx.lineTo(x + xOffset, y + yOffset);\n    ctx.lineTo(x - yOffset, y + xOffset);\n    ctx.closePath();\n    break;\n  case 'crossRot':\n    rad += QUARTER_PI;\n  case 'cross':\n    xOffset = Math.cos(rad) * radius;\n    yOffset = Math.sin(rad) * radius;\n    ctx.moveTo(x - xOffset, y - yOffset);\n    ctx.lineTo(x + xOffset, y + yOffset);\n    ctx.moveTo(x + yOffset, y - xOffset);\n    ctx.lineTo(x - yOffset, y + xOffset);\n    break;\n  case 'star':\n    xOffset = Math.cos(rad) * radius;\n    yOffset = Math.sin(rad) * radius;\n    ctx.moveTo(x - xOffset, y - yOffset);\n    ctx.lineTo(x + xOffset, y + yOffset);\n    ctx.moveTo(x + yOffset, y - xOffset);\n    ctx.lineTo(x - yOffset, y + xOffset);\n    rad += QUARTER_PI;\n    xOffset = Math.cos(rad) * radius;\n    yOffset = Math.sin(rad) * radius;\n    ctx.moveTo(x - xOffset, y - yOffset);\n    ctx.lineTo(x + xOffset, y + yOffset);\n    ctx.moveTo(x + yOffset, y - xOffset);\n    ctx.lineTo(x - yOffset, y + xOffset);\n    break;\n  case 'line':\n    xOffset = Math.cos(rad) * radius;\n    yOffset = Math.sin(rad) * radius;\n    ctx.moveTo(x - xOffset, y - yOffset);\n    ctx.lineTo(x + xOffset, y + yOffset);\n    break;\n  case 'dash':\n    ctx.moveTo(x, y);\n    ctx.lineTo(x + Math.cos(rad) * radius, y + Math.sin(rad) * radius);\n    break;\n  }\n  ctx.fill();\n  if (options.borderWidth > 0) {\n    ctx.stroke();\n  }\n}\nfunction _isPointInArea(point, area, margin) {\n  margin = margin || 0.5;\n  return !area || (point && point.x > area.left - margin && point.x < area.right + margin &&\n\t\tpoint.y > area.top - margin && point.y < area.bottom + margin);\n}\nfunction clipArea(ctx, area) {\n  ctx.save();\n  ctx.beginPath();\n  ctx.rect(area.left, area.top, area.right - area.left, area.bottom - area.top);\n  ctx.clip();\n}\nfunction unclipArea(ctx) {\n  ctx.restore();\n}\nfunction _steppedLineTo(ctx, previous, target, flip, mode) {\n  if (!previous) {\n    return ctx.lineTo(target.x, target.y);\n  }\n  if (mode === 'middle') {\n    const midpoint = (previous.x + target.x) / 2.0;\n    ctx.lineTo(midpoint, previous.y);\n    ctx.lineTo(midpoint, target.y);\n  } else if (mode === 'after' !== !!flip) {\n    ctx.lineTo(previous.x, target.y);\n  } else {\n    ctx.lineTo(target.x, previous.y);\n  }\n  ctx.lineTo(target.x, target.y);\n}\nfunction _bezierCurveTo(ctx, previous, target, flip) {\n  if (!previous) {\n    return ctx.lineTo(target.x, target.y);\n  }\n  ctx.bezierCurveTo(\n    flip ? previous.cp1x : previous.cp2x,\n    flip ? previous.cp1y : previous.cp2y,\n    flip ? target.cp2x : target.cp1x,\n    flip ? target.cp2y : target.cp1y,\n    target.x,\n    target.y);\n}\nfunction renderText(ctx, text, x, y, font, opts = {}) {\n  const lines = isArray(text) ? text : [text];\n  const stroke = opts.strokeWidth > 0 && opts.strokeColor !== '';\n  let i, line;\n  ctx.save();\n  ctx.font = font.string;\n  setRenderOpts(ctx, opts);\n  for (i = 0; i < lines.length; ++i) {\n    line = lines[i];\n    if (stroke) {\n      if (opts.strokeColor) {\n        ctx.strokeStyle = opts.strokeColor;\n      }\n      if (!isNullOrUndef(opts.strokeWidth)) {\n        ctx.lineWidth = opts.strokeWidth;\n      }\n      ctx.strokeText(line, x, y, opts.maxWidth);\n    }\n    ctx.fillText(line, x, y, opts.maxWidth);\n    decorateText(ctx, x, y, line, opts);\n    y += font.lineHeight;\n  }\n  ctx.restore();\n}\nfunction setRenderOpts(ctx, opts) {\n  if (opts.translation) {\n    ctx.translate(opts.translation[0], opts.translation[1]);\n  }\n  if (!isNullOrUndef(opts.rotation)) {\n    ctx.rotate(opts.rotation);\n  }\n  if (opts.color) {\n    ctx.fillStyle = opts.color;\n  }\n  if (opts.textAlign) {\n    ctx.textAlign = opts.textAlign;\n  }\n  if (opts.textBaseline) {\n    ctx.textBaseline = opts.textBaseline;\n  }\n}\nfunction decorateText(ctx, x, y, line, opts) {\n  if (opts.strikethrough || opts.underline) {\n    const metrics = ctx.measureText(line);\n    const left = x - metrics.actualBoundingBoxLeft;\n    const right = x + metrics.actualBoundingBoxRight;\n    const top = y - metrics.actualBoundingBoxAscent;\n    const bottom = y + metrics.actualBoundingBoxDescent;\n    const yDecoration = opts.strikethrough ? (top + bottom) / 2 : bottom;\n    ctx.strokeStyle = ctx.fillStyle;\n    ctx.beginPath();\n    ctx.lineWidth = opts.decorationWidth || 2;\n    ctx.moveTo(left, yDecoration);\n    ctx.lineTo(right, yDecoration);\n    ctx.stroke();\n  }\n}\nfunction addRoundedRectPath(ctx, rect) {\n  const {x, y, w, h, radius} = rect;\n  ctx.arc(x + radius.topLeft, y + radius.topLeft, radius.topLeft, -HALF_PI, PI, true);\n  ctx.lineTo(x, y + h - radius.bottomLeft);\n  ctx.arc(x + radius.bottomLeft, y + h - radius.bottomLeft, radius.bottomLeft, PI, HALF_PI, true);\n  ctx.lineTo(x + w - radius.bottomRight, y + h);\n  ctx.arc(x + w - radius.bottomRight, y + h - radius.bottomRight, radius.bottomRight, HALF_PI, 0, true);\n  ctx.lineTo(x + w, y + radius.topRight);\n  ctx.arc(x + w - radius.topRight, y + radius.topRight, radius.topRight, 0, -HALF_PI, true);\n  ctx.lineTo(x + radius.topLeft, y);\n}\n\nconst LINE_HEIGHT = new RegExp(/^(normal|(\\d+(?:\\.\\d+)?)(px|em|%)?)$/);\nconst FONT_STYLE = new RegExp(/^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/);\nfunction toLineHeight(value, size) {\n  const matches = ('' + value).match(LINE_HEIGHT);\n  if (!matches || matches[1] === 'normal') {\n    return size * 1.2;\n  }\n  value = +matches[2];\n  switch (matches[3]) {\n  case 'px':\n    return value;\n  case '%':\n    value /= 100;\n    break;\n  }\n  return size * value;\n}\nconst numberOrZero = v => +v || 0;\nfunction _readValueToProps(value, props) {\n  const ret = {};\n  const objProps = isObject(props);\n  const keys = objProps ? Object.keys(props) : props;\n  const read = isObject(value)\n    ? objProps\n      ? prop => valueOrDefault(value[prop], value[props[prop]])\n      : prop => value[prop]\n    : () => value;\n  for (const prop of keys) {\n    ret[prop] = numberOrZero(read(prop));\n  }\n  return ret;\n}\nfunction toTRBL(value) {\n  return _readValueToProps(value, {top: 'y', right: 'x', bottom: 'y', left: 'x'});\n}\nfunction toTRBLCorners(value) {\n  return _readValueToProps(value, ['topLeft', 'topRight', 'bottomLeft', 'bottomRight']);\n}\nfunction toPadding(value) {\n  const obj = toTRBL(value);\n  obj.width = obj.left + obj.right;\n  obj.height = obj.top + obj.bottom;\n  return obj;\n}\nfunction toFont(options, fallback) {\n  options = options || {};\n  fallback = fallback || defaults.font;\n  let size = valueOrDefault(options.size, fallback.size);\n  if (typeof size === 'string') {\n    size = parseInt(size, 10);\n  }\n  let style = valueOrDefault(options.style, fallback.style);\n  if (style && !('' + style).match(FONT_STYLE)) {\n    console.warn('Invalid font style specified: \"' + style + '\"');\n    style = '';\n  }\n  const font = {\n    family: valueOrDefault(options.family, fallback.family),\n    lineHeight: toLineHeight(valueOrDefault(options.lineHeight, fallback.lineHeight), size),\n    size,\n    style,\n    weight: valueOrDefault(options.weight, fallback.weight),\n    string: ''\n  };\n  font.string = toFontString(font);\n  return font;\n}\nfunction resolve(inputs, context, index, info) {\n  let cacheable = true;\n  let i, ilen, value;\n  for (i = 0, ilen = inputs.length; i < ilen; ++i) {\n    value = inputs[i];\n    if (value === undefined) {\n      continue;\n    }\n    if (context !== undefined && typeof value === 'function') {\n      value = value(context);\n      cacheable = false;\n    }\n    if (index !== undefined && isArray(value)) {\n      value = value[index % value.length];\n      cacheable = false;\n    }\n    if (value !== undefined) {\n      if (info && !cacheable) {\n        info.cacheable = false;\n      }\n      return value;\n    }\n  }\n}\nfunction _addGrace(minmax, grace) {\n  const {min, max} = minmax;\n  return {\n    min: min - Math.abs(toDimension(grace, min)),\n    max: max + toDimension(grace, max)\n  };\n}\n\nfunction _lookup(table, value, cmp) {\n  cmp = cmp || ((index) => table[index] < value);\n  let hi = table.length - 1;\n  let lo = 0;\n  let mid;\n  while (hi - lo > 1) {\n    mid = (lo + hi) >> 1;\n    if (cmp(mid)) {\n      lo = mid;\n    } else {\n      hi = mid;\n    }\n  }\n  return {lo, hi};\n}\nconst _lookupByKey = (table, key, value) =>\n  _lookup(table, value, index => table[index][key] < value);\nconst _rlookupByKey = (table, key, value) =>\n  _lookup(table, value, index => table[index][key] >= value);\nfunction _filterBetween(values, min, max) {\n  let start = 0;\n  let end = values.length;\n  while (start < end && values[start] < min) {\n    start++;\n  }\n  while (end > start && values[end - 1] > max) {\n    end--;\n  }\n  return start > 0 || end < values.length\n    ? values.slice(start, end)\n    : values;\n}\nconst arrayEvents = ['push', 'pop', 'shift', 'splice', 'unshift'];\nfunction listenArrayEvents(array, listener) {\n  if (array._chartjs) {\n    array._chartjs.listeners.push(listener);\n    return;\n  }\n  Object.defineProperty(array, '_chartjs', {\n    configurable: true,\n    enumerable: false,\n    value: {\n      listeners: [listener]\n    }\n  });\n  arrayEvents.forEach((key) => {\n    const method = '_onData' + _capitalize(key);\n    const base = array[key];\n    Object.defineProperty(array, key, {\n      configurable: true,\n      enumerable: false,\n      value(...args) {\n        const res = base.apply(this, args);\n        array._chartjs.listeners.forEach((object) => {\n          if (typeof object[method] === 'function') {\n            object[method](...args);\n          }\n        });\n        return res;\n      }\n    });\n  });\n}\nfunction unlistenArrayEvents(array, listener) {\n  const stub = array._chartjs;\n  if (!stub) {\n    return;\n  }\n  const listeners = stub.listeners;\n  const index = listeners.indexOf(listener);\n  if (index !== -1) {\n    listeners.splice(index, 1);\n  }\n  if (listeners.length > 0) {\n    return;\n  }\n  arrayEvents.forEach((key) => {\n    delete array[key];\n  });\n  delete array._chartjs;\n}\nfunction _arrayUnique(items) {\n  const set = new Set();\n  let i, ilen;\n  for (i = 0, ilen = items.length; i < ilen; ++i) {\n    set.add(items[i]);\n  }\n  if (set.size === ilen) {\n    return items;\n  }\n  return Array.from(set);\n}\n\nfunction _createResolver(scopes, prefixes = [''], rootScopes = scopes, fallback, getTarget = () => scopes[0]) {\n  if (!defined(fallback)) {\n    fallback = _resolve('_fallback', scopes);\n  }\n  const cache = {\n    [Symbol.toStringTag]: 'Object',\n    _cacheable: true,\n    _scopes: scopes,\n    _rootScopes: rootScopes,\n    _fallback: fallback,\n    _getTarget: getTarget,\n    override: (scope) => _createResolver([scope, ...scopes], prefixes, rootScopes, fallback),\n  };\n  return new Proxy(cache, {\n    deleteProperty(target, prop) {\n      delete target[prop];\n      delete target._keys;\n      delete scopes[0][prop];\n      return true;\n    },\n    get(target, prop) {\n      return _cached(target, prop,\n        () => _resolveWithPrefixes(prop, prefixes, scopes, target));\n    },\n    getOwnPropertyDescriptor(target, prop) {\n      return Reflect.getOwnPropertyDescriptor(target._scopes[0], prop);\n    },\n    getPrototypeOf() {\n      return Reflect.getPrototypeOf(scopes[0]);\n    },\n    has(target, prop) {\n      return getKeysFromAllScopes(target).includes(prop);\n    },\n    ownKeys(target) {\n      return getKeysFromAllScopes(target);\n    },\n    set(target, prop, value) {\n      const storage = target._storage || (target._storage = getTarget());\n      storage[prop] = value;\n      delete target[prop];\n      delete target._keys;\n      return true;\n    }\n  });\n}\nfunction _attachContext(proxy, context, subProxy, descriptorDefaults) {\n  const cache = {\n    _cacheable: false,\n    _proxy: proxy,\n    _context: context,\n    _subProxy: subProxy,\n    _stack: new Set(),\n    _descriptors: _descriptors(proxy, descriptorDefaults),\n    setContext: (ctx) => _attachContext(proxy, ctx, subProxy, descriptorDefaults),\n    override: (scope) => _attachContext(proxy.override(scope), context, subProxy, descriptorDefaults)\n  };\n  return new Proxy(cache, {\n    deleteProperty(target, prop) {\n      delete target[prop];\n      delete proxy[prop];\n      return true;\n    },\n    get(target, prop, receiver) {\n      return _cached(target, prop,\n        () => _resolveWithContext(target, prop, receiver));\n    },\n    getOwnPropertyDescriptor(target, prop) {\n      return target._descriptors.allKeys\n        ? Reflect.has(proxy, prop) ? {enumerable: true, configurable: true} : undefined\n        : Reflect.getOwnPropertyDescriptor(proxy, prop);\n    },\n    getPrototypeOf() {\n      return Reflect.getPrototypeOf(proxy);\n    },\n    has(target, prop) {\n      return Reflect.has(proxy, prop);\n    },\n    ownKeys() {\n      return Reflect.ownKeys(proxy);\n    },\n    set(target, prop, value) {\n      proxy[prop] = value;\n      delete target[prop];\n      return true;\n    }\n  });\n}\nfunction _descriptors(proxy, defaults = {scriptable: true, indexable: true}) {\n  const {_scriptable = defaults.scriptable, _indexable = defaults.indexable, _allKeys = defaults.allKeys} = proxy;\n  return {\n    allKeys: _allKeys,\n    scriptable: _scriptable,\n    indexable: _indexable,\n    isScriptable: isFunction(_scriptable) ? _scriptable : () => _scriptable,\n    isIndexable: isFunction(_indexable) ? _indexable : () => _indexable\n  };\n}\nconst readKey = (prefix, name) => prefix ? prefix + _capitalize(name) : name;\nconst needsSubResolver = (prop, value) => isObject(value) && prop !== 'adapters';\nfunction _cached(target, prop, resolve) {\n  let value = target[prop];\n  if (defined(value)) {\n    return value;\n  }\n  value = resolve();\n  if (defined(value)) {\n    target[prop] = value;\n  }\n  return value;\n}\nfunction _resolveWithContext(target, prop, receiver) {\n  const {_proxy, _context, _subProxy, _descriptors: descriptors} = target;\n  let value = _proxy[prop];\n  if (isFunction(value) && descriptors.isScriptable(prop)) {\n    value = _resolveScriptable(prop, value, target, receiver);\n  }\n  if (isArray(value) && value.length) {\n    value = _resolveArray(prop, value, target, descriptors.isIndexable);\n  }\n  if (needsSubResolver(prop, value)) {\n    value = _attachContext(value, _context, _subProxy && _subProxy[prop], descriptors);\n  }\n  return value;\n}\nfunction _resolveScriptable(prop, value, target, receiver) {\n  const {_proxy, _context, _subProxy, _stack} = target;\n  if (_stack.has(prop)) {\n    throw new Error('Recursion detected: ' + Array.from(_stack).join('->') + '->' + prop);\n  }\n  _stack.add(prop);\n  value = value(_context, _subProxy || receiver);\n  _stack.delete(prop);\n  if (isObject(value)) {\n    value = createSubResolver(_proxy._scopes, _proxy, prop, value);\n  }\n  return value;\n}\nfunction _resolveArray(prop, value, target, isIndexable) {\n  const {_proxy, _context, _subProxy, _descriptors: descriptors} = target;\n  if (defined(_context.index) && isIndexable(prop)) {\n    value = value[_context.index % value.length];\n  } else if (isObject(value[0])) {\n    const arr = value;\n    const scopes = _proxy._scopes.filter(s => s !== arr);\n    value = [];\n    for (const item of arr) {\n      const resolver = createSubResolver(scopes, _proxy, prop, item);\n      value.push(_attachContext(resolver, _context, _subProxy && _subProxy[prop], descriptors));\n    }\n  }\n  return value;\n}\nfunction resolveFallback(fallback, prop, value) {\n  return isFunction(fallback) ? fallback(prop, value) : fallback;\n}\nconst getScope = (key, parent) => key === true ? parent\n  : typeof key === 'string' ? resolveObjectKey(parent, key) : undefined;\nfunction addScopes(set, parentScopes, key, parentFallback) {\n  for (const parent of parentScopes) {\n    const scope = getScope(key, parent);\n    if (scope) {\n      set.add(scope);\n      const fallback = resolveFallback(scope._fallback, key, scope);\n      if (defined(fallback) && fallback !== key && fallback !== parentFallback) {\n        return fallback;\n      }\n    } else if (scope === false && defined(parentFallback) && key !== parentFallback) {\n      return null;\n    }\n  }\n  return false;\n}\nfunction createSubResolver(parentScopes, resolver, prop, value) {\n  const rootScopes = resolver._rootScopes;\n  const fallback = resolveFallback(resolver._fallback, prop, value);\n  const allScopes = [...parentScopes, ...rootScopes];\n  const set = new Set();\n  set.add(value);\n  let key = addScopesFromKey(set, allScopes, prop, fallback || prop);\n  if (key === null) {\n    return false;\n  }\n  if (defined(fallback) && fallback !== prop) {\n    key = addScopesFromKey(set, allScopes, fallback, key);\n    if (key === null) {\n      return false;\n    }\n  }\n  return _createResolver(Array.from(set), [''], rootScopes, fallback,\n    () => subGetTarget(resolver, prop, value));\n}\nfunction addScopesFromKey(set, allScopes, key, fallback) {\n  while (key) {\n    key = addScopes(set, allScopes, key, fallback);\n  }\n  return key;\n}\nfunction subGetTarget(resolver, prop, value) {\n  const parent = resolver._getTarget();\n  if (!(prop in parent)) {\n    parent[prop] = {};\n  }\n  const target = parent[prop];\n  if (isArray(target) && isObject(value)) {\n    return value;\n  }\n  return target;\n}\nfunction _resolveWithPrefixes(prop, prefixes, scopes, proxy) {\n  let value;\n  for (const prefix of prefixes) {\n    value = _resolve(readKey(prefix, prop), scopes);\n    if (defined(value)) {\n      return needsSubResolver(prop, value)\n        ? createSubResolver(scopes, proxy, prop, value)\n        : value;\n    }\n  }\n}\nfunction _resolve(key, scopes) {\n  for (const scope of scopes) {\n    if (!scope) {\n      continue;\n    }\n    const value = scope[key];\n    if (defined(value)) {\n      return value;\n    }\n  }\n}\nfunction getKeysFromAllScopes(target) {\n  let keys = target._keys;\n  if (!keys) {\n    keys = target._keys = resolveKeysFromAllScopes(target._scopes);\n  }\n  return keys;\n}\nfunction resolveKeysFromAllScopes(scopes) {\n  const set = new Set();\n  for (const scope of scopes) {\n    for (const key of Object.keys(scope).filter(k => !k.startsWith('_'))) {\n      set.add(key);\n    }\n  }\n  return Array.from(set);\n}\n\nconst EPSILON = Number.EPSILON || 1e-14;\nconst getPoint = (points, i) => i < points.length && !points[i].skip && points[i];\nconst getValueAxis = (indexAxis) => indexAxis === 'x' ? 'y' : 'x';\nfunction splineCurve(firstPoint, middlePoint, afterPoint, t) {\n  const previous = firstPoint.skip ? middlePoint : firstPoint;\n  const current = middlePoint;\n  const next = afterPoint.skip ? middlePoint : afterPoint;\n  const d01 = distanceBetweenPoints(current, previous);\n  const d12 = distanceBetweenPoints(next, current);\n  let s01 = d01 / (d01 + d12);\n  let s12 = d12 / (d01 + d12);\n  s01 = isNaN(s01) ? 0 : s01;\n  s12 = isNaN(s12) ? 0 : s12;\n  const fa = t * s01;\n  const fb = t * s12;\n  return {\n    previous: {\n      x: current.x - fa * (next.x - previous.x),\n      y: current.y - fa * (next.y - previous.y)\n    },\n    next: {\n      x: current.x + fb * (next.x - previous.x),\n      y: current.y + fb * (next.y - previous.y)\n    }\n  };\n}\nfunction monotoneAdjust(points, deltaK, mK) {\n  const pointsLen = points.length;\n  let alphaK, betaK, tauK, squaredMagnitude, pointCurrent;\n  let pointAfter = getPoint(points, 0);\n  for (let i = 0; i < pointsLen - 1; ++i) {\n    pointCurrent = pointAfter;\n    pointAfter = getPoint(points, i + 1);\n    if (!pointCurrent || !pointAfter) {\n      continue;\n    }\n    if (almostEquals(deltaK[i], 0, EPSILON)) {\n      mK[i] = mK[i + 1] = 0;\n      continue;\n    }\n    alphaK = mK[i] / deltaK[i];\n    betaK = mK[i + 1] / deltaK[i];\n    squaredMagnitude = Math.pow(alphaK, 2) + Math.pow(betaK, 2);\n    if (squaredMagnitude <= 9) {\n      continue;\n    }\n    tauK = 3 / Math.sqrt(squaredMagnitude);\n    mK[i] = alphaK * tauK * deltaK[i];\n    mK[i + 1] = betaK * tauK * deltaK[i];\n  }\n}\nfunction monotoneCompute(points, mK, indexAxis = 'x') {\n  const valueAxis = getValueAxis(indexAxis);\n  const pointsLen = points.length;\n  let delta, pointBefore, pointCurrent;\n  let pointAfter = getPoint(points, 0);\n  for (let i = 0; i < pointsLen; ++i) {\n    pointBefore = pointCurrent;\n    pointCurrent = pointAfter;\n    pointAfter = getPoint(points, i + 1);\n    if (!pointCurrent) {\n      continue;\n    }\n    const iPixel = pointCurrent[indexAxis];\n    const vPixel = pointCurrent[valueAxis];\n    if (pointBefore) {\n      delta = (iPixel - pointBefore[indexAxis]) / 3;\n      pointCurrent[`cp1${indexAxis}`] = iPixel - delta;\n      pointCurrent[`cp1${valueAxis}`] = vPixel - delta * mK[i];\n    }\n    if (pointAfter) {\n      delta = (pointAfter[indexAxis] - iPixel) / 3;\n      pointCurrent[`cp2${indexAxis}`] = iPixel + delta;\n      pointCurrent[`cp2${valueAxis}`] = vPixel + delta * mK[i];\n    }\n  }\n}\nfunction splineCurveMonotone(points, indexAxis = 'x') {\n  const valueAxis = getValueAxis(indexAxis);\n  const pointsLen = points.length;\n  const deltaK = Array(pointsLen).fill(0);\n  const mK = Array(pointsLen);\n  let i, pointBefore, pointCurrent;\n  let pointAfter = getPoint(points, 0);\n  for (i = 0; i < pointsLen; ++i) {\n    pointBefore = pointCurrent;\n    pointCurrent = pointAfter;\n    pointAfter = getPoint(points, i + 1);\n    if (!pointCurrent) {\n      continue;\n    }\n    if (pointAfter) {\n      const slopeDelta = pointAfter[indexAxis] - pointCurrent[indexAxis];\n      deltaK[i] = slopeDelta !== 0 ? (pointAfter[valueAxis] - pointCurrent[valueAxis]) / slopeDelta : 0;\n    }\n    mK[i] = !pointBefore ? deltaK[i]\n      : !pointAfter ? deltaK[i - 1]\n      : (sign(deltaK[i - 1]) !== sign(deltaK[i])) ? 0\n      : (deltaK[i - 1] + deltaK[i]) / 2;\n  }\n  monotoneAdjust(points, deltaK, mK);\n  monotoneCompute(points, mK, indexAxis);\n}\nfunction capControlPoint(pt, min, max) {\n  return Math.max(Math.min(pt, max), min);\n}\nfunction capBezierPoints(points, area) {\n  let i, ilen, point, inArea, inAreaPrev;\n  let inAreaNext = _isPointInArea(points[0], area);\n  for (i = 0, ilen = points.length; i < ilen; ++i) {\n    inAreaPrev = inArea;\n    inArea = inAreaNext;\n    inAreaNext = i < ilen - 1 && _isPointInArea(points[i + 1], area);\n    if (!inArea) {\n      continue;\n    }\n    point = points[i];\n    if (inAreaPrev) {\n      point.cp1x = capControlPoint(point.cp1x, area.left, area.right);\n      point.cp1y = capControlPoint(point.cp1y, area.top, area.bottom);\n    }\n    if (inAreaNext) {\n      point.cp2x = capControlPoint(point.cp2x, area.left, area.right);\n      point.cp2y = capControlPoint(point.cp2y, area.top, area.bottom);\n    }\n  }\n}\nfunction _updateBezierControlPoints(points, options, area, loop, indexAxis) {\n  let i, ilen, point, controlPoints;\n  if (options.spanGaps) {\n    points = points.filter((pt) => !pt.skip);\n  }\n  if (options.cubicInterpolationMode === 'monotone') {\n    splineCurveMonotone(points, indexAxis);\n  } else {\n    let prev = loop ? points[points.length - 1] : points[0];\n    for (i = 0, ilen = points.length; i < ilen; ++i) {\n      point = points[i];\n      controlPoints = splineCurve(\n        prev,\n        point,\n        points[Math.min(i + 1, ilen - (loop ? 0 : 1)) % ilen],\n        options.tension\n      );\n      point.cp1x = controlPoints.previous.x;\n      point.cp1y = controlPoints.previous.y;\n      point.cp2x = controlPoints.next.x;\n      point.cp2y = controlPoints.next.y;\n      prev = point;\n    }\n  }\n  if (options.capBezierPoints) {\n    capBezierPoints(points, area);\n  }\n}\n\nfunction _isDomSupported() {\n  return typeof window !== 'undefined' && typeof document !== 'undefined';\n}\nfunction _getParentNode(domNode) {\n  let parent = domNode.parentNode;\n  if (parent && parent.toString() === '[object ShadowRoot]') {\n    parent = parent.host;\n  }\n  return parent;\n}\nfunction parseMaxStyle(styleValue, node, parentProperty) {\n  let valueInPixels;\n  if (typeof styleValue === 'string') {\n    valueInPixels = parseInt(styleValue, 10);\n    if (styleValue.indexOf('%') !== -1) {\n      valueInPixels = valueInPixels / 100 * node.parentNode[parentProperty];\n    }\n  } else {\n    valueInPixels = styleValue;\n  }\n  return valueInPixels;\n}\nconst getComputedStyle = (element) => window.getComputedStyle(element, null);\nfunction getStyle(el, property) {\n  return getComputedStyle(el).getPropertyValue(property);\n}\nconst positions = ['top', 'right', 'bottom', 'left'];\nfunction getPositionedStyle(styles, style, suffix) {\n  const result = {};\n  suffix = suffix ? '-' + suffix : '';\n  for (let i = 0; i < 4; i++) {\n    const pos = positions[i];\n    result[pos] = parseFloat(styles[style + '-' + pos + suffix]) || 0;\n  }\n  result.width = result.left + result.right;\n  result.height = result.top + result.bottom;\n  return result;\n}\nconst useOffsetPos = (x, y, target) => (x > 0 || y > 0) && (!target || !target.shadowRoot);\nfunction getCanvasPosition(evt, canvas) {\n  const e = evt.native || evt;\n  const touches = e.touches;\n  const source = touches && touches.length ? touches[0] : e;\n  const {offsetX, offsetY} = source;\n  let box = false;\n  let x, y;\n  if (useOffsetPos(offsetX, offsetY, e.target)) {\n    x = offsetX;\n    y = offsetY;\n  } else {\n    const rect = canvas.getBoundingClientRect();\n    x = source.clientX - rect.left;\n    y = source.clientY - rect.top;\n    box = true;\n  }\n  return {x, y, box};\n}\nfunction getRelativePosition(evt, chart) {\n  const {canvas, currentDevicePixelRatio} = chart;\n  const style = getComputedStyle(canvas);\n  const borderBox = style.boxSizing === 'border-box';\n  const paddings = getPositionedStyle(style, 'padding');\n  const borders = getPositionedStyle(style, 'border', 'width');\n  const {x, y, box} = getCanvasPosition(evt, canvas);\n  const xOffset = paddings.left + (box && borders.left);\n  const yOffset = paddings.top + (box && borders.top);\n  let {width, height} = chart;\n  if (borderBox) {\n    width -= paddings.width + borders.width;\n    height -= paddings.height + borders.height;\n  }\n  return {\n    x: Math.round((x - xOffset) / width * canvas.width / currentDevicePixelRatio),\n    y: Math.round((y - yOffset) / height * canvas.height / currentDevicePixelRatio)\n  };\n}\nfunction getContainerSize(canvas, width, height) {\n  let maxWidth, maxHeight;\n  if (width === undefined || height === undefined) {\n    const container = _getParentNode(canvas);\n    if (!container) {\n      width = canvas.clientWidth;\n      height = canvas.clientHeight;\n    } else {\n      const rect = container.getBoundingClientRect();\n      const containerStyle = getComputedStyle(container);\n      const containerBorder = getPositionedStyle(containerStyle, 'border', 'width');\n      const containerPadding = getPositionedStyle(containerStyle, 'padding');\n      width = rect.width - containerPadding.width - containerBorder.width;\n      height = rect.height - containerPadding.height - containerBorder.height;\n      maxWidth = parseMaxStyle(containerStyle.maxWidth, container, 'clientWidth');\n      maxHeight = parseMaxStyle(containerStyle.maxHeight, container, 'clientHeight');\n    }\n  }\n  return {\n    width,\n    height,\n    maxWidth: maxWidth || INFINITY,\n    maxHeight: maxHeight || INFINITY\n  };\n}\nconst round1 = v => Math.round(v * 10) / 10;\nfunction getMaximumSize(canvas, bbWidth, bbHeight, aspectRatio) {\n  const style = getComputedStyle(canvas);\n  const margins = getPositionedStyle(style, 'margin');\n  const maxWidth = parseMaxStyle(style.maxWidth, canvas, 'clientWidth') || INFINITY;\n  const maxHeight = parseMaxStyle(style.maxHeight, canvas, 'clientHeight') || INFINITY;\n  const containerSize = getContainerSize(canvas, bbWidth, bbHeight);\n  let {width, height} = containerSize;\n  if (style.boxSizing === 'content-box') {\n    const borders = getPositionedStyle(style, 'border', 'width');\n    const paddings = getPositionedStyle(style, 'padding');\n    width -= paddings.width + borders.width;\n    height -= paddings.height + borders.height;\n  }\n  width = Math.max(0, width - margins.width);\n  height = Math.max(0, aspectRatio ? Math.floor(width / aspectRatio) : height - margins.height);\n  width = round1(Math.min(width, maxWidth, containerSize.maxWidth));\n  height = round1(Math.min(height, maxHeight, containerSize.maxHeight));\n  if (width && !height) {\n    height = round1(width / 2);\n  }\n  return {\n    width,\n    height\n  };\n}\nfunction retinaScale(chart, forceRatio, forceStyle) {\n  const pixelRatio = forceRatio || 1;\n  const deviceHeight = Math.floor(chart.height * pixelRatio);\n  const deviceWidth = Math.floor(chart.width * pixelRatio);\n  chart.height = deviceHeight / pixelRatio;\n  chart.width = deviceWidth / pixelRatio;\n  const canvas = chart.canvas;\n  if (canvas.style && (forceStyle || (!canvas.style.height && !canvas.style.width))) {\n    canvas.style.height = `${chart.height}px`;\n    canvas.style.width = `${chart.width}px`;\n  }\n  if (chart.currentDevicePixelRatio !== pixelRatio\n      || canvas.height !== deviceHeight\n      || canvas.width !== deviceWidth) {\n    chart.currentDevicePixelRatio = pixelRatio;\n    canvas.height = deviceHeight;\n    canvas.width = deviceWidth;\n    chart.ctx.setTransform(pixelRatio, 0, 0, pixelRatio, 0, 0);\n    return true;\n  }\n  return false;\n}\nconst supportsEventListenerOptions = (function() {\n  let passiveSupported = false;\n  try {\n    const options = {\n      get passive() {\n        passiveSupported = true;\n        return false;\n      }\n    };\n    window.addEventListener('test', null, options);\n    window.removeEventListener('test', null, options);\n  } catch (e) {\n  }\n  return passiveSupported;\n}());\nfunction readUsedSize(element, property) {\n  const value = getStyle(element, property);\n  const matches = value && value.match(/^(\\d+)(\\.\\d+)?px$/);\n  return matches ? +matches[1] : undefined;\n}\n\nfunction _pointInLine(p1, p2, t, mode) {\n  return {\n    x: p1.x + t * (p2.x - p1.x),\n    y: p1.y + t * (p2.y - p1.y)\n  };\n}\nfunction _steppedInterpolation(p1, p2, t, mode) {\n  return {\n    x: p1.x + t * (p2.x - p1.x),\n    y: mode === 'middle' ? t < 0.5 ? p1.y : p2.y\n    : mode === 'after' ? t < 1 ? p1.y : p2.y\n    : t > 0 ? p2.y : p1.y\n  };\n}\nfunction _bezierInterpolation(p1, p2, t, mode) {\n  const cp1 = {x: p1.cp2x, y: p1.cp2y};\n  const cp2 = {x: p2.cp1x, y: p2.cp1y};\n  const a = _pointInLine(p1, cp1, t);\n  const b = _pointInLine(cp1, cp2, t);\n  const c = _pointInLine(cp2, p2, t);\n  const d = _pointInLine(a, b, t);\n  const e = _pointInLine(b, c, t);\n  return _pointInLine(d, e, t);\n}\n\nconst intlCache = new Map();\nfunction getNumberFormat(locale, options) {\n  options = options || {};\n  const cacheKey = locale + JSON.stringify(options);\n  let formatter = intlCache.get(cacheKey);\n  if (!formatter) {\n    formatter = new Intl.NumberFormat(locale, options);\n    intlCache.set(cacheKey, formatter);\n  }\n  return formatter;\n}\nfunction formatNumber(num, locale, options) {\n  return getNumberFormat(locale, options).format(num);\n}\n\nconst getRightToLeftAdapter = function(rectX, width) {\n  return {\n    x(x) {\n      return rectX + rectX + width - x;\n    },\n    setWidth(w) {\n      width = w;\n    },\n    textAlign(align) {\n      if (align === 'center') {\n        return align;\n      }\n      return align === 'right' ? 'left' : 'right';\n    },\n    xPlus(x, value) {\n      return x - value;\n    },\n    leftForLtr(x, itemWidth) {\n      return x - itemWidth;\n    },\n  };\n};\nconst getLeftToRightAdapter = function() {\n  return {\n    x(x) {\n      return x;\n    },\n    setWidth(w) {\n    },\n    textAlign(align) {\n      return align;\n    },\n    xPlus(x, value) {\n      return x + value;\n    },\n    leftForLtr(x, _itemWidth) {\n      return x;\n    },\n  };\n};\nfunction getRtlAdapter(rtl, rectX, width) {\n  return rtl ? getRightToLeftAdapter(rectX, width) : getLeftToRightAdapter();\n}\nfunction overrideTextDirection(ctx, direction) {\n  let style, original;\n  if (direction === 'ltr' || direction === 'rtl') {\n    style = ctx.canvas.style;\n    original = [\n      style.getPropertyValue('direction'),\n      style.getPropertyPriority('direction'),\n    ];\n    style.setProperty('direction', direction, 'important');\n    ctx.prevTextDirection = original;\n  }\n}\nfunction restoreTextDirection(ctx, original) {\n  if (original !== undefined) {\n    delete ctx.prevTextDirection;\n    ctx.canvas.style.setProperty('direction', original[0], original[1]);\n  }\n}\n\nfunction propertyFn(property) {\n  if (property === 'angle') {\n    return {\n      between: _angleBetween,\n      compare: _angleDiff,\n      normalize: _normalizeAngle,\n    };\n  }\n  return {\n    between: (n, s, e) => n >= Math.min(s, e) && n <= Math.max(e, s),\n    compare: (a, b) => a - b,\n    normalize: x => x\n  };\n}\nfunction normalizeSegment({start, end, count, loop, style}) {\n  return {\n    start: start % count,\n    end: end % count,\n    loop: loop && (end - start + 1) % count === 0,\n    style\n  };\n}\nfunction getSegment(segment, points, bounds) {\n  const {property, start: startBound, end: endBound} = bounds;\n  const {between, normalize} = propertyFn(property);\n  const count = points.length;\n  let {start, end, loop} = segment;\n  let i, ilen;\n  if (loop) {\n    start += count;\n    end += count;\n    for (i = 0, ilen = count; i < ilen; ++i) {\n      if (!between(normalize(points[start % count][property]), startBound, endBound)) {\n        break;\n      }\n      start--;\n      end--;\n    }\n    start %= count;\n    end %= count;\n  }\n  if (end < start) {\n    end += count;\n  }\n  return {start, end, loop, style: segment.style};\n}\nfunction _boundSegment(segment, points, bounds) {\n  if (!bounds) {\n    return [segment];\n  }\n  const {property, start: startBound, end: endBound} = bounds;\n  const count = points.length;\n  const {compare, between, normalize} = propertyFn(property);\n  const {start, end, loop, style} = getSegment(segment, points, bounds);\n  const result = [];\n  let inside = false;\n  let subStart = null;\n  let value, point, prevValue;\n  const startIsBefore = () => between(startBound, prevValue, value) && compare(startBound, prevValue) !== 0;\n  const endIsBefore = () => compare(endBound, value) === 0 || between(endBound, prevValue, value);\n  const shouldStart = () => inside || startIsBefore();\n  const shouldStop = () => !inside || endIsBefore();\n  for (let i = start, prev = start; i <= end; ++i) {\n    point = points[i % count];\n    if (point.skip) {\n      continue;\n    }\n    value = normalize(point[property]);\n    if (value === prevValue) {\n      continue;\n    }\n    inside = between(value, startBound, endBound);\n    if (subStart === null && shouldStart()) {\n      subStart = compare(value, startBound) === 0 ? i : prev;\n    }\n    if (subStart !== null && shouldStop()) {\n      result.push(normalizeSegment({start: subStart, end: i, loop, count, style}));\n      subStart = null;\n    }\n    prev = i;\n    prevValue = value;\n  }\n  if (subStart !== null) {\n    result.push(normalizeSegment({start: subStart, end, loop, count, style}));\n  }\n  return result;\n}\nfunction _boundSegments(line, bounds) {\n  const result = [];\n  const segments = line.segments;\n  for (let i = 0; i < segments.length; i++) {\n    const sub = _boundSegment(segments[i], line.points, bounds);\n    if (sub.length) {\n      result.push(...sub);\n    }\n  }\n  return result;\n}\nfunction findStartAndEnd(points, count, loop, spanGaps) {\n  let start = 0;\n  let end = count - 1;\n  if (loop && !spanGaps) {\n    while (start < count && !points[start].skip) {\n      start++;\n    }\n  }\n  while (start < count && points[start].skip) {\n    start++;\n  }\n  start %= count;\n  if (loop) {\n    end += start;\n  }\n  while (end > start && points[end % count].skip) {\n    end--;\n  }\n  end %= count;\n  return {start, end};\n}\nfunction solidSegments(points, start, max, loop) {\n  const count = points.length;\n  const result = [];\n  let last = start;\n  let prev = points[start];\n  let end;\n  for (end = start + 1; end <= max; ++end) {\n    const cur = points[end % count];\n    if (cur.skip || cur.stop) {\n      if (!prev.skip) {\n        loop = false;\n        result.push({start: start % count, end: (end - 1) % count, loop});\n        start = last = cur.stop ? end : null;\n      }\n    } else {\n      last = end;\n      if (prev.skip) {\n        start = end;\n      }\n    }\n    prev = cur;\n  }\n  if (last !== null) {\n    result.push({start: start % count, end: last % count, loop});\n  }\n  return result;\n}\nfunction _computeSegments(line, segmentOptions) {\n  const points = line.points;\n  const spanGaps = line.options.spanGaps;\n  const count = points.length;\n  if (!count) {\n    return [];\n  }\n  const loop = !!line._loop;\n  const {start, end} = findStartAndEnd(points, count, loop, spanGaps);\n  if (spanGaps === true) {\n    return splitByStyles(line, [{start, end, loop}], points, segmentOptions);\n  }\n  const max = end < start ? end + count : end;\n  const completeLoop = !!line._fullLoop && start === 0 && end === count - 1;\n  return splitByStyles(line, solidSegments(points, start, max, completeLoop), points, segmentOptions);\n}\nfunction splitByStyles(line, segments, points, segmentOptions) {\n  if (!segmentOptions || !segmentOptions.setContext || !points) {\n    return segments;\n  }\n  return doSplitByStyles(line, segments, points, segmentOptions);\n}\nfunction doSplitByStyles(line, segments, points, segmentOptions) {\n  const baseStyle = readStyle(line.options);\n  const count = points.length;\n  const result = [];\n  let start = segments[0].start;\n  let i = start;\n  for (const segment of segments) {\n    let prevStyle = baseStyle;\n    let prev = points[start % count];\n    let style;\n    for (i = start + 1; i <= segment.end; i++) {\n      const pt = points[i % count];\n      style = readStyle(segmentOptions.setContext({\n        type: 'segment',\n        p0: prev,\n        p1: pt,\n        p0DataIndex: (i - 1) % count,\n        p1DataIndex: i % count,\n        datasetIndex: line._datasetIndex\n      }));\n      if (styleChanged(style, prevStyle)) {\n        result.push({start: start, end: i - 1, loop: segment.loop, style: prevStyle});\n        prevStyle = style;\n        start = i - 1;\n      }\n      prev = pt;\n      prevStyle = style;\n    }\n    if (start < i - 1) {\n      result.push({start, end: i - 1, loop: segment.loop, style});\n      start = i - 1;\n    }\n  }\n  return result;\n}\nfunction readStyle(options) {\n  return {\n    backgroundColor: options.backgroundColor,\n    borderCapStyle: options.borderCapStyle,\n    borderDash: options.borderDash,\n    borderDashOffset: options.borderDashOffset,\n    borderJoinStyle: options.borderJoinStyle,\n    borderWidth: options.borderWidth,\n    borderColor: options.borderColor\n  };\n}\nfunction styleChanged(style, prevStyle) {\n  return prevStyle && JSON.stringify(style) !== JSON.stringify(prevStyle);\n}\n\n\n\n\n//# sourceURL=webpack://toweb/./node_modules/chart.js/dist/chunks/helpers.segment.js?");

/***/ }),

/***/ "./node_modules/three/build/three.module.js":
/*!**************************************************!*\
  !*** ./node_modules/three/build/three.module.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"ACESFilmicToneMapping\": () => (/* binding */ ACESFilmicToneMapping),\n/* harmony export */   \"AddEquation\": () => (/* binding */ AddEquation),\n/* harmony export */   \"AddOperation\": () => (/* binding */ AddOperation),\n/* harmony export */   \"AdditiveAnimationBlendMode\": () => (/* binding */ AdditiveAnimationBlendMode),\n/* harmony export */   \"AdditiveBlending\": () => (/* binding */ AdditiveBlending),\n/* harmony export */   \"AlphaFormat\": () => (/* binding */ AlphaFormat),\n/* harmony export */   \"AlwaysDepth\": () => (/* binding */ AlwaysDepth),\n/* harmony export */   \"AlwaysStencilFunc\": () => (/* binding */ AlwaysStencilFunc),\n/* harmony export */   \"AmbientLight\": () => (/* binding */ AmbientLight),\n/* harmony export */   \"AmbientLightProbe\": () => (/* binding */ AmbientLightProbe),\n/* harmony export */   \"AnimationClip\": () => (/* binding */ AnimationClip),\n/* harmony export */   \"AnimationLoader\": () => (/* binding */ AnimationLoader),\n/* harmony export */   \"AnimationMixer\": () => (/* binding */ AnimationMixer),\n/* harmony export */   \"AnimationObjectGroup\": () => (/* binding */ AnimationObjectGroup),\n/* harmony export */   \"AnimationUtils\": () => (/* binding */ AnimationUtils),\n/* harmony export */   \"ArcCurve\": () => (/* binding */ ArcCurve),\n/* harmony export */   \"ArrayCamera\": () => (/* binding */ ArrayCamera),\n/* harmony export */   \"ArrowHelper\": () => (/* binding */ ArrowHelper),\n/* harmony export */   \"Audio\": () => (/* binding */ Audio),\n/* harmony export */   \"AudioAnalyser\": () => (/* binding */ AudioAnalyser),\n/* harmony export */   \"AudioContext\": () => (/* binding */ AudioContext),\n/* harmony export */   \"AudioListener\": () => (/* binding */ AudioListener),\n/* harmony export */   \"AudioLoader\": () => (/* binding */ AudioLoader),\n/* harmony export */   \"AxesHelper\": () => (/* binding */ AxesHelper),\n/* harmony export */   \"AxisHelper\": () => (/* binding */ AxisHelper),\n/* harmony export */   \"BackSide\": () => (/* binding */ BackSide),\n/* harmony export */   \"BasicDepthPacking\": () => (/* binding */ BasicDepthPacking),\n/* harmony export */   \"BasicShadowMap\": () => (/* binding */ BasicShadowMap),\n/* harmony export */   \"BinaryTextureLoader\": () => (/* binding */ BinaryTextureLoader),\n/* harmony export */   \"Bone\": () => (/* binding */ Bone),\n/* harmony export */   \"BooleanKeyframeTrack\": () => (/* binding */ BooleanKeyframeTrack),\n/* harmony export */   \"BoundingBoxHelper\": () => (/* binding */ BoundingBoxHelper),\n/* harmony export */   \"Box2\": () => (/* binding */ Box2),\n/* harmony export */   \"Box3\": () => (/* binding */ Box3),\n/* harmony export */   \"Box3Helper\": () => (/* binding */ Box3Helper),\n/* harmony export */   \"BoxBufferGeometry\": () => (/* binding */ BoxGeometry),\n/* harmony export */   \"BoxGeometry\": () => (/* binding */ BoxGeometry),\n/* harmony export */   \"BoxHelper\": () => (/* binding */ BoxHelper),\n/* harmony export */   \"BufferAttribute\": () => (/* binding */ BufferAttribute),\n/* harmony export */   \"BufferGeometry\": () => (/* binding */ BufferGeometry),\n/* harmony export */   \"BufferGeometryLoader\": () => (/* binding */ BufferGeometryLoader),\n/* harmony export */   \"ByteType\": () => (/* binding */ ByteType),\n/* harmony export */   \"Cache\": () => (/* binding */ Cache),\n/* harmony export */   \"Camera\": () => (/* binding */ Camera),\n/* harmony export */   \"CameraHelper\": () => (/* binding */ CameraHelper),\n/* harmony export */   \"CanvasRenderer\": () => (/* binding */ CanvasRenderer),\n/* harmony export */   \"CanvasTexture\": () => (/* binding */ CanvasTexture),\n/* harmony export */   \"CatmullRomCurve3\": () => (/* binding */ CatmullRomCurve3),\n/* harmony export */   \"CineonToneMapping\": () => (/* binding */ CineonToneMapping),\n/* harmony export */   \"CircleBufferGeometry\": () => (/* binding */ CircleGeometry),\n/* harmony export */   \"CircleGeometry\": () => (/* binding */ CircleGeometry),\n/* harmony export */   \"ClampToEdgeWrapping\": () => (/* binding */ ClampToEdgeWrapping),\n/* harmony export */   \"Clock\": () => (/* binding */ Clock),\n/* harmony export */   \"Color\": () => (/* binding */ Color),\n/* harmony export */   \"ColorKeyframeTrack\": () => (/* binding */ ColorKeyframeTrack),\n/* harmony export */   \"CompressedTexture\": () => (/* binding */ CompressedTexture),\n/* harmony export */   \"CompressedTextureLoader\": () => (/* binding */ CompressedTextureLoader),\n/* harmony export */   \"ConeBufferGeometry\": () => (/* binding */ ConeGeometry),\n/* harmony export */   \"ConeGeometry\": () => (/* binding */ ConeGeometry),\n/* harmony export */   \"CubeCamera\": () => (/* binding */ CubeCamera),\n/* harmony export */   \"CubeReflectionMapping\": () => (/* binding */ CubeReflectionMapping),\n/* harmony export */   \"CubeRefractionMapping\": () => (/* binding */ CubeRefractionMapping),\n/* harmony export */   \"CubeTexture\": () => (/* binding */ CubeTexture),\n/* harmony export */   \"CubeTextureLoader\": () => (/* binding */ CubeTextureLoader),\n/* harmony export */   \"CubeUVReflectionMapping\": () => (/* binding */ CubeUVReflectionMapping),\n/* harmony export */   \"CubeUVRefractionMapping\": () => (/* binding */ CubeUVRefractionMapping),\n/* harmony export */   \"CubicBezierCurve\": () => (/* binding */ CubicBezierCurve),\n/* harmony export */   \"CubicBezierCurve3\": () => (/* binding */ CubicBezierCurve3),\n/* harmony export */   \"CubicInterpolant\": () => (/* binding */ CubicInterpolant),\n/* harmony export */   \"CullFaceBack\": () => (/* binding */ CullFaceBack),\n/* harmony export */   \"CullFaceFront\": () => (/* binding */ CullFaceFront),\n/* harmony export */   \"CullFaceFrontBack\": () => (/* binding */ CullFaceFrontBack),\n/* harmony export */   \"CullFaceNone\": () => (/* binding */ CullFaceNone),\n/* harmony export */   \"Curve\": () => (/* binding */ Curve),\n/* harmony export */   \"CurvePath\": () => (/* binding */ CurvePath),\n/* harmony export */   \"CustomBlending\": () => (/* binding */ CustomBlending),\n/* harmony export */   \"CustomToneMapping\": () => (/* binding */ CustomToneMapping),\n/* harmony export */   \"CylinderBufferGeometry\": () => (/* binding */ CylinderGeometry),\n/* harmony export */   \"CylinderGeometry\": () => (/* binding */ CylinderGeometry),\n/* harmony export */   \"Cylindrical\": () => (/* binding */ Cylindrical),\n/* harmony export */   \"DataTexture\": () => (/* binding */ DataTexture),\n/* harmony export */   \"DataTexture2DArray\": () => (/* binding */ DataTexture2DArray),\n/* harmony export */   \"DataTexture3D\": () => (/* binding */ DataTexture3D),\n/* harmony export */   \"DataTextureLoader\": () => (/* binding */ DataTextureLoader),\n/* harmony export */   \"DataUtils\": () => (/* binding */ DataUtils),\n/* harmony export */   \"DecrementStencilOp\": () => (/* binding */ DecrementStencilOp),\n/* harmony export */   \"DecrementWrapStencilOp\": () => (/* binding */ DecrementWrapStencilOp),\n/* harmony export */   \"DefaultLoadingManager\": () => (/* binding */ DefaultLoadingManager),\n/* harmony export */   \"DepthFormat\": () => (/* binding */ DepthFormat),\n/* harmony export */   \"DepthStencilFormat\": () => (/* binding */ DepthStencilFormat),\n/* harmony export */   \"DepthTexture\": () => (/* binding */ DepthTexture),\n/* harmony export */   \"DirectionalLight\": () => (/* binding */ DirectionalLight),\n/* harmony export */   \"DirectionalLightHelper\": () => (/* binding */ DirectionalLightHelper),\n/* harmony export */   \"DiscreteInterpolant\": () => (/* binding */ DiscreteInterpolant),\n/* harmony export */   \"DodecahedronBufferGeometry\": () => (/* binding */ DodecahedronGeometry),\n/* harmony export */   \"DodecahedronGeometry\": () => (/* binding */ DodecahedronGeometry),\n/* harmony export */   \"DoubleSide\": () => (/* binding */ DoubleSide),\n/* harmony export */   \"DstAlphaFactor\": () => (/* binding */ DstAlphaFactor),\n/* harmony export */   \"DstColorFactor\": () => (/* binding */ DstColorFactor),\n/* harmony export */   \"DynamicBufferAttribute\": () => (/* binding */ DynamicBufferAttribute),\n/* harmony export */   \"DynamicCopyUsage\": () => (/* binding */ DynamicCopyUsage),\n/* harmony export */   \"DynamicDrawUsage\": () => (/* binding */ DynamicDrawUsage),\n/* harmony export */   \"DynamicReadUsage\": () => (/* binding */ DynamicReadUsage),\n/* harmony export */   \"EdgesGeometry\": () => (/* binding */ EdgesGeometry),\n/* harmony export */   \"EdgesHelper\": () => (/* binding */ EdgesHelper),\n/* harmony export */   \"EllipseCurve\": () => (/* binding */ EllipseCurve),\n/* harmony export */   \"EqualDepth\": () => (/* binding */ EqualDepth),\n/* harmony export */   \"EqualStencilFunc\": () => (/* binding */ EqualStencilFunc),\n/* harmony export */   \"EquirectangularReflectionMapping\": () => (/* binding */ EquirectangularReflectionMapping),\n/* harmony export */   \"EquirectangularRefractionMapping\": () => (/* binding */ EquirectangularRefractionMapping),\n/* harmony export */   \"Euler\": () => (/* binding */ Euler),\n/* harmony export */   \"EventDispatcher\": () => (/* binding */ EventDispatcher),\n/* harmony export */   \"ExtrudeBufferGeometry\": () => (/* binding */ ExtrudeGeometry),\n/* harmony export */   \"ExtrudeGeometry\": () => (/* binding */ ExtrudeGeometry),\n/* harmony export */   \"FaceColors\": () => (/* binding */ FaceColors),\n/* harmony export */   \"FileLoader\": () => (/* binding */ FileLoader),\n/* harmony export */   \"FlatShading\": () => (/* binding */ FlatShading),\n/* harmony export */   \"Float16BufferAttribute\": () => (/* binding */ Float16BufferAttribute),\n/* harmony export */   \"Float32Attribute\": () => (/* binding */ Float32Attribute),\n/* harmony export */   \"Float32BufferAttribute\": () => (/* binding */ Float32BufferAttribute),\n/* harmony export */   \"Float64Attribute\": () => (/* binding */ Float64Attribute),\n/* harmony export */   \"Float64BufferAttribute\": () => (/* binding */ Float64BufferAttribute),\n/* harmony export */   \"FloatType\": () => (/* binding */ FloatType),\n/* harmony export */   \"Fog\": () => (/* binding */ Fog),\n/* harmony export */   \"FogExp2\": () => (/* binding */ FogExp2),\n/* harmony export */   \"Font\": () => (/* binding */ Font),\n/* harmony export */   \"FontLoader\": () => (/* binding */ FontLoader),\n/* harmony export */   \"FrontSide\": () => (/* binding */ FrontSide),\n/* harmony export */   \"Frustum\": () => (/* binding */ Frustum),\n/* harmony export */   \"GLBufferAttribute\": () => (/* binding */ GLBufferAttribute),\n/* harmony export */   \"GLSL1\": () => (/* binding */ GLSL1),\n/* harmony export */   \"GLSL3\": () => (/* binding */ GLSL3),\n/* harmony export */   \"GammaEncoding\": () => (/* binding */ GammaEncoding),\n/* harmony export */   \"GreaterDepth\": () => (/* binding */ GreaterDepth),\n/* harmony export */   \"GreaterEqualDepth\": () => (/* binding */ GreaterEqualDepth),\n/* harmony export */   \"GreaterEqualStencilFunc\": () => (/* binding */ GreaterEqualStencilFunc),\n/* harmony export */   \"GreaterStencilFunc\": () => (/* binding */ GreaterStencilFunc),\n/* harmony export */   \"GridHelper\": () => (/* binding */ GridHelper),\n/* harmony export */   \"Group\": () => (/* binding */ Group),\n/* harmony export */   \"HalfFloatType\": () => (/* binding */ HalfFloatType),\n/* harmony export */   \"HemisphereLight\": () => (/* binding */ HemisphereLight),\n/* harmony export */   \"HemisphereLightHelper\": () => (/* binding */ HemisphereLightHelper),\n/* harmony export */   \"HemisphereLightProbe\": () => (/* binding */ HemisphereLightProbe),\n/* harmony export */   \"IcosahedronBufferGeometry\": () => (/* binding */ IcosahedronGeometry),\n/* harmony export */   \"IcosahedronGeometry\": () => (/* binding */ IcosahedronGeometry),\n/* harmony export */   \"ImageBitmapLoader\": () => (/* binding */ ImageBitmapLoader),\n/* harmony export */   \"ImageLoader\": () => (/* binding */ ImageLoader),\n/* harmony export */   \"ImageUtils\": () => (/* binding */ ImageUtils),\n/* harmony export */   \"ImmediateRenderObject\": () => (/* binding */ ImmediateRenderObject),\n/* harmony export */   \"IncrementStencilOp\": () => (/* binding */ IncrementStencilOp),\n/* harmony export */   \"IncrementWrapStencilOp\": () => (/* binding */ IncrementWrapStencilOp),\n/* harmony export */   \"InstancedBufferAttribute\": () => (/* binding */ InstancedBufferAttribute),\n/* harmony export */   \"InstancedBufferGeometry\": () => (/* binding */ InstancedBufferGeometry),\n/* harmony export */   \"InstancedInterleavedBuffer\": () => (/* binding */ InstancedInterleavedBuffer),\n/* harmony export */   \"InstancedMesh\": () => (/* binding */ InstancedMesh),\n/* harmony export */   \"Int16Attribute\": () => (/* binding */ Int16Attribute),\n/* harmony export */   \"Int16BufferAttribute\": () => (/* binding */ Int16BufferAttribute),\n/* harmony export */   \"Int32Attribute\": () => (/* binding */ Int32Attribute),\n/* harmony export */   \"Int32BufferAttribute\": () => (/* binding */ Int32BufferAttribute),\n/* harmony export */   \"Int8Attribute\": () => (/* binding */ Int8Attribute),\n/* harmony export */   \"Int8BufferAttribute\": () => (/* binding */ Int8BufferAttribute),\n/* harmony export */   \"IntType\": () => (/* binding */ IntType),\n/* harmony export */   \"InterleavedBuffer\": () => (/* binding */ InterleavedBuffer),\n/* harmony export */   \"InterleavedBufferAttribute\": () => (/* binding */ InterleavedBufferAttribute),\n/* harmony export */   \"Interpolant\": () => (/* binding */ Interpolant),\n/* harmony export */   \"InterpolateDiscrete\": () => (/* binding */ InterpolateDiscrete),\n/* harmony export */   \"InterpolateLinear\": () => (/* binding */ InterpolateLinear),\n/* harmony export */   \"InterpolateSmooth\": () => (/* binding */ InterpolateSmooth),\n/* harmony export */   \"InvertStencilOp\": () => (/* binding */ InvertStencilOp),\n/* harmony export */   \"JSONLoader\": () => (/* binding */ JSONLoader),\n/* harmony export */   \"KeepStencilOp\": () => (/* binding */ KeepStencilOp),\n/* harmony export */   \"KeyframeTrack\": () => (/* binding */ KeyframeTrack),\n/* harmony export */   \"LOD\": () => (/* binding */ LOD),\n/* harmony export */   \"LatheBufferGeometry\": () => (/* binding */ LatheGeometry),\n/* harmony export */   \"LatheGeometry\": () => (/* binding */ LatheGeometry),\n/* harmony export */   \"Layers\": () => (/* binding */ Layers),\n/* harmony export */   \"LensFlare\": () => (/* binding */ LensFlare),\n/* harmony export */   \"LessDepth\": () => (/* binding */ LessDepth),\n/* harmony export */   \"LessEqualDepth\": () => (/* binding */ LessEqualDepth),\n/* harmony export */   \"LessEqualStencilFunc\": () => (/* binding */ LessEqualStencilFunc),\n/* harmony export */   \"LessStencilFunc\": () => (/* binding */ LessStencilFunc),\n/* harmony export */   \"Light\": () => (/* binding */ Light),\n/* harmony export */   \"LightProbe\": () => (/* binding */ LightProbe),\n/* harmony export */   \"Line\": () => (/* binding */ Line),\n/* harmony export */   \"Line3\": () => (/* binding */ Line3),\n/* harmony export */   \"LineBasicMaterial\": () => (/* binding */ LineBasicMaterial),\n/* harmony export */   \"LineCurve\": () => (/* binding */ LineCurve),\n/* harmony export */   \"LineCurve3\": () => (/* binding */ LineCurve3),\n/* harmony export */   \"LineDashedMaterial\": () => (/* binding */ LineDashedMaterial),\n/* harmony export */   \"LineLoop\": () => (/* binding */ LineLoop),\n/* harmony export */   \"LinePieces\": () => (/* binding */ LinePieces),\n/* harmony export */   \"LineSegments\": () => (/* binding */ LineSegments),\n/* harmony export */   \"LineStrip\": () => (/* binding */ LineStrip),\n/* harmony export */   \"LinearEncoding\": () => (/* binding */ LinearEncoding),\n/* harmony export */   \"LinearFilter\": () => (/* binding */ LinearFilter),\n/* harmony export */   \"LinearInterpolant\": () => (/* binding */ LinearInterpolant),\n/* harmony export */   \"LinearMipMapLinearFilter\": () => (/* binding */ LinearMipMapLinearFilter),\n/* harmony export */   \"LinearMipMapNearestFilter\": () => (/* binding */ LinearMipMapNearestFilter),\n/* harmony export */   \"LinearMipmapLinearFilter\": () => (/* binding */ LinearMipmapLinearFilter),\n/* harmony export */   \"LinearMipmapNearestFilter\": () => (/* binding */ LinearMipmapNearestFilter),\n/* harmony export */   \"LinearToneMapping\": () => (/* binding */ LinearToneMapping),\n/* harmony export */   \"Loader\": () => (/* binding */ Loader),\n/* harmony export */   \"LoaderUtils\": () => (/* binding */ LoaderUtils),\n/* harmony export */   \"LoadingManager\": () => (/* binding */ LoadingManager),\n/* harmony export */   \"LogLuvEncoding\": () => (/* binding */ LogLuvEncoding),\n/* harmony export */   \"LoopOnce\": () => (/* binding */ LoopOnce),\n/* harmony export */   \"LoopPingPong\": () => (/* binding */ LoopPingPong),\n/* harmony export */   \"LoopRepeat\": () => (/* binding */ LoopRepeat),\n/* harmony export */   \"LuminanceAlphaFormat\": () => (/* binding */ LuminanceAlphaFormat),\n/* harmony export */   \"LuminanceFormat\": () => (/* binding */ LuminanceFormat),\n/* harmony export */   \"MOUSE\": () => (/* binding */ MOUSE),\n/* harmony export */   \"Material\": () => (/* binding */ Material),\n/* harmony export */   \"MaterialLoader\": () => (/* binding */ MaterialLoader),\n/* harmony export */   \"Math\": () => (/* binding */ MathUtils),\n/* harmony export */   \"MathUtils\": () => (/* binding */ MathUtils),\n/* harmony export */   \"Matrix3\": () => (/* binding */ Matrix3),\n/* harmony export */   \"Matrix4\": () => (/* binding */ Matrix4),\n/* harmony export */   \"MaxEquation\": () => (/* binding */ MaxEquation),\n/* harmony export */   \"Mesh\": () => (/* binding */ Mesh),\n/* harmony export */   \"MeshBasicMaterial\": () => (/* binding */ MeshBasicMaterial),\n/* harmony export */   \"MeshDepthMaterial\": () => (/* binding */ MeshDepthMaterial),\n/* harmony export */   \"MeshDistanceMaterial\": () => (/* binding */ MeshDistanceMaterial),\n/* harmony export */   \"MeshFaceMaterial\": () => (/* binding */ MeshFaceMaterial),\n/* harmony export */   \"MeshLambertMaterial\": () => (/* binding */ MeshLambertMaterial),\n/* harmony export */   \"MeshMatcapMaterial\": () => (/* binding */ MeshMatcapMaterial),\n/* harmony export */   \"MeshNormalMaterial\": () => (/* binding */ MeshNormalMaterial),\n/* harmony export */   \"MeshPhongMaterial\": () => (/* binding */ MeshPhongMaterial),\n/* harmony export */   \"MeshPhysicalMaterial\": () => (/* binding */ MeshPhysicalMaterial),\n/* harmony export */   \"MeshStandardMaterial\": () => (/* binding */ MeshStandardMaterial),\n/* harmony export */   \"MeshToonMaterial\": () => (/* binding */ MeshToonMaterial),\n/* harmony export */   \"MinEquation\": () => (/* binding */ MinEquation),\n/* harmony export */   \"MirroredRepeatWrapping\": () => (/* binding */ MirroredRepeatWrapping),\n/* harmony export */   \"MixOperation\": () => (/* binding */ MixOperation),\n/* harmony export */   \"MultiMaterial\": () => (/* binding */ MultiMaterial),\n/* harmony export */   \"MultiplyBlending\": () => (/* binding */ MultiplyBlending),\n/* harmony export */   \"MultiplyOperation\": () => (/* binding */ MultiplyOperation),\n/* harmony export */   \"NearestFilter\": () => (/* binding */ NearestFilter),\n/* harmony export */   \"NearestMipMapLinearFilter\": () => (/* binding */ NearestMipMapLinearFilter),\n/* harmony export */   \"NearestMipMapNearestFilter\": () => (/* binding */ NearestMipMapNearestFilter),\n/* harmony export */   \"NearestMipmapLinearFilter\": () => (/* binding */ NearestMipmapLinearFilter),\n/* harmony export */   \"NearestMipmapNearestFilter\": () => (/* binding */ NearestMipmapNearestFilter),\n/* harmony export */   \"NeverDepth\": () => (/* binding */ NeverDepth),\n/* harmony export */   \"NeverStencilFunc\": () => (/* binding */ NeverStencilFunc),\n/* harmony export */   \"NoBlending\": () => (/* binding */ NoBlending),\n/* harmony export */   \"NoColors\": () => (/* binding */ NoColors),\n/* harmony export */   \"NoToneMapping\": () => (/* binding */ NoToneMapping),\n/* harmony export */   \"NormalAnimationBlendMode\": () => (/* binding */ NormalAnimationBlendMode),\n/* harmony export */   \"NormalBlending\": () => (/* binding */ NormalBlending),\n/* harmony export */   \"NotEqualDepth\": () => (/* binding */ NotEqualDepth),\n/* harmony export */   \"NotEqualStencilFunc\": () => (/* binding */ NotEqualStencilFunc),\n/* harmony export */   \"NumberKeyframeTrack\": () => (/* binding */ NumberKeyframeTrack),\n/* harmony export */   \"Object3D\": () => (/* binding */ Object3D),\n/* harmony export */   \"ObjectLoader\": () => (/* binding */ ObjectLoader),\n/* harmony export */   \"ObjectSpaceNormalMap\": () => (/* binding */ ObjectSpaceNormalMap),\n/* harmony export */   \"OctahedronBufferGeometry\": () => (/* binding */ OctahedronGeometry),\n/* harmony export */   \"OctahedronGeometry\": () => (/* binding */ OctahedronGeometry),\n/* harmony export */   \"OneFactor\": () => (/* binding */ OneFactor),\n/* harmony export */   \"OneMinusDstAlphaFactor\": () => (/* binding */ OneMinusDstAlphaFactor),\n/* harmony export */   \"OneMinusDstColorFactor\": () => (/* binding */ OneMinusDstColorFactor),\n/* harmony export */   \"OneMinusSrcAlphaFactor\": () => (/* binding */ OneMinusSrcAlphaFactor),\n/* harmony export */   \"OneMinusSrcColorFactor\": () => (/* binding */ OneMinusSrcColorFactor),\n/* harmony export */   \"OrthographicCamera\": () => (/* binding */ OrthographicCamera),\n/* harmony export */   \"PCFShadowMap\": () => (/* binding */ PCFShadowMap),\n/* harmony export */   \"PCFSoftShadowMap\": () => (/* binding */ PCFSoftShadowMap),\n/* harmony export */   \"PMREMGenerator\": () => (/* binding */ PMREMGenerator),\n/* harmony export */   \"ParametricBufferGeometry\": () => (/* binding */ ParametricGeometry),\n/* harmony export */   \"ParametricGeometry\": () => (/* binding */ ParametricGeometry),\n/* harmony export */   \"Particle\": () => (/* binding */ Particle),\n/* harmony export */   \"ParticleBasicMaterial\": () => (/* binding */ ParticleBasicMaterial),\n/* harmony export */   \"ParticleSystem\": () => (/* binding */ ParticleSystem),\n/* harmony export */   \"ParticleSystemMaterial\": () => (/* binding */ ParticleSystemMaterial),\n/* harmony export */   \"Path\": () => (/* binding */ Path),\n/* harmony export */   \"PerspectiveCamera\": () => (/* binding */ PerspectiveCamera),\n/* harmony export */   \"Plane\": () => (/* binding */ Plane),\n/* harmony export */   \"PlaneBufferGeometry\": () => (/* binding */ PlaneGeometry),\n/* harmony export */   \"PlaneGeometry\": () => (/* binding */ PlaneGeometry),\n/* harmony export */   \"PlaneHelper\": () => (/* binding */ PlaneHelper),\n/* harmony export */   \"PointCloud\": () => (/* binding */ PointCloud),\n/* harmony export */   \"PointCloudMaterial\": () => (/* binding */ PointCloudMaterial),\n/* harmony export */   \"PointLight\": () => (/* binding */ PointLight),\n/* harmony export */   \"PointLightHelper\": () => (/* binding */ PointLightHelper),\n/* harmony export */   \"Points\": () => (/* binding */ Points),\n/* harmony export */   \"PointsMaterial\": () => (/* binding */ PointsMaterial),\n/* harmony export */   \"PolarGridHelper\": () => (/* binding */ PolarGridHelper),\n/* harmony export */   \"PolyhedronBufferGeometry\": () => (/* binding */ PolyhedronGeometry),\n/* harmony export */   \"PolyhedronGeometry\": () => (/* binding */ PolyhedronGeometry),\n/* harmony export */   \"PositionalAudio\": () => (/* binding */ PositionalAudio),\n/* harmony export */   \"PropertyBinding\": () => (/* binding */ PropertyBinding),\n/* harmony export */   \"PropertyMixer\": () => (/* binding */ PropertyMixer),\n/* harmony export */   \"QuadraticBezierCurve\": () => (/* binding */ QuadraticBezierCurve),\n/* harmony export */   \"QuadraticBezierCurve3\": () => (/* binding */ QuadraticBezierCurve3),\n/* harmony export */   \"Quaternion\": () => (/* binding */ Quaternion),\n/* harmony export */   \"QuaternionKeyframeTrack\": () => (/* binding */ QuaternionKeyframeTrack),\n/* harmony export */   \"QuaternionLinearInterpolant\": () => (/* binding */ QuaternionLinearInterpolant),\n/* harmony export */   \"REVISION\": () => (/* binding */ REVISION),\n/* harmony export */   \"RGBADepthPacking\": () => (/* binding */ RGBADepthPacking),\n/* harmony export */   \"RGBAFormat\": () => (/* binding */ RGBAFormat),\n/* harmony export */   \"RGBAIntegerFormat\": () => (/* binding */ RGBAIntegerFormat),\n/* harmony export */   \"RGBA_ASTC_10x10_Format\": () => (/* binding */ RGBA_ASTC_10x10_Format),\n/* harmony export */   \"RGBA_ASTC_10x5_Format\": () => (/* binding */ RGBA_ASTC_10x5_Format),\n/* harmony export */   \"RGBA_ASTC_10x6_Format\": () => (/* binding */ RGBA_ASTC_10x6_Format),\n/* harmony export */   \"RGBA_ASTC_10x8_Format\": () => (/* binding */ RGBA_ASTC_10x8_Format),\n/* harmony export */   \"RGBA_ASTC_12x10_Format\": () => (/* binding */ RGBA_ASTC_12x10_Format),\n/* harmony export */   \"RGBA_ASTC_12x12_Format\": () => (/* binding */ RGBA_ASTC_12x12_Format),\n/* harmony export */   \"RGBA_ASTC_4x4_Format\": () => (/* binding */ RGBA_ASTC_4x4_Format),\n/* harmony export */   \"RGBA_ASTC_5x4_Format\": () => (/* binding */ RGBA_ASTC_5x4_Format),\n/* harmony export */   \"RGBA_ASTC_5x5_Format\": () => (/* binding */ RGBA_ASTC_5x5_Format),\n/* harmony export */   \"RGBA_ASTC_6x5_Format\": () => (/* binding */ RGBA_ASTC_6x5_Format),\n/* harmony export */   \"RGBA_ASTC_6x6_Format\": () => (/* binding */ RGBA_ASTC_6x6_Format),\n/* harmony export */   \"RGBA_ASTC_8x5_Format\": () => (/* binding */ RGBA_ASTC_8x5_Format),\n/* harmony export */   \"RGBA_ASTC_8x6_Format\": () => (/* binding */ RGBA_ASTC_8x6_Format),\n/* harmony export */   \"RGBA_ASTC_8x8_Format\": () => (/* binding */ RGBA_ASTC_8x8_Format),\n/* harmony export */   \"RGBA_BPTC_Format\": () => (/* binding */ RGBA_BPTC_Format),\n/* harmony export */   \"RGBA_ETC2_EAC_Format\": () => (/* binding */ RGBA_ETC2_EAC_Format),\n/* harmony export */   \"RGBA_PVRTC_2BPPV1_Format\": () => (/* binding */ RGBA_PVRTC_2BPPV1_Format),\n/* harmony export */   \"RGBA_PVRTC_4BPPV1_Format\": () => (/* binding */ RGBA_PVRTC_4BPPV1_Format),\n/* harmony export */   \"RGBA_S3TC_DXT1_Format\": () => (/* binding */ RGBA_S3TC_DXT1_Format),\n/* harmony export */   \"RGBA_S3TC_DXT3_Format\": () => (/* binding */ RGBA_S3TC_DXT3_Format),\n/* harmony export */   \"RGBA_S3TC_DXT5_Format\": () => (/* binding */ RGBA_S3TC_DXT5_Format),\n/* harmony export */   \"RGBDEncoding\": () => (/* binding */ RGBDEncoding),\n/* harmony export */   \"RGBEEncoding\": () => (/* binding */ RGBEEncoding),\n/* harmony export */   \"RGBEFormat\": () => (/* binding */ RGBEFormat),\n/* harmony export */   \"RGBFormat\": () => (/* binding */ RGBFormat),\n/* harmony export */   \"RGBIntegerFormat\": () => (/* binding */ RGBIntegerFormat),\n/* harmony export */   \"RGBM16Encoding\": () => (/* binding */ RGBM16Encoding),\n/* harmony export */   \"RGBM7Encoding\": () => (/* binding */ RGBM7Encoding),\n/* harmony export */   \"RGB_ETC1_Format\": () => (/* binding */ RGB_ETC1_Format),\n/* harmony export */   \"RGB_ETC2_Format\": () => (/* binding */ RGB_ETC2_Format),\n/* harmony export */   \"RGB_PVRTC_2BPPV1_Format\": () => (/* binding */ RGB_PVRTC_2BPPV1_Format),\n/* harmony export */   \"RGB_PVRTC_4BPPV1_Format\": () => (/* binding */ RGB_PVRTC_4BPPV1_Format),\n/* harmony export */   \"RGB_S3TC_DXT1_Format\": () => (/* binding */ RGB_S3TC_DXT1_Format),\n/* harmony export */   \"RGFormat\": () => (/* binding */ RGFormat),\n/* harmony export */   \"RGIntegerFormat\": () => (/* binding */ RGIntegerFormat),\n/* harmony export */   \"RawShaderMaterial\": () => (/* binding */ RawShaderMaterial),\n/* harmony export */   \"Ray\": () => (/* binding */ Ray),\n/* harmony export */   \"Raycaster\": () => (/* binding */ Raycaster),\n/* harmony export */   \"RectAreaLight\": () => (/* binding */ RectAreaLight),\n/* harmony export */   \"RedFormat\": () => (/* binding */ RedFormat),\n/* harmony export */   \"RedIntegerFormat\": () => (/* binding */ RedIntegerFormat),\n/* harmony export */   \"ReinhardToneMapping\": () => (/* binding */ ReinhardToneMapping),\n/* harmony export */   \"RepeatWrapping\": () => (/* binding */ RepeatWrapping),\n/* harmony export */   \"ReplaceStencilOp\": () => (/* binding */ ReplaceStencilOp),\n/* harmony export */   \"ReverseSubtractEquation\": () => (/* binding */ ReverseSubtractEquation),\n/* harmony export */   \"RingBufferGeometry\": () => (/* binding */ RingGeometry),\n/* harmony export */   \"RingGeometry\": () => (/* binding */ RingGeometry),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_10x10_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_10x10_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_10x5_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_10x5_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_10x6_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_10x6_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_10x8_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_10x8_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_12x10_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_12x10_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_12x12_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_12x12_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_4x4_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_4x4_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_5x4_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_5x4_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_5x5_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_5x5_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_6x5_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_6x5_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_6x6_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_6x6_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_8x5_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_8x5_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_8x6_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_8x6_Format),\n/* harmony export */   \"SRGB8_ALPHA8_ASTC_8x8_Format\": () => (/* binding */ SRGB8_ALPHA8_ASTC_8x8_Format),\n/* harmony export */   \"Scene\": () => (/* binding */ Scene),\n/* harmony export */   \"SceneUtils\": () => (/* binding */ SceneUtils),\n/* harmony export */   \"ShaderChunk\": () => (/* binding */ ShaderChunk),\n/* harmony export */   \"ShaderLib\": () => (/* binding */ ShaderLib),\n/* harmony export */   \"ShaderMaterial\": () => (/* binding */ ShaderMaterial),\n/* harmony export */   \"ShadowMaterial\": () => (/* binding */ ShadowMaterial),\n/* harmony export */   \"Shape\": () => (/* binding */ Shape),\n/* harmony export */   \"ShapeBufferGeometry\": () => (/* binding */ ShapeGeometry),\n/* harmony export */   \"ShapeGeometry\": () => (/* binding */ ShapeGeometry),\n/* harmony export */   \"ShapePath\": () => (/* binding */ ShapePath),\n/* harmony export */   \"ShapeUtils\": () => (/* binding */ ShapeUtils),\n/* harmony export */   \"ShortType\": () => (/* binding */ ShortType),\n/* harmony export */   \"Skeleton\": () => (/* binding */ Skeleton),\n/* harmony export */   \"SkeletonHelper\": () => (/* binding */ SkeletonHelper),\n/* harmony export */   \"SkinnedMesh\": () => (/* binding */ SkinnedMesh),\n/* harmony export */   \"SmoothShading\": () => (/* binding */ SmoothShading),\n/* harmony export */   \"Sphere\": () => (/* binding */ Sphere),\n/* harmony export */   \"SphereBufferGeometry\": () => (/* binding */ SphereGeometry),\n/* harmony export */   \"SphereGeometry\": () => (/* binding */ SphereGeometry),\n/* harmony export */   \"Spherical\": () => (/* binding */ Spherical),\n/* harmony export */   \"SphericalHarmonics3\": () => (/* binding */ SphericalHarmonics3),\n/* harmony export */   \"SplineCurve\": () => (/* binding */ SplineCurve),\n/* harmony export */   \"SpotLight\": () => (/* binding */ SpotLight),\n/* harmony export */   \"SpotLightHelper\": () => (/* binding */ SpotLightHelper),\n/* harmony export */   \"Sprite\": () => (/* binding */ Sprite),\n/* harmony export */   \"SpriteMaterial\": () => (/* binding */ SpriteMaterial),\n/* harmony export */   \"SrcAlphaFactor\": () => (/* binding */ SrcAlphaFactor),\n/* harmony export */   \"SrcAlphaSaturateFactor\": () => (/* binding */ SrcAlphaSaturateFactor),\n/* harmony export */   \"SrcColorFactor\": () => (/* binding */ SrcColorFactor),\n/* harmony export */   \"StaticCopyUsage\": () => (/* binding */ StaticCopyUsage),\n/* harmony export */   \"StaticDrawUsage\": () => (/* binding */ StaticDrawUsage),\n/* harmony export */   \"StaticReadUsage\": () => (/* binding */ StaticReadUsage),\n/* harmony export */   \"StereoCamera\": () => (/* binding */ StereoCamera),\n/* harmony export */   \"StreamCopyUsage\": () => (/* binding */ StreamCopyUsage),\n/* harmony export */   \"StreamDrawUsage\": () => (/* binding */ StreamDrawUsage),\n/* harmony export */   \"StreamReadUsage\": () => (/* binding */ StreamReadUsage),\n/* harmony export */   \"StringKeyframeTrack\": () => (/* binding */ StringKeyframeTrack),\n/* harmony export */   \"SubtractEquation\": () => (/* binding */ SubtractEquation),\n/* harmony export */   \"SubtractiveBlending\": () => (/* binding */ SubtractiveBlending),\n/* harmony export */   \"TOUCH\": () => (/* binding */ TOUCH),\n/* harmony export */   \"TangentSpaceNormalMap\": () => (/* binding */ TangentSpaceNormalMap),\n/* harmony export */   \"TetrahedronBufferGeometry\": () => (/* binding */ TetrahedronGeometry),\n/* harmony export */   \"TetrahedronGeometry\": () => (/* binding */ TetrahedronGeometry),\n/* harmony export */   \"TextBufferGeometry\": () => (/* binding */ TextGeometry),\n/* harmony export */   \"TextGeometry\": () => (/* binding */ TextGeometry),\n/* harmony export */   \"Texture\": () => (/* binding */ Texture),\n/* harmony export */   \"TextureLoader\": () => (/* binding */ TextureLoader),\n/* harmony export */   \"TorusBufferGeometry\": () => (/* binding */ TorusGeometry),\n/* harmony export */   \"TorusGeometry\": () => (/* binding */ TorusGeometry),\n/* harmony export */   \"TorusKnotBufferGeometry\": () => (/* binding */ TorusKnotGeometry),\n/* harmony export */   \"TorusKnotGeometry\": () => (/* binding */ TorusKnotGeometry),\n/* harmony export */   \"Triangle\": () => (/* binding */ Triangle),\n/* harmony export */   \"TriangleFanDrawMode\": () => (/* binding */ TriangleFanDrawMode),\n/* harmony export */   \"TriangleStripDrawMode\": () => (/* binding */ TriangleStripDrawMode),\n/* harmony export */   \"TrianglesDrawMode\": () => (/* binding */ TrianglesDrawMode),\n/* harmony export */   \"TubeBufferGeometry\": () => (/* binding */ TubeGeometry),\n/* harmony export */   \"TubeGeometry\": () => (/* binding */ TubeGeometry),\n/* harmony export */   \"UVMapping\": () => (/* binding */ UVMapping),\n/* harmony export */   \"Uint16Attribute\": () => (/* binding */ Uint16Attribute),\n/* harmony export */   \"Uint16BufferAttribute\": () => (/* binding */ Uint16BufferAttribute),\n/* harmony export */   \"Uint32Attribute\": () => (/* binding */ Uint32Attribute),\n/* harmony export */   \"Uint32BufferAttribute\": () => (/* binding */ Uint32BufferAttribute),\n/* harmony export */   \"Uint8Attribute\": () => (/* binding */ Uint8Attribute),\n/* harmony export */   \"Uint8BufferAttribute\": () => (/* binding */ Uint8BufferAttribute),\n/* harmony export */   \"Uint8ClampedAttribute\": () => (/* binding */ Uint8ClampedAttribute),\n/* harmony export */   \"Uint8ClampedBufferAttribute\": () => (/* binding */ Uint8ClampedBufferAttribute),\n/* harmony export */   \"Uniform\": () => (/* binding */ Uniform),\n/* harmony export */   \"UniformsLib\": () => (/* binding */ UniformsLib),\n/* harmony export */   \"UniformsUtils\": () => (/* binding */ UniformsUtils),\n/* harmony export */   \"UnsignedByteType\": () => (/* binding */ UnsignedByteType),\n/* harmony export */   \"UnsignedInt248Type\": () => (/* binding */ UnsignedInt248Type),\n/* harmony export */   \"UnsignedIntType\": () => (/* binding */ UnsignedIntType),\n/* harmony export */   \"UnsignedShort4444Type\": () => (/* binding */ UnsignedShort4444Type),\n/* harmony export */   \"UnsignedShort5551Type\": () => (/* binding */ UnsignedShort5551Type),\n/* harmony export */   \"UnsignedShort565Type\": () => (/* binding */ UnsignedShort565Type),\n/* harmony export */   \"UnsignedShortType\": () => (/* binding */ UnsignedShortType),\n/* harmony export */   \"VSMShadowMap\": () => (/* binding */ VSMShadowMap),\n/* harmony export */   \"Vector2\": () => (/* binding */ Vector2),\n/* harmony export */   \"Vector3\": () => (/* binding */ Vector3),\n/* harmony export */   \"Vector4\": () => (/* binding */ Vector4),\n/* harmony export */   \"VectorKeyframeTrack\": () => (/* binding */ VectorKeyframeTrack),\n/* harmony export */   \"Vertex\": () => (/* binding */ Vertex),\n/* harmony export */   \"VertexColors\": () => (/* binding */ VertexColors),\n/* harmony export */   \"VideoTexture\": () => (/* binding */ VideoTexture),\n/* harmony export */   \"WebGL1Renderer\": () => (/* binding */ WebGL1Renderer),\n/* harmony export */   \"WebGLCubeRenderTarget\": () => (/* binding */ WebGLCubeRenderTarget),\n/* harmony export */   \"WebGLMultipleRenderTargets\": () => (/* binding */ WebGLMultipleRenderTargets),\n/* harmony export */   \"WebGLMultisampleRenderTarget\": () => (/* binding */ WebGLMultisampleRenderTarget),\n/* harmony export */   \"WebGLRenderTarget\": () => (/* binding */ WebGLRenderTarget),\n/* harmony export */   \"WebGLRenderTargetCube\": () => (/* binding */ WebGLRenderTargetCube),\n/* harmony export */   \"WebGLRenderer\": () => (/* binding */ WebGLRenderer),\n/* harmony export */   \"WebGLUtils\": () => (/* binding */ WebGLUtils),\n/* harmony export */   \"WireframeGeometry\": () => (/* binding */ WireframeGeometry),\n/* harmony export */   \"WireframeHelper\": () => (/* binding */ WireframeHelper),\n/* harmony export */   \"WrapAroundEnding\": () => (/* binding */ WrapAroundEnding),\n/* harmony export */   \"XHRLoader\": () => (/* binding */ XHRLoader),\n/* harmony export */   \"ZeroCurvatureEnding\": () => (/* binding */ ZeroCurvatureEnding),\n/* harmony export */   \"ZeroFactor\": () => (/* binding */ ZeroFactor),\n/* harmony export */   \"ZeroSlopeEnding\": () => (/* binding */ ZeroSlopeEnding),\n/* harmony export */   \"ZeroStencilOp\": () => (/* binding */ ZeroStencilOp),\n/* harmony export */   \"sRGBEncoding\": () => (/* binding */ sRGBEncoding)\n/* harmony export */ });\n/**\n * @license\n * Copyright 2010-2021 Three.js Authors\n * SPDX-License-Identifier: MIT\n */\nconst REVISION = '129';\nconst MOUSE = { LEFT: 0, MIDDLE: 1, RIGHT: 2, ROTATE: 0, DOLLY: 1, PAN: 2 };\nconst TOUCH = { ROTATE: 0, PAN: 1, DOLLY_PAN: 2, DOLLY_ROTATE: 3 };\nconst CullFaceNone = 0;\nconst CullFaceBack = 1;\nconst CullFaceFront = 2;\nconst CullFaceFrontBack = 3;\nconst BasicShadowMap = 0;\nconst PCFShadowMap = 1;\nconst PCFSoftShadowMap = 2;\nconst VSMShadowMap = 3;\nconst FrontSide = 0;\nconst BackSide = 1;\nconst DoubleSide = 2;\nconst FlatShading = 1;\nconst SmoothShading = 2;\nconst NoBlending = 0;\nconst NormalBlending = 1;\nconst AdditiveBlending = 2;\nconst SubtractiveBlending = 3;\nconst MultiplyBlending = 4;\nconst CustomBlending = 5;\nconst AddEquation = 100;\nconst SubtractEquation = 101;\nconst ReverseSubtractEquation = 102;\nconst MinEquation = 103;\nconst MaxEquation = 104;\nconst ZeroFactor = 200;\nconst OneFactor = 201;\nconst SrcColorFactor = 202;\nconst OneMinusSrcColorFactor = 203;\nconst SrcAlphaFactor = 204;\nconst OneMinusSrcAlphaFactor = 205;\nconst DstAlphaFactor = 206;\nconst OneMinusDstAlphaFactor = 207;\nconst DstColorFactor = 208;\nconst OneMinusDstColorFactor = 209;\nconst SrcAlphaSaturateFactor = 210;\nconst NeverDepth = 0;\nconst AlwaysDepth = 1;\nconst LessDepth = 2;\nconst LessEqualDepth = 3;\nconst EqualDepth = 4;\nconst GreaterEqualDepth = 5;\nconst GreaterDepth = 6;\nconst NotEqualDepth = 7;\nconst MultiplyOperation = 0;\nconst MixOperation = 1;\nconst AddOperation = 2;\nconst NoToneMapping = 0;\nconst LinearToneMapping = 1;\nconst ReinhardToneMapping = 2;\nconst CineonToneMapping = 3;\nconst ACESFilmicToneMapping = 4;\nconst CustomToneMapping = 5;\n\nconst UVMapping = 300;\nconst CubeReflectionMapping = 301;\nconst CubeRefractionMapping = 302;\nconst EquirectangularReflectionMapping = 303;\nconst EquirectangularRefractionMapping = 304;\nconst CubeUVReflectionMapping = 306;\nconst CubeUVRefractionMapping = 307;\nconst RepeatWrapping = 1000;\nconst ClampToEdgeWrapping = 1001;\nconst MirroredRepeatWrapping = 1002;\nconst NearestFilter = 1003;\nconst NearestMipmapNearestFilter = 1004;\nconst NearestMipMapNearestFilter = 1004;\nconst NearestMipmapLinearFilter = 1005;\nconst NearestMipMapLinearFilter = 1005;\nconst LinearFilter = 1006;\nconst LinearMipmapNearestFilter = 1007;\nconst LinearMipMapNearestFilter = 1007;\nconst LinearMipmapLinearFilter = 1008;\nconst LinearMipMapLinearFilter = 1008;\nconst UnsignedByteType = 1009;\nconst ByteType = 1010;\nconst ShortType = 1011;\nconst UnsignedShortType = 1012;\nconst IntType = 1013;\nconst UnsignedIntType = 1014;\nconst FloatType = 1015;\nconst HalfFloatType = 1016;\nconst UnsignedShort4444Type = 1017;\nconst UnsignedShort5551Type = 1018;\nconst UnsignedShort565Type = 1019;\nconst UnsignedInt248Type = 1020;\nconst AlphaFormat = 1021;\nconst RGBFormat = 1022;\nconst RGBAFormat = 1023;\nconst LuminanceFormat = 1024;\nconst LuminanceAlphaFormat = 1025;\nconst RGBEFormat = RGBAFormat;\nconst DepthFormat = 1026;\nconst DepthStencilFormat = 1027;\nconst RedFormat = 1028;\nconst RedIntegerFormat = 1029;\nconst RGFormat = 1030;\nconst RGIntegerFormat = 1031;\nconst RGBIntegerFormat = 1032;\nconst RGBAIntegerFormat = 1033;\n\nconst RGB_S3TC_DXT1_Format = 33776;\nconst RGBA_S3TC_DXT1_Format = 33777;\nconst RGBA_S3TC_DXT3_Format = 33778;\nconst RGBA_S3TC_DXT5_Format = 33779;\nconst RGB_PVRTC_4BPPV1_Format = 35840;\nconst RGB_PVRTC_2BPPV1_Format = 35841;\nconst RGBA_PVRTC_4BPPV1_Format = 35842;\nconst RGBA_PVRTC_2BPPV1_Format = 35843;\nconst RGB_ETC1_Format = 36196;\nconst RGB_ETC2_Format = 37492;\nconst RGBA_ETC2_EAC_Format = 37496;\nconst RGBA_ASTC_4x4_Format = 37808;\nconst RGBA_ASTC_5x4_Format = 37809;\nconst RGBA_ASTC_5x5_Format = 37810;\nconst RGBA_ASTC_6x5_Format = 37811;\nconst RGBA_ASTC_6x6_Format = 37812;\nconst RGBA_ASTC_8x5_Format = 37813;\nconst RGBA_ASTC_8x6_Format = 37814;\nconst RGBA_ASTC_8x8_Format = 37815;\nconst RGBA_ASTC_10x5_Format = 37816;\nconst RGBA_ASTC_10x6_Format = 37817;\nconst RGBA_ASTC_10x8_Format = 37818;\nconst RGBA_ASTC_10x10_Format = 37819;\nconst RGBA_ASTC_12x10_Format = 37820;\nconst RGBA_ASTC_12x12_Format = 37821;\nconst RGBA_BPTC_Format = 36492;\nconst SRGB8_ALPHA8_ASTC_4x4_Format = 37840;\nconst SRGB8_ALPHA8_ASTC_5x4_Format = 37841;\nconst SRGB8_ALPHA8_ASTC_5x5_Format = 37842;\nconst SRGB8_ALPHA8_ASTC_6x5_Format = 37843;\nconst SRGB8_ALPHA8_ASTC_6x6_Format = 37844;\nconst SRGB8_ALPHA8_ASTC_8x5_Format = 37845;\nconst SRGB8_ALPHA8_ASTC_8x6_Format = 37846;\nconst SRGB8_ALPHA8_ASTC_8x8_Format = 37847;\nconst SRGB8_ALPHA8_ASTC_10x5_Format = 37848;\nconst SRGB8_ALPHA8_ASTC_10x6_Format = 37849;\nconst SRGB8_ALPHA8_ASTC_10x8_Format = 37850;\nconst SRGB8_ALPHA8_ASTC_10x10_Format = 37851;\nconst SRGB8_ALPHA8_ASTC_12x10_Format = 37852;\nconst SRGB8_ALPHA8_ASTC_12x12_Format = 37853;\nconst LoopOnce = 2200;\nconst LoopRepeat = 2201;\nconst LoopPingPong = 2202;\nconst InterpolateDiscrete = 2300;\nconst InterpolateLinear = 2301;\nconst InterpolateSmooth = 2302;\nconst ZeroCurvatureEnding = 2400;\nconst ZeroSlopeEnding = 2401;\nconst WrapAroundEnding = 2402;\nconst NormalAnimationBlendMode = 2500;\nconst AdditiveAnimationBlendMode = 2501;\nconst TrianglesDrawMode = 0;\nconst TriangleStripDrawMode = 1;\nconst TriangleFanDrawMode = 2;\nconst LinearEncoding = 3000;\nconst sRGBEncoding = 3001;\nconst GammaEncoding = 3007;\nconst RGBEEncoding = 3002;\nconst LogLuvEncoding = 3003;\nconst RGBM7Encoding = 3004;\nconst RGBM16Encoding = 3005;\nconst RGBDEncoding = 3006;\nconst BasicDepthPacking = 3200;\nconst RGBADepthPacking = 3201;\nconst TangentSpaceNormalMap = 0;\nconst ObjectSpaceNormalMap = 1;\n\nconst ZeroStencilOp = 0;\nconst KeepStencilOp = 7680;\nconst ReplaceStencilOp = 7681;\nconst IncrementStencilOp = 7682;\nconst DecrementStencilOp = 7683;\nconst IncrementWrapStencilOp = 34055;\nconst DecrementWrapStencilOp = 34056;\nconst InvertStencilOp = 5386;\n\nconst NeverStencilFunc = 512;\nconst LessStencilFunc = 513;\nconst EqualStencilFunc = 514;\nconst LessEqualStencilFunc = 515;\nconst GreaterStencilFunc = 516;\nconst NotEqualStencilFunc = 517;\nconst GreaterEqualStencilFunc = 518;\nconst AlwaysStencilFunc = 519;\n\nconst StaticDrawUsage = 35044;\nconst DynamicDrawUsage = 35048;\nconst StreamDrawUsage = 35040;\nconst StaticReadUsage = 35045;\nconst DynamicReadUsage = 35049;\nconst StreamReadUsage = 35041;\nconst StaticCopyUsage = 35046;\nconst DynamicCopyUsage = 35050;\nconst StreamCopyUsage = 35042;\n\nconst GLSL1 = '100';\nconst GLSL3 = '300 es';\n\n/**\n * https://github.com/mrdoob/eventdispatcher.js/\n */\n\nclass EventDispatcher {\n\n\taddEventListener( type, listener ) {\n\n\t\tif ( this._listeners === undefined ) this._listeners = {};\n\n\t\tconst listeners = this._listeners;\n\n\t\tif ( listeners[ type ] === undefined ) {\n\n\t\t\tlisteners[ type ] = [];\n\n\t\t}\n\n\t\tif ( listeners[ type ].indexOf( listener ) === - 1 ) {\n\n\t\t\tlisteners[ type ].push( listener );\n\n\t\t}\n\n\t}\n\n\thasEventListener( type, listener ) {\n\n\t\tif ( this._listeners === undefined ) return false;\n\n\t\tconst listeners = this._listeners;\n\n\t\treturn listeners[ type ] !== undefined && listeners[ type ].indexOf( listener ) !== - 1;\n\n\t}\n\n\tremoveEventListener( type, listener ) {\n\n\t\tif ( this._listeners === undefined ) return;\n\n\t\tconst listeners = this._listeners;\n\t\tconst listenerArray = listeners[ type ];\n\n\t\tif ( listenerArray !== undefined ) {\n\n\t\t\tconst index = listenerArray.indexOf( listener );\n\n\t\t\tif ( index !== - 1 ) {\n\n\t\t\t\tlistenerArray.splice( index, 1 );\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\tdispatchEvent( event ) {\n\n\t\tif ( this._listeners === undefined ) return;\n\n\t\tconst listeners = this._listeners;\n\t\tconst listenerArray = listeners[ event.type ];\n\n\t\tif ( listenerArray !== undefined ) {\n\n\t\t\tevent.target = this;\n\n\t\t\t// Make a copy, in case listeners are removed while iterating.\n\t\t\tconst array = listenerArray.slice( 0 );\n\n\t\t\tfor ( let i = 0, l = array.length; i < l; i ++ ) {\n\n\t\t\t\tarray[ i ].call( this, event );\n\n\t\t\t}\n\n\t\t\tevent.target = null;\n\n\t\t}\n\n\t}\n\n}\n\nconst _lut = [];\n\nfor ( let i = 0; i < 256; i ++ ) {\n\n\t_lut[ i ] = ( i < 16 ? '0' : '' ) + ( i ).toString( 16 );\n\n}\n\nlet _seed = 1234567;\n\n\nconst DEG2RAD = Math.PI / 180;\nconst RAD2DEG = 180 / Math.PI;\n\n// http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/21963136#21963136\nfunction generateUUID() {\n\n\tconst d0 = Math.random() * 0xffffffff | 0;\n\tconst d1 = Math.random() * 0xffffffff | 0;\n\tconst d2 = Math.random() * 0xffffffff | 0;\n\tconst d3 = Math.random() * 0xffffffff | 0;\n\tconst uuid = _lut[ d0 & 0xff ] + _lut[ d0 >> 8 & 0xff ] + _lut[ d0 >> 16 & 0xff ] + _lut[ d0 >> 24 & 0xff ] + '-' +\n\t\t\t_lut[ d1 & 0xff ] + _lut[ d1 >> 8 & 0xff ] + '-' + _lut[ d1 >> 16 & 0x0f | 0x40 ] + _lut[ d1 >> 24 & 0xff ] + '-' +\n\t\t\t_lut[ d2 & 0x3f | 0x80 ] + _lut[ d2 >> 8 & 0xff ] + '-' + _lut[ d2 >> 16 & 0xff ] + _lut[ d2 >> 24 & 0xff ] +\n\t\t\t_lut[ d3 & 0xff ] + _lut[ d3 >> 8 & 0xff ] + _lut[ d3 >> 16 & 0xff ] + _lut[ d3 >> 24 & 0xff ];\n\n\t// .toUpperCase() here flattens concatenated strings to save heap memory space.\n\treturn uuid.toUpperCase();\n\n}\n\nfunction clamp( value, min, max ) {\n\n\treturn Math.max( min, Math.min( max, value ) );\n\n}\n\n// compute euclidian modulo of m % n\n// https://en.wikipedia.org/wiki/Modulo_operation\nfunction euclideanModulo( n, m ) {\n\n\treturn ( ( n % m ) + m ) % m;\n\n}\n\n// Linear mapping from range <a1, a2> to range <b1, b2>\nfunction mapLinear( x, a1, a2, b1, b2 ) {\n\n\treturn b1 + ( x - a1 ) * ( b2 - b1 ) / ( a2 - a1 );\n\n}\n\n// https://www.gamedev.net/tutorials/programming/general-and-gameplay-programming/inverse-lerp-a-super-useful-yet-often-overlooked-function-r5230/\nfunction inverseLerp( x, y, value ) {\n\n\tif ( x !== y ) {\n\n\t\treturn ( value - x ) / ( y - x );\n\n\t\t } else {\n\n\t\treturn 0;\n\n\t\t }\n\n}\n\n// https://en.wikipedia.org/wiki/Linear_interpolation\nfunction lerp( x, y, t ) {\n\n\treturn ( 1 - t ) * x + t * y;\n\n}\n\n// http://www.rorydriscoll.com/2016/03/07/frame-rate-independent-damping-using-lerp/\nfunction damp( x, y, lambda, dt ) {\n\n\treturn lerp( x, y, 1 - Math.exp( - lambda * dt ) );\n\n}\n\n// https://www.desmos.com/calculator/vcsjnyz7x4\nfunction pingpong( x, length = 1 ) {\n\n\treturn length - Math.abs( euclideanModulo( x, length * 2 ) - length );\n\n}\n\n// http://en.wikipedia.org/wiki/Smoothstep\nfunction smoothstep( x, min, max ) {\n\n\tif ( x <= min ) return 0;\n\tif ( x >= max ) return 1;\n\n\tx = ( x - min ) / ( max - min );\n\n\treturn x * x * ( 3 - 2 * x );\n\n}\n\nfunction smootherstep( x, min, max ) {\n\n\tif ( x <= min ) return 0;\n\tif ( x >= max ) return 1;\n\n\tx = ( x - min ) / ( max - min );\n\n\treturn x * x * x * ( x * ( x * 6 - 15 ) + 10 );\n\n}\n\n// Random integer from <low, high> interval\nfunction randInt( low, high ) {\n\n\treturn low + Math.floor( Math.random() * ( high - low + 1 ) );\n\n}\n\n// Random float from <low, high> interval\nfunction randFloat( low, high ) {\n\n\treturn low + Math.random() * ( high - low );\n\n}\n\n// Random float from <-range/2, range/2> interval\nfunction randFloatSpread( range ) {\n\n\treturn range * ( 0.5 - Math.random() );\n\n}\n\n// Deterministic pseudo-random float in the interval [ 0, 1 ]\nfunction seededRandom( s ) {\n\n\tif ( s !== undefined ) _seed = s % 2147483647;\n\n\t// Park-Miller algorithm\n\n\t_seed = _seed * 16807 % 2147483647;\n\n\treturn ( _seed - 1 ) / 2147483646;\n\n}\n\nfunction degToRad( degrees ) {\n\n\treturn degrees * DEG2RAD;\n\n}\n\nfunction radToDeg( radians ) {\n\n\treturn radians * RAD2DEG;\n\n}\n\nfunction isPowerOfTwo( value ) {\n\n\treturn ( value & ( value - 1 ) ) === 0 && value !== 0;\n\n}\n\nfunction ceilPowerOfTwo( value ) {\n\n\treturn Math.pow( 2, Math.ceil( Math.log( value ) / Math.LN2 ) );\n\n}\n\nfunction floorPowerOfTwo( value ) {\n\n\treturn Math.pow( 2, Math.floor( Math.log( value ) / Math.LN2 ) );\n\n}\n\nfunction setQuaternionFromProperEuler( q, a, b, c, order ) {\n\n\t// Intrinsic Proper Euler Angles - see https://en.wikipedia.org/wiki/Euler_angles\n\n\t// rotations are applied to the axes in the order specified by 'order'\n\t// rotation by angle 'a' is applied first, then by angle 'b', then by angle 'c'\n\t// angles are in radians\n\n\tconst cos = Math.cos;\n\tconst sin = Math.sin;\n\n\tconst c2 = cos( b / 2 );\n\tconst s2 = sin( b / 2 );\n\n\tconst c13 = cos( ( a + c ) / 2 );\n\tconst s13 = sin( ( a + c ) / 2 );\n\n\tconst c1_3 = cos( ( a - c ) / 2 );\n\tconst s1_3 = sin( ( a - c ) / 2 );\n\n\tconst c3_1 = cos( ( c - a ) / 2 );\n\tconst s3_1 = sin( ( c - a ) / 2 );\n\n\tswitch ( order ) {\n\n\t\tcase 'XYX':\n\t\t\tq.set( c2 * s13, s2 * c1_3, s2 * s1_3, c2 * c13 );\n\t\t\tbreak;\n\n\t\tcase 'YZY':\n\t\t\tq.set( s2 * s1_3, c2 * s13, s2 * c1_3, c2 * c13 );\n\t\t\tbreak;\n\n\t\tcase 'ZXZ':\n\t\t\tq.set( s2 * c1_3, s2 * s1_3, c2 * s13, c2 * c13 );\n\t\t\tbreak;\n\n\t\tcase 'XZX':\n\t\t\tq.set( c2 * s13, s2 * s3_1, s2 * c3_1, c2 * c13 );\n\t\t\tbreak;\n\n\t\tcase 'YXY':\n\t\t\tq.set( s2 * c3_1, c2 * s13, s2 * s3_1, c2 * c13 );\n\t\t\tbreak;\n\n\t\tcase 'ZYZ':\n\t\t\tq.set( s2 * s3_1, s2 * c3_1, c2 * s13, c2 * c13 );\n\t\t\tbreak;\n\n\t\tdefault:\n\t\t\tconsole.warn( 'THREE.MathUtils: .setQuaternionFromProperEuler() encountered an unknown order: ' + order );\n\n\t}\n\n}\n\nvar MathUtils = /*#__PURE__*/Object.freeze({\n\t__proto__: null,\n\tDEG2RAD: DEG2RAD,\n\tRAD2DEG: RAD2DEG,\n\tgenerateUUID: generateUUID,\n\tclamp: clamp,\n\teuclideanModulo: euclideanModulo,\n\tmapLinear: mapLinear,\n\tinverseLerp: inverseLerp,\n\tlerp: lerp,\n\tdamp: damp,\n\tpingpong: pingpong,\n\tsmoothstep: smoothstep,\n\tsmootherstep: smootherstep,\n\trandInt: randInt,\n\trandFloat: randFloat,\n\trandFloatSpread: randFloatSpread,\n\tseededRandom: seededRandom,\n\tdegToRad: degToRad,\n\tradToDeg: radToDeg,\n\tisPowerOfTwo: isPowerOfTwo,\n\tceilPowerOfTwo: ceilPowerOfTwo,\n\tfloorPowerOfTwo: floorPowerOfTwo,\n\tsetQuaternionFromProperEuler: setQuaternionFromProperEuler\n});\n\nclass Vector2 {\n\n\tconstructor( x = 0, y = 0 ) {\n\n\t\tthis.x = x;\n\t\tthis.y = y;\n\n\t}\n\n\tget width() {\n\n\t\treturn this.x;\n\n\t}\n\n\tset width( value ) {\n\n\t\tthis.x = value;\n\n\t}\n\n\tget height() {\n\n\t\treturn this.y;\n\n\t}\n\n\tset height( value ) {\n\n\t\tthis.y = value;\n\n\t}\n\n\tset( x, y ) {\n\n\t\tthis.x = x;\n\t\tthis.y = y;\n\n\t\treturn this;\n\n\t}\n\n\tsetScalar( scalar ) {\n\n\t\tthis.x = scalar;\n\t\tthis.y = scalar;\n\n\t\treturn this;\n\n\t}\n\n\tsetX( x ) {\n\n\t\tthis.x = x;\n\n\t\treturn this;\n\n\t}\n\n\tsetY( y ) {\n\n\t\tthis.y = y;\n\n\t\treturn this;\n\n\t}\n\n\tsetComponent( index, value ) {\n\n\t\tswitch ( index ) {\n\n\t\t\tcase 0: this.x = value; break;\n\t\t\tcase 1: this.y = value; break;\n\t\t\tdefault: throw new Error( 'index is out of range: ' + index );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tgetComponent( index ) {\n\n\t\tswitch ( index ) {\n\n\t\t\tcase 0: return this.x;\n\t\t\tcase 1: return this.y;\n\t\t\tdefault: throw new Error( 'index is out of range: ' + index );\n\n\t\t}\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor( this.x, this.y );\n\n\t}\n\n\tcopy( v ) {\n\n\t\tthis.x = v.x;\n\t\tthis.y = v.y;\n\n\t\treturn this;\n\n\t}\n\n\tadd( v, w ) {\n\n\t\tif ( w !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead.' );\n\t\t\treturn this.addVectors( v, w );\n\n\t\t}\n\n\t\tthis.x += v.x;\n\t\tthis.y += v.y;\n\n\t\treturn this;\n\n\t}\n\n\taddScalar( s ) {\n\n\t\tthis.x += s;\n\t\tthis.y += s;\n\n\t\treturn this;\n\n\t}\n\n\taddVectors( a, b ) {\n\n\t\tthis.x = a.x + b.x;\n\t\tthis.y = a.y + b.y;\n\n\t\treturn this;\n\n\t}\n\n\taddScaledVector( v, s ) {\n\n\t\tthis.x += v.x * s;\n\t\tthis.y += v.y * s;\n\n\t\treturn this;\n\n\t}\n\n\tsub( v, w ) {\n\n\t\tif ( w !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.' );\n\t\t\treturn this.subVectors( v, w );\n\n\t\t}\n\n\t\tthis.x -= v.x;\n\t\tthis.y -= v.y;\n\n\t\treturn this;\n\n\t}\n\n\tsubScalar( s ) {\n\n\t\tthis.x -= s;\n\t\tthis.y -= s;\n\n\t\treturn this;\n\n\t}\n\n\tsubVectors( a, b ) {\n\n\t\tthis.x = a.x - b.x;\n\t\tthis.y = a.y - b.y;\n\n\t\treturn this;\n\n\t}\n\n\tmultiply( v ) {\n\n\t\tthis.x *= v.x;\n\t\tthis.y *= v.y;\n\n\t\treturn this;\n\n\t}\n\n\tmultiplyScalar( scalar ) {\n\n\t\tthis.x *= scalar;\n\t\tthis.y *= scalar;\n\n\t\treturn this;\n\n\t}\n\n\tdivide( v ) {\n\n\t\tthis.x /= v.x;\n\t\tthis.y /= v.y;\n\n\t\treturn this;\n\n\t}\n\n\tdivideScalar( scalar ) {\n\n\t\treturn this.multiplyScalar( 1 / scalar );\n\n\t}\n\n\tapplyMatrix3( m ) {\n\n\t\tconst x = this.x, y = this.y;\n\t\tconst e = m.elements;\n\n\t\tthis.x = e[ 0 ] * x + e[ 3 ] * y + e[ 6 ];\n\t\tthis.y = e[ 1 ] * x + e[ 4 ] * y + e[ 7 ];\n\n\t\treturn this;\n\n\t}\n\n\tmin( v ) {\n\n\t\tthis.x = Math.min( this.x, v.x );\n\t\tthis.y = Math.min( this.y, v.y );\n\n\t\treturn this;\n\n\t}\n\n\tmax( v ) {\n\n\t\tthis.x = Math.max( this.x, v.x );\n\t\tthis.y = Math.max( this.y, v.y );\n\n\t\treturn this;\n\n\t}\n\n\tclamp( min, max ) {\n\n\t\t// assumes min < max, componentwise\n\n\t\tthis.x = Math.max( min.x, Math.min( max.x, this.x ) );\n\t\tthis.y = Math.max( min.y, Math.min( max.y, this.y ) );\n\n\t\treturn this;\n\n\t}\n\n\tclampScalar( minVal, maxVal ) {\n\n\t\tthis.x = Math.max( minVal, Math.min( maxVal, this.x ) );\n\t\tthis.y = Math.max( minVal, Math.min( maxVal, this.y ) );\n\n\t\treturn this;\n\n\t}\n\n\tclampLength( min, max ) {\n\n\t\tconst length = this.length();\n\n\t\treturn this.divideScalar( length || 1 ).multiplyScalar( Math.max( min, Math.min( max, length ) ) );\n\n\t}\n\n\tfloor() {\n\n\t\tthis.x = Math.floor( this.x );\n\t\tthis.y = Math.floor( this.y );\n\n\t\treturn this;\n\n\t}\n\n\tceil() {\n\n\t\tthis.x = Math.ceil( this.x );\n\t\tthis.y = Math.ceil( this.y );\n\n\t\treturn this;\n\n\t}\n\n\tround() {\n\n\t\tthis.x = Math.round( this.x );\n\t\tthis.y = Math.round( this.y );\n\n\t\treturn this;\n\n\t}\n\n\troundToZero() {\n\n\t\tthis.x = ( this.x < 0 ) ? Math.ceil( this.x ) : Math.floor( this.x );\n\t\tthis.y = ( this.y < 0 ) ? Math.ceil( this.y ) : Math.floor( this.y );\n\n\t\treturn this;\n\n\t}\n\n\tnegate() {\n\n\t\tthis.x = - this.x;\n\t\tthis.y = - this.y;\n\n\t\treturn this;\n\n\t}\n\n\tdot( v ) {\n\n\t\treturn this.x * v.x + this.y * v.y;\n\n\t}\n\n\tcross( v ) {\n\n\t\treturn this.x * v.y - this.y * v.x;\n\n\t}\n\n\tlengthSq() {\n\n\t\treturn this.x * this.x + this.y * this.y;\n\n\t}\n\n\tlength() {\n\n\t\treturn Math.sqrt( this.x * this.x + this.y * this.y );\n\n\t}\n\n\tmanhattanLength() {\n\n\t\treturn Math.abs( this.x ) + Math.abs( this.y );\n\n\t}\n\n\tnormalize() {\n\n\t\treturn this.divideScalar( this.length() || 1 );\n\n\t}\n\n\tangle() {\n\n\t\t// computes the angle in radians with respect to the positive x-axis\n\n\t\tconst angle = Math.atan2( - this.y, - this.x ) + Math.PI;\n\n\t\treturn angle;\n\n\t}\n\n\tdistanceTo( v ) {\n\n\t\treturn Math.sqrt( this.distanceToSquared( v ) );\n\n\t}\n\n\tdistanceToSquared( v ) {\n\n\t\tconst dx = this.x - v.x, dy = this.y - v.y;\n\t\treturn dx * dx + dy * dy;\n\n\t}\n\n\tmanhattanDistanceTo( v ) {\n\n\t\treturn Math.abs( this.x - v.x ) + Math.abs( this.y - v.y );\n\n\t}\n\n\tsetLength( length ) {\n\n\t\treturn this.normalize().multiplyScalar( length );\n\n\t}\n\n\tlerp( v, alpha ) {\n\n\t\tthis.x += ( v.x - this.x ) * alpha;\n\t\tthis.y += ( v.y - this.y ) * alpha;\n\n\t\treturn this;\n\n\t}\n\n\tlerpVectors( v1, v2, alpha ) {\n\n\t\tthis.x = v1.x + ( v2.x - v1.x ) * alpha;\n\t\tthis.y = v1.y + ( v2.y - v1.y ) * alpha;\n\n\t\treturn this;\n\n\t}\n\n\tequals( v ) {\n\n\t\treturn ( ( v.x === this.x ) && ( v.y === this.y ) );\n\n\t}\n\n\tfromArray( array, offset = 0 ) {\n\n\t\tthis.x = array[ offset ];\n\t\tthis.y = array[ offset + 1 ];\n\n\t\treturn this;\n\n\t}\n\n\ttoArray( array = [], offset = 0 ) {\n\n\t\tarray[ offset ] = this.x;\n\t\tarray[ offset + 1 ] = this.y;\n\n\t\treturn array;\n\n\t}\n\n\tfromBufferAttribute( attribute, index, offset ) {\n\n\t\tif ( offset !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector2: offset has been removed from .fromBufferAttribute().' );\n\n\t\t}\n\n\t\tthis.x = attribute.getX( index );\n\t\tthis.y = attribute.getY( index );\n\n\t\treturn this;\n\n\t}\n\n\trotateAround( center, angle ) {\n\n\t\tconst c = Math.cos( angle ), s = Math.sin( angle );\n\n\t\tconst x = this.x - center.x;\n\t\tconst y = this.y - center.y;\n\n\t\tthis.x = x * c - y * s + center.x;\n\t\tthis.y = x * s + y * c + center.y;\n\n\t\treturn this;\n\n\t}\n\n\trandom() {\n\n\t\tthis.x = Math.random();\n\t\tthis.y = Math.random();\n\n\t\treturn this;\n\n\t}\n\n}\n\nVector2.prototype.isVector2 = true;\n\nclass Matrix3 {\n\n\tconstructor() {\n\n\t\tthis.elements = [\n\n\t\t\t1, 0, 0,\n\t\t\t0, 1, 0,\n\t\t\t0, 0, 1\n\n\t\t];\n\n\t\tif ( arguments.length > 0 ) {\n\n\t\t\tconsole.error( 'THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.' );\n\n\t\t}\n\n\t}\n\n\tset( n11, n12, n13, n21, n22, n23, n31, n32, n33 ) {\n\n\t\tconst te = this.elements;\n\n\t\tte[ 0 ] = n11; te[ 1 ] = n21; te[ 2 ] = n31;\n\t\tte[ 3 ] = n12; te[ 4 ] = n22; te[ 5 ] = n32;\n\t\tte[ 6 ] = n13; te[ 7 ] = n23; te[ 8 ] = n33;\n\n\t\treturn this;\n\n\t}\n\n\tidentity() {\n\n\t\tthis.set(\n\n\t\t\t1, 0, 0,\n\t\t\t0, 1, 0,\n\t\t\t0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tcopy( m ) {\n\n\t\tconst te = this.elements;\n\t\tconst me = m.elements;\n\n\t\tte[ 0 ] = me[ 0 ]; te[ 1 ] = me[ 1 ]; te[ 2 ] = me[ 2 ];\n\t\tte[ 3 ] = me[ 3 ]; te[ 4 ] = me[ 4 ]; te[ 5 ] = me[ 5 ];\n\t\tte[ 6 ] = me[ 6 ]; te[ 7 ] = me[ 7 ]; te[ 8 ] = me[ 8 ];\n\n\t\treturn this;\n\n\t}\n\n\textractBasis( xAxis, yAxis, zAxis ) {\n\n\t\txAxis.setFromMatrix3Column( this, 0 );\n\t\tyAxis.setFromMatrix3Column( this, 1 );\n\t\tzAxis.setFromMatrix3Column( this, 2 );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromMatrix4( m ) {\n\n\t\tconst me = m.elements;\n\n\t\tthis.set(\n\n\t\t\tme[ 0 ], me[ 4 ], me[ 8 ],\n\t\t\tme[ 1 ], me[ 5 ], me[ 9 ],\n\t\t\tme[ 2 ], me[ 6 ], me[ 10 ]\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tmultiply( m ) {\n\n\t\treturn this.multiplyMatrices( this, m );\n\n\t}\n\n\tpremultiply( m ) {\n\n\t\treturn this.multiplyMatrices( m, this );\n\n\t}\n\n\tmultiplyMatrices( a, b ) {\n\n\t\tconst ae = a.elements;\n\t\tconst be = b.elements;\n\t\tconst te = this.elements;\n\n\t\tconst a11 = ae[ 0 ], a12 = ae[ 3 ], a13 = ae[ 6 ];\n\t\tconst a21 = ae[ 1 ], a22 = ae[ 4 ], a23 = ae[ 7 ];\n\t\tconst a31 = ae[ 2 ], a32 = ae[ 5 ], a33 = ae[ 8 ];\n\n\t\tconst b11 = be[ 0 ], b12 = be[ 3 ], b13 = be[ 6 ];\n\t\tconst b21 = be[ 1 ], b22 = be[ 4 ], b23 = be[ 7 ];\n\t\tconst b31 = be[ 2 ], b32 = be[ 5 ], b33 = be[ 8 ];\n\n\t\tte[ 0 ] = a11 * b11 + a12 * b21 + a13 * b31;\n\t\tte[ 3 ] = a11 * b12 + a12 * b22 + a13 * b32;\n\t\tte[ 6 ] = a11 * b13 + a12 * b23 + a13 * b33;\n\n\t\tte[ 1 ] = a21 * b11 + a22 * b21 + a23 * b31;\n\t\tte[ 4 ] = a21 * b12 + a22 * b22 + a23 * b32;\n\t\tte[ 7 ] = a21 * b13 + a22 * b23 + a23 * b33;\n\n\t\tte[ 2 ] = a31 * b11 + a32 * b21 + a33 * b31;\n\t\tte[ 5 ] = a31 * b12 + a32 * b22 + a33 * b32;\n\t\tte[ 8 ] = a31 * b13 + a32 * b23 + a33 * b33;\n\n\t\treturn this;\n\n\t}\n\n\tmultiplyScalar( s ) {\n\n\t\tconst te = this.elements;\n\n\t\tte[ 0 ] *= s; te[ 3 ] *= s; te[ 6 ] *= s;\n\t\tte[ 1 ] *= s; te[ 4 ] *= s; te[ 7 ] *= s;\n\t\tte[ 2 ] *= s; te[ 5 ] *= s; te[ 8 ] *= s;\n\n\t\treturn this;\n\n\t}\n\n\tdeterminant() {\n\n\t\tconst te = this.elements;\n\n\t\tconst a = te[ 0 ], b = te[ 1 ], c = te[ 2 ],\n\t\t\td = te[ 3 ], e = te[ 4 ], f = te[ 5 ],\n\t\t\tg = te[ 6 ], h = te[ 7 ], i = te[ 8 ];\n\n\t\treturn a * e * i - a * f * h - b * d * i + b * f * g + c * d * h - c * e * g;\n\n\t}\n\n\tinvert() {\n\n\t\tconst te = this.elements,\n\n\t\t\tn11 = te[ 0 ], n21 = te[ 1 ], n31 = te[ 2 ],\n\t\t\tn12 = te[ 3 ], n22 = te[ 4 ], n32 = te[ 5 ],\n\t\t\tn13 = te[ 6 ], n23 = te[ 7 ], n33 = te[ 8 ],\n\n\t\t\tt11 = n33 * n22 - n32 * n23,\n\t\t\tt12 = n32 * n13 - n33 * n12,\n\t\t\tt13 = n23 * n12 - n22 * n13,\n\n\t\t\tdet = n11 * t11 + n21 * t12 + n31 * t13;\n\n\t\tif ( det === 0 ) return this.set( 0, 0, 0, 0, 0, 0, 0, 0, 0 );\n\n\t\tconst detInv = 1 / det;\n\n\t\tte[ 0 ] = t11 * detInv;\n\t\tte[ 1 ] = ( n31 * n23 - n33 * n21 ) * detInv;\n\t\tte[ 2 ] = ( n32 * n21 - n31 * n22 ) * detInv;\n\n\t\tte[ 3 ] = t12 * detInv;\n\t\tte[ 4 ] = ( n33 * n11 - n31 * n13 ) * detInv;\n\t\tte[ 5 ] = ( n31 * n12 - n32 * n11 ) * detInv;\n\n\t\tte[ 6 ] = t13 * detInv;\n\t\tte[ 7 ] = ( n21 * n13 - n23 * n11 ) * detInv;\n\t\tte[ 8 ] = ( n22 * n11 - n21 * n12 ) * detInv;\n\n\t\treturn this;\n\n\t}\n\n\ttranspose() {\n\n\t\tlet tmp;\n\t\tconst m = this.elements;\n\n\t\ttmp = m[ 1 ]; m[ 1 ] = m[ 3 ]; m[ 3 ] = tmp;\n\t\ttmp = m[ 2 ]; m[ 2 ] = m[ 6 ]; m[ 6 ] = tmp;\n\t\ttmp = m[ 5 ]; m[ 5 ] = m[ 7 ]; m[ 7 ] = tmp;\n\n\t\treturn this;\n\n\t}\n\n\tgetNormalMatrix( matrix4 ) {\n\n\t\treturn this.setFromMatrix4( matrix4 ).invert().transpose();\n\n\t}\n\n\ttransposeIntoArray( r ) {\n\n\t\tconst m = this.elements;\n\n\t\tr[ 0 ] = m[ 0 ];\n\t\tr[ 1 ] = m[ 3 ];\n\t\tr[ 2 ] = m[ 6 ];\n\t\tr[ 3 ] = m[ 1 ];\n\t\tr[ 4 ] = m[ 4 ];\n\t\tr[ 5 ] = m[ 7 ];\n\t\tr[ 6 ] = m[ 2 ];\n\t\tr[ 7 ] = m[ 5 ];\n\t\tr[ 8 ] = m[ 8 ];\n\n\t\treturn this;\n\n\t}\n\n\tsetUvTransform( tx, ty, sx, sy, rotation, cx, cy ) {\n\n\t\tconst c = Math.cos( rotation );\n\t\tconst s = Math.sin( rotation );\n\n\t\tthis.set(\n\t\t\tsx * c, sx * s, - sx * ( c * cx + s * cy ) + cx + tx,\n\t\t\t- sy * s, sy * c, - sy * ( - s * cx + c * cy ) + cy + ty,\n\t\t\t0, 0, 1\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tscale( sx, sy ) {\n\n\t\tconst te = this.elements;\n\n\t\tte[ 0 ] *= sx; te[ 3 ] *= sx; te[ 6 ] *= sx;\n\t\tte[ 1 ] *= sy; te[ 4 ] *= sy; te[ 7 ] *= sy;\n\n\t\treturn this;\n\n\t}\n\n\trotate( theta ) {\n\n\t\tconst c = Math.cos( theta );\n\t\tconst s = Math.sin( theta );\n\n\t\tconst te = this.elements;\n\n\t\tconst a11 = te[ 0 ], a12 = te[ 3 ], a13 = te[ 6 ];\n\t\tconst a21 = te[ 1 ], a22 = te[ 4 ], a23 = te[ 7 ];\n\n\t\tte[ 0 ] = c * a11 + s * a21;\n\t\tte[ 3 ] = c * a12 + s * a22;\n\t\tte[ 6 ] = c * a13 + s * a23;\n\n\t\tte[ 1 ] = - s * a11 + c * a21;\n\t\tte[ 4 ] = - s * a12 + c * a22;\n\t\tte[ 7 ] = - s * a13 + c * a23;\n\n\t\treturn this;\n\n\t}\n\n\ttranslate( tx, ty ) {\n\n\t\tconst te = this.elements;\n\n\t\tte[ 0 ] += tx * te[ 2 ]; te[ 3 ] += tx * te[ 5 ]; te[ 6 ] += tx * te[ 8 ];\n\t\tte[ 1 ] += ty * te[ 2 ]; te[ 4 ] += ty * te[ 5 ]; te[ 7 ] += ty * te[ 8 ];\n\n\t\treturn this;\n\n\t}\n\n\tequals( matrix ) {\n\n\t\tconst te = this.elements;\n\t\tconst me = matrix.elements;\n\n\t\tfor ( let i = 0; i < 9; i ++ ) {\n\n\t\t\tif ( te[ i ] !== me[ i ] ) return false;\n\n\t\t}\n\n\t\treturn true;\n\n\t}\n\n\tfromArray( array, offset = 0 ) {\n\n\t\tfor ( let i = 0; i < 9; i ++ ) {\n\n\t\t\tthis.elements[ i ] = array[ i + offset ];\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\ttoArray( array = [], offset = 0 ) {\n\n\t\tconst te = this.elements;\n\n\t\tarray[ offset ] = te[ 0 ];\n\t\tarray[ offset + 1 ] = te[ 1 ];\n\t\tarray[ offset + 2 ] = te[ 2 ];\n\n\t\tarray[ offset + 3 ] = te[ 3 ];\n\t\tarray[ offset + 4 ] = te[ 4 ];\n\t\tarray[ offset + 5 ] = te[ 5 ];\n\n\t\tarray[ offset + 6 ] = te[ 6 ];\n\t\tarray[ offset + 7 ] = te[ 7 ];\n\t\tarray[ offset + 8 ] = te[ 8 ];\n\n\t\treturn array;\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().fromArray( this.elements );\n\n\t}\n\n}\n\nMatrix3.prototype.isMatrix3 = true;\n\nlet _canvas;\n\nclass ImageUtils {\n\n\tstatic getDataURL( image ) {\n\n\t\tif ( /^data:/i.test( image.src ) ) {\n\n\t\t\treturn image.src;\n\n\t\t}\n\n\t\tif ( typeof HTMLCanvasElement == 'undefined' ) {\n\n\t\t\treturn image.src;\n\n\t\t}\n\n\t\tlet canvas;\n\n\t\tif ( image instanceof HTMLCanvasElement ) {\n\n\t\t\tcanvas = image;\n\n\t\t} else {\n\n\t\t\tif ( _canvas === undefined ) _canvas = document.createElementNS( 'http://www.w3.org/1999/xhtml', 'canvas' );\n\n\t\t\t_canvas.width = image.width;\n\t\t\t_canvas.height = image.height;\n\n\t\t\tconst context = _canvas.getContext( '2d' );\n\n\t\t\tif ( image instanceof ImageData ) {\n\n\t\t\t\tcontext.putImageData( image, 0, 0 );\n\n\t\t\t} else {\n\n\t\t\t\tcontext.drawImage( image, 0, 0, image.width, image.height );\n\n\t\t\t}\n\n\t\t\tcanvas = _canvas;\n\n\t\t}\n\n\t\tif ( canvas.width > 2048 || canvas.height > 2048 ) {\n\n\t\t\tconsole.warn( 'THREE.ImageUtils.getDataURL: Image converted to jpg for performance reasons', image );\n\n\t\t\treturn canvas.toDataURL( 'image/jpeg', 0.6 );\n\n\t\t} else {\n\n\t\t\treturn canvas.toDataURL( 'image/png' );\n\n\t\t}\n\n\t}\n\n}\n\nlet textureId = 0;\n\nclass Texture extends EventDispatcher {\n\n\tconstructor( image = Texture.DEFAULT_IMAGE, mapping = Texture.DEFAULT_MAPPING, wrapS = ClampToEdgeWrapping, wrapT = ClampToEdgeWrapping, magFilter = LinearFilter, minFilter = LinearMipmapLinearFilter, format = RGBAFormat, type = UnsignedByteType, anisotropy = 1, encoding = LinearEncoding ) {\n\n\t\tsuper();\n\n\t\tObject.defineProperty( this, 'id', { value: textureId ++ } );\n\n\t\tthis.uuid = generateUUID();\n\n\t\tthis.name = '';\n\n\t\tthis.image = image;\n\t\tthis.mipmaps = [];\n\n\t\tthis.mapping = mapping;\n\n\t\tthis.wrapS = wrapS;\n\t\tthis.wrapT = wrapT;\n\n\t\tthis.magFilter = magFilter;\n\t\tthis.minFilter = minFilter;\n\n\t\tthis.anisotropy = anisotropy;\n\n\t\tthis.format = format;\n\t\tthis.internalFormat = null;\n\t\tthis.type = type;\n\n\t\tthis.offset = new Vector2( 0, 0 );\n\t\tthis.repeat = new Vector2( 1, 1 );\n\t\tthis.center = new Vector2( 0, 0 );\n\t\tthis.rotation = 0;\n\n\t\tthis.matrixAutoUpdate = true;\n\t\tthis.matrix = new Matrix3();\n\n\t\tthis.generateMipmaps = true;\n\t\tthis.premultiplyAlpha = false;\n\t\tthis.flipY = true;\n\t\tthis.unpackAlignment = 4;\t// valid values: 1, 2, 4, 8 (see http://www.khronos.org/opengles/sdk/docs/man/xhtml/glPixelStorei.xml)\n\n\t\t// Values of encoding !== THREE.LinearEncoding only supported on map, envMap and emissiveMap.\n\t\t//\n\t\t// Also changing the encoding after already used by a Material will not automatically make the Material\n\t\t// update. You need to explicitly call Material.needsUpdate to trigger it to recompile.\n\t\tthis.encoding = encoding;\n\n\t\tthis.version = 0;\n\t\tthis.onUpdate = null;\n\n\t}\n\n\tupdateMatrix() {\n\n\t\tthis.matrix.setUvTransform( this.offset.x, this.offset.y, this.repeat.x, this.repeat.y, this.rotation, this.center.x, this.center.y );\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n\tcopy( source ) {\n\n\t\tthis.name = source.name;\n\n\t\tthis.image = source.image;\n\t\tthis.mipmaps = source.mipmaps.slice( 0 );\n\n\t\tthis.mapping = source.mapping;\n\n\t\tthis.wrapS = source.wrapS;\n\t\tthis.wrapT = source.wrapT;\n\n\t\tthis.magFilter = source.magFilter;\n\t\tthis.minFilter = source.minFilter;\n\n\t\tthis.anisotropy = source.anisotropy;\n\n\t\tthis.format = source.format;\n\t\tthis.internalFormat = source.internalFormat;\n\t\tthis.type = source.type;\n\n\t\tthis.offset.copy( source.offset );\n\t\tthis.repeat.copy( source.repeat );\n\t\tthis.center.copy( source.center );\n\t\tthis.rotation = source.rotation;\n\n\t\tthis.matrixAutoUpdate = source.matrixAutoUpdate;\n\t\tthis.matrix.copy( source.matrix );\n\n\t\tthis.generateMipmaps = source.generateMipmaps;\n\t\tthis.premultiplyAlpha = source.premultiplyAlpha;\n\t\tthis.flipY = source.flipY;\n\t\tthis.unpackAlignment = source.unpackAlignment;\n\t\tthis.encoding = source.encoding;\n\n\t\treturn this;\n\n\t}\n\n\ttoJSON( meta ) {\n\n\t\tconst isRootObject = ( meta === undefined || typeof meta === 'string' );\n\n\t\tif ( ! isRootObject && meta.textures[ this.uuid ] !== undefined ) {\n\n\t\t\treturn meta.textures[ this.uuid ];\n\n\t\t}\n\n\t\tconst output = {\n\n\t\t\tmetadata: {\n\t\t\t\tversion: 4.5,\n\t\t\t\ttype: 'Texture',\n\t\t\t\tgenerator: 'Texture.toJSON'\n\t\t\t},\n\n\t\t\tuuid: this.uuid,\n\t\t\tname: this.name,\n\n\t\t\tmapping: this.mapping,\n\n\t\t\trepeat: [ this.repeat.x, this.repeat.y ],\n\t\t\toffset: [ this.offset.x, this.offset.y ],\n\t\t\tcenter: [ this.center.x, this.center.y ],\n\t\t\trotation: this.rotation,\n\n\t\t\twrap: [ this.wrapS, this.wrapT ],\n\n\t\t\tformat: this.format,\n\t\t\ttype: this.type,\n\t\t\tencoding: this.encoding,\n\n\t\t\tminFilter: this.minFilter,\n\t\t\tmagFilter: this.magFilter,\n\t\t\tanisotropy: this.anisotropy,\n\n\t\t\tflipY: this.flipY,\n\n\t\t\tpremultiplyAlpha: this.premultiplyAlpha,\n\t\t\tunpackAlignment: this.unpackAlignment\n\n\t\t};\n\n\t\tif ( this.image !== undefined ) {\n\n\t\t\t// TODO: Move to THREE.Image\n\n\t\t\tconst image = this.image;\n\n\t\t\tif ( image.uuid === undefined ) {\n\n\t\t\t\timage.uuid = generateUUID(); // UGH\n\n\t\t\t}\n\n\t\t\tif ( ! isRootObject && meta.images[ image.uuid ] === undefined ) {\n\n\t\t\t\tlet url;\n\n\t\t\t\tif ( Array.isArray( image ) ) {\n\n\t\t\t\t\t// process array of images e.g. CubeTexture\n\n\t\t\t\t\turl = [];\n\n\t\t\t\t\tfor ( let i = 0, l = image.length; i < l; i ++ ) {\n\n\t\t\t\t\t\t// check cube texture with data textures\n\n\t\t\t\t\t\tif ( image[ i ].isDataTexture ) {\n\n\t\t\t\t\t\t\turl.push( serializeImage( image[ i ].image ) );\n\n\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\turl.push( serializeImage( image[ i ] ) );\n\n\t\t\t\t\t\t}\n\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\n\t\t\t\t\t// process single image\n\n\t\t\t\t\turl = serializeImage( image );\n\n\t\t\t\t}\n\n\t\t\t\tmeta.images[ image.uuid ] = {\n\t\t\t\t\tuuid: image.uuid,\n\t\t\t\t\turl: url\n\t\t\t\t};\n\n\t\t\t}\n\n\t\t\toutput.image = image.uuid;\n\n\t\t}\n\n\t\tif ( ! isRootObject ) {\n\n\t\t\tmeta.textures[ this.uuid ] = output;\n\n\t\t}\n\n\t\treturn output;\n\n\t}\n\n\tdispose() {\n\n\t\tthis.dispatchEvent( { type: 'dispose' } );\n\n\t}\n\n\ttransformUv( uv ) {\n\n\t\tif ( this.mapping !== UVMapping ) return uv;\n\n\t\tuv.applyMatrix3( this.matrix );\n\n\t\tif ( uv.x < 0 || uv.x > 1 ) {\n\n\t\t\tswitch ( this.wrapS ) {\n\n\t\t\t\tcase RepeatWrapping:\n\n\t\t\t\t\tuv.x = uv.x - Math.floor( uv.x );\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase ClampToEdgeWrapping:\n\n\t\t\t\t\tuv.x = uv.x < 0 ? 0 : 1;\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase MirroredRepeatWrapping:\n\n\t\t\t\t\tif ( Math.abs( Math.floor( uv.x ) % 2 ) === 1 ) {\n\n\t\t\t\t\t\tuv.x = Math.ceil( uv.x ) - uv.x;\n\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\tuv.x = uv.x - Math.floor( uv.x );\n\n\t\t\t\t\t}\n\n\t\t\t\t\tbreak;\n\n\t\t\t}\n\n\t\t}\n\n\t\tif ( uv.y < 0 || uv.y > 1 ) {\n\n\t\t\tswitch ( this.wrapT ) {\n\n\t\t\t\tcase RepeatWrapping:\n\n\t\t\t\t\tuv.y = uv.y - Math.floor( uv.y );\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase ClampToEdgeWrapping:\n\n\t\t\t\t\tuv.y = uv.y < 0 ? 0 : 1;\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase MirroredRepeatWrapping:\n\n\t\t\t\t\tif ( Math.abs( Math.floor( uv.y ) % 2 ) === 1 ) {\n\n\t\t\t\t\t\tuv.y = Math.ceil( uv.y ) - uv.y;\n\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\tuv.y = uv.y - Math.floor( uv.y );\n\n\t\t\t\t\t}\n\n\t\t\t\t\tbreak;\n\n\t\t\t}\n\n\t\t}\n\n\t\tif ( this.flipY ) {\n\n\t\t\tuv.y = 1 - uv.y;\n\n\t\t}\n\n\t\treturn uv;\n\n\t}\n\n\tset needsUpdate( value ) {\n\n\t\tif ( value === true ) this.version ++;\n\n\t}\n\n}\n\nTexture.DEFAULT_IMAGE = undefined;\nTexture.DEFAULT_MAPPING = UVMapping;\n\nTexture.prototype.isTexture = true;\n\nfunction serializeImage( image ) {\n\n\tif ( ( typeof HTMLImageElement !== 'undefined' && image instanceof HTMLImageElement ) ||\n\t\t( typeof HTMLCanvasElement !== 'undefined' && image instanceof HTMLCanvasElement ) ||\n\t\t( typeof ImageBitmap !== 'undefined' && image instanceof ImageBitmap ) ) {\n\n\t\t// default images\n\n\t\treturn ImageUtils.getDataURL( image );\n\n\t} else {\n\n\t\tif ( image.data ) {\n\n\t\t\t// images of DataTexture\n\n\t\t\treturn {\n\t\t\t\tdata: Array.prototype.slice.call( image.data ),\n\t\t\t\twidth: image.width,\n\t\t\t\theight: image.height,\n\t\t\t\ttype: image.data.constructor.name\n\t\t\t};\n\n\t\t} else {\n\n\t\t\tconsole.warn( 'THREE.Texture: Unable to serialize Texture.' );\n\t\t\treturn {};\n\n\t\t}\n\n\t}\n\n}\n\nclass Vector4 {\n\n\tconstructor( x = 0, y = 0, z = 0, w = 1 ) {\n\n\t\tthis.x = x;\n\t\tthis.y = y;\n\t\tthis.z = z;\n\t\tthis.w = w;\n\n\t}\n\n\tget width() {\n\n\t\treturn this.z;\n\n\t}\n\n\tset width( value ) {\n\n\t\tthis.z = value;\n\n\t}\n\n\tget height() {\n\n\t\treturn this.w;\n\n\t}\n\n\tset height( value ) {\n\n\t\tthis.w = value;\n\n\t}\n\n\tset( x, y, z, w ) {\n\n\t\tthis.x = x;\n\t\tthis.y = y;\n\t\tthis.z = z;\n\t\tthis.w = w;\n\n\t\treturn this;\n\n\t}\n\n\tsetScalar( scalar ) {\n\n\t\tthis.x = scalar;\n\t\tthis.y = scalar;\n\t\tthis.z = scalar;\n\t\tthis.w = scalar;\n\n\t\treturn this;\n\n\t}\n\n\tsetX( x ) {\n\n\t\tthis.x = x;\n\n\t\treturn this;\n\n\t}\n\n\tsetY( y ) {\n\n\t\tthis.y = y;\n\n\t\treturn this;\n\n\t}\n\n\tsetZ( z ) {\n\n\t\tthis.z = z;\n\n\t\treturn this;\n\n\t}\n\n\tsetW( w ) {\n\n\t\tthis.w = w;\n\n\t\treturn this;\n\n\t}\n\n\tsetComponent( index, value ) {\n\n\t\tswitch ( index ) {\n\n\t\t\tcase 0: this.x = value; break;\n\t\t\tcase 1: this.y = value; break;\n\t\t\tcase 2: this.z = value; break;\n\t\t\tcase 3: this.w = value; break;\n\t\t\tdefault: throw new Error( 'index is out of range: ' + index );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tgetComponent( index ) {\n\n\t\tswitch ( index ) {\n\n\t\t\tcase 0: return this.x;\n\t\t\tcase 1: return this.y;\n\t\t\tcase 2: return this.z;\n\t\t\tcase 3: return this.w;\n\t\t\tdefault: throw new Error( 'index is out of range: ' + index );\n\n\t\t}\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor( this.x, this.y, this.z, this.w );\n\n\t}\n\n\tcopy( v ) {\n\n\t\tthis.x = v.x;\n\t\tthis.y = v.y;\n\t\tthis.z = v.z;\n\t\tthis.w = ( v.w !== undefined ) ? v.w : 1;\n\n\t\treturn this;\n\n\t}\n\n\tadd( v, w ) {\n\n\t\tif ( w !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead.' );\n\t\t\treturn this.addVectors( v, w );\n\n\t\t}\n\n\t\tthis.x += v.x;\n\t\tthis.y += v.y;\n\t\tthis.z += v.z;\n\t\tthis.w += v.w;\n\n\t\treturn this;\n\n\t}\n\n\taddScalar( s ) {\n\n\t\tthis.x += s;\n\t\tthis.y += s;\n\t\tthis.z += s;\n\t\tthis.w += s;\n\n\t\treturn this;\n\n\t}\n\n\taddVectors( a, b ) {\n\n\t\tthis.x = a.x + b.x;\n\t\tthis.y = a.y + b.y;\n\t\tthis.z = a.z + b.z;\n\t\tthis.w = a.w + b.w;\n\n\t\treturn this;\n\n\t}\n\n\taddScaledVector( v, s ) {\n\n\t\tthis.x += v.x * s;\n\t\tthis.y += v.y * s;\n\t\tthis.z += v.z * s;\n\t\tthis.w += v.w * s;\n\n\t\treturn this;\n\n\t}\n\n\tsub( v, w ) {\n\n\t\tif ( w !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.' );\n\t\t\treturn this.subVectors( v, w );\n\n\t\t}\n\n\t\tthis.x -= v.x;\n\t\tthis.y -= v.y;\n\t\tthis.z -= v.z;\n\t\tthis.w -= v.w;\n\n\t\treturn this;\n\n\t}\n\n\tsubScalar( s ) {\n\n\t\tthis.x -= s;\n\t\tthis.y -= s;\n\t\tthis.z -= s;\n\t\tthis.w -= s;\n\n\t\treturn this;\n\n\t}\n\n\tsubVectors( a, b ) {\n\n\t\tthis.x = a.x - b.x;\n\t\tthis.y = a.y - b.y;\n\t\tthis.z = a.z - b.z;\n\t\tthis.w = a.w - b.w;\n\n\t\treturn this;\n\n\t}\n\n\tmultiply( v ) {\n\n\t\tthis.x *= v.x;\n\t\tthis.y *= v.y;\n\t\tthis.z *= v.z;\n\t\tthis.w *= v.w;\n\n\t\treturn this;\n\n\t}\n\n\tmultiplyScalar( scalar ) {\n\n\t\tthis.x *= scalar;\n\t\tthis.y *= scalar;\n\t\tthis.z *= scalar;\n\t\tthis.w *= scalar;\n\n\t\treturn this;\n\n\t}\n\n\tapplyMatrix4( m ) {\n\n\t\tconst x = this.x, y = this.y, z = this.z, w = this.w;\n\t\tconst e = m.elements;\n\n\t\tthis.x = e[ 0 ] * x + e[ 4 ] * y + e[ 8 ] * z + e[ 12 ] * w;\n\t\tthis.y = e[ 1 ] * x + e[ 5 ] * y + e[ 9 ] * z + e[ 13 ] * w;\n\t\tthis.z = e[ 2 ] * x + e[ 6 ] * y + e[ 10 ] * z + e[ 14 ] * w;\n\t\tthis.w = e[ 3 ] * x + e[ 7 ] * y + e[ 11 ] * z + e[ 15 ] * w;\n\n\t\treturn this;\n\n\t}\n\n\tdivideScalar( scalar ) {\n\n\t\treturn this.multiplyScalar( 1 / scalar );\n\n\t}\n\n\tsetAxisAngleFromQuaternion( q ) {\n\n\t\t// http://www.euclideanspace.com/maths/geometry/rotations/conversions/quaternionToAngle/index.htm\n\n\t\t// q is assumed to be normalized\n\n\t\tthis.w = 2 * Math.acos( q.w );\n\n\t\tconst s = Math.sqrt( 1 - q.w * q.w );\n\n\t\tif ( s < 0.0001 ) {\n\n\t\t\tthis.x = 1;\n\t\t\tthis.y = 0;\n\t\t\tthis.z = 0;\n\n\t\t} else {\n\n\t\t\tthis.x = q.x / s;\n\t\t\tthis.y = q.y / s;\n\t\t\tthis.z = q.z / s;\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tsetAxisAngleFromRotationMatrix( m ) {\n\n\t\t// http://www.euclideanspace.com/maths/geometry/rotations/conversions/matrixToAngle/index.htm\n\n\t\t// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)\n\n\t\tlet angle, x, y, z; // variables for result\n\t\tconst epsilon = 0.01,\t\t// margin to allow for rounding errors\n\t\t\tepsilon2 = 0.1,\t\t// margin to distinguish between 0 and 180 degrees\n\n\t\t\tte = m.elements,\n\n\t\t\tm11 = te[ 0 ], m12 = te[ 4 ], m13 = te[ 8 ],\n\t\t\tm21 = te[ 1 ], m22 = te[ 5 ], m23 = te[ 9 ],\n\t\t\tm31 = te[ 2 ], m32 = te[ 6 ], m33 = te[ 10 ];\n\n\t\tif ( ( Math.abs( m12 - m21 ) < epsilon ) &&\n\t\t     ( Math.abs( m13 - m31 ) < epsilon ) &&\n\t\t     ( Math.abs( m23 - m32 ) < epsilon ) ) {\n\n\t\t\t// singularity found\n\t\t\t// first check for identity matrix which must have +1 for all terms\n\t\t\t// in leading diagonal and zero in other terms\n\n\t\t\tif ( ( Math.abs( m12 + m21 ) < epsilon2 ) &&\n\t\t\t     ( Math.abs( m13 + m31 ) < epsilon2 ) &&\n\t\t\t     ( Math.abs( m23 + m32 ) < epsilon2 ) &&\n\t\t\t     ( Math.abs( m11 + m22 + m33 - 3 ) < epsilon2 ) ) {\n\n\t\t\t\t// this singularity is identity matrix so angle = 0\n\n\t\t\t\tthis.set( 1, 0, 0, 0 );\n\n\t\t\t\treturn this; // zero angle, arbitrary axis\n\n\t\t\t}\n\n\t\t\t// otherwise this singularity is angle = 180\n\n\t\t\tangle = Math.PI;\n\n\t\t\tconst xx = ( m11 + 1 ) / 2;\n\t\t\tconst yy = ( m22 + 1 ) / 2;\n\t\t\tconst zz = ( m33 + 1 ) / 2;\n\t\t\tconst xy = ( m12 + m21 ) / 4;\n\t\t\tconst xz = ( m13 + m31 ) / 4;\n\t\t\tconst yz = ( m23 + m32 ) / 4;\n\n\t\t\tif ( ( xx > yy ) && ( xx > zz ) ) {\n\n\t\t\t\t// m11 is the largest diagonal term\n\n\t\t\t\tif ( xx < epsilon ) {\n\n\t\t\t\t\tx = 0;\n\t\t\t\t\ty = 0.707106781;\n\t\t\t\t\tz = 0.707106781;\n\n\t\t\t\t} else {\n\n\t\t\t\t\tx = Math.sqrt( xx );\n\t\t\t\t\ty = xy / x;\n\t\t\t\t\tz = xz / x;\n\n\t\t\t\t}\n\n\t\t\t} else if ( yy > zz ) {\n\n\t\t\t\t// m22 is the largest diagonal term\n\n\t\t\t\tif ( yy < epsilon ) {\n\n\t\t\t\t\tx = 0.707106781;\n\t\t\t\t\ty = 0;\n\t\t\t\t\tz = 0.707106781;\n\n\t\t\t\t} else {\n\n\t\t\t\t\ty = Math.sqrt( yy );\n\t\t\t\t\tx = xy / y;\n\t\t\t\t\tz = yz / y;\n\n\t\t\t\t}\n\n\t\t\t} else {\n\n\t\t\t\t// m33 is the largest diagonal term so base result on this\n\n\t\t\t\tif ( zz < epsilon ) {\n\n\t\t\t\t\tx = 0.707106781;\n\t\t\t\t\ty = 0.707106781;\n\t\t\t\t\tz = 0;\n\n\t\t\t\t} else {\n\n\t\t\t\t\tz = Math.sqrt( zz );\n\t\t\t\t\tx = xz / z;\n\t\t\t\t\ty = yz / z;\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\tthis.set( x, y, z, angle );\n\n\t\t\treturn this; // return 180 deg rotation\n\n\t\t}\n\n\t\t// as we have reached here there are no singularities so we can handle normally\n\n\t\tlet s = Math.sqrt( ( m32 - m23 ) * ( m32 - m23 ) +\n\t\t\t( m13 - m31 ) * ( m13 - m31 ) +\n\t\t\t( m21 - m12 ) * ( m21 - m12 ) ); // used to normalize\n\n\t\tif ( Math.abs( s ) < 0.001 ) s = 1;\n\n\t\t// prevent divide by zero, should not happen if matrix is orthogonal and should be\n\t\t// caught by singularity test above, but I've left it in just in case\n\n\t\tthis.x = ( m32 - m23 ) / s;\n\t\tthis.y = ( m13 - m31 ) / s;\n\t\tthis.z = ( m21 - m12 ) / s;\n\t\tthis.w = Math.acos( ( m11 + m22 + m33 - 1 ) / 2 );\n\n\t\treturn this;\n\n\t}\n\n\tmin( v ) {\n\n\t\tthis.x = Math.min( this.x, v.x );\n\t\tthis.y = Math.min( this.y, v.y );\n\t\tthis.z = Math.min( this.z, v.z );\n\t\tthis.w = Math.min( this.w, v.w );\n\n\t\treturn this;\n\n\t}\n\n\tmax( v ) {\n\n\t\tthis.x = Math.max( this.x, v.x );\n\t\tthis.y = Math.max( this.y, v.y );\n\t\tthis.z = Math.max( this.z, v.z );\n\t\tthis.w = Math.max( this.w, v.w );\n\n\t\treturn this;\n\n\t}\n\n\tclamp( min, max ) {\n\n\t\t// assumes min < max, componentwise\n\n\t\tthis.x = Math.max( min.x, Math.min( max.x, this.x ) );\n\t\tthis.y = Math.max( min.y, Math.min( max.y, this.y ) );\n\t\tthis.z = Math.max( min.z, Math.min( max.z, this.z ) );\n\t\tthis.w = Math.max( min.w, Math.min( max.w, this.w ) );\n\n\t\treturn this;\n\n\t}\n\n\tclampScalar( minVal, maxVal ) {\n\n\t\tthis.x = Math.max( minVal, Math.min( maxVal, this.x ) );\n\t\tthis.y = Math.max( minVal, Math.min( maxVal, this.y ) );\n\t\tthis.z = Math.max( minVal, Math.min( maxVal, this.z ) );\n\t\tthis.w = Math.max( minVal, Math.min( maxVal, this.w ) );\n\n\t\treturn this;\n\n\t}\n\n\tclampLength( min, max ) {\n\n\t\tconst length = this.length();\n\n\t\treturn this.divideScalar( length || 1 ).multiplyScalar( Math.max( min, Math.min( max, length ) ) );\n\n\t}\n\n\tfloor() {\n\n\t\tthis.x = Math.floor( this.x );\n\t\tthis.y = Math.floor( this.y );\n\t\tthis.z = Math.floor( this.z );\n\t\tthis.w = Math.floor( this.w );\n\n\t\treturn this;\n\n\t}\n\n\tceil() {\n\n\t\tthis.x = Math.ceil( this.x );\n\t\tthis.y = Math.ceil( this.y );\n\t\tthis.z = Math.ceil( this.z );\n\t\tthis.w = Math.ceil( this.w );\n\n\t\treturn this;\n\n\t}\n\n\tround() {\n\n\t\tthis.x = Math.round( this.x );\n\t\tthis.y = Math.round( this.y );\n\t\tthis.z = Math.round( this.z );\n\t\tthis.w = Math.round( this.w );\n\n\t\treturn this;\n\n\t}\n\n\troundToZero() {\n\n\t\tthis.x = ( this.x < 0 ) ? Math.ceil( this.x ) : Math.floor( this.x );\n\t\tthis.y = ( this.y < 0 ) ? Math.ceil( this.y ) : Math.floor( this.y );\n\t\tthis.z = ( this.z < 0 ) ? Math.ceil( this.z ) : Math.floor( this.z );\n\t\tthis.w = ( this.w < 0 ) ? Math.ceil( this.w ) : Math.floor( this.w );\n\n\t\treturn this;\n\n\t}\n\n\tnegate() {\n\n\t\tthis.x = - this.x;\n\t\tthis.y = - this.y;\n\t\tthis.z = - this.z;\n\t\tthis.w = - this.w;\n\n\t\treturn this;\n\n\t}\n\n\tdot( v ) {\n\n\t\treturn this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;\n\n\t}\n\n\tlengthSq() {\n\n\t\treturn this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;\n\n\t}\n\n\tlength() {\n\n\t\treturn Math.sqrt( this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w );\n\n\t}\n\n\tmanhattanLength() {\n\n\t\treturn Math.abs( this.x ) + Math.abs( this.y ) + Math.abs( this.z ) + Math.abs( this.w );\n\n\t}\n\n\tnormalize() {\n\n\t\treturn this.divideScalar( this.length() || 1 );\n\n\t}\n\n\tsetLength( length ) {\n\n\t\treturn this.normalize().multiplyScalar( length );\n\n\t}\n\n\tlerp( v, alpha ) {\n\n\t\tthis.x += ( v.x - this.x ) * alpha;\n\t\tthis.y += ( v.y - this.y ) * alpha;\n\t\tthis.z += ( v.z - this.z ) * alpha;\n\t\tthis.w += ( v.w - this.w ) * alpha;\n\n\t\treturn this;\n\n\t}\n\n\tlerpVectors( v1, v2, alpha ) {\n\n\t\tthis.x = v1.x + ( v2.x - v1.x ) * alpha;\n\t\tthis.y = v1.y + ( v2.y - v1.y ) * alpha;\n\t\tthis.z = v1.z + ( v2.z - v1.z ) * alpha;\n\t\tthis.w = v1.w + ( v2.w - v1.w ) * alpha;\n\n\t\treturn this;\n\n\t}\n\n\tequals( v ) {\n\n\t\treturn ( ( v.x === this.x ) && ( v.y === this.y ) && ( v.z === this.z ) && ( v.w === this.w ) );\n\n\t}\n\n\tfromArray( array, offset = 0 ) {\n\n\t\tthis.x = array[ offset ];\n\t\tthis.y = array[ offset + 1 ];\n\t\tthis.z = array[ offset + 2 ];\n\t\tthis.w = array[ offset + 3 ];\n\n\t\treturn this;\n\n\t}\n\n\ttoArray( array = [], offset = 0 ) {\n\n\t\tarray[ offset ] = this.x;\n\t\tarray[ offset + 1 ] = this.y;\n\t\tarray[ offset + 2 ] = this.z;\n\t\tarray[ offset + 3 ] = this.w;\n\n\t\treturn array;\n\n\t}\n\n\tfromBufferAttribute( attribute, index, offset ) {\n\n\t\tif ( offset !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector4: offset has been removed from .fromBufferAttribute().' );\n\n\t\t}\n\n\t\tthis.x = attribute.getX( index );\n\t\tthis.y = attribute.getY( index );\n\t\tthis.z = attribute.getZ( index );\n\t\tthis.w = attribute.getW( index );\n\n\t\treturn this;\n\n\t}\n\n\trandom() {\n\n\t\tthis.x = Math.random();\n\t\tthis.y = Math.random();\n\t\tthis.z = Math.random();\n\t\tthis.w = Math.random();\n\n\t\treturn this;\n\n\t}\n\n}\n\nVector4.prototype.isVector4 = true;\n\n/*\n In options, we can specify:\n * Texture parameters for an auto-generated target texture\n * depthBuffer/stencilBuffer: Booleans to indicate if we should generate these buffers\n*/\nclass WebGLRenderTarget extends EventDispatcher {\n\n\tconstructor( width, height, options ) {\n\n\t\tsuper();\n\n\t\tthis.width = width;\n\t\tthis.height = height;\n\t\tthis.depth = 1;\n\n\t\tthis.scissor = new Vector4( 0, 0, width, height );\n\t\tthis.scissorTest = false;\n\n\t\tthis.viewport = new Vector4( 0, 0, width, height );\n\n\t\toptions = options || {};\n\n\t\tthis.texture = new Texture( undefined, options.mapping, options.wrapS, options.wrapT, options.magFilter, options.minFilter, options.format, options.type, options.anisotropy, options.encoding );\n\n\t\tthis.texture.image = {};\n\t\tthis.texture.image.width = width;\n\t\tthis.texture.image.height = height;\n\t\tthis.texture.image.depth = 1;\n\n\t\tthis.texture.generateMipmaps = options.generateMipmaps !== undefined ? options.generateMipmaps : false;\n\t\tthis.texture.minFilter = options.minFilter !== undefined ? options.minFilter : LinearFilter;\n\n\t\tthis.depthBuffer = options.depthBuffer !== undefined ? options.depthBuffer : true;\n\t\tthis.stencilBuffer = options.stencilBuffer !== undefined ? options.stencilBuffer : false;\n\t\tthis.depthTexture = options.depthTexture !== undefined ? options.depthTexture : null;\n\n\t}\n\n\tsetTexture( texture ) {\n\n\t\ttexture.image = {\n\t\t\twidth: this.width,\n\t\t\theight: this.height,\n\t\t\tdepth: this.depth\n\t\t};\n\n\t\tthis.texture = texture;\n\n\t}\n\n\tsetSize( width, height, depth = 1 ) {\n\n\t\tif ( this.width !== width || this.height !== height || this.depth !== depth ) {\n\n\t\t\tthis.width = width;\n\t\t\tthis.height = height;\n\t\t\tthis.depth = depth;\n\n\t\t\tthis.texture.image.width = width;\n\t\t\tthis.texture.image.height = height;\n\t\t\tthis.texture.image.depth = depth;\n\n\t\t\tthis.dispose();\n\n\t\t}\n\n\t\tthis.viewport.set( 0, 0, width, height );\n\t\tthis.scissor.set( 0, 0, width, height );\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n\tcopy( source ) {\n\n\t\tthis.width = source.width;\n\t\tthis.height = source.height;\n\t\tthis.depth = source.depth;\n\n\t\tthis.viewport.copy( source.viewport );\n\n\t\tthis.texture = source.texture.clone();\n\t\tthis.texture.image = { ...this.texture.image }; // See #20328.\n\n\t\tthis.depthBuffer = source.depthBuffer;\n\t\tthis.stencilBuffer = source.stencilBuffer;\n\t\tthis.depthTexture = source.depthTexture;\n\n\t\treturn this;\n\n\t}\n\n\tdispose() {\n\n\t\tthis.dispatchEvent( { type: 'dispose' } );\n\n\t}\n\n}\n\nWebGLRenderTarget.prototype.isWebGLRenderTarget = true;\n\nclass WebGLMultipleRenderTargets extends WebGLRenderTarget {\n\n\tconstructor( width, height, count ) {\n\n\t\tsuper( width, height );\n\n\t\tconst texture = this.texture;\n\n\t\tthis.texture = [];\n\n\t\tfor ( let i = 0; i < count; i ++ ) {\n\n\t\t\tthis.texture[ i ] = texture.clone();\n\n\t\t}\n\n\t}\n\n\tsetSize( width, height, depth = 1 ) {\n\n\t\tif ( this.width !== width || this.height !== height || this.depth !== depth ) {\n\n\t\t\tthis.width = width;\n\t\t\tthis.height = height;\n\t\t\tthis.depth = depth;\n\n\t\t\tfor ( let i = 0, il = this.texture.length; i < il; i ++ ) {\n\n\t\t\t\tthis.texture[ i ].image.width = width;\n\t\t\t\tthis.texture[ i ].image.height = height;\n\t\t\t\tthis.texture[ i ].image.depth = depth;\n\n\t\t\t}\n\n\t\t\tthis.dispose();\n\n\t\t}\n\n\t\tthis.viewport.set( 0, 0, width, height );\n\t\tthis.scissor.set( 0, 0, width, height );\n\n\t\treturn this;\n\n\t}\n\n\tcopy( source ) {\n\n\t\tthis.dispose();\n\n\t\tthis.width = source.width;\n\t\tthis.height = source.height;\n\t\tthis.depth = source.depth;\n\n\t\tthis.viewport.set( 0, 0, this.width, this.height );\n\t\tthis.scissor.set( 0, 0, this.width, this.height );\n\n\t\tthis.depthBuffer = source.depthBuffer;\n\t\tthis.stencilBuffer = source.stencilBuffer;\n\t\tthis.depthTexture = source.depthTexture;\n\n\t\tthis.texture.length = 0;\n\n\t\tfor ( let i = 0, il = source.texture.length; i < il; i ++ ) {\n\n\t\t\tthis.texture[ i ] = source.texture[ i ].clone();\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n}\n\nWebGLMultipleRenderTargets.prototype.isWebGLMultipleRenderTargets = true;\n\nclass WebGLMultisampleRenderTarget extends WebGLRenderTarget {\n\n\tconstructor( width, height, options ) {\n\n\t\tsuper( width, height, options );\n\n\t\tthis.samples = 4;\n\n\t}\n\n\tcopy( source ) {\n\n\t\tsuper.copy.call( this, source );\n\n\t\tthis.samples = source.samples;\n\n\t\treturn this;\n\n\t}\n\n}\n\nWebGLMultisampleRenderTarget.prototype.isWebGLMultisampleRenderTarget = true;\n\nclass Quaternion {\n\n\tconstructor( x = 0, y = 0, z = 0, w = 1 ) {\n\n\t\tthis._x = x;\n\t\tthis._y = y;\n\t\tthis._z = z;\n\t\tthis._w = w;\n\n\t}\n\n\tstatic slerp( qa, qb, qm, t ) {\n\n\t\tconsole.warn( 'THREE.Quaternion: Static .slerp() has been deprecated. Use qm.slerpQuaternions( qa, qb, t ) instead.' );\n\t\treturn qm.slerpQuaternions( qa, qb, t );\n\n\t}\n\n\tstatic slerpFlat( dst, dstOffset, src0, srcOffset0, src1, srcOffset1, t ) {\n\n\t\t// fuzz-free, array-based Quaternion SLERP operation\n\n\t\tlet x0 = src0[ srcOffset0 + 0 ],\n\t\t\ty0 = src0[ srcOffset0 + 1 ],\n\t\t\tz0 = src0[ srcOffset0 + 2 ],\n\t\t\tw0 = src0[ srcOffset0 + 3 ];\n\n\t\tconst x1 = src1[ srcOffset1 + 0 ],\n\t\t\ty1 = src1[ srcOffset1 + 1 ],\n\t\t\tz1 = src1[ srcOffset1 + 2 ],\n\t\t\tw1 = src1[ srcOffset1 + 3 ];\n\n\t\tif ( t === 0 ) {\n\n\t\t\tdst[ dstOffset + 0 ] = x0;\n\t\t\tdst[ dstOffset + 1 ] = y0;\n\t\t\tdst[ dstOffset + 2 ] = z0;\n\t\t\tdst[ dstOffset + 3 ] = w0;\n\t\t\treturn;\n\n\t\t}\n\n\t\tif ( t === 1 ) {\n\n\t\t\tdst[ dstOffset + 0 ] = x1;\n\t\t\tdst[ dstOffset + 1 ] = y1;\n\t\t\tdst[ dstOffset + 2 ] = z1;\n\t\t\tdst[ dstOffset + 3 ] = w1;\n\t\t\treturn;\n\n\t\t}\n\n\t\tif ( w0 !== w1 || x0 !== x1 || y0 !== y1 || z0 !== z1 ) {\n\n\t\t\tlet s = 1 - t;\n\t\t\tconst cos = x0 * x1 + y0 * y1 + z0 * z1 + w0 * w1,\n\t\t\t\tdir = ( cos >= 0 ? 1 : - 1 ),\n\t\t\t\tsqrSin = 1 - cos * cos;\n\n\t\t\t// Skip the Slerp for tiny steps to avoid numeric problems:\n\t\t\tif ( sqrSin > Number.EPSILON ) {\n\n\t\t\t\tconst sin = Math.sqrt( sqrSin ),\n\t\t\t\t\tlen = Math.atan2( sin, cos * dir );\n\n\t\t\t\ts = Math.sin( s * len ) / sin;\n\t\t\t\tt = Math.sin( t * len ) / sin;\n\n\t\t\t}\n\n\t\t\tconst tDir = t * dir;\n\n\t\t\tx0 = x0 * s + x1 * tDir;\n\t\t\ty0 = y0 * s + y1 * tDir;\n\t\t\tz0 = z0 * s + z1 * tDir;\n\t\t\tw0 = w0 * s + w1 * tDir;\n\n\t\t\t// Normalize in case we just did a lerp:\n\t\t\tif ( s === 1 - t ) {\n\n\t\t\t\tconst f = 1 / Math.sqrt( x0 * x0 + y0 * y0 + z0 * z0 + w0 * w0 );\n\n\t\t\t\tx0 *= f;\n\t\t\t\ty0 *= f;\n\t\t\t\tz0 *= f;\n\t\t\t\tw0 *= f;\n\n\t\t\t}\n\n\t\t}\n\n\t\tdst[ dstOffset ] = x0;\n\t\tdst[ dstOffset + 1 ] = y0;\n\t\tdst[ dstOffset + 2 ] = z0;\n\t\tdst[ dstOffset + 3 ] = w0;\n\n\t}\n\n\tstatic multiplyQuaternionsFlat( dst, dstOffset, src0, srcOffset0, src1, srcOffset1 ) {\n\n\t\tconst x0 = src0[ srcOffset0 ];\n\t\tconst y0 = src0[ srcOffset0 + 1 ];\n\t\tconst z0 = src0[ srcOffset0 + 2 ];\n\t\tconst w0 = src0[ srcOffset0 + 3 ];\n\n\t\tconst x1 = src1[ srcOffset1 ];\n\t\tconst y1 = src1[ srcOffset1 + 1 ];\n\t\tconst z1 = src1[ srcOffset1 + 2 ];\n\t\tconst w1 = src1[ srcOffset1 + 3 ];\n\n\t\tdst[ dstOffset ] = x0 * w1 + w0 * x1 + y0 * z1 - z0 * y1;\n\t\tdst[ dstOffset + 1 ] = y0 * w1 + w0 * y1 + z0 * x1 - x0 * z1;\n\t\tdst[ dstOffset + 2 ] = z0 * w1 + w0 * z1 + x0 * y1 - y0 * x1;\n\t\tdst[ dstOffset + 3 ] = w0 * w1 - x0 * x1 - y0 * y1 - z0 * z1;\n\n\t\treturn dst;\n\n\t}\n\n\tget x() {\n\n\t\treturn this._x;\n\n\t}\n\n\tset x( value ) {\n\n\t\tthis._x = value;\n\t\tthis._onChangeCallback();\n\n\t}\n\n\tget y() {\n\n\t\treturn this._y;\n\n\t}\n\n\tset y( value ) {\n\n\t\tthis._y = value;\n\t\tthis._onChangeCallback();\n\n\t}\n\n\tget z() {\n\n\t\treturn this._z;\n\n\t}\n\n\tset z( value ) {\n\n\t\tthis._z = value;\n\t\tthis._onChangeCallback();\n\n\t}\n\n\tget w() {\n\n\t\treturn this._w;\n\n\t}\n\n\tset w( value ) {\n\n\t\tthis._w = value;\n\t\tthis._onChangeCallback();\n\n\t}\n\n\tset( x, y, z, w ) {\n\n\t\tthis._x = x;\n\t\tthis._y = y;\n\t\tthis._z = z;\n\t\tthis._w = w;\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor( this._x, this._y, this._z, this._w );\n\n\t}\n\n\tcopy( quaternion ) {\n\n\t\tthis._x = quaternion.x;\n\t\tthis._y = quaternion.y;\n\t\tthis._z = quaternion.z;\n\t\tthis._w = quaternion.w;\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tsetFromEuler( euler, update ) {\n\n\t\tif ( ! ( euler && euler.isEuler ) ) {\n\n\t\t\tthrow new Error( 'THREE.Quaternion: .setFromEuler() now expects an Euler rotation rather than a Vector3 and order.' );\n\n\t\t}\n\n\t\tconst x = euler._x, y = euler._y, z = euler._z, order = euler._order;\n\n\t\t// http://www.mathworks.com/matlabcentral/fileexchange/\n\t\t// \t20696-function-to-convert-between-dcm-euler-angles-quaternions-and-euler-vectors/\n\t\t//\tcontent/SpinCalc.m\n\n\t\tconst cos = Math.cos;\n\t\tconst sin = Math.sin;\n\n\t\tconst c1 = cos( x / 2 );\n\t\tconst c2 = cos( y / 2 );\n\t\tconst c3 = cos( z / 2 );\n\n\t\tconst s1 = sin( x / 2 );\n\t\tconst s2 = sin( y / 2 );\n\t\tconst s3 = sin( z / 2 );\n\n\t\tswitch ( order ) {\n\n\t\t\tcase 'XYZ':\n\t\t\t\tthis._x = s1 * c2 * c3 + c1 * s2 * s3;\n\t\t\t\tthis._y = c1 * s2 * c3 - s1 * c2 * s3;\n\t\t\t\tthis._z = c1 * c2 * s3 + s1 * s2 * c3;\n\t\t\t\tthis._w = c1 * c2 * c3 - s1 * s2 * s3;\n\t\t\t\tbreak;\n\n\t\t\tcase 'YXZ':\n\t\t\t\tthis._x = s1 * c2 * c3 + c1 * s2 * s3;\n\t\t\t\tthis._y = c1 * s2 * c3 - s1 * c2 * s3;\n\t\t\t\tthis._z = c1 * c2 * s3 - s1 * s2 * c3;\n\t\t\t\tthis._w = c1 * c2 * c3 + s1 * s2 * s3;\n\t\t\t\tbreak;\n\n\t\t\tcase 'ZXY':\n\t\t\t\tthis._x = s1 * c2 * c3 - c1 * s2 * s3;\n\t\t\t\tthis._y = c1 * s2 * c3 + s1 * c2 * s3;\n\t\t\t\tthis._z = c1 * c2 * s3 + s1 * s2 * c3;\n\t\t\t\tthis._w = c1 * c2 * c3 - s1 * s2 * s3;\n\t\t\t\tbreak;\n\n\t\t\tcase 'ZYX':\n\t\t\t\tthis._x = s1 * c2 * c3 - c1 * s2 * s3;\n\t\t\t\tthis._y = c1 * s2 * c3 + s1 * c2 * s3;\n\t\t\t\tthis._z = c1 * c2 * s3 - s1 * s2 * c3;\n\t\t\t\tthis._w = c1 * c2 * c3 + s1 * s2 * s3;\n\t\t\t\tbreak;\n\n\t\t\tcase 'YZX':\n\t\t\t\tthis._x = s1 * c2 * c3 + c1 * s2 * s3;\n\t\t\t\tthis._y = c1 * s2 * c3 + s1 * c2 * s3;\n\t\t\t\tthis._z = c1 * c2 * s3 - s1 * s2 * c3;\n\t\t\t\tthis._w = c1 * c2 * c3 - s1 * s2 * s3;\n\t\t\t\tbreak;\n\n\t\t\tcase 'XZY':\n\t\t\t\tthis._x = s1 * c2 * c3 - c1 * s2 * s3;\n\t\t\t\tthis._y = c1 * s2 * c3 - s1 * c2 * s3;\n\t\t\t\tthis._z = c1 * c2 * s3 + s1 * s2 * c3;\n\t\t\t\tthis._w = c1 * c2 * c3 + s1 * s2 * s3;\n\t\t\t\tbreak;\n\n\t\t\tdefault:\n\t\t\t\tconsole.warn( 'THREE.Quaternion: .setFromEuler() encountered an unknown order: ' + order );\n\n\t\t}\n\n\t\tif ( update !== false ) this._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tsetFromAxisAngle( axis, angle ) {\n\n\t\t// http://www.euclideanspace.com/maths/geometry/rotations/conversions/angleToQuaternion/index.htm\n\n\t\t// assumes axis is normalized\n\n\t\tconst halfAngle = angle / 2, s = Math.sin( halfAngle );\n\n\t\tthis._x = axis.x * s;\n\t\tthis._y = axis.y * s;\n\t\tthis._z = axis.z * s;\n\t\tthis._w = Math.cos( halfAngle );\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tsetFromRotationMatrix( m ) {\n\n\t\t// http://www.euclideanspace.com/maths/geometry/rotations/conversions/matrixToQuaternion/index.htm\n\n\t\t// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)\n\n\t\tconst te = m.elements,\n\n\t\t\tm11 = te[ 0 ], m12 = te[ 4 ], m13 = te[ 8 ],\n\t\t\tm21 = te[ 1 ], m22 = te[ 5 ], m23 = te[ 9 ],\n\t\t\tm31 = te[ 2 ], m32 = te[ 6 ], m33 = te[ 10 ],\n\n\t\t\ttrace = m11 + m22 + m33;\n\n\t\tif ( trace > 0 ) {\n\n\t\t\tconst s = 0.5 / Math.sqrt( trace + 1.0 );\n\n\t\t\tthis._w = 0.25 / s;\n\t\t\tthis._x = ( m32 - m23 ) * s;\n\t\t\tthis._y = ( m13 - m31 ) * s;\n\t\t\tthis._z = ( m21 - m12 ) * s;\n\n\t\t} else if ( m11 > m22 && m11 > m33 ) {\n\n\t\t\tconst s = 2.0 * Math.sqrt( 1.0 + m11 - m22 - m33 );\n\n\t\t\tthis._w = ( m32 - m23 ) / s;\n\t\t\tthis._x = 0.25 * s;\n\t\t\tthis._y = ( m12 + m21 ) / s;\n\t\t\tthis._z = ( m13 + m31 ) / s;\n\n\t\t} else if ( m22 > m33 ) {\n\n\t\t\tconst s = 2.0 * Math.sqrt( 1.0 + m22 - m11 - m33 );\n\n\t\t\tthis._w = ( m13 - m31 ) / s;\n\t\t\tthis._x = ( m12 + m21 ) / s;\n\t\t\tthis._y = 0.25 * s;\n\t\t\tthis._z = ( m23 + m32 ) / s;\n\n\t\t} else {\n\n\t\t\tconst s = 2.0 * Math.sqrt( 1.0 + m33 - m11 - m22 );\n\n\t\t\tthis._w = ( m21 - m12 ) / s;\n\t\t\tthis._x = ( m13 + m31 ) / s;\n\t\t\tthis._y = ( m23 + m32 ) / s;\n\t\t\tthis._z = 0.25 * s;\n\n\t\t}\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tsetFromUnitVectors( vFrom, vTo ) {\n\n\t\t// assumes direction vectors vFrom and vTo are normalized\n\n\t\tlet r = vFrom.dot( vTo ) + 1;\n\n\t\tif ( r < Number.EPSILON ) {\n\n\t\t\t// vFrom and vTo point in opposite directions\n\n\t\t\tr = 0;\n\n\t\t\tif ( Math.abs( vFrom.x ) > Math.abs( vFrom.z ) ) {\n\n\t\t\t\tthis._x = - vFrom.y;\n\t\t\t\tthis._y = vFrom.x;\n\t\t\t\tthis._z = 0;\n\t\t\t\tthis._w = r;\n\n\t\t\t} else {\n\n\t\t\t\tthis._x = 0;\n\t\t\t\tthis._y = - vFrom.z;\n\t\t\t\tthis._z = vFrom.y;\n\t\t\t\tthis._w = r;\n\n\t\t\t}\n\n\t\t} else {\n\n\t\t\t// crossVectors( vFrom, vTo ); // inlined to avoid cyclic dependency on Vector3\n\n\t\t\tthis._x = vFrom.y * vTo.z - vFrom.z * vTo.y;\n\t\t\tthis._y = vFrom.z * vTo.x - vFrom.x * vTo.z;\n\t\t\tthis._z = vFrom.x * vTo.y - vFrom.y * vTo.x;\n\t\t\tthis._w = r;\n\n\t\t}\n\n\t\treturn this.normalize();\n\n\t}\n\n\tangleTo( q ) {\n\n\t\treturn 2 * Math.acos( Math.abs( clamp( this.dot( q ), - 1, 1 ) ) );\n\n\t}\n\n\trotateTowards( q, step ) {\n\n\t\tconst angle = this.angleTo( q );\n\n\t\tif ( angle === 0 ) return this;\n\n\t\tconst t = Math.min( 1, step / angle );\n\n\t\tthis.slerp( q, t );\n\n\t\treturn this;\n\n\t}\n\n\tidentity() {\n\n\t\treturn this.set( 0, 0, 0, 1 );\n\n\t}\n\n\tinvert() {\n\n\t\t// quaternion is assumed to have unit length\n\n\t\treturn this.conjugate();\n\n\t}\n\n\tconjugate() {\n\n\t\tthis._x *= - 1;\n\t\tthis._y *= - 1;\n\t\tthis._z *= - 1;\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tdot( v ) {\n\n\t\treturn this._x * v._x + this._y * v._y + this._z * v._z + this._w * v._w;\n\n\t}\n\n\tlengthSq() {\n\n\t\treturn this._x * this._x + this._y * this._y + this._z * this._z + this._w * this._w;\n\n\t}\n\n\tlength() {\n\n\t\treturn Math.sqrt( this._x * this._x + this._y * this._y + this._z * this._z + this._w * this._w );\n\n\t}\n\n\tnormalize() {\n\n\t\tlet l = this.length();\n\n\t\tif ( l === 0 ) {\n\n\t\t\tthis._x = 0;\n\t\t\tthis._y = 0;\n\t\t\tthis._z = 0;\n\t\t\tthis._w = 1;\n\n\t\t} else {\n\n\t\t\tl = 1 / l;\n\n\t\t\tthis._x = this._x * l;\n\t\t\tthis._y = this._y * l;\n\t\t\tthis._z = this._z * l;\n\t\t\tthis._w = this._w * l;\n\n\t\t}\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tmultiply( q, p ) {\n\n\t\tif ( p !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead.' );\n\t\t\treturn this.multiplyQuaternions( q, p );\n\n\t\t}\n\n\t\treturn this.multiplyQuaternions( this, q );\n\n\t}\n\n\tpremultiply( q ) {\n\n\t\treturn this.multiplyQuaternions( q, this );\n\n\t}\n\n\tmultiplyQuaternions( a, b ) {\n\n\t\t// from http://www.euclideanspace.com/maths/algebra/realNormedAlgebra/quaternions/code/index.htm\n\n\t\tconst qax = a._x, qay = a._y, qaz = a._z, qaw = a._w;\n\t\tconst qbx = b._x, qby = b._y, qbz = b._z, qbw = b._w;\n\n\t\tthis._x = qax * qbw + qaw * qbx + qay * qbz - qaz * qby;\n\t\tthis._y = qay * qbw + qaw * qby + qaz * qbx - qax * qbz;\n\t\tthis._z = qaz * qbw + qaw * qbz + qax * qby - qay * qbx;\n\t\tthis._w = qaw * qbw - qax * qbx - qay * qby - qaz * qbz;\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tslerp( qb, t ) {\n\n\t\tif ( t === 0 ) return this;\n\t\tif ( t === 1 ) return this.copy( qb );\n\n\t\tconst x = this._x, y = this._y, z = this._z, w = this._w;\n\n\t\t// http://www.euclideanspace.com/maths/algebra/realNormedAlgebra/quaternions/slerp/\n\n\t\tlet cosHalfTheta = w * qb._w + x * qb._x + y * qb._y + z * qb._z;\n\n\t\tif ( cosHalfTheta < 0 ) {\n\n\t\t\tthis._w = - qb._w;\n\t\t\tthis._x = - qb._x;\n\t\t\tthis._y = - qb._y;\n\t\t\tthis._z = - qb._z;\n\n\t\t\tcosHalfTheta = - cosHalfTheta;\n\n\t\t} else {\n\n\t\t\tthis.copy( qb );\n\n\t\t}\n\n\t\tif ( cosHalfTheta >= 1.0 ) {\n\n\t\t\tthis._w = w;\n\t\t\tthis._x = x;\n\t\t\tthis._y = y;\n\t\t\tthis._z = z;\n\n\t\t\treturn this;\n\n\t\t}\n\n\t\tconst sqrSinHalfTheta = 1.0 - cosHalfTheta * cosHalfTheta;\n\n\t\tif ( sqrSinHalfTheta <= Number.EPSILON ) {\n\n\t\t\tconst s = 1 - t;\n\t\t\tthis._w = s * w + t * this._w;\n\t\t\tthis._x = s * x + t * this._x;\n\t\t\tthis._y = s * y + t * this._y;\n\t\t\tthis._z = s * z + t * this._z;\n\n\t\t\tthis.normalize();\n\t\t\tthis._onChangeCallback();\n\n\t\t\treturn this;\n\n\t\t}\n\n\t\tconst sinHalfTheta = Math.sqrt( sqrSinHalfTheta );\n\t\tconst halfTheta = Math.atan2( sinHalfTheta, cosHalfTheta );\n\t\tconst ratioA = Math.sin( ( 1 - t ) * halfTheta ) / sinHalfTheta,\n\t\t\tratioB = Math.sin( t * halfTheta ) / sinHalfTheta;\n\n\t\tthis._w = ( w * ratioA + this._w * ratioB );\n\t\tthis._x = ( x * ratioA + this._x * ratioB );\n\t\tthis._y = ( y * ratioA + this._y * ratioB );\n\t\tthis._z = ( z * ratioA + this._z * ratioB );\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tslerpQuaternions( qa, qb, t ) {\n\n\t\tthis.copy( qa ).slerp( qb, t );\n\n\t}\n\n\tequals( quaternion ) {\n\n\t\treturn ( quaternion._x === this._x ) && ( quaternion._y === this._y ) && ( quaternion._z === this._z ) && ( quaternion._w === this._w );\n\n\t}\n\n\tfromArray( array, offset = 0 ) {\n\n\t\tthis._x = array[ offset ];\n\t\tthis._y = array[ offset + 1 ];\n\t\tthis._z = array[ offset + 2 ];\n\t\tthis._w = array[ offset + 3 ];\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\ttoArray( array = [], offset = 0 ) {\n\n\t\tarray[ offset ] = this._x;\n\t\tarray[ offset + 1 ] = this._y;\n\t\tarray[ offset + 2 ] = this._z;\n\t\tarray[ offset + 3 ] = this._w;\n\n\t\treturn array;\n\n\t}\n\n\tfromBufferAttribute( attribute, index ) {\n\n\t\tthis._x = attribute.getX( index );\n\t\tthis._y = attribute.getY( index );\n\t\tthis._z = attribute.getZ( index );\n\t\tthis._w = attribute.getW( index );\n\n\t\treturn this;\n\n\t}\n\n\t_onChange( callback ) {\n\n\t\tthis._onChangeCallback = callback;\n\n\t\treturn this;\n\n\t}\n\n\t_onChangeCallback() {}\n\n}\n\nQuaternion.prototype.isQuaternion = true;\n\nclass Vector3 {\n\n\tconstructor( x = 0, y = 0, z = 0 ) {\n\n\t\tthis.x = x;\n\t\tthis.y = y;\n\t\tthis.z = z;\n\n\t}\n\n\tset( x, y, z ) {\n\n\t\tif ( z === undefined ) z = this.z; // sprite.scale.set(x,y)\n\n\t\tthis.x = x;\n\t\tthis.y = y;\n\t\tthis.z = z;\n\n\t\treturn this;\n\n\t}\n\n\tsetScalar( scalar ) {\n\n\t\tthis.x = scalar;\n\t\tthis.y = scalar;\n\t\tthis.z = scalar;\n\n\t\treturn this;\n\n\t}\n\n\tsetX( x ) {\n\n\t\tthis.x = x;\n\n\t\treturn this;\n\n\t}\n\n\tsetY( y ) {\n\n\t\tthis.y = y;\n\n\t\treturn this;\n\n\t}\n\n\tsetZ( z ) {\n\n\t\tthis.z = z;\n\n\t\treturn this;\n\n\t}\n\n\tsetComponent( index, value ) {\n\n\t\tswitch ( index ) {\n\n\t\t\tcase 0: this.x = value; break;\n\t\t\tcase 1: this.y = value; break;\n\t\t\tcase 2: this.z = value; break;\n\t\t\tdefault: throw new Error( 'index is out of range: ' + index );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tgetComponent( index ) {\n\n\t\tswitch ( index ) {\n\n\t\t\tcase 0: return this.x;\n\t\t\tcase 1: return this.y;\n\t\t\tcase 2: return this.z;\n\t\t\tdefault: throw new Error( 'index is out of range: ' + index );\n\n\t\t}\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor( this.x, this.y, this.z );\n\n\t}\n\n\tcopy( v ) {\n\n\t\tthis.x = v.x;\n\t\tthis.y = v.y;\n\t\tthis.z = v.z;\n\n\t\treturn this;\n\n\t}\n\n\tadd( v, w ) {\n\n\t\tif ( w !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead.' );\n\t\t\treturn this.addVectors( v, w );\n\n\t\t}\n\n\t\tthis.x += v.x;\n\t\tthis.y += v.y;\n\t\tthis.z += v.z;\n\n\t\treturn this;\n\n\t}\n\n\taddScalar( s ) {\n\n\t\tthis.x += s;\n\t\tthis.y += s;\n\t\tthis.z += s;\n\n\t\treturn this;\n\n\t}\n\n\taddVectors( a, b ) {\n\n\t\tthis.x = a.x + b.x;\n\t\tthis.y = a.y + b.y;\n\t\tthis.z = a.z + b.z;\n\n\t\treturn this;\n\n\t}\n\n\taddScaledVector( v, s ) {\n\n\t\tthis.x += v.x * s;\n\t\tthis.y += v.y * s;\n\t\tthis.z += v.z * s;\n\n\t\treturn this;\n\n\t}\n\n\tsub( v, w ) {\n\n\t\tif ( w !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead.' );\n\t\t\treturn this.subVectors( v, w );\n\n\t\t}\n\n\t\tthis.x -= v.x;\n\t\tthis.y -= v.y;\n\t\tthis.z -= v.z;\n\n\t\treturn this;\n\n\t}\n\n\tsubScalar( s ) {\n\n\t\tthis.x -= s;\n\t\tthis.y -= s;\n\t\tthis.z -= s;\n\n\t\treturn this;\n\n\t}\n\n\tsubVectors( a, b ) {\n\n\t\tthis.x = a.x - b.x;\n\t\tthis.y = a.y - b.y;\n\t\tthis.z = a.z - b.z;\n\n\t\treturn this;\n\n\t}\n\n\tmultiply( v, w ) {\n\n\t\tif ( w !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead.' );\n\t\t\treturn this.multiplyVectors( v, w );\n\n\t\t}\n\n\t\tthis.x *= v.x;\n\t\tthis.y *= v.y;\n\t\tthis.z *= v.z;\n\n\t\treturn this;\n\n\t}\n\n\tmultiplyScalar( scalar ) {\n\n\t\tthis.x *= scalar;\n\t\tthis.y *= scalar;\n\t\tthis.z *= scalar;\n\n\t\treturn this;\n\n\t}\n\n\tmultiplyVectors( a, b ) {\n\n\t\tthis.x = a.x * b.x;\n\t\tthis.y = a.y * b.y;\n\t\tthis.z = a.z * b.z;\n\n\t\treturn this;\n\n\t}\n\n\tapplyEuler( euler ) {\n\n\t\tif ( ! ( euler && euler.isEuler ) ) {\n\n\t\t\tconsole.error( 'THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order.' );\n\n\t\t}\n\n\t\treturn this.applyQuaternion( _quaternion$4.setFromEuler( euler ) );\n\n\t}\n\n\tapplyAxisAngle( axis, angle ) {\n\n\t\treturn this.applyQuaternion( _quaternion$4.setFromAxisAngle( axis, angle ) );\n\n\t}\n\n\tapplyMatrix3( m ) {\n\n\t\tconst x = this.x, y = this.y, z = this.z;\n\t\tconst e = m.elements;\n\n\t\tthis.x = e[ 0 ] * x + e[ 3 ] * y + e[ 6 ] * z;\n\t\tthis.y = e[ 1 ] * x + e[ 4 ] * y + e[ 7 ] * z;\n\t\tthis.z = e[ 2 ] * x + e[ 5 ] * y + e[ 8 ] * z;\n\n\t\treturn this;\n\n\t}\n\n\tapplyNormalMatrix( m ) {\n\n\t\treturn this.applyMatrix3( m ).normalize();\n\n\t}\n\n\tapplyMatrix4( m ) {\n\n\t\tconst x = this.x, y = this.y, z = this.z;\n\t\tconst e = m.elements;\n\n\t\tconst w = 1 / ( e[ 3 ] * x + e[ 7 ] * y + e[ 11 ] * z + e[ 15 ] );\n\n\t\tthis.x = ( e[ 0 ] * x + e[ 4 ] * y + e[ 8 ] * z + e[ 12 ] ) * w;\n\t\tthis.y = ( e[ 1 ] * x + e[ 5 ] * y + e[ 9 ] * z + e[ 13 ] ) * w;\n\t\tthis.z = ( e[ 2 ] * x + e[ 6 ] * y + e[ 10 ] * z + e[ 14 ] ) * w;\n\n\t\treturn this;\n\n\t}\n\n\tapplyQuaternion( q ) {\n\n\t\tconst x = this.x, y = this.y, z = this.z;\n\t\tconst qx = q.x, qy = q.y, qz = q.z, qw = q.w;\n\n\t\t// calculate quat * vector\n\n\t\tconst ix = qw * x + qy * z - qz * y;\n\t\tconst iy = qw * y + qz * x - qx * z;\n\t\tconst iz = qw * z + qx * y - qy * x;\n\t\tconst iw = - qx * x - qy * y - qz * z;\n\n\t\t// calculate result * inverse quat\n\n\t\tthis.x = ix * qw + iw * - qx + iy * - qz - iz * - qy;\n\t\tthis.y = iy * qw + iw * - qy + iz * - qx - ix * - qz;\n\t\tthis.z = iz * qw + iw * - qz + ix * - qy - iy * - qx;\n\n\t\treturn this;\n\n\t}\n\n\tproject( camera ) {\n\n\t\treturn this.applyMatrix4( camera.matrixWorldInverse ).applyMatrix4( camera.projectionMatrix );\n\n\t}\n\n\tunproject( camera ) {\n\n\t\treturn this.applyMatrix4( camera.projectionMatrixInverse ).applyMatrix4( camera.matrixWorld );\n\n\t}\n\n\ttransformDirection( m ) {\n\n\t\t// input: THREE.Matrix4 affine matrix\n\t\t// vector interpreted as a direction\n\n\t\tconst x = this.x, y = this.y, z = this.z;\n\t\tconst e = m.elements;\n\n\t\tthis.x = e[ 0 ] * x + e[ 4 ] * y + e[ 8 ] * z;\n\t\tthis.y = e[ 1 ] * x + e[ 5 ] * y + e[ 9 ] * z;\n\t\tthis.z = e[ 2 ] * x + e[ 6 ] * y + e[ 10 ] * z;\n\n\t\treturn this.normalize();\n\n\t}\n\n\tdivide( v ) {\n\n\t\tthis.x /= v.x;\n\t\tthis.y /= v.y;\n\t\tthis.z /= v.z;\n\n\t\treturn this;\n\n\t}\n\n\tdivideScalar( scalar ) {\n\n\t\treturn this.multiplyScalar( 1 / scalar );\n\n\t}\n\n\tmin( v ) {\n\n\t\tthis.x = Math.min( this.x, v.x );\n\t\tthis.y = Math.min( this.y, v.y );\n\t\tthis.z = Math.min( this.z, v.z );\n\n\t\treturn this;\n\n\t}\n\n\tmax( v ) {\n\n\t\tthis.x = Math.max( this.x, v.x );\n\t\tthis.y = Math.max( this.y, v.y );\n\t\tthis.z = Math.max( this.z, v.z );\n\n\t\treturn this;\n\n\t}\n\n\tclamp( min, max ) {\n\n\t\t// assumes min < max, componentwise\n\n\t\tthis.x = Math.max( min.x, Math.min( max.x, this.x ) );\n\t\tthis.y = Math.max( min.y, Math.min( max.y, this.y ) );\n\t\tthis.z = Math.max( min.z, Math.min( max.z, this.z ) );\n\n\t\treturn this;\n\n\t}\n\n\tclampScalar( minVal, maxVal ) {\n\n\t\tthis.x = Math.max( minVal, Math.min( maxVal, this.x ) );\n\t\tthis.y = Math.max( minVal, Math.min( maxVal, this.y ) );\n\t\tthis.z = Math.max( minVal, Math.min( maxVal, this.z ) );\n\n\t\treturn this;\n\n\t}\n\n\tclampLength( min, max ) {\n\n\t\tconst length = this.length();\n\n\t\treturn this.divideScalar( length || 1 ).multiplyScalar( Math.max( min, Math.min( max, length ) ) );\n\n\t}\n\n\tfloor() {\n\n\t\tthis.x = Math.floor( this.x );\n\t\tthis.y = Math.floor( this.y );\n\t\tthis.z = Math.floor( this.z );\n\n\t\treturn this;\n\n\t}\n\n\tceil() {\n\n\t\tthis.x = Math.ceil( this.x );\n\t\tthis.y = Math.ceil( this.y );\n\t\tthis.z = Math.ceil( this.z );\n\n\t\treturn this;\n\n\t}\n\n\tround() {\n\n\t\tthis.x = Math.round( this.x );\n\t\tthis.y = Math.round( this.y );\n\t\tthis.z = Math.round( this.z );\n\n\t\treturn this;\n\n\t}\n\n\troundToZero() {\n\n\t\tthis.x = ( this.x < 0 ) ? Math.ceil( this.x ) : Math.floor( this.x );\n\t\tthis.y = ( this.y < 0 ) ? Math.ceil( this.y ) : Math.floor( this.y );\n\t\tthis.z = ( this.z < 0 ) ? Math.ceil( this.z ) : Math.floor( this.z );\n\n\t\treturn this;\n\n\t}\n\n\tnegate() {\n\n\t\tthis.x = - this.x;\n\t\tthis.y = - this.y;\n\t\tthis.z = - this.z;\n\n\t\treturn this;\n\n\t}\n\n\tdot( v ) {\n\n\t\treturn this.x * v.x + this.y * v.y + this.z * v.z;\n\n\t}\n\n\t// TODO lengthSquared?\n\n\tlengthSq() {\n\n\t\treturn this.x * this.x + this.y * this.y + this.z * this.z;\n\n\t}\n\n\tlength() {\n\n\t\treturn Math.sqrt( this.x * this.x + this.y * this.y + this.z * this.z );\n\n\t}\n\n\tmanhattanLength() {\n\n\t\treturn Math.abs( this.x ) + Math.abs( this.y ) + Math.abs( this.z );\n\n\t}\n\n\tnormalize() {\n\n\t\treturn this.divideScalar( this.length() || 1 );\n\n\t}\n\n\tsetLength( length ) {\n\n\t\treturn this.normalize().multiplyScalar( length );\n\n\t}\n\n\tlerp( v, alpha ) {\n\n\t\tthis.x += ( v.x - this.x ) * alpha;\n\t\tthis.y += ( v.y - this.y ) * alpha;\n\t\tthis.z += ( v.z - this.z ) * alpha;\n\n\t\treturn this;\n\n\t}\n\n\tlerpVectors( v1, v2, alpha ) {\n\n\t\tthis.x = v1.x + ( v2.x - v1.x ) * alpha;\n\t\tthis.y = v1.y + ( v2.y - v1.y ) * alpha;\n\t\tthis.z = v1.z + ( v2.z - v1.z ) * alpha;\n\n\t\treturn this;\n\n\t}\n\n\tcross( v, w ) {\n\n\t\tif ( w !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead.' );\n\t\t\treturn this.crossVectors( v, w );\n\n\t\t}\n\n\t\treturn this.crossVectors( this, v );\n\n\t}\n\n\tcrossVectors( a, b ) {\n\n\t\tconst ax = a.x, ay = a.y, az = a.z;\n\t\tconst bx = b.x, by = b.y, bz = b.z;\n\n\t\tthis.x = ay * bz - az * by;\n\t\tthis.y = az * bx - ax * bz;\n\t\tthis.z = ax * by - ay * bx;\n\n\t\treturn this;\n\n\t}\n\n\tprojectOnVector( v ) {\n\n\t\tconst denominator = v.lengthSq();\n\n\t\tif ( denominator === 0 ) return this.set( 0, 0, 0 );\n\n\t\tconst scalar = v.dot( this ) / denominator;\n\n\t\treturn this.copy( v ).multiplyScalar( scalar );\n\n\t}\n\n\tprojectOnPlane( planeNormal ) {\n\n\t\t_vector$c.copy( this ).projectOnVector( planeNormal );\n\n\t\treturn this.sub( _vector$c );\n\n\t}\n\n\treflect( normal ) {\n\n\t\t// reflect incident vector off plane orthogonal to normal\n\t\t// normal is assumed to have unit length\n\n\t\treturn this.sub( _vector$c.copy( normal ).multiplyScalar( 2 * this.dot( normal ) ) );\n\n\t}\n\n\tangleTo( v ) {\n\n\t\tconst denominator = Math.sqrt( this.lengthSq() * v.lengthSq() );\n\n\t\tif ( denominator === 0 ) return Math.PI / 2;\n\n\t\tconst theta = this.dot( v ) / denominator;\n\n\t\t// clamp, to handle numerical problems\n\n\t\treturn Math.acos( clamp( theta, - 1, 1 ) );\n\n\t}\n\n\tdistanceTo( v ) {\n\n\t\treturn Math.sqrt( this.distanceToSquared( v ) );\n\n\t}\n\n\tdistanceToSquared( v ) {\n\n\t\tconst dx = this.x - v.x, dy = this.y - v.y, dz = this.z - v.z;\n\n\t\treturn dx * dx + dy * dy + dz * dz;\n\n\t}\n\n\tmanhattanDistanceTo( v ) {\n\n\t\treturn Math.abs( this.x - v.x ) + Math.abs( this.y - v.y ) + Math.abs( this.z - v.z );\n\n\t}\n\n\tsetFromSpherical( s ) {\n\n\t\treturn this.setFromSphericalCoords( s.radius, s.phi, s.theta );\n\n\t}\n\n\tsetFromSphericalCoords( radius, phi, theta ) {\n\n\t\tconst sinPhiRadius = Math.sin( phi ) * radius;\n\n\t\tthis.x = sinPhiRadius * Math.sin( theta );\n\t\tthis.y = Math.cos( phi ) * radius;\n\t\tthis.z = sinPhiRadius * Math.cos( theta );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromCylindrical( c ) {\n\n\t\treturn this.setFromCylindricalCoords( c.radius, c.theta, c.y );\n\n\t}\n\n\tsetFromCylindricalCoords( radius, theta, y ) {\n\n\t\tthis.x = radius * Math.sin( theta );\n\t\tthis.y = y;\n\t\tthis.z = radius * Math.cos( theta );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromMatrixPosition( m ) {\n\n\t\tconst e = m.elements;\n\n\t\tthis.x = e[ 12 ];\n\t\tthis.y = e[ 13 ];\n\t\tthis.z = e[ 14 ];\n\n\t\treturn this;\n\n\t}\n\n\tsetFromMatrixScale( m ) {\n\n\t\tconst sx = this.setFromMatrixColumn( m, 0 ).length();\n\t\tconst sy = this.setFromMatrixColumn( m, 1 ).length();\n\t\tconst sz = this.setFromMatrixColumn( m, 2 ).length();\n\n\t\tthis.x = sx;\n\t\tthis.y = sy;\n\t\tthis.z = sz;\n\n\t\treturn this;\n\n\t}\n\n\tsetFromMatrixColumn( m, index ) {\n\n\t\treturn this.fromArray( m.elements, index * 4 );\n\n\t}\n\n\tsetFromMatrix3Column( m, index ) {\n\n\t\treturn this.fromArray( m.elements, index * 3 );\n\n\t}\n\n\tequals( v ) {\n\n\t\treturn ( ( v.x === this.x ) && ( v.y === this.y ) && ( v.z === this.z ) );\n\n\t}\n\n\tfromArray( array, offset = 0 ) {\n\n\t\tthis.x = array[ offset ];\n\t\tthis.y = array[ offset + 1 ];\n\t\tthis.z = array[ offset + 2 ];\n\n\t\treturn this;\n\n\t}\n\n\ttoArray( array = [], offset = 0 ) {\n\n\t\tarray[ offset ] = this.x;\n\t\tarray[ offset + 1 ] = this.y;\n\t\tarray[ offset + 2 ] = this.z;\n\n\t\treturn array;\n\n\t}\n\n\tfromBufferAttribute( attribute, index, offset ) {\n\n\t\tif ( offset !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Vector3: offset has been removed from .fromBufferAttribute().' );\n\n\t\t}\n\n\t\tthis.x = attribute.getX( index );\n\t\tthis.y = attribute.getY( index );\n\t\tthis.z = attribute.getZ( index );\n\n\t\treturn this;\n\n\t}\n\n\trandom() {\n\n\t\tthis.x = Math.random();\n\t\tthis.y = Math.random();\n\t\tthis.z = Math.random();\n\n\t\treturn this;\n\n\t}\n\n}\n\nVector3.prototype.isVector3 = true;\n\nconst _vector$c = /*@__PURE__*/ new Vector3();\nconst _quaternion$4 = /*@__PURE__*/ new Quaternion();\n\nclass Box3 {\n\n\tconstructor( min = new Vector3( + Infinity, + Infinity, + Infinity ), max = new Vector3( - Infinity, - Infinity, - Infinity ) ) {\n\n\t\tthis.min = min;\n\t\tthis.max = max;\n\n\t}\n\n\tset( min, max ) {\n\n\t\tthis.min.copy( min );\n\t\tthis.max.copy( max );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromArray( array ) {\n\n\t\tlet minX = + Infinity;\n\t\tlet minY = + Infinity;\n\t\tlet minZ = + Infinity;\n\n\t\tlet maxX = - Infinity;\n\t\tlet maxY = - Infinity;\n\t\tlet maxZ = - Infinity;\n\n\t\tfor ( let i = 0, l = array.length; i < l; i += 3 ) {\n\n\t\t\tconst x = array[ i ];\n\t\t\tconst y = array[ i + 1 ];\n\t\t\tconst z = array[ i + 2 ];\n\n\t\t\tif ( x < minX ) minX = x;\n\t\t\tif ( y < minY ) minY = y;\n\t\t\tif ( z < minZ ) minZ = z;\n\n\t\t\tif ( x > maxX ) maxX = x;\n\t\t\tif ( y > maxY ) maxY = y;\n\t\t\tif ( z > maxZ ) maxZ = z;\n\n\t\t}\n\n\t\tthis.min.set( minX, minY, minZ );\n\t\tthis.max.set( maxX, maxY, maxZ );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromBufferAttribute( attribute ) {\n\n\t\tlet minX = + Infinity;\n\t\tlet minY = + Infinity;\n\t\tlet minZ = + Infinity;\n\n\t\tlet maxX = - Infinity;\n\t\tlet maxY = - Infinity;\n\t\tlet maxZ = - Infinity;\n\n\t\tfor ( let i = 0, l = attribute.count; i < l; i ++ ) {\n\n\t\t\tconst x = attribute.getX( i );\n\t\t\tconst y = attribute.getY( i );\n\t\t\tconst z = attribute.getZ( i );\n\n\t\t\tif ( x < minX ) minX = x;\n\t\t\tif ( y < minY ) minY = y;\n\t\t\tif ( z < minZ ) minZ = z;\n\n\t\t\tif ( x > maxX ) maxX = x;\n\t\t\tif ( y > maxY ) maxY = y;\n\t\t\tif ( z > maxZ ) maxZ = z;\n\n\t\t}\n\n\t\tthis.min.set( minX, minY, minZ );\n\t\tthis.max.set( maxX, maxY, maxZ );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromPoints( points ) {\n\n\t\tthis.makeEmpty();\n\n\t\tfor ( let i = 0, il = points.length; i < il; i ++ ) {\n\n\t\t\tthis.expandByPoint( points[ i ] );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tsetFromCenterAndSize( center, size ) {\n\n\t\tconst halfSize = _vector$b.copy( size ).multiplyScalar( 0.5 );\n\n\t\tthis.min.copy( center ).sub( halfSize );\n\t\tthis.max.copy( center ).add( halfSize );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromObject( object ) {\n\n\t\tthis.makeEmpty();\n\n\t\treturn this.expandByObject( object );\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n\tcopy( box ) {\n\n\t\tthis.min.copy( box.min );\n\t\tthis.max.copy( box.max );\n\n\t\treturn this;\n\n\t}\n\n\tmakeEmpty() {\n\n\t\tthis.min.x = this.min.y = this.min.z = + Infinity;\n\t\tthis.max.x = this.max.y = this.max.z = - Infinity;\n\n\t\treturn this;\n\n\t}\n\n\tisEmpty() {\n\n\t\t// this is a more robust check for empty than ( volume <= 0 ) because volume can get positive with two negative axes\n\n\t\treturn ( this.max.x < this.min.x ) || ( this.max.y < this.min.y ) || ( this.max.z < this.min.z );\n\n\t}\n\n\tgetCenter( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Box3: .getCenter() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\treturn this.isEmpty() ? target.set( 0, 0, 0 ) : target.addVectors( this.min, this.max ).multiplyScalar( 0.5 );\n\n\t}\n\n\tgetSize( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Box3: .getSize() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\treturn this.isEmpty() ? target.set( 0, 0, 0 ) : target.subVectors( this.max, this.min );\n\n\t}\n\n\texpandByPoint( point ) {\n\n\t\tthis.min.min( point );\n\t\tthis.max.max( point );\n\n\t\treturn this;\n\n\t}\n\n\texpandByVector( vector ) {\n\n\t\tthis.min.sub( vector );\n\t\tthis.max.add( vector );\n\n\t\treturn this;\n\n\t}\n\n\texpandByScalar( scalar ) {\n\n\t\tthis.min.addScalar( - scalar );\n\t\tthis.max.addScalar( scalar );\n\n\t\treturn this;\n\n\t}\n\n\texpandByObject( object ) {\n\n\t\t// Computes the world-axis-aligned bounding box of an object (including its children),\n\t\t// accounting for both the object's, and children's, world transforms\n\n\t\tobject.updateWorldMatrix( false, false );\n\n\t\tconst geometry = object.geometry;\n\n\t\tif ( geometry !== undefined ) {\n\n\t\t\tif ( geometry.boundingBox === null ) {\n\n\t\t\t\tgeometry.computeBoundingBox();\n\n\t\t\t}\n\n\t\t\t_box$3.copy( geometry.boundingBox );\n\t\t\t_box$3.applyMatrix4( object.matrixWorld );\n\n\t\t\tthis.union( _box$3 );\n\n\t\t}\n\n\t\tconst children = object.children;\n\n\t\tfor ( let i = 0, l = children.length; i < l; i ++ ) {\n\n\t\t\tthis.expandByObject( children[ i ] );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tcontainsPoint( point ) {\n\n\t\treturn point.x < this.min.x || point.x > this.max.x ||\n\t\t\tpoint.y < this.min.y || point.y > this.max.y ||\n\t\t\tpoint.z < this.min.z || point.z > this.max.z ? false : true;\n\n\t}\n\n\tcontainsBox( box ) {\n\n\t\treturn this.min.x <= box.min.x && box.max.x <= this.max.x &&\n\t\t\tthis.min.y <= box.min.y && box.max.y <= this.max.y &&\n\t\t\tthis.min.z <= box.min.z && box.max.z <= this.max.z;\n\n\t}\n\n\tgetParameter( point, target ) {\n\n\t\t// This can potentially have a divide by zero if the box\n\t\t// has a size dimension of 0.\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Box3: .getParameter() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\treturn target.set(\n\t\t\t( point.x - this.min.x ) / ( this.max.x - this.min.x ),\n\t\t\t( point.y - this.min.y ) / ( this.max.y - this.min.y ),\n\t\t\t( point.z - this.min.z ) / ( this.max.z - this.min.z )\n\t\t);\n\n\t}\n\n\tintersectsBox( box ) {\n\n\t\t// using 6 splitting planes to rule out intersections.\n\t\treturn box.max.x < this.min.x || box.min.x > this.max.x ||\n\t\t\tbox.max.y < this.min.y || box.min.y > this.max.y ||\n\t\t\tbox.max.z < this.min.z || box.min.z > this.max.z ? false : true;\n\n\t}\n\n\tintersectsSphere( sphere ) {\n\n\t\t// Find the point on the AABB closest to the sphere center.\n\t\tthis.clampPoint( sphere.center, _vector$b );\n\n\t\t// If that point is inside the sphere, the AABB and sphere intersect.\n\t\treturn _vector$b.distanceToSquared( sphere.center ) <= ( sphere.radius * sphere.radius );\n\n\t}\n\n\tintersectsPlane( plane ) {\n\n\t\t// We compute the minimum and maximum dot product values. If those values\n\t\t// are on the same side (back or front) of the plane, then there is no intersection.\n\n\t\tlet min, max;\n\n\t\tif ( plane.normal.x > 0 ) {\n\n\t\t\tmin = plane.normal.x * this.min.x;\n\t\t\tmax = plane.normal.x * this.max.x;\n\n\t\t} else {\n\n\t\t\tmin = plane.normal.x * this.max.x;\n\t\t\tmax = plane.normal.x * this.min.x;\n\n\t\t}\n\n\t\tif ( plane.normal.y > 0 ) {\n\n\t\t\tmin += plane.normal.y * this.min.y;\n\t\t\tmax += plane.normal.y * this.max.y;\n\n\t\t} else {\n\n\t\t\tmin += plane.normal.y * this.max.y;\n\t\t\tmax += plane.normal.y * this.min.y;\n\n\t\t}\n\n\t\tif ( plane.normal.z > 0 ) {\n\n\t\t\tmin += plane.normal.z * this.min.z;\n\t\t\tmax += plane.normal.z * this.max.z;\n\n\t\t} else {\n\n\t\t\tmin += plane.normal.z * this.max.z;\n\t\t\tmax += plane.normal.z * this.min.z;\n\n\t\t}\n\n\t\treturn ( min <= - plane.constant && max >= - plane.constant );\n\n\t}\n\n\tintersectsTriangle( triangle ) {\n\n\t\tif ( this.isEmpty() ) {\n\n\t\t\treturn false;\n\n\t\t}\n\n\t\t// compute box center and extents\n\t\tthis.getCenter( _center );\n\t\t_extents.subVectors( this.max, _center );\n\n\t\t// translate triangle to aabb origin\n\t\t_v0$2.subVectors( triangle.a, _center );\n\t\t_v1$7.subVectors( triangle.b, _center );\n\t\t_v2$3.subVectors( triangle.c, _center );\n\n\t\t// compute edge vectors for triangle\n\t\t_f0.subVectors( _v1$7, _v0$2 );\n\t\t_f1.subVectors( _v2$3, _v1$7 );\n\t\t_f2.subVectors( _v0$2, _v2$3 );\n\n\t\t// test against axes that are given by cross product combinations of the edges of the triangle and the edges of the aabb\n\t\t// make an axis testing of each of the 3 sides of the aabb against each of the 3 sides of the triangle = 9 axis of separation\n\t\t// axis_ij = u_i x f_j (u0, u1, u2 = face normals of aabb = x,y,z axes vectors since aabb is axis aligned)\n\t\tlet axes = [\n\t\t\t0, - _f0.z, _f0.y, 0, - _f1.z, _f1.y, 0, - _f2.z, _f2.y,\n\t\t\t_f0.z, 0, - _f0.x, _f1.z, 0, - _f1.x, _f2.z, 0, - _f2.x,\n\t\t\t- _f0.y, _f0.x, 0, - _f1.y, _f1.x, 0, - _f2.y, _f2.x, 0\n\t\t];\n\t\tif ( ! satForAxes( axes, _v0$2, _v1$7, _v2$3, _extents ) ) {\n\n\t\t\treturn false;\n\n\t\t}\n\n\t\t// test 3 face normals from the aabb\n\t\taxes = [ 1, 0, 0, 0, 1, 0, 0, 0, 1 ];\n\t\tif ( ! satForAxes( axes, _v0$2, _v1$7, _v2$3, _extents ) ) {\n\n\t\t\treturn false;\n\n\t\t}\n\n\t\t// finally testing the face normal of the triangle\n\t\t// use already existing triangle edge vectors here\n\t\t_triangleNormal.crossVectors( _f0, _f1 );\n\t\taxes = [ _triangleNormal.x, _triangleNormal.y, _triangleNormal.z ];\n\n\t\treturn satForAxes( axes, _v0$2, _v1$7, _v2$3, _extents );\n\n\t}\n\n\tclampPoint( point, target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Box3: .clampPoint() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\treturn target.copy( point ).clamp( this.min, this.max );\n\n\t}\n\n\tdistanceToPoint( point ) {\n\n\t\tconst clampedPoint = _vector$b.copy( point ).clamp( this.min, this.max );\n\n\t\treturn clampedPoint.sub( point ).length();\n\n\t}\n\n\tgetBoundingSphere( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.error( 'THREE.Box3: .getBoundingSphere() target is now required' );\n\t\t\t//target = new Sphere(); // removed to avoid cyclic dependency\n\n\t\t}\n\n\t\tthis.getCenter( target.center );\n\n\t\ttarget.radius = this.getSize( _vector$b ).length() * 0.5;\n\n\t\treturn target;\n\n\t}\n\n\tintersect( box ) {\n\n\t\tthis.min.max( box.min );\n\t\tthis.max.min( box.max );\n\n\t\t// ensure that if there is no overlap, the result is fully empty, not slightly empty with non-inf/+inf values that will cause subsequence intersects to erroneously return valid values.\n\t\tif ( this.isEmpty() ) this.makeEmpty();\n\n\t\treturn this;\n\n\t}\n\n\tunion( box ) {\n\n\t\tthis.min.min( box.min );\n\t\tthis.max.max( box.max );\n\n\t\treturn this;\n\n\t}\n\n\tapplyMatrix4( matrix ) {\n\n\t\t// transform of empty box is an empty box.\n\t\tif ( this.isEmpty() ) return this;\n\n\t\t// NOTE: I am using a binary pattern to specify all 2^3 combinations below\n\t\t_points[ 0 ].set( this.min.x, this.min.y, this.min.z ).applyMatrix4( matrix ); // 000\n\t\t_points[ 1 ].set( this.min.x, this.min.y, this.max.z ).applyMatrix4( matrix ); // 001\n\t\t_points[ 2 ].set( this.min.x, this.max.y, this.min.z ).applyMatrix4( matrix ); // 010\n\t\t_points[ 3 ].set( this.min.x, this.max.y, this.max.z ).applyMatrix4( matrix ); // 011\n\t\t_points[ 4 ].set( this.max.x, this.min.y, this.min.z ).applyMatrix4( matrix ); // 100\n\t\t_points[ 5 ].set( this.max.x, this.min.y, this.max.z ).applyMatrix4( matrix ); // 101\n\t\t_points[ 6 ].set( this.max.x, this.max.y, this.min.z ).applyMatrix4( matrix ); // 110\n\t\t_points[ 7 ].set( this.max.x, this.max.y, this.max.z ).applyMatrix4( matrix ); // 111\n\n\t\tthis.setFromPoints( _points );\n\n\t\treturn this;\n\n\t}\n\n\ttranslate( offset ) {\n\n\t\tthis.min.add( offset );\n\t\tthis.max.add( offset );\n\n\t\treturn this;\n\n\t}\n\n\tequals( box ) {\n\n\t\treturn box.min.equals( this.min ) && box.max.equals( this.max );\n\n\t}\n\n}\n\nBox3.prototype.isBox3 = true;\n\nconst _points = [\n\t/*@__PURE__*/ new Vector3(),\n\t/*@__PURE__*/ new Vector3(),\n\t/*@__PURE__*/ new Vector3(),\n\t/*@__PURE__*/ new Vector3(),\n\t/*@__PURE__*/ new Vector3(),\n\t/*@__PURE__*/ new Vector3(),\n\t/*@__PURE__*/ new Vector3(),\n\t/*@__PURE__*/ new Vector3()\n];\n\nconst _vector$b = /*@__PURE__*/ new Vector3();\n\nconst _box$3 = /*@__PURE__*/ new Box3();\n\n// triangle centered vertices\n\nconst _v0$2 = /*@__PURE__*/ new Vector3();\nconst _v1$7 = /*@__PURE__*/ new Vector3();\nconst _v2$3 = /*@__PURE__*/ new Vector3();\n\n// triangle edge vectors\n\nconst _f0 = /*@__PURE__*/ new Vector3();\nconst _f1 = /*@__PURE__*/ new Vector3();\nconst _f2 = /*@__PURE__*/ new Vector3();\n\nconst _center = /*@__PURE__*/ new Vector3();\nconst _extents = /*@__PURE__*/ new Vector3();\nconst _triangleNormal = /*@__PURE__*/ new Vector3();\nconst _testAxis = /*@__PURE__*/ new Vector3();\n\nfunction satForAxes( axes, v0, v1, v2, extents ) {\n\n\tfor ( let i = 0, j = axes.length - 3; i <= j; i += 3 ) {\n\n\t\t_testAxis.fromArray( axes, i );\n\t\t// project the aabb onto the seperating axis\n\t\tconst r = extents.x * Math.abs( _testAxis.x ) + extents.y * Math.abs( _testAxis.y ) + extents.z * Math.abs( _testAxis.z );\n\t\t// project all 3 vertices of the triangle onto the seperating axis\n\t\tconst p0 = v0.dot( _testAxis );\n\t\tconst p1 = v1.dot( _testAxis );\n\t\tconst p2 = v2.dot( _testAxis );\n\t\t// actual test, basically see if either of the most extreme of the triangle points intersects r\n\t\tif ( Math.max( - Math.max( p0, p1, p2 ), Math.min( p0, p1, p2 ) ) > r ) {\n\n\t\t\t// points of the projected triangle are outside the projected half-length of the aabb\n\t\t\t// the axis is seperating and we can exit\n\t\t\treturn false;\n\n\t\t}\n\n\t}\n\n\treturn true;\n\n}\n\nconst _box$2 = /*@__PURE__*/ new Box3();\nconst _v1$6 = /*@__PURE__*/ new Vector3();\nconst _toFarthestPoint = /*@__PURE__*/ new Vector3();\nconst _toPoint = /*@__PURE__*/ new Vector3();\n\nclass Sphere {\n\n\tconstructor( center = new Vector3(), radius = - 1 ) {\n\n\t\tthis.center = center;\n\t\tthis.radius = radius;\n\n\t}\n\n\tset( center, radius ) {\n\n\t\tthis.center.copy( center );\n\t\tthis.radius = radius;\n\n\t\treturn this;\n\n\t}\n\n\tsetFromPoints( points, optionalCenter ) {\n\n\t\tconst center = this.center;\n\n\t\tif ( optionalCenter !== undefined ) {\n\n\t\t\tcenter.copy( optionalCenter );\n\n\t\t} else {\n\n\t\t\t_box$2.setFromPoints( points ).getCenter( center );\n\n\t\t}\n\n\t\tlet maxRadiusSq = 0;\n\n\t\tfor ( let i = 0, il = points.length; i < il; i ++ ) {\n\n\t\t\tmaxRadiusSq = Math.max( maxRadiusSq, center.distanceToSquared( points[ i ] ) );\n\n\t\t}\n\n\t\tthis.radius = Math.sqrt( maxRadiusSq );\n\n\t\treturn this;\n\n\t}\n\n\tcopy( sphere ) {\n\n\t\tthis.center.copy( sphere.center );\n\t\tthis.radius = sphere.radius;\n\n\t\treturn this;\n\n\t}\n\n\tisEmpty() {\n\n\t\treturn ( this.radius < 0 );\n\n\t}\n\n\tmakeEmpty() {\n\n\t\tthis.center.set( 0, 0, 0 );\n\t\tthis.radius = - 1;\n\n\t\treturn this;\n\n\t}\n\n\tcontainsPoint( point ) {\n\n\t\treturn ( point.distanceToSquared( this.center ) <= ( this.radius * this.radius ) );\n\n\t}\n\n\tdistanceToPoint( point ) {\n\n\t\treturn ( point.distanceTo( this.center ) - this.radius );\n\n\t}\n\n\tintersectsSphere( sphere ) {\n\n\t\tconst radiusSum = this.radius + sphere.radius;\n\n\t\treturn sphere.center.distanceToSquared( this.center ) <= ( radiusSum * radiusSum );\n\n\t}\n\n\tintersectsBox( box ) {\n\n\t\treturn box.intersectsSphere( this );\n\n\t}\n\n\tintersectsPlane( plane ) {\n\n\t\treturn Math.abs( plane.distanceToPoint( this.center ) ) <= this.radius;\n\n\t}\n\n\tclampPoint( point, target ) {\n\n\t\tconst deltaLengthSq = this.center.distanceToSquared( point );\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Sphere: .clampPoint() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\ttarget.copy( point );\n\n\t\tif ( deltaLengthSq > ( this.radius * this.radius ) ) {\n\n\t\t\ttarget.sub( this.center ).normalize();\n\t\t\ttarget.multiplyScalar( this.radius ).add( this.center );\n\n\t\t}\n\n\t\treturn target;\n\n\t}\n\n\tgetBoundingBox( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Sphere: .getBoundingBox() target is now required' );\n\t\t\ttarget = new Box3();\n\n\t\t}\n\n\t\tif ( this.isEmpty() ) {\n\n\t\t\t// Empty sphere produces empty bounding box\n\t\t\ttarget.makeEmpty();\n\t\t\treturn target;\n\n\t\t}\n\n\t\ttarget.set( this.center, this.center );\n\t\ttarget.expandByScalar( this.radius );\n\n\t\treturn target;\n\n\t}\n\n\tapplyMatrix4( matrix ) {\n\n\t\tthis.center.applyMatrix4( matrix );\n\t\tthis.radius = this.radius * matrix.getMaxScaleOnAxis();\n\n\t\treturn this;\n\n\t}\n\n\ttranslate( offset ) {\n\n\t\tthis.center.add( offset );\n\n\t\treturn this;\n\n\t}\n\n\texpandByPoint( point ) {\n\n\t\t// from https://github.com/juj/MathGeoLib/blob/2940b99b99cfe575dd45103ef20f4019dee15b54/src/Geometry/Sphere.cpp#L649-L671\n\n\t\t_toPoint.subVectors( point, this.center );\n\n\t\tconst lengthSq = _toPoint.lengthSq();\n\n\t\tif ( lengthSq > ( this.radius * this.radius ) ) {\n\n\t\t\tconst length = Math.sqrt( lengthSq );\n\t\t\tconst missingRadiusHalf = ( length - this.radius ) * 0.5;\n\n\t\t\t// Nudge this sphere towards the target point. Add half the missing distance to radius,\n\t\t\t// and the other half to position. This gives a tighter enclosure, instead of if\n\t\t\t// the whole missing distance were just added to radius.\n\n\t\t\tthis.center.add( _toPoint.multiplyScalar( missingRadiusHalf / length ) );\n\t\t\tthis.radius += missingRadiusHalf;\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tunion( sphere ) {\n\n\t\t// from https://github.com/juj/MathGeoLib/blob/2940b99b99cfe575dd45103ef20f4019dee15b54/src/Geometry/Sphere.cpp#L759-L769\n\n\t\t// To enclose another sphere into this sphere, we only need to enclose two points:\n\t\t// 1) Enclose the farthest point on the other sphere into this sphere.\n\t\t// 2) Enclose the opposite point of the farthest point into this sphere.\n\n\t\t_toFarthestPoint.subVectors( sphere.center, this.center ).normalize().multiplyScalar( sphere.radius );\n\n\t\tthis.expandByPoint( _v1$6.copy( sphere.center ).add( _toFarthestPoint ) );\n\t\tthis.expandByPoint( _v1$6.copy( sphere.center ).sub( _toFarthestPoint ) );\n\n\t\treturn this;\n\n\t}\n\n\tequals( sphere ) {\n\n\t\treturn sphere.center.equals( this.center ) && ( sphere.radius === this.radius );\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n}\n\nconst _vector$a = /*@__PURE__*/ new Vector3();\nconst _segCenter = /*@__PURE__*/ new Vector3();\nconst _segDir = /*@__PURE__*/ new Vector3();\nconst _diff = /*@__PURE__*/ new Vector3();\n\nconst _edge1 = /*@__PURE__*/ new Vector3();\nconst _edge2 = /*@__PURE__*/ new Vector3();\nconst _normal$1 = /*@__PURE__*/ new Vector3();\n\nclass Ray {\n\n\tconstructor( origin = new Vector3(), direction = new Vector3( 0, 0, - 1 ) ) {\n\n\t\tthis.origin = origin;\n\t\tthis.direction = direction;\n\n\t}\n\n\tset( origin, direction ) {\n\n\t\tthis.origin.copy( origin );\n\t\tthis.direction.copy( direction );\n\n\t\treturn this;\n\n\t}\n\n\tcopy( ray ) {\n\n\t\tthis.origin.copy( ray.origin );\n\t\tthis.direction.copy( ray.direction );\n\n\t\treturn this;\n\n\t}\n\n\tat( t, target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Ray: .at() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\treturn target.copy( this.direction ).multiplyScalar( t ).add( this.origin );\n\n\t}\n\n\tlookAt( v ) {\n\n\t\tthis.direction.copy( v ).sub( this.origin ).normalize();\n\n\t\treturn this;\n\n\t}\n\n\trecast( t ) {\n\n\t\tthis.origin.copy( this.at( t, _vector$a ) );\n\n\t\treturn this;\n\n\t}\n\n\tclosestPointToPoint( point, target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Ray: .closestPointToPoint() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\ttarget.subVectors( point, this.origin );\n\n\t\tconst directionDistance = target.dot( this.direction );\n\n\t\tif ( directionDistance < 0 ) {\n\n\t\t\treturn target.copy( this.origin );\n\n\t\t}\n\n\t\treturn target.copy( this.direction ).multiplyScalar( directionDistance ).add( this.origin );\n\n\t}\n\n\tdistanceToPoint( point ) {\n\n\t\treturn Math.sqrt( this.distanceSqToPoint( point ) );\n\n\t}\n\n\tdistanceSqToPoint( point ) {\n\n\t\tconst directionDistance = _vector$a.subVectors( point, this.origin ).dot( this.direction );\n\n\t\t// point behind the ray\n\n\t\tif ( directionDistance < 0 ) {\n\n\t\t\treturn this.origin.distanceToSquared( point );\n\n\t\t}\n\n\t\t_vector$a.copy( this.direction ).multiplyScalar( directionDistance ).add( this.origin );\n\n\t\treturn _vector$a.distanceToSquared( point );\n\n\t}\n\n\tdistanceSqToSegment( v0, v1, optionalPointOnRay, optionalPointOnSegment ) {\n\n\t\t// from http://www.geometrictools.com/GTEngine/Include/Mathematics/GteDistRaySegment.h\n\t\t// It returns the min distance between the ray and the segment\n\t\t// defined by v0 and v1\n\t\t// It can also set two optional targets :\n\t\t// - The closest point on the ray\n\t\t// - The closest point on the segment\n\n\t\t_segCenter.copy( v0 ).add( v1 ).multiplyScalar( 0.5 );\n\t\t_segDir.copy( v1 ).sub( v0 ).normalize();\n\t\t_diff.copy( this.origin ).sub( _segCenter );\n\n\t\tconst segExtent = v0.distanceTo( v1 ) * 0.5;\n\t\tconst a01 = - this.direction.dot( _segDir );\n\t\tconst b0 = _diff.dot( this.direction );\n\t\tconst b1 = - _diff.dot( _segDir );\n\t\tconst c = _diff.lengthSq();\n\t\tconst det = Math.abs( 1 - a01 * a01 );\n\t\tlet s0, s1, sqrDist, extDet;\n\n\t\tif ( det > 0 ) {\n\n\t\t\t// The ray and segment are not parallel.\n\n\t\t\ts0 = a01 * b1 - b0;\n\t\t\ts1 = a01 * b0 - b1;\n\t\t\textDet = segExtent * det;\n\n\t\t\tif ( s0 >= 0 ) {\n\n\t\t\t\tif ( s1 >= - extDet ) {\n\n\t\t\t\t\tif ( s1 <= extDet ) {\n\n\t\t\t\t\t\t// region 0\n\t\t\t\t\t\t// Minimum at interior points of ray and segment.\n\n\t\t\t\t\t\tconst invDet = 1 / det;\n\t\t\t\t\t\ts0 *= invDet;\n\t\t\t\t\t\ts1 *= invDet;\n\t\t\t\t\t\tsqrDist = s0 * ( s0 + a01 * s1 + 2 * b0 ) + s1 * ( a01 * s0 + s1 + 2 * b1 ) + c;\n\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\t// region 1\n\n\t\t\t\t\t\ts1 = segExtent;\n\t\t\t\t\t\ts0 = Math.max( 0, - ( a01 * s1 + b0 ) );\n\t\t\t\t\t\tsqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;\n\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\n\t\t\t\t\t// region 5\n\n\t\t\t\t\ts1 = - segExtent;\n\t\t\t\t\ts0 = Math.max( 0, - ( a01 * s1 + b0 ) );\n\t\t\t\t\tsqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;\n\n\t\t\t\t}\n\n\t\t\t} else {\n\n\t\t\t\tif ( s1 <= - extDet ) {\n\n\t\t\t\t\t// region 4\n\n\t\t\t\t\ts0 = Math.max( 0, - ( - a01 * segExtent + b0 ) );\n\t\t\t\t\ts1 = ( s0 > 0 ) ? - segExtent : Math.min( Math.max( - segExtent, - b1 ), segExtent );\n\t\t\t\t\tsqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;\n\n\t\t\t\t} else if ( s1 <= extDet ) {\n\n\t\t\t\t\t// region 3\n\n\t\t\t\t\ts0 = 0;\n\t\t\t\t\ts1 = Math.min( Math.max( - segExtent, - b1 ), segExtent );\n\t\t\t\t\tsqrDist = s1 * ( s1 + 2 * b1 ) + c;\n\n\t\t\t\t} else {\n\n\t\t\t\t\t// region 2\n\n\t\t\t\t\ts0 = Math.max( 0, - ( a01 * segExtent + b0 ) );\n\t\t\t\t\ts1 = ( s0 > 0 ) ? segExtent : Math.min( Math.max( - segExtent, - b1 ), segExtent );\n\t\t\t\t\tsqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t} else {\n\n\t\t\t// Ray and segment are parallel.\n\n\t\t\ts1 = ( a01 > 0 ) ? - segExtent : segExtent;\n\t\t\ts0 = Math.max( 0, - ( a01 * s1 + b0 ) );\n\t\t\tsqrDist = - s0 * s0 + s1 * ( s1 + 2 * b1 ) + c;\n\n\t\t}\n\n\t\tif ( optionalPointOnRay ) {\n\n\t\t\toptionalPointOnRay.copy( this.direction ).multiplyScalar( s0 ).add( this.origin );\n\n\t\t}\n\n\t\tif ( optionalPointOnSegment ) {\n\n\t\t\toptionalPointOnSegment.copy( _segDir ).multiplyScalar( s1 ).add( _segCenter );\n\n\t\t}\n\n\t\treturn sqrDist;\n\n\t}\n\n\tintersectSphere( sphere, target ) {\n\n\t\t_vector$a.subVectors( sphere.center, this.origin );\n\t\tconst tca = _vector$a.dot( this.direction );\n\t\tconst d2 = _vector$a.dot( _vector$a ) - tca * tca;\n\t\tconst radius2 = sphere.radius * sphere.radius;\n\n\t\tif ( d2 > radius2 ) return null;\n\n\t\tconst thc = Math.sqrt( radius2 - d2 );\n\n\t\t// t0 = first intersect point - entrance on front of sphere\n\t\tconst t0 = tca - thc;\n\n\t\t// t1 = second intersect point - exit point on back of sphere\n\t\tconst t1 = tca + thc;\n\n\t\t// test to see if both t0 and t1 are behind the ray - if so, return null\n\t\tif ( t0 < 0 && t1 < 0 ) return null;\n\n\t\t// test to see if t0 is behind the ray:\n\t\t// if it is, the ray is inside the sphere, so return the second exit point scaled by t1,\n\t\t// in order to always return an intersect point that is in front of the ray.\n\t\tif ( t0 < 0 ) return this.at( t1, target );\n\n\t\t// else t0 is in front of the ray, so return the first collision point scaled by t0\n\t\treturn this.at( t0, target );\n\n\t}\n\n\tintersectsSphere( sphere ) {\n\n\t\treturn this.distanceSqToPoint( sphere.center ) <= ( sphere.radius * sphere.radius );\n\n\t}\n\n\tdistanceToPlane( plane ) {\n\n\t\tconst denominator = plane.normal.dot( this.direction );\n\n\t\tif ( denominator === 0 ) {\n\n\t\t\t// line is coplanar, return origin\n\t\t\tif ( plane.distanceToPoint( this.origin ) === 0 ) {\n\n\t\t\t\treturn 0;\n\n\t\t\t}\n\n\t\t\t// Null is preferable to undefined since undefined means.... it is undefined\n\n\t\t\treturn null;\n\n\t\t}\n\n\t\tconst t = - ( this.origin.dot( plane.normal ) + plane.constant ) / denominator;\n\n\t\t// Return if the ray never intersects the plane\n\n\t\treturn t >= 0 ? t : null;\n\n\t}\n\n\tintersectPlane( plane, target ) {\n\n\t\tconst t = this.distanceToPlane( plane );\n\n\t\tif ( t === null ) {\n\n\t\t\treturn null;\n\n\t\t}\n\n\t\treturn this.at( t, target );\n\n\t}\n\n\tintersectsPlane( plane ) {\n\n\t\t// check if the ray lies on the plane first\n\n\t\tconst distToPoint = plane.distanceToPoint( this.origin );\n\n\t\tif ( distToPoint === 0 ) {\n\n\t\t\treturn true;\n\n\t\t}\n\n\t\tconst denominator = plane.normal.dot( this.direction );\n\n\t\tif ( denominator * distToPoint < 0 ) {\n\n\t\t\treturn true;\n\n\t\t}\n\n\t\t// ray origin is behind the plane (and is pointing behind it)\n\n\t\treturn false;\n\n\t}\n\n\tintersectBox( box, target ) {\n\n\t\tlet tmin, tmax, tymin, tymax, tzmin, tzmax;\n\n\t\tconst invdirx = 1 / this.direction.x,\n\t\t\tinvdiry = 1 / this.direction.y,\n\t\t\tinvdirz = 1 / this.direction.z;\n\n\t\tconst origin = this.origin;\n\n\t\tif ( invdirx >= 0 ) {\n\n\t\t\ttmin = ( box.min.x - origin.x ) * invdirx;\n\t\t\ttmax = ( box.max.x - origin.x ) * invdirx;\n\n\t\t} else {\n\n\t\t\ttmin = ( box.max.x - origin.x ) * invdirx;\n\t\t\ttmax = ( box.min.x - origin.x ) * invdirx;\n\n\t\t}\n\n\t\tif ( invdiry >= 0 ) {\n\n\t\t\ttymin = ( box.min.y - origin.y ) * invdiry;\n\t\t\ttymax = ( box.max.y - origin.y ) * invdiry;\n\n\t\t} else {\n\n\t\t\ttymin = ( box.max.y - origin.y ) * invdiry;\n\t\t\ttymax = ( box.min.y - origin.y ) * invdiry;\n\n\t\t}\n\n\t\tif ( ( tmin > tymax ) || ( tymin > tmax ) ) return null;\n\n\t\t// These lines also handle the case where tmin or tmax is NaN\n\t\t// (result of 0 * Infinity). x !== x returns true if x is NaN\n\n\t\tif ( tymin > tmin || tmin !== tmin ) tmin = tymin;\n\n\t\tif ( tymax < tmax || tmax !== tmax ) tmax = tymax;\n\n\t\tif ( invdirz >= 0 ) {\n\n\t\t\ttzmin = ( box.min.z - origin.z ) * invdirz;\n\t\t\ttzmax = ( box.max.z - origin.z ) * invdirz;\n\n\t\t} else {\n\n\t\t\ttzmin = ( box.max.z - origin.z ) * invdirz;\n\t\t\ttzmax = ( box.min.z - origin.z ) * invdirz;\n\n\t\t}\n\n\t\tif ( ( tmin > tzmax ) || ( tzmin > tmax ) ) return null;\n\n\t\tif ( tzmin > tmin || tmin !== tmin ) tmin = tzmin;\n\n\t\tif ( tzmax < tmax || tmax !== tmax ) tmax = tzmax;\n\n\t\t//return point closest to the ray (positive side)\n\n\t\tif ( tmax < 0 ) return null;\n\n\t\treturn this.at( tmin >= 0 ? tmin : tmax, target );\n\n\t}\n\n\tintersectsBox( box ) {\n\n\t\treturn this.intersectBox( box, _vector$a ) !== null;\n\n\t}\n\n\tintersectTriangle( a, b, c, backfaceCulling, target ) {\n\n\t\t// Compute the offset origin, edges, and normal.\n\n\t\t// from http://www.geometrictools.com/GTEngine/Include/Mathematics/GteIntrRay3Triangle3.h\n\n\t\t_edge1.subVectors( b, a );\n\t\t_edge2.subVectors( c, a );\n\t\t_normal$1.crossVectors( _edge1, _edge2 );\n\n\t\t// Solve Q + t*D = b1*E1 + b2*E2 (Q = kDiff, D = ray direction,\n\t\t// E1 = kEdge1, E2 = kEdge2, N = Cross(E1,E2)) by\n\t\t//   |Dot(D,N)|*b1 = sign(Dot(D,N))*Dot(D,Cross(Q,E2))\n\t\t//   |Dot(D,N)|*b2 = sign(Dot(D,N))*Dot(D,Cross(E1,Q))\n\t\t//   |Dot(D,N)|*t = -sign(Dot(D,N))*Dot(Q,N)\n\t\tlet DdN = this.direction.dot( _normal$1 );\n\t\tlet sign;\n\n\t\tif ( DdN > 0 ) {\n\n\t\t\tif ( backfaceCulling ) return null;\n\t\t\tsign = 1;\n\n\t\t} else if ( DdN < 0 ) {\n\n\t\t\tsign = - 1;\n\t\t\tDdN = - DdN;\n\n\t\t} else {\n\n\t\t\treturn null;\n\n\t\t}\n\n\t\t_diff.subVectors( this.origin, a );\n\t\tconst DdQxE2 = sign * this.direction.dot( _edge2.crossVectors( _diff, _edge2 ) );\n\n\t\t// b1 < 0, no intersection\n\t\tif ( DdQxE2 < 0 ) {\n\n\t\t\treturn null;\n\n\t\t}\n\n\t\tconst DdE1xQ = sign * this.direction.dot( _edge1.cross( _diff ) );\n\n\t\t// b2 < 0, no intersection\n\t\tif ( DdE1xQ < 0 ) {\n\n\t\t\treturn null;\n\n\t\t}\n\n\t\t// b1+b2 > 1, no intersection\n\t\tif ( DdQxE2 + DdE1xQ > DdN ) {\n\n\t\t\treturn null;\n\n\t\t}\n\n\t\t// Line intersects triangle, check if ray does.\n\t\tconst QdN = - sign * _diff.dot( _normal$1 );\n\n\t\t// t < 0, no intersection\n\t\tif ( QdN < 0 ) {\n\n\t\t\treturn null;\n\n\t\t}\n\n\t\t// Ray intersects triangle.\n\t\treturn this.at( QdN / DdN, target );\n\n\t}\n\n\tapplyMatrix4( matrix4 ) {\n\n\t\tthis.origin.applyMatrix4( matrix4 );\n\t\tthis.direction.transformDirection( matrix4 );\n\n\t\treturn this;\n\n\t}\n\n\tequals( ray ) {\n\n\t\treturn ray.origin.equals( this.origin ) && ray.direction.equals( this.direction );\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n}\n\nclass Matrix4 {\n\n\tconstructor() {\n\n\t\tthis.elements = [\n\n\t\t\t1, 0, 0, 0,\n\t\t\t0, 1, 0, 0,\n\t\t\t0, 0, 1, 0,\n\t\t\t0, 0, 0, 1\n\n\t\t];\n\n\t\tif ( arguments.length > 0 ) {\n\n\t\t\tconsole.error( 'THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.' );\n\n\t\t}\n\n\t}\n\n\tset( n11, n12, n13, n14, n21, n22, n23, n24, n31, n32, n33, n34, n41, n42, n43, n44 ) {\n\n\t\tconst te = this.elements;\n\n\t\tte[ 0 ] = n11; te[ 4 ] = n12; te[ 8 ] = n13; te[ 12 ] = n14;\n\t\tte[ 1 ] = n21; te[ 5 ] = n22; te[ 9 ] = n23; te[ 13 ] = n24;\n\t\tte[ 2 ] = n31; te[ 6 ] = n32; te[ 10 ] = n33; te[ 14 ] = n34;\n\t\tte[ 3 ] = n41; te[ 7 ] = n42; te[ 11 ] = n43; te[ 15 ] = n44;\n\n\t\treturn this;\n\n\t}\n\n\tidentity() {\n\n\t\tthis.set(\n\n\t\t\t1, 0, 0, 0,\n\t\t\t0, 1, 0, 0,\n\t\t\t0, 0, 1, 0,\n\t\t\t0, 0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tclone() {\n\n\t\treturn new Matrix4().fromArray( this.elements );\n\n\t}\n\n\tcopy( m ) {\n\n\t\tconst te = this.elements;\n\t\tconst me = m.elements;\n\n\t\tte[ 0 ] = me[ 0 ]; te[ 1 ] = me[ 1 ]; te[ 2 ] = me[ 2 ]; te[ 3 ] = me[ 3 ];\n\t\tte[ 4 ] = me[ 4 ]; te[ 5 ] = me[ 5 ]; te[ 6 ] = me[ 6 ]; te[ 7 ] = me[ 7 ];\n\t\tte[ 8 ] = me[ 8 ]; te[ 9 ] = me[ 9 ]; te[ 10 ] = me[ 10 ]; te[ 11 ] = me[ 11 ];\n\t\tte[ 12 ] = me[ 12 ]; te[ 13 ] = me[ 13 ]; te[ 14 ] = me[ 14 ]; te[ 15 ] = me[ 15 ];\n\n\t\treturn this;\n\n\t}\n\n\tcopyPosition( m ) {\n\n\t\tconst te = this.elements, me = m.elements;\n\n\t\tte[ 12 ] = me[ 12 ];\n\t\tte[ 13 ] = me[ 13 ];\n\t\tte[ 14 ] = me[ 14 ];\n\n\t\treturn this;\n\n\t}\n\n\tsetFromMatrix3( m ) {\n\n\t\tconst me = m.elements;\n\n\t\tthis.set(\n\n\t\t\tme[ 0 ], me[ 3 ], me[ 6 ], 0,\n\t\t\tme[ 1 ], me[ 4 ], me[ 7 ], 0,\n\t\t\tme[ 2 ], me[ 5 ], me[ 8 ], 0,\n\t\t\t0, 0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\textractBasis( xAxis, yAxis, zAxis ) {\n\n\t\txAxis.setFromMatrixColumn( this, 0 );\n\t\tyAxis.setFromMatrixColumn( this, 1 );\n\t\tzAxis.setFromMatrixColumn( this, 2 );\n\n\t\treturn this;\n\n\t}\n\n\tmakeBasis( xAxis, yAxis, zAxis ) {\n\n\t\tthis.set(\n\t\t\txAxis.x, yAxis.x, zAxis.x, 0,\n\t\t\txAxis.y, yAxis.y, zAxis.y, 0,\n\t\t\txAxis.z, yAxis.z, zAxis.z, 0,\n\t\t\t0, 0, 0, 1\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\textractRotation( m ) {\n\n\t\t// this method does not support reflection matrices\n\n\t\tconst te = this.elements;\n\t\tconst me = m.elements;\n\n\t\tconst scaleX = 1 / _v1$5.setFromMatrixColumn( m, 0 ).length();\n\t\tconst scaleY = 1 / _v1$5.setFromMatrixColumn( m, 1 ).length();\n\t\tconst scaleZ = 1 / _v1$5.setFromMatrixColumn( m, 2 ).length();\n\n\t\tte[ 0 ] = me[ 0 ] * scaleX;\n\t\tte[ 1 ] = me[ 1 ] * scaleX;\n\t\tte[ 2 ] = me[ 2 ] * scaleX;\n\t\tte[ 3 ] = 0;\n\n\t\tte[ 4 ] = me[ 4 ] * scaleY;\n\t\tte[ 5 ] = me[ 5 ] * scaleY;\n\t\tte[ 6 ] = me[ 6 ] * scaleY;\n\t\tte[ 7 ] = 0;\n\n\t\tte[ 8 ] = me[ 8 ] * scaleZ;\n\t\tte[ 9 ] = me[ 9 ] * scaleZ;\n\t\tte[ 10 ] = me[ 10 ] * scaleZ;\n\t\tte[ 11 ] = 0;\n\n\t\tte[ 12 ] = 0;\n\t\tte[ 13 ] = 0;\n\t\tte[ 14 ] = 0;\n\t\tte[ 15 ] = 1;\n\n\t\treturn this;\n\n\t}\n\n\tmakeRotationFromEuler( euler ) {\n\n\t\tif ( ! ( euler && euler.isEuler ) ) {\n\n\t\t\tconsole.error( 'THREE.Matrix4: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.' );\n\n\t\t}\n\n\t\tconst te = this.elements;\n\n\t\tconst x = euler.x, y = euler.y, z = euler.z;\n\t\tconst a = Math.cos( x ), b = Math.sin( x );\n\t\tconst c = Math.cos( y ), d = Math.sin( y );\n\t\tconst e = Math.cos( z ), f = Math.sin( z );\n\n\t\tif ( euler.order === 'XYZ' ) {\n\n\t\t\tconst ae = a * e, af = a * f, be = b * e, bf = b * f;\n\n\t\t\tte[ 0 ] = c * e;\n\t\t\tte[ 4 ] = - c * f;\n\t\t\tte[ 8 ] = d;\n\n\t\t\tte[ 1 ] = af + be * d;\n\t\t\tte[ 5 ] = ae - bf * d;\n\t\t\tte[ 9 ] = - b * c;\n\n\t\t\tte[ 2 ] = bf - ae * d;\n\t\t\tte[ 6 ] = be + af * d;\n\t\t\tte[ 10 ] = a * c;\n\n\t\t} else if ( euler.order === 'YXZ' ) {\n\n\t\t\tconst ce = c * e, cf = c * f, de = d * e, df = d * f;\n\n\t\t\tte[ 0 ] = ce + df * b;\n\t\t\tte[ 4 ] = de * b - cf;\n\t\t\tte[ 8 ] = a * d;\n\n\t\t\tte[ 1 ] = a * f;\n\t\t\tte[ 5 ] = a * e;\n\t\t\tte[ 9 ] = - b;\n\n\t\t\tte[ 2 ] = cf * b - de;\n\t\t\tte[ 6 ] = df + ce * b;\n\t\t\tte[ 10 ] = a * c;\n\n\t\t} else if ( euler.order === 'ZXY' ) {\n\n\t\t\tconst ce = c * e, cf = c * f, de = d * e, df = d * f;\n\n\t\t\tte[ 0 ] = ce - df * b;\n\t\t\tte[ 4 ] = - a * f;\n\t\t\tte[ 8 ] = de + cf * b;\n\n\t\t\tte[ 1 ] = cf + de * b;\n\t\t\tte[ 5 ] = a * e;\n\t\t\tte[ 9 ] = df - ce * b;\n\n\t\t\tte[ 2 ] = - a * d;\n\t\t\tte[ 6 ] = b;\n\t\t\tte[ 10 ] = a * c;\n\n\t\t} else if ( euler.order === 'ZYX' ) {\n\n\t\t\tconst ae = a * e, af = a * f, be = b * e, bf = b * f;\n\n\t\t\tte[ 0 ] = c * e;\n\t\t\tte[ 4 ] = be * d - af;\n\t\t\tte[ 8 ] = ae * d + bf;\n\n\t\t\tte[ 1 ] = c * f;\n\t\t\tte[ 5 ] = bf * d + ae;\n\t\t\tte[ 9 ] = af * d - be;\n\n\t\t\tte[ 2 ] = - d;\n\t\t\tte[ 6 ] = b * c;\n\t\t\tte[ 10 ] = a * c;\n\n\t\t} else if ( euler.order === 'YZX' ) {\n\n\t\t\tconst ac = a * c, ad = a * d, bc = b * c, bd = b * d;\n\n\t\t\tte[ 0 ] = c * e;\n\t\t\tte[ 4 ] = bd - ac * f;\n\t\t\tte[ 8 ] = bc * f + ad;\n\n\t\t\tte[ 1 ] = f;\n\t\t\tte[ 5 ] = a * e;\n\t\t\tte[ 9 ] = - b * e;\n\n\t\t\tte[ 2 ] = - d * e;\n\t\t\tte[ 6 ] = ad * f + bc;\n\t\t\tte[ 10 ] = ac - bd * f;\n\n\t\t} else if ( euler.order === 'XZY' ) {\n\n\t\t\tconst ac = a * c, ad = a * d, bc = b * c, bd = b * d;\n\n\t\t\tte[ 0 ] = c * e;\n\t\t\tte[ 4 ] = - f;\n\t\t\tte[ 8 ] = d * e;\n\n\t\t\tte[ 1 ] = ac * f + bd;\n\t\t\tte[ 5 ] = a * e;\n\t\t\tte[ 9 ] = ad * f - bc;\n\n\t\t\tte[ 2 ] = bc * f - ad;\n\t\t\tte[ 6 ] = b * e;\n\t\t\tte[ 10 ] = bd * f + ac;\n\n\t\t}\n\n\t\t// bottom row\n\t\tte[ 3 ] = 0;\n\t\tte[ 7 ] = 0;\n\t\tte[ 11 ] = 0;\n\n\t\t// last column\n\t\tte[ 12 ] = 0;\n\t\tte[ 13 ] = 0;\n\t\tte[ 14 ] = 0;\n\t\tte[ 15 ] = 1;\n\n\t\treturn this;\n\n\t}\n\n\tmakeRotationFromQuaternion( q ) {\n\n\t\treturn this.compose( _zero, q, _one );\n\n\t}\n\n\tlookAt( eye, target, up ) {\n\n\t\tconst te = this.elements;\n\n\t\t_z.subVectors( eye, target );\n\n\t\tif ( _z.lengthSq() === 0 ) {\n\n\t\t\t// eye and target are in the same position\n\n\t\t\t_z.z = 1;\n\n\t\t}\n\n\t\t_z.normalize();\n\t\t_x.crossVectors( up, _z );\n\n\t\tif ( _x.lengthSq() === 0 ) {\n\n\t\t\t// up and z are parallel\n\n\t\t\tif ( Math.abs( up.z ) === 1 ) {\n\n\t\t\t\t_z.x += 0.0001;\n\n\t\t\t} else {\n\n\t\t\t\t_z.z += 0.0001;\n\n\t\t\t}\n\n\t\t\t_z.normalize();\n\t\t\t_x.crossVectors( up, _z );\n\n\t\t}\n\n\t\t_x.normalize();\n\t\t_y.crossVectors( _z, _x );\n\n\t\tte[ 0 ] = _x.x; te[ 4 ] = _y.x; te[ 8 ] = _z.x;\n\t\tte[ 1 ] = _x.y; te[ 5 ] = _y.y; te[ 9 ] = _z.y;\n\t\tte[ 2 ] = _x.z; te[ 6 ] = _y.z; te[ 10 ] = _z.z;\n\n\t\treturn this;\n\n\t}\n\n\tmultiply( m, n ) {\n\n\t\tif ( n !== undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead.' );\n\t\t\treturn this.multiplyMatrices( m, n );\n\n\t\t}\n\n\t\treturn this.multiplyMatrices( this, m );\n\n\t}\n\n\tpremultiply( m ) {\n\n\t\treturn this.multiplyMatrices( m, this );\n\n\t}\n\n\tmultiplyMatrices( a, b ) {\n\n\t\tconst ae = a.elements;\n\t\tconst be = b.elements;\n\t\tconst te = this.elements;\n\n\t\tconst a11 = ae[ 0 ], a12 = ae[ 4 ], a13 = ae[ 8 ], a14 = ae[ 12 ];\n\t\tconst a21 = ae[ 1 ], a22 = ae[ 5 ], a23 = ae[ 9 ], a24 = ae[ 13 ];\n\t\tconst a31 = ae[ 2 ], a32 = ae[ 6 ], a33 = ae[ 10 ], a34 = ae[ 14 ];\n\t\tconst a41 = ae[ 3 ], a42 = ae[ 7 ], a43 = ae[ 11 ], a44 = ae[ 15 ];\n\n\t\tconst b11 = be[ 0 ], b12 = be[ 4 ], b13 = be[ 8 ], b14 = be[ 12 ];\n\t\tconst b21 = be[ 1 ], b22 = be[ 5 ], b23 = be[ 9 ], b24 = be[ 13 ];\n\t\tconst b31 = be[ 2 ], b32 = be[ 6 ], b33 = be[ 10 ], b34 = be[ 14 ];\n\t\tconst b41 = be[ 3 ], b42 = be[ 7 ], b43 = be[ 11 ], b44 = be[ 15 ];\n\n\t\tte[ 0 ] = a11 * b11 + a12 * b21 + a13 * b31 + a14 * b41;\n\t\tte[ 4 ] = a11 * b12 + a12 * b22 + a13 * b32 + a14 * b42;\n\t\tte[ 8 ] = a11 * b13 + a12 * b23 + a13 * b33 + a14 * b43;\n\t\tte[ 12 ] = a11 * b14 + a12 * b24 + a13 * b34 + a14 * b44;\n\n\t\tte[ 1 ] = a21 * b11 + a22 * b21 + a23 * b31 + a24 * b41;\n\t\tte[ 5 ] = a21 * b12 + a22 * b22 + a23 * b32 + a24 * b42;\n\t\tte[ 9 ] = a21 * b13 + a22 * b23 + a23 * b33 + a24 * b43;\n\t\tte[ 13 ] = a21 * b14 + a22 * b24 + a23 * b34 + a24 * b44;\n\n\t\tte[ 2 ] = a31 * b11 + a32 * b21 + a33 * b31 + a34 * b41;\n\t\tte[ 6 ] = a31 * b12 + a32 * b22 + a33 * b32 + a34 * b42;\n\t\tte[ 10 ] = a31 * b13 + a32 * b23 + a33 * b33 + a34 * b43;\n\t\tte[ 14 ] = a31 * b14 + a32 * b24 + a33 * b34 + a34 * b44;\n\n\t\tte[ 3 ] = a41 * b11 + a42 * b21 + a43 * b31 + a44 * b41;\n\t\tte[ 7 ] = a41 * b12 + a42 * b22 + a43 * b32 + a44 * b42;\n\t\tte[ 11 ] = a41 * b13 + a42 * b23 + a43 * b33 + a44 * b43;\n\t\tte[ 15 ] = a41 * b14 + a42 * b24 + a43 * b34 + a44 * b44;\n\n\t\treturn this;\n\n\t}\n\n\tmultiplyScalar( s ) {\n\n\t\tconst te = this.elements;\n\n\t\tte[ 0 ] *= s; te[ 4 ] *= s; te[ 8 ] *= s; te[ 12 ] *= s;\n\t\tte[ 1 ] *= s; te[ 5 ] *= s; te[ 9 ] *= s; te[ 13 ] *= s;\n\t\tte[ 2 ] *= s; te[ 6 ] *= s; te[ 10 ] *= s; te[ 14 ] *= s;\n\t\tte[ 3 ] *= s; te[ 7 ] *= s; te[ 11 ] *= s; te[ 15 ] *= s;\n\n\t\treturn this;\n\n\t}\n\n\tdeterminant() {\n\n\t\tconst te = this.elements;\n\n\t\tconst n11 = te[ 0 ], n12 = te[ 4 ], n13 = te[ 8 ], n14 = te[ 12 ];\n\t\tconst n21 = te[ 1 ], n22 = te[ 5 ], n23 = te[ 9 ], n24 = te[ 13 ];\n\t\tconst n31 = te[ 2 ], n32 = te[ 6 ], n33 = te[ 10 ], n34 = te[ 14 ];\n\t\tconst n41 = te[ 3 ], n42 = te[ 7 ], n43 = te[ 11 ], n44 = te[ 15 ];\n\n\t\t//TODO: make this more efficient\n\t\t//( based on http://www.euclideanspace.com/maths/algebra/matrix/functions/inverse/fourD/index.htm )\n\n\t\treturn (\n\t\t\tn41 * (\n\t\t\t\t+ n14 * n23 * n32\n\t\t\t\t - n13 * n24 * n32\n\t\t\t\t - n14 * n22 * n33\n\t\t\t\t + n12 * n24 * n33\n\t\t\t\t + n13 * n22 * n34\n\t\t\t\t - n12 * n23 * n34\n\t\t\t) +\n\t\t\tn42 * (\n\t\t\t\t+ n11 * n23 * n34\n\t\t\t\t - n11 * n24 * n33\n\t\t\t\t + n14 * n21 * n33\n\t\t\t\t - n13 * n21 * n34\n\t\t\t\t + n13 * n24 * n31\n\t\t\t\t - n14 * n23 * n31\n\t\t\t) +\n\t\t\tn43 * (\n\t\t\t\t+ n11 * n24 * n32\n\t\t\t\t - n11 * n22 * n34\n\t\t\t\t - n14 * n21 * n32\n\t\t\t\t + n12 * n21 * n34\n\t\t\t\t + n14 * n22 * n31\n\t\t\t\t - n12 * n24 * n31\n\t\t\t) +\n\t\t\tn44 * (\n\t\t\t\t- n13 * n22 * n31\n\t\t\t\t - n11 * n23 * n32\n\t\t\t\t + n11 * n22 * n33\n\t\t\t\t + n13 * n21 * n32\n\t\t\t\t - n12 * n21 * n33\n\t\t\t\t + n12 * n23 * n31\n\t\t\t)\n\n\t\t);\n\n\t}\n\n\ttranspose() {\n\n\t\tconst te = this.elements;\n\t\tlet tmp;\n\n\t\ttmp = te[ 1 ]; te[ 1 ] = te[ 4 ]; te[ 4 ] = tmp;\n\t\ttmp = te[ 2 ]; te[ 2 ] = te[ 8 ]; te[ 8 ] = tmp;\n\t\ttmp = te[ 6 ]; te[ 6 ] = te[ 9 ]; te[ 9 ] = tmp;\n\n\t\ttmp = te[ 3 ]; te[ 3 ] = te[ 12 ]; te[ 12 ] = tmp;\n\t\ttmp = te[ 7 ]; te[ 7 ] = te[ 13 ]; te[ 13 ] = tmp;\n\t\ttmp = te[ 11 ]; te[ 11 ] = te[ 14 ]; te[ 14 ] = tmp;\n\n\t\treturn this;\n\n\t}\n\n\tsetPosition( x, y, z ) {\n\n\t\tconst te = this.elements;\n\n\t\tif ( x.isVector3 ) {\n\n\t\t\tte[ 12 ] = x.x;\n\t\t\tte[ 13 ] = x.y;\n\t\t\tte[ 14 ] = x.z;\n\n\t\t} else {\n\n\t\t\tte[ 12 ] = x;\n\t\t\tte[ 13 ] = y;\n\t\t\tte[ 14 ] = z;\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tinvert() {\n\n\t\t// based on http://www.euclideanspace.com/maths/algebra/matrix/functions/inverse/fourD/index.htm\n\t\tconst te = this.elements,\n\n\t\t\tn11 = te[ 0 ], n21 = te[ 1 ], n31 = te[ 2 ], n41 = te[ 3 ],\n\t\t\tn12 = te[ 4 ], n22 = te[ 5 ], n32 = te[ 6 ], n42 = te[ 7 ],\n\t\t\tn13 = te[ 8 ], n23 = te[ 9 ], n33 = te[ 10 ], n43 = te[ 11 ],\n\t\t\tn14 = te[ 12 ], n24 = te[ 13 ], n34 = te[ 14 ], n44 = te[ 15 ],\n\n\t\t\tt11 = n23 * n34 * n42 - n24 * n33 * n42 + n24 * n32 * n43 - n22 * n34 * n43 - n23 * n32 * n44 + n22 * n33 * n44,\n\t\t\tt12 = n14 * n33 * n42 - n13 * n34 * n42 - n14 * n32 * n43 + n12 * n34 * n43 + n13 * n32 * n44 - n12 * n33 * n44,\n\t\t\tt13 = n13 * n24 * n42 - n14 * n23 * n42 + n14 * n22 * n43 - n12 * n24 * n43 - n13 * n22 * n44 + n12 * n23 * n44,\n\t\t\tt14 = n14 * n23 * n32 - n13 * n24 * n32 - n14 * n22 * n33 + n12 * n24 * n33 + n13 * n22 * n34 - n12 * n23 * n34;\n\n\t\tconst det = n11 * t11 + n21 * t12 + n31 * t13 + n41 * t14;\n\n\t\tif ( det === 0 ) return this.set( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );\n\n\t\tconst detInv = 1 / det;\n\n\t\tte[ 0 ] = t11 * detInv;\n\t\tte[ 1 ] = ( n24 * n33 * n41 - n23 * n34 * n41 - n24 * n31 * n43 + n21 * n34 * n43 + n23 * n31 * n44 - n21 * n33 * n44 ) * detInv;\n\t\tte[ 2 ] = ( n22 * n34 * n41 - n24 * n32 * n41 + n24 * n31 * n42 - n21 * n34 * n42 - n22 * n31 * n44 + n21 * n32 * n44 ) * detInv;\n\t\tte[ 3 ] = ( n23 * n32 * n41 - n22 * n33 * n41 - n23 * n31 * n42 + n21 * n33 * n42 + n22 * n31 * n43 - n21 * n32 * n43 ) * detInv;\n\n\t\tte[ 4 ] = t12 * detInv;\n\t\tte[ 5 ] = ( n13 * n34 * n41 - n14 * n33 * n41 + n14 * n31 * n43 - n11 * n34 * n43 - n13 * n31 * n44 + n11 * n33 * n44 ) * detInv;\n\t\tte[ 6 ] = ( n14 * n32 * n41 - n12 * n34 * n41 - n14 * n31 * n42 + n11 * n34 * n42 + n12 * n31 * n44 - n11 * n32 * n44 ) * detInv;\n\t\tte[ 7 ] = ( n12 * n33 * n41 - n13 * n32 * n41 + n13 * n31 * n42 - n11 * n33 * n42 - n12 * n31 * n43 + n11 * n32 * n43 ) * detInv;\n\n\t\tte[ 8 ] = t13 * detInv;\n\t\tte[ 9 ] = ( n14 * n23 * n41 - n13 * n24 * n41 - n14 * n21 * n43 + n11 * n24 * n43 + n13 * n21 * n44 - n11 * n23 * n44 ) * detInv;\n\t\tte[ 10 ] = ( n12 * n24 * n41 - n14 * n22 * n41 + n14 * n21 * n42 - n11 * n24 * n42 - n12 * n21 * n44 + n11 * n22 * n44 ) * detInv;\n\t\tte[ 11 ] = ( n13 * n22 * n41 - n12 * n23 * n41 - n13 * n21 * n42 + n11 * n23 * n42 + n12 * n21 * n43 - n11 * n22 * n43 ) * detInv;\n\n\t\tte[ 12 ] = t14 * detInv;\n\t\tte[ 13 ] = ( n13 * n24 * n31 - n14 * n23 * n31 + n14 * n21 * n33 - n11 * n24 * n33 - n13 * n21 * n34 + n11 * n23 * n34 ) * detInv;\n\t\tte[ 14 ] = ( n14 * n22 * n31 - n12 * n24 * n31 - n14 * n21 * n32 + n11 * n24 * n32 + n12 * n21 * n34 - n11 * n22 * n34 ) * detInv;\n\t\tte[ 15 ] = ( n12 * n23 * n31 - n13 * n22 * n31 + n13 * n21 * n32 - n11 * n23 * n32 - n12 * n21 * n33 + n11 * n22 * n33 ) * detInv;\n\n\t\treturn this;\n\n\t}\n\n\tscale( v ) {\n\n\t\tconst te = this.elements;\n\t\tconst x = v.x, y = v.y, z = v.z;\n\n\t\tte[ 0 ] *= x; te[ 4 ] *= y; te[ 8 ] *= z;\n\t\tte[ 1 ] *= x; te[ 5 ] *= y; te[ 9 ] *= z;\n\t\tte[ 2 ] *= x; te[ 6 ] *= y; te[ 10 ] *= z;\n\t\tte[ 3 ] *= x; te[ 7 ] *= y; te[ 11 ] *= z;\n\n\t\treturn this;\n\n\t}\n\n\tgetMaxScaleOnAxis() {\n\n\t\tconst te = this.elements;\n\n\t\tconst scaleXSq = te[ 0 ] * te[ 0 ] + te[ 1 ] * te[ 1 ] + te[ 2 ] * te[ 2 ];\n\t\tconst scaleYSq = te[ 4 ] * te[ 4 ] + te[ 5 ] * te[ 5 ] + te[ 6 ] * te[ 6 ];\n\t\tconst scaleZSq = te[ 8 ] * te[ 8 ] + te[ 9 ] * te[ 9 ] + te[ 10 ] * te[ 10 ];\n\n\t\treturn Math.sqrt( Math.max( scaleXSq, scaleYSq, scaleZSq ) );\n\n\t}\n\n\tmakeTranslation( x, y, z ) {\n\n\t\tthis.set(\n\n\t\t\t1, 0, 0, x,\n\t\t\t0, 1, 0, y,\n\t\t\t0, 0, 1, z,\n\t\t\t0, 0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tmakeRotationX( theta ) {\n\n\t\tconst c = Math.cos( theta ), s = Math.sin( theta );\n\n\t\tthis.set(\n\n\t\t\t1, 0, 0, 0,\n\t\t\t0, c, - s, 0,\n\t\t\t0, s, c, 0,\n\t\t\t0, 0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tmakeRotationY( theta ) {\n\n\t\tconst c = Math.cos( theta ), s = Math.sin( theta );\n\n\t\tthis.set(\n\n\t\t\t c, 0, s, 0,\n\t\t\t 0, 1, 0, 0,\n\t\t\t- s, 0, c, 0,\n\t\t\t 0, 0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tmakeRotationZ( theta ) {\n\n\t\tconst c = Math.cos( theta ), s = Math.sin( theta );\n\n\t\tthis.set(\n\n\t\t\tc, - s, 0, 0,\n\t\t\ts, c, 0, 0,\n\t\t\t0, 0, 1, 0,\n\t\t\t0, 0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tmakeRotationAxis( axis, angle ) {\n\n\t\t// Based on http://www.gamedev.net/reference/articles/article1199.asp\n\n\t\tconst c = Math.cos( angle );\n\t\tconst s = Math.sin( angle );\n\t\tconst t = 1 - c;\n\t\tconst x = axis.x, y = axis.y, z = axis.z;\n\t\tconst tx = t * x, ty = t * y;\n\n\t\tthis.set(\n\n\t\t\ttx * x + c, tx * y - s * z, tx * z + s * y, 0,\n\t\t\ttx * y + s * z, ty * y + c, ty * z - s * x, 0,\n\t\t\ttx * z - s * y, ty * z + s * x, t * z * z + c, 0,\n\t\t\t0, 0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tmakeScale( x, y, z ) {\n\n\t\tthis.set(\n\n\t\t\tx, 0, 0, 0,\n\t\t\t0, y, 0, 0,\n\t\t\t0, 0, z, 0,\n\t\t\t0, 0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tmakeShear( xy, xz, yx, yz, zx, zy ) {\n\n\t\tthis.set(\n\n\t\t\t1, yx, zx, 0,\n\t\t\txy, 1, zy, 0,\n\t\t\txz, yz, 1, 0,\n\t\t\t0, 0, 0, 1\n\n\t\t);\n\n\t\treturn this;\n\n\t}\n\n\tcompose( position, quaternion, scale ) {\n\n\t\tconst te = this.elements;\n\n\t\tconst x = quaternion._x, y = quaternion._y, z = quaternion._z, w = quaternion._w;\n\t\tconst x2 = x + x,\ty2 = y + y, z2 = z + z;\n\t\tconst xx = x * x2, xy = x * y2, xz = x * z2;\n\t\tconst yy = y * y2, yz = y * z2, zz = z * z2;\n\t\tconst wx = w * x2, wy = w * y2, wz = w * z2;\n\n\t\tconst sx = scale.x, sy = scale.y, sz = scale.z;\n\n\t\tte[ 0 ] = ( 1 - ( yy + zz ) ) * sx;\n\t\tte[ 1 ] = ( xy + wz ) * sx;\n\t\tte[ 2 ] = ( xz - wy ) * sx;\n\t\tte[ 3 ] = 0;\n\n\t\tte[ 4 ] = ( xy - wz ) * sy;\n\t\tte[ 5 ] = ( 1 - ( xx + zz ) ) * sy;\n\t\tte[ 6 ] = ( yz + wx ) * sy;\n\t\tte[ 7 ] = 0;\n\n\t\tte[ 8 ] = ( xz + wy ) * sz;\n\t\tte[ 9 ] = ( yz - wx ) * sz;\n\t\tte[ 10 ] = ( 1 - ( xx + yy ) ) * sz;\n\t\tte[ 11 ] = 0;\n\n\t\tte[ 12 ] = position.x;\n\t\tte[ 13 ] = position.y;\n\t\tte[ 14 ] = position.z;\n\t\tte[ 15 ] = 1;\n\n\t\treturn this;\n\n\t}\n\n\tdecompose( position, quaternion, scale ) {\n\n\t\tconst te = this.elements;\n\n\t\tlet sx = _v1$5.set( te[ 0 ], te[ 1 ], te[ 2 ] ).length();\n\t\tconst sy = _v1$5.set( te[ 4 ], te[ 5 ], te[ 6 ] ).length();\n\t\tconst sz = _v1$5.set( te[ 8 ], te[ 9 ], te[ 10 ] ).length();\n\n\t\t// if determine is negative, we need to invert one scale\n\t\tconst det = this.determinant();\n\t\tif ( det < 0 ) sx = - sx;\n\n\t\tposition.x = te[ 12 ];\n\t\tposition.y = te[ 13 ];\n\t\tposition.z = te[ 14 ];\n\n\t\t// scale the rotation part\n\t\t_m1$2.copy( this );\n\n\t\tconst invSX = 1 / sx;\n\t\tconst invSY = 1 / sy;\n\t\tconst invSZ = 1 / sz;\n\n\t\t_m1$2.elements[ 0 ] *= invSX;\n\t\t_m1$2.elements[ 1 ] *= invSX;\n\t\t_m1$2.elements[ 2 ] *= invSX;\n\n\t\t_m1$2.elements[ 4 ] *= invSY;\n\t\t_m1$2.elements[ 5 ] *= invSY;\n\t\t_m1$2.elements[ 6 ] *= invSY;\n\n\t\t_m1$2.elements[ 8 ] *= invSZ;\n\t\t_m1$2.elements[ 9 ] *= invSZ;\n\t\t_m1$2.elements[ 10 ] *= invSZ;\n\n\t\tquaternion.setFromRotationMatrix( _m1$2 );\n\n\t\tscale.x = sx;\n\t\tscale.y = sy;\n\t\tscale.z = sz;\n\n\t\treturn this;\n\n\t}\n\n\tmakePerspective( left, right, top, bottom, near, far ) {\n\n\t\tif ( far === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Matrix4: .makePerspective() has been redefined and has a new signature. Please check the docs.' );\n\n\t\t}\n\n\t\tconst te = this.elements;\n\t\tconst x = 2 * near / ( right - left );\n\t\tconst y = 2 * near / ( top - bottom );\n\n\t\tconst a = ( right + left ) / ( right - left );\n\t\tconst b = ( top + bottom ) / ( top - bottom );\n\t\tconst c = - ( far + near ) / ( far - near );\n\t\tconst d = - 2 * far * near / ( far - near );\n\n\t\tte[ 0 ] = x;\tte[ 4 ] = 0;\tte[ 8 ] = a;\tte[ 12 ] = 0;\n\t\tte[ 1 ] = 0;\tte[ 5 ] = y;\tte[ 9 ] = b;\tte[ 13 ] = 0;\n\t\tte[ 2 ] = 0;\tte[ 6 ] = 0;\tte[ 10 ] = c;\tte[ 14 ] = d;\n\t\tte[ 3 ] = 0;\tte[ 7 ] = 0;\tte[ 11 ] = - 1;\tte[ 15 ] = 0;\n\n\t\treturn this;\n\n\t}\n\n\tmakeOrthographic( left, right, top, bottom, near, far ) {\n\n\t\tconst te = this.elements;\n\t\tconst w = 1.0 / ( right - left );\n\t\tconst h = 1.0 / ( top - bottom );\n\t\tconst p = 1.0 / ( far - near );\n\n\t\tconst x = ( right + left ) * w;\n\t\tconst y = ( top + bottom ) * h;\n\t\tconst z = ( far + near ) * p;\n\n\t\tte[ 0 ] = 2 * w;\tte[ 4 ] = 0;\tte[ 8 ] = 0;\tte[ 12 ] = - x;\n\t\tte[ 1 ] = 0;\tte[ 5 ] = 2 * h;\tte[ 9 ] = 0;\tte[ 13 ] = - y;\n\t\tte[ 2 ] = 0;\tte[ 6 ] = 0;\tte[ 10 ] = - 2 * p;\tte[ 14 ] = - z;\n\t\tte[ 3 ] = 0;\tte[ 7 ] = 0;\tte[ 11 ] = 0;\tte[ 15 ] = 1;\n\n\t\treturn this;\n\n\t}\n\n\tequals( matrix ) {\n\n\t\tconst te = this.elements;\n\t\tconst me = matrix.elements;\n\n\t\tfor ( let i = 0; i < 16; i ++ ) {\n\n\t\t\tif ( te[ i ] !== me[ i ] ) return false;\n\n\t\t}\n\n\t\treturn true;\n\n\t}\n\n\tfromArray( array, offset = 0 ) {\n\n\t\tfor ( let i = 0; i < 16; i ++ ) {\n\n\t\t\tthis.elements[ i ] = array[ i + offset ];\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\ttoArray( array = [], offset = 0 ) {\n\n\t\tconst te = this.elements;\n\n\t\tarray[ offset ] = te[ 0 ];\n\t\tarray[ offset + 1 ] = te[ 1 ];\n\t\tarray[ offset + 2 ] = te[ 2 ];\n\t\tarray[ offset + 3 ] = te[ 3 ];\n\n\t\tarray[ offset + 4 ] = te[ 4 ];\n\t\tarray[ offset + 5 ] = te[ 5 ];\n\t\tarray[ offset + 6 ] = te[ 6 ];\n\t\tarray[ offset + 7 ] = te[ 7 ];\n\n\t\tarray[ offset + 8 ] = te[ 8 ];\n\t\tarray[ offset + 9 ] = te[ 9 ];\n\t\tarray[ offset + 10 ] = te[ 10 ];\n\t\tarray[ offset + 11 ] = te[ 11 ];\n\n\t\tarray[ offset + 12 ] = te[ 12 ];\n\t\tarray[ offset + 13 ] = te[ 13 ];\n\t\tarray[ offset + 14 ] = te[ 14 ];\n\t\tarray[ offset + 15 ] = te[ 15 ];\n\n\t\treturn array;\n\n\t}\n\n}\n\nMatrix4.prototype.isMatrix4 = true;\n\nconst _v1$5 = /*@__PURE__*/ new Vector3();\nconst _m1$2 = /*@__PURE__*/ new Matrix4();\nconst _zero = /*@__PURE__*/ new Vector3( 0, 0, 0 );\nconst _one = /*@__PURE__*/ new Vector3( 1, 1, 1 );\nconst _x = /*@__PURE__*/ new Vector3();\nconst _y = /*@__PURE__*/ new Vector3();\nconst _z = /*@__PURE__*/ new Vector3();\n\nconst _matrix$1 = /*@__PURE__*/ new Matrix4();\nconst _quaternion$3 = /*@__PURE__*/ new Quaternion();\n\nclass Euler {\n\n\tconstructor( x = 0, y = 0, z = 0, order = Euler.DefaultOrder ) {\n\n\t\tthis._x = x;\n\t\tthis._y = y;\n\t\tthis._z = z;\n\t\tthis._order = order;\n\n\t}\n\n\tget x() {\n\n\t\treturn this._x;\n\n\t}\n\n\tset x( value ) {\n\n\t\tthis._x = value;\n\t\tthis._onChangeCallback();\n\n\t}\n\n\tget y() {\n\n\t\treturn this._y;\n\n\t}\n\n\tset y( value ) {\n\n\t\tthis._y = value;\n\t\tthis._onChangeCallback();\n\n\t}\n\n\tget z() {\n\n\t\treturn this._z;\n\n\t}\n\n\tset z( value ) {\n\n\t\tthis._z = value;\n\t\tthis._onChangeCallback();\n\n\t}\n\n\tget order() {\n\n\t\treturn this._order;\n\n\t}\n\n\tset order( value ) {\n\n\t\tthis._order = value;\n\t\tthis._onChangeCallback();\n\n\t}\n\n\tset( x, y, z, order ) {\n\n\t\tthis._x = x;\n\t\tthis._y = y;\n\t\tthis._z = z;\n\t\tthis._order = order || this._order;\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor( this._x, this._y, this._z, this._order );\n\n\t}\n\n\tcopy( euler ) {\n\n\t\tthis._x = euler._x;\n\t\tthis._y = euler._y;\n\t\tthis._z = euler._z;\n\t\tthis._order = euler._order;\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tsetFromRotationMatrix( m, order, update ) {\n\n\t\t// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)\n\n\t\tconst te = m.elements;\n\t\tconst m11 = te[ 0 ], m12 = te[ 4 ], m13 = te[ 8 ];\n\t\tconst m21 = te[ 1 ], m22 = te[ 5 ], m23 = te[ 9 ];\n\t\tconst m31 = te[ 2 ], m32 = te[ 6 ], m33 = te[ 10 ];\n\n\t\torder = order || this._order;\n\n\t\tswitch ( order ) {\n\n\t\t\tcase 'XYZ':\n\n\t\t\t\tthis._y = Math.asin( clamp( m13, - 1, 1 ) );\n\n\t\t\t\tif ( Math.abs( m13 ) < 0.9999999 ) {\n\n\t\t\t\t\tthis._x = Math.atan2( - m23, m33 );\n\t\t\t\t\tthis._z = Math.atan2( - m12, m11 );\n\n\t\t\t\t} else {\n\n\t\t\t\t\tthis._x = Math.atan2( m32, m22 );\n\t\t\t\t\tthis._z = 0;\n\n\t\t\t\t}\n\n\t\t\t\tbreak;\n\n\t\t\tcase 'YXZ':\n\n\t\t\t\tthis._x = Math.asin( - clamp( m23, - 1, 1 ) );\n\n\t\t\t\tif ( Math.abs( m23 ) < 0.9999999 ) {\n\n\t\t\t\t\tthis._y = Math.atan2( m13, m33 );\n\t\t\t\t\tthis._z = Math.atan2( m21, m22 );\n\n\t\t\t\t} else {\n\n\t\t\t\t\tthis._y = Math.atan2( - m31, m11 );\n\t\t\t\t\tthis._z = 0;\n\n\t\t\t\t}\n\n\t\t\t\tbreak;\n\n\t\t\tcase 'ZXY':\n\n\t\t\t\tthis._x = Math.asin( clamp( m32, - 1, 1 ) );\n\n\t\t\t\tif ( Math.abs( m32 ) < 0.9999999 ) {\n\n\t\t\t\t\tthis._y = Math.atan2( - m31, m33 );\n\t\t\t\t\tthis._z = Math.atan2( - m12, m22 );\n\n\t\t\t\t} else {\n\n\t\t\t\t\tthis._y = 0;\n\t\t\t\t\tthis._z = Math.atan2( m21, m11 );\n\n\t\t\t\t}\n\n\t\t\t\tbreak;\n\n\t\t\tcase 'ZYX':\n\n\t\t\t\tthis._y = Math.asin( - clamp( m31, - 1, 1 ) );\n\n\t\t\t\tif ( Math.abs( m31 ) < 0.9999999 ) {\n\n\t\t\t\t\tthis._x = Math.atan2( m32, m33 );\n\t\t\t\t\tthis._z = Math.atan2( m21, m11 );\n\n\t\t\t\t} else {\n\n\t\t\t\t\tthis._x = 0;\n\t\t\t\t\tthis._z = Math.atan2( - m12, m22 );\n\n\t\t\t\t}\n\n\t\t\t\tbreak;\n\n\t\t\tcase 'YZX':\n\n\t\t\t\tthis._z = Math.asin( clamp( m21, - 1, 1 ) );\n\n\t\t\t\tif ( Math.abs( m21 ) < 0.9999999 ) {\n\n\t\t\t\t\tthis._x = Math.atan2( - m23, m22 );\n\t\t\t\t\tthis._y = Math.atan2( - m31, m11 );\n\n\t\t\t\t} else {\n\n\t\t\t\t\tthis._x = 0;\n\t\t\t\t\tthis._y = Math.atan2( m13, m33 );\n\n\t\t\t\t}\n\n\t\t\t\tbreak;\n\n\t\t\tcase 'XZY':\n\n\t\t\t\tthis._z = Math.asin( - clamp( m12, - 1, 1 ) );\n\n\t\t\t\tif ( Math.abs( m12 ) < 0.9999999 ) {\n\n\t\t\t\t\tthis._x = Math.atan2( m32, m22 );\n\t\t\t\t\tthis._y = Math.atan2( m13, m11 );\n\n\t\t\t\t} else {\n\n\t\t\t\t\tthis._x = Math.atan2( - m23, m33 );\n\t\t\t\t\tthis._y = 0;\n\n\t\t\t\t}\n\n\t\t\t\tbreak;\n\n\t\t\tdefault:\n\n\t\t\t\tconsole.warn( 'THREE.Euler: .setFromRotationMatrix() encountered an unknown order: ' + order );\n\n\t\t}\n\n\t\tthis._order = order;\n\n\t\tif ( update !== false ) this._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\tsetFromQuaternion( q, order, update ) {\n\n\t\t_matrix$1.makeRotationFromQuaternion( q );\n\n\t\treturn this.setFromRotationMatrix( _matrix$1, order, update );\n\n\t}\n\n\tsetFromVector3( v, order ) {\n\n\t\treturn this.set( v.x, v.y, v.z, order || this._order );\n\n\t}\n\n\treorder( newOrder ) {\n\n\t\t// WARNING: this discards revolution information -bhouston\n\n\t\t_quaternion$3.setFromEuler( this );\n\n\t\treturn this.setFromQuaternion( _quaternion$3, newOrder );\n\n\t}\n\n\tequals( euler ) {\n\n\t\treturn ( euler._x === this._x ) && ( euler._y === this._y ) && ( euler._z === this._z ) && ( euler._order === this._order );\n\n\t}\n\n\tfromArray( array ) {\n\n\t\tthis._x = array[ 0 ];\n\t\tthis._y = array[ 1 ];\n\t\tthis._z = array[ 2 ];\n\t\tif ( array[ 3 ] !== undefined ) this._order = array[ 3 ];\n\n\t\tthis._onChangeCallback();\n\n\t\treturn this;\n\n\t}\n\n\ttoArray( array = [], offset = 0 ) {\n\n\t\tarray[ offset ] = this._x;\n\t\tarray[ offset + 1 ] = this._y;\n\t\tarray[ offset + 2 ] = this._z;\n\t\tarray[ offset + 3 ] = this._order;\n\n\t\treturn array;\n\n\t}\n\n\ttoVector3( optionalResult ) {\n\n\t\tif ( optionalResult ) {\n\n\t\t\treturn optionalResult.set( this._x, this._y, this._z );\n\n\t\t} else {\n\n\t\t\treturn new Vector3( this._x, this._y, this._z );\n\n\t\t}\n\n\t}\n\n\t_onChange( callback ) {\n\n\t\tthis._onChangeCallback = callback;\n\n\t\treturn this;\n\n\t}\n\n\t_onChangeCallback() {}\n\n}\n\nEuler.prototype.isEuler = true;\n\nEuler.DefaultOrder = 'XYZ';\nEuler.RotationOrders = [ 'XYZ', 'YZX', 'ZXY', 'XZY', 'YXZ', 'ZYX' ];\n\nclass Layers {\n\n\tconstructor() {\n\n\t\tthis.mask = 1 | 0;\n\n\t}\n\n\tset( channel ) {\n\n\t\tthis.mask = 1 << channel | 0;\n\n\t}\n\n\tenable( channel ) {\n\n\t\tthis.mask |= 1 << channel | 0;\n\n\t}\n\n\tenableAll() {\n\n\t\tthis.mask = 0xffffffff | 0;\n\n\t}\n\n\ttoggle( channel ) {\n\n\t\tthis.mask ^= 1 << channel | 0;\n\n\t}\n\n\tdisable( channel ) {\n\n\t\tthis.mask &= ~ ( 1 << channel | 0 );\n\n\t}\n\n\tdisableAll() {\n\n\t\tthis.mask = 0;\n\n\t}\n\n\ttest( layers ) {\n\n\t\treturn ( this.mask & layers.mask ) !== 0;\n\n\t}\n\n}\n\nlet _object3DId = 0;\n\nconst _v1$4 = /*@__PURE__*/ new Vector3();\nconst _q1 = /*@__PURE__*/ new Quaternion();\nconst _m1$1 = /*@__PURE__*/ new Matrix4();\nconst _target = /*@__PURE__*/ new Vector3();\n\nconst _position$3 = /*@__PURE__*/ new Vector3();\nconst _scale$2 = /*@__PURE__*/ new Vector3();\nconst _quaternion$2 = /*@__PURE__*/ new Quaternion();\n\nconst _xAxis = /*@__PURE__*/ new Vector3( 1, 0, 0 );\nconst _yAxis = /*@__PURE__*/ new Vector3( 0, 1, 0 );\nconst _zAxis = /*@__PURE__*/ new Vector3( 0, 0, 1 );\n\nconst _addedEvent = { type: 'added' };\nconst _removedEvent = { type: 'removed' };\n\nclass Object3D extends EventDispatcher {\n\n\tconstructor() {\n\n\t\tsuper();\n\n\t\tObject.defineProperty( this, 'id', { value: _object3DId ++ } );\n\n\t\tthis.uuid = generateUUID();\n\n\t\tthis.name = '';\n\t\tthis.type = 'Object3D';\n\n\t\tthis.parent = null;\n\t\tthis.children = [];\n\n\t\tthis.up = Object3D.DefaultUp.clone();\n\n\t\tconst position = new Vector3();\n\t\tconst rotation = new Euler();\n\t\tconst quaternion = new Quaternion();\n\t\tconst scale = new Vector3( 1, 1, 1 );\n\n\t\tfunction onRotationChange() {\n\n\t\t\tquaternion.setFromEuler( rotation, false );\n\n\t\t}\n\n\t\tfunction onQuaternionChange() {\n\n\t\t\trotation.setFromQuaternion( quaternion, undefined, false );\n\n\t\t}\n\n\t\trotation._onChange( onRotationChange );\n\t\tquaternion._onChange( onQuaternionChange );\n\n\t\tObject.defineProperties( this, {\n\t\t\tposition: {\n\t\t\t\tconfigurable: true,\n\t\t\t\tenumerable: true,\n\t\t\t\tvalue: position\n\t\t\t},\n\t\t\trotation: {\n\t\t\t\tconfigurable: true,\n\t\t\t\tenumerable: true,\n\t\t\t\tvalue: rotation\n\t\t\t},\n\t\t\tquaternion: {\n\t\t\t\tconfigurable: true,\n\t\t\t\tenumerable: true,\n\t\t\t\tvalue: quaternion\n\t\t\t},\n\t\t\tscale: {\n\t\t\t\tconfigurable: true,\n\t\t\t\tenumerable: true,\n\t\t\t\tvalue: scale\n\t\t\t},\n\t\t\tmodelViewMatrix: {\n\t\t\t\tvalue: new Matrix4()\n\t\t\t},\n\t\t\tnormalMatrix: {\n\t\t\t\tvalue: new Matrix3()\n\t\t\t}\n\t\t} );\n\n\t\tthis.matrix = new Matrix4();\n\t\tthis.matrixWorld = new Matrix4();\n\n\t\tthis.matrixAutoUpdate = Object3D.DefaultMatrixAutoUpdate;\n\t\tthis.matrixWorldNeedsUpdate = false;\n\n\t\tthis.layers = new Layers();\n\t\tthis.visible = true;\n\n\t\tthis.castShadow = false;\n\t\tthis.receiveShadow = false;\n\n\t\tthis.frustumCulled = true;\n\t\tthis.renderOrder = 0;\n\n\t\tthis.animations = [];\n\n\t\tthis.userData = {};\n\n\t}\n\n\tonBeforeRender() {}\n\tonAfterRender() {}\n\n\tapplyMatrix4( matrix ) {\n\n\t\tif ( this.matrixAutoUpdate ) this.updateMatrix();\n\n\t\tthis.matrix.premultiply( matrix );\n\n\t\tthis.matrix.decompose( this.position, this.quaternion, this.scale );\n\n\t}\n\n\tapplyQuaternion( q ) {\n\n\t\tthis.quaternion.premultiply( q );\n\n\t\treturn this;\n\n\t}\n\n\tsetRotationFromAxisAngle( axis, angle ) {\n\n\t\t// assumes axis is normalized\n\n\t\tthis.quaternion.setFromAxisAngle( axis, angle );\n\n\t}\n\n\tsetRotationFromEuler( euler ) {\n\n\t\tthis.quaternion.setFromEuler( euler, true );\n\n\t}\n\n\tsetRotationFromMatrix( m ) {\n\n\t\t// assumes the upper 3x3 of m is a pure rotation matrix (i.e, unscaled)\n\n\t\tthis.quaternion.setFromRotationMatrix( m );\n\n\t}\n\n\tsetRotationFromQuaternion( q ) {\n\n\t\t// assumes q is normalized\n\n\t\tthis.quaternion.copy( q );\n\n\t}\n\n\trotateOnAxis( axis, angle ) {\n\n\t\t// rotate object on axis in object space\n\t\t// axis is assumed to be normalized\n\n\t\t_q1.setFromAxisAngle( axis, angle );\n\n\t\tthis.quaternion.multiply( _q1 );\n\n\t\treturn this;\n\n\t}\n\n\trotateOnWorldAxis( axis, angle ) {\n\n\t\t// rotate object on axis in world space\n\t\t// axis is assumed to be normalized\n\t\t// method assumes no rotated parent\n\n\t\t_q1.setFromAxisAngle( axis, angle );\n\n\t\tthis.quaternion.premultiply( _q1 );\n\n\t\treturn this;\n\n\t}\n\n\trotateX( angle ) {\n\n\t\treturn this.rotateOnAxis( _xAxis, angle );\n\n\t}\n\n\trotateY( angle ) {\n\n\t\treturn this.rotateOnAxis( _yAxis, angle );\n\n\t}\n\n\trotateZ( angle ) {\n\n\t\treturn this.rotateOnAxis( _zAxis, angle );\n\n\t}\n\n\ttranslateOnAxis( axis, distance ) {\n\n\t\t// translate object by distance along axis in object space\n\t\t// axis is assumed to be normalized\n\n\t\t_v1$4.copy( axis ).applyQuaternion( this.quaternion );\n\n\t\tthis.position.add( _v1$4.multiplyScalar( distance ) );\n\n\t\treturn this;\n\n\t}\n\n\ttranslateX( distance ) {\n\n\t\treturn this.translateOnAxis( _xAxis, distance );\n\n\t}\n\n\ttranslateY( distance ) {\n\n\t\treturn this.translateOnAxis( _yAxis, distance );\n\n\t}\n\n\ttranslateZ( distance ) {\n\n\t\treturn this.translateOnAxis( _zAxis, distance );\n\n\t}\n\n\tlocalToWorld( vector ) {\n\n\t\treturn vector.applyMatrix4( this.matrixWorld );\n\n\t}\n\n\tworldToLocal( vector ) {\n\n\t\treturn vector.applyMatrix4( _m1$1.copy( this.matrixWorld ).invert() );\n\n\t}\n\n\tlookAt( x, y, z ) {\n\n\t\t// This method does not support objects having non-uniformly-scaled parent(s)\n\n\t\tif ( x.isVector3 ) {\n\n\t\t\t_target.copy( x );\n\n\t\t} else {\n\n\t\t\t_target.set( x, y, z );\n\n\t\t}\n\n\t\tconst parent = this.parent;\n\n\t\tthis.updateWorldMatrix( true, false );\n\n\t\t_position$3.setFromMatrixPosition( this.matrixWorld );\n\n\t\tif ( this.isCamera || this.isLight ) {\n\n\t\t\t_m1$1.lookAt( _position$3, _target, this.up );\n\n\t\t} else {\n\n\t\t\t_m1$1.lookAt( _target, _position$3, this.up );\n\n\t\t}\n\n\t\tthis.quaternion.setFromRotationMatrix( _m1$1 );\n\n\t\tif ( parent ) {\n\n\t\t\t_m1$1.extractRotation( parent.matrixWorld );\n\t\t\t_q1.setFromRotationMatrix( _m1$1 );\n\t\t\tthis.quaternion.premultiply( _q1.invert() );\n\n\t\t}\n\n\t}\n\n\tadd( object ) {\n\n\t\tif ( arguments.length > 1 ) {\n\n\t\t\tfor ( let i = 0; i < arguments.length; i ++ ) {\n\n\t\t\t\tthis.add( arguments[ i ] );\n\n\t\t\t}\n\n\t\t\treturn this;\n\n\t\t}\n\n\t\tif ( object === this ) {\n\n\t\t\tconsole.error( 'THREE.Object3D.add: object can\\'t be added as a child of itself.', object );\n\t\t\treturn this;\n\n\t\t}\n\n\t\tif ( object && object.isObject3D ) {\n\n\t\t\tif ( object.parent !== null ) {\n\n\t\t\t\tobject.parent.remove( object );\n\n\t\t\t}\n\n\t\t\tobject.parent = this;\n\t\t\tthis.children.push( object );\n\n\t\t\tobject.dispatchEvent( _addedEvent );\n\n\t\t} else {\n\n\t\t\tconsole.error( 'THREE.Object3D.add: object not an instance of THREE.Object3D.', object );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tremove( object ) {\n\n\t\tif ( arguments.length > 1 ) {\n\n\t\t\tfor ( let i = 0; i < arguments.length; i ++ ) {\n\n\t\t\t\tthis.remove( arguments[ i ] );\n\n\t\t\t}\n\n\t\t\treturn this;\n\n\t\t}\n\n\t\tconst index = this.children.indexOf( object );\n\n\t\tif ( index !== - 1 ) {\n\n\t\t\tobject.parent = null;\n\t\t\tthis.children.splice( index, 1 );\n\n\t\t\tobject.dispatchEvent( _removedEvent );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tremoveFromParent() {\n\n\t\tconst parent = this.parent;\n\n\t\tif ( parent !== null ) {\n\n\t\t\tparent.remove( this );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tclear() {\n\n\t\tfor ( let i = 0; i < this.children.length; i ++ ) {\n\n\t\t\tconst object = this.children[ i ];\n\n\t\t\tobject.parent = null;\n\n\t\t\tobject.dispatchEvent( _removedEvent );\n\n\t\t}\n\n\t\tthis.children.length = 0;\n\n\t\treturn this;\n\n\n\t}\n\n\tattach( object ) {\n\n\t\t// adds object as a child of this, while maintaining the object's world transform\n\n\t\tthis.updateWorldMatrix( true, false );\n\n\t\t_m1$1.copy( this.matrixWorld ).invert();\n\n\t\tif ( object.parent !== null ) {\n\n\t\t\tobject.parent.updateWorldMatrix( true, false );\n\n\t\t\t_m1$1.multiply( object.parent.matrixWorld );\n\n\t\t}\n\n\t\tobject.applyMatrix4( _m1$1 );\n\n\t\tthis.add( object );\n\n\t\tobject.updateWorldMatrix( false, true );\n\n\t\treturn this;\n\n\t}\n\n\tgetObjectById( id ) {\n\n\t\treturn this.getObjectByProperty( 'id', id );\n\n\t}\n\n\tgetObjectByName( name ) {\n\n\t\treturn this.getObjectByProperty( 'name', name );\n\n\t}\n\n\tgetObjectByProperty( name, value ) {\n\n\t\tif ( this[ name ] === value ) return this;\n\n\t\tfor ( let i = 0, l = this.children.length; i < l; i ++ ) {\n\n\t\t\tconst child = this.children[ i ];\n\t\t\tconst object = child.getObjectByProperty( name, value );\n\n\t\t\tif ( object !== undefined ) {\n\n\t\t\t\treturn object;\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn undefined;\n\n\t}\n\n\tgetWorldPosition( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Object3D: .getWorldPosition() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\tthis.updateWorldMatrix( true, false );\n\n\t\treturn target.setFromMatrixPosition( this.matrixWorld );\n\n\t}\n\n\tgetWorldQuaternion( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Object3D: .getWorldQuaternion() target is now required' );\n\t\t\ttarget = new Quaternion();\n\n\t\t}\n\n\t\tthis.updateWorldMatrix( true, false );\n\n\t\tthis.matrixWorld.decompose( _position$3, target, _scale$2 );\n\n\t\treturn target;\n\n\t}\n\n\tgetWorldScale( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Object3D: .getWorldScale() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\tthis.updateWorldMatrix( true, false );\n\n\t\tthis.matrixWorld.decompose( _position$3, _quaternion$2, target );\n\n\t\treturn target;\n\n\t}\n\n\tgetWorldDirection( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Object3D: .getWorldDirection() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\tthis.updateWorldMatrix( true, false );\n\n\t\tconst e = this.matrixWorld.elements;\n\n\t\treturn target.set( e[ 8 ], e[ 9 ], e[ 10 ] ).normalize();\n\n\t}\n\n\traycast() {}\n\n\ttraverse( callback ) {\n\n\t\tcallback( this );\n\n\t\tconst children = this.children;\n\n\t\tfor ( let i = 0, l = children.length; i < l; i ++ ) {\n\n\t\t\tchildren[ i ].traverse( callback );\n\n\t\t}\n\n\t}\n\n\ttraverseVisible( callback ) {\n\n\t\tif ( this.visible === false ) return;\n\n\t\tcallback( this );\n\n\t\tconst children = this.children;\n\n\t\tfor ( let i = 0, l = children.length; i < l; i ++ ) {\n\n\t\t\tchildren[ i ].traverseVisible( callback );\n\n\t\t}\n\n\t}\n\n\ttraverseAncestors( callback ) {\n\n\t\tconst parent = this.parent;\n\n\t\tif ( parent !== null ) {\n\n\t\t\tcallback( parent );\n\n\t\t\tparent.traverseAncestors( callback );\n\n\t\t}\n\n\t}\n\n\tupdateMatrix() {\n\n\t\tthis.matrix.compose( this.position, this.quaternion, this.scale );\n\n\t\tthis.matrixWorldNeedsUpdate = true;\n\n\t}\n\n\tupdateMatrixWorld( force ) {\n\n\t\tif ( this.matrixAutoUpdate ) this.updateMatrix();\n\n\t\tif ( this.matrixWorldNeedsUpdate || force ) {\n\n\t\t\tif ( this.parent === null ) {\n\n\t\t\t\tthis.matrixWorld.copy( this.matrix );\n\n\t\t\t} else {\n\n\t\t\t\tthis.matrixWorld.multiplyMatrices( this.parent.matrixWorld, this.matrix );\n\n\t\t\t}\n\n\t\t\tthis.matrixWorldNeedsUpdate = false;\n\n\t\t\tforce = true;\n\n\t\t}\n\n\t\t// update children\n\n\t\tconst children = this.children;\n\n\t\tfor ( let i = 0, l = children.length; i < l; i ++ ) {\n\n\t\t\tchildren[ i ].updateMatrixWorld( force );\n\n\t\t}\n\n\t}\n\n\tupdateWorldMatrix( updateParents, updateChildren ) {\n\n\t\tconst parent = this.parent;\n\n\t\tif ( updateParents === true && parent !== null ) {\n\n\t\t\tparent.updateWorldMatrix( true, false );\n\n\t\t}\n\n\t\tif ( this.matrixAutoUpdate ) this.updateMatrix();\n\n\t\tif ( this.parent === null ) {\n\n\t\t\tthis.matrixWorld.copy( this.matrix );\n\n\t\t} else {\n\n\t\t\tthis.matrixWorld.multiplyMatrices( this.parent.matrixWorld, this.matrix );\n\n\t\t}\n\n\t\t// update children\n\n\t\tif ( updateChildren === true ) {\n\n\t\t\tconst children = this.children;\n\n\t\t\tfor ( let i = 0, l = children.length; i < l; i ++ ) {\n\n\t\t\t\tchildren[ i ].updateWorldMatrix( false, true );\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\ttoJSON( meta ) {\n\n\t\t// meta is a string when called from JSON.stringify\n\t\tconst isRootObject = ( meta === undefined || typeof meta === 'string' );\n\n\t\tconst output = {};\n\n\t\t// meta is a hash used to collect geometries, materials.\n\t\t// not providing it implies that this is the root object\n\t\t// being serialized.\n\t\tif ( isRootObject ) {\n\n\t\t\t// initialize meta obj\n\t\t\tmeta = {\n\t\t\t\tgeometries: {},\n\t\t\t\tmaterials: {},\n\t\t\t\ttextures: {},\n\t\t\t\timages: {},\n\t\t\t\tshapes: {},\n\t\t\t\tskeletons: {},\n\t\t\t\tanimations: {}\n\t\t\t};\n\n\t\t\toutput.metadata = {\n\t\t\t\tversion: 4.5,\n\t\t\t\ttype: 'Object',\n\t\t\t\tgenerator: 'Object3D.toJSON'\n\t\t\t};\n\n\t\t}\n\n\t\t// standard Object3D serialization\n\n\t\tconst object = {};\n\n\t\tobject.uuid = this.uuid;\n\t\tobject.type = this.type;\n\n\t\tif ( this.name !== '' ) object.name = this.name;\n\t\tif ( this.castShadow === true ) object.castShadow = true;\n\t\tif ( this.receiveShadow === true ) object.receiveShadow = true;\n\t\tif ( this.visible === false ) object.visible = false;\n\t\tif ( this.frustumCulled === false ) object.frustumCulled = false;\n\t\tif ( this.renderOrder !== 0 ) object.renderOrder = this.renderOrder;\n\t\tif ( JSON.stringify( this.userData ) !== '{}' ) object.userData = this.userData;\n\n\t\tobject.layers = this.layers.mask;\n\t\tobject.matrix = this.matrix.toArray();\n\n\t\tif ( this.matrixAutoUpdate === false ) object.matrixAutoUpdate = false;\n\n\t\t// object specific properties\n\n\t\tif ( this.isInstancedMesh ) {\n\n\t\t\tobject.type = 'InstancedMesh';\n\t\t\tobject.count = this.count;\n\t\t\tobject.instanceMatrix = this.instanceMatrix.toJSON();\n\t\t\tif ( this.instanceColor !== null ) object.instanceColor = this.instanceColor.toJSON();\n\n\t\t}\n\n\t\t//\n\n\t\tfunction serialize( library, element ) {\n\n\t\t\tif ( library[ element.uuid ] === undefined ) {\n\n\t\t\t\tlibrary[ element.uuid ] = element.toJSON( meta );\n\n\t\t\t}\n\n\t\t\treturn element.uuid;\n\n\t\t}\n\n\t\tif ( this.isMesh || this.isLine || this.isPoints ) {\n\n\t\t\tobject.geometry = serialize( meta.geometries, this.geometry );\n\n\t\t\tconst parameters = this.geometry.parameters;\n\n\t\t\tif ( parameters !== undefined && parameters.shapes !== undefined ) {\n\n\t\t\t\tconst shapes = parameters.shapes;\n\n\t\t\t\tif ( Array.isArray( shapes ) ) {\n\n\t\t\t\t\tfor ( let i = 0, l = shapes.length; i < l; i ++ ) {\n\n\t\t\t\t\t\tconst shape = shapes[ i ];\n\n\t\t\t\t\t\tserialize( meta.shapes, shape );\n\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\n\t\t\t\t\tserialize( meta.shapes, shapes );\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t}\n\n\t\tif ( this.isSkinnedMesh ) {\n\n\t\t\tobject.bindMode = this.bindMode;\n\t\t\tobject.bindMatrix = this.bindMatrix.toArray();\n\n\t\t\tif ( this.skeleton !== undefined ) {\n\n\t\t\t\tserialize( meta.skeletons, this.skeleton );\n\n\t\t\t\tobject.skeleton = this.skeleton.uuid;\n\n\t\t\t}\n\n\t\t}\n\n\t\tif ( this.material !== undefined ) {\n\n\t\t\tif ( Array.isArray( this.material ) ) {\n\n\t\t\t\tconst uuids = [];\n\n\t\t\t\tfor ( let i = 0, l = this.material.length; i < l; i ++ ) {\n\n\t\t\t\t\tuuids.push( serialize( meta.materials, this.material[ i ] ) );\n\n\t\t\t\t}\n\n\t\t\t\tobject.material = uuids;\n\n\t\t\t} else {\n\n\t\t\t\tobject.material = serialize( meta.materials, this.material );\n\n\t\t\t}\n\n\t\t}\n\n\t\t//\n\n\t\tif ( this.children.length > 0 ) {\n\n\t\t\tobject.children = [];\n\n\t\t\tfor ( let i = 0; i < this.children.length; i ++ ) {\n\n\t\t\t\tobject.children.push( this.children[ i ].toJSON( meta ).object );\n\n\t\t\t}\n\n\t\t}\n\n\t\t//\n\n\t\tif ( this.animations.length > 0 ) {\n\n\t\t\tobject.animations = [];\n\n\t\t\tfor ( let i = 0; i < this.animations.length; i ++ ) {\n\n\t\t\t\tconst animation = this.animations[ i ];\n\n\t\t\t\tobject.animations.push( serialize( meta.animations, animation ) );\n\n\t\t\t}\n\n\t\t}\n\n\t\tif ( isRootObject ) {\n\n\t\t\tconst geometries = extractFromCache( meta.geometries );\n\t\t\tconst materials = extractFromCache( meta.materials );\n\t\t\tconst textures = extractFromCache( meta.textures );\n\t\t\tconst images = extractFromCache( meta.images );\n\t\t\tconst shapes = extractFromCache( meta.shapes );\n\t\t\tconst skeletons = extractFromCache( meta.skeletons );\n\t\t\tconst animations = extractFromCache( meta.animations );\n\n\t\t\tif ( geometries.length > 0 ) output.geometries = geometries;\n\t\t\tif ( materials.length > 0 ) output.materials = materials;\n\t\t\tif ( textures.length > 0 ) output.textures = textures;\n\t\t\tif ( images.length > 0 ) output.images = images;\n\t\t\tif ( shapes.length > 0 ) output.shapes = shapes;\n\t\t\tif ( skeletons.length > 0 ) output.skeletons = skeletons;\n\t\t\tif ( animations.length > 0 ) output.animations = animations;\n\n\t\t}\n\n\t\toutput.object = object;\n\n\t\treturn output;\n\n\t\t// extract data from the cache hash\n\t\t// remove metadata on each item\n\t\t// and return as array\n\t\tfunction extractFromCache( cache ) {\n\n\t\t\tconst values = [];\n\t\t\tfor ( const key in cache ) {\n\n\t\t\t\tconst data = cache[ key ];\n\t\t\t\tdelete data.metadata;\n\t\t\t\tvalues.push( data );\n\n\t\t\t}\n\n\t\t\treturn values;\n\n\t\t}\n\n\t}\n\n\tclone( recursive ) {\n\n\t\treturn new this.constructor().copy( this, recursive );\n\n\t}\n\n\tcopy( source, recursive = true ) {\n\n\t\tthis.name = source.name;\n\n\t\tthis.up.copy( source.up );\n\n\t\tthis.position.copy( source.position );\n\t\tthis.rotation.order = source.rotation.order;\n\t\tthis.quaternion.copy( source.quaternion );\n\t\tthis.scale.copy( source.scale );\n\n\t\tthis.matrix.copy( source.matrix );\n\t\tthis.matrixWorld.copy( source.matrixWorld );\n\n\t\tthis.matrixAutoUpdate = source.matrixAutoUpdate;\n\t\tthis.matrixWorldNeedsUpdate = source.matrixWorldNeedsUpdate;\n\n\t\tthis.layers.mask = source.layers.mask;\n\t\tthis.visible = source.visible;\n\n\t\tthis.castShadow = source.castShadow;\n\t\tthis.receiveShadow = source.receiveShadow;\n\n\t\tthis.frustumCulled = source.frustumCulled;\n\t\tthis.renderOrder = source.renderOrder;\n\n\t\tthis.userData = JSON.parse( JSON.stringify( source.userData ) );\n\n\t\tif ( recursive === true ) {\n\n\t\t\tfor ( let i = 0; i < source.children.length; i ++ ) {\n\n\t\t\t\tconst child = source.children[ i ];\n\t\t\t\tthis.add( child.clone() );\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n}\n\nObject3D.DefaultUp = new Vector3( 0, 1, 0 );\nObject3D.DefaultMatrixAutoUpdate = true;\n\nObject3D.prototype.isObject3D = true;\n\nconst _vector1 = /*@__PURE__*/ new Vector3();\nconst _vector2$1 = /*@__PURE__*/ new Vector3();\nconst _normalMatrix = /*@__PURE__*/ new Matrix3();\n\nclass Plane {\n\n\tconstructor( normal = new Vector3( 1, 0, 0 ), constant = 0 ) {\n\n\t\t// normal is assumed to be normalized\n\n\t\tthis.normal = normal;\n\t\tthis.constant = constant;\n\n\t}\n\n\tset( normal, constant ) {\n\n\t\tthis.normal.copy( normal );\n\t\tthis.constant = constant;\n\n\t\treturn this;\n\n\t}\n\n\tsetComponents( x, y, z, w ) {\n\n\t\tthis.normal.set( x, y, z );\n\t\tthis.constant = w;\n\n\t\treturn this;\n\n\t}\n\n\tsetFromNormalAndCoplanarPoint( normal, point ) {\n\n\t\tthis.normal.copy( normal );\n\t\tthis.constant = - point.dot( this.normal );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromCoplanarPoints( a, b, c ) {\n\n\t\tconst normal = _vector1.subVectors( c, b ).cross( _vector2$1.subVectors( a, b ) ).normalize();\n\n\t\t// Q: should an error be thrown if normal is zero (e.g. degenerate plane)?\n\n\t\tthis.setFromNormalAndCoplanarPoint( normal, a );\n\n\t\treturn this;\n\n\t}\n\n\tcopy( plane ) {\n\n\t\tthis.normal.copy( plane.normal );\n\t\tthis.constant = plane.constant;\n\n\t\treturn this;\n\n\t}\n\n\tnormalize() {\n\n\t\t// Note: will lead to a divide by zero if the plane is invalid.\n\n\t\tconst inverseNormalLength = 1.0 / this.normal.length();\n\t\tthis.normal.multiplyScalar( inverseNormalLength );\n\t\tthis.constant *= inverseNormalLength;\n\n\t\treturn this;\n\n\t}\n\n\tnegate() {\n\n\t\tthis.constant *= - 1;\n\t\tthis.normal.negate();\n\n\t\treturn this;\n\n\t}\n\n\tdistanceToPoint( point ) {\n\n\t\treturn this.normal.dot( point ) + this.constant;\n\n\t}\n\n\tdistanceToSphere( sphere ) {\n\n\t\treturn this.distanceToPoint( sphere.center ) - sphere.radius;\n\n\t}\n\n\tprojectPoint( point, target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Plane: .projectPoint() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\treturn target.copy( this.normal ).multiplyScalar( - this.distanceToPoint( point ) ).add( point );\n\n\t}\n\n\tintersectLine( line, target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Plane: .intersectLine() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\tconst direction = line.delta( _vector1 );\n\n\t\tconst denominator = this.normal.dot( direction );\n\n\t\tif ( denominator === 0 ) {\n\n\t\t\t// line is coplanar, return origin\n\t\t\tif ( this.distanceToPoint( line.start ) === 0 ) {\n\n\t\t\t\treturn target.copy( line.start );\n\n\t\t\t}\n\n\t\t\t// Unsure if this is the correct method to handle this case.\n\t\t\treturn null;\n\n\t\t}\n\n\t\tconst t = - ( line.start.dot( this.normal ) + this.constant ) / denominator;\n\n\t\tif ( t < 0 || t > 1 ) {\n\n\t\t\treturn null;\n\n\t\t}\n\n\t\treturn target.copy( direction ).multiplyScalar( t ).add( line.start );\n\n\t}\n\n\tintersectsLine( line ) {\n\n\t\t// Note: this tests if a line intersects the plane, not whether it (or its end-points) are coplanar with it.\n\n\t\tconst startSign = this.distanceToPoint( line.start );\n\t\tconst endSign = this.distanceToPoint( line.end );\n\n\t\treturn ( startSign < 0 && endSign > 0 ) || ( endSign < 0 && startSign > 0 );\n\n\t}\n\n\tintersectsBox( box ) {\n\n\t\treturn box.intersectsPlane( this );\n\n\t}\n\n\tintersectsSphere( sphere ) {\n\n\t\treturn sphere.intersectsPlane( this );\n\n\t}\n\n\tcoplanarPoint( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Plane: .coplanarPoint() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\treturn target.copy( this.normal ).multiplyScalar( - this.constant );\n\n\t}\n\n\tapplyMatrix4( matrix, optionalNormalMatrix ) {\n\n\t\tconst normalMatrix = optionalNormalMatrix || _normalMatrix.getNormalMatrix( matrix );\n\n\t\tconst referencePoint = this.coplanarPoint( _vector1 ).applyMatrix4( matrix );\n\n\t\tconst normal = this.normal.applyMatrix3( normalMatrix ).normalize();\n\n\t\tthis.constant = - referencePoint.dot( normal );\n\n\t\treturn this;\n\n\t}\n\n\ttranslate( offset ) {\n\n\t\tthis.constant -= offset.dot( this.normal );\n\n\t\treturn this;\n\n\t}\n\n\tequals( plane ) {\n\n\t\treturn plane.normal.equals( this.normal ) && ( plane.constant === this.constant );\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n}\n\nPlane.prototype.isPlane = true;\n\nconst _v0$1 = /*@__PURE__*/ new Vector3();\nconst _v1$3 = /*@__PURE__*/ new Vector3();\nconst _v2$2 = /*@__PURE__*/ new Vector3();\nconst _v3$1 = /*@__PURE__*/ new Vector3();\n\nconst _vab = /*@__PURE__*/ new Vector3();\nconst _vac = /*@__PURE__*/ new Vector3();\nconst _vbc = /*@__PURE__*/ new Vector3();\nconst _vap = /*@__PURE__*/ new Vector3();\nconst _vbp = /*@__PURE__*/ new Vector3();\nconst _vcp = /*@__PURE__*/ new Vector3();\n\nclass Triangle {\n\n\tconstructor( a = new Vector3(), b = new Vector3(), c = new Vector3() ) {\n\n\t\tthis.a = a;\n\t\tthis.b = b;\n\t\tthis.c = c;\n\n\t}\n\n\tstatic getNormal( a, b, c, target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Triangle: .getNormal() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\ttarget.subVectors( c, b );\n\t\t_v0$1.subVectors( a, b );\n\t\ttarget.cross( _v0$1 );\n\n\t\tconst targetLengthSq = target.lengthSq();\n\t\tif ( targetLengthSq > 0 ) {\n\n\t\t\treturn target.multiplyScalar( 1 / Math.sqrt( targetLengthSq ) );\n\n\t\t}\n\n\t\treturn target.set( 0, 0, 0 );\n\n\t}\n\n\t// static/instance method to calculate barycentric coordinates\n\t// based on: http://www.blackpawn.com/texts/pointinpoly/default.html\n\tstatic getBarycoord( point, a, b, c, target ) {\n\n\t\t_v0$1.subVectors( c, a );\n\t\t_v1$3.subVectors( b, a );\n\t\t_v2$2.subVectors( point, a );\n\n\t\tconst dot00 = _v0$1.dot( _v0$1 );\n\t\tconst dot01 = _v0$1.dot( _v1$3 );\n\t\tconst dot02 = _v0$1.dot( _v2$2 );\n\t\tconst dot11 = _v1$3.dot( _v1$3 );\n\t\tconst dot12 = _v1$3.dot( _v2$2 );\n\n\t\tconst denom = ( dot00 * dot11 - dot01 * dot01 );\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Triangle: .getBarycoord() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\t// collinear or singular triangle\n\t\tif ( denom === 0 ) {\n\n\t\t\t// arbitrary location outside of triangle?\n\t\t\t// not sure if this is the best idea, maybe should be returning undefined\n\t\t\treturn target.set( - 2, - 1, - 1 );\n\n\t\t}\n\n\t\tconst invDenom = 1 / denom;\n\t\tconst u = ( dot11 * dot02 - dot01 * dot12 ) * invDenom;\n\t\tconst v = ( dot00 * dot12 - dot01 * dot02 ) * invDenom;\n\n\t\t// barycentric coordinates must always sum to 1\n\t\treturn target.set( 1 - u - v, v, u );\n\n\t}\n\n\tstatic containsPoint( point, a, b, c ) {\n\n\t\tthis.getBarycoord( point, a, b, c, _v3$1 );\n\n\t\treturn ( _v3$1.x >= 0 ) && ( _v3$1.y >= 0 ) && ( ( _v3$1.x + _v3$1.y ) <= 1 );\n\n\t}\n\n\tstatic getUV( point, p1, p2, p3, uv1, uv2, uv3, target ) {\n\n\t\tthis.getBarycoord( point, p1, p2, p3, _v3$1 );\n\n\t\ttarget.set( 0, 0 );\n\t\ttarget.addScaledVector( uv1, _v3$1.x );\n\t\ttarget.addScaledVector( uv2, _v3$1.y );\n\t\ttarget.addScaledVector( uv3, _v3$1.z );\n\n\t\treturn target;\n\n\t}\n\n\tstatic isFrontFacing( a, b, c, direction ) {\n\n\t\t_v0$1.subVectors( c, b );\n\t\t_v1$3.subVectors( a, b );\n\n\t\t// strictly front facing\n\t\treturn ( _v0$1.cross( _v1$3 ).dot( direction ) < 0 ) ? true : false;\n\n\t}\n\n\tset( a, b, c ) {\n\n\t\tthis.a.copy( a );\n\t\tthis.b.copy( b );\n\t\tthis.c.copy( c );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromPointsAndIndices( points, i0, i1, i2 ) {\n\n\t\tthis.a.copy( points[ i0 ] );\n\t\tthis.b.copy( points[ i1 ] );\n\t\tthis.c.copy( points[ i2 ] );\n\n\t\treturn this;\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n\tcopy( triangle ) {\n\n\t\tthis.a.copy( triangle.a );\n\t\tthis.b.copy( triangle.b );\n\t\tthis.c.copy( triangle.c );\n\n\t\treturn this;\n\n\t}\n\n\tgetArea() {\n\n\t\t_v0$1.subVectors( this.c, this.b );\n\t\t_v1$3.subVectors( this.a, this.b );\n\n\t\treturn _v0$1.cross( _v1$3 ).length() * 0.5;\n\n\t}\n\n\tgetMidpoint( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Triangle: .getMidpoint() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\treturn target.addVectors( this.a, this.b ).add( this.c ).multiplyScalar( 1 / 3 );\n\n\t}\n\n\tgetNormal( target ) {\n\n\t\treturn Triangle.getNormal( this.a, this.b, this.c, target );\n\n\t}\n\n\tgetPlane( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Triangle: .getPlane() target is now required' );\n\t\t\ttarget = new Plane();\n\n\t\t}\n\n\t\treturn target.setFromCoplanarPoints( this.a, this.b, this.c );\n\n\t}\n\n\tgetBarycoord( point, target ) {\n\n\t\treturn Triangle.getBarycoord( point, this.a, this.b, this.c, target );\n\n\t}\n\n\tgetUV( point, uv1, uv2, uv3, target ) {\n\n\t\treturn Triangle.getUV( point, this.a, this.b, this.c, uv1, uv2, uv3, target );\n\n\t}\n\n\tcontainsPoint( point ) {\n\n\t\treturn Triangle.containsPoint( point, this.a, this.b, this.c );\n\n\t}\n\n\tisFrontFacing( direction ) {\n\n\t\treturn Triangle.isFrontFacing( this.a, this.b, this.c, direction );\n\n\t}\n\n\tintersectsBox( box ) {\n\n\t\treturn box.intersectsTriangle( this );\n\n\t}\n\n\tclosestPointToPoint( p, target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Triangle: .closestPointToPoint() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\tconst a = this.a, b = this.b, c = this.c;\n\t\tlet v, w;\n\n\t\t// algorithm thanks to Real-Time Collision Detection by Christer Ericson,\n\t\t// published by Morgan Kaufmann Publishers, (c) 2005 Elsevier Inc.,\n\t\t// under the accompanying license; see chapter 5.1.5 for detailed explanation.\n\t\t// basically, we're distinguishing which of the voronoi regions of the triangle\n\t\t// the point lies in with the minimum amount of redundant computation.\n\n\t\t_vab.subVectors( b, a );\n\t\t_vac.subVectors( c, a );\n\t\t_vap.subVectors( p, a );\n\t\tconst d1 = _vab.dot( _vap );\n\t\tconst d2 = _vac.dot( _vap );\n\t\tif ( d1 <= 0 && d2 <= 0 ) {\n\n\t\t\t// vertex region of A; barycentric coords (1, 0, 0)\n\t\t\treturn target.copy( a );\n\n\t\t}\n\n\t\t_vbp.subVectors( p, b );\n\t\tconst d3 = _vab.dot( _vbp );\n\t\tconst d4 = _vac.dot( _vbp );\n\t\tif ( d3 >= 0 && d4 <= d3 ) {\n\n\t\t\t// vertex region of B; barycentric coords (0, 1, 0)\n\t\t\treturn target.copy( b );\n\n\t\t}\n\n\t\tconst vc = d1 * d4 - d3 * d2;\n\t\tif ( vc <= 0 && d1 >= 0 && d3 <= 0 ) {\n\n\t\t\tv = d1 / ( d1 - d3 );\n\t\t\t// edge region of AB; barycentric coords (1-v, v, 0)\n\t\t\treturn target.copy( a ).addScaledVector( _vab, v );\n\n\t\t}\n\n\t\t_vcp.subVectors( p, c );\n\t\tconst d5 = _vab.dot( _vcp );\n\t\tconst d6 = _vac.dot( _vcp );\n\t\tif ( d6 >= 0 && d5 <= d6 ) {\n\n\t\t\t// vertex region of C; barycentric coords (0, 0, 1)\n\t\t\treturn target.copy( c );\n\n\t\t}\n\n\t\tconst vb = d5 * d2 - d1 * d6;\n\t\tif ( vb <= 0 && d2 >= 0 && d6 <= 0 ) {\n\n\t\t\tw = d2 / ( d2 - d6 );\n\t\t\t// edge region of AC; barycentric coords (1-w, 0, w)\n\t\t\treturn target.copy( a ).addScaledVector( _vac, w );\n\n\t\t}\n\n\t\tconst va = d3 * d6 - d5 * d4;\n\t\tif ( va <= 0 && ( d4 - d3 ) >= 0 && ( d5 - d6 ) >= 0 ) {\n\n\t\t\t_vbc.subVectors( c, b );\n\t\t\tw = ( d4 - d3 ) / ( ( d4 - d3 ) + ( d5 - d6 ) );\n\t\t\t// edge region of BC; barycentric coords (0, 1-w, w)\n\t\t\treturn target.copy( b ).addScaledVector( _vbc, w ); // edge region of BC\n\n\t\t}\n\n\t\t// face region\n\t\tconst denom = 1 / ( va + vb + vc );\n\t\t// u = va * denom\n\t\tv = vb * denom;\n\t\tw = vc * denom;\n\n\t\treturn target.copy( a ).addScaledVector( _vab, v ).addScaledVector( _vac, w );\n\n\t}\n\n\tequals( triangle ) {\n\n\t\treturn triangle.a.equals( this.a ) && triangle.b.equals( this.b ) && triangle.c.equals( this.c );\n\n\t}\n\n}\n\nlet materialId = 0;\n\nclass Material extends EventDispatcher {\n\n\tconstructor() {\n\n\t\tsuper();\n\n\t\tObject.defineProperty( this, 'id', { value: materialId ++ } );\n\n\t\tthis.uuid = generateUUID();\n\n\t\tthis.name = '';\n\t\tthis.type = 'Material';\n\n\t\tthis.fog = true;\n\n\t\tthis.blending = NormalBlending;\n\t\tthis.side = FrontSide;\n\t\tthis.vertexColors = false;\n\n\t\tthis.opacity = 1;\n\t\tthis.transparent = false;\n\n\t\tthis.blendSrc = SrcAlphaFactor;\n\t\tthis.blendDst = OneMinusSrcAlphaFactor;\n\t\tthis.blendEquation = AddEquation;\n\t\tthis.blendSrcAlpha = null;\n\t\tthis.blendDstAlpha = null;\n\t\tthis.blendEquationAlpha = null;\n\n\t\tthis.depthFunc = LessEqualDepth;\n\t\tthis.depthTest = true;\n\t\tthis.depthWrite = true;\n\n\t\tthis.stencilWriteMask = 0xff;\n\t\tthis.stencilFunc = AlwaysStencilFunc;\n\t\tthis.stencilRef = 0;\n\t\tthis.stencilFuncMask = 0xff;\n\t\tthis.stencilFail = KeepStencilOp;\n\t\tthis.stencilZFail = KeepStencilOp;\n\t\tthis.stencilZPass = KeepStencilOp;\n\t\tthis.stencilWrite = false;\n\n\t\tthis.clippingPlanes = null;\n\t\tthis.clipIntersection = false;\n\t\tthis.clipShadows = false;\n\n\t\tthis.shadowSide = null;\n\n\t\tthis.colorWrite = true;\n\n\t\tthis.precision = null; // override the renderer's default precision for this material\n\n\t\tthis.polygonOffset = false;\n\t\tthis.polygonOffsetFactor = 0;\n\t\tthis.polygonOffsetUnits = 0;\n\n\t\tthis.dithering = false;\n\n\t\tthis.alphaTest = 0;\n\t\tthis.alphaToCoverage = false;\n\t\tthis.premultipliedAlpha = false;\n\n\t\tthis.visible = true;\n\n\t\tthis.toneMapped = true;\n\n\t\tthis.userData = {};\n\n\t\tthis.version = 0;\n\n\t}\n\n\tonBuild( /* shaderobject, renderer */ ) {}\n\n\tonBeforeCompile( /* shaderobject, renderer */ ) {}\n\n\tcustomProgramCacheKey() {\n\n\t\treturn this.onBeforeCompile.toString();\n\n\t}\n\n\tsetValues( values ) {\n\n\t\tif ( values === undefined ) return;\n\n\t\tfor ( const key in values ) {\n\n\t\t\tconst newValue = values[ key ];\n\n\t\t\tif ( newValue === undefined ) {\n\n\t\t\t\tconsole.warn( 'THREE.Material: \\'' + key + '\\' parameter is undefined.' );\n\t\t\t\tcontinue;\n\n\t\t\t}\n\n\t\t\t// for backward compatability if shading is set in the constructor\n\t\t\tif ( key === 'shading' ) {\n\n\t\t\t\tconsole.warn( 'THREE.' + this.type + ': .shading has been removed. Use the boolean .flatShading instead.' );\n\t\t\t\tthis.flatShading = ( newValue === FlatShading ) ? true : false;\n\t\t\t\tcontinue;\n\n\t\t\t}\n\n\t\t\tconst currentValue = this[ key ];\n\n\t\t\tif ( currentValue === undefined ) {\n\n\t\t\t\tconsole.warn( 'THREE.' + this.type + ': \\'' + key + '\\' is not a property of this material.' );\n\t\t\t\tcontinue;\n\n\t\t\t}\n\n\t\t\tif ( currentValue && currentValue.isColor ) {\n\n\t\t\t\tcurrentValue.set( newValue );\n\n\t\t\t} else if ( ( currentValue && currentValue.isVector3 ) && ( newValue && newValue.isVector3 ) ) {\n\n\t\t\t\tcurrentValue.copy( newValue );\n\n\t\t\t} else {\n\n\t\t\t\tthis[ key ] = newValue;\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\ttoJSON( meta ) {\n\n\t\tconst isRoot = ( meta === undefined || typeof meta === 'string' );\n\n\t\tif ( isRoot ) {\n\n\t\t\tmeta = {\n\t\t\t\ttextures: {},\n\t\t\t\timages: {}\n\t\t\t};\n\n\t\t}\n\n\t\tconst data = {\n\t\t\tmetadata: {\n\t\t\t\tversion: 4.5,\n\t\t\t\ttype: 'Material',\n\t\t\t\tgenerator: 'Material.toJSON'\n\t\t\t}\n\t\t};\n\n\t\t// standard Material serialization\n\t\tdata.uuid = this.uuid;\n\t\tdata.type = this.type;\n\n\t\tif ( this.name !== '' ) data.name = this.name;\n\n\t\tif ( this.color && this.color.isColor ) data.color = this.color.getHex();\n\n\t\tif ( this.roughness !== undefined ) data.roughness = this.roughness;\n\t\tif ( this.metalness !== undefined ) data.metalness = this.metalness;\n\n\t\tif ( this.sheen && this.sheen.isColor ) data.sheen = this.sheen.getHex();\n\t\tif ( this.emissive && this.emissive.isColor ) data.emissive = this.emissive.getHex();\n\t\tif ( this.emissiveIntensity && this.emissiveIntensity !== 1 ) data.emissiveIntensity = this.emissiveIntensity;\n\n\t\tif ( this.specular && this.specular.isColor ) data.specular = this.specular.getHex();\n\t\tif ( this.shininess !== undefined ) data.shininess = this.shininess;\n\t\tif ( this.clearcoat !== undefined ) data.clearcoat = this.clearcoat;\n\t\tif ( this.clearcoatRoughness !== undefined ) data.clearcoatRoughness = this.clearcoatRoughness;\n\n\t\tif ( this.clearcoatMap && this.clearcoatMap.isTexture ) {\n\n\t\t\tdata.clearcoatMap = this.clearcoatMap.toJSON( meta ).uuid;\n\n\t\t}\n\n\t\tif ( this.clearcoatRoughnessMap && this.clearcoatRoughnessMap.isTexture ) {\n\n\t\t\tdata.clearcoatRoughnessMap = this.clearcoatRoughnessMap.toJSON( meta ).uuid;\n\n\t\t}\n\n\t\tif ( this.clearcoatNormalMap && this.clearcoatNormalMap.isTexture ) {\n\n\t\t\tdata.clearcoatNormalMap = this.clearcoatNormalMap.toJSON( meta ).uuid;\n\t\t\tdata.clearcoatNormalScale = this.clearcoatNormalScale.toArray();\n\n\t\t}\n\n\t\tif ( this.map && this.map.isTexture ) data.map = this.map.toJSON( meta ).uuid;\n\t\tif ( this.matcap && this.matcap.isTexture ) data.matcap = this.matcap.toJSON( meta ).uuid;\n\t\tif ( this.alphaMap && this.alphaMap.isTexture ) data.alphaMap = this.alphaMap.toJSON( meta ).uuid;\n\n\t\tif ( this.lightMap && this.lightMap.isTexture ) {\n\n\t\t\tdata.lightMap = this.lightMap.toJSON( meta ).uuid;\n\t\t\tdata.lightMapIntensity = this.lightMapIntensity;\n\n\t\t}\n\n\t\tif ( this.aoMap && this.aoMap.isTexture ) {\n\n\t\t\tdata.aoMap = this.aoMap.toJSON( meta ).uuid;\n\t\t\tdata.aoMapIntensity = this.aoMapIntensity;\n\n\t\t}\n\n\t\tif ( this.bumpMap && this.bumpMap.isTexture ) {\n\n\t\t\tdata.bumpMap = this.bumpMap.toJSON( meta ).uuid;\n\t\t\tdata.bumpScale = this.bumpScale;\n\n\t\t}\n\n\t\tif ( this.normalMap && this.normalMap.isTexture ) {\n\n\t\t\tdata.normalMap = this.normalMap.toJSON( meta ).uuid;\n\t\t\tdata.normalMapType = this.normalMapType;\n\t\t\tdata.normalScale = this.normalScale.toArray();\n\n\t\t}\n\n\t\tif ( this.displacementMap && this.displacementMap.isTexture ) {\n\n\t\t\tdata.displacementMap = this.displacementMap.toJSON( meta ).uuid;\n\t\t\tdata.displacementScale = this.displacementScale;\n\t\t\tdata.displacementBias = this.displacementBias;\n\n\t\t}\n\n\t\tif ( this.roughnessMap && this.roughnessMap.isTexture ) data.roughnessMap = this.roughnessMap.toJSON( meta ).uuid;\n\t\tif ( this.metalnessMap && this.metalnessMap.isTexture ) data.metalnessMap = this.metalnessMap.toJSON( meta ).uuid;\n\n\t\tif ( this.emissiveMap && this.emissiveMap.isTexture ) data.emissiveMap = this.emissiveMap.toJSON( meta ).uuid;\n\t\tif ( this.specularMap && this.specularMap.isTexture ) data.specularMap = this.specularMap.toJSON( meta ).uuid;\n\n\t\tif ( this.envMap && this.envMap.isTexture ) {\n\n\t\t\tdata.envMap = this.envMap.toJSON( meta ).uuid;\n\n\t\t\tif ( this.combine !== undefined ) data.combine = this.combine;\n\n\t\t}\n\n\t\tif ( this.envMapIntensity !== undefined ) data.envMapIntensity = this.envMapIntensity;\n\t\tif ( this.reflectivity !== undefined ) data.reflectivity = this.reflectivity;\n\t\tif ( this.refractionRatio !== undefined ) data.refractionRatio = this.refractionRatio;\n\n\t\tif ( this.gradientMap && this.gradientMap.isTexture ) {\n\n\t\t\tdata.gradientMap = this.gradientMap.toJSON( meta ).uuid;\n\n\t\t}\n\n\t\tif ( this.transmission !== undefined ) data.transmission = this.transmission;\n\t\tif ( this.transmissionMap && this.transmissionMap.isTexture ) data.transmissionMap = this.transmissionMap.toJSON( meta ).uuid;\n\t\tif ( this.thickness !== undefined ) data.thickness = this.thickness;\n\t\tif ( this.thicknessMap && this.thicknessMap.isTexture ) data.thicknessMap = this.thicknessMap.toJSON( meta ).uuid;\n\t\tif ( this.attenuationDistance !== undefined ) data.attenuationDistance = this.attenuationDistance;\n\t\tif ( this.attenuationColor !== undefined ) data.attenuationColor = this.attenuationColor.getHex();\n\n\t\tif ( this.size !== undefined ) data.size = this.size;\n\t\tif ( this.shadowSide !== null ) data.shadowSide = this.shadowSide;\n\t\tif ( this.sizeAttenuation !== undefined ) data.sizeAttenuation = this.sizeAttenuation;\n\n\t\tif ( this.blending !== NormalBlending ) data.blending = this.blending;\n\t\tif ( this.side !== FrontSide ) data.side = this.side;\n\t\tif ( this.vertexColors ) data.vertexColors = true;\n\n\t\tif ( this.opacity < 1 ) data.opacity = this.opacity;\n\t\tif ( this.transparent === true ) data.transparent = this.transparent;\n\n\t\tdata.depthFunc = this.depthFunc;\n\t\tdata.depthTest = this.depthTest;\n\t\tdata.depthWrite = this.depthWrite;\n\t\tdata.colorWrite = this.colorWrite;\n\n\t\tdata.stencilWrite = this.stencilWrite;\n\t\tdata.stencilWriteMask = this.stencilWriteMask;\n\t\tdata.stencilFunc = this.stencilFunc;\n\t\tdata.stencilRef = this.stencilRef;\n\t\tdata.stencilFuncMask = this.stencilFuncMask;\n\t\tdata.stencilFail = this.stencilFail;\n\t\tdata.stencilZFail = this.stencilZFail;\n\t\tdata.stencilZPass = this.stencilZPass;\n\n\t\t// rotation (SpriteMaterial)\n\t\tif ( this.rotation && this.rotation !== 0 ) data.rotation = this.rotation;\n\n\t\tif ( this.polygonOffset === true ) data.polygonOffset = true;\n\t\tif ( this.polygonOffsetFactor !== 0 ) data.polygonOffsetFactor = this.polygonOffsetFactor;\n\t\tif ( this.polygonOffsetUnits !== 0 ) data.polygonOffsetUnits = this.polygonOffsetUnits;\n\n\t\tif ( this.linewidth && this.linewidth !== 1 ) data.linewidth = this.linewidth;\n\t\tif ( this.dashSize !== undefined ) data.dashSize = this.dashSize;\n\t\tif ( this.gapSize !== undefined ) data.gapSize = this.gapSize;\n\t\tif ( this.scale !== undefined ) data.scale = this.scale;\n\n\t\tif ( this.dithering === true ) data.dithering = true;\n\n\t\tif ( this.alphaTest > 0 ) data.alphaTest = this.alphaTest;\n\t\tif ( this.alphaToCoverage === true ) data.alphaToCoverage = this.alphaToCoverage;\n\t\tif ( this.premultipliedAlpha === true ) data.premultipliedAlpha = this.premultipliedAlpha;\n\n\t\tif ( this.wireframe === true ) data.wireframe = this.wireframe;\n\t\tif ( this.wireframeLinewidth > 1 ) data.wireframeLinewidth = this.wireframeLinewidth;\n\t\tif ( this.wireframeLinecap !== 'round' ) data.wireframeLinecap = this.wireframeLinecap;\n\t\tif ( this.wireframeLinejoin !== 'round' ) data.wireframeLinejoin = this.wireframeLinejoin;\n\n\t\tif ( this.morphTargets === true ) data.morphTargets = true;\n\t\tif ( this.morphNormals === true ) data.morphNormals = true;\n\n\t\tif ( this.flatShading === true ) data.flatShading = this.flatShading;\n\n\t\tif ( this.visible === false ) data.visible = false;\n\n\t\tif ( this.toneMapped === false ) data.toneMapped = false;\n\n\t\tif ( JSON.stringify( this.userData ) !== '{}' ) data.userData = this.userData;\n\n\t\t// TODO: Copied from Object3D.toJSON\n\n\t\tfunction extractFromCache( cache ) {\n\n\t\t\tconst values = [];\n\n\t\t\tfor ( const key in cache ) {\n\n\t\t\t\tconst data = cache[ key ];\n\t\t\t\tdelete data.metadata;\n\t\t\t\tvalues.push( data );\n\n\t\t\t}\n\n\t\t\treturn values;\n\n\t\t}\n\n\t\tif ( isRoot ) {\n\n\t\t\tconst textures = extractFromCache( meta.textures );\n\t\t\tconst images = extractFromCache( meta.images );\n\n\t\t\tif ( textures.length > 0 ) data.textures = textures;\n\t\t\tif ( images.length > 0 ) data.images = images;\n\n\t\t}\n\n\t\treturn data;\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n\tcopy( source ) {\n\n\t\tthis.name = source.name;\n\n\t\tthis.fog = source.fog;\n\n\t\tthis.blending = source.blending;\n\t\tthis.side = source.side;\n\t\tthis.vertexColors = source.vertexColors;\n\n\t\tthis.opacity = source.opacity;\n\t\tthis.transparent = source.transparent;\n\n\t\tthis.blendSrc = source.blendSrc;\n\t\tthis.blendDst = source.blendDst;\n\t\tthis.blendEquation = source.blendEquation;\n\t\tthis.blendSrcAlpha = source.blendSrcAlpha;\n\t\tthis.blendDstAlpha = source.blendDstAlpha;\n\t\tthis.blendEquationAlpha = source.blendEquationAlpha;\n\n\t\tthis.depthFunc = source.depthFunc;\n\t\tthis.depthTest = source.depthTest;\n\t\tthis.depthWrite = source.depthWrite;\n\n\t\tthis.stencilWriteMask = source.stencilWriteMask;\n\t\tthis.stencilFunc = source.stencilFunc;\n\t\tthis.stencilRef = source.stencilRef;\n\t\tthis.stencilFuncMask = source.stencilFuncMask;\n\t\tthis.stencilFail = source.stencilFail;\n\t\tthis.stencilZFail = source.stencilZFail;\n\t\tthis.stencilZPass = source.stencilZPass;\n\t\tthis.stencilWrite = source.stencilWrite;\n\n\t\tconst srcPlanes = source.clippingPlanes;\n\t\tlet dstPlanes = null;\n\n\t\tif ( srcPlanes !== null ) {\n\n\t\t\tconst n = srcPlanes.length;\n\t\t\tdstPlanes = new Array( n );\n\n\t\t\tfor ( let i = 0; i !== n; ++ i ) {\n\n\t\t\t\tdstPlanes[ i ] = srcPlanes[ i ].clone();\n\n\t\t\t}\n\n\t\t}\n\n\t\tthis.clippingPlanes = dstPlanes;\n\t\tthis.clipIntersection = source.clipIntersection;\n\t\tthis.clipShadows = source.clipShadows;\n\n\t\tthis.shadowSide = source.shadowSide;\n\n\t\tthis.colorWrite = source.colorWrite;\n\n\t\tthis.precision = source.precision;\n\n\t\tthis.polygonOffset = source.polygonOffset;\n\t\tthis.polygonOffsetFactor = source.polygonOffsetFactor;\n\t\tthis.polygonOffsetUnits = source.polygonOffsetUnits;\n\n\t\tthis.dithering = source.dithering;\n\n\t\tthis.alphaTest = source.alphaTest;\n\t\tthis.alphaToCoverage = source.alphaToCoverage;\n\t\tthis.premultipliedAlpha = source.premultipliedAlpha;\n\n\t\tthis.visible = source.visible;\n\n\t\tthis.toneMapped = source.toneMapped;\n\n\t\tthis.userData = JSON.parse( JSON.stringify( source.userData ) );\n\n\t\treturn this;\n\n\t}\n\n\tdispose() {\n\n\t\tthis.dispatchEvent( { type: 'dispose' } );\n\n\t}\n\n\tset needsUpdate( value ) {\n\n\t\tif ( value === true ) this.version ++;\n\n\t}\n\n}\n\nMaterial.prototype.isMaterial = true;\n\nconst _colorKeywords = { 'aliceblue': 0xF0F8FF, 'antiquewhite': 0xFAEBD7, 'aqua': 0x00FFFF, 'aquamarine': 0x7FFFD4, 'azure': 0xF0FFFF,\n\t'beige': 0xF5F5DC, 'bisque': 0xFFE4C4, 'black': 0x000000, 'blanchedalmond': 0xFFEBCD, 'blue': 0x0000FF, 'blueviolet': 0x8A2BE2,\n\t'brown': 0xA52A2A, 'burlywood': 0xDEB887, 'cadetblue': 0x5F9EA0, 'chartreuse': 0x7FFF00, 'chocolate': 0xD2691E, 'coral': 0xFF7F50,\n\t'cornflowerblue': 0x6495ED, 'cornsilk': 0xFFF8DC, 'crimson': 0xDC143C, 'cyan': 0x00FFFF, 'darkblue': 0x00008B, 'darkcyan': 0x008B8B,\n\t'darkgoldenrod': 0xB8860B, 'darkgray': 0xA9A9A9, 'darkgreen': 0x006400, 'darkgrey': 0xA9A9A9, 'darkkhaki': 0xBDB76B, 'darkmagenta': 0x8B008B,\n\t'darkolivegreen': 0x556B2F, 'darkorange': 0xFF8C00, 'darkorchid': 0x9932CC, 'darkred': 0x8B0000, 'darksalmon': 0xE9967A, 'darkseagreen': 0x8FBC8F,\n\t'darkslateblue': 0x483D8B, 'darkslategray': 0x2F4F4F, 'darkslategrey': 0x2F4F4F, 'darkturquoise': 0x00CED1, 'darkviolet': 0x9400D3,\n\t'deeppink': 0xFF1493, 'deepskyblue': 0x00BFFF, 'dimgray': 0x696969, 'dimgrey': 0x696969, 'dodgerblue': 0x1E90FF, 'firebrick': 0xB22222,\n\t'floralwhite': 0xFFFAF0, 'forestgreen': 0x228B22, 'fuchsia': 0xFF00FF, 'gainsboro': 0xDCDCDC, 'ghostwhite': 0xF8F8FF, 'gold': 0xFFD700,\n\t'goldenrod': 0xDAA520, 'gray': 0x808080, 'green': 0x008000, 'greenyellow': 0xADFF2F, 'grey': 0x808080, 'honeydew': 0xF0FFF0, 'hotpink': 0xFF69B4,\n\t'indianred': 0xCD5C5C, 'indigo': 0x4B0082, 'ivory': 0xFFFFF0, 'khaki': 0xF0E68C, 'lavender': 0xE6E6FA, 'lavenderblush': 0xFFF0F5, 'lawngreen': 0x7CFC00,\n\t'lemonchiffon': 0xFFFACD, 'lightblue': 0xADD8E6, 'lightcoral': 0xF08080, 'lightcyan': 0xE0FFFF, 'lightgoldenrodyellow': 0xFAFAD2, 'lightgray': 0xD3D3D3,\n\t'lightgreen': 0x90EE90, 'lightgrey': 0xD3D3D3, 'lightpink': 0xFFB6C1, 'lightsalmon': 0xFFA07A, 'lightseagreen': 0x20B2AA, 'lightskyblue': 0x87CEFA,\n\t'lightslategray': 0x778899, 'lightslategrey': 0x778899, 'lightsteelblue': 0xB0C4DE, 'lightyellow': 0xFFFFE0, 'lime': 0x00FF00, 'limegreen': 0x32CD32,\n\t'linen': 0xFAF0E6, 'magenta': 0xFF00FF, 'maroon': 0x800000, 'mediumaquamarine': 0x66CDAA, 'mediumblue': 0x0000CD, 'mediumorchid': 0xBA55D3,\n\t'mediumpurple': 0x9370DB, 'mediumseagreen': 0x3CB371, 'mediumslateblue': 0x7B68EE, 'mediumspringgreen': 0x00FA9A, 'mediumturquoise': 0x48D1CC,\n\t'mediumvioletred': 0xC71585, 'midnightblue': 0x191970, 'mintcream': 0xF5FFFA, 'mistyrose': 0xFFE4E1, 'moccasin': 0xFFE4B5, 'navajowhite': 0xFFDEAD,\n\t'navy': 0x000080, 'oldlace': 0xFDF5E6, 'olive': 0x808000, 'olivedrab': 0x6B8E23, 'orange': 0xFFA500, 'orangered': 0xFF4500, 'orchid': 0xDA70D6,\n\t'palegoldenrod': 0xEEE8AA, 'palegreen': 0x98FB98, 'paleturquoise': 0xAFEEEE, 'palevioletred': 0xDB7093, 'papayawhip': 0xFFEFD5, 'peachpuff': 0xFFDAB9,\n\t'peru': 0xCD853F, 'pink': 0xFFC0CB, 'plum': 0xDDA0DD, 'powderblue': 0xB0E0E6, 'purple': 0x800080, 'rebeccapurple': 0x663399, 'red': 0xFF0000, 'rosybrown': 0xBC8F8F,\n\t'royalblue': 0x4169E1, 'saddlebrown': 0x8B4513, 'salmon': 0xFA8072, 'sandybrown': 0xF4A460, 'seagreen': 0x2E8B57, 'seashell': 0xFFF5EE,\n\t'sienna': 0xA0522D, 'silver': 0xC0C0C0, 'skyblue': 0x87CEEB, 'slateblue': 0x6A5ACD, 'slategray': 0x708090, 'slategrey': 0x708090, 'snow': 0xFFFAFA,\n\t'springgreen': 0x00FF7F, 'steelblue': 0x4682B4, 'tan': 0xD2B48C, 'teal': 0x008080, 'thistle': 0xD8BFD8, 'tomato': 0xFF6347, 'turquoise': 0x40E0D0,\n\t'violet': 0xEE82EE, 'wheat': 0xF5DEB3, 'white': 0xFFFFFF, 'whitesmoke': 0xF5F5F5, 'yellow': 0xFFFF00, 'yellowgreen': 0x9ACD32 };\n\nconst _hslA = { h: 0, s: 0, l: 0 };\nconst _hslB = { h: 0, s: 0, l: 0 };\n\nfunction hue2rgb( p, q, t ) {\n\n\tif ( t < 0 ) t += 1;\n\tif ( t > 1 ) t -= 1;\n\tif ( t < 1 / 6 ) return p + ( q - p ) * 6 * t;\n\tif ( t < 1 / 2 ) return q;\n\tif ( t < 2 / 3 ) return p + ( q - p ) * 6 * ( 2 / 3 - t );\n\treturn p;\n\n}\n\nfunction SRGBToLinear( c ) {\n\n\treturn ( c < 0.04045 ) ? c * 0.0773993808 : Math.pow( c * 0.9478672986 + 0.0521327014, 2.4 );\n\n}\n\nfunction LinearToSRGB( c ) {\n\n\treturn ( c < 0.0031308 ) ? c * 12.92 : 1.055 * ( Math.pow( c, 0.41666 ) ) - 0.055;\n\n}\n\nclass Color {\n\n\tconstructor( r, g, b ) {\n\n\t\tif ( g === undefined && b === undefined ) {\n\n\t\t\t// r is THREE.Color, hex or string\n\t\t\treturn this.set( r );\n\n\t\t}\n\n\t\treturn this.setRGB( r, g, b );\n\n\t}\n\n\tset( value ) {\n\n\t\tif ( value && value.isColor ) {\n\n\t\t\tthis.copy( value );\n\n\t\t} else if ( typeof value === 'number' ) {\n\n\t\t\tthis.setHex( value );\n\n\t\t} else if ( typeof value === 'string' ) {\n\n\t\t\tthis.setStyle( value );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tsetScalar( scalar ) {\n\n\t\tthis.r = scalar;\n\t\tthis.g = scalar;\n\t\tthis.b = scalar;\n\n\t\treturn this;\n\n\t}\n\n\tsetHex( hex ) {\n\n\t\thex = Math.floor( hex );\n\n\t\tthis.r = ( hex >> 16 & 255 ) / 255;\n\t\tthis.g = ( hex >> 8 & 255 ) / 255;\n\t\tthis.b = ( hex & 255 ) / 255;\n\n\t\treturn this;\n\n\t}\n\n\tsetRGB( r, g, b ) {\n\n\t\tthis.r = r;\n\t\tthis.g = g;\n\t\tthis.b = b;\n\n\t\treturn this;\n\n\t}\n\n\tsetHSL( h, s, l ) {\n\n\t\t// h,s,l ranges are in 0.0 - 1.0\n\t\th = euclideanModulo( h, 1 );\n\t\ts = clamp( s, 0, 1 );\n\t\tl = clamp( l, 0, 1 );\n\n\t\tif ( s === 0 ) {\n\n\t\t\tthis.r = this.g = this.b = l;\n\n\t\t} else {\n\n\t\t\tconst p = l <= 0.5 ? l * ( 1 + s ) : l + s - ( l * s );\n\t\t\tconst q = ( 2 * l ) - p;\n\n\t\t\tthis.r = hue2rgb( q, p, h + 1 / 3 );\n\t\t\tthis.g = hue2rgb( q, p, h );\n\t\t\tthis.b = hue2rgb( q, p, h - 1 / 3 );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tsetStyle( style ) {\n\n\t\tfunction handleAlpha( string ) {\n\n\t\t\tif ( string === undefined ) return;\n\n\t\t\tif ( parseFloat( string ) < 1 ) {\n\n\t\t\t\tconsole.warn( 'THREE.Color: Alpha component of ' + style + ' will be ignored.' );\n\n\t\t\t}\n\n\t\t}\n\n\n\t\tlet m;\n\n\t\tif ( m = /^((?:rgb|hsl)a?)\\(([^\\)]*)\\)/.exec( style ) ) {\n\n\t\t\t// rgb / hsl\n\n\t\t\tlet color;\n\t\t\tconst name = m[ 1 ];\n\t\t\tconst components = m[ 2 ];\n\n\t\t\tswitch ( name ) {\n\n\t\t\t\tcase 'rgb':\n\t\t\t\tcase 'rgba':\n\n\t\t\t\t\tif ( color = /^\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*(?:,\\s*(\\d*\\.?\\d+)\\s*)?$/.exec( components ) ) {\n\n\t\t\t\t\t\t// rgb(255,0,0) rgba(255,0,0,0.5)\n\t\t\t\t\t\tthis.r = Math.min( 255, parseInt( color[ 1 ], 10 ) ) / 255;\n\t\t\t\t\t\tthis.g = Math.min( 255, parseInt( color[ 2 ], 10 ) ) / 255;\n\t\t\t\t\t\tthis.b = Math.min( 255, parseInt( color[ 3 ], 10 ) ) / 255;\n\n\t\t\t\t\t\thandleAlpha( color[ 4 ] );\n\n\t\t\t\t\t\treturn this;\n\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( color = /^\\s*(\\d+)\\%\\s*,\\s*(\\d+)\\%\\s*,\\s*(\\d+)\\%\\s*(?:,\\s*(\\d*\\.?\\d+)\\s*)?$/.exec( components ) ) {\n\n\t\t\t\t\t\t// rgb(100%,0%,0%) rgba(100%,0%,0%,0.5)\n\t\t\t\t\t\tthis.r = Math.min( 100, parseInt( color[ 1 ], 10 ) ) / 100;\n\t\t\t\t\t\tthis.g = Math.min( 100, parseInt( color[ 2 ], 10 ) ) / 100;\n\t\t\t\t\t\tthis.b = Math.min( 100, parseInt( color[ 3 ], 10 ) ) / 100;\n\n\t\t\t\t\t\thandleAlpha( color[ 4 ] );\n\n\t\t\t\t\t\treturn this;\n\n\t\t\t\t\t}\n\n\t\t\t\t\tbreak;\n\n\t\t\t\tcase 'hsl':\n\t\t\t\tcase 'hsla':\n\n\t\t\t\t\tif ( color = /^\\s*(\\d*\\.?\\d+)\\s*,\\s*(\\d+)\\%\\s*,\\s*(\\d+)\\%\\s*(?:,\\s*(\\d*\\.?\\d+)\\s*)?$/.exec( components ) ) {\n\n\t\t\t\t\t\t// hsl(120,50%,50%) hsla(120,50%,50%,0.5)\n\t\t\t\t\t\tconst h = parseFloat( color[ 1 ] ) / 360;\n\t\t\t\t\t\tconst s = parseInt( color[ 2 ], 10 ) / 100;\n\t\t\t\t\t\tconst l = parseInt( color[ 3 ], 10 ) / 100;\n\n\t\t\t\t\t\thandleAlpha( color[ 4 ] );\n\n\t\t\t\t\t\treturn this.setHSL( h, s, l );\n\n\t\t\t\t\t}\n\n\t\t\t\t\tbreak;\n\n\t\t\t}\n\n\t\t} else if ( m = /^\\#([A-Fa-f\\d]+)$/.exec( style ) ) {\n\n\t\t\t// hex color\n\n\t\t\tconst hex = m[ 1 ];\n\t\t\tconst size = hex.length;\n\n\t\t\tif ( size === 3 ) {\n\n\t\t\t\t// #ff0\n\t\t\t\tthis.r = parseInt( hex.charAt( 0 ) + hex.charAt( 0 ), 16 ) / 255;\n\t\t\t\tthis.g = parseInt( hex.charAt( 1 ) + hex.charAt( 1 ), 16 ) / 255;\n\t\t\t\tthis.b = parseInt( hex.charAt( 2 ) + hex.charAt( 2 ), 16 ) / 255;\n\n\t\t\t\treturn this;\n\n\t\t\t} else if ( size === 6 ) {\n\n\t\t\t\t// #ff0000\n\t\t\t\tthis.r = parseInt( hex.charAt( 0 ) + hex.charAt( 1 ), 16 ) / 255;\n\t\t\t\tthis.g = parseInt( hex.charAt( 2 ) + hex.charAt( 3 ), 16 ) / 255;\n\t\t\t\tthis.b = parseInt( hex.charAt( 4 ) + hex.charAt( 5 ), 16 ) / 255;\n\n\t\t\t\treturn this;\n\n\t\t\t}\n\n\t\t}\n\n\t\tif ( style && style.length > 0 ) {\n\n\t\t\treturn this.setColorName( style );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tsetColorName( style ) {\n\n\t\t// color keywords\n\t\tconst hex = _colorKeywords[ style.toLowerCase() ];\n\n\t\tif ( hex !== undefined ) {\n\n\t\t\t// red\n\t\t\tthis.setHex( hex );\n\n\t\t} else {\n\n\t\t\t// unknown color\n\t\t\tconsole.warn( 'THREE.Color: Unknown color ' + style );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor( this.r, this.g, this.b );\n\n\t}\n\n\tcopy( color ) {\n\n\t\tthis.r = color.r;\n\t\tthis.g = color.g;\n\t\tthis.b = color.b;\n\n\t\treturn this;\n\n\t}\n\n\tcopyGammaToLinear( color, gammaFactor = 2.0 ) {\n\n\t\tthis.r = Math.pow( color.r, gammaFactor );\n\t\tthis.g = Math.pow( color.g, gammaFactor );\n\t\tthis.b = Math.pow( color.b, gammaFactor );\n\n\t\treturn this;\n\n\t}\n\n\tcopyLinearToGamma( color, gammaFactor = 2.0 ) {\n\n\t\tconst safeInverse = ( gammaFactor > 0 ) ? ( 1.0 / gammaFactor ) : 1.0;\n\n\t\tthis.r = Math.pow( color.r, safeInverse );\n\t\tthis.g = Math.pow( color.g, safeInverse );\n\t\tthis.b = Math.pow( color.b, safeInverse );\n\n\t\treturn this;\n\n\t}\n\n\tconvertGammaToLinear( gammaFactor ) {\n\n\t\tthis.copyGammaToLinear( this, gammaFactor );\n\n\t\treturn this;\n\n\t}\n\n\tconvertLinearToGamma( gammaFactor ) {\n\n\t\tthis.copyLinearToGamma( this, gammaFactor );\n\n\t\treturn this;\n\n\t}\n\n\tcopySRGBToLinear( color ) {\n\n\t\tthis.r = SRGBToLinear( color.r );\n\t\tthis.g = SRGBToLinear( color.g );\n\t\tthis.b = SRGBToLinear( color.b );\n\n\t\treturn this;\n\n\t}\n\n\tcopyLinearToSRGB( color ) {\n\n\t\tthis.r = LinearToSRGB( color.r );\n\t\tthis.g = LinearToSRGB( color.g );\n\t\tthis.b = LinearToSRGB( color.b );\n\n\t\treturn this;\n\n\t}\n\n\tconvertSRGBToLinear() {\n\n\t\tthis.copySRGBToLinear( this );\n\n\t\treturn this;\n\n\t}\n\n\tconvertLinearToSRGB() {\n\n\t\tthis.copyLinearToSRGB( this );\n\n\t\treturn this;\n\n\t}\n\n\tgetHex() {\n\n\t\treturn ( this.r * 255 ) << 16 ^ ( this.g * 255 ) << 8 ^ ( this.b * 255 ) << 0;\n\n\t}\n\n\tgetHexString() {\n\n\t\treturn ( '000000' + this.getHex().toString( 16 ) ).slice( - 6 );\n\n\t}\n\n\tgetHSL( target ) {\n\n\t\t// h,s,l ranges are in 0.0 - 1.0\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Color: .getHSL() target is now required' );\n\t\t\ttarget = { h: 0, s: 0, l: 0 };\n\n\t\t}\n\n\t\tconst r = this.r, g = this.g, b = this.b;\n\n\t\tconst max = Math.max( r, g, b );\n\t\tconst min = Math.min( r, g, b );\n\n\t\tlet hue, saturation;\n\t\tconst lightness = ( min + max ) / 2.0;\n\n\t\tif ( min === max ) {\n\n\t\t\thue = 0;\n\t\t\tsaturation = 0;\n\n\t\t} else {\n\n\t\t\tconst delta = max - min;\n\n\t\t\tsaturation = lightness <= 0.5 ? delta / ( max + min ) : delta / ( 2 - max - min );\n\n\t\t\tswitch ( max ) {\n\n\t\t\t\tcase r: hue = ( g - b ) / delta + ( g < b ? 6 : 0 ); break;\n\t\t\t\tcase g: hue = ( b - r ) / delta + 2; break;\n\t\t\t\tcase b: hue = ( r - g ) / delta + 4; break;\n\n\t\t\t}\n\n\t\t\thue /= 6;\n\n\t\t}\n\n\t\ttarget.h = hue;\n\t\ttarget.s = saturation;\n\t\ttarget.l = lightness;\n\n\t\treturn target;\n\n\t}\n\n\tgetStyle() {\n\n\t\treturn 'rgb(' + ( ( this.r * 255 ) | 0 ) + ',' + ( ( this.g * 255 ) | 0 ) + ',' + ( ( this.b * 255 ) | 0 ) + ')';\n\n\t}\n\n\toffsetHSL( h, s, l ) {\n\n\t\tthis.getHSL( _hslA );\n\n\t\t_hslA.h += h; _hslA.s += s; _hslA.l += l;\n\n\t\tthis.setHSL( _hslA.h, _hslA.s, _hslA.l );\n\n\t\treturn this;\n\n\t}\n\n\tadd( color ) {\n\n\t\tthis.r += color.r;\n\t\tthis.g += color.g;\n\t\tthis.b += color.b;\n\n\t\treturn this;\n\n\t}\n\n\taddColors( color1, color2 ) {\n\n\t\tthis.r = color1.r + color2.r;\n\t\tthis.g = color1.g + color2.g;\n\t\tthis.b = color1.b + color2.b;\n\n\t\treturn this;\n\n\t}\n\n\taddScalar( s ) {\n\n\t\tthis.r += s;\n\t\tthis.g += s;\n\t\tthis.b += s;\n\n\t\treturn this;\n\n\t}\n\n\tsub( color ) {\n\n\t\tthis.r = Math.max( 0, this.r - color.r );\n\t\tthis.g = Math.max( 0, this.g - color.g );\n\t\tthis.b = Math.max( 0, this.b - color.b );\n\n\t\treturn this;\n\n\t}\n\n\tmultiply( color ) {\n\n\t\tthis.r *= color.r;\n\t\tthis.g *= color.g;\n\t\tthis.b *= color.b;\n\n\t\treturn this;\n\n\t}\n\n\tmultiplyScalar( s ) {\n\n\t\tthis.r *= s;\n\t\tthis.g *= s;\n\t\tthis.b *= s;\n\n\t\treturn this;\n\n\t}\n\n\tlerp( color, alpha ) {\n\n\t\tthis.r += ( color.r - this.r ) * alpha;\n\t\tthis.g += ( color.g - this.g ) * alpha;\n\t\tthis.b += ( color.b - this.b ) * alpha;\n\n\t\treturn this;\n\n\t}\n\n\tlerpColors( color1, color2, alpha ) {\n\n\t\tthis.r = color1.r + ( color2.r - color1.r ) * alpha;\n\t\tthis.g = color1.g + ( color2.g - color1.g ) * alpha;\n\t\tthis.b = color1.b + ( color2.b - color1.b ) * alpha;\n\n\t\treturn this;\n\n\t}\n\n\tlerpHSL( color, alpha ) {\n\n\t\tthis.getHSL( _hslA );\n\t\tcolor.getHSL( _hslB );\n\n\t\tconst h = lerp( _hslA.h, _hslB.h, alpha );\n\t\tconst s = lerp( _hslA.s, _hslB.s, alpha );\n\t\tconst l = lerp( _hslA.l, _hslB.l, alpha );\n\n\t\tthis.setHSL( h, s, l );\n\n\t\treturn this;\n\n\t}\n\n\tequals( c ) {\n\n\t\treturn ( c.r === this.r ) && ( c.g === this.g ) && ( c.b === this.b );\n\n\t}\n\n\tfromArray( array, offset = 0 ) {\n\n\t\tthis.r = array[ offset ];\n\t\tthis.g = array[ offset + 1 ];\n\t\tthis.b = array[ offset + 2 ];\n\n\t\treturn this;\n\n\t}\n\n\ttoArray( array = [], offset = 0 ) {\n\n\t\tarray[ offset ] = this.r;\n\t\tarray[ offset + 1 ] = this.g;\n\t\tarray[ offset + 2 ] = this.b;\n\n\t\treturn array;\n\n\t}\n\n\tfromBufferAttribute( attribute, index ) {\n\n\t\tthis.r = attribute.getX( index );\n\t\tthis.g = attribute.getY( index );\n\t\tthis.b = attribute.getZ( index );\n\n\t\tif ( attribute.normalized === true ) {\n\n\t\t\t// assuming Uint8Array\n\n\t\t\tthis.r /= 255;\n\t\t\tthis.g /= 255;\n\t\t\tthis.b /= 255;\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\ttoJSON() {\n\n\t\treturn this.getHex();\n\n\t}\n\n}\n\nColor.NAMES = _colorKeywords;\n\nColor.prototype.isColor = true;\nColor.prototype.r = 1;\nColor.prototype.g = 1;\nColor.prototype.b = 1;\n\n/**\n * parameters = {\n *  color: <hex>,\n *  opacity: <float>,\n *  map: new THREE.Texture( <Image> ),\n *\n *  lightMap: new THREE.Texture( <Image> ),\n *  lightMapIntensity: <float>\n *\n *  aoMap: new THREE.Texture( <Image> ),\n *  aoMapIntensity: <float>\n *\n *  specularMap: new THREE.Texture( <Image> ),\n *\n *  alphaMap: new THREE.Texture( <Image> ),\n *\n *  envMap: new THREE.CubeTexture( [posx, negx, posy, negy, posz, negz] ),\n *  combine: THREE.Multiply,\n *  reflectivity: <float>,\n *  refractionRatio: <float>,\n *\n *  depthTest: <bool>,\n *  depthWrite: <bool>,\n *\n *  wireframe: <boolean>,\n *  wireframeLinewidth: <float>,\n *\n *  morphTargets: <bool>\n * }\n */\n\nclass MeshBasicMaterial extends Material {\n\n\tconstructor( parameters ) {\n\n\t\tsuper();\n\n\t\tthis.type = 'MeshBasicMaterial';\n\n\t\tthis.color = new Color( 0xffffff ); // emissive\n\n\t\tthis.map = null;\n\n\t\tthis.lightMap = null;\n\t\tthis.lightMapIntensity = 1.0;\n\n\t\tthis.aoMap = null;\n\t\tthis.aoMapIntensity = 1.0;\n\n\t\tthis.specularMap = null;\n\n\t\tthis.alphaMap = null;\n\n\t\tthis.envMap = null;\n\t\tthis.combine = MultiplyOperation;\n\t\tthis.reflectivity = 1;\n\t\tthis.refractionRatio = 0.98;\n\n\t\tthis.wireframe = false;\n\t\tthis.wireframeLinewidth = 1;\n\t\tthis.wireframeLinecap = 'round';\n\t\tthis.wireframeLinejoin = 'round';\n\n\t\tthis.morphTargets = false;\n\n\t\tthis.setValues( parameters );\n\n\t}\n\n\tcopy( source ) {\n\n\t\tsuper.copy( source );\n\n\t\tthis.color.copy( source.color );\n\n\t\tthis.map = source.map;\n\n\t\tthis.lightMap = source.lightMap;\n\t\tthis.lightMapIntensity = source.lightMapIntensity;\n\n\t\tthis.aoMap = source.aoMap;\n\t\tthis.aoMapIntensity = source.aoMapIntensity;\n\n\t\tthis.specularMap = source.specularMap;\n\n\t\tthis.alphaMap = source.alphaMap;\n\n\t\tthis.envMap = source.envMap;\n\t\tthis.combine = source.combine;\n\t\tthis.reflectivity = source.reflectivity;\n\t\tthis.refractionRatio = source.refractionRatio;\n\n\t\tthis.wireframe = source.wireframe;\n\t\tthis.wireframeLinewidth = source.wireframeLinewidth;\n\t\tthis.wireframeLinecap = source.wireframeLinecap;\n\t\tthis.wireframeLinejoin = source.wireframeLinejoin;\n\n\t\tthis.morphTargets = source.morphTargets;\n\n\t\treturn this;\n\n\t}\n\n}\n\nMeshBasicMaterial.prototype.isMeshBasicMaterial = true;\n\nconst _vector$9 = /*@__PURE__*/ new Vector3();\nconst _vector2 = /*@__PURE__*/ new Vector2();\n\nclass BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tif ( Array.isArray( array ) ) {\n\n\t\t\tthrow new TypeError( 'THREE.BufferAttribute: array should be a Typed Array.' );\n\n\t\t}\n\n\t\tthis.name = '';\n\n\t\tthis.array = array;\n\t\tthis.itemSize = itemSize;\n\t\tthis.count = array !== undefined ? array.length / itemSize : 0;\n\t\tthis.normalized = normalized === true;\n\n\t\tthis.usage = StaticDrawUsage;\n\t\tthis.updateRange = { offset: 0, count: - 1 };\n\n\t\tthis.version = 0;\n\n\t}\n\n\tonUploadCallback() {}\n\n\tset needsUpdate( value ) {\n\n\t\tif ( value === true ) this.version ++;\n\n\t}\n\n\tsetUsage( value ) {\n\n\t\tthis.usage = value;\n\n\t\treturn this;\n\n\t}\n\n\tcopy( source ) {\n\n\t\tthis.name = source.name;\n\t\tthis.array = new source.array.constructor( source.array );\n\t\tthis.itemSize = source.itemSize;\n\t\tthis.count = source.count;\n\t\tthis.normalized = source.normalized;\n\n\t\tthis.usage = source.usage;\n\n\t\treturn this;\n\n\t}\n\n\tcopyAt( index1, attribute, index2 ) {\n\n\t\tindex1 *= this.itemSize;\n\t\tindex2 *= attribute.itemSize;\n\n\t\tfor ( let i = 0, l = this.itemSize; i < l; i ++ ) {\n\n\t\t\tthis.array[ index1 + i ] = attribute.array[ index2 + i ];\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tcopyArray( array ) {\n\n\t\tthis.array.set( array );\n\n\t\treturn this;\n\n\t}\n\n\tcopyColorsArray( colors ) {\n\n\t\tconst array = this.array;\n\t\tlet offset = 0;\n\n\t\tfor ( let i = 0, l = colors.length; i < l; i ++ ) {\n\n\t\t\tlet color = colors[ i ];\n\n\t\t\tif ( color === undefined ) {\n\n\t\t\t\tconsole.warn( 'THREE.BufferAttribute.copyColorsArray(): color is undefined', i );\n\t\t\t\tcolor = new Color();\n\n\t\t\t}\n\n\t\t\tarray[ offset ++ ] = color.r;\n\t\t\tarray[ offset ++ ] = color.g;\n\t\t\tarray[ offset ++ ] = color.b;\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tcopyVector2sArray( vectors ) {\n\n\t\tconst array = this.array;\n\t\tlet offset = 0;\n\n\t\tfor ( let i = 0, l = vectors.length; i < l; i ++ ) {\n\n\t\t\tlet vector = vectors[ i ];\n\n\t\t\tif ( vector === undefined ) {\n\n\t\t\t\tconsole.warn( 'THREE.BufferAttribute.copyVector2sArray(): vector is undefined', i );\n\t\t\t\tvector = new Vector2();\n\n\t\t\t}\n\n\t\t\tarray[ offset ++ ] = vector.x;\n\t\t\tarray[ offset ++ ] = vector.y;\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tcopyVector3sArray( vectors ) {\n\n\t\tconst array = this.array;\n\t\tlet offset = 0;\n\n\t\tfor ( let i = 0, l = vectors.length; i < l; i ++ ) {\n\n\t\t\tlet vector = vectors[ i ];\n\n\t\t\tif ( vector === undefined ) {\n\n\t\t\t\tconsole.warn( 'THREE.BufferAttribute.copyVector3sArray(): vector is undefined', i );\n\t\t\t\tvector = new Vector3();\n\n\t\t\t}\n\n\t\t\tarray[ offset ++ ] = vector.x;\n\t\t\tarray[ offset ++ ] = vector.y;\n\t\t\tarray[ offset ++ ] = vector.z;\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tcopyVector4sArray( vectors ) {\n\n\t\tconst array = this.array;\n\t\tlet offset = 0;\n\n\t\tfor ( let i = 0, l = vectors.length; i < l; i ++ ) {\n\n\t\t\tlet vector = vectors[ i ];\n\n\t\t\tif ( vector === undefined ) {\n\n\t\t\t\tconsole.warn( 'THREE.BufferAttribute.copyVector4sArray(): vector is undefined', i );\n\t\t\t\tvector = new Vector4();\n\n\t\t\t}\n\n\t\t\tarray[ offset ++ ] = vector.x;\n\t\t\tarray[ offset ++ ] = vector.y;\n\t\t\tarray[ offset ++ ] = vector.z;\n\t\t\tarray[ offset ++ ] = vector.w;\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tapplyMatrix3( m ) {\n\n\t\tif ( this.itemSize === 2 ) {\n\n\t\t\tfor ( let i = 0, l = this.count; i < l; i ++ ) {\n\n\t\t\t\t_vector2.fromBufferAttribute( this, i );\n\t\t\t\t_vector2.applyMatrix3( m );\n\n\t\t\t\tthis.setXY( i, _vector2.x, _vector2.y );\n\n\t\t\t}\n\n\t\t} else if ( this.itemSize === 3 ) {\n\n\t\t\tfor ( let i = 0, l = this.count; i < l; i ++ ) {\n\n\t\t\t\t_vector$9.fromBufferAttribute( this, i );\n\t\t\t\t_vector$9.applyMatrix3( m );\n\n\t\t\t\tthis.setXYZ( i, _vector$9.x, _vector$9.y, _vector$9.z );\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tapplyMatrix4( m ) {\n\n\t\tfor ( let i = 0, l = this.count; i < l; i ++ ) {\n\n\t\t\t_vector$9.x = this.getX( i );\n\t\t\t_vector$9.y = this.getY( i );\n\t\t\t_vector$9.z = this.getZ( i );\n\n\t\t\t_vector$9.applyMatrix4( m );\n\n\t\t\tthis.setXYZ( i, _vector$9.x, _vector$9.y, _vector$9.z );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tapplyNormalMatrix( m ) {\n\n\t\tfor ( let i = 0, l = this.count; i < l; i ++ ) {\n\n\t\t\t_vector$9.x = this.getX( i );\n\t\t\t_vector$9.y = this.getY( i );\n\t\t\t_vector$9.z = this.getZ( i );\n\n\t\t\t_vector$9.applyNormalMatrix( m );\n\n\t\t\tthis.setXYZ( i, _vector$9.x, _vector$9.y, _vector$9.z );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\ttransformDirection( m ) {\n\n\t\tfor ( let i = 0, l = this.count; i < l; i ++ ) {\n\n\t\t\t_vector$9.x = this.getX( i );\n\t\t\t_vector$9.y = this.getY( i );\n\t\t\t_vector$9.z = this.getZ( i );\n\n\t\t\t_vector$9.transformDirection( m );\n\n\t\t\tthis.setXYZ( i, _vector$9.x, _vector$9.y, _vector$9.z );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tset( value, offset = 0 ) {\n\n\t\tthis.array.set( value, offset );\n\n\t\treturn this;\n\n\t}\n\n\tgetX( index ) {\n\n\t\treturn this.array[ index * this.itemSize ];\n\n\t}\n\n\tsetX( index, x ) {\n\n\t\tthis.array[ index * this.itemSize ] = x;\n\n\t\treturn this;\n\n\t}\n\n\tgetY( index ) {\n\n\t\treturn this.array[ index * this.itemSize + 1 ];\n\n\t}\n\n\tsetY( index, y ) {\n\n\t\tthis.array[ index * this.itemSize + 1 ] = y;\n\n\t\treturn this;\n\n\t}\n\n\tgetZ( index ) {\n\n\t\treturn this.array[ index * this.itemSize + 2 ];\n\n\t}\n\n\tsetZ( index, z ) {\n\n\t\tthis.array[ index * this.itemSize + 2 ] = z;\n\n\t\treturn this;\n\n\t}\n\n\tgetW( index ) {\n\n\t\treturn this.array[ index * this.itemSize + 3 ];\n\n\t}\n\n\tsetW( index, w ) {\n\n\t\tthis.array[ index * this.itemSize + 3 ] = w;\n\n\t\treturn this;\n\n\t}\n\n\tsetXY( index, x, y ) {\n\n\t\tindex *= this.itemSize;\n\n\t\tthis.array[ index + 0 ] = x;\n\t\tthis.array[ index + 1 ] = y;\n\n\t\treturn this;\n\n\t}\n\n\tsetXYZ( index, x, y, z ) {\n\n\t\tindex *= this.itemSize;\n\n\t\tthis.array[ index + 0 ] = x;\n\t\tthis.array[ index + 1 ] = y;\n\t\tthis.array[ index + 2 ] = z;\n\n\t\treturn this;\n\n\t}\n\n\tsetXYZW( index, x, y, z, w ) {\n\n\t\tindex *= this.itemSize;\n\n\t\tthis.array[ index + 0 ] = x;\n\t\tthis.array[ index + 1 ] = y;\n\t\tthis.array[ index + 2 ] = z;\n\t\tthis.array[ index + 3 ] = w;\n\n\t\treturn this;\n\n\t}\n\n\tonUpload( callback ) {\n\n\t\tthis.onUploadCallback = callback;\n\n\t\treturn this;\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor( this.array, this.itemSize ).copy( this );\n\n\t}\n\n\ttoJSON() {\n\n\t\tconst data = {\n\t\t\titemSize: this.itemSize,\n\t\t\ttype: this.array.constructor.name,\n\t\t\tarray: Array.prototype.slice.call( this.array ),\n\t\t\tnormalized: this.normalized\n\t\t};\n\n\t\tif ( this.name !== '' ) data.name = this.name;\n\t\tif ( this.usage !== StaticDrawUsage ) data.usage = this.usage;\n\t\tif ( this.updateRange.offset !== 0 || this.updateRange.count !== - 1 ) data.updateRange = this.updateRange;\n\n\t\treturn data;\n\n\t}\n\n}\n\nBufferAttribute.prototype.isBufferAttribute = true;\n\n//\n\nclass Int8BufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Int8Array( array ), itemSize, normalized );\n\n\t}\n\n}\n\nclass Uint8BufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Uint8Array( array ), itemSize, normalized );\n\n\t}\n\n}\n\nclass Uint8ClampedBufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Uint8ClampedArray( array ), itemSize, normalized );\n\n\t}\n\n}\n\nclass Int16BufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Int16Array( array ), itemSize, normalized );\n\n\t}\n\n}\n\nclass Uint16BufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Uint16Array( array ), itemSize, normalized );\n\n\t}\n\n}\n\nclass Int32BufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Int32Array( array ), itemSize, normalized );\n\n\t}\n\n}\n\nclass Uint32BufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Uint32Array( array ), itemSize, normalized );\n\n\t}\n\n}\n\nclass Float16BufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Uint16Array( array ), itemSize, normalized );\n\n\t}\n\n}\n\nFloat16BufferAttribute.prototype.isFloat16BufferAttribute = true;\n\nclass Float32BufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Float32Array( array ), itemSize, normalized );\n\n\t}\n\n}\n\nclass Float64BufferAttribute extends BufferAttribute {\n\n\tconstructor( array, itemSize, normalized ) {\n\n\t\tsuper( new Float64Array( array ), itemSize, normalized );\n\n\t}\n\n}\n\nfunction arrayMax( array ) {\n\n\tif ( array.length === 0 ) return - Infinity;\n\n\tlet max = array[ 0 ];\n\n\tfor ( let i = 1, l = array.length; i < l; ++ i ) {\n\n\t\tif ( array[ i ] > max ) max = array[ i ];\n\n\t}\n\n\treturn max;\n\n}\n\nconst TYPED_ARRAYS = {\n\tInt8Array: Int8Array,\n\tUint8Array: Uint8Array,\n\tUint8ClampedArray: Uint8ClampedArray,\n\tInt16Array: Int16Array,\n\tUint16Array: Uint16Array,\n\tInt32Array: Int32Array,\n\tUint32Array: Uint32Array,\n\tFloat32Array: Float32Array,\n\tFloat64Array: Float64Array\n};\n\nfunction getTypedArray( type, buffer ) {\n\n\treturn new TYPED_ARRAYS[ type ]( buffer );\n\n}\n\nlet _id = 0;\n\nconst _m1 = /*@__PURE__*/ new Matrix4();\nconst _obj = /*@__PURE__*/ new Object3D();\nconst _offset = /*@__PURE__*/ new Vector3();\nconst _box$1 = /*@__PURE__*/ new Box3();\nconst _boxMorphTargets = /*@__PURE__*/ new Box3();\nconst _vector$8 = /*@__PURE__*/ new Vector3();\n\nclass BufferGeometry extends EventDispatcher {\n\n\tconstructor() {\n\n\t\tsuper();\n\n\t\tObject.defineProperty( this, 'id', { value: _id ++ } );\n\n\t\tthis.uuid = generateUUID();\n\n\t\tthis.name = '';\n\t\tthis.type = 'BufferGeometry';\n\n\t\tthis.index = null;\n\t\tthis.attributes = {};\n\n\t\tthis.morphAttributes = {};\n\t\tthis.morphTargetsRelative = false;\n\n\t\tthis.groups = [];\n\n\t\tthis.boundingBox = null;\n\t\tthis.boundingSphere = null;\n\n\t\tthis.drawRange = { start: 0, count: Infinity };\n\n\t\tthis.userData = {};\n\n\t}\n\n\tgetIndex() {\n\n\t\treturn this.index;\n\n\t}\n\n\tsetIndex( index ) {\n\n\t\tif ( Array.isArray( index ) ) {\n\n\t\t\tthis.index = new ( arrayMax( index ) > 65535 ? Uint32BufferAttribute : Uint16BufferAttribute )( index, 1 );\n\n\t\t} else {\n\n\t\t\tthis.index = index;\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tgetAttribute( name ) {\n\n\t\treturn this.attributes[ name ];\n\n\t}\n\n\tsetAttribute( name, attribute ) {\n\n\t\tthis.attributes[ name ] = attribute;\n\n\t\treturn this;\n\n\t}\n\n\tdeleteAttribute( name ) {\n\n\t\tdelete this.attributes[ name ];\n\n\t\treturn this;\n\n\t}\n\n\thasAttribute( name ) {\n\n\t\treturn this.attributes[ name ] !== undefined;\n\n\t}\n\n\taddGroup( start, count, materialIndex = 0 ) {\n\n\t\tthis.groups.push( {\n\n\t\t\tstart: start,\n\t\t\tcount: count,\n\t\t\tmaterialIndex: materialIndex\n\n\t\t} );\n\n\t}\n\n\tclearGroups() {\n\n\t\tthis.groups = [];\n\n\t}\n\n\tsetDrawRange( start, count ) {\n\n\t\tthis.drawRange.start = start;\n\t\tthis.drawRange.count = count;\n\n\t}\n\n\tapplyMatrix4( matrix ) {\n\n\t\tconst position = this.attributes.position;\n\n\t\tif ( position !== undefined ) {\n\n\t\t\tposition.applyMatrix4( matrix );\n\n\t\t\tposition.needsUpdate = true;\n\n\t\t}\n\n\t\tconst normal = this.attributes.normal;\n\n\t\tif ( normal !== undefined ) {\n\n\t\t\tconst normalMatrix = new Matrix3().getNormalMatrix( matrix );\n\n\t\t\tnormal.applyNormalMatrix( normalMatrix );\n\n\t\t\tnormal.needsUpdate = true;\n\n\t\t}\n\n\t\tconst tangent = this.attributes.tangent;\n\n\t\tif ( tangent !== undefined ) {\n\n\t\t\ttangent.transformDirection( matrix );\n\n\t\t\ttangent.needsUpdate = true;\n\n\t\t}\n\n\t\tif ( this.boundingBox !== null ) {\n\n\t\t\tthis.computeBoundingBox();\n\n\t\t}\n\n\t\tif ( this.boundingSphere !== null ) {\n\n\t\t\tthis.computeBoundingSphere();\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tapplyQuaternion( q ) {\n\n\t\t_m1.makeRotationFromQuaternion( q );\n\n\t\tthis.applyMatrix4( _m1 );\n\n\t\treturn this;\n\n\t}\n\n\trotateX( angle ) {\n\n\t\t// rotate geometry around world x-axis\n\n\t\t_m1.makeRotationX( angle );\n\n\t\tthis.applyMatrix4( _m1 );\n\n\t\treturn this;\n\n\t}\n\n\trotateY( angle ) {\n\n\t\t// rotate geometry around world y-axis\n\n\t\t_m1.makeRotationY( angle );\n\n\t\tthis.applyMatrix4( _m1 );\n\n\t\treturn this;\n\n\t}\n\n\trotateZ( angle ) {\n\n\t\t// rotate geometry around world z-axis\n\n\t\t_m1.makeRotationZ( angle );\n\n\t\tthis.applyMatrix4( _m1 );\n\n\t\treturn this;\n\n\t}\n\n\ttranslate( x, y, z ) {\n\n\t\t// translate geometry\n\n\t\t_m1.makeTranslation( x, y, z );\n\n\t\tthis.applyMatrix4( _m1 );\n\n\t\treturn this;\n\n\t}\n\n\tscale( x, y, z ) {\n\n\t\t// scale geometry\n\n\t\t_m1.makeScale( x, y, z );\n\n\t\tthis.applyMatrix4( _m1 );\n\n\t\treturn this;\n\n\t}\n\n\tlookAt( vector ) {\n\n\t\t_obj.lookAt( vector );\n\n\t\t_obj.updateMatrix();\n\n\t\tthis.applyMatrix4( _obj.matrix );\n\n\t\treturn this;\n\n\t}\n\n\tcenter() {\n\n\t\tthis.computeBoundingBox();\n\n\t\tthis.boundingBox.getCenter( _offset ).negate();\n\n\t\tthis.translate( _offset.x, _offset.y, _offset.z );\n\n\t\treturn this;\n\n\t}\n\n\tsetFromPoints( points ) {\n\n\t\tconst position = [];\n\n\t\tfor ( let i = 0, l = points.length; i < l; i ++ ) {\n\n\t\t\tconst point = points[ i ];\n\t\t\tposition.push( point.x, point.y, point.z || 0 );\n\n\t\t}\n\n\t\tthis.setAttribute( 'position', new Float32BufferAttribute( position, 3 ) );\n\n\t\treturn this;\n\n\t}\n\n\tcomputeBoundingBox() {\n\n\t\tif ( this.boundingBox === null ) {\n\n\t\t\tthis.boundingBox = new Box3();\n\n\t\t}\n\n\t\tconst position = this.attributes.position;\n\t\tconst morphAttributesPosition = this.morphAttributes.position;\n\n\t\tif ( position && position.isGLBufferAttribute ) {\n\n\t\t\tconsole.error( 'THREE.BufferGeometry.computeBoundingBox(): GLBufferAttribute requires a manual bounding box. Alternatively set \"mesh.frustumCulled\" to \"false\".', this );\n\n\t\t\tthis.boundingBox.set(\n\t\t\t\tnew Vector3( - Infinity, - Infinity, - Infinity ),\n\t\t\t\tnew Vector3( + Infinity, + Infinity, + Infinity )\n\t\t\t);\n\n\t\t\treturn;\n\n\t\t}\n\n\t\tif ( position !== undefined ) {\n\n\t\t\tthis.boundingBox.setFromBufferAttribute( position );\n\n\t\t\t// process morph attributes if present\n\n\t\t\tif ( morphAttributesPosition ) {\n\n\t\t\t\tfor ( let i = 0, il = morphAttributesPosition.length; i < il; i ++ ) {\n\n\t\t\t\t\tconst morphAttribute = morphAttributesPosition[ i ];\n\t\t\t\t\t_box$1.setFromBufferAttribute( morphAttribute );\n\n\t\t\t\t\tif ( this.morphTargetsRelative ) {\n\n\t\t\t\t\t\t_vector$8.addVectors( this.boundingBox.min, _box$1.min );\n\t\t\t\t\t\tthis.boundingBox.expandByPoint( _vector$8 );\n\n\t\t\t\t\t\t_vector$8.addVectors( this.boundingBox.max, _box$1.max );\n\t\t\t\t\t\tthis.boundingBox.expandByPoint( _vector$8 );\n\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\tthis.boundingBox.expandByPoint( _box$1.min );\n\t\t\t\t\t\tthis.boundingBox.expandByPoint( _box$1.max );\n\n\t\t\t\t\t}\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tthis.boundingBox.makeEmpty();\n\n\t\t}\n\n\t\tif ( isNaN( this.boundingBox.min.x ) || isNaN( this.boundingBox.min.y ) || isNaN( this.boundingBox.min.z ) ) {\n\n\t\t\tconsole.error( 'THREE.BufferGeometry.computeBoundingBox(): Computed min/max have NaN values. The \"position\" attribute is likely to have NaN values.', this );\n\n\t\t}\n\n\t}\n\n\tcomputeBoundingSphere() {\n\n\t\tif ( this.boundingSphere === null ) {\n\n\t\t\tthis.boundingSphere = new Sphere();\n\n\t\t}\n\n\t\tconst position = this.attributes.position;\n\t\tconst morphAttributesPosition = this.morphAttributes.position;\n\n\t\tif ( position && position.isGLBufferAttribute ) {\n\n\t\t\tconsole.error( 'THREE.BufferGeometry.computeBoundingSphere(): GLBufferAttribute requires a manual bounding sphere. Alternatively set \"mesh.frustumCulled\" to \"false\".', this );\n\n\t\t\tthis.boundingSphere.set( new Vector3(), Infinity );\n\n\t\t\treturn;\n\n\t\t}\n\n\t\tif ( position ) {\n\n\t\t\t// first, find the center of the bounding sphere\n\n\t\t\tconst center = this.boundingSphere.center;\n\n\t\t\t_box$1.setFromBufferAttribute( position );\n\n\t\t\t// process morph attributes if present\n\n\t\t\tif ( morphAttributesPosition ) {\n\n\t\t\t\tfor ( let i = 0, il = morphAttributesPosition.length; i < il; i ++ ) {\n\n\t\t\t\t\tconst morphAttribute = morphAttributesPosition[ i ];\n\t\t\t\t\t_boxMorphTargets.setFromBufferAttribute( morphAttribute );\n\n\t\t\t\t\tif ( this.morphTargetsRelative ) {\n\n\t\t\t\t\t\t_vector$8.addVectors( _box$1.min, _boxMorphTargets.min );\n\t\t\t\t\t\t_box$1.expandByPoint( _vector$8 );\n\n\t\t\t\t\t\t_vector$8.addVectors( _box$1.max, _boxMorphTargets.max );\n\t\t\t\t\t\t_box$1.expandByPoint( _vector$8 );\n\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\t_box$1.expandByPoint( _boxMorphTargets.min );\n\t\t\t\t\t\t_box$1.expandByPoint( _boxMorphTargets.max );\n\n\t\t\t\t\t}\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\t_box$1.getCenter( center );\n\n\t\t\t// second, try to find a boundingSphere with a radius smaller than the\n\t\t\t// boundingSphere of the boundingBox: sqrt(3) smaller in the best case\n\n\t\t\tlet maxRadiusSq = 0;\n\n\t\t\tfor ( let i = 0, il = position.count; i < il; i ++ ) {\n\n\t\t\t\t_vector$8.fromBufferAttribute( position, i );\n\n\t\t\t\tmaxRadiusSq = Math.max( maxRadiusSq, center.distanceToSquared( _vector$8 ) );\n\n\t\t\t}\n\n\t\t\t// process morph attributes if present\n\n\t\t\tif ( morphAttributesPosition ) {\n\n\t\t\t\tfor ( let i = 0, il = morphAttributesPosition.length; i < il; i ++ ) {\n\n\t\t\t\t\tconst morphAttribute = morphAttributesPosition[ i ];\n\t\t\t\t\tconst morphTargetsRelative = this.morphTargetsRelative;\n\n\t\t\t\t\tfor ( let j = 0, jl = morphAttribute.count; j < jl; j ++ ) {\n\n\t\t\t\t\t\t_vector$8.fromBufferAttribute( morphAttribute, j );\n\n\t\t\t\t\t\tif ( morphTargetsRelative ) {\n\n\t\t\t\t\t\t\t_offset.fromBufferAttribute( position, j );\n\t\t\t\t\t\t\t_vector$8.add( _offset );\n\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tmaxRadiusSq = Math.max( maxRadiusSq, center.distanceToSquared( _vector$8 ) );\n\n\t\t\t\t\t}\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\tthis.boundingSphere.radius = Math.sqrt( maxRadiusSq );\n\n\t\t\tif ( isNaN( this.boundingSphere.radius ) ) {\n\n\t\t\t\tconsole.error( 'THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The \"position\" attribute is likely to have NaN values.', this );\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\tcomputeFaceNormals() {\n\n\t\t// backwards compatibility\n\n\t}\n\n\tcomputeTangents() {\n\n\t\tconst index = this.index;\n\t\tconst attributes = this.attributes;\n\n\t\t// based on http://www.terathon.com/code/tangent.html\n\t\t// (per vertex tangents)\n\n\t\tif ( index === null ||\n\t\t\t attributes.position === undefined ||\n\t\t\t attributes.normal === undefined ||\n\t\t\t attributes.uv === undefined ) {\n\n\t\t\tconsole.error( 'THREE.BufferGeometry: .computeTangents() failed. Missing required attributes (index, position, normal or uv)' );\n\t\t\treturn;\n\n\t\t}\n\n\t\tconst indices = index.array;\n\t\tconst positions = attributes.position.array;\n\t\tconst normals = attributes.normal.array;\n\t\tconst uvs = attributes.uv.array;\n\n\t\tconst nVertices = positions.length / 3;\n\n\t\tif ( attributes.tangent === undefined ) {\n\n\t\t\tthis.setAttribute( 'tangent', new BufferAttribute( new Float32Array( 4 * nVertices ), 4 ) );\n\n\t\t}\n\n\t\tconst tangents = attributes.tangent.array;\n\n\t\tconst tan1 = [], tan2 = [];\n\n\t\tfor ( let i = 0; i < nVertices; i ++ ) {\n\n\t\t\ttan1[ i ] = new Vector3();\n\t\t\ttan2[ i ] = new Vector3();\n\n\t\t}\n\n\t\tconst vA = new Vector3(),\n\t\t\tvB = new Vector3(),\n\t\t\tvC = new Vector3(),\n\n\t\t\tuvA = new Vector2(),\n\t\t\tuvB = new Vector2(),\n\t\t\tuvC = new Vector2(),\n\n\t\t\tsdir = new Vector3(),\n\t\t\ttdir = new Vector3();\n\n\t\tfunction handleTriangle( a, b, c ) {\n\n\t\t\tvA.fromArray( positions, a * 3 );\n\t\t\tvB.fromArray( positions, b * 3 );\n\t\t\tvC.fromArray( positions, c * 3 );\n\n\t\t\tuvA.fromArray( uvs, a * 2 );\n\t\t\tuvB.fromArray( uvs, b * 2 );\n\t\t\tuvC.fromArray( uvs, c * 2 );\n\n\t\t\tvB.sub( vA );\n\t\t\tvC.sub( vA );\n\n\t\t\tuvB.sub( uvA );\n\t\t\tuvC.sub( uvA );\n\n\t\t\tconst r = 1.0 / ( uvB.x * uvC.y - uvC.x * uvB.y );\n\n\t\t\t// silently ignore degenerate uv triangles having coincident or colinear vertices\n\n\t\t\tif ( ! isFinite( r ) ) return;\n\n\t\t\tsdir.copy( vB ).multiplyScalar( uvC.y ).addScaledVector( vC, - uvB.y ).multiplyScalar( r );\n\t\t\ttdir.copy( vC ).multiplyScalar( uvB.x ).addScaledVector( vB, - uvC.x ).multiplyScalar( r );\n\n\t\t\ttan1[ a ].add( sdir );\n\t\t\ttan1[ b ].add( sdir );\n\t\t\ttan1[ c ].add( sdir );\n\n\t\t\ttan2[ a ].add( tdir );\n\t\t\ttan2[ b ].add( tdir );\n\t\t\ttan2[ c ].add( tdir );\n\n\t\t}\n\n\t\tlet groups = this.groups;\n\n\t\tif ( groups.length === 0 ) {\n\n\t\t\tgroups = [ {\n\t\t\t\tstart: 0,\n\t\t\t\tcount: indices.length\n\t\t\t} ];\n\n\t\t}\n\n\t\tfor ( let i = 0, il = groups.length; i < il; ++ i ) {\n\n\t\t\tconst group = groups[ i ];\n\n\t\t\tconst start = group.start;\n\t\t\tconst count = group.count;\n\n\t\t\tfor ( let j = start, jl = start + count; j < jl; j += 3 ) {\n\n\t\t\t\thandleTriangle(\n\t\t\t\t\tindices[ j + 0 ],\n\t\t\t\t\tindices[ j + 1 ],\n\t\t\t\t\tindices[ j + 2 ]\n\t\t\t\t);\n\n\t\t\t}\n\n\t\t}\n\n\t\tconst tmp = new Vector3(), tmp2 = new Vector3();\n\t\tconst n = new Vector3(), n2 = new Vector3();\n\n\t\tfunction handleVertex( v ) {\n\n\t\t\tn.fromArray( normals, v * 3 );\n\t\t\tn2.copy( n );\n\n\t\t\tconst t = tan1[ v ];\n\n\t\t\t// Gram-Schmidt orthogonalize\n\n\t\t\ttmp.copy( t );\n\t\t\ttmp.sub( n.multiplyScalar( n.dot( t ) ) ).normalize();\n\n\t\t\t// Calculate handedness\n\n\t\t\ttmp2.crossVectors( n2, t );\n\t\t\tconst test = tmp2.dot( tan2[ v ] );\n\t\t\tconst w = ( test < 0.0 ) ? - 1.0 : 1.0;\n\n\t\t\ttangents[ v * 4 ] = tmp.x;\n\t\t\ttangents[ v * 4 + 1 ] = tmp.y;\n\t\t\ttangents[ v * 4 + 2 ] = tmp.z;\n\t\t\ttangents[ v * 4 + 3 ] = w;\n\n\t\t}\n\n\t\tfor ( let i = 0, il = groups.length; i < il; ++ i ) {\n\n\t\t\tconst group = groups[ i ];\n\n\t\t\tconst start = group.start;\n\t\t\tconst count = group.count;\n\n\t\t\tfor ( let j = start, jl = start + count; j < jl; j += 3 ) {\n\n\t\t\t\thandleVertex( indices[ j + 0 ] );\n\t\t\t\thandleVertex( indices[ j + 1 ] );\n\t\t\t\thandleVertex( indices[ j + 2 ] );\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\tcomputeVertexNormals() {\n\n\t\tconst index = this.index;\n\t\tconst positionAttribute = this.getAttribute( 'position' );\n\n\t\tif ( positionAttribute !== undefined ) {\n\n\t\t\tlet normalAttribute = this.getAttribute( 'normal' );\n\n\t\t\tif ( normalAttribute === undefined ) {\n\n\t\t\t\tnormalAttribute = new BufferAttribute( new Float32Array( positionAttribute.count * 3 ), 3 );\n\t\t\t\tthis.setAttribute( 'normal', normalAttribute );\n\n\t\t\t} else {\n\n\t\t\t\t// reset existing normals to zero\n\n\t\t\t\tfor ( let i = 0, il = normalAttribute.count; i < il; i ++ ) {\n\n\t\t\t\t\tnormalAttribute.setXYZ( i, 0, 0, 0 );\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\tconst pA = new Vector3(), pB = new Vector3(), pC = new Vector3();\n\t\t\tconst nA = new Vector3(), nB = new Vector3(), nC = new Vector3();\n\t\t\tconst cb = new Vector3(), ab = new Vector3();\n\n\t\t\t// indexed elements\n\n\t\t\tif ( index ) {\n\n\t\t\t\tfor ( let i = 0, il = index.count; i < il; i += 3 ) {\n\n\t\t\t\t\tconst vA = index.getX( i + 0 );\n\t\t\t\t\tconst vB = index.getX( i + 1 );\n\t\t\t\t\tconst vC = index.getX( i + 2 );\n\n\t\t\t\t\tpA.fromBufferAttribute( positionAttribute, vA );\n\t\t\t\t\tpB.fromBufferAttribute( positionAttribute, vB );\n\t\t\t\t\tpC.fromBufferAttribute( positionAttribute, vC );\n\n\t\t\t\t\tcb.subVectors( pC, pB );\n\t\t\t\t\tab.subVectors( pA, pB );\n\t\t\t\t\tcb.cross( ab );\n\n\t\t\t\t\tnA.fromBufferAttribute( normalAttribute, vA );\n\t\t\t\t\tnB.fromBufferAttribute( normalAttribute, vB );\n\t\t\t\t\tnC.fromBufferAttribute( normalAttribute, vC );\n\n\t\t\t\t\tnA.add( cb );\n\t\t\t\t\tnB.add( cb );\n\t\t\t\t\tnC.add( cb );\n\n\t\t\t\t\tnormalAttribute.setXYZ( vA, nA.x, nA.y, nA.z );\n\t\t\t\t\tnormalAttribute.setXYZ( vB, nB.x, nB.y, nB.z );\n\t\t\t\t\tnormalAttribute.setXYZ( vC, nC.x, nC.y, nC.z );\n\n\t\t\t\t}\n\n\t\t\t} else {\n\n\t\t\t\t// non-indexed elements (unconnected triangle soup)\n\n\t\t\t\tfor ( let i = 0, il = positionAttribute.count; i < il; i += 3 ) {\n\n\t\t\t\t\tpA.fromBufferAttribute( positionAttribute, i + 0 );\n\t\t\t\t\tpB.fromBufferAttribute( positionAttribute, i + 1 );\n\t\t\t\t\tpC.fromBufferAttribute( positionAttribute, i + 2 );\n\n\t\t\t\t\tcb.subVectors( pC, pB );\n\t\t\t\t\tab.subVectors( pA, pB );\n\t\t\t\t\tcb.cross( ab );\n\n\t\t\t\t\tnormalAttribute.setXYZ( i + 0, cb.x, cb.y, cb.z );\n\t\t\t\t\tnormalAttribute.setXYZ( i + 1, cb.x, cb.y, cb.z );\n\t\t\t\t\tnormalAttribute.setXYZ( i + 2, cb.x, cb.y, cb.z );\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\tthis.normalizeNormals();\n\n\t\t\tnormalAttribute.needsUpdate = true;\n\n\t\t}\n\n\t}\n\n\tmerge( geometry, offset ) {\n\n\t\tif ( ! ( geometry && geometry.isBufferGeometry ) ) {\n\n\t\t\tconsole.error( 'THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.', geometry );\n\t\t\treturn;\n\n\t\t}\n\n\t\tif ( offset === undefined ) {\n\n\t\t\toffset = 0;\n\n\t\t\tconsole.warn(\n\t\t\t\t'THREE.BufferGeometry.merge(): Overwriting original geometry, starting at offset=0. '\n\t\t\t\t+ 'Use BufferGeometryUtils.mergeBufferGeometries() for lossless merge.'\n\t\t\t);\n\n\t\t}\n\n\t\tconst attributes = this.attributes;\n\n\t\tfor ( const key in attributes ) {\n\n\t\t\tif ( geometry.attributes[ key ] === undefined ) continue;\n\n\t\t\tconst attribute1 = attributes[ key ];\n\t\t\tconst attributeArray1 = attribute1.array;\n\n\t\t\tconst attribute2 = geometry.attributes[ key ];\n\t\t\tconst attributeArray2 = attribute2.array;\n\n\t\t\tconst attributeOffset = attribute2.itemSize * offset;\n\t\t\tconst length = Math.min( attributeArray2.length, attributeArray1.length - attributeOffset );\n\n\t\t\tfor ( let i = 0, j = attributeOffset; i < length; i ++, j ++ ) {\n\n\t\t\t\tattributeArray1[ j ] = attributeArray2[ i ];\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tnormalizeNormals() {\n\n\t\tconst normals = this.attributes.normal;\n\n\t\tfor ( let i = 0, il = normals.count; i < il; i ++ ) {\n\n\t\t\t_vector$8.fromBufferAttribute( normals, i );\n\n\t\t\t_vector$8.normalize();\n\n\t\t\tnormals.setXYZ( i, _vector$8.x, _vector$8.y, _vector$8.z );\n\n\t\t}\n\n\t}\n\n\ttoNonIndexed() {\n\n\t\tfunction convertBufferAttribute( attribute, indices ) {\n\n\t\t\tconst array = attribute.array;\n\t\t\tconst itemSize = attribute.itemSize;\n\t\t\tconst normalized = attribute.normalized;\n\n\t\t\tconst array2 = new array.constructor( indices.length * itemSize );\n\n\t\t\tlet index = 0, index2 = 0;\n\n\t\t\tfor ( let i = 0, l = indices.length; i < l; i ++ ) {\n\n\t\t\t\tindex = indices[ i ] * itemSize;\n\n\t\t\t\tfor ( let j = 0; j < itemSize; j ++ ) {\n\n\t\t\t\t\tarray2[ index2 ++ ] = array[ index ++ ];\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\treturn new BufferAttribute( array2, itemSize, normalized );\n\n\t\t}\n\n\t\t//\n\n\t\tif ( this.index === null ) {\n\n\t\t\tconsole.warn( 'THREE.BufferGeometry.toNonIndexed(): BufferGeometry is already non-indexed.' );\n\t\t\treturn this;\n\n\t\t}\n\n\t\tconst geometry2 = new BufferGeometry();\n\n\t\tconst indices = this.index.array;\n\t\tconst attributes = this.attributes;\n\n\t\t// attributes\n\n\t\tfor ( const name in attributes ) {\n\n\t\t\tconst attribute = attributes[ name ];\n\n\t\t\tconst newAttribute = convertBufferAttribute( attribute, indices );\n\n\t\t\tgeometry2.setAttribute( name, newAttribute );\n\n\t\t}\n\n\t\t// morph attributes\n\n\t\tconst morphAttributes = this.morphAttributes;\n\n\t\tfor ( const name in morphAttributes ) {\n\n\t\t\tconst morphArray = [];\n\t\t\tconst morphAttribute = morphAttributes[ name ]; // morphAttribute: array of Float32BufferAttributes\n\n\t\t\tfor ( let i = 0, il = morphAttribute.length; i < il; i ++ ) {\n\n\t\t\t\tconst attribute = morphAttribute[ i ];\n\n\t\t\t\tconst newAttribute = convertBufferAttribute( attribute, indices );\n\n\t\t\t\tmorphArray.push( newAttribute );\n\n\t\t\t}\n\n\t\t\tgeometry2.morphAttributes[ name ] = morphArray;\n\n\t\t}\n\n\t\tgeometry2.morphTargetsRelative = this.morphTargetsRelative;\n\n\t\t// groups\n\n\t\tconst groups = this.groups;\n\n\t\tfor ( let i = 0, l = groups.length; i < l; i ++ ) {\n\n\t\t\tconst group = groups[ i ];\n\t\t\tgeometry2.addGroup( group.start, group.count, group.materialIndex );\n\n\t\t}\n\n\t\treturn geometry2;\n\n\t}\n\n\ttoJSON() {\n\n\t\tconst data = {\n\t\t\tmetadata: {\n\t\t\t\tversion: 4.5,\n\t\t\t\ttype: 'BufferGeometry',\n\t\t\t\tgenerator: 'BufferGeometry.toJSON'\n\t\t\t}\n\t\t};\n\n\t\t// standard BufferGeometry serialization\n\n\t\tdata.uuid = this.uuid;\n\t\tdata.type = this.type;\n\t\tif ( this.name !== '' ) data.name = this.name;\n\t\tif ( Object.keys( this.userData ).length > 0 ) data.userData = this.userData;\n\n\t\tif ( this.parameters !== undefined ) {\n\n\t\t\tconst parameters = this.parameters;\n\n\t\t\tfor ( const key in parameters ) {\n\n\t\t\t\tif ( parameters[ key ] !== undefined ) data[ key ] = parameters[ key ];\n\n\t\t\t}\n\n\t\t\treturn data;\n\n\t\t}\n\n\t\t// for simplicity the code assumes attributes are not shared across geometries, see #15811\n\n\t\tdata.data = { attributes: {} };\n\n\t\tconst index = this.index;\n\n\t\tif ( index !== null ) {\n\n\t\t\tdata.data.index = {\n\t\t\t\ttype: index.array.constructor.name,\n\t\t\t\tarray: Array.prototype.slice.call( index.array )\n\t\t\t};\n\n\t\t}\n\n\t\tconst attributes = this.attributes;\n\n\t\tfor ( const key in attributes ) {\n\n\t\t\tconst attribute = attributes[ key ];\n\n\t\t\tdata.data.attributes[ key ] = attribute.toJSON( data.data );\n\n\t\t}\n\n\t\tconst morphAttributes = {};\n\t\tlet hasMorphAttributes = false;\n\n\t\tfor ( const key in this.morphAttributes ) {\n\n\t\t\tconst attributeArray = this.morphAttributes[ key ];\n\n\t\t\tconst array = [];\n\n\t\t\tfor ( let i = 0, il = attributeArray.length; i < il; i ++ ) {\n\n\t\t\t\tconst attribute = attributeArray[ i ];\n\n\t\t\t\tarray.push( attribute.toJSON( data.data ) );\n\n\t\t\t}\n\n\t\t\tif ( array.length > 0 ) {\n\n\t\t\t\tmorphAttributes[ key ] = array;\n\n\t\t\t\thasMorphAttributes = true;\n\n\t\t\t}\n\n\t\t}\n\n\t\tif ( hasMorphAttributes ) {\n\n\t\t\tdata.data.morphAttributes = morphAttributes;\n\t\t\tdata.data.morphTargetsRelative = this.morphTargetsRelative;\n\n\t\t}\n\n\t\tconst groups = this.groups;\n\n\t\tif ( groups.length > 0 ) {\n\n\t\t\tdata.data.groups = JSON.parse( JSON.stringify( groups ) );\n\n\t\t}\n\n\t\tconst boundingSphere = this.boundingSphere;\n\n\t\tif ( boundingSphere !== null ) {\n\n\t\t\tdata.data.boundingSphere = {\n\t\t\t\tcenter: boundingSphere.center.toArray(),\n\t\t\t\tradius: boundingSphere.radius\n\t\t\t};\n\n\t\t}\n\n\t\treturn data;\n\n\t}\n\n\tclone() {\n\n\t\t/*\n\t\t // Handle primitives\n\n\t\t const parameters = this.parameters;\n\n\t\t if ( parameters !== undefined ) {\n\n\t\t const values = [];\n\n\t\t for ( const key in parameters ) {\n\n\t\t values.push( parameters[ key ] );\n\n\t\t }\n\n\t\t const geometry = Object.create( this.constructor.prototype );\n\t\t this.constructor.apply( geometry, values );\n\t\t return geometry;\n\n\t\t }\n\n\t\t return new this.constructor().copy( this );\n\t\t */\n\n\t\treturn new BufferGeometry().copy( this );\n\n\t}\n\n\tcopy( source ) {\n\n\t\t// reset\n\n\t\tthis.index = null;\n\t\tthis.attributes = {};\n\t\tthis.morphAttributes = {};\n\t\tthis.groups = [];\n\t\tthis.boundingBox = null;\n\t\tthis.boundingSphere = null;\n\n\t\t// used for storing cloned, shared data\n\n\t\tconst data = {};\n\n\t\t// name\n\n\t\tthis.name = source.name;\n\n\t\t// index\n\n\t\tconst index = source.index;\n\n\t\tif ( index !== null ) {\n\n\t\t\tthis.setIndex( index.clone( data ) );\n\n\t\t}\n\n\t\t// attributes\n\n\t\tconst attributes = source.attributes;\n\n\t\tfor ( const name in attributes ) {\n\n\t\t\tconst attribute = attributes[ name ];\n\t\t\tthis.setAttribute( name, attribute.clone( data ) );\n\n\t\t}\n\n\t\t// morph attributes\n\n\t\tconst morphAttributes = source.morphAttributes;\n\n\t\tfor ( const name in morphAttributes ) {\n\n\t\t\tconst array = [];\n\t\t\tconst morphAttribute = morphAttributes[ name ]; // morphAttribute: array of Float32BufferAttributes\n\n\t\t\tfor ( let i = 0, l = morphAttribute.length; i < l; i ++ ) {\n\n\t\t\t\tarray.push( morphAttribute[ i ].clone( data ) );\n\n\t\t\t}\n\n\t\t\tthis.morphAttributes[ name ] = array;\n\n\t\t}\n\n\t\tthis.morphTargetsRelative = source.morphTargetsRelative;\n\n\t\t// groups\n\n\t\tconst groups = source.groups;\n\n\t\tfor ( let i = 0, l = groups.length; i < l; i ++ ) {\n\n\t\t\tconst group = groups[ i ];\n\t\t\tthis.addGroup( group.start, group.count, group.materialIndex );\n\n\t\t}\n\n\t\t// bounding box\n\n\t\tconst boundingBox = source.boundingBox;\n\n\t\tif ( boundingBox !== null ) {\n\n\t\t\tthis.boundingBox = boundingBox.clone();\n\n\t\t}\n\n\t\t// bounding sphere\n\n\t\tconst boundingSphere = source.boundingSphere;\n\n\t\tif ( boundingSphere !== null ) {\n\n\t\t\tthis.boundingSphere = boundingSphere.clone();\n\n\t\t}\n\n\t\t// draw range\n\n\t\tthis.drawRange.start = source.drawRange.start;\n\t\tthis.drawRange.count = source.drawRange.count;\n\n\t\t// user data\n\n\t\tthis.userData = source.userData;\n\n\t\treturn this;\n\n\t}\n\n\tdispose() {\n\n\t\tthis.dispatchEvent( { type: 'dispose' } );\n\n\t}\n\n}\n\nBufferGeometry.prototype.isBufferGeometry = true;\n\nconst _inverseMatrix$2 = /*@__PURE__*/ new Matrix4();\nconst _ray$2 = /*@__PURE__*/ new Ray();\nconst _sphere$3 = /*@__PURE__*/ new Sphere();\n\nconst _vA$1 = /*@__PURE__*/ new Vector3();\nconst _vB$1 = /*@__PURE__*/ new Vector3();\nconst _vC$1 = /*@__PURE__*/ new Vector3();\n\nconst _tempA = /*@__PURE__*/ new Vector3();\nconst _tempB = /*@__PURE__*/ new Vector3();\nconst _tempC = /*@__PURE__*/ new Vector3();\n\nconst _morphA = /*@__PURE__*/ new Vector3();\nconst _morphB = /*@__PURE__*/ new Vector3();\nconst _morphC = /*@__PURE__*/ new Vector3();\n\nconst _uvA$1 = /*@__PURE__*/ new Vector2();\nconst _uvB$1 = /*@__PURE__*/ new Vector2();\nconst _uvC$1 = /*@__PURE__*/ new Vector2();\n\nconst _intersectionPoint = /*@__PURE__*/ new Vector3();\nconst _intersectionPointWorld = /*@__PURE__*/ new Vector3();\n\nclass Mesh extends Object3D {\n\n\tconstructor( geometry = new BufferGeometry(), material = new MeshBasicMaterial() ) {\n\n\t\tsuper();\n\n\t\tthis.type = 'Mesh';\n\n\t\tthis.geometry = geometry;\n\t\tthis.material = material;\n\n\t\tthis.updateMorphTargets();\n\n\t}\n\n\tcopy( source ) {\n\n\t\tsuper.copy( source );\n\n\t\tif ( source.morphTargetInfluences !== undefined ) {\n\n\t\t\tthis.morphTargetInfluences = source.morphTargetInfluences.slice();\n\n\t\t}\n\n\t\tif ( source.morphTargetDictionary !== undefined ) {\n\n\t\t\tthis.morphTargetDictionary = Object.assign( {}, source.morphTargetDictionary );\n\n\t\t}\n\n\t\tthis.material = source.material;\n\t\tthis.geometry = source.geometry;\n\n\t\treturn this;\n\n\t}\n\n\tupdateMorphTargets() {\n\n\t\tconst geometry = this.geometry;\n\n\t\tif ( geometry.isBufferGeometry ) {\n\n\t\t\tconst morphAttributes = geometry.morphAttributes;\n\t\t\tconst keys = Object.keys( morphAttributes );\n\n\t\t\tif ( keys.length > 0 ) {\n\n\t\t\t\tconst morphAttribute = morphAttributes[ keys[ 0 ] ];\n\n\t\t\t\tif ( morphAttribute !== undefined ) {\n\n\t\t\t\t\tthis.morphTargetInfluences = [];\n\t\t\t\t\tthis.morphTargetDictionary = {};\n\n\t\t\t\t\tfor ( let m = 0, ml = morphAttribute.length; m < ml; m ++ ) {\n\n\t\t\t\t\t\tconst name = morphAttribute[ m ].name || String( m );\n\n\t\t\t\t\t\tthis.morphTargetInfluences.push( 0 );\n\t\t\t\t\t\tthis.morphTargetDictionary[ name ] = m;\n\n\t\t\t\t\t}\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tconst morphTargets = geometry.morphTargets;\n\n\t\t\tif ( morphTargets !== undefined && morphTargets.length > 0 ) {\n\n\t\t\t\tconsole.error( 'THREE.Mesh.updateMorphTargets() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.' );\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\traycast( raycaster, intersects ) {\n\n\t\tconst geometry = this.geometry;\n\t\tconst material = this.material;\n\t\tconst matrixWorld = this.matrixWorld;\n\n\t\tif ( material === undefined ) return;\n\n\t\t// Checking boundingSphere distance to ray\n\n\t\tif ( geometry.boundingSphere === null ) geometry.computeBoundingSphere();\n\n\t\t_sphere$3.copy( geometry.boundingSphere );\n\t\t_sphere$3.applyMatrix4( matrixWorld );\n\n\t\tif ( raycaster.ray.intersectsSphere( _sphere$3 ) === false ) return;\n\n\t\t//\n\n\t\t_inverseMatrix$2.copy( matrixWorld ).invert();\n\t\t_ray$2.copy( raycaster.ray ).applyMatrix4( _inverseMatrix$2 );\n\n\t\t// Check boundingBox before continuing\n\n\t\tif ( geometry.boundingBox !== null ) {\n\n\t\t\tif ( _ray$2.intersectsBox( geometry.boundingBox ) === false ) return;\n\n\t\t}\n\n\t\tlet intersection;\n\n\t\tif ( geometry.isBufferGeometry ) {\n\n\t\t\tconst index = geometry.index;\n\t\t\tconst position = geometry.attributes.position;\n\t\t\tconst morphPosition = geometry.morphAttributes.position;\n\t\t\tconst morphTargetsRelative = geometry.morphTargetsRelative;\n\t\t\tconst uv = geometry.attributes.uv;\n\t\t\tconst uv2 = geometry.attributes.uv2;\n\t\t\tconst groups = geometry.groups;\n\t\t\tconst drawRange = geometry.drawRange;\n\n\t\t\tif ( index !== null ) {\n\n\t\t\t\t// indexed buffer geometry\n\n\t\t\t\tif ( Array.isArray( material ) ) {\n\n\t\t\t\t\tfor ( let i = 0, il = groups.length; i < il; i ++ ) {\n\n\t\t\t\t\t\tconst group = groups[ i ];\n\t\t\t\t\t\tconst groupMaterial = material[ group.materialIndex ];\n\n\t\t\t\t\t\tconst start = Math.max( group.start, drawRange.start );\n\t\t\t\t\t\tconst end = Math.min( ( group.start + group.count ), ( drawRange.start + drawRange.count ) );\n\n\t\t\t\t\t\tfor ( let j = start, jl = end; j < jl; j += 3 ) {\n\n\t\t\t\t\t\t\tconst a = index.getX( j );\n\t\t\t\t\t\t\tconst b = index.getX( j + 1 );\n\t\t\t\t\t\t\tconst c = index.getX( j + 2 );\n\n\t\t\t\t\t\t\tintersection = checkBufferGeometryIntersection( this, groupMaterial, raycaster, _ray$2, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c );\n\n\t\t\t\t\t\t\tif ( intersection ) {\n\n\t\t\t\t\t\t\t\tintersection.faceIndex = Math.floor( j / 3 ); // triangle number in indexed buffer semantics\n\t\t\t\t\t\t\t\tintersection.face.materialIndex = group.materialIndex;\n\t\t\t\t\t\t\t\tintersects.push( intersection );\n\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t}\n\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\n\t\t\t\t\tconst start = Math.max( 0, drawRange.start );\n\t\t\t\t\tconst end = Math.min( index.count, ( drawRange.start + drawRange.count ) );\n\n\t\t\t\t\tfor ( let i = start, il = end; i < il; i += 3 ) {\n\n\t\t\t\t\t\tconst a = index.getX( i );\n\t\t\t\t\t\tconst b = index.getX( i + 1 );\n\t\t\t\t\t\tconst c = index.getX( i + 2 );\n\n\t\t\t\t\t\tintersection = checkBufferGeometryIntersection( this, material, raycaster, _ray$2, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c );\n\n\t\t\t\t\t\tif ( intersection ) {\n\n\t\t\t\t\t\t\tintersection.faceIndex = Math.floor( i / 3 ); // triangle number in indexed buffer semantics\n\t\t\t\t\t\t\tintersects.push( intersection );\n\n\t\t\t\t\t\t}\n\n\t\t\t\t\t}\n\n\t\t\t\t}\n\n\t\t\t} else if ( position !== undefined ) {\n\n\t\t\t\t// non-indexed buffer geometry\n\n\t\t\t\tif ( Array.isArray( material ) ) {\n\n\t\t\t\t\tfor ( let i = 0, il = groups.length; i < il; i ++ ) {\n\n\t\t\t\t\t\tconst group = groups[ i ];\n\t\t\t\t\t\tconst groupMaterial = material[ group.materialIndex ];\n\n\t\t\t\t\t\tconst start = Math.max( group.start, drawRange.start );\n\t\t\t\t\t\tconst end = Math.min( ( group.start + group.count ), ( drawRange.start + drawRange.count ) );\n\n\t\t\t\t\t\tfor ( let j = start, jl = end; j < jl; j += 3 ) {\n\n\t\t\t\t\t\t\tconst a = j;\n\t\t\t\t\t\t\tconst b = j + 1;\n\t\t\t\t\t\t\tconst c = j + 2;\n\n\t\t\t\t\t\t\tintersection = checkBufferGeometryIntersection( this, groupMaterial, raycaster, _ray$2, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c );\n\n\t\t\t\t\t\t\tif ( intersection ) {\n\n\t\t\t\t\t\t\t\tintersection.faceIndex = Math.floor( j / 3 ); // triangle number in non-indexed buffer semantics\n\t\t\t\t\t\t\t\tintersection.face.materialIndex = group.materialIndex;\n\t\t\t\t\t\t\t\tintersects.push( intersection );\n\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t}\n\n\t\t\t\t\t}\n\n\t\t\t\t} else {\n\n\t\t\t\t\tconst start = Math.max( 0, drawRange.start );\n\t\t\t\t\tconst end = Math.min( position.count, ( drawRange.start + drawRange.count ) );\n\n\t\t\t\t\tfor ( let i = start, il = end; i < il; i += 3 ) {\n\n\t\t\t\t\t\tconst a = i;\n\t\t\t\t\t\tconst b = i + 1;\n\t\t\t\t\t\tconst c = i + 2;\n\n\t\t\t\t\t\tintersection = checkBufferGeometryIntersection( this, material, raycaster, _ray$2, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c );\n\n\t\t\t\t\t\tif ( intersection ) {\n\n\t\t\t\t\t\t\tintersection.faceIndex = Math.floor( i / 3 ); // triangle number in non-indexed buffer semantics\n\t\t\t\t\t\t\tintersects.push( intersection );\n\n\t\t\t\t\t\t}\n\n\t\t\t\t\t}\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t} else if ( geometry.isGeometry ) {\n\n\t\t\tconsole.error( 'THREE.Mesh.raycast() no longer supports THREE.Geometry. Use THREE.BufferGeometry instead.' );\n\n\t\t}\n\n\t}\n\n}\n\nMesh.prototype.isMesh = true;\n\nfunction checkIntersection( object, material, raycaster, ray, pA, pB, pC, point ) {\n\n\tlet intersect;\n\n\tif ( material.side === BackSide ) {\n\n\t\tintersect = ray.intersectTriangle( pC, pB, pA, true, point );\n\n\t} else {\n\n\t\tintersect = ray.intersectTriangle( pA, pB, pC, material.side !== DoubleSide, point );\n\n\t}\n\n\tif ( intersect === null ) return null;\n\n\t_intersectionPointWorld.copy( point );\n\t_intersectionPointWorld.applyMatrix4( object.matrixWorld );\n\n\tconst distance = raycaster.ray.origin.distanceTo( _intersectionPointWorld );\n\n\tif ( distance < raycaster.near || distance > raycaster.far ) return null;\n\n\treturn {\n\t\tdistance: distance,\n\t\tpoint: _intersectionPointWorld.clone(),\n\t\tobject: object\n\t};\n\n}\n\nfunction checkBufferGeometryIntersection( object, material, raycaster, ray, position, morphPosition, morphTargetsRelative, uv, uv2, a, b, c ) {\n\n\t_vA$1.fromBufferAttribute( position, a );\n\t_vB$1.fromBufferAttribute( position, b );\n\t_vC$1.fromBufferAttribute( position, c );\n\n\tconst morphInfluences = object.morphTargetInfluences;\n\n\tif ( material.morphTargets && morphPosition && morphInfluences ) {\n\n\t\t_morphA.set( 0, 0, 0 );\n\t\t_morphB.set( 0, 0, 0 );\n\t\t_morphC.set( 0, 0, 0 );\n\n\t\tfor ( let i = 0, il = morphPosition.length; i < il; i ++ ) {\n\n\t\t\tconst influence = morphInfluences[ i ];\n\t\t\tconst morphAttribute = morphPosition[ i ];\n\n\t\t\tif ( influence === 0 ) continue;\n\n\t\t\t_tempA.fromBufferAttribute( morphAttribute, a );\n\t\t\t_tempB.fromBufferAttribute( morphAttribute, b );\n\t\t\t_tempC.fromBufferAttribute( morphAttribute, c );\n\n\t\t\tif ( morphTargetsRelative ) {\n\n\t\t\t\t_morphA.addScaledVector( _tempA, influence );\n\t\t\t\t_morphB.addScaledVector( _tempB, influence );\n\t\t\t\t_morphC.addScaledVector( _tempC, influence );\n\n\t\t\t} else {\n\n\t\t\t\t_morphA.addScaledVector( _tempA.sub( _vA$1 ), influence );\n\t\t\t\t_morphB.addScaledVector( _tempB.sub( _vB$1 ), influence );\n\t\t\t\t_morphC.addScaledVector( _tempC.sub( _vC$1 ), influence );\n\n\t\t\t}\n\n\t\t}\n\n\t\t_vA$1.add( _morphA );\n\t\t_vB$1.add( _morphB );\n\t\t_vC$1.add( _morphC );\n\n\t}\n\n\tif ( object.isSkinnedMesh ) {\n\n\t\tobject.boneTransform( a, _vA$1 );\n\t\tobject.boneTransform( b, _vB$1 );\n\t\tobject.boneTransform( c, _vC$1 );\n\n\t}\n\n\tconst intersection = checkIntersection( object, material, raycaster, ray, _vA$1, _vB$1, _vC$1, _intersectionPoint );\n\n\tif ( intersection ) {\n\n\t\tif ( uv ) {\n\n\t\t\t_uvA$1.fromBufferAttribute( uv, a );\n\t\t\t_uvB$1.fromBufferAttribute( uv, b );\n\t\t\t_uvC$1.fromBufferAttribute( uv, c );\n\n\t\t\tintersection.uv = Triangle.getUV( _intersectionPoint, _vA$1, _vB$1, _vC$1, _uvA$1, _uvB$1, _uvC$1, new Vector2() );\n\n\t\t}\n\n\t\tif ( uv2 ) {\n\n\t\t\t_uvA$1.fromBufferAttribute( uv2, a );\n\t\t\t_uvB$1.fromBufferAttribute( uv2, b );\n\t\t\t_uvC$1.fromBufferAttribute( uv2, c );\n\n\t\t\tintersection.uv2 = Triangle.getUV( _intersectionPoint, _vA$1, _vB$1, _vC$1, _uvA$1, _uvB$1, _uvC$1, new Vector2() );\n\n\t\t}\n\n\t\tconst face = {\n\t\t\ta: a,\n\t\t\tb: b,\n\t\t\tc: c,\n\t\t\tnormal: new Vector3(),\n\t\t\tmaterialIndex: 0\n\t\t};\n\n\t\tTriangle.getNormal( _vA$1, _vB$1, _vC$1, face.normal );\n\n\t\tintersection.face = face;\n\n\t}\n\n\treturn intersection;\n\n}\n\nclass BoxGeometry extends BufferGeometry {\n\n\tconstructor( width = 1, height = 1, depth = 1, widthSegments = 1, heightSegments = 1, depthSegments = 1 ) {\n\n\t\tsuper();\n\n\t\tthis.type = 'BoxGeometry';\n\n\t\tthis.parameters = {\n\t\t\twidth: width,\n\t\t\theight: height,\n\t\t\tdepth: depth,\n\t\t\twidthSegments: widthSegments,\n\t\t\theightSegments: heightSegments,\n\t\t\tdepthSegments: depthSegments\n\t\t};\n\n\t\tconst scope = this;\n\n\t\t// segments\n\n\t\twidthSegments = Math.floor( widthSegments );\n\t\theightSegments = Math.floor( heightSegments );\n\t\tdepthSegments = Math.floor( depthSegments );\n\n\t\t// buffers\n\n\t\tconst indices = [];\n\t\tconst vertices = [];\n\t\tconst normals = [];\n\t\tconst uvs = [];\n\n\t\t// helper variables\n\n\t\tlet numberOfVertices = 0;\n\t\tlet groupStart = 0;\n\n\t\t// build each side of the box geometry\n\n\t\tbuildPlane( 'z', 'y', 'x', - 1, - 1, depth, height, width, depthSegments, heightSegments, 0 ); // px\n\t\tbuildPlane( 'z', 'y', 'x', 1, - 1, depth, height, - width, depthSegments, heightSegments, 1 ); // nx\n\t\tbuildPlane( 'x', 'z', 'y', 1, 1, width, depth, height, widthSegments, depthSegments, 2 ); // py\n\t\tbuildPlane( 'x', 'z', 'y', 1, - 1, width, depth, - height, widthSegments, depthSegments, 3 ); // ny\n\t\tbuildPlane( 'x', 'y', 'z', 1, - 1, width, height, depth, widthSegments, heightSegments, 4 ); // pz\n\t\tbuildPlane( 'x', 'y', 'z', - 1, - 1, width, height, - depth, widthSegments, heightSegments, 5 ); // nz\n\n\t\t// build geometry\n\n\t\tthis.setIndex( indices );\n\t\tthis.setAttribute( 'position', new Float32BufferAttribute( vertices, 3 ) );\n\t\tthis.setAttribute( 'normal', new Float32BufferAttribute( normals, 3 ) );\n\t\tthis.setAttribute( 'uv', new Float32BufferAttribute( uvs, 2 ) );\n\n\t\tfunction buildPlane( u, v, w, udir, vdir, width, height, depth, gridX, gridY, materialIndex ) {\n\n\t\t\tconst segmentWidth = width / gridX;\n\t\t\tconst segmentHeight = height / gridY;\n\n\t\t\tconst widthHalf = width / 2;\n\t\t\tconst heightHalf = height / 2;\n\t\t\tconst depthHalf = depth / 2;\n\n\t\t\tconst gridX1 = gridX + 1;\n\t\t\tconst gridY1 = gridY + 1;\n\n\t\t\tlet vertexCounter = 0;\n\t\t\tlet groupCount = 0;\n\n\t\t\tconst vector = new Vector3();\n\n\t\t\t// generate vertices, normals and uvs\n\n\t\t\tfor ( let iy = 0; iy < gridY1; iy ++ ) {\n\n\t\t\t\tconst y = iy * segmentHeight - heightHalf;\n\n\t\t\t\tfor ( let ix = 0; ix < gridX1; ix ++ ) {\n\n\t\t\t\t\tconst x = ix * segmentWidth - widthHalf;\n\n\t\t\t\t\t// set values to correct vector component\n\n\t\t\t\t\tvector[ u ] = x * udir;\n\t\t\t\t\tvector[ v ] = y * vdir;\n\t\t\t\t\tvector[ w ] = depthHalf;\n\n\t\t\t\t\t// now apply vector to vertex buffer\n\n\t\t\t\t\tvertices.push( vector.x, vector.y, vector.z );\n\n\t\t\t\t\t// set values to correct vector component\n\n\t\t\t\t\tvector[ u ] = 0;\n\t\t\t\t\tvector[ v ] = 0;\n\t\t\t\t\tvector[ w ] = depth > 0 ? 1 : - 1;\n\n\t\t\t\t\t// now apply vector to normal buffer\n\n\t\t\t\t\tnormals.push( vector.x, vector.y, vector.z );\n\n\t\t\t\t\t// uvs\n\n\t\t\t\t\tuvs.push( ix / gridX );\n\t\t\t\t\tuvs.push( 1 - ( iy / gridY ) );\n\n\t\t\t\t\t// counters\n\n\t\t\t\t\tvertexCounter += 1;\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\t// indices\n\n\t\t\t// 1. you need three indices to draw a single face\n\t\t\t// 2. a single segment consists of two faces\n\t\t\t// 3. so we need to generate six (2*3) indices per segment\n\n\t\t\tfor ( let iy = 0; iy < gridY; iy ++ ) {\n\n\t\t\t\tfor ( let ix = 0; ix < gridX; ix ++ ) {\n\n\t\t\t\t\tconst a = numberOfVertices + ix + gridX1 * iy;\n\t\t\t\t\tconst b = numberOfVertices + ix + gridX1 * ( iy + 1 );\n\t\t\t\t\tconst c = numberOfVertices + ( ix + 1 ) + gridX1 * ( iy + 1 );\n\t\t\t\t\tconst d = numberOfVertices + ( ix + 1 ) + gridX1 * iy;\n\n\t\t\t\t\t// faces\n\n\t\t\t\t\tindices.push( a, b, d );\n\t\t\t\t\tindices.push( b, c, d );\n\n\t\t\t\t\t// increase counter\n\n\t\t\t\t\tgroupCount += 6;\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\t// add a group to the geometry. this will ensure multi material support\n\n\t\t\tscope.addGroup( groupStart, groupCount, materialIndex );\n\n\t\t\t// calculate new start value for groups\n\n\t\t\tgroupStart += groupCount;\n\n\t\t\t// update total number of vertices\n\n\t\t\tnumberOfVertices += vertexCounter;\n\n\t\t}\n\n\t}\n\n}\n\n/**\n * Uniform Utilities\n */\n\nfunction cloneUniforms( src ) {\n\n\tconst dst = {};\n\n\tfor ( const u in src ) {\n\n\t\tdst[ u ] = {};\n\n\t\tfor ( const p in src[ u ] ) {\n\n\t\t\tconst property = src[ u ][ p ];\n\n\t\t\tif ( property && ( property.isColor ||\n\t\t\t\tproperty.isMatrix3 || property.isMatrix4 ||\n\t\t\t\tproperty.isVector2 || property.isVector3 || property.isVector4 ||\n\t\t\t\tproperty.isTexture || property.isQuaternion ) ) {\n\n\t\t\t\tdst[ u ][ p ] = property.clone();\n\n\t\t\t} else if ( Array.isArray( property ) ) {\n\n\t\t\t\tdst[ u ][ p ] = property.slice();\n\n\t\t\t} else {\n\n\t\t\t\tdst[ u ][ p ] = property;\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\treturn dst;\n\n}\n\nfunction mergeUniforms( uniforms ) {\n\n\tconst merged = {};\n\n\tfor ( let u = 0; u < uniforms.length; u ++ ) {\n\n\t\tconst tmp = cloneUniforms( uniforms[ u ] );\n\n\t\tfor ( const p in tmp ) {\n\n\t\t\tmerged[ p ] = tmp[ p ];\n\n\t\t}\n\n\t}\n\n\treturn merged;\n\n}\n\n// Legacy\n\nconst UniformsUtils = { clone: cloneUniforms, merge: mergeUniforms };\n\nvar default_vertex = \"void main() {\\n\\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\\n}\";\n\nvar default_fragment = \"void main() {\\n\\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\\n}\";\n\n/**\n * parameters = {\n *  defines: { \"label\" : \"value\" },\n *  uniforms: { \"parameter1\": { value: 1.0 }, \"parameter2\": { value2: 2 } },\n *\n *  fragmentShader: <string>,\n *  vertexShader: <string>,\n *\n *  wireframe: <boolean>,\n *  wireframeLinewidth: <float>,\n *\n *  lights: <bool>,\n *\n *  morphTargets: <bool>,\n *  morphNormals: <bool>\n * }\n */\n\nclass ShaderMaterial extends Material {\n\n\tconstructor( parameters ) {\n\n\t\tsuper();\n\n\t\tthis.type = 'ShaderMaterial';\n\n\t\tthis.defines = {};\n\t\tthis.uniforms = {};\n\n\t\tthis.vertexShader = default_vertex;\n\t\tthis.fragmentShader = default_fragment;\n\n\t\tthis.linewidth = 1;\n\n\t\tthis.wireframe = false;\n\t\tthis.wireframeLinewidth = 1;\n\n\t\tthis.fog = false; // set to use scene fog\n\t\tthis.lights = false; // set to use scene lights\n\t\tthis.clipping = false; // set to use user-defined clipping planes\n\n\t\tthis.morphTargets = false; // set to use morph targets\n\t\tthis.morphNormals = false; // set to use morph normals\n\n\t\tthis.extensions = {\n\t\t\tderivatives: false, // set to use derivatives\n\t\t\tfragDepth: false, // set to use fragment depth values\n\t\t\tdrawBuffers: false, // set to use draw buffers\n\t\t\tshaderTextureLOD: false // set to use shader texture LOD\n\t\t};\n\n\t\t// When rendered geometry doesn't include these attributes but the material does,\n\t\t// use these default values in WebGL. This avoids errors when buffer data is missing.\n\t\tthis.defaultAttributeValues = {\n\t\t\t'color': [ 1, 1, 1 ],\n\t\t\t'uv': [ 0, 0 ],\n\t\t\t'uv2': [ 0, 0 ]\n\t\t};\n\n\t\tthis.index0AttributeName = undefined;\n\t\tthis.uniformsNeedUpdate = false;\n\n\t\tthis.glslVersion = null;\n\n\t\tif ( parameters !== undefined ) {\n\n\t\t\tif ( parameters.attributes !== undefined ) {\n\n\t\t\t\tconsole.error( 'THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead.' );\n\n\t\t\t}\n\n\t\t\tthis.setValues( parameters );\n\n\t\t}\n\n\t}\n\n\tcopy( source ) {\n\n\t\tsuper.copy( source );\n\n\t\tthis.fragmentShader = source.fragmentShader;\n\t\tthis.vertexShader = source.vertexShader;\n\n\t\tthis.uniforms = cloneUniforms( source.uniforms );\n\n\t\tthis.defines = Object.assign( {}, source.defines );\n\n\t\tthis.wireframe = source.wireframe;\n\t\tthis.wireframeLinewidth = source.wireframeLinewidth;\n\n\t\tthis.lights = source.lights;\n\t\tthis.clipping = source.clipping;\n\n\t\tthis.morphTargets = source.morphTargets;\n\t\tthis.morphNormals = source.morphNormals;\n\n\t\tthis.extensions = Object.assign( {}, source.extensions );\n\n\t\tthis.glslVersion = source.glslVersion;\n\n\t\treturn this;\n\n\t}\n\n\ttoJSON( meta ) {\n\n\t\tconst data = super.toJSON( meta );\n\n\t\tdata.glslVersion = this.glslVersion;\n\t\tdata.uniforms = {};\n\n\t\tfor ( const name in this.uniforms ) {\n\n\t\t\tconst uniform = this.uniforms[ name ];\n\t\t\tconst value = uniform.value;\n\n\t\t\tif ( value && value.isTexture ) {\n\n\t\t\t\tdata.uniforms[ name ] = {\n\t\t\t\t\ttype: 't',\n\t\t\t\t\tvalue: value.toJSON( meta ).uuid\n\t\t\t\t};\n\n\t\t\t} else if ( value && value.isColor ) {\n\n\t\t\t\tdata.uniforms[ name ] = {\n\t\t\t\t\ttype: 'c',\n\t\t\t\t\tvalue: value.getHex()\n\t\t\t\t};\n\n\t\t\t} else if ( value && value.isVector2 ) {\n\n\t\t\t\tdata.uniforms[ name ] = {\n\t\t\t\t\ttype: 'v2',\n\t\t\t\t\tvalue: value.toArray()\n\t\t\t\t};\n\n\t\t\t} else if ( value && value.isVector3 ) {\n\n\t\t\t\tdata.uniforms[ name ] = {\n\t\t\t\t\ttype: 'v3',\n\t\t\t\t\tvalue: value.toArray()\n\t\t\t\t};\n\n\t\t\t} else if ( value && value.isVector4 ) {\n\n\t\t\t\tdata.uniforms[ name ] = {\n\t\t\t\t\ttype: 'v4',\n\t\t\t\t\tvalue: value.toArray()\n\t\t\t\t};\n\n\t\t\t} else if ( value && value.isMatrix3 ) {\n\n\t\t\t\tdata.uniforms[ name ] = {\n\t\t\t\t\ttype: 'm3',\n\t\t\t\t\tvalue: value.toArray()\n\t\t\t\t};\n\n\t\t\t} else if ( value && value.isMatrix4 ) {\n\n\t\t\t\tdata.uniforms[ name ] = {\n\t\t\t\t\ttype: 'm4',\n\t\t\t\t\tvalue: value.toArray()\n\t\t\t\t};\n\n\t\t\t} else {\n\n\t\t\t\tdata.uniforms[ name ] = {\n\t\t\t\t\tvalue: value\n\t\t\t\t};\n\n\t\t\t\t// note: the array variants v2v, v3v, v4v, m4v and tv are not supported so far\n\n\t\t\t}\n\n\t\t}\n\n\t\tif ( Object.keys( this.defines ).length > 0 ) data.defines = this.defines;\n\n\t\tdata.vertexShader = this.vertexShader;\n\t\tdata.fragmentShader = this.fragmentShader;\n\n\t\tconst extensions = {};\n\n\t\tfor ( const key in this.extensions ) {\n\n\t\t\tif ( this.extensions[ key ] === true ) extensions[ key ] = true;\n\n\t\t}\n\n\t\tif ( Object.keys( extensions ).length > 0 ) data.extensions = extensions;\n\n\t\treturn data;\n\n\t}\n\n}\n\nShaderMaterial.prototype.isShaderMaterial = true;\n\nclass Camera extends Object3D {\n\n\tconstructor() {\n\n\t\tsuper();\n\n\t\tthis.type = 'Camera';\n\n\t\tthis.matrixWorldInverse = new Matrix4();\n\n\t\tthis.projectionMatrix = new Matrix4();\n\t\tthis.projectionMatrixInverse = new Matrix4();\n\n\t}\n\n\tcopy( source, recursive ) {\n\n\t\tsuper.copy( source, recursive );\n\n\t\tthis.matrixWorldInverse.copy( source.matrixWorldInverse );\n\n\t\tthis.projectionMatrix.copy( source.projectionMatrix );\n\t\tthis.projectionMatrixInverse.copy( source.projectionMatrixInverse );\n\n\t\treturn this;\n\n\t}\n\n\tgetWorldDirection( target ) {\n\n\t\tif ( target === undefined ) {\n\n\t\t\tconsole.warn( 'THREE.Camera: .getWorldDirection() target is now required' );\n\t\t\ttarget = new Vector3();\n\n\t\t}\n\n\t\tthis.updateWorldMatrix( true, false );\n\n\t\tconst e = this.matrixWorld.elements;\n\n\t\treturn target.set( - e[ 8 ], - e[ 9 ], - e[ 10 ] ).normalize();\n\n\t}\n\n\tupdateMatrixWorld( force ) {\n\n\t\tsuper.updateMatrixWorld( force );\n\n\t\tthis.matrixWorldInverse.copy( this.matrixWorld ).invert();\n\n\t}\n\n\tupdateWorldMatrix( updateParents, updateChildren ) {\n\n\t\tsuper.updateWorldMatrix( updateParents, updateChildren );\n\n\t\tthis.matrixWorldInverse.copy( this.matrixWorld ).invert();\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n}\n\nCamera.prototype.isCamera = true;\n\nclass PerspectiveCamera extends Camera {\n\n\tconstructor( fov = 50, aspect = 1, near = 0.1, far = 2000 ) {\n\n\t\tsuper();\n\n\t\tthis.type = 'PerspectiveCamera';\n\n\t\tthis.fov = fov;\n\t\tthis.zoom = 1;\n\n\t\tthis.near = near;\n\t\tthis.far = far;\n\t\tthis.focus = 10;\n\n\t\tthis.aspect = aspect;\n\t\tthis.view = null;\n\n\t\tthis.filmGauge = 35;\t// width of the film (default in millimeters)\n\t\tthis.filmOffset = 0;\t// horizontal film offset (same unit as gauge)\n\n\t\tthis.updateProjectionMatrix();\n\n\t}\n\n\tcopy( source, recursive ) {\n\n\t\tsuper.copy( source, recursive );\n\n\t\tthis.fov = source.fov;\n\t\tthis.zoom = source.zoom;\n\n\t\tthis.near = source.near;\n\t\tthis.far = source.far;\n\t\tthis.focus = source.focus;\n\n\t\tthis.aspect = source.aspect;\n\t\tthis.view = source.view === null ? null : Object.assign( {}, source.view );\n\n\t\tthis.filmGauge = source.filmGauge;\n\t\tthis.filmOffset = source.filmOffset;\n\n\t\treturn this;\n\n\t}\n\n\t/**\n\t * Sets the FOV by focal length in respect to the current .filmGauge.\n\t *\n\t * The default film gauge is 35, so that the focal length can be specified for\n\t * a 35mm (full frame) camera.\n\t *\n\t * Values for focal length and film gauge must have the same unit.\n\t */\n\tsetFocalLength( focalLength ) {\n\n\t\t/** see {@link http://www.bobatkins.com/photography/technical/field_of_view.html} */\n\t\tconst vExtentSlope = 0.5 * this.getFilmHeight() / focalLength;\n\n\t\tthis.fov = RAD2DEG * 2 * Math.atan( vExtentSlope );\n\t\tthis.updateProjectionMatrix();\n\n\t}\n\n\t/**\n\t * Calculates the focal length from the current .fov and .filmGauge.\n\t */\n\tgetFocalLength() {\n\n\t\tconst vExtentSlope = Math.tan( DEG2RAD * 0.5 * this.fov );\n\n\t\treturn 0.5 * this.getFilmHeight() / vExtentSlope;\n\n\t}\n\n\tgetEffectiveFOV() {\n\n\t\treturn RAD2DEG * 2 * Math.atan(\n\t\t\tMath.tan( DEG2RAD * 0.5 * this.fov ) / this.zoom );\n\n\t}\n\n\tgetFilmWidth() {\n\n\t\t// film not completely covered in portrait format (aspect < 1)\n\t\treturn this.filmGauge * Math.min( this.aspect, 1 );\n\n\t}\n\n\tgetFilmHeight() {\n\n\t\t// film not completely covered in landscape format (aspect > 1)\n\t\treturn this.filmGauge / Math.max( this.aspect, 1 );\n\n\t}\n\n\t/**\n\t * Sets an offset in a larger frustum. This is useful for multi-window or\n\t * multi-monitor/multi-machine setups.\n\t *\n\t * For example, if you have 3x2 monitors and each monitor is 1920x1080 and\n\t * the monitors are in grid like this\n\t *\n\t *   +---+---+---+\n\t *   | A | B | C |\n\t *   +---+---+---+\n\t *   | D | E | F |\n\t *   +---+---+---+\n\t *\n\t * then for each monitor you would call it like this\n\t *\n\t *   const w = 1920;\n\t *   const h = 1080;\n\t *   const fullWidth = w * 3;\n\t *   const fullHeight = h * 2;\n\t *\n\t *   --A--\n\t *   camera.setViewOffset( fullWidth, fullHeight, w * 0, h * 0, w, h );\n\t *   --B--\n\t *   camera.setViewOffset( fullWidth, fullHeight, w * 1, h * 0, w, h );\n\t *   --C--\n\t *   camera.setViewOffset( fullWidth, fullHeight, w * 2, h * 0, w, h );\n\t *   --D--\n\t *   camera.setViewOffset( fullWidth, fullHeight, w * 0, h * 1, w, h );\n\t *   --E--\n\t *   camera.setViewOffset( fullWidth, fullHeight, w * 1, h * 1, w, h );\n\t *   --F--\n\t *   camera.setViewOffset( fullWidth, fullHeight, w * 2, h * 1, w, h );\n\t *\n\t *   Note there is no reason monitors have to be the same size or in a grid.\n\t */\n\tsetViewOffset( fullWidth, fullHeight, x, y, width, height ) {\n\n\t\tthis.aspect = fullWidth / fullHeight;\n\n\t\tif ( this.view === null ) {\n\n\t\t\tthis.view = {\n\t\t\t\tenabled: true,\n\t\t\t\tfullWidth: 1,\n\t\t\t\tfullHeight: 1,\n\t\t\t\toffsetX: 0,\n\t\t\t\toffsetY: 0,\n\t\t\t\twidth: 1,\n\t\t\t\theight: 1\n\t\t\t};\n\n\t\t}\n\n\t\tthis.view.enabled = true;\n\t\tthis.view.fullWidth = fullWidth;\n\t\tthis.view.fullHeight = fullHeight;\n\t\tthis.view.offsetX = x;\n\t\tthis.view.offsetY = y;\n\t\tthis.view.width = width;\n\t\tthis.view.height = height;\n\n\t\tthis.updateProjectionMatrix();\n\n\t}\n\n\tclearViewOffset() {\n\n\t\tif ( this.view !== null ) {\n\n\t\t\tthis.view.enabled = false;\n\n\t\t}\n\n\t\tthis.updateProjectionMatrix();\n\n\t}\n\n\tupdateProjectionMatrix() {\n\n\t\tconst near = this.near;\n\t\tlet top = near * Math.tan( DEG2RAD * 0.5 * this.fov ) / this.zoom;\n\t\tlet height = 2 * top;\n\t\tlet width = this.aspect * height;\n\t\tlet left = - 0.5 * width;\n\t\tconst view = this.view;\n\n\t\tif ( this.view !== null && this.view.enabled ) {\n\n\t\t\tconst fullWidth = view.fullWidth,\n\t\t\t\tfullHeight = view.fullHeight;\n\n\t\t\tleft += view.offsetX * width / fullWidth;\n\t\t\ttop -= view.offsetY * height / fullHeight;\n\t\t\twidth *= view.width / fullWidth;\n\t\t\theight *= view.height / fullHeight;\n\n\t\t}\n\n\t\tconst skew = this.filmOffset;\n\t\tif ( skew !== 0 ) left += near * skew / this.getFilmWidth();\n\n\t\tthis.projectionMatrix.makePerspective( left, left + width, top, top - height, near, this.far );\n\n\t\tthis.projectionMatrixInverse.copy( this.projectionMatrix ).invert();\n\n\t}\n\n\ttoJSON( meta ) {\n\n\t\tconst data = super.toJSON( meta );\n\n\t\tdata.object.fov = this.fov;\n\t\tdata.object.zoom = this.zoom;\n\n\t\tdata.object.near = this.near;\n\t\tdata.object.far = this.far;\n\t\tdata.object.focus = this.focus;\n\n\t\tdata.object.aspect = this.aspect;\n\n\t\tif ( this.view !== null ) data.object.view = Object.assign( {}, this.view );\n\n\t\tdata.object.filmGauge = this.filmGauge;\n\t\tdata.object.filmOffset = this.filmOffset;\n\n\t\treturn data;\n\n\t}\n\n}\n\nPerspectiveCamera.prototype.isPerspectiveCamera = true;\n\nconst fov = 90, aspect = 1;\n\nclass CubeCamera extends Object3D {\n\n\tconstructor( near, far, renderTarget ) {\n\n\t\tsuper();\n\n\t\tthis.type = 'CubeCamera';\n\n\t\tif ( renderTarget.isWebGLCubeRenderTarget !== true ) {\n\n\t\t\tconsole.error( 'THREE.CubeCamera: The constructor now expects an instance of WebGLCubeRenderTarget as third parameter.' );\n\t\t\treturn;\n\n\t\t}\n\n\t\tthis.renderTarget = renderTarget;\n\n\t\tconst cameraPX = new PerspectiveCamera( fov, aspect, near, far );\n\t\tcameraPX.layers = this.layers;\n\t\tcameraPX.up.set( 0, - 1, 0 );\n\t\tcameraPX.lookAt( new Vector3( 1, 0, 0 ) );\n\t\tthis.add( cameraPX );\n\n\t\tconst cameraNX = new PerspectiveCamera( fov, aspect, near, far );\n\t\tcameraNX.layers = this.layers;\n\t\tcameraNX.up.set( 0, - 1, 0 );\n\t\tcameraNX.lookAt( new Vector3( - 1, 0, 0 ) );\n\t\tthis.add( cameraNX );\n\n\t\tconst cameraPY = new PerspectiveCamera( fov, aspect, near, far );\n\t\tcameraPY.layers = this.layers;\n\t\tcameraPY.up.set( 0, 0, 1 );\n\t\tcameraPY.lookAt( new Vector3( 0, 1, 0 ) );\n\t\tthis.add( cameraPY );\n\n\t\tconst cameraNY = new PerspectiveCamera( fov, aspect, near, far );\n\t\tcameraNY.layers = this.layers;\n\t\tcameraNY.up.set( 0, 0, - 1 );\n\t\tcameraNY.lookAt( new Vector3( 0, - 1, 0 ) );\n\t\tthis.add( cameraNY );\n\n\t\tconst cameraPZ = new PerspectiveCamera( fov, aspect, near, far );\n\t\tcameraPZ.layers = this.layers;\n\t\tcameraPZ.up.set( 0, - 1, 0 );\n\t\tcameraPZ.lookAt( new Vector3( 0, 0, 1 ) );\n\t\tthis.add( cameraPZ );\n\n\t\tconst cameraNZ = new PerspectiveCamera( fov, aspect, near, far );\n\t\tcameraNZ.layers = this.layers;\n\t\tcameraNZ.up.set( 0, - 1, 0 );\n\t\tcameraNZ.lookAt( new Vector3( 0, 0, - 1 ) );\n\t\tthis.add( cameraNZ );\n\n\t}\n\n\tupdate( renderer, scene ) {\n\n\t\tif ( this.parent === null ) this.updateMatrixWorld();\n\n\t\tconst renderTarget = this.renderTarget;\n\n\t\tconst [ cameraPX, cameraNX, cameraPY, cameraNY, cameraPZ, cameraNZ ] = this.children;\n\n\t\tconst currentXrEnabled = renderer.xr.enabled;\n\t\tconst currentRenderTarget = renderer.getRenderTarget();\n\n\t\trenderer.xr.enabled = false;\n\n\t\tconst generateMipmaps = renderTarget.texture.generateMipmaps;\n\n\t\trenderTarget.texture.generateMipmaps = false;\n\n\t\trenderer.setRenderTarget( renderTarget, 0 );\n\t\trenderer.render( scene, cameraPX );\n\n\t\trenderer.setRenderTarget( renderTarget, 1 );\n\t\trenderer.render( scene, cameraNX );\n\n\t\trenderer.setRenderTarget( renderTarget, 2 );\n\t\trenderer.render( scene, cameraPY );\n\n\t\trenderer.setRenderTarget( renderTarget, 3 );\n\t\trenderer.render( scene, cameraNY );\n\n\t\trenderer.setRenderTarget( renderTarget, 4 );\n\t\trenderer.render( scene, cameraPZ );\n\n\t\trenderTarget.texture.generateMipmaps = generateMipmaps;\n\n\t\trenderer.setRenderTarget( renderTarget, 5 );\n\t\trenderer.render( scene, cameraNZ );\n\n\t\trenderer.setRenderTarget( currentRenderTarget );\n\n\t\trenderer.xr.enabled = currentXrEnabled;\n\n\t}\n\n}\n\nclass CubeTexture extends Texture {\n\n\tconstructor( images, mapping, wrapS, wrapT, magFilter, minFilter, format, type, anisotropy, encoding ) {\n\n\t\timages = images !== undefined ? images : [];\n\t\tmapping = mapping !== undefined ? mapping : CubeReflectionMapping;\n\t\tformat = format !== undefined ? format : RGBFormat;\n\n\t\tsuper( images, mapping, wrapS, wrapT, magFilter, minFilter, format, type, anisotropy, encoding );\n\n\t\t// Why CubeTexture._needsFlipEnvMap is necessary:\n\t\t//\n\t\t// By convention -- likely based on the RenderMan spec from the 1990's -- cube maps are specified by WebGL (and three.js)\n\t\t// in a coordinate system in which positive-x is to the right when looking up the positive-z axis -- in other words,\n\t\t// in a left-handed coordinate system. By continuing this convention, preexisting cube maps continued to render correctly.\n\n\t\t// three.js uses a right-handed coordinate system. So environment maps used in three.js appear to have px and nx swapped\n\t\t// and the flag _needsFlipEnvMap controls this conversion. The flip is not required (and thus _needsFlipEnvMap is set to false)\n\t\t// when using WebGLCubeRenderTarget.texture as a cube texture.\n\n\t\tthis._needsFlipEnvMap = true;\n\n\t\tthis.flipY = false;\n\n\t}\n\n\tget images() {\n\n\t\treturn this.image;\n\n\t}\n\n\tset images( value ) {\n\n\t\tthis.image = value;\n\n\t}\n\n}\n\nCubeTexture.prototype.isCubeTexture = true;\n\nclass WebGLCubeRenderTarget extends WebGLRenderTarget {\n\n\tconstructor( size, options, dummy ) {\n\n\t\tif ( Number.isInteger( options ) ) {\n\n\t\t\tconsole.warn( 'THREE.WebGLCubeRenderTarget: constructor signature is now WebGLCubeRenderTarget( size, options )' );\n\n\t\t\toptions = dummy;\n\n\t\t}\n\n\t\tsuper( size, size, options );\n\n\t\toptions = options || {};\n\n\t\tthis.texture = new CubeTexture( undefined, options.mapping, options.wrapS, options.wrapT, options.magFilter, options.minFilter, options.format, options.type, options.anisotropy, options.encoding );\n\n\t\tthis.texture.generateMipmaps = options.generateMipmaps !== undefined ? options.generateMipmaps : false;\n\t\tthis.texture.minFilter = options.minFilter !== undefined ? options.minFilter : LinearFilter;\n\n\t\tthis.texture._needsFlipEnvMap = false;\n\n\t}\n\n\tfromEquirectangularTexture( renderer, texture ) {\n\n\t\tthis.texture.type = texture.type;\n\t\tthis.texture.format = RGBAFormat; // see #18859\n\t\tthis.texture.encoding = texture.encoding;\n\n\t\tthis.texture.generateMipmaps = texture.generateMipmaps;\n\t\tthis.texture.minFilter = texture.minFilter;\n\t\tthis.texture.magFilter = texture.magFilter;\n\n\t\tconst shader = {\n\n\t\t\tuniforms: {\n\t\t\t\ttEquirect: { value: null },\n\t\t\t},\n\n\t\t\tvertexShader: /* glsl */`\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\tvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\n\t\t\t\t\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n\n\t\t\t\t}\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvWorldDirection = transformDirection( position, modelMatrix );\n\n\t\t\t\t\t#include <begin_vertex>\n\t\t\t\t\t#include <project_vertex>\n\n\t\t\t\t}\n\t\t\t`,\n\n\t\t\tfragmentShader: /* glsl */`\n\n\t\t\t\tuniform sampler2D tEquirect;\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\t#include <common>\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvec3 direction = normalize( vWorldDirection );\n\n\t\t\t\t\tvec2 sampleUV = equirectUv( direction );\n\n\t\t\t\t\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\n\t\t\t\t}\n\t\t\t`\n\t\t};\n\n\t\tconst geometry = new BoxGeometry( 5, 5, 5 );\n\n\t\tconst material = new ShaderMaterial( {\n\n\t\t\tname: 'CubemapFromEquirect',\n\n\t\t\tuniforms: cloneUniforms( shader.uniforms ),\n\t\t\tvertexShader: shader.vertexShader,\n\t\t\tfragmentShader: shader.fragmentShader,\n\t\t\tside: BackSide,\n\t\t\tblending: NoBlending\n\n\t\t} );\n\n\t\tmaterial.uniforms.tEquirect.value = texture;\n\n\t\tconst mesh = new Mesh( geometry, material );\n\n\t\tconst currentMinFilter = texture.minFilter;\n\n\t\t// Avoid blurred poles\n\t\tif ( texture.minFilter === LinearMipmapLinearFilter ) texture.minFilter = LinearFilter;\n\n\t\tconst camera = new CubeCamera( 1, 10, this );\n\t\tcamera.update( renderer, mesh );\n\n\t\ttexture.minFilter = currentMinFilter;\n\n\t\tmesh.geometry.dispose();\n\t\tmesh.material.dispose();\n\n\t\treturn this;\n\n\t}\n\n\tclear( renderer, color, depth, stencil ) {\n\n\t\tconst currentRenderTarget = renderer.getRenderTarget();\n\n\t\tfor ( let i = 0; i < 6; i ++ ) {\n\n\t\t\trenderer.setRenderTarget( this, i );\n\n\t\t\trenderer.clear( color, depth, stencil );\n\n\t\t}\n\n\t\trenderer.setRenderTarget( currentRenderTarget );\n\n\t}\n\n}\n\nWebGLCubeRenderTarget.prototype.isWebGLCubeRenderTarget = true;\n\nconst _sphere$2 = /*@__PURE__*/ new Sphere();\nconst _vector$7 = /*@__PURE__*/ new Vector3();\n\nclass Frustum {\n\n\tconstructor( p0 = new Plane(), p1 = new Plane(), p2 = new Plane(), p3 = new Plane(), p4 = new Plane(), p5 = new Plane() ) {\n\n\t\tthis.planes = [ p0, p1, p2, p3, p4, p5 ];\n\n\t}\n\n\tset( p0, p1, p2, p3, p4, p5 ) {\n\n\t\tconst planes = this.planes;\n\n\t\tplanes[ 0 ].copy( p0 );\n\t\tplanes[ 1 ].copy( p1 );\n\t\tplanes[ 2 ].copy( p2 );\n\t\tplanes[ 3 ].copy( p3 );\n\t\tplanes[ 4 ].copy( p4 );\n\t\tplanes[ 5 ].copy( p5 );\n\n\t\treturn this;\n\n\t}\n\n\tcopy( frustum ) {\n\n\t\tconst planes = this.planes;\n\n\t\tfor ( let i = 0; i < 6; i ++ ) {\n\n\t\t\tplanes[ i ].copy( frustum.planes[ i ] );\n\n\t\t}\n\n\t\treturn this;\n\n\t}\n\n\tsetFromProjectionMatrix( m ) {\n\n\t\tconst planes = this.planes;\n\t\tconst me = m.elements;\n\t\tconst me0 = me[ 0 ], me1 = me[ 1 ], me2 = me[ 2 ], me3 = me[ 3 ];\n\t\tconst me4 = me[ 4 ], me5 = me[ 5 ], me6 = me[ 6 ], me7 = me[ 7 ];\n\t\tconst me8 = me[ 8 ], me9 = me[ 9 ], me10 = me[ 10 ], me11 = me[ 11 ];\n\t\tconst me12 = me[ 12 ], me13 = me[ 13 ], me14 = me[ 14 ], me15 = me[ 15 ];\n\n\t\tplanes[ 0 ].setComponents( me3 - me0, me7 - me4, me11 - me8, me15 - me12 ).normalize();\n\t\tplanes[ 1 ].setComponents( me3 + me0, me7 + me4, me11 + me8, me15 + me12 ).normalize();\n\t\tplanes[ 2 ].setComponents( me3 + me1, me7 + me5, me11 + me9, me15 + me13 ).normalize();\n\t\tplanes[ 3 ].setComponents( me3 - me1, me7 - me5, me11 - me9, me15 - me13 ).normalize();\n\t\tplanes[ 4 ].setComponents( me3 - me2, me7 - me6, me11 - me10, me15 - me14 ).normalize();\n\t\tplanes[ 5 ].setComponents( me3 + me2, me7 + me6, me11 + me10, me15 + me14 ).normalize();\n\n\t\treturn this;\n\n\t}\n\n\tintersectsObject( object ) {\n\n\t\tconst geometry = object.geometry;\n\n\t\tif ( geometry.boundingSphere === null ) geometry.computeBoundingSphere();\n\n\t\t_sphere$2.copy( geometry.boundingSphere ).applyMatrix4( object.matrixWorld );\n\n\t\treturn this.intersectsSphere( _sphere$2 );\n\n\t}\n\n\tintersectsSprite( sprite ) {\n\n\t\t_sphere$2.center.set( 0, 0, 0 );\n\t\t_sphere$2.radius = 0.7071067811865476;\n\t\t_sphere$2.applyMatrix4( sprite.matrixWorld );\n\n\t\treturn this.intersectsSphere( _sphere$2 );\n\n\t}\n\n\tintersectsSphere( sphere ) {\n\n\t\tconst planes = this.planes;\n\t\tconst center = sphere.center;\n\t\tconst negRadius = - sphere.radius;\n\n\t\tfor ( let i = 0; i < 6; i ++ ) {\n\n\t\t\tconst distance = planes[ i ].distanceToPoint( center );\n\n\t\t\tif ( distance < negRadius ) {\n\n\t\t\t\treturn false;\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn true;\n\n\t}\n\n\tintersectsBox( box ) {\n\n\t\tconst planes = this.planes;\n\n\t\tfor ( let i = 0; i < 6; i ++ ) {\n\n\t\t\tconst plane = planes[ i ];\n\n\t\t\t// corner at max distance\n\n\t\t\t_vector$7.x = plane.normal.x > 0 ? box.max.x : box.min.x;\n\t\t\t_vector$7.y = plane.normal.y > 0 ? box.max.y : box.min.y;\n\t\t\t_vector$7.z = plane.normal.z > 0 ? box.max.z : box.min.z;\n\n\t\t\tif ( plane.distanceToPoint( _vector$7 ) < 0 ) {\n\n\t\t\t\treturn false;\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn true;\n\n\t}\n\n\tcontainsPoint( point ) {\n\n\t\tconst planes = this.planes;\n\n\t\tfor ( let i = 0; i < 6; i ++ ) {\n\n\t\t\tif ( planes[ i ].distanceToPoint( point ) < 0 ) {\n\n\t\t\t\treturn false;\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn true;\n\n\t}\n\n\tclone() {\n\n\t\treturn new this.constructor().copy( this );\n\n\t}\n\n}\n\nfunction WebGLAnimation() {\n\n\tlet context = null;\n\tlet isAnimating = false;\n\tlet animationLoop = null;\n\tlet requestId = null;\n\n\tfunction onAnimationFrame( time, frame ) {\n\n\t\tanimationLoop( time, frame );\n\n\t\trequestId = context.requestAnimationFrame( onAnimationFrame );\n\n\t}\n\n\treturn {\n\n\t\tstart: function () {\n\n\t\t\tif ( isAnimating === true ) return;\n\t\t\tif ( animationLoop === null ) return;\n\n\t\t\trequestId = context.requestAnimationFrame( onAnimationFrame );\n\n\t\t\tisAnimating = true;\n\n\t\t},\n\n\t\tstop: function () {\n\n\t\t\tcontext.cancelAnimationFrame( requestId );\n\n\t\t\tisAnimating = false;\n\n\t\t},\n\n\t\tsetAnimationLoop: function ( callback ) {\n\n\t\t\tanimationLoop = callback;\n\n\t\t},\n\n\t\tsetContext: function ( value ) {\n\n\t\t\tcontext = value;\n\n\t\t}\n\n\t};\n\n}\n\nfunction WebGLAttributes( gl, capabilities ) {\n\n\tconst isWebGL2 = capabilities.isWebGL2;\n\n\tconst buffers = new WeakMap();\n\n\tfunction createBuffer( attribute, bufferType ) {\n\n\t\tconst array = attribute.array;\n\t\tconst usage = attribute.usage;\n\n\t\tconst buffer = gl.createBuffer();\n\n\t\tgl.bindBuffer( bufferType, buffer );\n\t\tgl.bufferData( bufferType, array, usage );\n\n\t\tattribute.onUploadCallback();\n\n\t\tlet type = 5126;\n\n\t\tif ( array instanceof Float32Array ) {\n\n\t\t\ttype = 5126;\n\n\t\t} else if ( array instanceof Float64Array ) {\n\n\t\t\tconsole.warn( 'THREE.WebGLAttributes: Unsupported data buffer format: Float64Array.' );\n\n\t\t} else if ( array instanceof Uint16Array ) {\n\n\t\t\tif ( attribute.isFloat16BufferAttribute ) {\n\n\t\t\t\tif ( isWebGL2 ) {\n\n\t\t\t\t\ttype = 5131;\n\n\t\t\t\t} else {\n\n\t\t\t\t\tconsole.warn( 'THREE.WebGLAttributes: Usage of Float16BufferAttribute requires WebGL2.' );\n\n\t\t\t\t}\n\n\t\t\t} else {\n\n\t\t\t\ttype = 5123;\n\n\t\t\t}\n\n\t\t} else if ( array instanceof Int16Array ) {\n\n\t\t\ttype = 5122;\n\n\t\t} else if ( array instanceof Uint32Array ) {\n\n\t\t\ttype = 5125;\n\n\t\t} else if ( array instanceof Int32Array ) {\n\n\t\t\ttype = 5124;\n\n\t\t} else if ( array instanceof Int8Array ) {\n\n\t\t\ttype = 5120;\n\n\t\t} else if ( array instanceof Uint8Array ) {\n\n\t\t\ttype = 5121;\n\n\t\t} else if ( array instanceof Uint8ClampedArray ) {\n\n\t\t\ttype = 5121;\n\n\t\t}\n\n\t\treturn {\n\t\t\tbuffer: buffer,\n\t\t\ttype: type,\n\t\t\tbytesPerElement: array.BYTES_PER_ELEMENT,\n\t\t\tversion: attribute.version\n\t\t};\n\n\t}\n\n\tfunction updateBuffer( buffer, attribute, bufferType ) {\n\n\t\tconst array = attribute.array;\n\t\tconst updateRange = attribute.updateRange;\n\n\t\tgl.bindBuffer( bufferType, buffer );\n\n\t\tif ( updateRange.count === - 1 ) {\n\n\t\t\t// Not using update ranges\n\n\t\t\tgl.bufferSubData( bufferType, 0, array );\n\n\t\t} else {\n\n\t\t\tif ( isWebGL2 ) {\n\n\t\t\t\tgl.bufferSubData( bufferType, updateRange.offset * array.BYTES_PER_ELEMENT,\n\t\t\t\t\tarray, updateRange.offset, updateRange.count );\n\n\t\t\t} else {\n\n\t\t\t\tgl.bufferSubData( bufferType, updateRange.offset * array.BYTES_PER_ELEMENT,\n\t\t\t\t\tarray.subarray( updateRange.offset, updateRange.offset + updateRange.count ) );\n\n\t\t\t}\n\n\t\t\tupdateRange.count = - 1; // reset range\n\n\t\t}\n\n\t}\n\n\t//\n\n\tfunction get( attribute ) {\n\n\t\tif ( attribute.isInterleavedBufferAttribute ) attribute = attribute.data;\n\n\t\treturn buffers.get( attribute );\n\n\t}\n\n\tfunction remove( attribute ) {\n\n\t\tif ( attribute.isInterleavedBufferAttribute ) attribute = attribute.data;\n\n\t\tconst data = buffers.get( attribute );\n\n\t\tif ( data ) {\n\n\t\t\tgl.deleteBuffer( data.buffer );\n\n\t\t\tbuffers.delete( attribute );\n\n\t\t}\n\n\t}\n\n\tfunction update( attribute, bufferType ) {\n\n\t\tif ( attribute.isGLBufferAttribute ) {\n\n\t\t\tconst cached = buffers.get( attribute );\n\n\t\t\tif ( ! cached || cached.version < attribute.version ) {\n\n\t\t\t\tbuffers.set( attribute, {\n\t\t\t\t\tbuffer: attribute.buffer,\n\t\t\t\t\ttype: attribute.type,\n\t\t\t\t\tbytesPerElement: attribute.elementSize,\n\t\t\t\t\tversion: attribute.version\n\t\t\t\t} );\n\n\t\t\t}\n\n\t\t\treturn;\n\n\t\t}\n\n\t\tif ( attribute.isInterleavedBufferAttribute ) attribute = attribute.data;\n\n\t\tconst data = buffers.get( attribute );\n\n\t\tif ( data === undefined ) {\n\n\t\t\tbuffers.set( attribute, createBuffer( attribute, bufferType ) );\n\n\t\t} else if ( data.version < attribute.version ) {\n\n\t\t\tupdateBuffer( data.buffer, attribute, bufferType );\n\n\t\t\tdata.version = attribute.version;\n\n\t\t}\n\n\t}\n\n\treturn {\n\n\t\tget: get,\n\t\tremove: remove,\n\t\tupdate: update\n\n\t};\n\n}\n\nclass PlaneGeometry extends BufferGeometry {\n\n\tconstructor( width = 1, height = 1, widthSegments = 1, heightSegments = 1 ) {\n\n\t\tsuper();\n\t\tthis.type = 'PlaneGeometry';\n\n\t\tthis.parameters = {\n\t\t\twidth: width,\n\t\t\theight: height,\n\t\t\twidthSegments: widthSegments,\n\t\t\theightSegments: heightSegments\n\t\t};\n\n\t\tconst width_half = width / 2;\n\t\tconst height_half = height / 2;\n\n\t\tconst gridX = Math.floor( widthSegments );\n\t\tconst gridY = Math.floor( heightSegments );\n\n\t\tconst gridX1 = gridX + 1;\n\t\tconst gridY1 = gridY + 1;\n\n\t\tconst segment_width = width / gridX;\n\t\tconst segment_height = height / gridY;\n\n\t\t//\n\n\t\tconst indices = [];\n\t\tconst vertices = [];\n\t\tconst normals = [];\n\t\tconst uvs = [];\n\n\t\tfor ( let iy = 0; iy < gridY1; iy ++ ) {\n\n\t\t\tconst y = iy * segment_height - height_half;\n\n\t\t\tfor ( let ix = 0; ix < gridX1; ix ++ ) {\n\n\t\t\t\tconst x = ix * segment_width - width_half;\n\n\t\t\t\tvertices.push( x, - y, 0 );\n\n\t\t\t\tnormals.push( 0, 0, 1 );\n\n\t\t\t\tuvs.push( ix / gridX );\n\t\t\t\tuvs.push( 1 - ( iy / gridY ) );\n\n\t\t\t}\n\n\t\t}\n\n\t\tfor ( let iy = 0; iy < gridY; iy ++ ) {\n\n\t\t\tfor ( let ix = 0; ix < gridX; ix ++ ) {\n\n\t\t\t\tconst a = ix + gridX1 * iy;\n\t\t\t\tconst b = ix + gridX1 * ( iy + 1 );\n\t\t\t\tconst c = ( ix + 1 ) + gridX1 * ( iy + 1 );\n\t\t\t\tconst d = ( ix + 1 ) + gridX1 * iy;\n\n\t\t\t\tindices.push( a, b, d );\n\t\t\t\tindices.push( b, c, d );\n\n\t\t\t}\n\n\t\t}\n\n\t\tthis.setIndex( indices );\n\t\tthis.setAttribute( 'position', new Float32BufferAttribute( vertices, 3 ) );\n\t\tthis.setAttribute( 'normal', new Float32BufferAttribute( normals, 3 ) );\n\t\tthis.setAttribute( 'uv', new Float32BufferAttribute( uvs, 2 ) );\n\n\t}\n\n}\n\nvar alphamap_fragment = \"#ifdef USE_ALPHAMAP\\n\\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\\n#endif\";\n\nvar alphamap_pars_fragment = \"#ifdef USE_ALPHAMAP\\n\\tuniform sampler2D alphaMap;\\n#endif\";\n\nvar alphatest_fragment = \"#ifdef ALPHATEST\\n\\tif ( diffuseColor.a < ALPHATEST ) discard;\\n#endif\";\n\nvar aomap_fragment = \"#ifdef USE_AOMAP\\n\\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\\n\\treflectedLight.indirectDiffuse *= ambientOcclusion;\\n\\t#if defined( USE_ENVMAP ) && defined( STANDARD )\\n\\t\\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\\n\\t\\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\\n\\t#endif\\n#endif\";\n\nvar aomap_pars_fragment = \"#ifdef USE_AOMAP\\n\\tuniform sampler2D aoMap;\\n\\tuniform float aoMapIntensity;\\n#endif\";\n\nvar begin_vertex = \"vec3 transformed = vec3( position );\";\n\nvar beginnormal_vertex = \"vec3 objectNormal = vec3( normal );\\n#ifdef USE_TANGENT\\n\\tvec3 objectTangent = vec3( tangent.xyz );\\n#endif\";\n\nvar bsdfs = \"vec2 integrateSpecularBRDF( const in float dotNV, const in float roughness ) {\\n\\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\\n\\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\\n\\tvec4 r = roughness * c0 + c1;\\n\\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\\n\\treturn vec2( -1.04, 1.04 ) * a004 + r.zw;\\n}\\nfloat punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\\n\\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\\n\\tif( cutoffDistance > 0.0 ) {\\n\\t\\tdistanceFalloff *= pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\\n\\t}\\n\\treturn distanceFalloff;\\n#else\\n\\tif( cutoffDistance > 0.0 && decayExponent > 0.0 ) {\\n\\t\\treturn pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\\n\\t}\\n\\treturn 1.0;\\n#endif\\n}\\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\\n\\treturn RECIPROCAL_PI * diffuseColor;\\n}\\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\\n\\tfloat fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\\n\\treturn ( 1.0 - specularColor ) * fresnel + specularColor;\\n}\\nvec3 F_Schlick_RoughnessDependent( const in vec3 F0, const in float dotNV, const in float roughness ) {\\n\\tfloat fresnel = exp2( ( -5.55473 * dotNV - 6.98316 ) * dotNV );\\n\\tvec3 Fr = max( vec3( 1.0 - roughness ), F0 ) - F0;\\n\\treturn Fr * fresnel + F0;\\n}\\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\\n\\tfloat a2 = pow2( alpha );\\n\\tfloat gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\\n\\tfloat gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\\n\\treturn 1.0 / ( gl * gv );\\n}\\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\\n\\tfloat a2 = pow2( alpha );\\n\\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\\n\\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\\n\\treturn 0.5 / max( gv + gl, EPSILON );\\n}\\nfloat D_GGX( const in float alpha, const in float dotNH ) {\\n\\tfloat a2 = pow2( alpha );\\n\\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\\n\\treturn RECIPROCAL_PI * a2 / pow2( denom );\\n}\\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float roughness ) {\\n\\tfloat alpha = pow2( roughness );\\n\\tvec3 halfDir = normalize( incidentLight.direction + viewDir );\\n\\tfloat dotNL = saturate( dot( normal, incidentLight.direction ) );\\n\\tfloat dotNV = saturate( dot( normal, viewDir ) );\\n\\tfloat dotNH = saturate( dot( normal, halfDir ) );\\n\\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\\n\\tvec3 F = F_Schlick( specularColor, dotLH );\\n\\tfloat G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\\n\\tfloat D = D_GGX( alpha, dotNH );\\n\\treturn F * ( G * D );\\n}\\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\\n\\tconst float LUT_SIZE = 64.0;\\n\\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\\n\\tconst float LUT_BIAS = 0.5 / LUT_SIZE;\\n\\tfloat dotNV = saturate( dot( N, V ) );\\n\\tvec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\\n\\tuv = uv * LUT_SCALE + LUT_BIAS;\\n\\treturn uv;\\n}\\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\\n\\tfloat l = length( f );\\n\\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\\n}\\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\\n\\tfloat x = dot( v1, v2 );\\n\\tfloat y = abs( x );\\n\\tfloat a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\\n\\tfloat b = 3.4175940 + ( 4.1616724 + y ) * y;\\n\\tfloat v = a / b;\\n\\tfloat theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\\n\\treturn cross( v1, v2 ) * theta_sintheta;\\n}\\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\\n\\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\\n\\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\\n\\tvec3 lightNormal = cross( v1, v2 );\\n\\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\\n\\tvec3 T1, T2;\\n\\tT1 = normalize( V - N * dot( V, N ) );\\n\\tT2 = - cross( N, T1 );\\n\\tmat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\\n\\tvec3 coords[ 4 ];\\n\\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\\n\\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\\n\\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\\n\\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\\n\\tcoords[ 0 ] = normalize( coords[ 0 ] );\\n\\tcoords[ 1 ] = normalize( coords[ 1 ] );\\n\\tcoords[ 2 ] = normalize( coords[ 2 ] );\\n\\tcoords[ 3 ] = normalize( coords[ 3 ] );\\n\\tvec3 vectorFormFactor = vec3( 0.0 );\\n\\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\\n\\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\\n\\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\\n\\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\\n\\tfloat result = LTC_ClippedSphereFormFactor( vectorFormFactor );\\n\\treturn vec3( result );\\n}\\nvec3 BRDF_Specular_GGX_Environment( const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float roughness ) {\\n\\tfloat dotNV = saturate( dot( normal, viewDir ) );\\n\\tvec2 brdf = integrateSpecularBRDF( dotNV, roughness );\\n\\treturn specularColor * brdf.x + brdf.y;\\n}\\nvoid BRDF_Specular_Multiscattering_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\\n\\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\\n\\tvec3 F = F_Schlick_RoughnessDependent( specularColor, dotNV, roughness );\\n\\tvec2 brdf = integrateSpecularBRDF( dotNV, roughness );\\n\\tvec3 FssEss = F * brdf.x + brdf.y;\\n\\tfloat Ess = brdf.x + brdf.y;\\n\\tfloat Ems = 1.0 - Ess;\\n\\tvec3 Favg = specularColor + ( 1.0 - specularColor ) * 0.047619;\\tvec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );\\n\\tsingleScatter += FssEss;\\n\\tmultiScatter += Fms * Ems;\\n}\\nfloat G_BlinnPhong_Implicit( ) {\\n\\treturn 0.25;\\n}\\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\\n\\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\\n}\\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\\n\\tvec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\\n\\tfloat dotNH = saturate( dot( geometry.normal, halfDir ) );\\n\\tfloat dotLH = saturate( dot( incidentLight.direction, halfDir ) );\\n\\tvec3 F = F_Schlick( specularColor, dotLH );\\n\\tfloat G = G_BlinnPhong_Implicit( );\\n\\tfloat D = D_BlinnPhong( shininess, dotNH );\\n\\treturn F * ( G * D );\\n}\\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\\n\\treturn ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\\n}\\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\\n\\treturn sqrt( 2.0 / ( blinnExponent + 2.0 ) );\\n}\\n#if defined( USE_SHEEN )\\nfloat D_Charlie(float roughness, float NoH) {\\n\\tfloat invAlpha = 1.0 / roughness;\\n\\tfloat cos2h = NoH * NoH;\\n\\tfloat sin2h = max(1.0 - cos2h, 0.0078125);\\treturn (2.0 + invAlpha) * pow(sin2h, invAlpha * 0.5) / (2.0 * PI);\\n}\\nfloat V_Neubelt(float NoV, float NoL) {\\n\\treturn saturate(1.0 / (4.0 * (NoL + NoV - NoL * NoV)));\\n}\\nvec3 BRDF_Specular_Sheen( const in float roughness, const in vec3 L, const in GeometricContext geometry, vec3 specularColor ) {\\n\\tvec3 N = geometry.normal;\\n\\tvec3 V = geometry.viewDir;\\n\\tvec3 H = normalize( V + L );\\n\\tfloat dotNH = saturate( dot( N, H ) );\\n\\treturn specularColor * D_Charlie( roughness, dotNH ) * V_Neubelt( dot(N, V), dot(N, L) );\\n}\\n#endif\";\n\nvar bumpmap_pars_fragment = \"#ifdef USE_BUMPMAP\\n\\tuniform sampler2D bumpMap;\\n\\tuniform float bumpScale;\\n\\tvec2 dHdxy_fwd() {\\n\\t\\tvec2 dSTdx = dFdx( vUv );\\n\\t\\tvec2 dSTdy = dFdy( vUv );\\n\\t\\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\\n\\t\\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\\n\\t\\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\\n\\t\\treturn vec2( dBx, dBy );\\n\\t}\\n\\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy, float faceDirection ) {\\n\\t\\tvec3 vSigmaX = vec3( dFdx( surf_pos.x ), dFdx( surf_pos.y ), dFdx( surf_pos.z ) );\\n\\t\\tvec3 vSigmaY = vec3( dFdy( surf_pos.x ), dFdy( surf_pos.y ), dFdy( surf_pos.z ) );\\n\\t\\tvec3 vN = surf_norm;\\n\\t\\tvec3 R1 = cross( vSigmaY, vN );\\n\\t\\tvec3 R2 = cross( vN, vSigmaX );\\n\\t\\tfloat fDet = dot( vSigmaX, R1 ) * faceDirection;\\n\\t\\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\\n\\t\\treturn normalize( abs( fDet ) * surf_norm - vGrad );\\n\\t}\\n#endif\";\n\nvar clipping_planes_fragment = \"#if NUM_CLIPPING_PLANES > 0\\n\\tvec4 plane;\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\\n\\t\\tplane = clippingPlanes[ i ];\\n\\t\\tif ( dot( vClipPosition, plane.xyz ) > plane.w ) discard;\\n\\t}\\n\\t#pragma unroll_loop_end\\n\\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\\n\\t\\tbool clipped = true;\\n\\t\\t#pragma unroll_loop_start\\n\\t\\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\\n\\t\\t\\tplane = clippingPlanes[ i ];\\n\\t\\t\\tclipped = ( dot( vClipPosition, plane.xyz ) > plane.w ) && clipped;\\n\\t\\t}\\n\\t\\t#pragma unroll_loop_end\\n\\t\\tif ( clipped ) discard;\\n\\t#endif\\n#endif\";\n\nvar clipping_planes_pars_fragment = \"#if NUM_CLIPPING_PLANES > 0\\n\\tvarying vec3 vClipPosition;\\n\\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\\n#endif\";\n\nvar clipping_planes_pars_vertex = \"#if NUM_CLIPPING_PLANES > 0\\n\\tvarying vec3 vClipPosition;\\n#endif\";\n\nvar clipping_planes_vertex = \"#if NUM_CLIPPING_PLANES > 0\\n\\tvClipPosition = - mvPosition.xyz;\\n#endif\";\n\nvar color_fragment = \"#if defined( USE_COLOR_ALPHA )\\n\\tdiffuseColor *= vColor;\\n#elif defined( USE_COLOR )\\n\\tdiffuseColor.rgb *= vColor;\\n#endif\";\n\nvar color_pars_fragment = \"#if defined( USE_COLOR_ALPHA )\\n\\tvarying vec4 vColor;\\n#elif defined( USE_COLOR )\\n\\tvarying vec3 vColor;\\n#endif\";\n\nvar color_pars_vertex = \"#if defined( USE_COLOR_ALPHA )\\n\\tvarying vec4 vColor;\\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR )\\n\\tvarying vec3 vColor;\\n#endif\";\n\nvar color_vertex = \"#if defined( USE_COLOR_ALPHA )\\n\\tvColor = vec4( 1.0 );\\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR )\\n\\tvColor = vec3( 1.0 );\\n#endif\\n#ifdef USE_COLOR\\n\\tvColor *= color;\\n#endif\\n#ifdef USE_INSTANCING_COLOR\\n\\tvColor.xyz *= instanceColor.xyz;\\n#endif\";\n\nvar common = \"#define PI 3.141592653589793\\n#define PI2 6.283185307179586\\n#define PI_HALF 1.5707963267948966\\n#define RECIPROCAL_PI 0.3183098861837907\\n#define RECIPROCAL_PI2 0.15915494309189535\\n#define EPSILON 1e-6\\n#ifndef saturate\\n#define saturate(a) clamp( a, 0.0, 1.0 )\\n#endif\\n#define whiteComplement(a) ( 1.0 - saturate( a ) )\\nfloat pow2( const in float x ) { return x*x; }\\nfloat pow3( const in float x ) { return x*x*x; }\\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\\nhighp float rand( const in vec2 uv ) {\\n\\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\\n\\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\\n\\treturn fract(sin(sn) * c);\\n}\\n#ifdef HIGH_PRECISION\\n\\tfloat precisionSafeLength( vec3 v ) { return length( v ); }\\n#else\\n\\tfloat max3( vec3 v ) { return max( max( v.x, v.y ), v.z ); }\\n\\tfloat precisionSafeLength( vec3 v ) {\\n\\t\\tfloat maxComponent = max3( abs( v ) );\\n\\t\\treturn length( v / maxComponent ) * maxComponent;\\n\\t}\\n#endif\\nstruct IncidentLight {\\n\\tvec3 color;\\n\\tvec3 direction;\\n\\tbool visible;\\n};\\nstruct ReflectedLight {\\n\\tvec3 directDiffuse;\\n\\tvec3 directSpecular;\\n\\tvec3 indirectDiffuse;\\n\\tvec3 indirectSpecular;\\n};\\nstruct GeometricContext {\\n\\tvec3 position;\\n\\tvec3 normal;\\n\\tvec3 viewDir;\\n#ifdef CLEARCOAT\\n\\tvec3 clearcoatNormal;\\n#endif\\n};\\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\\n\\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\\n}\\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\\n\\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\\n}\\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\\n\\tfloat distance = dot( planeNormal, point - pointOnPlane );\\n\\treturn - distance * planeNormal + point;\\n}\\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\\n\\treturn sign( dot( point - pointOnPlane, planeNormal ) );\\n}\\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\\n\\treturn lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\\n}\\nmat3 transposeMat3( const in mat3 m ) {\\n\\tmat3 tmp;\\n\\ttmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\\n\\ttmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\\n\\ttmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\\n\\treturn tmp;\\n}\\nfloat linearToRelativeLuminance( const in vec3 color ) {\\n\\tvec3 weights = vec3( 0.2126, 0.7152, 0.0722 );\\n\\treturn dot( weights, color.rgb );\\n}\\nbool isPerspectiveMatrix( mat4 m ) {\\n\\treturn m[ 2 ][ 3 ] == - 1.0;\\n}\\nvec2 equirectUv( in vec3 dir ) {\\n\\tfloat u = atan( dir.z, dir.x ) * RECIPROCAL_PI2 + 0.5;\\n\\tfloat v = asin( clamp( dir.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\\n\\treturn vec2( u, v );\\n}\";\n\nvar cube_uv_reflection_fragment = \"#ifdef ENVMAP_TYPE_CUBE_UV\\n\\t#define cubeUV_maxMipLevel 8.0\\n\\t#define cubeUV_minMipLevel 4.0\\n\\t#define cubeUV_maxTileSize 256.0\\n\\t#define cubeUV_minTileSize 16.0\\n\\tfloat getFace( vec3 direction ) {\\n\\t\\tvec3 absDirection = abs( direction );\\n\\t\\tfloat face = - 1.0;\\n\\t\\tif ( absDirection.x > absDirection.z ) {\\n\\t\\t\\tif ( absDirection.x > absDirection.y )\\n\\t\\t\\t\\tface = direction.x > 0.0 ? 0.0 : 3.0;\\n\\t\\t\\telse\\n\\t\\t\\t\\tface = direction.y > 0.0 ? 1.0 : 4.0;\\n\\t\\t} else {\\n\\t\\t\\tif ( absDirection.z > absDirection.y )\\n\\t\\t\\t\\tface = direction.z > 0.0 ? 2.0 : 5.0;\\n\\t\\t\\telse\\n\\t\\t\\t\\tface = direction.y > 0.0 ? 1.0 : 4.0;\\n\\t\\t}\\n\\t\\treturn face;\\n\\t}\\n\\tvec2 getUV( vec3 direction, float face ) {\\n\\t\\tvec2 uv;\\n\\t\\tif ( face == 0.0 ) {\\n\\t\\t\\tuv = vec2( direction.z, direction.y ) / abs( direction.x );\\n\\t\\t} else if ( face == 1.0 ) {\\n\\t\\t\\tuv = vec2( - direction.x, - direction.z ) / abs( direction.y );\\n\\t\\t} else if ( face == 2.0 ) {\\n\\t\\t\\tuv = vec2( - direction.x, direction.y ) / abs( direction.z );\\n\\t\\t} else if ( face == 3.0 ) {\\n\\t\\t\\tuv = vec2( - direction.z, direction.y ) / abs( direction.x );\\n\\t\\t} else if ( face == 4.0 ) {\\n\\t\\t\\tuv = vec2( - direction.x, direction.z ) / abs( direction.y );\\n\\t\\t} else {\\n\\t\\t\\tuv = vec2( direction.x, direction.y ) / abs( direction.z );\\n\\t\\t}\\n\\t\\treturn 0.5 * ( uv + 1.0 );\\n\\t}\\n\\tvec3 bilinearCubeUV( sampler2D envMap, vec3 direction, float mipInt ) {\\n\\t\\tfloat face = getFace( direction );\\n\\t\\tfloat filterInt = max( cubeUV_minMipLevel - mipInt, 0.0 );\\n\\t\\tmipInt = max( mipInt, cubeUV_minMipLevel );\\n\\t\\tfloat faceSize = exp2( mipInt );\\n\\t\\tfloat texelSize = 1.0 / ( 3.0 * cubeUV_maxTileSize );\\n\\t\\tvec2 uv = getUV( direction, face ) * ( faceSize - 1.0 );\\n\\t\\tvec2 f = fract( uv );\\n\\t\\tuv += 0.5 - f;\\n\\t\\tif ( face > 2.0 ) {\\n\\t\\t\\tuv.y += faceSize;\\n\\t\\t\\tface -= 3.0;\\n\\t\\t}\\n\\t\\tuv.x += face * faceSize;\\n\\t\\tif ( mipInt < cubeUV_maxMipLevel ) {\\n\\t\\t\\tuv.y += 2.0 * cubeUV_maxTileSize;\\n\\t\\t}\\n\\t\\tuv.y += filterInt * 2.0 * cubeUV_minTileSize;\\n\\t\\tuv.x += 3.0 * max( 0.0, cubeUV_maxTileSize - 2.0 * faceSize );\\n\\t\\tuv *= texelSize;\\n\\t\\tvec3 tl = envMapTexelToLinear( texture2D( envMap, uv ) ).rgb;\\n\\t\\tuv.x += texelSize;\\n\\t\\tvec3 tr = envMapTexelToLinear( texture2D( envMap, uv ) ).rgb;\\n\\t\\tuv.y += texelSize;\\n\\t\\tvec3 br = envMapTexelToLinear( texture2D( envMap, uv ) ).rgb;\\n\\t\\tuv.x -= texelSize;\\n\\t\\tvec3 bl = envMapTexelToLinear( texture2D( envMap, uv ) ).rgb;\\n\\t\\tvec3 tm = mix( tl, tr, f.x );\\n\\t\\tvec3 bm = mix( bl, br, f.x );\\n\\t\\treturn mix( tm, bm, f.y );\\n\\t}\\n\\t#define r0 1.0\\n\\t#define v0 0.339\\n\\t#define m0 - 2.0\\n\\t#define r1 0.8\\n\\t#define v1 0.276\\n\\t#define m1 - 1.0\\n\\t#define r4 0.4\\n\\t#define v4 0.046\\n\\t#define m4 2.0\\n\\t#define r5 0.305\\n\\t#define v5 0.016\\n\\t#define m5 3.0\\n\\t#define r6 0.21\\n\\t#define v6 0.0038\\n\\t#define m6 4.0\\n\\tfloat roughnessToMip( float roughness ) {\\n\\t\\tfloat mip = 0.0;\\n\\t\\tif ( roughness >= r1 ) {\\n\\t\\t\\tmip = ( r0 - roughness ) * ( m1 - m0 ) / ( r0 - r1 ) + m0;\\n\\t\\t} else if ( roughness >= r4 ) {\\n\\t\\t\\tmip = ( r1 - roughness ) * ( m4 - m1 ) / ( r1 - r4 ) + m1;\\n\\t\\t} else if ( roughness >= r5 ) {\\n\\t\\t\\tmip = ( r4 - roughness ) * ( m5 - m4 ) / ( r4 - r5 ) + m4;\\n\\t\\t} else if ( roughness >= r6 ) {\\n\\t\\t\\tmip = ( r5 - roughness ) * ( m6 - m5 ) / ( r5 - r6 ) + m5;\\n\\t\\t} else {\\n\\t\\t\\tmip = - 2.0 * log2( 1.16 * roughness );\\t\\t}\\n\\t\\treturn mip;\\n\\t}\\n\\tvec4 textureCubeUV( sampler2D envMap, vec3 sampleDir, float roughness ) {\\n\\t\\tfloat mip = clamp( roughnessToMip( roughness ), m0, cubeUV_maxMipLevel );\\n\\t\\tfloat mipF = fract( mip );\\n\\t\\tfloat mipInt = floor( mip );\\n\\t\\tvec3 color0 = bilinearCubeUV( envMap, sampleDir, mipInt );\\n\\t\\tif ( mipF == 0.0 ) {\\n\\t\\t\\treturn vec4( color0, 1.0 );\\n\\t\\t} else {\\n\\t\\t\\tvec3 color1 = bilinearCubeUV( envMap, sampleDir, mipInt + 1.0 );\\n\\t\\t\\treturn vec4( mix( color0, color1, mipF ), 1.0 );\\n\\t\\t}\\n\\t}\\n#endif\";\n\nvar defaultnormal_vertex = \"vec3 transformedNormal = objectNormal;\\n#ifdef USE_INSTANCING\\n\\tmat3 m = mat3( instanceMatrix );\\n\\ttransformedNormal /= vec3( dot( m[ 0 ], m[ 0 ] ), dot( m[ 1 ], m[ 1 ] ), dot( m[ 2 ], m[ 2 ] ) );\\n\\ttransformedNormal = m * transformedNormal;\\n#endif\\ntransformedNormal = normalMatrix * transformedNormal;\\n#ifdef FLIP_SIDED\\n\\ttransformedNormal = - transformedNormal;\\n#endif\\n#ifdef USE_TANGENT\\n\\tvec3 transformedTangent = ( modelViewMatrix * vec4( objectTangent, 0.0 ) ).xyz;\\n\\t#ifdef FLIP_SIDED\\n\\t\\ttransformedTangent = - transformedTangent;\\n\\t#endif\\n#endif\";\n\nvar displacementmap_pars_vertex = \"#ifdef USE_DISPLACEMENTMAP\\n\\tuniform sampler2D displacementMap;\\n\\tuniform float displacementScale;\\n\\tuniform float displacementBias;\\n#endif\";\n\nvar displacementmap_vertex = \"#ifdef USE_DISPLACEMENTMAP\\n\\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, vUv ).x * displacementScale + displacementBias );\\n#endif\";\n\nvar emissivemap_fragment = \"#ifdef USE_EMISSIVEMAP\\n\\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\\n\\temissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\\n\\ttotalEmissiveRadiance *= emissiveColor.rgb;\\n#endif\";\n\nvar emissivemap_pars_fragment = \"#ifdef USE_EMISSIVEMAP\\n\\tuniform sampler2D emissiveMap;\\n#endif\";\n\nvar encodings_fragment = \"gl_FragColor = linearToOutputTexel( gl_FragColor );\";\n\nvar encodings_pars_fragment = \"\\nvec4 LinearToLinear( in vec4 value ) {\\n\\treturn value;\\n}\\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\\n\\treturn vec4( pow( value.rgb, vec3( gammaFactor ) ), value.a );\\n}\\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\\n\\treturn vec4( pow( value.rgb, vec3( 1.0 / gammaFactor ) ), value.a );\\n}\\nvec4 sRGBToLinear( in vec4 value ) {\\n\\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.a );\\n}\\nvec4 LinearTosRGB( in vec4 value ) {\\n\\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.a );\\n}\\nvec4 RGBEToLinear( in vec4 value ) {\\n\\treturn vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\\n}\\nvec4 LinearToRGBE( in vec4 value ) {\\n\\tfloat maxComponent = max( max( value.r, value.g ), value.b );\\n\\tfloat fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\\n\\treturn vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\\n}\\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\\n\\treturn vec4( value.rgb * value.a * maxRange, 1.0 );\\n}\\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\\n\\tfloat maxRGB = max( value.r, max( value.g, value.b ) );\\n\\tfloat M = clamp( maxRGB / maxRange, 0.0, 1.0 );\\n\\tM = ceil( M * 255.0 ) / 255.0;\\n\\treturn vec4( value.rgb / ( M * maxRange ), M );\\n}\\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\\n\\treturn vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\\n}\\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\\n\\tfloat maxRGB = max( value.r, max( value.g, value.b ) );\\n\\tfloat D = max( maxRange / maxRGB, 1.0 );\\n\\tD = clamp( floor( D ) / 255.0, 0.0, 1.0 );\\n\\treturn vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\\n}\\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\\nvec4 LinearToLogLuv( in vec4 value ) {\\n\\tvec3 Xp_Y_XYZp = cLogLuvM * value.rgb;\\n\\tXp_Y_XYZp = max( Xp_Y_XYZp, vec3( 1e-6, 1e-6, 1e-6 ) );\\n\\tvec4 vResult;\\n\\tvResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\\n\\tfloat Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\\n\\tvResult.w = fract( Le );\\n\\tvResult.z = ( Le - ( floor( vResult.w * 255.0 ) ) / 255.0 ) / 255.0;\\n\\treturn vResult;\\n}\\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\\nvec4 LogLuvToLinear( in vec4 value ) {\\n\\tfloat Le = value.z * 255.0 + value.w;\\n\\tvec3 Xp_Y_XYZp;\\n\\tXp_Y_XYZp.y = exp2( ( Le - 127.0 ) / 2.0 );\\n\\tXp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\\n\\tXp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\\n\\tvec3 vRGB = cLogLuvInverseM * Xp_Y_XYZp.rgb;\\n\\treturn vec4( max( vRGB, 0.0 ), 1.0 );\\n}\";\n\nvar envmap_fragment = \"#ifdef USE_ENVMAP\\n\\t#ifdef ENV_WORLDPOS\\n\\t\\tvec3 cameraToFrag;\\n\\t\\tif ( isOrthographic ) {\\n\\t\\t\\tcameraToFrag = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\\n\\t\\t} else {\\n\\t\\t\\tcameraToFrag = normalize( vWorldPosition - cameraPosition );\\n\\t\\t}\\n\\t\\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\\n\\t\\t#ifdef ENVMAP_MODE_REFLECTION\\n\\t\\t\\tvec3 reflectVec = reflect( cameraToFrag, worldNormal );\\n\\t\\t#else\\n\\t\\t\\tvec3 reflectVec = refract( cameraToFrag, worldNormal, refractionRatio );\\n\\t\\t#endif\\n\\t#else\\n\\t\\tvec3 reflectVec = vReflect;\\n\\t#endif\\n\\t#ifdef ENVMAP_TYPE_CUBE\\n\\t\\tvec4 envColor = textureCube( envMap, vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\\n\\t#elif defined( ENVMAP_TYPE_CUBE_UV )\\n\\t\\tvec4 envColor = textureCubeUV( envMap, reflectVec, 0.0 );\\n\\t#else\\n\\t\\tvec4 envColor = vec4( 0.0 );\\n\\t#endif\\n\\t#ifndef ENVMAP_TYPE_CUBE_UV\\n\\t\\tenvColor = envMapTexelToLinear( envColor );\\n\\t#endif\\n\\t#ifdef ENVMAP_BLENDING_MULTIPLY\\n\\t\\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\\n\\t#elif defined( ENVMAP_BLENDING_MIX )\\n\\t\\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\\n\\t#elif defined( ENVMAP_BLENDING_ADD )\\n\\t\\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\\n\\t#endif\\n#endif\";\n\nvar envmap_common_pars_fragment = \"#ifdef USE_ENVMAP\\n\\tuniform float envMapIntensity;\\n\\tuniform float flipEnvMap;\\n\\tuniform int maxMipLevel;\\n\\t#ifdef ENVMAP_TYPE_CUBE\\n\\t\\tuniform samplerCube envMap;\\n\\t#else\\n\\t\\tuniform sampler2D envMap;\\n\\t#endif\\n\\t\\n#endif\";\n\nvar envmap_pars_fragment = \"#ifdef USE_ENVMAP\\n\\tuniform float reflectivity;\\n\\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\\n\\t\\t#define ENV_WORLDPOS\\n\\t#endif\\n\\t#ifdef ENV_WORLDPOS\\n\\t\\tvarying vec3 vWorldPosition;\\n\\t\\tuniform float refractionRatio;\\n\\t#else\\n\\t\\tvarying vec3 vReflect;\\n\\t#endif\\n#endif\";\n\nvar envmap_pars_vertex = \"#ifdef USE_ENVMAP\\n\\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) ||defined( PHONG )\\n\\t\\t#define ENV_WORLDPOS\\n\\t#endif\\n\\t#ifdef ENV_WORLDPOS\\n\\t\\t\\n\\t\\tvarying vec3 vWorldPosition;\\n\\t#else\\n\\t\\tvarying vec3 vReflect;\\n\\t\\tuniform float refractionRatio;\\n\\t#endif\\n#endif\";\n\nvar envmap_vertex = \"#ifdef USE_ENVMAP\\n\\t#ifdef ENV_WORLDPOS\\n\\t\\tvWorldPosition = worldPosition.xyz;\\n\\t#else\\n\\t\\tvec3 cameraToVertex;\\n\\t\\tif ( isOrthographic ) {\\n\\t\\t\\tcameraToVertex = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\\n\\t\\t} else {\\n\\t\\t\\tcameraToVertex = normalize( worldPosition.xyz - cameraPosition );\\n\\t\\t}\\n\\t\\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\\n\\t\\t#ifdef ENVMAP_MODE_REFLECTION\\n\\t\\t\\tvReflect = reflect( cameraToVertex, worldNormal );\\n\\t\\t#else\\n\\t\\t\\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\\n\\t\\t#endif\\n\\t#endif\\n#endif\";\n\nvar fog_vertex = \"#ifdef USE_FOG\\n\\tfogDepth = - mvPosition.z;\\n#endif\";\n\nvar fog_pars_vertex = \"#ifdef USE_FOG\\n\\tvarying float fogDepth;\\n#endif\";\n\nvar fog_fragment = \"#ifdef USE_FOG\\n\\t#ifdef FOG_EXP2\\n\\t\\tfloat fogFactor = 1.0 - exp( - fogDensity * fogDensity * fogDepth * fogDepth );\\n\\t#else\\n\\t\\tfloat fogFactor = smoothstep( fogNear, fogFar, fogDepth );\\n\\t#endif\\n\\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\\n#endif\";\n\nvar fog_pars_fragment = \"#ifdef USE_FOG\\n\\tuniform vec3 fogColor;\\n\\tvarying float fogDepth;\\n\\t#ifdef FOG_EXP2\\n\\t\\tuniform float fogDensity;\\n\\t#else\\n\\t\\tuniform float fogNear;\\n\\t\\tuniform float fogFar;\\n\\t#endif\\n#endif\";\n\nvar gradientmap_pars_fragment = \"#ifdef USE_GRADIENTMAP\\n\\tuniform sampler2D gradientMap;\\n#endif\\nvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\\n\\tfloat dotNL = dot( normal, lightDirection );\\n\\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\\n\\t#ifdef USE_GRADIENTMAP\\n\\t\\treturn texture2D( gradientMap, coord ).rgb;\\n\\t#else\\n\\t\\treturn ( coord.x < 0.7 ) ? vec3( 0.7 ) : vec3( 1.0 );\\n\\t#endif\\n}\";\n\nvar lightmap_fragment = \"#ifdef USE_LIGHTMAP\\n\\tvec4 lightMapTexel= texture2D( lightMap, vUv2 );\\n\\treflectedLight.indirectDiffuse += PI * lightMapTexelToLinear( lightMapTexel ).rgb * lightMapIntensity;\\n#endif\";\n\nvar lightmap_pars_fragment = \"#ifdef USE_LIGHTMAP\\n\\tuniform sampler2D lightMap;\\n\\tuniform float lightMapIntensity;\\n#endif\";\n\nvar lights_lambert_vertex = \"vec3 diffuse = vec3( 1.0 );\\nGeometricContext geometry;\\ngeometry.position = mvPosition.xyz;\\ngeometry.normal = normalize( transformedNormal );\\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( -mvPosition.xyz );\\nGeometricContext backGeometry;\\nbackGeometry.position = geometry.position;\\nbackGeometry.normal = -geometry.normal;\\nbackGeometry.viewDir = geometry.viewDir;\\nvLightFront = vec3( 0.0 );\\nvIndirectFront = vec3( 0.0 );\\n#ifdef DOUBLE_SIDED\\n\\tvLightBack = vec3( 0.0 );\\n\\tvIndirectBack = vec3( 0.0 );\\n#endif\\nIncidentLight directLight;\\nfloat dotNL;\\nvec3 directLightColor_Diffuse;\\nvIndirectFront += getAmbientLightIrradiance( ambientLightColor );\\nvIndirectFront += getLightProbeIrradiance( lightProbe, geometry );\\n#ifdef DOUBLE_SIDED\\n\\tvIndirectBack += getAmbientLightIrradiance( ambientLightColor );\\n\\tvIndirectBack += getLightProbeIrradiance( lightProbe, backGeometry );\\n#endif\\n#if NUM_POINT_LIGHTS > 0\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\\n\\t\\tgetPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\\n\\t\\tdotNL = dot( geometry.normal, directLight.direction );\\n\\t\\tdirectLightColor_Diffuse = PI * directLight.color;\\n\\t\\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\\n\\t\\t#ifdef DOUBLE_SIDED\\n\\t\\t\\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\\n\\t\\t#endif\\n\\t}\\n\\t#pragma unroll_loop_end\\n#endif\\n#if NUM_SPOT_LIGHTS > 0\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\\n\\t\\tgetSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\\n\\t\\tdotNL = dot( geometry.normal, directLight.direction );\\n\\t\\tdirectLightColor_Diffuse = PI * directLight.color;\\n\\t\\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\\n\\t\\t#ifdef DOUBLE_SIDED\\n\\t\\t\\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\\n\\t\\t#endif\\n\\t}\\n\\t#pragma unroll_loop_end\\n#endif\\n#if NUM_DIR_LIGHTS > 0\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\\n\\t\\tgetDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\\n\\t\\tdotNL = dot( geometry.normal, directLight.direction );\\n\\t\\tdirectLightColor_Diffuse = PI * directLight.color;\\n\\t\\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\\n\\t\\t#ifdef DOUBLE_SIDED\\n\\t\\t\\tvLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\\n\\t\\t#endif\\n\\t}\\n\\t#pragma unroll_loop_end\\n#endif\\n#if NUM_HEMI_LIGHTS > 0\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\\n\\t\\tvIndirectFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\\n\\t\\t#ifdef DOUBLE_SIDED\\n\\t\\t\\tvIndirectBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\\n\\t\\t#endif\\n\\t}\\n\\t#pragma unroll_loop_end\\n#endif\";\n\nvar lights_pars_begin = \"uniform bool receiveShadow;\\nuniform vec3 ambientLightColor;\\nuniform vec3 lightProbe[ 9 ];\\nvec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {\\n\\tfloat x = normal.x, y = normal.y, z = normal.z;\\n\\tvec3 result = shCoefficients[ 0 ] * 0.886227;\\n\\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;\\n\\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;\\n\\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;\\n\\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;\\n\\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;\\n\\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );\\n\\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;\\n\\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );\\n\\treturn result;\\n}\\nvec3 getLightProbeIrradiance( const in vec3 lightProbe[ 9 ], const in GeometricContext geometry ) {\\n\\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\\n\\tvec3 irradiance = shGetIrradianceAt( worldNormal, lightProbe );\\n\\treturn irradiance;\\n}\\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\\n\\tvec3 irradiance = ambientLightColor;\\n\\t#ifndef PHYSICALLY_CORRECT_LIGHTS\\n\\t\\tirradiance *= PI;\\n\\t#endif\\n\\treturn irradiance;\\n}\\n#if NUM_DIR_LIGHTS > 0\\n\\tstruct DirectionalLight {\\n\\t\\tvec3 direction;\\n\\t\\tvec3 color;\\n\\t};\\n\\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\\n\\tvoid getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\\n\\t\\tdirectLight.color = directionalLight.color;\\n\\t\\tdirectLight.direction = directionalLight.direction;\\n\\t\\tdirectLight.visible = true;\\n\\t}\\n#endif\\n#if NUM_POINT_LIGHTS > 0\\n\\tstruct PointLight {\\n\\t\\tvec3 position;\\n\\t\\tvec3 color;\\n\\t\\tfloat distance;\\n\\t\\tfloat decay;\\n\\t};\\n\\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\\n\\tvoid getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\\n\\t\\tvec3 lVector = pointLight.position - geometry.position;\\n\\t\\tdirectLight.direction = normalize( lVector );\\n\\t\\tfloat lightDistance = length( lVector );\\n\\t\\tdirectLight.color = pointLight.color;\\n\\t\\tdirectLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\\n\\t\\tdirectLight.visible = ( directLight.color != vec3( 0.0 ) );\\n\\t}\\n#endif\\n#if NUM_SPOT_LIGHTS > 0\\n\\tstruct SpotLight {\\n\\t\\tvec3 position;\\n\\t\\tvec3 direction;\\n\\t\\tvec3 color;\\n\\t\\tfloat distance;\\n\\t\\tfloat decay;\\n\\t\\tfloat coneCos;\\n\\t\\tfloat penumbraCos;\\n\\t};\\n\\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\\n\\tvoid getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight ) {\\n\\t\\tvec3 lVector = spotLight.position - geometry.position;\\n\\t\\tdirectLight.direction = normalize( lVector );\\n\\t\\tfloat lightDistance = length( lVector );\\n\\t\\tfloat angleCos = dot( directLight.direction, spotLight.direction );\\n\\t\\tif ( angleCos > spotLight.coneCos ) {\\n\\t\\t\\tfloat spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\\n\\t\\t\\tdirectLight.color = spotLight.color;\\n\\t\\t\\tdirectLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\\n\\t\\t\\tdirectLight.visible = true;\\n\\t\\t} else {\\n\\t\\t\\tdirectLight.color = vec3( 0.0 );\\n\\t\\t\\tdirectLight.visible = false;\\n\\t\\t}\\n\\t}\\n#endif\\n#if NUM_RECT_AREA_LIGHTS > 0\\n\\tstruct RectAreaLight {\\n\\t\\tvec3 color;\\n\\t\\tvec3 position;\\n\\t\\tvec3 halfWidth;\\n\\t\\tvec3 halfHeight;\\n\\t};\\n\\tuniform sampler2D ltc_1;\\tuniform sampler2D ltc_2;\\n\\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\\n#endif\\n#if NUM_HEMI_LIGHTS > 0\\n\\tstruct HemisphereLight {\\n\\t\\tvec3 direction;\\n\\t\\tvec3 skyColor;\\n\\t\\tvec3 groundColor;\\n\\t};\\n\\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\\n\\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\\n\\t\\tfloat dotNL = dot( geometry.normal, hemiLight.direction );\\n\\t\\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\\n\\t\\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\\n\\t\\t#ifndef PHYSICALLY_CORRECT_LIGHTS\\n\\t\\t\\tirradiance *= PI;\\n\\t\\t#endif\\n\\t\\treturn irradiance;\\n\\t}\\n#endif\";\n\nvar envmap_physical_pars_fragment = \"#if defined( USE_ENVMAP )\\n\\t#ifdef ENVMAP_MODE_REFRACTION\\n\\t\\tuniform float refractionRatio;\\n\\t#endif\\n\\tvec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\\n\\t\\tvec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\\n\\t\\t#ifdef ENVMAP_TYPE_CUBE\\n\\t\\t\\tvec3 queryVec = vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\\n\\t\\t\\t#ifdef TEXTURE_LOD_EXT\\n\\t\\t\\t\\tvec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\\n\\t\\t\\t#else\\n\\t\\t\\t\\tvec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\\n\\t\\t\\t#endif\\n\\t\\t\\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\\n\\t\\t#elif defined( ENVMAP_TYPE_CUBE_UV )\\n\\t\\t\\tvec4 envMapColor = textureCubeUV( envMap, worldNormal, 1.0 );\\n\\t\\t#else\\n\\t\\t\\tvec4 envMapColor = vec4( 0.0 );\\n\\t\\t#endif\\n\\t\\treturn PI * envMapColor.rgb * envMapIntensity;\\n\\t}\\n\\tfloat getSpecularMIPLevel( const in float roughness, const in int maxMIPLevel ) {\\n\\t\\tfloat maxMIPLevelScalar = float( maxMIPLevel );\\n\\t\\tfloat sigma = PI * roughness * roughness / ( 1.0 + roughness );\\n\\t\\tfloat desiredMIPLevel = maxMIPLevelScalar + log2( sigma );\\n\\t\\treturn clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\\n\\t}\\n\\tvec3 getLightProbeIndirectRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness, const in int maxMIPLevel ) {\\n\\t\\t#ifdef ENVMAP_MODE_REFLECTION\\n\\t\\t\\tvec3 reflectVec = reflect( -viewDir, normal );\\n\\t\\t\\treflectVec = normalize( mix( reflectVec, normal, roughness * roughness) );\\n\\t\\t#else\\n\\t\\t\\tvec3 reflectVec = refract( -viewDir, normal, refractionRatio );\\n\\t\\t#endif\\n\\t\\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\\n\\t\\tfloat specularMIPLevel = getSpecularMIPLevel( roughness, maxMIPLevel );\\n\\t\\t#ifdef ENVMAP_TYPE_CUBE\\n\\t\\t\\tvec3 queryReflectVec = vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\\n\\t\\t\\t#ifdef TEXTURE_LOD_EXT\\n\\t\\t\\t\\tvec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\\n\\t\\t\\t#else\\n\\t\\t\\t\\tvec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\\n\\t\\t\\t#endif\\n\\t\\t\\tenvMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\\n\\t\\t#elif defined( ENVMAP_TYPE_CUBE_UV )\\n\\t\\t\\tvec4 envMapColor = textureCubeUV( envMap, reflectVec, roughness );\\n\\t\\t#endif\\n\\t\\treturn envMapColor.rgb * envMapIntensity;\\n\\t}\\n#endif\";\n\nvar lights_toon_fragment = \"ToonMaterial material;\\nmaterial.diffuseColor = diffuseColor.rgb;\";\n\nvar lights_toon_pars_fragment = \"varying vec3 vViewPosition;\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n#endif\\nstruct ToonMaterial {\\n\\tvec3 diffuseColor;\\n};\\nvoid RE_Direct_Toon( const in IncidentLight directLight, const in GeometricContext geometry, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\\n\\tvec3 irradiance = getGradientIrradiance( geometry.normal, directLight.direction ) * directLight.color;\\n\\t#ifndef PHYSICALLY_CORRECT_LIGHTS\\n\\t\\tirradiance *= PI;\\n\\t#endif\\n\\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\\n}\\nvoid RE_IndirectDiffuse_Toon( const in vec3 irradiance, const in GeometricContext geometry, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\\n\\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\\n}\\n#define RE_Direct\\t\\t\\t\\tRE_Direct_Toon\\n#define RE_IndirectDiffuse\\t\\tRE_IndirectDiffuse_Toon\\n#define Material_LightProbeLOD( material )\\t(0)\";\n\nvar lights_phong_fragment = \"BlinnPhongMaterial material;\\nmaterial.diffuseColor = diffuseColor.rgb;\\nmaterial.specularColor = specular;\\nmaterial.specularShininess = shininess;\\nmaterial.specularStrength = specularStrength;\";\n\nvar lights_phong_pars_fragment = \"varying vec3 vViewPosition;\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n#endif\\nstruct BlinnPhongMaterial {\\n\\tvec3 diffuseColor;\\n\\tvec3 specularColor;\\n\\tfloat specularShininess;\\n\\tfloat specularStrength;\\n};\\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\\n\\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\\n\\tvec3 irradiance = dotNL * directLight.color;\\n\\t#ifndef PHYSICALLY_CORRECT_LIGHTS\\n\\t\\tirradiance *= PI;\\n\\t#endif\\n\\treflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\\n\\treflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\\n}\\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\\n\\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\\n}\\n#define RE_Direct\\t\\t\\t\\tRE_Direct_BlinnPhong\\n#define RE_IndirectDiffuse\\t\\tRE_IndirectDiffuse_BlinnPhong\\n#define Material_LightProbeLOD( material )\\t(0)\";\n\nvar lights_physical_fragment = \"PhysicalMaterial material;\\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\\nvec3 dxy = max( abs( dFdx( geometryNormal ) ), abs( dFdy( geometryNormal ) ) );\\nfloat geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );\\nmaterial.specularRoughness = max( roughnessFactor, 0.0525 );material.specularRoughness += geometryRoughness;\\nmaterial.specularRoughness = min( material.specularRoughness, 1.0 );\\n#ifdef REFLECTIVITY\\n\\tmaterial.specularColor = mix( vec3( MAXIMUM_SPECULAR_COEFFICIENT * pow2( reflectivity ) ), rawDiffuseColor, metalnessFactor );\\n#else\\n\\tmaterial.specularColor = mix( vec3( DEFAULT_SPECULAR_COEFFICIENT ), rawDiffuseColor, metalnessFactor );\\n#endif\\n#ifdef CLEARCOAT\\n\\tmaterial.clearcoat = clearcoat;\\n\\tmaterial.clearcoatRoughness = clearcoatRoughness;\\n\\t#ifdef USE_CLEARCOATMAP\\n\\t\\tmaterial.clearcoat *= texture2D( clearcoatMap, vUv ).x;\\n\\t#endif\\n\\t#ifdef USE_CLEARCOAT_ROUGHNESSMAP\\n\\t\\tmaterial.clearcoatRoughness *= texture2D( clearcoatRoughnessMap, vUv ).y;\\n\\t#endif\\n\\tmaterial.clearcoat = saturate( material.clearcoat );\\tmaterial.clearcoatRoughness = max( material.clearcoatRoughness, 0.0525 );\\n\\tmaterial.clearcoatRoughness += geometryRoughness;\\n\\tmaterial.clearcoatRoughness = min( material.clearcoatRoughness, 1.0 );\\n#endif\\n#ifdef USE_SHEEN\\n\\tmaterial.sheenColor = sheen;\\n#endif\";\n\nvar lights_physical_pars_fragment = \"struct PhysicalMaterial {\\n\\tvec3 diffuseColor;\\n\\tfloat specularRoughness;\\n\\tvec3 specularColor;\\n#ifdef CLEARCOAT\\n\\tfloat clearcoat;\\n\\tfloat clearcoatRoughness;\\n#endif\\n#ifdef USE_SHEEN\\n\\tvec3 sheenColor;\\n#endif\\n};\\n#define MAXIMUM_SPECULAR_COEFFICIENT 0.16\\n#define DEFAULT_SPECULAR_COEFFICIENT 0.04\\nfloat clearcoatDHRApprox( const in float roughness, const in float dotNL ) {\\n\\treturn DEFAULT_SPECULAR_COEFFICIENT + ( 1.0 - DEFAULT_SPECULAR_COEFFICIENT ) * ( pow( 1.0 - dotNL, 5.0 ) * pow( 1.0 - roughness, 2.0 ) );\\n}\\n#if NUM_RECT_AREA_LIGHTS > 0\\n\\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\\n\\t\\tvec3 normal = geometry.normal;\\n\\t\\tvec3 viewDir = geometry.viewDir;\\n\\t\\tvec3 position = geometry.position;\\n\\t\\tvec3 lightPos = rectAreaLight.position;\\n\\t\\tvec3 halfWidth = rectAreaLight.halfWidth;\\n\\t\\tvec3 halfHeight = rectAreaLight.halfHeight;\\n\\t\\tvec3 lightColor = rectAreaLight.color;\\n\\t\\tfloat roughness = material.specularRoughness;\\n\\t\\tvec3 rectCoords[ 4 ];\\n\\t\\trectCoords[ 0 ] = lightPos + halfWidth - halfHeight;\\t\\trectCoords[ 1 ] = lightPos - halfWidth - halfHeight;\\n\\t\\trectCoords[ 2 ] = lightPos - halfWidth + halfHeight;\\n\\t\\trectCoords[ 3 ] = lightPos + halfWidth + halfHeight;\\n\\t\\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\\n\\t\\tvec4 t1 = texture2D( ltc_1, uv );\\n\\t\\tvec4 t2 = texture2D( ltc_2, uv );\\n\\t\\tmat3 mInv = mat3(\\n\\t\\t\\tvec3( t1.x, 0, t1.y ),\\n\\t\\t\\tvec3(    0, 1,    0 ),\\n\\t\\t\\tvec3( t1.z, 0, t1.w )\\n\\t\\t);\\n\\t\\tvec3 fresnel = ( material.specularColor * t2.x + ( vec3( 1.0 ) - material.specularColor ) * t2.y );\\n\\t\\treflectedLight.directSpecular += lightColor * fresnel * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\\n\\t\\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1.0 ), rectCoords );\\n\\t}\\n#endif\\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\\n\\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\\n\\tvec3 irradiance = dotNL * directLight.color;\\n\\t#ifndef PHYSICALLY_CORRECT_LIGHTS\\n\\t\\tirradiance *= PI;\\n\\t#endif\\n\\t#ifdef CLEARCOAT\\n\\t\\tfloat ccDotNL = saturate( dot( geometry.clearcoatNormal, directLight.direction ) );\\n\\t\\tvec3 ccIrradiance = ccDotNL * directLight.color;\\n\\t\\t#ifndef PHYSICALLY_CORRECT_LIGHTS\\n\\t\\t\\tccIrradiance *= PI;\\n\\t\\t#endif\\n\\t\\tfloat clearcoatDHR = material.clearcoat * clearcoatDHRApprox( material.clearcoatRoughness, ccDotNL );\\n\\t\\treflectedLight.directSpecular += ccIrradiance * material.clearcoat * BRDF_Specular_GGX( directLight, geometry.viewDir, geometry.clearcoatNormal, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearcoatRoughness );\\n\\t#else\\n\\t\\tfloat clearcoatDHR = 0.0;\\n\\t#endif\\n\\t#ifdef USE_SHEEN\\n\\t\\treflectedLight.directSpecular += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Specular_Sheen(\\n\\t\\t\\tmaterial.specularRoughness,\\n\\t\\t\\tdirectLight.direction,\\n\\t\\t\\tgeometry,\\n\\t\\t\\tmaterial.sheenColor\\n\\t\\t);\\n\\t#else\\n\\t\\treflectedLight.directSpecular += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Specular_GGX( directLight, geometry.viewDir, geometry.normal, material.specularColor, material.specularRoughness);\\n\\t#endif\\n\\treflectedLight.directDiffuse += ( 1.0 - clearcoatDHR ) * irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\\n}\\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\\n\\treflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\\n}\\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in vec3 clearcoatRadiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight) {\\n\\t#ifdef CLEARCOAT\\n\\t\\tfloat ccDotNV = saturate( dot( geometry.clearcoatNormal, geometry.viewDir ) );\\n\\t\\treflectedLight.indirectSpecular += clearcoatRadiance * material.clearcoat * BRDF_Specular_GGX_Environment( geometry.viewDir, geometry.clearcoatNormal, vec3( DEFAULT_SPECULAR_COEFFICIENT ), material.clearcoatRoughness );\\n\\t\\tfloat ccDotNL = ccDotNV;\\n\\t\\tfloat clearcoatDHR = material.clearcoat * clearcoatDHRApprox( material.clearcoatRoughness, ccDotNL );\\n\\t#else\\n\\t\\tfloat clearcoatDHR = 0.0;\\n\\t#endif\\n\\tfloat clearcoatInv = 1.0 - clearcoatDHR;\\n\\tvec3 singleScattering = vec3( 0.0 );\\n\\tvec3 multiScattering = vec3( 0.0 );\\n\\tvec3 cosineWeightedIrradiance = irradiance * RECIPROCAL_PI;\\n\\tBRDF_Specular_Multiscattering_Environment( geometry, material.specularColor, material.specularRoughness, singleScattering, multiScattering );\\n\\tvec3 diffuse = material.diffuseColor * ( 1.0 - ( singleScattering + multiScattering ) );\\n\\treflectedLight.indirectSpecular += clearcoatInv * radiance * singleScattering;\\n\\treflectedLight.indirectSpecular += multiScattering * cosineWeightedIrradiance;\\n\\treflectedLight.indirectDiffuse += diffuse * cosineWeightedIrradiance;\\n}\\n#define RE_Direct\\t\\t\\t\\tRE_Direct_Physical\\n#define RE_Direct_RectArea\\t\\tRE_Direct_RectArea_Physical\\n#define RE_IndirectDiffuse\\t\\tRE_IndirectDiffuse_Physical\\n#define RE_IndirectSpecular\\t\\tRE_IndirectSpecular_Physical\\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\\n\\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\\n}\";\n\nvar lights_fragment_begin = \"\\nGeometricContext geometry;\\ngeometry.position = - vViewPosition;\\ngeometry.normal = normal;\\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\\n#ifdef CLEARCOAT\\n\\tgeometry.clearcoatNormal = clearcoatNormal;\\n#endif\\nIncidentLight directLight;\\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\\n\\tPointLight pointLight;\\n\\t#if defined( USE_SHADOWMAP ) && NUM_POINT_LIGHT_SHADOWS > 0\\n\\tPointLightShadow pointLightShadow;\\n\\t#endif\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\\n\\t\\tpointLight = pointLights[ i ];\\n\\t\\tgetPointDirectLightIrradiance( pointLight, geometry, directLight );\\n\\t\\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_POINT_LIGHT_SHADOWS )\\n\\t\\tpointLightShadow = pointLightShadows[ i ];\\n\\t\\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getPointShadow( pointShadowMap[ i ], pointLightShadow.shadowMapSize, pointLightShadow.shadowBias, pointLightShadow.shadowRadius, vPointShadowCoord[ i ], pointLightShadow.shadowCameraNear, pointLightShadow.shadowCameraFar ) : 1.0;\\n\\t\\t#endif\\n\\t\\tRE_Direct( directLight, geometry, material, reflectedLight );\\n\\t}\\n\\t#pragma unroll_loop_end\\n#endif\\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\\n\\tSpotLight spotLight;\\n\\t#if defined( USE_SHADOWMAP ) && NUM_SPOT_LIGHT_SHADOWS > 0\\n\\tSpotLightShadow spotLightShadow;\\n\\t#endif\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\\n\\t\\tspotLight = spotLights[ i ];\\n\\t\\tgetSpotDirectLightIrradiance( spotLight, geometry, directLight );\\n\\t\\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\\n\\t\\tspotLightShadow = spotLightShadows[ i ];\\n\\t\\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getShadow( spotShadowMap[ i ], spotLightShadow.shadowMapSize, spotLightShadow.shadowBias, spotLightShadow.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\\n\\t\\t#endif\\n\\t\\tRE_Direct( directLight, geometry, material, reflectedLight );\\n\\t}\\n\\t#pragma unroll_loop_end\\n#endif\\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\\n\\tDirectionalLight directionalLight;\\n\\t#if defined( USE_SHADOWMAP ) && NUM_DIR_LIGHT_SHADOWS > 0\\n\\tDirectionalLightShadow directionalLightShadow;\\n\\t#endif\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\\n\\t\\tdirectionalLight = directionalLights[ i ];\\n\\t\\tgetDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\\n\\t\\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_DIR_LIGHT_SHADOWS )\\n\\t\\tdirectionalLightShadow = directionalLightShadows[ i ];\\n\\t\\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getShadow( directionalShadowMap[ i ], directionalLightShadow.shadowMapSize, directionalLightShadow.shadowBias, directionalLightShadow.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\\n\\t\\t#endif\\n\\t\\tRE_Direct( directLight, geometry, material, reflectedLight );\\n\\t}\\n\\t#pragma unroll_loop_end\\n#endif\\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\\n\\tRectAreaLight rectAreaLight;\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\\n\\t\\trectAreaLight = rectAreaLights[ i ];\\n\\t\\tRE_Direct_RectArea( rectAreaLight, geometry, material, reflectedLight );\\n\\t}\\n\\t#pragma unroll_loop_end\\n#endif\\n#if defined( RE_IndirectDiffuse )\\n\\tvec3 iblIrradiance = vec3( 0.0 );\\n\\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\\n\\tirradiance += getLightProbeIrradiance( lightProbe, geometry );\\n\\t#if ( NUM_HEMI_LIGHTS > 0 )\\n\\t\\t#pragma unroll_loop_start\\n\\t\\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\\n\\t\\t\\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\\n\\t\\t}\\n\\t\\t#pragma unroll_loop_end\\n\\t#endif\\n#endif\\n#if defined( RE_IndirectSpecular )\\n\\tvec3 radiance = vec3( 0.0 );\\n\\tvec3 clearcoatRadiance = vec3( 0.0 );\\n#endif\";\n\nvar lights_fragment_maps = \"#if defined( RE_IndirectDiffuse )\\n\\t#ifdef USE_LIGHTMAP\\n\\t\\tvec4 lightMapTexel= texture2D( lightMap, vUv2 );\\n\\t\\tvec3 lightMapIrradiance = lightMapTexelToLinear( lightMapTexel ).rgb * lightMapIntensity;\\n\\t\\t#ifndef PHYSICALLY_CORRECT_LIGHTS\\n\\t\\t\\tlightMapIrradiance *= PI;\\n\\t\\t#endif\\n\\t\\tirradiance += lightMapIrradiance;\\n\\t#endif\\n\\t#if defined( USE_ENVMAP ) && defined( STANDARD ) && defined( ENVMAP_TYPE_CUBE_UV )\\n\\t\\tiblIrradiance += getLightProbeIndirectIrradiance( geometry, maxMipLevel );\\n\\t#endif\\n#endif\\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\\n\\tradiance += getLightProbeIndirectRadiance( geometry.viewDir, geometry.normal, material.specularRoughness, maxMipLevel );\\n\\t#ifdef CLEARCOAT\\n\\t\\tclearcoatRadiance += getLightProbeIndirectRadiance( geometry.viewDir, geometry.clearcoatNormal, material.clearcoatRoughness, maxMipLevel );\\n\\t#endif\\n#endif\";\n\nvar lights_fragment_end = \"#if defined( RE_IndirectDiffuse )\\n\\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\\n#endif\\n#if defined( RE_IndirectSpecular )\\n\\tRE_IndirectSpecular( radiance, iblIrradiance, clearcoatRadiance, geometry, material, reflectedLight );\\n#endif\";\n\nvar logdepthbuf_fragment = \"#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\\n\\tgl_FragDepthEXT = vIsPerspective == 0.0 ? gl_FragCoord.z : log2( vFragDepth ) * logDepthBufFC * 0.5;\\n#endif\";\n\nvar logdepthbuf_pars_fragment = \"#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\\n\\tuniform float logDepthBufFC;\\n\\tvarying float vFragDepth;\\n\\tvarying float vIsPerspective;\\n#endif\";\n\nvar logdepthbuf_pars_vertex = \"#ifdef USE_LOGDEPTHBUF\\n\\t#ifdef USE_LOGDEPTHBUF_EXT\\n\\t\\tvarying float vFragDepth;\\n\\t\\tvarying float vIsPerspective;\\n\\t#else\\n\\t\\tuniform float logDepthBufFC;\\n\\t#endif\\n#endif\";\n\nvar logdepthbuf_vertex = \"#ifdef USE_LOGDEPTHBUF\\n\\t#ifdef USE_LOGDEPTHBUF_EXT\\n\\t\\tvFragDepth = 1.0 + gl_Position.w;\\n\\t\\tvIsPerspective = float( isPerspectiveMatrix( projectionMatrix ) );\\n\\t#else\\n\\t\\tif ( isPerspectiveMatrix( projectionMatrix ) ) {\\n\\t\\t\\tgl_Position.z = log2( max( EPSILON, gl_Position.w + 1.0 ) ) * logDepthBufFC - 1.0;\\n\\t\\t\\tgl_Position.z *= gl_Position.w;\\n\\t\\t}\\n\\t#endif\\n#endif\";\n\nvar map_fragment = \"#ifdef USE_MAP\\n\\tvec4 texelColor = texture2D( map, vUv );\\n\\ttexelColor = mapTexelToLinear( texelColor );\\n\\tdiffuseColor *= texelColor;\\n#endif\";\n\nvar map_pars_fragment = \"#ifdef USE_MAP\\n\\tuniform sampler2D map;\\n#endif\";\n\nvar map_particle_fragment = \"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\\n\\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\\n#endif\\n#ifdef USE_MAP\\n\\tvec4 mapTexel = texture2D( map, uv );\\n\\tdiffuseColor *= mapTexelToLinear( mapTexel );\\n#endif\\n#ifdef USE_ALPHAMAP\\n\\tdiffuseColor.a *= texture2D( alphaMap, uv ).g;\\n#endif\";\n\nvar map_particle_pars_fragment = \"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\\n\\tuniform mat3 uvTransform;\\n#endif\\n#ifdef USE_MAP\\n\\tuniform sampler2D map;\\n#endif\\n#ifdef USE_ALPHAMAP\\n\\tuniform sampler2D alphaMap;\\n#endif\";\n\nvar metalnessmap_fragment = \"float metalnessFactor = metalness;\\n#ifdef USE_METALNESSMAP\\n\\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\\n\\tmetalnessFactor *= texelMetalness.b;\\n#endif\";\n\nvar metalnessmap_pars_fragment = \"#ifdef USE_METALNESSMAP\\n\\tuniform sampler2D metalnessMap;\\n#endif\";\n\nvar morphnormal_vertex = \"#ifdef USE_MORPHNORMALS\\n\\tobjectNormal *= morphTargetBaseInfluence;\\n\\tobjectNormal += morphNormal0 * morphTargetInfluences[ 0 ];\\n\\tobjectNormal += morphNormal1 * morphTargetInfluences[ 1 ];\\n\\tobjectNormal += morphNormal2 * morphTargetInfluences[ 2 ];\\n\\tobjectNormal += morphNormal3 * morphTargetInfluences[ 3 ];\\n#endif\";\n\nvar morphtarget_pars_vertex = \"#ifdef USE_MORPHTARGETS\\n\\tuniform float morphTargetBaseInfluence;\\n\\t#ifndef USE_MORPHNORMALS\\n\\t\\tuniform float morphTargetInfluences[ 8 ];\\n\\t#else\\n\\t\\tuniform float morphTargetInfluences[ 4 ];\\n\\t#endif\\n#endif\";\n\nvar morphtarget_vertex = \"#ifdef USE_MORPHTARGETS\\n\\ttransformed *= morphTargetBaseInfluence;\\n\\ttransformed += morphTarget0 * morphTargetInfluences[ 0 ];\\n\\ttransformed += morphTarget1 * morphTargetInfluences[ 1 ];\\n\\ttransformed += morphTarget2 * morphTargetInfluences[ 2 ];\\n\\ttransformed += morphTarget3 * morphTargetInfluences[ 3 ];\\n\\t#ifndef USE_MORPHNORMALS\\n\\t\\ttransformed += morphTarget4 * morphTargetInfluences[ 4 ];\\n\\t\\ttransformed += morphTarget5 * morphTargetInfluences[ 5 ];\\n\\t\\ttransformed += morphTarget6 * morphTargetInfluences[ 6 ];\\n\\t\\ttransformed += morphTarget7 * morphTargetInfluences[ 7 ];\\n\\t#endif\\n#endif\";\n\nvar normal_fragment_begin = \"float faceDirection = gl_FrontFacing ? 1.0 : - 1.0;\\n#ifdef FLAT_SHADED\\n\\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\\n\\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\\n\\tvec3 normal = normalize( cross( fdx, fdy ) );\\n#else\\n\\tvec3 normal = normalize( vNormal );\\n\\t#ifdef DOUBLE_SIDED\\n\\t\\tnormal = normal * faceDirection;\\n\\t#endif\\n\\t#ifdef USE_TANGENT\\n\\t\\tvec3 tangent = normalize( vTangent );\\n\\t\\tvec3 bitangent = normalize( vBitangent );\\n\\t\\t#ifdef DOUBLE_SIDED\\n\\t\\t\\ttangent = tangent * faceDirection;\\n\\t\\t\\tbitangent = bitangent * faceDirection;\\n\\t\\t#endif\\n\\t\\t#if defined( TANGENTSPACE_NORMALMAP ) || defined( USE_CLEARCOAT_NORMALMAP )\\n\\t\\t\\tmat3 vTBN = mat3( tangent, bitangent, normal );\\n\\t\\t#endif\\n\\t#endif\\n#endif\\nvec3 geometryNormal = normal;\";\n\nvar normal_fragment_maps = \"#ifdef OBJECTSPACE_NORMALMAP\\n\\tnormal = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\\n\\t#ifdef FLIP_SIDED\\n\\t\\tnormal = - normal;\\n\\t#endif\\n\\t#ifdef DOUBLE_SIDED\\n\\t\\tnormal = normal * faceDirection;\\n\\t#endif\\n\\tnormal = normalize( normalMatrix * normal );\\n#elif defined( TANGENTSPACE_NORMALMAP )\\n\\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\\n\\tmapN.xy *= normalScale;\\n\\t#ifdef USE_TANGENT\\n\\t\\tnormal = normalize( vTBN * mapN );\\n\\t#else\\n\\t\\tnormal = perturbNormal2Arb( -vViewPosition, normal, mapN, faceDirection );\\n\\t#endif\\n#elif defined( USE_BUMPMAP )\\n\\tnormal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd(), faceDirection );\\n#endif\";\n\nvar normalmap_pars_fragment = \"#ifdef USE_NORMALMAP\\n\\tuniform sampler2D normalMap;\\n\\tuniform vec2 normalScale;\\n#endif\\n#ifdef OBJECTSPACE_NORMALMAP\\n\\tuniform mat3 normalMatrix;\\n#endif\\n#if ! defined ( USE_TANGENT ) && ( defined ( TANGENTSPACE_NORMALMAP ) || defined ( USE_CLEARCOAT_NORMALMAP ) )\\n\\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm, vec3 mapN, float faceDirection ) {\\n\\t\\tvec3 q0 = vec3( dFdx( eye_pos.x ), dFdx( eye_pos.y ), dFdx( eye_pos.z ) );\\n\\t\\tvec3 q1 = vec3( dFdy( eye_pos.x ), dFdy( eye_pos.y ), dFdy( eye_pos.z ) );\\n\\t\\tvec2 st0 = dFdx( vUv.st );\\n\\t\\tvec2 st1 = dFdy( vUv.st );\\n\\t\\tvec3 N = surf_norm;\\n\\t\\tvec3 q1perp = cross( q1, N );\\n\\t\\tvec3 q0perp = cross( N, q0 );\\n\\t\\tvec3 T = q1perp * st0.x + q0perp * st1.x;\\n\\t\\tvec3 B = q1perp * st0.y + q0perp * st1.y;\\n\\t\\tfloat det = max( dot( T, T ), dot( B, B ) );\\n\\t\\tfloat scale = ( det == 0.0 ) ? 0.0 : faceDirection * inversesqrt( det );\\n\\t\\treturn normalize( T * ( mapN.x * scale ) + B * ( mapN.y * scale ) + N * mapN.z );\\n\\t}\\n#endif\";\n\nvar clearcoat_normal_fragment_begin = \"#ifdef CLEARCOAT\\n\\tvec3 clearcoatNormal = geometryNormal;\\n#endif\";\n\nvar clearcoat_normal_fragment_maps = \"#ifdef USE_CLEARCOAT_NORMALMAP\\n\\tvec3 clearcoatMapN = texture2D( clearcoatNormalMap, vUv ).xyz * 2.0 - 1.0;\\n\\tclearcoatMapN.xy *= clearcoatNormalScale;\\n\\t#ifdef USE_TANGENT\\n\\t\\tclearcoatNormal = normalize( vTBN * clearcoatMapN );\\n\\t#else\\n\\t\\tclearcoatNormal = perturbNormal2Arb( - vViewPosition, clearcoatNormal, clearcoatMapN, faceDirection );\\n\\t#endif\\n#endif\";\n\nvar clearcoat_pars_fragment = \"#ifdef USE_CLEARCOATMAP\\n\\tuniform sampler2D clearcoatMap;\\n#endif\\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\\n\\tuniform sampler2D clearcoatRoughnessMap;\\n#endif\\n#ifdef USE_CLEARCOAT_NORMALMAP\\n\\tuniform sampler2D clearcoatNormalMap;\\n\\tuniform vec2 clearcoatNormalScale;\\n#endif\";\n\nvar packing = \"vec3 packNormalToRGB( const in vec3 normal ) {\\n\\treturn normalize( normal ) * 0.5 + 0.5;\\n}\\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\\n\\treturn 2.0 * rgb.xyz - 1.0;\\n}\\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256., 256. );\\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\\nconst float ShiftRight8 = 1. / 256.;\\nvec4 packDepthToRGBA( const in float v ) {\\n\\tvec4 r = vec4( fract( v * PackFactors ), v );\\n\\tr.yzw -= r.xyz * ShiftRight8;\\treturn r * PackUpscale;\\n}\\nfloat unpackRGBAToDepth( const in vec4 v ) {\\n\\treturn dot( v, UnpackFactors );\\n}\\nvec4 pack2HalfToRGBA( vec2 v ) {\\n\\tvec4 r = vec4( v.x, fract( v.x * 255.0 ), v.y, fract( v.y * 255.0 ));\\n\\treturn vec4( r.x - r.y / 255.0, r.y, r.z - r.w / 255.0, r.w);\\n}\\nvec2 unpackRGBATo2Half( vec4 v ) {\\n\\treturn vec2( v.x + ( v.y / 255.0 ), v.z + ( v.w / 255.0 ) );\\n}\\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\\n\\treturn ( viewZ + near ) / ( near - far );\\n}\\nfloat orthographicDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\\n\\treturn linearClipZ * ( near - far ) - near;\\n}\\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\\n\\treturn (( near + viewZ ) * far ) / (( far - near ) * viewZ );\\n}\\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\\n\\treturn ( near * far ) / ( ( far - near ) * invClipZ - far );\\n}\";\n\nvar premultiplied_alpha_fragment = \"#ifdef PREMULTIPLIED_ALPHA\\n\\tgl_FragColor.rgb *= gl_FragColor.a;\\n#endif\";\n\nvar project_vertex = \"vec4 mvPosition = vec4( transformed, 1.0 );\\n#ifdef USE_INSTANCING\\n\\tmvPosition = instanceMatrix * mvPosition;\\n#endif\\nmvPosition = modelViewMatrix * mvPosition;\\ngl_Position = projectionMatrix * mvPosition;\";\n\nvar dithering_fragment = \"#ifdef DITHERING\\n\\tgl_FragColor.rgb = dithering( gl_FragColor.rgb );\\n#endif\";\n\nvar dithering_pars_fragment = \"#ifdef DITHERING\\n\\tvec3 dithering( vec3 color ) {\\n\\t\\tfloat grid_position = rand( gl_FragCoord.xy );\\n\\t\\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\\n\\t\\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\\n\\t\\treturn color + dither_shift_RGB;\\n\\t}\\n#endif\";\n\nvar roughnessmap_fragment = \"float roughnessFactor = roughness;\\n#ifdef USE_ROUGHNESSMAP\\n\\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\\n\\troughnessFactor *= texelRoughness.g;\\n#endif\";\n\nvar roughnessmap_pars_fragment = \"#ifdef USE_ROUGHNESSMAP\\n\\tuniform sampler2D roughnessMap;\\n#endif\";\n\nvar shadowmap_pars_fragment = \"#ifdef USE_SHADOWMAP\\n\\t#if NUM_DIR_LIGHT_SHADOWS > 0\\n\\t\\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\\n\\t\\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\\n\\t\\tstruct DirectionalLightShadow {\\n\\t\\t\\tfloat shadowBias;\\n\\t\\t\\tfloat shadowNormalBias;\\n\\t\\t\\tfloat shadowRadius;\\n\\t\\t\\tvec2 shadowMapSize;\\n\\t\\t};\\n\\t\\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\\n\\t#endif\\n\\t#if NUM_SPOT_LIGHT_SHADOWS > 0\\n\\t\\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\\n\\t\\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\\n\\t\\tstruct SpotLightShadow {\\n\\t\\t\\tfloat shadowBias;\\n\\t\\t\\tfloat shadowNormalBias;\\n\\t\\t\\tfloat shadowRadius;\\n\\t\\t\\tvec2 shadowMapSize;\\n\\t\\t};\\n\\t\\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\\n\\t#endif\\n\\t#if NUM_POINT_LIGHT_SHADOWS > 0\\n\\t\\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\\n\\t\\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\\n\\t\\tstruct PointLightShadow {\\n\\t\\t\\tfloat shadowBias;\\n\\t\\t\\tfloat shadowNormalBias;\\n\\t\\t\\tfloat shadowRadius;\\n\\t\\t\\tvec2 shadowMapSize;\\n\\t\\t\\tfloat shadowCameraNear;\\n\\t\\t\\tfloat shadowCameraFar;\\n\\t\\t};\\n\\t\\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\\n\\t#endif\\n\\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\\n\\t\\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\\n\\t}\\n\\tvec2 texture2DDistribution( sampler2D shadow, vec2 uv ) {\\n\\t\\treturn unpackRGBATo2Half( texture2D( shadow, uv ) );\\n\\t}\\n\\tfloat VSMShadow (sampler2D shadow, vec2 uv, float compare ){\\n\\t\\tfloat occlusion = 1.0;\\n\\t\\tvec2 distribution = texture2DDistribution( shadow, uv );\\n\\t\\tfloat hard_shadow = step( compare , distribution.x );\\n\\t\\tif (hard_shadow != 1.0 ) {\\n\\t\\t\\tfloat distance = compare - distribution.x ;\\n\\t\\t\\tfloat variance = max( 0.00000, distribution.y * distribution.y );\\n\\t\\t\\tfloat softness_probability = variance / (variance + distance * distance );\\t\\t\\tsoftness_probability = clamp( ( softness_probability - 0.3 ) / ( 0.95 - 0.3 ), 0.0, 1.0 );\\t\\t\\tocclusion = clamp( max( hard_shadow, softness_probability ), 0.0, 1.0 );\\n\\t\\t}\\n\\t\\treturn occlusion;\\n\\t}\\n\\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\\n\\t\\tfloat shadow = 1.0;\\n\\t\\tshadowCoord.xyz /= shadowCoord.w;\\n\\t\\tshadowCoord.z += shadowBias;\\n\\t\\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\\n\\t\\tbool inFrustum = all( inFrustumVec );\\n\\t\\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\\n\\t\\tbool frustumTest = all( frustumTestVec );\\n\\t\\tif ( frustumTest ) {\\n\\t\\t#if defined( SHADOWMAP_TYPE_PCF )\\n\\t\\t\\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\\n\\t\\t\\tfloat dx0 = - texelSize.x * shadowRadius;\\n\\t\\t\\tfloat dy0 = - texelSize.y * shadowRadius;\\n\\t\\t\\tfloat dx1 = + texelSize.x * shadowRadius;\\n\\t\\t\\tfloat dy1 = + texelSize.y * shadowRadius;\\n\\t\\t\\tfloat dx2 = dx0 / 2.0;\\n\\t\\t\\tfloat dy2 = dy0 / 2.0;\\n\\t\\t\\tfloat dx3 = dx1 / 2.0;\\n\\t\\t\\tfloat dy3 = dy1 / 2.0;\\n\\t\\t\\tshadow = (\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy2 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy2 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy2 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, 0.0 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, 0.0 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy3 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy3 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy3 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\\n\\t\\t\\t) * ( 1.0 / 17.0 );\\n\\t\\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\\n\\t\\t\\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\\n\\t\\t\\tfloat dx = texelSize.x;\\n\\t\\t\\tfloat dy = texelSize.y;\\n\\t\\t\\tvec2 uv = shadowCoord.xy;\\n\\t\\t\\tvec2 f = fract( uv * shadowMapSize + 0.5 );\\n\\t\\t\\tuv -= f * texelSize;\\n\\t\\t\\tshadow = (\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, uv, shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, uv + vec2( dx, 0.0 ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, uv + vec2( 0.0, dy ), shadowCoord.z ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, uv + texelSize, shadowCoord.z ) +\\n\\t\\t\\t\\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, 0.0 ), shadowCoord.z ), \\n\\t\\t\\t\\t\\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 0.0 ), shadowCoord.z ),\\n\\t\\t\\t\\t\\t f.x ) +\\n\\t\\t\\t\\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, dy ), shadowCoord.z ), \\n\\t\\t\\t\\t\\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, dy ), shadowCoord.z ),\\n\\t\\t\\t\\t\\t f.x ) +\\n\\t\\t\\t\\tmix( texture2DCompare( shadowMap, uv + vec2( 0.0, -dy ), shadowCoord.z ), \\n\\t\\t\\t\\t\\t texture2DCompare( shadowMap, uv + vec2( 0.0, 2.0 * dy ), shadowCoord.z ),\\n\\t\\t\\t\\t\\t f.y ) +\\n\\t\\t\\t\\tmix( texture2DCompare( shadowMap, uv + vec2( dx, -dy ), shadowCoord.z ), \\n\\t\\t\\t\\t\\t texture2DCompare( shadowMap, uv + vec2( dx, 2.0 * dy ), shadowCoord.z ),\\n\\t\\t\\t\\t\\t f.y ) +\\n\\t\\t\\t\\tmix( mix( texture2DCompare( shadowMap, uv + vec2( -dx, -dy ), shadowCoord.z ), \\n\\t\\t\\t\\t\\t\\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, -dy ), shadowCoord.z ),\\n\\t\\t\\t\\t\\t\\t  f.x ),\\n\\t\\t\\t\\t\\t mix( texture2DCompare( shadowMap, uv + vec2( -dx, 2.0 * dy ), shadowCoord.z ), \\n\\t\\t\\t\\t\\t\\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 2.0 * dy ), shadowCoord.z ),\\n\\t\\t\\t\\t\\t\\t  f.x ),\\n\\t\\t\\t\\t\\t f.y )\\n\\t\\t\\t) * ( 1.0 / 9.0 );\\n\\t\\t#elif defined( SHADOWMAP_TYPE_VSM )\\n\\t\\t\\tshadow = VSMShadow( shadowMap, shadowCoord.xy, shadowCoord.z );\\n\\t\\t#else\\n\\t\\t\\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\\n\\t\\t#endif\\n\\t\\t}\\n\\t\\treturn shadow;\\n\\t}\\n\\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\\n\\t\\tvec3 absV = abs( v );\\n\\t\\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\\n\\t\\tabsV *= scaleToCube;\\n\\t\\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\\n\\t\\tvec2 planar = v.xy;\\n\\t\\tfloat almostATexel = 1.5 * texelSizeY;\\n\\t\\tfloat almostOne = 1.0 - almostATexel;\\n\\t\\tif ( absV.z >= almostOne ) {\\n\\t\\t\\tif ( v.z > 0.0 )\\n\\t\\t\\t\\tplanar.x = 4.0 - v.x;\\n\\t\\t} else if ( absV.x >= almostOne ) {\\n\\t\\t\\tfloat signX = sign( v.x );\\n\\t\\t\\tplanar.x = v.z * signX + 2.0 * signX;\\n\\t\\t} else if ( absV.y >= almostOne ) {\\n\\t\\t\\tfloat signY = sign( v.y );\\n\\t\\t\\tplanar.x = v.x + 2.0 * signY + 2.0;\\n\\t\\t\\tplanar.y = v.z * signY - 2.0;\\n\\t\\t}\\n\\t\\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\\n\\t}\\n\\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\\n\\t\\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\\n\\t\\tvec3 lightToPosition = shadowCoord.xyz;\\n\\t\\tfloat dp = ( length( lightToPosition ) - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\\t\\tdp += shadowBias;\\n\\t\\tvec3 bd3D = normalize( lightToPosition );\\n\\t\\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT ) || defined( SHADOWMAP_TYPE_VSM )\\n\\t\\t\\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\\n\\t\\t\\treturn (\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\\n\\t\\t\\t\\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\\n\\t\\t\\t) * ( 1.0 / 9.0 );\\n\\t\\t#else\\n\\t\\t\\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\\n\\t\\t#endif\\n\\t}\\n#endif\";\n\nvar shadowmap_pars_vertex = \"#ifdef USE_SHADOWMAP\\n\\t#if NUM_DIR_LIGHT_SHADOWS > 0\\n\\t\\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHT_SHADOWS ];\\n\\t\\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\\n\\t\\tstruct DirectionalLightShadow {\\n\\t\\t\\tfloat shadowBias;\\n\\t\\t\\tfloat shadowNormalBias;\\n\\t\\t\\tfloat shadowRadius;\\n\\t\\t\\tvec2 shadowMapSize;\\n\\t\\t};\\n\\t\\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\\n\\t#endif\\n\\t#if NUM_SPOT_LIGHT_SHADOWS > 0\\n\\t\\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHT_SHADOWS ];\\n\\t\\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\\n\\t\\tstruct SpotLightShadow {\\n\\t\\t\\tfloat shadowBias;\\n\\t\\t\\tfloat shadowNormalBias;\\n\\t\\t\\tfloat shadowRadius;\\n\\t\\t\\tvec2 shadowMapSize;\\n\\t\\t};\\n\\t\\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\\n\\t#endif\\n\\t#if NUM_POINT_LIGHT_SHADOWS > 0\\n\\t\\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHT_SHADOWS ];\\n\\t\\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\\n\\t\\tstruct PointLightShadow {\\n\\t\\t\\tfloat shadowBias;\\n\\t\\t\\tfloat shadowNormalBias;\\n\\t\\t\\tfloat shadowRadius;\\n\\t\\t\\tvec2 shadowMapSize;\\n\\t\\t\\tfloat shadowCameraNear;\\n\\t\\t\\tfloat shadowCameraFar;\\n\\t\\t};\\n\\t\\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\\n\\t#endif\\n#endif\";\n\nvar shadowmap_vertex = \"#ifdef USE_SHADOWMAP\\n\\t#if NUM_DIR_LIGHT_SHADOWS > 0 || NUM_SPOT_LIGHT_SHADOWS > 0 || NUM_POINT_LIGHT_SHADOWS > 0\\n\\t\\tvec3 shadowWorldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\\n\\t\\tvec4 shadowWorldPosition;\\n\\t#endif\\n\\t#if NUM_DIR_LIGHT_SHADOWS > 0\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\\n\\t\\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * directionalLightShadows[ i ].shadowNormalBias, 0 );\\n\\t\\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * shadowWorldPosition;\\n\\t}\\n\\t#pragma unroll_loop_end\\n\\t#endif\\n\\t#if NUM_SPOT_LIGHT_SHADOWS > 0\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\\n\\t\\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * spotLightShadows[ i ].shadowNormalBias, 0 );\\n\\t\\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * shadowWorldPosition;\\n\\t}\\n\\t#pragma unroll_loop_end\\n\\t#endif\\n\\t#if NUM_POINT_LIGHT_SHADOWS > 0\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\\n\\t\\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * pointLightShadows[ i ].shadowNormalBias, 0 );\\n\\t\\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * shadowWorldPosition;\\n\\t}\\n\\t#pragma unroll_loop_end\\n\\t#endif\\n#endif\";\n\nvar shadowmask_pars_fragment = \"float getShadowMask() {\\n\\tfloat shadow = 1.0;\\n\\t#ifdef USE_SHADOWMAP\\n\\t#if NUM_DIR_LIGHT_SHADOWS > 0\\n\\tDirectionalLightShadow directionalLight;\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\\n\\t\\tdirectionalLight = directionalLightShadows[ i ];\\n\\t\\tshadow *= receiveShadow ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\\n\\t}\\n\\t#pragma unroll_loop_end\\n\\t#endif\\n\\t#if NUM_SPOT_LIGHT_SHADOWS > 0\\n\\tSpotLightShadow spotLight;\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\\n\\t\\tspotLight = spotLightShadows[ i ];\\n\\t\\tshadow *= receiveShadow ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\\n\\t}\\n\\t#pragma unroll_loop_end\\n\\t#endif\\n\\t#if NUM_POINT_LIGHT_SHADOWS > 0\\n\\tPointLightShadow pointLight;\\n\\t#pragma unroll_loop_start\\n\\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\\n\\t\\tpointLight = pointLightShadows[ i ];\\n\\t\\tshadow *= receiveShadow ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\\n\\t}\\n\\t#pragma unroll_loop_end\\n\\t#endif\\n\\t#endif\\n\\treturn shadow;\\n}\";\n\nvar skinbase_vertex = \"#ifdef USE_SKINNING\\n\\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\\n\\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\\n\\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\\n\\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\\n#endif\";\n\nvar skinning_pars_vertex = \"#ifdef USE_SKINNING\\n\\tuniform mat4 bindMatrix;\\n\\tuniform mat4 bindMatrixInverse;\\n\\t#ifdef BONE_TEXTURE\\n\\t\\tuniform highp sampler2D boneTexture;\\n\\t\\tuniform int boneTextureSize;\\n\\t\\tmat4 getBoneMatrix( const in float i ) {\\n\\t\\t\\tfloat j = i * 4.0;\\n\\t\\t\\tfloat x = mod( j, float( boneTextureSize ) );\\n\\t\\t\\tfloat y = floor( j / float( boneTextureSize ) );\\n\\t\\t\\tfloat dx = 1.0 / float( boneTextureSize );\\n\\t\\t\\tfloat dy = 1.0 / float( boneTextureSize );\\n\\t\\t\\ty = dy * ( y + 0.5 );\\n\\t\\t\\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\\n\\t\\t\\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\\n\\t\\t\\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\\n\\t\\t\\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\\n\\t\\t\\tmat4 bone = mat4( v1, v2, v3, v4 );\\n\\t\\t\\treturn bone;\\n\\t\\t}\\n\\t#else\\n\\t\\tuniform mat4 boneMatrices[ MAX_BONES ];\\n\\t\\tmat4 getBoneMatrix( const in float i ) {\\n\\t\\t\\tmat4 bone = boneMatrices[ int(i) ];\\n\\t\\t\\treturn bone;\\n\\t\\t}\\n\\t#endif\\n#endif\";\n\nvar skinning_vertex = \"#ifdef USE_SKINNING\\n\\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\\n\\tvec4 skinned = vec4( 0.0 );\\n\\tskinned += boneMatX * skinVertex * skinWeight.x;\\n\\tskinned += boneMatY * skinVertex * skinWeight.y;\\n\\tskinned += boneMatZ * skinVertex * skinWeight.z;\\n\\tskinned += boneMatW * skinVertex * skinWeight.w;\\n\\ttransformed = ( bindMatrixInverse * skinned ).xyz;\\n#endif\";\n\nvar skinnormal_vertex = \"#ifdef USE_SKINNING\\n\\tmat4 skinMatrix = mat4( 0.0 );\\n\\tskinMatrix += skinWeight.x * boneMatX;\\n\\tskinMatrix += skinWeight.y * boneMatY;\\n\\tskinMatrix += skinWeight.z * boneMatZ;\\n\\tskinMatrix += skinWeight.w * boneMatW;\\n\\tskinMatrix = bindMatrixInverse * skinMatrix * bindMatrix;\\n\\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\\n\\t#ifdef USE_TANGENT\\n\\t\\tobjectTangent = vec4( skinMatrix * vec4( objectTangent, 0.0 ) ).xyz;\\n\\t#endif\\n#endif\";\n\nvar specularmap_fragment = \"float specularStrength;\\n#ifdef USE_SPECULARMAP\\n\\tvec4 texelSpecular = texture2D( specularMap, vUv );\\n\\tspecularStrength = texelSpecular.r;\\n#else\\n\\tspecularStrength = 1.0;\\n#endif\";\n\nvar specularmap_pars_fragment = \"#ifdef USE_SPECULARMAP\\n\\tuniform sampler2D specularMap;\\n#endif\";\n\nvar tonemapping_fragment = \"#if defined( TONE_MAPPING )\\n\\tgl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\\n#endif\";\n\nvar tonemapping_pars_fragment = \"#ifndef saturate\\n#define saturate(a) clamp( a, 0.0, 1.0 )\\n#endif\\nuniform float toneMappingExposure;\\nvec3 LinearToneMapping( vec3 color ) {\\n\\treturn toneMappingExposure * color;\\n}\\nvec3 ReinhardToneMapping( vec3 color ) {\\n\\tcolor *= toneMappingExposure;\\n\\treturn saturate( color / ( vec3( 1.0 ) + color ) );\\n}\\nvec3 OptimizedCineonToneMapping( vec3 color ) {\\n\\tcolor *= toneMappingExposure;\\n\\tcolor = max( vec3( 0.0 ), color - 0.004 );\\n\\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\\n}\\nvec3 RRTAndODTFit( vec3 v ) {\\n\\tvec3 a = v * ( v + 0.0245786 ) - 0.000090537;\\n\\tvec3 b = v * ( 0.983729 * v + 0.4329510 ) + 0.238081;\\n\\treturn a / b;\\n}\\nvec3 ACESFilmicToneMapping( vec3 color ) {\\n\\tconst mat3 ACESInputMat = mat3(\\n\\t\\tvec3( 0.59719, 0.07600, 0.02840 ),\\t\\tvec3( 0.35458, 0.90834, 0.13383 ),\\n\\t\\tvec3( 0.04823, 0.01566, 0.83777 )\\n\\t);\\n\\tconst mat3 ACESOutputMat = mat3(\\n\\t\\tvec3(  1.60475, -0.10208, -0.00327 ),\\t\\tvec3( -0.53108,  1.10813, -0.07276 ),\\n\\t\\tvec3( -0.07367, -0.00605,  1.07602 )\\n\\t);\\n\\tcolor *= toneMappingExposure / 0.6;\\n\\tcolor = ACESInputMat * color;\\n\\tcolor = RRTAndODTFit( color );\\n\\tcolor = ACESOutputMat * color;\\n\\treturn saturate( color );\\n}\\nvec3 CustomToneMapping( vec3 color ) { return color; }\";\n\nvar transmission_fragment = \"#ifdef USE_TRANSMISSION\\n\\t#ifdef USE_TRANSMISSIONMAP\\n\\t\\ttotalTransmission *= texture2D( transmissionMap, vUv ).r;\\n\\t#endif\\n\\t#ifdef USE_THICKNESSNMAP\\n\\t\\tthicknessFactor *= texture2D( thicknessMap, vUv ).g;\\n\\t#endif\\n\\tvec3 pos = vWorldPosition.xyz / vWorldPosition.w;\\n\\tvec3 v = normalize( cameraPosition - pos );\\n\\tvec3 viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\\n\\tfloat ior = ( 1.0 + 0.4 * reflectivity ) / ( 1.0 - 0.4 * reflectivity );\\n\\tvec3 f0 = vec3( pow( ior - 1.0, 2.0 ) / pow( ior + 1.0, 2.0 ) );\\n\\tvec3 f90 = vec3( 1.0 );\\n\\tvec3 f_transmission = totalTransmission * getIBLVolumeRefraction(\\n\\t\\tnormal, v, viewDir, roughnessFactor, diffuseColor.rgb, f0, f90,\\n\\t\\tpos, modelMatrix, viewMatrix, projectionMatrix, ior, thicknessFactor,\\n\\t\\tattenuationColor, attenuationDistance);\\n\\tdiffuseColor.rgb = mix( diffuseColor.rgb, f_transmission, totalTransmission );\\n#endif\";\n\nvar transmission_pars_fragment = \"#ifdef USE_TRANSMISSION\\n\\t#ifdef USE_TRANSMISSIONMAP\\n\\t\\tuniform sampler2D transmissionMap;\\n\\t#endif\\n\\t#ifdef USE_THICKNESSMAP\\n\\t\\tuniform sampler2D thicknessMap;\\n\\t#endif\\n\\tuniform vec2 transmissionSamplerSize;\\n\\tuniform sampler2D transmissionSamplerMap;\\n\\tuniform mat4 modelMatrix;\\n\\tuniform mat4 projectionMatrix;\\n\\tvarying vec4 vWorldPosition;\\n\\tvec3 getVolumeTransmissionRay(vec3 n, vec3 v, float thickness, float ior, mat4 modelMatrix) {\\n\\t\\tvec3 refractionVector = refract(-v, normalize(n), 1.0 / ior);\\n\\t\\tvec3 modelScale;\\n\\t\\tmodelScale.x = length(vec3(modelMatrix[0].xyz));\\n\\t\\tmodelScale.y = length(vec3(modelMatrix[1].xyz));\\n\\t\\tmodelScale.z = length(vec3(modelMatrix[2].xyz));\\n\\t\\treturn normalize(refractionVector) * thickness * modelScale;\\n\\t}\\n\\tfloat applyIorToRoughness(float roughness, float ior) {\\n\\t\\treturn roughness * clamp(ior * 2.0 - 2.0, 0.0, 1.0);\\n\\t}\\n\\tvec3 getTransmissionSample(vec2 fragCoord, float roughness, float ior) {\\n\\t\\tfloat framebufferLod = log2(transmissionSamplerSize.x) * applyIorToRoughness(roughness, ior);\\n\\t\\treturn texture2DLodEXT(transmissionSamplerMap, fragCoord.xy, framebufferLod).rgb;\\n\\t}\\n\\tvec3 applyVolumeAttenuation(vec3 radiance, float transmissionDistance, vec3 attenuationColor, float attenuationDistance) {\\n\\t\\tif (attenuationDistance == 0.0) {\\n\\t\\t\\treturn radiance;\\n\\t\\t} else {\\n\\t\\t\\tvec3 attenuationCoefficient = -log(attenuationColor) / attenuationDistance;\\n\\t\\t\\tvec3 transmittance = exp(-attenuationCoefficient * transmissionDistance);\\t\\t\\treturn transmittance * radiance;\\n\\t\\t}\\n\\t}\\n\\tvec3 getIBLVolumeRefraction(vec3 n, vec3 v, vec3 viewDir, float perceptualRoughness, vec3 baseColor, vec3 f0, vec3 f90,\\n\\t\\tvec3 position, mat4 modelMatrix, mat4 viewMatrix, mat4 projMatrix, float ior, float thickness, vec3 attenuationColor, float attenuationDistance) {\\n\\t\\tvec3 transmissionRay = getVolumeTransmissionRay(n, v, thickness, ior, modelMatrix);\\n\\t\\tvec3 refractedRayExit = position + transmissionRay;\\n\\t\\tvec4 ndcPos = projMatrix * viewMatrix * vec4(refractedRayExit, 1.0);\\n\\t\\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\\n\\t\\trefractionCoords += 1.0;\\n\\t\\trefractionCoords /= 2.0;\\n\\t\\tvec3 transmittedLight = getTransmissionSample(refractionCoords, perceptualRoughness, ior);\\n\\t\\tvec3 attenuatedColor = applyVolumeAttenuation(transmittedLight, length(transmissionRay), attenuationColor, attenuationDistance);\\n\\t\\tfloat NdotV = saturate(dot(n, viewDir));\\n\\t\\tvec2 brdf = integrateSpecularBRDF(NdotV, perceptualRoughness);\\n\\t\\tvec3 specularColor = f0 * brdf.x + f90 * brdf.y;\\n\\t\\treturn (1.0 - specularColor) * attenuatedColor * baseColor;\\n\\t}\\n#endif\";\n\nvar uv_pars_fragment = \"#if ( defined( USE_UV ) && ! defined( UVS_VERTEX_ONLY ) )\\n\\tvarying vec2 vUv;\\n#endif\";\n\nvar uv_pars_vertex = \"#ifdef USE_UV\\n\\t#ifdef UVS_VERTEX_ONLY\\n\\t\\tvec2 vUv;\\n\\t#else\\n\\t\\tvarying vec2 vUv;\\n\\t#endif\\n\\tuniform mat3 uvTransform;\\n#endif\";\n\nvar uv_vertex = \"#ifdef USE_UV\\n\\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\\n#endif\";\n\nvar uv2_pars_fragment = \"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\\n\\tvarying vec2 vUv2;\\n#endif\";\n\nvar uv2_pars_vertex = \"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\\n\\tattribute vec2 uv2;\\n\\tvarying vec2 vUv2;\\n\\tuniform mat3 uv2Transform;\\n#endif\";\n\nvar uv2_vertex = \"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\\n\\tvUv2 = ( uv2Transform * vec3( uv2, 1 ) ).xy;\\n#endif\";\n\nvar worldpos_vertex = \"#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP ) || defined ( USE_TRANSMISSION )\\n\\tvec4 worldPosition = vec4( transformed, 1.0 );\\n\\t#ifdef USE_INSTANCING\\n\\t\\tworldPosition = instanceMatrix * worldPosition;\\n\\t#endif\\n\\tworldPosition = modelMatrix * worldPosition;\\n#endif\";\n\nvar background_frag = \"uniform sampler2D t2D;\\nvarying vec2 vUv;\\nvoid main() {\\n\\tvec4 texColor = texture2D( t2D, vUv );\\n\\tgl_FragColor = mapTexelToLinear( texColor );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n}\";\n\nvar background_vert = \"varying vec2 vUv;\\nuniform mat3 uvTransform;\\nvoid main() {\\n\\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\\n\\tgl_Position = vec4( position.xy, 1.0, 1.0 );\\n}\";\n\nvar cube_frag = \"#include <envmap_common_pars_fragment>\\nuniform float opacity;\\nvarying vec3 vWorldDirection;\\n#include <cube_uv_reflection_fragment>\\nvoid main() {\\n\\tvec3 vReflect = vWorldDirection;\\n\\t#include <envmap_fragment>\\n\\tgl_FragColor = envColor;\\n\\tgl_FragColor.a *= opacity;\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n}\";\n\nvar cube_vert = \"varying vec3 vWorldDirection;\\n#include <common>\\nvoid main() {\\n\\tvWorldDirection = transformDirection( position, modelMatrix );\\n\\t#include <begin_vertex>\\n\\t#include <project_vertex>\\n\\tgl_Position.z = gl_Position.w;\\n}\";\n\nvar depth_frag = \"#if DEPTH_PACKING == 3200\\n\\tuniform float opacity;\\n#endif\\n#include <common>\\n#include <packing>\\n#include <uv_pars_fragment>\\n#include <map_pars_fragment>\\n#include <alphamap_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvarying vec2 vHighPrecisionZW;\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tvec4 diffuseColor = vec4( 1.0 );\\n\\t#if DEPTH_PACKING == 3200\\n\\t\\tdiffuseColor.a = opacity;\\n\\t#endif\\n\\t#include <map_fragment>\\n\\t#include <alphamap_fragment>\\n\\t#include <alphatest_fragment>\\n\\t#include <logdepthbuf_fragment>\\n\\tfloat fragCoordZ = 0.5 * vHighPrecisionZW[0] / vHighPrecisionZW[1] + 0.5;\\n\\t#if DEPTH_PACKING == 3200\\n\\t\\tgl_FragColor = vec4( vec3( 1.0 - fragCoordZ ), opacity );\\n\\t#elif DEPTH_PACKING == 3201\\n\\t\\tgl_FragColor = packDepthToRGBA( fragCoordZ );\\n\\t#endif\\n}\";\n\nvar depth_vert = \"#include <common>\\n#include <uv_pars_vertex>\\n#include <displacementmap_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <skinning_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvarying vec2 vHighPrecisionZW;\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#ifdef USE_DISPLACEMENTMAP\\n\\t\\t#include <beginnormal_vertex>\\n\\t\\t#include <morphnormal_vertex>\\n\\t\\t#include <skinnormal_vertex>\\n\\t#endif\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <skinning_vertex>\\n\\t#include <displacementmap_vertex>\\n\\t#include <project_vertex>\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\tvHighPrecisionZW = gl_Position.zw;\\n}\";\n\nvar distanceRGBA_frag = \"#define DISTANCE\\nuniform vec3 referencePosition;\\nuniform float nearDistance;\\nuniform float farDistance;\\nvarying vec3 vWorldPosition;\\n#include <common>\\n#include <packing>\\n#include <uv_pars_fragment>\\n#include <map_pars_fragment>\\n#include <alphamap_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main () {\\n\\t#include <clipping_planes_fragment>\\n\\tvec4 diffuseColor = vec4( 1.0 );\\n\\t#include <map_fragment>\\n\\t#include <alphamap_fragment>\\n\\t#include <alphatest_fragment>\\n\\tfloat dist = length( vWorldPosition - referencePosition );\\n\\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\\n\\tdist = saturate( dist );\\n\\tgl_FragColor = packDepthToRGBA( dist );\\n}\";\n\nvar distanceRGBA_vert = \"#define DISTANCE\\nvarying vec3 vWorldPosition;\\n#include <common>\\n#include <uv_pars_vertex>\\n#include <displacementmap_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <skinning_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#ifdef USE_DISPLACEMENTMAP\\n\\t\\t#include <beginnormal_vertex>\\n\\t\\t#include <morphnormal_vertex>\\n\\t\\t#include <skinnormal_vertex>\\n\\t#endif\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <skinning_vertex>\\n\\t#include <displacementmap_vertex>\\n\\t#include <project_vertex>\\n\\t#include <worldpos_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\tvWorldPosition = worldPosition.xyz;\\n}\";\n\nvar equirect_frag = \"uniform sampler2D tEquirect;\\nvarying vec3 vWorldDirection;\\n#include <common>\\nvoid main() {\\n\\tvec3 direction = normalize( vWorldDirection );\\n\\tvec2 sampleUV = equirectUv( direction );\\n\\tvec4 texColor = texture2D( tEquirect, sampleUV );\\n\\tgl_FragColor = mapTexelToLinear( texColor );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n}\";\n\nvar equirect_vert = \"varying vec3 vWorldDirection;\\n#include <common>\\nvoid main() {\\n\\tvWorldDirection = transformDirection( position, modelMatrix );\\n\\t#include <begin_vertex>\\n\\t#include <project_vertex>\\n}\";\n\nvar linedashed_frag = \"uniform vec3 diffuse;\\nuniform float opacity;\\nuniform float dashSize;\\nuniform float totalSize;\\nvarying float vLineDistance;\\n#include <common>\\n#include <color_pars_fragment>\\n#include <fog_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\\n\\t\\tdiscard;\\n\\t}\\n\\tvec3 outgoingLight = vec3( 0.0 );\\n\\tvec4 diffuseColor = vec4( diffuse, opacity );\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <color_fragment>\\n\\toutgoingLight = diffuseColor.rgb;\\n\\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n\\t#include <premultiplied_alpha_fragment>\\n}\";\n\nvar linedashed_vert = \"uniform float scale;\\nattribute float lineDistance;\\nvarying float vLineDistance;\\n#include <common>\\n#include <color_pars_vertex>\\n#include <fog_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\tvLineDistance = scale * lineDistance;\\n\\t#include <color_vertex>\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <project_vertex>\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\t#include <fog_vertex>\\n}\";\n\nvar meshbasic_frag = \"uniform vec3 diffuse;\\nuniform float opacity;\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n#endif\\n#include <common>\\n#include <dithering_pars_fragment>\\n#include <color_pars_fragment>\\n#include <uv_pars_fragment>\\n#include <uv2_pars_fragment>\\n#include <map_pars_fragment>\\n#include <alphamap_pars_fragment>\\n#include <aomap_pars_fragment>\\n#include <lightmap_pars_fragment>\\n#include <envmap_common_pars_fragment>\\n#include <envmap_pars_fragment>\\n#include <cube_uv_reflection_fragment>\\n#include <fog_pars_fragment>\\n#include <specularmap_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tvec4 diffuseColor = vec4( diffuse, opacity );\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <map_fragment>\\n\\t#include <color_fragment>\\n\\t#include <alphamap_fragment>\\n\\t#include <alphatest_fragment>\\n\\t#include <specularmap_fragment>\\n\\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\\n\\t#ifdef USE_LIGHTMAP\\n\\t\\n\\t\\tvec4 lightMapTexel= texture2D( lightMap, vUv2 );\\n\\t\\treflectedLight.indirectDiffuse += lightMapTexelToLinear( lightMapTexel ).rgb * lightMapIntensity;\\n\\t#else\\n\\t\\treflectedLight.indirectDiffuse += vec3( 1.0 );\\n\\t#endif\\n\\t#include <aomap_fragment>\\n\\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\\n\\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\\n\\t#include <envmap_fragment>\\n\\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n\\t#include <premultiplied_alpha_fragment>\\n\\t#include <dithering_fragment>\\n}\";\n\nvar meshbasic_vert = \"#include <common>\\n#include <uv_pars_vertex>\\n#include <uv2_pars_vertex>\\n#include <envmap_pars_vertex>\\n#include <color_pars_vertex>\\n#include <fog_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <skinning_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\t#include <uv2_vertex>\\n\\t#include <color_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#ifdef USE_ENVMAP\\n\\t#include <beginnormal_vertex>\\n\\t#include <morphnormal_vertex>\\n\\t#include <skinnormal_vertex>\\n\\t#include <defaultnormal_vertex>\\n\\t#endif\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <skinning_vertex>\\n\\t#include <project_vertex>\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <worldpos_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\t#include <envmap_vertex>\\n\\t#include <fog_vertex>\\n}\";\n\nvar meshlambert_frag = \"uniform vec3 diffuse;\\nuniform vec3 emissive;\\nuniform float opacity;\\nvarying vec3 vLightFront;\\nvarying vec3 vIndirectFront;\\n#ifdef DOUBLE_SIDED\\n\\tvarying vec3 vLightBack;\\n\\tvarying vec3 vIndirectBack;\\n#endif\\n#include <common>\\n#include <packing>\\n#include <dithering_pars_fragment>\\n#include <color_pars_fragment>\\n#include <uv_pars_fragment>\\n#include <uv2_pars_fragment>\\n#include <map_pars_fragment>\\n#include <alphamap_pars_fragment>\\n#include <aomap_pars_fragment>\\n#include <lightmap_pars_fragment>\\n#include <emissivemap_pars_fragment>\\n#include <envmap_common_pars_fragment>\\n#include <envmap_pars_fragment>\\n#include <cube_uv_reflection_fragment>\\n#include <bsdfs>\\n#include <lights_pars_begin>\\n#include <fog_pars_fragment>\\n#include <shadowmap_pars_fragment>\\n#include <shadowmask_pars_fragment>\\n#include <specularmap_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tvec4 diffuseColor = vec4( diffuse, opacity );\\n\\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\\n\\tvec3 totalEmissiveRadiance = emissive;\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <map_fragment>\\n\\t#include <color_fragment>\\n\\t#include <alphamap_fragment>\\n\\t#include <alphatest_fragment>\\n\\t#include <specularmap_fragment>\\n\\t#include <emissivemap_fragment>\\n\\t#ifdef DOUBLE_SIDED\\n\\t\\treflectedLight.indirectDiffuse += ( gl_FrontFacing ) ? vIndirectFront : vIndirectBack;\\n\\t#else\\n\\t\\treflectedLight.indirectDiffuse += vIndirectFront;\\n\\t#endif\\n\\t#include <lightmap_fragment>\\n\\treflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\\n\\t#ifdef DOUBLE_SIDED\\n\\t\\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\\n\\t#else\\n\\t\\treflectedLight.directDiffuse = vLightFront;\\n\\t#endif\\n\\treflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\\n\\t#include <aomap_fragment>\\n\\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\\n\\t#include <envmap_fragment>\\n\\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n\\t#include <premultiplied_alpha_fragment>\\n\\t#include <dithering_fragment>\\n}\";\n\nvar meshlambert_vert = \"#define LAMBERT\\nvarying vec3 vLightFront;\\nvarying vec3 vIndirectFront;\\n#ifdef DOUBLE_SIDED\\n\\tvarying vec3 vLightBack;\\n\\tvarying vec3 vIndirectBack;\\n#endif\\n#include <common>\\n#include <uv_pars_vertex>\\n#include <uv2_pars_vertex>\\n#include <envmap_pars_vertex>\\n#include <bsdfs>\\n#include <lights_pars_begin>\\n#include <color_pars_vertex>\\n#include <fog_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <skinning_pars_vertex>\\n#include <shadowmap_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\t#include <uv2_vertex>\\n\\t#include <color_vertex>\\n\\t#include <beginnormal_vertex>\\n\\t#include <morphnormal_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#include <skinnormal_vertex>\\n\\t#include <defaultnormal_vertex>\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <skinning_vertex>\\n\\t#include <project_vertex>\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\t#include <worldpos_vertex>\\n\\t#include <envmap_vertex>\\n\\t#include <lights_lambert_vertex>\\n\\t#include <shadowmap_vertex>\\n\\t#include <fog_vertex>\\n}\";\n\nvar meshmatcap_frag = \"#define MATCAP\\nuniform vec3 diffuse;\\nuniform float opacity;\\nuniform sampler2D matcap;\\nvarying vec3 vViewPosition;\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n#endif\\n#include <common>\\n#include <dithering_pars_fragment>\\n#include <color_pars_fragment>\\n#include <uv_pars_fragment>\\n#include <map_pars_fragment>\\n#include <alphamap_pars_fragment>\\n#include <fog_pars_fragment>\\n#include <bumpmap_pars_fragment>\\n#include <normalmap_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tvec4 diffuseColor = vec4( diffuse, opacity );\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <map_fragment>\\n\\t#include <color_fragment>\\n\\t#include <alphamap_fragment>\\n\\t#include <alphatest_fragment>\\n\\t#include <normal_fragment_begin>\\n\\t#include <normal_fragment_maps>\\n\\tvec3 viewDir = normalize( vViewPosition );\\n\\tvec3 x = normalize( vec3( viewDir.z, 0.0, - viewDir.x ) );\\n\\tvec3 y = cross( viewDir, x );\\n\\tvec2 uv = vec2( dot( x, normal ), dot( y, normal ) ) * 0.495 + 0.5;\\n\\t#ifdef USE_MATCAP\\n\\t\\tvec4 matcapColor = texture2D( matcap, uv );\\n\\t\\tmatcapColor = matcapTexelToLinear( matcapColor );\\n\\t#else\\n\\t\\tvec4 matcapColor = vec4( 1.0 );\\n\\t#endif\\n\\tvec3 outgoingLight = diffuseColor.rgb * matcapColor.rgb;\\n\\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n\\t#include <premultiplied_alpha_fragment>\\n\\t#include <dithering_fragment>\\n}\";\n\nvar meshmatcap_vert = \"#define MATCAP\\nvarying vec3 vViewPosition;\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n#endif\\n#include <common>\\n#include <uv_pars_vertex>\\n#include <color_pars_vertex>\\n#include <displacementmap_pars_vertex>\\n#include <fog_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <skinning_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\t#include <color_vertex>\\n\\t#include <beginnormal_vertex>\\n\\t#include <morphnormal_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#include <skinnormal_vertex>\\n\\t#include <defaultnormal_vertex>\\n\\t#ifndef FLAT_SHADED\\n\\t\\tvNormal = normalize( transformedNormal );\\n\\t#endif\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <skinning_vertex>\\n\\t#include <displacementmap_vertex>\\n\\t#include <project_vertex>\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\t#include <fog_vertex>\\n\\tvViewPosition = - mvPosition.xyz;\\n}\";\n\nvar meshtoon_frag = \"#define TOON\\nuniform vec3 diffuse;\\nuniform vec3 emissive;\\nuniform float opacity;\\n#include <common>\\n#include <packing>\\n#include <dithering_pars_fragment>\\n#include <color_pars_fragment>\\n#include <uv_pars_fragment>\\n#include <uv2_pars_fragment>\\n#include <map_pars_fragment>\\n#include <alphamap_pars_fragment>\\n#include <aomap_pars_fragment>\\n#include <lightmap_pars_fragment>\\n#include <emissivemap_pars_fragment>\\n#include <gradientmap_pars_fragment>\\n#include <fog_pars_fragment>\\n#include <bsdfs>\\n#include <lights_pars_begin>\\n#include <lights_toon_pars_fragment>\\n#include <shadowmap_pars_fragment>\\n#include <bumpmap_pars_fragment>\\n#include <normalmap_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tvec4 diffuseColor = vec4( diffuse, opacity );\\n\\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\\n\\tvec3 totalEmissiveRadiance = emissive;\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <map_fragment>\\n\\t#include <color_fragment>\\n\\t#include <alphamap_fragment>\\n\\t#include <alphatest_fragment>\\n\\t#include <normal_fragment_begin>\\n\\t#include <normal_fragment_maps>\\n\\t#include <emissivemap_fragment>\\n\\t#include <lights_toon_fragment>\\n\\t#include <lights_fragment_begin>\\n\\t#include <lights_fragment_maps>\\n\\t#include <lights_fragment_end>\\n\\t#include <aomap_fragment>\\n\\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\\n\\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n\\t#include <premultiplied_alpha_fragment>\\n\\t#include <dithering_fragment>\\n}\";\n\nvar meshtoon_vert = \"#define TOON\\nvarying vec3 vViewPosition;\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n#endif\\n#include <common>\\n#include <uv_pars_vertex>\\n#include <uv2_pars_vertex>\\n#include <displacementmap_pars_vertex>\\n#include <color_pars_vertex>\\n#include <fog_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <skinning_pars_vertex>\\n#include <shadowmap_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\t#include <uv2_vertex>\\n\\t#include <color_vertex>\\n\\t#include <beginnormal_vertex>\\n\\t#include <morphnormal_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#include <skinnormal_vertex>\\n\\t#include <defaultnormal_vertex>\\n#ifndef FLAT_SHADED\\n\\tvNormal = normalize( transformedNormal );\\n#endif\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <skinning_vertex>\\n\\t#include <displacementmap_vertex>\\n\\t#include <project_vertex>\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\tvViewPosition = - mvPosition.xyz;\\n\\t#include <worldpos_vertex>\\n\\t#include <shadowmap_vertex>\\n\\t#include <fog_vertex>\\n}\";\n\nvar meshphong_frag = \"#define PHONG\\nuniform vec3 diffuse;\\nuniform vec3 emissive;\\nuniform vec3 specular;\\nuniform float shininess;\\nuniform float opacity;\\n#include <common>\\n#include <packing>\\n#include <dithering_pars_fragment>\\n#include <color_pars_fragment>\\n#include <uv_pars_fragment>\\n#include <uv2_pars_fragment>\\n#include <map_pars_fragment>\\n#include <alphamap_pars_fragment>\\n#include <aomap_pars_fragment>\\n#include <lightmap_pars_fragment>\\n#include <emissivemap_pars_fragment>\\n#include <envmap_common_pars_fragment>\\n#include <envmap_pars_fragment>\\n#include <cube_uv_reflection_fragment>\\n#include <fog_pars_fragment>\\n#include <bsdfs>\\n#include <lights_pars_begin>\\n#include <lights_phong_pars_fragment>\\n#include <shadowmap_pars_fragment>\\n#include <bumpmap_pars_fragment>\\n#include <normalmap_pars_fragment>\\n#include <specularmap_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tvec4 diffuseColor = vec4( diffuse, opacity );\\n\\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\\n\\tvec3 totalEmissiveRadiance = emissive;\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <map_fragment>\\n\\t#include <color_fragment>\\n\\t#include <alphamap_fragment>\\n\\t#include <alphatest_fragment>\\n\\t#include <specularmap_fragment>\\n\\t#include <normal_fragment_begin>\\n\\t#include <normal_fragment_maps>\\n\\t#include <emissivemap_fragment>\\n\\t#include <lights_phong_fragment>\\n\\t#include <lights_fragment_begin>\\n\\t#include <lights_fragment_maps>\\n\\t#include <lights_fragment_end>\\n\\t#include <aomap_fragment>\\n\\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\\n\\t#include <envmap_fragment>\\n\\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n\\t#include <premultiplied_alpha_fragment>\\n\\t#include <dithering_fragment>\\n}\";\n\nvar meshphong_vert = \"#define PHONG\\nvarying vec3 vViewPosition;\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n#endif\\n#include <common>\\n#include <uv_pars_vertex>\\n#include <uv2_pars_vertex>\\n#include <displacementmap_pars_vertex>\\n#include <envmap_pars_vertex>\\n#include <color_pars_vertex>\\n#include <fog_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <skinning_pars_vertex>\\n#include <shadowmap_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\t#include <uv2_vertex>\\n\\t#include <color_vertex>\\n\\t#include <beginnormal_vertex>\\n\\t#include <morphnormal_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#include <skinnormal_vertex>\\n\\t#include <defaultnormal_vertex>\\n#ifndef FLAT_SHADED\\n\\tvNormal = normalize( transformedNormal );\\n#endif\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <skinning_vertex>\\n\\t#include <displacementmap_vertex>\\n\\t#include <project_vertex>\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\tvViewPosition = - mvPosition.xyz;\\n\\t#include <worldpos_vertex>\\n\\t#include <envmap_vertex>\\n\\t#include <shadowmap_vertex>\\n\\t#include <fog_vertex>\\n}\";\n\nvar meshphysical_frag = \"#define STANDARD\\n#ifdef PHYSICAL\\n\\t#define REFLECTIVITY\\n\\t#define CLEARCOAT\\n#endif\\nuniform vec3 diffuse;\\nuniform vec3 emissive;\\nuniform float roughness;\\nuniform float metalness;\\nuniform float opacity;\\n#ifdef USE_TRANSMISSION\\n\\tuniform float transmission;\\n\\tuniform float thickness;\\n\\tuniform vec3 attenuationColor;\\n\\tuniform float attenuationDistance;\\n#endif\\n#ifdef REFLECTIVITY\\n\\tuniform float reflectivity;\\n#endif\\n#ifdef CLEARCOAT\\n\\tuniform float clearcoat;\\n\\tuniform float clearcoatRoughness;\\n#endif\\n#ifdef USE_SHEEN\\n\\tuniform vec3 sheen;\\n#endif\\nvarying vec3 vViewPosition;\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n\\t#ifdef USE_TANGENT\\n\\t\\tvarying vec3 vTangent;\\n\\t\\tvarying vec3 vBitangent;\\n\\t#endif\\n#endif\\n#include <common>\\n#include <packing>\\n#include <dithering_pars_fragment>\\n#include <color_pars_fragment>\\n#include <uv_pars_fragment>\\n#include <uv2_pars_fragment>\\n#include <map_pars_fragment>\\n#include <alphamap_pars_fragment>\\n#include <aomap_pars_fragment>\\n#include <lightmap_pars_fragment>\\n#include <emissivemap_pars_fragment>\\n#include <bsdfs>\\n#include <transmission_pars_fragment>\\n#include <cube_uv_reflection_fragment>\\n#include <envmap_common_pars_fragment>\\n#include <envmap_physical_pars_fragment>\\n#include <fog_pars_fragment>\\n#include <lights_pars_begin>\\n#include <lights_physical_pars_fragment>\\n#include <shadowmap_pars_fragment>\\n#include <bumpmap_pars_fragment>\\n#include <normalmap_pars_fragment>\\n#include <clearcoat_pars_fragment>\\n#include <roughnessmap_pars_fragment>\\n#include <metalnessmap_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tvec4 diffuseColor = vec4( diffuse, opacity );\\n\\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\\n\\tvec3 totalEmissiveRadiance = emissive;\\n\\t#ifdef USE_TRANSMISSION\\n\\t\\tfloat totalTransmission = transmission;\\n\\t\\tfloat thicknessFactor = thickness;\\n\\t#endif\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <map_fragment>\\n\\t#include <color_fragment>\\n\\t#include <alphamap_fragment>\\n\\t#include <alphatest_fragment>\\n\\t#include <roughnessmap_fragment>\\n\\t#include <metalnessmap_fragment>\\n\\t#include <normal_fragment_begin>\\n\\t#include <normal_fragment_maps>\\n\\t#include <clearcoat_normal_fragment_begin>\\n\\t#include <clearcoat_normal_fragment_maps>\\n\\t#include <emissivemap_fragment>\\n\\tvec3 rawDiffuseColor = diffuseColor.rgb;\\n\\t#include <transmission_fragment>\\n\\t#include <lights_physical_fragment>\\n\\t#include <lights_fragment_begin>\\n\\t#include <lights_fragment_maps>\\n\\t#include <lights_fragment_end>\\n\\t#include <aomap_fragment>\\n\\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\\n\\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n\\t#include <premultiplied_alpha_fragment>\\n\\t#include <dithering_fragment>\\n}\";\n\nvar meshphysical_vert = \"#define STANDARD\\nvarying vec3 vViewPosition;\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n\\t#ifdef USE_TANGENT\\n\\t\\tvarying vec3 vTangent;\\n\\t\\tvarying vec3 vBitangent;\\n\\t#endif\\n#endif\\n#ifdef USE_TRANSMISSION\\n\\tvarying vec4 vWorldPosition;\\n#endif\\n#include <common>\\n#include <uv_pars_vertex>\\n#include <uv2_pars_vertex>\\n#include <displacementmap_pars_vertex>\\n#include <color_pars_vertex>\\n#include <fog_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <skinning_pars_vertex>\\n#include <shadowmap_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\t#include <uv2_vertex>\\n\\t#include <color_vertex>\\n\\t#include <beginnormal_vertex>\\n\\t#include <morphnormal_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#include <skinnormal_vertex>\\n\\t#include <defaultnormal_vertex>\\n#ifndef FLAT_SHADED\\n\\tvNormal = normalize( transformedNormal );\\n\\t#ifdef USE_TANGENT\\n\\t\\tvTangent = normalize( transformedTangent );\\n\\t\\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\\n\\t#endif\\n#endif\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <skinning_vertex>\\n\\t#include <displacementmap_vertex>\\n\\t#include <project_vertex>\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\tvViewPosition = - mvPosition.xyz;\\n\\t#include <worldpos_vertex>\\n\\t#include <shadowmap_vertex>\\n\\t#include <fog_vertex>\\n#ifdef USE_TRANSMISSION\\n\\tvWorldPosition = worldPosition;\\n#endif\\n}\";\n\nvar normal_frag = \"#define NORMAL\\nuniform float opacity;\\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\\n\\tvarying vec3 vViewPosition;\\n#endif\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n\\t#ifdef USE_TANGENT\\n\\t\\tvarying vec3 vTangent;\\n\\t\\tvarying vec3 vBitangent;\\n\\t#endif\\n#endif\\n#include <packing>\\n#include <uv_pars_fragment>\\n#include <bumpmap_pars_fragment>\\n#include <normalmap_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <normal_fragment_begin>\\n\\t#include <normal_fragment_maps>\\n\\tgl_FragColor = vec4( packNormalToRGB( normal ), opacity );\\n}\";\n\nvar normal_vert = \"#define NORMAL\\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\\n\\tvarying vec3 vViewPosition;\\n#endif\\n#ifndef FLAT_SHADED\\n\\tvarying vec3 vNormal;\\n\\t#ifdef USE_TANGENT\\n\\t\\tvarying vec3 vTangent;\\n\\t\\tvarying vec3 vBitangent;\\n\\t#endif\\n#endif\\n#include <common>\\n#include <uv_pars_vertex>\\n#include <displacementmap_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <skinning_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\t#include <beginnormal_vertex>\\n\\t#include <morphnormal_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#include <skinnormal_vertex>\\n\\t#include <defaultnormal_vertex>\\n#ifndef FLAT_SHADED\\n\\tvNormal = normalize( transformedNormal );\\n\\t#ifdef USE_TANGENT\\n\\t\\tvTangent = normalize( transformedTangent );\\n\\t\\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\\n\\t#endif\\n#endif\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <skinning_vertex>\\n\\t#include <displacementmap_vertex>\\n\\t#include <project_vertex>\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\\n\\tvViewPosition = - mvPosition.xyz;\\n#endif\\n}\";\n\nvar points_frag = \"uniform vec3 diffuse;\\nuniform float opacity;\\n#include <common>\\n#include <color_pars_fragment>\\n#include <map_particle_pars_fragment>\\n#include <fog_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tvec3 outgoingLight = vec3( 0.0 );\\n\\tvec4 diffuseColor = vec4( diffuse, opacity );\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <map_particle_fragment>\\n\\t#include <color_fragment>\\n\\t#include <alphatest_fragment>\\n\\toutgoingLight = diffuseColor.rgb;\\n\\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n\\t#include <premultiplied_alpha_fragment>\\n}\";\n\nvar points_vert = \"uniform float size;\\nuniform float scale;\\n#include <common>\\n#include <color_pars_vertex>\\n#include <fog_pars_vertex>\\n#include <morphtarget_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <color_vertex>\\n\\t#include <begin_vertex>\\n\\t#include <morphtarget_vertex>\\n\\t#include <project_vertex>\\n\\tgl_PointSize = size;\\n\\t#ifdef USE_SIZEATTENUATION\\n\\t\\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\\n\\t\\tif ( isPerspective ) gl_PointSize *= ( scale / - mvPosition.z );\\n\\t#endif\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\t#include <worldpos_vertex>\\n\\t#include <fog_vertex>\\n}\";\n\nvar shadow_frag = \"uniform vec3 color;\\nuniform float opacity;\\n#include <common>\\n#include <packing>\\n#include <fog_pars_fragment>\\n#include <bsdfs>\\n#include <lights_pars_begin>\\n#include <shadowmap_pars_fragment>\\n#include <shadowmask_pars_fragment>\\nvoid main() {\\n\\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n}\";\n\nvar shadow_vert = \"#include <common>\\n#include <fog_pars_vertex>\\n#include <shadowmap_pars_vertex>\\nvoid main() {\\n\\t#include <begin_vertex>\\n\\t#include <project_vertex>\\n\\t#include <worldpos_vertex>\\n\\t#include <beginnormal_vertex>\\n\\t#include <morphnormal_vertex>\\n\\t#include <skinbase_vertex>\\n\\t#include <skinnormal_vertex>\\n\\t#include <defaultnormal_vertex>\\n\\t#include <shadowmap_vertex>\\n\\t#include <fog_vertex>\\n}\";\n\nvar sprite_frag = \"uniform vec3 diffuse;\\nuniform float opacity;\\n#include <common>\\n#include <uv_pars_fragment>\\n#include <map_pars_fragment>\\n#include <alphamap_pars_fragment>\\n#include <fog_pars_fragment>\\n#include <logdepthbuf_pars_fragment>\\n#include <clipping_planes_pars_fragment>\\nvoid main() {\\n\\t#include <clipping_planes_fragment>\\n\\tvec3 outgoingLight = vec3( 0.0 );\\n\\tvec4 diffuseColor = vec4( diffuse, opacity );\\n\\t#include <logdepthbuf_fragment>\\n\\t#include <map_fragment>\\n\\t#include <alphamap_fragment>\\n\\t#include <alphatest_fragment>\\n\\toutgoingLight = diffuseColor.rgb;\\n\\tgl_FragColor = vec4( outgoingLight, diffuseColor.a );\\n\\t#include <tonemapping_fragment>\\n\\t#include <encodings_fragment>\\n\\t#include <fog_fragment>\\n}\";\n\nvar sprite_vert = \"uniform float rotation;\\nuniform vec2 center;\\n#include <common>\\n#include <uv_pars_vertex>\\n#include <fog_pars_vertex>\\n#include <logdepthbuf_pars_vertex>\\n#include <clipping_planes_pars_vertex>\\nvoid main() {\\n\\t#include <uv_vertex>\\n\\tvec4 mvPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\\n\\tvec2 scale;\\n\\tscale.x = length( vec3( modelMatrix[ 0 ].x, modelMatrix[ 0 ].y, modelMatrix[ 0 ].z ) );\\n\\tscale.y = length( vec3( modelMatrix[ 1 ].x, modelMatrix[ 1 ].y, modelMatrix[ 1 ].z ) );\\n\\t#ifndef USE_SIZEATTENUATION\\n\\t\\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\\n\\t\\tif ( isPerspective ) scale *= - mvPosition.z;\\n\\t#endif\\n\\tvec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale;\\n\\tvec2 rotatedPosition;\\n\\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\\n\\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\\n\\tmvPosition.xy += rotatedPosition;\\n\\tgl_Position = projectionMatrix * mvPosition;\\n\\t#include <logdepthbuf_vertex>\\n\\t#include <clipping_planes_vertex>\\n\\t#include <fog_vertex>\\n}\";\n\nconst ShaderChunk = {\n\talphamap_fragment: alphamap_fragment,\n\talphamap_pars_fragment: alphamap_pars_fragment,\n\talphatest_fragment: alphatest_fragment,\n\taomap_fragment: aomap_fragment,\n\taomap_pars_fragment: aomap_pars_fragment,\n\tbegin_vertex: begin_vertex,\n\tbeginnormal_vertex: beginnormal_vertex,\n\tbsdfs: bsdfs,\n\tbumpmap_pars_fragment: bumpmap_pars_fragment,\n\tclipping_planes_fragment: clipping_planes_fragment,\n\tclipping_planes_pars_fragment: clipping_planes_pars_fragment,\n\tclipping_planes_pars_vertex: clipping_planes_pars_vertex,\n\tclipping_planes_vertex: clipping_planes_vertex,\n\tcolor_fragment: color_fragment,\n\tcolor_pars_fragment: color_pars_fragment,\n\tcolor_pars_vertex: color_pars_vertex,\n\tcolor_vertex: color_vertex,\n\tcommon: common,\n\tcube_uv_reflection_fragment: cube_uv_reflection_fragment,\n\tdefaultnormal_vertex: defaultnormal_vertex,\n\tdisplacementmap_pars_vertex: displacementmap_pars_vertex,\n\tdisplacementmap_vertex: displacementmap_vertex,\n\temissivemap_fragment: emissivemap_fragment,\n\temissivemap_pars_fragment: emissivemap_pars_fragment,\n\tencodings_fragment: encodings_fragment,\n\tencodings_pars_fragment: encodings_pars_fragment,\n\tenvmap_fragment: envmap_fragment,\n\tenvmap_common_pars_fragment: envmap_common_pars_fragment,\n\tenvmap_pars_fragment: envmap_pars_fragment,\n\tenvmap_pars_vertex: envmap_pars_vertex,\n\tenvmap_physical_pars_fragment: envmap_physical_pars_fragment,\n\tenvmap_vertex: envmap_vertex,\n\tfog_vertex: fog_vertex,\n\tfog_pars_vertex: fog_pars_vertex,\n\tfog_fragment: fog_fragment,\n\tfog_pars_fragment: fog_pars_fragment,\n\tgradientmap_pars_fragment: gradientmap_pars_fragment,\n\tlightmap_fragment: lightmap_fragment,\n\tlightmap_pars_fragment: lightmap_pars_fragment,\n\tlights_lambert_vertex: lights_lambert_vertex,\n\tlights_pars_begin: lights_pars_begin,\n\tlights_toon_fragment: lights_toon_fragment,\n\tlights_toon_pars_fragment: lights_toon_pars_fragment,\n\tlights_phong_fragment: lights_phong_fragment,\n\tlights_phong_pars_fragment: lights_phong_pars_fragment,\n\tlights_physical_fragment: lights_physical_fragment,\n\tlights_physical_pars_fragment: lights_physical_pars_fragment,\n\tlights_fragment_begin: lights_fragment_begin,\n\tlights_fragment_maps: lights_fragment_maps,\n\tlights_fragment_end: lights_fragment_end,\n\tlogdepthbuf_fragment: logdepthbuf_fragment,\n\tlogdepthbuf_pars_fragment: logdepthbuf_pars_fragment,\n\tlogdepthbuf_pars_vertex: logdepthbuf_pars_vertex,\n\tlogdepthbuf_vertex: logdepthbuf_vertex,\n\tmap_fragment: map_fragment,\n\tmap_pars_fragment: map_pars_fragment,\n\tmap_particle_fragment: map_particle_fragment,\n\tmap_particle_pars_fragment: map_particle_pars_fragment,\n\tmetalnessmap_fragment: metalnessmap_fragment,\n\tmetalnessmap_pars_fragment: metalnessmap_pars_fragment,\n\tmorphnormal_vertex: morphnormal_vertex,\n\tmorphtarget_pars_vertex: morphtarget_pars_vertex,\n\tmorphtarget_vertex: morphtarget_vertex,\n\tnormal_fragment_begin: normal_fragment_begin,\n\tnormal_fragment_maps: normal_fragment_maps,\n\tnormalmap_pars_fragment: normalmap_pars_fragment,\n\tclearcoat_normal_fragment_begin: clearcoat_normal_fragment_begin,\n\tclearcoat_normal_fragment_maps: clearcoat_normal_fragment_maps,\n\tclearcoat_pars_fragment: clearcoat_pars_fragment,\n\tpacking: packing,\n\tpremultiplied_alpha_fragment: premultiplied_alpha_fragment,\n\tproject_vertex: project_vertex,\n\tdithering_fragment: dithering_fragment,\n\tdithering_pars_fragment: dithering_pars_fragment,\n\troughnessmap_fragment: roughnessmap_fragment,\n\troughnessmap_pars_fragment: roughnessmap_pars_fragment,\n\tshadowmap_pars_fragment: shadowmap_pars_fragment,\n\tshadowmap_pars_vertex: shadowmap_pars_vertex,\n\tshadowmap_vertex: shadowmap_vertex,\n\tshadowmask_pars_fragment: shadowmask_pars_fragment,\n\tskinbase_vertex: skinbase_vertex,\n\tskinning_pars_vertex: skinning_pars_vertex,\n\tskinning_vertex: skinning_vertex,\n\tskinnormal_vertex: skinnormal_vertex,\n\tspecularmap_fragment: specularmap_fragment,\n\tspecularmap_pars_fragment: specularmap_pars_fragment,\n\ttonemapping_fragment: tonemapping_fragment,\n\ttonemapping_pars_fragment: tonemapping_pars_fragment,\n\ttransmission_fragment: transmission_fragment,\n\ttransmission_pars_fragment: transmission_pars_fragment,\n\tuv_pars_fragment: uv_pars_fragment,\n\tuv_pars_vertex: uv_pars_vertex,\n\tuv_vertex: uv_vertex,\n\tuv2_pars_fragment: uv2_pars_fragment,\n\tuv2_pars_vertex: uv2_pars_vertex,\n\tuv2_vertex: uv2_vertex,\n\tworldpos_vertex: worldpos_vertex,\n\n\tbackground_frag: background_frag,\n\tbackground_vert: background_vert,\n\tcube_frag: cube_frag,\n\tcube_vert: cube_vert,\n\tdepth_frag: depth_frag,\n\tdepth_vert: depth_vert,\n\tdistanceRGBA_frag: distanceRGBA_frag,\n\tdistanceRGBA_vert: distanceRGBA_vert,\n\tequirect_frag: equirect_frag,\n\tequirect_vert: equirect_vert,\n\tlinedashed_frag: linedashed_frag,\n\tlinedashed_vert: linedashed_vert,\n\tmeshbasic_frag: meshbasic_frag,\n\tmeshbasic_vert: meshbasic_vert,\n\tmeshlambert_frag: meshlambert_frag,\n\tmeshlambert_vert: meshlambert_vert,\n\tmeshmatcap_frag: meshmatcap_frag,\n\tmeshmatcap_vert: meshmatcap_vert,\n\tmeshtoon_frag: meshtoon_frag,\n\tmeshtoon_vert: meshtoon_vert,\n\tmeshphong_frag: meshphong_frag,\n\tmeshphong_vert: meshphong_vert,\n\tmeshphysical_frag: meshphysical_frag,\n\tmeshphysical_vert: meshphysical_vert,\n\tnormal_frag: normal_frag,\n\tnormal_vert: normal_vert,\n\tpoints_frag: points_frag,\n\tpoints_vert: points_vert,\n\tshadow_frag: shadow_frag,\n\tshadow_vert: shadow_vert,\n\tsprite_frag: sprite_frag,\n\tsprite_vert: sprite_vert\n};\n\n/**\n * Uniforms library for shared webgl shaders\n */\n\nconst UniformsLib = {\n\n\tcommon: {\n\n\t\tdiffuse: { value: new Color( 0xffffff ) },\n\t\topacity: { value: 1.0 },\n\n\t\tmap: { value: null },\n\t\tuvTransform: { value: new Matrix3() },\n\t\tuv2Transform: { value: new Matrix3() },\n\n\t\talphaMap: { value: null },\n\n\t},\n\n\tspecularmap: {\n\n\t\tspecularMap: { value: null },\n\n\t},\n\n\tenvmap: {\n\n\t\tenvMap: { value: null },\n\t\tflipEnvMap: { value: - 1 },\n\t\treflectivity: { value: 1.0 },\n\t\trefractionRatio: { value: 0.98 },\n\t\tmaxMipLevel: { value: 0 }\n\n\t},\n\n\taomap: {\n\n\t\taoMap: { value: null },\n\t\taoMapIntensity: { value: 1 }\n\n\t},\n\n\tlightmap: {\n\n\t\tlightMap: { value: null },\n\t\tlightMapIntensity: { value: 1 }\n\n\t},\n\n\temissivemap: {\n\n\t\temissiveMap: { value: null }\n\n\t},\n\n\tbumpmap: {\n\n\t\tbumpMap: { value: null },\n\t\tbumpScale: { value: 1 }\n\n\t},\n\n\tnormalmap: {\n\n\t\tnormalMap: { value: null },\n\t\tnormalScale: { value: new Vector2( 1, 1 ) }\n\n\t},\n\n\tdisplacementmap: {\n\n\t\tdisplacementMap: { value: null },\n\t\tdisplacementScale: { value: 1 },\n\t\tdisplacementBias: { value: 0 }\n\n\t},\n\n\troughnessmap: {\n\n\t\troughnessMap: { value: null }\n\n\t},\n\n\tmetalnessmap: {\n\n\t\tmetalnessMap: { value: null }\n\n\t},\n\n\tgradientmap: {\n\n\t\tgradientMap: { value: null }\n\n\t},\n\n\tfog: {\n\n\t\tfogDensity: { value: 0.00025 },\n\t\tfogNear: { value: 1 },\n\t\tfogFar: { value: 2000 },\n\t\tfogColor: { value: new Color( 0xffffff ) }\n\n\t},\n\n\tlights: {\n\n\t\tambientLightColor: { value: [] },\n\n\t\tlightProbe: { value: [] },\n\n\t\tdirectionalLights: { value: [], properties: {\n\t\t\tdirection: {},\n\t\t\tcolor: {}\n\t\t} },\n\n\t\tdirectionalLightShadows: { value: [], properties: {\n\t\t\tshadowBias: {},\n\t\t\tshadowNormalBias: {},\n\t\t\tshadowRadius: {},\n\t\t\tshadowMapSize: {}\n\t\t} },\n\n\t\tdirectionalShadowMap: { value: [] },\n\t\tdirectionalShadowMatrix: { value: [] },\n\n\t\tspotLights: { value: [], properties: {\n\t\t\tcolor: {},\n\t\t\tposition: {},\n\t\t\tdirection: {},\n\t\t\tdistance: {},\n\t\t\tconeCos: {},\n\t\t\tpenumbraCos: {},\n\t\t\tdecay: {}\n\t\t} },\n\n\t\tspotLightShadows: { value: [], properties: {\n\t\t\tshadowBias: {},\n\t\t\tshadowNormalBias: {},\n\t\t\tshadowRadius: {},\n\t\t\tshadowMapSize: {}\n\t\t} },\n\n\t\tspotShadowMap: { value: [] },\n\t\tspotShadowMatrix: { value: [] },\n\n\t\tpointLights: { value: [], properties: {\n\t\t\tcolor: {},\n\t\t\tposition: {},\n\t\t\tdecay: {},\n\t\t\tdistance: {}\n\t\t} },\n\n\t\tpointLightShadows: { value: [], properties: {\n\t\t\tshadowBias: {},\n\t\t\tshadowNormalBias: {},\n\t\t\tshadowRadius: {},\n\t\t\tshadowMapSize: {},\n\t\t\tshadowCameraNear: {},\n\t\t\tshadowCameraFar: {}\n\t\t} },\n\n\t\tpointShadowMap: { value: [] },\n\t\tpointShadowMatrix: { value: [] },\n\n\t\themisphereLights: { value: [], properties: {\n\t\t\tdirection: {},\n\t\t\tskyColor: {},\n\t\t\tgroundColor: {}\n\t\t} },\n\n\t\t// TODO (abelnation): RectAreaLight BRDF data needs to be moved from example to main src\n\t\trectAreaLights: { value: [], properties: {\n\t\t\tcolor: {},\n\t\t\tposition: {},\n\t\t\twidth: {},\n\t\t\theight: {}\n\t\t} },\n\n\t\tltc_1: { value: null },\n\t\tltc_2: { value: null }\n\n\t},\n\n\tpoints: {\n\n\t\tdiffuse: { value: new Color( 0xffffff ) },\n\t\topacity: { value: 1.0 },\n\t\tsize: { value: 1.0 },\n\t\tscale: { value: 1.0 },\n\t\tmap: { value: null },\n\t\talphaMap: { value: null },\n\t\tuvTransform: { value: new Matrix3() }\n\n\t},\n\n\tsprite: {\n\n\t\tdiffuse: { value: new Color( 0xffffff ) },\n\t\topacity: { value: 1.0 },\n\t\tcenter: { value: new Vector2( 0.5, 0.5 ) },\n\t\trotation: { value: 0.0 },\n\t\tmap: { value: null },\n\t\talphaMap: { value: null },\n\t\tuvTransform: { value: new Matrix3() }\n\n\t}\n\n};\n\nconst ShaderLib = {\n\n\tbasic: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.specularmap,\n\t\t\tUniformsLib.envmap,\n\t\t\tUniformsLib.aomap,\n\t\t\tUniformsLib.lightmap,\n\t\t\tUniformsLib.fog\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.meshbasic_vert,\n\t\tfragmentShader: ShaderChunk.meshbasic_frag\n\n\t},\n\n\tlambert: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.specularmap,\n\t\t\tUniformsLib.envmap,\n\t\t\tUniformsLib.aomap,\n\t\t\tUniformsLib.lightmap,\n\t\t\tUniformsLib.emissivemap,\n\t\t\tUniformsLib.fog,\n\t\t\tUniformsLib.lights,\n\t\t\t{\n\t\t\t\temissive: { value: new Color( 0x000000 ) }\n\t\t\t}\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.meshlambert_vert,\n\t\tfragmentShader: ShaderChunk.meshlambert_frag\n\n\t},\n\n\tphong: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.specularmap,\n\t\t\tUniformsLib.envmap,\n\t\t\tUniformsLib.aomap,\n\t\t\tUniformsLib.lightmap,\n\t\t\tUniformsLib.emissivemap,\n\t\t\tUniformsLib.bumpmap,\n\t\t\tUniformsLib.normalmap,\n\t\t\tUniformsLib.displacementmap,\n\t\t\tUniformsLib.fog,\n\t\t\tUniformsLib.lights,\n\t\t\t{\n\t\t\t\temissive: { value: new Color( 0x000000 ) },\n\t\t\t\tspecular: { value: new Color( 0x111111 ) },\n\t\t\t\tshininess: { value: 30 }\n\t\t\t}\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.meshphong_vert,\n\t\tfragmentShader: ShaderChunk.meshphong_frag\n\n\t},\n\n\tstandard: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.envmap,\n\t\t\tUniformsLib.aomap,\n\t\t\tUniformsLib.lightmap,\n\t\t\tUniformsLib.emissivemap,\n\t\t\tUniformsLib.bumpmap,\n\t\t\tUniformsLib.normalmap,\n\t\t\tUniformsLib.displacementmap,\n\t\t\tUniformsLib.roughnessmap,\n\t\t\tUniformsLib.metalnessmap,\n\t\t\tUniformsLib.fog,\n\t\t\tUniformsLib.lights,\n\t\t\t{\n\t\t\t\temissive: { value: new Color( 0x000000 ) },\n\t\t\t\troughness: { value: 1.0 },\n\t\t\t\tmetalness: { value: 0.0 },\n\t\t\t\tenvMapIntensity: { value: 1 } // temporary\n\t\t\t}\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.meshphysical_vert,\n\t\tfragmentShader: ShaderChunk.meshphysical_frag\n\n\t},\n\n\ttoon: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.aomap,\n\t\t\tUniformsLib.lightmap,\n\t\t\tUniformsLib.emissivemap,\n\t\t\tUniformsLib.bumpmap,\n\t\t\tUniformsLib.normalmap,\n\t\t\tUniformsLib.displacementmap,\n\t\t\tUniformsLib.gradientmap,\n\t\t\tUniformsLib.fog,\n\t\t\tUniformsLib.lights,\n\t\t\t{\n\t\t\t\temissive: { value: new Color( 0x000000 ) }\n\t\t\t}\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.meshtoon_vert,\n\t\tfragmentShader: ShaderChunk.meshtoon_frag\n\n\t},\n\n\tmatcap: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.bumpmap,\n\t\t\tUniformsLib.normalmap,\n\t\t\tUniformsLib.displacementmap,\n\t\t\tUniformsLib.fog,\n\t\t\t{\n\t\t\t\tmatcap: { value: null }\n\t\t\t}\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.meshmatcap_vert,\n\t\tfragmentShader: ShaderChunk.meshmatcap_frag\n\n\t},\n\n\tpoints: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.points,\n\t\t\tUniformsLib.fog\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.points_vert,\n\t\tfragmentShader: ShaderChunk.points_frag\n\n\t},\n\n\tdashed: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.fog,\n\t\t\t{\n\t\t\t\tscale: { value: 1 },\n\t\t\t\tdashSize: { value: 1 },\n\t\t\t\ttotalSize: { value: 2 }\n\t\t\t}\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.linedashed_vert,\n\t\tfragmentShader: ShaderChunk.linedashed_frag\n\n\t},\n\n\tdepth: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.displacementmap\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.depth_vert,\n\t\tfragmentShader: ShaderChunk.depth_frag\n\n\t},\n\n\tnormal: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.bumpmap,\n\t\t\tUniformsLib.normalmap,\n\t\t\tUniformsLib.displacementmap,\n\t\t\t{\n\t\t\t\topacity: { value: 1.0 }\n\t\t\t}\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.normal_vert,\n\t\tfragmentShader: ShaderChunk.normal_frag\n\n\t},\n\n\tsprite: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.sprite,\n\t\t\tUniformsLib.fog\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.sprite_vert,\n\t\tfragmentShader: ShaderChunk.sprite_frag\n\n\t},\n\n\tbackground: {\n\n\t\tuniforms: {\n\t\t\tuvTransform: { value: new Matrix3() },\n\t\t\tt2D: { value: null },\n\t\t},\n\n\t\tvertexShader: ShaderChunk.background_vert,\n\t\tfragmentShader: ShaderChunk.background_frag\n\n\t},\n\t/* -------------------------------------------------------------------------\n\t//\tCube map shader\n\t ------------------------------------------------------------------------- */\n\n\tcube: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.envmap,\n\t\t\t{\n\t\t\t\topacity: { value: 1.0 }\n\t\t\t}\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.cube_vert,\n\t\tfragmentShader: ShaderChunk.cube_frag\n\n\t},\n\n\tequirect: {\n\n\t\tuniforms: {\n\t\t\ttEquirect: { value: null },\n\t\t},\n\n\t\tvertexShader: ShaderChunk.equirect_vert,\n\t\tfragmentShader: ShaderChunk.equirect_frag\n\n\t},\n\n\tdistanceRGBA: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.common,\n\t\t\tUniformsLib.displacementmap,\n\t\t\t{\n\t\t\t\treferencePosition: { value: new Vector3() },\n\t\t\t\tnearDistance: { value: 1 },\n\t\t\t\tfarDistance: { value: 1000 }\n\t\t\t}\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.distanceRGBA_vert,\n\t\tfragmentShader: ShaderChunk.distanceRGBA_frag\n\n\t},\n\n\tshadow: {\n\n\t\tuniforms: mergeUniforms( [\n\t\t\tUniformsLib.lights,\n\t\t\tUniformsLib.fog,\n\t\t\t{\n\t\t\t\tcolor: { value: new Color( 0x00000 ) },\n\t\t\t\topacity: { value: 1.0 }\n\t\t\t},\n\t\t] ),\n\n\t\tvertexShader: ShaderChunk.shadow_vert,\n\t\tfragmentShader: ShaderChunk.shadow_frag\n\n\t}\n\n};\n\nShaderLib.physical = {\n\n\tuniforms: mergeUniforms( [\n\t\tShaderLib.standard.uniforms,\n\t\t{\n\t\t\tclearcoat: { value: 0 },\n\t\t\tclearcoatMap: { value: null },\n\t\t\tclearcoatRoughness: { value: 0 },\n\t\t\tclearcoatRoughnessMap: { value: null },\n\t\t\tclearcoatNormalScale: { value: new Vector2( 1, 1 ) },\n\t\t\tclearcoatNormalMap: { value: null },\n\t\t\tsheen: { value: new Color( 0x000000 ) },\n\t\t\ttransmission: { value: 0 },\n\t\t\ttransmissionMap: { value: null },\n\t\t\ttransmissionSamplerSize: { value: new Vector2() },\n\t\t\ttransmissionSamplerMap: { value: null },\n\t\t\tthickness: { value: 0 },\n\t\t\tthicknessMap: { value: null },\n\t\t\tattenuationDistance: { value: 0 },\n\t\t\tattenuationColor: { value: new Color( 0x000000 ) }\n\t\t}\n\t] ),\n\n\tvertexShader: ShaderChunk.meshphysical_vert,\n\tfragmentShader: ShaderChunk.meshphysical_frag\n\n};\n\nfunction WebGLBackground( renderer, cubemaps, state, objects, premultipliedAlpha ) {\n\n\tconst clearColor = new Color( 0x000000 );\n\tlet clearAlpha = 0;\n\n\tlet planeMesh;\n\tlet boxMesh;\n\n\tlet currentBackground = null;\n\tlet currentBackgroundVersion = 0;\n\tlet currentTonemapping = null;\n\n\tfunction render( renderList, scene ) {\n\n\t\tlet forceClear = false;\n\t\tlet background = scene.isScene === true ? scene.background : null;\n\n\t\tif ( background && background.isTexture ) {\n\n\t\t\tbackground = cubemaps.get( background );\n\n\t\t}\n\n\t\t// Ignore background in AR\n\t\t// TODO: Reconsider this.\n\n\t\tconst xr = renderer.xr;\n\t\tconst session = xr.getSession && xr.getSession();\n\n\t\tif ( session && session.environmentBlendMode === 'additive' ) {\n\n\t\t\tbackground = null;\n\n\t\t}\n\n\t\tif ( background === null ) {\n\n\t\t\tsetClear( clearColor, clearAlpha );\n\n\t\t} else if ( background && background.isColor ) {\n\n\t\t\tsetClear( background, 1 );\n\t\t\tforceClear = true;\n\n\t\t}\n\n\t\tif ( renderer.autoClear || forceClear ) {\n\n\t\t\trenderer.clear( renderer.autoClearColor, renderer.autoClearDepth, renderer.autoClearStencil );\n\n\t\t}\n\n\t\tif ( background && ( background.isCubeTexture || background.mapping === CubeUVReflectionMapping ) ) {\n\n\t\t\tif ( boxMesh === undefined ) {\n\n\t\t\t\tboxMesh = new Mesh(\n\t\t\t\t\tnew BoxGeometry( 1, 1, 1 ),\n\t\t\t\t\tnew ShaderMaterial( {\n\t\t\t\t\t\tname: 'BackgroundCubeMaterial',\n\t\t\t\t\t\tuniforms: cloneUniforms( ShaderLib.cube.uniforms ),\n\t\t\t\t\t\tvertexShader: ShaderLib.cube.vertexShader,\n\t\t\t\t\t\tfragmentShader: ShaderLib.cube.fragmentShader,\n\t\t\t\t\t\tside: BackSide,\n\t\t\t\t\t\tdepthTest: false,\n\t\t\t\t\t\tdepthWrite: false,\n\t\t\t\t\t\tfog: false\n\t\t\t\t\t} )\n\t\t\t\t);\n\n\t\t\t\tboxMesh.geometry.deleteAttribute( 'normal' );\n\t\t\t\tboxMesh.geometry.deleteAttribute( 'uv' );\n\n\t\t\t\tboxMesh.onBeforeRender = function ( renderer, scene, camera ) {\n\n\t\t\t\t\tthis.matrixWorld.copyPosition( camera.matrixWorld );\n\n\t\t\t\t};\n\n\t\t\t\t// enable code injection for non-built-in material\n\t\t\t\tObject.defineProperty( boxMesh.material, 'envMap', {\n\n\t\t\t\t\tget: function () {\n\n\t\t\t\t\t\treturn this.uniforms.envMap.value;\n\n\t\t\t\t\t}\n\n\t\t\t\t} );\n\n\t\t\t\tobjects.update( boxMesh );\n\n\t\t\t}\n\n\t\t\tboxMesh.material.uniforms.envMap.value = background;\n\t\t\tboxMesh.material.uniforms.flipEnvMap.value = ( background.isCubeTexture && background._needsFlipEnvMap ) ? - 1 : 1;\n\n\t\t\tif ( currentBackground !== background ||\n\t\t\t\tcurrentBackgroundVersion !== background.version ||\n\t\t\t\tcurrentTonemapping !== renderer.toneMapping ) {\n\n\t\t\t\tboxMesh.material.needsUpdate = true;\n\n\t\t\t\tcurrentBackground = background;\n\t\t\t\tcurrentBackgroundVersion = background.version;\n\t\t\t\tcurrentTonemapping = renderer.toneMapping;\n\n\t\t\t}\n\n\t\t\t// push to the pre-sorted opaque render list\n\t\t\trenderList.unshift( boxMesh, boxMesh.geometry, boxMesh.material, 0, 0, null );\n\n\t\t} else if ( background && background.isTexture ) {\n\n\t\t\tif ( planeMesh === undefined ) {\n\n\t\t\t\tplaneMesh = new Mesh(\n\t\t\t\t\tnew PlaneGeometry( 2, 2 ),\n\t\t\t\t\tnew ShaderMaterial( {\n\t\t\t\t\t\tname: 'BackgroundMaterial',\n\t\t\t\t\t\tuniforms: cloneUniforms( ShaderLib.background.uniforms ),\n\t\t\t\t\t\tvertexShader: ShaderLib.background.vertexShader,\n\t\t\t\t\t\tfragmentShader: ShaderLib.background.fragmentShader,\n\t\t\t\t\t\tside: FrontSide,\n\t\t\t\t\t\tdepthTest: false,\n\t\t\t\t\t\tdepthWrite: false,\n\t\t\t\t\t\tfog: false\n\t\t\t\t\t} )\n\t\t\t\t);\n\n\t\t\t\tplaneMesh.geometry.deleteAttribute( 'normal' );\n\n\t\t\t\t// enable code injection for non-built-in material\n\t\t\t\tObject.defineProperty( planeMesh.material, 'map', {\n\n\t\t\t\t\tget: function () {\n\n\t\t\t\t\t\treturn this.uniforms.t2D.value;\n\n\t\t\t\t\t}\n\n\t\t\t\t} );\n\n\t\t\t\tobjects.update( planeMesh );\n\n\t\t\t}\n\n\t\t\tplaneMesh.material.uniforms.t2D.value = background;\n\n\t\t\tif ( background.matrixAutoUpdate === true ) {\n\n\t\t\t\tbackground.updateMatrix();\n\n\t\t\t}\n\n\t\t\tplaneMesh.material.uniforms.uvTransform.value.copy( background.matrix );\n\n\t\t\tif ( currentBackground !== background ||\n\t\t\t\tcurrentBackgroundVersion !== background.version ||\n\t\t\t\tcurrentTonemapping !== renderer.toneMapping ) {\n\n\t\t\t\tplaneMesh.material.needsUpdate = true;\n\n\t\t\t\tcurrentBackground = background;\n\t\t\t\tcurrentBackgroundVersion = background.version;\n\t\t\t\tcurrentTonemapping = renderer.toneMapping;\n\n\t\t\t}\n\n\n\t\t\t// push to the pre-sorted opaque render list\n\t\t\trenderList.unshift( planeMesh, planeMesh.geometry, planeMesh.material, 0, 0, null );\n\n\t\t}\n\n\t}\n\n\tfunction setClear( color, alpha ) {\n\n\t\tstate.buffers.color.setClear( color.r, color.g, color.b, alpha, premultipliedAlpha );\n\n\t}\n\n\treturn {\n\n\t\tgetClearColor: function () {\n\n\t\t\treturn clearColor;\n\n\t\t},\n\t\tsetClearColor: function ( color, alpha = 1 ) {\n\n\t\t\tclearColor.set( color );\n\t\t\tclearAlpha = alpha;\n\t\t\tsetClear( clearColor, clearAlpha );\n\n\t\t},\n\t\tgetClearAlpha: function () {\n\n\t\t\treturn clearAlpha;\n\n\t\t},\n\t\tsetClearAlpha: function ( alpha ) {\n\n\t\t\tclearAlpha = alpha;\n\t\t\tsetClear( clearColor, clearAlpha );\n\n\t\t},\n\t\trender: render\n\n\t};\n\n}\n\nfunction WebGLBindingStates( gl, extensions, attributes, capabilities ) {\n\n\tconst maxVertexAttributes = gl.getParameter( 34921 );\n\n\tconst extension = capabilities.isWebGL2 ? null : extensions.get( 'OES_vertex_array_object' );\n\tconst vaoAvailable = capabilities.isWebGL2 || extension !== null;\n\n\tconst bindingStates = {};\n\n\tconst defaultState = createBindingState( null );\n\tlet currentState = defaultState;\n\n\tfunction setup( object, material, program, geometry, index ) {\n\n\t\tlet updateBuffers = false;\n\n\t\tif ( vaoAvailable ) {\n\n\t\t\tconst state = getBindingState( geometry, program, material );\n\n\t\t\tif ( currentState !== state ) {\n\n\t\t\t\tcurrentState = state;\n\t\t\t\tbindVertexArrayObject( currentState.object );\n\n\t\t\t}\n\n\t\t\tupdateBuffers = needsUpdate( geometry, index );\n\n\t\t\tif ( updateBuffers ) saveCache( geometry, index );\n\n\t\t} else {\n\n\t\t\tconst wireframe = ( material.wireframe === true );\n\n\t\t\tif ( currentState.geometry !== geometry.id ||\n\t\t\t\tcurrentState.program !== program.id ||\n\t\t\t\tcurrentState.wireframe !== wireframe ) {\n\n\t\t\t\tcurrentState.geometry = geometry.id;\n\t\t\t\tcurrentState.program = program.id;\n\t\t\t\tcurrentState.wireframe = wireframe;\n\n\t\t\t\tupdateBuffers = true;\n\n\t\t\t}\n\n\t\t}\n\n\t\tif ( object.isInstancedMesh === true ) {\n\n\t\t\tupdateBuffers = true;\n\n\t\t}\n\n\t\tif ( index !== null ) {\n\n\t\t\tattributes.update( index, 34963 );\n\n\t\t}\n\n\t\tif ( updateBuffers ) {\n\n\t\t\tsetupVertexAttributes( object, material, program, geometry );\n\n\t\t\tif ( index !== null ) {\n\n\t\t\t\tgl.bindBuffer( 34963, attributes.get( index ).buffer );\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\tfunction createVertexArrayObject() {\n\n\t\tif ( capabilities.isWebGL2 ) return gl.createVertexArray();\n\n\t\treturn extension.createVertexArrayOES();\n\n\t}\n\n\tfunction bindVertexArrayObject( vao ) {\n\n\t\tif ( capabilities.isWebGL2 ) return gl.bindVertexArray( vao );\n\n\t\treturn extension.bindVertexArrayOES( vao );\n\n\t}\n\n\tfunction deleteVertexArrayObject( vao ) {\n\n\t\tif ( capabilities.isWebGL2 ) return gl.deleteVertexArray( vao );\n\n\t\treturn extension.deleteVertexArrayOES( vao );\n\n\t}\n\n\tfunction getBindingState( geometry, program, material ) {\n\n\t\tconst wireframe = ( material.wireframe === true );\n\n\t\tlet programMap = bindingStates[ geometry.id ];\n\n\t\tif ( programMap === undefined ) {\n\n\t\t\tprogramMap = {};\n\t\t\tbindingStates[ geometry.id ] = programMap;\n\n\t\t}\n\n\t\tlet stateMap = programMap[ program.id ];\n\n\t\tif ( stateMap === undefined ) {\n\n\t\t\tstateMap = {};\n\t\t\tprogramMap[ program.id ] = stateMap;\n\n\t\t}\n\n\t\tlet state = stateMap[ wireframe ];\n\n\t\tif ( state === undefined ) {\n\n\t\t\tstate = createBindingState( createVertexArrayObject() );\n\t\t\tstateMap[ wireframe ] = state;\n\n\t\t}\n\n\t\treturn state;\n\n\t}\n\n\tfunction createBindingState( vao ) {\n\n\t\tconst newAttributes = [];\n\t\tconst enabledAttributes = [];\n\t\tconst attributeDivisors = [];\n\n\t\tfor ( let i = 0; i < maxVertexAttributes; i ++ ) {\n\n\t\t\tnewAttributes[ i ] = 0;\n\t\t\tenabledAttributes[ i ] = 0;\n\t\t\tattributeDivisors[ i ] = 0;\n\n\t\t}\n\n\t\treturn {\n\n\t\t\t// for backward compatibility on non-VAO support browser\n\t\t\tgeometry: null,\n\t\t\tprogram: null,\n\t\t\twireframe: false,\n\n\t\t\tnewAttributes: newAttributes,\n\t\t\tenabledAttributes: enabledAttributes,\n\t\t\tattributeDivisors: attributeDivisors,\n\t\t\tobject: vao,\n\t\t\tattributes: {},\n\t\t\tindex: null\n\n\t\t};\n\n\t}\n\n\tfunction needsUpdate( geometry, index ) {\n\n\t\tconst cachedAttributes = currentState.attributes;\n\t\tconst geometryAttributes = geometry.attributes;\n\n\t\tlet attributesNum = 0;\n\n\t\tfor ( const key in geometryAttributes ) {\n\n\t\t\tconst cachedAttribute = cachedAttributes[ key ];\n\t\t\tconst geometryAttribute = geometryAttributes[ key ];\n\n\t\t\tif ( cachedAttribute === undefined ) return true;\n\n\t\t\tif ( cachedAttribute.attribute !== geometryAttribute ) return true;\n\n\t\t\tif ( cachedAttribute.data !== geometryAttribute.data ) return true;\n\n\t\t\tattributesNum ++;\n\n\t\t}\n\n\t\tif ( currentState.attributesNum !== attributesNum ) return true;\n\n\t\tif ( currentState.index !== index ) return true;\n\n\t\treturn false;\n\n\t}\n\n\tfunction saveCache( geometry, index ) {\n\n\t\tconst cache = {};\n\t\tconst attributes = geometry.attributes;\n\t\tlet attributesNum = 0;\n\n\t\tfor ( const key in attributes ) {\n\n\t\t\tconst attribute = attributes[ key ];\n\n\t\t\tconst data = {};\n\t\t\tdata.attribute = attribute;\n\n\t\t\tif ( attribute.data ) {\n\n\t\t\t\tdata.data = attribute.data;\n\n\t\t\t}\n\n\t\t\tcache[ key ] = data;\n\n\t\t\tattributesNum ++;\n\n\t\t}\n\n\t\tcurrentState.attributes = cache;\n\t\tcurrentState.attributesNum = attributesNum;\n\n\t\tcurrentState.index = index;\n\n\t}\n\n\tfunction initAttributes() {\n\n\t\tconst newAttributes = currentState.newAttributes;\n\n\t\tfor ( let i = 0, il = newAttributes.length; i < il; i ++ ) {\n\n\t\t\tnewAttributes[ i ] = 0;\n\n\t\t}\n\n\t}\n\n\tfunction enableAttribute( attribute ) {\n\n\t\tenableAttributeAndDivisor( attribute, 0 );\n\n\t}\n\n\tfunction enableAttributeAndDivisor( attribute, meshPerAttribute ) {\n\n\t\tconst newAttributes = currentState.newAttributes;\n\t\tconst enabledAttributes = currentState.enabledAttributes;\n\t\tconst attributeDivisors = currentState.attributeDivisors;\n\n\t\tnewAttributes[ attribute ] = 1;\n\n\t\tif ( enabledAttributes[ attribute ] === 0 ) {\n\n\t\t\tgl.enableVertexAttribArray( attribute );\n\t\t\tenabledAttributes[ attribute ] = 1;\n\n\t\t}\n\n\t\tif ( attributeDivisors[ attribute ] !== meshPerAttribute ) {\n\n\t\t\tconst extension = capabilities.isWebGL2 ? gl : extensions.get( 'ANGLE_instanced_arrays' );\n\n\t\t\textension[ capabilities.isWebGL2 ? 'vertexAttribDivisor' : 'vertexAttribDivisorANGLE' ]( attribute, meshPerAttribute );\n\t\t\tattributeDivisors[ attribute ] = meshPerAttribute;\n\n\t\t}\n\n\t}\n\n\tfunction disableUnusedAttributes() {\n\n\t\tconst newAttributes = currentState.newAttributes;\n\t\tconst enabledAttributes = currentState.enabledAttributes;\n\n\t\tfor ( let i = 0, il = enabledAttributes.length; i < il; i ++ ) {\n\n\t\t\tif ( enabledAttributes[ i ] !== newAttributes[ i ] ) {\n\n\t\t\t\tgl.disableVertexAttribArray( i );\n\t\t\t\tenabledAttributes[ i ] = 0;\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\tfunction vertexAttribPointer( index, size, type, normalized, stride, offset ) {\n\n\t\tif ( capabilities.isWebGL2 === true && ( type === 5124 || type === 5125 ) ) {\n\n\t\t\tgl.vertexAttribIPointer( index, size, type, stride, offset );\n\n\t\t} else {\n\n\t\t\tgl.vertexAttribPointer( index, size, type, normalized, stride, offset );\n\n\t\t}\n\n\t}\n\n\tfunction setupVertexAttributes( object, material, program, geometry ) {\n\n\t\tif ( capabilities.isWebGL2 === false && ( object.isInstancedMesh || geometry.isInstancedBufferGeometry ) ) {\n\n\t\t\tif ( extensions.get( 'ANGLE_instanced_arrays' ) === null ) return;\n\n\t\t}\n\n\t\tinitAttributes();\n\n\t\tconst geometryAttributes = geometry.attributes;\n\n\t\tconst programAttributes = program.getAttributes();\n\n\t\tconst materialDefaultAttributeValues = material.defaultAttributeValues;\n\n\t\tfor ( const name in programAttributes ) {\n\n\t\t\tconst programAttribute = programAttributes[ name ];\n\n\t\t\tif ( programAttribute >= 0 ) {\n\n\t\t\t\tconst geometryAttribute = geometryAttributes[ name ];\n\n\t\t\t\tif ( geometryAttribute !== undefined ) {\n\n\t\t\t\t\tconst normalized = geometryAttribute.normalized;\n\t\t\t\t\tconst size = geometryAttribute.itemSize;\n\n\t\t\t\t\tconst attribute = attributes.get( geometryAttribute );\n\n\t\t\t\t\t// TODO Attribute may not be available on context restore\n\n\t\t\t\t\tif ( attribute === undefined ) continue;\n\n\t\t\t\t\tconst buffer = attribute.buffer;\n\t\t\t\t\tconst type = attribute.type;\n\t\t\t\t\tconst bytesPerElement = attribute.bytesPerElement;\n\n\t\t\t\t\tif ( geometryAttribute.isInterleavedBufferAttribute ) {\n\n\t\t\t\t\t\tconst data = geometryAttribute.data;\n\t\t\t\t\t\tconst stride = data.stride;\n\t\t\t\t\t\tconst offset = geometryAttribute.offset;\n\n\t\t\t\t\t\tif ( data && data.isInstancedInterleavedBuffer ) {\n\n\t\t\t\t\t\t\tenableAttributeAndDivisor( programAttribute, data.meshPerAttribute );\n\n\t\t\t\t\t\t\tif ( geometry._maxInstanceCount === undefined ) {\n\n\t\t\t\t\t\t\t\tgeometry._maxInstanceCount = data.meshPerAttribute * data.count;\n\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\tenableAttribute( programAttribute );\n\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tgl.bindBuffer( 34962, buffer );\n\t\t\t\t\t\tvertexAttribPointer( programAttribute, size, type, normalized, stride * bytesPerElement, offset * bytesPerElement );\n\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\tif ( geometryAttribute.isInstancedBufferAttribute ) {\n\n\t\t\t\t\t\t\tenableAttributeAndDivisor( programAttribute, geometryAttribute.meshPerAttribute );\n\n\t\t\t\t\t\t\tif ( geometry._maxInstanceCount === undefined ) {\n\n\t\t\t\t\t\t\t\tgeometry._maxInstanceCount = geometryAttribute.meshPerAttribute * geometryAttribute.count;\n\n\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t} else {\n\n\t\t\t\t\t\t\tenableAttribute( programAttribute );\n\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tgl.bindBuffer( 34962, buffer );\n\t\t\t\t\t\tvertexAttribPointer( programAttribute, size, type, normalized, 0, 0 );\n\n\t\t\t\t\t}\n\n\t\t\t\t} else if ( name === 'instanceMatrix' ) {\n\n\t\t\t\t\tconst attribute = attributes.get( object.instanceMatrix );\n\n\t\t\t\t\t// TODO Attribute may not be available on context restore\n\n\t\t\t\t\tif ( attribute === undefined ) continue;\n\n\t\t\t\t\tconst buffer = attribute.buffer;\n\t\t\t\t\tconst type = attribute.type;\n\n\t\t\t\t\tenableAttributeAndDivisor( programAttribute + 0, 1 );\n\t\t\t\t\tenableAttributeAndDivisor( programAttribute + 1, 1 );\n\t\t\t\t\tenableAttributeAndDivisor( programAttribute + 2, 1 );\n\t\t\t\t\tenableAttributeAndDivisor( programAttribute + 3, 1 );\n\n\t\t\t\t\tgl.bindBuffer( 34962, buffer );\n\n\t\t\t\t\tgl.vertexAttribPointer( programAttribute + 0, 4, type, false, 64, 0 );\n\t\t\t\t\tgl.vertexAttribPointer( programAttribute + 1, 4, type, false, 64, 16 );\n\t\t\t\t\tgl.vertexAttribPointer( programAttribute + 2, 4, type, false, 64, 32 );\n\t\t\t\t\tgl.vertexAttribPointer( programAttribute + 3, 4, type, false, 64, 48 );\n\n\t\t\t\t} else if ( name === 'instanceColor' ) {\n\n\t\t\t\t\tconst attribute = attributes.get( object.instanceColor );\n\n\t\t\t\t\t// TODO Attribute may not be available on context restore\n\n\t\t\t\t\tif ( attribute === undefined ) continue;\n\n\t\t\t\t\tconst buffer = attribute.buffer;\n\t\t\t\t\tconst type = attribute.type;\n\n\t\t\t\t\tenableAttributeAndDivisor( programAttribute, 1 );\n\n\t\t\t\t\tgl.bindBuffer( 34962, buffer );\n\n\t\t\t\t\tgl.vertexAttribPointer( programAttribute, 3, type, false, 12, 0 );\n\n\t\t\t\t} else if ( materialDefaultAttributeValues !== undefined ) {\n\n\t\t\t\t\tconst value = materialDefaultAttributeValues[ name ];\n\n\t\t\t\t\tif ( value !== undefined ) {\n\n\t\t\t\t\t\tswitch ( value.length ) {\n\n\t\t\t\t\t\t\tcase 2:\n\t\t\t\t\t\t\t\tgl.vertexAttrib2fv( programAttribute, value );\n\t\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t\tcase 3:\n\t\t\t\t\t\t\t\tgl.vertexAttrib3fv( programAttribute, value );\n\t\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t\tcase 4:\n\t\t\t\t\t\t\t\tgl.vertexAttrib4fv( programAttribute, value );\n\t\t\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\t\tgl.vertexAttrib1fv( programAttribute, value );\n\n\t\t\t\t\t\t}\n\n\t\t\t\t\t}\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t}\n\n\t\tdisableUnusedAttributes();\n\n\t}\n\n\tfunction dispose() {\n\n\t\treset();\n\n\t\tfor ( const geometryId in bindingStates ) {\n\n\t\t\tconst programMap = bindingStates[ geometryId ];\n\n\t\t\tfor ( const programId in programMap ) {\n\n\t\t\t\tconst stateMap = programMap[ programId ];\n\n\t\t\t\tfor ( const wireframe in stateMap ) {\n\n\t\t\t\t\tdeleteVertexArrayObject( stateMap[ wireframe ].object );\n\n\t\t\t\t\tdelete stateMap[ wireframe ];\n\n\t\t\t\t}\n\n\t\t\t\tdelete programMap[ programId ];\n\n\t\t\t}\n\n\t\t\tdelete bindingStates[ geometryId ];\n\n\t\t}\n\n\t}\n\n\tfunction releaseStatesOfGeometry( geometry ) {\n\n\t\tif ( bindingStates[ geometry.id ] === undefined ) return;\n\n\t\tconst programMap = bindingStates[ geometry.id ];\n\n\t\tfor ( const programId in programMap ) {\n\n\t\t\tconst stateMap = programMap[ programId ];\n\n\t\t\tfor ( const wireframe in stateMap ) {\n\n\t\t\t\tdeleteVertexArrayObject( stateMap[ wireframe ].object );\n\n\t\t\t\tdelete stateMap[ wireframe ];\n\n\t\t\t}\n\n\t\t\tdelete programMap[ programId ];\n\n\t\t}\n\n\t\tdelete bindingStates[ geometry.id ];\n\n\t}\n\n\tfunction releaseStatesOfProgram( program ) {\n\n\t\tfor ( const geometryId in bindingStates ) {\n\n\t\t\tconst programMap = bindingStates[ geometryId ];\n\n\t\t\tif ( programMap[ program.id ] === undefined ) continue;\n\n\t\t\tconst stateMap = programMap[ program.id ];\n\n\t\t\tfor ( const wireframe in stateMap ) {\n\n\t\t\t\tdeleteVertexArrayObject( stateMap[ wireframe ].object );\n\n\t\t\t\tdelete stateMap[ wireframe ];\n\n\t\t\t}\n\n\t\t\tdelete programMap[ program.id ];\n\n\t\t}\n\n\t}\n\n\tfunction reset() {\n\n\t\tresetDefaultState();\n\n\t\tif ( currentState === defaultState ) return;\n\n\t\tcurrentState = defaultState;\n\t\tbindVertexArrayObject( currentState.object );\n\n\t}\n\n\t// for backward-compatilibity\n\n\tfunction resetDefaultState() {\n\n\t\tdefaultState.geometry = null;\n\t\tdefaultState.program = null;\n\t\tdefaultState.wireframe = false;\n\n\t}\n\n\treturn {\n\n\t\tsetup: setup,\n\t\treset: reset,\n\t\tresetDefaultState: resetDefaultState,\n\t\tdispose: dispose,\n\t\treleaseStatesOfGeometry: releaseStatesOfGeometry,\n\t\treleaseStatesOfProgram: releaseStatesOfProgram,\n\n\t\tinitAttributes: initAttributes,\n\t\tenableAttribute: enableAttribute,\n\t\tdisableUnusedAttributes: disableUnusedAttributes\n\n\t};\n\n}\n\nfunction WebGLBufferRenderer( gl, extensions, info, capabilities ) {\n\n\tconst isWebGL2 = capabilities.isWebGL2;\n\n\tlet mode;\n\n\tfunction setMode( value ) {\n\n\t\tmode = value;\n\n\t}\n\n\tfunction render( start, count ) {\n\n\t\tgl.drawArrays( mode, start, count );\n\n\t\tinfo.update( count, mode, 1 );\n\n\t}\n\n\tfunction renderInstances( start, count, primcount ) {\n\n\t\tif ( primcount === 0 ) return;\n\n\t\tlet extension, methodName;\n\n\t\tif ( isWebGL2 ) {\n\n\t\t\textension = gl;\n\t\t\tmethodName = 'drawArraysInstanced';\n\n\t\t} else {\n\n\t\t\textension = extensions.get( 'ANGLE_instanced_arrays' );\n\t\t\tmethodName = 'drawArraysInstancedANGLE';\n\n\t\t\tif ( extension === null ) {\n\n\t\t\t\tconsole.error( 'THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.' );\n\t\t\t\treturn;\n\n\t\t\t}\n\n\t\t}\n\n\t\textension[ methodName ]( mode, start, count, primcount );\n\n\t\tinfo.update( count, mode, primcount );\n\n\t}\n\n\t//\n\n\tthis.setMode = setMode;\n\tthis.render = render;\n\tthis.renderInstances = renderInstances;\n\n}\n\nfunction WebGLCapabilities( gl, extensions, parameters ) {\n\n\tlet maxAnisotropy;\n\n\tfunction getMaxAnisotropy() {\n\n\t\tif ( maxAnisotropy !== undefined ) return maxAnisotropy;\n\n\t\tif ( extensions.has( 'EXT_texture_filter_anisotropic' ) === true ) {\n\n\t\t\tconst extension = extensions.get( 'EXT_texture_filter_anisotropic' );\n\n\t\t\tmaxAnisotropy = gl.getParameter( extension.MAX_TEXTURE_MAX_ANISOTROPY_EXT );\n\n\t\t} else {\n\n\t\t\tmaxAnisotropy = 0;\n\n\t\t}\n\n\t\treturn maxAnisotropy;\n\n\t}\n\n\tfunction getMaxPrecision( precision ) {\n\n\t\tif ( precision === 'highp' ) {\n\n\t\t\tif ( gl.getShaderPrecisionFormat( 35633, 36338 ).precision > 0 &&\n\t\t\t\tgl.getShaderPrecisionFormat( 35632, 36338 ).precision > 0 ) {\n\n\t\t\t\treturn 'highp';\n\n\t\t\t}\n\n\t\t\tprecision = 'mediump';\n\n\t\t}\n\n\t\tif ( precision === 'mediump' ) {\n\n\t\t\tif ( gl.getShaderPrecisionFormat( 35633, 36337 ).precision > 0 &&\n\t\t\t\tgl.getShaderPrecisionFormat( 35632, 36337 ).precision > 0 ) {\n\n\t\t\t\treturn 'mediump';\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn 'lowp';\n\n\t}\n\n\t/* eslint-disable no-undef */\n\tconst isWebGL2 = ( typeof WebGL2RenderingContext !== 'undefined' && gl instanceof WebGL2RenderingContext ) ||\n\t\t( typeof WebGL2ComputeRenderingContext !== 'undefined' && gl instanceof WebGL2ComputeRenderingContext );\n\t/* eslint-enable no-undef */\n\n\tlet precision = parameters.precision !== undefined ? parameters.precision : 'highp';\n\tconst maxPrecision = getMaxPrecision( precision );\n\n\tif ( maxPrecision !== precision ) {\n\n\t\tconsole.warn( 'THREE.WebGLRenderer:', precision, 'not supported, using', maxPrecision, 'instead.' );\n\t\tprecision = maxPrecision;\n\n\t}\n\n\tconst drawBuffers = isWebGL2 || extensions.has( 'WEBGL_draw_buffers' );\n\n\tconst logarithmicDepthBuffer = parameters.logarithmicDepthBuffer === true;\n\n\tconst maxTextures = gl.getParameter( 34930 );\n\tconst maxVertexTextures = gl.getParameter( 35660 );\n\tconst maxTextureSize = gl.getParameter( 3379 );\n\tconst maxCubemapSize = gl.getParameter( 34076 );\n\n\tconst maxAttributes = gl.getParameter( 34921 );\n\tconst maxVertexUniforms = gl.getParameter( 36347 );\n\tconst maxVaryings = gl.getParameter( 36348 );\n\tconst maxFragmentUniforms = gl.getParameter( 36349 );\n\n\tconst vertexTextures = maxVertexTextures > 0;\n\tconst floatFragmentTextures = isWebGL2 || extensions.has( 'OES_texture_float' );\n\tconst floatVertexTextures = vertexTextures && floatFragmentTextures;\n\n\tconst maxSamples = isWebGL2 ? gl.getParameter( 36183 ) : 0;\n\n\treturn {\n\n\t\tisWebGL2: isWebGL2,\n\n\t\tdrawBuffers: drawBuffers,\n\n\t\tgetMaxAnisotropy: getMaxAnisotropy,\n\t\tgetMaxPrecision: getMaxPrecision,\n\n\t\tprecision: precision,\n\t\tlogarithmicDepthBuffer: logarithmicDepthBuffer,\n\n\t\tmaxTextures: maxTextures,\n\t\tmaxVertexTextures: maxVertexTextures,\n\t\tmaxTextureSize: maxTextureSize,\n\t\tmaxCubemapSize: maxCubemapSize,\n\n\t\tmaxAttributes: maxAttributes,\n\t\tmaxVertexUniforms: maxVertexUniforms,\n\t\tmaxVaryings: maxVaryings,\n\t\tmaxFragmentUniforms: maxFragmentUniforms,\n\n\t\tvertexTextures: vertexTextures,\n\t\tfloatFragmentTextures: floatFragmentTextures,\n\t\tfloatVertexTextures: floatVertexTextures,\n\n\t\tmaxSamples: maxSamples\n\n\t};\n\n}\n\nfunction WebGLClipping( properties ) {\n\n\tconst scope = this;\n\n\tlet globalState = null,\n\t\tnumGlobalPlanes = 0,\n\t\tlocalClippingEnabled = false,\n\t\trenderingShadows = false;\n\n\tconst plane = new Plane(),\n\t\tviewNormalMatrix = new Matrix3(),\n\n\t\tuniform = { value: null, needsUpdate: false };\n\n\tthis.uniform = uniform;\n\tthis.numPlanes = 0;\n\tthis.numIntersection = 0;\n\n\tthis.init = function ( planes, enableLocalClipping, camera ) {\n\n\t\tconst enabled =\n\t\t\tplanes.length !== 0 ||\n\t\t\tenableLocalClipping ||\n\t\t\t// enable state of previous frame - the clipping code has to\n\t\t\t// run another frame in order to reset the state:\n\t\t\tnumGlobalPlanes !== 0 ||\n\t\t\tlocalClippingEnabled;\n\n\t\tlocalClippingEnabled = enableLocalClipping;\n\n\t\tglobalState = projectPlanes( planes, camera, 0 );\n\t\tnumGlobalPlanes = planes.length;\n\n\t\treturn enabled;\n\n\t};\n\n\tthis.beginShadows = function () {\n\n\t\trenderingShadows = true;\n\t\tprojectPlanes( null );\n\n\t};\n\n\tthis.endShadows = function () {\n\n\t\trenderingShadows = false;\n\t\tresetGlobalState();\n\n\t};\n\n\tthis.setState = function ( material, camera, useCache ) {\n\n\t\tconst planes = material.clippingPlanes,\n\t\t\tclipIntersection = material.clipIntersection,\n\t\t\tclipShadows = material.clipShadows;\n\n\t\tconst materialProperties = properties.get( material );\n\n\t\tif ( ! localClippingEnabled || planes === null || planes.length === 0 || renderingShadows && ! clipShadows ) {\n\n\t\t\t// there's no local clipping\n\n\t\t\tif ( renderingShadows ) {\n\n\t\t\t\t// there's no global clipping\n\n\t\t\t\tprojectPlanes( null );\n\n\t\t\t} else {\n\n\t\t\t\tresetGlobalState();\n\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tconst nGlobal = renderingShadows ? 0 : numGlobalPlanes,\n\t\t\t\tlGlobal = nGlobal * 4;\n\n\t\t\tlet dstArray = materialProperties.clippingState || null;\n\n\t\t\tuniform.value = dstArray; // ensure unique state\n\n\t\t\tdstArray = projectPlanes( planes, camera, lGlobal, useCache );\n\n\t\t\tfor ( let i = 0; i !== lGlobal; ++ i ) {\n\n\t\t\t\tdstArray[ i ] = globalState[ i ];\n\n\t\t\t}\n\n\t\t\tmaterialProperties.clippingState = dstArray;\n\t\t\tthis.numIntersection = clipIntersection ? this.numPlanes : 0;\n\t\t\tthis.numPlanes += nGlobal;\n\n\t\t}\n\n\n\t};\n\n\tfunction resetGlobalState() {\n\n\t\tif ( uniform.value !== globalState ) {\n\n\t\t\tuniform.value = globalState;\n\t\t\tuniform.needsUpdate = numGlobalPlanes > 0;\n\n\t\t}\n\n\t\tscope.numPlanes = numGlobalPlanes;\n\t\tscope.numIntersection = 0;\n\n\t}\n\n\tfunction projectPlanes( planes, camera, dstOffset, skipTransform ) {\n\n\t\tconst nPlanes = planes !== null ? planes.length : 0;\n\t\tlet dstArray = null;\n\n\t\tif ( nPlanes !== 0 ) {\n\n\t\t\tdstArray = uniform.value;\n\n\t\t\tif ( skipTransform !== true || dstArray === null ) {\n\n\t\t\t\tconst flatSize = dstOffset + nPlanes * 4,\n\t\t\t\t\tviewMatrix = camera.matrixWorldInverse;\n\n\t\t\t\tviewNormalMatrix.getNormalMatrix( viewMatrix );\n\n\t\t\t\tif ( dstArray === null || dstArray.length < flatSize ) {\n\n\t\t\t\t\tdstArray = new Float32Array( flatSize );\n\n\t\t\t\t}\n\n\t\t\t\tfor ( let i = 0, i4 = dstOffset; i !== nPlanes; ++ i, i4 += 4 ) {\n\n\t\t\t\t\tplane.copy( planes[ i ] ).applyMatrix4( viewMatrix, viewNormalMatrix );\n\n\t\t\t\t\tplane.normal.toArray( dstArray, i4 );\n\t\t\t\t\tdstArray[ i4 + 3 ] = plane.constant;\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\tuniform.value = dstArray;\n\t\t\tuniform.needsUpdate = true;\n\n\t\t}\n\n\t\tscope.numPlanes = nPlanes;\n\t\tscope.numIntersection = 0;\n\n\t\treturn dstArray;\n\n\t}\n\n}\n\nfunction WebGLCubeMaps( renderer ) {\n\n\tlet cubemaps = new WeakMap();\n\n\tfunction mapTextureMapping( texture, mapping ) {\n\n\t\tif ( mapping === EquirectangularReflectionMapping ) {\n\n\t\t\ttexture.mapping = CubeReflectionMapping;\n\n\t\t} else if ( mapping === EquirectangularRefractionMapping ) {\n\n\t\t\ttexture.mapping = CubeRefractionMapping;\n\n\t\t}\n\n\t\treturn texture;\n\n\t}\n\n\tfunction get( texture ) {\n\n\t\tif ( texture && texture.isTexture ) {\n\n\t\t\tconst mapping = texture.mapping;\n\n\t\t\tif ( mapping === EquirectangularReflectionMapping || mapping === EquirectangularRefractionMapping ) {\n\n\t\t\t\tif ( cubemaps.has( texture ) ) {\n\n\t\t\t\t\tconst cubemap = cubemaps.get( texture ).texture;\n\t\t\t\t\treturn mapTextureMapping( cubemap, texture.mapping );\n\n\t\t\t\t} else {\n\n\t\t\t\t\tconst image = texture.image;\n\n\t\t\t\t\tif ( image && image.height > 0 ) {\n\n\t\t\t\t\t\tconst currentRenderTarget = renderer.getRenderTarget();\n\n\t\t\t\t\t\tconst renderTarget = new WebGLCubeRenderTarget( image.height / 2 );\n\t\t\t\t\t\trenderTarget.fromEquirectangularTexture( renderer, texture );\n\t\t\t\t\t\tcubemaps.set( texture, renderTarget );\n\n\t\t\t\t\t\trenderer.setRenderTarget( currentRenderTarget );\n\n\t\t\t\t\t\ttexture.addEventListener( 'dispose', onTextureDispose );\n\n\t\t\t\t\t\treturn mapTextureMapping( renderTarget.texture, texture.mapping );\n\n\t\t\t\t\t} else {\n\n\t\t\t\t\t\t// image not yet ready. try the conversion next frame\n\n\t\t\t\t\t\treturn null;\n\n\t\t\t\t\t}\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn texture;\n\n\t}\n\n\tfunction onTextureDispose( event ) {\n\n\t\tconst texture = event.target;\n\n\t\ttexture.removeEventListener( 'dispose', onTextureDispose );\n\n\t\tconst cubemap = cubemaps.get( texture );\n\n\t\tif ( cubemap !== undefined ) {\n\n\t\t\tcubemaps.delete( texture );\n\t\t\tcubemap.dispose();\n\n\t\t}\n\n\t}\n\n\tfunction dispose() {\n\n\t\tcubemaps = new WeakMap();\n\n\t}\n\n\treturn {\n\t\tget: get,\n\t\tdispose: dispose\n\t};\n\n}\n\nfunction WebGLExtensions( gl ) {\n\n\tconst extensions = {};\n\n\tfunction getExtension( name ) {\n\n\t\tif ( extensions[ name ] !== undefined ) {\n\n\t\t\treturn extensions[ name ];\n\n\t\t}\n\n\t\tlet extension;\n\n\t\tswitch ( name ) {\n\n\t\t\tcase 'WEBGL_depth_texture':\n\t\t\t\textension = gl.getExtension( 'WEBGL_depth_texture' ) || gl.getExtension( 'MOZ_WEBGL_depth_texture' ) || gl.getExtension( 'WEBKIT_WEBGL_depth_texture' );\n\t\t\t\tbreak;\n\n\t\t\tcase 'EXT_texture_filter_anisotropic':\n\t\t\t\textension = gl.getExtension( 'EXT_texture_filter_anisotropic' ) || gl.getExtension( 'MOZ_EXT_texture_filter_anisotropic' ) || gl.getExtension( 'WEBKIT_EXT_texture_filter_anisotropic' );\n\t\t\t\tbreak;\n\n\t\t\tcase 'WEBGL_compressed_texture_s3tc':\n\t\t\t\textension = gl.getExtension( 'WEBGL_compressed_texture_s3tc' ) || gl.getExtension( 'MOZ_WEBGL_compressed_texture_s3tc' ) || gl.getExtension( 'WEBKIT_WEBGL_compressed_texture_s3tc' );\n\t\t\t\tbreak;\n\n\t\t\tcase 'WEBGL_compressed_texture_pvrtc':\n\t\t\t\textension = gl.getExtension( 'WEBGL_compressed_texture_pvrtc' ) || gl.getExtension( 'WEBKIT_WEBGL_compressed_texture_pvrtc' );\n\t\t\t\tbreak;\n\n\t\t\tdefault:\n\t\t\t\textension = gl.getExtension( name );\n\n\t\t}\n\n\t\textensions[ name ] = extension;\n\n\t\treturn extension;\n\n\t}\n\n\treturn {\n\n\t\thas: function ( name ) {\n\n\t\t\treturn getExtension( name ) !== null;\n\n\t\t},\n\n\t\tinit: function ( capabilities ) {\n\n\t\t\tif ( capabilities.isWebGL2 ) {\n\n\t\t\t\tgetExtension( 'EXT_color_buffer_float' );\n\n\t\t\t} else {\n\n\t\t\t\tgetExtension( 'WEBGL_depth_texture' );\n\t\t\t\tgetExtension( 'OES_texture_float' );\n\t\t\t\tgetExtension( 'OES_texture_half_float' );\n\t\t\t\tgetExtension( 'OES_texture_half_float_linear' );\n\t\t\t\tgetExtension( 'OES_standard_derivatives' );\n\t\t\t\tgetExtension( 'OES_element_index_uint' );\n\t\t\t\tgetExtension( 'OES_vertex_array_object' );\n\t\t\t\tgetExtension( 'ANGLE_instanced_arrays' );\n\n\t\t\t}\n\n\t\t\tgetExtension( 'OES_texture_float_linear' );\n\t\t\tgetExtension( 'EXT_color_buffer_half_float' );\n\n\t\t},\n\n\t\tget: function ( name ) {\n\n\t\t\tconst extension = getExtension( name );\n\n\t\t\tif ( extension === null ) {\n\n\t\t\t\tconsole.warn( 'THREE.WebGLRenderer: ' + name + ' extension not supported.' );\n\n\t\t\t}\n\n\t\t\treturn extension;\n\n\t\t}\n\n\t};\n\n}\n\nfunction WebGLGeometries( gl, attributes, info, bindingStates ) {\n\n\tconst geometries = {};\n\tconst wireframeAttributes = new WeakMap();\n\n\tfunction onGeometryDispose( event ) {\n\n\t\tconst geometry = event.target;\n\n\t\tif ( geometry.index !== null ) {\n\n\t\t\tattributes.remove( geometry.index );\n\n\t\t}\n\n\t\tfor ( const name in geometry.attributes ) {\n\n\t\t\tattributes.remove( geometry.attributes[ name ] );\n\n\t\t}\n\n\t\tgeometry.removeEventListener( 'dispose', onGeometryDispose );\n\n\t\tdelete geometries[ geometry.id ];\n\n\t\tconst attribute = wireframeAttributes.get( geometry );\n\n\t\tif ( attribute ) {\n\n\t\t\tattributes.remove( attribute );\n\t\t\twireframeAttributes.delete( geometry );\n\n\t\t}\n\n\t\tbindingStates.releaseStatesOfGeometry( geometry );\n\n\t\tif ( geometry.isInstancedBufferGeometry === true ) {\n\n\t\t\tdelete geometry._maxInstanceCount;\n\n\t\t}\n\n\t\t//\n\n\t\tinfo.memory.geometries --;\n\n\t}\n\n\tfunction get( object, geometry ) {\n\n\t\tif ( geometries[ geometry.id ] === true ) return geometry;\n\n\t\tgeometry.addEventListener( 'dispose', onGeometryDispose );\n\n\t\tgeometries[ geometry.id ] = true;\n\n\t\tinfo.memory.geometries ++;\n\n\t\treturn geometry;\n\n\t}\n\n\tfunction update( geometry ) {\n\n\t\tconst geometryAttributes = geometry.attributes;\n\n\t\t// Updating index buffer in VAO now. See WebGLBindingStates.\n\n\t\tfor ( const name in geometryAttributes ) {\n\n\t\t\tattributes.update( geometryAttributes[ name ], 34962 );\n\n\t\t}\n\n\t\t// morph targets\n\n\t\tconst morphAttributes = geometry.morphAttributes;\n\n\t\tfor ( const name in morphAttributes ) {\n\n\t\t\tconst array = morphAttributes[ name ];\n\n\t\t\tfor ( let i = 0, l = array.length; i < l; i ++ ) {\n\n\t\t\t\tattributes.update( array[ i ], 34962 );\n\n\t\t\t}\n\n\t\t}\n\n\t}\n\n\tfunction updateWireframeAttribute( geometry ) {\n\n\t\tconst indices = [];\n\n\t\tconst geometryIndex = geometry.index;\n\t\tconst geometryPosition = geometry.attributes.position;\n\t\tlet version = 0;\n\n\t\tif ( geometryIndex !== null ) {\n\n\t\t\tconst array = geometryIndex.array;\n\t\t\tversion = geometryIndex.version;\n\n\t\t\tfor ( let i = 0, l = array.length; i < l; i += 3 ) {\n\n\t\t\t\tconst a = array[ i + 0 ];\n\t\t\t\tconst b = array[ i + 1 ];\n\t\t\t\tconst c = array[ i + 2 ];\n\n\t\t\t\tindices.push( a, b, b, c, c, a );\n\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tconst array = geometryPosition.array;\n\t\t\tversion = geometryPosition.version;\n\n\t\t\tfor ( let i = 0, l = ( array.length / 3 ) - 1; i < l; i += 3 ) {\n\n\t\t\t\tconst a = i + 0;\n\t\t\t\tconst b = i + 1;\n\t\t\t\tconst c = i + 2;\n\n\t\t\t\tindices.push( a, b, b, c, c, a );\n\n\t\t\t}\n\n\t\t}\n\n\t\tconst attribute = new ( arrayMax( indices ) > 65535 ? Uint32BufferAttribute : Uint16BufferAttribute )( indices, 1 );\n\t\tattribute.version = version;\n\n\t\t// Updating index buffer in VAO now. See WebGLBindingStates\n\n\t\t//\n\n\t\tconst previousAttribute = wireframeAttributes.get( geometry );\n\n\t\tif ( previousAttribute ) attributes.remove( previousAttribute );\n\n\t\t//\n\n\t\twireframeAttributes.set( geometry, attribute );\n\n\t}\n\n\tfunction getWireframeAttribute( geometry ) {\n\n\t\tconst currentAttribute = wireframeAttributes.get( geometry );\n\n\t\tif ( currentAttribute ) {\n\n\t\t\tconst geometryIndex = geometry.index;\n\n\t\t\tif ( geometryIndex !== null ) {\n\n\t\t\t\t// if the attribute is obsolete, create a new one\n\n\t\t\t\tif ( currentAttribute.version < geometryIndex.version ) {\n\n\t\t\t\t\tupdateWireframeAttribute( geometry );\n\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tupdateWireframeAttribute( geometry );\n\n\t\t}\n\n\t\treturn wireframeAttributes.get( geometry );\n\n\t}\n\n\treturn {\n\n\t\tget: get,\n\t\tupdate: update,\n\n\t\tgetWireframeAttribute: getWireframeAttribute\n\n\t};\n\n}\n\nfunction WebGLIndexedBufferRenderer( gl, extensions, info, capabilities ) {\n\n\tconst isWebGL2 = capabilities.isWebGL2;\n\n\tlet mode;\n\n\tfunction setMode( value ) {\n\n\t\tmode = value;\n\n\t}\n\n\tlet type, bytesPerElement;\n\n\tfunction setIndex( value ) {\n\n\t\ttype = value.type;\n\t\tbytesPerElement = value.bytesPerElement;\n\n\t}\n\n\tfunction render( start, count ) {\n\n\t\tgl.drawElements( mode, count, type, start * bytesPerElement );\n\n\t\tinfo.update( count, mode, 1 );\n\n\t}\n\n\tfunction renderInstances( start, count, primcount ) {\n\n\t\tif ( primcount === 0 ) return;\n\n\t\tlet extension, methodName;\n\n\t\tif ( isWebGL2 ) {\n\n\t\t\textension = gl;\n\t\t\tmethodName = 'drawElementsInstanced';\n\n\t\t} else {\n\n\t\t\textension = extensions.get( 'ANGLE_instanced_arrays' );\n\t\t\tmethodName = 'drawElementsInstancedANGLE';\n\n\t\t\tif ( extension === null ) {\n\n\t\t\t\tconsole.error( 'THREE.WebGLIndexedBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.' );\n\t\t\t\treturn;\n\n\t\t\t}\n\n\t\t}\n\n\t\textension[ methodName ]( mode, count, type, start * bytesPerElement, primcount );\n\n\t\tinfo.update( count, mode, primcount );\n\n\t}\n\n\t//\n\n\tthis.setMode = setMode;\n\tthis.setIndex = setIndex;\n\tthis.render = render;\n\tthis.renderInstances = renderInstances;\n\n}\n\nfunction WebGLInfo( gl ) {\n\n\tconst memory = {\n\t\tgeometries: 0,\n\t\ttextures: 0\n\t};\n\n\tconst render = {\n\t\tframe: 0,\n\t\tcalls: 0,\n\t\ttriangles: 0,\n\t\tpoints: 0,\n\t\tlines: 0\n\t};\n\n\tfunction update( count, mode, instanceCount ) {\n\n\t\trender.calls ++;\n\n\t\tswitch ( mode ) {\n\n\t\t\tcase 4:\n\t\t\t\trender.triangles += instanceCount * ( count / 3 );\n\t\t\t\tbreak;\n\n\t\t\tcase 1:\n\t\t\t\trender.lines += instanceCount * ( count / 2 );\n\t\t\t\tbreak;\n\n\t\t\tcase 3:\n\t\t\t\trender.lines += instanceCount * ( count - 1 );\n\t\t\t\tbreak;\n\n\t\t\tcase 2:\n\t\t\t\trender.lines += instanceCount * count;\n\t\t\t\tbreak;\n\n\t\t\tcase 0:\n\t\t\t\trender.points += instanceCount * count;\n\t\t\t\tbreak;\n\n\t\t\tdefault:\n\t\t\t\tconsole.error( 'THREE.WebGLInfo: Unknown draw mode:', mode );\n\t\t\t\tbreak;\n\n\t\t}\n\n\t}\n\n\tfunction reset() {\n\n\t\trender.frame ++;\n\t\trender.calls = 0;\n\t\trender.triangles = 0;\n\t\trender.points = 0;\n\t\trender.lines = 0;\n\n\t}\n\n\treturn {\n\t\tmemory: memory,\n\t\trender: render,\n\t\tprograms: null,\n\t\tautoReset: true,\n\t\treset: reset,\n\t\tupdate: update\n\t};\n\n}\n\nfunction numericalSort( a, b ) {\n\n\treturn a[ 0 ] - b[ 0 ];\n\n}\n\nfunction absNumericalSort( a, b ) {\n\n\treturn Math.abs( b[ 1 ] ) - Math.abs( a[ 1 ] );\n\n}\n\nfunction WebGLMorphtargets( gl ) {\n\n\tconst influencesList = {};\n\tconst morphInfluences = new Float32Array( 8 );\n\n\tconst workInfluences = [];\n\n\tfor ( let i = 0; i < 8; i ++ ) {\n\n\t\tworkInfluences[ i ] = [ i, 0 ];\n\n\t}\n\n\tfunction update( object, geometry, material, program ) {\n\n\t\tconst objectInfluences = object.morphTargetInfluences;\n\n\t\t// When object doesn't have morph target influences defined, we treat it as a 0-length array\n\t\t// This is important to make sure we set up morphTargetBaseInfluence / morphTargetInfluences\n\n\t\tconst length = objectInfluences === undefined ? 0 : objectInfluences.length;\n\n\t\tlet influences = influencesList[ geometry.id ];\n\n\t\tif ( influences === undefined ) {\n\n\t\t\t// initialise list\n\n\t\t\tinfluences = [];\n\n\t\t\tfor ( let i = 0; i < length; i ++ ) {\n\n\t\t\t\tinfluences[ i ] = [ i, 0 ];\n\n\t\t\t}\n\n\t\t\tinfluencesList[ geometry.id ] = influences;\n\n\t\t}\n\n\t\t// Collect influences\n\n\t\tfor ( let i = 0; i < length; i ++ ) {\n\n\t\t\tconst influence = influences[ i ];\n\n\t\t\tinfluence[ 0 ] = i;\n\t\t\tinfluence[ 1 ] = objectInfluences[ i ];\n\n\t\t}\n\n\t\tinfluences.sort( absNumericalSort );\n\n\t\tfor ( let i = 0; i < 8; i ++ ) {\n\n\t\t\tif ( i < length && influences[ i ][ 1 ] ) {\n\n\t\t\t\tworkInfluences[ i ][ 0 ] = influences[ i ][ 0 ];\n\t\t\t\tworkInfluences[ i ][ 1 ] = influences[ i ][ 1 ];\n\n\t\t\t} else {\n\n\t\t\t\tworkInfluences[ i ][ 0 ] = Number.MAX_SAFE_INTEGER;\n\t\t\t\tworkInfluences[ i ][ 1 ] = 0;\n\n\t\t\t}\n\n\t\t}\n\n\t\tworkInfluences.sort( numericalSort );\n\n\t\tconst morphTargets = material.morphTargets && geometry.morphAttributes.position;\n\t\tconst morphNormals = material.morphNormals && geometry.morphAttributes.normal;\n\n\t\tlet morphInfluencesSum = 0;\n\n\t\tfor ( let i = 0; i < 8; i ++ ) {\n\n\t\t\tconst influence = workInfluences[ i ];\n\t\t\tconst index = influence[ 0 ];\n\t\t\tconst value = influence[ 1 ];\n\n\t\t\tif ( index !== Number.MAX_SAFE_INTEGER && value ) {\n\n\t\t\t\tif ( morphTargets && geometry.getAttribute( 'morphTarget' + i ) !== morphTargets[ index ] ) {\n\n\t\t\t\t\tgeometry.setAttribute( 'morphTarget' + i, morphTargets[ index ] );\n\n\t\t\t\t}\n\n\t\t\t\tif ( morphNormals && geometry.getAttribute( 'morphNormal' + i ) !== morphNormals[ index ] ) {\n\n\t\t\t\t\tgeometry.setAttribute( 'morphNormal' + i, morphNormals[ index ] );\n\n\t\t\t\t}\n\n\t\t\t\tmorphInfluences[ i ] = value;\n\t\t\t\tmorphInfluencesSum += value;\n\n\t\t\t} else {\n\n\t\t\t\tif ( morphTargets && geometry.hasAttribute( 'morphTarget' + i ) === true ) {\n\n\t\t\t\t\tgeometry.deleteAttribute( 'morphTarget' + i );\n\n\t\t\t\t}\n\n\t\t\t\tif ( morphNormals && geometry.hasAttribute( 'morphNormal' + i ) === true ) {\n\n\t\t\t\t\tgeometry.deleteAttribute( 'morphNormal' + i );\n\n\t\t\t\t}\n\n\t\t\t\tmorphInfluences[ i ] = 0;\n\n\t\t\t}\n\n\t\t}\n\n\t\t// GLSL shader uses formula baseinfluence * base + sum(target * influence)\n\t\t// This allows us to switch between absolute morphs and relative morphs without changing shader code\n\t\t// When baseinfluence = 1 - sum(influence), the above is equivalent to sum((target - base) * influence)\n\t\tconst morphBaseInfluence = geometry.morphTargetsRelative ? 1 : 1 - morphInfluencesSum;\n\n\t\tprogram.getUniforms().setValue( gl, 'morphTargetBaseInfluence', morphBaseInfluence );\n\t\tprogram.getUniforms().setValue( gl, 'morphTargetInfluences', morphInfluences );\n\n\t}\n\n\treturn {\n\n\t\tupdate: update\n\n\t};\n\n}\n\nfunction WebGLObjects( gl, geometries, attributes, info ) {\n\n\tlet updateMap = new WeakMap();\n\n\tfunction update( object ) {\n\n\t\tconst frame = info.render.frame;\n\n\t\tconst geometry = object.geometry;\n\t\tconst buffergeometry = geometries.get( object, geometry );\n\n\t\t// Update once per frame\n\n\t\tif ( updateMap.get( buffergeometry ) !== frame ) {\n\n\t\t\tgeometries.update( buffergeometry );\n\n\t\t\tupdateMap.set( buffergeometry, frame );\n\n\t\t}\n\n\t\tif ( object.isInstancedMesh ) {\n\n\t\t\tif ( object.hasEventListener( 'dispose', onInstancedMeshDispose ) === false ) {\n\n\t\t\t\tobject.addEventListener( 'dispose', onInstancedMeshDispose );\n\n\t\t\t}\n\n\t\t\tattributes.update( object.instanceMatrix, 34962 );\n\n\t\t\tif ( object.instanceColor !== null ) {\n\n\t\t\t\tattributes.update( object.instanceColor, 34962 );\n\n\t\t\t}\n\n\t\t}\n\n\t\treturn buffergeometry;\n\n\t}\n\n\tfunction dispose() {\n\n\t\tupdateMap = new WeakMap();\n\n\t}\n\n\tfunction onInstancedMeshDispose( event ) {\n\n\t\tconst instancedMesh = event.target;\n\n\t\tinstancedMesh.removeEventListener( 'dispose', onInstancedMeshDispose );\n\n\t\tattributes.remove( instancedMesh.instanceMatrix );\n\n\t\tif ( instancedMesh.instanceColor !== null ) attributes.remove( instancedMesh.instanceColor );\n\n\t}\n\n\treturn {\n\n\t\tupdate: update,\n\t\tdispose: dispose\n\n\t};\n\n}\n\nclass DataTexture2DArray extends Texture {\n\n\tconstructor( data = null, width = 1, height = 1, depth = 1 ) {\n\n\t\tsuper( null );\n\n\t\tthis.image = { data, width, height, depth };\n\n\t\tthis.magFilter = NearestFilter;\n\t\tthis.minFilter = NearestFilter;\n\n\t\tthis.wrapR = ClampToEdgeWrapping;\n\n\t\tthis.generateMipmaps = false;\n\t\tthis.flipY = false;\n\t\tthis.unpackAlignment = 1;\n\n\t\tthis.needsUpdate = true;\n\n\t}\n\n}\n\nDataTexture2DArray.prototype.isDataTexture2DArray = true;\n\nclass DataTexture3D extends Texture {\n\n\tconstructor( data = null, width = 1, height = 1, depth = 1 ) {\n\n\t\t// We're going to add .setXXX() methods for setting properties later.\n\t\t// Users can still set in DataTexture3D directly.\n\t\t//\n\t\t//\tconst texture = new THREE.DataTexture3D( data, width, height, depth );\n\t\t// \ttexture.anisotropy = 16;\n\t\t//\n\t\t// See #14839\n\n\t\tsuper( null );\n\n\t\tthis.image = { data, width, height, depth };\n\n\t\tthis.magFilter = NearestFilter;\n\t\tthis.minFilter = NearestFilter;\n\n\t\tthis.wrapR = ClampToEdgeWrapping;\n\n\t\tthis.generateMipmaps = false;\n\t\tthis.flipY = false;\n\t\tthis.unpackAlignment = 1;\n\n\t\tthis.needsUpdate = true;\n\n\t}\n\n}\n\nDataTexture3D.prototype.isDataTexture3D = true;\n\n/**\n * Uniforms of a program.\n * Those form a tree structure with a special top-level container for the root,\n * which you get by calling 'new WebGLUniforms( gl, program )'.\n *\n *\n * Properties of inner nodes including the top-level container:\n *\n * .seq - array of nested uniforms\n * .map - nested uniforms by name\n *\n *\n * Methods of all nodes except the top-level container:\n *\n * .setValue( gl, value, [textures] )\n *\n * \t\tuploads a uniform value(s)\n *  \tthe 'textures' parameter is needed for sampler uniforms\n *\n *\n * Static methods of the top-level container (textures factorizations):\n *\n * .upload( gl, seq, values, textures )\n *\n * \t\tsets uniforms in 'seq' to 'values[id].value'\n *\n * .seqWithValue( seq, values ) : filteredSeq\n *\n * \t\tfilters 'seq' entries with corresponding entry in values\n *\n *\n * Methods of the top-level container (textures factorizations):\n *\n * .setValue( gl, name, value, textures )\n *\n * \t\tsets uniform with  name 'name' to 'value'\n *\n * .setOptional( gl, obj, prop )\n *\n * \t\tlike .set for an optional property of the object\n *\n */\n\nconst emptyTexture = new Texture();\nconst emptyTexture2dArray = new DataTexture2DArray();\nconst emptyTexture3d = new DataTexture3D();\nconst emptyCubeTexture = new CubeTexture();\n\n// --- Utilities ---\n\n// Array Caches (provide typed arrays for temporary by size)\n\nconst arrayCacheF32 = [];\nconst arrayCacheI32 = [];\n\n// Float32Array caches used for uploading Matrix uniforms\n\nconst mat4array = new Float32Array( 16 );\nconst mat3array = new Float32Array( 9 );\nconst mat2array = new Float32Array( 4 );\n\n// Flattening for arrays of vectors and matrices\n\nfunction flatten( array, nBlocks, blockSize ) {\n\n\tconst firstElem = array[ 0 ];\n\n\tif ( firstElem <= 0 || firstElem > 0 ) return array;\n\t// unoptimized: ! isNaN( firstElem )\n\t// see http://jacksondunstan.com/articles/983\n\n\tconst n = nBlocks * blockSize;\n\tlet r = arrayCacheF32[ n ];\n\n\tif ( r === undefined ) {\n\n\t\tr = new Float32Array( n );\n\t\tarrayCacheF32[ n ] = r;\n\n\t}\n\n\tif ( nBlocks !== 0 ) {\n\n\t\tfirstElem.toArray( r, 0 );\n\n\t\tfor ( let i = 1, offset = 0; i !== nBlocks; ++ i ) {\n\n\t\t\toffset += blockSize;\n\t\t\tarray[ i ].toArray( r, offset );\n\n\t\t}\n\n\t}\n\n\treturn r;\n\n}\n\nfunction arraysEqual( a, b ) {\n\n\tif ( a.length !== b.length ) return false;\n\n\tfor ( let i = 0, l = a.length; i < l; i ++ ) {\n\n\t\tif ( a[ i ] !== b[ i ] ) return false;\n\n\t}\n\n\treturn true;\n\n}\n\nfunction copyArray( a, b ) {\n\n\tfor ( let i = 0, l = b.length; i < l; i ++ ) {\n\n\t\ta[ i ] = b[ i ];\n\n\t}\n\n}\n\n// Texture unit allocation\n\nfunction allocTexUnits( textures, n ) {\n\n\tlet r = arrayCacheI32[ n ];\n\n\tif ( r === undefined ) {\n\n\t\tr = new Int32Array( n );\n\t\tarrayCacheI32[ n ] = r;\n\n\t}\n\n\tfor ( let i = 0; i !== n; ++ i ) {\n\n\t\tr[ i ] = textures.allocateTextureUnit();\n\n\t}\n\n\treturn r;\n\n}\n\n// --- Setters ---\n\n// Note: Defining these methods externally, because they come in a bunch\n// and this way their names minify.\n\n// Single scalar\n\nfunction setValueV1f( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( cache[ 0 ] === v ) return;\n\n\tgl.uniform1f( this.addr, v );\n\n\tcache[ 0 ] = v;\n\n}\n\n// Single float vector (from flat array or THREE.VectorN)\n\nfunction setValueV2f( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( v.x !== undefined ) {\n\n\t\tif ( cache[ 0 ] !== v.x || cache[ 1 ] !== v.y ) {\n\n\t\t\tgl.uniform2f( this.addr, v.x, v.y );\n\n\t\t\tcache[ 0 ] = v.x;\n\t\t\tcache[ 1 ] = v.y;\n\n\t\t}\n\n\t} else {\n\n\t\tif ( arraysEqual( cache, v ) ) return;\n\n\t\tgl.uniform2fv( this.addr, v );\n\n\t\tcopyArray( cache, v );\n\n\t}\n\n}\n\nfunction setValueV3f( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( v.x !== undefined ) {\n\n\t\tif ( cache[ 0 ] !== v.x || cache[ 1 ] !== v.y || cache[ 2 ] !== v.z ) {\n\n\t\t\tgl.uniform3f( this.addr, v.x, v.y, v.z );\n\n\t\t\tcache[ 0 ] = v.x;\n\t\t\tcache[ 1 ] = v.y;\n\t\t\tcache[ 2 ] = v.z;\n\n\t\t}\n\n\t} else if ( v.r !== undefined ) {\n\n\t\tif ( cache[ 0 ] !== v.r || cache[ 1 ] !== v.g || cache[ 2 ] !== v.b ) {\n\n\t\t\tgl.uniform3f( this.addr, v.r, v.g, v.b );\n\n\t\t\tcache[ 0 ] = v.r;\n\t\t\tcache[ 1 ] = v.g;\n\t\t\tcache[ 2 ] = v.b;\n\n\t\t}\n\n\t} else {\n\n\t\tif ( arraysEqual( cache, v ) ) return;\n\n\t\tgl.uniform3fv( this.addr, v );\n\n\t\tcopyArray( cache, v );\n\n\t}\n\n}\n\nfunction setValueV4f( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( v.x !== undefined ) {\n\n\t\tif ( cache[ 0 ] !== v.x || cache[ 1 ] !== v.y || cache[ 2 ] !== v.z || cache[ 3 ] !== v.w ) {\n\n\t\t\tgl.uniform4f( this.addr, v.x, v.y, v.z, v.w );\n\n\t\t\tcache[ 0 ] = v.x;\n\t\t\tcache[ 1 ] = v.y;\n\t\t\tcache[ 2 ] = v.z;\n\t\t\tcache[ 3 ] = v.w;\n\n\t\t}\n\n\t} else {\n\n\t\tif ( arraysEqual( cache, v ) ) return;\n\n\t\tgl.uniform4fv( this.addr, v );\n\n\t\tcopyArray( cache, v );\n\n\t}\n\n}\n\n// Single matrix (from flat array or THREE.MatrixN)\n\nfunction setValueM2( gl, v ) {\n\n\tconst cache = this.cache;\n\tconst elements = v.elements;\n\n\tif ( elements === undefined ) {\n\n\t\tif ( arraysEqual( cache, v ) ) return;\n\n\t\tgl.uniformMatrix2fv( this.addr, false, v );\n\n\t\tcopyArray( cache, v );\n\n\t} else {\n\n\t\tif ( arraysEqual( cache, elements ) ) return;\n\n\t\tmat2array.set( elements );\n\n\t\tgl.uniformMatrix2fv( this.addr, false, mat2array );\n\n\t\tcopyArray( cache, elements );\n\n\t}\n\n}\n\nfunction setValueM3( gl, v ) {\n\n\tconst cache = this.cache;\n\tconst elements = v.elements;\n\n\tif ( elements === undefined ) {\n\n\t\tif ( arraysEqual( cache, v ) ) return;\n\n\t\tgl.uniformMatrix3fv( this.addr, false, v );\n\n\t\tcopyArray( cache, v );\n\n\t} else {\n\n\t\tif ( arraysEqual( cache, elements ) ) return;\n\n\t\tmat3array.set( elements );\n\n\t\tgl.uniformMatrix3fv( this.addr, false, mat3array );\n\n\t\tcopyArray( cache, elements );\n\n\t}\n\n}\n\nfunction setValueM4( gl, v ) {\n\n\tconst cache = this.cache;\n\tconst elements = v.elements;\n\n\tif ( elements === undefined ) {\n\n\t\tif ( arraysEqual( cache, v ) ) return;\n\n\t\tgl.uniformMatrix4fv( this.addr, false, v );\n\n\t\tcopyArray( cache, v );\n\n\t} else {\n\n\t\tif ( arraysEqual( cache, elements ) ) return;\n\n\t\tmat4array.set( elements );\n\n\t\tgl.uniformMatrix4fv( this.addr, false, mat4array );\n\n\t\tcopyArray( cache, elements );\n\n\t}\n\n}\n\n// Single integer / boolean\n\nfunction setValueV1i( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( cache[ 0 ] === v ) return;\n\n\tgl.uniform1i( this.addr, v );\n\n\tcache[ 0 ] = v;\n\n}\n\n// Single integer / boolean vector (from flat array)\n\nfunction setValueV2i( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( arraysEqual( cache, v ) ) return;\n\n\tgl.uniform2iv( this.addr, v );\n\n\tcopyArray( cache, v );\n\n}\n\nfunction setValueV3i( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( arraysEqual( cache, v ) ) return;\n\n\tgl.uniform3iv( this.addr, v );\n\n\tcopyArray( cache, v );\n\n}\n\nfunction setValueV4i( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( arraysEqual( cache, v ) ) return;\n\n\tgl.uniform4iv( this.addr, v );\n\n\tcopyArray( cache, v );\n\n}\n\n// Single unsigned integer\n\nfunction setValueV1ui( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( cache[ 0 ] === v ) return;\n\n\tgl.uniform1ui( this.addr, v );\n\n\tcache[ 0 ] = v;\n\n}\n\n// Single unsigned integer vector (from flat array)\n\nfunction setValueV2ui( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( arraysEqual( cache, v ) ) return;\n\n\tgl.uniform2uiv( this.addr, v );\n\n\tcopyArray( cache, v );\n\n}\n\nfunction setValueV3ui( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( arraysEqual( cache, v ) ) return;\n\n\tgl.uniform3uiv( this.addr, v );\n\n\tcopyArray( cache, v );\n\n}\n\nfunction setValueV4ui( gl, v ) {\n\n\tconst cache = this.cache;\n\n\tif ( arraysEqual( cache, v ) ) return;\n\n\tgl.uniform4uiv( this.addr, v );\n\n\tcopyArray( cache, v );\n\n}\n\n\n// Single texture (2D / Cube)\n\nfunction setValueT1( gl, v, textures ) {\n\n\tconst cache = this.cache;\n\tconst unit = textures.allocateTextureUnit();\n\n\tif ( cache[ 0 ] !== unit ) {\n\n\t\tgl.uniform1i( this.addr, unit );\n\t\tcache[ 0 ] = unit;\n\n\t}\n\n\ttextures.safeSetTexture2D( v || emptyTexture, unit );\n\n}\n\nfunction setValueT3D1( gl, v, textures ) {\n\n\tconst cache = this.cache;\n\tconst unit = textures.allocateTextureUnit();\n\n\tif ( cache[ 0 ] !== unit ) {\n\n\t\tgl.uniform1i( this.addr, unit );\n\t\tcache[ 0 ] = unit;\n\n\t}\n\n\ttextures.setTexture3D( v || emptyTexture3d, unit );\n\n}\n\nfunction setValueT6( gl, v, textures ) {\n\n\tconst cache = this.cache;\n\tconst unit = textures.allocateTextureUnit();\n\n\tif ( cache[ 0 ] !== unit ) {\n\n\t\tgl.uniform1i( this.addr, unit );\n\t\tcache[ 0 ] = unit;\n\n\t}\n\n\ttextures.safeSetTextureCube( v || emptyCubeTexture, unit );\n\n}\n\nfunction setValueT2DArray1( gl, v, textures ) {\n\n\tconst cache = this.cache;\n\tconst unit = textures.allocateTextureUnit();\n\n\tif ( cache[ 0 ] !== unit ) {\n\n\t\tgl.uniform1i( this.addr, unit );\n\t\tcache[ 0 ] = unit;\n\n\t}\n\n\ttextures.setTexture2DArray( v || emptyTexture2dArray, unit );\n\n}\n\n// Helper to pick the right setter for the singular case\n\nfunction getSingularSetter( type ) {\n\n\tswitch ( type ) {\n\n\t\tcase 0x1406: return setValueV1f; // FLOAT\n\t\tcase 0x8b50: return setValueV2f; // _VEC2\n\t\tcase 0x8b51: return setValueV3f; // _VEC3\n\t\tcase 0x8b52: return setValueV4f; // _VEC4\n\n\t\tcase 0x8b5a: return setValueM2; // _MAT2\n\t\tcase 0x8b5b: return setValueM3; // _MAT3\n\t\tcase 0x8b5c: return setValueM4; // _MAT4\n\n\t\tcase 0x1404: case 0x8b56: return setValueV1i; // INT, BOOL\n\t\tcase 0x8b53: case 0x8b57: return setValueV2i; // _VEC2\n\t\tcase 0x8b54: case 0x8b58: return setValueV3i; // _VEC3\n\t\tcase 0x8b55: case 0x8b59: return setValueV4i; // _VEC4\n\n\t\tcase 0x1405: return setValueV1ui; // UINT\n\t\tcase 0x8dc6: return setValueV2ui; // _VEC2\n\t\tcase 0x8dc7: return setValueV3ui; // _VEC3\n\t\tcase 0x8dc8: return setValueV4ui; // _VEC4\n\n\t\tcase 0x8b5e: // SAMPLER_2D\n\t\tcase 0x8d66: // SAMPLER_EXTERNAL_OES\n\t\tcase 0x8dca: // INT_SAMPLER_2D\n\t\tcase 0x8dd2: // UNSIGNED_INT_SAMPLER_2D\n\t\tcase 0x8b62: // SAMPLER_2D_SHADOW\n\t\t\treturn setValueT1;\n\n\t\tcase 0x8b5f: // SAMPLER_3D\n\t\tcase 0x8dcb: // INT_SAMPLER_3D\n\t\tcase 0x8dd3: // UNSIGNED_INT_SAMPLER_3D\n\t\t\treturn setValueT3D1;\n\n\t\tcase 0x8b60: // SAMPLER_CUBE\n\t\tcase 0x8dcc: // INT_SAMPLER_CUBE\n\t\tcase 0x8dd4: // UNSIGNED_INT_SAMPLER_CUBE\n\t\tcase 0x8dc5: // SAMPLER_CUBE_SHADOW\n\t\t\treturn setValueT6;\n\n\t\tcase 0x8dc1: // SAMPLER_2D_ARRAY\n\t\tcase 0x8dcf: // INT_SAMPLER_2D_ARRAY\n\t\tcase 0x8dd7: // UNSIGNED_INT_SAMPLER_2D_ARRAY\n\t\tcase 0x8dc4: // SAMPLER_2D_ARRAY_SHADOW\n\t\t\treturn setValueT2DArray1;\n\n\t}\n\n}\n\n\n// Array of scalars\n\nfunction setValueV1fArray( gl, v ) {\n\n\tgl.uniform1fv( this.addr, v );\n\n}\n\n// Array of vectors (from flat array or array of THREE.VectorN)\n\nfunction setValueV2fArray( gl, v ) {\n\n\tconst data = flatten( v, this.size, 2 );\n\n\tgl.uniform2fv( this.addr, data );\n\n}\n\nfunction setValueV3fArray( gl, v ) {\n\n\tconst data = flatten( v, this.size, 3 );\n\n\tgl.uniform3fv( this.addr, data );\n\n}\n\nfunction setValueV4fArray( gl, v ) {\n\n\tconst data = flatten( v, this.size, 4 );\n\n\tgl.uniform4fv( this.addr, data );\n\n}\n\n// Array of matrices (from flat array or array of THREE.MatrixN)\n\nfunction setValueM2Array( gl, v ) {\n\n\tconst data = flatten( v, this.size, 4 );\n\n\tgl.uniformMatrix2fv( this.addr, false, data );\n\n}\n\nfunction setValueM3Array( gl, v ) {\n\n\tconst data = flatten( v, this.size, 9 );\n\n\tgl.uniformMatrix3fv( this.addr, false, data );\n\n}\n\nfunction setValueM4Array( gl, v ) {\n\n\tconst data = flatten( v, this.size, 16 );\n\n\tgl.uniformMatrix4fv( this.addr, false, data );\n\n}\n\n// Array of integer / boolean\n\nfunction setValueV1iArray( gl, v ) {\n\n\tgl.uniform1iv( this.addr, v );\n\n}\n\n// Array of integer / boolean vectors (from flat array)\n\nfunction setValueV2iArray( gl, v ) {\n\n\tgl.uniform2iv( this.addr, v );\n\n}\n\nfunction setValueV3iArray( gl, v ) {\n\n\tgl.uniform3iv( this.addr, v );\n\n}\n\nfunction setValueV4iArray( gl, v ) {\n\n\tgl.uniform4iv( this.addr, v );\n\n}\n\n// Array of unsigned integer\n\nfunction setValueV1uiArray( gl, v ) {\n\n\tgl.uniform1uiv( this.addr, v );\n\n}\n\n// Array of unsigned integer vectors (from flat array)\n\nfunction setValueV2uiArray( gl, v ) {\n\n\tgl.uniform2uiv( this.addr, v );\n\n}\n\nfunction setValueV3uiArray( gl, v ) {\n\n\tgl.uniform3uiv( this.addr, v );\n\n}\n\nfunction setValueV4uiArray( gl, v ) {\n\n\tgl.uniform4uiv( this.addr, v );\n\n}\n\n\n// Array of textures (2D / Cube)\n\nfunction setValueT1Array( gl, v, textures ) {\n\n\tconst n = v.length;\n\n\tconst units = allocTexUnits( textures, n );\n\n\tgl.uniform1iv( this.addr, units );\n\n\tfor ( let i = 0; i !== n; ++ i ) {\n\n\t\ttextures.safeSetTexture2D( v[ i ] || emptyTexture, units[ i ] );\n\n\t}\n\n}\n\nfunction setValueT6Array( gl, v, textures ) {\n\n\tconst n = v.length;\n\n\tconst units = allocTexUnits( textures, n );\n\n\tgl.uniform1iv( this.addr, units );\n\n\tfor ( let i = 0; i !== n; ++ i ) {\n\n\t\ttextures.safeSetTextureCube( v[ i ] || emptyCubeTexture, units[ i ] );\n\n\t}\n\n}\n\n// Helper to pick the right setter for a pure (bottom-level) array\n\nfunction getPureArraySetter( type ) {\n\n\tswitch ( type ) {\n\n\t\tcase 0x1406: return setValueV1fArray; // FLOAT\n\t\tcase 0x8b50: return setValueV2fArray; // _VEC2\n\t\tcase 0x8b51: return setValueV3fArray; // _VEC3\n\t\tcase 0x8b52: return setValueV4fArray; // _VEC4\n\n\t\tcase 0x8b5a: return setValueM2Array; // _MAT2\n\t\tcase 0x8b5b: return setValueM3Array; // _MAT3\n\t\tcase 0x8b5c: return setValueM4Array; // _MAT4\n\n\t\tcase 0x1404: case 0x8b56: return setValueV1iArray; // INT, BOOL\n\t\tcase 0x8b53: case 0x8b57: return setValueV2iArray; // _VEC2\n\t\tcase 0x8b54: case 0x8b58: return setValueV3iArray; // _VEC3\n\t\tcase 0x8b55: case 0x8b59: return setValueV4iArray; // _VEC4\n\n\t\tcase 0x1405: return setValueV1uiArray; // UINT\n\t\tcase 0x8dc6: return setValueV2uiArray; // _VEC2\n\t\tcase 0x8dc7: return setValueV3uiArray; // _VEC3\n\t\tcase 0x8dc8: return setValueV4uiArray; // _VEC4\n\n\t\tcase 0x8b5e: // SAMPLER_2D\n\t\tcase 0x8d66: // SAMPLER_EXTERNAL_OES\n\t\tcase 0x8dca: // INT_SAMPLER_2D\n\t\tcase 0x8dd2: // UNSIGNED_INT_SAMPLER_2D\n\t\tcase 0x8b62: // SAMPLER_2D_SHADOW\n\t\t\treturn setValueT1Array;\n\n\t\tcase 0x8b60: // SAMPLER_CUBE\n\t\tcase 0x8dcc: // INT_SAMPLER_CUBE\n\t\tcase 0x8dd4: // UNSIGNED_INT_SAMPLER_CUBE\n\t\tcase 0x8dc5: // SAMPLER_CUBE_SHADOW\n\t\t\treturn setValueT6Array;\n\n\t}\n\n}\n\n// --- Uniform Classes ---\n\nfunction SingleUniform( id, activeInfo, addr ) {\n\n\tthis.id = id;\n\tthis.addr = addr;\n\tthis.cache = [];\n\tthis.setValue = getSingularSetter( activeInfo.type );\n\n\t// this.path = activeInfo.name; // DEBUG\n\n}\n\nfunction PureArrayUniform( id, activeInfo, addr ) {\n\n\tthis.id = id;\n\tthis.addr = addr;\n\tthis.cache = [];\n\tthis.size = activeInfo.size;\n\tthis.setValue = getPureArraySetter( activeInfo.type );\n\n\t// this.path = activeInfo.name; // DEBUG\n\n}\n\nPureArrayUniform.prototype.updateCache = function ( data ) {\n\n\tconst cache = this.cache;\n\n\tif ( data instanceof Float32Array && cache.length !== data.length ) {\n\n\t\tthis.cache = new Float32Array( data.length );\n\n\t}\n\n\tcopyArray( cache, data );\n\n};\n\nfunction StructuredUniform( id ) {\n\n\tthis.id = id;\n\n\tthis.seq = [];\n\tthis.map = {};\n\n}\n\nStructuredUniform.prototype.setValue = function ( gl, value, textures ) {\n\n\tconst seq = this.seq;\n\n\tfor ( let i = 0, n = seq.length; i !== n; ++ i ) {\n\n\t\tconst u = seq[ i ];\n\t\tu.setValue( gl, value[ u.id ], textures );\n\n\t}\n\n};\n\n// --- Top-level ---\n\n// Parser - builds up the property tree from the path strings\n\nconst RePathPart = /(\\w+)(\\])?(\\[|\\.)?/g;\n\n// extracts\n// \t- the identifier (member name or array index)\n//  - followed by an optional right bracket (found when array index)\n//  - followed by an optional left bracket or dot (type of subscript)\n//\n// Note: These portions can be read in a non-overlapping fashion and\n// allow straightforward parsing of the hierarchy that WebGL encodes\n// in the uniform names.\n\nfunction addUniform( container, uniformObject ) {\n\n\tcontainer.seq.push( uniformObject );\n\tcontainer.map[ uniformObject.id ] = uniformObject;\n\n}\n\nfunction parseUniform( activeInfo, addr, container ) {\n\n\tconst path = activeInfo.name,\n\t\tpathLength = path.length;\n\n\t// reset RegExp object, because of the early exit of a previous run\n\tRePathPart.lastIndex = 0;\n\n\twhile ( true ) {\n\n\t\tconst match = RePathPart.exec( path ),\n\t\t\tmatchEnd = RePathPart.lastIndex;\n\n\t\tlet id = match[ 1 ];\n\t\tconst idIsIndex = match[ 2 ] === ']',\n\t\t\tsubscript = match[ 3 ];\n\n\t\tif ( idIsIndex ) id = id | 0; // convert to integer\n\n\t\tif ( subscript === undefined || subscript === '[' && matchEnd + 2 === pathLength ) {\n\n\t\t\t// bare name or \"pure\" bottom-level array \"[0]\" suffix\n\n\t\t\taddUniform( container, subscript === undefined ?\n\t\t\t\tnew SingleUniform( id, activeInfo, addr ) :\n\t\t\t\tnew PureArrayUniform( id, activeInfo, addr ) );\n\n\t\t\tbreak;\n\n\t\t} else {\n\n\t\t\t// step into inner node / create it in case it doesn't exist\n\n\t\t\tconst map = container.map;\n\t\t\tlet next = map[ id ];\n\n\t\t\tif ( next === undefined ) {\n\n\t\t\t\tnext = new StructuredUniform( id );\n\t\t\t\taddUniform( container, next );\n\n\t\t\t}\n\n\t\t\tcontainer = next;\n\n\t\t}\n\n\t}\n\n}\n\n// Root Container\n\nfunction WebGLUniforms( gl, program ) {\n\n\tthis.seq = [];\n\tthis.map = {};\n\n\tconst n = gl.getProgramParameter( program, 35718 );\n\n\tfor ( let i = 0; i < n; ++ i ) {\n\n\t\tconst info = gl.getActiveUniform( program, i ),\n\t\t\taddr = gl.getUniformLocation( program, info.name );\n\n\t\tparseUniform( info, addr, this );\n\n\t}\n\n}\n\nWebGLUniforms.prototype.setValue = function ( gl, name, value, textures ) {\n\n\tconst u = this.map[ name ];\n\n\tif ( u !== undefined ) u.setValue( gl, value, textures );\n\n};\n\nWebGLUniforms.prototype.setOptional = function ( gl, object, name ) {\n\n\tconst v = object[ name ];\n\n\tif ( v !== undefined ) this.setValue( gl, name, v );\n\n};\n\n\n// Static interface\n\nWebGLUniforms.upload = function ( gl, seq, values, textures ) {\n\n\tfor ( let i = 0, n = seq.length; i !== n; ++ i ) {\n\n\t\tconst u = seq[ i ],\n\t\t\tv = values[ u.id ];\n\n\t\tif ( v.needsUpdate !== false ) {\n\n\t\t\t// note: always updating when .needsUpdate is undefined\n\t\t\tu.setValue( gl, v.value, textures );\n\n\t\t}\n\n\t}\n\n};\n\nWebGLUniforms.seqWithValue = function ( seq, values ) {\n\n\tconst r = [];\n\n\tfor ( let i = 0, n = seq.length; i !== n; ++ i ) {\n\n\t\tconst u = seq[ i ];\n\t\tif ( u.id in values ) r.push( u );\n\n\t}\n\n\treturn r;\n\n};\n\nfunction WebGLShader( gl, type, string ) {\n\n\tconst shader = gl.createShader( type );\n\n\tgl.shaderSource( shader, string );\n\tgl.compileShader( shader );\n\n\treturn shader;\n\n}\n\nlet programIdCount = 0;\n\nfunction addLineNumbers( string ) {\n\n\tconst lines = string.split( '\\n' );\n\n\tfor ( let i = 0; i < lines.length; i ++ ) {\n\n\t\tlines[ i ] = ( i + 1 ) + ': ' + lines[ i ];\n\n\t}\n\n\treturn lines.join( '\\n' );\n\n}\n\nfunction getEncodingComponents( encoding ) {\n\n\tswitch ( encoding ) {\n\n\t\tcase LinearEncoding:\n\t\t\treturn [ 'Linear', '( value )' ];\n\t\tcase sRGBEncoding:\n\t\t\treturn [ 'sRGB', '( value )' ];\n\t\tcase RGBEEncoding:\n\t\t\treturn [ 'RGBE', '( value )' ];\n\t\tcase RGBM7Encoding:\n\t\t\treturn [ 'RGBM', '( value, 7.0 )' ];\n\t\tcase RGBM16Encoding:\n\t\t\treturn [ 'RGBM', '( value, 16.0 )' ];\n\t\tcase RGBDEncoding:\n\t\t\treturn [ 'RGBD', '( value, 256.0 )' ];\n\t\tcase GammaEncoding:\n\t\t\treturn [ 'Gamma', '( value, float( GAMMA_FACTOR ) )' ];\n\t\tcase LogLuvEncoding:\n\t\t\treturn [ 'LogLuv', '( value )' ];\n\t\tdefault:\n\t\t\tconsole.warn( 'THREE.WebGLProgram: Unsupported encoding:', encoding );\n\t\t\treturn [ 'Linear', '( value )' ];\n\n\t}\n\n}\n\nfunction getShaderErrors( gl, shader, type ) {\n\n\tconst status = gl.getShaderParameter( shader, 35713 );\n\tconst log = gl.getShaderInfoLog( shader ).trim();\n\n\tif ( status && log === '' ) return '';\n\n\t// --enable-privileged-webgl-extension\n\t// console.log( '**' + type + '**', gl.getExtension( 'WEBGL_debug_shaders' ).getTranslatedShaderSource( shader ) );\n\n\tconst source = gl.getShaderSource( shader );\n\n\treturn 'THREE.WebGLShader: gl.getShaderInfoLog() ' + type + '\\n' + log + addLineNumbers( source );\n\n}\n\nfunction getTexelDecodingFunction( functionName, encoding ) {\n\n\tconst components = getEncodingComponents( encoding );\n\treturn 'vec4 ' + functionName + '( vec4 value ) { return ' + components[ 0 ] + 'ToLinear' + components[ 1 ] + '; }';\n\n}\n\nfunction getTexelEncodingFunction( functionName, encoding ) {\n\n\tconst components = getEncodingComponents( encoding );\n\treturn 'vec4 ' + functionName + '( vec4 value ) { return LinearTo' + components[ 0 ] + components[ 1 ] + '; }';\n\n}\n\nfunction getToneMappingFunction( functionName, toneMapping ) {\n\n\tlet toneMappingName;\n\n\tswitch ( toneMapping ) {\n\n\t\tcase LinearToneMapping:\n\t\t\ttoneMappingName = 'Linear';\n\t\t\tbreak;\n\n\t\tcase ReinhardToneMapping:\n\t\t\ttoneMappingName = 'Reinhard';\n\t\t\tbreak;\n\n\t\tcase CineonToneMapping:\n\t\t\ttoneMappingName = 'OptimizedCineon';\n\t\t\tbreak;\n\n\t\tcase ACESFilmicToneMapping:\n\t\t\ttoneMappingName = 'ACESFilmic';\n\t\t\tbreak;\n\n\t\tcase CustomToneMapping:\n\t\t\ttoneMappingName = 'Custom';\n\t\t\tbreak;\n\n\t\tdefault:\n\t\t\tconsole.warn( 'THREE.WebGLProgram: Unsupported toneMapping:', toneMapping );\n\t\t\ttoneMappingName = 'Linear';\n\n\t}\n\n\treturn 'vec3 ' + functionName + '( vec3 color ) { return ' + toneMappingName + 'ToneMapping( color ); }';\n\n}\n\nfunction generateExtensions( parameters ) {\n\n\tconst chunks = [\n\t\t( parameters.extensionDerivatives || parameters.envMapCubeUV || parameters.bumpMap || parameters.tangentSpaceNormalMap || parameters.clearcoatNormalMap || parameters.flatShading || parameters.shaderID === 'physical' ) ? '#extension GL_OES_standard_derivatives : enable' : '',\n\t\t( parameters.extensionFragDepth || parameters.logarithmicDepthBuffer ) && parameters.rendererExtensionFragDepth ? '#extension GL_EXT_frag_depth : enable' : '',\n\t\t( parameters.extensionDrawBuffers && parameters.rendererExtensionDrawBuffers ) ? '#extension GL_EXT_draw_buffers : require' : '',\n\t\t( parameters.extensionShaderTextureLOD || parameters.envMap || parameters.transmission > 0.0 ) && parameters.rendererExtensionShaderTextureLod ? '#extension GL_EXT_shader_texture_lod : enable' : ''\n\t];\n\n\treturn chunks.filter( filterEmptyLine ).join( '\\n' );\n\n}\n\nfunction generateDefines( defines ) {\n\n\tconst chunks = [];\n\n\tfor ( const name in defines ) {\n\n\t\tconst value = defines[ name ];\n\n\t\tif ( value === false ) continue;\n\n\t\tchunks.push( '#define ' + name + ' ' + value );\n\n\t}\n\n\treturn chunks.join( '\\n' );\n\n}\n\nfunction fetchAttributeLocations( gl, program ) {\n\n\tconst attributes = {};\n\n\tconst n = gl.getProgramParameter( program, 35721 );\n\n\tfor ( let i = 0; i < n; i ++ ) {\n\n\t\tconst info = gl.getActiveAttrib( program, i );\n\t\tconst name = info.name;\n\n\t\t// console.log( 'THREE.WebGLProgram: ACTIVE VERTEX ATTRIBUTE:', name, i );\n\n\t\tattributes[ name ] = gl.getAttribLocation( program, name );\n\n\t}\n\n\treturn attributes;\n\n}\n\nfunction filterEmptyLine( string ) {\n\n\treturn string !== '';\n\n}\n\nfunction replaceLightNums( string, parameters ) {\n\n\treturn string\n\t\t.replace( /NUM_DIR_LIGHTS/g, parameters.numDirLights )\n\t\t.replace( /NUM_SPOT_LIGHTS/g, parameters.numSpotLights )\n\t\t.replace( /NUM_RECT_AREA_LIGHTS/g, parameters.numRectAreaLights )\n\t\t.replace( /NUM_POINT_LIGHTS/g, parameters.numPointLights )\n\t\t.replace( /NUM_HEMI_LIGHTS/g, parameters.numHemiLights )\n\t\t.replace( /NUM_DIR_LIGHT_SHADOWS/g, parameters.numDirLightShadows )\n\t\t.replace( /NUM_SPOT_LIGHT_SHADOWS/g, parameters.numSpotLightShadows )\n\t\t.replace( /NUM_POINT_LIGHT_SHADOWS/g, parameters.numPointLightShadows );\n\n}\n\nfunction replaceClippingPlaneNums( string, parameters ) {\n\n\treturn string\n\t\t.replace( /NUM_CLIPPING_PLANES/g, parameters.numClippingPlanes )\n\t\t.replace( /UNION_CLIPPING_PLANES/g, ( parameters.numClippingPlanes - parameters.numClipIntersection ) );\n\n}\n\n// Resolve Includes\n\nconst includePattern = /^[ \\t]*#include +<([\\w\\d./]+)>/gm;\n\nfunction resolveIncludes( string ) {\n\n\treturn string.replace( includePattern, includeReplacer );\n\n}\n\nfunction includeReplacer( match, include ) {\n\n\tconst string = ShaderChunk[ include ];\n\n\tif ( string === undefined ) {\n\n\t\tthrow new Error( 'Can not resolve #include <' + include + '>' );\n\n\t}\n\n\treturn resolveIncludes( string );\n\n}\n\n// Unroll Loops\n\nconst deprecatedUnrollLoopPattern = /#pragma unroll_loop[\\s]+?for \\( int i \\= (\\d+)\\; i < (\\d+)\\; i \\+\\+ \\) \\{([\\s\\S]+?)(?=\\})\\}/g;\nconst unrollLoopPattern = /#pragma unroll_loop_start\\s+for\\s*\\(\\s*int\\s+i\\s*=\\s*(\\d+)\\s*;\\s*i\\s*<\\s*(\\d+)\\s*;\\s*i\\s*\\+\\+\\s*\\)\\s*{([\\s\\S]+?)}\\s+#pragma unroll_loop_end/g;\n\nfunction unrollLoops( string ) {\n\n\treturn string\n\t\t.replace( unrollLoopPattern, loopReplacer )\n\t\t.replace( deprecatedUnrollLoopPattern, deprecatedLoopReplacer );\n\n}\n\nfunction deprecatedLoopReplacer( match, start, end, snippet ) {\n\n\tconsole.warn( 'WebGLProgram: #pragma unroll_loop shader syntax is deprecated. Please use #pragma unroll_loop_start syntax instead.' );\n\treturn loopReplacer( match, start, end, snippet );\n\n}\n\nfunction loopReplacer( match, start, end, snippet ) {\n\n\tlet string = '';\n\n\tfor ( let i = parseInt( start ); i < parseInt( end ); i ++ ) {\n\n\t\tstring += snippet\n\t\t\t.replace( /\\[\\s*i\\s*\\]/g, '[ ' + i + ' ]' )\n\t\t\t.replace( /UNROLLED_LOOP_INDEX/g, i );\n\n\t}\n\n\treturn string;\n\n}\n\n//\n\nfunction generatePrecision( parameters ) {\n\n\tlet precisionstring = 'precision ' + parameters.precision + ' float;\\nprecision ' + parameters.precision + ' int;';\n\n\tif ( parameters.precision === 'highp' ) {\n\n\t\tprecisionstring += '\\n#define HIGH_PRECISION';\n\n\t} else if ( parameters.precision === 'mediump' ) {\n\n\t\tprecisionstring += '\\n#define MEDIUM_PRECISION';\n\n\t} else if ( parameters.precision === 'lowp' ) {\n\n\t\tprecisionstring += '\\n#define LOW_PRECISION';\n\n\t}\n\n\treturn precisionstring;\n\n}\n\nfunction generateShadowMapTypeDefine( parameters ) {\n\n\tlet shadowMapTypeDefine = 'SHADOWMAP_TYPE_BASIC';\n\n\tif ( parameters.shadowMapType === PCFShadowMap ) {\n\n\t\tshadowMapTypeDefine = 'SHADOWMAP_TYPE_PCF';\n\n\t} else if ( parameters.shadowMapType === PCFSoftShadowMap ) {\n\n\t\tshadowMapTypeDefine = 'SHADOWMAP_TYPE_PCF_SOFT';\n\n\t} else if ( parameters.shadowMapType === VSMShadowMap ) {\n\n\t\tshadowMapTypeDefine = 'SHADOWMAP_TYPE_VSM';\n\n\t}\n\n\treturn shadowMapTypeDefine;\n\n}\n\nfunction generateEnvMapTypeDefine( parameters ) {\n\n\tlet envMapTypeDefine = 'ENVMAP_TYPE_CUBE';\n\n\tif ( parameters.envMap ) {\n\n\t\tswitch ( parameters.envMapMode ) {\n\n\t\t\tcase CubeReflectionMapping:\n\t\t\tcase CubeRefractionMapping:\n\t\t\t\tenvMapTypeDefine = 'ENVMAP_TYPE_CUBE';\n\t\t\t\tbreak;\n\n\t\t\tcase CubeUVReflectionMapping:\n\t\t\tcase CubeUVRefractionMapping:\n\t\t\t\tenvMapTypeDefine = 'ENVMAP_TYPE_CUBE_UV';\n\t\t\t\tbreak;\n\n\t\t}\n\n\t}\n\n\treturn envMapTypeDefine;\n\n}\n\nfunction generateEnvMapModeDefine( parameters ) {\n\n\tlet envMapModeDefine = 'ENVMAP_MODE_REFLECTION';\n\n\tif ( parameters.envMap ) {\n\n\t\tswitch ( parameters.envMapMode ) {\n\n\t\t\tcase CubeRefractionMapping:\n\t\t\tcase CubeUVRefractionMapping:\n\n\t\t\t\tenvMapModeDefine = 'ENVMAP_MODE_REFRACTION';\n\t\t\t\tbreak;\n\n\t\t}\n\n\t}\n\n\treturn envMapModeDefine;\n\n}\n\nfunction generateEnvMapBlendingDefine( parameters ) {\n\n\tlet envMapBlendingDefine = 'ENVMAP_BLENDING_NONE';\n\n\tif ( parameters.envMap ) {\n\n\t\tswitch ( parameters.combine ) {\n\n\t\t\tcase MultiplyOperation:\n\t\t\t\tenvMapBlendingDefine = 'ENVMAP_BLENDING_MULTIPLY';\n\t\t\t\tbreak;\n\n\t\t\tcase MixOperation:\n\t\t\t\tenvMapBlendingDefine = 'ENVMAP_BLENDING_MIX';\n\t\t\t\tbreak;\n\n\t\t\tcase AddOperation:\n\t\t\t\tenvMapBlendingDefine = 'ENVMAP_BLENDING_ADD';\n\t\t\t\tbreak;\n\n\t\t}\n\n\t}\n\n\treturn envMapBlendingDefine;\n\n}\n\nfunction WebGLProgram( renderer, cacheKey, parameters, bindingStates ) {\n\n\tconst gl = renderer.getContext();\n\n\tconst defines = parameters.defines;\n\n\tlet vertexShader = parameters.vertexShader;\n\tlet fragmentShader = parameters.fragmentShader;\n\n\tconst shadowMapTypeDefine = generateShadowMapTypeDefine( parameters );\n\tconst envMapTypeDefine = generateEnvMapTypeDefine( parameters );\n\tconst envMapModeDefine = generateEnvMapModeDefine( parameters );\n\tconst envMapBlendingDefine = generateEnvMapBlendingDefine( parameters );\n\n\n\tconst gammaFactorDefine = ( renderer.gammaFactor > 0 ) ? renderer.gammaFactor : 1.0;\n\n\tconst customExtensions = parameters.isWebGL2 ? '' : generateExtensions( parameters );\n\n\tconst customDefines = generateDefines( defines );\n\n\tconst program = gl.createProgram();\n\n\tlet prefixVertex, prefixFragment;\n\tlet versionString = parameters.glslVersion ? '#version ' + parameters.glslVersion + '\\n' : '';\n\n\tif ( parameters.isRawShaderMaterial ) {\n\n\t\tprefixVertex = [\n\n\t\t\tcustomDefines\n\n\t\t].filter( filterEmptyLine ).join( '\\n' );\n\n\t\tif ( prefixVertex.length > 0 ) {\n\n\t\t\tprefixVertex += '\\n';\n\n\t\t}\n\n\t\tprefixFragment = [\n\n\t\t\tcustomExtensions,\n\t\t\tcustomDefines\n\n\t\t].filter( filterEmptyLine ).join( '\\n' );\n\n\t\tif ( prefixFragment.length > 0 ) {\n\n\t\t\tprefixFragment += '\\n';\n\n\t\t}\n\n\t} else {\n\n\t\tprefixVertex = [\n\n\t\t\tgeneratePrecision( parameters ),\n\n\t\t\t'#define SHADER_NAME ' + parameters.shaderName,\n\n\t\t\tcustomDefines,\n\n\t\t\tparameters.instancing ? '#define USE_INSTANCING' : '',\n\t\t\tparameters.instancingColor ? '#define USE_INSTANCING_COLOR' : '',\n\n\t\t\tparameters.supportsVertexTextures ? '#define VERTEX_TEXTURES' : '',\n\n\t\t\t'#define GAMMA_FACTOR ' + gammaFactorDefine,\n\n\t\t\t'#define MAX_BONES ' + parameters.maxBones,\n\t\t\t( parameters.useFog && parameters.fog ) ? '#define USE_FOG' : '',\n\t\t\t( parameters.useFog && parameters.fogExp2 ) ? '#define FOG_EXP2' : '',\n\n\t\t\tparameters.map ? '#define USE_MAP' : '',\n\t\t\tparameters.envMap ? '#define USE_ENVMAP' : '',\n\t\t\tparameters.envMap ? '#define ' + envMapModeDefine : '',\n\t\t\tparameters.lightMap ? '#define USE_LIGHTMAP' : '',\n\t\t\tparameters.aoMap ? '#define USE_AOMAP' : '',\n\t\t\tparameters.emissiveMap ? '#define USE_EMISSIVEMAP' : '',\n\t\t\tparameters.bumpMap ? '#define USE_BUMPMAP' : '',\n\t\t\tparameters.normalMap ? '#define USE_NORMALMAP' : '',\n\t\t\t( parameters.normalMap && parameters.objectSpaceNormalMap ) ? '#define OBJECTSPACE_NORMALMAP' : '',\n\t\t\t( parameters.normalMap && parameters.tangentSpaceNormalMap ) ? '#define TANGENTSPACE_NORMALMAP' : '',\n\n\t\t\tparameters.clearcoatMap ? '#define USE_CLEARCOATMAP' : '',\n\t\t\tparameters.clearcoatRoughnessMap ? '#define USE_CLEARCOAT_ROUGHNESSMAP' : '',\n\t\t\tparameters.clearcoatNormalMap ? '#define USE_CLEARCOAT_NORMALMAP' : '',\n\t\t\tparameters.displacementMap && parameters.supportsVertexTextures ? '#define USE_DISPLACEMENTMAP' : '',\n\t\t\tparameters.specularMap ? '#define USE_SPECULARMAP' : '',\n\t\t\tparameters.roughnessMap ? '#define USE_ROUGHNESSMAP' : '',\n\t\t\tparameters.metalnessMap ? '#define USE_METALNESSMAP' : '',\n\t\t\tparameters.alphaMap ? '#define USE_ALPHAMAP' : '',\n\t\t\tparameters.transmission ? '#define USE_TRANSMISSION' : '',\n\t\t\tparameters.transmissionMap ? '#define USE_TRANSMISSIONMAP' : '',\n\t\t\tparameters.thicknessMap ? '#define USE_THICKNESSMAP' : '',\n\n\t\t\tparameters.vertexTangents ? '#define USE_TANGENT' : '',\n\t\t\tparameters.vertexColors ? '#define USE_COLOR' : '',\n\t\t\tparameters.vertexAlphas ? '#define USE_COLOR_ALPHA' : '',\n\t\t\tparameters.vertexUvs ? '#define USE_UV' : '',\n\t\t\tparameters.uvsVertexOnly ? '#define UVS_VERTEX_ONLY' : '',\n\n\t\t\tparameters.flatShading ? '#define FLAT_SHADED' : '',\n\n\t\t\tparameters.skinning ? '#define USE_SKINNING' : '',\n\t\t\tparameters.useVertexTexture ? '#define BONE_TEXTURE' : '',\n\n\t\t\tparameters.morphTargets ? '#define USE_MORPHTARGETS' : '',\n\t\t\tparameters.morphNormals && parameters.flatShading === false ? '#define USE_MORPHNORMALS' : '',\n\t\t\tparameters.doubleSided ? '#define DOUBLE_SIDED' : '',\n\t\t\tparameters.flipSided ? '#define FLIP_SIDED' : '',\n\n\t\t\tparameters.shadowMapEnabled ? '#define USE_SHADOWMAP' : '',\n\t\t\tparameters.shadowMapEnabled ? '#define ' + shadowMapTypeDefine : '',\n\n\t\t\tparameters.sizeAttenuation ? '#define USE_SIZEATTENUATION' : '',\n\n\t\t\tparameters.logarithmicDepthBuffer ? '#define USE_LOGDEPTHBUF' : '',\n\t\t\t( parameters.logarithmicDepthBuffer && parameters.rendererExtensionFragDepth ) ? '#define USE_LOGDEPTHBUF_EXT' : '',\n\n\t\t\t'uniform mat4 modelMatrix;',\n\t\t\t'uniform mat4 modelViewMatrix;',\n\t\t\t'uniform mat4 projectionMatrix;',\n\t\t\t'uniform mat4 viewMatrix;',\n\t\t\t'uniform mat3 normalMatrix;',\n\t\t\t'uniform vec3 cameraPosition;',\n\t\t\t'uniform bool isOrthographic;',\n\n\t\t\t'#ifdef USE_INSTANCING',\n\n\t\t\t'\tattribute mat4 instanceMatrix;',\n\n\t\t\t'#endif',\n\n\t\t\t'#ifdef USE_INSTANCING_COLOR',\n\n\t\t\t'\tattribute vec3 instanceColor;',\n\n\t\t\t'#endif',\n\n\t\t\t'attribute vec3 position;',\n\t\t\t'attribute vec3 normal;',\n\t\t\t'attribute vec2 uv;',\n\n\t\t\t'#ifdef USE_TANGENT',\n\n\t\t\t'\tattribute vec4 tangent;',\n\n\t\t\t'#endif',\n\n\t\t\t'#if defined( USE_COLOR_ALPHA )',\n\n\t\t\t'\tattribute vec4 color;',\n\n\t\t\t'#elif defined( USE_COLOR )',\n\n\t\t\t'\tattribute vec3 color;',\n\n\t\t\t'#endif',\n\n\t\t\t'#ifdef USE_MORPHTARGETS',\n\n\t\t\t'\tattribute vec3 morphTarget0;',\n\t\t\t'\tattribute vec3 morphTarget1;',\n\t\t\t'\tattribute vec3 morphTarget2;',\n\t\t\t'\tattribute vec3 morphTarget3;',\n\n\t\t\t'\t#ifdef USE_MORPHNORMALS',\n\n\t\t\t'\t\tattribute vec3 morphNormal0;',\n\t\t\t'\t\tattribute vec3 morphNormal1;',\n\t\t\t'\t\tattribute vec3 morphNormal2;',\n\t\t\t'\t\tattribute vec3 morphNormal3;',\n\n\t\t\t'\t#else',\n\n\t\t\t'\t\tattribute vec3 morphTarget4;',\n\t\t\t'\t\tattribute vec3 morphTarget5;',\n\t\t\t'\t\tattribute vec3 morphTarget6;',\n\t\t\t'\t\tattribute vec3 morphTarget7;',\n\n\t\t\t'\t#endif',\n\n\t\t\t'#endif',\n\n\t\t\t'#ifdef USE_SKINNING',\n\n\t\t\t'\tattribute vec4 skinIndex;',\n\t\t\t'\tattribute vec4 skinWeight;',\n\n\t\t\t'#endif',\n\n\t\t\t'\\n'\n\n\t\t].filter( filterEmptyLine ).join( '\\n' );\n\n\t\tprefixFragment = [\n\n\t\t\tcustomExtensions,\n\n\t\t\tgeneratePrecision( parameters ),\n\n\t\t\t'#define SHADER_NAME ' + parameters.shaderName,\n\n\t\t\tcustomDefines,\n\n\t\t\tparameters.alphaTest ? '#define ALPHATEST ' + parameters.alphaTest + ( parameters.alphaTest % 1 ? '' : '.0' ) : '', // add '.0' if integer\n\n\t\t\t'#define GAMMA_FACTOR ' + gammaFactorDefine,\n\n\t\t\t( parameters.useFog && parameters.fog ) ? '#define USE_FOG' : '',\n\t\t\t( parameters.useFog && parameters.fogExp2 ) ? '#define FOG_EXP2' : '',\n\n\t\t\tparameters.map ? '#define USE_MAP' : '',\n\t\t\tparameters.matcap ? '#define USE_MATCAP' : '',\n\t\t\tparameters.envMap ? '#define USE_ENVMAP' : '',\n\t\t\tparameters.envMap ? '#define ' + envMapTypeDefine : '',\n\t\t\tparameters.envMap ? '#define ' + envMapModeDefine : '',\n\t\t\tparameters.envMap ? '#define ' + envMapBlendingDefine : '',\n\t\t\tparameters.lightMap ? '#define USE_LIGHTMAP' : '',\n\t\t\tparameters.aoMap ? '#define USE_AOMAP' : '',\n\t\t\tparameters.emissiveMap ? '#define USE_EMISSIVEMAP' : '',\n\t\t\tparameters.bumpMap ? '#define USE_BUMPMAP' : '',\n\t\t\tparameters.normalMap ? '#define USE_NORMALMAP' : '',\n\t\t\t( parameters.normalMap && parameters.objectSpa