# ------------------------------------------------------------
# This file was generated using create_marin_data.py
#
# on    : Version 2022.3.1
# under : SymPy 1.9
# using : Python 3.8.10
# ------------------------------------------------------------

# generated data function for cubic Hecke algebra
def _read_regl(u, v, w):
    r"""
    Return precomputed representation matrices of Ivan Marin

    This code has been generated by ``create_marin_data.py`` (from
    the `database_cubic_hecke repository  <https://github.com/soehms/database_cubic_hecke>`__),
    please don't edit.

    INPUT:

    ``u, v, w`` -- values for the variables of the representation matrices

    OUTPUT:

    A triple ``dim_list, repr_list, repr_list_inv`` where each member
    is a list indexed by the number of the representation.

    ``dim_list`` is a list of integers representing the dimension of
    the corresponding representation
    ``repr_list`` is a triple of dictionaries each describing the
    representation matrix of the corresponding generator of the
    cubic Hecke algebra.
    ``repr_list_inv`` is a triple of dictionaries each describing the
    inverse of the correspondig matrix of ``repr_list``.

    EXAMPLES::

        >>> from database_cubic_hecke import _read_regl
        >>> dim_list, repr_list, repr_list_inv = _read_regl(3, 5, 7)
        >>> dim_list
        [648]
        >>> len(repr_list)
        1
        >>> g1, g2, g3 = repr_list[0]
        >>> list(g1.items())[0]
        ((0, 27), -5)
    """

    data = ([648], [[{(0, 27): -v, (0, 54): 1, (1, 28): -v, (1, 55): 1, (2, 29):
        -v, (2, 56): 1, (3, 30): -v, (3, 57): 1, (4, 31): -v, (4, 58):
        1, (5, 32): -v, (5, 59): 1, (6, 33): -v, (6, 60): 1, (7, 34):
        -v, (7, 61): 1, (8, 35): -v, (8, 62): 1, (9, 36): -v, (9, 63):
        1, (10, 37): -v, (10, 64): 1, (11, 38): -v, (11, 65): 1, (12,
        39): -v, (12, 66): 1, (13, 40): -v, (13, 67): 1, (14, 41): -v,
        (14, 68): 1, (15, 42): -v, (15, 69): 1, (16, 43): -v, (16,
        70): 1, (17, 44): -v, (17, 71): 1, (18, 45): -v, (18, 72): 1,
        (19, 46): -v, (19, 73): 1, (20, 47): -v, (20, 74): 1, (21,
        48): -v, (21, 75): 1, (22, 49): -v, (22, 76): 1, (23, 50): -v,
        (23, 77): 1, (24, 51): -v, (24, 78): 1, (25, 52): -v, (25,
        79): 1, (26, 53): -v, (26, 80): 1, (27, 0): 1, (27, 27): u,
        (28, 1): 1, (28, 28): u, (29, 2): 1, (29, 29): u, (30, 3): 1,
        (30, 30): u, (31, 4): 1, (31, 31): u, (32, 5): 1, (32, 32): u,
        (33, 6): 1, (33, 33): u, (34, 7): 1, (34, 34): u, (35, 8): 1,
        (35, 35): u, (36, 9): 1, (36, 36): u, (37, 10): 1, (37, 37):
        u, (38, 11): 1, (38, 38): u, (39, 12): 1, (39, 39): u, (40,
        13): 1, (40, 40): u, (41, 14): 1, (41, 41): u, (42, 15): 1,
        (42, 42): u, (43, 16): 1, (43, 43): u, (44, 17): 1, (44, 44):
        u, (45, 18): 1, (45, 45): u, (46, 19): 1, (46, 46): u, (47,
        20): 1, (47, 47): u, (48, 21): 1, (48, 48): u, (49, 22): 1,
        (49, 49): u, (50, 23): 1, (50, 50): u, (51, 24): 1, (51, 51):
        u, (52, 25): 1, (52, 52): u, (53, 26): 1, (53, 53): u, (54,
        27): w, (55, 28): w, (56, 29): w, (57, 30): w, (58, 31): w,
        (59, 32): w, (60, 33): w, (61, 34): w, (62, 35): w, (63, 36):
        w, (64, 37): w, (65, 38): w, (66, 39): w, (67, 40): w, (68,
        41): w, (69, 42): w, (70, 43): w, (71, 44): w, (72, 45): w,
        (73, 46): w, (74, 47): w, (75, 48): w, (76, 49): w, (77, 50):
        w, (78, 51): w, (79, 52): w, (80, 53): w, (81, 135): -v, (81,
        189): 1, (82, 136): -v, (82, 190): 1, (83, 137): -v, (83,
        191): 1, (84, 138): -v, (84, 192): 1, (85, 139): -v, (85,
        193): 1, (86, 140): -v, (86, 194): 1, (87, 141): -v, (87,
        195): 1, (88, 142): -v, (88, 196): 1, (89, 143): -v, (89,
        197): 1, (90, 144): -v, (90, 198): 1, (91, 145): -v, (91,
        199): 1, (92, 146): -v, (92, 200): 1, (93, 147): -v, (93,
        201): 1, (94, 148): -v, (94, 202): 1, (95, 149): -v, (95,
        203): 1, (96, 150): -v, (96, 204): 1, (97, 151): -v, (97,
        205): 1, (98, 152): -v, (98, 206): 1, (99, 153): -v, (99,
        207): 1, (100, 154): -v, (100, 208): 1, (101, 155): -v, (101,
        209): 1, (102, 156): -v, (102, 210): 1, (103, 157): -v, (103,
        211): 1, (104, 158): -v, (104, 212): 1, (105, 159): -v, (105,
        213): 1, (106, 160): -v, (106, 214): 1, (107, 161): -v, (107,
        215): 1, (108, 162): -v, (108, 216): 1, (109, 163): -v, (109,
        217): 1, (110, 164): -v, (110, 218): 1, (111, 165): -v, (111,
        219): 1, (112, 166): -v, (112, 220): 1, (113, 167): -v, (113,
        221): 1, (114, 168): -v, (114, 222): 1, (115, 169): -v, (115,
        223): 1, (116, 170): -v, (116, 224): 1, (117, 171): -v, (117,
        225): 1, (118, 172): -v, (118, 226): 1, (119, 173): -v, (119,
        227): 1, (120, 174): -v, (120, 228): 1, (121, 175): -v, (121,
        229): 1, (122, 176): -v, (122, 230): 1, (123, 177): -v, (123,
        231): 1, (124, 178): -v, (124, 232): 1, (125, 179): -v, (125,
        233): 1, (126, 180): -v, (126, 234): 1, (127, 181): -v, (127,
        235): 1, (128, 182): -v, (128, 236): 1, (129, 183): -v, (129,
        237): 1, (130, 184): -v, (130, 238): 1, (131, 185): -v, (131,
        239): 1, (132, 186): -v, (132, 240): 1, (133, 187): -v, (133,
        241): 1, (134, 188): -v, (134, 242): 1, (135, 81): 1, (135,
        135): u, (136, 82): 1, (136, 136): u, (137, 83): 1, (137,
        137): u, (138, 84): 1, (138, 138): u, (139, 85): 1, (139,
        139): u, (140, 86): 1, (140, 140): u, (141, 87): 1, (141,
        141): u, (142, 88): 1, (142, 142): u, (143, 89): 1, (143,
        143): u, (144, 90): 1, (144, 144): u, (145, 91): 1, (145,
        145): u, (146, 92): 1, (146, 146): u, (147, 93): 1, (147,
        147): u, (148, 94): 1, (148, 148): u, (149, 95): 1, (149,
        149): u, (150, 96): 1, (150, 150): u, (151, 97): 1, (151,
        151): u, (152, 98): 1, (152, 152): u, (153, 99): 1, (153,
        153): u, (154, 100): 1, (154, 154): u, (155, 101): 1, (155,
        155): u, (156, 102): 1, (156, 156): u, (157, 103): 1, (157,
        157): u, (158, 104): 1, (158, 158): u, (159, 105): 1, (159,
        159): u, (160, 106): 1, (160, 160): u, (161, 107): 1, (161,
        161): u, (162, 108): 1, (162, 162): u, (163, 109): 1, (163,
        163): u, (164, 110): 1, (164, 164): u, (165, 111): 1, (165,
        165): u, (166, 112): 1, (166, 166): u, (167, 113): 1, (167,
        167): u, (168, 114): 1, (168, 168): u, (169, 115): 1, (169,
        169): u, (170, 116): 1, (170, 170): u, (171, 117): 1, (171,
        171): u, (172, 118): 1, (172, 172): u, (173, 119): 1, (173,
        173): u, (174, 120): 1, (174, 174): u, (175, 121): 1, (175,
        175): u, (176, 122): 1, (176, 176): u, (177, 123): 1, (177,
        177): u, (178, 124): 1, (178, 178): u, (179, 125): 1, (179,
        179): u, (180, 126): 1, (180, 180): u, (181, 127): 1, (181,
        181): u, (182, 128): 1, (182, 182): u, (183, 129): 1, (183,
        183): u, (184, 130): 1, (184, 184): u, (185, 131): 1, (185,
        185): u, (186, 132): 1, (186, 186): u, (187, 133): 1, (187,
        187): u, (188, 134): 1, (188, 188): u, (189, 135): w, (190,
        136): w, (191, 137): w, (192, 138): w, (193, 139): w, (194,
        140): w, (195, 141): w, (196, 142): w, (197, 143): w, (198,
        144): w, (199, 145): w, (200, 146): w, (201, 147): w, (202,
        148): w, (203, 149): w, (204, 150): w, (205, 151): w, (206,
        152): w, (207, 153): w, (208, 154): w, (209, 155): w, (210,
        156): w, (211, 157): w, (212, 158): w, (213, 159): w, (214,
        160): w, (215, 161): w, (216, 162): w, (217, 163): w, (218,
        164): w, (219, 165): w, (220, 166): w, (221, 167): w, (222,
        168): w, (223, 169): w, (224, 170): w, (225, 171): w, (226,
        172): w, (227, 173): w, (228, 174): w, (229, 175): w, (230,
        176): w, (231, 177): w, (232, 178): w, (233, 179): w, (234,
        180): w, (235, 181): w, (236, 182): w, (237, 183): w, (238,
        184): w, (239, 185): w, (240, 186): w, (241, 187): w, (242,
        188): w, (243, 243): u, (243, 405): 1, (244, 244): u, (244,
        406): 1, (245, 245): u, (245, 407): 1, (246, 246): u, (246,
        408): 1, (247, 247): u, (247, 409): 1, (248, 248): u, (248,
        410): 1, (249, 249): u, (249, 411): 1, (250, 250): u, (250,
        412): 1, (251, 251): u, (251, 413): 1, (252, 252): u, (252,
        414): 1, (253, 253): u, (253, 415): 1, (254, 254): u, (254,
        416): 1, (255, 255): u, (255, 417): 1, (256, 256): u, (256,
        418): 1, (257, 257): u, (257, 419): 1, (258, 258): u, (258,
        420): 1, (259, 259): u, (259, 421): 1, (260, 260): u, (260,
        422): 1, (261, 261): u, (261, 423): 1, (262, 262): u, (262,
        424): 1, (263, 263): u, (263, 425): 1, (264, 264): u, (264,
        426): 1, (265, 265): u, (265, 427): 1, (266, 266): u, (266,
        428): 1, (267, 267): u, (267, 429): 1, (268, 268): u, (268,
        430): 1, (269, 269): u, (269, 431): 1, (270, 270): u, (270,
        459): 1, (271, 271): u, (271, 460): 1, (272, 272): u, (272,
        461): 1, (273, 273): u, (273, 462): 1, (274, 274): u, (274,
        463): 1, (275, 275): u, (275, 464): 1, (276, 276): u, (276,
        465): 1, (277, 277): u, (277, 466): 1, (278, 278): u, (278,
        467): 1, (279, 279): u, (279, 468): 1, (280, 280): u, (280,
        469): 1, (281, 281): u, (281, 470): 1, (282, 282): u, (282,
        471): 1, (283, 283): u, (283, 472): 1, (284, 284): u, (284,
        473): 1, (285, 285): u, (285, 474): 1, (286, 286): u, (286,
        475): 1, (287, 287): u, (287, 476): 1, (288, 288): u, (288,
        477): 1, (289, 289): u, (289, 478): 1, (290, 290): u, (290,
        479): 1, (291, 291): u, (291, 480): 1, (292, 292): u, (292,
        481): 1, (293, 293): u, (293, 482): 1, (294, 294): u, (294,
        483): 1, (295, 295): u, (295, 484): 1, (296, 296): u, (296,
        485): 1, (297, 243): w, (298, 244): w, (299, 245): w, (300,
        246): w, (301, 247): w, (302, 248): w, (303, 249): w, (304,
        250): w, (305, 251): w, (306, 252): w, (307, 253): w, (308,
        254): w, (309, 255): w, (310, 256): w, (311, 257): w, (312,
        258): w, (313, 259): w, (314, 260): w, (315, 261): w, (316,
        262): w, (317, 263): w, (318, 264): w, (319, 265): w, (320,
        266): w, (321, 267): w, (322, 268): w, (323, 269): w, (324,
        270): w, (325, 271): w, (326, 272): w, (327, 273): w, (328,
        274): w, (329, 275): w, (330, 276): w, (331, 277): w, (332,
        278): w, (333, 279): w, (334, 280): w, (335, 281): w, (336,
        282): w, (337, 283): w, (338, 284): w, (339, 285): w, (340,
        286): w, (341, 287): w, (342, 288): w, (343, 289): w, (344,
        290): w, (345, 291): w, (346, 292): w, (347, 293): w, (348,
        294): w, (349, 295): w, (350, 296): w, (351, 351): u, (351,
        432): 1, (352, 352): u, (352, 433): 1, (353, 353): u, (353,
        434): 1, (354, 354): u, (354, 435): 1, (355, 355): u, (355,
        436): 1, (356, 356): u, (356, 437): 1, (357, 357): u, (357,
        438): 1, (358, 358): u, (358, 439): 1, (359, 359): u, (359,
        440): 1, (360, 360): u, (360, 441): 1, (361, 361): u, (361,
        442): 1, (362, 362): u, (362, 443): 1, (363, 363): u, (363,
        444): 1, (364, 364): u, (364, 445): 1, (365, 365): u, (365,
        446): 1, (366, 366): u, (366, 447): 1, (367, 367): u, (367,
        448): 1, (368, 368): u, (368, 449): 1, (369, 369): u, (369,
        450): 1, (370, 370): u, (370, 451): 1, (371, 371): u, (371,
        452): 1, (372, 372): u, (372, 453): 1, (373, 373): u, (373,
        454): 1, (374, 374): u, (374, 455): 1, (375, 375): u, (375,
        456): 1, (376, 376): u, (376, 457): 1, (377, 377): u, (377,
        458): 1, (378, 351): w, (379, 352): w, (380, 353): w, (381,
        354): w, (382, 355): w, (383, 356): w, (384, 357): w, (385,
        358): w, (386, 359): w, (387, 360): w, (388, 361): w, (389,
        362): w, (390, 363): w, (391, 364): w, (392, 365): w, (393,
        366): w, (394, 367): w, (395, 368): w, (396, 369): w, (397,
        370): w, (398, 371): w, (399, 372): w, (400, 373): w, (401,
        374): w, (402, 375): w, (403, 376): w, (404, 377): w, (405,
        243): -v, (405, 297): 1, (406, 244): -v, (406, 298): 1, (407,
        245): -v, (407, 299): 1, (408, 246): -v, (408, 300): 1, (409,
        247): -v, (409, 301): 1, (410, 248): -v, (410, 302): 1, (411,
        249): -v, (411, 303): 1, (412, 250): -v, (412, 304): 1, (413,
        251): -v, (413, 305): 1, (414, 252): -v, (414, 306): 1, (415,
        253): -v, (415, 307): 1, (416, 254): -v, (416, 308): 1, (417,
        255): -v, (417, 309): 1, (418, 256): -v, (418, 310): 1, (419,
        257): -v, (419, 311): 1, (420, 258): -v, (420, 312): 1, (421,
        259): -v, (421, 313): 1, (422, 260): -v, (422, 314): 1, (423,
        261): -v, (423, 315): 1, (424, 262): -v, (424, 316): 1, (425,
        263): -v, (425, 317): 1, (426, 264): -v, (426, 318): 1, (427,
        265): -v, (427, 319): 1, (428, 266): -v, (428, 320): 1, (429,
        267): -v, (429, 321): 1, (430, 268): -v, (430, 322): 1, (431,
        269): -v, (431, 323): 1, (432, 351): -v, (432, 378): 1, (433,
        352): -v, (433, 379): 1, (434, 353): -v, (434, 380): 1, (435,
        354): -v, (435, 381): 1, (436, 355): -v, (436, 382): 1, (437,
        356): -v, (437, 383): 1, (438, 357): -v, (438, 384): 1, (439,
        358): -v, (439, 385): 1, (440, 359): -v, (440, 386): 1, (441,
        360): -v, (441, 387): 1, (442, 361): -v, (442, 388): 1, (443,
        362): -v, (443, 389): 1, (444, 363): -v, (444, 390): 1, (445,
        364): -v, (445, 391): 1, (446, 365): -v, (446, 392): 1, (447,
        366): -v, (447, 393): 1, (448, 367): -v, (448, 394): 1, (449,
        368): -v, (449, 395): 1, (450, 369): -v, (450, 396): 1, (451,
        370): -v, (451, 397): 1, (452, 371): -v, (452, 398): 1, (453,
        372): -v, (453, 399): 1, (454, 373): -v, (454, 400): 1, (455,
        374): -v, (455, 401): 1, (456, 375): -v, (456, 402): 1, (457,
        376): -v, (457, 403): 1, (458, 377): -v, (458, 404): 1, (459,
        270): -v, (459, 324): 1, (460, 271): -v, (460, 325): 1, (461,
        272): -v, (461, 326): 1, (462, 273): -v, (462, 327): 1, (463,
        274): -v, (463, 328): 1, (464, 275): -v, (464, 329): 1, (465,
        276): -v, (465, 330): 1, (466, 277): -v, (466, 331): 1, (467,
        278): -v, (467, 332): 1, (468, 279): -v, (468, 333): 1, (469,
        280): -v, (469, 334): 1, (470, 281): -v, (470, 335): 1, (471,
        282): -v, (471, 336): 1, (472, 283): -v, (472, 337): 1, (473,
        284): -v, (473, 338): 1, (474, 285): -v, (474, 339): 1, (475,
        286): -v, (475, 340): 1, (476, 287): -v, (476, 341): 1, (477,
        288): -v, (477, 342): 1, (478, 289): -v, (478, 343): 1, (479,
        290): -v, (479, 344): 1, (480, 291): -v, (480, 345): 1, (481,
        292): -v, (481, 346): 1, (482, 293): -v, (482, 347): 1, (483,
        294): -v, (483, 348): 1, (484, 295): -v, (484, 349): 1, (485,
        296): -v, (485, 350): 1, (486, 513): -v, (486, 540): 1, (487,
        514): -v, (487, 541): 1, (488, 515): -v, (488, 542): 1, (489,
        516): -v, (489, 543): 1, (490, 517): -v, (490, 544): 1, (491,
        518): -v, (491, 545): 1, (492, 519): -v, (492, 546): 1, (493,
        520): -v, (493, 547): 1, (494, 521): -v, (494, 548): 1, (495,
        522): -v, (495, 549): 1, (496, 523): -v, (496, 550): 1, (497,
        524): -v, (497, 551): 1, (498, 525): -v, (498, 552): 1, (499,
        526): -v, (499, 553): 1, (500, 527): -v, (500, 554): 1, (501,
        528): -v, (501, 555): 1, (502, 529): -v, (502, 556): 1, (503,
        530): -v, (503, 557): 1, (504, 531): -v, (504, 558): 1, (505,
        532): -v, (505, 559): 1, (506, 533): -v, (506, 560): 1, (507,
        534): -v, (507, 561): 1, (508, 535): -v, (508, 562): 1, (509,
        536): -v, (509, 563): 1, (510, 537): -v, (510, 564): 1, (511,
        538): -v, (511, 565): 1, (512, 539): -v, (512, 566): 1, (513,
        486): 1, (513, 513): u, (514, 487): 1, (514, 514): u, (515,
        488): 1, (515, 515): u, (516, 489): 1, (516, 516): u, (517,
        490): 1, (517, 517): u, (518, 491): 1, (518, 518): u, (519,
        492): 1, (519, 519): u, (520, 493): 1, (520, 520): u, (521,
        494): 1, (521, 521): u, (522, 495): 1, (522, 522): u, (523,
        496): 1, (523, 523): u, (524, 497): 1, (524, 524): u, (525,
        498): 1, (525, 525): u, (526, 499): 1, (526, 526): u, (527,
        500): 1, (527, 527): u, (528, 501): 1, (528, 528): u, (529,
        502): 1, (529, 529): u, (530, 503): 1, (530, 530): u, (531,
        504): 1, (531, 531): u, (532, 505): 1, (532, 532): u, (533,
        506): 1, (533, 533): u, (534, 507): 1, (534, 534): u, (535,
        508): 1, (535, 535): u, (536, 509): 1, (536, 536): u, (537,
        510): 1, (537, 537): u, (538, 511): 1, (538, 538): u, (539,
        512): 1, (539, 539): u, (540, 513): w, (541, 514): w, (542,
        515): w, (543, 516): w, (544, 517): w, (545, 518): w, (546,
        519): w, (547, 520): w, (548, 521): w, (549, 522): w, (550,
        523): w, (551, 524): w, (552, 525): w, (553, 526): w, (554,
        527): w, (555, 528): w, (556, 529): w, (557, 530): w, (558,
        531): w, (559, 532): w, (560, 533): w, (561, 534): w, (562,
        535): w, (563, 536): w, (564, 537): w, (565, 538): w, (566,
        539): w, (567, 594): -v, (567, 621): 1, (568, 595): -v, (568,
        622): 1, (569, 596): -v, (569, 623): 1, (570, 597): -v, (570,
        624): 1, (571, 598): -v, (571, 625): 1, (572, 599): -v, (572,
        626): 1, (573, 600): -v, (573, 627): 1, (574, 601): -v, (574,
        628): 1, (575, 602): -v, (575, 629): 1, (576, 603): -v, (576,
        630): 1, (577, 604): -v, (577, 631): 1, (578, 605): -v, (578,
        632): 1, (579, 606): -v, (579, 633): 1, (580, 607): -v, (580,
        634): 1, (581, 608): -v, (581, 635): 1, (582, 609): -v, (582,
        636): 1, (583, 610): -v, (583, 637): 1, (584, 611): -v, (584,
        638): 1, (585, 612): -v, (585, 639): 1, (586, 613): -v, (586,
        640): 1, (587, 614): -v, (587, 641): 1, (588, 615): -v, (588,
        642): 1, (589, 616): -v, (589, 643): 1, (590, 617): -v, (590,
        644): 1, (591, 618): -v, (591, 645): 1, (592, 619): -v, (592,
        646): 1, (593, 620): -v, (593, 647): 1, (594, 567): 1, (594,
        594): u, (595, 568): 1, (595, 595): u, (596, 569): 1, (596,
        596): u, (597, 570): 1, (597, 597): u, (598, 571): 1, (598,
        598): u, (599, 572): 1, (599, 599): u, (600, 573): 1, (600,
        600): u, (601, 574): 1, (601, 601): u, (602, 575): 1, (602,
        602): u, (603, 576): 1, (603, 603): u, (604, 577): 1, (604,
        604): u, (605, 578): 1, (605, 605): u, (606, 579): 1, (606,
        606): u, (607, 580): 1, (607, 607): u, (608, 581): 1, (608,
        608): u, (609, 582): 1, (609, 609): u, (610, 583): 1, (610,
        610): u, (611, 584): 1, (611, 611): u, (612, 585): 1, (612,
        612): u, (613, 586): 1, (613, 613): u, (614, 587): 1, (614,
        614): u, (615, 588): 1, (615, 615): u, (616, 589): 1, (616,
        616): u, (617, 590): 1, (617, 617): u, (618, 591): 1, (618,
        618): u, (619, 592): 1, (619, 619): u, (620, 593): 1, (620,
        620): u, (621, 594): w, (622, 595): w, (623, 596): w, (624,
        597): w, (625, 598): w, (626, 599): w, (627, 600): w, (628,
        601): w, (629, 602): w, (630, 603): w, (631, 604): w, (632,
        605): w, (633, 606): w, (634, 607): w, (635, 608): w, (636,
        609): w, (637, 610): w, (638, 611): w, (639, 612): w, (640,
        613): w, (641, 614): w, (642, 615): w, (643, 616): w, (644,
        617): w, (645, 618): w, (646, 619): w, (647, 620): w}, {(0,
        81): -v, (0, 108): 1, (1, 82): -v, (1, 109): 1, (2, 83): -v,
        (2, 110): 1, (3, 84): -v, (3, 111): 1, (4, 85): -v, (4, 112):
        1, (5, 86): -v, (5, 113): 1, (6, 87): -v, (6, 114): 1, (7,
        88): -v, (7, 115): 1, (8, 89): -v, (8, 116): 1, (9, 90): -v,
        (9, 117): 1, (10, 91): -v, (10, 118): 1, (11, 92): -v, (11,
        119): 1, (12, 93): -v, (12, 120): 1, (13, 94): -v, (13, 121):
        1, (14, 95): -v, (14, 122): 1, (15, 96): -v, (15, 123): 1,
        (16, 97): -v, (16, 124): 1, (17, 98): -v, (17, 125): 1, (18,
        99): -v, (18, 126): 1, (19, 100): -v, (19, 127): 1, (20, 101):
        -v, (20, 128): 1, (21, 102): -v, (21, 129): 1, (22, 103): -v,
        (22, 130): 1, (23, 104): -v, (23, 131): 1, (24, 105): -v, (24,
        132): 1, (25, 106): -v, (25, 133): 1, (26, 107): -v, (26,
        134): 1, (27, 405): -v, (27, 432): 1, (27, 594): -v, (27,
        621): u*v/w, (28, 406): -v, (28, 433): 1, (28, 595): -v, (28,
        622): u*v/w, (29, 407): -v, (29, 434): 1, (29, 596): -v, (29,
        623): u*v/w, (30, 408): -v, (30, 435): 1, (30, 597): -v, (30,
        624): u*v/w, (31, 409): -v, (31, 436): 1, (31, 598): -v, (31,
        625): u*v/w, (32, 410): -v, (32, 437): 1, (32, 599): -v, (32,
        626): u*v/w, (33, 411): -v, (33, 438): 1, (33, 600): -v, (33,
        627): u*v/w, (34, 412): -v, (34, 439): 1, (34, 601): -v, (34,
        628): u*v/w, (35, 413): -v, (35, 440): 1, (35, 602): -v, (35,
        629): u*v/w, (36, 414): -v, (36, 441): 1, (36, 603): -v, (36,
        630): u*v/w, (37, 415): -v, (37, 442): 1, (37, 604): -v, (37,
        631): u*v/w, (38, 416): -v, (38, 443): 1, (38, 605): -v, (38,
        632): u*v/w, (39, 417): -v, (39, 444): 1, (39, 606): -v, (39,
        633): u*v/w, (40, 418): -v, (40, 445): 1, (40, 607): -v, (40,
        634): u*v/w, (41, 419): -v, (41, 446): 1, (41, 608): -v, (41,
        635): u*v/w, (42, 420): -v, (42, 447): 1, (42, 609): -v, (42,
        636): u*v/w, (43, 421): -v, (43, 448): 1, (43, 610): -v, (43,
        637): u*v/w, (44, 422): -v, (44, 449): 1, (44, 611): -v, (44,
        638): u*v/w, (45, 423): -v, (45, 450): 1, (45, 612): -v, (45,
        639): u*v/w, (46, 424): -v, (46, 451): 1, (46, 613): -v, (46,
        640): u*v/w, (47, 425): -v, (47, 452): 1, (47, 614): -v, (47,
        641): u*v/w, (48, 426): -v, (48, 453): 1, (48, 615): -v, (48,
        642): u*v/w, (49, 427): -v, (49, 454): 1, (49, 616): -v, (49,
        643): u*v/w, (50, 428): -v, (50, 455): 1, (50, 617): -v, (50,
        644): u*v/w, (51, 429): -v, (51, 456): 1, (51, 618): -v, (51,
        645): u*v/w, (52, 430): -v, (52, 457): 1, (52, 619): -v, (52,
        646): u*v/w, (53, 431): -v, (53, 458): 1, (53, 620): -v, (53,
        647): u*v/w, (54, 459): -v, (54, 486): 1, (54, 621): v*(u*v -
        w)/w, (55, 460): -v, (55, 487): 1, (55, 622): v*(u*v - w)/w,
        (56, 461): -v, (56, 488): 1, (56, 623): v*(u*v - w)/w, (57,
        462): -v, (57, 489): 1, (57, 624): v*(u*v - w)/w, (58, 463):
        -v, (58, 490): 1, (58, 625): v*(u*v - w)/w, (59, 464): -v,
        (59, 491): 1, (59, 626): v*(u*v - w)/w, (60, 465): -v, (60,
        492): 1, (60, 627): v*(u*v - w)/w, (61, 466): -v, (61, 493):
        1, (61, 628): v*(u*v - w)/w, (62, 467): -v, (62, 494): 1, (62,
        629): v*(u*v - w)/w, (63, 468): -v, (63, 495): 1, (63, 630):
        v*(u*v - w)/w, (64, 469): -v, (64, 496): 1, (64, 631): v*(u*v
        - w)/w, (65, 470): -v, (65, 497): 1, (65, 632): v*(u*v - w)/w,
        (66, 471): -v, (66, 498): 1, (66, 633): v*(u*v - w)/w, (67,
        472): -v, (67, 499): 1, (67, 634): v*(u*v - w)/w, (68, 473):
        -v, (68, 500): 1, (68, 635): v*(u*v - w)/w, (69, 474): -v,
        (69, 501): 1, (69, 636): v*(u*v - w)/w, (70, 475): -v, (70,
        502): 1, (70, 637): v*(u*v - w)/w, (71, 476): -v, (71, 503):
        1, (71, 638): v*(u*v - w)/w, (72, 477): -v, (72, 504): 1, (72,
        639): v*(u*v - w)/w, (73, 478): -v, (73, 505): 1, (73, 640):
        v*(u*v - w)/w, (74, 479): -v, (74, 506): 1, (74, 641): v*(u*v
        - w)/w, (75, 480): -v, (75, 507): 1, (75, 642): v*(u*v - w)/w,
        (76, 481): -v, (76, 508): 1, (76, 643): v*(u*v - w)/w, (77,
        482): -v, (77, 509): 1, (77, 644): v*(u*v - w)/w, (78, 483):
        -v, (78, 510): 1, (78, 645): v*(u*v - w)/w, (79, 484): -v,
        (79, 511): 1, (79, 646): v*(u*v - w)/w, (80, 485): -v, (80,
        512): 1, (80, 647): v*(u*v - w)/w, (81, 0): 1, (81, 81): u,
        (82, 1): 1, (82, 82): u, (83, 2): 1, (83, 83): u, (84, 3): 1,
        (84, 84): u, (85, 4): 1, (85, 85): u, (86, 5): 1, (86, 86): u,
        (87, 6): 1, (87, 87): u, (88, 7): 1, (88, 88): u, (89, 8): 1,
        (89, 89): u, (90, 9): 1, (90, 90): u, (91, 10): 1, (91, 91):
        u, (92, 11): 1, (92, 92): u, (93, 12): 1, (93, 93): u, (94,
        13): 1, (94, 94): u, (95, 14): 1, (95, 95): u, (96, 15): 1,
        (96, 96): u, (97, 16): 1, (97, 97): u, (98, 17): 1, (98, 98):
        u, (99, 18): 1, (99, 99): u, (100, 19): 1, (100, 100): u,
        (101, 20): 1, (101, 101): u, (102, 21): 1, (102, 102): u,
        (103, 22): 1, (103, 103): u, (104, 23): 1, (104, 104): u,
        (105, 24): 1, (105, 105): u, (106, 25): 1, (106, 106): u,
        (107, 26): 1, (107, 107): u, (108, 81): w, (109, 82): w, (110,
        83): w, (111, 84): w, (112, 85): w, (113, 86): w, (114, 87):
        w, (115, 88): w, (116, 89): w, (117, 90): w, (118, 91): w,
        (119, 92): w, (120, 93): w, (121, 94): w, (122, 95): w, (123,
        96): w, (124, 97): w, (125, 98): w, (126, 99): w, (127, 100):
        w, (128, 101): w, (129, 102): w, (130, 103): w, (131, 104): w,
        (132, 105): w, (133, 106): w, (134, 107): w, (135, 243): -v,
        (135, 270): 1, (135, 324): -u/w, (135, 594): u, (135, 621):
        -u**2/w, (136, 244): -v, (136, 271): 1, (136, 325): -u/w,
        (136, 595): u, (136, 622): -u**2/w, (137, 245): -v, (137,
        272): 1, (137, 326): -u/w, (137, 596): u, (137, 623): -u**2/w,
        (138, 246): -v, (138, 273): 1, (138, 327): -u/w, (138, 597):
        u, (138, 624): -u**2/w, (139, 247): -v, (139, 274): 1, (139,
        328): -u/w, (139, 598): u, (139, 625): -u**2/w, (140, 248):
        -v, (140, 275): 1, (140, 329): -u/w, (140, 599): u, (140,
        626): -u**2/w, (141, 249): -v, (141, 276): 1, (141, 330):
        -u/w, (141, 600): u, (141, 627): -u**2/w, (142, 250): -v,
        (142, 277): 1, (142, 331): -u/w, (142, 601): u, (142, 628):
        -u**2/w, (143, 251): -v, (143, 278): 1, (143, 332): -u/w,
        (143, 602): u, (143, 629): -u**2/w, (144, 252): -v, (144,
        279): 1, (144, 333): -u/w, (144, 603): u, (144, 630): -u**2/w,
        (145, 253): -v, (145, 280): 1, (145, 334): -u/w, (145, 604):
        u, (145, 631): -u**2/w, (146, 254): -v, (146, 281): 1, (146,
        335): -u/w, (146, 605): u, (146, 632): -u**2/w, (147, 255):
        -v, (147, 282): 1, (147, 336): -u/w, (147, 606): u, (147,
        633): -u**2/w, (148, 256): -v, (148, 283): 1, (148, 337):
        -u/w, (148, 607): u, (148, 634): -u**2/w, (149, 257): -v,
        (149, 284): 1, (149, 338): -u/w, (149, 608): u, (149, 635):
        -u**2/w, (150, 258): -v, (150, 285): 1, (150, 339): -u/w,
        (150, 609): u, (150, 636): -u**2/w, (151, 259): -v, (151,
        286): 1, (151, 340): -u/w, (151, 610): u, (151, 637): -u**2/w,
        (152, 260): -v, (152, 287): 1, (152, 341): -u/w, (152, 611):
        u, (152, 638): -u**2/w, (153, 261): -v, (153, 288): 1, (153,
        342): -u/w, (153, 612): u, (153, 639): -u**2/w, (154, 262):
        -v, (154, 289): 1, (154, 343): -u/w, (154, 613): u, (154,
        640): -u**2/w, (155, 263): -v, (155, 290): 1, (155, 344):
        -u/w, (155, 614): u, (155, 641): -u**2/w, (156, 264): -v,
        (156, 291): 1, (156, 345): -u/w, (156, 615): u, (156, 642):
        -u**2/w, (157, 265): -v, (157, 292): 1, (157, 346): -u/w,
        (157, 616): u, (157, 643): -u**2/w, (158, 266): -v, (158,
        293): 1, (158, 347): -u/w, (158, 617): u, (158, 644): -u**2/w,
        (159, 267): -v, (159, 294): 1, (159, 348): -u/w, (159, 618):
        u, (159, 645): -u**2/w, (160, 268): -v, (160, 295): 1, (160,
        349): -u/w, (160, 619): u, (160, 646): -u**2/w, (161, 269):
        -v, (161, 296): 1, (161, 350): -u/w, (161, 620): u, (161,
        647): -u**2/w, (162, 297): -v, (162, 594): w, (162, 621): -u,
        (163, 298): -v, (163, 595): w, (163, 622): -u, (164, 299): -v,
        (164, 596): w, (164, 623): -u, (165, 300): -v, (165, 597): w,
        (165, 624): -u, (166, 301): -v, (166, 598): w, (166, 625): -u,
        (167, 302): -v, (167, 599): w, (167, 626): -u, (168, 303): -v,
        (168, 600): w, (168, 627): -u, (169, 304): -v, (169, 601): w,
        (169, 628): -u, (170, 305): -v, (170, 602): w, (170, 629): -u,
        (171, 306): -v, (171, 603): w, (171, 630): -u, (172, 307): -v,
        (172, 604): w, (172, 631): -u, (173, 308): -v, (173, 605): w,
        (173, 632): -u, (174, 309): -v, (174, 606): w, (174, 633): -u,
        (175, 310): -v, (175, 607): w, (175, 634): -u, (176, 311): -v,
        (176, 608): w, (176, 635): -u, (177, 312): -v, (177, 609): w,
        (177, 636): -u, (178, 313): -v, (178, 610): w, (178, 637): -u,
        (179, 314): -v, (179, 611): w, (179, 638): -u, (180, 315): -v,
        (180, 612): w, (180, 639): -u, (181, 316): -v, (181, 613): w,
        (181, 640): -u, (182, 317): -v, (182, 614): w, (182, 641): -u,
        (183, 318): -v, (183, 615): w, (183, 642): -u, (184, 319): -v,
        (184, 616): w, (184, 643): -u, (185, 320): -v, (185, 617): w,
        (185, 644): -u, (186, 321): -v, (186, 618): w, (186, 645): -u,
        (187, 322): -v, (187, 619): w, (187, 646): -u, (188, 323): -v,
        (188, 620): w, (188, 647): -u, (189, 324): -u*v/w, (189, 351):
        -v, (189, 513): 1, (189, 567): -v, (189, 621): -u**2*v/w,
        (190, 325): -u*v/w, (190, 352): -v, (190, 514): 1, (190, 568):
        -v, (190, 622): -u**2*v/w, (191, 326): -u*v/w, (191, 353): -v,
        (191, 515): 1, (191, 569): -v, (191, 623): -u**2*v/w, (192,
        327): -u*v/w, (192, 354): -v, (192, 516): 1, (192, 570): -v,
        (192, 624): -u**2*v/w, (193, 328): -u*v/w, (193, 355): -v,
        (193, 517): 1, (193, 571): -v, (193, 625): -u**2*v/w, (194,
        329): -u*v/w, (194, 356): -v, (194, 518): 1, (194, 572): -v,
        (194, 626): -u**2*v/w, (195, 330): -u*v/w, (195, 357): -v,
        (195, 519): 1, (195, 573): -v, (195, 627): -u**2*v/w, (196,
        331): -u*v/w, (196, 358): -v, (196, 520): 1, (196, 574): -v,
        (196, 628): -u**2*v/w, (197, 332): -u*v/w, (197, 359): -v,
        (197, 521): 1, (197, 575): -v, (197, 629): -u**2*v/w, (198,
        333): -u*v/w, (198, 360): -v, (198, 522): 1, (198, 576): -v,
        (198, 630): -u**2*v/w, (199, 334): -u*v/w, (199, 361): -v,
        (199, 523): 1, (199, 577): -v, (199, 631): -u**2*v/w, (200,
        335): -u*v/w, (200, 362): -v, (200, 524): 1, (200, 578): -v,
        (200, 632): -u**2*v/w, (201, 336): -u*v/w, (201, 363): -v,
        (201, 525): 1, (201, 579): -v, (201, 633): -u**2*v/w, (202,
        337): -u*v/w, (202, 364): -v, (202, 526): 1, (202, 580): -v,
        (202, 634): -u**2*v/w, (203, 338): -u*v/w, (203, 365): -v,
        (203, 527): 1, (203, 581): -v, (203, 635): -u**2*v/w, (204,
        339): -u*v/w, (204, 366): -v, (204, 528): 1, (204, 582): -v,
        (204, 636): -u**2*v/w, (205, 340): -u*v/w, (205, 367): -v,
        (205, 529): 1, (205, 583): -v, (205, 637): -u**2*v/w, (206,
        341): -u*v/w, (206, 368): -v, (206, 530): 1, (206, 584): -v,
        (206, 638): -u**2*v/w, (207, 342): -u*v/w, (207, 369): -v,
        (207, 531): 1, (207, 585): -v, (207, 639): -u**2*v/w, (208,
        343): -u*v/w, (208, 370): -v, (208, 532): 1, (208, 586): -v,
        (208, 640): -u**2*v/w, (209, 344): -u*v/w, (209, 371): -v,
        (209, 533): 1, (209, 587): -v, (209, 641): -u**2*v/w, (210,
        345): -u*v/w, (210, 372): -v, (210, 534): 1, (210, 588): -v,
        (210, 642): -u**2*v/w, (211, 346): -u*v/w, (211, 373): -v,
        (211, 535): 1, (211, 589): -v, (211, 643): -u**2*v/w, (212,
        347): -u*v/w, (212, 374): -v, (212, 536): 1, (212, 590): -v,
        (212, 644): -u**2*v/w, (213, 348): -u*v/w, (213, 375): -v,
        (213, 537): 1, (213, 591): -v, (213, 645): -u**2*v/w, (214,
        349): -u*v/w, (214, 376): -v, (214, 538): 1, (214, 592): -v,
        (214, 646): -u**2*v/w, (215, 350): -u*v/w, (215, 377): -v,
        (215, 539): 1, (215, 593): -v, (215, 647): -u**2*v/w, (216,
        324): -v, (216, 378): -v, (216, 540): 1, (216, 621): -u*v,
        (217, 325): -v, (217, 379): -v, (217, 541): 1, (217, 622):
        -u*v, (218, 326): -v, (218, 380): -v, (218, 542): 1, (218,
        623): -u*v, (219, 327): -v, (219, 381): -v, (219, 543): 1,
        (219, 624): -u*v, (220, 328): -v, (220, 382): -v, (220, 544):
        1, (220, 625): -u*v, (221, 329): -v, (221, 383): -v, (221,
        545): 1, (221, 626): -u*v, (222, 330): -v, (222, 384): -v,
        (222, 546): 1, (222, 627): -u*v, (223, 331): -v, (223, 385):
        -v, (223, 547): 1, (223, 628): -u*v, (224, 332): -v, (224,
        386): -v, (224, 548): 1, (224, 629): -u*v, (225, 333): -v,
        (225, 387): -v, (225, 549): 1, (225, 630): -u*v, (226, 334):
        -v, (226, 388): -v, (226, 550): 1, (226, 631): -u*v, (227,
        335): -v, (227, 389): -v, (227, 551): 1, (227, 632): -u*v,
        (228, 336): -v, (228, 390): -v, (228, 552): 1, (228, 633):
        -u*v, (229, 337): -v, (229, 391): -v, (229, 553): 1, (229,
        634): -u*v, (230, 338): -v, (230, 392): -v, (230, 554): 1,
        (230, 635): -u*v, (231, 339): -v, (231, 393): -v, (231, 555):
        1, (231, 636): -u*v, (232, 340): -v, (232, 394): -v, (232,
        556): 1, (232, 637): -u*v, (233, 341): -v, (233, 395): -v,
        (233, 557): 1, (233, 638): -u*v, (234, 342): -v, (234, 396):
        -v, (234, 558): 1, (234, 639): -u*v, (235, 343): -v, (235,
        397): -v, (235, 559): 1, (235, 640): -u*v, (236, 344): -v,
        (236, 398): -v, (236, 560): 1, (236, 641): -u*v, (237, 345):
        -v, (237, 399): -v, (237, 561): 1, (237, 642): -u*v, (238,
        346): -v, (238, 400): -v, (238, 562): 1, (238, 643): -u*v,
        (239, 347): -v, (239, 401): -v, (239, 563): 1, (239, 644):
        -u*v, (240, 348): -v, (240, 402): -v, (240, 564): 1, (240,
        645): -u*v, (241, 349): -v, (241, 403): -v, (241, 565): 1,
        (241, 646): -u*v, (242, 350): -v, (242, 404): -v, (242, 566):
        1, (242, 647): -u*v, (243, 135): 1, (243, 243): u, (243, 621):
        u/w, (244, 136): 1, (244, 244): u, (244, 622): u/w, (245,
        137): 1, (245, 245): u, (245, 623): u/w, (246, 138): 1, (246,
        246): u, (246, 624): u/w, (247, 139): 1, (247, 247): u, (247,
        625): u/w, (248, 140): 1, (248, 248): u, (248, 626): u/w,
        (249, 141): 1, (249, 249): u, (249, 627): u/w, (250, 142): 1,
        (250, 250): u, (250, 628): u/w, (251, 143): 1, (251, 251): u,
        (251, 629): u/w, (252, 144): 1, (252, 252): u, (252, 630):
        u/w, (253, 145): 1, (253, 253): u, (253, 631): u/w, (254,
        146): 1, (254, 254): u, (254, 632): u/w, (255, 147): 1, (255,
        255): u, (255, 633): u/w, (256, 148): 1, (256, 256): u, (256,
        634): u/w, (257, 149): 1, (257, 257): u, (257, 635): u/w,
        (258, 150): 1, (258, 258): u, (258, 636): u/w, (259, 151): 1,
        (259, 259): u, (259, 637): u/w, (260, 152): 1, (260, 260): u,
        (260, 638): u/w, (261, 153): 1, (261, 261): u, (261, 639):
        u/w, (262, 154): 1, (262, 262): u, (262, 640): u/w, (263,
        155): 1, (263, 263): u, (263, 641): u/w, (264, 156): 1, (264,
        264): u, (264, 642): u/w, (265, 157): 1, (265, 265): u, (265,
        643): u/w, (266, 158): 1, (266, 266): u, (266, 644): u/w,
        (267, 159): 1, (267, 267): u, (267, 645): u/w, (268, 160): 1,
        (268, 268): u, (268, 646): u/w, (269, 161): 1, (269, 269): u,
        (269, 647): u/w, (270, 243): w, (270, 297): -u, (271, 244): w,
        (271, 298): -u, (272, 245): w, (272, 299): -u, (273, 246): w,
        (273, 300): -u, (274, 247): w, (274, 301): -u, (275, 248): w,
        (275, 302): -u, (276, 249): w, (276, 303): -u, (277, 250): w,
        (277, 304): -u, (278, 251): w, (278, 305): -u, (279, 252): w,
        (279, 306): -u, (280, 253): w, (280, 307): -u, (281, 254): w,
        (281, 308): -u, (282, 255): w, (282, 309): -u, (283, 256): w,
        (283, 310): -u, (284, 257): w, (284, 311): -u, (285, 258): w,
        (285, 312): -u, (286, 259): w, (286, 313): -u, (287, 260): w,
        (287, 314): -u, (288, 261): w, (288, 315): -u, (289, 262): w,
        (289, 316): -u, (290, 263): w, (290, 317): -u, (291, 264): w,
        (291, 318): -u, (292, 265): w, (292, 319): -u, (293, 266): w,
        (293, 320): -u, (294, 267): w, (294, 321): -u, (295, 268): w,
        (295, 322): -u, (296, 269): w, (296, 323): -u, (297, 162): 1,
        (297, 297): u, (297, 351): u, (298, 163): 1, (298, 298): u,
        (298, 352): u, (299, 164): 1, (299, 299): u, (299, 353): u,
        (300, 165): 1, (300, 300): u, (300, 354): u, (301, 166): 1,
        (301, 301): u, (301, 355): u, (302, 167): 1, (302, 302): u,
        (302, 356): u, (303, 168): 1, (303, 303): u, (303, 357): u,
        (304, 169): 1, (304, 304): u, (304, 358): u, (305, 170): 1,
        (305, 305): u, (305, 359): u, (306, 171): 1, (306, 306): u,
        (306, 360): u, (307, 172): 1, (307, 307): u, (307, 361): u,
        (308, 173): 1, (308, 308): u, (308, 362): u, (309, 174): 1,
        (309, 309): u, (309, 363): u, (310, 175): 1, (310, 310): u,
        (310, 364): u, (311, 176): 1, (311, 311): u, (311, 365): u,
        (312, 177): 1, (312, 312): u, (312, 366): u, (313, 178): 1,
        (313, 313): u, (313, 367): u, (314, 179): 1, (314, 314): u,
        (314, 368): u, (315, 180): 1, (315, 315): u, (315, 369): u,
        (316, 181): 1, (316, 316): u, (316, 370): u, (317, 182): 1,
        (317, 317): u, (317, 371): u, (318, 183): 1, (318, 318): u,
        (318, 372): u, (319, 184): 1, (319, 319): u, (319, 373): u,
        (320, 185): 1, (320, 320): u, (320, 374): u, (321, 186): 1,
        (321, 321): u, (321, 375): u, (322, 187): 1, (322, 322): u,
        (322, 376): u, (323, 188): 1, (323, 323): u, (323, 377): u,
        (324, 351): w, (324, 621): -v, (325, 352): w, (325, 622): -v,
        (326, 353): w, (326, 623): -v, (327, 354): w, (327, 624): -v,
        (328, 355): w, (328, 625): -v, (329, 356): w, (329, 626): -v,
        (330, 357): w, (330, 627): -v, (331, 358): w, (331, 628): -v,
        (332, 359): w, (332, 629): -v, (333, 360): w, (333, 630): -v,
        (334, 361): w, (334, 631): -v, (335, 362): w, (335, 632): -v,
        (336, 363): w, (336, 633): -v, (337, 364): w, (337, 634): -v,
        (338, 365): w, (338, 635): -v, (339, 366): w, (339, 636): -v,
        (340, 367): w, (340, 637): -v, (341, 368): w, (341, 638): -v,
        (342, 369): w, (342, 639): -v, (343, 370): w, (343, 640): -v,
        (344, 371): w, (344, 641): -v, (345, 372): w, (345, 642): -v,
        (346, 373): w, (346, 643): -v, (347, 374): w, (347, 644): -v,
        (348, 375): w, (348, 645): -v, (349, 376): w, (349, 646): -v,
        (350, 377): w, (350, 647): -v, (351, 621): 1, (352, 622): 1,
        (353, 623): 1, (354, 624): 1, (355, 625): 1, (356, 626): 1,
        (357, 627): 1, (358, 628): 1, (359, 629): 1, (360, 630): 1,
        (361, 631): 1, (362, 632): 1, (363, 633): 1, (364, 634): 1,
        (365, 635): 1, (366, 636): 1, (367, 637): 1, (368, 638): 1,
        (369, 639): 1, (370, 640): 1, (371, 641): 1, (372, 642): 1,
        (373, 643): 1, (374, 644): 1, (375, 645): 1, (376, 646): 1,
        (377, 647): 1, (378, 216): 1, (378, 378): u, (378, 621): v,
        (379, 217): 1, (379, 379): u, (379, 622): v, (380, 218): 1,
        (380, 380): u, (380, 623): v, (381, 219): 1, (381, 381): u,
        (381, 624): v, (382, 220): 1, (382, 382): u, (382, 625): v,
        (383, 221): 1, (383, 383): u, (383, 626): v, (384, 222): 1,
        (384, 384): u, (384, 627): v, (385, 223): 1, (385, 385): u,
        (385, 628): v, (386, 224): 1, (386, 386): u, (386, 629): v,
        (387, 225): 1, (387, 387): u, (387, 630): v, (388, 226): 1,
        (388, 388): u, (388, 631): v, (389, 227): 1, (389, 389): u,
        (389, 632): v, (390, 228): 1, (390, 390): u, (390, 633): v,
        (391, 229): 1, (391, 391): u, (391, 634): v, (392, 230): 1,
        (392, 392): u, (392, 635): v, (393, 231): 1, (393, 393): u,
        (393, 636): v, (394, 232): 1, (394, 394): u, (394, 637): v,
        (395, 233): 1, (395, 395): u, (395, 638): v, (396, 234): 1,
        (396, 396): u, (396, 639): v, (397, 235): 1, (397, 397): u,
        (397, 640): v, (398, 236): 1, (398, 398): u, (398, 641): v,
        (399, 237): 1, (399, 399): u, (399, 642): v, (400, 238): 1,
        (400, 400): u, (400, 643): v, (401, 239): 1, (401, 401): u,
        (401, 644): v, (402, 240): 1, (402, 402): u, (402, 645): v,
        (403, 241): 1, (403, 403): u, (403, 646): v, (404, 242): 1,
        (404, 404): u, (404, 647): v, (405, 27): 1, (405, 324): u/w,
        (405, 405): u, (406, 28): 1, (406, 325): u/w, (406, 406): u,
        (407, 29): 1, (407, 326): u/w, (407, 407): u, (408, 30): 1,
        (408, 327): u/w, (408, 408): u, (409, 31): 1, (409, 328): u/w,
        (409, 409): u, (410, 32): 1, (410, 329): u/w, (410, 410): u,
        (411, 33): 1, (411, 330): u/w, (411, 411): u, (412, 34): 1,
        (412, 331): u/w, (412, 412): u, (413, 35): 1, (413, 332): u/w,
        (413, 413): u, (414, 36): 1, (414, 333): u/w, (414, 414): u,
        (415, 37): 1, (415, 334): u/w, (415, 415): u, (416, 38): 1,
        (416, 335): u/w, (416, 416): u, (417, 39): 1, (417, 336): u/w,
        (417, 417): u, (418, 40): 1, (418, 337): u/w, (418, 418): u,
        (419, 41): 1, (419, 338): u/w, (419, 419): u, (420, 42): 1,
        (420, 339): u/w, (420, 420): u, (421, 43): 1, (421, 340): u/w,
        (421, 421): u, (422, 44): 1, (422, 341): u/w, (422, 422): u,
        (423, 45): 1, (423, 342): u/w, (423, 423): u, (424, 46): 1,
        (424, 343): u/w, (424, 424): u, (425, 47): 1, (425, 344): u/w,
        (425, 425): u, (426, 48): 1, (426, 345): u/w, (426, 426): u,
        (427, 49): 1, (427, 346): u/w, (427, 427): u, (428, 50): 1,
        (428, 347): u/w, (428, 428): u, (429, 51): 1, (429, 348): u/w,
        (429, 429): u, (430, 52): 1, (430, 349): u/w, (430, 430): u,
        (431, 53): 1, (431, 350): u/w, (431, 431): u, (432, 297): v,
        (432, 405): w, (432, 621): -u, (433, 298): v, (433, 406): w,
        (433, 622): -u, (434, 299): v, (434, 407): w, (434, 623): -u,
        (435, 300): v, (435, 408): w, (435, 624): -u, (436, 301): v,
        (436, 409): w, (436, 625): -u, (437, 302): v, (437, 410): w,
        (437, 626): -u, (438, 303): v, (438, 411): w, (438, 627): -u,
        (439, 304): v, (439, 412): w, (439, 628): -u, (440, 305): v,
        (440, 413): w, (440, 629): -u, (441, 306): v, (441, 414): w,
        (441, 630): -u, (442, 307): v, (442, 415): w, (442, 631): -u,
        (443, 308): v, (443, 416): w, (443, 632): -u, (444, 309): v,
        (444, 417): w, (444, 633): -u, (445, 310): v, (445, 418): w,
        (445, 634): -u, (446, 311): v, (446, 419): w, (446, 635): -u,
        (447, 312): v, (447, 420): w, (447, 636): -u, (448, 313): v,
        (448, 421): w, (448, 637): -u, (449, 314): v, (449, 422): w,
        (449, 638): -u, (450, 315): v, (450, 423): w, (450, 639): -u,
        (451, 316): v, (451, 424): w, (451, 640): -u, (452, 317): v,
        (452, 425): w, (452, 641): -u, (453, 318): v, (453, 426): w,
        (453, 642): -u, (454, 319): v, (454, 427): w, (454, 643): -u,
        (455, 320): v, (455, 428): w, (455, 644): -u, (456, 321): v,
        (456, 429): w, (456, 645): -u, (457, 322): v, (457, 430): w,
        (457, 646): -u, (458, 323): v, (458, 431): w, (458, 647): -u,
        (459, 54): 1, (459, 324): u*v/w, (459, 459): u, (460, 55): 1,
        (460, 325): u*v/w, (460, 460): u, (461, 56): 1, (461, 326):
        u*v/w, (461, 461): u, (462, 57): 1, (462, 327): u*v/w, (462,
        462): u, (463, 58): 1, (463, 328): u*v/w, (463, 463): u, (464,
        59): 1, (464, 329): u*v/w, (464, 464): u, (465, 60): 1, (465,
        330): u*v/w, (465, 465): u, (466, 61): 1, (466, 331): u*v/w,
        (466, 466): u, (467, 62): 1, (467, 332): u*v/w, (467, 467): u,
        (468, 63): 1, (468, 333): u*v/w, (468, 468): u, (469, 64): 1,
        (469, 334): u*v/w, (469, 469): u, (470, 65): 1, (470, 335):
        u*v/w, (470, 470): u, (471, 66): 1, (471, 336): u*v/w, (471,
        471): u, (472, 67): 1, (472, 337): u*v/w, (472, 472): u, (473,
        68): 1, (473, 338): u*v/w, (473, 473): u, (474, 69): 1, (474,
        339): u*v/w, (474, 474): u, (475, 70): 1, (475, 340): u*v/w,
        (475, 475): u, (476, 71): 1, (476, 341): u*v/w, (476, 476): u,
        (477, 72): 1, (477, 342): u*v/w, (477, 477): u, (478, 73): 1,
        (478, 343): u*v/w, (478, 478): u, (479, 74): 1, (479, 344):
        u*v/w, (479, 479): u, (480, 75): 1, (480, 345): u*v/w, (480,
        480): u, (481, 76): 1, (481, 346): u*v/w, (481, 481): u, (482,
        77): 1, (482, 347): u*v/w, (482, 482): u, (483, 78): 1, (483,
        348): u*v/w, (483, 483): u, (484, 79): 1, (484, 349): u*v/w,
        (484, 484): u, (485, 80): 1, (485, 350): u*v/w, (485, 485): u,
        (486, 324): v, (486, 459): w, (487, 325): v, (487, 460): w,
        (488, 326): v, (488, 461): w, (489, 327): v, (489, 462): w,
        (490, 328): v, (490, 463): w, (491, 329): v, (491, 464): w,
        (492, 330): v, (492, 465): w, (493, 331): v, (493, 466): w,
        (494, 332): v, (494, 467): w, (495, 333): v, (495, 468): w,
        (496, 334): v, (496, 469): w, (497, 335): v, (497, 470): w,
        (498, 336): v, (498, 471): w, (499, 337): v, (499, 472): w,
        (500, 338): v, (500, 473): w, (501, 339): v, (501, 474): w,
        (502, 340): v, (502, 475): w, (503, 341): v, (503, 476): w,
        (504, 342): v, (504, 477): w, (505, 343): v, (505, 478): w,
        (506, 344): v, (506, 479): w, (507, 345): v, (507, 480): w,
        (508, 346): v, (508, 481): w, (509, 347): v, (509, 482): w,
        (510, 348): v, (510, 483): w, (511, 349): v, (511, 484): w,
        (512, 350): v, (512, 485): w, (513, 567): w, (513, 621): v,
        (514, 568): w, (514, 622): v, (515, 569): w, (515, 623): v,
        (516, 570): w, (516, 624): v, (517, 571): w, (517, 625): v,
        (518, 572): w, (518, 626): v, (519, 573): w, (519, 627): v,
        (520, 574): w, (520, 628): v, (521, 575): w, (521, 629): v,
        (522, 576): w, (522, 630): v, (523, 577): w, (523, 631): v,
        (524, 578): w, (524, 632): v, (525, 579): w, (525, 633): v,
        (526, 580): w, (526, 634): v, (527, 581): w, (527, 635): v,
        (528, 582): w, (528, 636): v, (529, 583): w, (529, 637): v,
        (530, 584): w, (530, 638): v, (531, 585): w, (531, 639): v,
        (532, 586): w, (532, 640): v, (533, 587): w, (533, 641): v,
        (534, 588): w, (534, 642): v, (535, 589): w, (535, 643): v,
        (536, 590): w, (536, 644): v, (537, 591): w, (537, 645): v,
        (538, 592): w, (538, 646): v, (539, 593): w, (539, 647): v,
        (540, 378): w, (541, 379): w, (542, 380): w, (543, 381): w,
        (544, 382): w, (545, 383): w, (546, 384): w, (547, 385): w,
        (548, 386): w, (549, 387): w, (550, 388): w, (551, 389): w,
        (552, 390): w, (553, 391): w, (554, 392): w, (555, 393): w,
        (556, 394): w, (557, 395): w, (558, 396): w, (559, 397): w,
        (560, 398): w, (561, 399): w, (562, 400): w, (563, 401): w,
        (564, 402): w, (565, 403): w, (566, 404): w, (567, 189): 1,
        (567, 567): u, (567, 621): u*v/w, (568, 190): 1, (568, 568):
        u, (568, 622): u*v/w, (569, 191): 1, (569, 569): u, (569,
        623): u*v/w, (570, 192): 1, (570, 570): u, (570, 624): u*v/w,
        (571, 193): 1, (571, 571): u, (571, 625): u*v/w, (572, 194):
        1, (572, 572): u, (572, 626): u*v/w, (573, 195): 1, (573,
        573): u, (573, 627): u*v/w, (574, 196): 1, (574, 574): u,
        (574, 628): u*v/w, (575, 197): 1, (575, 575): u, (575, 629):
        u*v/w, (576, 198): 1, (576, 576): u, (576, 630): u*v/w, (577,
        199): 1, (577, 577): u, (577, 631): u*v/w, (578, 200): 1,
        (578, 578): u, (578, 632): u*v/w, (579, 201): 1, (579, 579):
        u, (579, 633): u*v/w, (580, 202): 1, (580, 580): u, (580,
        634): u*v/w, (581, 203): 1, (581, 581): u, (581, 635): u*v/w,
        (582, 204): 1, (582, 582): u, (582, 636): u*v/w, (583, 205):
        1, (583, 583): u, (583, 637): u*v/w, (584, 206): 1, (584,
        584): u, (584, 638): u*v/w, (585, 207): 1, (585, 585): u,
        (585, 639): u*v/w, (586, 208): 1, (586, 586): u, (586, 640):
        u*v/w, (587, 209): 1, (587, 587): u, (587, 641): u*v/w, (588,
        210): 1, (588, 588): u, (588, 642): u*v/w, (589, 211): 1,
        (589, 589): u, (589, 643): u*v/w, (590, 212): 1, (590, 590):
        u, (590, 644): u*v/w, (591, 213): 1, (591, 591): u, (591,
        645): u*v/w, (592, 214): 1, (592, 592): u, (592, 646): u*v/w,
        (593, 215): 1, (593, 593): u, (593, 647): u*v/w, (594, 297):
        1, (595, 298): 1, (596, 299): 1, (597, 300): 1, (598, 301): 1,
        (599, 302): 1, (600, 303): 1, (601, 304): 1, (602, 305): 1,
        (603, 306): 1, (604, 307): 1, (605, 308): 1, (606, 309): 1,
        (607, 310): 1, (608, 311): 1, (609, 312): 1, (610, 313): 1,
        (611, 314): 1, (612, 315): 1, (613, 316): 1, (614, 317): 1,
        (615, 318): 1, (616, 319): 1, (617, 320): 1, (618, 321): 1,
        (619, 322): 1, (620, 323): 1, (621, 324): 1, (621, 621): u,
        (622, 325): 1, (622, 622): u, (623, 326): 1, (623, 623): u,
        (624, 327): 1, (624, 624): u, (625, 328): 1, (625, 625): u,
        (626, 329): 1, (626, 626): u, (627, 330): 1, (627, 627): u,
        (628, 331): 1, (628, 628): u, (629, 332): 1, (629, 629): u,
        (630, 333): 1, (630, 630): u, (631, 334): 1, (631, 631): u,
        (632, 335): 1, (632, 632): u, (633, 336): 1, (633, 633): u,
        (634, 337): 1, (634, 634): u, (635, 338): 1, (635, 635): u,
        (636, 339): 1, (636, 636): u, (637, 340): 1, (637, 637): u,
        (638, 341): 1, (638, 638): u, (639, 342): 1, (639, 639): u,
        (640, 343): 1, (640, 640): u, (641, 344): 1, (641, 641): u,
        (642, 345): 1, (642, 642): u, (643, 346): 1, (643, 643): u,
        (644, 347): 1, (644, 644): u, (645, 348): 1, (645, 645): u,
        (646, 349): 1, (646, 646): u, (647, 350): 1, (647, 647): u},
        {(0, 3): -v, (0, 4): 1, (1, 509): u**2/w, (1, 510): -u, (1,
        511): -u, (1, 512): w, (1, 535): u*v, (1, 562): -u, (2, 2): u,
        (2, 110): u*v/w, (2, 353): -u*v**2/w, (2, 371): -u*v, (2,
        372): u, (2, 380): u*v/w, (2, 398): u, (2, 399): -u**2/w, (2,
        434): u**2*v/w, (2, 451): u, (2, 568): -u**3/w, (2, 597): w,
        (2, 622): -u**2*(u*v - w)/w**2, (2, 624): -u, (3, 0): 1, (3,
        3): u, (4, 3): w, (5, 7): w, (5, 115): v, (5, 368): v**2*(u*v
        - w)/w, (5, 376): u*v**2*(u*v - w)/w, (6, 8): w, (6, 116): v,
        (6, 127): -u, (6, 184): u*v, (6, 238): -u**2*v/w, (6, 368):
        u*v**2/w, (6, 377): u*v**2*(u*v - w)/w, (6, 395): -u*v/w, (6,
        434): u*v**2/w, (6, 528): -v**2/w, (6, 555): u*v**2/w**2, (6,
        616): u*v**2, (6, 643): -u**2*v**2/w, (7, 7): u, (7, 108): 1,
        (7, 115): u*v/w, (7, 368): u*v**2*(u*v - w)/w**2, (7, 376):
        u**2*v**2*(u*v - w)/w**2, (8, 8): u, (8, 81): 1, (8, 115):
        u/w, (8, 368): u*v*(u*v - w)/w**2, (8, 376): u**2*v*(u*v -
        w)/w**2, (9, 13): w, (9, 121): v, (9, 364): -v**2, (9, 391):
        v, (9, 526): v, (9, 535): v*w, (9, 553): -u*v/w, (9, 562):
        -u*v, (10, 14): w, (10, 122): v, (10, 185): -u, (10, 186):
        u*v, (10, 239): u**2/w, (10, 240): -u**2*v/w, (10, 373):
        u**2*v**3/w, (10, 400): -u**2*v**2/w, (10, 487): u**2/w, (10,
        527): v, (10, 535): u*v, (10, 536): u*v*(u*v - w)/w**2, (10,
        538): -v*(u*v - w)/w, (10, 554): -u*v/w, (10, 562): -u**2*v/w,
        (10, 563): -u**2*v*(u*v - w)/w**3, (10, 565): u*v*(u*v -
        w)/w**2, (10, 568): u**3*v/w, (10, 617): -u*v, (10, 618):
        u*v**2, (10, 622): u**2*v*(u*v - w)/w**2, (10, 644): u**2*v/w,
        (10, 645): -u**2*v**2/w, (11, 15): w, (11, 123): v, (11, 129):
        -u, (11, 132): -u**2, (11, 184): -u*w, (11, 238): u**2, (11,
        366): -v**2, (11, 393): v, (11, 488): -u, (11, 509):
        -u**3*v/w**2, (11, 511): u**2*v/w, (11, 528): v, (11, 535):
        -u**2*v**2/w, (11, 555): -u*v/w, (11, 562): u**2*v/w, (11,
        588): -u*v, (11, 591): -u**2*v, (11, 595): u**3, (11, 616):
        -u*v*w, (11, 622): -u**4/w, (11, 643): u**2*v, (12, 16): w,
        (12, 110): -u*v/w, (12, 124): v, (12, 128): -u, (12, 184):
        -u**2, (12, 187): -u, (12, 188): u*v, (12, 238): u**3/w, (12,
        241): u**2/w, (12, 242): -u, (12, 367): -v**2, (12, 394): v,
        (12, 434): -u, (12, 460): u**2/w, (12, 529): v, (12, 556):
        -u*v/w, (12, 568): u**3/w, (12, 569): -u*v**2/w, (12, 587):
        -u*v, (12, 616): -u**2*v, (12, 619): -u*v, (12, 620): u*v**2,
        (12, 643): u**3*v/w, (12, 646): u**2*v/w, (12, 647): -u*v,
        (13, 13): u, (13, 121): u*v/w, (13, 364): -u*v**2/w, (13,
        391): u*v/w, (13, 486): 1, (13, 526): u*v/w, (13, 535):
        u**2*v**2/w, (13, 553): -u**2*v/w**2, (13, 562):
        -u**3*v**2/w**2, (14, 14): u, (14, 122): u*v/w, (14, 364):
        -u*v/w, (14, 373): u**2*v**2*(u*v - w)/w**2, (14, 391):
        u**2*v/w**2, (14, 432): 1, (14, 526): u/w, (14, 535):
        u**2*v/w, (14, 553): -u**2/w**2, (14, 562): -u**3*v/w**2, (14,
        594): -v, (14, 621): u*v/w, (15, 15): u, (15, 121): u/w, (15,
        366): -u*v**2/w, (15, 368): u, (15, 376): -u**2*(u*v - w)/w,
        (15, 377): u**2*v*(u*v - w)/w, (15, 393): u*v/w, (15, 395):
        -u**2/w, (15, 445): u**2/w, (15, 449): -u*v/w, (15, 455):
        u**2/w, (15, 456): -u**2*v/w, (15, 457): -u**2*v/w, (15, 458):
        u**2*v**2/w, (15, 459): 1, (15, 567): u, (15, 574): u, (15,
        575): -u*v, (15, 580): u*v/w, (15, 582): -u*v**2/w, (15, 586):
        u**2, (16, 16): u, (16, 122): u/w, (16, 179): u/w, (16, 233):
        -u**2/w**2, (16, 366): -u*v/w, (16, 368): u**2/w, (16, 373):
        u**2*v*(u*v - w)/w**2, (16, 393): u/w, (16, 395): -u**3/w**2,
        (16, 405): 1, (16, 407): u**2*v/w, (16, 535): u**2/w, (16,
        562): -u**3/w**2, (16, 580): u/w, (16, 582): -u*v/w, (16,
        596): u**2*v/w, (16, 616): u**3*v/w, (16, 623): -u**2/w, (16,
        643): -u**4*v/w**2, (17, 17): u, (17, 125): u*v/w, (17, 364):
        u, (17, 368): -u*v**2/w, (17, 391): -u**2/w, (17, 395): u*v/w,
        (17, 508): u**2*v/w, (17, 594): w, (17, 621): -u, (18, 17): w,
        (18, 125): v, (18, 186): -u*w, (18, 240): u**2, (18, 368):
        -v**2, (18, 395): v, (18, 508): u*v, (18, 530): v, (18, 536):
        -u**2*v/w, (18, 538): u*v, (18, 557): -u*v/w, (18, 563):
        u**3*v/w**2, (18, 565): -u**2*v/w, (18, 568): -u**3, (18,
        618): -u*v*w, (18, 622): -u**2*(u*v - w)/w, (18, 645): u**2*v,
        (19, 19): u, (19, 111): 1, (19, 127): u*v/w, (19, 353):
        u*v**2*(u*v - w)/w**2, (19, 371): u*v*(u*v - w)/w, (20, 20):
        u, (20, 128): u*v/w, (20, 372): -u*v/w, (20, 399):
        u**2*v/w**2, (20, 435): 1, (20, 452): u**2*v/w, (20, 534):
        u/w, (20, 561): -u**2/w**2, (20, 597): -v, (20, 624): u*v/w,
        (21, 21): u, (21, 129): u*v/w, (21, 372): -u*v**2/w, (21,
        399): u*v/w, (21, 452): u*v, (21, 489): 1, (21, 534): u*v/w,
        (21, 561): -u**2*v/w**2, (22, 22): u, (22, 130): u*v/w, (22,
        373): -u*v**2/w, (22, 400): u*v/w, (22, 446): 1, (22, 454):
        u**2*v/w, (23, 23): u, (23, 131): u*v/w, (23, 374): -u*v**2/w,
        (23, 401): u*v/w, (23, 434): u*v, (23, 449): v, (23, 457):
        u*v, (23, 493): 1, (23, 505): u, (23, 508): -u*v**2/w, (23,
        536): u*v/w, (23, 563): -u**2*v/w**2, (24, 24): u, (24, 132):
        u*v/w, (24, 375): -u*v**2/w, (24, 402): u*v/w, (24, 458): u*v,
        (24, 494): 1, (24, 501): v/w, (24, 537): u*v/w, (24, 564):
        -u**2*v/w**2, (25, 25): u, (25, 133): u*v/w, (25, 376):
        -u*v**2/w, (25, 403): u*v/w, (25, 439): 1, (25, 449): u*v/w,
        (25, 457): u**2*v/w, (25, 508): -u*v/w, (25, 536): u/w, (25,
        563): -u**2/w**2, (25, 568): u**3/w, (25, 622): u**2*(u*v -
        w)/w**2, (26, 26): u, (26, 134): u*v/w, (26, 136): -u**2/w,
        (26, 190): u**3/w**2, (26, 271): -u**2*v/w**2, (26, 325):
        u**3*v/w**3, (26, 377): -u*v**2/w, (26, 404): u*v/w, (26,
        440): 1, (26, 449): u/w, (26, 458): u**2*v/w, (26, 537): u/w,
        (26, 564): -u**2/w**2, (26, 568): u**4/w**2, (26, 595):
        -u**3*v/w**2, (26, 613): -u, (26, 622): u**3*(2*u*v - w)/w**3,
        (26, 640): u**2/w, (27, 30): -v, (27, 31): 1, (28, 508): -u,
        (28, 535): -u**2, (28, 536): u**2/w, (28, 537): -u, (28, 538):
        -u, (28, 539): w, (29, 29): u, (29, 164): u*v/w, (29, 353):
        2*u**2*v/w, (29, 370): u, (29, 371): u**2, (29, 399): u/w,
        (29, 434): u*v/w, (29, 452): u, (29, 568): u**2/w, (29, 622):
        u**2*v/w**2, (29, 624): 1, (30, 27): 1, (30, 30): u, (31, 30):
        w, (32, 34): w, (32, 169): v, (32, 368): -u**2*v**2/w, (32,
        376): -u**3*v**2/w, (32, 395): -v**2/w, (32, 403): -u*v**2/w,
        (32, 449): -u*v**2/w, (32, 457): -u**2*v**2/w, (33, 35): w,
        (33, 170): v, (33, 181): -u, (33, 238): u*v/w, (33, 353):
        u*v**2/w, (33, 368): -u**2*v/w, (33, 377): -u**3*v**2/w, (33,
        404): -u*v**2/w, (33, 449): -u*v/w, (33, 458): -u**2*v**2/w,
        (33, 555): -v**2/w**2, (33, 643): u*v**2/w, (34, 34): u, (34,
        162): 1, (34, 169): u*v/w, (34, 368): -u**3*v**2/w**2, (34,
        376): -u**4*v**2/w**2, (34, 395): -u*v**2/w**2, (34, 403):
        -u**2*v**2/w**2, (34, 449): -u**2*v**2/w**2, (34, 457):
        -u**3*v**2/w**2, (35, 35): u, (35, 135): 1, (35, 169): u/w,
        (35, 368): -u**3*v/w**2, (35, 376): -u**4*v/w**2, (35, 395):
        -u*v/w**2, (35, 403): -u**2*v/w**2, (35, 449): -u**2*v/w**2,
        (35, 457): -u**3*v/w**2, (36, 40): w, (36, 175): v, (36, 364):
        u*v, (36, 445): v, (36, 553): v/w, (36, 562): v, (37, 41): w,
        (37, 176): v, (37, 239): -u/w, (37, 240): u*v/w, (37, 373):
        -u**3*v**2/w, (37, 454): -u**2*v**2/w, (37, 514): u**2/w, (37,
        554): v/w, (37, 562): u*v/w, (37, 563): u*v*(u*v - w)/w**3,
        (37, 565): -v*(u*v - w)/w**2, (37, 568): -u**2*v/w, (37, 622):
        -u**2*v**2/w**2, (37, 644): -u*v/w, (37, 645): u*v**2/w, (38,
        42): w, (38, 177): v, (38, 183): -u, (38, 186): -u**2, (38,
        238): -u, (38, 366): u*v, (38, 447): v, (38, 508): u**2*v/w,
        (38, 515): -u, (38, 535): u**3*v/w, (38, 536): -u**3*v/w**2,
        (38, 538): u**2*v/w, (38, 555): v/w, (38, 615): -u*v, (38,
        618): -u**2*v, (38, 622): u**3/w, (38, 643): -u*v, (39, 43):
        w, (39, 134): -u, (39, 164): -u*v/w, (39, 178): v, (39, 182):
        -u, (39, 188): -u**2, (39, 238): -u**2/w, (39, 241): -u/w,
        (39, 271): u**2/w, (39, 353): -u, (39, 367): u*v, (39, 448):
        v, (39, 556): v/w, (39, 593): -u*v, (39, 595): u**3/w, (39,
        596): -u*v**2/w, (39, 614): -u*v, (39, 620): -u**2*v, (39,
        643): -u**2*v/w, (39, 646): -u*v/w, (40, 40): u, (40, 175):
        u*v/w, (40, 364): u**2*v/w, (40, 445): u*v/w, (40, 513): 1,
        (40, 553): u*v/w**2, (40, 562): u**2*v**2/w**2, (41, 41): u,
        (41, 176): u*v/w, (41, 351): 1, (41, 373): -u**4*v**2/w**2,
        (41, 391): -u*v/w**2, (41, 400): -u**2*v**2/w**2, (41, 454):
        -u**3*v**2/w**2, (41, 553): u/w**2, (41, 562): u**2*v/w**2,
        (41, 621): -v/w, (42, 42): u, (42, 175): u/w, (42, 270): 1,
        (42, 364): u**2/w, (42, 366): u**2*v/w, (42, 368): -u*v/w,
        (42, 374): u**2/w, (42, 375): -u**2*v/w, (42, 376): u**2*(u**2
        - v)/w, (42, 377): -u**2*v*(u**2 - v)/w, (42, 395): u/w, (42,
        403): u**2/w, (42, 404): -u**2*v/w, (42, 447): u*v/w, (42,
        457): u**3/w, (42, 458): -u**3*v/w, (42, 594): u, (42, 601):
        u, (42, 602): -u*v, (42, 607): u*v/w, (42, 609): -u*v**2/w,
        (42, 613): u**2, (43, 43): u, (43, 176): u/w, (43, 233):
        u/w**2, (43, 243): 1, (43, 245): u**2*v/w, (43, 366): u**2/w,
        (43, 373): -u**4*v/w**2, (43, 395): u**2/w**2, (43, 400):
        -u**2*v/w**2, (43, 447): u/w, (43, 454): -u**3*v/w**2, (43,
        562): u**2/w**2, (43, 569): -u**2/w, (43, 596): -u**3/w, (43,
        607): u/w, (43, 609): -u*v/w, (43, 643): u**3*v/w**2, (44,
        44): u, (44, 179): u*v/w, (44, 368): u**2*v/w, (44, 391): u/w,
        (44, 449): u*v/w, (44, 535): u**2*v/w, (44, 621): 1, (45, 44):
        w, (45, 179): v, (45, 240): -u, (45, 368): u*v, (45, 449): v,
        (45, 535): u*v, (45, 557): v/w, (45, 563): -u**2*v/w**2, (45,
        565): u*v/w, (45, 568): u**2, (45, 622): u**2*v/w, (45, 645):
        -u*v, (46, 46): u, (46, 165): 1, (46, 181): u*v/w, (46, 353):
        -u**3*v**2/w**2, (46, 371): -u**3*v/w, (46, 380):
        -u*v**2/w**2, (46, 398): -u*v/w, (46, 434): -u**2*v**2/w**2,
        (46, 452): -u**2*v/w, (47, 47): u, (47, 182): u*v/w, (47,
        354): 1, (47, 371): u**2*v/w, (47, 399): -u*v/w**2, (47, 561):
        u/w**2, (47, 624): -v/w, (48, 48): u, (48, 183): u*v/w, (48,
        371): u*v, (48, 372): u**2*v/w, (48, 453): u*v/w, (48, 516):
        1, (48, 561): u*v/w**2, (49, 49): u, (49, 184): u*v/w, (49,
        365): 1, (49, 373): 2*u**2*v/w, (49, 454): u*v/w, (50, 50): u,
        (50, 185): u*v/w, (50, 353): u*v, (50, 368): v, (50, 374):
        u**2*v/w, (50, 376): u*v, (50, 455): u*v/w, (50, 520): 1, (50,
        532): u, (50, 535): -u*v**2/w, (50, 563): u*v/w**2, (51, 51):
        u, (51, 186): u*v/w, (51, 375): u**2*v/w, (51, 377): u*v, (51,
        456): u*v/w, (51, 521): 1, (51, 528): v/w, (51, 564):
        u*v/w**2, (52, 52): u, (52, 187): u*v/w, (52, 358): 1, (52,
        368): u*v/w, (52, 376): 2*u**2*v/w, (52, 457): u*v/w, (52,
        535): -u*v/w, (52, 563): u/w**2, (52, 568): -u**2/w, (52,
        622): -u**2*v/w**2, (53, 53): u, (53, 188): u*v/w, (53, 190):
        -u**2/w**2, (53, 325): -u**2*v/w**3, (53, 359): 1, (53, 368):
        u/w, (53, 377): 2*u**2*v/w, (53, 458): u*v/w, (53, 564):
        u/w**2, (53, 568): -u**3/w**2, (53, 622): -2*u**3*v/w**3, (53,
        640): -u/w, (54, 57): -v, (54, 58): 1, (55, 535): -u*w, (55,
        563): u**2/w, (55, 564): -u, (55, 565): -u, (55, 566): w, (56,
        56): u, (56, 218): u*v/w, (56, 353): u*v, (56, 371): u*w, (56,
        380): u**2*v/w, (56, 397): u, (56, 399): u*v/w, (56, 453): u,
        (56, 568): u**2*v/w, (56, 570): w, (56, 595): u**2, (56, 622):
        -u**2*(u*w - v**2)/w**2, (56, 624): v, (57, 54): 1, (57, 57):
        u, (58, 57): w, (59, 61): w, (59, 223): v, (59, 368): -u*v**2,
        (59, 376): -u**2*v**2, (59, 395): -v**3/w, (59, 403):
        -u*v**3/w, (59, 449): -v**2, (59, 457): -u*v**2, (60, 62): w,
        (60, 130): u*v, (60, 224): v, (60, 235): -u, (60, 238):
        u*v**2/w, (60, 368): -u*v, (60, 377): -u**2*v**2, (60, 380):
        u*v**2/w, (60, 404): -u*v**3/w, (60, 458): -u*v**2, (60, 501):
        -v**2/w, (60, 555): -v**3/w**2, (60, 589): u*v**2, (60, 643):
        u*v**3/w, (61, 61): u, (61, 216): 1, (61, 223): u*v/w, (61,
        368): -u**2*v**2/w, (61, 376): -u**3*v**2/w, (61, 395):
        -u*v**3/w**2, (61, 403): -u**2*v**3/w**2, (61, 449):
        -u*v**2/w, (61, 457): -u**2*v**2/w, (62, 62): u, (62, 189): 1,
        (62, 223): u/w, (62, 368): -u**2*v/w, (62, 376): -u**3*v/w,
        (62, 395): -u*v**2/w**2, (62, 403): -u**2*v**2/w**2, (62,
        449): -u*v/w, (62, 457): -u**2*v/w, (63, 67): w, (63, 229): v,
        (63, 364): v*w, (63, 499): v, (63, 508): v*w, (63, 553):
        v**2/w, (63, 562): v**2, (64, 68): w, (64, 131): -u, (64,
        132): u*v, (64, 230): v, (64, 239): -u*v/w, (64, 240):
        u*v**2/w, (64, 373): -u**2*v**2, (64, 500): v, (64, 508): u*v,
        (64, 509): u*v*(u*v - w)/w**2, (64, 511): -v*(u*v - w)/w, (64,
        541): u**2/w, (64, 554): v**2/w, (64, 562): u*v**2/w, (64,
        563): u*v**2*(u*v - w)/w**3, (64, 565): -v**2*(u*v - w)/w**2,
        (64, 568): -u**2*v**2/w, (64, 590): -u*v, (64, 591): u*v**2,
        (64, 595): -u**2*v, (64, 622): u**2*v*(u*w - v**2)/w**2, (64,
        644): -u*v**2/w, (64, 645): u*v**3/w, (65, 69): w, (65, 130):
        -u*w, (65, 231): v, (65, 237): -u, (65, 238): -u*v, (65, 240):
        -u**2, (65, 366): v*w, (65, 501): v, (65, 535): u**2*v, (65,
        542): -u, (65, 555): v**2/w, (65, 563): -u**3*v/w**2, (65,
        565): u**2*v/w, (65, 568): u**3, (65, 589): -u*v*w, (65, 622):
        u**3*v/w, (65, 642): -u*v, (65, 643): -u*v**2, (65, 645):
        -u**2*v, (66, 70): w, (66, 130): -u**2, (66, 133): -u, (66,
        188): -u*w, (66, 218): -u*v/w, (66, 232): v, (66, 236): -u,
        (66, 238): -u**2*v/w, (66, 241): -u*v/w, (66, 325): u**2/w,
        (66, 367): v*w, (66, 380): -u, (66, 502): v, (66, 556):
        v**2/w, (66, 589): -u**2*v, (66, 592): -u*v, (66, 620):
        -u*v*w, (66, 622): u**3/w, (66, 623): -u*v**2/w, (66, 641):
        -u*v, (66, 643): -u**2*v**2/w, (66, 646): -u*v**2/w, (67, 67):
        u, (67, 229): u*v/w, (67, 364): u*v, (67, 499): u*v/w, (67,
        508): u**2*v**2/w, (67, 540): 1, (67, 553): u*v**2/w**2, (67,
        562): u**2*v**3/w**2, (68, 68): u, (68, 230): u*v/w, (68,
        373): -u**3*v**2/w, (68, 378): 1, (68, 391): -u*v**2/w**2,
        (68, 400): -u**2*v**3/w**2, (68, 445): -u*v/w, (68, 454):
        -u**2*v**2/w, (68, 499): u/w, (68, 508): u**2*v/w, (68, 553):
        u*v/w**2, (68, 562): u**2*v**2/w**2, (68, 567): -v, (68, 621):
        -v**2/w, (69, 69): u, (69, 229): u/w, (69, 324): 1, (69, 366):
        u*v, (69, 376): u**3, (69, 377): -u**3*v, (69, 391): u**2/w,
        (69, 401): u**2/w, (69, 402): -u**2*v/w, (69, 449): u, (69,
        457): u**2, (69, 458): -u**2*v, (69, 621): u, (69, 628): u,
        (69, 629): -u*v, (69, 634): u*v/w, (69, 636): -u*v**2/w, (69,
        640): u**2, (70, 70): u, (70, 125): u/w, (70, 230): u/w, (70,
        233): u*v/w**2, (70, 297): 1, (70, 299): u**2*v/w, (70, 366):
        u, (70, 373): -u**3*v/w, (70, 395): u**2*v/w**2, (70, 400):
        -u**2*v**2/w**2, (70, 449): u**2/w, (70, 454): -u**2*v/w, (70,
        508): u**2/w, (70, 562): u**2*v/w**2, (70, 589): u**3*v/w,
        (70, 596): -u**2, (70, 634): u/w, (70, 636): -u*v/w, (70,
        643): u**3*v**2/w**2, (71, 71): u, (71, 233): u*v/w, (71,
        368): u*v, (71, 391): u*v/w, (71, 445): u, (71, 562):
        u**2*v/w, (71, 567): w, (71, 621): v, (72, 71): w, (72, 132):
        -u*w, (72, 233): v, (72, 240): -u*v, (72, 368): v*w, (72,
        503): v, (72, 509): -u**2*v/w, (72, 511): u*v, (72, 557):
        v**2/w, (72, 562): u*v, (72, 563): -u**2*v**2/w**2, (72, 565):
        u*v**2/w, (72, 568): u**2*v, (72, 591): -u*v*w, (72, 595):
        u**2*w, (72, 622): -u**2*(u*w - v**2)/w, (72, 645): -u*v**2,
        (73, 73): u, (73, 219): 1, (73, 235): u*v/w, (73, 353):
        -u**2*v**2/w, (73, 371): -u**2*v, (73, 380): -u*v**3/w**2,
        (73, 398): -u*v**2/w, (73, 434): -u*v**2/w, (73, 452): -u*v,
        (74, 74): u, (74, 236): u*v/w, (74, 381): 1, (74, 398):
        u**2*v/w, (74, 399): -u*v**2/w**2, (74, 453): -u*v/w, (74,
        507): u/w, (74, 561): u*v/w**2, (74, 570): -v, (74, 624):
        -v**2/w, (75, 75): u, (75, 237): u*v/w, (75, 372): u*v, (75,
        398): u*v, (75, 507): u*v/w, (75, 543): 1, (75, 561):
        u*v**2/w**2, (76, 76): u, (76, 238): u*v/w, (76, 373): u*v,
        (76, 392): 1, (76, 400): u**2*v/w, (77, 77): u, (77, 239):
        u*v/w, (77, 374): u*v, (77, 380): u*v, (77, 395): v, (77,
        403): u*v, (77, 509): u*v/w, (77, 547): 1, (77, 559): u, (77,
        562): -u*v**2/w, (77, 563): u*v**2/w**2, (78, 78): u, (78,
        240): u*v/w, (78, 375): u*v, (78, 404): u*v, (78, 510): u*v/w,
        (78, 548): 1, (78, 555): v/w, (78, 564): u*v**2/w**2, (79,
        79): u, (79, 241): u*v/w, (79, 376): u*v, (79, 385): 1, (79,
        395): u*v/w, (79, 403): u**2*v/w, (79, 509): u/w, (79, 562):
        -u*v/w, (79, 563): u*v/w**2, (79, 568): -u**2*v/w, (79, 595):
        -u**2, (79, 622): u**2*(u*w - v**2)/w**2, (80, 80): u, (80,
        82): -u**2/w, (80, 190): -u**2*v/w**2, (80, 242): u*v/w, (80,
        325): -u**2*v**2/w**3, (80, 377): u*v, (80, 386): 1, (80,
        395): u/w, (80, 404): u**2*v/w, (80, 460): -u**2*v/w**2, (80,
        510): u/w, (80, 564): u*v/w**2, (80, 568): -2*u**3*v/w**2,
        (80, 586): -u, (80, 595): -u**3/w, (80, 622): u**3*(u*w -
        2*v**2)/w**3, (80, 640): -u*v/w, (81, 6): 1, (81, 8): -v, (81,
        100): -v, (81, 127): u*v/w, (81, 157): v**2, (81, 184):
        u*v**2*(u*v - 2*w)/w**2, (81, 211): -u*v**2/w, (81, 238):
        u*v/w, (82, 509): -u/w, (82, 510): 1, (82, 535): -v, (82,
        562): u*v/w, (83, 582): -u, (83, 583): w, (83, 596): -u**2,
        (83, 611): -u, (83, 619): -u**2, (83, 620): u**2*v, (83, 623):
        u**3/w, (83, 638): u**2/w, (83, 646): u**3/w, (83, 647):
        -u**2, (84, 88): 1, (84, 89): -v, (84, 100): u, (84, 115):
        -u/w, (84, 127): -u**2/w, (84, 373): u**3*v*(u*v - w)/w**2,
        (84, 616): u**2*v**2*(u*v - w)/w**2, (84, 643): -u**2*v*(u*v -
        w)/w**2, (85, 100): w, (85, 116): -v, (85, 127): -u, (85,
        373): u**2*v*(u*v - w)/w, (85, 616): u*v**2*(u*v - w)/w, (85,
        643): -u*v*(u*v - w)/w, (86, 19): w, (86, 127): v, (86, 346):
        -u*v*(u*v - w)/w, (86, 353): v**2*(u*v - w)/w, (86, 373):
        -u*v**2*(u*v - w)/w, (87, 127): 1, (87, 373): u*v, (87, 376):
        u*v**2/w, (87, 377): -u*v**3/w, (87, 400): -u**2*v/w, (87,
        403): -u*v/w, (87, 404): u*v**2/w, (87, 434): -v**2/w, (88,
        89): w, (88, 116): -u, (88, 319): -u*v*(u*v - w)/w, (88, 353):
        u*v**2*(u*v - w)/w**2, (88, 616): u**2*v*(u*v - w)/w, (89,
        84): 1, (89, 89): u, (89, 127): u/w, (89, 319): -u**2*v*(u*v -
        w)/w**2, (89, 353): u*v*(u*v - w)/w**2, (89, 373):
        -u**2*v*(u*v - w)/w**2, (90, 21): w, (90, 22): v*w, (90, 129):
        v, (90, 130): v**2, (90, 372): -v**2, (90, 373): -v**3, (90,
        399): v, (90, 400): v**2, (90, 534): v, (90, 535): v**2, (90,
        561): -u*v/w, (90, 562): -u*v**2/w, (91, 2): v, (91, 20): w,
        (91, 22): u*v, (91, 110): v**2/w, (91, 128): v, (91, 130):
        u*v**2/w, (91, 353): -v**3/w, (91, 380): v**2/w, (91, 481):
        -u*v, (91, 487): -u/w, (91, 515): v**2/w, (91, 533): v, (91,
        535): u*v**2/w, (91, 536): -u*v**2/w**2, (91, 538): v**2/w,
        (91, 542): -u*v**2/w**2, (91, 560): -u*v/w, (91, 562):
        -u**2*v**2/w**2, (91, 563): u**2*v**2/w**3, (91, 565):
        -u*v**2/w**2, (91, 568): -u**2*v/w, (91, 622): -u*v*(u*v -
        w)/w**2, (92, 129): 1, (92, 132): u, (92, 509): u**2*v/w**2,
        (92, 535): u*v**2/w, (92, 562): -u**2*v**2/w**2, (92, 588): v,
        (92, 591): u*v, (92, 595): -u**2, (92, 622): u**3/w, (93, 22):
        u, (93, 110): v/w, (93, 128): 1, (93, 130): u*v/w, (93, 373):
        -u*v**2/w, (93, 400): u*v/w, (93, 460): -u/w, (93, 535):
        u*v/w, (93, 562): -u**2*v/w**2, (93, 568): -u**2/w, (93, 569):
        v**2/w, (93, 587): v, (94, 29): u*v, (94, 56): -u, (94, 96):
        w, (94, 123): -u, (94, 164): u*v**2/w, (94, 218): -u*v/w, (94,
        319): u*(u*v - w), (94, 346): -u**2*(u*v - w)/w, (94, 373):
        -u**3*v**2/w, (94, 376): -u**2*v**2/w, (94, 377): u*v**2, (94,
        400): u**2, (94, 403): u**2*v/w, (94, 404): -u*v, (94, 434):
        u*v**2/w, (94, 474): v, (94, 476): -u, (94, 501): -u*v/w, (94,
        503): u**2/w, (94, 562): u**3*(u*v - w)/w**2, (94, 616):
        -u**2*(u*v - w), (95, 97): w, (95, 124): -u, (95, 164): u*v/w,
        (95, 218): -u**2*v/w**2, (95, 319): u**2*(u*v - w)/w, (95,
        322): u*(u*v - w)/w, (95, 323): -u*v*(u*v - w)/w, (95, 353):
        -u**2*v*(u*v - w)/w**2, (95, 373): -u**3*v/w, (95, 376):
        -u**2*v/w, (95, 377): u*v, (95, 400): u**3/w, (95, 403):
        u**2/w, (95, 404): -u, (95, 422): -u, (95, 434): u*v/w, (95,
        449): u**2/w, (95, 474): u*v/w, (95, 501): -u**2*v/w**2, (95,
        611): -u**2*v/w, (95, 616): -u**3*(u*v - w)/w, (95, 619):
        -u**2*(u*v - w)/w, (95, 620): u**2*v*(u*v - w)/w, (95, 638):
        u**2/w, (96, 96): u, (96, 129): u/w, (96, 132): u**2/w, (96,
        319): u**2*(u*v - w)/w, (96, 353): -u*(u*v - w)/w, (96, 376):
        u**2*v/w, (96, 403): -u**2/w, (96, 434): -u*v/w, (96, 453):
        u**2/w, (96, 456): u**3/w, (96, 462): 1, (96, 467): u, (96,
        474): u*v/w, (96, 570): u, (96, 575): u**2, (96, 582):
        u**2*v/w, (96, 588): u*v/w, (96, 591): u**2*v/w, (97, 97): u,
        (97, 128): u/w, (97, 164): u/w, (97, 218): -u**2/w**2, (97,
        319): u**3*(u*v - w)/w**2, (97, 322): u**2*(u*v - w)/w**2,
        (97, 353): -u**2*(u*v - w)/w**2, (97, 407): -u**3/w, (97,
        408): 1, (97, 422): -u**2/w, (97, 452): u**2/w, (97, 474):
        u/w, (97, 501): -u**2/w**2, (97, 582): u**2/w, (97, 588): u/w,
        (97, 616): -u**4/w, (97, 643): u**5/w**2, (98, 164):
        -u**2*v/w, (98, 218): u**2/w, (98, 323): u*(u*v - w), (98,
        371): u*v, (98, 373): u**2*v**2/w, (98, 398): -u, (98, 400):
        -u**2*v/w, (98, 474): -u, (98, 475): w, (98, 501): u**2/w,
        (98, 502): -u, (98, 508): -u**3/w, (98, 596): -u*v*(u*v -
        w)/w, (98, 620): -u**2*(u*v - w), (99, 25): w, (99, 133): v,
        (99, 376): -v**2, (99, 403): v, (99, 536): u*v/w, (99, 563):
        -u**2*v/w**2, (99, 568): u**2, (99, 622): u*(u*v - w)/w, (100,
        116): 1, (100, 377): u*v*(u*v - w)/w, (100, 616): -u*v*(u*v -
        w)/w, (101, 124): 1, (101, 407): -u, (101, 449): -u/w, (101,
        582): u*v/w, (101, 611): u*v/w, (101, 616): -u**2, (101, 619):
        u*(u*v - w)/w, (101, 620): -u*v*(u*v - w)/w, (101, 623):
        -u**2*(u*v - w)/w**2, (101, 638): -u**2*v/w**2, (101, 643):
        u**3/w, (101, 646): -u**2*(u*v - w)/w**2, (102, 123): 1, (102,
        461): -u, (102, 503): -u/w, (102, 562): -u**2*(u*v - w)/w**2,
        (102, 582): v, (102, 616): -u*w, (102, 643): u**2, (103, 353):
        u*v/w, (103, 380): -u/w, (103, 501): 1/w, (104, 454): u*v,
        (104, 488): u*v/w, (104, 500): 1, (104, 503): v/w, (104, 506):
        u, (104, 508): u**2*v/w, (104, 511): u*v/w, (105, 503): 1/w,
        (105, 511): u/w, (106, 164): u*v/w, (106, 218): -u/w, (106,
        501): -u/w, (106, 502): 1, (106, 508): u**2/w, (106, 596):
        u*v**2/w, (106, 620): -u*w, (106, 623): -u*v/w, (106, 647):
        u**2, (107, 448): 1, (107, 614): -u, (107, 620): -u**2, (107,
        623): u*(u*v - w)/w**2, (107, 641): u**2/w, (107, 647):
        u**3/w, (108, 5): 1, (108, 7): -v, (108, 127): v*(u*v - w)/w,
        (108, 184): v**2*(u*v - w)**2/w**2, (109, 109): u, (109, 353):
        v*w, (109, 380): -u*v, (109, 487): u*v/w, (109, 509): -u*v/w,
        (109, 510): v, (109, 532): w, (109, 535): -v**2, (109, 559):
        -u, (109, 562): u*v**2/w, (109, 568): u*v, (110, 110): u,
        (110, 373): -u*(u*v - w), (110, 454): -u*v, (110, 569): u*v,
        (110, 580): -u, (110, 581): w, (110, 587): u*w, (110, 588):
        -u**2, (110, 617): -u**2, (110, 618): u**2*v, (110, 644):
        u**3/w, (110, 645): -u**2, (111, 19): -v, (111, 86): 1, (111,
        87): -v, (111, 115): -u*v/w, (111, 127): -u**2*v/w, (111,
        265): -v**3, (111, 319): v**2, (111, 346): u*v**2*(u*v -
        w)/w**2, (111, 373): u*v**2*(u**3*v - u**2*w + v*w)/w**2,
        (111, 400): -u*v**2/w, (111, 589): u*v**3/w, (111, 616):
        u**2*v**3*(u*v - w)/w**2, (112, 113): 1, (112, 114): -v, (112,
        115): -v, (112, 127): -u*v, (112, 292): -v**3, (112, 346):
        u*v**3/w, (112, 373): u**2*v**2*(u*v - w)/w, (112, 535):
        u*v**3/w, (112, 562): -u*v**2/w, (112, 616): v**2*(u*v -
        w)**2/w, (113, 114): w, (113, 292): v**2*w, (113, 346):
        -u*v**2, (113, 377): u*v**2*(u*v - w), (113, 458): v**2*(u*v -
        w), (113, 535): -u*v**2, (113, 562): u*v, (114, 112): 1, (114,
        114): u, (114, 127): v, (114, 373): -u*v**2*(u*v - w)/w, (114,
        434): -v**3/w, (114, 452): -v**2, (114, 454): -u*v**3/w, (114,
        606): u*v**2, (114, 633): -u*v, (115, 87): w, (115, 127): -v,
        (115, 265): v**2*w, (115, 319): -u*v**2, (115, 373):
        u*v**2*(u*v - 2*w)/w, (115, 377): u**2*v**2*(u*v - w)/w, (115,
        400): u*v, (115, 458): u*v**2*(u*v - w)/w, (115, 589):
        -u*v**2, (116, 85): 1, (116, 87): u, (116, 116): u, (116,
        265): u*v**2, (116, 319): -u**2*v**2/w, (116, 373):
        -u**2*v**2/w, (116, 377): u**2*v*(u*v - w)/w, (116, 400):
        u**2*v/w, (116, 458): u*v*(u*v - w)/w, (116, 589):
        -u**2*v**2/w, (116, 616): -u**2*v*(u*v - w)/w, (117, 119): w,
        (117, 497): v, (117, 504): -u, (117, 578): v*w, (118, 120): w,
        (118, 377): -v**2*(u*v - w), (118, 450): -u, (118, 454):
        u*v**2, (118, 457): v**2, (118, 458): -v**3, (118, 487):
        -u*v/w, (118, 497): u*v/w, (118, 508): -u*v, (118, 515):
        v**3/w, (118, 533): v**2, (118, 534): -u*v**2/w, (118, 536):
        -u*v**3/w**2, (118, 538): v**3/w, (118, 542): -u*v**3/w**2,
        (118, 560): -u*v**2/w, (118, 561): u**2*v**2/w**2, (118, 563):
        u**2*v**3/w**3, (118, 565): -u*v**3/w**2, (118, 568):
        -u**2*v**2/w, (118, 622): -u*v**2*(u*v - w)/w**2, (119, 119):
        u, (119, 129): v, (119, 132): u*v, (119, 353): -u*v**2, (119,
        380): u**2*v**2/w, (119, 452): v*w, (119, 458): u*v*w, (119,
        490): 1, (119, 492): u, (119, 497): u*v/w, (119, 509):
        u**2*v**2/w**2, (119, 532): -u*v, (119, 535): u*v**3/w, (119,
        559): u**2*v/w, (119, 562): -u**2*v**3/w**2, (119, 578): u*v,
        (119, 588): v**2, (119, 591): u*v**2, (119, 595): -u**2*v,
        (119, 622): u**3*v/w, (120, 110): v**2/w, (120, 120): u, (120,
        128): v, (120, 434): u*v**2/w, (120, 436): 1, (120, 450):
        -u**2/w, (120, 451): v, (120, 452): u*v, (120, 460): -u*v/w,
        (120, 497): u/w, (120, 568): -2*u**2*v/w, (120, 569): v**3/w,
        (120, 579): u*v, (120, 587): v**2, (120, 622): -u*v*(u*v -
        w)/w**2, (121, 92): w, (121, 129): -v, (121, 130): -v**2,
        (121, 265): -v*w**2, (121, 292): u*v*w, (121, 319): u*v*w,
        (121, 346): -u**2*v, (121, 373): -u*v*(u*v - w), (121, 376):
        -u*v**2, (121, 377): v**2*w, (121, 403): u*v, (121, 404):
        -v*w, (121, 434): v**2, (121, 470): v, (121, 477): -u, (121,
        535): -u**2*v, (121, 562): u**3*v/w, (121, 578): u*v, (121,
        588): -v**2, (121, 589): v*(u*w - v**2), (122, 93): w, (122,
        128): -v, (122, 130): -u*v**2/w, (122, 265): -u*v*w, (122,
        268): -v*w, (122, 269): v**2*w, (122, 292): u*w, (122, 319):
        u**2*v, (122, 322): u*v, (122, 323): -u*v**2, (122, 346):
        -u**2, (122, 373): -u**2*v*(u*v - w)/w, (122, 376): -u*v*(u*v
        - w)/w, (122, 423): -u, (122, 434): u*v**2/w, (122, 470):
        u*v/w, (122, 535): -u**2, (122, 562): u**3/w, (122, 578):
        u**2*v/w, (122, 588): -u*v**2/w, (122, 589): u*v*(u*w -
        v**2)/w, (122, 591): -u*v*(u*v - w)/w, (122, 592): u*v, (122,
        593): -v*w, (123, 92): u, (123, 123): u, (123, 265): -u*v*w,
        (123, 319): u**2*v, (123, 373): -u**2*v*(u*v - w)/w, (123,
        377): -u*(u**2*v - u*w - v**2), (123, 404): -u*v, (123, 454):
        -u**2*v**2/w, (123, 456): u**2, (123, 458): -u*(u*v - w),
        (123, 463): 1, (123, 465): u, (123, 470): u*v/w, (123, 575):
        u*w, (123, 578): u**2*v/w, (123, 582): u*v, (123, 586): -u*v,
        (123, 589): u**2*v, (123, 595): -u**3*v/w, (123, 606): u**2*v,
        (123, 616): u**2*(u*v - w), (123, 622): u**4*v/w**2, (123,
        633): -u**2, (124, 93): u, (124, 124): u, (124, 130): -u*v/w,
        (124, 265): -u**2*v, (124, 268): -u*v, (124, 269): u*v**2,
        (124, 319): u**3*v/w, (124, 322): u**2*v/w, (124, 323): -u*v,
        (124, 407): -u**2, (124, 409): 1, (124, 423): -u**2/w, (124,
        449): -u**2/w, (124, 454): -u**2*v/w, (124, 470): u/w, (124,
        578): u**2/w, (124, 582): u, (124, 589): u*v*(u**2 - v)/w,
        (124, 592): u**2*v/w, (124, 593): -u*v, (124, 606): u**2,
        (124, 611): u**2*v/w, (124, 616): u**3*(u*v - 2*w)/w, (124,
        619): u**2*(u*v - w)/w, (124, 620): -u*(u*v - w), (124, 633):
        -u**3/w, (124, 638): -u**2/w, (124, 643): u**4/w, (125, 133):
        -v, (125, 269): -v*w**2, (125, 323): u*v*w, (125, 373):
        u*v**2, (125, 377): -u*v*(u*v - w), (125, 400): -u*v, (125,
        454): u*w, (125, 458): -u*v**2, (125, 470): -u, (125, 471): w,
        (125, 508): -u**2, (125, 578): -u**2, (125, 587): -v*w, (125,
        588): u*v, (125, 591): u**2*v, (125, 592): -v**2, (126, 497):
        -u, (126, 498): w, (126, 515): -v**2, (126, 533): -v*w, (126,
        534): u*v, (126, 536): u*v**2/w, (126, 538): -v**2, (126,
        542): u*v**2/w, (126, 560): u*v, (126, 561): -u**2*v/w, (126,
        563): -u**2*v**2/w**2, (126, 565): u*v**2/w, (126, 568):
        u**2*v, (126, 622): u*v*(u*v - w)/w, (127, 115): 1, (127,
        127): u, (127, 376): u*v*(u*v - w)/w, (127, 616): -u*v**2*(u*v
        - w)/w, (128, 122): 1, (128, 128): u, (128, 373): u*v*(u*v -
        w)/w, (128, 449): -u*v/w, (128, 535): u, (128, 562): -u**2/w,
        (128, 580): u*v/w, (128, 588): u**2*v/w, (128, 617): u*(u*v -
        w)/w, (128, 618): -u*v*(u*v - w)/w, (128, 644): -u**2*(u*v -
        w)/w**2, (129, 121): 1, (129, 129): u, (129, 449): -v, (129,
        535): u*v, (129, 562): -u**2*v/w, (129, 580): v, (129, 588):
        u*v, (130, 130): u, (130, 449): 1, (130, 589): u*v, (131,
        131): u, (131, 499): 1, (131, 507): u, (131, 508): u*v, (131,
        509): u*v/w, (131, 590): u*v, (132, 132): u, (132, 445): 1,
        (132, 509): u/w, (132, 591): u*v, (132, 595): -u**2, (132,
        622): u**3/w, (133, 125): 1, (133, 133): u, (133, 508): u,
        (133, 584): v, (133, 592): u*v, (133, 618): -u*w, (133, 645):
        u**2, (134, 134): u, (134, 271): -u**2/w, (134, 325):
        u**3/w**2, (134, 447): 1, (134, 569): -u, (134, 593): u*v,
        (134, 595): -u**3/w, (134, 615): -u, (134, 618): -u**2, (134,
        622): u**4/w**2, (134, 642): u**2/w, (134, 645): u**3/w, (135,
        33): 1, (135, 35): -v, (135, 130): -u*v*(u*v - w)/w**2, (135,
        154): -v, (135, 181): u*v/w, (135, 184): -u**2*v*(u*v -
        w)/w**2, (135, 211): v**2/w, (135, 238): -u*v**2/w**2, (136,
        536): -u/w, (136, 537): 1, (136, 562): -v/w, (137, 593):
        -u**2, (137, 609): -u, (137, 610): w, (137, 620): -u**3, (137,
        623): -u**2/w, (137, 638): -u/w, (137, 646): -u**2/w, (138,
        142): 1, (138, 143): -v, (138, 154): u, (138, 169): -u/w,
        (138, 181): -u**2/w, (138, 373): -u**5*v/w**2, (138, 400):
        -u**3*v/w**2, (138, 454): -u**4*v/w**2, (138, 589):
        -u**2*v*(u*v - w)/w**2, (138, 616): -u**3*v*(u*v - w)/w**2,
        (139, 154): w, (139, 170): -v, (139, 181): -u, (139, 373):
        -u**4*v/w, (139, 400): -u**2*v/w, (139, 454): -u**3*v/w, (139,
        589): -u*v*(u*v - w)/w, (139, 616): -u**2*v*(u*v - w)/w, (140,
        46): w, (140, 181): v, (140, 292): u**2*v, (140, 346):
        u*v**2/w, (140, 353): -u**2*v**2/w, (140, 373): u**3*v**2/w,
        (140, 380): -v**2/w, (140, 400): u*v**2/w, (140, 434):
        -u*v**2/w, (140, 454): u**2*v**2/w, (140, 481): u*v, (141,
        181): 1, (141, 353): -v**2/w, (141, 376): -u**2*v/w, (141,
        377): u**2*v**2/w, (141, 400): u*v/w, (141, 457): -u*v/w,
        (141, 458): u*v**2/w, (142, 143): w, (142, 170): -u, (142,
        265): u**2*v, (142, 319): u*v**2/w, (142, 353):
        -u**3*v**2/w**2, (142, 380): -u*v**2/w**2, (142, 427): u*v,
        (142, 434): -u**2*v**2/w**2, (142, 589): -u**3*v/w, (142,
        616): -u**4*v/w, (142, 643): -u**2*v/w, (143, 138): 1, (143,
        143): u, (143, 181): u/w, (143, 265): u**3*v/w, (143, 319):
        u**2*v**2/w**2, (143, 353): -u**3*v/w**2, (143, 373):
        u**4*v/w**2, (143, 380): -u*v/w**2, (143, 400): u**2*v/w**2,
        (143, 427): u**2*v/w, (143, 434): -u**2*v/w**2, (143, 454):
        u**3*v/w**2, (144, 48): w, (144, 49): v*w, (144, 183): v,
        (144, 184): v**2, (144, 372): u*v, (144, 373): u*v**2, (144,
        453): v, (144, 454): v**2, (144, 561): v/w, (144, 562):
        v**2/w, (145, 29): v, (145, 47): w, (145, 49): u*v, (145,
        164): v**2/w, (145, 182): v, (145, 184): u*v**2/w, (145, 292):
        -u*v, (145, 353): u*v**2/w, (145, 434): v**2/w, (145, 514):
        -u/w, (145, 542): v**2/w**2, (145, 560): v/w, (145, 562):
        u*v**2/w**2, (145, 563): -u*v**2/w**3, (145, 565): v**2/w**2,
        (145, 568): u*v/w, (145, 622): u*v**2/w**2, (146, 183): 1,
        (146, 186): u, (146, 536): u**2*v/w**2, (146, 562):
        u*v**2/w**2, (146, 615): v, (146, 618): u*v, (146, 622):
        -u**2/w, (147, 49): u, (147, 164): v/w, (147, 182): 1, (147,
        184): u*v/w, (147, 271): -u/w, (147, 373): u**2*v/w, (147,
        454): u*v/w, (147, 562): u*v/w**2, (147, 595): -u**2/w, (147,
        596): v**2/w, (147, 614): v, (148, 2): -u, (148, 29): -u**2,
        (148, 110): -u*v/w, (148, 150): w, (148, 164): -u**2*v/w,
        (148, 177): -u, (148, 265): -u**2*w, (148, 285): v, (148,
        287): -u, (148, 292): u**3, (148, 319): -u*v, (148, 346):
        u**2*v/w, (148, 353): u*v**2/w, (148, 373): u**3*(u*v + w)/w,
        (148, 376): u**3*v/w, (148, 377): -u**2*v, (148, 400):
        u**2*v/w, (148, 427): -u*w, (148, 454): u**2*(u*v + w)/w,
        (148, 457): u**2*v/w, (148, 458): -u*v, (148, 481): u**2,
        (148, 508): -u**3/w, (148, 528): -u*v/w, (148, 530): u**2/w,
        (148, 535): -u**4/w, (148, 562): -u**3*v/w**2, (148, 589):
        u**3, (148, 616): u**4, (148, 643): u**2, (149, 151): w, (149,
        178): -u, (149, 218): u*v/w**2, (149, 260): -u, (149, 265):
        -u**3, (149, 268): -u**2, (149, 269): u**2*v, (149, 285):
        u*v/w, (149, 319): -u**2*v/w, (149, 322): -u*v/w, (149, 323):
        u*v**2/w, (149, 353): u*v*(u**3 + w)/w**2, (149, 368): u**2/w,
        (149, 373): u**4/w, (149, 376): u**3/w, (149, 377): -u**2,
        (149, 380): u**2*v/w**2, (149, 427): -u**2, (149, 430): -u,
        (149, 431): u*v, (149, 434): u**3*v/w**2, (149, 454): u**3/w,
        (149, 457): u**2/w, (149, 458): -u, (149, 528): -u**2*v/w**2,
        (149, 584): u**2/w, (149, 589): u**4/w, (149, 592): u**3/w,
        (149, 593): -u**3*v/w, (149, 611): u**3/w, (149, 616): u**5/w,
        (149, 619): u**4/w, (149, 620): -u**4*v/w, (149, 643): u**3/w,
        (149, 646): u**2/w, (149, 647): -u**2*v/w, (150, 150): u,
        (150, 183): u/w, (150, 186): u**2/w, (150, 265): -u**3, (150,
        273): 1, (150, 278): u, (150, 285): u*v/w, (150, 319):
        -u**2*v/w, (150, 353): u*(u**2 - v)/w, (150, 372): u**2/w,
        (150, 375): u**3/w, (150, 376): -u**3/w, (150, 380): u/w,
        (150, 427): -u**2, (150, 434): u**2/w, (150, 457): -u**2/w,
        (150, 597): u, (150, 602): u**2, (150, 609): u**2*v/w, (150,
        615): u*v/w, (150, 618): u**2*v/w, (151, 151): u, (151, 182):
        u/w, (151, 218): u/w**2, (151, 245): -u**3/w, (151, 246): 1,
        (151, 260): -u**2/w, (151, 265): -u**4/w, (151, 268): -u**3/w,
        (151, 285): u/w, (151, 319): -u**3*v/w**2, (151, 322):
        -u**2*v/w**2, (151, 353): u**4/w**2, (151, 371): u**2/w, (151,
        380): u**2/w**2, (151, 427): -u**3/w, (151, 430): -u**2/w,
        (151, 434): u**3/w**2, (151, 528): -u**2/w**2, (151, 609):
        u**2/w, (151, 615): u/w, (151, 643): -u**4/w**2, (152, 110):
        u**2/w, (152, 164): u**3/w, (152, 269): -u**2*w, (152, 285):
        -u, (152, 286): w, (152, 323): -u*v, (152, 371): -u**2, (152,
        373): -u**3*v/w, (152, 431): -u*w, (152, 452): -u, (152, 454):
        -u**2*v/w, (152, 528): u**2/w, (152, 529): -u, (152, 535):
        -u**3/w, (152, 569): u**2*v/w, (152, 593): u**3, (152, 596):
        u**3*v/w, (152, 620): u**4, (152, 623): u*v/w, (152, 647):
        u**2, (153, 52): w, (153, 187): v, (153, 376): u*v, (153,
        457): v, (153, 563): u*v/w**2, (153, 568): -u, (153, 622):
        -u*v/w, (154, 170): 1, (154, 377): -u**3*v/w, (154, 404):
        -u*v/w, (154, 458): -u**2*v/w, (154, 589): u**2*v/w, (154,
        616): u**3*v/w, (154, 643): u*v/w, (155, 178): 1, (155, 245):
        -u, (155, 368): -u/w, (155, 569): u**2/w, (155, 593):
        u**2*v/w, (155, 596): u**3/w, (155, 609): u*v/w, (155, 620):
        u**3*v/w, (155, 623): u**2*v/w**2, (155, 638): u*v/w**2, (155,
        643): -u**2/w, (155, 646): u*(u*v - w)/w**2, (155, 647):
        u*v/w, (156, 177): 1, (156, 272): -u, (156, 508): u**2/w,
        (156, 530): -u/w, (156, 535): u**3/w, (156, 562): u**2*v/w**2,
        (156, 609): v, (156, 643): -u, (157, 353): -u**2/w, (157,
        434): -u/w, (157, 528): 1/w, (158, 373): u*v, (158, 515):
        u*v/w, (158, 527): 1, (158, 530): v/w, (158, 533): u, (158,
        535): u**2*v/w, (158, 538): u*v/w, (159, 530): 1/w, (159,
        538): u/w, (160, 110): -u/w, (160, 164): -u**2/w, (160, 528):
        -u/w, (160, 529): 1, (160, 535): u**2/w, (160, 569): -u*v/w,
        (160, 596): -u**2*v/w, (160, 647): -u, (161, 367): 1, (161,
        569): -u/w, (161, 596): -u**2/w, (161, 623): -u*v/w**2, (161,
        641): -u/w, (161, 647): -u**2/w, (162, 32): 1, (162, 34): -v,
        (162, 130): -u*v**2*(u*v - w)/w**2, (162, 181): v*(u*v - w)/w,
        (162, 184): -u**2*v**2*(u*v - w)/w**2, (162, 238): -v**2*(u*v
        - w)/w**2, (163, 163): u, (163, 380): v, (163, 514): u*v/w,
        (163, 536): -u*v/w, (163, 537): v, (163, 559): 1, (163, 562):
        -v**2/w, (163, 595): u*v, (164, 164): u, (164, 373): u*(u**2 -
        v), (164, 400): u, (164, 454): u**2, (164, 591): -u**2, (164,
        596): u*v, (164, 607): -u, (164, 608): w, (164, 614): u*w,
        (164, 615): -u**2, (164, 618): -u**3, (164, 644): -u**2/w,
        (165, 46): -v, (165, 140): 1, (165, 141): -v, (165, 169):
        -u*v/w, (165, 181): -u**2*v/w, (165, 265): u*v**2, (165, 292):
        -u**2*v**2/w, (165, 346): -u*v**3/w**2, (165, 373):
        -u**2*v**2*(u**3 + w)/w**2, (165, 400): -u**3*v**2/w**2, (165,
        427): v**2, (165, 454): -u*v**2*(u**3 + w)/w**2, (165, 481):
        -u*v**2/w, (165, 589): -u**3*v**3/w**2, (165, 616):
        -u*v**3*(u**3 - w)/w**2, (165, 643): -u**2*v**3/w**2, (166,
        167): 1, (166, 168): -v, (166, 169): -v, (166, 181): -u*v,
        (166, 346): -v**3/w, (166, 373): -u**4*v**2/w, (166, 400):
        -u**2*v**2/w, (166, 454): -u**3*v**2/w, (166, 508): -u*v**2/w,
        (166, 535): -u**2*v**2/w, (166, 589): -u*v**2*(u*v - w)/w,
        (166, 616): -u**2*v**2*(u*v - w)/w, (166, 643): -v**2*(u*v -
        w)/w, (167, 168): w, (167, 346): v**2, (167, 377): -v**2*(u**3
        - u*v + w), (167, 404): -u*v**2, (167, 458): -u**2*v**2, (167,
        508): u*v, (167, 535): u**2*v, (168, 166): 1, (168, 168): u,
        (168, 181): v, (168, 353): -v**3/w, (168, 371): -v**2, (168,
        373): u*v**2*(u**2 - v)/w, (168, 400): u*v**2/w, (168, 454):
        u**2*v**2/w, (168, 579): -u*v, (168, 606): -u**2*v, (169,
        141): w, (169, 181): -v, (169, 319): v**2, (169, 373):
        -u**2*v*(u*v - w)/w, (169, 377): -u*v**2*(u**3 - u*v + w)/w,
        (169, 400): -u*v**2/w, (169, 404): -u**2*v**2/w, (169, 454):
        -u*v*(u*v - w)/w, (169, 458): -u**3*v**2/w, (169, 616):
        -u*v**2, (170, 139): 1, (170, 141): u, (170, 170): u, (170,
        319): u*v**2/w, (170, 373): u**3*v/w, (170, 377): -u*v*(u**3 -
        u*v + w)/w, (170, 404): -u**2*v/w, (170, 454): u**2*v/w, (170,
        458): -u**3*v/w, (170, 589): u**3*v/w, (170, 616):
        u**2*v*(u**2 - v)/w, (170, 643): u**2*v/w, (171, 173): w,
        (171, 524): v, (171, 531): -u, (171, 605): v*w, (172, 174): w,
        (172, 369): -u, (172, 373): u*v**2, (172, 376): v**2, (172,
        377): v**2*(u**2 - v), (172, 404): v**2, (172, 458): u*v**2,
        (172, 514): -u*v/w, (172, 524): u*v/w, (172, 535): -u*v, (172,
        542): v**3/w**2, (172, 560): v**2/w, (172, 561): -u*v**2/w**2,
        (172, 563): -u*v**3/w**3, (172, 565): v**3/w**2, (172, 568):
        u*v**2/w, (172, 622): u*v**3/w**2, (173, 173): u, (173, 183):
        v, (173, 186): u*v, (173, 371): v*w, (173, 377): u*v*w, (173,
        380): -u*v**2/w, (173, 517): 1, (173, 519): u, (173, 524):
        u*v/w, (173, 536): u**2*v**2/w**2, (173, 559): -u*v/w, (173,
        562): u*v**3/w**2, (173, 605): u*v, (173, 615): v**2, (173,
        618): u*v**2, (173, 622): -u**2*v/w, (174, 164): v**2/w, (174,
        174): u, (174, 182): v, (174, 271): -u*v/w, (174, 353):
        u*v**2/w, (174, 355): 1, (174, 369): -u**2/w, (174, 370): v,
        (174, 371): u*v, (174, 524): u/w, (174, 568): u*v/w, (174,
        595): -u**2*v/w, (174, 596): v**3/w, (174, 606): u*v, (174,
        614): v**2, (174, 622): u*v**2/w**2, (175, 146): w, (175,
        183): -v, (175, 184): -v**2, (175, 281): v, (175, 288): -u,
        (175, 319): -v*w, (175, 346): u*v, (175, 353): v**2, (175,
        373): u**3*v, (175, 376): u**2*v, (175, 377): -u*v*w, (175,
        400): u*v, (175, 454): u**2*v, (175, 457): u*v, (175, 458):
        -v*w, (175, 562): -u**2*v/w, (175, 605): u*v, (175, 615):
        -v**2, (175, 616): v*(u*w - v**2), (176, 147): w, (176, 182):
        -v, (176, 184): -u*v**2/w, (176, 261): -u, (176, 281): u*v/w,
        (176, 319): -u*v, (176, 322): -v, (176, 323): v**2, (176,
        346): u, (176, 353): u*v**2/w, (176, 373): u**4*v/w, (176,
        376): u**3*v/w, (176, 400): u**2*v/w, (176, 403): u*v/w, (176,
        454): u**3*v/w, (176, 457): u**2*v/w, (176, 562): -u**2/w,
        (176, 605): u**2*v/w, (176, 615): -u*v**2/w, (176, 616):
        u*v*(u*w - v**2)/w, (176, 618): -u*v*(u*v - w)/w, (176, 619):
        u*v, (176, 620): -v*w, (177, 146): u, (177, 177): u, (177,
        274): 1, (177, 276): u, (177, 281): u*v/w, (177, 319): -u*v,
        (177, 373): u**2*v*(u**2 - v)/w, (177, 375): u**2, (177, 377):
        u*(u**3 - 2*u*v + w), (177, 400): u**2*v/w, (177, 404): u**2,
        (177, 454): u**3*v/w, (177, 458): u*(u**2 - v), (177, 579):
        -u**2, (177, 589): -u**3, (177, 602): u*w, (177, 605):
        u**2*v/w, (177, 606): -u**3, (177, 609): u*v, (177, 613):
        -u*v, (177, 616): -u**2*(u**2 - v), (177, 622): -u**3*v/w**2,
        (177, 643): -u**2, (178, 147): u, (178, 178): u, (178, 184):
        -u*v/w, (178, 245): -u**2, (178, 247): 1, (178, 261): -u**2/w,
        (178, 269): -u**2*v, (178, 281): u/w, (178, 319): -u**2*v/w,
        (178, 322): -u*v/w, (178, 368): -u**2/w, (178, 373):
        -u**2*v/w, (178, 431): -u*v, (178, 584): -u**2/w, (178, 589):
        -u**4/w, (178, 592): -u**3/w, (178, 593): u**2, (178, 605):
        u**2/w, (178, 609): u, (178, 611): -u**3/w, (178, 616):
        -u*(u**4 - u**2*v + v**2)/w, (178, 619): -u**2*(u**2 - v)/w,
        (178, 620): u*(u**2 - v), (178, 633): u**2/w, (178, 643):
        -2*u**3/w, (178, 646): -u**2/w, (178, 647): u, (179, 187): -v,
        (179, 281): -u, (179, 282): w, (179, 323): -v*w, (179, 373):
        -u*(u*v - w), (179, 377): u*v*(u**2 - v), (179, 404): u*v,
        (179, 454): -u*v, (179, 458): u**2*v, (179, 535): -u**2, (179,
        605): -u**2, (179, 614): -v*w, (179, 615): u*v, (179, 618):
        u**2*v, (179, 619): -v**2, (180, 524): -u, (180, 525): w,
        (180, 542): -v**2/w, (180, 560): -v, (180, 561): u*v/w, (180,
        563): u*v**2/w**2, (180, 565): -v**2/w, (180, 568): -u*v,
        (180, 622): -u*v**2/w, (181, 169): 1, (181, 181): u, (181,
        376): -u**3*v/w, (181, 403): -u*v/w, (181, 457): -u**2*v/w,
        (181, 589): u**2*v**2/w, (181, 616): u**3*v**2/w, (181, 643):
        u*v**2/w, (182, 176): 1, (182, 182): u, (182, 368): -u*v/w,
        (182, 373): -u**3*v/w, (182, 400): -u*v/w, (182, 454):
        -u**2*v/w, (182, 562): u/w, (182, 591): u**2*v/w, (182, 607):
        u*v/w, (182, 615): u**2*v/w, (182, 618): u**3*v/w, (182, 644):
        u*(u*v - w)/w**2, (182, 645): u*v/w, (183, 175): 1, (183,
        183): u, (183, 368): -v, (183, 562): u*v/w, (183, 607): v,
        (183, 615): u*v, (184, 184): u, (184, 368): 1, (184, 616):
        u*v, (185, 185): u, (185, 526): 1, (185, 534): u, (185, 535):
        u*v, (185, 536): u*v/w, (185, 617): u*v, (186, 186): u, (186,
        364): 1, (186, 536): u/w, (186, 618): u*v, (186, 622):
        -u**2/w, (187, 179): 1, (187, 187): u, (187, 535): u, (187,
        611): v, (187, 619): u*v, (187, 645): -u, (188, 188): u, (188,
        325): -u**2/w**2, (188, 366): 1, (188, 596): -u, (188, 620):
        u*v, (188, 622): -u**3/w**2, (188, 642): -u/w, (188, 645):
        -u**2/w, (189, 60): 1, (189, 62): -v, (189, 103): v**2, (189,
        130): -u*v**2/w, (189, 184): -u*v*(u*v - w)/w, (189, 208): -v,
        (189, 211): v**3/w, (189, 235): u*v/w, (189, 238):
        -u*v**3/w**2, (190, 508): -v, (190, 562): -v**2/w, (190, 563):
        -u/w, (190, 564): 1, (191, 569): -u**2, (191, 584): -u, (191,
        592): -u**2, (191, 620): -u**2*w, (191, 623): -u**2*v/w, (191,
        636): -u, (191, 637): w, (191, 638): -u*v/w, (191, 646):
        -u**2*v/w, (192, 196): 1, (192, 197): -v, (192, 208): u, (192,
        223): -u/w, (192, 235): -u**2/w, (192, 373): -u**4*v/w, (192,
        400): -u**3*v**2/w**2, (192, 454): -u**3*v/w, (192, 616):
        -u**2*v*(u*v - w)/w, (193, 208): w, (193, 224): -v, (193,
        235): -u, (193, 373): -u**3*v, (193, 400): -u**2*v**2/w, (193,
        454): -u**2*v, (193, 616): -u*v*(u*v - w), (194, 73): w, (194,
        235): v, (194, 292): u*v*w, (194, 346): u*v**3/w, (194, 353):
        -u*v**2, (194, 373): u**2*v**2, (194, 380): -v**3/w, (194,
        400): u*v**3/w, (194, 434): -v**2, (194, 454): u*v**2, (194,
        481): u*v**2, (195, 235): 1, (195, 376): -u*v, (195, 377):
        u*v**2, (195, 380): -v**2/w, (195, 400): u*v**2/w, (195, 454):
        u*v, (196, 197): w, (196, 224): -u, (196, 265): u*v*w, (196,
        319): u*v**3/w, (196, 353): -u**2*v**2/w, (196, 380):
        -u*v**3/w**2, (196, 427): u*v**2, (196, 434): -u*v**2/w, (196,
        589): -u**2*v, (196, 616): -u**3*v, (196, 643): -u**2*v**2/w,
        (197, 192): 1, (197, 197): u, (197, 235): u/w, (197, 265):
        u**2*v, (197, 319): u**2*v**3/w**2, (197, 353): -u**2*v/w,
        (197, 373): u**3*v/w, (197, 380): -u*v**2/w**2, (197, 400):
        u**2*v**2/w**2, (197, 427): u**2*v**2/w, (197, 434): -u*v/w,
        (197, 454): u**2*v/w, (198, 75): w, (198, 76): v*w, (198,
        237): v, (198, 238): v**2, (198, 372): v*w, (198, 373):
        v**2*w, (198, 507): v, (198, 508): v**2, (198, 561): v**2/w,
        (198, 562): v**3/w, (199, 56): v, (199, 74): w, (199, 76):
        u*v, (199, 218): v**2/w, (199, 236): v, (199, 238): u*v**2/w,
        (199, 346): -u*v, (199, 353): v**2, (199, 488): v**2/w, (199,
        506): v, (199, 508): u*v**2/w, (199, 509): -u*v**2/w**2, (199,
        511): v**2/w, (199, 541): -u/w, (199, 542): v**3/w**2, (199,
        560): v**2/w, (199, 562): u*v**3/w**2, (199, 563):
        -u*v**3/w**3, (199, 565): v**3/w**2, (199, 568): u*v**2/w,
        (199, 595): u*v, (199, 622): -u*v*(u*w - v**2)/w**2, (200,
        237): 1, (200, 240): u, (200, 508): u*v**2/w, (200, 562):
        u*v**3/w**2, (200, 563): u**2*v/w**2, (200, 568): -u**2, (200,
        622): -u**2*v/w, (200, 642): v, (200, 645): u*v, (201, 76): u,
        (201, 218): v/w, (201, 236): 1, (201, 238): u*v/w, (201, 325):
        -u/w, (201, 373): u*v, (201, 508): u*v/w, (201, 562):
        u*v**2/w**2, (201, 622): -u**2/w, (201, 623): v**2/w, (201,
        641): v, (202, 29): -u*w, (202, 164): -u*v, (202, 204): w,
        (202, 231): -u, (202, 265): -u*w**2, (202, 292): u**2*w, (202,
        319): -u*v**2, (202, 339): v, (202, 341): -u, (202, 346):
        u**2*v**2/w, (202, 373): u**2*(u*v + w), (202, 376): u**2*v,
        (202, 377): -u*v*w, (202, 380): u*v**2/w, (202, 400):
        u**2*v**2/w, (202, 427): -u*v*w, (202, 454): u**2*v, (202,
        481): u**2*v, (202, 508): -u**3*v/w, (202, 535): -u**3, (202,
        555): -u*v/w, (202, 557): u**2/w, (202, 562): -u**3*v**2/w**2,
        (202, 589): u**2*w, (202, 616): u**3*w, (202, 643): u**2*v,
        (203, 110): u*v/w, (203, 205): w, (203, 218): u*v**2/w**2,
        (203, 232): -u, (203, 265): -u**2*w, (203, 268): -u*w, (203,
        269): u*v*w, (203, 314): -u, (203, 319): -u**2*v**2/w, (203,
        322): -u*v**2/w, (203, 323): u*v**3/w, (203, 339): u*v/w,
        (203, 353): u**3*v/w, (203, 373): u**3, (203, 376): u**2,
        (203, 377): -u*w, (203, 380): u*v*(u*v + w)/w**2, (203, 395):
        u**2/w, (203, 427): -u**2*v, (203, 430): -u*v, (203, 431):
        u*v**2, (203, 434): u**2*v/w, (203, 555): -u**2*v/w**2, (203,
        589): u**3, (203, 592): u**2, (203, 593): -u**2*v, (203, 611):
        u**2, (203, 616): u**4, (203, 619): u**3, (203, 620): -u**3*v,
        (203, 643): u**3*v/w, (203, 646): u**2*v/w, (203, 647):
        -u**2*v**2/w, (204, 204): u, (204, 237): u/w, (204, 240):
        u**2/w, (204, 265): -u**2*w, (204, 319): -u**2*v**2/w, (204,
        327): 1, (204, 332): u, (204, 339): u*v/w, (204, 353): u**2,
        (204, 376): -u**2, (204, 399): u**2/w, (204, 402): u**3/w,
        (204, 427): -u**2*v, (204, 434): u, (204, 624): u, (204, 629):
        u**2, (204, 636): u**2*v/w, (204, 642): u*v/w, (204, 645):
        u**2*v/w, (205, 110): u/w, (205, 205): u, (205, 218):
        u*v/w**2, (205, 236): u/w, (205, 265): -u**3, (205, 268):
        -u**2, (205, 299): -u**3/w, (205, 300): 1, (205, 314):
        -u**2/w, (205, 319): -u**3*v**2/w**2, (205, 322):
        -u**2*v**2/w**2, (205, 339): u/w, (205, 353): u**3/w, (205,
        380): u**2*v/w**2, (205, 398): u**2/w, (205, 427): -u**3*v/w,
        (205, 430): -u**2*v/w, (205, 434): u**2/w, (205, 555):
        -u**2/w**2, (205, 589): -u**4/w, (205, 636): u**2/w, (205,
        642): u/w, (205, 643): -u**4*v/w**2, (206, 164): u**2, (206,
        269): -u*w**2, (206, 323): -u*v**2, (206, 339): -u, (206,
        340): w, (206, 371): -u*w, (206, 373): -u**2*v, (206, 431):
        -u*v*w, (206, 555): u**2/w, (206, 556): -u, (206, 562):
        -u**3/w, (206, 569): u*v, (206, 593): u**2*w, (206, 596):
        u**2*v, (206, 620): u**3*w, (206, 623): u*v**2/w, (206, 647):
        u**2*v, (207, 79): w, (207, 241): v, (207, 376): v*w, (207,
        509): u*v/w, (207, 563): u*v**2/w**2, (207, 568): -u*v, (207,
        595): -u*w, (207, 622): u*(u*w - v**2)/w, (208, 224): 1, (208,
        377): -u**2*v, (208, 404): -u*v**2/w, (208, 458): -u*v, (208,
        589): u*v, (208, 616): u**2*v, (208, 643): u*v**2/w, (209,
        232): 1, (209, 299): -u, (209, 395): -u/w, (209, 569):
        u**2*v/w, (209, 584): u*v/w, (209, 589): -u**2, (209, 592):
        u*(u*v - w)/w, (209, 593): u*v, (209, 596): u**2, (209, 620):
        u**2*v, (209, 623): u**2*v**2/w**2, (209, 636): u*v/w, (209,
        638): u*v**2/w**2, (209, 643): -u**2*v/w, (209, 646): u*v*(u*v
        - w)/w**2, (209, 647): u*v**2/w, (210, 231): 1, (210, 326):
        -u, (210, 508): u**2*v/w, (210, 535): u**2, (210, 557): -u/w,
        (210, 562): u**2*v**2/w**2, (210, 589): -u*w, (210, 636): v,
        (210, 643): -u*v, (211, 353): -u, (211, 555): 1/w, (212, 400):
        u*v, (212, 542): u*v/w, (212, 554): 1, (212, 557): v/w, (212,
        560): u, (212, 562): u**2*v/w, (212, 565): u*v/w, (213, 557):
        1/w, (213, 565): u/w, (214, 164): -u, (214, 555): -u/w, (214,
        556): 1, (214, 562): u**2/w, (214, 593): -u*w, (214, 596):
        -u*v, (214, 647): -u*v, (215, 394): 1, (215, 569): -u*v/w,
        (215, 587): -u, (215, 593): -u**2, (215, 596): -u, (215, 623):
        -u*v**2/w**2, (215, 641): -u*v/w, (215, 647): -u**2*v/w, (216,
        59): 1, (216, 61): -v, (216, 130): -v**2*(u*v - w)/w, (216,
        184): -u*v**2*(u*v - w)/w, (216, 235): v*(u*v - w)/w, (216,
        238): -v**3*(u*v - w)/w**2, (217, 217): u, (217, 380): v**2,
        (217, 434): v*w, (217, 505): w, (217, 508): -v**2, (217, 541):
        u*v/w, (217, 559): v, (217, 562): -v**3/w, (217, 563): -u*v/w,
        (217, 564): v, (217, 622): u*v, (218, 218): u, (218, 373):
        u**2*w, (218, 454): u*w, (218, 590): -u**2, (218, 618):
        -u**2*w, (218, 623): u*v, (218, 634): -u, (218, 635): w, (218,
        641): u*w, (218, 642): -u**2, (218, 644): -u**2*v/w, (219,
        73): -v, (219, 194): 1, (219, 195): -v, (219, 223): -u*v/w,
        (219, 235): -u**2*v/w, (219, 265): v**2*w, (219, 292):
        -u*v**2, (219, 346): -u*v**4/w**2, (219, 373): -u*v**2*(u**3 +
        w)/w, (219, 400): -u**3*v**3/w**2, (219, 454): -u**3*v**2/w,
        (219, 481): -u*v**3/w, (219, 589): -u**2*v**3/w, (219, 616):
        -u**3*v**3/w, (219, 643): -u*v**3*(u*v - w)/w**2, (220, 221):
        1, (220, 222): -v, (220, 223): -v, (220, 235): -u*v, (220,
        346): -v**4/w, (220, 373): -u**3*v**2, (220, 400):
        -u**2*v**3/w, (220, 454): -u**2*v**2, (220, 481): -v**3, (220,
        535): -u*v**2, (220, 589): -v**2*(u*v - w), (220, 616):
        -u*v**2*(u*v - w), (220, 643): -v**3*(u*v - w)/w, (221, 222):
        w, (221, 346): v**3, (221, 377): -u**2*v**2*w, (221, 404):
        -v**2*w, (221, 458): -u*v**2*w, (221, 481): v**2*w, (221,
        535): u*v*w, (222, 220): 1, (222, 222): u, (222, 235): v,
        (222, 373): u**2*v**2, (222, 380): -v**3/w, (222, 398): -v**2,
        (222, 454): u*v**2, (222, 606): -u*v*w, (223, 195): w, (223,
        235): -v, (223, 319): v**3, (223, 373): -u*v*(u*v - w), (223,
        377): -u**3*v**2, (223, 400): -u*v**3/w, (223, 404): -u*v**2,
        (223, 427): v**2*w, (223, 454): -u*v**2, (223, 458):
        -u**2*v**2, (223, 643): -u*v**2, (224, 193): 1, (224, 195): u,
        (224, 224): u, (224, 319): u*v**3/w, (224, 373): u**2*v, (224,
        377): -u**3*v, (224, 404): -u*v, (224, 427): u*v**2, (224,
        458): -u**2*v, (224, 589): u**2*v, (224, 616): u**3*v, (225,
        227): w, (225, 551): v, (225, 558): -u, (225, 632): v*w, (226,
        228): w, (226, 377): u*v**2*w, (226, 396): -u, (226, 400):
        u*v**2, (226, 403): v**2, (226, 458): v**2*w, (226, 488):
        v**3/w, (226, 506): v**2, (226, 507): -u*v**2/w, (226, 509):
        -u*v**3/w**2, (226, 511): v**3/w, (226, 541): -u*v/w, (226,
        542): v**4/w**2, (226, 551): u*v/w, (226, 560): v**3/w, (226,
        561): -u*v**3/w**2, (226, 562): -u*v, (226, 563):
        -u*v**4/w**3, (226, 565): v**4/w**2, (226, 568): u*v**3/w,
        (226, 595): u*v**2, (226, 622): -u*v**2*(u*w - v**2)/w**2,
        (227, 227): u, (227, 237): v, (227, 240): u*v, (227, 380):
        -u*v**3/w, (227, 398): v*w, (227, 404): u*v*w, (227, 434):
        -u*v**2, (227, 505): -u*v, (227, 508): u*v**3/w, (227, 544):
        1, (227, 546): u, (227, 551): u*v/w, (227, 559): -u*v**2/w,
        (227, 562): u*v**4/w**2, (227, 563): u**2*v**2/w**2, (227,
        568): -u**2*v, (227, 622): -u**2*v**2/w, (227, 632): u*v,
        (227, 642): v**2, (227, 645): u*v**2, (228, 218): v**2/w,
        (228, 228): u, (228, 236): v, (228, 325): -u*v/w, (228, 380):
        u*v**2/w, (228, 382): 1, (228, 396): -u**2/w, (228, 397): v,
        (228, 398): u*v, (228, 551): u/w, (228, 568): u*v**2/w, (228,
        595): u*v, (228, 622): -u*v*(2*u*w - v**2)/w**2, (228, 623):
        v**3/w, (228, 633): u*v, (228, 641): v**2, (229, 200): w,
        (229, 237): -v, (229, 238): -v**2, (229, 319): -v**2*w, (229,
        335): v, (229, 342): -u, (229, 346): u*v**2, (229, 373):
        u**2*v*w, (229, 376): u*v*w, (229, 377): -v*w**2, (229, 380):
        v**2, (229, 400): u*v**2, (229, 427): -v*w**2, (229, 454):
        u*v*w, (229, 481): u*v*w, (229, 508): -u**2*v, (229, 562):
        -u**2*v**2/w, (229, 632): u*v, (229, 642): -v**2, (229, 643):
        v*(u*w - v**2), (230, 201): w, (230, 236): -v, (230, 238):
        -u*v**2/w, (230, 315): -u, (230, 319): -u*v**2, (230, 322):
        -v**2, (230, 323): v**3, (230, 335): u*v/w, (230, 346): u*v,
        (230, 373): u**3*v, (230, 376): u**2*v, (230, 380): u*v**2/w,
        (230, 400): u**2*v**2/w, (230, 403): u*v**2/w, (230, 427):
        -u*v*w, (230, 430): -v*w, (230, 431): v**2*w, (230, 454):
        u**2*v, (230, 457): u*v, (230, 481): u*w, (230, 508): -u**2,
        (230, 562): -u**2*v/w, (230, 632): u**2*v/w, (230, 642):
        -u*v**2/w, (230, 643): u*v*(u*w - v**2)/w, (230, 645):
        -u*v*(u*v - w)/w, (230, 646): u*v, (230, 647): -v*w, (231,
        200): u, (231, 231): u, (231, 319): -u*v**2, (231, 328): 1,
        (231, 330): u, (231, 335): u*v/w, (231, 373): u**3*v, (231,
        377): u*w*(u**2 - v), (231, 402): u**2, (231, 404): u*w, (231,
        427): -u*v*w, (231, 454): u**2*v, (231, 458): u**2*w, (231,
        568): -u**3*v/w, (231, 589): -u**2*w, (231, 606): -u**2*w,
        (231, 616): -u**3*w, (231, 622): -u**3*v**2/w**2, (231, 629):
        u*w, (231, 632): u**2*v/w, (231, 636): u*v, (231, 640): -u*v,
        (232, 201): u, (232, 232): u, (232, 238): -u*v/w, (232, 269):
        -u*v*w, (232, 299): -u**2, (232, 301): 1, (232, 315): -u**2/w,
        (232, 319): -u**2*v**2/w, (232, 322): -u*v**2/w, (232, 335):
        u/w, (232, 395): -u**2/w, (232, 400): -u**2*v/w, (232, 427):
        -u**2*v, (232, 430): -u*v, (232, 579): u**2, (232, 589):
        -2*u**3, (232, 592): -u**2, (232, 593): u*w, (232, 611):
        -u**2, (232, 616): -u**4, (232, 619): -u**3, (232, 620):
        u**2*w, (232, 632): u**2/w, (232, 633): u**2*v/w, (232, 636):
        u, (232, 643): -u*v*(u**2 + v)/w, (233, 241): -v, (233, 323):
        -v**2*w, (233, 335): -u, (233, 336): w, (233, 373): -u*v*w,
        (233, 377): u**2*v*w, (233, 400): u*w, (233, 431): -v*w**2,
        (233, 458): u*v*w, (233, 562): -u**2, (233, 632): -u**2, (233,
        641): -v*w, (233, 642): u*v, (233, 645): u**2*v, (233, 646):
        -v**2, (234, 488): -v**2, (234, 506): -v*w, (234, 507): u*v,
        (234, 509): u*v**2/w, (234, 511): -v**2, (234, 542): -v**3/w,
        (234, 551): -u, (234, 552): w, (234, 560): -v**2, (234, 561):
        u*v**2/w, (234, 563): u*v**3/w**2, (234, 565): -v**3/w, (234,
        568): -u*v**2, (234, 595): -u*v*w, (234, 622): u*v*(u*w -
        v**2)/w, (235, 223): 1, (235, 235): u, (235, 376): -u**2*v,
        (235, 403): -u*v**2/w, (235, 457): -u*v, (235, 589): u*v**2,
        (235, 616): u**2*v**2, (235, 643): u*v**3/w, (236, 230): 1,
        (236, 236): u, (236, 373): -u**2*v, (236, 395): -u*v/w, (236,
        400): -u*v**2/w, (236, 454): -u*v, (236, 508): u, (236, 562):
        u*v/w, (236, 590): u*(u*v - w)/w, (236, 591): u*v, (236, 618):
        u**2*v, (236, 634): u*v/w, (236, 642): u**2*v/w, (236, 644):
        u*v*(u*v - w)/w**2, (236, 645): u*v**2/w, (237, 229): 1, (237,
        237): u, (237, 395): -v, (237, 508): u*v, (237, 562):
        u*v**2/w, (237, 634): v, (237, 642): u*v, (238, 238): u, (238,
        395): 1, (238, 643): u*v, (239, 239): u, (239, 553): 1, (239,
        561): u, (239, 562): u*v, (239, 563): u*v/w, (239, 644): u*v,
        (240, 240): u, (240, 391): 1, (240, 563): u/w, (240, 568):
        -u**2, (240, 622): -u**2*v/w, (240, 645): u*v, (241, 233): 1,
        (241, 241): u, (241, 562): u, (241, 591): -u*w, (241, 638): v,
        (241, 645): -u*v, (241, 646): u*v, (242, 242): u, (242, 325):
        -u**2*v/w**2, (242, 393): 1, (242, 460): -u**2/w, (242, 568):
        -u**3/w, (242, 588): -u, (242, 591): -u**2, (242, 622):
        -u**3*v/w**2, (242, 623): -u, (242, 642): -u*v/w, (242, 645):
        -u**2*v/w, (242, 647): u*v, (243, 39): 1, (243, 43): -v, (243,
        107): -v, (243, 134): u*v/w, (243, 155): -v, (243, 161): -u*v,
        (243, 182): u*v/w, (243, 184): u*v*(u*v - w)/w**2, (243, 188):
        u**2*v/w, (243, 211): -u*v/w, (243, 214): -v/w, (243, 238):
        u**2*v/w**2, (243, 241): u*v/w**2, (243, 353): -u*v*(u*v -
        w)/w**2, (244, 562): u/w, (244, 565): 1/w, (245, 593): u,
        (245, 609): 1, (245, 620): u**2, (246, 149): 1, (246, 151):
        -v, (246, 155): u, (246, 176): -u/w, (246, 182): -u**2/w,
        (246, 319): -u*v/w, (246, 346): u**2*v/w**2, (246, 353):
        u**3*v/w**2, (246, 368): u**2*v/w**2, (246, 373):
        2*u**4*v/w**2, (246, 376): u**3*v/w**2, (246, 377): u**2*v/w,
        (246, 400): u**2*v/w**2, (246, 454): u**3*v/w**2, (246, 458):
        u*v/w, (246, 616): u**3*v**2/w**2, (247, 155): w, (247, 178):
        -v, (247, 182): -u, (247, 353): u**2*v/w, (247, 368): u*v/w,
        (247, 373): 2*u**3*v/w, (247, 376): u**2*v/w, (247, 377):
        u**2*v**2/w, (247, 454): u**2*v/w, (247, 458): u*v**2/w, (247,
        562): u**2*v/w**2, (247, 616): u*v*(u*v - w)/w, (248, 49):
        -u*v, (248, 160): w, (248, 184): -u*v**2/w, (248, 187): -u,
        (248, 292): -u*v, (248, 373): -2*u**2*v**2/w, (248, 376):
        -u*v**2/w, (248, 377): u**2*v, (248, 454): -2*u*v**2/w, (248,
        457): -v**2/w, (248, 508): -u*v/w, (248, 528): u*v/w, (248,
        529): -v, (248, 535): -u**2*v/w, (248, 562): -u*v**2/w**2,
        (249, 49): -u, (249, 161): w, (249, 184): -u*v/w, (249, 188):
        -u, (249, 367): -v, (249, 373): -2*u**2*v/w, (249, 377):
        -u*v**2/w, (249, 454): -u*v/w, (249, 458): -v**2/w, (249,
        562): -u*v/w**2, (250, 152): 1, (250, 160): u, (250, 179):
        -u/w, (250, 187): -u**2/w, (250, 265): -u*v, (250, 286): -v,
        (250, 353): u**2*v**2/w**2, (250, 371): u**2*v/w, (250, 373):
        u**3*v**2/w**2, (250, 377): 2*u**3*v/w, (250, 434):
        u*v**2/w**2, (250, 452): u*v/w, (250, 454): u*v*(u*v -
        w)/w**2, (250, 458): u**2*v/w, (250, 528): u**2*v/w**2, (250,
        589): u**2*v/w, (250, 616): u**3*v/w, (251, 161): u, (251,
        188): -u**2/w, (251, 258): 1, (251, 259): -v, (251, 265):
        -u**2*v/w, (251, 285): -u/w, (251, 366): -u/w, (251, 373):
        -u**2/w, (251, 454): -u/w, (251, 528): u**2/w**2, (251, 582):
        -u/w, (251, 609): -u**2/w, (252, 51): w, (252, 186): v, (252,
        375): u*v, (252, 456): v, (252, 564): v/w, (253, 157): w,
        (253, 184): -u, (253, 292): v, (253, 377): -u*v, (253, 508):
        v/w, (253, 528): -v/w, (253, 562): v**2/w**2, (254, 53): w,
        (254, 188): v, (254, 377): u*v, (254, 458): v, (254, 562):
        -u**2*v/w**2, (254, 565): -u*v/w**2, (255, 188): 1, (255,
        620): v, (256, 265): u*w, (256, 287): 1, (256, 292): -u**2,
        (256, 353): -u**2*v/w, (256, 373): -u**2*(u*v + w)/w, (256,
        376): -u**2*v/w, (256, 434): -u*v/w, (256, 454): -u**2*v/w,
        (256, 457): -u*v/w, (256, 530): -u/w, (256, 535): u**3/w,
        (256, 589): -u**2, (256, 616): -u**3, (257, 157): u, (257,
        184): -u**2/w, (257, 260): 1, (257, 265): u**2, (257, 268): u,
        (257, 269): -u*v, (257, 285): -v/w, (257, 353): -u**3*v/w**2,
        (257, 368): -u/w, (257, 373): -u**3/w, (257, 376): -u**2/w,
        (257, 434): -u**2*v/w**2, (257, 584): -u/w, (257, 589):
        -u**3/w, (257, 592): -u**2/w, (257, 593): u**2*v/w, (257,
        611): -u**2/w, (257, 616): -u**4/w, (257, 619): -u**3/w, (257,
        620): u**3*v/w, (258, 259): w, (258, 265): u**2, (258, 367):
        -u, (258, 373): -u**3/w, (259, 188): u/w, (259, 245): u**2/w,
        (259, 251): 1, (259, 259): u, (259, 260): u/w, (259, 265):
        u**3/w, (259, 268): u**2/w, (259, 323): u**2/w, (259, 353):
        -u**3/w**2, (259, 377): u**2/w, (259, 407): u/w, (259, 434):
        -u**2/w**2, (259, 618): u/w, (260, 110): -u/w, (260, 164):
        -u**2/w, (260, 269): u*w, (260, 285): 1, (260, 377): -u**2,
        (260, 528): -u/w, (260, 569): -u*v/w, (260, 593): -u**2, (260,
        596): -u**2*v/w, (260, 620): -u**3, (261, 49): w, (261, 184):
        v, (261, 373): u*v, (261, 454): v, (262, 137): 1, (262, 164):
        -u/w, (262, 535): -u/w, (262, 610): -v, (262, 616): -u**2*v/w,
        (263, 245): 1, (263, 353): -u/w, (263, 569): -u/w, (263, 593):
        -u*v/w, (263, 596): -u**2/w, (263, 609): -v/w, (263, 620):
        -u**2*v/w, (264, 272): 1, (264, 515): -u/w, (264, 535):
        -u**2/w, (264, 538): -u/w, (265, 353): u/w, (265, 434): 1/w,
        (266, 2): 1, (266, 29): u, (266, 110): v/w, (266, 164): u*v/w,
        (266, 353): v*(u**2 - v)/w, (266, 380): v/w, (266, 434):
        u*v/w, (266, 515): v/w, (267, 515): 1/w, (268, 110): 1/w,
        (268, 164): u/w, (268, 569): v/w, (268, 596): u*v/w, (269,
        569): 1/w, (269, 596): u/w, (270, 17): u*v/w, (270, 18): -u/w,
        (270, 38): 1, (270, 42): -v, (270, 44): u**2*v/w, (270, 45):
        -u**2/w, (270, 130): -u**2*v*(u*v - w)/w**2, (270, 133):
        -u*v*(u*v - w)/w**2, (270, 134): v*(u*v - w)/w, (270, 156):
        -v, (270, 183): u*v/w, (270, 184): -u*v*(u**2 - v)*(u*v -
        w)/w**2, (270, 187): -u**2*v*(u*v - w)/w**2, (270, 188):
        u*v*(u*v - w)/w, (270, 211): -v, (270, 238): -u*v*(u*v -
        2*w)/w**2, (270, 245): v**2, (270, 272): -u*v**2/w, (270,
        353): -u*v**2/w, (270, 515): u*v/w, (270, 569): u*v**2*(u*v -
        2*w)/w**2, (270, 596): u**2*v**2*(u*v - 2*w)/w**2, (271, 509):
        -u/w, (271, 536): -u**2/w, (271, 562): 1, (272, 272): u, (272,
        375): u, (272, 377): u*(u**2 - v), (272, 404): u, (272, 458):
        u**2, (272, 589): -u**2, (272, 593): u*v, (272, 602): w, (272,
        609): v, (272, 616): -u**3, (272, 620): u**2*v, (273, 2):
        u*v/w, (273, 29): u**2*v/w, (273, 148): 1, (273, 150): -v,
        (273, 156): u, (273, 175): -u/w, (273, 183): -u**2/w, (273,
        245): -u*v, (273, 260): -v, (273, 265): u**2*v, (273, 272):
        u**2*v/w, (273, 287): u*v/w, (273, 292): -u**3*v/w, (273,
        353): u**2*v/w, (273, 368): u*v/w, (273, 373): -u**3*v*(u**3 -
        2*u*v + w)/w**2, (273, 376): -u**3*v*(u**2 - v)/w**2, (273,
        377): u**2*v**2/w, (273, 400): -u**4*v/w**2, (273, 403):
        -u**3*v/w**2, (273, 427): u*v, (273, 454): -u**2*v*(u**3 - u*v
        + w)/w**2, (273, 457): -u**4*v/w**2, (273, 458): u*v**2/w,
        (273, 481): -u**2*v/w, (273, 569): -u**2*v*(u*v - w)/w**2,
        (273, 584): -u*v*(u*v - w)/w**2, (273, 589): -u**4*v**2/w**2,
        (273, 592): -u**2*v*(u*v - w)/w**2, (273, 596): -u**3*v*(u*v -
        w)/w**2, (273, 611): -u**2*v*(u*v - w)/w**2, (273, 616):
        -u**3*v**2*(u**2 - v)/w**2, (273, 619): -u**3*v*(u*v -
        w)/w**2, (273, 643): -u**3*v**2/w**2, (274, 156): w, (274,
        177): -v, (274, 183): -u, (274, 245): -v*w, (274, 272): u*v,
        (274, 353): u*v, (274, 373): -u**3*v*(u**2 - 2*v)/w, (274,
        376): -u**2*v*(u**2 - v)/w, (274, 377): u**2*v**3/w, (274,
        400): -u**3*v/w, (274, 403): -u**2*v/w, (274, 454):
        -u**2*v*(u**2 - v)/w, (274, 457): -u**3*v/w, (274, 458):
        u*v**3/w, (274, 508): -u**2*v/w, (274, 530): u*v/w, (274,
        535): -u**3*v/w, (274, 569): -u*v*(u*v - w)/w, (274, 584):
        -u*v**2/w, (274, 589): -u**2*v*(u*v - w)/w, (274, 592):
        -u*v*(u*v - w)/w, (274, 596): -u**2*v*(u*v - w)/w, (274, 611):
        -u**2*v**2/w, (274, 616): -u*v*(u**2 - v)*(u*v - w)/w, (274,
        619): -u**2*v*(u*v - w)/w, (274, 643): -u*v*(u*v - w)/w, (275,
        49): -v*w, (275, 110): -v, (275, 158): w, (275, 164): -u*v,
        (275, 184): -v**2, (275, 185): -u, (275, 292): -u*v**2, (275,
        293): v, (275, 295): -v**2, (275, 352): -u**2, (275, 373):
        -u*v**2*(u*v + 2*w)/w, (275, 376): -u*v**3/w, (275, 377):
        -u**2*v*(u**2 - v), (275, 404): -u**2*v, (275, 433): -u, (275,
        454): -v**2*(u*v + w)/w, (275, 457): -v**3/w, (275, 458):
        -u**3*v, (275, 487): u**2/w, (275, 514): u**3/w, (275, 527):
        -v, (275, 530): -v**2/w, (275, 536): -u*v/w, (275, 569):
        -v**2, (275, 593): u*v*w, (275, 595): u*v, (275, 596):
        -u*v**2, (275, 620): u**2*v*w, (276, 159): w, (276, 184): -v,
        (276, 186): -u, (276, 244): -u**2, (276, 271): u**3/w, (276,
        294): v, (276, 296): -v**2, (276, 373): u**2*v*(u**2 - v)/w,
        (276, 377): -u*v**3/w, (276, 400): u**2*v/w, (276, 406): -u,
        (276, 454): u**3*v/w, (276, 458): -v**3/w, (276, 460): u**2/w,
        (276, 530): -v/w, (276, 537): -u*v/w, (276, 568): u**3/w,
        (276, 569): v*(u*v - w)/w, (276, 587): u*v, (276, 593):
        u**2*v, (276, 595): u**4/w, (276, 596): u*v*(u*v - w)/w, (276,
        614): u**2*v, (276, 616): -v**2, (276, 620): u**3*v, (276,
        622): u**2/w, (277, 158): u, (277, 185): -u**2/w, (277, 265):
        -u*v**2, (277, 283): 1, (277, 284): -v, (277, 285): -v, (277,
        287): -v**2/w, (277, 293): u*v/w, (277, 295): -u*v**2/w, (277,
        352): -u**3/w, (277, 353): u**2*v**3/w**2, (277, 371):
        u**2*v**2/w, (277, 373): u**2*v**2*(u*v - w)/w**2, (277, 377):
        -u**3*v*(u**2 - 2*v)/w, (277, 404): -u**3*v/w, (277, 433):
        -u**2/w, (277, 434): u*v**3/w**2, (277, 452): u*v**2/w, (277,
        454): u*v**2*(u*v - w)/w**2, (277, 458): -u**2*v*(u**2 - v)/w,
        (277, 487): u**3/w**2, (277, 514): u**4/w**2, (277, 526):
        -u/w, (277, 528): u*v/w, (277, 536): -u**2*v/w**2, (277, 569):
        -u*v**2/w, (277, 589): u**2*v**2/w, (277, 593): u**2*v, (277,
        595): u**2*v/w, (277, 596): -u**2*v**2/w, (277, 616):
        u**3*v**2/w, (277, 620): u**3*v, (278, 159): u, (278, 184):
        -u*v/w, (278, 186): -u**2/w, (278, 244): -u**3/w, (278, 256):
        1, (278, 257): -v, (278, 265): -u**2*v**2/w, (278, 271):
        u**4/w**2, (278, 285): -u*v/w, (278, 287): -v/w, (278, 293):
        u/w, (278, 295): -u*v/w, (278, 364): -u/w, (278, 373):
        -2*u**2*v/w, (278, 406): -u**2/w, (278, 454): -u*v/w, (278,
        460): u**3/w**2, (278, 536): -u**2/w**2, (278, 568):
        u**4/w**2, (278, 569): -u*v/w, (278, 580): -u/w, (278, 593):
        u**3*v/w, (278, 595): u**5/w**2, (278, 596): -u**2*v/w, (278,
        607): -u**2/w, (278, 620): u**4*v/w, (278, 622): u**3/w**2,
        (279, 50): w, (279, 109): -u, (279, 163): -u**2, (279, 185):
        v, (279, 374): u*v, (279, 455): v, (279, 487): -u*v/w, (279,
        514): -u**2*v/w, (279, 563): v/w, (279, 568): -u*v, (279,
        595): -u**2*v, (280, 185): 1, (280, 186): -v, (280, 353):
        -u*v, (280, 377): u*v*(u**2 - v), (280, 404): u*v, (280, 434):
        -v, (280, 458): u**2*v, (280, 487): -u/w, (280, 514): -u**2/w,
        (280, 536): -v*(u*v - w)/w**2, (280, 617): v, (280, 618):
        -v**2, (280, 622): u*v/w, (281, 82): -u, (281, 136): -u**2,
        (281, 184): w, (281, 271): -u**2*v/w, (281, 460): -u*v/w,
        (281, 509): u**2*v/w**2, (281, 510): u*v/w, (281, 536):
        u**3*v/w**2, (281, 537): u**2*v/w, (281, 562): -u*v/w, (281,
        568): -u**2*v/w, (281, 595): -u**2*(u*v + w)/w, (281, 616):
        v*w, (282, 184): u, (282, 187): 1, (282, 271): -u**2/w, (282,
        460): -u/w, (282, 535): u*v/w, (282, 568): -u**2/w, (282,
        595): -u**3/w, (282, 616): u*v, (282, 619): v, (283, 265):
        u*v*w, (283, 284): w, (283, 287): v, (283, 292): -u**2*v,
        (283, 353): -u**2*v**2/w, (283, 371): -u**2*v, (283, 373):
        -u**2*v*(2*u*v + w)/w, (283, 376): -u**2*v**2/w, (283, 434):
        -u*v**2/w, (283, 452): -u*v, (283, 454): -2*u**2*v**2/w, (283,
        457): -u*v**2/w, (283, 527): -u, (283, 530): -u*v/w, (283,
        589): -u**2*v, (283, 616): -u**3*v, (284, 185): u/w, (284,
        186): -u*v/w, (284, 260): v, (284, 265): u**2*v, (284, 268):
        u*v, (284, 269): -u*v**2, (284, 277): 1, (284, 278): -v, (284,
        284): u, (284, 285): -v**2/w, (284, 292): -u*v**2/w, (284,
        353): -u**2*v*(u*v + w)/w**2, (284, 371): -u**3*v/w, (284,
        373): -u**4*v**2/w**2, (284, 377): u**2*v*(u**2 - v)/w, (284,
        404): u**2*v/w, (284, 434): -u*v*(u*v + w)/w**2, (284, 452):
        -u**2*v/w, (284, 454): -u**3*v**2/w**2, (284, 458): u**3*v/w,
        (284, 487): -u**2/w**2, (284, 514): -u**3/w**2, (284, 584):
        -u*v/w, (284, 589): -u**3*v/w, (284, 592): -u**2*v/w, (284,
        593): u**2*v**2/w, (284, 611): -u**2*v/w, (284, 616):
        -u**4*v/w, (284, 617): u*v/w, (284, 618): -u*v**2/w, (284,
        619): -u**3*v/w, (284, 620): u**3*v**2/w, (284, 622):
        u**2*v/w**2, (285, 184): u, (285, 257): w, (285, 265): u**2*v,
        (285, 285): u, (285, 373): u**2*(u**3 - u*v + w)/w, (285,
        400): u**3/w, (285, 454): u**4/w, (285, 569): u**2*v/w, (285,
        587): u**2, (285, 596): u**3*v/w, (285, 614): u**3, (286,
        184): u**2/w, (286, 187): u/w, (286, 250): 1, (286, 257): u,
        (286, 260): u*v/w, (286, 265): u**3*v/w, (286, 268): u**2*v/w,
        (286, 269): -u**3, (286, 271): -u**3/w**2, (286, 286): u,
        (286, 292): -u*v/w, (286, 353): -u**3*v/w**2, (286, 371):
        -u**3/w, (286, 373): -u**3*(u*v - w)/w**2, (286, 376): u**2/w,
        (286, 431): -u**2, (286, 434): -u**2*v/w**2, (286, 452):
        -u**2/w, (286, 454): -u**3*v/w**2, (286, 460): -u**2/w**2,
        (286, 568): -u**3/w**2, (286, 569): u**2/w, (286, 595):
        -u**4/w**2, (286, 596): u*(u**2 - v)/w, (286, 616): -u**2*v/w,
        (286, 617): u/w, (286, 623): u/w, (287, 110): -u*v/w, (287,
        164): -u**2*v/w, (287, 186): u, (287, 269): u*v*w, (287, 278):
        w, (287, 285): v, (287, 287): u, (287, 353): -u**3*v/w, (287,
        370): -u**2, (287, 376): -u**3*v/w, (287, 434): -u**2*v/w,
        (287, 451): -u, (287, 457): -u**2*v/w, (287, 569): -u*v**2/w,
        (287, 593): -u**2*v, (287, 596): -u**2*v**2/w, (287, 618):
        u*v, (287, 620): -u**3*v, (287, 622): -u**2/w, (288, 186): w,
        (288, 536): u*v/w, (288, 618): v*w, (288, 622): -u, (289,
        272): -v**2/w, (289, 290): -v, (289, 291): 1, (289, 352):
        u**2/w, (289, 433): u/w, (289, 487): -u**2/w**2, (289, 514):
        -u**3/w**2, (289, 534): -u/w, (289, 535): -u*v/w, (289, 569):
        u**2*v/w, (289, 584): u*v/w, (289, 589): u**3*v/w, (289, 592):
        u**2*v/w, (289, 593): -u*v, (289, 595): -u*v/w, (289, 596):
        u**3*v/w, (289, 609): -v, (289, 611): u**2*v/w, (289, 616):
        u**2*v*(u**2 - v)/w, (289, 619): u**3*v/w, (289, 620):
        -u**2*v, (289, 643): u**2*v/w, (290, 245): v, (290, 289): 1,
        (290, 290): u, (290, 375): -u*v/w, (290, 377): -u*v*(u**2 -
        v)/w, (290, 404): -u*v/w, (290, 458): -u**2*v/w, (290, 487):
        u/w**2, (290, 514): u**2/w**2, (290, 569): -u*v/w, (290, 589):
        u**2*v/w, (290, 593): -u*v**2/w, (290, 596): -u**2*v/w, (290,
        602): -v, (290, 609): -v**2/w, (290, 616): u**3*v/w, (290,
        620): -u**2*v**2/w, (290, 622): -u*v/w**2, (291, 272): v,
        (291, 290): w, (291, 515): -u*v/w, (291, 533): -u, (291, 535):
        -u**2*v/w, (291, 538): -u*v/w, (292, 292): u, (292, 353):
        u*v/w, (292, 371): u, (292, 373): u**2*v/w, (292, 434): v/w,
        (292, 452): 1, (292, 454): u*v/w, (293, 295): w, (293, 376):
        u*v, (293, 457): v, (294, 296): w, (294, 373): -u**2, (294,
        377): u*v, (294, 454): -u, (294, 458): v, (295, 110): v/w,
        (295, 164): u*v/w, (295, 295): u, (295, 353): u**2*v/w, (295,
        370): u, (295, 376): u**2*v/w, (295, 434): u*v/w, (295, 451):
        1, (295, 457): u*v/w, (295, 569): v**2/w, (295, 596):
        u*v**2/w, (295, 622): u/w, (296, 136): u/w, (296, 271):
        u*v/w**2, (296, 296): u, (296, 376): u**2/w, (296, 457): u/w,
        (296, 569): v/w, (296, 595): u**2*v/w**2, (296, 596): u*v/w,
        (296, 613): 1, (296, 622): u**2/w**2, (297, 66): 1, (297, 70):
        -v, (297, 103): -u*v, (297, 106): -v, (297, 130): u**2*v/w,
        (297, 133): u*v/w, (297, 161): -v*w, (297, 188): u*v, (297,
        209): -v, (297, 211): -u*v**2/w, (297, 214): -v**2/w, (297,
        236): u*v/w, (297, 238): u*v*(2*u*v - w)/w**2, (297, 241):
        u*v**2/w**2, (297, 380): -u*v*(u*v - w)/w**2, (298, 508): u,
        (298, 511): 1, (298, 562): u*v/w, (298, 565): v/w, (299, 620):
        u*w, (299, 636): 1, (300, 203): 1, (300, 205): -v, (300, 209):
        u, (300, 230): -u/w, (300, 236): -u**2/w, (300, 319):
        -u*v**2/w, (300, 346): u**2*v**2/w**2, (300, 373): u**3*v/w,
        (300, 377): u*v, (300, 380): u**3*v/w**2, (300, 395):
        u**2*v/w**2, (300, 400): u**2*v*(u**2 + v)/w**2, (300, 403):
        u**3*v/w**2, (300, 427): -u*v, (300, 454): u**2*v/w, (300,
        481): u**2*v/w, (300, 643): u**3*v**2/w**2, (301, 209): w,
        (301, 232): -v, (301, 236): -u, (301, 373): u**2*v, (301,
        377): u*v**2, (301, 380): u**2*v/w, (301, 395): u*v/w, (301,
        400): u**3*v/w, (301, 403): u**2*v/w, (301, 508): u**2*v/w,
        (301, 562): u**2*v**2/w**2, (301, 643): u*v*(u*v - w)/w, (302,
        76): -u*v, (302, 214): w, (302, 238): -u*v**2/w, (302, 241):
        -u, (302, 346): -u*v, (302, 373): -2*u*v**2, (302, 376):
        -v**2, (302, 404): u**2*v, (302, 508): -u*v**2/w, (302, 535):
        -u*v, (302, 555): u*v/w, (302, 556): -v, (302, 562):
        -u*v**3/w**2, (303, 76): -u, (303, 215): w, (303, 238):
        -u*v/w, (303, 242): -u, (303, 373): -u*v, (303, 377): -v**2,
        (303, 394): -v, (303, 400): -u**2*v/w, (303, 508): -u*v/w,
        (303, 562): -u*v**2/w**2, (304, 206): 1, (304, 214): u, (304,
        233): -u/w, (304, 241): -u**2/w, (304, 319): -u*v, (304, 340):
        -v, (304, 353): u*v**2/w, (304, 371): u*v, (304, 373):
        u*v*(u*v - w)/w, (304, 377): u**2*v, (304, 400): u**2*v/w,
        (304, 404): u**3*v/w, (304, 555): u**2*v/w**2, (304, 616):
        u**2*v, (305, 215): u, (305, 242): -u**2/w, (305, 312): 1,
        (305, 313): -v, (305, 319): -u**2*v/w, (305, 339): -u/w, (305,
        373): -u, (305, 393): -u/w, (305, 555): u**2/w**2, (305, 609):
        -u, (306, 78): w, (306, 240): v, (306, 375): v*w, (306, 510):
        v, (306, 564): v**2/w, (307, 211): w, (307, 238): -u, (307,
        346): v, (307, 404): -u*v, (307, 508): v**2/w, (307, 535): v,
        (307, 555): -v/w, (307, 562): -v*(u*w - v**2)/w**2, (308, 80):
        w, (308, 242): v, (308, 377): v*w, (308, 508): -u**2*v/w,
        (308, 511): -u*v/w, (308, 562): -u**2*v**2/w**2, (308, 565):
        -u*v**2/w**2, (309, 242): 1, (309, 647): v, (310, 319): u*w,
        (310, 341): 1, (310, 346): -u**2, (310, 353): -u*v, (310,
        373): -u**2*v, (310, 376): -u*v, (310, 400): -u**2, (310,
        557): -u/w, (310, 562): u**3/w, (310, 616): -u**2*w, (311,
        211): u, (311, 238): -u**2/w, (311, 314): 1, (311, 319): u**2,
        (311, 322): u, (311, 323): -u*v, (311, 339): -v/w, (311, 353):
        -u**2*v/w, (311, 395): -u/w, (311, 400): -u**3/w, (311, 403):
        -u**2/w, (311, 611): -u, (311, 616): -u**3, (311, 619): -u**2,
        (311, 620): u**2*v, (312, 313): w, (312, 319): u**2, (312,
        394): -u, (312, 400): -u**3/w, (313, 242): u/w, (313, 245): u,
        (313, 305): 1, (313, 313): u, (313, 314): u/w, (313, 319):
        u**3/w, (313, 322): u**2/w, (313, 323): u**2*v/w, (313, 353):
        -u**2/w, (313, 404): u**2/w, (313, 431): u**2, (313, 645):
        u/w, (314, 164): -u, (314, 323): u*w, (314, 339): 1, (314,
        404): -u**2, (314, 555): -u/w, (314, 596): -u*v, (314, 620):
        -u**2*w, (315, 76): w, (315, 238): v, (315, 373): v*w, (316,
        191): 1, (316, 218): -u/w, (316, 562): -u/w, (316, 637): -v,
        (316, 643): -u**2*v/w, (317, 299): 1, (317, 380): -u/w, (317,
        596): -u, (317, 620): -u*v, (317, 636): -v/w, (318, 326): 1,
        (318, 542): -u/w, (318, 562): -u**2/w, (318, 565): -u/w, (319,
        353): 1, (320, 29): w, (320, 164): v, (320, 353): u*v, (320,
        434): v, (320, 542): v/w, (321, 542): 1/w, (322, 164): 1,
        (322, 596): v, (323, 596): 1, (324, 44): u*v, (324, 45): -u,
        (324, 65): 1, (324, 69): -v, (324, 103): -v*w, (324, 130):
        -u*v*(u*v - 2*w)/w, (324, 184): -u**2*v*(u*v - w)/w, (324,
        187): -u*v*(u*v - w)/w, (324, 188): v*(u*v - w), (324, 210):
        -v, (324, 211): -v**2, (324, 237): u*v/w, (324, 238):
        u*v**2/w, (324, 299): v**2, (324, 326): -u*v**2/w, (324, 380):
        -u*v**2/w, (324, 542): u*v/w, (324, 596): u*v**2*(u*v -
        2*w)/w, (325, 508): w, (325, 536): -u, (325, 562): v, (326,
        326): u, (326, 377): u**2*w, (326, 402): u, (326, 458): u*w,
        (326, 616): -u**2*w, (326, 620): u*v*w, (326, 629): w, (326,
        636): v, (327, 29): u*v, (327, 202): 1, (327, 204): -v, (327,
        210): u, (327, 229): -u/w, (327, 237): -u**2/w, (327, 265):
        u*v*w, (327, 292): -u**2*v, (327, 299): -u*v, (327, 314): -v,
        (327, 326): u**2*v/w, (327, 341): u*v/w, (327, 373):
        -u**2*v*(u**3 - u*v + w)/w, (327, 376): -u**4*v/w, (327, 377):
        u*v**2, (327, 380): u**2*v/w, (327, 395): u*v/w, (327, 454):
        -u**4*v/w, (327, 457): -u**3*v/w, (327, 589): -u**3*v**2/w,
        (327, 596): -u**2*v*(u*v - w)/w, (327, 611): -u*v*(u*v - w)/w,
        (327, 616): -u**4*v**2/w, (327, 619): -u**2*v*(u*v - w)/w,
        (328, 210): w, (328, 231): -v, (328, 237): -u, (328, 299):
        -v*w, (328, 326): u*v, (328, 373): -u**2*v*(u**2 - v), (328,
        376): -u**3*v, (328, 377): u*v**3, (328, 380): u*v, (328,
        454): -u**3*v, (328, 457): -u**2*v, (328, 535): -u**2*v, (328,
        557): u*v/w, (328, 589): -u*v*(u*v - w), (328, 596): -u*v*(u*v
        - w), (328, 611): -u*v**2, (328, 616): -u**2*v*(u*v - w),
        (328, 619): -u*v*(u*v - w), (329, 76): -v*w, (329, 164): -v*w,
        (329, 212): w, (329, 238): -v**2, (329, 239): -u, (329, 346):
        -u*v**2, (329, 347): v, (329, 349): -v**2, (329, 352): -u*w,
        (329, 373): -v**2*(u*v + w), (329, 376): -v**3, (329, 377):
        -u**3*v*w, (329, 400): -u*v**2, (329, 458): -u**2*v*w, (329,
        514): u**2, (329, 554): -v, (329, 557): -v**2/w, (329, 563):
        -u*v/w, (329, 596): -v**2*w, (329, 620): u*v*w**2, (329, 622):
        u*v, (330, 213): w, (330, 238): -v, (330, 240): -u, (330,
        244): -u*w, (330, 271): u**2, (330, 348): v, (330, 350):
        -v**2, (330, 373): u**3*v, (330, 377): -v**3, (330, 454):
        u**2*v, (330, 557): -v/w, (330, 564): -u*v/w, (330, 568):
        u**2, (330, 595): u**3, (330, 596): v*(u*v - w), (330, 614):
        u*v*w, (330, 620): u**2*v*w, (330, 622): u**2*v/w, (330, 643):
        -v**2, (331, 212): u, (331, 239): -u**2/w, (331, 319):
        -u*v**2, (331, 337): 1, (331, 338): -v, (331, 339): -v, (331,
        341): -v**2/w, (331, 347): u*v/w, (331, 349): -u*v**2/w, (331,
        352): -u**2, (331, 353): u*v**3/w, (331, 371): u*v**2, (331,
        373): u*v**2*(u*v - w)/w, (331, 377): -u**2*v*(u**2 - v),
        (331, 458): -u**3*v, (331, 514): u**3/w, (331, 553): -u/w,
        (331, 555): u*v/w, (331, 563): -u**2*v/w**2, (331, 596):
        -u*v**2, (331, 616): u**2*v**2, (331, 620): u**2*v*w, (331,
        622): u**2*v/w, (332, 213): u, (332, 238): -u*v/w, (332, 240):
        -u**2/w, (332, 244): -u**2, (332, 271): u**3/w, (332, 310): 1,
        (332, 311): -v, (332, 319): -u**2*v**2/w, (332, 339): -u*v/w,
        (332, 341): -v/w, (332, 347): u/w, (332, 349): -u*v/w, (332,
        373): -u*v, (332, 391): -u/w, (332, 400): -u**2*v/w, (332,
        563): -u**2/w**2, (332, 568): u**3/w, (332, 595): u**4/w,
        (332, 596): -u*v, (332, 607): -u, (332, 620): u**3*v, (332,
        622): u**3*v/w**2, (333, 77): w, (333, 163): -u*w, (333, 239):
        v, (333, 374): v*w, (333, 509): v, (333, 514): -u*v, (333,
        563): v**2/w, (333, 595): -u*v*w, (334, 239): 1, (334, 240):
        -v, (334, 353): -v*w, (334, 377): u**2*v*w, (334, 458): u*v*w,
        (334, 514): -u, (334, 563): -v*(u*v - w)/w**2, (334, 568):
        u*v, (334, 622): u*v**2/w, (334, 644): v, (334, 645): -v**2,
        (335, 136): -u*w, (335, 238): w, (335, 271): -u*v, (335, 508):
        -u*v, (335, 536): u**2*v/w, (335, 537): u*v, (335, 562):
        -u*v**2/w, (335, 595): -u**2*v, (335, 622): -u**2, (335, 643):
        v*w, (336, 238): u, (336, 241): 1, (336, 271): -u, (336, 562):
        u*v/w, (336, 595): -u**2, (336, 643): u*v, (336, 646): v,
        (337, 319): u*v*w, (337, 338): w, (337, 341): v, (337, 346):
        -u**2*v, (337, 353): -u*v**2, (337, 371): -u*v*w, (337, 373):
        -2*u**2*v**2, (337, 376): -u*v**2, (337, 400): -u**2*v, (337,
        554): -u, (337, 557): -u*v/w, (337, 616): -u**2*v*w, (338,
        239): u/w, (338, 240): -u*v/w, (338, 314): v, (338, 319):
        u**2*v, (338, 322): u*v, (338, 323): -u*v**2, (338, 331): 1,
        (338, 332): -v, (338, 338): u, (338, 339): -v**2/w, (338,
        346): -u*v**2/w, (338, 353): -u*v*(u*v + w)/w, (338, 371):
        -u**2*v, (338, 373): -u**3*v**2/w, (338, 377): u**3*v, (338,
        458): u**2*v, (338, 514): -u**2/w, (338, 568): u**2*v/w, (338,
        611): -u*v, (338, 616): -u**3*v, (338, 619): -u**2*v, (338,
        620): u**2*v**2, (338, 622): u**2*v**2/w**2, (338, 644):
        u*v/w, (338, 645): -u*v**2/w, (339, 238): u, (339, 311): w,
        (339, 319): u**2*v, (339, 339): u, (339, 373): u**4, (339,
        400): u**2, (339, 454): u**3, (339, 596): u**2*v, (339, 614):
        u**2*w, (340, 238): u**2/w, (340, 241): u/w, (340, 269):
        -u**2*w, (340, 271): -u**2/w, (340, 304): 1, (340, 311): u,
        (340, 314): u*v/w, (340, 319): u**3*v/w, (340, 322): u**2*v/w,
        (340, 340): u, (340, 346): -u*v/w, (340, 353): -u**2*v/w,
        (340, 371): -u**2, (340, 373): -u**3*v/w, (340, 400): u**3/w,
        (340, 403): u**2/w, (340, 569): u, (340, 595): -u**3/w, (340,
        596): u**2, (340, 643): -u**2*v/w, (340, 644): u/w, (341,
        164): -u*v, (341, 240): u, (341, 323): u*v*w, (341, 332): w,
        (341, 339): v, (341, 341): u, (341, 353): -u**2*v, (341, 370):
        -u*w, (341, 376): -u**2*v, (341, 568): -u**2, (341, 596):
        -u*v**2, (341, 620): -u**2*v*w, (341, 622): -u**2*v/w, (341,
        645): u*v, (342, 240): w, (342, 563): u*v/w, (342, 568): -u*w,
        (342, 622): -u*v, (342, 645): v*w, (343, 326): -v**2/w, (343,
        344): -v, (343, 345): 1, (343, 352): u, (343, 514): -u**2/w,
        (343, 561): -u/w, (343, 562): -u*v/w, (343, 589): u**2*v,
        (343, 596): u**2*v, (343, 611): u*v, (343, 616): u**3*v, (343,
        619): u**2*v, (343, 620): -u*v*w, (343, 622): -u*v/w, (343,
        636): -v, (344, 299): v, (344, 343): 1, (344, 344): u, (344,
        377): -u**2*v, (344, 402): -u*v/w, (344, 458): -u*v, (344,
        514): u/w, (344, 568): -u*v/w, (344, 596): -u*v, (344, 616):
        u**2*v, (344, 620): -u*v**2, (344, 622): -u*v**2/w**2, (344,
        629): -v, (344, 636): -v**2/w, (345, 326): v, (345, 344): w,
        (345, 542): -u*v/w, (345, 560): -u, (345, 562): -u**2*v/w,
        (345, 565): -u*v/w, (346, 346): u, (346, 353): v, (346, 371):
        w, (346, 373): u*v, (347, 349): w, (347, 376): v*w, (348,
        350): w, (348, 373): -u*w, (348, 377): v*w, (349, 164): v,
        (349, 349): u, (349, 353): u*v, (349, 370): w, (349, 376):
        u*v, (349, 568): u, (349, 596): v**2, (349, 622): u*v/w, (350,
        190): u/w, (350, 325): u*v/w**2, (350, 350): u, (350, 376): u,
        (350, 568): u**2/w, (350, 596): v, (350, 622): 2*u**2*v/w**2,
        (350, 640): 1, (351, 37): 1, (351, 41): -v, (351, 44):
        -v**2/w, (351, 45): v/w, (351, 130): v**2*(u*v - w)/w**2,
        (351, 182): v*(u*v - w)/w, (351, 184): 2*u*v**2*(u*v -
        w)/w**2, (351, 187): v**2*(u*v - w)/w**2, (351, 212): -v/w,
        (351, 239): u*v/w**2, (351, 244): -v, (351, 271): u*v/w, (351,
        352): u*v/w, (351, 353): -u*v**2*(u*v - w)/w**2, (351, 514):
        -u**2*v/w**2, (351, 568): u*v/w, (351, 595): u**2*v/w, (351,
        596): -v**3*(u*v - w)/w**2, (352, 536): v/w, (352, 542): v/w,
        (352, 560): 1, (352, 562): u*v/w, (352, 565): v/w, (353, 353):
        u, (353, 591): u, (353, 607): 1, (353, 615): u, (353, 616):
        u*v, (353, 618): u**2, (353, 644): u/w, (354, 29): -v**2/w,
        (354, 47): -v, (354, 145): 1, (354, 147): -v, (354, 176):
        -u*v/w, (354, 182): -u**2*v/w, (354, 265): -v**2, (354, 292):
        u*v**2/w, (354, 346): u**2*v**2/w**2, (354, 347): -u*v/w**2,
        (354, 349): u*v**2/w**2, (354, 352): -v/w, (354, 353):
        u**3*v**2/w**2, (354, 368): u**2*v**2/w**2, (354, 373):
        u*v**2*(3*u**3 - u*v + w)/w**2, (354, 376): 2*u**3*v**2/w**2,
        (354, 400): u**2*v**2/w**2, (354, 454): 2*u**3*v**2/w**2,
        (354, 457): u**2*v**2/w**2, (354, 514): u*v/w**2, (354, 563):
        u**2*v/w**3, (354, 589): u**2*v**3/w**2, (354, 596):
        u**2*v**3/w**2, (354, 611): u*v**3/w**2, (354, 616):
        u**2*v**2*(2*u*v - w)/w**2, (354, 619): u*v**2*(u*v - w)/w**2,
        (354, 620): v**2, (354, 622): v**2/w**2, (355, 172): 1, (355,
        174): -v, (355, 176): -v, (355, 182): -u*v, (355, 346):
        u*v**2/w, (355, 347): -v/w, (355, 349): v**2/w, (355, 352):
        -v**2/w, (355, 353): u**2*v**2/w, (355, 368): u*v**2/w, (355,
        373): u*v**2*(3*u**2 - v)/w, (355, 376): 2*u**2*v**2/w, (355,
        400): u*v**2/w, (355, 454): 2*u**2*v**2/w, (355, 457):
        u*v**2/w, (355, 514): u*v**2/w**2, (355, 535): u*v**2/w, (355,
        563): u*v/w**2, (355, 589): v**2*(u*v - w)/w, (355, 596):
        u*v**3/w, (355, 611): v**3/w, (355, 616): 2*u*v**2*(u*v -
        w)/w, (355, 619): v**2*(u*v - w)/w, (355, 620): v**3, (355,
        622): v**3/w**2, (356, 179): -v, (356, 180): 1, (356, 187):
        -u*v, (356, 352): v, (356, 373): u*v**2, (356, 377):
        u**2*v**2, (356, 458): u*v**2, (356, 508): -v, (356, 514):
        -u*v/w, (356, 525): -v, (356, 535): -u*v, (356, 562): -v**2/w,
        (356, 611): -v**2, (356, 619): -u*v**2, (356, 620): -v**2*w,
        (356, 622): -v**2/w, (357, 188): -u*v, (357, 244): v, (357,
        271): -u*v/w, (357, 352): u*v/w, (357, 362): 1, (357, 363):
        -v, (357, 366): -v, (357, 373): -u**2*v**2/w, (357, 377):
        -u**2*v, (357, 454): -u*v**2/w, (357, 514): -u**2*v/w**2,
        (357, 524): -u/w, (357, 562): -v/w, (357, 568): -u*v/w, (357,
        595): -u**2*v/w, (357, 596): v*(u*w - v**2)/w, (357, 614):
        -v**2, (357, 620): -2*u*v**2, (357, 622): -2*u*v**2/w**2,
        (357, 632): -v/w, (358, 52): -v, (358, 153): 1, (358, 179):
        -u*v/w, (358, 184): u*v**2/w, (358, 187): -u**2*v/w, (358,
        282): -v, (358, 373): u*v*(3*u*v - w)/w, (358, 377):
        u**3*v**2/w, (358, 454): v*(2*u*v - w)/w, (358, 458):
        u**2*v**2/w, (358, 596): v**3/w, (358, 611): -u*v**2/w, (358,
        614): v**2, (358, 616): u*v**3/w, (358, 619): -v**2*(u**2 -
        v)/w, (359, 53): -v, (359, 184): u*v/w, (359, 188): -u**2*v/w,
        (359, 244): u*v/w, (359, 254): 1, (359, 255): -v, (359, 271):
        -u**2*v/w**2, (359, 281): -u/w, (359, 348): u/w, (359, 350):
        -u*v/w, (359, 366): -u*v/w, (359, 373): u**2*v/w, (359, 377):
        -u**3*v/w, (359, 564): -u**2/w**2, (359, 568): -u**2*v/w**2,
        (359, 578): -u/w, (359, 589): -u**2*v/w, (359, 595):
        -u**3*v/w**2, (359, 605): -u**2/w, (359, 611): -u*v/w, (359,
        616): -v*(u**3 - 2*u*v + w)/w, (359, 619): -v*(u**2 - v)/w,
        (359, 620): -u**2*v**2/w, (359, 622): -u**2*v**2/w**3, (359,
        632): -u*v/w**2, (359, 643): -u*v/w, (360, 163): v, (360,
        514): v**2/w, (360, 531): 1, (360, 595): v**2, (361, 184):
        -u*v, (361, 368): -v, (361, 369): 1, (361, 373): -u**2*v,
        (361, 376): -u*v, (361, 377): -u*v**2, (361, 458): -v**2,
        (361, 514): v/w, (361, 524): -v/w, (361, 561): v**2/w**2,
        (361, 562): v**3/w**2, (361, 563): v**3/w**3, (361, 568):
        -v**2/w, (361, 616): -u*v**2, (361, 622): -v**3/w**2, (362,
        136): v, (362, 271): v**2/w, (362, 363): w, (362, 536):
        -u*v**2/w**2, (362, 537): -v**2/w, (362, 542): -u*v**2/w**2,
        (362, 560): -u*v/w, (362, 562): -u**2*v**2/w**2, (362, 565):
        -v*(u*v + w)/w**2, (362, 595): u*v**2/w, (362, 622): u*v/w,
        (363, 188): v, (363, 271): v/w, (363, 357): 1, (363, 363): u,
        (363, 369): u/w, (363, 377): u*v, (363, 514): u*v/w**2, (363,
        595): u*v/w, (363, 620): v**2, (364, 186): -v, (364, 288): 1,
        (364, 373): -u**2*v, (364, 376): -u*v, (364, 454): -u*v, (364,
        457): -v, (364, 618): -v**2, (365, 49): -v, (365, 184):
        -u**2*v/w, (365, 261): 1, (365, 281): -v/w, (365, 368):
        -u*v/w, (365, 373): -2*u**3*v/w, (365, 376): -2*u**2*v/w,
        (365, 454): -u**2*v/w, (365, 457): -u*v/w, (365, 605): -u*v/w,
        (365, 615): v**2/w, (365, 616): -v**2*(u**2 - v)/w, (365,
        618): v*(u*v - w)/w, (366, 188): -v, (366, 255): w, (366,
        373): -u**3*v/w, (366, 377): -u*v, (366, 454): -u**2*v/w,
        (366, 589): u**2, (366, 596): u*(u*w - v**2)/w, (366, 611): u,
        (366, 614): -u*v, (366, 616): u*(u**2 - v), (366, 619): u**2 -
        v, (366, 620): -u**2*v, (366, 643): u, (367, 249): 1, (367,
        255): u, (367, 261): u/w, (367, 269): u*v, (367, 271):
        u*v/w**2, (367, 367): u, (367, 376): -u**2/w, (367, 584): u/w,
        (367, 589): u**3/w, (367, 592): u**2/w, (367, 595):
        u**2*v/w**2, (367, 611): u**2/w, (367, 616): (u**2 - v)**2/w,
        (367, 619): u*(u**2 - v)/w, (367, 643): 2*u**2/w, (367, 646):
        u/w, (368, 184): -v, (368, 281): 1, (368, 377): -u**2*v, (368,
        458): -u*v, (368, 605): u, (368, 615): -v, (368, 616): -v**2,
        (368, 618): -u*v, (369, 524): 1, (369, 561): -v/w, (369, 562):
        -v**2/w, (369, 563): -v**2/w**2, (369, 568): v, (369, 622):
        v**2/w, (370, 164): -u*v/w, (370, 347): 1/w, (370, 349): -v/w,
        (370, 353): -u**2*v/w, (370, 373): -v*(u**3 - 2*u*v + w)/w,
        (370, 400): -u*v/w, (370, 454): -u**2*v/w, (370, 563):
        -u/w**2, (370, 589): -u*v**2/w, (370, 596): -2*u*v**2/w, (370,
        608): -v, (370, 611): -v**2/w, (370, 614): -u*v, (370, 616):
        -2*u**2*v**2/w, (370, 619): -u*v**2/w, (371, 346): -v/w, (371,
        353): -u*v/w, (371, 373): -u**2*v/w, (371, 376): -u*v/w, (371,
        591): -u*v/w, (371, 607): -v/w, (371, 615): -u*v/w, (371,
        616): -u*v**2/w, (371, 618): -u**2*v/w, (371, 644): -(u*v -
        w)/w**2, (371, 645): -v/w, (372, 373): -u*v, (372, 374): 1,
        (372, 375): -v, (372, 376): -v, (372, 536): -u/w, (373, 373):
        u, (373, 376): 1, (374, 375): w, (375, 372): 1, (375, 373): v,
        (375, 375): u, (375, 622): u/w, (376, 373): -v, (376, 645): 1,
        (377, 325): u/w**2, (377, 377): u, (377, 622): u**2/w**2,
        (377, 642): 1/w, (377, 645): u/w, (378, 64): 1, (378, 68): -v,
        (378, 71): -v**2/w, (378, 72): v/w, (378, 104): -v, (378,
        131): u*v/w, (378, 184): v**2*(u*v - w)/w, (378, 212):
        -v**2/w, (378, 236): v*(u*v - w)/w, (378, 238): u*v**2*(u*v -
        w)/w**2, (378, 239): u*v**2/w**2, (378, 241): v**2*(u*v -
        w)/w**2, (378, 298): -v, (378, 325): u*v/w, (378, 379): u*v/w,
        (378, 380): -u*v**2*(u*v - w)/w**2, (378, 541): -u**2*v/w**2,
        (378, 595): u*v, (378, 623): -v**3*(u*v - w)/w**2, (379, 488):
        v, (379, 506): w, (379, 508): u*v, (379, 511): v, (379, 542):
        v**2/w, (379, 560): v, (379, 562): u*v**2/w, (379, 563): v/w,
        (379, 565): v**2/w, (380, 380): u, (380, 590): u, (380, 618):
        u*w, (380, 634): 1, (380, 642): u, (380, 643): u*v, (380,
        644): u*v/w, (381, 56): -v**2/w, (381, 74): -v, (381, 199): 1,
        (381, 201): -v, (381, 230): -u*v/w, (381, 236): -u**2*v/w,
        (381, 319): -v**2, (381, 346): u*v**2*(u*v + w)/w**2, (381,
        347): -u*v**2/w**2, (381, 349): u*v**3/w**2, (381, 373):
        2*u**3*v**2/w, (381, 376): u**2*v**2/w, (381, 379): -v/w,
        (381, 380): u**3*v**2/w**2, (381, 395): u**2*v**2/w**2, (381,
        400): u*v**2*(u**3 + w)/w**2, (381, 403): u**3*v**2/w**2,
        (381, 454): u**2*v**2/w, (381, 481): u**2*v**2/w, (381, 482):
        -u*v/w, (381, 484): u*v**2/w, (381, 509): u**2*v/w**2, (381,
        541): u*v/w**2, (381, 563): u**2*v**2/w**3, (381, 568):
        v**2/w, (381, 616): u**2*v**3/w, (381, 622): v**3/w**2, (381,
        623): u**2*v**3/w**2, (381, 638): u*v**3/w**2, (381, 643):
        u**2*v**2*(u*v - w)/w**2, (381, 646): u*v**2*(u*v - w)/w**2,
        (381, 647): v**2, (382, 226): 1, (382, 228): -v, (382, 230):
        -v, (382, 236): -u*v, (382, 346): u*v**3/w, (382, 347):
        -v**2/w, (382, 349): v**3/w, (382, 373): 2*u**2*v**2, (382,
        376): u*v**2, (382, 379): -v**2/w, (382, 380): u**2*v**2/w,
        (382, 395): u*v**2/w, (382, 400): u**3*v**2/w, (382, 403):
        u**2*v**2/w, (382, 454): u*v**2, (382, 481): u*v**2, (382,
        482): -v, (382, 484): v**2, (382, 509): u*v/w, (382, 541):
        u*v**2/w**2, (382, 562): u*v**2/w, (382, 563): u*v**2/w**2,
        (382, 568): v**3/w, (382, 616): v**2*(u*v - w), (382, 622):
        v**4/w**2, (382, 623): u*v**3/w, (382, 638): v**3/w, (382,
        643): u*v**2*(u*v - w)/w, (382, 646): v**2*(u*v - w)/w, (382,
        647): v**3, (383, 233): -v, (383, 234): 1, (383, 241): -u*v,
        (383, 377): u*v**2*w, (383, 379): v, (383, 400): u*v**2, (383,
        508): -v**2, (383, 535): -v*w, (383, 541): -u*v/w, (383, 552):
        -v, (383, 562): -v**3/w, (383, 568): -v**2, (383, 622):
        -v**3/w, (383, 638): -v**2, (383, 646): -u*v**2, (383, 647):
        -v**2*w, (384, 242): -u*v, (384, 298): v, (384, 325): -u*v/w,
        (384, 373): -u*v**2, (384, 379): u*v/w, (384, 389): 1, (384,
        390): -v, (384, 393): -v, (384, 404): -u**2*v, (384, 508): -v,
        (384, 541): -u**2*v/w**2, (384, 551): -u/w, (384, 562):
        -v**2/w, (384, 568): -2*u*v**2/w, (384, 578): -v, (384, 595):
        -u*v, (384, 622): -2*u*v**3/w**2, (384, 623): v*(u*w -
        v**2)/w, (384, 632): -v**2/w, (384, 641): -v**2, (384, 647):
        -2*u*v**2, (385, 79): -v, (385, 207): 1, (385, 233): -u*v/w,
        (385, 238): u*v**2/w, (385, 241): -u**2*v/w, (385, 336): -v,
        (385, 373): v*(2*u*v - w), (385, 377): u**2*v**2, (385, 400):
        u**2*v**2/w, (385, 623): v**3/w, (385, 638): -u*v**2/w, (385,
        641): v**2, (385, 643): u*v**3/w, (385, 646): -v**2*(u**2 -
        v)/w, (386, 80): -v, (386, 238): u*v/w, (386, 242): -u**2*v/w,
        (386, 298): u*v/w, (386, 308): 1, (386, 309): -v, (386, 325):
        -u**2*v/w**2, (386, 335): -u/w, (386, 348): u*v/w, (386, 350):
        -u*v**2/w, (386, 393): -u*v/w, (386, 400): u**2*v/w, (386,
        404): -u**3*v/w, (386, 483): u, (386, 485): -u*v, (386, 510):
        -u**2/w, (386, 564): -u**2*v/w**2, (386, 568):
        -u**2*v**2/w**2, (386, 578): -u*v/w, (386, 589): -u*v, (386,
        595): -u**2*v/w, (386, 605): -u, (386, 616): -u**2*v, (386,
        622): -u**2*v**3/w**3, (386, 632): -u*v**2/w**2, (386, 638):
        -u*v/w, (386, 643): v*(u*v - w)/w, (386, 646): -v*(u**2 -
        v)/w, (386, 647): -u**2*v**2/w, (387, 217): v, (387, 541):
        v**2/w, (387, 558): 1, (387, 622): v**2, (388, 238): -u*v,
        (388, 377): -v**2*w, (388, 395): -v, (388, 396): 1, (388,
        400): -u**2*v, (388, 403): -u*v, (388, 507): v**2/w, (388,
        508): v**3/w, (388, 509): v**3/w**2, (388, 541): v/w, (388,
        551): -v/w, (388, 561): v**3/w**2, (388, 562): v**4/w**2,
        (388, 563): v**4/w**3, (388, 568): -v**3/w, (388, 595): -v**2,
        (388, 622): v**2*(u*w - v**2)/w**2, (388, 643): -u*v**2, (389,
        190): v, (389, 325): v**2/w, (389, 390): w, (389, 488):
        -u*v**2/w, (389, 506): -u*v, (389, 508): -u**2*v**2/w, (389,
        511): -v*(u*v + w)/w, (389, 542): -u*v**3/w**2, (389, 560):
        -u*v**2/w, (389, 562): -u**2*v**3/w**2, (389, 563):
        -u*v**2/w**2, (389, 564): -v**2/w, (389, 565): -v**2*(u*v +
        w)/w**2, (389, 568): u*v, (389, 622): 2*u*v**2/w, (390, 242):
        v, (390, 325): v/w, (390, 384): 1, (390, 390): u, (390, 396):
        u/w, (390, 404): u*v, (390, 541): u*v/w**2, (390, 622): u*v/w,
        (390, 647): v**2, (391, 240): -v, (391, 342): 1, (391, 373):
        -u*v*w, (391, 376): -v*w, (391, 645): -v**2, (392, 76): -v,
        (392, 238): -u**2*v/w, (392, 315): 1, (392, 335): -v/w, (392,
        373): -u**2*v, (392, 376): -u*v, (392, 395): -u*v/w, (392,
        400): -u**3*v/w, (392, 403): -u**2*v/w, (392, 632): -u*v/w,
        (392, 642): v**2/w, (392, 643): -v**2*(u**2 - v)/w, (392,
        645): v*(u*v - w)/w, (393, 242): -v, (393, 309): w, (393,
        373): -u**2*v, (393, 404): -u*v, (393, 589): u*w, (393, 616):
        u**2*w, (393, 623): u*(u*w - v**2)/w, (393, 638): u, (393,
        641): -u*v, (393, 646): u**2 - v, (393, 647): -u**2*v, (394,
        303): 1, (394, 309): u, (394, 315): u/w, (394, 323): u*v,
        (394, 325): u*v/w**2, (394, 394): u, (394, 403): -u**2/w,
        (394, 589): 2*u**2, (394, 592): u, (394, 611): u, (394, 616):
        u**3, (394, 619): u**2, (394, 622): u**2*v/w**2, (394, 643):
        v**2/w, (395, 238): -v, (395, 335): 1, (395, 377): -u*v*w,
        (395, 632): u, (395, 642): -v, (395, 643): -v**2, (395, 645):
        -u*v, (396, 507): -v, (396, 508): -v**2, (396, 509): -v**2/w,
        (396, 551): 1, (396, 561): -v**2/w, (396, 562): -v**3/w, (396,
        563): -v**3/w**2, (396, 568): v**2, (396, 595): v*w, (396,
        622): -v*(u*w - v**2)/w, (397, 218): -u*v/w, (397, 347): v/w,
        (397, 349): -v**2/w, (397, 373): -u**2*v, (397, 380):
        -u**2*v/w, (397, 400): v*(u*v - w)/w, (397, 454): -u*v, (397,
        482): 1, (397, 484): -v, (397, 509): -u/w, (397, 563):
        -u*v/w**2, (397, 616): -u*v**2, (397, 623): -2*u*v**2/w, (397,
        635): -v, (397, 638): -v**2/w, (397, 641): -u*v, (397, 643):
        -u**2*v**2/w, (397, 646): -u*v**2/w, (398, 346): -v**2/w,
        (398, 380): -u*v/w, (398, 400): -u**2*v/w, (398, 403): -u*v/w,
        (398, 481): -v, (398, 590): (-u*v + w)/w, (398, 591): -v,
        (398, 618): -u*v, (398, 634): -v/w, (398, 642): -u*v/w, (398,
        643): -u*v**2/w, (398, 644): -v*(u*v - w)/w**2, (398, 645):
        -v**2/w, (399, 400): -u*v, (399, 401): 1, (399, 402): -v,
        (399, 403): -v, (399, 563): -u/w, (400, 400): u, (400, 403):
        1, (401, 402): w, (402, 399): 1, (402, 400): v, (402, 402): u,
        (402, 568): u, (402, 622): u*v/w, (403, 400): -v, (403, 591):
        w, (403, 645): v, (404, 325): u*v/w**2, (404, 404): u, (404,
        460): u/w, (404, 568): u**2/w, (404, 588): 1, (404, 591): u,
        (404, 622): u**2*v/w**2, (404, 642): v/w, (404, 645): u*v/w,
        (405, 12): 1, (405, 16): -v, (405, 101): -v, (405, 128):
        u*v/w, (405, 130): u*v*(u*v - w)/w**2, (405, 157): -u*v, (405,
        160): -v, (405, 161): v**2, (405, 184): u**2*v/w, (405, 187):
        u*v/w, (405, 188): -u*v**2/w, (405, 211): u**2*v/w, (405,
        214): u*v/w, (405, 215): -v, (405, 238): -u**3*v/w**2, (405,
        241): -u**2*v/w**2, (405, 242): u*v/w, (405, 434): -u*v*(u*v -
        w)/w**2, (406, 535): u, (406, 538): 1, (406, 562): -u**2/w,
        (406, 565): -u/w, (407, 582): 1, (407, 620): -u*v, (407, 647):
        u, (408, 95): 1, (408, 97): -v, (408, 101): u, (408, 122):
        -u/w, (408, 128): -u**2/w, (408, 265): -u*v, (408, 292):
        u**2*v/w, (408, 319): u**2*v/w, (408, 346): -u**3*v/w**2,
        (408, 373): -u**2*v*(u*v - w)/w**2, (408, 377): -u*v**2/w,
        (408, 404): u*v/w, (408, 434): u**3*v/w**2, (408, 449):
        u**2*v/w**2, (408, 454): u**4*v/w**2, (408, 457): u**3*v/w**2,
        (408, 589): u**3*v**2/w**2, (409, 101): w, (409, 124): -v,
        (409, 128): -u, (409, 373): -u**2*v**2/w, (409, 377):
        -u*v**3/w, (409, 400): u**2*v/w, (409, 404): u*v**2/w, (409,
        434): u**2*v/w, (409, 449): u*v/w, (409, 454): u**3*v/w, (409,
        457): u**2*v/w, (409, 535): u**2*v/w, (409, 562):
        -u**3*v/w**2, (409, 589): u*v*(u*v - w)/w, (410, 22): -u*v,
        (410, 106): w, (410, 130): -u*v**2/w, (410, 133): -u, (410,
        373): 2*u*v**3/w, (410, 376): v**3/w, (410, 400): -2*u*v**2/w,
        (410, 403): -v**2/w, (410, 458): u**2*v, (410, 481): -u*v,
        (410, 501): u*v/w, (410, 502): -v, (410, 562): u*v*(u*v -
        w)/w**2, (411, 22): -u, (411, 107): w, (411, 130): -u*v/w,
        (411, 134): -u, (411, 373): u*v**2/w, (411, 377): v**3/w,
        (411, 400): -u*v/w, (411, 404): -v**2/w, (411, 448): -v, (411,
        454): -u**2*v/w, (411, 535): -u*v/w, (411, 562): u**2*v/w**2,
        (412, 98): 1, (412, 106): u, (412, 125): -u/w, (412, 133):
        -u**2/w, (412, 353): -u*v**3/w**2, (412, 371): -u*v**2/w,
        (412, 373): -u*v**2*(u*v - w)/w**2, (412, 377): -u**2*v**2/w,
        (412, 380): u*v**2/w**2, (412, 398): u*v/w, (412, 400):
        u*v*(u*v - w)/w**2, (412, 404): u**2*v/w, (412, 427): -u*v,
        (412, 454): u**2*v/w, (412, 458): u**3*v/w, (412, 475): -v,
        (412, 501): u**2*v/w**2, (412, 616): -u**2*v**2/w, (412, 643):
        u**2*v/w, (413, 107): u, (413, 134): -u**2/w, (413, 373):
        u*v/w, (413, 400): -u/w, (413, 420): 1, (413, 421): -v, (413,
        427): -u**2*v/w, (413, 447): -u/w, (413, 474): -u/w, (413,
        501): u**2/w**2, (413, 609): u*v/w, (413, 636): -u/w, (414,
        24): w, (414, 132): v, (414, 375): -v**2, (414, 402): v, (414,
        537): v, (414, 564): -u*v/w, (415, 103): w, (415, 130): -u,
        (415, 458): -u*v, (415, 481): v, (415, 501): -v/w, (415, 508):
        -u*v/w, (415, 562): -v*(u*v - w)/w**2, (416, 26): w, (416,
        134): v, (416, 377): -v**2, (416, 404): v, (416, 535):
        -u**2*v/w, (416, 538): -u*v/w, (416, 562): u**3*v/w**2, (416,
        565): u**2*v/w**2, (417, 134): 1, (417, 593): v, (418, 353):
        u*v**2/w, (418, 373): u**2*v**2/w, (418, 376): u*v**2/w, (418,
        380): -u*v/w, (418, 400): -u**2*v/w, (418, 403): -u*v/w, (418,
        427): u*w, (418, 454): -u**2, (418, 476): 1, (418, 481):
        -u**2, (418, 503): -u/w, (418, 508): u**3/w, (418, 616):
        u**2*v, (418, 643): -u**2, (419, 103): u, (419, 130): -u**2/w,
        (419, 353): u**2*v**2/w**2, (419, 380): -u**2*v/w**2, (419,
        422): 1, (419, 427): u**2, (419, 430): u, (419, 431): -u*v,
        (419, 449): -u/w, (419, 454): -u**3/w, (419, 457): -u**2/w,
        (419, 474): -v/w, (419, 611): u*v/w, (419, 616): u**3*v/w,
        (419, 619): u**2*v/w, (419, 620): -u**2*v**2/w, (419, 638):
        -u/w, (419, 643): -u**3/w, (419, 646): -u**2/w, (419, 647):
        u**2*v/w, (420, 421): w, (420, 427): u**2, (420, 448): -u,
        (420, 454): -u**3/w, (421, 134): u/w, (421, 245): -u*v/w,
        (421, 269): u**2, (421, 299): u/w, (421, 323): -u**3/w, (421,
        353): u**2*v/w**2, (421, 380): -u**2/w**2, (421, 413): 1,
        (421, 421): u, (421, 422): u/w, (421, 427): u**3/w, (421,
        430): u**2/w, (421, 458): u**2/w, (421, 591): u/w, (422, 164):
        u*v/w, (422, 218): -u/w, (422, 431): u*w, (422, 458): -u**2,
        (422, 474): 1, (422, 501): -u/w, (422, 596): u*v**2/w, (422,
        620): u**2*v, (422, 623): -u*v/w, (422, 647): -u**2, (423,
        22): w, (423, 130): v, (423, 373): -v**2, (423, 400): v, (424,
        83): 1, (424, 110): -u/w, (424, 508): -u/w, (424, 583): -v,
        (424, 589): -u**2*v/w, (425, 407): 1, (425, 434): -u/w, (425,
        582): -v/w, (425, 596): u*v/w, (425, 620): u*v**2/w, (425,
        623): -u/w, (425, 647): -u*v/w, (426, 461): 1, (426, 488):
        -u/w, (426, 508): -u**2/w, (426, 511): -u/w, (427, 353): -v/w,
        (427, 380): 1/w, (428, 29): -v, (428, 56): 1, (428, 164):
        -v**2/w, (428, 218): v/w, (428, 353): -v*(u*v - w)/w, (428,
        434): -v**2/w, (428, 488): v/w, (429, 488): 1/w, (430, 164):
        -v/w, (430, 218): 1/w, (430, 596): -v**2/w, (430, 623): v/w,
        (431, 596): -v/w, (431, 623): 1/w, (432, 10): 1, (432, 14):
        -v, (432, 17): -v**2/w, (432, 18): v/w, (432, 128): v*(u*v -
        w)/w, (432, 130): u*v**2*(u*v - w)/w**2, (432, 133): v**2*(u*v
        - w)/w**2, (432, 158): -v, (432, 184): -v**3*(u*v - w)/w**2,
        (432, 185): u*v/w, (432, 212): u*v/w, (432, 238): v**2*(u*v -
        w)/w**2, (432, 239): -u**2*v/w**2, (432, 406): -v, (432, 433):
        u*v/w, (432, 434): -u*v**2*(u*v - w)/w**2, (432, 460): u*v/w,
        (432, 487): -u**2*v/w**2, (432, 569): -v**3*(u*v - w)/w**2,
        (432, 595): -u*v**2/w, (432, 622): u*v/w, (433, 509): v/w,
        (433, 515): v, (433, 533): w, (433, 535): u*v, (433, 538): v,
        (433, 542): -u*v/w, (433, 560): -u, (433, 562): -u**2*v/w,
        (433, 565): -u*v/w, (434, 434): u, (434, 580): 1, (434, 588):
        u, (434, 589): u*v, (434, 617): u, (434, 618): -u*v, (434,
        644): -u**2/w, (434, 645): u, (435, 2): -v**2/w, (435, 20):
        -v, (435, 91): 1, (435, 93): -v, (435, 122): -u*v/w, (435,
        128): -u**2*v/w, (435, 292): u**2*v**2/w, (435, 293): -u*v/w,
        (435, 295): u*v**2/w, (435, 346): -u**3*v**2/w**2, (435, 347):
        u**2*v/w**2, (435, 349): -u**2*v**2/w**2, (435, 373):
        -u**2*v**2*(2*u*v - w)/w**2, (435, 376): -u**2*v**3/w**2,
        (435, 400): u**3*v**2/w**2, (435, 403): u**2*v**2/w**2, (435,
        427): -v**2, (435, 433): -v/w, (435, 434): u**3*v**2/w**2,
        (435, 449): u**2*v**2/w**2, (435, 454): u*v**2*(u**3 - u*v +
        w)/w**2, (435, 457): u**3*v**2/w**2, (435, 481): u*v**2/w,
        (435, 487): u*v/w**2, (435, 536): u**2*v/w**2, (435, 563):
        -u**3*v/w**3, (435, 569): u**2*v**3/w**2, (435, 584):
        u*v**3/w**2, (435, 589): u**2*v**2*(u*v - w)/w**2, (435, 592):
        u*v**2*(u*v - w)/w**2, (435, 593): v**2, (435, 595): v**2/w,
        (435, 616): -u**2*v**4/w**2, (435, 622): -u*v**2/w**2, (435,
        643): u**2*v**3/w**2, (436, 118): 1, (436, 120): -v, (436,
        122): -v, (436, 128): -u*v, (436, 292): u*v**2, (436, 293):
        -v, (436, 295): v**2, (436, 346): -u**2*v**2/w, (436, 347):
        u*v/w, (436, 349): -u*v**2/w, (436, 373): -u*v**2*(2*u*v -
        w)/w, (436, 376): -u*v**3/w, (436, 400): u**2*v**2/w, (436,
        403): u*v**2/w, (436, 433): -v**2/w, (436, 434): u**2*v**2/w,
        (436, 449): u*v**2/w, (436, 454): u*v**2*(u**2 - v)/w, (436,
        457): u**2*v**2/w, (436, 487): u*v**2/w**2, (436, 508):
        u*v**2/w, (436, 536): u*v/w, (436, 563): -u**2*v/w**2, (436,
        569): u*v**3/w, (436, 584): v**3/w, (436, 589): u*v**2*(u*v -
        w)/w, (436, 592): v**2*(u*v - w)/w, (436, 593): v**3, (436,
        595): v**3/w, (436, 616): -v**3*(u*v - w)/w, (436, 622):
        -u*v**3/w**2, (436, 643): v**2*(u*v - w)/w, (437, 125): -v,
        (437, 126): 1, (437, 133): -u*v, (437, 377): -u*v**3, (437,
        404): u*v**2, (437, 433): v, (437, 454): u*v**2, (437, 487):
        -u*v/w, (437, 498): -v, (437, 562): v*(u*v - w)/w, (437, 584):
        -v**2, (437, 592): -u*v**2, (437, 593): -v**2*w, (437, 595):
        -v**2, (437, 622): u*v**2/w, (438, 134): -u*v, (438, 373):
        u*v**3/w, (438, 400): -u*v**2/w, (438, 406): v, (438, 433):
        u*v/w, (438, 443): 1, (438, 444): -v, (438, 447): -v, (438,
        458): -u**2*v, (438, 460): -u*v/w, (438, 487): -u**2*v/w**2,
        (438, 497): -u/w, (438, 535): -v, (438, 562): u*v/w, (438,
        569): v*(u*w - v**2)/w, (438, 587): -v**2, (438, 593):
        -2*u*v**2, (438, 595): -u*v**2/w, (438, 605): -v, (438, 622):
        u*v*(2*u*v - w)/w**2, (438, 632): u*v/w, (439, 25): -v, (439,
        99): 1, (439, 125): -u*v/w, (439, 130): u*v**2/w, (439, 133):
        -u**2*v/w, (439, 373): -v**2*(2*u*v - w)/w, (439, 377):
        -u**2*v**3/w, (439, 400): v*(2*u*v - w)/w, (439, 404):
        u**2*v**2/w, (439, 454): u**2*v**2/w, (439, 471): -v, (439,
        569): v**3/w, (439, 584): -u*v**2/w, (439, 587): v**2, (439,
        589): u*v**3/w, (439, 592): -v**2*(u**2 - v)/w, (440, 26): -v,
        (440, 130): u*v/w, (440, 134): -u**2*v/w, (440, 294): u, (440,
        296): -u*v, (440, 348): -u**2/w, (440, 350): u**2*v/w, (440,
        406): u*v/w, (440, 416): 1, (440, 417): -v, (440, 447):
        -u*v/w, (440, 454): u**2*v/w, (440, 458): -u**3*v/w, (440,
        460): -u**2*v/w**2, (440, 470): -u/w, (440, 537): -u**2/w,
        (440, 564): u**3/w**2, (440, 584): -u*v/w, (440, 589):
        v*(2*u*v - w)/w, (440, 592): -v*(u**2 - v)/w, (440, 593):
        -u**2*v**2/w, (440, 616): u*v*(u*v - w)/w, (440, 622):
        u**2*v*(u*v - w)/w**3, (440, 632): u*(u*v - w)/w**2, (441,
        109): v, (441, 487): v**2/w, (441, 504): 1, (441, 568): v**2,
        (442, 130): -u*v, (442, 377): v**3, (442, 404): -v**2, (442,
        449): -v, (442, 450): 1, (442, 454): -u**2*v, (442, 457):
        -u*v, (442, 487): v/w, (442, 497): -v/w, (442, 534): v**2/w,
        (442, 535): v**3/w, (442, 536): v**3/w**2, (442, 561):
        -u*v**2/w**2, (442, 562): -u*v**3/w**2, (442, 563):
        -u*v**3/w**3, (442, 568): u*v**2/w, (442, 589): -u*v**2, (442,
        622): v**2*(u*v - w)/w**2, (443, 82): v, (443, 444): w, (443,
        460): v**2/w, (443, 509): -u*v**2/w**2, (443, 510): -v**2/w,
        (443, 515): -u*v**2/w, (443, 533): -u*v, (443, 535):
        -u**2*v**2/w, (443, 538): -v*(u*v + w)/w, (443, 542):
        u**2*v**2/w**2, (443, 560): u**2*v/w, (443, 562):
        u**3*v**2/w**2, (443, 565): u*v*(u*v + w)/w**2, (443, 568):
        u*v**2/w, (443, 595): u*v, (443, 622): -u**2*v/w, (444, 134):
        v, (444, 438): 1, (444, 444): u, (444, 450): u/w, (444, 458):
        u*v, (444, 460): v/w, (444, 487): u*v/w**2, (444, 568): u*v/w,
        (444, 593): v**2, (445, 132): -v, (445, 373): u*v**2, (445,
        376): v**2, (445, 400): -u*v, (445, 403): -v, (445, 477): 1,
        (445, 591): -v**2, (446, 22): -v, (446, 130): -u**2*v/w, (446,
        373): u**2*v**2/w, (446, 376): u*v**2/w, (446, 400):
        -u**2*v/w, (446, 403): -u*v/w, (446, 423): 1, (446, 449):
        -u*v/w, (446, 454): -u**3*v/w, (446, 457): -u**2*v/w, (446,
        470): -v/w, (446, 578): -u*v/w, (446, 588): v**2/w, (446,
        589): -v**2*(u**2 - v)/w, (446, 591): v*(u*v - w)/w, (447,
        134): -v, (447, 373): u**2*v**2/w, (447, 400): -u**2*v/w,
        (447, 417): w, (447, 458): -u*v, (447, 569): u*(u*w - v**2)/w,
        (447, 584): u, (447, 587): -u*v, (447, 589): -u*v, (447, 592):
        u**2 - v, (447, 593): -u**2*v, (447, 616): -u*(u*v - w), (448,
        411): 1, (448, 417): u, (448, 423): u/w, (448, 431): u*v,
        (448, 448): u, (448, 457): -u**2/w, (448, 460): u*v/w**2,
        (448, 568): u**2*v/w**2, (448, 589): -v*(2*u**2 - v)/w, (448,
        592): -u*v/w, (448, 611): -u*v/w, (448, 616): -u**2*(u*v -
        2*w)/w, (448, 619): -u*(u*v - w)/w, (448, 638): u/w, (448,
        643): -u**3/w, (449, 130): -v, (449, 377): u*v**2, (449, 404):
        -u*v, (449, 470): 1, (449, 578): u, (449, 588): -v, (449,
        589): -v**2, (449, 591): -u*v, (450, 497): 1, (450, 534): -v,
        (450, 535): -v**2, (450, 536): -v**2/w, (450, 561): u*v/w,
        (450, 562): u*v**2/w, (450, 563): u*v**2/w**2, (450, 568):
        -u*v, (450, 622): -v*(u*v - w)/w, (451, 110): -u*v/w, (451,
        293): 1, (451, 295): -v, (451, 347): -u/w, (451, 349): u*v/w,
        (451, 373): u*v*(u*v - w)/w, (451, 434): -u**2*v/w, (451,
        454): v*(2*u*v - w)/w, (451, 536): -u/w, (451, 563):
        u**2/w**2, (451, 569): -2*u*v**2/w, (451, 581): -v, (451,
        584): -v**2/w, (451, 587): -u*v, (451, 589): -u**2*v**2/w,
        (451, 592): -u*v**2/w, (451, 616): u*v**3/w, (451, 643):
        -u*v**2/w, (452, 292): -v, (452, 346): u*v/w, (452, 434):
        -u*v/w, (452, 454): -u**2*v/w, (452, 457): -u*v/w, (452, 580):
        -v/w, (452, 588): -u*v/w, (452, 589): -u*v**2/w, (452, 617):
        (-u*v + w)/w, (452, 618): v*(u*v - w)/w, (452, 644): u*(u*v -
        w)/w**2, (453, 454): -u*v, (453, 455): 1, (453, 456): -v,
        (453, 457): -v, (453, 509): -u/w, (454, 454): u, (454, 457):
        1, (455, 456): w, (456, 453): 1, (456, 454): v, (456, 456): u,
        (456, 595): u, (456, 622): -u**2/w, (457, 454): -v, (457,
        618): w, (457, 645): -u, (458, 271): u/w, (458, 325):
        -u**2/w**2, (458, 458): u, (458, 595): u**2/w, (458, 615): 1,
        (458, 618): u, (458, 622): -u**3/w**2, (458, 642): -u/w, (458,
        645): -u**2/w, (459, 11): 1, (459, 15): -v, (459, 44):
        -u*v**2/w, (459, 45): u*v/w, (459, 71): u*v/w, (459, 72):
        -u/w, (459, 102): -v, (459, 129): u*v/w, (459, 130):
        u*v**2*(u*v - w)/w**2, (459, 157): -v*w, (459, 184):
        u*v*(u**2*v**2 - 2*u*v*w + 2*w**2)/w**2, (459, 187):
        u*v**2*(u*v - w)/w**2, (459, 188): -v**2*(u*v - w)/w, (459,
        211): u*v, (459, 238): -u**2*v/w, (459, 241): -u*v*(u*v -
        w)/w**2, (459, 242): v*(u*v - w)/w, (459, 407): v**2, (459,
        434): -u*v**2/w, (459, 461): -u*v**2/w, (459, 488): u*v/w,
        (459, 596): -u*v**3*(u*v - 2*w)/w**2, (459, 623): u*v**2*(u*v
        - 2*w)/w**2, (460, 535): w, (460, 536): u*v/w, (460, 562): -u,
        (460, 563): -u/w, (461, 377): -u*(u*v - w), (461, 456): u,
        (461, 458): -u*v, (461, 461): u, (461, 575): w, (461, 582): v,
        (461, 616): u**2*v, (461, 620): -u*v**2, (461, 643): -u**2,
        (461, 647): u*v, (462, 29): -u*v**2/w, (462, 56): u*v/w, (462,
        94): 1, (462, 96): -v, (462, 102): u, (462, 121): -u/w, (462,
        129): -u**2/w, (462, 265): -u*v**2, (462, 292): u**2*v**2/w,
        (462, 319): u*v, (462, 346): -u**2*v/w, (462, 373):
        u**2*v*(u**2 - v)*(u*v - w)/w**2, (462, 376): u**3*v*(u*v -
        w)/w**2, (462, 377): -u*v**3/w, (462, 400): u**2*v*(u*v -
        w)/w**2, (462, 404): u*v**2/w, (462, 407): -u*v, (462, 422):
        -v, (462, 434): u**2*v/w, (462, 449): u*v/w, (462, 454):
        u**4*v**2/w**2, (462, 457): u**3*v**2/w**2, (462, 461):
        u**2*v/w, (462, 476): u*v/w, (462, 589): u**3*v**3/w**2, (462,
        596): u**2*v**2*(u*v - w)/w**2, (462, 611): u*v**2*(u*v -
        w)/w**2, (462, 616): u**3*v**2*(u*v - w)/w**2, (462, 619):
        u**2*v**2*(u*v - w)/w**2, (462, 623): -u**2*v*(u*v - w)/w**2,
        (462, 638): -u*v*(u*v - w)/w**2, (462, 646): -u**2*v*(u*v -
        w)/w**2, (463, 102): w, (463, 123): -v, (463, 129): -u, (463,
        373): u**2*v*(u**2*v - u*w - v**2)/w, (463, 376): u**2*v*(u*v
        - w)/w, (463, 377): -u*v**4/w, (463, 400): u**2*v**2/w, (463,
        404): u*v**3/w, (463, 407): -v*w, (463, 434): u*v, (463, 454):
        u**3*v**2/w, (463, 457): u**2*v**2/w, (463, 461): u*v, (463,
        503): u*v/w, (463, 535): u**2*v**2/w, (463, 562): -u**2*v/w,
        (463, 589): u*v**2*(u*v - w)/w, (463, 596): u*v**2*(u*v -
        w)/w, (463, 611): u*v**3/w, (463, 616): u*v*(u*v - w)**2/w,
        (463, 619): u*v**2*(u*v - w)/w, (463, 623): -u*v*(u*v - w)/w,
        (463, 638): -u*v**2/w, (463, 646): -u*v*(u*v - w)/w, (464,
        22): -v*w, (464, 104): w, (464, 130): -v**2, (464, 131): -u,
        (464, 164): v**2, (464, 218): -v, (464, 352): u*v, (464, 373):
        v**3*(u*v + w)/w, (464, 376): v**4/w, (464, 377): u**2*v*(u*v
        - w), (464, 379): -u, (464, 400): -v**2*(u*v + w)/w, (464,
        403): -v**3/w, (464, 454): -u*v**2, (464, 458): u**2*v**2,
        (464, 481): -u*v**2, (464, 482): v, (464, 484): -v**2, (464,
        500): -v, (464, 503): -v**2/w, (464, 509): -u*v/w, (464, 514):
        -u**2*v/w, (464, 541): u**2/w, (464, 568): u*v, (464, 596):
        v**3, (464, 620): -u*v**2*w, (464, 623): -v**2, (464, 647):
        u*v*w, (465, 105): w, (465, 130): -v, (465, 132): -u, (465,
        244): u*v, (465, 271): -u**2*v/w, (465, 298): -u, (465, 325):
        u**2/w, (465, 373): -u**2*v*(u*v - w)/w, (465, 377): v**4/w,
        (465, 404): -v**3/w, (465, 454): -u**2*v**2/w, (465, 483): v,
        (465, 485): -v**2, (465, 503): -v/w, (465, 510): -u*v/w, (465,
        589): -v**2, (465, 595): -u**2*(u*v - w)/w, (465, 596):
        -v**2*(u*v - w)/w, (465, 614): -u*v**2, (465, 620):
        -u**2*v**2, (465, 623): v*(u*v - w)/w, (465, 641): u*v, (465,
        647): u**2*v, (466, 104): u, (466, 131): -u**2/w, (466, 352):
        u**2*v/w, (466, 353): -u*v**4/w**2, (466, 371): -u*v**3/w,
        (466, 373): -u*v**3*(u*v - w)/w**2, (466, 377): u**2*v*(u**2*v
        - u*w - v**2)/w, (466, 379): -u**2/w, (466, 380): u*v**3/w**2,
        (466, 398): u*v**2/w, (466, 400): u*v**2*(u*v - w)/w**2, (466,
        404): u**2*v**2/w, (466, 427): -u*v**2, (466, 458):
        u**3*v**2/w, (466, 472): 1, (466, 473): -v, (466, 474): -v,
        (466, 476): -v**2/w, (466, 482): u*v/w, (466, 484): -u*v**2/w,
        (466, 499): -u/w, (466, 501): u*v/w, (466, 509): -u**2*v/w**2,
        (466, 514): -u**3*v/w**2, (466, 541): u**3/w**2, (466, 568):
        u**2*v/w, (466, 596): u*v**3/w, (466, 616): -u**2*v**3/w,
        (466, 620): -u**2*v**2, (466, 623): -u*v**2/w, (466, 643):
        u**2*v**2/w, (466, 647): u**2*v, (467, 105): u, (467, 130):
        -u*v/w, (467, 132): -u**2/w, (467, 244): u**2*v/w, (467, 271):
        -u**3*v/w**2, (467, 298): -u**2/w, (467, 325): u**3/w**2,
        (467, 373): u*v**2/w, (467, 400): -u*v/w, (467, 418): 1, (467,
        419): -v, (467, 427): -u**2*v**2/w, (467, 445): -u/w, (467,
        454): -u**2*v/w, (467, 474): -u*v/w, (467, 476): -v/w, (467,
        482): u/w, (467, 484): -u*v/w, (467, 509): -u**2/w**2, (467,
        595): -u**3*(u*v - w)/w**2, (467, 596): u*v**2/w, (467, 607):
        u*v/w, (467, 620): -u**3*v**2/w, (467, 623): -u*v/w, (467,
        634): -u/w, (467, 647): u**3*v/w, (468, 23): w, (468, 131): v,
        (468, 163): u*v, (468, 217): -u, (468, 374): -v**2, (468,
        401): v, (468, 514): u*v**2/w, (468, 536): v, (468, 541):
        -u*v/w, (468, 563): -u*v/w, (468, 595): u*v**2, (468, 622):
        -u*v, (469, 131): 1, (469, 132): -v, (469, 353): v**2, (469,
        377): -u*v*(u*v - w), (469, 380): -v, (469, 458): -u*v**2,
        (469, 509): -v*(u*v - w)/w**2, (469, 514): u*v/w, (469, 541):
        -u/w, (469, 590): v, (469, 591): -v**2, (469, 595): u*v, (469,
        622): -u**2*v/w, (470, 130): w, (470, 136): u*v, (470, 190):
        -u, (470, 271): u*v**2/w, (470, 325): -u*v/w, (470, 535):
        -u*v, (470, 536): -u**2*v**2/w**2, (470, 537): -u*v**2/w,
        (470, 562): u**2*v/w, (470, 563): u**2*v/w**2, (470, 564):
        u*v/w, (470, 568): -u**2, (470, 589): v*w, (470, 595):
        u**2*v**2/w, (470, 622): -u**2*v/w, (471, 130): u, (471, 133):
        1, (471, 271): u*v/w, (471, 325): -u/w, (471, 508): u*v/w,
        (471, 589): u*v, (471, 592): v, (471, 595): u**2*v/w, (471,
        622): -u**2/w, (472, 353): u*v**3/w, (472, 371): u*v**2, (472,
        373): 2*u**2*v**3/w, (472, 376): u*v**3/w, (472, 380):
        -u*v**2/w, (472, 398): -u*v, (472, 400): -2*u**2*v**2/w, (472,
        403): -u*v**2/w, (472, 427): u*v*w, (472, 454): -u**2*v, (472,
        473): w, (472, 476): v, (472, 481): -u**2*v, (472, 500): -u,
        (472, 503): -u*v/w, (472, 616): u**2*v**2, (472, 643):
        -u**2*v, (473, 131): u/w, (473, 132): -u*v/w, (473, 353):
        u*v**2*(u*v + w)/w**2, (473, 371): u**2*v**2/w, (473, 373):
        u**3*v**3/w**2, (473, 377): -u**2*v*(u*v - w)/w, (473, 380):
        -u*v*(u*v + w)/w**2, (473, 398): -u**2*v/w, (473, 400):
        -u**3*v**2/w**2, (473, 422): v, (473, 427): u**2*v, (473,
        430): u*v, (473, 431): -u*v**2, (473, 458): -u**2*v**2/w,
        (473, 466): 1, (473, 467): -v, (473, 473): u, (473, 474):
        -v**2/w, (473, 481): -u*v**2/w, (473, 514): u**2*v/w**2, (473,
        541): -u**2/w**2, (473, 590): u*v/w, (473, 591): -u*v**2/w,
        (473, 595): u**2*v/w, (473, 611): u*v**2/w, (473, 616):
        u**3*v**2/w, (473, 619): u**2*v**2/w, (473, 620):
        -u**2*v**3/w, (473, 622): -u**3*v/w**2, (473, 638): -u*v/w,
        (473, 643): -u**3*v/w, (473, 646): -u**2*v/w, (473, 647):
        u**2*v**2/w, (474, 130): u, (474, 373): -u**3*(u*v - w)/w,
        (474, 419): w, (474, 427): u**2*v, (474, 454): -u**2*(u*v -
        w)/w, (474, 474): u, (474, 596): -u**2*v**2/w, (474, 614):
        -u**2*v, (474, 623): u**2*v/w, (474, 641): u**2, (475, 130):
        u**2/w, (475, 133): u/w, (475, 269): u**2*v, (475, 271):
        u**2*v/w**2, (475, 323): -u**2, (475, 325): -u**2/w**2, (475,
        353): u**2*v**2/w**2, (475, 371): u**2*v/w, (475, 373):
        u**3*v**2/w**2, (475, 380): -u**2*v/w**2, (475, 398): -u**2/w,
        (475, 400): -u**3*v/w**2, (475, 412): 1, (475, 419): u, (475,
        422): u*v/w, (475, 427): u**3*v/w, (475, 430): u**2*v/w, (475,
        454): u**3/w, (475, 457): u**2/w, (475, 475): u, (475, 481):
        -u*v/w, (475, 569): -u*v/w, (475, 589): -u**2*v/w, (475, 590):
        u/w, (475, 595): u**3*v/w**2, (475, 596): -u*(u*v - w)/w,
        (475, 622): -u**3/w**2, (476, 132): u, (476, 164): u*v**2/w,
        (476, 218): -u*v/w, (476, 353): u**2*v**2/w, (476, 370): u*v,
        (476, 376): u**2*v**2/w, (476, 380): -u**2*v/w, (476, 397):
        -u, (476, 403): -u**2*v/w, (476, 431): u*v*w, (476, 467): w,
        (476, 474): v, (476, 476): u, (476, 591): u*v, (476, 595):
        -u**2, (476, 596): u*v**3/w, (476, 620): u**2*v**2, (476,
        622): u**3/w, (476, 623): -u*v**2/w, (476, 647): -u**2*v,
        (477, 132): w, (477, 509): u*v/w, (477, 591): v*w, (477, 595):
        -u*w, (477, 622): u**2, (478, 352): -u*v/w, (478, 379): u/w,
        (478, 461): -v**2/w, (478, 479): -v, (478, 480): 1, (478,
        507): -u/w, (478, 508): -u*v/w, (478, 514): u**2*v/w**2, (478,
        541): -u**2/w**2, (478, 568): -u*v/w, (478, 582): -v, (478,
        589): -u**2*v**2/w, (478, 596): -u**2*v**2/w, (478, 611):
        -u*v**2/w, (478, 616): -u**2*v*(u*v - w)/w, (478, 619):
        -u**2*v**2/w, (478, 620): u*v**2, (478, 623): u**2*v/w, (478,
        638): u*v/w, (478, 646): u**2*v/w, (478, 647): -u*v, (479,
        377): u*v*(u*v - w)/w, (479, 407): v, (479, 456): -u*v/w,
        (479, 458): u*v**2/w, (479, 478): 1, (479, 479): u, (479,
        514): -u*v/w**2, (479, 541): u/w**2, (479, 575): -v, (479,
        582): -v**2/w, (479, 595): -u*v/w, (479, 596): u*v**2/w, (479,
        616): -u**2*v**2/w, (479, 620): u*v**3/w, (479, 622):
        u**2*v/w**2, (479, 623): -u*v/w, (479, 643): u**2*v/w, (479,
        647): -u*v**2/w, (480, 461): v, (480, 479): w, (480, 488):
        -u*v/w, (480, 506): -u, (480, 508): -u**2*v/w, (480, 511):
        -u*v/w, (481, 353): -v**2/w, (481, 371): -v, (481, 373):
        -u*v**2/w, (481, 380): v/w, (481, 398): 1, (481, 400): u*v/w,
        (481, 481): u, (482, 376): -v**2, (482, 403): v, (482, 484):
        w, (483, 373): u*v, (483, 377): -v**2, (483, 400): -u, (483,
        404): v, (483, 485): w, (484, 164): -v**2/w, (484, 218): v/w,
        (484, 353): -u*v**2/w, (484, 370): -v, (484, 376): -u*v**2/w,
        (484, 380): u*v/w, (484, 397): 1, (484, 403): u*v/w, (484,
        484): u, (484, 595): u, (484, 596): -v**3/w, (484, 622):
        -u**2/w, (484, 623): v**2/w, (485, 82): u/w, (485, 376):
        -u*v/w, (485, 403): u/w, (485, 460): u*v/w**2, (485, 485): u,
        (485, 568): u**2*v/w**2, (485, 586): 1, (485, 595): u**2/w,
        (485, 596): -v**2/w, (485, 622): -u**3/w**2, (485, 623): v/w,
        (486, 9): 1, (486, 13): -v, (486, 129): v*(u*v - w)/w, (486,
        130): v**2*(u*v - w)/w, (486, 185): v*(u*v - w)/w, (486, 186):
        -v**2*(u*v - w)/w, (486, 239): -u*v*(u*v - w)/w**2, (486,
        240): v*(u*v - w)/w, (486, 434): -v**2*(u*v - w)/w, (486,
        460): v*(u*v - w)/w, (486, 487): -u*v*(u*v - w)/w**2, (487,
        487): u, (487, 534): w, (487, 535): v*w, (487, 536): v, (487,
        561): -u, (487, 562): -u*v, (487, 563): -u*v/w, (488, 376):
        -u*(u*v - w), (488, 455): u, (488, 457): -u*v, (488, 488): u,
        (488, 574): w, (488, 580): v, (488, 586): u*w, (488, 588):
        u*v, (488, 596): -u*v**2, (488, 611): -v**2, (488, 617): u*v,
        (488, 618): -u*v**2, (488, 619): -u*v**2, (488, 623): u*v,
        (488, 638): v, (488, 644): -u**2*v/w, (488, 645): u*v, (488,
        646): u*v, (489, 21): -v, (489, 90): 1, (489, 92): -v, (489,
        121): -u*v/w, (489, 129): -u**2*v/w, (489, 292): u*v**2, (489,
        346): -u**2*v**2/w, (489, 373): -u**2*v**3/w, (489, 375):
        -v**2*(u*v - w)/w, (489, 377): -v**3, (489, 400): u**2*v**2/w,
        (489, 402): v*(u*v - w)/w, (489, 404): v**2, (489, 423): -v,
        (489, 434): u**2*v**2/w, (489, 449): u*v**2/w, (489, 454):
        u**3*v**2/w, (489, 457): u**2*v**2/w, (489, 477): u*v/w, (489,
        487): v*(u*v - w)/w**2, (489, 563): -u**2*v*(u*v - w)/w**3,
        (489, 589): u*v**2*(u*v - w)/w, (489, 591): -v**2*(u*v - w)/w,
        (489, 617): u*v*(u*v - w)/w, (489, 618): -u*v**2*(u*v - w)/w,
        (489, 622): -v**2*(u*v - w)/w**2, (489, 639): -u*v*(u*v -
        w)/w**2, (489, 644): -u**2*v*(u*v - w)/w**2, (490, 117): 1,
        (490, 119): -v, (490, 121): -v, (490, 129): -u*v, (490, 292):
        v**2*w, (490, 346): -u*v**2, (490, 373): -u*v**3, (490, 377):
        -v**4, (490, 400): u*v**2, (490, 404): v**3, (490, 434):
        u*v**2, (490, 449): v**2, (490, 450): -v, (490, 454):
        u**2*v**2, (490, 457): u*v**2, (490, 487): v**2*(u*v -
        w)/w**2, (490, 504): u*v/w, (490, 537): -v**2*(u*v - w)/w,
        (490, 563): -u*v*(u*v - w)/w**2, (490, 564): v*(u*v - w)/w,
        (490, 589): v**2*(u*v - w), (490, 612): v**2, (490, 617):
        v*(u*v - w), (490, 618): -v**2*(u*v - w), (490, 622):
        -v**3*(u*v - w)/w**2, (490, 639): -u*v**2/w, (490, 644):
        -u*v*(u*v - w)/w, (491, 131): -u*v, (491, 373): v**4, (491,
        400): -v**3, (491, 481): -v**2*w, (491, 495): 1, (491, 496):
        -v, (491, 497): -v, (491, 499): -v, (491, 504): -v**2/w, (491,
        509): -u*v**2/w, (491, 514): -u*v, (491, 534): v**2, (491,
        535): v**3, (491, 536): v**3/w, (491, 541): u**2*v/w, (491,
        561): -v, (491, 562): -v**2, (491, 563): -v**2/w, (491, 568):
        u*v**2, (491, 585): -v**2, (491, 590): -u*v**2, (491, 618):
        -v*w**2, (491, 622): v**2*(u*v - w)/w, (491, 645): u*v*w,
        (492, 109): -v**2/w, (492, 130): -v**2, (492, 132): -u*v,
        (492, 271): -u*v, (492, 325): u**2*v/w, (492, 373): v**3,
        (492, 400): -v**2, (492, 441): 1, (492, 442): -v, (492, 445):
        -v, (492, 454): -u*v**2, (492, 458): -u*v*w, (492, 487):
        -u**2*v**2/w**2, (492, 497): -u*v/w, (492, 504): -v/w, (492,
        510): -u*v**2/w, (492, 536): v**2/w, (492, 563): -v/w, (492,
        568): v**2*(u**2 - v)/w, (492, 589): -v**3, (492, 591):
        -u*v**2, (492, 595): -u*v**3/w, (492, 605): -v**2, (492, 615):
        -v*w, (492, 618): -u*v*w, (492, 622): u*v**2*(2*u*v - w)/w**2,
        (492, 632): u*v**2/w, (492, 642): u*v, (492, 645): u**2*v,
        (493, 23): -v, (493, 130): v**2, (493, 131): -u**2*v/w, (493,
        163): -u*v**2/w, (493, 217): u*v/w, (493, 353): -v**4/w, (493,
        371): -v**3, (493, 372): v**2, (493, 373): -v**3*(u*v - w)/w,
        (493, 374): v**3/w, (493, 375): u*v**2, (493, 376): -v**4/w,
        (493, 377): -u*v**3, (493, 380): v**3/w, (493, 398): v**2,
        (493, 399): -v, (493, 400): v**2*(u*v - w)/w, (493, 401):
        -v**2/w, (493, 402): -u*v, (493, 403): v**3/w, (493, 404):
        u*v**2, (493, 427): -v**2*w, (493, 454): u*v**2, (493, 468):
        1, (493, 469): -v, (493, 470): -v, (493, 477): -v**2/w, (493,
        499): -u*v/w, (493, 509): -u**2*v**2/w**2, (493, 514):
        -u**3*v**2/w**2, (493, 537): -u**2*v**2/w, (493, 541):
        u**3*v/w**2, (493, 564): u**2*v/w, (493, 568): u**2*v**2/w,
        (493, 585): -u*v**2/w, (493, 588): v**2, (493, 589): v**3,
        (493, 590): -v**2*(u**2 - v)/w, (493, 591): u*v**2, (493,
        595): -v**2*(u*v - w)/w, (493, 616): -u*v**3, (493, 618):
        -u*v*w, (493, 622): v*(u*v - w)/w, (493, 643): u*v**2, (493,
        645): u**2*v, (494, 24): -v, (494, 132): -u**2*v/w, (494,
        136): -v, (494, 190): u*v/w, (494, 271): -u**2*v/w, (494,
        325): u**3*v/w**2, (494, 372): u*v**2/w, (494, 373): u*v**3/w,
        (494, 374): v**2/w, (494, 375): u**2*v**2/w, (494, 376):
        -v**3/w, (494, 399): -u*v/w, (494, 400): -u*v**2/w, (494,
        401): -v/w, (494, 402): -u**2*v/w, (494, 403): v**2/w, (494,
        414): 1, (494, 415): -v, (494, 427): -u*v**2, (494, 445):
        -u*v/w, (494, 458): -u**2*v, (494, 470): -u*v/w, (494, 477):
        -v/w, (494, 501): -u*v/w, (494, 509): -u**2*v/w**2, (494,
        537): -u**2*v/w, (494, 564): u**3*v/w**2, (494, 568):
        u**3*v**2/w**2, (494, 585): -u*v/w, (494, 588): u*v**2/w,
        (494, 589): u*v**3/w, (494, 590): -v*(u**2 - v)/w, (494, 591):
        u**2*v**2/w, (494, 607): u*v**2/w, (494, 615): u*v*(u*v -
        w)/w, (494, 616): u*v**2*(u*v - w)/w, (494, 618): u**2*v*(u*v
        - 2*w)/w, (494, 622): u*v*(u*v - w)*(u*v + w)/w**3, (494,
        632): u*v*(u*v - w)/w**2, (494, 634): -u*v/w, (494, 645):
        u**3*v/w, (495, 454): v*w**2, (495, 496): w, (495, 504): v,
        (496, 131): v, (496, 132): -v**2, (496, 353): v**3, (496,
        380): -u*v**3/w, (496, 450): v, (496, 458): -v**2*w, (496,
        491): 1, (496, 492): -v, (496, 496): u, (496, 497): -v**2/w,
        (496, 509): -v**2*(u*v - w)/w**2, (496, 514): v, (496, 532):
        v**2, (496, 534): v**3/w, (496, 541): -u*v/w, (496, 559):
        -u*v**2/w, (496, 561): -u*v**3/w**2, (496, 563): -v**3*(u*v -
        w)/w**3, (496, 568): v**2*(u*v - w)/w, (496, 590): v**2, (496,
        591): -v**3, (496, 595): u*v**2, (496, 622): -v**2*(u**2*w -
        u*v**2 + v*w)/w**2, (497, 130): v*w, (497, 442): w, (497,
        454): u*v*w, (497, 487): -v**2/w, (497, 497): u, (497, 534):
        -u*v, (497, 535): -u*v**2, (497, 536): -v*(u*v + w)/w, (497,
        561): u**2*v/w, (497, 562): u**2*v**2/w, (497, 563): u*v*(u*v
        + w)/w**2, (497, 568): -u**2*v, (497, 589): v**2*w, (497,
        622): -u*v*(u*v - w)/w, (498, 130): u*v, (498, 133): v, (498,
        271): v, (498, 325): -u*v/w, (498, 437): 1, (498, 442): u,
        (498, 450): u*v/w, (498, 454): u**2*v, (498, 457): u*v, (498,
        498): u, (498, 589): u*v**2, (498, 592): v**2, (498, 595):
        u*v, (498, 622): -u**2*v/w, (499, 131): -v, (499, 353): v**3,
        (499, 371): v**2*w, (499, 373): 2*u*v**3, (499, 376): v**3,
        (499, 380): -v**2, (499, 398): -v*w, (499, 400): -2*u*v**2,
        (499, 403): -v**2, (499, 427): v*w**2, (499, 469): w, (499,
        477): v, (499, 481): -u*v*w, (499, 514): -u*v**2/w, (499,
        541): u*v/w, (499, 590): -v**2, (499, 595): -v*w, (499, 616):
        u*v**2*w, (499, 622): u*v, (499, 643): -u*v*w, (500, 164):
        v**3/w, (500, 218): -v**2/w, (500, 353): 2*u*v**3/w, (500,
        370): v**2, (500, 371): u*v**2, (500, 373): v**3*(u**2 - v)/w,
        (500, 380): -2*u*v**2/w, (500, 397): -v, (500, 398): -u*v,
        (500, 400): -v**2*(u**2 - v)/w, (500, 423): v, (500, 427):
        u*v*w, (500, 430): v*w, (500, 431): -v**2*w, (500, 457): -u*v,
        (500, 464): 1, (500, 465): -v, (500, 469): u, (500, 470):
        -v**2/w, (500, 500): u, (500, 578): -u*v**2/w, (500, 586):
        v**2, (500, 588): v**3/w, (500, 591): v**2*(u*v - w)/w, (500,
        595): u*v*(u*v - w)/w, (500, 616): u**2*v**2, (500, 619):
        u*v**2, (500, 620): -u*v**3, (500, 622): -u**2*v*(u*v -
        w)/w**2, (500, 643): -u**2*v, (500, 646): -u*v, (500, 647):
        u*v**2, (501, 271): -v, (501, 325): u*v/w, (501, 415): w,
        (501, 427): u*v*w, (501, 470): u, (501, 501): u, (501, 578):
        u**2, (501, 588): -u*v, (501, 589): -u*v**2, (501, 590): u**2
        - v, (501, 591): -v*(2*u**2 - v), (501, 595): -u*v, (501,
        607): -u*v, (501, 615): -u**2*v, (501, 616): -u*v*(u*v - w),
        (501, 618): -u**2*(u*v - w), (501, 622): u**2*v/w, (501, 634):
        u, (501, 642): u**2, (502, 373): (-u**4*v + u**3*w +
        2*u**2*v**2 - v**3)/w, (502, 400): -v*(2*u**2 - v)/w, (502,
        410): 1, (502, 415): u, (502, 423): u*v/w, (502, 427): u**2*v,
        (502, 430): u*v, (502, 454): -u**2*(u*v - 2*w)/w, (502, 471):
        u, (502, 502): u, (502, 569): -u*v**2/w, (502, 587): -u*v,
        (502, 589): -2*u**2*v**2/w, (502, 592): -u*v**2/w, (502, 596):
        -u*v*(u*v - w)/w, (502, 608): -u*v, (502, 611): -u*v**2/w,
        (502, 614): -u*(u*v - w), (502, 616): -2*u**2*v*(u*v - w)/w,
        (502, 619): -u*v*(u*v - w)/w, (502, 635): u, (502, 638):
        u*v/w, (503, 376): u*v**2, (503, 403): -u*v, (503, 431):
        v*w**2, (503, 465): w, (503, 470): v, (503, 477): u, (503,
        503): u, (503, 578): u*v, (503, 586): -v*w, (503, 588): -v**2,
        (503, 591): -u*v**2, (503, 595): -u**2*v, (503, 596): v**3,
        (503, 620): u*v**2*w, (503, 622): u**3*v/w, (503, 623): -v**2,
        (503, 647): -u*v*w, (504, 132): v*w, (504, 353): -v**2*w,
        (504, 380): u*v**2, (504, 458): v*w**2, (504, 492): w, (504,
        497): v, (504, 504): u, (504, 509): u*v**2/w, (504, 532):
        -v*w, (504, 534): -v**2, (504, 559): u*v, (504, 561):
        u*v**2/w, (504, 563): v**2*(u*v - w)/w**2, (504, 568): -v*(u*v
        - w), (504, 591): v**2*w, (504, 595): -u*v*w, (504, 622):
        v*(u**2*w - u*v**2 + v*w)/w, (505, 163): v**2/w, (505, 217):
        -v/w, (505, 434): -u*v, (505, 507): -u*v/w, (505, 514):
        u**2*v**2/w**2, (505, 536): -u*v/w, (505, 537): u*v**2/w,
        (505, 541): -u**2*v/w**2, (505, 563): u**2*v/w**2, (505, 564):
        -u*v/w, (505, 568): -u*v**2/w, (505, 576): 1, (505, 577): -v,
        (505, 578): -v, (505, 579): v**2, (505, 580): -v, (505, 588):
        -u*v, (505, 589): -u*v**2, (505, 595): v**3/w, (505, 612): -v,
        (505, 616): v**3, (505, 617): -u*v, (505, 618): u*v**2, (505,
        622): -v**2/w, (505, 639): u*v/w, (505, 643): -v**2, (505,
        644): u**2*v/w, (505, 645): -u*v, (506, 376): u*v*(u*v - w)/w,
        (506, 455): -u*v/w, (506, 457): u*v**2/w, (506, 506): u, (506,
        572): 1, (506, 573): -v, (506, 574): -v, (506, 577): u, (506,
        579): -u*v, (506, 580): -v**2/w, (506, 586): -u*v, (506, 588):
        -u*v**2/w, (506, 595): -u*v**2/w, (506, 596): u*v**3/w, (506,
        611): v**3/w, (506, 616): -u*v**2, (506, 617): -v*(u*v - w)/w,
        (506, 618): v**2*(u*v - w)/w, (506, 619): v**2*(u*v - w)/w,
        (506, 620): v**3, (506, 622): u**2*v**2/w**2, (506, 623):
        -u*v**2/w, (506, 638): -v**2/w, (506, 643): u*v, (506, 644):
        u*v*(u*v - w)/w**2, (506, 646): -v*(u*v - w)/w, (506, 647):
        -v**2, (507, 508): -u*v, (507, 509): -u*v/w, (507, 514):
        v**2/w, (507, 541): -v/w, (507, 577): w, (507, 579): -v*w,
        (507, 616): -v**2*w, (507, 643): v*w, (508, 508): u, (508,
        579): w, (509, 509): u, (509, 585): w, (510, 510): u, (510,
        595): u*v, (510, 605): w, (510, 622): -u**2*v/w, (510, 632):
        -u, (511, 511): u, (511, 573): w, (511, 585): u, (511, 595):
        u*v, (511, 618): v*w, (511, 620): -v**2*w, (511, 622):
        -u**2*v/w, (511, 645): -u*v, (511, 647): v*w, (512, 82):
        u*v/w, (512, 271): u*v/w, (512, 325): -u**2*v/w**2, (512,
        460): u*v**2/w**2, (512, 512): u, (512, 568): u**2*v**2/w**2,
        (512, 571): 1, (512, 573): u, (512, 586): v, (512, 595):
        3*u**2*v/w, (512, 596): -v**3/w, (512, 605): u, (512, 606):
        -u*v, (512, 614): -v**2, (512, 615): v, (512, 618): u*v, (512,
        620): -u*v**2, (512, 622): -3*u**3*v/w**2, (512, 623): v**2/w,
        (512, 632): -u**2/w, (512, 633): u, (512, 641): v, (512, 642):
        -u*v/w, (512, 645): -u**2*v/w, (512, 647): u*v, (513, 36): 1,
        (513, 40): -v, (513, 132): v*(u*v - w)/w, (513, 183): v*(u*v -
        w)/w, (513, 184): v**2*(u*v - w)/w, (513, 186): u*v*(u*v -
        w)/w, (513, 239): v*(u*v - w)/w**2, (513, 271): v*(u*v - w)/w,
        (513, 353): -v**2*(u*v - w)/w, (513, 514): -u*v*(u*v -
        w)/w**2, (514, 514): u, (514, 561): 1, (514, 562): v, (514,
        563): v/w, (515, 374): u, (515, 376): u*(u**2 - v), (515,
        403): u, (515, 457): u**2, (515, 515): u, (515, 569): u*v,
        (515, 584): v, (515, 591): u*v, (515, 592): u*v, (515, 596):
        u**2*v, (515, 601): w, (515, 607): v, (515, 611): u*v, (515,
        613): u*w, (515, 615): u*v, (515, 618): u**2*v, (515, 619):
        u**2*v, (515, 644): u*v/w, (516, 48): -v, (516, 144): 1, (516,
        146): -v, (516, 175): -u*v/w, (516, 183): -u**2*v/w, (516,
        261): -v, (516, 288): u*v/w, (516, 346): u*v**2/w, (516, 353):
        u**2*v**2/w, (516, 368): u*v**2/w, (516, 373): 2*u**3*v**2/w,
        (516, 375): u*v*(u*v - w)/w, (516, 376): u**2*v**2/w, (516,
        377): u*v**2, (516, 454): u**2*v**2/w, (516, 456): v*(u*v -
        w)/w, (516, 458): v**2, (516, 509): u**2*v/w**2, (516, 514):
        v*(u*v - w)/w**2, (516, 536): u**3*v/w**2, (516, 563):
        u**2*v**2/w**3, (516, 568): v**2/w, (516, 585): u*v/w, (516,
        591): u**2*v**2/w, (516, 595): u*v**2/w, (516, 612): u**2*v/w,
        (516, 616): u*v**2*(u*v - w)/w, (516, 618): v**2*(u**3 - u*v +
        w)/w, (516, 622): v**3/w**2, (516, 639): u*v**2/w**2, (516,
        644): u*v*(u*v - w)/w**2, (516, 645): u*v**2/w, (517, 171): 1,
        (517, 173): -v, (517, 175): -v, (517, 183): -u*v, (517, 346):
        v**2, (517, 353): u*v**2, (517, 368): v**2, (517, 369): -v,
        (517, 373): 2*u**2*v**2, (517, 376): u*v**2, (517, 377):
        u*v**3, (517, 454): u*v**2, (517, 458): v**3, (517, 509):
        u*v/w, (517, 510): v*(u*v - w)/w, (517, 514): v**2*(u*v -
        w)/w**2, (517, 531): u*v/w, (517, 536): u**2*v/w, (517, 537):
        u*v*(u*v - w)/w, (517, 563): u*v**2/w**2, (517, 568): v**3/w,
        (517, 591): u*v**2, (517, 595): u*v**3/w, (517, 616):
        v**2*(u*v - w), (517, 618): u**2*v**2, (517, 622): v**4/w**2,
        (517, 639): v**2/w, (517, 644): v*(u*v - w)/w, (517, 645):
        v**2, (518, 185): -u*v, (518, 292): -v**2*w, (518, 373):
        -u*v**3, (518, 454): -v**3, (518, 507): -v, (518, 508): -v**2,
        (518, 509): -v**2/w, (518, 522): 1, (518, 523): -v, (518,
        524): -v, (518, 526): -v, (518, 531): -v**2/w, (518, 534):
        -u*v, (518, 535): -u*v**2, (518, 536): -2*u*v**2/w, (518,
        541): -u*v/w, (518, 568): -v**2, (518, 612): -v**2, (518,
        617): -u*v**2, (518, 622): -v**3/w, (518, 645): -v*w, (519,
        163): -v**2/w, (519, 184): -v**2, (519, 186): -u*v, (519,
        325): -u*v/w, (519, 360): 1, (519, 361): -v, (519, 364): -v,
        (519, 373): -2*u*v**2, (519, 377): -u*v*w, (519, 454): -v**2,
        (519, 509): -v/w, (519, 514): -u**2*v**2/w**2, (519, 524):
        -u*v/w, (519, 531): -v/w, (519, 536): -u*v/w, (519, 537):
        -u*v**2/w, (519, 568): -u*v**2/w, (519, 595): -v**3/w, (519,
        616): -v**3, (519, 618): -u*v**2, (519, 622): -2*u*v**3/w**2,
        (519, 632): -v**2/w, (519, 642): -v, (519, 645): -u*v, (520,
        50): -v, (520, 109): u*v/w, (520, 163): u**2*v/w, (520, 184):
        v**2, (520, 185): -u**2*v/w, (520, 265): -v**2*w, (520, 279):
        1, (520, 280): -v, (520, 281): -v, (520, 288): -v**2/w, (520,
        353): u*v**3/w, (520, 371): u*v**2, (520, 372): -u*v, (520,
        373): u**2*v**3/w, (520, 374): -u*v**2/w, (520, 375): -u**2*v,
        (520, 376): u*v**3/w, (520, 377): u**2*v**2, (520, 434):
        v**3/w, (520, 452): v**2, (520, 453): -v, (520, 454):
        v**2*(u*v - w)/w, (520, 455): -v**2/w, (520, 456): -u*v, (520,
        457): v**3/w, (520, 458): u*v**2, (520, 487): u**3*v/w**2,
        (520, 510): u**2*v/w, (520, 514): u**4*v/w**2, (520, 526):
        -u*v/w, (520, 536): -u**2*v**2/w**2, (520, 537): u**3*v/w,
        (520, 568): v*(u*v - w)/w, (520, 589): u*v**2, (520, 595):
        u*v*(2*u*v - w)/w, (520, 612): -u*v**2/w, (520, 615): v**2,
        (520, 616): v**2*(u**2 + v), (520, 617): -v**2*(u**2 - v)/w,
        (520, 618): u*v**2, (520, 645): -u*v, (521, 51): -v, (521,
        186): -u**2*v/w, (521, 190): -v/w, (521, 252): 1, (521, 253):
        -v, (521, 265): -u*v**2, (521, 281): -u*v/w, (521, 288): -v/w,
        (521, 325): -u**2*v/w**2, (521, 364): -u*v/w, (521, 372):
        -u**2*v/w, (521, 373): -u**2*v**2/w, (521, 374): -u*v/w, (521,
        375): -u**3*v/w, (521, 376): u*v**2/w, (521, 377): -u**2*v,
        (521, 453): -u*v/w, (521, 454): -u*v**2/w, (521, 455): -v/w,
        (521, 456): -u**2*v/w, (521, 457): v**2/w, (521, 528): -u*v/w,
        (521, 536): -u**2*v/w**2, (521, 564): -u**2*v/w**2, (521,
        568): -u*v*(u*v + w)/w**2, (521, 578): -u*v/w, (521, 580):
        -u*v/w, (521, 588): -u**2*v/w, (521, 589): -u**2*v**2/w, (521,
        591): -u**3*v/w, (521, 595): -u**2*v/w, (521, 605): -u**2*v/w,
        (521, 607): -u**2*v/w, (521, 612): -u*v/w, (521, 615):
        -u*v*(u**2 - v)/w, (521, 616): -u*v**2*(u**2 - v)/w, (521,
        617): -v*(u**2 - v)/w, (521, 618): -u**2*v*(u**2 - v)/w, (521,
        622): -u*v**2*(u*v + w)/w**3, (521, 632): -u*v**2/w**2, (521,
        642): -u*v/w, (521, 643): -u*v**2/w, (521, 645): -2*u**2*v/w,
        (522, 373): v*w**2, (522, 523): w, (522, 531): v, (523, 185):
        v, (523, 186): -v**2, (523, 369): v, (523, 377): -v**2*w,
        (523, 380): v**3/w, (523, 509): v**3/w**2, (523, 518): 1,
        (523, 519): -v, (523, 523): u, (523, 524): -v**2/w, (523,
        536): v**2/w, (523, 541): v/w, (523, 559): v**2/w, (523, 561):
        v**3/w**2, (523, 563): v**4/w**3, (523, 568): -v**3/w, (523,
        595): -v**2, (523, 617): v**2, (523, 618): -v**3, (523, 622):
        v**2*(u*w - v**2)/w**2, (524, 184): v*w, (524, 361): w, (524,
        373): u*v*w, (524, 514): -v**2/w, (524, 524): u, (524, 561):
        -u*v/w, (524, 562): -u*v**2/w, (524, 563): -v*(u*v + w)/w**2,
        (524, 568): u*v, (524, 616): v**2*w, (524, 622): u*v**2/w,
        (525, 184): u*v, (525, 187): v, (525, 325): v/w, (525, 356):
        1, (525, 361): u, (525, 369): u*v/w, (525, 373): u**2*v, (525,
        376): u*v, (525, 525): u, (525, 616): u*v**2, (525, 619):
        v**2, (525, 622): u*v/w, (526, 185): -v, (526, 265): v*w**2,
        (526, 280): w, (526, 288): v, (526, 292): -u*v*w, (526, 353):
        -u*v**2, (526, 371): -u*v*w, (526, 373): -2*u**2*v**2, (526,
        376): -u*v**2, (526, 434): -v**2, (526, 452): -v*w, (526,
        454): -2*u*v**2, (526, 457): -v**2, (526, 487): u*v/w, (526,
        514): u**2*v/w, (526, 589): -u*v*w, (526, 616): -u**2*v*w,
        (526, 617): -v**2, (526, 622): -v, (527, 110): -v**2/w, (527,
        164): -u*v**2/w, (527, 261): v, (527, 265): u*v*w, (527, 268):
        v*w, (527, 269): -v**2*w, (527, 275): 1, (527, 276): -v, (527,
        280): u, (527, 281): -v**2/w, (527, 353): -2*u**2*v**2/w,
        (527, 370): -u*v, (527, 371): -u**2*v, (527, 373):
        -u*v**2*(u**2 - v)/w, (527, 376): -u*v, (527, 434):
        -2*u*v**2/w, (527, 451): -v, (527, 452): -u*v, (527, 454):
        -v**2*(u**2 - v)/w, (527, 527): u, (527, 589): -u**2*v, (527,
        592): -u*v, (527, 593): u*v**2, (527, 605): -u*v**2/w, (527,
        613): v**2, (527, 615): v**3/w, (527, 616): -u**3*v, (527,
        618): v**2*(u*v - w)/w, (527, 619): -u**2*v, (527, 620):
        u**2*v**2, (527, 622): u*v*(u*v - w)/w**2, (528, 253): w,
        (528, 265): u*v*w, (528, 281): u, (528, 325): -v/w, (528,
        528): u, (528, 580): u, (528, 588): u**2, (528, 589): u**2*v,
        (528, 591): u**3, (528, 605): u**2, (528, 607): u**2, (528,
        615): u*(u**2 - v), (528, 616): u*v*(u**2 - v), (528, 617):
        u**2 - v, (528, 618): (u**2 - v)**2, (528, 622): -u*v/w, (528,
        643): u*v, (528, 645): u**2, (529, 248): 1, (529, 253): u,
        (529, 261): u*v/w, (529, 265): u**2*v, (529, 268): u*v, (529,
        282): u, (529, 373): u*(u**4 - 3*u**2*v + 2*u*w + v**2)/w,
        (529, 400): u**3/w, (529, 454): (u**2 - v)**2/w, (529, 529):
        u, (529, 569): u**2*v/w, (529, 581): u, (529, 584): u*v/w,
        (529, 587): u**2, (529, 589): 2*u**3*v/w, (529, 592):
        u**2*v/w, (529, 596): u*v*(u**2 - v)/w, (529, 608): u**2,
        (529, 611): u**2*v/w, (529, 614): u*(u**2 - v), (529, 616):
        2*u**2*v*(u**2 - v)/w, (529, 619): u*v*(u**2 - v)/w, (529,
        623): u*v/w, (529, 641): u, (529, 643): 2*u**2*v/w, (529,
        646): u*v/w, (530, 269): v*w**2, (530, 276): w, (530, 281): v,
        (530, 288): u, (530, 376): -u**2*v, (530, 457): -u*v, (530,
        530): u, (530, 569): -v**2, (530, 593): -u*v*w, (530, 596):
        -u*v**2, (530, 605): u*v, (530, 613): -v*w, (530, 615): -v**2,
        (530, 618): -u*v**2, (530, 620): -u**2*v*w, (530, 622):
        -u**2*v/w, (531, 186): v*w, (531, 377): v*w**2, (531, 380):
        -v**2, (531, 509): -v**2/w, (531, 519): w, (531, 524): v,
        (531, 531): u, (531, 559): -v, (531, 561): -v**2/w, (531,
        563): -v**3/w**2, (531, 568): v**2, (531, 595): v*w, (531,
        618): v**2*w, (531, 622): -v*(u*w - v**2)/w, (532, 109): -v/w,
        (532, 163): -u*v/w, (532, 353): -u*v, (532, 487):
        -u**2*v/w**2, (532, 510): -u*v/w, (532, 514): -u**3*v/w**2,
        (532, 534): -u*v/w, (532, 537): -u**2*v/w, (532, 563):
        -u*v/w**2, (532, 568): -v**2/w, (532, 589): -v**2, (532, 591):
        -u*v, (532, 595): -2*u*v**2/w, (532, 603): 1, (532, 604): -v,
        (532, 605): -v, (532, 606): v**2, (532, 607): -v, (532, 615):
        -u*v, (532, 616): -2*u*v**2, (532, 618): -u**2*v, (532, 639):
        -v/w, (532, 644): -u*v/w, (533, 374): -u*v/w, (533, 376):
        -u*v*(u**2 - v)/w, (533, 403): -u*v/w, (533, 457): -u**2*v/w,
        (533, 533): u, (533, 569): -u*v**2/w, (533, 584): -v**2/w,
        (533, 589): u*v, (533, 591): -u*v**2/w, (533, 592): -v*(u*v -
        w)/w, (533, 593): -v**2, (533, 596): -u**2*v**2/w, (533, 599):
        1, (533, 600): -v, (533, 601): -v, (533, 604): u, (533, 606):
        -u*v, (533, 607): -v**2/w, (533, 611): -u*v**2/w, (533, 613):
        -u*v, (533, 615): -u*v**2/w, (533, 616): u**2*v, (533, 618):
        -u**2*v**2/w, (533, 619): -u*v*(u*v - w)/w, (533, 620):
        -u*v**2, (533, 622): -u*v**2/w**2, (533, 644): -v*(u*v -
        w)/w**2, (533, 645): -v**2/w, (534, 487): -v/w, (534, 514):
        -u*v/w, (534, 535): -u*v, (534, 536): -u*v/w, (534, 589): v*w,
        (534, 604): w, (534, 606): -v*w, (534, 616): u*v*w, (535,
        535): u, (535, 606): w, (536, 536): u, (536, 612): w, (537,
        537): u, (537, 622): u*v/w, (537, 632): 1, (538, 538): u,
        (538, 593): v*w, (538, 600): w, (538, 612): u, (538, 620):
        u*v*w, (538, 622): u*v/w, (538, 645): v, (539, 136): u*v/w,
        (539, 271): u*v**2/w**2, (539, 325): u*v/w**2, (539, 539): u,
        (539, 569): v**2/w, (539, 579): u, (539, 587): v, (539, 593):
        u*v, (539, 595): u**2*v**2/w**2, (539, 596): u*v**2/w, (539,
        598): 1, (539, 600): u, (539, 606): u**2, (539, 613): v, (539,
        614): u*v, (539, 620): u**2*v, (539, 622): 3*u**2*v/w**2,
        (539, 632): u/w, (539, 642): v/w, (539, 645): u*v/w, (540,
        63): 1, (540, 67): -v, (540, 131): v*(u*v - w)/w, (540, 186):
        v*(u*v - w), (540, 237): v*(u*v - w)/w, (540, 238): v**2*(u*v
        - w)/w, (540, 239): v**2*(u*v - w)/w**2, (540, 325): v*(u*v -
        w)/w, (540, 380): -v**2*(u*v - w)/w, (540, 541): -u*v*(u*v -
        w)/w**2, (541, 507): w, (541, 508): v*w, (541, 509): v, (541,
        541): u, (541, 561): v, (541, 562): v**2, (541, 563): v**2/w,
        (542, 376): u**2*w, (542, 401): u, (542, 457): u*w, (542,
        542): u, (542, 590): u*v, (542, 596): u*v*w, (542, 611): v*w,
        (542, 618): u*v*w, (542, 619): u*v*w, (542, 628): w, (542,
        634): v, (542, 640): u*w, (542, 642): u*v, (542, 644):
        u*v**2/w, (543, 75): -v, (543, 198): 1, (543, 200): -v, (543,
        229): -u*v/w, (543, 237): -u**2*v/w, (543, 315): -v, (543,
        342): u*v/w, (543, 346): u*v**3/w, (543, 373): u**2*v**2,
        (543, 375): v*(u*v - w), (543, 377): v**2*w, (543, 380):
        u**2*v**2/w, (543, 395): u*v**2/w, (543, 400): u**3*v**2/w,
        (543, 403): u**2*v**2/w, (543, 481): u*v**2, (543, 509):
        u**2*v**2/w**2, (543, 536): u**2*v/w, (543, 541): v*(u*v -
        w)/w**2, (543, 563): u**2*v**3/w**3, (543, 568): v**3/w, (543,
        585): u*v**2/w, (543, 590): u*v*(u*v - w)/w, (543, 591):
        u*v**2, (543, 595): v**2, (543, 612): u*v, (543, 618):
        u**2*v**2, (543, 622): v**4/w**2, (543, 639): u*v**3/w**2,
        (543, 643): u*v**2*(u*v - w)/w, (543, 644): u*v**2*(u*v -
        w)/w**2, (543, 645): v**2, (544, 225): 1, (544, 227): -v,
        (544, 229): -v, (544, 237): -u*v, (544, 346): v**3, (544,
        373): u*v**2*w, (544, 377): v**3*w, (544, 380): u*v**2, (544,
        395): v**2, (544, 396): -v, (544, 400): u**2*v**2, (544, 403):
        u*v**2, (544, 481): v**2*w, (544, 509): u*v**2/w, (544, 536):
        u*v, (544, 537): v*(u*v - w), (544, 541): v**2*(u*v - w)/w**2,
        (544, 558): u*v/w, (544, 563): u*v**3/w**2, (544, 568):
        v**4/w, (544, 585): v**2, (544, 590): v*(u*v - w), (544, 591):
        v**2*w, (544, 595): v**3, (544, 618): u*v**2*w, (544, 622):
        v**5/w**2, (544, 639): v**3/w, (544, 643): v**2*(u*v - w),
        (544, 644): v**2*(u*v - w)/w, (544, 645): v**3, (545, 239):
        -u*v, (545, 346): -v**2*w, (545, 373): -v**3*w, (545, 487):
        -u*v, (545, 534): -v*w, (545, 535): -v**2*w, (545, 536):
        -v**2, (545, 541): -u*v**2/w, (545, 549): 1, (545, 550): -v,
        (545, 551): -v, (545, 553): -v, (545, 558): -v**2/w, (545,
        563): -u*v**2/w, (545, 568): -v**3, (545, 591): -v*w**2, (545,
        595): -v**2*w, (545, 622): v**2*(u*w - v**2)/w, (545, 639):
        -v**2, (545, 644): -u*v**2, (545, 645): -v**2*w, (546, 217):
        -v**2/w, (546, 238): -v**2, (546, 240): -u*v, (546, 325):
        -u*v**2/w, (546, 373): -v**2*w, (546, 387): 1, (546, 388): -v,
        (546, 391): -v, (546, 400): -u*v**2, (546, 404): -u*v*w, (546,
        460): -u*v, (546, 536): -v, (546, 541): -u**2*v**2/w**2, (546,
        551): -u*v/w, (546, 558): -v/w, (546, 564): -u*v**2/w, (546,
        568): -2*u*v**3/w, (546, 578): -v**2, (546, 588): -v*w, (546,
        591): -u*v*w, (546, 595): -u*v**2, (546, 622): v**2*(u**2*w -
        2*u*v**2 - v*w)/w**2, (546, 632): -v**3/w, (546, 642): -v**2,
        (546, 643): -v**3, (546, 645): -2*u*v**2, (547, 77): -v, (547,
        163): u*v, (547, 238): v**2, (547, 239): -u**2*v/w, (547,
        319): -v**2*w, (547, 333): 1, (547, 334): -v, (547, 335): -v,
        (547, 342): -v**2/w, (547, 353): v**3, (547, 371): v**2*w,
        (547, 372): -v*w, (547, 373): v**2*(u*v - w), (547, 374):
        -v**2, (547, 375): -u*v*w, (547, 376): v**3, (547, 377):
        u*v**2*w, (547, 400): u*v**2, (547, 514): u**3*v/w, (547,
        537): u**2*v, (547, 553): -u*v/w, (547, 563): -u**2*v**2/w**2,
        (547, 591): -u*v*w, (547, 595): v*(u*v - w), (547, 616):
        u*v**2*w, (547, 622): u**2*v**2/w, (547, 639): -u*v**2/w,
        (547, 642): v**2, (547, 643): v**3, (547, 644): -v**2*(u**2 -
        v)/w, (548, 78): -v, (548, 82): -v, (548, 190): -v**2/w, (548,
        240): -u**2*v/w, (548, 306): 1, (548, 307): -v, (548, 319):
        -u*v**2, (548, 325): -u**2*v**2/w**2, (548, 335): -u*v/w,
        (548, 342): -v/w, (548, 372): -u*v, (548, 373): -u*v**2, (548,
        374): -v, (548, 375): -u**2*v, (548, 376): v**2, (548, 391):
        -u*v/w, (548, 404): -u**2*v, (548, 460): -u**2*v/w, (548,
        510): -u**2*v/w, (548, 555): -u*v/w, (548, 563): -u**2*v/w**2,
        (548, 564): -u**2*v**2/w**2, (548, 568): -u*v**2*(u*v +
        w)/w**2, (548, 578): -u*v**2/w, (548, 588): -u*v, (548, 589):
        -u*v**2, (548, 591): -2*u**2*v, (548, 595): -u*v*(u*v + w)/w,
        (548, 605): -u*v, (548, 607): -u*v, (548, 615): -u**2*v, (548,
        616): -u**2*v**2, (548, 618): -u**3*v, (548, 622):
        u*v**2*(u**2*w - u*v**2 - v*w)/w**3, (548, 632): -u*v**3/w**2,
        (548, 639): -u*v/w, (548, 644): -v*(u**2 - v)/w, (548, 645):
        -u**2*v**2/w, (549, 400): v*w**2, (549, 550): w, (549, 558):
        v, (550, 239): v, (550, 240): -v**2, (550, 380): v**4/w, (550,
        396): v, (550, 404): -v**2*w, (550, 434): v**3, (550, 487): v,
        (550, 505): v**2, (550, 507): v**3/w, (550, 509): v**4/w**2,
        (550, 536): v**3/w, (550, 541): v**2/w, (550, 545): 1, (550,
        546): -v, (550, 550): u, (550, 551): -v**2/w, (550, 559):
        v**3/w, (550, 561): v**4/w**2, (550, 563): -v**2*(u*v*w - v**3
        - w**2)/w**3, (550, 568): v**2*(u*w - v**2)/w, (550, 595):
        -v**3, (550, 622): v**2*(2*u*v*w - v**3 - w**2)/w**2, (550,
        644): v**2, (550, 645): -v**3, (551, 238): v*w, (551, 388): w,
        (551, 400): u*v*w, (551, 507): -u*v, (551, 508): -u*v**2,
        (551, 509): -v*(u*v + w)/w, (551, 541): -v**2/w, (551, 551):
        u, (551, 561): -u*v**2/w, (551, 562): -u*v**3/w, (551, 563):
        -v**2*(u*v + w)/w**2, (551, 568): u*v**2, (551, 595): u*v*w,
        (551, 622): -u*v*(u*w - v**2)/w, (551, 643): v**2*w, (552,
        238): u*v, (552, 241): v, (552, 325): v**2/w, (552, 383): 1,
        (552, 388): u, (552, 396): u*v/w, (552, 400): u**2*v, (552,
        403): u*v, (552, 460): v, (552, 552): u, (552, 568): u*v,
        (552, 622): u*v**2/w, (552, 643): u*v**2, (552, 646): v**2,
        (553, 239): -v, (553, 319): v*w**2, (553, 334): w, (553, 342):
        v, (553, 346): -u*v*w, (553, 353): -v**2*w, (553, 371):
        -v*w**2, (553, 373): -2*u*v**2*w, (553, 376): -v**2*w, (553,
        514): u*v, (553, 568): -v*w, (553, 616): -u*v*w**2, (553,
        622): -v**2, (553, 644): -v**2, (554, 164): -v**2, (554, 315):
        v, (554, 319): u*v*w, (554, 322): v*w, (554, 323): -v**2*w,
        (554, 329): 1, (554, 330): -v, (554, 334): u, (554, 335):
        -v**2/w, (554, 353): -2*u*v**2, (554, 370): -v*w, (554, 371):
        -u*v*w, (554, 373): -v**2*(u**2 - v), (554, 403): -u*v, (554,
        554): u, (554, 568): u*v*(u*v - w)/w, (554, 616): -u**2*v*w,
        (554, 619): -u*v*w, (554, 620): u*v**2*w, (554, 622):
        u*v**2*(u*v - w)/w**2, (554, 632): -u*v**2/w, (554, 640):
        v**2, (554, 642): v**3/w, (554, 645): v**2*(u*v - w)/w, (555,
        307): w, (555, 319): u*v*w, (555, 325): -v**2/w, (555, 335):
        u, (555, 460): -v, (555, 555): u, (555, 568): -u*v, (555,
        589): u*v*w, (555, 591): u**2*w, (555, 607): u*w, (555, 615):
        u**2*w, (555, 616): u**2*v*w, (555, 618): u**3*w, (555, 622):
        -u*v**2/w, (555, 632): u**2, (555, 642): -u*v, (555, 644):
        u**2 - v, (555, 645): -v*(u**2 - v), (556, 302): 1, (556,
        307): u, (556, 315): u*v/w, (556, 319): u**2*v, (556, 322):
        u*v, (556, 336): u, (556, 373): (u**2 - v)**2, (556, 400):
        2*u**2, (556, 454): u**3, (556, 556): u, (556, 569): u*v,
        (556, 587): u*w, (556, 589): 2*u**2*v, (556, 592): u*v, (556,
        596): u**2*v, (556, 608): u*w, (556, 611): u*v, (556, 614):
        u**2*w, (556, 616): 2*u**3*v, (556, 619): u**2*v, (557, 323):
        v*w**2, (557, 330): w, (557, 335): v, (557, 342): u, (557,
        376): -u*v*w, (557, 557): u, (557, 568): -u**2*v, (557, 596):
        -v**2*w, (557, 620): -u*v*w**2, (557, 622): -u**2*v**2/w,
        (557, 632): u*v, (557, 640): -v*w, (557, 642): -v**2, (557,
        645): -u*v**2, (558, 240): v*w, (558, 380): -v**3, (558, 404):
        v*w**2, (558, 434): -v**2*w, (558, 505): -v*w, (558, 507):
        -v**2, (558, 509): -v**3/w, (558, 536): -v**2, (558, 546): w,
        (558, 551): v, (558, 558): u, (558, 559): -v**2, (558, 561):
        -v**3/w, (558, 563): v**2*(u*w - v**2)/w**2, (558, 568):
        -v*(u*w - v**2), (558, 595): v**2*w, (558, 622): -v*(2*u*v*w -
        v**3 - w**2)/w, (558, 645): v**2*w, (559, 163): -v, (559,
        380): -u*v, (559, 509): -u*v/w, (559, 514): -u**2*v/w, (559,
        537): -u*v, (559, 561): -u*v/w, (559, 563): -u*v**2/w**2,
        (559, 585): -v, (559, 590): -u*v, (559, 595): -v**2, (559,
        616): -v**2*w, (559, 618): -u*v*w, (559, 622): -u*v**2/w,
        (559, 630): 1, (559, 631): -v, (559, 632): -v, (559, 633):
        v**2, (559, 634): -v, (559, 639): -v**2/w, (559, 642): -u*v,
        (559, 643): -u*v**2, (559, 644): -u*v**2/w, (560, 376):
        -u**2*v, (560, 401): -u*v/w, (560, 457): -u*v, (560, 560): u,
        (560, 568): -u*v**2/w, (560, 590): -v*(u*v - w)/w, (560, 591):
        -v**2, (560, 596): -u*v**2, (560, 611): -v**2, (560, 616):
        u*v*w, (560, 618): -u*v**2, (560, 619): -v*(u*v - w), (560,
        620): -v**2*w, (560, 622): -u*v**3/w**2, (560, 626): 1, (560,
        627): -v, (560, 628): -v, (560, 631): u, (560, 633): -u*v,
        (560, 634): -v**2/w, (560, 640): -u*v, (560, 642): -u*v**2/w,
        (560, 644): -v**2*(u*v - w)/w**2, (560, 645): -v**3/w, (561,
        514): -v, (561, 562): -u*v, (561, 563): -u*v/w, (561, 616):
        v*w**2, (561, 631): w, (561, 633): -v*w, (562, 562): u, (562,
        633): w, (563, 563): u, (563, 639): w, (564, 564): u, (564,
        568): u*v, (564, 578): w, (564, 622): u*v**2/w, (564, 632): v,
        (565, 565): u, (565, 568): u*v, (565, 591): v*w, (565, 620):
        v*w**2, (565, 622): u*v**2/w, (565, 627): w, (565, 639): u,
        (565, 645): v**2, (566, 190): u*v/w, (566, 325):
        2*u*v**2/w**2, (566, 460): u*v/w, (566, 566): u, (566, 568):
        3*u**2*v/w, (566, 578): u, (566, 588): v, (566, 591): u*v,
        (566, 596): v**2, (566, 606): u*w, (566, 614): v*w, (566,
        620): u*v*w, (566, 622): 4*u**2*v**2/w**2, (566, 625): 1,
        (566, 627): u, (566, 632): u*v/w, (566, 640): v, (566, 642):
        v**2/w, (566, 645): u*v**2/w, (567, 44): v**2/w, (567, 45):
        -v/w, (567, 71): -v/w, (567, 72): 1/w, (567, 105): -v, (567,
        130): -v**2*(u*v - w)/w**2, (567, 132): u*v/w, (567, 184):
        -v*(u*v - w)**2/w**2, (567, 187): -v**2*(u*v - w)/w**2, (567,
        241): v*(u*v - w)/w**2, (567, 596): v**3*(u*v - w)/w**2, (567,
        623): -v**2*(u*v - w)/w**2, (568, 536): -v/w, (568, 563): 1/w,
        (569, 569): u, (569, 584): 1, (569, 592): u, (569, 616): -u*v,
        (569, 643): u, (570, 29): v**2/w, (570, 56): -v/w, (570, 265):
        v**2, (570, 292): -u*v**2/w, (570, 319): -v, (570, 346):
        u*v/w, (570, 373): -u*v*(u**2 - v)*(u*v - w)/w**2, (570, 376):
        -u**2*v*(u*v - w)/w**2, (570, 400): -u*v*(u*v - w)/w**2, (570,
        428): 1, (570, 429): -v, (570, 430): -v, (570, 431): v**2,
        (570, 454): -u**2*v*(u*v - w)/w**2, (570, 455): -u/w, (570,
        456): u*v/w, (570, 457): -u*v*(u*v - w)/w**2, (570, 482):
        -u/w, (570, 484): u*v/w, (570, 509): u**2/w**2, (570, 589):
        -u**2*v**3/w**2, (570, 596): -u**2*v**3/w**2, (570, 611):
        -u*v**3/w**2, (570, 616): -u**2*v**2*(u*v - w)/w**2, (570,
        617): u*v/w, (570, 618): -u*v**2/w, (570, 619):
        -u**2*v**3/w**2, (570, 623): u**2*v**2/w**2, (570, 638):
        u*v**2/w**2, (570, 644): -u/w, (570, 645): u*v/w, (570, 646):
        u**2*v**2/w**2, (571, 1): 1, (571, 373): -u*v*(u**2*v - u*w -
        v**2)/w, (571, 376): -u*v*(u*v - w)/w, (571, 400): -u*v**2/w,
        (571, 454): -u*v*(u*v - w)/w, (571, 457): -u*v**2/w, (571,
        458): v**2, (571, 483): -v, (571, 485): v**2, (571, 510):
        u*v/w, (571, 511): u*v/w, (571, 512): -v, (571, 535):
        -u*v**2/w, (571, 562): u*v/w, (571, 589): -v**2*(u*v - w)/w,
        (571, 596): -u*v**3/w, (571, 611): -v**3/w, (571, 616):
        -v*(u*v - w)**2/w, (571, 619): -v**2*(u*v - w)/w, (571, 620):
        -v**3, (571, 623): u*v**2/w, (571, 638): v**2/w, (571, 646):
        v*(u*v - w)/w, (571, 647): v**2, (572, 292): -v*w, (572, 346):
        u*v, (572, 352): -v, (572, 377): -u*v*(u*v - w), (572, 379):
        1, (572, 454): -v**2, (572, 458): -u*v**2, (572, 488):
        -v**2/w, (572, 506): -v, (572, 508): -u*v**2/w, (572, 511):
        -v**2/w, (572, 514): u*v/w, (572, 541): -u/w, (572, 568): -v,
        (572, 620): v**2*w, (572, 647): -v*w, (573, 244): -v, (573,
        271): u*v/w, (573, 298): 1, (573, 325): -u/w, (573, 373):
        u*v*(u*v - w)/w, (573, 454): v*(u*v - w)/w, (573, 511): -v/w,
        (573, 595): u*(u*v - w)/w, (573, 596): v**3/w, (573, 614):
        v**2, (573, 620): u*v**2, (573, 623): -v**2/w, (573, 641): -v,
        (573, 647): -u*v, (574, 265): -v*w, (574, 319): u*v, (574,
        373): u*v, (574, 377): -u**2*v*(u*v - w)/w, (574, 400):
        -u**2*v/w, (574, 429): w, (574, 431): -v*w, (574, 434):
        v**2/w, (574, 454): -u*v**2/w, (574, 456): -u, (574, 458):
        -u*v*(u*v - w)/w, (574, 483): -u, (574, 485): u*v, (574, 488):
        -v/w, (574, 510): u**2/w, (574, 589): u*v, (574, 596):
        -v**3/w, (574, 618): u*v, (574, 623): v**2/w, (574, 645): -u,
        (575, 244): -u*v/w, (575, 265): -u*v, (575, 271): u**2*v/w**2,
        (575, 298): u/w, (575, 319): u**2*v/w, (575, 325): -u**2/w**2,
        (575, 425): -v, (575, 426): 1, (575, 429): u, (575, 431):
        -u*v, (575, 453): -u/w, (575, 454): -u*v/w, (575, 456):
        -u**2/w, (575, 461): -v/w, (575, 582): -u*v/w, (575, 595):
        u**2*(u*v - w)/w**2, (575, 615): u*v/w, (575, 618): u**2*v/w,
        (575, 620): u**2*v**2/w, (575, 642): -u/w, (575, 645):
        -u**2/w, (575, 647): -u**2*v/w, (576, 163): -v, (576, 217): 1,
        (576, 514): -v**2/w, (576, 541): v/w, (576, 595): -v**2, (576,
        622): v, (577, 377): v*(u*v - w), (577, 458): v**2, (577,
        509): v**2/w**2, (577, 514): -v/w, (577, 541): 1/w, (577,
        595): -v, (577, 622): u*v/w, (578, 136): -v, (578, 190): 1,
        (578, 271): -v**2/w, (578, 325): v/w, (578, 536): u*v**2/w**2,
        (578, 537): v**2/w, (578, 563): -u*v/w**2, (578, 564): -v/w,
        (578, 568): u, (578, 595): -u*v**2/w, (578, 622): u*v/w, (579,
        271): -v/w, (579, 325): 1/w, (579, 508): -v/w, (579, 595):
        -u*v/w, (579, 622): u/w, (580, 265): w**2, (580, 292): -u*w,
        (580, 319): -u*w, (580, 346): u**2, (580, 373): -u*w, (580,
        400): u**2, (580, 434): -v, (580, 535): u**2, (580, 562):
        -u**3/w, (580, 589): -u*w, (581, 110): -v/w, (581, 265): u*w,
        (581, 268): w, (581, 269): -v*w, (581, 319): -u**2, (581,
        322): -u, (581, 323): u*v, (581, 373): -u**2, (581, 376): -u,
        (581, 377): u**2*v**2/w, (581, 400): u**3/w, (581, 403):
        u**2/w, (581, 404): -u**2*v/w, (581, 434): -u*v/w, (581, 454):
        u**2*v/w, (581, 457): u*v/w, (581, 589): -u**2, (581, 592):
        -u, (581, 593): u*v, (582, 265): u*w, (582, 319): -u**2, (582,
        373): u**2*(u*v - w)/w, (582, 425): w, (582, 431): u*w, (582,
        454): u**2*v/w, (582, 582): u, (582, 596): u*v**2/w, (582,
        614): u*v, (582, 623): -u*v/w, (582, 641): -u, (583, 265):
        u**2, (583, 268): u, (583, 269): -u*v, (583, 271): -u*v/w**2,
        (583, 319): -u**3/w, (583, 322): -u**2/w, (583, 323): u, (583,
        325): u/w**2, (583, 377): u**2*v/w, (583, 404): -u**2/w, (583,
        407): u*v/w, (583, 424): 1, (583, 425): u, (583, 583): u,
        (583, 589): u**3/w, (583, 595): -u**2*v/w**2, (583, 622):
        u**2/w**2, (584, 269): w**2, (584, 323): -u*w, (584, 377):
        -u*w, (584, 404): u**2, (584, 458): u*v, (584, 569): -v, (584,
        593): -u*w, (585, 509): -v/w, (585, 595): w, (585, 622): -u,
        (586, 373): -u*v**2/w, (586, 400): u*v/w, (586, 483): 1, (586,
        485): -v, (586, 510): -u/w, (586, 589): v*(u*v - w)/w, (586,
        596): u*v**2/w, (586, 611): v**2/w, (586, 616): u*v*(u*v -
        w)/w, (586, 619): u*v**2/w, (586, 623): -u*v/w, (586, 638):
        -v/w, (586, 646): -u*v/w, (587, 373): u**2*v/w, (587, 376):
        u*v/w, (587, 400): -u**2/w, (587, 403): -u/w, (587, 569):
        -u*v/w, (587, 584): -v/w, (587, 589): u, (587, 592): (-u*v +
        w)/w, (587, 593): -v, (587, 616): u*v**2/w, (587, 643):
        -u*v/w, (588, 373): u*v, (588, 377): v**2, (588, 400): -u,
        (588, 404): -v, (588, 535): -u, (588, 562): u**2/w, (588,
        589): w, (589, 377): -v, (589, 404): 1, (590, 373): -v**2,
        (590, 400): v, (590, 481): w, (591, 373): -v, (591, 400): 1,
        (592, 377): u*v, (592, 404): -u, (592, 593): w, (593, 373):
        -u*v/w, (593, 400): u/w, (593, 569): v/w, (593, 587): 1, (593,
        593): u, (594, 17): -v/w, (594, 18): 1/w, (594, 44): -u*v/w,
        (594, 45): u/w, (594, 130): u*v*(u*v - w)/w**2, (594, 133):
        v*(u*v - w)/w**2, (594, 159): -v, (594, 184): v*(u**2 -
        v)*(u*v - w)/w**2, (594, 186): u*v/w, (594, 187): u*v*(u*v -
        w)/w**2, (594, 238): v*(u*v - w)/w**2, (594, 569): -v**2*(u*v
        - w)/w**2, (594, 596): -u*v**2*(u*v - w)/w**2, (595, 509):
        1/w, (595, 536): u/w, (596, 589): u, (596, 596): u, (596,
        611): 1, (596, 616): u**2, (596, 619): u, (597, 2): -v/w,
        (597, 29): -u*v/w, (597, 265): -u*v, (597, 266): 1, (597,
        267): -v, (597, 268): -v, (597, 269): v**2, (597, 292):
        u**2*v/w, (597, 293): -u/w, (597, 295): u*v/w, (597, 373):
        u**2*v*(u**3 - 2*u*v + 2*w)/w**2, (597, 374): -u/w, (597,
        375): u*v/w, (597, 376): u*v*(u**3 - u*v + w)/w**2, (597,
        400): u**3*v/w**2, (597, 403): u**2*v/w**2, (597, 427): -v,
        (597, 454): u*v*(u**3 - u*v + w)/w**2, (597, 457):
        u**3*v/w**2, (597, 481): u*v/w, (597, 536): u**2/w**2, (597,
        569): u**2*v**2/w**2, (597, 584): u*v**2/w**2, (597, 589):
        u**3*v**2/w**2, (597, 590): -u/w, (597, 591): u*v/w, (597,
        592): u**2*v**2/w**2, (597, 596): u**3*v**2/w**2, (597, 611):
        u**2*v**2/w**2, (597, 616): u**2*v**2*(u**2 - v)/w**2, (597,
        617): -u**2/w, (597, 618): u**2*v/w, (597, 619):
        u**3*v**2/w**2, (597, 643): u**2*v**2/w**2, (598, 28): 1,
        (598, 294): -v, (598, 296): v**2, (598, 373): u*v*(u**3 -
        2*u*v + w)/w, (598, 376): u*v*(u**2 - v)/w, (598, 377): v**2,
        (598, 400): u**2*v/w, (598, 403): u*v/w, (598, 454): u*v*(u**2
        - v)/w, (598, 457): u**2*v/w, (598, 508): u*v/w, (598, 535):
        u**2*v/w, (598, 537): u*v/w, (598, 538): u*v/w, (598, 539):
        -v, (598, 569): u*v**2/w, (598, 584): v**2/w, (598, 589):
        u*v*(u*v - w)/w, (598, 592): v*(u*v - w)/w, (598, 593): v**2,
        (598, 596): u**2*v**2/w, (598, 611): u*v**2/w, (598, 616):
        v*(u**2 - v)*(u*v - w)/w, (598, 619): u*v*(u*v - w)/w, (598,
        620): u*v**2, (598, 643): v*(u*v - w)/w, (599, 346): -v, (599,
        352): u, (599, 373): -v**2, (599, 377): u*v*(u**2 - v), (599,
        404): u*v, (599, 433): 1, (599, 458): u**2*v, (599, 487):
        -u/w, (599, 514): -u**2/w, (599, 515): -v**2/w, (599, 533):
        -v, (599, 535): -u*v**2/w, (599, 538): -v**2/w, (599, 593):
        -v*w, (599, 595): -v, (599, 620): -u*v*w, (600, 244): u, (600,
        271): -u**2/w, (600, 373): -v*(u**3 - u*v + w)/w, (600, 400):
        -u*v/w, (600, 406): 1, (600, 454): -u**2*v/w, (600, 460):
        -u/w, (600, 538): -v/w, (600, 568): -u**2/w, (600, 569):
        -v**2/w, (600, 587): -v, (600, 593): -u*v, (600, 595):
        -u**3/w, (600, 596): -u*v**2/w, (600, 614): -u*v, (600, 620):
        -u**2*v, (600, 622): -u/w, (601, 267): w, (601, 269): -v*w,
        (601, 294): -u, (601, 296): u*v, (601, 319): -v, (601, 353):
        v**2/w, (601, 373): -u*v**2/w, (601, 375): -u, (601, 377):
        u*v*(u**3 - u*v + w)/w, (601, 400): u*v/w, (601, 404):
        u**2*v/w, (601, 458): u**3*v/w, (601, 515): -v/w, (601, 537):
        u**2/w, (601, 569): v**2/w, (601, 591): -u, (601, 596):
        u*v**2/w, (601, 616): u*v, (601, 618): -u**2, (602, 244):
        u**2/w, (602, 263): -v, (602, 264): 1, (602, 267): u, (602,
        269): -u*v, (602, 271): -u**3/w**2, (602, 272): -v/w, (602,
        319): -u*v/w, (602, 372): -u/w, (602, 373): -u*v/w, (602,
        375): -u**2/w, (602, 406): u/w, (602, 460): -u**2/w**2, (602,
        568): -u**3/w**2, (602, 588): -u/w, (602, 591): -u**2/w, (602,
        593): -u**2*v/w, (602, 595): -u**4/w**2, (602, 609): -u*v/w,
        (602, 615): -u**2/w, (602, 618): -u**3/w, (602, 620):
        -u**3*v/w, (602, 622): -u**2/w**2, (603, 109): 1, (603, 163):
        u, (603, 487): v/w, (603, 514): u*v/w, (603, 568): v, (603,
        595): u*v, (604, 377): -v*(u**2 - v), (604, 404): -v, (604,
        458): -u*v, (604, 487): 1/w, (604, 514): u/w, (604, 536):
        v**2/w**2, (604, 622): -v/w, (605, 82): 1, (605, 136): u,
        (605, 271): u*v/w, (605, 460): v/w, (605, 509): -u*v/w**2,
        (605, 510): -v/w, (605, 536): -u**2*v/w**2, (605, 537):
        -u*v/w, (605, 568): u*v/w, (605, 595): u*(u*v + w)/w, (606,
        271): u/w, (606, 460): 1/w, (606, 535): -v/w, (606, 568): u/w,
        (606, 595): u**2/w, (607, 319): w, (607, 346): -u, (607, 353):
        -v, (607, 400): -u, (607, 562): u**2/w, (607, 616): -u*w,
        (608, 164): -v/w, (608, 319): u, (608, 322): 1, (608, 323):
        -v, (608, 353): -u*v/w, (608, 373): u**2*v/w, (608, 376):
        u*v/w, (608, 377): -u**3*v/w, (608, 400): -u**2/w, (608, 403):
        -u/w, (608, 458): -u**2*v/w, (608, 616): -u**2, (608, 619):
        -u, (608, 620): u*v, (609, 263): w, (609, 269): u*w, (609,
        319): u, (609, 373): -u**2*(u**2 - v)/w, (609, 400): -u**2/w,
        (609, 454): -u**3/w, (609, 569): -u*v/w, (609, 587): -u, (609,
        596): -u**2*v/w, (609, 609): u, (609, 614): -u**2, (610, 245):
        u*v/w, (610, 262): 1, (610, 263): u, (610, 269): u**2, (610,
        271): u**2/w**2, (610, 319): u**2/w, (610, 322): u/w, (610,
        377): -u**3/w, (610, 431): u, (610, 458): -u**2/w, (610, 460):
        u/w**2, (610, 568): u**2/w**2, (610, 595): u**3/w**2, (610,
        610): u, (610, 616): u**3/w, (611, 323): w, (611, 377): u*v,
        (611, 404): -u, (611, 596): -v, (611, 620): -u*w, (612, 536):
        -v/w, (612, 622): 1, (613, 294): 1, (613, 296): -v, (613,
        373): u**2*v/w, (613, 454): u*v/w, (613, 537): -u/w, (613,
        569): -u*v/w, (613, 584): -v/w, (613, 589): -u**2*v/w, (613,
        592): -u*v/w, (613, 596): -u**2*v/w, (613, 611): -u*v/w, (613,
        616): -v*(u**3 - u*v + w)/w, (613, 619): -u**2*v/w, (613,
        643): -u*v/w, (614, 373): -u**3/w, (614, 376): -u**2/w, (614,
        454): -u**2/w, (614, 457): -u/w, (614, 589): -u*v/w, (614,
        596): -u*v/w, (614, 611): -v/w, (614, 616): -u*(u*v - w)/w,
        (614, 619): (-u*v + w)/w, (614, 620): -v, (615, 373): -u**2,
        (615, 377): -u*v, (615, 454): -u, (615, 458): -v, (615, 562):
        -u/w, (615, 616): w, (616, 377): u, (616, 458): 1, (617, 292):
        w, (617, 373): u*v, (617, 454): v, (618, 373): u, (618, 454):
        1, (619, 377): -u**2, (619, 458): -u, (619, 620): w, (620,
        373): u**2/w, (620, 454): u/w, (620, 596): v/w, (620, 614): 1,
        (620, 620): u, (621, 44): -v, (621, 45): 1, (621, 130): v*(u*v
        - w)/w, (621, 184): u*v*(u*v - w)/w, (621, 187): v*(u*v -
        w)/w, (621, 213): -v, (621, 240): u*v/w, (621, 596):
        -v**2*(u*v - w)/w, (622, 536): 1, (623, 616): u*w, (623, 623):
        u, (623, 638): 1, (623, 646): u, (624, 29): -v, (624, 265):
        -v*w, (624, 292): u*v, (624, 320): 1, (624, 321): -v, (624,
        322): -v, (624, 323): v**2, (624, 347): -u/w, (624, 349):
        u*v/w, (624, 373): u*v*(u**3 - u*v + w)/w, (624, 376):
        u**3*v/w, (624, 400): u**2*v/w, (624, 401): -u/w, (624, 402):
        u*v/w, (624, 403): u*v/w, (624, 454): u**3*v/w, (624, 457):
        u**2*v/w, (624, 563): u**2/w**2, (624, 589): u**2*v**2/w,
        (624, 596): u**2*v**2/w, (624, 611): u*v**2/w, (624, 616):
        u**3*v**2/w, (624, 617): -u, (624, 618): u*v, (624, 619):
        u**2*v**2/w, (625, 55): 1, (625, 348): -v, (625, 350): v**2,
        (625, 373): u*v*(u**2 - v), (625, 376): u**2*v, (625, 400):
        u*v, (625, 404): v**2, (625, 454): u**2*v, (625, 457): u*v,
        (625, 535): u*v, (625, 564): u*v/w, (625, 565): u*v/w, (625,
        566): -v, (625, 589): v*(u*v - w), (625, 596): u*v**2, (625,
        611): v**2, (625, 616): u*v*(u*v - w), (625, 619): v*(u*v -
        w), (625, 620): v**2*w, (626, 346): -v**2, (626, 352): w,
        (626, 377): u**2*v*w, (626, 400): -v**2, (626, 458): u*v*w,
        (626, 481): -v*w, (626, 514): -u, (626, 542): -v**2/w, (626,
        560): -v, (626, 562): -u*v**2/w, (626, 565): -v**2/w, (626,
        620): -v*w**2, (626, 622): -v, (627, 244): w, (627, 271): -u,
        (627, 373): -u**2*v, (627, 400): -v, (627, 454): -u*v, (627,
        565): -v/w, (627, 568): -u, (627, 595): -u**2, (627, 596):
        -v**2, (627, 614): -v*w, (627, 620): -u*v*w, (627, 622):
        -u*v/w, (628, 319): -v**2, (628, 321): w, (628, 323): -v*w,
        (628, 348): -u, (628, 350): u*v, (628, 377): u**3*v, (628,
        380): v**2/w, (628, 402): -u, (628, 404): u*v, (628, 427):
        -v*w, (628, 454): u*v, (628, 458): u**2*v, (628, 542): -v/w,
        (628, 564): u**2/w, (628, 596): v**2, (628, 618): -u*w, (628,
        643): u*v, (629, 244): u, (629, 271): -u**2/w, (629, 317): -v,
        (629, 318): 1, (629, 319): -u*v**2/w, (629, 321): u, (629,
        323): -u*v, (629, 326): -v/w, (629, 399): -u/w, (629, 400):
        -u*v/w, (629, 402): -u**2/w, (629, 427): -u*v, (629, 568):
        -u**2/w, (629, 595): -u**3/w, (629, 615): -u, (629, 618):
        -u**2, (629, 620): -u**2*v, (629, 622): -u**2*v/w**2, (629,
        636): -u*v/w, (630, 163): w, (630, 514): v, (630, 595): v*w,
        (631, 377): -u*v*w, (631, 458): -v*w, (631, 514): 1, (631,
        563): v**2/w**2, (631, 568): -v, (631, 622): -v**2/w, (632,
        136): w, (632, 271): v, (632, 536): -u*v/w, (632, 537): -v,
        (632, 595): u*v, (632, 622): u, (633, 271): 1, (633, 562):
        -v/w, (633, 595): u, (634, 319): v*w, (634, 346): -u*v, (634,
        380): -v, (634, 400): -u*v, (634, 427): w**2, (634, 454):
        -u*w, (634, 481): -u*w, (634, 508): u**2, (634, 562):
        u**2*v/w, (634, 643): -u*w, (635, 218): -v/w, (635, 319): u*v,
        (635, 322): v, (635, 323): -v**2, (635, 377): -u**2*v, (635,
        380): -u*v/w, (635, 427): u*w, (635, 430): w, (635, 431):
        -v*w, (635, 454): -u**2, (635, 457): -u, (635, 643): -u**2,
        (635, 646): -u, (635, 647): u*v, (636, 317): w, (636, 319):
        u*v, (636, 323): u*w, (636, 373): -u**3, (636, 427): u*w,
        (636, 454): -u**2, (636, 596): -u*v, (636, 614): -u*w, (636,
        636): u, (637, 269): u*w, (637, 271): u/w, (637, 299): u*v/w,
        (637, 316): 1, (637, 317): u, (637, 319): u**2*v/w, (637,
        322): u*v/w, (637, 377): -u**2, (637, 427): u**2, (637, 430):
        u, (637, 595): u**2/w, (637, 637): u, (637, 643): u**3/w,
        (638, 323): v*w, (638, 431): w**2, (638, 458): -u*w, (638,
        623): -v, (638, 647): -u*w, (639, 563): -v/w, (639, 568): w,
        (639, 622): v, (640, 348): 1, (640, 350): -v, (640, 373): u*v,
        (640, 564): -u/w, (640, 589): -u*v, (640, 596): -u*v, (640,
        611): -v, (640, 616): -u**2*v, (640, 619): -u*v, (640, 643):
        -v, (641, 373): -u**2, (641, 376): -u, (641, 616): -u*v, (641,
        623): -u*v/w, (641, 638): -v/w, (641, 643): u, (641, 646):
        (-u*v + w)/w, (641, 647): -v, (642, 373): -u*w, (642, 377):
        -v*w, (642, 508): -u, (642, 562): -u*v/w, (642, 643): w, (643,
        377): w, (644, 346): w, (644, 373): v*w, (645, 373): w, (646,
        377): -u*w, (646, 647): w, (647, 373): u, (647, 623): v/w,
        (647, 641): 1, (647, 647): u}]], [[{(0, 27): 1, (0, 54): -u/w,
        (1, 28): 1, (1, 55): -u/w, (2, 29): 1, (2, 56): -u/w, (3, 30):
        1, (3, 57): -u/w, (4, 31): 1, (4, 58): -u/w, (5, 32): 1, (5,
        59): -u/w, (6, 33): 1, (6, 60): -u/w, (7, 34): 1, (7, 61):
        -u/w, (8, 35): 1, (8, 62): -u/w, (9, 36): 1, (9, 63): -u/w,
        (10, 37): 1, (10, 64): -u/w, (11, 38): 1, (11, 65): -u/w, (12,
        39): 1, (12, 66): -u/w, (13, 40): 1, (13, 67): -u/w, (14, 41):
        1, (14, 68): -u/w, (15, 42): 1, (15, 69): -u/w, (16, 43): 1,
        (16, 70): -u/w, (17, 44): 1, (17, 71): -u/w, (18, 45): 1, (18,
        72): -u/w, (19, 46): 1, (19, 73): -u/w, (20, 47): 1, (20, 74):
        -u/w, (21, 48): 1, (21, 75): -u/w, (22, 49): 1, (22, 76):
        -u/w, (23, 50): 1, (23, 77): -u/w, (24, 51): 1, (24, 78):
        -u/w, (25, 52): 1, (25, 79): -u/w, (26, 53): 1, (26, 80):
        -u/w, (27, 54): 1/w, (28, 55): 1/w, (29, 56): 1/w, (30, 57):
        1/w, (31, 58): 1/w, (32, 59): 1/w, (33, 60): 1/w, (34, 61):
        1/w, (35, 62): 1/w, (36, 63): 1/w, (37, 64): 1/w, (38, 65):
        1/w, (39, 66): 1/w, (40, 67): 1/w, (41, 68): 1/w, (42, 69):
        1/w, (43, 70): 1/w, (44, 71): 1/w, (45, 72): 1/w, (46, 73):
        1/w, (47, 74): 1/w, (48, 75): 1/w, (49, 76): 1/w, (50, 77):
        1/w, (51, 78): 1/w, (52, 79): 1/w, (53, 80): 1/w, (54, 0): 1,
        (54, 54): v/w, (55, 1): 1, (55, 55): v/w, (56, 2): 1, (56,
        56): v/w, (57, 3): 1, (57, 57): v/w, (58, 4): 1, (58, 58):
        v/w, (59, 5): 1, (59, 59): v/w, (60, 6): 1, (60, 60): v/w,
        (61, 7): 1, (61, 61): v/w, (62, 8): 1, (62, 62): v/w, (63, 9):
        1, (63, 63): v/w, (64, 10): 1, (64, 64): v/w, (65, 11): 1,
        (65, 65): v/w, (66, 12): 1, (66, 66): v/w, (67, 13): 1, (67,
        67): v/w, (68, 14): 1, (68, 68): v/w, (69, 15): 1, (69, 69):
        v/w, (70, 16): 1, (70, 70): v/w, (71, 17): 1, (71, 71): v/w,
        (72, 18): 1, (72, 72): v/w, (73, 19): 1, (73, 73): v/w, (74,
        20): 1, (74, 74): v/w, (75, 21): 1, (75, 75): v/w, (76, 22):
        1, (76, 76): v/w, (77, 23): 1, (77, 77): v/w, (78, 24): 1,
        (78, 78): v/w, (79, 25): 1, (79, 79): v/w, (80, 26): 1, (80,
        80): v/w, (81, 135): 1, (81, 189): -u/w, (82, 136): 1, (82,
        190): -u/w, (83, 137): 1, (83, 191): -u/w, (84, 138): 1, (84,
        192): -u/w, (85, 139): 1, (85, 193): -u/w, (86, 140): 1, (86,
        194): -u/w, (87, 141): 1, (87, 195): -u/w, (88, 142): 1, (88,
        196): -u/w, (89, 143): 1, (89, 197): -u/w, (90, 144): 1, (90,
        198): -u/w, (91, 145): 1, (91, 199): -u/w, (92, 146): 1, (92,
        200): -u/w, (93, 147): 1, (93, 201): -u/w, (94, 148): 1, (94,
        202): -u/w, (95, 149): 1, (95, 203): -u/w, (96, 150): 1, (96,
        204): -u/w, (97, 151): 1, (97, 205): -u/w, (98, 152): 1, (98,
        206): -u/w, (99, 153): 1, (99, 207): -u/w, (100, 154): 1,
        (100, 208): -u/w, (101, 155): 1, (101, 209): -u/w, (102, 156):
        1, (102, 210): -u/w, (103, 157): 1, (103, 211): -u/w, (104,
        158): 1, (104, 212): -u/w, (105, 159): 1, (105, 213): -u/w,
        (106, 160): 1, (106, 214): -u/w, (107, 161): 1, (107, 215):
        -u/w, (108, 162): 1, (108, 216): -u/w, (109, 163): 1, (109,
        217): -u/w, (110, 164): 1, (110, 218): -u/w, (111, 165): 1,
        (111, 219): -u/w, (112, 166): 1, (112, 220): -u/w, (113, 167):
        1, (113, 221): -u/w, (114, 168): 1, (114, 222): -u/w, (115,
        169): 1, (115, 223): -u/w, (116, 170): 1, (116, 224): -u/w,
        (117, 171): 1, (117, 225): -u/w, (118, 172): 1, (118, 226):
        -u/w, (119, 173): 1, (119, 227): -u/w, (120, 174): 1, (120,
        228): -u/w, (121, 175): 1, (121, 229): -u/w, (122, 176): 1,
        (122, 230): -u/w, (123, 177): 1, (123, 231): -u/w, (124, 178):
        1, (124, 232): -u/w, (125, 179): 1, (125, 233): -u/w, (126,
        180): 1, (126, 234): -u/w, (127, 181): 1, (127, 235): -u/w,
        (128, 182): 1, (128, 236): -u/w, (129, 183): 1, (129, 237):
        -u/w, (130, 184): 1, (130, 238): -u/w, (131, 185): 1, (131,
        239): -u/w, (132, 186): 1, (132, 240): -u/w, (133, 187): 1,
        (133, 241): -u/w, (134, 188): 1, (134, 242): -u/w, (135, 189):
        1/w, (136, 190): 1/w, (137, 191): 1/w, (138, 192): 1/w, (139,
        193): 1/w, (140, 194): 1/w, (141, 195): 1/w, (142, 196): 1/w,
        (143, 197): 1/w, (144, 198): 1/w, (145, 199): 1/w, (146, 200):
        1/w, (147, 201): 1/w, (148, 202): 1/w, (149, 203): 1/w, (150,
        204): 1/w, (151, 205): 1/w, (152, 206): 1/w, (153, 207): 1/w,
        (154, 208): 1/w, (155, 209): 1/w, (156, 210): 1/w, (157, 211):
        1/w, (158, 212): 1/w, (159, 213): 1/w, (160, 214): 1/w, (161,
        215): 1/w, (162, 216): 1/w, (163, 217): 1/w, (164, 218): 1/w,
        (165, 219): 1/w, (166, 220): 1/w, (167, 221): 1/w, (168, 222):
        1/w, (169, 223): 1/w, (170, 224): 1/w, (171, 225): 1/w, (172,
        226): 1/w, (173, 227): 1/w, (174, 228): 1/w, (175, 229): 1/w,
        (176, 230): 1/w, (177, 231): 1/w, (178, 232): 1/w, (179, 233):
        1/w, (180, 234): 1/w, (181, 235): 1/w, (182, 236): 1/w, (183,
        237): 1/w, (184, 238): 1/w, (185, 239): 1/w, (186, 240): 1/w,
        (187, 241): 1/w, (188, 242): 1/w, (189, 81): 1, (189, 189):
        v/w, (190, 82): 1, (190, 190): v/w, (191, 83): 1, (191, 191):
        v/w, (192, 84): 1, (192, 192): v/w, (193, 85): 1, (193, 193):
        v/w, (194, 86): 1, (194, 194): v/w, (195, 87): 1, (195, 195):
        v/w, (196, 88): 1, (196, 196): v/w, (197, 89): 1, (197, 197):
        v/w, (198, 90): 1, (198, 198): v/w, (199, 91): 1, (199, 199):
        v/w, (200, 92): 1, (200, 200): v/w, (201, 93): 1, (201, 201):
        v/w, (202, 94): 1, (202, 202): v/w, (203, 95): 1, (203, 203):
        v/w, (204, 96): 1, (204, 204): v/w, (205, 97): 1, (205, 205):
        v/w, (206, 98): 1, (206, 206): v/w, (207, 99): 1, (207, 207):
        v/w, (208, 100): 1, (208, 208): v/w, (209, 101): 1, (209,
        209): v/w, (210, 102): 1, (210, 210): v/w, (211, 103): 1,
        (211, 211): v/w, (212, 104): 1, (212, 212): v/w, (213, 105):
        1, (213, 213): v/w, (214, 106): 1, (214, 214): v/w, (215,
        107): 1, (215, 215): v/w, (216, 108): 1, (216, 216): v/w,
        (217, 109): 1, (217, 217): v/w, (218, 110): 1, (218, 218):
        v/w, (219, 111): 1, (219, 219): v/w, (220, 112): 1, (220,
        220): v/w, (221, 113): 1, (221, 221): v/w, (222, 114): 1,
        (222, 222): v/w, (223, 115): 1, (223, 223): v/w, (224, 116):
        1, (224, 224): v/w, (225, 117): 1, (225, 225): v/w, (226,
        118): 1, (226, 226): v/w, (227, 119): 1, (227, 227): v/w,
        (228, 120): 1, (228, 228): v/w, (229, 121): 1, (229, 229):
        v/w, (230, 122): 1, (230, 230): v/w, (231, 123): 1, (231,
        231): v/w, (232, 124): 1, (232, 232): v/w, (233, 125): 1,
        (233, 233): v/w, (234, 126): 1, (234, 234): v/w, (235, 127):
        1, (235, 235): v/w, (236, 128): 1, (236, 236): v/w, (237,
        129): 1, (237, 237): v/w, (238, 130): 1, (238, 238): v/w,
        (239, 131): 1, (239, 239): v/w, (240, 132): 1, (240, 240):
        v/w, (241, 133): 1, (241, 241): v/w, (242, 134): 1, (242,
        242): v/w, (243, 297): 1/w, (244, 298): 1/w, (245, 299): 1/w,
        (246, 300): 1/w, (247, 301): 1/w, (248, 302): 1/w, (249, 303):
        1/w, (250, 304): 1/w, (251, 305): 1/w, (252, 306): 1/w, (253,
        307): 1/w, (254, 308): 1/w, (255, 309): 1/w, (256, 310): 1/w,
        (257, 311): 1/w, (258, 312): 1/w, (259, 313): 1/w, (260, 314):
        1/w, (261, 315): 1/w, (262, 316): 1/w, (263, 317): 1/w, (264,
        318): 1/w, (265, 319): 1/w, (266, 320): 1/w, (267, 321): 1/w,
        (268, 322): 1/w, (269, 323): 1/w, (270, 324): 1/w, (271, 325):
        1/w, (272, 326): 1/w, (273, 327): 1/w, (274, 328): 1/w, (275,
        329): 1/w, (276, 330): 1/w, (277, 331): 1/w, (278, 332): 1/w,
        (279, 333): 1/w, (280, 334): 1/w, (281, 335): 1/w, (282, 336):
        1/w, (283, 337): 1/w, (284, 338): 1/w, (285, 339): 1/w, (286,
        340): 1/w, (287, 341): 1/w, (288, 342): 1/w, (289, 343): 1/w,
        (290, 344): 1/w, (291, 345): 1/w, (292, 346): 1/w, (293, 347):
        1/w, (294, 348): 1/w, (295, 349): 1/w, (296, 350): 1/w, (297,
        297): v/w, (297, 405): 1, (298, 298): v/w, (298, 406): 1,
        (299, 299): v/w, (299, 407): 1, (300, 300): v/w, (300, 408):
        1, (301, 301): v/w, (301, 409): 1, (302, 302): v/w, (302,
        410): 1, (303, 303): v/w, (303, 411): 1, (304, 304): v/w,
        (304, 412): 1, (305, 305): v/w, (305, 413): 1, (306, 306):
        v/w, (306, 414): 1, (307, 307): v/w, (307, 415): 1, (308,
        308): v/w, (308, 416): 1, (309, 309): v/w, (309, 417): 1,
        (310, 310): v/w, (310, 418): 1, (311, 311): v/w, (311, 419):
        1, (312, 312): v/w, (312, 420): 1, (313, 313): v/w, (313,
        421): 1, (314, 314): v/w, (314, 422): 1, (315, 315): v/w,
        (315, 423): 1, (316, 316): v/w, (316, 424): 1, (317, 317):
        v/w, (317, 425): 1, (318, 318): v/w, (318, 426): 1, (319,
        319): v/w, (319, 427): 1, (320, 320): v/w, (320, 428): 1,
        (321, 321): v/w, (321, 429): 1, (322, 322): v/w, (322, 430):
        1, (323, 323): v/w, (323, 431): 1, (324, 324): v/w, (324,
        459): 1, (325, 325): v/w, (325, 460): 1, (326, 326): v/w,
        (326, 461): 1, (327, 327): v/w, (327, 462): 1, (328, 328):
        v/w, (328, 463): 1, (329, 329): v/w, (329, 464): 1, (330,
        330): v/w, (330, 465): 1, (331, 331): v/w, (331, 466): 1,
        (332, 332): v/w, (332, 467): 1, (333, 333): v/w, (333, 468):
        1, (334, 334): v/w, (334, 469): 1, (335, 335): v/w, (335,
        470): 1, (336, 336): v/w, (336, 471): 1, (337, 337): v/w,
        (337, 472): 1, (338, 338): v/w, (338, 473): 1, (339, 339):
        v/w, (339, 474): 1, (340, 340): v/w, (340, 475): 1, (341,
        341): v/w, (341, 476): 1, (342, 342): v/w, (342, 477): 1,
        (343, 343): v/w, (343, 478): 1, (344, 344): v/w, (344, 479):
        1, (345, 345): v/w, (345, 480): 1, (346, 346): v/w, (346,
        481): 1, (347, 347): v/w, (347, 482): 1, (348, 348): v/w,
        (348, 483): 1, (349, 349): v/w, (349, 484): 1, (350, 350):
        v/w, (350, 485): 1, (351, 378): 1/w, (352, 379): 1/w, (353,
        380): 1/w, (354, 381): 1/w, (355, 382): 1/w, (356, 383): 1/w,
        (357, 384): 1/w, (358, 385): 1/w, (359, 386): 1/w, (360, 387):
        1/w, (361, 388): 1/w, (362, 389): 1/w, (363, 390): 1/w, (364,
        391): 1/w, (365, 392): 1/w, (366, 393): 1/w, (367, 394): 1/w,
        (368, 395): 1/w, (369, 396): 1/w, (370, 397): 1/w, (371, 398):
        1/w, (372, 399): 1/w, (373, 400): 1/w, (374, 401): 1/w, (375,
        402): 1/w, (376, 403): 1/w, (377, 404): 1/w, (378, 378): v/w,
        (378, 432): 1, (379, 379): v/w, (379, 433): 1, (380, 380):
        v/w, (380, 434): 1, (381, 381): v/w, (381, 435): 1, (382,
        382): v/w, (382, 436): 1, (383, 383): v/w, (383, 437): 1,
        (384, 384): v/w, (384, 438): 1, (385, 385): v/w, (385, 439):
        1, (386, 386): v/w, (386, 440): 1, (387, 387): v/w, (387,
        441): 1, (388, 388): v/w, (388, 442): 1, (389, 389): v/w,
        (389, 443): 1, (390, 390): v/w, (390, 444): 1, (391, 391):
        v/w, (391, 445): 1, (392, 392): v/w, (392, 446): 1, (393,
        393): v/w, (393, 447): 1, (394, 394): v/w, (394, 448): 1,
        (395, 395): v/w, (395, 449): 1, (396, 396): v/w, (396, 450):
        1, (397, 397): v/w, (397, 451): 1, (398, 398): v/w, (398,
        452): 1, (399, 399): v/w, (399, 453): 1, (400, 400): v/w,
        (400, 454): 1, (401, 401): v/w, (401, 455): 1, (402, 402):
        v/w, (402, 456): 1, (403, 403): v/w, (403, 457): 1, (404,
        404): v/w, (404, 458): 1, (405, 243): 1, (405, 297): -u/w,
        (406, 244): 1, (406, 298): -u/w, (407, 245): 1, (407, 299):
        -u/w, (408, 246): 1, (408, 300): -u/w, (409, 247): 1, (409,
        301): -u/w, (410, 248): 1, (410, 302): -u/w, (411, 249): 1,
        (411, 303): -u/w, (412, 250): 1, (412, 304): -u/w, (413, 251):
        1, (413, 305): -u/w, (414, 252): 1, (414, 306): -u/w, (415,
        253): 1, (415, 307): -u/w, (416, 254): 1, (416, 308): -u/w,
        (417, 255): 1, (417, 309): -u/w, (418, 256): 1, (418, 310):
        -u/w, (419, 257): 1, (419, 311): -u/w, (420, 258): 1, (420,
        312): -u/w, (421, 259): 1, (421, 313): -u/w, (422, 260): 1,
        (422, 314): -u/w, (423, 261): 1, (423, 315): -u/w, (424, 262):
        1, (424, 316): -u/w, (425, 263): 1, (425, 317): -u/w, (426,
        264): 1, (426, 318): -u/w, (427, 265): 1, (427, 319): -u/w,
        (428, 266): 1, (428, 320): -u/w, (429, 267): 1, (429, 321):
        -u/w, (430, 268): 1, (430, 322): -u/w, (431, 269): 1, (431,
        323): -u/w, (432, 351): 1, (432, 378): -u/w, (433, 352): 1,
        (433, 379): -u/w, (434, 353): 1, (434, 380): -u/w, (435, 354):
        1, (435, 381): -u/w, (436, 355): 1, (436, 382): -u/w, (437,
        356): 1, (437, 383): -u/w, (438, 357): 1, (438, 384): -u/w,
        (439, 358): 1, (439, 385): -u/w, (440, 359): 1, (440, 386):
        -u/w, (441, 360): 1, (441, 387): -u/w, (442, 361): 1, (442,
        388): -u/w, (443, 362): 1, (443, 389): -u/w, (444, 363): 1,
        (444, 390): -u/w, (445, 364): 1, (445, 391): -u/w, (446, 365):
        1, (446, 392): -u/w, (447, 366): 1, (447, 393): -u/w, (448,
        367): 1, (448, 394): -u/w, (449, 368): 1, (449, 395): -u/w,
        (450, 369): 1, (450, 396): -u/w, (451, 370): 1, (451, 397):
        -u/w, (452, 371): 1, (452, 398): -u/w, (453, 372): 1, (453,
        399): -u/w, (454, 373): 1, (454, 400): -u/w, (455, 374): 1,
        (455, 401): -u/w, (456, 375): 1, (456, 402): -u/w, (457, 376):
        1, (457, 403): -u/w, (458, 377): 1, (458, 404): -u/w, (459,
        270): 1, (459, 324): -u/w, (460, 271): 1, (460, 325): -u/w,
        (461, 272): 1, (461, 326): -u/w, (462, 273): 1, (462, 327):
        -u/w, (463, 274): 1, (463, 328): -u/w, (464, 275): 1, (464,
        329): -u/w, (465, 276): 1, (465, 330): -u/w, (466, 277): 1,
        (466, 331): -u/w, (467, 278): 1, (467, 332): -u/w, (468, 279):
        1, (468, 333): -u/w, (469, 280): 1, (469, 334): -u/w, (470,
        281): 1, (470, 335): -u/w, (471, 282): 1, (471, 336): -u/w,
        (472, 283): 1, (472, 337): -u/w, (473, 284): 1, (473, 338):
        -u/w, (474, 285): 1, (474, 339): -u/w, (475, 286): 1, (475,
        340): -u/w, (476, 287): 1, (476, 341): -u/w, (477, 288): 1,
        (477, 342): -u/w, (478, 289): 1, (478, 343): -u/w, (479, 290):
        1, (479, 344): -u/w, (480, 291): 1, (480, 345): -u/w, (481,
        292): 1, (481, 346): -u/w, (482, 293): 1, (482, 347): -u/w,
        (483, 294): 1, (483, 348): -u/w, (484, 295): 1, (484, 349):
        -u/w, (485, 296): 1, (485, 350): -u/w, (486, 513): 1, (486,
        540): -u/w, (487, 514): 1, (487, 541): -u/w, (488, 515): 1,
        (488, 542): -u/w, (489, 516): 1, (489, 543): -u/w, (490, 517):
        1, (490, 544): -u/w, (491, 518): 1, (491, 545): -u/w, (492,
        519): 1, (492, 546): -u/w, (493, 520): 1, (493, 547): -u/w,
        (494, 521): 1, (494, 548): -u/w, (495, 522): 1, (495, 549):
        -u/w, (496, 523): 1, (496, 550): -u/w, (497, 524): 1, (497,
        551): -u/w, (498, 525): 1, (498, 552): -u/w, (499, 526): 1,
        (499, 553): -u/w, (500, 527): 1, (500, 554): -u/w, (501, 528):
        1, (501, 555): -u/w, (502, 529): 1, (502, 556): -u/w, (503,
        530): 1, (503, 557): -u/w, (504, 531): 1, (504, 558): -u/w,
        (505, 532): 1, (505, 559): -u/w, (506, 533): 1, (506, 560):
        -u/w, (507, 534): 1, (507, 561): -u/w, (508, 535): 1, (508,
        562): -u/w, (509, 536): 1, (509, 563): -u/w, (510, 537): 1,
        (510, 564): -u/w, (511, 538): 1, (511, 565): -u/w, (512, 539):
        1, (512, 566): -u/w, (513, 540): 1/w, (514, 541): 1/w, (515,
        542): 1/w, (516, 543): 1/w, (517, 544): 1/w, (518, 545): 1/w,
        (519, 546): 1/w, (520, 547): 1/w, (521, 548): 1/w, (522, 549):
        1/w, (523, 550): 1/w, (524, 551): 1/w, (525, 552): 1/w, (526,
        553): 1/w, (527, 554): 1/w, (528, 555): 1/w, (529, 556): 1/w,
        (530, 557): 1/w, (531, 558): 1/w, (532, 559): 1/w, (533, 560):
        1/w, (534, 561): 1/w, (535, 562): 1/w, (536, 563): 1/w, (537,
        564): 1/w, (538, 565): 1/w, (539, 566): 1/w, (540, 486): 1,
        (540, 540): v/w, (541, 487): 1, (541, 541): v/w, (542, 488):
        1, (542, 542): v/w, (543, 489): 1, (543, 543): v/w, (544,
        490): 1, (544, 544): v/w, (545, 491): 1, (545, 545): v/w,
        (546, 492): 1, (546, 546): v/w, (547, 493): 1, (547, 547):
        v/w, (548, 494): 1, (548, 548): v/w, (549, 495): 1, (549,
        549): v/w, (550, 496): 1, (550, 550): v/w, (551, 497): 1,
        (551, 551): v/w, (552, 498): 1, (552, 552): v/w, (553, 499):
        1, (553, 553): v/w, (554, 500): 1, (554, 554): v/w, (555,
        501): 1, (555, 555): v/w, (556, 502): 1, (556, 556): v/w,
        (557, 503): 1, (557, 557): v/w, (558, 504): 1, (558, 558):
        v/w, (559, 505): 1, (559, 559): v/w, (560, 506): 1, (560,
        560): v/w, (561, 507): 1, (561, 561): v/w, (562, 508): 1,
        (562, 562): v/w, (563, 509): 1, (563, 563): v/w, (564, 510):
        1, (564, 564): v/w, (565, 511): 1, (565, 565): v/w, (566,
        512): 1, (566, 566): v/w, (567, 594): 1, (567, 621): -u/w,
        (568, 595): 1, (568, 622): -u/w, (569, 596): 1, (569, 623):
        -u/w, (570, 597): 1, (570, 624): -u/w, (571, 598): 1, (571,
        625): -u/w, (572, 599): 1, (572, 626): -u/w, (573, 600): 1,
        (573, 627): -u/w, (574, 601): 1, (574, 628): -u/w, (575, 602):
        1, (575, 629): -u/w, (576, 603): 1, (576, 630): -u/w, (577,
        604): 1, (577, 631): -u/w, (578, 605): 1, (578, 632): -u/w,
        (579, 606): 1, (579, 633): -u/w, (580, 607): 1, (580, 634):
        -u/w, (581, 608): 1, (581, 635): -u/w, (582, 609): 1, (582,
        636): -u/w, (583, 610): 1, (583, 637): -u/w, (584, 611): 1,
        (584, 638): -u/w, (585, 612): 1, (585, 639): -u/w, (586, 613):
        1, (586, 640): -u/w, (587, 614): 1, (587, 641): -u/w, (588,
        615): 1, (588, 642): -u/w, (589, 616): 1, (589, 643): -u/w,
        (590, 617): 1, (590, 644): -u/w, (591, 618): 1, (591, 645):
        -u/w, (592, 619): 1, (592, 646): -u/w, (593, 620): 1, (593,
        647): -u/w, (594, 621): 1/w, (595, 622): 1/w, (596, 623): 1/w,
        (597, 624): 1/w, (598, 625): 1/w, (599, 626): 1/w, (600, 627):
        1/w, (601, 628): 1/w, (602, 629): 1/w, (603, 630): 1/w, (604,
        631): 1/w, (605, 632): 1/w, (606, 633): 1/w, (607, 634): 1/w,
        (608, 635): 1/w, (609, 636): 1/w, (610, 637): 1/w, (611, 638):
        1/w, (612, 639): 1/w, (613, 640): 1/w, (614, 641): 1/w, (615,
        642): 1/w, (616, 643): 1/w, (617, 644): 1/w, (618, 645): 1/w,
        (619, 646): 1/w, (620, 647): 1/w, (621, 567): 1, (621, 621):
        v/w, (622, 568): 1, (622, 622): v/w, (623, 569): 1, (623,
        623): v/w, (624, 570): 1, (624, 624): v/w, (625, 571): 1,
        (625, 625): v/w, (626, 572): 1, (626, 626): v/w, (627, 573):
        1, (627, 627): v/w, (628, 574): 1, (628, 628): v/w, (629,
        575): 1, (629, 629): v/w, (630, 576): 1, (630, 630): v/w,
        (631, 577): 1, (631, 631): v/w, (632, 578): 1, (632, 632):
        v/w, (633, 579): 1, (633, 633): v/w, (634, 580): 1, (634,
        634): v/w, (635, 581): 1, (635, 635): v/w, (636, 582): 1,
        (636, 636): v/w, (637, 583): 1, (637, 637): v/w, (638, 584):
        1, (638, 638): v/w, (639, 585): 1, (639, 639): v/w, (640,
        586): 1, (640, 640): v/w, (641, 587): 1, (641, 641): v/w,
        (642, 588): 1, (642, 642): v/w, (643, 589): 1, (643, 643):
        v/w, (644, 590): 1, (644, 644): v/w, (645, 591): 1, (645,
        645): v/w, (646, 592): 1, (646, 646): v/w, (647, 593): 1,
        (647, 647): v/w}, {(0, 81): 1, (0, 108): -u/w, (1, 82): 1, (1,
        109): -u/w, (2, 83): 1, (2, 110): -u/w, (3, 84): 1, (3, 111):
        -u/w, (4, 85): 1, (4, 112): -u/w, (5, 86): 1, (5, 113): -u/w,
        (6, 87): 1, (6, 114): -u/w, (7, 88): 1, (7, 115): -u/w, (8,
        89): 1, (8, 116): -u/w, (9, 90): 1, (9, 117): -u/w, (10, 91):
        1, (10, 118): -u/w, (11, 92): 1, (11, 119): -u/w, (12, 93): 1,
        (12, 120): -u/w, (13, 94): 1, (13, 121): -u/w, (14, 95): 1,
        (14, 122): -u/w, (15, 96): 1, (15, 123): -u/w, (16, 97): 1,
        (16, 124): -u/w, (17, 98): 1, (17, 125): -u/w, (18, 99): 1,
        (18, 126): -u/w, (19, 100): 1, (19, 127): -u/w, (20, 101): 1,
        (20, 128): -u/w, (21, 102): 1, (21, 129): -u/w, (22, 103): 1,
        (22, 130): -u/w, (23, 104): 1, (23, 131): -u/w, (24, 105): 1,
        (24, 132): -u/w, (25, 106): 1, (25, 133): -u/w, (26, 107): 1,
        (26, 134): -u/w, (27, 405): 1, (27, 432): -u/w, (27, 594):
        u*v/w, (27, 621): -u/w, (28, 406): 1, (28, 433): -u/w, (28,
        595): u*v/w, (28, 622): -u/w, (29, 407): 1, (29, 434): -u/w,
        (29, 596): u*v/w, (29, 623): -u/w, (30, 408): 1, (30, 435):
        -u/w, (30, 597): u*v/w, (30, 624): -u/w, (31, 409): 1, (31,
        436): -u/w, (31, 598): u*v/w, (31, 625): -u/w, (32, 410): 1,
        (32, 437): -u/w, (32, 599): u*v/w, (32, 626): -u/w, (33, 411):
        1, (33, 438): -u/w, (33, 600): u*v/w, (33, 627): -u/w, (34,
        412): 1, (34, 439): -u/w, (34, 601): u*v/w, (34, 628): -u/w,
        (35, 413): 1, (35, 440): -u/w, (35, 602): u*v/w, (35, 629):
        -u/w, (36, 414): 1, (36, 441): -u/w, (36, 603): u*v/w, (36,
        630): -u/w, (37, 415): 1, (37, 442): -u/w, (37, 604): u*v/w,
        (37, 631): -u/w, (38, 416): 1, (38, 443): -u/w, (38, 605):
        u*v/w, (38, 632): -u/w, (39, 417): 1, (39, 444): -u/w, (39,
        606): u*v/w, (39, 633): -u/w, (40, 418): 1, (40, 445): -u/w,
        (40, 607): u*v/w, (40, 634): -u/w, (41, 419): 1, (41, 446):
        -u/w, (41, 608): u*v/w, (41, 635): -u/w, (42, 420): 1, (42,
        447): -u/w, (42, 609): u*v/w, (42, 636): -u/w, (43, 421): 1,
        (43, 448): -u/w, (43, 610): u*v/w, (43, 637): -u/w, (44, 422):
        1, (44, 449): -u/w, (44, 611): u*v/w, (44, 638): -u/w, (45,
        423): 1, (45, 450): -u/w, (45, 612): u*v/w, (45, 639): -u/w,
        (46, 424): 1, (46, 451): -u/w, (46, 613): u*v/w, (46, 640):
        -u/w, (47, 425): 1, (47, 452): -u/w, (47, 614): u*v/w, (47,
        641): -u/w, (48, 426): 1, (48, 453): -u/w, (48, 615): u*v/w,
        (48, 642): -u/w, (49, 427): 1, (49, 454): -u/w, (49, 616):
        u*v/w, (49, 643): -u/w, (50, 428): 1, (50, 455): -u/w, (50,
        617): u*v/w, (50, 644): -u/w, (51, 429): 1, (51, 456): -u/w,
        (51, 618): u*v/w, (51, 645): -u/w, (52, 430): 1, (52, 457):
        -u/w, (52, 619): u*v/w, (52, 646): -u/w, (53, 431): 1, (53,
        458): -u/w, (53, 620): u*v/w, (53, 647): -u/w, (54, 459): 1,
        (54, 486): -u/w, (55, 460): 1, (55, 487): -u/w, (56, 461): 1,
        (56, 488): -u/w, (57, 462): 1, (57, 489): -u/w, (58, 463): 1,
        (58, 490): -u/w, (59, 464): 1, (59, 491): -u/w, (60, 465): 1,
        (60, 492): -u/w, (61, 466): 1, (61, 493): -u/w, (62, 467): 1,
        (62, 494): -u/w, (63, 468): 1, (63, 495): -u/w, (64, 469): 1,
        (64, 496): -u/w, (65, 470): 1, (65, 497): -u/w, (66, 471): 1,
        (66, 498): -u/w, (67, 472): 1, (67, 499): -u/w, (68, 473): 1,
        (68, 500): -u/w, (69, 474): 1, (69, 501): -u/w, (70, 475): 1,
        (70, 502): -u/w, (71, 476): 1, (71, 503): -u/w, (72, 477): 1,
        (72, 504): -u/w, (73, 478): 1, (73, 505): -u/w, (74, 479): 1,
        (74, 506): -u/w, (75, 480): 1, (75, 507): -u/w, (76, 481): 1,
        (76, 508): -u/w, (77, 482): 1, (77, 509): -u/w, (78, 483): 1,
        (78, 510): -u/w, (79, 484): 1, (79, 511): -u/w, (80, 485): 1,
        (80, 512): -u/w, (81, 108): 1/w, (82, 109): 1/w, (83, 110):
        1/w, (84, 111): 1/w, (85, 112): 1/w, (86, 113): 1/w, (87,
        114): 1/w, (88, 115): 1/w, (89, 116): 1/w, (90, 117): 1/w,
        (91, 118): 1/w, (92, 119): 1/w, (93, 120): 1/w, (94, 121):
        1/w, (95, 122): 1/w, (96, 123): 1/w, (97, 124): 1/w, (98,
        125): 1/w, (99, 126): 1/w, (100, 127): 1/w, (101, 128): 1/w,
        (102, 129): 1/w, (103, 130): 1/w, (104, 131): 1/w, (105, 132):
        1/w, (106, 133): 1/w, (107, 134): 1/w, (108, 0): 1, (108,
        108): v/w, (109, 1): 1, (109, 109): v/w, (110, 2): 1, (110,
        110): v/w, (111, 3): 1, (111, 111): v/w, (112, 4): 1, (112,
        112): v/w, (113, 5): 1, (113, 113): v/w, (114, 6): 1, (114,
        114): v/w, (115, 7): 1, (115, 115): v/w, (116, 8): 1, (116,
        116): v/w, (117, 9): 1, (117, 117): v/w, (118, 10): 1, (118,
        118): v/w, (119, 11): 1, (119, 119): v/w, (120, 12): 1, (120,
        120): v/w, (121, 13): 1, (121, 121): v/w, (122, 14): 1, (122,
        122): v/w, (123, 15): 1, (123, 123): v/w, (124, 16): 1, (124,
        124): v/w, (125, 17): 1, (125, 125): v/w, (126, 18): 1, (126,
        126): v/w, (127, 19): 1, (127, 127): v/w, (128, 20): 1, (128,
        128): v/w, (129, 21): 1, (129, 129): v/w, (130, 22): 1, (130,
        130): v/w, (131, 23): 1, (131, 131): v/w, (132, 24): 1, (132,
        132): v/w, (133, 25): 1, (133, 133): v/w, (134, 26): 1, (134,
        134): v/w, (135, 243): 1, (135, 270): -u/w, (135, 351): -u/w,
        (135, 594): -u**2/w, (136, 244): 1, (136, 271): -u/w, (136,
        352): -u/w, (136, 595): -u**2/w, (137, 245): 1, (137, 272):
        -u/w, (137, 353): -u/w, (137, 596): -u**2/w, (138, 246): 1,
        (138, 273): -u/w, (138, 354): -u/w, (138, 597): -u**2/w, (139,
        247): 1, (139, 274): -u/w, (139, 355): -u/w, (139, 598):
        -u**2/w, (140, 248): 1, (140, 275): -u/w, (140, 356): -u/w,
        (140, 599): -u**2/w, (141, 249): 1, (141, 276): -u/w, (141,
        357): -u/w, (141, 600): -u**2/w, (142, 250): 1, (142, 277):
        -u/w, (142, 358): -u/w, (142, 601): -u**2/w, (143, 251): 1,
        (143, 278): -u/w, (143, 359): -u/w, (143, 602): -u**2/w, (144,
        252): 1, (144, 279): -u/w, (144, 360): -u/w, (144, 603):
        -u**2/w, (145, 253): 1, (145, 280): -u/w, (145, 361): -u/w,
        (145, 604): -u**2/w, (146, 254): 1, (146, 281): -u/w, (146,
        362): -u/w, (146, 605): -u**2/w, (147, 255): 1, (147, 282):
        -u/w, (147, 363): -u/w, (147, 606): -u**2/w, (148, 256): 1,
        (148, 283): -u/w, (148, 364): -u/w, (148, 607): -u**2/w, (149,
        257): 1, (149, 284): -u/w, (149, 365): -u/w, (149, 608):
        -u**2/w, (150, 258): 1, (150, 285): -u/w, (150, 366): -u/w,
        (150, 609): -u**2/w, (151, 259): 1, (151, 286): -u/w, (151,
        367): -u/w, (151, 610): -u**2/w, (152, 260): 1, (152, 287):
        -u/w, (152, 368): -u/w, (152, 611): -u**2/w, (153, 261): 1,
        (153, 288): -u/w, (153, 369): -u/w, (153, 612): -u**2/w, (154,
        262): 1, (154, 289): -u/w, (154, 370): -u/w, (154, 613):
        -u**2/w, (155, 263): 1, (155, 290): -u/w, (155, 371): -u/w,
        (155, 614): -u**2/w, (156, 264): 1, (156, 291): -u/w, (156,
        372): -u/w, (156, 615): -u**2/w, (157, 265): 1, (157, 292):
        -u/w, (157, 373): -u/w, (157, 616): -u**2/w, (158, 266): 1,
        (158, 293): -u/w, (158, 374): -u/w, (158, 617): -u**2/w, (159,
        267): 1, (159, 294): -u/w, (159, 375): -u/w, (159, 618):
        -u**2/w, (160, 268): 1, (160, 295): -u/w, (160, 376): -u/w,
        (160, 619): -u**2/w, (161, 269): 1, (161, 296): -u/w, (161,
        377): -u/w, (161, 620): -u**2/w, (162, 297): 1, (162, 324):
        -u/w, (162, 351): -u*v/w, (162, 594): -u, (163, 298): 1, (163,
        325): -u/w, (163, 352): -u*v/w, (163, 595): -u, (164, 299): 1,
        (164, 326): -u/w, (164, 353): -u*v/w, (164, 596): -u, (165,
        300): 1, (165, 327): -u/w, (165, 354): -u*v/w, (165, 597): -u,
        (166, 301): 1, (166, 328): -u/w, (166, 355): -u*v/w, (166,
        598): -u, (167, 302): 1, (167, 329): -u/w, (167, 356): -u*v/w,
        (167, 599): -u, (168, 303): 1, (168, 330): -u/w, (168, 357):
        -u*v/w, (168, 600): -u, (169, 304): 1, (169, 331): -u/w, (169,
        358): -u*v/w, (169, 601): -u, (170, 305): 1, (170, 332): -u/w,
        (170, 359): -u*v/w, (170, 602): -u, (171, 306): 1, (171, 333):
        -u/w, (171, 360): -u*v/w, (171, 603): -u, (172, 307): 1, (172,
        334): -u/w, (172, 361): -u*v/w, (172, 604): -u, (173, 308): 1,
        (173, 335): -u/w, (173, 362): -u*v/w, (173, 605): -u, (174,
        309): 1, (174, 336): -u/w, (174, 363): -u*v/w, (174, 606): -u,
        (175, 310): 1, (175, 337): -u/w, (175, 364): -u*v/w, (175,
        607): -u, (176, 311): 1, (176, 338): -u/w, (176, 365): -u*v/w,
        (176, 608): -u, (177, 312): 1, (177, 339): -u/w, (177, 366):
        -u*v/w, (177, 609): -u, (178, 313): 1, (178, 340): -u/w, (178,
        367): -u*v/w, (178, 610): -u, (179, 314): 1, (179, 341): -u/w,
        (179, 368): -u*v/w, (179, 611): -u, (180, 315): 1, (180, 342):
        -u/w, (180, 369): -u*v/w, (180, 612): -u, (181, 316): 1, (181,
        343): -u/w, (181, 370): -u*v/w, (181, 613): -u, (182, 317): 1,
        (182, 344): -u/w, (182, 371): -u*v/w, (182, 614): -u, (183,
        318): 1, (183, 345): -u/w, (183, 372): -u*v/w, (183, 615): -u,
        (184, 319): 1, (184, 346): -u/w, (184, 373): -u*v/w, (184,
        616): -u, (185, 320): 1, (185, 347): -u/w, (185, 374): -u*v/w,
        (185, 617): -u, (186, 321): 1, (186, 348): -u/w, (186, 375):
        -u*v/w, (186, 618): -u, (187, 322): 1, (187, 349): -u/w, (187,
        376): -u*v/w, (187, 619): -u, (188, 323): 1, (188, 350): -u/w,
        (188, 377): -u*v/w, (188, 620): -u, (189, 513): -u/w, (189,
        567): 1, (190, 514): -u/w, (190, 568): 1, (191, 515): -u/w,
        (191, 569): 1, (192, 516): -u/w, (192, 570): 1, (193, 517):
        -u/w, (193, 571): 1, (194, 518): -u/w, (194, 572): 1, (195,
        519): -u/w, (195, 573): 1, (196, 520): -u/w, (196, 574): 1,
        (197, 521): -u/w, (197, 575): 1, (198, 522): -u/w, (198, 576):
        1, (199, 523): -u/w, (199, 577): 1, (200, 524): -u/w, (200,
        578): 1, (201, 525): -u/w, (201, 579): 1, (202, 526): -u/w,
        (202, 580): 1, (203, 527): -u/w, (203, 581): 1, (204, 528):
        -u/w, (204, 582): 1, (205, 529): -u/w, (205, 583): 1, (206,
        530): -u/w, (206, 584): 1, (207, 531): -u/w, (207, 585): 1,
        (208, 532): -u/w, (208, 586): 1, (209, 533): -u/w, (209, 587):
        1, (210, 534): -u/w, (210, 588): 1, (211, 535): -u/w, (211,
        589): 1, (212, 536): -u/w, (212, 590): 1, (213, 537): -u/w,
        (213, 591): 1, (214, 538): -u/w, (214, 592): 1, (215, 539):
        -u/w, (215, 593): 1, (216, 351): -v, (216, 378): 1, (216,
        540): -u/w, (217, 352): -v, (217, 379): 1, (217, 541): -u/w,
        (218, 353): -v, (218, 380): 1, (218, 542): -u/w, (219, 354):
        -v, (219, 381): 1, (219, 543): -u/w, (220, 355): -v, (220,
        382): 1, (220, 544): -u/w, (221, 356): -v, (221, 383): 1,
        (221, 545): -u/w, (222, 357): -v, (222, 384): 1, (222, 546):
        -u/w, (223, 358): -v, (223, 385): 1, (223, 547): -u/w, (224,
        359): -v, (224, 386): 1, (224, 548): -u/w, (225, 360): -v,
        (225, 387): 1, (225, 549): -u/w, (226, 361): -v, (226, 388):
        1, (226, 550): -u/w, (227, 362): -v, (227, 389): 1, (227,
        551): -u/w, (228, 363): -v, (228, 390): 1, (228, 552): -u/w,
        (229, 364): -v, (229, 391): 1, (229, 553): -u/w, (230, 365):
        -v, (230, 392): 1, (230, 554): -u/w, (231, 366): -v, (231,
        393): 1, (231, 555): -u/w, (232, 367): -v, (232, 394): 1,
        (232, 556): -u/w, (233, 368): -v, (233, 395): 1, (233, 557):
        -u/w, (234, 369): -v, (234, 396): 1, (234, 558): -u/w, (235,
        370): -v, (235, 397): 1, (235, 559): -u/w, (236, 371): -v,
        (236, 398): 1, (236, 560): -u/w, (237, 372): -v, (237, 399):
        1, (237, 561): -u/w, (238, 373): -v, (238, 400): 1, (238,
        562): -u/w, (239, 374): -v, (239, 401): 1, (239, 563): -u/w,
        (240, 375): -v, (240, 402): 1, (240, 564): -u/w, (241, 376):
        -v, (241, 403): 1, (241, 565): -u/w, (242, 377): -v, (242,
        404): 1, (242, 566): -u/w, (243, 270): 1/w, (243, 594): u/w,
        (244, 271): 1/w, (244, 595): u/w, (245, 272): 1/w, (245, 596):
        u/w, (246, 273): 1/w, (246, 597): u/w, (247, 274): 1/w, (247,
        598): u/w, (248, 275): 1/w, (248, 599): u/w, (249, 276): 1/w,
        (249, 600): u/w, (250, 277): 1/w, (250, 601): u/w, (251, 278):
        1/w, (251, 602): u/w, (252, 279): 1/w, (252, 603): u/w, (253,
        280): 1/w, (253, 604): u/w, (254, 281): 1/w, (254, 605): u/w,
        (255, 282): 1/w, (255, 606): u/w, (256, 283): 1/w, (256, 607):
        u/w, (257, 284): 1/w, (257, 608): u/w, (258, 285): 1/w, (258,
        609): u/w, (259, 286): 1/w, (259, 610): u/w, (260, 287): 1/w,
        (260, 611): u/w, (261, 288): 1/w, (261, 612): u/w, (262, 289):
        1/w, (262, 613): u/w, (263, 290): 1/w, (263, 614): u/w, (264,
        291): 1/w, (264, 615): u/w, (265, 292): 1/w, (265, 616): u/w,
        (266, 293): 1/w, (266, 617): u/w, (267, 294): 1/w, (267, 618):
        u/w, (268, 295): 1/w, (268, 619): u/w, (269, 296): 1/w, (269,
        620): u/w, (270, 135): 1, (270, 162): -u/w, (270, 270): v/w,
        (270, 351): -u**2/w, (270, 621): u/w, (271, 136): 1, (271,
        163): -u/w, (271, 271): v/w, (271, 352): -u**2/w, (271, 622):
        u/w, (272, 137): 1, (272, 164): -u/w, (272, 272): v/w, (272,
        353): -u**2/w, (272, 623): u/w, (273, 138): 1, (273, 165):
        -u/w, (273, 273): v/w, (273, 354): -u**2/w, (273, 624): u/w,
        (274, 139): 1, (274, 166): -u/w, (274, 274): v/w, (274, 355):
        -u**2/w, (274, 625): u/w, (275, 140): 1, (275, 167): -u/w,
        (275, 275): v/w, (275, 356): -u**2/w, (275, 626): u/w, (276,
        141): 1, (276, 168): -u/w, (276, 276): v/w, (276, 357):
        -u**2/w, (276, 627): u/w, (277, 142): 1, (277, 169): -u/w,
        (277, 277): v/w, (277, 358): -u**2/w, (277, 628): u/w, (278,
        143): 1, (278, 170): -u/w, (278, 278): v/w, (278, 359):
        -u**2/w, (278, 629): u/w, (279, 144): 1, (279, 171): -u/w,
        (279, 279): v/w, (279, 360): -u**2/w, (279, 630): u/w, (280,
        145): 1, (280, 172): -u/w, (280, 280): v/w, (280, 361):
        -u**2/w, (280, 631): u/w, (281, 146): 1, (281, 173): -u/w,
        (281, 281): v/w, (281, 362): -u**2/w, (281, 632): u/w, (282,
        147): 1, (282, 174): -u/w, (282, 282): v/w, (282, 363):
        -u**2/w, (282, 633): u/w, (283, 148): 1, (283, 175): -u/w,
        (283, 283): v/w, (283, 364): -u**2/w, (283, 634): u/w, (284,
        149): 1, (284, 176): -u/w, (284, 284): v/w, (284, 365):
        -u**2/w, (284, 635): u/w, (285, 150): 1, (285, 177): -u/w,
        (285, 285): v/w, (285, 366): -u**2/w, (285, 636): u/w, (286,
        151): 1, (286, 178): -u/w, (286, 286): v/w, (286, 367):
        -u**2/w, (286, 637): u/w, (287, 152): 1, (287, 179): -u/w,
        (287, 287): v/w, (287, 368): -u**2/w, (287, 638): u/w, (288,
        153): 1, (288, 180): -u/w, (288, 288): v/w, (288, 369):
        -u**2/w, (288, 639): u/w, (289, 154): 1, (289, 181): -u/w,
        (289, 289): v/w, (289, 370): -u**2/w, (289, 640): u/w, (290,
        155): 1, (290, 182): -u/w, (290, 290): v/w, (290, 371):
        -u**2/w, (290, 641): u/w, (291, 156): 1, (291, 183): -u/w,
        (291, 291): v/w, (291, 372): -u**2/w, (291, 642): u/w, (292,
        157): 1, (292, 184): -u/w, (292, 292): v/w, (292, 373):
        -u**2/w, (292, 643): u/w, (293, 158): 1, (293, 185): -u/w,
        (293, 293): v/w, (293, 374): -u**2/w, (293, 644): u/w, (294,
        159): 1, (294, 186): -u/w, (294, 294): v/w, (294, 375):
        -u**2/w, (294, 645): u/w, (295, 160): 1, (295, 187): -u/w,
        (295, 295): v/w, (295, 376): -u**2/w, (295, 646): u/w, (296,
        161): 1, (296, 188): -u/w, (296, 296): v/w, (296, 377):
        -u**2/w, (296, 647): u/w, (297, 594): 1, (298, 595): 1, (299,
        596): 1, (300, 597): 1, (301, 598): 1, (302, 599): 1, (303,
        600): 1, (304, 601): 1, (305, 602): 1, (306, 603): 1, (307,
        604): 1, (308, 605): 1, (309, 606): 1, (310, 607): 1, (311,
        608): 1, (312, 609): 1, (313, 610): 1, (314, 611): 1, (315,
        612): 1, (316, 613): 1, (317, 614): 1, (318, 615): 1, (319,
        616): 1, (320, 617): 1, (321, 618): 1, (322, 619): 1, (323,
        620): 1, (324, 351): -u, (324, 621): 1, (325, 352): -u, (325,
        622): 1, (326, 353): -u, (326, 623): 1, (327, 354): -u, (327,
        624): 1, (328, 355): -u, (328, 625): 1, (329, 356): -u, (329,
        626): 1, (330, 357): -u, (330, 627): 1, (331, 358): -u, (331,
        628): 1, (332, 359): -u, (332, 629): 1, (333, 360): -u, (333,
        630): 1, (334, 361): -u, (334, 631): 1, (335, 362): -u, (335,
        632): 1, (336, 363): -u, (336, 633): 1, (337, 364): -u, (337,
        634): 1, (338, 365): -u, (338, 635): 1, (339, 366): -u, (339,
        636): 1, (340, 367): -u, (340, 637): 1, (341, 368): -u, (341,
        638): 1, (342, 369): -u, (342, 639): 1, (343, 370): -u, (343,
        640): 1, (344, 371): -u, (344, 641): 1, (345, 372): -u, (345,
        642): 1, (346, 373): -u, (346, 643): 1, (347, 374): -u, (347,
        644): 1, (348, 375): -u, (348, 645): 1, (349, 376): -u, (349,
        646): 1, (350, 377): -u, (350, 647): 1, (351, 324): 1/w, (351,
        351): v/w, (352, 325): 1/w, (352, 352): v/w, (353, 326): 1/w,
        (353, 353): v/w, (354, 327): 1/w, (354, 354): v/w, (355, 328):
        1/w, (355, 355): v/w, (356, 329): 1/w, (356, 356): v/w, (357,
        330): 1/w, (357, 357): v/w, (358, 331): 1/w, (358, 358): v/w,
        (359, 332): 1/w, (359, 359): v/w, (360, 333): 1/w, (360, 360):
        v/w, (361, 334): 1/w, (361, 361): v/w, (362, 335): 1/w, (362,
        362): v/w, (363, 336): 1/w, (363, 363): v/w, (364, 337): 1/w,
        (364, 364): v/w, (365, 338): 1/w, (365, 365): v/w, (366, 339):
        1/w, (366, 366): v/w, (367, 340): 1/w, (367, 367): v/w, (368,
        341): 1/w, (368, 368): v/w, (369, 342): 1/w, (369, 369): v/w,
        (370, 343): 1/w, (370, 370): v/w, (371, 344): 1/w, (371, 371):
        v/w, (372, 345): 1/w, (372, 372): v/w, (373, 346): 1/w, (373,
        373): v/w, (374, 347): 1/w, (374, 374): v/w, (375, 348): 1/w,
        (375, 375): v/w, (376, 349): 1/w, (376, 376): v/w, (377, 350):
        1/w, (377, 377): v/w, (378, 540): 1/w, (379, 541): 1/w, (380,
        542): 1/w, (381, 543): 1/w, (382, 544): 1/w, (383, 545): 1/w,
        (384, 546): 1/w, (385, 547): 1/w, (386, 548): 1/w, (387, 549):
        1/w, (388, 550): 1/w, (389, 551): 1/w, (390, 552): 1/w, (391,
        553): 1/w, (392, 554): 1/w, (393, 555): 1/w, (394, 556): 1/w,
        (395, 557): 1/w, (396, 558): 1/w, (397, 559): 1/w, (398, 560):
        1/w, (399, 561): 1/w, (400, 562): 1/w, (401, 563): 1/w, (402,
        564): 1/w, (403, 565): 1/w, (404, 566): 1/w, (405, 351): u/w,
        (405, 432): 1/w, (405, 594): -v/w, (406, 352): u/w, (406,
        433): 1/w, (406, 595): -v/w, (407, 353): u/w, (407, 434): 1/w,
        (407, 596): -v/w, (408, 354): u/w, (408, 435): 1/w, (408,
        597): -v/w, (409, 355): u/w, (409, 436): 1/w, (409, 598):
        -v/w, (410, 356): u/w, (410, 437): 1/w, (410, 599): -v/w,
        (411, 357): u/w, (411, 438): 1/w, (411, 600): -v/w, (412,
        358): u/w, (412, 439): 1/w, (412, 601): -v/w, (413, 359): u/w,
        (413, 440): 1/w, (413, 602): -v/w, (414, 360): u/w, (414,
        441): 1/w, (414, 603): -v/w, (415, 361): u/w, (415, 442): 1/w,
        (415, 604): -v/w, (416, 362): u/w, (416, 443): 1/w, (416,
        605): -v/w, (417, 363): u/w, (417, 444): 1/w, (417, 606):
        -v/w, (418, 364): u/w, (418, 445): 1/w, (418, 607): -v/w,
        (419, 365): u/w, (419, 446): 1/w, (419, 608): -v/w, (420,
        366): u/w, (420, 447): 1/w, (420, 609): -v/w, (421, 367): u/w,
        (421, 448): 1/w, (421, 610): -v/w, (422, 368): u/w, (422,
        449): 1/w, (422, 611): -v/w, (423, 369): u/w, (423, 450): 1/w,
        (423, 612): -v/w, (424, 370): u/w, (424, 451): 1/w, (424,
        613): -v/w, (425, 371): u/w, (425, 452): 1/w, (425, 614):
        -v/w, (426, 372): u/w, (426, 453): 1/w, (426, 615): -v/w,
        (427, 373): u/w, (427, 454): 1/w, (427, 616): -v/w, (428,
        374): u/w, (428, 455): 1/w, (428, 617): -v/w, (429, 375): u/w,
        (429, 456): 1/w, (429, 618): -v/w, (430, 376): u/w, (430,
        457): 1/w, (430, 619): -v/w, (431, 377): u/w, (431, 458): 1/w,
        (431, 620): -v/w, (432, 27): 1, (432, 162): v/w, (432, 351):
        u*v/w, (432, 432): v/w, (433, 28): 1, (433, 163): v/w, (433,
        352): u*v/w, (433, 433): v/w, (434, 29): 1, (434, 164): v/w,
        (434, 353): u*v/w, (434, 434): v/w, (435, 30): 1, (435, 165):
        v/w, (435, 354): u*v/w, (435, 435): v/w, (436, 31): 1, (436,
        166): v/w, (436, 355): u*v/w, (436, 436): v/w, (437, 32): 1,
        (437, 167): v/w, (437, 356): u*v/w, (437, 437): v/w, (438,
        33): 1, (438, 168): v/w, (438, 357): u*v/w, (438, 438): v/w,
        (439, 34): 1, (439, 169): v/w, (439, 358): u*v/w, (439, 439):
        v/w, (440, 35): 1, (440, 170): v/w, (440, 359): u*v/w, (440,
        440): v/w, (441, 36): 1, (441, 171): v/w, (441, 360): u*v/w,
        (441, 441): v/w, (442, 37): 1, (442, 172): v/w, (442, 361):
        u*v/w, (442, 442): v/w, (443, 38): 1, (443, 173): v/w, (443,
        362): u*v/w, (443, 443): v/w, (444, 39): 1, (444, 174): v/w,
        (444, 363): u*v/w, (444, 444): v/w, (445, 40): 1, (445, 175):
        v/w, (445, 364): u*v/w, (445, 445): v/w, (446, 41): 1, (446,
        176): v/w, (446, 365): u*v/w, (446, 446): v/w, (447, 42): 1,
        (447, 177): v/w, (447, 366): u*v/w, (447, 447): v/w, (448,
        43): 1, (448, 178): v/w, (448, 367): u*v/w, (448, 448): v/w,
        (449, 44): 1, (449, 179): v/w, (449, 368): u*v/w, (449, 449):
        v/w, (450, 45): 1, (450, 180): v/w, (450, 369): u*v/w, (450,
        450): v/w, (451, 46): 1, (451, 181): v/w, (451, 370): u*v/w,
        (451, 451): v/w, (452, 47): 1, (452, 182): v/w, (452, 371):
        u*v/w, (452, 452): v/w, (453, 48): 1, (453, 183): v/w, (453,
        372): u*v/w, (453, 453): v/w, (454, 49): 1, (454, 184): v/w,
        (454, 373): u*v/w, (454, 454): v/w, (455, 50): 1, (455, 185):
        v/w, (455, 374): u*v/w, (455, 455): v/w, (456, 51): 1, (456,
        186): v/w, (456, 375): u*v/w, (456, 456): v/w, (457, 52): 1,
        (457, 187): v/w, (457, 376): u*v/w, (457, 457): v/w, (458,
        53): 1, (458, 188): v/w, (458, 377): u*v/w, (458, 458): v/w,
        (459, 351): u*v/w, (459, 486): 1/w, (459, 621): -v/w, (460,
        352): u*v/w, (460, 487): 1/w, (460, 622): -v/w, (461, 353):
        u*v/w, (461, 488): 1/w, (461, 623): -v/w, (462, 354): u*v/w,
        (462, 489): 1/w, (462, 624): -v/w, (463, 355): u*v/w, (463,
        490): 1/w, (463, 625): -v/w, (464, 356): u*v/w, (464, 491):
        1/w, (464, 626): -v/w, (465, 357): u*v/w, (465, 492): 1/w,
        (465, 627): -v/w, (466, 358): u*v/w, (466, 493): 1/w, (466,
        628): -v/w, (467, 359): u*v/w, (467, 494): 1/w, (467, 629):
        -v/w, (468, 360): u*v/w, (468, 495): 1/w, (468, 630): -v/w,
        (469, 361): u*v/w, (469, 496): 1/w, (469, 631): -v/w, (470,
        362): u*v/w, (470, 497): 1/w, (470, 632): -v/w, (471, 363):
        u*v/w, (471, 498): 1/w, (471, 633): -v/w, (472, 364): u*v/w,
        (472, 499): 1/w, (472, 634): -v/w, (473, 365): u*v/w, (473,
        500): 1/w, (473, 635): -v/w, (474, 366): u*v/w, (474, 501):
        1/w, (474, 636): -v/w, (475, 367): u*v/w, (475, 502): 1/w,
        (475, 637): -v/w, (476, 368): u*v/w, (476, 503): 1/w, (476,
        638): -v/w, (477, 369): u*v/w, (477, 504): 1/w, (477, 639):
        -v/w, (478, 370): u*v/w, (478, 505): 1/w, (478, 640): -v/w,
        (479, 371): u*v/w, (479, 506): 1/w, (479, 641): -v/w, (480,
        372): u*v/w, (480, 507): 1/w, (480, 642): -v/w, (481, 373):
        u*v/w, (481, 508): 1/w, (481, 643): -v/w, (482, 374): u*v/w,
        (482, 509): 1/w, (482, 644): -v/w, (483, 375): u*v/w, (483,
        510): 1/w, (483, 645): -v/w, (484, 376): u*v/w, (484, 511):
        1/w, (484, 646): -v/w, (485, 377): u*v/w, (485, 512): 1/w,
        (485, 647): -v/w, (486, 54): 1, (486, 351): v, (486, 486):
        v/w, (486, 621): -v**2/w, (487, 55): 1, (487, 352): v, (487,
        487): v/w, (487, 622): -v**2/w, (488, 56): 1, (488, 353): v,
        (488, 488): v/w, (488, 623): -v**2/w, (489, 57): 1, (489,
        354): v, (489, 489): v/w, (489, 624): -v**2/w, (490, 58): 1,
        (490, 355): v, (490, 490): v/w, (490, 625): -v**2/w, (491,
        59): 1, (491, 356): v, (491, 491): v/w, (491, 626): -v**2/w,
        (492, 60): 1, (492, 357): v, (492, 492): v/w, (492, 627):
        -v**2/w, (493, 61): 1, (493, 358): v, (493, 493): v/w, (493,
        628): -v**2/w, (494, 62): 1, (494, 359): v, (494, 494): v/w,
        (494, 629): -v**2/w, (495, 63): 1, (495, 360): v, (495, 495):
        v/w, (495, 630): -v**2/w, (496, 64): 1, (496, 361): v, (496,
        496): v/w, (496, 631): -v**2/w, (497, 65): 1, (497, 362): v,
        (497, 497): v/w, (497, 632): -v**2/w, (498, 66): 1, (498,
        363): v, (498, 498): v/w, (498, 633): -v**2/w, (499, 67): 1,
        (499, 364): v, (499, 499): v/w, (499, 634): -v**2/w, (500,
        68): 1, (500, 365): v, (500, 500): v/w, (500, 635): -v**2/w,
        (501, 69): 1, (501, 366): v, (501, 501): v/w, (501, 636):
        -v**2/w, (502, 70): 1, (502, 367): v, (502, 502): v/w, (502,
        637): -v**2/w, (503, 71): 1, (503, 368): v, (503, 503): v/w,
        (503, 638): -v**2/w, (504, 72): 1, (504, 369): v, (504, 504):
        v/w, (504, 639): -v**2/w, (505, 73): 1, (505, 370): v, (505,
        505): v/w, (505, 640): -v**2/w, (506, 74): 1, (506, 371): v,
        (506, 506): v/w, (506, 641): -v**2/w, (507, 75): 1, (507,
        372): v, (507, 507): v/w, (507, 642): -v**2/w, (508, 76): 1,
        (508, 373): v, (508, 508): v/w, (508, 643): -v**2/w, (509,
        77): 1, (509, 374): v, (509, 509): v/w, (509, 644): -v**2/w,
        (510, 78): 1, (510, 375): v, (510, 510): v/w, (510, 645):
        -v**2/w, (511, 79): 1, (511, 376): v, (511, 511): v/w, (511,
        646): -v**2/w, (512, 80): 1, (512, 377): v, (512, 512): v/w,
        (512, 647): -v**2/w, (513, 189): 1, (513, 324): v/w, (513,
        513): v/w, (513, 621): u*v/w, (514, 190): 1, (514, 325): v/w,
        (514, 514): v/w, (514, 622): u*v/w, (515, 191): 1, (515, 326):
        v/w, (515, 515): v/w, (515, 623): u*v/w, (516, 192): 1, (516,
        327): v/w, (516, 516): v/w, (516, 624): u*v/w, (517, 193): 1,
        (517, 328): v/w, (517, 517): v/w, (517, 625): u*v/w, (518,
        194): 1, (518, 329): v/w, (518, 518): v/w, (518, 626): u*v/w,
        (519, 195): 1, (519, 330): v/w, (519, 519): v/w, (519, 627):
        u*v/w, (520, 196): 1, (520, 331): v/w, (520, 520): v/w, (520,
        628): u*v/w, (521, 197): 1, (521, 332): v/w, (521, 521): v/w,
        (521, 629): u*v/w, (522, 198): 1, (522, 333): v/w, (522, 522):
        v/w, (522, 630): u*v/w, (523, 199): 1, (523, 334): v/w, (523,
        523): v/w, (523, 631): u*v/w, (524, 200): 1, (524, 335): v/w,
        (524, 524): v/w, (524, 632): u*v/w, (525, 201): 1, (525, 336):
        v/w, (525, 525): v/w, (525, 633): u*v/w, (526, 202): 1, (526,
        337): v/w, (526, 526): v/w, (526, 634): u*v/w, (527, 203): 1,
        (527, 338): v/w, (527, 527): v/w, (527, 635): u*v/w, (528,
        204): 1, (528, 339): v/w, (528, 528): v/w, (528, 636): u*v/w,
        (529, 205): 1, (529, 340): v/w, (529, 529): v/w, (529, 637):
        u*v/w, (530, 206): 1, (530, 341): v/w, (530, 530): v/w, (530,
        638): u*v/w, (531, 207): 1, (531, 342): v/w, (531, 531): v/w,
        (531, 639): u*v/w, (532, 208): 1, (532, 343): v/w, (532, 532):
        v/w, (532, 640): u*v/w, (533, 209): 1, (533, 344): v/w, (533,
        533): v/w, (533, 641): u*v/w, (534, 210): 1, (534, 345): v/w,
        (534, 534): v/w, (534, 642): u*v/w, (535, 211): 1, (535, 346):
        v/w, (535, 535): v/w, (535, 643): u*v/w, (536, 212): 1, (536,
        347): v/w, (536, 536): v/w, (536, 644): u*v/w, (537, 213): 1,
        (537, 348): v/w, (537, 537): v/w, (537, 645): u*v/w, (538,
        214): 1, (538, 349): v/w, (538, 538): v/w, (538, 646): u*v/w,
        (539, 215): 1, (539, 350): v/w, (539, 539): v/w, (539, 647):
        u*v/w, (540, 216): 1, (540, 540): v/w, (540, 621): v, (541,
        217): 1, (541, 541): v/w, (541, 622): v, (542, 218): 1, (542,
        542): v/w, (542, 623): v, (543, 219): 1, (543, 543): v/w,
        (543, 624): v, (544, 220): 1, (544, 544): v/w, (544, 625): v,
        (545, 221): 1, (545, 545): v/w, (545, 626): v, (546, 222): 1,
        (546, 546): v/w, (546, 627): v, (547, 223): 1, (547, 547):
        v/w, (547, 628): v, (548, 224): 1, (548, 548): v/w, (548,
        629): v, (549, 225): 1, (549, 549): v/w, (549, 630): v, (550,
        226): 1, (550, 550): v/w, (550, 631): v, (551, 227): 1, (551,
        551): v/w, (551, 632): v, (552, 228): 1, (552, 552): v/w,
        (552, 633): v, (553, 229): 1, (553, 553): v/w, (553, 634): v,
        (554, 230): 1, (554, 554): v/w, (554, 635): v, (555, 231): 1,
        (555, 555): v/w, (555, 636): v, (556, 232): 1, (556, 556):
        v/w, (556, 637): v, (557, 233): 1, (557, 557): v/w, (557,
        638): v, (558, 234): 1, (558, 558): v/w, (558, 639): v, (559,
        235): 1, (559, 559): v/w, (559, 640): v, (560, 236): 1, (560,
        560): v/w, (560, 641): v, (561, 237): 1, (561, 561): v/w,
        (561, 642): v, (562, 238): 1, (562, 562): v/w, (562, 643): v,
        (563, 239): 1, (563, 563): v/w, (563, 644): v, (564, 240): 1,
        (564, 564): v/w, (564, 645): v, (565, 241): 1, (565, 565):
        v/w, (565, 646): v, (566, 242): 1, (566, 566): v/w, (566,
        647): v, (567, 351): -v/w, (567, 513): 1/w, (568, 352): -v/w,
        (568, 514): 1/w, (569, 353): -v/w, (569, 515): 1/w, (570,
        354): -v/w, (570, 516): 1/w, (571, 355): -v/w, (571, 517):
        1/w, (572, 356): -v/w, (572, 518): 1/w, (573, 357): -v/w,
        (573, 519): 1/w, (574, 358): -v/w, (574, 520): 1/w, (575,
        359): -v/w, (575, 521): 1/w, (576, 360): -v/w, (576, 522):
        1/w, (577, 361): -v/w, (577, 523): 1/w, (578, 362): -v/w,
        (578, 524): 1/w, (579, 363): -v/w, (579, 525): 1/w, (580,
        364): -v/w, (580, 526): 1/w, (581, 365): -v/w, (581, 527):
        1/w, (582, 366): -v/w, (582, 528): 1/w, (583, 367): -v/w,
        (583, 529): 1/w, (584, 368): -v/w, (584, 530): 1/w, (585,
        369): -v/w, (585, 531): 1/w, (586, 370): -v/w, (586, 532):
        1/w, (587, 371): -v/w, (587, 533): 1/w, (588, 372): -v/w,
        (588, 534): 1/w, (589, 373): -v/w, (589, 535): 1/w, (590,
        374): -v/w, (590, 536): 1/w, (591, 375): -v/w, (591, 537):
        1/w, (592, 376): -v/w, (592, 538): 1/w, (593, 377): -v/w,
        (593, 539): 1/w, (594, 162): 1/w, (594, 351): u/w, (594, 594):
        v/w, (595, 163): 1/w, (595, 352): u/w, (595, 595): v/w, (596,
        164): 1/w, (596, 353): u/w, (596, 596): v/w, (597, 165): 1/w,
        (597, 354): u/w, (597, 597): v/w, (598, 166): 1/w, (598, 355):
        u/w, (598, 598): v/w, (599, 167): 1/w, (599, 356): u/w, (599,
        599): v/w, (600, 168): 1/w, (600, 357): u/w, (600, 600): v/w,
        (601, 169): 1/w, (601, 358): u/w, (601, 601): v/w, (602, 170):
        1/w, (602, 359): u/w, (602, 602): v/w, (603, 171): 1/w, (603,
        360): u/w, (603, 603): v/w, (604, 172): 1/w, (604, 361): u/w,
        (604, 604): v/w, (605, 173): 1/w, (605, 362): u/w, (605, 605):
        v/w, (606, 174): 1/w, (606, 363): u/w, (606, 606): v/w, (607,
        175): 1/w, (607, 364): u/w, (607, 607): v/w, (608, 176): 1/w,
        (608, 365): u/w, (608, 608): v/w, (609, 177): 1/w, (609, 366):
        u/w, (609, 609): v/w, (610, 178): 1/w, (610, 367): u/w, (610,
        610): v/w, (611, 179): 1/w, (611, 368): u/w, (611, 611): v/w,
        (612, 180): 1/w, (612, 369): u/w, (612, 612): v/w, (613, 181):
        1/w, (613, 370): u/w, (613, 613): v/w, (614, 182): 1/w, (614,
        371): u/w, (614, 614): v/w, (615, 183): 1/w, (615, 372): u/w,
        (615, 615): v/w, (616, 184): 1/w, (616, 373): u/w, (616, 616):
        v/w, (617, 185): 1/w, (617, 374): u/w, (617, 617): v/w, (618,
        186): 1/w, (618, 375): u/w, (618, 618): v/w, (619, 187): 1/w,
        (619, 376): u/w, (619, 619): v/w, (620, 188): 1/w, (620, 377):
        u/w, (620, 620): v/w, (621, 351): 1, (622, 352): 1, (623,
        353): 1, (624, 354): 1, (625, 355): 1, (626, 356): 1, (627,
        357): 1, (628, 358): 1, (629, 359): 1, (630, 360): 1, (631,
        361): 1, (632, 362): 1, (633, 363): 1, (634, 364): 1, (635,
        365): 1, (636, 366): 1, (637, 367): 1, (638, 368): 1, (639,
        369): 1, (640, 370): 1, (641, 371): 1, (642, 372): 1, (643,
        373): 1, (644, 374): 1, (645, 375): 1, (646, 376): 1, (647,
        377): 1}, {(0, 3): 1, (0, 4): -u/w, (1, 1): v/w, (1, 82):
        u*v/w, (1, 271): u*v/w, (1, 325): -u**2*v/w**2, (1, 460):
        u*v**2/w**2, (1, 568): u**2*v**2/w**2, (1, 571): 1, (1, 586):
        v, (1, 595): u**2*v/w, (1, 596): -v**3/w, (1, 614): -v**2, (1,
        615): v, (1, 622): -u**3*v/w**2, (1, 623): v**2/w, (1, 641):
        v, (1, 642): -u*v/w, (2, 266): 1, (2, 267): -v, (2, 268): -v,
        (2, 269): v**2, (2, 320): -u/w, (2, 321): u*v/w, (2, 322):
        u*v/w, (2, 323): -u*v**2/w, (2, 427): -v, (3, 4): 1/w, (4, 0):
        1, (4, 4): v/w, (5, 5): v/w, (5, 87): v, (5, 108): 1, (5,
        127): -v**2/w, (5, 184): -v**3*(u*v - w)/w**2, (5, 265): v**3,
        (5, 281): v**2*(u*v - w)/w**2, (5, 319): -u*v**3/w, (5, 373):
        -u*v**3/w, (5, 400): u*v**2/w, (5, 589): -u*v**3/w, (5, 605):
        u*v**2*(u*v - w)/w**2, (5, 615): -v**3*(u*v - w)/w**2, (5,
        616): -v**4*(u*v - w)/w**2, (5, 618): -u*v**3*(u*v - w)/w**2,
        (5, 645): u*v**2*(u*v - w)/w**2, (6, 6): v/w, (6, 81): 1, (6,
        85): v/w, (6, 87): u*v/w, (6, 184): -u*v**3/w**2, (6, 238):
        u*v**2/w**2, (6, 253): -v**2/w, (6, 307): u*v**2/w**2, (6,
        325): v**2*(u**2 - v)*(u*v - w)/w**4, (6, 335): u*v*(u*v -
        w)/w**3, (6, 373): -u**2*v**3/w**2, (6, 400): u**2*v**2/w**2,
        (6, 460): -u*v**3/w**3, (6, 568): -u**2*v**3/w**3, (6, 617):
        v**3/w**2, (6, 618): -v**4/w**2, (6, 622): u*v**2*(u**2 -
        v)*(u*v - w)/w**4, (6, 632): u**2*v*(u*v - w)/w**3, (6, 644):
        -u*v**3/w**3, (6, 645): u*v**4/w**3, (7, 5): 1/w, (7, 87):
        u*v/w, (7, 127): -v/w, (7, 184): -v**2*(u*v - w)/w**2, (7,
        265): u*v**3/w, (7, 281): u*v**2*(u*v - w)/w**3, (7, 319):
        -u**2*v**3/w**2, (7, 373): -u**2*v**3/w**2, (7, 400):
        u**2*v**2/w**2, (7, 589): -u**2*v**3/w**2, (7, 605):
        u**2*v**2*(u*v - w)/w**3, (7, 615): -u*v**3*(u*v - w)/w**3,
        (7, 616): -u*v**4*(u*v - w)/w**3, (7, 618): -u**2*v**3*(u*v -
        w)/w**3, (7, 645): u**2*v**2*(u*v - w)/w**3, (8, 6): 1/w, (8,
        87): u/w, (8, 100): -v/w, (8, 157): v**2/w, (8, 184):
        -u*v**2/w**2, (8, 211): -u*v**2/w**2, (8, 238): u*v/w**2, (8,
        265): u*v**2/w, (8, 281): u*v*(u*v - w)/w**3, (8, 319):
        -u**2*v**2/w**2, (8, 373): -u**2*v**2/w**2, (8, 400):
        u**2*v/w**2, (8, 589): -u**2*v**2/w**2, (8, 605): u**2*v*(u*v
        - w)/w**3, (8, 615): -u*v**2*(u*v - w)/w**3, (8, 616):
        -u*v**3*(u*v - w)/w**3, (8, 618): -u**2*v**2*(u*v - w)/w**3,
        (8, 645): u**2*v*(u*v - w)/w**3, (9, 9): v/w, (9, 92): v, (9,
        129): -v**2/w, (9, 130): -v**3/w, (9, 185): -v**2/w, (9, 186):
        v**3/w, (9, 239): u*v**2/w**2, (9, 240): -v**2/w, (9, 280): v,
        (9, 334): -u*v/w, (9, 342): -v*(u*v - w)/w**2, (9, 376):
        -v**2, (9, 377): v**3, (9, 403): u*v**2/w, (9, 404): -v**2,
        (9, 452): -v**2, (9, 454): -u*v**3/w, (9, 470): v**2/w, (9,
        477): -u*v/w, (9, 486): 1, (9, 487): u*v**2/w**2, (9, 568):
        u*v**2/w, (9, 578): u*v**2/w, (9, 588): -v**3/w, (9, 589):
        -v**4/w, (9, 606): v*w, (9, 617): -v**3/w, (9, 618): v**4/w,
        (9, 622): v**2*(u*v - w)/w**2, (9, 633): -u*v, (9, 644):
        u*v**3/w**2, (9, 645): -v**3/w, (10, 10): v/w, (10, 93): v,
        (10, 110): -v**3/w**2, (10, 128): -v**2/w, (10, 130):
        -u*v**3/w**2, (10, 261): v**2/w, (10, 275): v/w, (10, 276):
        -v**2/w, (10, 280): u*v/w, (10, 281): -v**3/w**2, (10, 315):
        -u*v**2/w**2, (10, 329): -u*v/w**2, (10, 330): u*v**2/w**2,
        (10, 334): -u**2*v/w**2, (10, 335): u*v**3/w**3, (10, 423):
        -u*v/w, (10, 432): 1, (10, 434): -u*v**3/w**2, (10, 451):
        -v**2/w, (10, 452): -u*v**2/w, (10, 454): -v**3*(u**2 -
        v)/w**2, (10, 470): u*v**2/w**2, (10, 578): u**2*v**2/w**2,
        (10, 588): -u*v**3/w**2, (10, 589): -u*v**4/w**2, (10, 594):
        -v, (10, 600): -v*(u*v - w)/w, (10, 605): -u*v**3/w**2, (10,
        606): u*v, (10, 613): v**3/w, (10, 615): v**4/w**2, (10, 618):
        v**3*(u*v - w)/w**2, (10, 621): u*v/w, (10, 627): u*v*(u*v -
        w)/w**2, (10, 632): u**2*v**3/w**3, (10, 633): -u**2*v/w, (10,
        640): -u*v**3/w**2, (10, 642): -u*v**4/w**3, (10, 645):
        -v**2*(u*v - w)/w**2, (11, 11): v/w, (11, 92): u*v/w, (11,
        188): v**3/w, (11, 242): -v**2/w, (11, 253): v, (11, 255):
        -v**2, (11, 281): u*v/w, (11, 307): -u*v/w, (11, 309): v, (11,
        325): v**2*(u*v - w)/w**3, (11, 335): -u**2*v/w**2, (11, 377):
        u*v**3/w, (11, 404): -u*v**2/w, (11, 459): 1, (11, 460):
        u*v**2/w**2, (11, 463): v/w, (11, 465): u*v/w, (11, 470):
        u*v**2/w**2, (11, 567): u, (11, 568): u**2*v**2/w**2, (11,
        573): u**2*v/w, (11, 578): u**2*v**2/w**2, (11, 586):
        -u*v**2/w, (11, 596): u*v**4/w**2, (11, 605): u**2*v/w, (11,
        614): u*v**3/w, (11, 615): -u*v**2/w, (11, 617): -v**2/w, (11,
        618): v**3/w, (11, 619): v**3/w, (11, 622): u*v**2*(u*v -
        w)/w**3, (11, 623): -u*v**3/w**2, (11, 632): -u**3*v/w**2,
        (11, 641): -u*v**2/w, (11, 642): u**2*v**2/w**2, (11, 644):
        u*v**2/w**2, (11, 645): -u*v**3/w**2, (11, 646): -v**2/w, (12,
        12): v/w, (12, 93): u*v/w, (12, 130): -u*v**2/w**2, (12, 248):
        v/w, (12, 249): -v**2/w, (12, 253): u*v/w, (12, 255):
        -u*v**2/w, (12, 271): -u*v**3/w**3, (12, 282): u*v/w, (12,
        302): -u*v/w**2, (12, 303): v/w, (12, 307): -u**2*v/w**2, (12,
        309): u*v/w, (12, 315): -u*v*(u*v - w)/w**3, (12, 325):
        u*v**2/w**3, (12, 336): -u**2*v/w**2, (12, 405): 1, (12, 409):
        v/w, (12, 423): -u**2*v/w**2, (12, 454): -v**2*(u**2 -
        v)/w**2, (12, 470): u*v/w**2, (12, 578): u**2*v/w**2, (12,
        589): -u*v**3/w**2, (12, 595): -u**2*v**3/w**3, (12, 606):
        u**2*v/w, (12, 616): -v**4/w**2, (12, 622): u**2*v**2/w**3,
        (12, 633): -u**3*v/w**2, (12, 643): v**3/w**2, (13, 9): 1/w,
        (13, 92): u*v/w, (13, 129): -v/w, (13, 130): -v**2/w, (13,
        185): -v/w, (13, 186): v**2/w, (13, 239): u*v/w**2, (13, 240):
        -v/w, (13, 280): u*v/w, (13, 334): -u**2*v/w**2, (13, 342):
        -u*v*(u*v - w)/w**3, (13, 376): -u*v**2/w, (13, 377):
        u*v**3/w, (13, 403): u**2*v**2/w**2, (13, 404): -u*v**2/w,
        (13, 434): -v**2*(u*v - w)/w**2, (13, 452): -u*v**2/w, (13,
        454): -u**2*v**3/w**2, (13, 460): v*(u*v - w)/w**2, (13, 470):
        u*v**2/w**2, (13, 477): -u**2*v/w**2, (13, 487): u*v/w**2,
        (13, 568): u**2*v**2/w**2, (13, 578): u**2*v**2/w**2, (13,
        588): -u*v**3/w**2, (13, 589): -u*v**4/w**2, (13, 606):
        u**2*v**2/w, (13, 617): -u*v**3/w**2, (13, 618): u*v**4/w**2,
        (13, 622): u*v**2*(u*v - w)/w**3, (13, 633): -u**3*v**2/w**2,
        (13, 644): u**2*v**3/w**3, (13, 645): -u*v**3/w**2, (14, 10):
        1/w, (14, 93): u*v/w, (14, 128): -v/w, (14, 130):
        -u*v**2/w**2, (14, 158): -v/w, (14, 159): v**2/w, (14, 212):
        u*v/w**2, (14, 213): -u*v**2/w**2, (14, 265): -u*v*(u*v -
        w)/w, (14, 268): -u*v**2/w, (14, 269): u*v**3/w, (14, 280):
        u/w, (14, 319): u**2*v*(u*v - w)/w**2, (14, 322):
        u**2*v**2/w**2, (14, 323): -u**2*v**3/w**2, (14, 334):
        -u**2/w**2, (14, 406): -v/w, (14, 423): -u**2*v/w**2, (14,
        433): u*v/w**2, (14, 452): -u*v/w, (14, 454): -u**2*v**2/w**2,
        (14, 460): u*v/w**2, (14, 470): u**2*v**2/w**3, (14, 568):
        u**2*v/w**2, (14, 578): u**3*v**2/w**3, (14, 588):
        -u**2*v**3/w**3, (14, 589): u**2*v*(u*v*w - v**3 - w**2)/w**3,
        (14, 591): -u**2*v**2*(u*v - w)/w**3, (14, 592):
        u**2*v**2/w**2, (14, 593): -u*v**2/w, (14, 595): -u*v**2/w**2,
        (14, 606): u**2*v/w, (14, 617): -u*v**2/w**2, (14, 618):
        u*v**3/w**2, (14, 622): u**2*v**2/w**3, (14, 633):
        -u**3*v/w**2, (14, 644): u**2*v**2/w**3, (14, 645):
        -u**2*v**3/w**3, (15, 11): 1/w, (15, 92): u/w, (15, 102):
        -v/w, (15, 105): -u*v/w, (15, 157): -v, (15, 188): v**2/w,
        (15, 211): u*v/w, (15, 242): -v/w, (15, 244): u**2*v**2/w**2,
        (15, 255): -u*v**2/w, (15, 265): -u*v, (15, 281): u/w, (15,
        298): -u**2*v/w**2, (15, 309): u*v/w, (15, 319): u**2*v/w,
        (15, 335): -u**2/w**2, (15, 377): u*v**2/w, (15, 404): -u*v/w,
        (15, 407): v**2/w, (15, 426): -u*v/w, (15, 429): -u*(u*v -
        w)/w, (15, 431): -u*v, (15, 589): u**2*v/w, (15, 605): u**2/w,
        (15, 615): -u*v/w, (15, 616): u*v**2*(u*v - w)/w**2, (15,
        618): -u**2*v/w, (15, 619): u*v**3/w**2, (15, 632):
        -u**3/w**2, (15, 642): u**2*v/w**2, (15, 645): u**3*v/w**2,
        (15, 646): -u*v**2/w**2, (16, 12): 1/w, (16, 93): u/w, (16,
        101): -v/w, (16, 130): -u*v/w**2, (16, 157): -u*v/w, (16,
        160): -v/w, (16, 161): v**2/w, (16, 211): u**2*v/w**2, (16,
        214): u*v/w**2, (16, 215): -v/w, (16, 255): -u*v/w, (16, 265):
        -u*(2*u*v - w)/w, (16, 268): -u*v/w, (16, 269): u*v**2/w, (16,
        282): u/w, (16, 309): u/w, (16, 319): u**2*(2*u*v - w)/w**2,
        (16, 322): u**2*v/w**2, (16, 323): -u*v/w, (16, 336):
        -u**2/w**2, (16, 423): -u**2/w**2, (16, 425): -u*v/w, (16,
        454): -u**2*v/w**2, (16, 470): u**2*v/w**3, (16, 578):
        u**3*v/w**3, (16, 588): -u**2*v**2/w**3, (16, 589):
        u**2*v*(u*w - v**2)/w**3, (16, 591): -u**2*v*(u*v - w)/w**3,
        (16, 592): u**2*v/w**2, (16, 593): -u*v/w, (16, 606): u**2/w,
        (16, 614): -u*v/w, (16, 633): -u**3/w**2, (16, 641):
        u**2*v/w**2, (16, 643): u**2*v*(u*v - w)/w**3, (16, 646):
        u*v*(u*v - w)/w**3, (17, 18): 1/w, (17, 133): -v/w, (17, 159):
        -v, (17, 184): v**2/w, (17, 213): u*v/w, (17, 238): -v/w, (17,
        269): -u*v**2, (17, 281): -u*v**2/w**2, (17, 288): u/w, (17,
        323): u**2*v**2/w, (17, 335): u*v/w**2, (17, 342): -u**2/w**2,
        (17, 373): u**2*v**3/w**2, (17, 400): -u**2*v**2/w**2, (17,
        457): -u*v/w, (17, 470): -u**2*v/w**2, (17, 471): u*v/w, (17,
        569): -v**2*(u*v - w)/w**2, (17, 578): -u**3*v/w**2, (17,
        579): u**2*v/w, (17, 587): -u*v**2/w, (17, 588):
        u**2*v**2/w**2, (17, 591): u**3*v**2/w**2, (17, 592):
        -u*v**3/w**2, (17, 605): -u**2*v**2/w**2, (17, 615):
        u*v**3/w**2, (17, 616): u*v**4/w**2, (17, 618): u*v**2*(u*v -
        w)/w**2, (17, 632): u**2*v/w**2, (17, 642): -u*v**2/w**2, (17,
        643): -u*v**3/w**2, (18, 18): v/w, (18, 133): -v**2/w, (18,
        184): v**3/w, (18, 238): -v**2/w, (18, 276): v, (18, 288):
        u*v/w, (18, 330): -u*v/w, (18, 335): -v*(u*v - w)/w**2, (18,
        342): -u**2*v/w**2, (18, 373): u*v**3/w, (18, 400): -u*v**2/w,
        (18, 457): -u*v**2/w, (18, 470): -u*v/w, (18, 471): v, (18,
        569): -v**3/w, (18, 578): -u**2*v/w, (18, 579): u*v, (18,
        587): -v**2, (18, 588): u*v**2/w, (18, 592): -v**3/w, (18,
        594): w, (18, 600): u*v, (18, 613): -v**2, (18, 616): v**4/w,
        (18, 621): -u, (18, 627): -u**2*v/w, (18, 632): -u*v*(u*v -
        w)/w**2, (18, 640): u*v**2/w, (18, 642): v**2*(u*v - w)/w**2,
        (18, 643): -v**3/w, (19, 86): 1/w, (19, 87): -v/w, (19, 265):
        -v**3/w, (19, 319): v**2/w, (19, 373): u*v**3/w**2, (19, 400):
        -u*v**2/w**2, (19, 589): u*v**3/w**2, (19, 644): u*v*(u*v -
        w)/w**3, (19, 645): -u*v**2*(u*v - w)/w**3, (20, 91): 1/w,
        (20, 93): -v/w, (20, 266): -v/w, (20, 267): v**2/w, (20, 268):
        v**2/w, (20, 269): -v**3/w, (20, 320): u*v/w**2, (20, 321):
        -u*v**2/w**2, (20, 322): -u*v**2/w**2, (20, 323): u*v**3/w**2,
        (20, 433): -v/w**2, (20, 589): -u*v*(u*v - w)/w**2, (20, 590):
        u*v/w**2, (20, 591): -u*v**2/w**2, (20, 592): -u*v**2/w**2,
        (20, 593): v**2/w, (20, 595): v**2/w**2, (20, 604): u/w, (20,
        606): -u*v/w, (20, 622): -u*v**2/w**3, (20, 631): -u**2/w**2,
        (20, 633): u**2*v/w**2, (21, 90): 1/w, (21, 92): -v/w, (21,
        374): -u*v**2/w**2, (21, 375): v**2/w, (21, 376): u*v**3/w**2,
        (21, 377): -v**3/w, (21, 401): u*v/w**2, (21, 402): -v/w, (21,
        403): -u*v**2/w**2, (21, 404): v**2/w, (21, 423): -v/w, (21,
        477): u*v/w**2, (21, 487): -v/w**2, (21, 591): -v**2*(u*v -
        w)/w**2, (21, 604): u*v/w, (21, 606): -u*v**2/w, (21, 622):
        -v**2*(u*v - w)/w**3, (21, 631): -u**2*v/w**2, (21, 633):
        u**2*v**2/w**2, (21, 639): -u*v*(u*v - w)/w**3, (22, 423):
        1/w, (22, 470): -v/w**2, (22, 578): -u*v/w**2, (22, 588):
        v**2/w**2, (22, 589): v**3/w**2, (22, 591): v*(u*v - w)/w**2,
        (23, 353): -v**4/w**2, (23, 371): -v**3/w, (23, 372): v**2/w,
        (23, 373): -v**3*(u*v - w)/w**2, (23, 374): v**3/w**2, (23,
        376): -v**4/w**2, (23, 380): v**3/w**2, (23, 398): v**2/w,
        (23, 399): -v/w, (23, 400): v**2*(u*v - w)/w**2, (23, 401):
        -v**2/w**2, (23, 403): v**3/w**2, (23, 427): -v**2, (23, 468):
        1/w, (23, 469): -v/w, (23, 477): -v**2/w**2, (23, 576): u/w,
        (23, 577): -u*v/w, (23, 585): -u*v**2/w**2, (23, 590):
        v**3/w**2, (23, 595): v**2/w, (23, 622): -v/w, (24, 136):
        -v/w, (24, 190): u*v/w**2, (24, 271): -v**2/w**2, (24, 325):
        u*v**2/w**3, (24, 374): v**2/w**2, (24, 376): -v**3/w**2, (24,
        401): -v/w**2, (24, 403): v**2/w**2, (24, 414): 1/w, (24,
        477): -v/w**2, (24, 568): u**2*v/w**2, (24, 585): -u*v/w**2,
        (24, 591): v**3/w**2, (24, 595): -u*v**2/w**2, (24, 622):
        u*v*(2*u*v - w)/w**3, (25, 99): 1/w, (25, 373): -v**2*(u*v -
        w)/w**2, (25, 400): v*(u*v - w)/w**2, (25, 470): u*v/w**2,
        (25, 471): -v/w, (25, 569): v**3/w**2, (25, 578): u**2*v/w**2,
        (25, 579): -u*v/w, (25, 587): v**2/w, (25, 588): -u*v**2/w**2,
        (25, 591): -u*v*(u*v - w)/w**2, (25, 592): v**3/w**2, (25,
        612): u/w, (25, 639): -u**2/w**2, (26, 406): u*v/w**2, (26,
        416): 1/w, (26, 417): -v/w, (26, 589): v*(u*v - w)/w**2, (26,
        592): v**2/w**2, (27, 30): 1, (27, 31): -u/w, (28, 28): v/w,
        (28, 136): u*v/w, (28, 271): u*v**2/w**2, (28, 325): u*v/w**2,
        (28, 569): v**2/w, (28, 587): v, (28, 595): u**2*v**2/w**2,
        (28, 596): u*v**2/w, (28, 598): 1, (28, 613): v, (28, 614):
        u*v, (28, 622): u**2*v/w**2, (28, 642): v/w, (29, 265): -v,
        (29, 320): 1/w, (29, 321): -v/w, (29, 322): -v/w, (29, 323):
        v**2/w, (30, 31): 1/w, (31, 27): 1, (31, 31): v/w, (32, 32):
        v/w, (32, 130): u*v**3/w**2, (32, 141): v, (32, 162): 1, (32,
        181): -v**2/w, (32, 184): u**2*v**3/w**2, (32, 238):
        v**3/w**2, (32, 281): -u**2*v**2/w**2, (32, 319): v**3/w, (32,
        335): -v**2/w**2, (32, 373): u**2*v**2/w, (32, 454): u*v**2/w,
        (32, 470): -u*v**2/w**2, (32, 578): -u**2*v**2/w**2, (32,
        588): u*v**3/w**2, (32, 589): u*v**4/w**2, (32, 591):
        u*v**2*(u*v - w)/w**2, (32, 605): -u**3*v**2/w**2, (32, 615):
        u**2*v**3/w**2, (32, 616): u*v**3*(u*v - w)/w**2, (32, 618):
        u**2*v**2*(u*v - w)/w**2, (32, 632): -u*v**2/w**2, (32, 642):
        v**3/w**2, (32, 643): v**4/w**2, (33, 33): v/w, (33, 130):
        u*v**2/w**2, (33, 135): 1, (33, 139): v/w, (33, 141): u*v/w,
        (33, 184): u**2*v**2/w**2, (33, 271): -u**3*v**2/w**3, (33,
        281): -u**2*v/w**2, (33, 307): -v**2/w**2, (33, 325):
        -v**3*(u**2 - v)/w**4, (33, 335): -u*v**2/w**3, (33, 373):
        u**3*v**2/w**2, (33, 454): u**2*v**2/w**2, (33, 460):
        -v**2*(u**2 - v)/w**3, (33, 470): -u*v/w**2, (33, 568):
        -u*v**2*(u**2 - v)/w**3, (33, 578): -u**2*v/w**2, (33, 595):
        -u**4*v**2/w**3, (33, 605): -u**3*v/w**2, (33, 622):
        -u*v**3*(u**2 - v)/w**4, (33, 632): -u**2*v**2/w**3, (33,
        644): v**3/w**3, (33, 645): -v**4/w**3, (34, 32): 1/w, (34,
        130): u*v**2/w**2, (34, 141): u*v/w, (34, 181): -v/w, (34,
        184): u**2*v**2/w**2, (34, 238): v**2/w**2, (34, 281):
        -u**3*v**2/w**3, (34, 319): u*v**3/w**2, (34, 335):
        -u*v**2/w**3, (34, 373): u**3*v**2/w**2, (34, 454):
        u**2*v**2/w**2, (34, 470): -u**2*v**2/w**3, (34, 578):
        -u**3*v**2/w**3, (34, 588): u**2*v**3/w**3, (34, 589):
        u**2*v**4/w**3, (34, 591): u**2*v**2*(u*v - w)/w**3, (34,
        605): -u**4*v**2/w**3, (34, 615): u**3*v**3/w**3, (34, 616):
        u**2*v**3*(u*v - w)/w**3, (34, 618): u**3*v**2*(u*v - w)/w**3,
        (34, 632): -u**2*v**2/w**3, (34, 642): u*v**3/w**3, (34, 643):
        u*v**4/w**3, (35, 33): 1/w, (35, 130): u*v/w**2, (35, 141):
        u/w, (35, 154): -v/w, (35, 184): u**2*v/w**2, (35, 211):
        v**2/w**2, (35, 281): -u**3*v/w**3, (35, 319): u*v**2/w**2,
        (35, 335): -u*v/w**3, (35, 373): u**3*v/w**2, (35, 454):
        u**2*v/w**2, (35, 470): -u**2*v/w**3, (35, 578): -u**3*v/w**3,
        (35, 588): u**2*v**2/w**3, (35, 589): u**2*v**3/w**3, (35,
        591): u**2*v*(u*v - w)/w**3, (35, 605): -u**4*v/w**3, (35,
        615): u**3*v**2/w**3, (35, 616): u**2*v**2*(u*v - w)/w**3,
        (35, 618): u**3*v*(u*v - w)/w**3, (35, 632): -u**2*v/w**3,
        (35, 642): u*v**2/w**3, (35, 643): u*v**3/w**3, (36, 36): v/w,
        (36, 132): -v**2/w, (36, 146): v, (36, 183): -v**2/w, (36,
        184): -v**3/w, (36, 186): -u*v**2/w, (36, 239): -v**2/w**2,
        (36, 281): v**2/w, (36, 334): v/w, (36, 342): v**2/w**2, (36,
        371): -v**2, (36, 373): -u*v**3/w, (36, 377): -u*v**2, (36,
        403): -v**2/w, (36, 458): -v**2, (36, 477): v/w, (36, 513): 1,
        (36, 514): u*v**2/w**2, (36, 568): -v**2/w, (36, 591):
        -v**3/w, (36, 605): u*v**2/w, (36, 615): -v**3/w, (36, 616):
        -v**4/w, (36, 618): -u*v**3/w, (36, 622): -v**3/w**2, (36,
        633): v, (36, 644): -v**3/w**2, (37, 37): v/w, (37, 147): v,
        (37, 164): -v**3/w**2, (37, 182): -v**2/w, (37, 184):
        -u*v**3/w**2, (37, 261): -u*v/w, (37, 281): u*v**2/w**2, (37,
        315): v**2/w**2, (37, 329): v/w**2, (37, 330): -v**2/w**2,
        (37, 334): u*v/w**2, (37, 335): -v**3/w**3, (37, 351): 1, (37,
        353): -u*v**3/w**2, (37, 370): -v**2/w, (37, 371): -u*v**2/w,
        (37, 373): -v**3*(u**2 - v)/w**2, (37, 591): -v**2*(u*v -
        w)/w**2, (37, 605): u**2*v**2/w**2, (37, 615): -u*v**3/w**2,
        (37, 616): -u*v**4/w**2, (37, 618): -u*v**2*(u*v - w)/w**2,
        (37, 621): -v/w, (37, 627): -v*(u*v - w)/w**2, (37, 632):
        -u*v**3/w**3, (37, 633): u*v/w, (37, 640): v**3/w**2, (37,
        642): v**4/w**3, (38, 38): v/w, (38, 134): -v**2/w, (38, 146):
        u*v/w, (38, 188): -u*v**2/w, (38, 255): u*v, (38, 270): 1,
        (38, 274): v/w, (38, 276): u*v/w, (38, 281): u*v**2/w**2, (38,
        307): v/w, (38, 325): -v**3/w**3, (38, 335): u*v/w**2, (38,
        377): -u**2*v**2/w, (38, 417): v, (38, 458): -u*v**2/w, (38,
        460): -v**2/w**2, (38, 568): -u*v**2/w**2, (38, 569):
        -u*v**3/w**2, (38, 587): -u*v**2/w, (38, 592): -v**2/w, (38,
        594): u, (38, 596): -u**2*v**3/w**2, (38, 600): u**2*v/w, (38,
        605): u**2*v**2/w**2, (38, 613): -u*v**2/w, (38, 614):
        -u**2*v**2/w, (38, 619): -u*v**2/w, (38, 622): -u*v**3/w**3,
        (38, 632): u**2*v/w**2, (38, 642): -u*v**2/w**2, (38, 644):
        -v**2/w**2, (38, 645): v**3/w**2, (39, 39): v/w, (39, 147):
        u*v/w, (39, 184): -u*v**2/w**2, (39, 243): 1, (39, 247): v/w,
        (39, 249): u*v/w, (39, 255): u**2*v/w, (39, 271):
        u**2*v**2/w**3, (39, 281): u*v/w**2, (39, 302): v/w**2, (39,
        307): u*v/w**2, (39, 315): u*v**2/w**3, (39, 336): u*v/w**2,
        (39, 373): -v**2*(u**2 - v)/w**2, (39, 411): v/w, (39, 417):
        u*v/w, (39, 423): u*v/w**2, (39, 460): u*v**2/w**3, (39, 568):
        u**2*v**2/w**3, (39, 589): v**3/w**2, (39, 595):
        u**3*v**2/w**3, (39, 605): u**2*v/w**2, (39, 633):
        u**2*v/w**2, (40, 36): 1/w, (40, 132): -v/w, (40, 146): u*v/w,
        (40, 183): -v/w, (40, 184): -v**2/w, (40, 186): -u*v/w, (40,
        239): -v/w**2, (40, 271): v*(u*v - w)/w**2, (40, 281):
        u*v**2/w**2, (40, 334): u*v/w**2, (40, 342): u*v**2/w**3, (40,
        353): -v**2*(u*v - w)/w**2, (40, 371): -u*v**2/w, (40, 373):
        -u**2*v**3/w**2, (40, 377): -u**2*v**2/w, (40, 403):
        -u*v**2/w**2, (40, 458): -u*v**2/w, (40, 477): u*v/w**2, (40,
        514): u*v/w**2, (40, 568): -u*v**2/w**2, (40, 591):
        -u*v**3/w**2, (40, 605): u**2*v**2/w**2, (40, 615):
        -u*v**3/w**2, (40, 616): -u*v**4/w**2, (40, 618):
        -u**2*v**3/w**2, (40, 622): -u*v**3/w**3, (40, 633):
        u**2*v**2/w**2, (40, 644): -u*v**3/w**3, (41, 37): 1/w, (41,
        147): u*v/w, (41, 182): -v/w, (41, 184): -u*v**2/w**2, (41,
        212): -v/w**2, (41, 213): v**2/w**2, (41, 244): -v/w, (41,
        261): -u**2*v/w**2, (41, 271): u*v/w**2, (41, 281):
        u**2*v**2/w**3, (41, 319): -u*v*(u*v - w)/w**2, (41, 322):
        -u*v**2/w**2, (41, 323): u*v**3/w**2, (41, 334): u/w**2, (41,
        352): u*v/w**2, (41, 371): -u*v/w, (41, 373): -u**2*v**2/w**2,
        (41, 595): u**2*v/w**2, (41, 605): u**3*v**2/w**3, (41, 615):
        -u**2*v**3/w**3, (41, 616): u**2*v*(u*v*w - v**3 - w**2)/w**3,
        (41, 618): -u**2*v**2*(u*v - w)/w**3, (41, 619):
        u**2*v**2/w**2, (41, 620): -u*v**2/w, (41, 622): -u*v**2/w**3,
        (41, 633): u**2*v/w**2, (41, 644): -u*v**2/w**3, (41, 645):
        u*v**3/w**3, (42, 38): 1/w, (42, 134): -v/w, (42, 146): u/w,
        (42, 156): -v/w, (42, 159): -u*v/w, (42, 188): -u*v/w, (42,
        211): -v/w, (42, 244): -u**3*v/w**2, (42, 245): v**2/w, (42,
        255): u**2*v/w, (42, 264): -u*v/w, (42, 267): -u*(u*v - w)/w,
        (42, 269): -u*v, (42, 319): -u*v/w, (42, 335): u/w**2, (42,
        377): -u**2*v/w, (42, 406): -u**2*v/w**2, (42, 417): u*v/w,
        (42, 458): -u*v/w, (42, 589): -u**2*v**2/w**2, (42, 592):
        -u*v**2/w**2, (42, 616): -u**2*v*(u*v - w)/w**2, (42, 619):
        -u**2*v**2/w**2, (42, 632): u**2/w**2, (42, 642): -u*v/w**2,
        (42, 643): -u*v**2/w**2, (42, 645): -u**2*v/w**2, (43, 39):
        1/w, (43, 107): -v/w, (43, 147): u/w, (43, 155): -v/w, (43,
        161): -u*v/w, (43, 184): -u*v/w**2, (43, 211): -u*v/w**2, (43,
        214): -v/w**2, (43, 255): u**2/w, (43, 261): -u**2/w**2, (43,
        263): -u*v/w, (43, 269): -u**2*v/w, (43, 281): u**2*v/w**3,
        (43, 319): -u*(2*u*v - w)/w**2, (43, 322): -u*v/w**2, (43,
        336): u/w**2, (43, 373): -u**2*v/w**2, (43, 417): u/w, (43,
        431): -u*v/w, (43, 589): -u**2*v/w**2, (43, 592): -u*v/w**2,
        (43, 605): u**3*v/w**3, (43, 615): -u**2*v**2/w**3, (43, 616):
        -u**2*v**3/w**3, (43, 618): -u**2*v*(u*v - w)/w**3, (43, 620):
        -u*v/w, (43, 633): u**2/w**2, (43, 641): -u*v/w**2, (43, 643):
        -u**2*v**2/w**3, (43, 646): -u*v**2/w**3, (44, 45): 1/w, (44,
        130): -v/w, (44, 184): -u*v/w, (44, 187): -v/w, (44, 213):
        -v/w, (44, 282): u*v/w, (44, 323): -u*v**2/w, (44, 342):
        u/w**2, (44, 373): -u**3*v**2/w**2, (44, 376): -u*v/w, (44,
        454): -u**2*v**2/w**2, (44, 470): u*v/w**2, (44, 578):
        u**2*v/w**2, (44, 588): -u*v**2/w**2, (44, 589): -u*v**3/w**2,
        (44, 591): -u**2*v**2/w**2, (44, 596): -v**2*(u*v - w)/w**2,
        (44, 606): u**2*v/w, (44, 614): -u*v**2/w, (44, 616):
        -u**2*v**3/w**2, (44, 619): -u*v**3/w**2, (44, 645):
        -u*v**2/w**2, (45, 45): v/w, (45, 130): -v**2/w, (45, 184):
        -u*v**2/w, (45, 187): -v**2/w, (45, 282): v, (45, 330): v/w,
        (45, 335): v**2/w**2, (45, 342): u*v/w**2, (45, 373):
        -u**2*v**2/w, (45, 376): -u*v**2/w, (45, 454): -u*v**2/w, (45,
        470): v/w, (45, 578): u*v/w, (45, 588): -v**2/w, (45, 589):
        -v**3/w, (45, 596): -v**3/w, (45, 606): u*v, (45, 614): -v**2,
        (45, 616): -u*v**3/w, (45, 619): -v**3/w, (45, 621): 1, (45,
        627): u*v/w, (45, 632): u*v**2/w**2, (45, 640): -v**2/w, (45,
        642): -v**3/w**2, (46, 140): 1/w, (46, 141): -v/w, (46, 265):
        u*v**2/w, (46, 373): -u**2*v**2/w**2, (46, 427): v**2/w, (46,
        454): -u*v**2/w**2, (46, 590): -u*v/w**2, (46, 591):
        u*v**2/w**2, (46, 616): u*v**3/w**2, (46, 617): -u**2*v/w**2,
        (46, 618): u**2*v**2/w**2, (46, 644): -u*v**2/w**3, (46, 645):
        u*v**3/w**3, (47, 145): 1/w, (47, 147): -v/w, (47, 320):
        -v/w**2, (47, 321): v**2/w**2, (47, 322): v**2/w**2, (47,
        323): -v**3/w**2, (47, 352): -v/w**2, (47, 616): -u*v*(u*v -
        w)/w**2, (47, 617): u*v/w**2, (47, 618): -u*v**2/w**2, (47,
        619): -u*v**2/w**2, (47, 620): v**2/w, (47, 622): v**2/w**3,
        (47, 631): u/w**2, (47, 633): -u*v/w**2, (48, 144): 1/w, (48,
        146): -v/w, (48, 261): -v/w, (48, 288): u*v/w**2, (48, 374):
        u**2*v/w**2, (48, 375): -u*v/w, (48, 376): -u**2*v**2/w**2,
        (48, 377): u*v**2/w, (48, 455): u*v/w**2, (48, 456): -v/w,
        (48, 457): -u*v**2/w**2, (48, 458): v**2/w, (48, 514):
        -v/w**2, (48, 568): v**2/w**2, (48, 585): u*v/w**2, (48, 595):
        u*v**2/w**2, (48, 612): u**2*v/w**2, (48, 618): -v**2*(u*v -
        w)/w**2, (48, 622): v**3/w**3, (48, 631): u*v/w**2, (48, 633):
        -u*v**2/w**2, (48, 639): u*v**2/w**3, (49, 261): 1/w, (49,
        281): -v/w**2, (49, 605): -u*v/w**2, (49, 615): v**2/w**2,
        (49, 616): v**3/w**2, (49, 618): v*(u*v - w)/w**2, (50, 265):
        -v**2, (50, 279): 1/w, (50, 280): -v/w, (50, 288): -v**2/w**2,
        (50, 353): u*v**3/w**2, (50, 371): u*v**2/w, (50, 372):
        -u*v/w, (50, 373): u*v**2*(u*v - w)/w**2, (50, 374):
        -u*v**2/w**2, (50, 376): u*v**3/w**2, (50, 434): v**3/w**2,
        (50, 452): v**2/w, (50, 453): -v/w, (50, 454): v**2*(u*v -
        w)/w**2, (50, 455): -v**2/w**2, (50, 457): v**3/w**2, (50,
        568): -v/w, (50, 595): -u*v/w, (50, 603): u/w, (50, 604):
        -u*v/w, (50, 612): -u*v**2/w**2, (50, 617): v**3/w**2, (51,
        190): -v/w**2, (51, 252): 1/w, (51, 288): -v/w**2, (51, 325):
        -v**2/w**3, (51, 374): -u*v/w**2, (51, 376): u*v**2/w**2, (51,
        455): -v/w**2, (51, 457): v**2/w**2, (51, 568): -u*v/w**2,
        (51, 612): -u*v/w**2, (51, 618): v**3/w**2, (51, 622):
        -2*u*v**2/w**3, (52, 153): 1/w, (52, 281): u*v/w**2, (52,
        282): -v/w, (52, 373): u*v*(u*v - w)/w**2, (52, 454): v*(u*v -
        w)/w**2, (52, 596): v**3/w**2, (52, 605): u**2*v/w**2, (52,
        606): -u*v/w, (52, 614): v**2/w, (52, 615): -u*v**2/w**2, (52,
        618): -u*v*(u*v - w)/w**2, (52, 619): v**3/w**2, (52, 639):
        u/w**2, (53, 244): u*v/w**2, (53, 254): 1/w, (53, 255): -v/w,
        (53, 616): v*(u*v - w)/w**2, (53, 619): v**2/w**2, (54, 57):
        1, (54, 58): -u/w, (55, 55): v/w, (55, 190): u*v/w, (55, 325):
        2*u*v**2/w**2, (55, 460): u*v/w, (55, 568): u**2*v/w, (55,
        588): v, (55, 596): v**2, (55, 614): v*w, (55, 622):
        2*u**2*v**2/w**2, (55, 625): 1, (55, 640): v, (55, 642):
        v**2/w, (56, 319): -v, (56, 320): v/w, (56, 321): -v**2/w,
        (56, 322): -v**2/w, (56, 323): v**3/w, (56, 428): 1, (56,
        429): -v, (56, 430): -v, (56, 431): v**2, (57, 58): 1/w, (58,
        54): 1, (58, 58): v/w, (59, 59): v/w, (59, 130): v**3/w, (59,
        184): u*v**3/w, (59, 195): v, (59, 216): 1, (59, 235):
        -v**2/w, (59, 238): v**4/w**2, (59, 281): -u*v**2/w, (59,
        319): v**4/w, (59, 335): -v**3/w**2, (59, 373): u*v**2, (59,
        427): v**3, (59, 470): -v**2/w, (59, 578): -u*v**2/w, (59,
        588): v**3/w, (59, 589): v**4/w, (59, 605): -u**2*v**2/w, (59,
        615): u*v**3/w, (59, 616): u*v**4/w, (59, 618): u*v**2*(u*v -
        w)/w, (59, 632): -u*v**3/w**2, (59, 642): v**4/w**2, (59,
        643): -v**3*(u*w - v**2)/w**2, (60, 60): v/w, (60, 184):
        u*v**2/w, (60, 189): 1, (60, 193): v/w, (60, 195): u*v/w, (60,
        271): -v**2*(u**2 - v)/w**2, (60, 281): -u*v/w, (60, 307):
        -v**3/w**2, (60, 325): -v**3*(u**2*v + u*w - v**2)/w**4, (60,
        335): -u*v**3/w**3, (60, 373): u**2*v**2/w, (60, 415):
        -v**2/w, (60, 460): -v**3*(u**2 - v)/w**3, (60, 470):
        -u*v**2/w**2, (60, 568): -u*v**3*(u**2 - v)/w**3, (60, 578):
        -u**2*v**2/w**2, (60, 590): v**3/w**2, (60, 591): -v**4/w**2,
        (60, 595): -u*v**2*(u**2 - v)/w**2, (60, 605): -u**2*v/w, (60,
        622): -u*v**3*(u**2*v + u*w - v**2)/w**4, (60, 632):
        -u**2*v**3/w**3, (60, 644): v**4/w**3, (60, 645): -v**5/w**3,
        (61, 59): 1/w, (61, 130): v**2/w, (61, 184): u*v**2/w, (61,
        195): u*v/w, (61, 235): -v/w, (61, 238): v**3/w**2, (61, 281):
        -u**2*v**2/w**2, (61, 319): u*v**4/w**2, (61, 335):
        -u*v**3/w**3, (61, 373): u**2*v**2/w, (61, 427): u*v**3/w,
        (61, 470): -u*v**2/w**2, (61, 578): -u**2*v**2/w**2, (61,
        588): u*v**3/w**2, (61, 589): u*v**4/w**2, (61, 605):
        -u**3*v**2/w**2, (61, 615): u**2*v**3/w**2, (61, 616):
        u**2*v**4/w**2, (61, 618): u**2*v**2*(u*v - w)/w**2, (61,
        632): -u**2*v**3/w**3, (61, 642): u*v**4/w**3, (61, 643):
        -u*v**3*(u*w - v**2)/w**3, (62, 60): 1/w, (62, 103): v**2/w,
        (62, 184): u*v/w, (62, 195): u/w, (62, 208): -v/w, (62, 211):
        v**3/w**2, (62, 281): -u**2*v/w**2, (62, 319): u*v**3/w**2,
        (62, 335): -u*v**2/w**3, (62, 373): u**2*v/w, (62, 427):
        u*v**2/w, (62, 470): -u*v/w**2, (62, 578): -u**2*v/w**2, (62,
        588): u*v**2/w**2, (62, 589): u*v**3/w**2, (62, 605):
        -u**3*v/w**2, (62, 615): u**2*v**2/w**2, (62, 616):
        u**2*v**3/w**2, (62, 618): u**2*v*(u*v - w)/w**2, (62, 632):
        -u**2*v**2/w**3, (62, 642): u*v**3/w**3, (62, 643):
        -u*v**2*(u*w - v**2)/w**3, (63, 63): v/w, (63, 131): -v**2/w,
        (63, 186): -v**2, (63, 200): v, (63, 237): -v**2/w, (63, 238):
        -v**3/w, (63, 239): -v**3/w**2, (63, 288): v, (63, 334):
        v**2/w, (63, 335): v**2/w, (63, 342): -v*(u*w - v**2)/w**2,
        (63, 377): -v**2*w, (63, 398): -v**2, (63, 400): -u*v**3/w,
        (63, 403): -v**3/w, (63, 457): -v**2, (63, 469): v, (63, 477):
        v**2/w, (63, 540): 1, (63, 541): u*v**2/w**2, (63, 568):
        -v**3/w, (63, 579): v*w, (63, 590): -v**3/w, (63, 595): -v**2,
        (63, 618): -v**3, (63, 622): v**2*(u*w - v**2)/w**2, (63,
        632): u*v**2/w, (63, 633): v**2, (63, 642): -v**3/w, (63,
        643): -v**4/w, (63, 644): -v**4/w**2, (64, 64): v/w, (64,
        201): v, (64, 218): -v**3/w**2, (64, 236): -v**2/w, (64, 238):
        -u*v**3/w**2, (64, 315): -v*(u*w - v**2)/w**2, (64, 329):
        v**2/w**2, (64, 330): -v**3/w**2, (64, 334): u*v**2/w**2, (64,
        335): v**2*(u*w - v**2)/w**3, (64, 378): 1, (64, 380):
        -u*v**3/w**2, (64, 397): -v**2/w, (64, 398): -u*v**2/w, (64,
        400): -v**3*(u**2 - v)/w**2, (64, 423): v**2/w, (64, 464):
        v/w, (64, 465): -v**2/w, (64, 469): u*v/w, (64, 470):
        -v**3/w**2, (64, 567): -v, (64, 573): -v*(u*v - w)/w, (64,
        578): -u*v**3/w**2, (64, 579): u*v, (64, 586): v**3/w, (64,
        588): v**4/w**2, (64, 618): -v**2*(u*v - w)/w, (64, 621):
        -v**2/w, (64, 627): -v**2*(u*v - w)/w**2, (64, 632):
        u*v**2*(u*w - v**2)/w**3, (64, 633): u*v**2/w, (64, 640):
        v**4/w**2, (64, 642): -v**3*(u*w - v**2)/w**3, (64, 643):
        -u*v**4/w**2, (65, 65): v/w, (65, 188): -v**2, (65, 200):
        u*v/w, (65, 255): v*w, (65, 271): -v**2/w, (65, 307): v**2/w,
        (65, 324): 1, (65, 325): v**2*(u*w - v**2)/w**3, (65, 328):
        v/w, (65, 330): u*v/w, (65, 335): 2*u*v**2/w**2, (65, 377):
        -u*v**2, (65, 415): v, (65, 460): -v**3/w**2, (65, 470):
        u*v/w, (65, 568): -u*v**3/w**2, (65, 578): u**2*v/w, (65,
        588): -u*v**2/w, (65, 590): -v**2/w, (65, 591): v**3/w, (65,
        595): -u*v**2/w, (65, 596): -u*v**3/w, (65, 614): -u*v**2,
        (65, 619): -v**2, (65, 621): u, (65, 622): u*v**2*(u*w -
        v**2)/w**3, (65, 627): u**2*v/w, (65, 632): 2*u**2*v**2/w**2,
        (65, 640): -u*v**2/w, (65, 642): -u*v**3/w**2, (65, 644):
        -v**3/w**2, (65, 645): v**4/w**2, (66, 66): v/w, (66, 201):
        u*v/w, (66, 238): -u*v**2/w**2, (66, 249): v, (66, 255): u*v,
        (66, 261): u*v/w, (66, 271): u*v**2/w**2, (66, 297): 1, (66,
        301): v/w, (66, 302): v**2/w**2, (66, 307): u*v**2/w**2, (66,
        315): -u*v*(u*w - v**2)/w**3, (66, 335): u*v/w**2, (66, 336):
        u*v**2/w**2, (66, 400): -v**2*(u**2 - v)/w**2, (66, 410): v/w,
        (66, 415): u*v/w, (66, 423): u*v**2/w**2, (66, 471): u*v/w,
        (66, 579): u**2*v/w, (66, 595): u**2*v**2/w**2, (66, 616):
        v**3/w, (66, 632): u**2*v/w**2, (66, 633): u**2*v**2/w**2,
        (66, 643): -u*v**3/w**2, (67, 63): 1/w, (67, 131): -v/w, (67,
        186): -v, (67, 200): u*v/w, (67, 237): -v/w, (67, 238):
        -v**2/w, (67, 239): -v**2/w**2, (67, 288): u*v/w, (67, 325):
        v*(u*v - w)/w**2, (67, 334): u*v**2/w**2, (67, 335):
        u*v**2/w**2, (67, 342): -u*v*(u*w - v**2)/w**3, (67, 377):
        -u*v**2, (67, 380): -v**2*(u*v - w)/w**2, (67, 398):
        -u*v**2/w, (67, 400): -u**2*v**3/w**2, (67, 403):
        -u*v**3/w**2, (67, 457): -u*v**2/w, (67, 469): u*v/w, (67,
        477): u*v**2/w**2, (67, 541): u*v/w**2, (67, 568):
        -u*v**3/w**2, (67, 579): u**2*v**2/w, (67, 590): -u*v**3/w**2,
        (67, 595): -u*v**2/w, (67, 618): -u*v**3/w, (67, 622):
        u*v**2*(u*w - v**2)/w**3, (67, 632): u**2*v**2/w**2, (67,
        633): u**2*v**3/w**2, (67, 642): -u*v**3/w**2, (67, 643):
        -u*v**4/w**2, (67, 644): -u*v**4/w**3, (68, 64): 1/w, (68,
        104): -v/w, (68, 105): v**2/w, (68, 201): u*v/w, (68, 212):
        -v**2/w**2, (68, 213): v**3/w**2, (68, 236): -v/w, (68, 238):
        -u*v**2/w**2, (68, 298): -v/w, (68, 315): -u**2*v/w**2, (68,
        319): -u*v**2*(u*v - w)/w**2, (68, 322): -u*v**3/w**2, (68,
        323): u*v**4/w**2, (68, 325): u*v/w**2, (68, 334): u*v/w**2,
        (68, 335): u**2*v**2/w**3, (68, 379): u*v/w**2, (68, 398):
        -u*v/w, (68, 400): -u**2*v**2/w**2, (68, 427): -u*v*(u*v -
        w)/w, (68, 430): -u*v**2/w, (68, 431): u*v**3/w, (68, 469):
        u/w, (68, 568): -u*v**2/w**2, (68, 579): u**2*v/w, (68, 590):
        -u*v**2/w**2, (68, 591): u*v**3/w**2, (68, 622): u*v*(u*w -
        v**2)/w**3, (68, 632): u**3*v**2/w**3, (68, 633):
        u**2*v**2/w**2, (68, 642): -u**2*v**3/w**3, (68, 643):
        u**2*v*(u*v*w - v**3 - w**2)/w**3, (68, 644): -u*v**3/w**3,
        (68, 645): -u*v**2*(u**2*v - u*w - v**2)/w**3, (68, 646):
        u**2*v**2/w**2, (68, 647): -u*v**2/w, (69, 65): 1/w, (69,
        103): -v, (69, 188): -v, (69, 200): u/w, (69, 210): -v/w, (69,
        211): -v**2/w, (69, 213): -u*v/w, (69, 244): -u**2*v/w, (69,
        255): u*v, (69, 299): v**2/w, (69, 318): -u*v/w, (69, 319):
        -u*v**2/w, (69, 321): -u*(u*v - w)/w, (69, 323): -u*v, (69,
        335): u*v/w**2, (69, 377): -u*v, (69, 427): -u*v, (69, 470):
        u/w, (69, 578): u**2/w, (69, 588): -u*v/w, (69, 589):
        -u*v**2/w, (69, 591): -u**2*v/w, (69, 616): -u**2*v**2/w, (69,
        619): -u*v**2/w, (69, 632): u**2*v/w**2, (69, 642):
        -u*v**2/w**2, (69, 643): u*v*(u*w - v**2)/w**2, (69, 645):
        -u**2*v**2/w**2, (70, 66): 1/w, (70, 103): -u*v/w, (70, 106):
        -v/w, (70, 161): -v, (70, 201): u/w, (70, 209): -v/w, (70,
        211): -u*v**2/w**2, (70, 214): -v**2/w**2, (70, 238):
        -u*v/w**2, (70, 255): u, (70, 269): -u*v, (70, 315):
        -u**2/w**2, (70, 317): -u*v/w, (70, 319): -u*v*(2*u*v -
        w)/w**2, (70, 322): -u*v**2/w**2, (70, 335): u**2*v/w**3, (70,
        336): u*v/w**2, (70, 400): -u**2*v/w**2, (70, 427): -u*(2*u*v
        - w)/w, (70, 430): -u*v/w, (70, 471): u/w, (70, 579): u**2/w,
        (70, 587): -u*v/w, (70, 589): -u**2*v**2/w**2, (70, 592):
        -u*v**2/w**2, (70, 616): -u**2*v/w, (70, 619): -u*v/w, (70,
        632): u**3*v/w**3, (70, 633): u**2*v/w**2, (70, 641):
        -u*v**2/w**2, (70, 642): -u**2*v**2/w**3, (70, 643):
        u**2*v*(u*w - 2*v**2)/w**3, (70, 645): -u**2*v*(u*v - w)/w**3,
        (70, 646): u*v*(u*w - v**2)/w**3, (70, 647): -u*v/w, (71, 72):
        1/w, (71, 105): -v, (71, 184): -v, (71, 213): -v**2/w, (71,
        241): -v/w, (71, 281): u*v/w, (71, 323): -u*v**3/w, (71, 335):
        -u**2*v/w**2, (71, 336): u*v/w, (71, 342): u*v/w**2, (71,
        373): -u**2*v**2/w, (71, 403): -u*v/w, (71, 431): -u*v**2,
        (71, 477): u/w, (71, 591): -u*v**2/w, (71, 605): u**2*v/w,
        (71, 615): -u*v**2/w, (71, 616): -u*v**3/w, (71, 618):
        -u**2*v**2/w, (71, 623): -v**2*(u*v - w)/w**2, (71, 632):
        -u**3*v/w**2, (71, 633): u**2*v/w, (71, 641): -u*v**2/w, (71,
        642): u**2*v**2/w**2, (71, 645): u*v**2*(u**2 - v)/w**2, (71,
        646): -u*v**3/w**2, (72, 72): v/w, (72, 184): -v**2, (72,
        241): -v**2/w, (72, 281): v, (72, 330): v**2/w, (72, 335):
        -v*(u*w - v**2)/w**2, (72, 336): v, (72, 342): u*v**2/w**2,
        (72, 373): -u*v**2, (72, 403): -u*v**2/w, (72, 465): v, (72,
        470): v**2/w, (72, 477): u*v/w, (72, 567): w, (72, 573): u*v,
        (72, 578): u*v**2/w, (72, 586): -v**2, (72, 588): -v**3/w,
        (72, 605): u*v, (72, 615): -v**2, (72, 616): -v**3, (72, 621):
        v, (72, 623): -v**3/w, (72, 627): u*v**2/w, (72, 632):
        -u*v*(u*w - v**2)/w**2, (72, 633): u*v, (72, 640): -v**3/w,
        (72, 641): -v**2, (72, 642): v**2*(u*w - v**2)/w**2, (72,
        646): -v**3/w, (73, 194): 1/w, (73, 195): -v/w, (73, 265):
        v**2, (73, 373): -u*v**2/w, (73, 590): -u*v**2/w**2, (73,
        591): u*v**3/w**2, (73, 617): -u*v/w, (73, 618): u*v**2/w,
        (73, 643): u*v**3/w**2, (73, 644): -u*v**3/w**3, (73, 645):
        u*v**4/w**3, (74, 199): 1/w, (74, 201): -v/w, (74, 320):
        -v**2/w**2, (74, 321): v**3/w**2, (74, 322): v**3/w**2, (74,
        323): -v**4/w**2, (74, 379): -v/w**2, (74, 428): -v/w, (74,
        429): v**2/w, (74, 430): v**2/w, (74, 431): -v**3/w, (74,
        568): v**2/w**2, (74, 577): u/w, (74, 579): -u*v/w, (74, 622):
        v**3/w**3, (74, 631): u*v/w**2, (74, 633): -u*v**2/w**2, (74,
        643): -u*v*(u*v - w)/w**2, (74, 644): u*v/w**2, (74, 645):
        -u*v**2/w**2, (74, 646): -u*v**2/w**2, (74, 647): v**2/w, (75,
        198): 1/w, (75, 200): -v/w, (75, 315): -v/w, (75, 342):
        u*v/w**2, (75, 374): u*v/w, (75, 375): -v, (75, 376):
        -u*v**2/w, (75, 377): v**2, (75, 541): -v/w**2, (75, 568):
        v**3/w**2, (75, 577): u*v/w, (75, 579): -u*v**2/w, (75, 585):
        u*v**2/w**2, (75, 595): v**2/w, (75, 612): u*v/w, (75, 622):
        v**4/w**3, (75, 631): u*v**2/w**2, (75, 633): -u*v**3/w**2,
        (75, 639): u*v**3/w**3, (75, 645): -v**2*(u*v - w)/w**2, (76,
        315): 1/w, (76, 335): -v/w**2, (76, 632): -u*v/w**2, (76,
        642): v**2/w**2, (76, 643): v**3/w**2, (76, 645): v*(u*v -
        w)/w**2, (77, 319): -v**2, (77, 333): 1/w, (77, 334): -v/w,
        (77, 342): -v**2/w**2, (77, 353): v**3/w, (77, 371): v**2,
        (77, 372): -v, (77, 373): v**2*(u*v - w)/w, (77, 374):
        -v**2/w, (77, 376): v**3/w, (77, 595): -v, (77, 630): u/w,
        (77, 631): -u*v/w, (77, 639): -u*v**2/w**2, (77, 644):
        v**3/w**2, (78, 82): -v/w, (78, 190): -v**2/w**2, (78, 306):
        1/w, (78, 325): -v**3/w**3, (78, 342): -v/w**2, (78, 374):
        -v/w, (78, 376): v**2/w, (78, 460): -v**2/w**2, (78, 568):
        -2*u*v**2/w**2, (78, 595): -u*v/w, (78, 622): u*v*(u*w -
        2*v**2)/w**3, (78, 639): -u*v/w**2, (78, 645): v**3/w**2, (79,
        207): 1/w, (79, 335): u*v/w**2, (79, 336): -v/w, (79, 373):
        v*(u*v - w)/w, (79, 585): u/w, (79, 623): v**3/w**2, (79,
        632): u**2*v/w**2, (79, 633): -u*v/w, (79, 639): u*v/w**2,
        (79, 641): v**2/w, (79, 642): -u*v**2/w**2, (79, 645):
        -u*v*(u*v - w)/w**2, (79, 646): v**3/w**2, (80, 298):
        u*v/w**2, (80, 308): 1/w, (80, 309): -v/w, (80, 643): v*(u*v -
        w)/w**2, (80, 646): v**2/w**2, (81, 6): -u/w, (81, 8): 1, (81,
        100): u*v/w, (81, 127): -u/w, (81, 157): -u*v**2/w, (81, 184):
        u*v/w, (81, 211): u**2*v**2/w**2, (81, 238): -u**2*v/w**2,
        (82, 82): v/w, (82, 585): -u/w, (82, 595): u*v/w, (82, 605):
        1, (82, 606): -v, (82, 622): -u**2*v/w**2, (82, 632): -u/w,
        (82, 633): u*v/w, (83, 83): v/w, (83, 268): u, (83, 269):
        -u*v, (83, 271): -u*v/w**2, (83, 322): -u**2/w, (83, 323):
        u**2*v/w, (83, 325): u/w**2, (83, 407): u*v/w, (83, 424): 1,
        (83, 595): -u**2*v/w**2, (83, 596): u*v/w, (83, 622):
        u**2/w**2, (83, 623): -u**2*v/w**2, (84, 87): -u/w, (84, 88):
        -u/w, (84, 89): 1, (84, 100): -u**2/w, (84, 265): -u*v**2/w,
        (84, 319): u*v*(u**2*v**2 - u*v*w + w**2)/w**3, (84, 373):
        u**2*v**2/w**2, (84, 400): -u**2*v/w**2, (84, 589):
        u**2*v**2/w**2, (84, 643): u**3*v*(u*v - w)/w**3, (85, 87):
        -u*v/w, (85, 100): -u, (85, 115): -u/w, (85, 116): 1, (85,
        265): -u*v**3/w, (85, 319): u**2*v**3/w**2, (85, 373):
        u**2*v**3/w**2, (85, 400): -u**2*v**2/w**2, (85, 589):
        u**2*v**3/w**2, (85, 616): u*v*(u*v - w)**2/w**2, (85, 643):
        u**2*v*(u*v - w)/w**2, (86, 86): v/w, (86, 111): 1, (86, 115):
        v/w, (86, 127): u*v/w, (86, 373): -u**2*v**2*(u*v - w)/w**2,
        (86, 591): u*v**2*(u*v - w)/w**2, (86, 607): v**2*(u*v -
        w)/w**2, (86, 615): u*v**2*(u*v - w)/w**2, (86, 618):
        u**2*v**2*(u*v - w)/w**2, (86, 644): u*v**2*(u*v - w)/w**3,
        (87, 87): v/w, (87, 115): 1/w, (87, 373): -u*v**3/w**2, (87,
        400): u*v**2/w**2, (87, 460): u**2*v**2/w**3, (87, 568):
        u**3*v**2/w**3, (87, 580): -v**2/w**2, (87, 589):
        -u*v**3/w**2, (87, 591): u*v*(u*v - w)/w**2, (87, 616):
        -u*v**2*(u*v - w)/w**2, (87, 617): -u*v**2/w**2, (87, 618):
        u*v**3/w**2, (87, 644): u**2*v**2/w**3, (87, 645):
        -u*v**2/w**2, (88, 84): 1, (88, 85): -u/w, (88, 87): -u**2/w,
        (88, 88): v/w, (88, 127): u/w, (88, 265): -u**2*v**2/w, (88,
        319): u**3*v**2/w**2, (88, 373): u**2*v/w, (88, 400):
        -u**3*v/w**2, (88, 589): u**3*v**2/w**2, (88, 591):
        u**2*v**2*(u*v - w)/w**3, (88, 607): u*v**2*(u*v - w)/w**3,
        (88, 615): u**2*v**2*(u*v - w)/w**3, (88, 616): u**2*v**3*(u*v
        - w)/w**3, (88, 618): u**3*v**2*(u*v - w)/w**3, (88, 644):
        u**2*v**2*(u*v - w)/w**4, (89, 88): 1/w, (89, 100): u/w, (89,
        591): u**2*v*(u*v - w)/w**3, (89, 607): u*v*(u*v - w)/w**3,
        (89, 615): u**2*v*(u*v - w)/w**3, (89, 616): u**2*v**2*(u*v -
        w)/w**3, (89, 618): u**3*v*(u*v - w)/w**3, (89, 643):
        -u**2*v*(u*v - w)/w**3, (89, 644): u**2*v*(u*v - w)/w**4, (90,
        90): v/w, (90, 121): v/w, (90, 129): u*v/w, (90, 130):
        u*v**2/w, (90, 374): -v**2/w, (90, 375): v**3/w, (90, 401):
        v/w, (90, 402): -v**2/w, (90, 446): v, (90, 452): u*v, (90,
        454): u**2*v**2/w, (90, 487): -v**2/w**2, (90, 489): 1, (90,
        563): u*v*(u*v - w)/w**3, (90, 580): v**2/w, (90, 588):
        u*v**2/w, (90, 589): v**2*(u*v + w)/w, (90, 604): v, (90,
        631): -u*v/w, (91, 91): v/w, (91, 110): u*v**2/w**2, (91,
        122): v/w, (91, 128): u*v/w, (91, 130): u**2*v**2/w**2, (91,
        434): u**2*v**2/w**2, (91, 435): 1, (91, 446): u*v/w, (91,
        451): u*v/w, (91, 452): u**2*v/w, (91, 454): u*v**2*(u**2 -
        v)/w**2, (91, 569): u*v**3/w**2, (91, 581): v**2/w, (91, 587):
        u*v**2/w, (91, 589): u*v**2*(u*v + w)/w**2, (91, 591):
        -u*v**3/w**2, (91, 592): v**2/w, (91, 599): v/w, (91, 604):
        u*v/w, (91, 607): -v**3/w**2, (91, 615): -u*v**3/w**2, (91,
        616): -u*v**4/w**2, (91, 617): -u*v/w, (91, 618): -u*v**2*(u*v
        - 2*w)/w**2, (91, 626): -u*v/w**2, (91, 631): -u**2*v/w**2,
        (91, 634): v**2/w**2, (91, 642): u*v**2/w**2, (91, 643):
        u*v**3/w**2, (91, 644): v*(u**2*w - u*v**2 + v*w)/w**3, (91,
        645): -u**2*v**2/w**2, (92, 92): v/w, (92, 121): 1/w, (92,
        377): v**3/w, (92, 404): -v**2/w, (92, 445): u/w, (92, 449):
        -v/w, (92, 580): v/w, (92, 585): u**2*v/w**2, (92, 589): v,
        (92, 606): u*v**2/w, (92, 633): -u**2*v**2/w**2, (93, 93):
        v/w, (93, 122): 1/w, (93, 130): u**2*v/w**2, (93, 446): u/w,
        (93, 454): u*v*(u**2 - v)/w**2, (93, 460): u**2/w**2, (93,
        568): u**3/w**2, (93, 581): v/w, (93, 589): u*v*(u*v +
        w)/w**2, (93, 592): v/w, (93, 593): -v**2/w, (93, 606): u*v/w,
        (93, 617): -u/w, (93, 618): u*v/w, (93, 633): -u**2*v/w**2,
        (93, 644): u**2/w**2, (93, 645): -u**2*v/w**2, (94, 92):
        -u**2/w, (94, 94): v/w, (94, 129): u/w, (94, 130): u*v/w, (94,
        265): u**2*v, (94, 271): u*v**2/w**2, (94, 319): -u**3*v/w,
        (94, 325): -u**2*v**2/w**3, (94, 376): u**2*v/w, (94, 377):
        -u**2*v**2/w, (94, 403): -u**3*v/w**2, (94, 404): u**2*v/w,
        (94, 415): -u*v/w, (94, 419): v, (94, 434): u*v*(u*v -
        w)/w**2, (94, 452): u**2*v/w, (94, 454): u**3*v**2/w**2, (94,
        460): -u**2*v/w**2, (94, 462): 1, (94, 463): -u/w, (94, 470):
        -u**2*v/w**2, (94, 477): u**3/w**2, (94, 568): -u**3*v/w**2,
        (94, 578): -u**3*v/w**2, (94, 580): u*v**2/w**2, (94, 588):
        u**2*v**2/w**2, (94, 589): -u**2*v*(u*w - 2*v**2)/w**2, (94,
        590): u*v**2/w**2, (94, 591): -u*v**3/w**2, (94, 595):
        u**2*v**2/w**2, (94, 606): -u**3*v/w, (94, 608): u*v**2/w,
        (94, 616): u**2*v**2*(u*v - w)/w**2, (94, 617):
        u**2*v**2/w**2, (94, 618): -u**2*v**3/w**2, (94, 622):
        -u**3*v**2/w**3, (94, 633): u**4*v/w**2, (94, 635): -u*v/w,
        (94, 644): -u**3*v**2/w**3, (94, 645): u**2*v**2/w**2, (95,
        93): -u**2/w, (95, 95): v/w, (95, 128): u/w, (95, 130):
        u**2*v/w**2, (95, 265): u**3*v/w, (95, 268): u**2*v/w, (95,
        269): -u**2*v**2/w, (95, 271): u**2*v**2/w**3, (95, 319):
        -u**4*v/w**2, (95, 322): -u**3*v/w**2, (95, 323):
        u**3*v**2/w**2, (95, 325): -u**3*v**2/w**4, (95, 408): 1, (95,
        409): -u/w, (95, 415): -u**2*v/w**2, (95, 419): u*v/w, (95,
        423): u**3/w**2, (95, 452): u**2/w, (95, 454): u**3*v/w**2,
        (95, 460): -u**2/w**2, (95, 470): -u**3*v/w**3, (95, 568):
        -u**3/w**2, (95, 578): -u**4*v/w**3, (95, 580): u*v/w**2, (95,
        588): u**3*v**2/w**3, (95, 589): -u**2*v*(u**2*w - u*v**2 -
        v*w)/w**3, (95, 590): u**2*v**2/w**3, (95, 591):
        u**2*v*(u**2*v - u*w - v**2)/w**3, (95, 592): -u**3*v/w**2,
        (95, 593): u**2*v/w, (95, 595): u**3*v**2/w**3, (95, 606):
        -u**3/w, (95, 608): u*v/w, (95, 617): u**2*v/w**2, (95, 618):
        -u**2*v**2/w**2, (95, 622): -u**4*v**2/w**4, (95, 633):
        u**4/w**2, (95, 635): -u**2*v/w**2, (95, 644): -u**3*v/w**3,
        (95, 645): u**2*v/w**2, (96, 94): 1/w, (96, 102): u/w, (96,
        105): u**2/w, (96, 407): -u*v/w, (96, 418): u/w, (96, 422):
        -v/w, (96, 426): u**2/w, (96, 428): u/w, (96, 429): u*(u**2 -
        v)/w, (96, 430): -u*v/w, (96, 431): u*v**2/w, (96, 589):
        -u*v*(u*v - w)/w**2, (96, 607): u/w, (96, 611): -u*v**2/w**2,
        (96, 615): u**2/w, (96, 616): -u**2*v*(u*v - w)/w**2, (96,
        618): u**3/w, (96, 619): -u**2*v**2/w**2, (96, 634):
        -u**2/w**2, (96, 638): u*v/w**2, (96, 642): -u**3/w**2, (96,
        645): -u**4/w**2, (96, 646): u**2*v/w**2, (97, 95): 1/w, (97,
        101): u/w, (97, 130): u**2/w**2, (97, 265): u*(u**2 - v)/w,
        (97, 271): u**2*v/w**3, (97, 319): -u**2*(u**2 - v)/w**2, (97,
        325): -u**3*v/w**4, (97, 415): -u**2/w**2, (97, 419): u/w,
        (97, 425): u**2/w, (97, 454): u**3/w**2, (97, 470):
        -u**3/w**3, (97, 578): -u**4/w**3, (97, 588): u**3*v/w**3,
        (97, 589): u*(u**2*v**2 + w**2)/w**3, (97, 590): u**2*v/w**3,
        (97, 591): u**2*v*(u**2 - v)/w**3, (97, 595): u**3*v/w**3,
        (97, 608): u/w, (97, 614): u**2/w, (97, 622): -u**4*v/w**4,
        (97, 635): -u**2/w**2, (97, 641): -u**3/w**2, (98, 98): v/w,
        (98, 133): u/w, (98, 269): u**2*v, (98, 323): -u**3*v/w, (98,
        325): u**2*(u*v - w)/w**3, (98, 373): -u*v**2*(u**2 - v)/w**2,
        (98, 400): u*v*(u**2 - v)/w**2, (98, 410): -u/w, (98, 412): 1,
        (98, 422): u*v/w, (98, 423): -u**2*v/w**2, (98, 457): u**2/w,
        (98, 470): u**3/w**2, (98, 471): -u**2/w, (98, 569): u*v*(u*v
        - w)/w**2, (98, 578): u**4/w**2, (98, 579): -u**3/w, (98,
        587): u**2*v/w, (98, 588): -u**3*v/w**2, (98, 591): -u*v*(u**3
        - w)/w**2, (98, 592): u**2*v**2/w**2, (98, 607): -u*v**2/w**2,
        (98, 611): u*v/w, (98, 615): -u**2*v**2/w**2, (98, 616):
        -u**2*v**3/w**2, (98, 618): -u**2*v*(u*v - w)/w**2, (98, 622):
        u**3*(u*v - w)/w**3, (98, 634): u*v/w**2, (98, 638):
        -u**2*v/w**2, (98, 642): u**2*v/w**2, (98, 643):
        u**2*v**2/w**2, (99, 99): v/w, (99, 125): v/w, (99, 133):
        u*v/w, (99, 373): v**3/w, (99, 400): -v**2/w, (99, 439): 1,
        (99, 449): u*v/w, (99, 457): u**2*v/w, (99, 584): v**2/w, (99,
        591): v, (99, 592): u*v**2/w, (99, 612): u*v/w, (99, 618):
        -u*v, (99, 639): -u**2*v/w**2, (99, 645): u**2*v/w, (100, 85):
        1/w, (100, 87): u/w, (100, 100): v/w, (100, 265): u*v**2/w,
        (100, 319): -u**2*v**2/w**2, (100, 325): u**2*v*(u*v -
        w)/w**4, (100, 373): -u**2*v**2/w**2, (100, 400): u**2*v/w**2,
        (100, 589): -u**2*v**2/w**2, (100, 622): u**3*v*(u*v -
        w)/w**4, (100, 642): u*v*(u*v - w)/w**3, (100, 645):
        u**2*v*(u*v - w)/w**3, (101, 93): u/w, (101, 101): v/w, (101,
        268): -u*v/w, (101, 269): u*v**2/w, (101, 322): u**2*v/w**2,
        (101, 323): -u**2*v**2/w**2, (101, 409): 1/w, (101, 423):
        -u**2/w**2, (101, 425): u*v/w, (101, 588): u*v/w**2, (101,
        589): u**3*v/w**2, (101, 591): u**2*v/w**2, (101, 592):
        u**2*v/w**2, (101, 593): -u*v/w, (101, 606): u**2/w, (101,
        614): u*v/w, (101, 633): -u**3/w**2, (101, 641): -u**2*v/w**2,
        (102, 92): u/w, (102, 102): v/w, (102, 376): -u**2*v**2/w**2,
        (102, 377): u*v**2/w, (102, 403): u**2*v/w**2, (102, 404):
        -u*v/w, (102, 425): v, (102, 463): 1/w, (102, 477):
        -u**2/w**2, (102, 588): u*v**2/w**2, (102, 589): u**2*v/w,
        (102, 591): u**2*v**2/w**2, (102, 606): u**2*v/w, (102, 614):
        u*v**2/w, (102, 633): -u**3*v/w**2, (102, 641): -u*v/w, (103,
        103): v/w, (103, 271): -v/w**2, (103, 325): u*v/w**3, (103,
        415): 1/w, (103, 427): u*v/w, (103, 470): u/w**2, (103, 578):
        u**2/w**2, (103, 588): -u*v/w**2, (103, 589): -u*v**2/w**2,
        (103, 590): -v/w**2, (103, 591): -v*(u**2 - v)/w**2, (103,
        595): -u*v/w**2, (103, 616): u*v/w, (103, 622): u**2*v/w**3,
        (103, 643): -u**2*v/w**2, (104, 104): v/w, (104, 164):
        v**3/w**2, (104, 218): -v**2/w**2, (104, 353): 2*u*v**3/w**2,
        (104, 370): v**2/w, (104, 371): u*v**2/w, (104, 373):
        v**3*(u**2 - v)/w**2, (104, 376): u*v**3/w**2, (104, 380):
        -2*u*v**2/w**2, (104, 397): -v/w, (104, 398): -u*v/w, (104,
        400): -v**2*(u**2 - v)/w**2, (104, 403): -u*v**2/w**2, (104,
        423): v/w, (104, 427): u*v, (104, 430): v, (104, 464): 1/w,
        (104, 469): u/w, (104, 477): u*v/w**2, (104, 572): u/w, (104,
        577): u**2/w, (104, 585): u**2*v/w**2, (104, 591): -v**2/w,
        (104, 595): -u*v/w, (104, 596): v**4/w**2, (104, 617): u*v/w,
        (104, 622): u**2*v/w**2, (104, 623): -v**3/w**2, (104, 644):
        -u**2*v/w**2, (105, 105): v/w, (105, 376): u*v**2/w**2, (105,
        403): -u*v/w**2, (105, 431): v, (105, 465): 1/w, (105, 470):
        v/w**2, (105, 477): u/w**2, (105, 573): u/w, (105, 578):
        u*v/w**2, (105, 585): u**2/w**2, (105, 586): -v/w, (105, 588):
        -v**2/w**2, (105, 591): -u*v**2/w**2, (105, 596): v**3/w**2,
        (105, 618): u*v/w, (105, 623): -v**2/w**2, (105, 645):
        -u**2*v/w**2, (106, 106): v/w, (106, 271): u*v/w**2, (106,
        325): -u**2*v/w**3, (106, 373): v**2*(u**2 - v)/w**2, (106,
        400): -v*(u**2 - v)/w**2, (106, 410): 1/w, (106, 423):
        u*v/w**2, (106, 430): u*v/w, (106, 470): -u**2/w**2, (106,
        471): u/w, (106, 569): -u*v**2/w**2, (106, 578): -u**3/w**2,
        (106, 579): u**2/w, (106, 587): -u*v/w, (106, 588):
        u**2*v/w**2, (106, 590): u*v/w**2, (106, 591): u*v*(u**2 -
        v)/w**2, (106, 592): -u*v**2/w**2, (106, 595): u**2*v/w**2,
        (106, 619): u*v/w, (106, 622): -u**3*v/w**3, (106, 646):
        -u**2*v/w**2, (107, 107): v/w, (107, 411): 1/w, (107, 417):
        u/w, (107, 423): u/w**2, (107, 431): u*v/w, (107, 460):
        u*v/w**3, (107, 568): u**2*v/w**3, (107, 589): -v*(u**2 -
        v)/w**2, (107, 592): -u*v/w**2, (107, 620): u*v/w, (107, 647):
        -u**2*v/w**2, (108, 5): -u/w, (108, 7): 1, (109, 568):
        -v**2/w, (109, 589): -v**2, (109, 603): 1, (109, 604): -v,
        (109, 630): -u/w, (109, 631): u*v/w, (109, 639): v*(u*v -
        w)/w**2, (110, 268): w, (110, 269): -v*w, (110, 322): -u,
        (110, 323): u*v, (111, 19): 1, (111, 86): -u/w, (111, 319):
        u*v**2*(u*v - w)/w**2, (111, 346): -u*v*(u*v - w)/w**2, (112,
        87): -v, (112, 113): -u/w, (112, 114): 1, (112, 265): -v**3,
        (112, 292): v**2, (112, 319): u*v**3/w, (112, 346): -u*v**2/w,
        (112, 373): u*v**3/w, (112, 400): -u*v**2/w, (112, 535):
        -u*v**2/w, (112, 562): u*v/w, (112, 589): u*v**3/w, (112,
        616): u*v**2*(u*v - w)/w, (113, 112): 1, (113, 113): v/w,
        (113, 127): v, (113, 271): u*v**2*(u*v - w)/w**2, (113, 373):
        -u*v**2*(u*v - w)/w, (113, 595): u**2*v**2*(u*v - w)/w**2,
        (113, 615): v**2*(u*v - w)/w, (113, 618): u*v**2*(u*v - w)/w,
        (114, 113): 1/w, (114, 271): u*v*(u*v - w)/w**2, (114, 460):
        u*v**2/w**2, (114, 568): u**2*v**2/w**2, (114, 595):
        u**2*v*(u*v - w)/w**2, (114, 616): -v**2*(u*v - w)/w, (114,
        617): -v**2/w, (114, 618): v**3/w, (114, 644): u*v**2/w**2,
        (114, 645): -u*v**3/w**2, (115, 87): -u, (115, 127): 1, (115,
        265): -u*v**2, (115, 271): u**2*v**2*(u*v - w)/w**3, (115,
        319): u**2*v**2/w, (115, 373): u*v, (115, 400): -u**2*v/w,
        (115, 589): u**2*v**2/w, (115, 595): u**3*v**2*(u*v - w)/w**3,
        (115, 615): u*v**2*(u*v - w)/w**2, (115, 616): u*v**3*(u*v -
        w)/w**2, (115, 618): u**2*v**2*(u*v - w)/w**2, (116, 100): 1,
        (116, 271): u**2*v*(u*v - w)/w**3, (116, 595): u**3*v*(u*v -
        w)/w**3, (116, 615): u*v*(u*v - w)/w**2, (116, 616):
        u*v**2*(u*v - w)/w**2, (116, 618): u**2*v*(u*v - w)/w**2,
        (116, 643): -u*v*(u*v - w)/w**2, (117, 117): v/w, (117, 129):
        v, (117, 130): v**2, (117, 136): -v**2, (117, 190): v, (117,
        271): -v**3/w, (117, 325): v**2/w, (117, 442): v, (117, 452):
        v*w, (117, 454): u*v**2, (117, 487): -v**3/w**2, (117, 490):
        1, (117, 536): -v**2/w, (117, 537): v**3/w, (117, 563):
        u*v**2/w**2, (117, 564): -v**2/w, (117, 588): v**2, (117,
        589): v**3, (117, 595): -u*v**3/w, (117, 622): u*v**2/w, (118,
        110): v**2/w, (118, 118): v/w, (118, 128): v, (118, 130):
        u*v**2/w, (118, 271): -u*v**3/w**2, (118, 325): u*v**2/w**2,
        (118, 434): u*v**2/w, (118, 436): 1, (118, 442): u*v/w, (118,
        451): v, (118, 452): u*v, (118, 454): v**2*(u**2 - v)/w, (118,
        460): -u*v/w, (118, 568): -u**2*v/w, (118, 569): v**3/w, (118,
        587): v**2, (118, 589): u*v**3/w, (118, 590): -u*v**3/w**2,
        (118, 592): v**3/w, (118, 595): -u**2*v**3/w**2, (118, 599):
        v**2/w, (118, 615): -v**3/w, (118, 618): -v**2*(u*v - w)/w,
        (118, 622): u**2*v**2/w**2, (118, 626): -u*v**2/w**2, (118,
        642): v**2/w, (118, 644): -v**3*(u*v - w)/w**3, (119, 117):
        1/w, (119, 136): -u*v**2/w, (119, 190): u*v/w, (119, 271):
        -u*v**3/w**2, (119, 325): u*v**2/w**2, (119, 441): u/w, (119,
        450): -v/w, (119, 487): -v**2/w**2, (119, 537): v**2/w, (119,
        564): -v/w, (119, 568): u**2*v/w, (119, 589): u*v**3/w, (119,
        595): -u**2*v**3/w**2, (119, 603): -u*v/w, (119, 604):
        u*v**2/w, (119, 612): v**2/w, (119, 622): v**2*(u**2*w -
        u*v**2 + v*w)/w**3, (119, 630): u**2*v/w**2, (119, 631):
        -u**2*v**2/w**2, (119, 639): -u**2*v**3/w**3, (120, 118): 1/w,
        (120, 130): u*v/w, (120, 271): -u*v**2/w**2, (120, 325):
        u*v/w**2, (120, 433): -v**2/w**2, (120, 442): u/w, (120, 454):
        v*(u**2 - v)/w, (120, 589): u*v**2/w, (120, 595): -v**2*(u**2
        - v)/w**2, (120, 616): v**3/w, (120, 622): u*v*(u*w -
        v**2)/w**3, (120, 643): -v**2/w, (121, 92): -u, (121, 129): 1,
        (121, 130): v, (121, 265): u*v*w, (121, 319): -u**2*v, (121,
        376): u*v, (121, 377): -u*v**2, (121, 403): -u**2*v/w, (121,
        404): u*v, (121, 434): v*(u*v - w)/w, (121, 452): u*v, (121,
        454): u**2*v**2/w, (121, 460): -u*v/w, (121, 470): -u*v/w,
        (121, 477): u**2/w, (121, 568): -u**2*v/w, (121, 578):
        -u**2*v/w, (121, 588): u*v**2/w, (121, 589): -u*v*(u*w -
        v**2)/w, (121, 606): -u**2*v, (121, 617): u*v**2/w, (121,
        618): -u*v**3/w, (121, 633): u**3*v/w, (121, 644):
        -u**2*v**2/w**2, (121, 645): u*v**2/w, (122, 93): -u, (122,
        128): 1, (122, 130): u*v/w, (122, 265): u**2*v, (122, 268):
        u*v, (122, 269): -u*v**2, (122, 319): -u**3*v/w, (122, 322):
        -u**2*v/w, (122, 323): u**2*v**2/w, (122, 423): u**2/w, (122,
        452): u, (122, 454): u**2*v/w, (122, 460): -u/w, (122, 470):
        -u**2*v/w**2, (122, 568): -u**2/w, (122, 578): -u**3*v/w**2,
        (122, 588): u**2*v**2/w**2, (122, 589): -u**2*v*(u*w -
        v**2)/w**2, (122, 591): u**2*v*(u*v - w)/w**2, (122, 592):
        -u**2*v/w, (122, 593): u*v, (122, 606): -u**2, (122, 617):
        u*v/w, (122, 618): -u*v**2/w, (122, 633): u**3/w, (122, 644):
        -u**2*v/w**2, (122, 645): u*v/w, (123, 102): 1, (123, 105): u,
        (123, 407): -v, (123, 426): u, (123, 429): u**2, (123, 615):
        u, (123, 616): -u*v*(u*v - w)/w, (123, 618): u**2, (123, 619):
        -u*v**2/w, (123, 642): -u**2/w, (123, 645): -u**3/w, (123,
        646): u*v/w, (124, 101): 1, (124, 130): u/w, (124, 265): u**2,
        (124, 319): -u**3/w, (124, 425): u, (124, 454): u**2/w, (124,
        470): -u**2/w**2, (124, 578): -u**3/w**2, (124, 588):
        u**2*v/w**2, (124, 589): u**2*v**2/w**2, (124, 591):
        u**3*v/w**2, (124, 614): u, (124, 641): -u**2/w, (125, 133):
        1, (125, 269): u*v*w, (125, 271): -u*v*(u*v - w)/w**2, (125,
        323): -u**2*v, (125, 325): u*(u*v - w)/w**2, (125, 373):
        -u**2*v**2/w, (125, 400): u**2*v/w, (125, 457): u, (125, 470):
        u**2/w, (125, 471): -u, (125, 569): v*(u*v - w)/w, (125, 578):
        u**3/w, (125, 579): -u**2, (125, 587): u*v, (125, 588):
        -u**2*v/w, (125, 591): -u**3*v/w, (125, 592): u*v**2/w, (125,
        595): -u**2*v*(u*v - w)/w**2, (125, 615): -u*v**2/w, (125,
        616): -u*v**3/w, (125, 618): -u*v*(u*v - w)/w, (125, 622):
        u**2*(u*v - w)/w**2, (125, 642): u*v/w, (125, 643): u*v**2/w,
        (126, 126): v/w, (126, 133): v, (126, 271): v, (126, 325):
        -u*v/w, (126, 437): 1, (126, 450): u*v/w, (126, 457): u*v,
        (126, 590): u*v**2/w, (126, 595): u*v, (126, 599): -v, (126,
        622): -u**2*v/w, (126, 626): u*v/w, (126, 644): v**2*(u*v -
        w)/w**2, (127, 87): 1, (127, 265): v**2, (127, 319):
        -u*v**2/w, (127, 373): -u*v**2/w, (127, 400): u*v/w, (127,
        589): -u*v**2/w, (127, 645): u*v*(u*v - w)/w**2, (128, 93): 1,
        (128, 268): -v, (128, 269): v**2, (128, 322): u*v/w, (128,
        323): -u*v**2/w, (128, 423): -u/w, (128, 589): u**2*v/w, (128,
        591): u*v/w, (128, 592): u*v/w, (128, 593): -v, (128, 606): u,
        (128, 633): -u**2/w, (129, 92): 1, (129, 376): -u*v**2/w,
        (129, 377): v**2, (129, 403): u*v/w, (129, 404): -v, (129,
        477): -u/w, (129, 589): u*v, (129, 591): u*v**2/w, (129, 606):
        u*v, (129, 633): -u**2*v/w, (130, 470): 1/w, (130, 578): u/w,
        (130, 588): -v/w, (130, 589): -v**2/w, (130, 591): -u*v/w,
        (131, 353): v**3/w, (131, 371): v**2, (131, 373): u*v**3/w,
        (131, 376): v**3/w, (131, 380): -v**2/w, (131, 398): -v, (131,
        400): -u*v**2/w, (131, 403): -v**2/w, (131, 427): v*w, (131,
        469): 1, (131, 477): v/w, (131, 577): u, (131, 585): u*v/w,
        (131, 590): -v**2/w, (131, 595): -v, (131, 622): u*v/w, (132,
        376): v**2/w, (132, 403): -v/w, (132, 477): 1/w, (132, 585):
        u/w, (132, 591): -v**2/w, (133, 373): u*v**2/w, (133, 400):
        -u*v/w, (133, 470): -u/w, (133, 471): 1, (133, 569): -v**2/w,
        (133, 578): -u**2/w, (133, 579): u, (133, 587): -v, (133,
        588): u*v/w, (133, 591): u**2*v/w, (133, 592): -v**2/w, (134,
        417): 1, (134, 589): -u*v/w, (134, 592): -v/w, (135, 33):
        -u/w, (135, 35): 1, (135, 154): u*v/w, (135, 181): -u/w, (135,
        211): -u*v**2/w**2, (135, 238): u*v/w**2, (136, 136): v/w,
        (136, 612): -u/w, (136, 622): u*v/w**2, (136, 632): 1/w, (136,
        633): -v/w, (137, 137): v/w, (137, 245): u*v/w, (137, 262): 1,
        (137, 271): u**2/w**2, (137, 322): u/w, (137, 323): -u*v/w,
        (137, 460): u/w**2, (137, 568): u**2/w**2, (137, 595):
        u**3/w**2, (137, 623): u*v/w**2, (138, 141): -u/w, (138, 142):
        -u/w, (138, 143): 1, (138, 154): -u**2/w, (138, 265):
        -u**2*v*(u*v - w)/w**2, (138, 319): -u**2*v**3/w**3, (138,
        373): -u**3*v/w**2, (138, 427): -u*v*(u*v - w)/w**2, (138,
        454): -u**2*v/w**2, (138, 589): -u**3*v/w**2, (138, 616):
        -u**2*v*(u**2 - v)/w**2, (138, 643): -u**3*v**2/w**3, (139,
        141): -u*v/w, (139, 154): -u, (139, 169): -u/w, (139, 170): 1,
        (139, 319): -u*v**3/w**2, (139, 373): -u**3*v**2/w**2, (139,
        454): -u**2*v**2/w**2, (139, 589): -u**3*v**2/w**2, (139,
        616): -u**2*v**2*(u**2 - v)/w**2, (139, 643): -u*v*(2*u*v -
        w)/w**2, (140, 140): v/w, (140, 165): 1, (140, 169): v/w,
        (140, 181): u*v/w, (140, 373): u**4*v**2/w**2, (140, 400):
        u**2*v**2/w**2, (140, 454): u**3*v**2/w**2, (140, 580):
        -u*v**2/w**2, (140, 588): -u**2*v**2/w**2, (140, 590):
        -u*v**2/w**2, (140, 591): -u**3*v**2/w**2, (140, 607):
        -u**2*v**2/w**2, (140, 615): -u**3*v**2/w**2, (140, 617):
        -u**2*v**2/w**2, (140, 618): -u*v**2*(u**3 - u*v + w)/w**2,
        (140, 634): -v**2/w**2, (140, 642): -u*v**2/w**2, (140, 644):
        -u*v**3/w**3, (140, 645): -u**2*v**2/w**2, (141, 141): v/w,
        (141, 169): 1/w, (141, 271): u**2*v**2/w**3, (141, 373):
        u**2*v**2/w**2, (141, 454): u*v**2/w**2, (141, 589):
        u**2*v**2/w**2, (141, 591): -u*v**2/w**2, (141, 595):
        u**3*v**2/w**3, (141, 607): -v**2/w**2, (141, 616):
        u*v**2*(u**2 - v)/w**2, (141, 618): -u*v/w, (141, 643):
        u*v**2/w**2, (141, 644): -u*v**2/w**3, (142, 138): 1, (142,
        139): -u/w, (142, 141): -u**2/w, (142, 142): v/w, (142, 181):
        u/w, (142, 319): -u**2*v**2/w**2, (142, 400): u**2*v/w**2,
        (142, 580): -u**2*v**2/w**3, (142, 588): -u**3*v**2/w**3,
        (142, 589): -u**3*v**3/w**3, (142, 590): -u**2*v**2/w**3,
        (142, 591): -u**4*v**2/w**3, (142, 607): -u**3*v**2/w**3,
        (142, 615): -u**4*v**2/w**3, (142, 616): -u**3*v**2*(u*v -
        w)/w**3, (142, 617): -u**3*v**2/w**3, (142, 618):
        -u**2*v**2*(u**3 - u*v + w)/w**3, (142, 634): -u*v**2/w**3,
        (142, 642): -u**2*v**2/w**3, (142, 643): -u**2*v**3/w**3,
        (142, 644): -u**2*v**3/w**4, (142, 645): -u**3*v**2/w**3,
        (143, 142): 1/w, (143, 154): u/w, (143, 580): -u**2*v/w**3,
        (143, 588): -u**3*v/w**3, (143, 589): -u**2*v*(u*v - w)/w**3,
        (143, 590): -u**2*v/w**3, (143, 591): -u**4*v/w**3, (143,
        607): -u**3*v/w**3, (143, 615): -u**4*v/w**3, (143, 616):
        -u**3*v*(u*v - w)/w**3, (143, 617): -u**3*v/w**3, (143, 618):
        -u**2*v*(u**3 - u*v + w)/w**3, (143, 634): -u*v/w**3, (143,
        642): -u**2*v/w**3, (143, 644): -u**2*v**2/w**4, (143, 645):
        -u**3*v/w**3, (144, 144): v/w, (144, 175): v/w, (144, 183):
        u*v/w, (144, 184): u*v**2/w, (144, 365): v, (144, 371): u*v,
        (144, 373): u**2*v**2/w, (144, 374): u*v/w, (144, 375):
        -u*v**2/w, (144, 455): v/w, (144, 456): -v**2/w, (144, 509):
        -u*v/w**2, (144, 514): -v**2/w**2, (144, 516): 1, (144, 536):
        -u**2*v/w**2, (144, 563): -u*v**2/w**3, (144, 607): v**2/w,
        (144, 615): u*v**2/w, (144, 616): v**2*(u*v + w)/w, (144,
        631): v/w, (145, 145): v/w, (145, 164): u*v**2/w**2, (145,
        176): v/w, (145, 182): u*v/w, (145, 184): u**2*v**2/w**2,
        (145, 353): u**2*v**2/w**2, (145, 354): 1, (145, 365): u*v/w,
        (145, 370): u*v/w, (145, 371): u**2*v/w, (145, 373):
        u*v**2*(u**2 - v)/w**2, (145, 580): v**2/w**2, (145, 588):
        u*v**2/w**2, (145, 589): u*v**3/w**2, (145, 590): v**2/w**2,
        (145, 591): u**2*v**2/w**2, (145, 596): u*v**3/w**2, (145,
        607): u*v**2/w**2, (145, 608): v**2/w, (145, 614): u*v**2/w,
        (145, 615): u**2*v**2/w**2, (145, 616): u*v**2*(2*u*v +
        w)/w**2, (145, 617): u*v**2/w**2, (145, 618): u*v**2*(u**2 -
        v)/w**2, (145, 619): v**2/w, (145, 626): v/w**2, (145, 631):
        u*v/w**2, (145, 644): -v*(u*w - v**2)/w**3, (145, 645):
        2*u*v**2/w**2, (146, 146): v/w, (146, 175): 1/w, (146, 364):
        u/w, (146, 368): -v/w, (146, 377): -u*v**2/w, (146, 458):
        -v**2/w, (146, 607): v/w, (146, 612): u**2*v/w**2, (146, 616):
        v, (146, 633): u*v**2/w**2, (147, 147): v/w, (147, 176): 1/w,
        (147, 184): u**2*v/w**2, (147, 271): u**2/w**2, (147, 365):
        u/w, (147, 373): u*v*(u**2 - v)/w**2, (147, 595): u**3/w**2,
        (147, 608): v/w, (147, 616): u*v*(u*v + w)/w**2, (147, 619):
        v/w, (147, 620): -v**2/w, (147, 633): u*v/w**2, (147, 644):
        -u/w**2, (147, 645): u*v/w**2, (148, 146): -u**2/w, (148,
        148): v/w, (148, 183): u/w, (148, 184): u*v/w, (148, 253):
        -u*v/w, (148, 257): v, (148, 271): -u**2*v/w**2, (148, 273):
        1, (148, 274): -u/w, (148, 281): -u**2*v/w**2, (148, 288):
        u**3/w**2, (148, 319): u**2*v/w, (148, 325): u*v**2/w**3,
        (148, 353): u*v*(u*v - w)/w**2, (148, 371): u**2*v/w, (148,
        373): u**3*v**2/w**2, (148, 377): u**3*v/w, (148, 403):
        u**2*v/w**2, (148, 458): u**2*v/w, (148, 581): -u*v/w, (148,
        589): -u**3*v**2/w**2, (148, 591): u**2*v**2/w**2, (148, 595):
        -u**3*v/w**2, (148, 605): -u**3*v/w**2, (148, 607):
        u*v**2/w**2, (148, 608): -u**2*v/w, (148, 615):
        u**2*v**2/w**2, (148, 616): -u**2*v*(u**2*v + u*w -
        2*v**2)/w**2, (148, 617): u*v**2/w**2, (148, 618):
        u*v**2*(u**2 - v)/w**2, (148, 622): u**2*v**2/w**3, (148,
        633): -u**3*v/w**2, (148, 643): -u**2*v**2/w**2, (148, 644):
        u**2*v**2/w**3, (149, 147): -u**2/w, (149, 149): v/w, (149,
        182): u/w, (149, 184): u**2*v/w**2, (149, 246): 1, (149, 247):
        -u/w, (149, 253): -u**2*v/w**2, (149, 257): u*v/w, (149, 261):
        u**3/w**2, (149, 271): -u**2/w**2, (149, 281): -u**3*v/w**3,
        (149, 319): u**3*v/w**2, (149, 322): u**2*v/w**2, (149, 323):
        -u**2*v**2/w**2, (149, 325): u**2*v**2/w**4, (149, 371):
        u**2/w, (149, 373): u**3*v/w**2, (149, 591): u**2*v/w**2,
        (149, 595): -u**3/w**2, (149, 605): -u**4*v/w**3, (149, 607):
        u*v/w**2, (149, 615): u**3*v**2/w**3, (149, 616):
        -u**2*v*(u**2*w - u*v**2 - v*w)/w**3, (149, 617):
        u**2*v**2/w**3, (149, 618): u**2*v**2*(u**2 - v)/w**3, (149,
        619): -u**3*v/w**2, (149, 620): u**2*v/w, (149, 622):
        u**3*v**2/w**4, (149, 633): -u**3/w**2, (149, 635): u*v/w**2,
        (149, 644): u**2*v/w**3, (150, 148): 1/w, (150, 156): u/w,
        (150, 159): u**2/w, (150, 245): -u*v/w, (150, 256): u/w, (150,
        260): -v/w, (150, 264): u**2/w, (150, 266): u/w, (150, 267):
        u*(u**2 - v)/w, (150, 268): -u*v/w, (150, 269): u*v**2/w,
        (150, 584): u*v/w**2, (150, 589): u**3*v/w**2, (150, 592):
        u**2*v/w**2, (150, 611): u**2*v/w**2, (150, 616): u*v*(u**3 -
        u*v + w)/w**2, (150, 619): u**3*v/w**2, (150, 634): u/w**2,
        (150, 642): u**2/w**2, (150, 643): u**2*v/w**2, (150, 645):
        u**3/w**2, (151, 149): 1/w, (151, 155): u/w, (151, 184):
        u**2/w**2, (151, 253): -u**2/w**2, (151, 257): u/w, (151,
        263): u**2/w, (151, 281): -u**3/w**3, (151, 319): u*(u**2 -
        v)/w**2, (151, 325): u**2*v/w**4, (151, 373): u**3/w**2, (151,
        605): -u**4/w**3, (151, 615): u**3*v/w**3, (151, 616):
        u*(u**2*v**2 + w**2)/w**3, (151, 617): u**2*v/w**3, (151,
        618): u**2*v*(u**2 - v)/w**3, (151, 622): u**3*v/w**4, (151,
        635): u/w**2, (151, 641): u**2/w**2, (152, 152): v/w, (152,
        187): u/w, (152, 248): -u/w, (152, 250): 1, (152, 260): u*v/w,
        (152, 261): -u**2*v/w**2, (152, 271): -u**3/w**2, (152, 281):
        u**3/w**2, (152, 282): -u**2/w, (152, 323): u**2*v/w, (152,
        325): -u**2*v/w**3, (152, 373): u**2*v*(u**2 - v)/w**2, (152,
        376): u**2/w, (152, 454): u*v*(u**2 - v)/w**2, (152, 460):
        -u**2/w**2, (152, 568): -u**3/w**2, (152, 580): u*v/w**2,
        (152, 588): u**2*v/w**2, (152, 589): u**2*v**2/w**2, (152,
        591): u**3*v/w**2, (152, 595): -u**4/w**2, (152, 596):
        u*v*(u*v - w)/w**2, (152, 605): u**4/w**2, (152, 606):
        -u**3/w, (152, 607): u**2*v/w**2, (152, 614): u**2*v/w, (152,
        616): u**3*v**2/w**2, (152, 618): u*v/w, (152, 619):
        u**2*v**2/w**2, (152, 622): -u**3*v/w**3, (152, 638):
        u*v/w**2, (152, 645): u**2*v/w**2, (153, 153): v/w, (153,
        179): v/w, (153, 187): u*v/w, (153, 358): 1, (153, 368):
        u*v/w, (153, 373): -u*v**2/w, (153, 376): u**2*v/w, (153,
        454): -v**2/w, (153, 611): v**2/w, (153, 618): v, (153, 619):
        u*v**2/w, (153, 639): u*v/w**2, (153, 645): -u*v/w, (154,
        139): 1/w, (154, 141): u/w, (154, 154): v/w, (154, 271):
        -u**3*v/w**3, (154, 319): u*v**2/w**2, (154, 325):
        -u**2*v**2/w**4, (154, 373): u**3*v/w**2, (154, 454):
        u**2*v/w**2, (154, 460): -u**2*v/w**3, (154, 568):
        -u**3*v/w**3, (154, 588): -u*v/w**2, (154, 591): -u**2*v/w**2,
        (154, 595): -u**4*v/w**3, (154, 615): -u**2*v/w**2, (154,
        616): -u**2*v**2/w**2, (154, 618): -u**3*v/w**2, (154, 622):
        -u**3*v**2/w**4, (154, 642): -u*v**2/w**3, (154, 645):
        -u**2*v**2/w**3, (155, 147): u/w, (155, 155): v/w, (155, 247):
        1/w, (155, 261): -u**2/w**2, (155, 263): u*v/w, (155, 322):
        -u*v/w**2, (155, 323): u*v**2/w**2, (155, 615): u*v/w**2,
        (155, 616): u**3*v/w**2, (155, 618): u**2*v/w**2, (155, 619):
        u**2*v/w**2, (155, 620): -u*v/w, (155, 633): u**2/w**2, (155,
        641): u*v/w**2, (156, 146): u/w, (156, 156): v/w, (156, 263):
        v, (156, 274): 1/w, (156, 288): -u**2/w**2, (156, 376):
        u**3*v/w**2, (156, 377): -u**2*v/w, (156, 457): u**2*v/w**2,
        (156, 458): -u*v/w, (156, 587): -u*v/w, (156, 614): -u**2*v/w,
        (156, 615): u*v**2/w**2, (156, 616): u**2*v/w, (156, 618):
        u**2*v**2/w**2, (156, 633): u**2*v/w**2, (157, 157): v/w,
        (157, 253): 1/w, (157, 265): u*v/w, (157, 281): u/w**2, (157,
        325): -v/w**3, (157, 605): u**2/w**2, (157, 615): -u*v/w**2,
        (157, 616): -u*v**2/w**2, (157, 617): -v/w**2, (157, 618):
        -v*(u**2 - v)/w**2, (157, 622): -u*v/w**3, (157, 643):
        u*v/w**2, (158, 110): -v**2/w**2, (158, 158): v/w, (158, 164):
        -u*v**2/w**2, (158, 261): v/w, (158, 265): u*v, (158, 268): v,
        (158, 275): 1/w, (158, 280): u/w, (158, 288): u*v/w**2, (158,
        353): -2*u**2*v**2/w**2, (158, 370): -u*v/w, (158, 371):
        -u**2*v/w, (158, 373): -u*v**2*(u**2 - v)/w**2, (158, 376):
        -u**2*v**2/w**2, (158, 434): -2*u*v**2/w**2, (158, 451): -v/w,
        (158, 452): -u*v/w, (158, 454): -v**2*(u**2 - v)/w**2, (158,
        457): -u*v**2/w**2, (158, 569): -v**3/w**2, (158, 596):
        -u*v**3/w**2, (158, 599): u/w, (158, 604): u**2/w, (158, 612):
        u**2*v/w**2, (158, 618): -v**2/w, (158, 622): -u*v/w**2, (158,
        644): u*v/w**2, (159, 159): v/w, (159, 269): v, (159, 276):
        1/w, (159, 281): v/w**2, (159, 288): u/w**2, (159, 376):
        -u**2*v/w**2, (159, 457): -u*v/w**2, (159, 569): -v**2/w**2,
        (159, 596): -u*v**2/w**2, (159, 600): u/w, (159, 605):
        u*v/w**2, (159, 612): u**2/w**2, (159, 613): -v/w, (159, 615):
        -v**2/w**2, (159, 618): -u*v**2/w**2, (159, 645): u*v/w**2,
        (160, 160): v/w, (160, 248): 1/w, (160, 261): u*v/w**2, (160,
        268): u*v/w, (160, 281): -u**2/w**2, (160, 282): u/w, (160,
        325): u*v/w**3, (160, 373): -u*v*(u**2 - v)/w**2, (160, 454):
        -v*(u**2 - v)/w**2, (160, 596): -u*v**2/w**2, (160, 605):
        -u**3/w**2, (160, 606): u**2/w, (160, 614): -u*v/w, (160,
        615): u**2*v/w**2, (160, 617): u*v/w**2, (160, 618): u*v*(u**2
        - v)/w**2, (160, 619): -u*v**2/w**2, (160, 622): u**2*v/w**3,
        (160, 646): u*v/w**2, (161, 161): v/w, (161, 249): 1/w, (161,
        255): u/w, (161, 261): u/w**2, (161, 269): u*v/w, (161, 271):
        u*v/w**3, (161, 595): u**2*v/w**3, (161, 616): -v*(u**2 -
        v)/w**2, (161, 619): -u*v/w**2, (161, 647): u*v/w**2, (162,
        32): -u/w, (162, 34): 1, (163, 585): -v/w, (163, 595):
        -v**2/w, (163, 612): -u*v/w, (163, 616): -v**2, (163, 630):
        1/w, (163, 631): -v/w, (163, 639): -v**2/w**2, (164, 322): 1,
        (164, 323): -v, (165, 46): 1, (165, 140): -u/w, (165, 265):
        -u**2*v**2/w, (165, 292): u**2*v/w, (165, 319): -u*v**3/w**2,
        (165, 346): u*v**2/w**2, (165, 427): -u*v**2/w, (165, 481):
        u*v/w, (166, 141): -v, (166, 167): -u/w, (166, 168): 1, (166,
        319): -v**3/w, (166, 346): v**2/w, (166, 373): -u**2*v**2/w,
        (166, 454): -u*v**2/w, (166, 508): u*v/w, (166, 535):
        u**2*v/w, (166, 589): -u**2*v**2/w, (166, 616): -u*v**2*(u**2
        - v)/w, (166, 643): -u*v**2/w, (167, 166): 1, (167, 167): v/w,
        (167, 181): v, (167, 271): -u**3*v**2/w**2, (167, 325):
        -u*v**2/w**2, (167, 373): u**3*v**2/w, (167, 400): u*v**2/w,
        (167, 454): u**2*v**2/w, (167, 460): -u**2*v**2/w**2, (167,
        568): -u**3*v**2/w**2, (167, 588): -u*v**2/w, (167, 591):
        -u**2*v**2/w, (167, 595): -u**4*v**2/w**2, (167, 615):
        -u**2*v**2/w, (167, 618): -u**3*v**2/w, (167, 622):
        -u**2*v**2/w**2, (167, 642): -v**2/w, (167, 645): -u*v**2/w,
        (168, 167): 1/w, (168, 271): -u*v*(u**2 - v)/w**2, (168, 325):
        -u*v/w**2, (168, 460): -u**2*v/w**2, (168, 568): -u**3*v/w**2,
        (168, 589): u*v**2/w, (168, 595): -u**2*v*(u**2 - v)/w**2,
        (168, 616): u**2*v**2/w, (168, 622): -u**2*v/w**2, (168, 643):
        v**2/w, (168, 644): -v**2/w**2, (168, 645): v**3/w**2, (169,
        141): -u, (169, 181): 1, (169, 271): -u**4*v**2/w**3, (169,
        319): -u*v**2/w, (169, 325): -u**2*v**2/w**3, (169, 400):
        u*v/w, (169, 460): -u**3*v**2/w**3, (169, 568):
        -u**4*v**2/w**3, (169, 588): -u**2*v**2/w**2, (169, 589):
        -u**2*v**3/w**2, (169, 591): -u**3*v**2/w**2, (169, 595):
        -u**5*v**2/w**3, (169, 615): -u**3*v**2/w**2, (169, 616):
        -u**2*v**2*(u*v - w)/w**2, (169, 618): -u**4*v**2/w**2, (169,
        622): -u**3*v**2/w**3, (169, 642): -u*v**2/w**2, (169, 643):
        -u*v**3/w**2, (169, 645): -u**2*v**2/w**2, (170, 154): 1,
        (170, 271): -u**4*v/w**3, (170, 325): -u**2*v/w**3, (170,
        460): -u**3*v/w**3, (170, 568): -u**4*v/w**3, (170, 588):
        -u**2*v/w**2, (170, 589): -u*v*(u*v - w)/w**2, (170, 591):
        -u**3*v/w**2, (170, 595): -u**5*v/w**3, (170, 615):
        -u**3*v/w**2, (170, 616): -u**2*v*(u*v - w)/w**2, (170, 618):
        -u**4*v/w**2, (170, 622): -u**3*v/w**3, (170, 642): -u*v/w**2,
        (170, 645): -u**2*v/w**2, (171, 82): v, (171, 136): u*v, (171,
        171): v/w, (171, 183): v, (171, 184): v**2, (171, 271):
        u*v**2/w, (171, 361): v, (171, 371): v*w, (171, 373): u*v**2,
        (171, 460): v**2/w, (171, 510): -v**2/w, (171, 514):
        -v**3/w**2, (171, 517): 1, (171, 537): -u*v**2/w, (171, 563):
        -v**2/w**2, (171, 568): u*v**2/w, (171, 595): u**2*v**2/w,
        (171, 615): v**2, (171, 616): v**3, (172, 164): v**2/w, (172,
        172): v/w, (172, 182): v, (172, 184): u*v**2/w, (172, 271):
        u*v*(u*v - w)/w**2, (172, 353): u*v**2/w, (172, 355): 1, (172,
        361): u*v/w, (172, 370): v, (172, 371): u*v, (172, 373):
        v**2*(u**2 - v)/w, (172, 460): u*v**2/w**2, (172, 568):
        u**2*v**2/w**2, (172, 588): v**2/w, (172, 590): v**3/w**2,
        (172, 591): u*v**2/w, (172, 595): u**2*v*(u*v - w)/w**2, (172,
        596): v**3/w, (172, 614): v**2, (172, 615): u*v**2/w, (172,
        616): u*v**3/w, (172, 618): u**2*v**2/w, (172, 619): v**3/w,
        (172, 626): v**2/w**2, (172, 644): v**4/w**3, (172, 645):
        v**2/w, (173, 82): u*v/w, (173, 136): u**2*v/w, (173, 171):
        1/w, (173, 271): u**2*v**2/w**2, (173, 360): u/w, (173, 369):
        -v/w, (173, 460): u*v**2/w**2, (173, 510): -v/w, (173, 514):
        -v**2/w**2, (173, 537): -u*v/w, (173, 568): v**2*(u**2 +
        v)/w**2, (173, 585): u*v**2/w**2, (173, 595): u*v*(u**2*v +
        u*w + v**2)/w**2, (173, 612): u**2*v**2/w**2, (173, 616):
        u*v**3/w, (173, 622): v**4/w**3, (173, 630): -u*v/w**2, (173,
        631): u*v**2/w**2, (173, 639): v**2*(u*v + w)/w**3, (174,
        172): 1/w, (174, 184): u*v/w, (174, 271): u**2*v/w**2, (174,
        352): -v**2/w**2, (174, 361): u/w, (174, 373): v*(u**2 - v)/w,
        (174, 460): u*v/w**2, (174, 568): u**2*v/w**2, (174, 589):
        -v**2/w, (174, 595): u**3*v/w**2, (174, 622): v**3/w**3, (175,
        146): -u, (175, 183): 1, (175, 184): v, (175, 271): -u*v/w,
        (175, 281): -u*v/w, (175, 288): u**2/w, (175, 319): u*v, (175,
        353): v*(u*v - w)/w, (175, 371): u*v, (175, 373): u**2*v**2/w,
        (175, 377): u**2*v, (175, 403): u*v/w, (175, 458): u*v, (175,
        591): u*v**2/w, (175, 595): -u**2*v/w, (175, 605): -u**2*v/w,
        (175, 615): u*v**2/w, (175, 616): -u*v*(u*w - v**2)/w, (175,
        618): u**2*v**2/w, (175, 633): -u**2*v/w, (175, 644):
        u*v**2/w**2, (176, 147): -u, (176, 182): 1, (176, 184): u*v/w,
        (176, 261): u**2/w, (176, 271): -u/w, (176, 281):
        -u**2*v/w**2, (176, 319): u**2*v/w, (176, 322): u*v/w, (176,
        323): -u*v**2/w, (176, 371): u, (176, 373): u**2*v/w, (176,
        591): u*v/w, (176, 595): -u**2/w, (176, 605): -u**3*v/w**2,
        (176, 615): u**2*v**2/w**2, (176, 616): -u**2*v*(u*w -
        v**2)/w**2, (176, 618): u**3*v**2/w**2, (176, 619): -u**2*v/w,
        (176, 620): u*v, (176, 633): -u**2/w, (176, 644): u*v/w**2,
        (177, 156): 1, (177, 159): u, (177, 245): -v, (177, 264): u,
        (177, 267): u**2, (177, 589): u**2*v/w, (177, 592): u*v/w,
        (177, 616): u**3*v/w, (177, 619): u**2*v/w, (177, 642): u/w,
        (177, 643): u*v/w, (177, 645): u**2/w, (178, 155): 1, (178,
        184): u/w, (178, 263): u, (178, 281): -u**2/w**2, (178, 319):
        u**2/w, (178, 373): u**2/w, (178, 605): -u**3/w**2, (178,
        615): u**2*v/w**2, (178, 616): u**2*v**2/w**2, (178, 618):
        u**3*v/w**2, (178, 641): u/w, (179, 187): 1, (179, 271):
        u**2*(u*v - w)/w**2, (179, 281): u**2/w, (179, 282): -u, (179,
        323): u*v, (179, 373): u**3*v/w, (179, 376): u, (179, 454):
        u**2*v/w, (179, 460): u*(u*v - w)/w**2, (179, 568): u**2*(u*v
        - w)/w**2, (179, 588): u*v/w, (179, 589): u*v**2/w, (179,
        591): u**2*v/w, (179, 595): u**3*(u*v - w)/w**2, (179, 596):
        v*(u*v - w)/w, (179, 605): u**3/w, (179, 606): -u**2, (179,
        614): u*v, (179, 616): u**2*v**2/w, (179, 619): u*v**2/w,
        (179, 645): u*v/w, (180, 180): v/w, (180, 187): v, (180, 325):
        v/w, (180, 356): 1, (180, 369): u*v/w, (180, 376): u*v, (180,
        590): -v**2/w, (180, 622): u*v/w, (180, 626): -v/w, (180,
        644): -v**3/w**2, (181, 141): 1, (181, 319): v**2/w, (181,
        373): u**2*v/w, (181, 454): u*v/w, (181, 591): -u*v/w, (181,
        616): -u*v**2/w, (181, 618): -u**2*v/w, (181, 645):
        -u*v**2/w**2, (182, 147): 1, (182, 261): -u/w, (182, 322):
        -v/w, (182, 323): v**2/w, (182, 616): u**2*v/w, (182, 618):
        u*v/w, (182, 619): u*v/w, (182, 620): -v, (182, 633): u/w,
        (183, 146): 1, (183, 288): -u/w, (183, 376): u**2*v/w, (183,
        377): -u*v, (183, 457): u*v/w, (183, 458): -v, (183, 616):
        u*v, (183, 618): u*v**2/w, (183, 633): u*v/w, (184, 281): 1/w,
        (184, 605): u/w, (184, 615): -v/w, (184, 616): -v**2/w, (184,
        618): -u*v/w, (185, 265): v*w, (185, 280): 1, (185, 288): v/w,
        (185, 353): -u*v**2/w, (185, 371): -u*v, (185, 373):
        -u**2*v**2/w, (185, 376): -u*v**2/w, (185, 434): -v**2/w,
        (185, 452): -v, (185, 454): -u*v**2/w, (185, 457): -v**2/w,
        (185, 604): u, (185, 612): u*v/w, (185, 617): -v**2/w, (185,
        622): -v/w, (186, 288): 1/w, (186, 376): -u*v/w, (186, 457):
        -v/w, (186, 612): u/w, (186, 618): -v**2/w, (187, 281): -u/w,
        (187, 282): 1, (187, 373): -u**2*v/w, (187, 454): -u*v/w,
        (187, 596): -v**2/w, (187, 605): -u**2/w, (187, 606): u, (187,
        614): -v, (187, 615): u*v/w, (187, 618): u**2*v/w, (187, 619):
        -v**2/w, (188, 255): 1, (188, 616): -u*v/w, (188, 619): -v/w,
        (189, 60): -u/w, (189, 62): 1, (189, 103): -u*v**2/w, (189,
        130): u*v/w, (189, 208): u*v/w, (189, 211): -u*v**3/w**2,
        (189, 235): -u/w, (189, 238): u*v**2/w**2, (190, 190): v/w,
        (190, 568): u*v/w, (190, 578): 1, (190, 579): -v, (190, 622):
        u*v**2/w**2, (190, 632): v/w, (190, 633): -v**2/w, (190, 639):
        -u/w, (191, 191): v/w, (191, 271): u/w, (191, 299): u*v/w,
        (191, 316): 1, (191, 322): u*v/w, (191, 323): -u*v**2/w, (191,
        430): u, (191, 431): -u*v, (191, 569): u*v/w, (191, 595):
        u**2/w, (191, 623): u*v**2/w**2, (192, 195): -u/w, (192, 196):
        -u/w, (192, 197): 1, (192, 208): -u**2/w, (192, 265):
        -u*v*(u*v - w)/w, (192, 319): -u**2*v**4/w**3, (192, 373):
        -u**2*v/w, (192, 427): -u**2*v**3/w**2, (192, 589):
        -u**3*v**2/w**2, (192, 616): -u**3*v/w, (192, 643):
        -u**2*v**2*(u*v - w)/w**3, (193, 195): -u*v/w, (193, 208): -u,
        (193, 223): -u/w, (193, 224): 1, (193, 319): -u*v**4/w**2,
        (193, 373): -u**2*v**2/w, (193, 427): -u*v**3/w, (193, 589):
        -u*v*(2*u*v - w)/w, (193, 616): -u**3*v**2/w, (193, 643):
        -u*v**2*(u*v - w)/w**2, (194, 194): v/w, (194, 219): 1, (194,
        223): v/w, (194, 235): u*v/w, (194, 373): u**3*v**2/w, (194,
        400): u**2*v**3/w**2, (194, 454): u**2*v**2/w, (194, 580):
        -v**2/w, (194, 588): -u*v**2/w, (194, 590): -u*v**3/w**2,
        (194, 591): -u**2*v**2/w, (194, 607): -u*v**2/w, (194, 615):
        -u**2*v**2/w, (194, 617): -u*v**2/w, (194, 618): -u**3*v**2/w,
        (194, 634): -v**3/w**2, (194, 642): -u*v**3/w**2, (194, 644):
        -u*v**4/w**3, (194, 645): -u*v**2/w, (195, 195): v/w, (195,
        223): 1/w, (195, 325): u**2*v**2/w**3, (195, 373): u*v**2/w,
        (195, 589): u*v**2/w, (195, 590): -u*v**2/w**2, (195, 616):
        u**2*v**2/w, (195, 618): -u*v**2/w, (195, 622):
        u**3*v**2/w**3, (195, 634): -v**2/w**2, (195, 644):
        -u*v**3/w**3, (195, 645): u*v*(u*v - w)/w**2, (196, 192): 1,
        (196, 193): -u/w, (196, 195): -u**2/w, (196, 196): v/w, (196,
        235): u/w, (196, 319): -u**2*v**3/w**2, (196, 400):
        u**2*v**2/w**2, (196, 427): -u**2*v**2/w, (196, 454):
        u**2*v/w, (196, 580): -u*v**2/w**2, (196, 588):
        -u**2*v**2/w**2, (196, 589): -u**2*v**3/w**2, (196, 590):
        -u**2*v**3/w**3, (196, 591): -u**3*v**2/w**2, (196, 607):
        -u**2*v**2/w**2, (196, 615): -u**3*v**2/w**2, (196, 616):
        -u**3*v**3/w**2, (196, 617): -u**2*v**2/w**2, (196, 618):
        -u**4*v**2/w**2, (196, 634): -u*v**3/w**3, (196, 642):
        -u**2*v**3/w**3, (196, 643): u**2*v**2*(u*w - v**2)/w**3,
        (196, 644): -u**2*v**4/w**4, (196, 645): -u**2*v**2/w**2,
        (197, 196): 1/w, (197, 208): u/w, (197, 580): -u*v/w**2, (197,
        588): -u**2*v/w**2, (197, 590): -u**2*v**2/w**3, (197, 591):
        -u**3*v/w**2, (197, 607): -u**2*v/w**2, (197, 615):
        -u**3*v/w**2, (197, 616): -u**2*v*(u*v - w)/w**2, (197, 617):
        -u**2*v/w**2, (197, 618): -u**4*v/w**2, (197, 634):
        -u*v**2/w**3, (197, 642): -u**2*v**2/w**3, (197, 644):
        -u**2*v**3/w**4, (197, 645): -u**2*v/w**2, (198, 198): v/w,
        (198, 229): v/w, (198, 237): u*v/w, (198, 238): u*v**2/w,
        (198, 374): v, (198, 375): -v**2, (198, 392): v, (198, 398):
        u*v, (198, 400): u**2*v**2/w, (198, 509): -u*v**2/w**2, (198,
        536): -u*v/w, (198, 541): -v**2/w**2, (198, 543): 1, (198,
        563): -u*v**3/w**3, (198, 577): v, (198, 631): v**2/w, (198,
        634): v**2/w, (198, 642): u*v**2/w, (198, 643): v**2*(u*v +
        w)/w, (199, 199): v/w, (199, 218): u*v**2/w**2, (199, 230):
        v/w, (199, 236): u*v/w, (199, 238): u**2*v**2/w**2, (199,
        380): u**2*v**2/w**2, (199, 381): 1, (199, 392): u*v/w, (199,
        397): u*v/w, (199, 398): u**2*v/w, (199, 400): u*v**2*(u**2 -
        v)/w**2, (199, 572): v/w, (199, 577): u*v/w, (199, 590):
        -v*(u*w - v**2)/w**2, (199, 591): 2*u*v**2/w, (199, 607):
        v**2/w, (199, 615): u*v**2/w, (199, 616): u*v**3/w, (199,
        617): v**2/w, (199, 618): u**2*v**2/w, (199, 623):
        u*v**3/w**2, (199, 626): v**2/w**2, (199, 631): u*v**2/w**2,
        (199, 635): v**2/w, (199, 641): u*v**2/w, (199, 643):
        u*v**2*(u*v + w)/w**2, (199, 644): -v**2*(u*w - v**2)/w**3,
        (199, 645): u*v**3/w**2, (199, 646): v**2/w, (200, 200): v/w,
        (200, 229): 1/w, (200, 377): -v**2, (200, 391): u/w, (200,
        395): -v/w, (200, 579): u*v**2/w, (200, 633): u*v**3/w**2,
        (200, 634): v/w, (200, 639): u**2*v/w**2, (200, 643): v, (201,
        201): v/w, (201, 230): 1/w, (201, 238): u**2*v/w**2, (201,
        325): u**2/w**2, (201, 392): u/w, (201, 400): u*v*(u**2 -
        v)/w**2, (201, 579): u*v/w, (201, 590): -u/w, (201, 591):
        u*v/w, (201, 622): u**3/w**2, (201, 633): u*v**2/w**2, (201,
        635): v/w, (201, 643): u*v*(u*v + w)/w**2, (201, 644):
        -u*v/w**2, (201, 645): u*v**2/w**2, (201, 646): v/w, (201,
        647): -v**2/w, (202, 200): -u**2/w, (202, 202): v/w, (202,
        237): u/w, (202, 238): u*v/w, (202, 307): -u*v/w, (202, 311):
        v, (202, 319): u**2*v**2/w, (202, 325): -u*v*(u*w -
        v**2)/w**3, (202, 327): 1, (202, 328): -u/w, (202, 335):
        -u**2*v/w**2, (202, 342): u**3/w**2, (202, 377): u**2*v, (202,
        380): u*v*(u*v - w)/w**2, (202, 398): u**2*v/w, (202, 400):
        u**3*v**2/w**2, (202, 403): u**2*v**2/w**2, (202, 427):
        u**2*v, (202, 457): u**2*v/w, (202, 460): u*v**2/w**2, (202,
        568): u**2*v**2/w**2, (202, 579): -u**3*v/w, (202, 589):
        -u**2*v**2/w, (202, 590): u**2*v**2/w**2, (202, 608): -u*v,
        (202, 616): -u**3*v**2/w, (202, 618): u**2*v**2/w, (202, 622):
        -u**2*v*(u*w - v**2)/w**3, (202, 632): -u**3*v/w**2, (202,
        633): -u**3*v**2/w**2, (202, 634): u*v**2/w**2, (202, 642):
        u**2*v**2/w**2, (202, 643): -u**2*v*(u*w - v**2)/w**2, (202,
        644): u*v**2*(u*v + w)/w**3, (202, 645): -u*v**3/w**2, (203,
        201): -u**2/w, (203, 203): v/w, (203, 236): u/w, (203, 238):
        u**2*v/w**2, (203, 300): 1, (203, 301): -u/w, (203, 307):
        -u**2*v/w**2, (203, 311): u*v/w, (203, 315): u**3/w**2, (203,
        319): u**3*v**2/w**2, (203, 322): u**2*v**2/w**2, (203, 323):
        -u**2*v**3/w**2, (203, 325): u**2*(v**3 - w**2)/w**4, (203,
        335): -u**3*v/w**3, (203, 398): u**2/w, (203, 400):
        u**3*v/w**2, (203, 427): u**3*v/w, (203, 430): u**2*v/w, (203,
        431): -u**2*v**2/w, (203, 460): u**2*v**2/w**3, (203, 568):
        u**3*v**2/w**3, (203, 579): -u**3/w, (203, 581): u*v/w, (203,
        590): u**2*v/w**2, (203, 618): u**2*v/w, (203, 622):
        u**3*(v**3 - w**2)/w**4, (203, 632): -u**4*v/w**3, (203, 633):
        -u**3*v/w**2, (203, 634): u*v/w**2, (203, 635): u*v**2/w**2,
        (203, 642): u**3*v**2/w**3, (203, 643): -u**2*v*(u**2*w -
        u*v**2 - v*w)/w**3, (203, 644): 2*u**2*v**2/w**3, (203, 645):
        u**2*v*(u**2*v - u*w - v**2)/w**3, (203, 646): -u**3*v/w**2,
        (203, 647): u**2*v/w, (204, 202): 1/w, (204, 210): u/w, (204,
        213): u**2/w, (204, 299): -u*v/w, (204, 310): u/w, (204, 314):
        -v/w, (204, 318): u**2/w, (204, 320): u/w, (204, 321): u*(u**2
        - v)/w, (204, 322): -u*v/w, (204, 323): u*v**2/w, (204, 580):
        u/w, (204, 588): u**2/w, (204, 589): u**2*v/w, (204, 591):
        u**3/w, (204, 611): u*v/w, (204, 616): u**3*v/w, (204, 619):
        u**2*v/w, (204, 634): u*v/w**2, (204, 642): u**2*v/w**2, (204,
        643): u*v/w, (204, 645): u**3*v/w**2, (205, 203): 1/w, (205,
        209): u/w, (205, 238): u**2/w**2, (205, 307): -u**2/w**2,
        (205, 311): u/w, (205, 317): u**2/w, (205, 319): u*v*(u**2 -
        v)/w**2, (205, 325): u**2*v**2/w**4, (205, 335): -u**3/w**3,
        (205, 400): u**3/w**2, (205, 427): u*(u**2 - v)/w, (205, 460):
        u**2*v/w**3, (205, 568): u**3*v/w**3, (205, 581): u/w, (205,
        587): u**2/w, (205, 622): u**3*v**2/w**4, (205, 632):
        -u**4/w**3, (205, 635): u*v/w**2, (205, 641): u**2*v/w**2,
        (205, 642): u**3*v/w**3, (205, 643): u*(u**2*v**2 +
        w**2)/w**3, (205, 644): u**2*v/w**3, (205, 645): u**2*v*(u**2
        - v)/w**3, (206, 206): v/w, (206, 241): u/w, (206, 271):
        -u**2/w, (206, 302): -u/w, (206, 304): 1, (206, 314): u*v/w,
        (206, 315): -u**2*v/w**2, (206, 323): u**2*v**2/w, (206, 325):
        -u**2*v**2/w**3, (206, 335): u**3/w**2, (206, 336): -u**2/w,
        (206, 373): u*v*(u**2 - v)/w, (206, 403): u**2/w, (206, 431):
        u**2*v, (206, 460): -u**2*v/w**2, (206, 568): -u**3*v/w**2,
        (206, 584): u*v/w, (206, 591): u**2*v/w, (206, 595): -u**3/w,
        (206, 607): u*v/w, (206, 615): u**2*v/w, (206, 616):
        u**2*v**2/w, (206, 618): u**3*v/w, (206, 622):
        -u**3*v**2/w**3, (206, 623): u*v*(u*v - w)/w**2, (206, 632):
        u**4/w**2, (206, 633): -u**3/w, (206, 638): u*v**2/w**2, (206,
        641): u**2*v/w, (206, 642): -u**3*v/w**2, (206, 645):
        -u*v*(u**3 - u*v - w)/w**2, (206, 646): u**2*v**2/w**2, (207,
        207): v/w, (207, 233): v/w, (207, 241): u*v/w, (207, 373):
        -v**2, (207, 385): 1, (207, 395): u*v/w, (207, 403): u**2*v/w,
        (207, 585): u*v/w, (207, 591): -u*v, (207, 638): v**2/w, (207,
        639): u*v**2/w**2, (207, 645): -v*(u*v - w)/w, (207, 646):
        u*v**2/w, (208, 193): 1/w, (208, 195): u/w, (208, 208): v/w,
        (208, 271): -u**2*v/w**2, (208, 319): u*v**3/w**2, (208, 325):
        -u**2*v**3/w**4, (208, 373): u**2*v/w, (208, 427): u*v**2/w,
        (208, 460): -u**2*v**2/w**3, (208, 568): -u**3*v**2/w**3,
        (208, 588): -u*v**2/w**2, (208, 591): -u**2*v**2/w**2, (208,
        595): -u**3*v/w**2, (208, 615): -u*v/w, (208, 618): -u**2*v/w,
        (208, 622): -u**3*v**3/w**4, (208, 642): -u*v**3/w**3, (208,
        643): -u**2*v**2/w**2, (208, 645): -u**2*v**3/w**3, (209,
        201): u/w, (209, 209): v/w, (209, 301): 1/w, (209, 315):
        -u**2/w**2, (209, 317): u*v/w, (209, 322): -u*v**2/w**2, (209,
        323): u*v**3/w**2, (209, 430): -u*v/w, (209, 431): u*v**2/w,
        (209, 579): u**2/w, (209, 587): u*v/w, (209, 633):
        u**2*v/w**2, (209, 641): u*v**2/w**2, (209, 642): u*v/w**2,
        (209, 643): u**3*v/w**2, (209, 645): u**2*v/w**2, (209, 646):
        u**2*v/w**2, (209, 647): -u*v/w, (210, 200): u/w, (210, 210):
        v/w, (210, 317): v, (210, 328): 1/w, (210, 342): -u**2/w**2,
        (210, 376): u**2*v/w, (210, 377): -u*v, (210, 579): u**2*v/w,
        (210, 614): -u*v, (210, 633): u**2*v**2/w**2, (210, 642):
        u*v**2/w**2, (210, 643): u**2*v/w, (210, 645): u**2*v**2/w**2,
        (211, 211): v/w, (211, 307): 1/w, (211, 319): u*v/w, (211,
        325): -v**2/w**3, (211, 335): u/w**2, (211, 460): -v/w**2,
        (211, 568): -u*v/w**2, (211, 589): u*v/w, (211, 622):
        -u*v**2/w**3, (211, 632): u**2/w**2, (211, 642): -u*v/w**2,
        (211, 644): -v/w**2, (211, 645): -v*(u**2 - v)/w**2, (212,
        164): -v**2/w, (212, 212): v/w, (212, 315): v/w, (212, 319):
        u*v, (212, 322): v, (212, 329): 1/w, (212, 334): u/w, (212,
        342): u*v/w**2, (212, 353): -2*u*v**2/w, (212, 370): -v, (212,
        371): -u*v, (212, 373): -v**2*(u**2 - v)/w, (212, 376):
        -u*v**2/w, (212, 568): -u*v/w, (212, 590): u*v/w, (212, 596):
        -v**3/w, (212, 622): -u*v**2/w**2, (212, 626): u/w, (212,
        631): u**2/w, (212, 639): u**2*v/w**2, (212, 644):
        u*v**2/w**2, (212, 645): -v**2/w, (213, 213): v/w, (213, 323):
        v, (213, 330): 1/w, (213, 335): v/w**2, (213, 342): u/w**2,
        (213, 376): -u*v/w, (213, 591): u*v/w, (213, 596): -v**2/w,
        (213, 627): u/w, (213, 632): u*v/w**2, (213, 639): u**2/w**2,
        (213, 640): -v/w, (213, 642): -v**2/w**2, (214, 214): v/w,
        (214, 302): 1/w, (214, 315): u*v/w**2, (214, 322): u*v/w,
        (214, 325): u*v**2/w**3, (214, 335): -u**2/w**2, (214, 336):
        u/w, (214, 373): -v*(u**2 - v)/w, (214, 460): u*v/w**2, (214,
        568): u**2*v/w**2, (214, 592): u*v/w, (214, 622):
        u**2*v**2/w**3, (214, 623): -u*v**2/w**2, (214, 632):
        -u**3/w**2, (214, 633): u**2/w, (214, 641): -u*v/w, (214,
        642): u**2*v/w**2, (214, 644): u*v/w**2, (214, 645): u*v*(u**2
        - v)/w**2, (215, 215): v/w, (215, 303): 1/w, (215, 309): u/w,
        (215, 315): u/w**2, (215, 323): u*v/w, (215, 325): u*v/w**3,
        (215, 593): u*v/w, (215, 622): u**2*v/w**3, (215, 643):
        -v*(u**2 - v)/w**2, (215, 646): -u*v/w**2, (215, 647):
        u*v**2/w**2, (216, 59): -u/w, (216, 61): 1, (217, 576): 1,
        (217, 577): -v, (217, 585): -v**2/w, (217, 612): -v, (217,
        622): -v**2/w, (217, 630): v/w, (217, 631): -v**2/w, (217,
        639): -v**3/w**2, (217, 643): -v**2, (218, 322): v, (218,
        323): -v**2, (218, 430): w, (218, 431): -v*w, (219, 73): 1,
        (219, 194): -u/w, (219, 265): -u*v**2, (219, 292): u*v, (219,
        319): -u*v**4/w**2, (219, 346): u*v**3/w**2, (219, 427):
        -u*v**3/w, (219, 481): u*v**2/w, (220, 195): -v, (220, 221):
        -u/w, (220, 222): 1, (220, 319): -v**4/w, (220, 346): v**3/w,
        (220, 373): -u*v**2, (220, 427): -v**3, (220, 481): v**2,
        (220, 535): u*v, (220, 589): -u*v**2, (220, 616): -u**2*v**2,
        (221, 220): 1, (221, 221): v/w, (221, 235): v, (221, 271):
        -u**2*v**2/w, (221, 325): -u*v**3/w**2, (221, 373): u**2*v**2,
        (221, 400): u*v**3/w, (221, 454): u*v**2, (221, 460):
        -u*v**2/w, (221, 568): -u**2*v**2/w, (221, 588): -v**2, (221,
        591): -u*v**2, (221, 595): -u**3*v**2/w, (221, 615): -u*v**2,
        (221, 618): -u**2*v**2, (221, 622): -u**2*v**3/w**2, (221,
        642): -v**3/w, (221, 645): -u*v**3/w, (222, 221): 1/w, (222,
        271): -u**2*v/w, (222, 460): -u*v/w, (222, 568): -u**2*v/w,
        (222, 589): v**2, (222, 590): -v**2/w, (222, 591): v**3/w,
        (222, 595): -u**3*v/w, (222, 616): u*v**2, (222, 643): v**3/w,
        (222, 644): -v**3/w**2, (222, 645): v**4/w**2, (223, 195): -u,
        (223, 235): 1, (223, 271): -u**3*v**2/w**2, (223, 319):
        -u*v**3/w, (223, 325): -u**2*v**3/w**3, (223, 400): u*v**2/w,
        (223, 427): -u*v**2, (223, 454): u*v, (223, 460):
        -u**2*v**2/w**2, (223, 568): -u**3*v**2/w**2, (223, 588):
        -u*v**2/w, (223, 589): -u*v**3/w, (223, 591): -u**2*v**2/w,
        (223, 595): -u**4*v**2/w**2, (223, 615): -u**2*v**2/w, (223,
        616): -u**2*v**3/w, (223, 618): -u**3*v**2/w, (223, 622):
        -u**3*v**3/w**3, (223, 642): -u*v**3/w**2, (223, 643):
        u*v**2*(u*w - v**2)/w**2, (223, 645): -u**2*v**3/w**2, (224,
        208): 1, (224, 271): -u**3*v/w**2, (224, 325):
        -u**2*v**2/w**3, (224, 460): -u**2*v/w**2, (224, 568):
        -u**3*v/w**2, (224, 588): -u*v/w, (224, 591): -u**2*v/w, (224,
        595): -u**4*v/w**2, (224, 615): -u**2*v/w, (224, 616):
        -u*v*(u*v - w)/w, (224, 618): -u**3*v/w, (224, 622):
        -u**3*v**2/w**3, (224, 642): -u*v**2/w**2, (224, 645):
        -u**2*v**2/w**2, (225, 136): v*w, (225, 225): v/w, (225, 237):
        v, (225, 238): v**2, (225, 271): v**2, (225, 388): v, (225,
        398): v*w, (225, 400): u*v**2, (225, 509): -v**2/w, (225,
        537): -v**2, (225, 541): -v**3/w**2, (225, 544): 1, (225,
        563): -v**3/w**2, (225, 595): u*v**2, (225, 642): v**2, (225,
        643): v**3, (226, 218): v**2/w, (226, 226): v/w, (226, 236):
        v, (226, 238): u*v**2/w, (226, 271): u*v**2/w, (226, 325):
        -u*v/w, (226, 380): u*v**2/w, (226, 382): 1, (226, 388):
        u*v/w, (226, 397): v, (226, 398): u*v, (226, 400): v**2*(u**2
        - v)/w, (226, 572): v**2/w, (226, 590): v**4/w**2, (226, 591):
        v**2, (226, 595): u**2*v**2/w, (226, 615): v**2, (226, 617):
        v**3/w, (226, 618): u*v**2, (226, 622): -u**2*v/w, (226, 623):
        v**3/w, (226, 626): v**3/w**2, (226, 641): v**2, (226, 643):
        u*v**3/w, (226, 644): -v**3*(u*w - v**2)/w**3, (226, 645):
        v**3/w, (226, 646): v**3/w, (227, 136): u*v, (227, 225): 1/w,
        (227, 271): u*v**2/w, (227, 387): u/w, (227, 396): -v/w, (227,
        537): -v, (227, 541): -v**2/w**2, (227, 568): v**4/w**2, (227,
        576): -u*v/w, (227, 577): u*v**2/w, (227, 585): v**2*(u*v +
        w)/w**2, (227, 595): v**2*(u**2 + v)/w, (227, 612): u*v**2/w,
        (227, 622): v*(u**2*w**2 + v**4)/w**3, (227, 630):
        -u*v**2/w**2, (227, 631): u*v**3/w**2, (227, 639): v**3*(u*v +
        w)/w**3, (227, 643): u*v**3/w, (228, 226): 1/w, (228, 238):
        u*v/w, (228, 271): u*v/w, (228, 379): -v**2/w**2, (228, 388):
        u/w, (228, 400): v*(u**2 - v)/w, (228, 568): v**3/w**2, (228,
        595): u**2*v/w, (228, 616): -v**2, (228, 622): v**4/w**3,
        (228, 643): u*v**2/w, (229, 200): -u, (229, 237): 1, (229,
        238): v, (229, 319): u*v**2, (229, 325): -u*v/w, (229, 335):
        -u*v/w, (229, 342): u**2/w, (229, 377): u*v*w, (229, 380):
        v*(u*v - w)/w, (229, 398): u*v, (229, 400): u**2*v**2/w, (229,
        403): u*v**2/w, (229, 427): u*v*w, (229, 457): u*v, (229,
        579): -u**2*v, (229, 590): u*v**2/w, (229, 618): u*v**2, (229,
        622): -u**2*v/w, (229, 632): -u**2*v/w, (229, 633):
        -u**2*v**2/w, (229, 642): u*v**2/w, (229, 643): -u*v*(u*w -
        v**2)/w, (229, 644): u*v**3/w**2, (230, 201): -u, (230, 236):
        1, (230, 238): u*v/w, (230, 315): u**2/w, (230, 319):
        u**2*v**2/w, (230, 322): u*v**2/w, (230, 323): -u*v**3/w,
        (230, 325): -u/w, (230, 335): -u**2*v/w**2, (230, 398): u,
        (230, 400): u**2*v/w, (230, 427): u**2*v, (230, 430): u*v,
        (230, 431): -u*v**2, (230, 579): -u**2, (230, 590): u*v/w,
        (230, 618): u*v, (230, 622): -u**2/w, (230, 632):
        -u**3*v/w**2, (230, 633): -u**2*v/w, (230, 642):
        u**2*v**2/w**2, (230, 643): -u**2*v*(u*w - v**2)/w**2, (230,
        644): u*v**2/w**2, (230, 645): u**2*v*(u*v - w)/w**2, (230,
        646): -u**2*v/w, (230, 647): u*v, (231, 210): 1, (231, 213):
        u, (231, 299): -v, (231, 318): u, (231, 321): u**2, (231,
        588): u, (231, 589): u*v, (231, 591): u**2, (231, 616):
        u**2*v, (231, 619): u*v, (231, 642): u*v/w, (231, 643):
        u*v**2/w, (231, 645): u**2*v/w, (232, 209): 1, (232, 238):
        u/w, (232, 317): u, (232, 319): u**2*v/w, (232, 335):
        -u**2/w**2, (232, 400): u**2/w, (232, 427): u**2, (232, 587):
        u, (232, 632): -u**3/w**2, (232, 641): u*v/w, (232, 642):
        u**2*v/w**2, (232, 643): u**2*v**2/w**2, (232, 645):
        u**3*v/w**2, (233, 241): 1, (233, 271): u*(u*v - w)/w, (233,
        323): u*v**2, (233, 335): u**2/w, (233, 336): -u, (233, 373):
        u**2*v, (233, 403): u, (233, 431): u*v*w, (233, 591): u*v,
        (233, 595): u**2*(u*v - w)/w, (233, 615): u*v, (233, 616):
        u*v**2, (233, 618): u**2*v, (233, 623): v*(u*v - w)/w, (233,
        632): u**3/w, (233, 633): -u**2, (233, 641): u*v, (233, 642):
        -u**2*v/w, (233, 645): -u*v*(u**2 - v)/w, (233, 646):
        u*v**2/w, (234, 234): v/w, (234, 241): v, (234, 325): v**2/w,
        (234, 383): 1, (234, 396): u*v/w, (234, 403): u*v, (234, 460):
        v, (234, 568): u*v, (234, 572): -v, (234, 590): -v**3/w, (234,
        617): -v**2, (234, 622): u*v**2/w, (234, 626): -v**2/w, (234,
        644): v**2*(u*w - v**2)/w**2, (235, 195): 1, (235, 319):
        v**3/w, (235, 373): u*v, (235, 427): v**2, (235, 591):
        -u*v**2/w, (235, 618): -u*v, (235, 643): -u*v**2/w, (235,
        645): -u*v**3/w**2, (236, 201): 1, (236, 315): -u/w, (236,
        322): -v**2/w, (236, 323): v**3/w, (236, 430): -v, (236, 431):
        v**2, (236, 579): u, (236, 633): u*v/w, (236, 643): u**2*v/w,
        (236, 645): u*v/w, (236, 646): u*v/w, (236, 647): -v, (237,
        200): 1, (237, 342): -u/w, (237, 376): u*v, (237, 377): -v*w,
        (237, 579): u*v, (237, 633): u*v**2/w, (237, 643): u*v, (237,
        645): u*v**2/w, (238, 335): 1/w, (238, 632): u/w, (238, 642):
        -v/w, (238, 643): -v**2/w, (238, 645): -u*v/w, (239, 319):
        v*w, (239, 334): 1, (239, 342): v/w, (239, 353): -v**2, (239,
        371): -v*w, (239, 373): -u*v**2, (239, 376): -v**2, (239,
        568): -v, (239, 622): -v**2/w, (239, 631): u, (239, 639):
        u*v/w, (239, 644): -v**2/w, (240, 342): 1/w, (240, 376): -v,
        (240, 639): u/w, (240, 645): -v**2/w, (241, 335): -u/w, (241,
        336): 1, (241, 373): -u*v, (241, 623): -v**2/w, (241, 632):
        -u**2/w, (241, 633): u, (241, 641): -v, (241, 642): u*v/w,
        (241, 645): u**2*v/w, (241, 646): -v**2/w, (242, 309): 1,
        (242, 643): -u*v/w, (242, 646): -v/w, (243, 39): -u/w, (243,
        43): 1, (243, 107): u*v/w, (243, 134): -u/w, (243, 155):
        u*v/w, (243, 161): u**2*v/w, (243, 182): -u/w, (243, 188):
        -u**2/w, (243, 211): u**2*v/w**2, (243, 214): u*v/w**2, (243,
        238): -u**2/w**2, (243, 241): -u/w**2, (243, 245): -u*v*(u*v -
        w)/w**2, (243, 271): -u**2*(u*v - w)/w**3, (243, 353): u*(u*v
        - w)/w**2, (243, 595): -u**3*(u*v - w)/w**3, (243, 623):
        -u*v*(u*v - w)/w**3, (244, 244): v/w, (244, 568): u*v/w**2,
        (244, 591): v/w, (244, 620): v, (244, 622): u*v**2/w**3, (244,
        627): 1/w, (244, 633): u/w, (244, 639): u/w**2, (244, 645):
        v**2/w**2, (245, 245): v/w, (245, 263): 1, (245, 269): u,
        (245, 319): u/w, (246, 147): -u/w, (246, 149): -u/w, (246,
        151): 1, (246, 155): -u**2/w, (246, 245): u**2*(u*v - w)/w**2,
        (246, 260): u*(u*v - w)/w**2, (246, 261): u**2/w**2, (246,
        265): u**3*(u*v - w)/w**2, (246, 268): u**2*(u*v - w)/w**2,
        (246, 269): u**2*v/w, (246, 271): u**2*v/w**3, (246, 319):
        u**2*v*(u*v + w)/w**3, (246, 322): u**2*v**2/w**3, (246, 346):
        -u**2/w**2, (246, 373): u**4/w**2, (246, 376): u**3/w**2,
        (246, 377): -u**2/w, (246, 427): u**2*(u*v - w)/w**2, (246,
        430): u*(u*v - w)/w**2, (246, 431): u*v/w, (246, 454):
        u**3/w**2, (246, 457): u**2/w**2, (246, 458): -u/w, (246,
        569): u**3/w**2, (246, 584): u**2/w**2, (246, 589): u**4/w**2,
        (246, 592): u**3/w**2, (246, 595): u**3*v/w**3, (246, 596):
        u**4/w**2, (246, 611): u**3/w**2, (246, 616): u**3*(u**2 -
        v)/w**2, (246, 619): u**2*(u**2 - v)/w**2, (246, 620): u*v/w,
        (246, 623): u**3*v/w**3, (246, 638): u**2*v/w**3, (246, 643):
        u**4*v/w**3, (246, 644): u**3/w**3, (246, 646): u**3*v/w**3,
        (247, 147): -u*v/w, (247, 155): -u, (247, 176): -u/w, (247,
        178): 1, (247, 245): u*(u*v - w)/w, (247, 261): u**2*v/w**2,
        (247, 269): u**2*v**2/w, (247, 271): u**2*v**2/w**3, (247,
        319): u**2*v**2/w**2, (247, 322): u*v**2/w**2, (247, 368):
        u*(u*v - w)/w**2, (247, 373): u**4*v/w**2, (247, 376):
        u**3*v/w**2, (247, 377): -u**2*v/w, (247, 400): u**2*v/w**2,
        (247, 431): u*v**2/w, (247, 454): u**3*v/w**2, (247, 457):
        u**2*v/w**2, (247, 458): -u*v/w, (247, 562): -u**2/w**2, (247,
        569): u**2/w, (247, 584): u**2*v/w**2, (247, 589):
        u**4*v/w**2, (247, 592): u**3*v/w**2, (247, 595):
        u**3*v**2/w**3, (247, 596): u**3/w, (247, 611): u**3*v/w**2,
        (247, 616): u**2*v*(u**3 - u*v + w)/w**2, (247, 619):
        u**2*v*(u**2 - v)/w**2, (247, 620): u*v**2/w, (247, 623):
        u**2*v/w**2, (247, 638): u*v/w**2, (247, 643): u**2*(2*u*v -
        w)/w**2, (247, 644): u**2/w**2, (247, 646): u*(2*u*v -
        w)/w**2, (248, 110): -u/w, (248, 160): -u, (248, 164):
        -u**2/w, (248, 179): -u/w, (248, 184): -u**2*v**2/w**2, (248,
        261): -u*v**2/w**2, (248, 268): -u*v**2/w, (248, 281):
        u**2*v/w**2, (248, 282): -u*v/w, (248, 325): u*v*(u**2 -
        v)/w**3, (248, 353): -u**2*v**2/w**2, (248, 365): -u*v/w,
        (248, 368): -u*v**2/w**2, (248, 371): -u**2*v/w, (248, 373):
        -u**2*v*(u**3 + 2*w)/w**2, (248, 376): -u**2*v**2/w**2, (248,
        400): -u**3*v/w**2, (248, 434): -u*v**2/w**2, (248, 452):
        -u*v/w, (248, 454): -u**4*v/w**2, (248, 457): -u*v**2/w**2,
        (248, 528): -u/w, (248, 529): 1, (248, 569): -u*v*(u*v +
        w)/w**2, (248, 579): -u*v/w, (248, 580): u**2*v/w**2, (248,
        581): -u*v/w, (248, 584): -u*v**2/w**2, (248, 587): -u**2*v/w,
        (248, 588): u**3*v/w**2, (248, 589): -u**3*v**2/w**2, (248,
        591): u**4*v/w**2, (248, 592): -u**2*v**2/w**2, (248, 596):
        -u*v*(u**2*v + u*w - v**2)/w**2, (248, 605): u**3*v/w**2,
        (248, 606): -u**2*v/w, (248, 607): u**3*v/w**2, (248, 608):
        -u**2*v/w, (248, 611): -u*v*(u*v + w)/w**2, (248, 614):
        -u*v*(u**2 - v)/w, (248, 615): u**2*v*(u**2 - v)/w**2, (248,
        616): -u**4*v**2/w**2, (248, 617): u*v*(u**2 - v)/w**2, (248,
        618): v*(u**5 - 2*u**3*v + u*v**2 - v*w)/w**2, (248, 619):
        -u*v*(u**2*v + u*w - v**2)/w**2, (248, 622): u**2*v*(u**2 -
        v)/w**3, (248, 623): -u*v**2/w**2, (248, 633): -u*v**2/w**2,
        (248, 641): -u*v/w, (248, 642): u**2*v/w**2, (248, 643):
        -u**2*v**2/w**2, (248, 645): u**2*(2*u*v + w)/w**2, (248,
        646): -u*v**2/w**2, (248, 647): -u, (249, 161): -u, (249,
        184): -u**2*v/w**2, (249, 255): -u*v/w, (249, 261): -u*v/w**2,
        (249, 269): -u*v**2/w, (249, 271): -2*u*v**2/w**3, (249, 325):
        u**3/w**3, (249, 365): -u/w, (249, 366): -u/w, (249, 367): 1,
        (249, 368): -u*v/w**2, (249, 373): -2*u**3*v/w**2, (249, 376):
        -u**2*v/w**2, (249, 454): -u**2*v/w**2, (249, 457): -u*v/w**2,
        (249, 569): -u/w, (249, 584): -u*v/w**2, (249, 589):
        -u**3*v/w**2, (249, 592): -u**2*v/w**2, (249, 595):
        -2*u**2*v**2/w**3, (249, 611): -u**2*v/w**2, (249, 615):
        -v**2/w**2, (249, 616): -v*(u**4 - u**2*v + v**2)/w**2, (249,
        618): -u*v**2/w**2, (249, 619): -u*v*(u**2 - v)/w**2, (249,
        620): -u**2*v/w, (249, 622): u**4/w**3, (249, 623): -u*v/w**2,
        (249, 633): -u*v/w**2, (249, 641): -u/w, (249, 642):
        u**2/w**2, (249, 643): -2*u**2*v/w**2, (249, 645): u**3/w**2,
        (249, 646): -u*v/w**2, (249, 647): -u**2/w, (250, 152): -u/w,
        (250, 160): -u**2/w, (250, 184): -u**2*v/w**2, (250, 253):
        u**2*v/w**2, (250, 257): -u*v/w, (250, 260): -u*v**2/w**2,
        (250, 265): u**2*v/w, (250, 268): -u**2*v**2/w**2, (250, 269):
        u**2*(u*v - w)/w, (250, 271): 2*u**3*v/w**3, (250, 281):
        u**2*(u*v + w)/w**3, (250, 282): -u/w, (250, 285): -u/w, (250,
        286): 1, (250, 325): u**2*v*(u**2 - v)/w**4, (250, 353):
        -u**2*v/w**2, (250, 371): -u**2/w, (250, 373): -u**2*(u*v +
        w)/w**2, (250, 376): -u**2*v/w**2, (250, 431): u*(u*v - w)/w,
        (250, 434): -u*v/w**2, (250, 452): -u/w, (250, 457):
        -u*v/w**2, (250, 460): u**2*v/w**3, (250, 568): u**3*v/w**3,
        (250, 569): -u**2*v/w**2, (250, 580): u**3*v/w**3, (250, 588):
        u**4*v/w**3, (250, 589): u**3*v*(u*v - w)/w**3, (250, 591):
        u**5*v/w**3, (250, 593): u**3/w, (250, 595): 2*u**4*v/w**3,
        (250, 596): -u*v*(u**2 - v)/w**2, (250, 605): u**3*(u*v +
        w)/w**3, (250, 607): u**4*v/w**3, (250, 611): -u**2*v/w**2,
        (250, 614): u*v/w, (250, 615): u**3*v*(u**2 - v)/w**3, (250,
        616): u**2*v*(u**2 - v)*(u*v - w)/w**3, (250, 617):
        u**2*v*(u**2 - v)/w**3, (250, 618): u*v*(u**5 - 2*u**3*v +
        u*v**2 - v*w)/w**3, (250, 619): -u*v*(u**2 - v)/w**2, (250,
        620): u**4/w, (250, 622): u**3*v*(u**2 - v)/w**4, (250, 642):
        u**3*v/w**3, (250, 643): u**3*v**2/w**3, (250, 645):
        u**3*(2*u*v + w)/w**3, (251, 161): -u**2/w, (251, 184):
        -u**2/w**2, (251, 245): -u**2*v/w**2, (251, 253): u**2/w**2,
        (251, 255): -u/w, (251, 257): -u/w, (251, 258): -u/w, (251,
        259): 1, (251, 260): -u*v/w**2, (251, 263): -u**2/w, (251,
        268): -u**2*v/w**2, (251, 269): -u**3/w, (251, 281):
        u**3/w**3, (251, 323): -u**2*v/w**2, (251, 325): u**2*(u**2 -
        v)/w**4, (251, 373): -u**3/w**2, (251, 376): -u**2/w**2, (251,
        407): -u*v/w**2, (251, 425): -u/w, (251, 431): -u**2/w, (251,
        457): -u/w**2, (251, 569): -u**2/w**2, (251, 580): u**3/w**3,
        (251, 588): u**4/w**3, (251, 589): u**3*(u*v - w)/w**3, (251,
        591): u**5/w**3, (251, 596): -u**3/w**2, (251, 605):
        u**4/w**3, (251, 607): u**4/w**3, (251, 611): -u**2/w**2,
        (251, 615): u**3*(u**2 - v)/w**3, (251, 616): u**2*(u**2 -
        v)*(u*v - w)/w**3, (251, 617): u**2*(u**2 - v)/w**3, (251,
        618): u*(u**5 - 2*u**3*v + u*v**2 - v*w)/w**3, (251, 619):
        -u*(u**2 - v)/w**2, (251, 622): u**3*(u**2 - v)/w**4, (251,
        642): u**3/w**3, (251, 643): u**2*(u*v - w)/w**3, (251, 645):
        2*u**4/w**3, (251, 647): -u**3/w**2, (252, 186): u*v/w, (252,
        252): v/w, (252, 364): v/w, (252, 372): u*v/w, (252, 373):
        u*v**2/w, (252, 375): u**2*v/w, (252, 377): u*v, (252, 453):
        v/w, (252, 454): v**2/w, (252, 456): u*v/w, (252, 521): 1,
        (252, 528): v/w, (252, 536): u*v/w**2, (252, 564): u*v/w**2,
        (252, 568): u*v**2/w**2, (252, 578): v/w, (252, 595): u*v/w,
        (252, 618): u*v**2/w, (252, 622): -u*v*(u*w - v**2)/w**3,
        (252, 632): v**2/w**2, (253, 157): -u, (253, 265): -u*v**2/w,
        (253, 281): -u*v/w**2, (253, 325): v*(-u**2 + v)/w**3, (253,
        353): -u*(u*w - v**2)/w**2, (253, 368): -u/w, (253, 371):
        u*v/w, (253, 373): u**2*v**2/w**2, (253, 434): (-u*w +
        v**2)/w**2, (253, 452): v/w, (253, 454): u*v**2/w**2, (253,
        528): 1/w, (253, 579): v/w, (253, 580): -u*v/w**2, (253, 588):
        -u**2*v/w**2, (253, 589): -u**2*v**2/w**2, (253, 591):
        -u**3*v/w**2, (253, 605): -u**2*v/w**2, (253, 607):
        -u**2*v/w**2, (253, 615): -u*v*(u**2 - v)/w**2, (253, 616):
        -u*v*(u**2*v + u*w - v**2)/w**2, (253, 617): -v*(u**2 -
        v)/w**2, (253, 618): -v*(u**2 - v)**2/w**2, (253, 622):
        -u*v*(u**2 - v)/w**3, (253, 633): v**2/w**2, (253, 642):
        -u*v/w**2, (253, 643): -u*v**2/w**2, (253, 645):
        -2*u**2*v/w**2, (254, 188): u*v/w, (254, 190): -u**2/w**2,
        (254, 254): v/w, (254, 271): u*v/w**2, (254, 325):
        -2*u**2*v/w**3, (254, 359): 1, (254, 366): v/w, (254, 368):
        u/w, (254, 377): 2*u**2*v/w, (254, 458): u*v/w, (254, 564):
        u/w**2, (254, 568): -u**2*(u*w + v**2)/w**3, (254, 591):
        -u*v**2/w**2, (254, 595): u**2*v/w**2, (254, 596): -u*v/w,
        (254, 615): v/w, (254, 618): u*v/w, (254, 622): -u**2*v*(3*u*w
        + v**2)/w**4, (254, 627): -u*v/w**2, (254, 633): -u**2*v/w**2,
        (254, 639): -u**2*v/w**3, (254, 640): -u/w, (254, 642):
        -u*v/w**2, (254, 645): -u*v*(u*w + v**2)/w**3, (255, 255):
        v/w, (255, 325): -u**2/w**3, (255, 366): 1/w, (255, 373):
        u**2*v/w**2, (255, 454): u*v/w**2, (255, 596): (-u*w +
        v**2)/w**2, (255, 614): v/w, (255, 620): u*v/w, (255, 622):
        -u**3/w**3, (255, 642): -u/w**2, (255, 645): -u**2/w**2, (256,
        110): -u*v/w**2, (256, 164): -u**2*v/w**2, (256, 186): u/w,
        (256, 256): v/w, (256, 265): -u**2, (256, 276): -u/w, (256,
        278): 1, (256, 281): -u*v/w**2, (256, 285): v/w, (256, 288):
        -u**2/w**2, (256, 353): -u**2*(2*u*v - w)/w**2, (256, 370):
        -u**2/w, (256, 371): -u**3/w, (256, 373): -u**2*v*(u**2 -
        v)/w**2, (256, 376): -u**2/w, (256, 377): -u**2*(u**2 - v)/w,
        (256, 404): -u**2/w, (256, 434): -u*(2*u*v - w)/w**2, (256,
        451): -u/w, (256, 452): -u**2/w, (256, 454): -u*v*(u**2 -
        v)/w**2, (256, 458): -u**3/w, (256, 580): -u*v/w**2, (256,
        588): -u**2*v/w**2, (256, 589): u**2*(u*w - v**2)/w**2, (256,
        591): -u**3*v/w**2, (256, 605): -u**2*v/w**2, (256, 606):
        u**3/w, (256, 607): -u**2*v/w**2, (256, 613): u*v/w, (256,
        615): -u*v*(u**2 - v)/w**2, (256, 616): u**3*(u*w -
        v**2)/w**2, (256, 617): -u**2*v/w**2, (256, 618):
        -u**2*v*(u**2 - 2*v)/w**2, (256, 622): u**2*(u*v - w)/w**3,
        (256, 645): -u**2*v/w**2, (257, 157): -u**2/w, (257, 260):
        -u/w, (257, 265): -u**2*(u*w + v**2)/w**2, (257, 268):
        -u**2/w, (257, 269): u**2*v/w, (257, 281): -u/w**2, (257,
        285): 1/w, (257, 580): -u**2*v/w**3, (257, 584): u**2/w**2,
        (257, 588): -u**3*v/w**3, (257, 589): u**3*(u*w - v**2)/w**3,
        (257, 591): -u**4*v/w**3, (257, 592): u**3/w**2, (257, 593):
        -u**2/w, (257, 605): -u**2/w**2, (257, 607): -u**3*v/w**3,
        (257, 611): u**3/w**2, (257, 615): -u*v*(u**3 - w)/w**3, (257,
        616): u*(u**4*w - u**3*v**2 - u**2*v*w + v**2*w)/w**3, (257,
        617): -u**3*v/w**3, (257, 618): -u**2*v*(u**3 - u*v - w)/w**3,
        (257, 619): u**4/w**2, (257, 620): -u**3/w, (257, 645):
        -u**2*(u*v + w)/w**3, (258, 188): u/w, (258, 245): u**2/w,
        (258, 249): -u/w, (258, 251): 1, (258, 255): -u**2/w, (258,
        258): v/w, (258, 260): u/w, (258, 261): -u**2/w**2, (258,
        268): u**2/w, (258, 269): -u**2*v/w, (258, 271): -u**2*v/w**3,
        (258, 323): u**2/w, (258, 377): u**2/w, (258, 407): u/w, (258,
        584): -u**2/w**2, (258, 589): -u**4/w**2, (258, 592):
        -u**3/w**2, (258, 595): -u**3*v/w**3, (258, 611): -u**3/w**2,
        (258, 616): -u*(u**2 - v)**2/w**2, (258, 618): u/w, (258,
        619): -u**2*(u**2 - v)/w**2, (258, 643): -2*u**3/w**2, (258,
        646): -u**2/w**2, (259, 161): u/w, (259, 258): 1/w, (259,
        265): -u**2*v/w**2, (259, 269): u**2/w, (259, 580):
        -u**2/w**3, (259, 588): -u**3/w**3, (259, 589): -u**3*v/w**3,
        (259, 591): -u**4/w**3, (259, 607): -u**3/w**3, (259, 615):
        -u**4/w**3, (259, 616): -u**4*v/w**3, (259, 617): -u**3/w**3,
        (259, 618): -u**3*(u**2 - v)/w**3, (259, 645): -u**3/w**3,
        (259, 647): u**2/w**2, (260, 184): u/w, (260, 253): -u/w,
        (260, 257): 1, (260, 260): v/w, (260, 269): -u**2, (260, 281):
        -u**2/w**2, (260, 325): -u*(u**2 - v)/w**3, (260, 373):
        -u**3*(u**2 - 2*v)/w**2, (260, 400): -u**3/w**2, (260, 454):
        -u**2*(u**2 - v)/w**2, (260, 569): -u*(u*v - w)/w**2, (260,
        581): -u/w, (260, 584): -u*v/w**2, (260, 587): -u**2/w, (260,
        589): -2*u**3*v/w**2, (260, 592): -u**2*v/w**2, (260, 596):
        -u**2*(u*v - w)/w**2, (260, 605): -u**3/w**2, (260, 608):
        -u**2/w, (260, 611): -u**2*v/w**2, (260, 614): -u**3/w, (260,
        615): u**2*v/w**2, (260, 616): -2*u**2*v*(u**2 - v)/w**2,
        (260, 617): u*v/w**2, (260, 618): u*v*(u**2 - v)/w**2, (260,
        619): -u**3*v/w**2, (260, 622): -u**2*(u**2 - v)/w**3, (260,
        642): -u**2/w**2, (260, 643): -2*u**2*v/w**2, (260, 645):
        -u**3/w**2, (261, 184): u*v/w, (261, 261): v/w, (261, 365): 1,
        (261, 368): v/w, (261, 373): 2*u**2*v/w, (261, 376): u*v/w,
        (261, 454): u*v/w, (261, 457): v/w, (261, 616): u*v**2/w,
        (262, 137): -u/w, (262, 245): -u*v**2/w**2, (262, 263):
        -u*v/w, (262, 269): -u**2*v/w, (262, 271): -u**2*v/w**3, (262,
        319): -u**2*v/w**2, (262, 322): -u*v/w**2, (262, 373):
        -u**2*(u**2 - v)/w**2, (262, 400): -u**2/w**2, (262, 431):
        -u*v/w, (262, 454): -u**3/w**2, (262, 460): -u*v/w**3, (262,
        568): -u**2*v/w**3, (262, 591): u**3/w**2, (262, 593):
        -u**2/w, (262, 595): -u**3*v/w**3, (262, 596): -u**2*v/w**2,
        (262, 606): -u/w, (262, 607): u**2/w**2, (262, 608): -u/w,
        (262, 609): -u/w, (262, 610): 1, (262, 614): -u**2/w, (262,
        615): u**3/w**2, (262, 618): u**4/w**2, (262, 620): -u**3/w,
        (262, 623): -u**2/w**2, (262, 638): -u/w**2, (262, 644):
        u**3/w**3, (262, 646): -u**2/w**2, (263, 245): -u/w, (263,
        269): -u*v/w, (263, 319): -u*v/w**2, (263, 584): -u/w**2,
        (263, 589): -u**3/w**2, (263, 591): -u**2/w**2, (263, 592):
        -u**2/w**2, (263, 593): u/w, (263, 607): -u/w**2, (263, 609):
        1/w, (263, 611): -u**2/w**2, (263, 615): -u**2/w**2, (263,
        616): -u**4/w**2, (263, 618): -u**3/w**2, (263, 619):
        -u**3/w**2, (263, 620): u**2/w, (263, 643): -u**2/w**2, (263,
        644): -u**2/w**3, (264, 264): v/w, (264, 374): -u**2/w**2,
        (264, 375): u/w, (264, 376): -u**2*(u**2 - v)/w**2, (264,
        377): u*(u**2 - v)/w, (264, 403): -u**2/w**2, (264, 404): u/w,
        (264, 457): -u**3/w**2, (264, 458): u**2/w, (264, 569):
        -u**2*v/w**2, (264, 584): -u*v/w**2, (264, 589): -u**2/w,
        (264, 591): -u**2*v/w**2, (264, 592): -u**2*v/w**2, (264,
        596): -u**3*v/w**2, (264, 600): -u/w, (264, 601): -u/w, (264,
        602): 1, (264, 606): -u**2/w, (264, 607): -u*v/w**2, (264,
        609): v/w, (264, 611): -u**2*v/w**2, (264, 612): -u**2/w**2,
        (264, 613): -u**2/w, (264, 615): -u**2*v/w**2, (264, 616):
        -u**3/w, (264, 618): -u**3*v/w**2, (264, 619): -u**3*v/w**2,
        (264, 622): -u**2*v/w**3, (264, 644): -u**2*v/w**3, (264,
        645): -u*v/w**2, (265, 265): v/w, (265, 580): w**(-2), (265,
        588): u/w**2, (265, 589): u*v/w**2, (265, 591): u**2/w**2,
        (265, 607): u/w**2, (265, 615): u**2/w**2, (265, 616):
        u**2*v/w**2, (265, 617): u/w**2, (265, 618): u*(u**2 -
        v)/w**2, (265, 645): u/w**2, (266, 110): u*v/w**2, (266, 164):
        u**2*v/w**2, (266, 266): v/w, (266, 353): u*v*(2*u**2 -
        v)/w**2, (266, 370): u**2/w, (266, 371): u*(u**2 - v)/w, (266,
        372): u/w, (266, 373): u*v*(u**3 - 2*u*v + w)/w**2, (266,
        374): u*v/w**2, (266, 376): u*v*(u**2 - v)/w**2, (266, 380):
        u*v/w**2, (266, 398): u/w, (266, 400): u**2*v/w**2, (266,
        403): u*v/w**2, (266, 434): 2*u**2*v/w**2, (266, 451): u/w,
        (266, 452): u**2/w, (266, 454): u*v*(u**2 - v)/w**2, (266,
        457): u**2*v/w**2, (266, 569): 2*u*v**2/w**2, (266, 581): v/w,
        (266, 584): v**2/w**2, (266, 587): u*v/w, (266, 589):
        u**2*v**2/w**2, (266, 590): u*v/w**2, (266, 592): u*v**2/w**2,
        (266, 596): 2*u**2*v**2/w**2, (266, 597): 1, (266, 601): v/w,
        (266, 608): u*v/w, (266, 611): u*v**2/w**2, (266, 613): u*v/w,
        (266, 614): u**2*v/w, (266, 616): u*v**2*(u**2 - v)/w**2,
        (266, 618): u*v/w, (266, 619): u**2*v**2/w**2, (266, 622):
        u**2/w**2, (266, 634): v/w**2, (266, 642): u*v/w**2, (266,
        643): u*v**2/w**2, (266, 644): u*v**2/w**3, (267, 267): v/w,
        (267, 374): u/w**2, (267, 376): u*(u**2 - v)/w**2, (267, 403):
        u/w**2, (267, 457): u**2/w**2, (267, 569): u*v/w**2, (267,
        584): v/w**2, (267, 591): u*v/w**2, (267, 592): u*v/w**2,
        (267, 596): u**2*v/w**2, (267, 601): 1/w, (267, 607): v/w**2,
        (267, 611): u*v/w**2, (267, 613): u/w, (267, 615): u*v/w**2,
        (267, 618): u**2*v/w**2, (267, 619): u**2*v/w**2, (267, 644):
        u*v/w**3, (268, 268): v/w, (268, 373): u*(u**3 - 2*u*v +
        w)/w**2, (268, 400): u**2/w**2, (268, 454): u*(u**2 - v)/w**2,
        (268, 569): u*v/w**2, (268, 580): -u/w**2, (268, 581): 1/w,
        (268, 584): v/w**2, (268, 587): u/w, (268, 588): -u**2/w**2,
        (268, 589): u**2*v/w**2, (268, 591): -u**3/w**2, (268, 592):
        u*v/w**2, (268, 596): u**2*v/w**2, (268, 607): -u**2/w**2,
        (268, 608): u/w, (268, 611): u*v/w**2, (268, 614): u**2/w,
        (268, 615): -u**3/w**2, (268, 616): u*v*(u**2 - v)/w**2, (268,
        617): -u**2/w**2, (268, 618): -u**2*(u**2 - v)/w**2, (268,
        619): u**2*v/w**2, (268, 643): u*v/w**2, (268, 645):
        -u**2/w**2, (269, 269): v/w, (269, 584): w**(-2), (269, 589):
        u**2/w**2, (269, 592): u/w**2, (269, 611): u/w**2, (269, 616):
        u*(u**2 - v)/w**2, (269, 619): u**2/w**2, (269, 643): u/w**2,
        (270, 17): -u/w, (270, 18): u**2/w**2, (270, 38): -u/w, (270,
        42): 1, (270, 44): -u**2/w, (270, 45): u**3/w**2, (270, 156):
        u*v/w, (270, 183): -u/w, (270, 211): u*v/w, (270, 238): -u/w,
        (270, 245): -u*v**2/w, (270, 271): -u**2*v*(u*v - w)/w**3,
        (270, 272): u*v/w, (270, 353): u*v/w, (270, 515): -u/w, (270,
        569): u*v/w, (270, 595): -u**3*v*(u*v - w)/w**3, (270, 596):
        u**2*v/w, (271, 271): v/w, (271, 585): -u/w, (271, 612):
        -u**2/w, (271, 633): 1, (272, 244): u**2/w, (272, 264): 1,
        (272, 267): u, (272, 406): u/w, (273, 2): -u/w, (273, 29):
        -u**2/w, (273, 146): -u/w, (273, 148): -u/w, (273, 150): 1,
        (273, 156): -u**2/w, (273, 245): u**2*v/w, (273, 260): u*v/w,
        (273, 265): -u**2, (273, 271): u**2*v**2/w**3, (273, 272):
        -u**2/w, (273, 287): -u/w, (273, 288): u**2/w**2, (273, 292):
        u**3/w, (273, 319): u**2*v**2/w**2, (273, 373): u**3/w, (273,
        427): -u, (273, 454): u**2/w, (273, 481): u**2/w, (273, 589):
        u**3/w, (273, 595): u**3*v**2/w**3, (273, 616): u**2*(u**2 -
        v)/w, (273, 643): u**3*v/w**2, (273, 644): u**3*v/w**3, (274,
        146): -u*v/w, (274, 156): -u, (274, 175): -u/w, (274, 177): 1,
        (274, 245): u*v, (274, 271): u**2*v**3/w**3, (274, 272): -u,
        (274, 288): u**2*v/w**2, (274, 319): u*v**2/w, (274, 368):
        u*v/w, (274, 508): u**2/w, (274, 530): -u/w, (274, 535):
        u**3/w, (274, 584): u*v/w, (274, 595): u**3*v**3/w**3, (274,
        611): u**2*v/w, (274, 643): u*(u*v - w)/w, (274, 644):
        u**2*v/w**2, (275, 158): -u, (275, 184): -u*v**2/w, (275,
        261): -v**2/w, (275, 265): -u*v**2, (275, 268): -v**2, (275,
        271): -u**4*v/w**2, (275, 280): -u*v/w, (275, 288):
        -u*v**2/w**2, (275, 293): -u*v/w, (275, 295): v, (275, 352):
        u**3/w, (275, 365): -v, (275, 368): -v**2/w, (275, 373):
        -u**2*v**2/w, (275, 433): u**2/w, (275, 460): -u**3*v/w**2,
        (275, 526): -u/w, (275, 527): 1, (275, 530): v/w, (275, 568):
        -u**4*v/w**2, (275, 580): u*v/w, (275, 581): -v, (275, 584):
        -v**2/w, (275, 595): -u**2*v*(u**3 + w)/w**2, (275, 607):
        u**2*v/w, (275, 608): -u*v, (275, 611): -u*v**2/w, (275, 612):
        -u*v/w, (275, 618): -u**2*v**2/w, (275, 643): -u*v**2/w, (275,
        645): u**2*v/w, (276, 136): -u*v**2/w**2, (276, 159): -u,
        (276, 244): u**3/w, (276, 269): -v**2, (276, 271): -u*(u**3*w
        + 2*v**3)/w**3, (276, 281): -v**2/w**2, (276, 288): -u*v/w**2,
        (276, 294): -u*v/w, (276, 296): v, (276, 364): -u/w, (276,
        368): -v/w, (276, 373): -u**2*v/w, (276, 406): u**2/w, (276,
        454): -u*v/w, (276, 460): -u**3/w**2, (276, 530): 1/w, (276,
        568): -u**4/w**2, (276, 584): -v/w, (276, 595): -u**2*(u**3*w
        + 2*v**3)/w**3, (276, 605): -u*v**2/w**2, (276, 611): -u*v/w,
        (276, 616): u*v**2/w, (276, 618): -u**2*v/w, (276, 622):
        -u**2*v**2/w**3, (276, 632): -u*v/w**2, (276, 643): -u*v/w,
        (277, 158): -u**2/w, (277, 184): -u*v/w, (277, 253): u*v/w,
        (277, 257): -v, (277, 260): -v**2/w, (277, 268): -u*v**2/w,
        (277, 271): -u**3*v*(u**2 - v)/w**3, (277, 280): -u/w, (277,
        281): u**2*v/w**2, (277, 283): -u/w, (277, 284): 1, (277,
        287): v/w, (277, 288): -u*v/w**2, (277, 293): -u**2*v/w**2,
        (277, 295): u*v/w, (277, 325): -u*v**2/w**3, (277, 352):
        u**4/w**2, (277, 373): -u**2*v/w, (277, 433): u**3/w**2, (277,
        460): -u**4*v/w**3, (277, 568): -u**5*v/w**3, (277, 580):
        u**2*v/w**2, (277, 595): -u**3*v*(u**3 - u*v + w)/w**3, (277,
        605): u**3*v/w**2, (277, 607): u**3*v/w**2, (277, 612):
        -u**2*v/w**2, (277, 618): -u**3*v**2/w**2, (277, 622):
        -u*v*(2*u*v - w)/w**3, (277, 645): u**3*v/w**2, (278, 157):
        -u*v/w, (278, 159): -u**2/w, (278, 244): u**4/w**2, (278,
        256): -u/w, (278, 260): -v/w, (278, 265): -u**2*v/w, (278,
        268): -u*v/w, (278, 271): -u**5/w**3, (278, 287): 1/w, (278,
        288): -u/w**2, (278, 293): -u**2/w**2, (278, 295): u/w, (278,
        406): u**3/w**2, (278, 460): -u**4/w**3, (278, 568):
        -u**5/w**3, (278, 580): u**2/w**2, (278, 595): -u**6/w**3,
        (278, 607): u**3/w**2, (278, 612): -u**2/w**2, (278, 618):
        -u**3*v/w**2, (278, 643): -u**2*v/w**2, (279, 185): u*v/w,
        (279, 279): v/w, (279, 368): v, (279, 375): u*v, (279, 376):
        u*v, (279, 456): v, (279, 487): -u**2*v/w**2, (279, 510):
        -u*v/w, (279, 514): -u**3*v/w**2, (279, 520): 1, (279, 526):
        v/w, (279, 536): u*v**2/w**2, (279, 537): -u**2*v/w, (279,
        617): u*v**2/w, (279, 639): v/w, (280, 271): u**3*v/w**2,
        (280, 280): v/w, (280, 292): v, (280, 364): -v/w, (280, 460):
        u**2*v/w**2, (280, 526): 1/w, (280, 568): u**3*v/w**2, (280,
        580): -v/w, (280, 589): -u*v**2/w, (280, 595): u**4*v/w**2,
        (280, 607): -u*v/w, (280, 612): -v*(u*v - w)/w**2, (280, 616):
        -u**2*v**2/w, (280, 617): -u*v/w, (280, 618): u*v**2/w, (280,
        645): -u*v/w, (281, 82): u**2/w, (281, 136): u**3/w, (281,
        271): u**3*v/w**2, (281, 281): v/w, (281, 368): 1, (281, 377):
        u*v, (281, 458): v, (281, 460): u**2*v/w**2, (281, 510): -u/w,
        (281, 537): -u**2/w, (281, 568): u**3*v/w**2, (281, 585):
        u**2*v/w**2, (281, 595): u**2*(u**2*v + u*w + v**2)/w**2,
        (281, 605): u*v/w, (281, 612): u**3*v/w**2, (281, 633):
        -u*v/w, (282, 179): 1/w, (282, 271): u**3/w**2, (282, 282):
        v/w, (282, 368): u/w, (282, 460): u**2/w**2, (282, 568):
        u**3/w**2, (282, 595): u**4/w**2, (282, 606): u*v/w, (282,
        611): v/w, (282, 620): v, (282, 645): -u/w, (283, 185): u/w,
        (283, 260): v, (283, 261): -u*v/w, (283, 265): -u**2*v, (283,
        275): -u/w, (283, 277): 1, (283, 280): -u**2/w, (283, 283):
        v/w, (283, 288): -u**2*v/w**2, (283, 487): -u**2/w**2, (283,
        514): -u**3/w**2, (283, 584): -u*v/w, (283, 589): u**3*v/w,
        (283, 611): -u**2*v/w, (283, 616): u**4*v/w, (283, 618):
        u*v**2/w, (283, 622): u**2*v/w**2, (284, 158): u/w, (284,
        159): -u*v/w, (284, 244): u**3*v/w**2, (284, 256): -v/w, (284,
        265): -u*v**2/w, (284, 283): 1/w, (284, 292): u*v/w, (284,
        352): -u**3/w**2, (284, 406): u**2*v/w**2, (284, 433):
        -u**2/w**2, (284, 595): u**2*v/w**2, (284, 617): -u**2*v/w**2,
        (284, 618): u**2*v**2/w**2, (284, 645): -u**2*v/w**2, (285,
        157): u, (285, 260): 1, (285, 265): u**2, (285, 268): u, (285,
        269): -u*v, (285, 584): -u/w, (285, 611): -u**2/w, (285, 616):
        u**2*v/w, (286, 152): 1/w, (286, 157): u**2/w, (286, 160):
        u/w, (286, 260): u/w, (286, 265): u*(u**2 - v)/w, (286, 268):
        u**2/w, (286, 292): u/w, (286, 616): u**2/w, (286, 617):
        -u**2/w**2, (286, 618): u**2*v/w**2, (286, 638): u/w**2, (286,
        643): u**3/w**2, (286, 646): u**2/w**2, (287, 159): u, (287,
        244): -u**3/w, (287, 256): 1, (287, 271): u**4/w**2, (287,
        373): u**2*v/w, (287, 406): -u**2/w, (287, 454): u*v/w, (287,
        460): u**3/w**2, (287, 568): u**4/w**2, (287, 580): -u/w,
        (287, 595): u**5/w**2, (287, 607): -u**2/w, (288, 288): v/w,
        (288, 364): 1, (288, 373): u*v, (288, 454): v, (288, 612):
        u*v/w, (289, 245): -v**2/w, (289, 263): -v, (289, 272): v/w,
        (289, 290): 1, (289, 291): -u/w, (289, 319): -u*v/w, (289,
        352): -u**3/w**2, (289, 433): -u**2/w**2, (289, 589): -u*v/w,
        (289, 595): u**2*v/w**2, (289, 604): -u/w, (289, 616):
        -u**2*v/w, (289, 622): u*v**2/w**3, (290, 244): -u**2*v/w**2,
        (290, 264): -v/w, (290, 267): -u*v/w, (290, 291): 1/w, (290,
        352): u**2/w**2, (290, 406): -u*v/w**2, (290, 433): u/w**2,
        (290, 595): -u*v/w**2, (291, 245): v, (291, 289): 1, (291,
        291): v/w, (291, 487): u/w**2, (291, 514): u**2/w**2, (291,
        569): -u*v/w, (291, 589): -u**2*v/w, (291, 592): -u*v/w, (291,
        596): -u**2*v/w, (291, 599): -u/w, (291, 604): -u**2/w, (291,
        612): -u**2*v/w**2, (291, 616): -u**3*v/w, (291, 619):
        -u**2*v/w, (291, 622): -u*v/w**2, (291, 644): -u*v/w**2, (292,
        617): 1/w, (292, 618): -v/w, (293, 110): v/w, (293, 164):
        u*v/w, (293, 293): v/w, (293, 353): u**2*v/w, (293, 370): u,
        (293, 373): -u*v**2/w, (293, 434): u*v/w, (293, 451): 1, (293,
        454): -v**2/w, (293, 569): v**2/w, (293, 596): u*v**2/w, (293,
        618): v, (293, 622): u/w, (294, 136): u/w, (294, 271):
        2*u*v/w**2, (294, 294): v/w, (294, 569): v/w, (294, 595):
        2*u**2*v/w**2, (294, 596): u*v/w, (294, 613): 1, (294, 615):
        v/w, (294, 618): u*v/w, (294, 622): u**2/w**2, (295, 293):
        1/w, (295, 373): -u*v/w, (295, 454): -v/w, (295, 618): u*v/w,
        (296, 294): 1/w, (296, 616): -v/w, (296, 618): u/w, (297, 66):
        -u/w, (297, 70): 1, (297, 103): u**2*v/w, (297, 106): u*v/w,
        (297, 130): -u**2/w, (297, 133): -u/w, (297, 161): u*v, (297,
        188): -u, (297, 209): u*v/w, (297, 211): u**2*v**2/w**2, (297,
        214): u*v**2/w**2, (297, 236): -u/w, (297, 238): -u**2*v/w**2,
        (297, 241): -u*v/w**2, (297, 299): -u*v*(u*v - w)/w**2, (297,
        325): -u**2*(u*v - w)/w**3, (297, 380): u*(u*v - w)/w**2,
        (297, 569): -u*v*(u*v - w)/w**2, (297, 622): -u**3*(u*v -
        w)/w**3, (297, 623): -u*v**2*(u*v - w)/w**3, (298, 298): v/w,
        (298, 568): u*v**2/w**2, (298, 573): 1, (298, 579): u, (298,
        585): u/w, (298, 591): v**2/w, (298, 595): u*v/w, (298, 618):
        v, (298, 622): -u*v*(u*w - v**2)/w**3, (298, 627): v/w, (298,
        633): u*v/w, (298, 639): u*v/w**2, (298, 645): -v*(u*w -
        v**2)/w**2, (298, 647): v, (299, 299): v/w, (299, 317): 1,
        (299, 319): u*v/w, (299, 323): u, (299, 427): u, (300, 201):
        -u/w, (300, 203): -u/w, (300, 205): 1, (300, 209): -u**2/w,
        (300, 265): u**2*(u*v - w)/w, (300, 268): u*(u*v - w)/w, (300,
        269): u*v, (300, 299): u**2*(u*v - w)/w**2, (300, 314): u*(u*v
        - w)/w**2, (300, 315): u**2/w**2, (300, 319): u**2*v**2*(u*v +
        w)/w**3, (300, 322): u**2*v**3/w**3, (300, 325): u**2*v/w**3,
        (300, 346): -u**2*v/w**2, (300, 373): u**3/w, (300, 376):
        u**2/w, (300, 377): -u, (300, 427): u**2*v*(u*v + w)/w**2,
        (300, 430): u**2*v**2/w**2, (300, 481): -u**2/w, (300, 569):
        u**3*v/w**2, (300, 584): u**2*v/w**2, (300, 589): u**4*v/w**2,
        (300, 590): u**3/w**2, (300, 592): u**3*v/w**2, (300, 596):
        u**3/w, (300, 611): u**2/w, (300, 616): u**4/w, (300, 619):
        u**3/w, (300, 622): u**3*v/w**3, (300, 623): u**3*v**2/w**3,
        (300, 638): u**2*v**2/w**3, (300, 643): u**3*v*(u*v - w)/w**3,
        (300, 644): u**3*v/w**3, (300, 646): u**2*v*(u*v - w)/w**3,
        (300, 647): u*v/w, (301, 201): -u*v/w, (301, 209): -u, (301,
        230): -u/w, (301, 232): 1, (301, 269): u*v**2, (301, 299):
        u*(u*v - w)/w, (301, 315): u**2*v/w**2, (301, 319):
        u**2*v**3/w**2, (301, 322): u*v**3/w**2, (301, 325):
        u**2*v**2/w**3, (301, 373): u**3*v/w, (301, 376): u**2*v/w,
        (301, 377): -u*v, (301, 395): u*(u*v - w)/w**2, (301, 400):
        u**2*v**2/w**2, (301, 427): u**2*v**2/w, (301, 430): u*v**2/w,
        (301, 454): u**2*v/w, (301, 508): -u**2/w, (301, 562):
        -u**2*v/w**2, (301, 569): u**2*v/w, (301, 584): u*v/w, (301,
        589): u**2*(2*u*v - w)/w, (301, 590): u**2/w, (301, 592):
        u*(2*u*v - w)/w, (301, 596): u**2, (301, 611): u**2*v/w, (301,
        616): u**4*v/w, (301, 619): u**3*v/w, (301, 622):
        u**3*v**2/w**3, (301, 623): u**2*v**2/w**2, (301, 638):
        u*v**2/w**2, (301, 643): u**3*v**2/w**2, (301, 644):
        u**2*v/w**2, (301, 646): u*v*(u*v - w)/w**2, (301, 647):
        u*v**2/w, (302, 164): -u, (302, 214): -u, (302, 233): -u/w,
        (302, 238): -u**2*v**2/w**2, (302, 315): -u*v**2/w**2, (302,
        322): -u*v**2/w, (302, 325): u*v**2*(u**2 - v)/w**3, (302,
        335): u**2*v/w**2, (302, 336): -u*v/w, (302, 353): -u*v**2/w,
        (302, 371): -u*v, (302, 373): -u**4*v/w, (302, 376):
        -u*v**2/w, (302, 392): -u*v/w, (302, 395): -u*v**2/w**2, (302,
        400): -u**2*v*(u*v + 2*w)/w**2, (302, 454): -u**3*v/w, (302,
        460): u*v*(u**2 - v)/w**2, (302, 555): -u/w, (302, 556): 1,
        (302, 568): u**2*v*(u**2 - v)/w**2, (302, 569): -u*v**2/w,
        (302, 579): -u*v**2/w, (302, 587): -u*v, (302, 588): u**2*v/w,
        (302, 589): -u**2*v**2/w, (302, 591): u**2*(2*u*v + w)/w,
        (302, 592): -u*v**2/w, (302, 593): -u*w, (302, 596): -u*v*(u*v
        + w)/w, (302, 606): -u*v, (302, 607): u**2*v/w, (302, 608):
        -u*v, (302, 611): -u*v**2/w, (302, 614): -u**2*v, (302, 615):
        u**3*v/w, (302, 616): -u**3*v**2/w, (302, 618): u**4*v/w,
        (302, 619): -u**2*v**2/w, (302, 622): u**2*v**2*(u**2 -
        v)/w**3, (302, 632): u**3*v/w**2, (302, 633): -u*v**3/w**2,
        (302, 638): -u*v/w, (302, 643): -u**2*v**3/w**2, (302, 644):
        u*v*(u**2 - v)/w**2, (302, 645): v*(u**2*w + u*v**2 -
        v*w)/w**2, (302, 646): -u**2*v/w, (302, 647): -u*v, (303,
        215): -u, (303, 238): -u**2*v/w**2, (303, 309): -u*v/w, (303,
        315): -u*v/w**2, (303, 323): -u*v**2/w, (303, 325): u*v*(u**2
        - 2*v)/w**3, (303, 373): -u**2*v/w, (303, 376): -u*v/w, (303,
        392): -u/w, (303, 393): -u/w, (303, 394): 1, (303, 395):
        -u*v/w**2, (303, 400): -u**3*v/w**2, (303, 460): u**3/w**2,
        (303, 568): u**4/w**2, (303, 569): -u*v/w, (303, 579): -u*v/w,
        (303, 587): -u, (303, 588): u**2/w, (303, 589): -2*u**2*v/w,
        (303, 591): u**3/w, (303, 592): -u*v/w, (303, 593): -u**2,
        (303, 596): -u, (303, 611): -u*v/w, (303, 616): -u**3*v/w,
        (303, 619): -u**2*v/w, (303, 622): u**2*v*(u**2 - 2*v)/w**3,
        (303, 623): u*(u*w - v**2)/w**2, (303, 633): -u*v**2/w**2,
        (303, 641): -u*v/w, (303, 642): v*(u**2 - v)/w**2, (303, 643):
        -v**2*(u**2 + v)/w**2, (303, 645): u*v*(u**2 - v)/w**2, (303,
        647): -2*u**2*v/w, (304, 206): -u/w, (304, 214): -u**2/w,
        (304, 238): -u**2*v/w**2, (304, 269): u*(u*v - w), (304, 271):
        u**2*v/w**2, (304, 307): u**2*v/w**2, (304, 311): -u*v/w,
        (304, 314): -u*v**2/w**2, (304, 319): u**2*v/w, (304, 322):
        -u**2*v**2/w**2, (304, 325): u**2*v*(u**2*v + u*w -
        v**2)/w**4, (304, 335): u**2*(u*v + w)/w**3, (304, 336): -u/w,
        (304, 339): -u/w, (304, 340): 1, (304, 353): -u*v/w, (304,
        371): -u, (304, 376): -u*v/w, (304, 400): -u**2*(u*v +
        w)/w**2, (304, 460): u**2*v*(u**2 - v)/w**3, (304, 568):
        u**3*v*(u**2 - v)/w**3, (304, 588): u**3*v/w**2, (304, 589):
        u**3*v**2/w**2, (304, 591): u**3*(2*u*v + w)/w**2, (304, 595):
        u**3*v/w**2, (304, 596): -u**2*v/w, (304, 607): u**3*v/w**2,
        (304, 615): u**4*v/w**2, (304, 616): u**3*v*(u*v - w)/w**2,
        (304, 618): u**5*v/w**2, (304, 620): u**3, (304, 622):
        u**3*v*(u**2*v + u*w - v**2)/w**4, (304, 623): u*v**2/w**2,
        (304, 632): u**3*(u*v + w)/w**3, (304, 638): -u**2*v/w**2,
        (304, 641): u*v/w, (304, 643): u**2*v**2/w**2, (304, 644):
        u**2*v*(u**2 - v)/w**3, (304, 645): u*v*(u**2*w + u*v**2 -
        v*w)/w**3, (304, 646): -u*v*(u**2 - v)/w**2, (305, 215):
        -u**2/w, (305, 238): -u**2/w**2, (305, 245): -u*v/w, (305,
        263): -u, (305, 269): -u**2, (305, 307): u**2/w**2, (305,
        309): -u/w, (305, 311): -u/w, (305, 312): -u/w, (305, 313): 1,
        (305, 314): -u*v/w**2, (305, 322): -u**2*v/w**2, (305, 323):
        -u**2*v**2/w**2, (305, 325): u**2*v*(u**2 - v)/w**4, (305,
        335): u**3/w**3, (305, 376): -u/w, (305, 400): -u**3/w**2,
        (305, 431): -u**2*v/w, (305, 460): u**2*(u**2 - v)/w**3, (305,
        568): u**3*(u**2 - v)/w**3, (305, 588): u**3/w**2, (305, 589):
        u**2*(u*v - w)/w**2, (305, 591): 2*u**4/w**2, (305, 593):
        -u**3/w, (305, 596): -u**2/w, (305, 607): u**3/w**2, (305,
        615): u**4/w**2, (305, 616): u**3*(u*v - w)/w**2, (305, 618):
        u**5/w**2, (305, 622): u**3*v*(u**2 - v)/w**4, (305, 632):
        u**4/w**3, (305, 638): -u**2/w**2, (305, 644): u**2*(u**2 -
        v)/w**3, (305, 645): u*v*(u*v - w)/w**3, (305, 646): -u*(u**2
        - v)/w**2, (305, 647): -u**3*v/w**2, (306, 240): u*v/w, (306,
        306): v/w, (306, 372): v, (306, 373): v**2, (306, 375): u*v,
        (306, 391): v/w, (306, 404): u*v, (306, 510): u*v/w, (306,
        548): 1, (306, 555): v/w, (306, 563): u*v/w**2, (306, 564):
        u*v**2/w**2, (306, 568): -u*v*(u*w - v**2)/w**2, (306, 578):
        v**2/w, (306, 595): u*v**2/w, (306, 605): v, (306, 622):
        -u*v*(2*u*v*w - v**3 - w**2)/w**3, (306, 632): -v*(u*w -
        v**2)/w**2, (306, 645): u*v**2/w, (307, 211): -u, (307, 319):
        -u*v**2/w, (307, 325): -v**2*(u**2 - v)/w**3, (307, 335):
        -u*v/w**2, (307, 353): -(u*w - v**2)/w, (307, 371): v, (307,
        373): u*v**2/w, (307, 395): -u/w, (307, 460): -v*(u**2 -
        v)/w**2, (307, 555): 1/w, (307, 568): -u*v*(u**2 - v)/w**2,
        (307, 579): v**2/w, (307, 588): -u*v/w, (307, 589): -u*v**2/w,
        (307, 591): -2*u**2*v/w, (307, 606): v, (307, 607): -u*v/w,
        (307, 615): -u**2*v/w, (307, 616): -u**2*v**2/w, (307, 618):
        -u**3*v/w, (307, 622): -u*v**2*(u**2 - v)/w**3, (307, 632):
        -u**2*v/w**2, (307, 633): -v*(u*w - v**2)/w**2, (307, 643):
        -u**2*v/w, (307, 644): -v*(u**2 - v)/w**2, (307, 645):
        -v**3/w**2, (308, 82): -u**2/w, (308, 190): -u**2*v/w**2,
        (308, 242): u*v/w, (308, 308): v/w, (308, 325): -u*v*(2*u*v -
        w)/w**3, (308, 377): u*v, (308, 386): 1, (308, 393): v/w,
        (308, 395): u/w, (308, 404): u**2*v/w, (308, 460):
        -2*u**2*v/w**2, (308, 510): u/w, (308, 564): u*v/w**2, (308,
        568): -u**2*v*(3*u*w + v**2)/w**3, (308, 573): -u*v/w, (308,
        579): -u**2*v/w, (308, 585): -u**2*v/w**2, (308, 586): -u,
        (308, 588): -u*v/w, (308, 591): -u*v*(u*w + v**2)/w**2, (308,
        595): -u**2*(u*w + v**2)/w**2, (308, 618): -u*v**2/w, (308,
        622): u**2*(u**2*w**2 - 2*u*v**2*w - v**4 + v*w**2)/w**4,
        (308, 623): -u*v/w, (308, 627): -u*v**2/w**2, (308, 633):
        -u**2*v**2/w**2, (308, 639): -u**2*v**2/w**3, (308, 640):
        -u*v/w, (308, 642): -v*(u*v - w)/w**2, (308, 645): -u*v*(v**3
        - w**2)/w**3, (309, 309): v/w, (309, 325): -u**2*v/w**3, (309,
        373): u*v/w, (309, 393): 1/w, (309, 460): -u**2/w**2, (309,
        568): -u**3/w**2, (309, 588): -u/w, (309, 591): -u**2/w, (309,
        622): -u**3*v/w**3, (309, 623): (-u*w + v**2)/w**2, (309,
        641): v/w, (309, 642): -u*v/w**2, (309, 645): -u**2*v/w**2,
        (309, 647): u*v/w, (310, 164): -u*v/w, (310, 240): u/w, (310,
        310): v/w, (310, 319): -u**2, (310, 330): -u/w, (310, 332): 1,
        (310, 335): -u*v/w**2, (310, 339): v/w, (310, 342):
        -u**2/w**2, (310, 353): -u*(2*u*v - w)/w, (310, 370): -u,
        (310, 371): -u**2, (310, 373): -u*v*(u**2 - v)/w, (310, 377):
        -u**3, (310, 403): -u**2/w, (310, 458): -u**2, (310, 568):
        u**2*(u*v - w)/w**2, (310, 591): -u**2*v/w, (310, 607):
        -u*v/w, (310, 615): -u**2*v/w, (310, 616): u**2*(u*w -
        v**2)/w, (310, 618): -u**3*v/w, (310, 622): u**2*v*(u*v -
        w)/w**3, (310, 632): -u**2*v/w**2, (310, 633): u**3/w, (310,
        640): u*v/w, (310, 642): u*v**2/w**2, (310, 644):
        -u**2*v/w**2, (310, 645): u**2*v**2/w**2, (311, 211): -u**2/w,
        (311, 314): -u/w, (311, 319): -u**2*(u*w + v**2)/w**2, (311,
        322): -u**2/w, (311, 323): u**2*v/w, (311, 335): -u/w**2,
        (311, 339): 1/w, (311, 591): -u**2*(u*v + w)/w**2, (311, 607):
        -u**2*v/w**2, (311, 611): u**2/w, (311, 615): -u**3*v/w**2,
        (311, 616): u**3*(u*w - v**2)/w**2, (311, 618): -u**4*v/w**2,
        (311, 619): u**3/w, (311, 620): -u**2, (311, 632): -u**2/w**2,
        (311, 642): u*v/w**2, (311, 643): -u*v*(u**2 - v)/w**2, (311,
        644): -u**3*v/w**3, (312, 242): u/w, (312, 245): u, (312,
        303): -u/w, (312, 305): 1, (312, 309): -u**2/w, (312, 312):
        v/w, (312, 314): u/w, (312, 315): -u**2/w**2, (312, 322):
        u**2/w, (312, 325): -u**2*v/w**3, (312, 404): u**2/w, (312,
        431): u**2, (312, 589): -2*u**3/w, (312, 592): -u**2/w, (312,
        611): -u**2/w, (312, 616): -u**4/w, (312, 619): -u**3/w, (312,
        622): -u**3*v/w**3, (312, 643): -u*v**2/w**2, (312, 645): u/w,
        (313, 215): u/w, (313, 312): 1/w, (313, 319): -u**2*v/w**2,
        (313, 323): u**2/w, (313, 591): -u**3/w**2, (313, 593):
        u**2/w, (313, 607): -u**2/w**2, (313, 615): -u**3/w**2, (313,
        616): -u**3*v/w**2, (313, 618): -u**4/w**2, (313, 644):
        -u**3/w**3, (313, 647): u**2*v/w**2, (314, 238): u/w, (314,
        307): -u/w, (314, 311): 1, (314, 314): v/w, (314, 323): -u**2,
        (314, 325): -u*v*(u**2 - v)/w**3, (314, 335): -u**2/w**2,
        (314, 373): -u**2*(u**2 - v)/w, (314, 454): -u**3/w, (314,
        460): -u*(u**2 - v)/w**2, (314, 568): -u**2*(u**2 - v)/w**2,
        (314, 588): -u**2/w, (314, 589): -2*u**2*v/w, (314, 591):
        -u**3/w, (314, 596): -u*(u*v - w)/w, (314, 608): -u, (314,
        611): -u*v/w, (314, 614): -u**2, (314, 616): -2*u**3*v/w,
        (314, 619): -u**2*v/w, (314, 622): -u**2*v*(u**2 - v)/w**3,
        (314, 632): -u**3/w**2, (314, 644): u*v/w**2, (314, 645):
        -u*v**2/w**2, (315, 238): u*v/w, (315, 315): v/w, (315, 373):
        u*v, (315, 376): v, (315, 392): 1, (315, 395): v/w, (315,
        400): u**2*v/w, (315, 643): u*v**2/w, (316, 191): -u/w, (316,
        269): -u*v, (316, 271): -u*v/w**2, (316, 299): -u*v**2/w**2,
        (316, 317): -u*v/w, (316, 319): -u**2*v**2/w**2, (316, 322):
        -u*v**2/w**2, (316, 373): -u**3/w, (316, 427): -u**2*v/w,
        (316, 430): -u*v/w, (316, 454): -u**2/w, (316, 569): -u**2/w,
        (316, 584): -u/w, (316, 590): u**3/w**2, (316, 592): -u**2/w,
        (316, 595): -u**2*v/w**2, (316, 618): u**3/w, (316, 620):
        -u**2, (316, 623): -2*u**2*v/w**2, (316, 633): -u/w, (316,
        634): u**2/w**2, (316, 635): -u/w, (316, 636): -u/w, (316,
        637): 1, (316, 638): -u*v/w**2, (316, 641): -u**2/w, (316,
        642): u**3/w**2, (316, 644): u**3*v/w**3, (316, 646):
        -u**2*v/w**2, (317, 299): -u/w, (317, 319): -u*v**2/w**2,
        (317, 323): -u*v/w, (317, 427): -u*v/w, (317, 589): -u**2/w,
        (317, 590): -u**2/w**2, (317, 611): -u/w, (317, 616): -u**3/w,
        (317, 618): -u**2/w, (317, 619): -u**2/w, (317, 620): u, (317,
        634): -u/w**2, (317, 636): 1/w, (317, 642): -u**2/w**2, (317,
        643): -u**2*v/w**2, (317, 644): -u**2*v/w**3, (318, 318): v/w,
        (318, 376): -u**3/w, (318, 377): u**2, (318, 401): -u**2/w**2,
        (318, 402): u/w, (318, 457): -u**2/w, (318, 458): u, (318,
        568): -u**2*v/w**2, (318, 590): -u**2*v/w**2, (318, 591):
        -u*v/w, (318, 596): -u**2*v/w, (318, 611): -u*v/w, (318, 616):
        -u**2, (318, 618): -u**2*v/w, (318, 619): -u**2*v/w, (318,
        622): -u**2*v**2/w**3, (318, 627): -u/w, (318, 628): -u/w,
        (318, 629): 1, (318, 633): -u**2/w, (318, 634): -u*v/w**2,
        (318, 636): v/w, (318, 639): -u**2/w**2, (318, 640): -u**2/w,
        (318, 642): -u**2*v/w**2, (318, 644): -u**2*v**2/w**3, (318,
        645): -u*v**2/w**2, (319, 319): v/w, (319, 591): u/w, (319,
        607): 1/w, (319, 615): u/w, (319, 616): u*v/w, (319, 618):
        u**2/w, (319, 644): u/w**2, (320, 164): u*v/w, (320, 320):
        v/w, (320, 353): 2*u**2*v/w, (320, 370): u, (320, 371): u**2,
        (320, 373): u*v*(u**2 - v)/w, (320, 376): u**2*v/w, (320,
        399): u/w, (320, 400): u*v/w, (320, 401): u*v/w**2, (320,
        434): u*v/w, (320, 452): u, (320, 454): u**2*v/w, (320, 457):
        u*v/w, (320, 568): u**2/w, (320, 580): v/w, (320, 588): u*v/w,
        (320, 589): u*v**2/w, (320, 590): u*v**2/w**2, (320, 596):
        2*u*v**2/w, (320, 608): v, (320, 611): v**2/w, (320, 614):
        u*v, (320, 616): u**2*v**2/w, (320, 617): u*v/w, (320, 619):
        u*v**2/w, (320, 622): u**2*v/w**2, (320, 624): 1, (320, 628):
        v/w, (320, 634): v**2/w**2, (320, 640): u*v/w, (320, 642):
        u*v**2/w**2, (320, 644): -u*v*(u*w - v**2)/w**3, (320, 645):
        u*v/w, (321, 321): v/w, (321, 376): u**2/w, (321, 401):
        u/w**2, (321, 457): u/w, (321, 590): u*v/w**2, (321, 596):
        u*v/w, (321, 611): v/w, (321, 618): u*v/w, (321, 619): u*v/w,
        (321, 628): 1/w, (321, 634): v/w**2, (321, 640): u/w, (321,
        642): u*v/w**2, (321, 644): u*v**2/w**3, (322, 322): v/w,
        (322, 373): u*(u**2 - v)/w, (322, 400): u/w, (322, 454):
        u**2/w, (322, 589): u*v/w, (322, 591): -u**2/w, (322, 596):
        u*v/w, (322, 607): -u/w, (322, 608): 1, (322, 611): v/w, (322,
        614): u, (322, 615): -u**2/w, (322, 616): u**2*v/w, (322,
        618): -u**3/w, (322, 619): u*v/w, (322, 644): -u**2/w**2,
        (323, 323): v/w, (323, 589): u/w, (323, 611): 1/w, (323, 616):
        u**2/w, (323, 619): u/w, (324, 44): -u, (324, 45): u**2/w,
        (324, 65): -u/w, (324, 69): 1, (324, 103): u*v, (324, 130):
        -u, (324, 210): u*v/w, (324, 211): u*v**2/w, (324, 237): -u/w,
        (324, 238): -u*v/w, (324, 299): -u*v**2/w, (324, 325):
        -u**2*v*(u*v - w)/w**3, (324, 326): u*v/w, (324, 380): u*v/w,
        (324, 542): -u/w, (324, 596): u*v, (324, 622): -u**3*v*(u*v -
        w)/w**3, (325, 325): v/w, (325, 579): w, (325, 612): -u, (325,
        633): v, (326, 244): u, (326, 318): 1, (326, 321): u, (327,
        29): -u, (327, 200): -u/w, (327, 202): -u/w, (327, 204): 1,
        (327, 210): -u**2/w, (327, 265): -u*w, (327, 292): u**2, (327,
        299): u**2*v/w, (327, 314): u*v/w, (327, 319): u**2*v**3/w**2,
        (327, 325): u**2*v**2/w**3, (327, 326): -u**2/w, (327, 341):
        -u/w, (327, 342): u**2/w**2, (327, 373): u**2, (327, 427):
        u**2*v**2/w, (327, 589): u**3*v/w, (327, 590): u**3*v/w**2,
        (327, 616): u**3, (327, 622): u**3*v**2/w**3, (327, 643):
        u**2*v*(u*v - w)/w**2, (327, 644): u**3*v**2/w**3, (328, 200):
        -u*v/w, (328, 210): -u, (328, 229): -u/w, (328, 231): 1, (328,
        299): u*v, (328, 319): u*v**3/w, (328, 325): u**2*v**3/w**3,
        (328, 326): -u, (328, 342): u**2*v/w**2, (328, 395): u*v/w,
        (328, 427): u*v**2, (328, 535): u**2, (328, 557): -u/w, (328,
        589): u*(u*v - w), (328, 590): u**2*v/w, (328, 611): u*v,
        (328, 622): u**3*v**3/w**3, (328, 643): u*v*(u*v - w)/w, (328,
        644): u**2*v**2/w**2, (329, 212): -u, (329, 238): -u*v**2/w,
        (329, 271): -u**3*v/w, (329, 315): -v**2/w, (329, 319):
        -u*v**2, (329, 322): -v**2, (329, 334): -u*v/w, (329, 342):
        -u*v**2/w**2, (329, 347): -u*v/w, (329, 349): v, (329, 352):
        u**2, (329, 392): -v, (329, 395): -v**2/w, (329, 400):
        -u**2*v**2/w, (329, 553): -u/w, (329, 554): 1, (329, 557):
        v/w, (329, 589): -u*v**2, (329, 591): u**2*v, (329, 595):
        -u**4*v/w, (329, 607): u*v, (329, 608): -v*w, (329, 611):
        -v**2, (329, 622): -u**2*v/w, (329, 639): -u*v/w, (329, 643):
        -u*v**3/w, (330, 190): -u*v**2/w**2, (330, 213): -u, (330,
        244): u**2, (330, 271): -u**3/w, (330, 323): -v**2, (330,
        325): -2*u*v**3/w**3, (330, 335): -v**2/w**2, (330, 342):
        -u*v/w**2, (330, 348): -u*v/w, (330, 350): v, (330, 373):
        -u*v, (330, 391): -u/w, (330, 395): -v/w, (330, 557): 1/w,
        (330, 568): -u**2*v**2/w**2, (330, 578): -u*v/w, (330, 589):
        -u*v, (330, 595): -u**4/w, (330, 611): -v, (330, 622):
        -3*u**2*v**3/w**3, (330, 632): -2*u*v**2/w**2, (330, 645):
        -u**2*v/w, (331, 212): -u**2/w, (331, 238): -u*v/w, (331,
        271): -u**4*v/w**2, (331, 307): u*v/w, (331, 311): -v, (331,
        314): -v**2/w, (331, 322): -u*v**2/w, (331, 325): u*v**2*(u**2
        - v)/w**3, (331, 334): -u/w, (331, 335): u**2*v/w**2, (331,
        337): -u/w, (331, 338): 1, (331, 341): v/w, (331, 342):
        -u*v/w**2, (331, 347): -u**2*v/w**2, (331, 349): u*v/w, (331,
        352): u**3/w, (331, 400): -u**2*v/w, (331, 460): -u*v**2/w**2,
        (331, 568): -u*v*(2*u*v - w)/w**2, (331, 591): u**3*v/w, (331,
        595): -u**5*v/w**2, (331, 607): u**2*v/w, (331, 622):
        u*v*(u**3*v - u**2*w - 2*u*v**2 + v*w)/w**3, (331, 632):
        u**3*v/w**2, (331, 639): -u**2*v/w**2, (332, 211): -u*v/w,
        (332, 213): -u**2/w, (332, 244): u**3/w, (332, 271):
        -u**4/w**2, (332, 310): -u/w, (332, 314): -v/w, (332, 319):
        -u**2*v/w, (332, 322): -u*v/w, (332, 341): 1/w, (332, 342):
        -u/w**2, (332, 347): -u**2/w**2, (332, 349): u/w, (332, 589):
        -u**2*v/w, (332, 595): -u**5/w**2, (332, 607): u**2/w, (332,
        639): -u**2/w**2, (332, 643): -u**2*v**2/w**2, (332, 645):
        -u**3*v/w**2, (333, 239): u*v/w, (333, 333): v/w, (333, 375):
        v*w, (333, 395): v, (333, 403): u*v, (333, 514): -u**2*v/w,
        (333, 537): -u*v, (333, 547): 1, (333, 553): v/w, (333, 563):
        u*v**2/w**2, (333, 585): v, (333, 639): v**2/w, (333, 644):
        u*v**2/w, (334, 271): u**2*v/w, (334, 334): v/w, (334, 346):
        v, (334, 391): -v/w, (334, 553): 1/w, (334, 591): -u*v, (334,
        595): u**3*v/w, (334, 607): -v, (334, 616): -u*v**2, (334,
        639): -v*(u*v - w)/w**2, (334, 644): -u*v/w, (335, 136): u**2,
        (335, 271): u**2*v/w, (335, 335): v/w, (335, 377): v*w, (335,
        395): 1, (335, 537): -u, (335, 579): -u*v, (335, 595):
        u**3*v/w, (335, 612): u**2*v/w, (335, 622): u**2*(u*w +
        v**2)/w**2, (335, 632): u*v/w, (335, 633): -u*v**2/w, (336,
        233): 1/w, (336, 271): u**2/w, (336, 336): v/w, (336, 395):
        u/w, (336, 591): -u, (336, 595): u**3/w, (336, 633): u*v/w,
        (336, 638): v/w, (336, 645): -u*v/w, (336, 647): v, (337,
        239): u/w, (337, 314): v, (337, 315): -u*v/w, (337, 319):
        -u**2*v, (337, 329): -u/w, (337, 331): 1, (337, 334): -u**2/w,
        (337, 337): v/w, (337, 342): -u**2*v/w**2, (337, 514):
        -u**2/w, (337, 568): u**2*v/w, (337, 611): -u*v, (337, 616):
        u**3*v, (337, 622): u**2*v**2/w**2, (337, 645): u*v**2/w,
        (338, 212): u/w, (338, 213): -u*v/w, (338, 244): u**2*v/w,
        (338, 310): -v/w, (338, 319): -u*v**2/w, (338, 337): 1/w,
        (338, 346): u*v/w, (338, 352): -u**2/w, (338, 591): -u**2*v/w,
        (338, 622): u**2*v/w**2, (338, 644): -u**2*v/w**2, (339, 211):
        u, (339, 314): 1, (339, 319): u**2, (339, 322): u, (339, 323):
        -u*v, (339, 611): -u, (339, 643): u**2*v/w, (340, 206): 1/w,
        (340, 211): u**2/w, (340, 214): u/w, (340, 314): u/w, (340,
        319): u*(u**2 - v)/w, (340, 322): u**2/w, (340, 346): u/w,
        (340, 584): u/w, (340, 589): u**3/w, (340, 592): u**2/w, (340,
        638): u*v/w**2, (340, 643): u**2*(u*v + w)/w**2, (340, 644):
        -u**2/w**2, (340, 645): u**2*v/w**2, (340, 646): u**2*v/w**2,
        (341, 213): u, (341, 244): -u**2, (341, 271): u**3/w, (341,
        310): 1, (341, 373): u*v, (341, 595): u**4/w, (341, 607): -u,
        (342, 342): v/w, (342, 373): v*w, (342, 391): 1, (342, 639):
        u*v/w, (343, 299): -v**2/w, (343, 317): -v, (343, 319):
        -u*v**2/w, (343, 326): v/w, (343, 344): 1, (343, 345): -u/w,
        (343, 352): -u**2/w, (343, 427): -u*v, (343, 568):
        u*v**2/w**2, (343, 616): -u*v, (343, 622): u*v*(u*w +
        v**2)/w**3, (343, 631): -u/w, (344, 244): -u*v/w, (344, 318):
        -v/w, (344, 321): -u*v/w, (344, 345): 1/w, (344, 352): u/w,
        (344, 622): -u*v/w**2, (345, 299): v, (345, 343): 1, (345,
        345): v/w, (345, 514): u/w, (345, 568): -u*v/w, (345, 590):
        -u*v/w, (345, 596): -u*v, (345, 616): -u**2*v, (345, 619):
        -u*v, (345, 622): -u*v**2/w**2, (345, 626): -u/w, (345, 631):
        -u**2/w, (345, 639): -u**2*v/w**2, (345, 644): -u*v**2/w**2,
        (346, 644): 1/w, (346, 645): -v/w, (347, 164): v, (347, 347):
        v/w, (347, 353): u*v, (347, 370): w, (347, 373): -v**2, (347,
        568): u, (347, 596): v**2, (347, 622): u*v/w, (347, 645): v,
        (348, 190): u/w, (348, 325): 2*u*v/w**2, (348, 348): v/w,
        (348, 568): u**2/w, (348, 596): v, (348, 622): 3*u**2*v/w**2,
        (348, 640): 1, (348, 642): v/w, (348, 645): u*v/w, (349, 347):
        1/w, (349, 373): -v, (349, 645): u*v/w, (350, 348): 1/w, (350,
        643): -v/w, (350, 645): u/w, (351, 37): -u/w, (351, 41): 1,
        (351, 44): v/w, (351, 45): -u*v/w**2, (351, 212): u*v/w**2,
        (351, 239): -u/w**2, (351, 244): u*v/w, (351, 271):
        -u**2*v/w**2, (351, 352): -u**2*v/w**2, (351, 514): u**2/w**2,
        (351, 568): -u**2*v/w**2, (351, 595): -u**3*v/w**2, (352,
        352): v/w, (352, 590): v/w, (352, 612): v/w, (352, 616): u*v,
        (352, 619): v, (352, 626): 1/w, (352, 631): u/w, (352, 639):
        u*v/w**2, (352, 644): v**2/w**2, (353, 319): 1, (354, 29):
        v/w, (354, 47): 1, (354, 145): -u/w, (354, 261): u**2*v/w**2,
        (354, 265): u*v**2/w, (354, 271): u*v/w**2, (354, 292):
        -u*v/w, (354, 319): u**2*v**2/w**2, (354, 322): u*v**2/w**2,
        (354, 346): -u**2*v/w**2, (354, 347): u**2*v/w**3, (354, 349):
        -u*v/w**2, (354, 352): u*v/w**2, (354, 514): -u/w**2, (354,
        568): u*v/w**2, (354, 595): u**2*v/w**2, (354, 639):
        u**2*v/w**3, (354, 644): u**3*v/w**3, (355, 147): -v, (355,
        172): -u/w, (355, 174): 1, (355, 261): u*v/w, (355, 271):
        u*v**2/w**2, (355, 319): u*v**2/w, (355, 322): v**2/w, (355,
        346): -u*v/w, (355, 347): u*v/w**2, (355, 349): -v/w, (355,
        352): u*v**2/w**2, (355, 369): u*(u*v - w)/w**2, (355, 373):
        u*v**2/w, (355, 514): -u*v/w**2, (355, 535): -u*v/w, (355,
        568): u*v**2/w**2, (355, 589): u*v**2/w, (355, 595):
        u**2*v**2/w**2, (355, 616): u**2*v**2/w, (355, 639): u*v/w**2,
        (355, 644): u**2*v/w**2, (356, 180): -u/w, (356, 184):
        -u*v**2/w, (356, 271): u**2*v**2/w**2, (356, 281): u*v/w,
        (356, 282): -v, (356, 325): -v**2/w**2, (356, 352): -u*v/w,
        (356, 361): -u*v/w, (356, 369): -u*v**2/w**2, (356, 373):
        -u*v*(u*v + w)/w, (356, 524): -u/w, (356, 525): 1, (356, 568):
        -u*v/w, (356, 579): -v, (356, 595): u**3*v**2/w**2, (356,
        605): u**2*v/w, (356, 606): -u*v, (356, 616): -u*v**3/w, (356,
        622): -u*v**2/w**2, (356, 633): -v**2/w, (356, 645): u**2*v/w,
        (357, 184): -u*v/w, (357, 244): -u*v/w, (357, 255): -v, (357,
        271): v*(u**2 - v)/w**2, (357, 352): -u**2*v/w**2, (357, 361):
        -u/w, (357, 362): -u/w, (357, 363): 1, (357, 369): -u*v/w**2,
        (357, 373): -u**2*v/w, (357, 595): u*v*(u**2 - v)/w**2, (357,
        616): -u*v**2/w, (357, 622): u**2*v**2/w**3, (357, 632):
        u*v/w**2, (357, 633): -v/w, (357, 643): -u*v/w, (358, 52): 1,
        (358, 153): -u/w, (358, 184): -u*v/w, (358, 271): u**2*v*(u*v
        + w)/w**3, (358, 281): u**2*v/w**2, (358, 373): -u**2*v/w,
        (358, 460): u*v/w**2, (358, 568): u*(2*u*v - w)/w**2, (358,
        595): u**3*v*(u*v + w)/w**3, (358, 605): u**3*v/w**2, (358,
        622): u*v*(u*v - w)/w**3, (358, 645): u**3*v/w**2, (359, 53):
        1, (359, 184): -u/w, (359, 190): -u/w**2, (359, 244):
        -u**2*v/w**2, (359, 254): -u/w, (359, 271): u**3*v/w**3, (359,
        281): u**2/w**2, (359, 323): -u*v/w, (359, 325): -u*v/w**3,
        (359, 348): -u**2/w**2, (359, 350): u/w, (359, 373): -u**2/w,
        (359, 568): -u**2/w**2, (359, 595): u**4*v/w**3, (359, 605):
        u**3/w**2, (359, 622): -2*u**2*v/w**3, (360, 186): v, (360,
        360): v/w, (360, 377): v*w, (360, 514): u*v**2/w**2, (360,
        519): 1, (360, 524): v/w, (360, 537): v**2/w, (360, 568):
        v**2/w, (360, 595): v, (360, 618): v**2, (360, 622): -v*(u*w -
        v**2)/w**2, (361, 271): -u*v**2/w**2, (361, 281): -v/w, (361,
        369): -u/w, (361, 524): 1/w, (361, 568): v/w, (361, 595):
        -u**2*v**2/w**2, (361, 605): -u*v/w, (361, 616): v**3/w, (361,
        622): v**2/w**2, (361, 631): v**2/w**2, (361, 639): v**3/w**3,
        (361, 645): -u*v/w, (362, 136): -u*v/w, (362, 188): v, (362,
        271): -v*(u*v - w)/w**2, (362, 357): 1, (362, 362): v/w, (362,
        369): u/w, (362, 377): u*v, (362, 514): u*v/w**2, (362, 537):
        v/w, (362, 568): -u*v**2/w**2, (362, 590): -u*v**2/w**2, (362,
        591): -v**2/w, (362, 595): -u*v*(u*v - w)/w**2, (362, 612):
        -u*v**2/w**2, (362, 616): -u**2*v**2/w, (362, 619): -u*v**2/w,
        (362, 622): -u*v*(u*w + 2*v**2)/w**3, (362, 626): -u*v/w**2,
        (362, 627): -v/w, (362, 631): -u**2*v/w**2, (362, 632):
        -v**2/w**2, (362, 639): -u*v*(u*v + w)/w**3, (362, 644):
        -u*v**3/w**3, (362, 645): -v**3/w**2, (363, 244): v/w, (363,
        271): -u*v/w**2, (363, 352): u*v/w**2, (363, 362): 1/w, (363,
        595): -u**2*v/w**2, (363, 622): -u*v**2/w**3, (363, 632):
        -v/w**2, (364, 186): 1, (364, 288): -u/w, (364, 622): u*(u*v -
        w)/w**2, (365, 49): 1, (365, 261): -u/w, (365, 645):
        -u**2*v/w**2, (366, 188): 1, (366, 255): -u, (366, 323): u,
        (366, 377): u, (366, 643): -u**2/w, (367, 161): 1, (367, 269):
        u, (367, 645): -u**2/w**2, (367, 647): u/w, (368, 184): 1,
        (368, 271): -u**2*v/w**2, (368, 281): -u/w, (368, 595):
        -u**3*v/w**2, (368, 605): -u**2/w, (369, 184): v, (369, 361):
        1, (369, 369): v/w, (369, 373): u*v, (369, 631): -v/w, (369,
        639): -v**2/w**2, (370, 319): -u*v/w, (370, 322): -v/w, (370,
        347): -u/w**2, (370, 349): 1/w, (370, 568): -u*v/w**2, (370,
        622): -u*v**2/w**3, (370, 639): -u/w**2, (371, 319): -v/w,
        (371, 346): 1/w, (371, 644): -u/w**2, (372, 374): -u/w, (372,
        375): 1, (372, 612): -u/w, (372, 622): -u*v/w**2, (372, 645):
        -v/w, (373, 645): 1/w, (374, 372): 1, (374, 373): v, (374,
        374): v/w, (374, 622): u/w, (375, 374): 1/w, (376, 373): 1,
        (376, 645): -u/w, (377, 643): 1/w, (378, 64): -u/w, (378, 68):
        1, (378, 71): v/w, (378, 72): -u*v/w**2, (378, 104): u*v/w,
        (378, 131): -u/w, (378, 212): u*v**2/w**2, (378, 239):
        -u*v/w**2, (378, 298): u*v/w, (378, 325): -u**2*v/w**2, (378,
        379): -u**2*v/w**2, (378, 541): u**2/w**2, (378, 595):
        -u**2*v/w, (379, 379): v/w, (379, 572): 1, (379, 577): u,
        (379, 585): u*v/w, (379, 590): v**2/w, (379, 617): v, (379,
        626): v/w, (379, 631): u*v/w, (379, 639): v*(u*v + w)/w**2,
        (379, 643): u*v, (379, 644): -v*(u*w - v**2)/w**2, (379, 646):
        v, (380, 319): v, (380, 427): w, (381, 56): v/w, (381, 74): 1,
        (381, 199): -u/w, (381, 315): u**2*v/w**2, (381, 319):
        u*v**2*(u*v + w)/w**2, (381, 322): u*v**3/w**2, (381, 325):
        u*v/w**2, (381, 346): -u*v*(u*v + w)/w**2, (381, 347):
        u**2*v**2/w**3, (381, 349): -u*v**2/w**2, (381, 379):
        u*v/w**2, (381, 427): u**2*v**2/w, (381, 430): u*v**2/w, (381,
        481): -u**2*v/w, (381, 482): u**2*v/w**2, (381, 484): -u*v/w,
        (381, 541): -u/w**2, (381, 585): u**2*v/w**2, (381, 590):
        u**3*v/w**2, (381, 595): u*v/w, (381, 639): u**2*v**2/w**3,
        (381, 644): u**3*v**2/w**3, (382, 201): -v, (382, 226): -u/w,
        (382, 228): 1, (382, 315): u*v/w, (382, 319): u*v**3/w, (382,
        322): v**3/w, (382, 325): u*v**2/w**2, (382, 346): -u*v**2/w,
        (382, 347): u*v**2/w**2, (382, 349): -v**2/w, (382, 379):
        u*v**2/w**2, (382, 396): u*(u*v - w)/w**2, (382, 400):
        u*v**2/w, (382, 427): u*v**2, (382, 430): v**2, (382, 481):
        -u*v, (382, 482): u*v/w, (382, 484): -v, (382, 541):
        -u*v/w**2, (382, 562): -u*v/w, (382, 585): u*v/w, (382, 590):
        u**2*v/w, (382, 595): u*v**2/w, (382, 616): u*v**2, (382,
        639): u*v**2/w**2, (382, 644): u**2*v**2/w**2, (383, 234):
        -u/w, (383, 238): -u*v**2/w, (383, 325): v**2*(u**2 - v)/w**2,
        (383, 335): u*v/w, (383, 336): -v, (383, 379): -u*v/w, (383,
        388): -u*v/w, (383, 396): -u*v**2/w**2, (383, 400): -u*v*(u*v
        + w)/w, (383, 460): -v**2/w, (383, 551): -u/w, (383, 552): 1,
        (383, 568): -u*v**2/w, (383, 579): -v**2, (383, 591): u**2*v,
        (383, 595): -u*v, (383, 606): -v*w, (383, 622): u*v*(u**2*v +
        u*w - v**2)/w**2, (383, 632): u**2*v/w, (383, 633): -v**3/w,
        (383, 643): -u*v**3/w, (383, 645): u**2*v**2/w, (384, 238):
        -u*v/w, (384, 298): -u*v/w, (384, 309): -v, (384, 325):
        v*(u**2 - v)/w**2, (384, 379): -u**2*v/w**2, (384, 388): -u/w,
        (384, 389): -u/w, (384, 390): 1, (384, 396): -u*v/w**2, (384,
        400): -u**2*v/w, (384, 568): u**2*v**2/w**2, (384, 578):
        u*v/w, (384, 579): -v, (384, 589): -u*v, (384, 622):
        u*v*(u**2*w + u*v**2 - v*w)/w**3, (384, 632): u*v**2/w**2,
        (384, 633): -v**2/w, (384, 643): -2*u*v**2/w, (385, 79): 1,
        (385, 207): -u/w, (385, 238): -u*v/w, (385, 271): u*v/w, (385,
        325): u**3*v**2/w**3, (385, 335): u**2*v/w**2, (385, 400):
        -u**2*v/w, (385, 568): u*v*(u*v - w)/w**2, (385, 591):
        u**3*v/w, (385, 595): u*(2*u*v - w)/w, (385, 622):
        u*(u**3*v**2 - u**2*v*w + u*v**3 + u*w**2 - v**2*w)/w**3,
        (385, 632): u**3*v/w**2, (385, 645): u**3*v**2/w**2, (386,
        80): 1, (386, 82): -u/w, (386, 190): -u*v/w**2, (386, 238):
        -u/w, (386, 298): -u**2*v/w**2, (386, 308): -u/w, (386, 323):
        -u*v**2/w, (386, 325): u*v*(u**2 - v)/w**3, (386, 335):
        u**2/w**2, (386, 348): -u**2*v/w**2, (386, 350): u*v/w, (386,
        400): -u**2/w, (386, 431): -u*v, (386, 460): -u*v/w**2, (386,
        483): -u**2/w, (386, 485): u, (386, 568): -2*u**2*v/w**2,
        (386, 595): -u**2/w, (386, 622): u**2*(u**2*v + u*w -
        2*v**2)/w**3, (386, 632): u**3/w**2, (387, 240): v, (387,
        387): v/w, (387, 404): v*w, (387, 541): u*v**2/w**2, (387,
        546): 1, (387, 551): v/w, (387, 564): v**2/w, (387, 568):
        -v*(u*w - v**2)/w, (387, 595): v**2, (387, 622): -v*(2*u*v*w -
        v**3 - w**2)/w**2, (387, 645): v**2, (388, 325): -u*v**2/w**2,
        (388, 335): -v/w, (388, 396): -u/w, (388, 551): 1/w, (388,
        568): v**2/w, (388, 577): v**2/w, (388, 585): v**3/w**2, (388,
        591): -u*v, (388, 595): v, (388, 622): -v*(u**2*v + u*w -
        v**2)/w**2, (388, 631): v**3/w**2, (388, 632): -u*v/w, (388,
        639): v**4/w**3, (388, 643): v**3/w, (388, 645): -u*v**2/w,
        (389, 190): -u*v/w, (389, 242): v, (389, 325): -v*(u*v -
        w)/w**2, (389, 384): 1, (389, 389): v/w, (389, 396): u/w,
        (389, 404): u*v, (389, 541): u*v/w**2, (389, 564): v/w, (389,
        568): -u*v*(u*w + 2*v**2)/w**2, (389, 572): -u*v/w, (389,
        573): -v, (389, 577): -u**2*v/w, (389, 578): -v**2/w, (389,
        585): -u*v*(u*v + w)/w**2, (389, 590): -u*v**3/w**2, (389,
        591): -v**3/w, (389, 595): -u*v**2/w, (389, 617): -u*v**2/w,
        (389, 618): -v**2, (389, 622): -u*v*(u*v*w + 2*v**3 -
        w**2)/w**3, (389, 626): -u*v**2/w**2, (389, 627): -v**2/w,
        (389, 631): -u**2*v**2/w**2, (389, 632): -v**3/w**2, (389,
        639): -u*v**2*(u*v + 2*w)/w**3, (389, 643): -u**2*v**2/w,
        (389, 644): u*v**2*(u*w - v**2)/w**3, (389, 645): v**2*(u*w -
        v**2)/w**2, (389, 646): -u*v**2/w, (390, 298): v/w, (390,
        325): -u*v/w**2, (390, 379): u*v/w**2, (390, 389): 1/w, (390,
        568): -u*v**2/w**2, (390, 578): -v/w, (390, 622): -u*v*(u*w +
        v**2)/w**3, (390, 632): -v**2/w**2, (391, 240): 1, (391, 342):
        -u/w, (391, 568): u*(u*v - w)/w, (391, 622): u*v*(u*v -
        w)/w**2, (392, 76): 1, (392, 315): -u/w, (392, 591):
        -u**2*v/w, (392, 645): -u**2*v**2/w**2, (393, 242): 1, (393,
        309): -u, (393, 323): u*v, (393, 404): u, (393, 431): u*w,
        (393, 589): -u**2, (393, 643): -u**2*v/w, (394, 215): 1, (394,
        323): u, (394, 591): -u**2/w, (394, 593): u, (394, 645):
        -u**2*v/w**2, (394, 647): u*v/w, (395, 238): 1, (395, 325):
        -u**2*v/w**2, (395, 335): -u/w, (395, 622): -u**3*v/w**2,
        (395, 632): -u**2/w, (396, 238): v, (396, 388): 1, (396, 396):
        v/w, (396, 400): u*v, (396, 577): -v, (396, 585): -v**2/w,
        (396, 631): -v**2/w, (396, 639): -v**3/w**2, (397, 319):
        -u*v**2/w, (397, 322): -v**2/w, (397, 347): -u*v/w**2, (397,
        349): v/w, (397, 427): -u*v, (397, 430): -v, (397, 482): -u/w,
        (397, 484): 1, (397, 568): -u*v**2/w**2, (397, 585): -u/w,
        (397, 595): -u*v/w, (397, 622): u*v*(u*w - v**2)/w**3, (397,
        639): -u*v/w**2, (398, 319): -v**2/w, (398, 346): v/w, (398,
        427): -v, (398, 481): 1, (398, 590): -u/w, (398, 644):
        -u*v/w**2, (399, 401): -u/w, (399, 402): 1, (399, 568):
        -u*v/w, (399, 591): -v, (399, 622): -u*v**2/w**2, (399, 639):
        -u/w, (399, 645): -v**2/w, (400, 591): 1, (400, 645): v/w,
        (401, 399): 1, (401, 400): v, (401, 401): v/w, (401, 568): u,
        (401, 622): u*v/w, (402, 401): 1/w, (403, 400): 1, (403, 591):
        -u, (403, 645): -u*v/w, (404, 589): 1, (404, 643): v/w, (405,
        12): -u/w, (405, 16): 1, (405, 101): u*v/w, (405, 128): -u/w,
        (405, 157): u**2*v/w, (405, 160): u*v/w, (405, 161):
        -u*v**2/w, (405, 184): -u**2/w, (405, 187): -u/w, (405, 188):
        u*v/w, (405, 211): -u**3*v/w**2, (405, 214): -u**2*v/w**2,
        (405, 215): u*v/w, (405, 238): u**3/w**2, (405, 241):
        u**2/w**2, (405, 242): -u/w, (405, 407): -u*v*(u*v - w)/w**2,
        (405, 434): u*(u*v - w)/w**2, (405, 460): -u**2*(u*v -
        w)/w**3, (405, 568): -u**3*(u*v - w)/w**3, (405, 596):
        -u*v*(u*v - w)/w**2, (405, 623): u**2*v*(u*v - w)/w**3, (406,
        406): v/w, (406, 568): -u**2*v/w**2, (406, 591): -u*v/w, (406,
        593): v, (406, 600): 1, (406, 606): u, (406, 612): u/w, (406,
        622): -u*v*(u*v - w)/w**3, (406, 627): -u/w, (406, 633):
        -u**2/w, (406, 639): -u**2/w**2, (406, 645): -v*(u*v -
        w)/w**2, (407, 265): u, (407, 319): -u**2/w, (407, 407): v/w,
        (407, 425): 1, (407, 431): u, (408, 93): -u/w, (408, 95):
        -u/w, (408, 97): 1, (408, 101): -u**2/w, (408, 265):
        2*u**2*v/w, (408, 268): u*v/w, (408, 269): -u*v**2/w, (408,
        292): -u**2/w, (408, 319): -u**2*(u**2*v**2 + w**2)/w**3,
        (408, 322): -u*(u**2*v**2 - u*v*w + w**2)/w**3, (408, 323):
        u*v/w, (408, 346): u**3/w**2, (408, 373): -u**3*v/w**2, (408,
        376): -u**2*v/w**2, (408, 377): u*v/w, (408, 400): u**3/w**2,
        (408, 403): u**2/w**2, (408, 404): -u/w, (408, 407): u**2*(u*v
        - w)/w**2, (408, 422): u*(u*v - w)/w**2, (408, 423):
        u**2/w**2, (408, 460): u**2*v/w**3, (408, 568): u**3*v/w**3,
        (408, 589): -u**3*v/w**2, (408, 592): -u**2*v/w**2, (408,
        593): u*v/w, (408, 617): u**3/w**2, (408, 623): -u**3*(u*v -
        w)/w**3, (408, 638): -u**2*(u*v - w)/w**3, (408, 643):
        -u**4*(u*v - w)/w**3, (408, 644): -u**4/w**3, (408, 646):
        -u**3*(u*v - w)/w**3, (409, 93): -u*v/w, (409, 101): -u, (409,
        122): -u/w, (409, 124): 1, (409, 265): u**2*v**2/w, (409,
        268): u*v**2/w, (409, 269): -u*v**3/w, (409, 319):
        -u**3*v**2/w**2, (409, 322): -u**2*v**2/w**2, (409, 323):
        u*v**2/w, (409, 373): -u**2*v*(u*v - w)/w**2, (409, 376):
        -u**2*v**2/w**2, (409, 377): u*v**2/w, (409, 403):
        u**2*v/w**2, (409, 404): -u*v/w, (409, 407): u*(u*v - w)/w,
        (409, 423): u**2*v/w**2, (409, 449): u*(u*v - w)/w**2, (409,
        460): u**2*v**2/w**3, (409, 535): -u**2/w, (409, 562):
        u**3/w**2, (409, 568): u**3*v**2/w**3, (409, 589):
        -u**2*v*(u*v - w)/w**2, (409, 592): -u**2*v**2/w**2, (409,
        593): u*v**2/w, (409, 611): -u*v*(u*v - w)/w**2, (409, 616):
        -u**2*(u*v - w)**2/w**2, (409, 617): u**2/w, (409, 619):
        -u*(u*v - w)**2/w**2, (409, 623): -u**2*(u*v - w)/w**2, (409,
        643): -u**3*(u*v - w)/w**2, (409, 644): -u**3/w**2, (409,
        646): -u**2*(u*v - w)/w**2, (410, 106): -u, (410, 125): -u/w,
        (410, 130): -u**2*v**2/w**2, (410, 164): u*v/w, (410, 218):
        -u/w, (410, 271): u*v*(u**2 - v)/w**2, (410, 325):
        -u**2*v*(u**2 - v)/w**3, (410, 353): u*v**3/w**2, (410, 371):
        u*v**2/w, (410, 373): u**3*v*(u*v - w)/w**2, (410, 376):
        u*v**3/w**2, (410, 380): -u*v**2/w**2, (410, 398): -u*v/w,
        (410, 403): -u*v**2/w**2, (410, 423): -u*v**2/w**2, (410,
        430): -u*v**2/w, (410, 446): -u*v/w, (410, 449): -u*v**2/w**2,
        (410, 454): -2*u**2*v/w, (410, 470): u**2*v/w**2, (410, 471):
        -u*v/w, (410, 501): -u/w, (410, 502): 1, (410, 569):
        u*v**3/w**2, (410, 578): u**3*v/w**2, (410, 584): -u*v/w,
        (410, 587): u*v**2/w, (410, 588): -u**2*v**2/w**2, (410, 590):
        u*v*(u**2 - v)/w**2, (410, 591): -v**2*(2*u**3 - u*v +
        w)/w**2, (410, 592): -u*v*(u*w - v**2)/w**2, (410, 595):
        u**2*v*(u**2 - v)/w**2, (410, 596): u**2*v**3/w**2, (410,
        607): -u**2*v**2/w**2, (410, 608): u*v**2/w, (410, 611):
        u*v**3/w**2, (410, 614): u*v*(u*v - w)/w, (410, 615):
        -u**2*v*(u*v - w)/w**2, (410, 616): u**2*v**2*(u*v - w)/w**2,
        (410, 618): -u**2*(u**2*v**2 - 2*u*v*w - w**2)/w**2, (410,
        619): u*v**2*(u*v - w)/w**2, (410, 620): -u*w, (410, 622):
        -u**3*v*(u**2 - v)/w**3, (410, 623): -u*v/w, (410, 633):
        u*v*(u*v - w)/w**2, (410, 634): u**2*v/w**2, (410, 635):
        -u*v/w, (410, 638): -u*v**2/w**2, (410, 645): -u**3*(u*v +
        w)/w**2, (410, 647): u**2, (411, 107): -u, (411, 130):
        -u**2*v/w**2, (411, 271): u**3/w**2, (411, 325): -u**4/w**3,
        (411, 373): u**2*v**2/w**2, (411, 376): u*v**2/w**2, (411,
        400): -u**2*v/w**2, (411, 403): -u*v/w**2, (411, 417): -u*v/w,
        (411, 423): -u*v/w**2, (411, 431): -u*v**2/w, (411, 446):
        -u/w, (411, 447): -u/w, (411, 448): 1, (411, 449): -u*v/w**2,
        (411, 454): -u**3*v/w**2, (411, 460): -2*u*v**2/w**3, (411,
        568): -2*u**2*v**2/w**3, (411, 569): u**2/w, (411, 588):
        -v**2/w**2, (411, 589): v**2*(u**2 - v)/w**2, (411, 591):
        -u*v**2/w**2, (411, 592): u*v**2/w**2, (411, 593): -u**2*v/w,
        (411, 595): u**4/w**2, (411, 606): -u*v/w, (411, 611):
        u*v**2/w**2, (411, 614): -u, (411, 615): u**2/w, (411, 616):
        u**2*v*(u*v - 2*w)/w**2, (411, 618): u**3/w, (411, 619):
        u*v*(u*v - w)/w**2, (411, 620): -u**2, (411, 622): -u**5/w**3,
        (411, 623): u*(u*v - w)/w**2, (411, 633): u**2*v/w**2, (411,
        638): -u*v/w**2, (411, 641): u**2/w, (411, 642): -u**3/w**2,
        (411, 643): u**3*v/w**2, (411, 645): -u**4/w**2, (411, 647):
        u**3/w, (412, 98): -u/w, (412, 106): -u**2/w, (412, 130):
        -u**2*v/w**2, (412, 269): -u*v*(u*v - w)/w, (412, 271):
        u**2*v*(u**2 - 2*v)/w**3, (412, 323): u*(u*v - w)/w, (412,
        325): -u**2*v*(u**3 - u*v - w)/w**4, (412, 353): u*v**2/w**2,
        (412, 371): u*v/w, (412, 376): u*v**2/w**2, (412, 380):
        -u*v/w**2, (412, 398): -u/w, (412, 403): -u*v/w**2, (412,
        415): u**2*v/w**2, (412, 419): -u*v/w, (412, 422):
        -u*v**2/w**2, (412, 427): u**2*v/w, (412, 430):
        -u**2*v**2/w**2, (412, 454): -u**2*(u*v + w)/w**2, (412, 460):
        u**3*v/w**3, (412, 470): u**2*(u*v + w)/w**3, (412, 471):
        -u/w, (412, 474): -u/w, (412, 475): 1, (412, 568):
        u**4*v/w**3, (412, 569): u*v**2/w**2, (412, 578): u**3*(u*v +
        w)/w**3, (412, 584): -u**2*v/w**2, (412, 587): u*v/w, (412,
        588): -u**3*v**2/w**3, (412, 589): -u**2*v**2*(u*v - w)/w**3,
        (412, 590): u**2*v*(u**2 - v)/w**3, (412, 591):
        -u*v**2*(2*u**3 - u*v + w)/w**3, (412, 592): -u*v*(u**2 -
        v)/w**2, (412, 595): u**3*v*(u**2 - 2*v)/w**3, (412, 596):
        u**2*v**2/w**2, (412, 607): -u**3*v**2/w**3, (412, 615):
        -u**3*v*(u*v - w)/w**3, (412, 616): -u**3*v**2*(u*v -
        2*w)/w**3, (412, 618): -u**3*(u**2*v**2 - 2*u*v*w -
        w**2)/w**3, (412, 620): -u**3*v/w, (412, 622): -u**3*v*(u**3 -
        u*v - w)/w**4, (412, 623): -u**2*v/w**2, (412, 634):
        u**3*v/w**3, (412, 643): -u**3*v/w**2, (412, 645): -u**4*(u*v
        + w)/w**3, (412, 647): u**3/w, (413, 107): -u**2/w, (413,
        130): -u**2/w**2, (413, 245): u*v**2/w**2, (413, 263): u*v/w,
        (413, 271): u**2*(u**2 - v)/w**3, (413, 299): -u*v/w**2, (413,
        317): -u/w, (413, 323): u**2*(u*v - w)/w**2, (413, 325):
        -u**3*(u**2 - v)/w**4, (413, 376): u*v/w**2, (413, 403):
        -u/w**2, (413, 415): u**2/w**2, (413, 417): -u/w, (413, 419):
        -u/w, (413, 420): -u/w, (413, 421): 1, (413, 422): -u*v/w**2,
        (413, 430): -u**2*v/w**2, (413, 454): -u**3/w**2, (413, 470):
        u**3/w**3, (413, 578): u**4/w**3, (413, 584): -u**2/w**2,
        (413, 588): -u**3*v/w**3, (413, 589): -u**2*v*(u*v - w)/w**3,
        (413, 590): u**2*(u**2 - v)/w**3, (413, 591): -u*v*(2*u**3 -
        u*v + w)/w**3, (413, 592): -u*(u**2 - v)/w**2, (413, 595):
        u**3*(u**2 - v)/w**3, (413, 596): u**2*v/w**2, (413, 607):
        -u**3*v/w**3, (413, 615): -u**3*(u*v - w)/w**3, (413, 616):
        -u**2*(u*v - w)**2/w**3, (413, 618): -u**4*(u*v - 2*w)/w**3,
        (413, 620): -u**3/w, (413, 622): -u**4*(u**2 - v)/w**4, (413,
        623): -u**2/w**2, (413, 634): u**3/w**3, (413, 645):
        -u**5/w**3, (413, 647): u**4/w**2, (414, 132): u*v/w, (414,
        372): -v**2/w, (414, 373): -v**3/w, (414, 375): -u*v**2/w,
        (414, 399): v/w, (414, 400): v**2/w, (414, 402): u*v/w, (414,
        414): v/w, (414, 445): v/w, (414, 458): u*v, (414, 494): 1,
        (414, 501): v/w, (414, 509): u*v/w**2, (414, 537): u*v/w,
        (414, 564): -u**2*v/w**2, (414, 568): -u*v*(u*v - w)/w**2,
        (414, 578): -u*v/w, (414, 591): u*v**2/w, (414, 595):
        -u**2*v/w, (414, 622): u*v*(u**2*w - u*v**2 + v*w)/w**3, (414,
        632): -v*(u*v - w)/w**2, (415, 103): -u, (415, 271): -v*(u**2
        - v)/w**2, (415, 325): u*v*(u**2 - v)/w**3, (415, 353): v*(u*w
        - v**2)/w**2, (415, 371): -v**2/w, (415, 373): -u*v**3/w**2,
        (415, 380): (-u*w + v**2)/w**2, (415, 398): v/w, (415, 400):
        u*v**2/w**2, (415, 427): -u*v**2/w, (415, 449): -u/w, (415,
        470): -u*v/w**2, (415, 501): 1/w, (415, 578): -u**2*v/w**2,
        (415, 579): -u*v/w, (415, 588): u*v**2/w**2, (415, 589):
        -u*v*(u*w - v**2)/w**2, (415, 590): -v*(u**2 - v)/w**2, (415,
        591): v**2*(2*u**2 - v)/w**2, (415, 595): -u*v*(u**2 -
        v)/w**2, (415, 607): u*v**2/w**2, (415, 615): u*v*(u*v -
        w)/w**2, (415, 616): u*v**2*(u*v - w)/w**2, (415, 618):
        u**2*v*(u*v - 2*w)/w**2, (415, 622): u**2*v*(u**2 - v)/w**3,
        (415, 633): -v*(u*v - w)/w**2, (415, 634): -u*v/w**2, (415,
        645): u**3*v/w**2, (416, 134): u*v/w, (416, 136): -u**2/w,
        (416, 190): u**3/w**2, (416, 271): -2*u**2*v/w**2, (416, 325):
        2*u**3*v/w**3, (416, 377): -u*v**2/w, (416, 404): u*v/w, (416,
        416): v/w, (416, 440): 1, (416, 447): v/w, (416, 449): u/w,
        (416, 458): u**2*v/w, (416, 460): u*v/w**2, (416, 537): u/w,
        (416, 564): -u**2/w**2, (416, 568): u**2*(u**2*w + u*v**2 +
        v*w)/w**3, (416, 569): -u*v/w, (416, 588): v/w, (416, 591):
        u*v*(u*v + w)/w**2, (416, 595): -2*u**3*v/w**2, (416, 600):
        -u*v/w, (416, 606): -u**2*v/w, (416, 612): -u**2*v/w**2, (416,
        613): -u, (416, 615): -u*v/w, (416, 618): -u**2*v/w, (416,
        622): u**2*(3*u**2*v*w + u*v**3 - u*w**2 - v**2*w)/w**4, (416,
        627): u**2*v/w**2, (416, 633): u**3*v/w**2, (416, 639):
        u**3*v/w**3, (416, 640): u**2/w, (416, 642): u**2*v/w**2,
        (416, 645): u*v*(u**2*w + u*v**2 - v*w)/w**3, (417, 271):
        -u**2/w**2, (417, 325): u**3/w**3, (417, 373): -u*v**2/w**2,
        (417, 400): u*v/w**2, (417, 417): v/w, (417, 447): 1/w, (417,
        569): (-u*w + v**2)/w**2, (417, 587): v/w, (417, 593): u*v/w,
        (417, 595): -u**3/w**2, (417, 615): -u/w, (417, 618): -u**2/w,
        (417, 622): u**4/w**3, (417, 642): u**2/w**2, (417, 645):
        u**3/w**2, (418, 132): u/w, (418, 164): u*v**2/w**2, (418,
        218): -u*v/w**2, (418, 353): u*v*(2*u*v - w)/w**2, (418, 370):
        u*v/w, (418, 371): u**2*v/w, (418, 373): u*v**2*(u**2 -
        v)/w**2, (418, 377): u**2*(u*v - w)/w, (418, 380): -u*(2*u*v -
        w)/w**2, (418, 397): -u/w, (418, 398): -u**2/w, (418, 400):
        -u*v*(u**2 - v)/w**2, (418, 418): v/w, (418, 427): -u**2,
        (418, 457): -u**2/w, (418, 458): u**2*v/w, (418, 465): -u/w,
        (418, 467): 1, (418, 470): -u*v/w**2, (418, 474): v/w, (418,
        477): -u**2/w**2, (418, 578): -u**2*v/w**2, (418, 579):
        u**3/w, (418, 586): u*v/w, (418, 588): u*v**2/w**2, (418,
        590): -u**2*v/w**2, (418, 591): 2*u**2*v**2/w**2, (418, 595):
        u**2*(u*v - w)/w**2, (418, 607): u*v**2/w**2, (418, 615):
        u**2*v**2/w**2, (418, 616): -u**2*v*(u*w - v**2)/w**2, (418,
        618): u**2*v*(u*v - w)/w**2, (418, 622): -u**3*(u*v - w)/w**3,
        (418, 634): -u*v/w**2, (418, 642): -u**2*v/w**2, (418, 643):
        u**2*(u*w - v**2)/w**2, (419, 103): -u**2/w, (419, 422): -u/w,
        (419, 427): -u**2*(u*w + v**2)/w**2, (419, 430): -u**2/w,
        (419, 431): u**2*v/w, (419, 470): -u/w**2, (419, 474): 1/w,
        (419, 578): -u**2/w**2, (419, 588): u*v/w**2, (419, 589):
        -u*v*(u**2 - v)/w**2, (419, 590): -u**3*v/w**3, (419, 591):
        u**2*v*(u*v + w)/w**3, (419, 607): u**2*v**2/w**3, (419, 611):
        -u**2*v/w**2, (419, 615): u**3*v**2/w**3, (419, 616):
        -u**3*v*(u*w - v**2)/w**3, (419, 618): u**2*(u**2*v**2 - u*v*w
        - w**2)/w**3, (419, 619): -u**3*v/w**2, (419, 620): u**2*v/w,
        (419, 634): -u**2*v/w**3, (419, 638): u**2/w**2, (419, 642):
        -u**3*v/w**3, (419, 643): u**3*(u*w - v**2)/w**3, (419, 645):
        u**3/w**2, (419, 646): u**3/w**2, (419, 647): -u**2/w, (420,
        134): u/w, (420, 245): -u*v/w, (420, 269): u**2, (420, 299):
        u/w, (420, 323): -u**3/w, (420, 411): -u/w, (420, 413): 1,
        (420, 417): -u**2/w, (420, 420): v/w, (420, 422): u/w, (420,
        423): -u**2/w**2, (420, 430): u**2/w, (420, 431): -u**2*v/w,
        (420, 458): u**2/w, (420, 460): -u**2*v/w**3, (420, 568):
        -u**3*v/w**3, (420, 589): u*v*(2*u**2 - v)/w**2, (420, 591):
        u/w, (420, 592): u**2*v/w**2, (420, 611): u**2*v/w**2, (420,
        616): u**3*(u*v - 2*w)/w**2, (420, 619): u**2*(u*v - w)/w**2,
        (420, 638): -u**2/w**2, (420, 643): u**4/w**2, (421, 107):
        u/w, (421, 420): 1/w, (421, 427): -u**2*v/w**2, (421, 431):
        u**2/w, (421, 590): -u**3/w**3, (421, 591): u**3*v/w**3, (421,
        607): u**2*v/w**3, (421, 615): u**3*v/w**3, (421, 616):
        u**3*v**2/w**3, (421, 618): u**3*(u*v - w)/w**3, (421, 620):
        u**2/w, (421, 634): -u**2/w**3, (421, 642): -u**3/w**3, (421,
        643): -u**3*v/w**3, (421, 647): -u**3/w**2, (422, 130): u/w,
        (422, 271): -u*(u**2 - v)/w**2, (422, 325): u**2*(u**2 -
        v)/w**3, (422, 373): u**2*(u**2*v - u*w - v**2)/w**2, (422,
        400): u**2*v/w**2, (422, 415): -u/w, (422, 419): 1, (422,
        422): v/w, (422, 431): -u**2, (422, 454): u**3*v/w**2, (422,
        470): -u**2/w**2, (422, 578): -u**3/w**2, (422, 588):
        u**2*v/w**2, (422, 589): 2*u**2*v**2/w**2, (422, 590):
        u*v/w**2, (422, 591): u*v*(u**2 - v)/w**2, (422, 595):
        -u**2*(u**2 - v)/w**2, (422, 596): u*v*(u*v - w)/w**2, (422,
        608): u*v/w, (422, 611): u*v**2/w**2, (422, 614): u**2*v/w,
        (422, 615): -u**2/w, (422, 616): 2*u**2*v*(u*v - w)/w**2,
        (422, 618): -u**3/w, (422, 619): u**2*v**2/w**2, (422, 622):
        u**3*(u**2 - v)/w**3, (422, 623): -u*(u*v - w)/w**2, (422,
        635): -u/w, (422, 638): -u*v/w**2, (422, 641): -u**2/w, (422,
        642): u**3/w**2, (422, 645): u**4/w**2, (422, 646):
        -u**2*v/w**2, (423, 130): u*v/w, (423, 373): -u*v**2/w, (423,
        376): -v**2/w, (423, 400): u*v/w, (423, 403): v/w, (423, 423):
        v/w, (423, 446): 1, (423, 449): v/w, (423, 454): u**2*v/w,
        (423, 589): u*v**2/w, (424, 83): -u/w, (424, 265): -u**2*v/w,
        (424, 268): -u*v/w, (424, 269): u*v**2/w, (424, 271):
        u*v**2/w**3, (424, 319): u**3*v/w**2, (424, 322): u**2*v/w**2,
        (424, 323): -u*v/w, (424, 325): -u*v/w**3, (424, 373):
        u**2*(u*v - w)/w**2, (424, 407): -u*v**2/w**2, (424, 425):
        -u*v/w, (424, 454): u**2*v/w**2, (424, 569): -u**2*v/w**2,
        (424, 579): -u/w, (424, 580): u**2/w**2, (424, 581): -u/w,
        (424, 582): -u/w, (424, 583): 1, (424, 587): -u**2/w, (424,
        588): u**3/w**2, (424, 595): u**2*v**2/w**3, (424, 596):
        -u**2/w, (424, 611): -u/w, (424, 617): u**3/w**2, (424, 618):
        -u**3*v/w**2, (424, 619): -u**2/w, (424, 620): u**2*v/w, (424,
        622): -u**2*v/w**3, (424, 623): u**3/w**2, (424, 638):
        u**2/w**2, (424, 644): -u**4/w**3, (424, 645): u**3/w**2,
        (424, 646): u**3/w**2, (424, 647): -u**2/w, (425, 265):
        -u*v/w, (425, 319): u**2*v/w**2, (425, 407): -u/w, (425, 431):
        -u*v/w, (425, 580): -u/w**2, (425, 582): 1/w, (425, 588):
        -u**2/w**2, (425, 611): u*v/w**2, (425, 616): u**2*(u*v -
        w)/w**2, (425, 617): -u**2/w**2, (425, 618): u**2*v/w**2,
        (425, 619): u**2*v/w**2, (425, 620): -u*v/w, (425, 638):
        -u/w**2, (425, 644): u**3/w**3, (425, 645): -u**2/w**2, (425,
        646): -u**2/w**2, (425, 647): u/w, (426, 376): u**2*(u*v -
        w)/w**2, (426, 377): -u*(u*v - w)/w, (426, 426): v/w, (426,
        455): -u**2/w**2, (426, 456): u/w, (426, 457): u**2*v/w**2,
        (426, 458): -u*v/w, (426, 573): -u/w, (426, 574): -u/w, (426,
        575): 1, (426, 579): -u**2/w, (426, 580): -u*v/w**2, (426,
        582): v/w, (426, 585): -u**2/w**2, (426, 586): -u**2/w, (426,
        588): -u**2*v/w**2, (426, 595): -u**2*v/w**2, (426, 596):
        u**2*v**2/w**2, (426, 611): u*v**2/w**2, (426, 616): u**2*v/w,
        (426, 617): -u**2*v/w**2, (426, 618): u*v*(u*v - w)/w**2,
        (426, 619): u**2*v**2/w**2, (426, 622): u**3*v/w**3, (426,
        623): -u**2*v/w**2, (426, 638): -u*v/w**2, (426, 643):
        -u**2/w, (426, 644): u**3*v/w**3, (426, 646): -u**2*v/w**2,
        (427, 427): v/w, (427, 590): u/w**2, (427, 591): -u*v/w**2,
        (427, 607): -v/w**2, (427, 615): -u*v/w**2, (427, 616):
        -u*v**2/w**2, (427, 618): -u*(u*v - w)/w**2, (427, 634):
        w**(-2), (427, 642): u/w**2, (427, 643): u*v/w**2, (428, 164):
        -u*v**2/w**2, (428, 218): u*v/w**2, (428, 353): -u*v*(2*u*v -
        w)/w**2, (428, 370): -u*v/w, (428, 371): -u*(u*v - w)/w, (428,
        373): -u*v*(u**2*v - u*w - v**2)/w**2, (428, 376): -u*v*(u*v -
        w)/w**2, (428, 380): u**2*v/w**2, (428, 397): u/w, (428, 400):
        -u*v**2/w**2, (428, 428): v/w, (428, 434): -u*v**2/w**2, (428,
        452): -u*v/w, (428, 453): u/w, (428, 454): -u*v*(u*v -
        w)/w**2, (428, 455): u*v/w**2, (428, 457): -u*v**2/w**2, (428,
        570): 1, (428, 574): v/w, (428, 586): u*v/w, (428, 589):
        -u*v**3/w**2, (428, 590): -u**2*v/w**2, (428, 591): u*v/w,
        (428, 595): u**2/w, (428, 596): -2*u*v**3/w**2, (428, 607):
        v/w, (428, 608): -v**2/w, (428, 611): -v**3/w**2, (428, 614):
        -u*v**2/w, (428, 615): u*v/w, (428, 616): -u*v**2*(u*v -
        w)/w**2, (428, 619): -u*v**3/w**2, (428, 622): -u**3/w**2,
        (428, 623): 2*u*v**2/w**2, (428, 634): -u*v/w**2, (428, 635):
        v/w, (428, 638): v**2/w**2, (428, 641): u*v/w, (428, 642):
        -u**2*v/w**2, (428, 644): -u*v*(u*v - w)/w**3, (428, 646):
        u*v**2/w**2, (429, 376): -u*(u*v - w)/w**2, (429, 429): v/w,
        (429, 455): u/w**2, (429, 457): -u*v/w**2, (429, 574): 1/w,
        (429, 580): v/w**2, (429, 586): u/w, (429, 588): u*v/w**2,
        (429, 596): -u*v**2/w**2, (429, 611): -v**2/w**2, (429, 617):
        u*v/w**2, (429, 618): -u*v**2/w**2, (429, 619): -u*v**2/w**2,
        (429, 623): u*v/w**2, (429, 638): v/w**2, (429, 644):
        -u**2*v/w**3, (429, 645): u*v/w**2, (429, 646): u*v/w**2,
        (430, 373): -u*(u**2*v - u*w - v**2)/w**2, (430, 400):
        -u*v/w**2, (430, 430): v/w, (430, 454): -u*(u*v - w)/w**2,
        (430, 589): -u*v**2/w**2, (430, 590): -u**2/w**2, (430, 591):
        u**2*v/w**2, (430, 596): -u*v**2/w**2, (430, 607): u*v/w**2,
        (430, 608): -v/w, (430, 611): -v**2/w**2, (430, 614): -u*v/w,
        (430, 615): u**2*v/w**2, (430, 616): -u*v*(u*v - w)/w**2,
        (430, 618): u**2*(u*v - w)/w**2, (430, 619): -u*v**2/w**2,
        (430, 623): u*v/w**2, (430, 634): -u/w**2, (430, 635): 1/w,
        (430, 638): v/w**2, (430, 641): u/w, (430, 642): -u**2/w**2,
        (430, 646): u*v/w**2, (431, 431): v/w, (431, 589): -u*v/w**2,
        (431, 611): -v/w**2, (431, 616): -u*(u*v - w)/w**2, (431,
        619): -u*v/w**2, (431, 638): w**(-2), (431, 646): u/w**2,
        (432, 10): -u/w, (432, 14): 1, (432, 17): v/w, (432, 18):
        -u*v/w**2, (432, 158): u*v/w, (432, 185): -u/w, (432, 212):
        -u**2*v/w**2, (432, 239): u**2/w**2, (432, 406): u*v/w, (432,
        433): -u**2*v/w**2, (432, 460): -u**2*v/w**2, (432, 487):
        u**2/w**2, (432, 595): u**2*v**2/w**2, (432, 622):
        -u**2*v/w**2, (433, 433): v/w, (433, 585): v/w, (433, 589):
        u*v, (433, 590): -u*v/w, (433, 592): v, (433, 599): 1, (433,
        604): u, (433, 612): u*v/w, (433, 626): -u/w, (433, 631):
        -u**2/w, (433, 639): -u**2*v/w**2, (433, 644): -v*(u*v -
        w)/w**2, (434, 265): w, (434, 319): -u, (435, 2): v/w, (435,
        20): 1, (435, 91): -u/w, (435, 265): u**2*v**2/w, (435, 268):
        u*v**2/w, (435, 292): -u**2*v/w, (435, 293): u**2*v/w**2,
        (435, 295): -u*v/w, (435, 319): -u**3*v**2/w**2, (435, 322):
        -u**2*v**2/w**2, (435, 346): u**3*v/w**2, (435, 347):
        -u**3*v/w**3, (435, 349): u**2*v/w**2, (435, 423):
        u**2*v/w**2, (435, 427): u*v**2/w, (435, 433): u*v/w**2, (435,
        460): u*v/w**2, (435, 481): -u*v/w, (435, 487): -u/w**2, (435,
        595): -u*v**2/w**2, (435, 612): u**2*v/w**2, (435, 617):
        u**3*v/w**2, (435, 622): u*v/w**2, (435, 639): -u**3*v/w**3,
        (435, 644): -u**4*v/w**3, (436, 93): -v, (436, 118): -u/w,
        (436, 120): 1, (436, 265): u*v**2, (436, 268): v**2, (436,
        292): -u*v, (436, 293): u*v/w, (436, 295): -v, (436, 319):
        -u**2*v**2/w, (436, 322): -u*v**2/w, (436, 346): u**2*v/w,
        (436, 347): -u**2*v/w**2, (436, 349): u*v/w, (436, 423):
        u*v/w, (436, 433): u*v**2/w**2, (436, 450): u*(u*v - w)/w**2,
        (436, 454): u*v**2/w, (436, 460): u*v**2/w**2, (436, 487):
        -u*v/w**2, (436, 508): -u*v/w, (436, 595): -u*v**3/w**2, (436,
        612): u*v/w, (436, 616): -u*v**3/w, (436, 617): u**2*v/w,
        (436, 622): u*v**2/w**2, (436, 639): -u**2*v/w**2, (436, 643):
        u*v**2/w, (436, 644): -u**3*v/w**2, (437, 126): -u/w, (437,
        130): -u*v**2/w, (437, 271): -v**2/w, (437, 325): u*v**2/w**2,
        (437, 433): -u*v/w, (437, 442): -u*v/w, (437, 450):
        -u*v**2/w**2, (437, 454): -u*v*(u*v + w)/w, (437, 460):
        u**2*v**2/w**2, (437, 470): u*v/w, (437, 471): -v, (437, 497):
        -u/w, (437, 498): 1, (437, 568): u**2*v*(u*v + w)/w**2, (437,
        578): u**2*v/w, (437, 589): -u*v**3/w, (437, 618): u**2*v,
        (437, 622): u*v*(u*v - w)/w**2, (437, 633): v*(u*v - w)/w,
        (437, 645): -u**3*v/w, (438, 130): -u*v/w, (438, 406): -u*v/w,
        (438, 417): -v, (438, 433): -u**2*v/w**2, (438, 442): -u/w,
        (438, 443): -u/w, (438, 444): 1, (438, 450): -u*v/w**2, (438,
        454): -u**2*v/w, (438, 460): v*(u**2 - v)/w**2, (438, 568):
        u*v*(u**2 - v)/w**2, (438, 589): -u*v**2/w, (438, 595):
        u**2*v**2/w**2, (438, 605): u*v/w, (438, 606): -v, (438, 616):
        -u*v, (438, 622): -u**3*v**2/w**3, (438, 632): -u**2*v/w**2,
        (438, 633): u*v/w, (438, 643): u**2*v/w, (439, 25): 1, (439,
        99): -u/w, (439, 130): -u*v/w, (439, 271): -u*v**2/w**2, (439,
        325): u*v/w**2, (439, 454): -u**2*v/w, (439, 460):
        u**3*v**2/w**3, (439, 470): u**2*v/w**2, (439, 568):
        u**2*(u**2*v**2 - u*v*w + w**2)/w**3, (439, 578): u**3*v/w**2,
        (439, 595): -u**2*v**2/w**2, (439, 618): u**3*v/w, (439, 622):
        -u*(u**2*v**2 - 3*u*v*w + w**2)/w**3, (439, 645):
        -u**4*v/w**2, (440, 26): 1, (440, 130): -u/w, (440, 136):
        -u/w, (440, 190): u**2/w**2, (440, 269): -u*v, (440, 271):
        -u*v/w**2, (440, 294): -u**2/w, (440, 296): u, (440, 323):
        u**2*v/w, (440, 325): u**2*v/w**3, (440, 348): u**3/w**2,
        (440, 350): -u**2/w, (440, 406): -u**2*v/w**2, (440, 416):
        -u/w, (440, 454): -u**2/w, (440, 460): u**3*v/w**3, (440,
        470): u**2/w**2, (440, 568): u**3*(u*v + w)/w**3, (440, 578):
        u**3/w**2, (440, 595): -u**2*v/w**2, (440, 622): u**2*(2*u*v -
        w)/w**3, (441, 132): v, (441, 441): v/w, (441, 458): v*w,
        (441, 487): u*v**2/w**2, (441, 492): 1, (441, 497): v/w, (441,
        510): v**2/w, (441, 568): -v*(u*v - w)/w, (441, 591): v**2,
        (441, 595): -u*v, (441, 622): v*(u**2*w - u*v**2 + v*w)/w**2,
        (442, 450): -u/w, (442, 460): -u*v**2/w**2, (442, 470): -v/w,
        (442, 497): 1/w, (442, 568): -u*v*(u*v + w)/w**2, (442, 578):
        -u*v/w, (442, 589): v**3/w, (442, 604): v**2/w, (442, 612):
        v**3/w**2, (442, 618): -u*v, (442, 622): -v*(u*v - w)/w**2,
        (442, 631): -u*v**2/w**2, (442, 639): -u*v**3/w**3, (442,
        645): u**2*v/w, (443, 82): -u*v/w, (443, 134): v, (443, 438):
        1, (443, 443): v/w, (443, 450): u/w, (443, 458): u*v, (443,
        460): -v*(u*v - w)/w**2, (443, 487): u*v/w**2, (443, 510):
        v/w, (443, 568): u*v/w, (443, 585): -u*v**2/w**2, (443, 589):
        -u**2*v**2/w, (443, 590): u**2*v**2/w**2, (443, 591):
        u*v**2/w, (443, 592): -u*v**2/w, (443, 595): -u*v*(u*w +
        v**2)/w**2, (443, 599): -u*v/w, (443, 600): -v, (443, 604):
        -u**2*v/w, (443, 605): -v**2/w, (443, 612): -u*v*(u*v +
        w)/w**2, (443, 622): u*v*(u**2*w + 2*u*v**2 - v*w)/w**3, (443,
        626): u**2*v/w**2, (443, 627): u*v/w, (443, 631): u**3*v/w**2,
        (443, 632): u*v**2/w**2, (443, 639): u**2*v*(u*v + w)/w**3,
        (443, 644): u*v**2*(u*v - w)/w**3, (443, 645): v**2*(u*v -
        w)/w**2, (444, 406): v/w, (444, 433): u*v/w**2, (444, 443):
        1/w, (444, 460): -u*v/w**2, (444, 568): -u**2*v/w**2, (444,
        595): -u*v**2/w**2, (444, 605): -v/w, (444, 622):
        u**2*v**2/w**3, (444, 632): u*v/w**2, (445, 132): 1, (445,
        477): -u/w, (445, 595): u*(u*v - w)/w, (445, 622): -u**2*(u*v
        - w)/w**2, (446, 22): 1, (446, 423): -u/w, (446, 618):
        -u**2*v/w, (446, 645): u**3*v/w**2, (447, 134): 1, (447, 269):
        u*w, (447, 323): -u**2, (447, 417): -u, (447, 458): u, (447,
        616): -u**2, (447, 643): u**3/w, (448, 107): 1, (448, 431): u,
        (448, 618): -u**2/w, (448, 620): u, (448, 645): u**3/w**2,
        (448, 647): -u**2/w, (449, 130): 1, (449, 460): -u**2*v/w**2,
        (449, 470): -u/w, (449, 568): -u**3*v/w**2, (449, 578):
        -u**2/w, (450, 130): v, (450, 442): 1, (450, 450): v/w, (450,
        454): u*v, (450, 604): -v, (450, 612): -v**2/w, (450, 631):
        u*v/w, (450, 639): u*v**2/w**2, (451, 265): -u*v, (451, 268):
        -v, (451, 293): -u/w, (451, 295): 1, (451, 319): u**2*v/w,
        (451, 322): u*v/w, (451, 347): u**2/w**2, (451, 349): -u/w,
        (451, 568): u**2*v/w**2, (451, 612): -u/w, (451, 622):
        u*v*(u*v - w)/w**3, (451, 639): u**2/w**2, (452, 265): -v,
        (452, 292): 1, (452, 319): u*v/w, (452, 346): -u/w, (452,
        617): -u/w, (452, 644): u**2/w**2, (453, 455): -u/w, (453,
        456): 1, (453, 585): -u/w, (453, 595): -u*v/w, (453, 618): -v,
        (453, 622): u**2*v/w**2, (453, 645): u*v/w, (454, 618): 1,
        (454, 645): -u/w, (455, 453): 1, (455, 454): v, (455, 455):
        v/w, (455, 595): u, (455, 622): -u**2/w, (456, 455): 1/w,
        (457, 454): 1, (457, 618): -u, (457, 645): u**2/w, (458, 616):
        1, (458, 643): -u/w, (459, 11): -u/w, (459, 15): 1, (459, 44):
        u*v/w, (459, 45): -u**2*v/w**2, (459, 71): -u/w, (459, 72):
        u**2/w**2, (459, 102): u*v/w, (459, 129): -u/w, (459, 157):
        u*v, (459, 184): -u, (459, 211): -u**2*v/w, (459, 238):
        u**2/w, (459, 407): -u*v**2/w, (459, 434): u*v/w, (459, 460):
        -u**2*v*(u*v - w)/w**3, (459, 461): u*v/w, (459, 488): -u/w,
        (459, 568): -u**3*v*(u*v - w)/w**3, (459, 596): -u*v**2/w,
        (459, 623): u*v/w, (460, 460): v/w, (460, 606): w, (460, 612):
        u*v/w, (460, 633): -u, (460, 639): -u/w, (461, 244): -u*v/w,
        (461, 298): u/w, (461, 426): 1, (461, 429): u, (462, 29):
        u*v/w, (462, 56): -u/w, (462, 92): -u/w, (462, 94): -u/w,
        (462, 96): 1, (462, 102): -u**2/w, (462, 265): u*v*(u*v +
        w)/w, (462, 292): -u**2*v/w, (462, 319): -u*(u**2*v**2 +
        w**2)/w**2, (462, 346): u**2/w, (462, 373): -u**2*v/w, (462,
        400): u**2/w, (462, 407): u**2*v/w, (462, 422): u*v/w, (462,
        460): u**2*v**2/w**3, (462, 461): -u**2/w, (462, 476): -u/w,
        (462, 477): u**2/w**2, (462, 568): u**3*v**2/w**3, (462, 589):
        -u**2*v/w, (462, 617): u**3*v/w**2, (462, 643): -u**3*(u*v -
        w)/w**2, (462, 644): -u**4*v/w**3, (463, 92): -u*v/w, (463,
        102): -u, (463, 121): -u/w, (463, 123): 1, (463, 265): u*v**2,
        (463, 319): -u**2*v**2/w, (463, 407): u*v, (463, 449): u*v/w,
        (463, 460): u**2*v**3/w**3, (463, 461): -u, (463, 477):
        u**2*v/w**2, (463, 503): -u/w, (463, 535): -u**2*v/w, (463,
        562): u**2/w, (463, 568): u**3*v**3/w**3, (463, 611):
        -u*v**2/w, (463, 616): u*(u*v - w), (463, 617): u**2*v/w,
        (463, 638): u*v/w, (463, 643): -u**2*(u*v - w)/w, (463, 644):
        -u**3*v/w**2, (464, 104): -u, (464, 130): -u*v**2/w, (464,
        271): u**3*v**2/w**2, (464, 325): -u**3*v/w**2, (464, 352):
        -u**2*v/w, (464, 379): u**2/w, (464, 423): -v**2/w, (464,
        427): -u*v**2, (464, 430): -v**2, (464, 446): -v, (464, 449):
        -v**2/w, (464, 454): -u**2*v**2/w, (464, 469): -u*v/w, (464,
        477): -u*v**2/w**2, (464, 482): -u*v/w, (464, 484): v, (464,
        499): -u/w, (464, 500): 1, (464, 503): v/w, (464, 568):
        -u**2*v/w, (464, 585): -u*v/w, (464, 591): -u**2*v**2/w, (464,
        595): u**4*v**2/w**2, (464, 607): -u*v**2/w, (464, 608): v**2,
        (464, 611): v**3/w, (464, 616): -u*v**2, (464, 618): u**2*v,
        (464, 622): -u**4*v/w**2, (464, 634): u*v/w, (464, 635): -v,
        (464, 638): -v**2/w, (464, 643): u**2*v**2/w, (464, 645):
        -u**3*v/w, (465, 82): -u*v**2/w**2, (465, 105): -u, (465,
        244): -u**2*v/w, (465, 271): u**3*v/w**2, (465, 298): u**2/w,
        (465, 325): -u**3/w**2, (465, 373): u*v**2/w, (465, 400):
        -u*v/w, (465, 431): -v**2, (465, 445): -u/w, (465, 449): -v/w,
        (465, 460): -2*u*v**3/w**3, (465, 470): -v**2/w**2, (465,
        477): -u*v/w**2, (465, 483): -u*v/w, (465, 485): v, (465,
        503): 1/w, (465, 568): -2*u**2*v**3/w**3, (465, 578):
        -u*v**2/w**2, (465, 589): u*v**2/w, (465, 591): -u**2*v/w,
        (465, 595): u**2*v*(u**2 - v)/w**2, (465, 605): -u*v/w, (465,
        611): v**2/w, (465, 616): -u*v, (465, 622): -u**3*(u*w -
        v**2)/w**3, (465, 632): u**2*v/w**2, (465, 638): -v/w, (465,
        643): u**2*v/w, (466, 104): -u**2/w, (466, 130): -u*v/w, (466,
        271): u*v**2*(u**3 - w)/w**3, (466, 325): -u**2*v*(u**2 -
        v)/w**3, (466, 352): -u**3*v/w**2, (466, 379): u**3/w**2,
        (466, 415): u*v/w, (466, 419): -v, (466, 422): -v**2/w, (466,
        430): -u*v**2/w, (466, 454): -u**2*v/w, (466, 460):
        u**3*v**2/w**3, (466, 469): -u/w, (466, 470): u**2*v/w**2,
        (466, 472): -u/w, (466, 473): 1, (466, 476): v/w, (466, 477):
        -u*v/w**2, (466, 482): -u**2*v/w**2, (466, 484): u*v/w, (466,
        568): u**3*v*(u*v - w)/w**3, (466, 578): u**3*v/w**2, (466,
        585): -u**2*v/w**2, (466, 591): -u**3*v**2/w**2, (466, 595):
        u*v*(u**4*v - 2*u*v*w + w**2)/w**3, (466, 607):
        -u**2*v**2/w**2, (466, 618): u**3*v/w, (466, 622):
        -u**2*v*(u**3 - 2*u*v + w)/w**3, (466, 634): u**2*v/w**2,
        (466, 645): -u**4*v/w**2, (467, 103): -u*v/w, (467, 105):
        -u**2/w, (467, 244): -u**3*v/w**2, (467, 271): u**4*v/w**3,
        (467, 298): u**3/w**2, (467, 325): -u**4/w**3, (467, 418):
        -u/w, (467, 422): -v/w, (467, 427): -u**2*v/w, (467, 430):
        -u*v/w, (467, 476): 1/w, (467, 477): -u/w**2, (467, 482):
        -u**2/w**2, (467, 484): u/w, (467, 585): -u**2/w**2, (467,
        591): -u**3*v/w**2, (467, 595): u**5*v/w**3, (467, 607):
        -u**2*v/w**2, (467, 616): -u**2*v/w, (467, 622): -u**5/w**3,
        (467, 634): u**2/w**2, (467, 643): u**3*v/w**2, (468, 131):
        u*v/w, (468, 375): -v**2, (468, 402): v, (468, 449): v, (468,
        457): u*v, (468, 468): v/w, (468, 493): 1, (468, 499): v/w,
        (468, 509): u*v**2/w**2, (468, 514): u**2*v**2/w**2, (468,
        537): u*v**2/w, (468, 541): -u**2*v/w**2, (468, 564): -u*v/w,
        (468, 590): u*v**2/w, (468, 612): v, (468, 639): -u*v/w, (469,
        271): -u**2*v**2/w**2, (469, 325): u**2*v/w**2, (469, 445):
        -v/w, (469, 469): v/w, (469, 481): v, (469, 499): 1/w, (469,
        585): -v*(u*v - w)/w**2, (469, 590): -u*v/w, (469, 591):
        u*v**2/w, (469, 595): -u**3*v**2/w**2, (469, 607): v**2/w,
        (469, 616): u*v**3/w, (469, 618): -u*v, (469, 622):
        u**3*v/w**2, (469, 634): -v/w, (469, 643): -u*v**2/w, (469,
        645): u**2*v/w, (470, 136): -u**2*v/w, (470, 190): u**2/w,
        (470, 271): -u**2*v**2/w**2, (470, 325): u**2*v/w**2, (470,
        377): -v**2, (470, 404): v, (470, 449): 1, (470, 470): v/w,
        (470, 537): u*v/w, (470, 564): -u/w, (470, 568): u**2*(u*w +
        v**2)/w**2, (470, 578): u*v/w, (470, 595): -u**3*v**2/w**2,
        (470, 606): -u*v, (470, 612): -u**2*v**2/w**2, (470, 622):
        u**3*v/w**2, (470, 633): u**2*v/w, (470, 639): u**2*v/w**2,
        (471, 125): 1/w, (471, 271): -u**2*v/w**2, (471, 325):
        u**2/w**2, (471, 449): u/w, (471, 471): v/w, (471, 579):
        u*v/w, (471, 584): v/w, (471, 593): v, (471, 595):
        -u**3*v/w**2, (471, 618): -u, (471, 622): u**3/w**2, (471,
        645): u**2/w, (472, 131): u/w, (472, 422): v, (472, 423):
        -u*v/w, (472, 427): -u**2*v, (472, 464): -u/w, (472, 466): 1,
        (472, 469): -u**2/w, (472, 472): v/w, (472, 477):
        -u**2*v/w**2, (472, 514): u**2*v/w**2, (472, 541): -u**2/w**2,
        (472, 591): u*v**2/w, (472, 595): u**2*v/w, (472, 611):
        u*v**2/w, (472, 616): -u**3*v**2/w, (472, 622): -u**3*v/w**2,
        (472, 638): -u*v/w, (472, 643): u**3*v/w, (473, 104): u/w,
        (473, 105): -u*v/w, (473, 244): -u**2*v**2/w**2, (473, 298):
        u**2*v/w**2, (473, 352): u**2*v/w**2, (473, 379): -u**2/w**2,
        (473, 418): -v/w, (473, 427): -u*v**2/w, (473, 472): 1/w,
        (473, 481): u*v/w, (473, 568): u**2*v/w**2, (473, 590):
        -u**2*v/w**2, (473, 591): u**2*v**2/w**2, (473, 618):
        -u**2*v/w, (473, 645): u**3*v/w**2, (474, 103): u, (474, 422):
        1, (474, 427): u**2, (474, 430): u, (474, 431): -u*v, (474,
        589): u**2*v/w, (474, 611): u*v/w, (474, 638): -u/w, (475,
        98): 1/w, (475, 103): u**2/w, (475, 106): u/w, (475, 422):
        u/w, (475, 427): u*(u**2 - v)/w, (475, 430): u**2/w, (475,
        481): u/w, (475, 589): u**2/w, (475, 590): -u**2/w**2, (475,
        591): u**2*v/w**2, (475, 611): u/w, (475, 616): u**3/w, (475,
        619): u**2/w, (475, 638): -u**2/w**2, (475, 643): -u**4/w**2,
        (475, 646): -u**3/w**2, (476, 105): u, (476, 244): u**2*v/w,
        (476, 271): -u**3*v/w**2, (476, 298): -u**2/w, (476, 325):
        u**3/w**2, (476, 373): -u*v**2/w, (476, 400): u*v/w, (476,
        418): 1, (476, 595): -u**4*v/w**2, (476, 607): u*v/w, (476,
        622): u**4/w**2, (476, 634): -u/w, (477, 373): -v**2, (477,
        400): v, (477, 445): 1, (477, 477): v/w, (477, 585): u*v/w,
        (478, 265): -u*v, (478, 319): u**2*v/w, (478, 352):
        u**2*v/w**2, (478, 379): -u**2/w**2, (478, 407): -v**2/w,
        (478, 425): -v, (478, 461): v/w, (478, 479): 1, (478, 480):
        -u/w, (478, 568): u**2*v/w**2, (478, 577): -u/w, (478, 595):
        u*v**2/w**2, (478, 616): u*v**2/w, (478, 622):
        -u**2*v**2/w**3, (478, 643): -u*v/w, (479, 244): u*v**2/w**2,
        (479, 298): -u*v/w**2, (479, 352): -u*v/w**2, (479, 379):
        u/w**2, (479, 426): -v/w, (479, 429): -u*v/w, (479, 480): 1/w,
        (479, 568): -u*v/w**2, (480, 407): v, (480, 478): 1, (480,
        480): v/w, (480, 514): -u*v/w**2, (480, 541): u/w**2, (480,
        572): -u/w, (480, 577): -u**2/w, (480, 585): -u**2*v/w**2,
        (480, 595): -u*v/w, (480, 596): u*v**2/w, (480, 616):
        u**2*v**2/w, (480, 617): -u*v/w, (480, 619): u*v**2/w, (480,
        622): u**2*v/w**2, (480, 623): -u*v/w, (480, 643): -u**2*v/w,
        (480, 644): u**2*v/w**2, (480, 646): -u*v/w, (481, 590): 1/w,
        (481, 591): -v/w, (482, 164): -v**2/w, (482, 218): v/w, (482,
        353): -u*v**2/w, (482, 370): -v, (482, 373): v**3/w, (482,
        380): u*v/w, (482, 397): 1, (482, 400): -v**2/w, (482, 482):
        v/w, (482, 591): v, (482, 595): u, (482, 596): -v**3/w, (482,
        622): -u**2/w, (482, 623): v**2/w, (483, 82): u/w, (483, 460):
        2*u*v/w**2, (483, 483): v/w, (483, 568): 2*u**2*v/w**2, (483,
        586): 1, (483, 588): v/w, (483, 591): u*v/w, (483, 595):
        u**2/w, (483, 596): -v**2/w, (483, 622): -u**3/w**2, (483,
        623): v/w, (484, 373): v**2/w, (484, 400): -v/w, (484, 482):
        1/w, (484, 591): u*v/w, (485, 483): 1/w, (485, 589): -v/w,
        (485, 591): u/w, (486, 9): -u/w, (486, 13): 1, (486, 460):
        -u*v*(u*v - w)/w**2, (486, 568): -u**2*v*(u*v - w)/w**2, (487,
        589): v*w, (487, 604): w, (487, 612): v, (487, 631): -u, (487,
        639): -u*v/w, (488, 429): w, (489, 21): 1, (489, 90): -u/w,
        (489, 265): u*v**2, (489, 292): -u*v, (489, 319):
        -u**2*v**2/w, (489, 346): u**2*v/w, (489, 423): u*v/w, (489,
        460): u*v**2/w**2, (489, 568): u**2*v**2/w**2, (489, 617):
        u**2*v/w, (489, 644): -u**3*v/w**2, (490, 92): -v, (490, 117):
        -u/w, (490, 119): 1, (490, 265): v**2*w, (490, 292): -v*w,
        (490, 319): -u*v**2, (490, 346): u*v, (490, 450): u*v/w, (490,
        460): u*v**3/w**2, (490, 477): u*v/w, (490, 504): -u/w, (490,
        568): u**2*v**3/w**2, (490, 612): -u*v**2/w, (490, 617): u*v,
        (490, 639): u*v/w, (490, 644): -u**2*v/w, (491, 130): -v**2,
        (491, 427): -v**2*w, (491, 442): -v, (491, 450): -v**2/w,
        (491, 454): -u*v**2, (491, 469): -v, (491, 477): -v**2/w,
        (491, 495): -u/w, (491, 496): 1, (491, 504): v/w, (491, 604):
        v**2, (491, 612): v**3/w, (491, 616): -v**2*w, (491, 618):
        u*v*w, (491, 631): -v, (491, 639): -v**2/w, (491, 643):
        u*v**2, (491, 645): -u**2*v, (492, 82): -v**2/w, (492, 109):
        v/w, (492, 441): -u/w, (492, 450): -v/w, (492, 460):
        -v**3/w**2, (492, 477): -v/w, (492, 504): 1/w, (492, 568):
        -u*v**3/w**2, (492, 612): v**2/w, (492, 616): -v*w, (492,
        639): -v/w, (492, 643): u*v, (493, 23): 1, (493, 130): -v,
        (493, 136): -u*v**2/w, (493, 163): u*v/w, (493, 190): u*v/w,
        (493, 217): -u/w, (493, 271): -u*v**3/w**2, (493, 325):
        u*v**2/w**2, (493, 454): -u*v, (493, 460): u**2*v**2/w**2,
        (493, 468): -u/w, (493, 470): u*v/w, (493, 568):
        u**3*v**2/w**2, (493, 578): u**2*v/w, (493, 595):
        -u**2*v**3/w**2, (493, 618): u**2*v, (493, 622):
        u**2*v**2/w**2, (493, 645): -u**3*v/w, (494, 24): 1, (494,
        103): -v, (494, 414): -u/w, (494, 427): -u*v, (494, 616):
        -u*v, (494, 643): u**2*v/w, (495, 131): v, (495, 450): v,
        (495, 457): v*w, (495, 491): 1, (495, 495): v/w, (495, 509):
        v**2/w, (495, 514): v, (495, 541): -u*v/w, (495, 590): v**2,
        (496, 441): -v/w, (496, 495): 1/w, (496, 603): v**2/w, (496,
        618): -v*w, (496, 630): -u*v**2/w**2, (496, 645): u*v, (497,
        450): 1, (497, 487): v/w, (497, 568): u*v**2/w, (497, 589):
        -u*v**2, (497, 604): -u*v, (497, 612): -v*(u*v + w)/w, (497,
        622): v**2*(u*v - w)/w**2, (497, 631): u**2*v/w, (497, 639):
        u*v*(u*v + w)/w**2, (498, 126): 1/w, (498, 433): v/w, (498,
        450): u/w, (498, 595): -v**2/w, (498, 622): u*v**2/w**2, (499,
        131): 1, (499, 427): -u*v*w, (499, 469): -u, (499, 477):
        -u*v/w, (499, 514): u*v/w, (499, 541): -u/w, (499, 595): u*v,
        (499, 616): -u**2*v**2, (499, 622): -u**2*v/w, (499, 643):
        u**2*v, (500, 104): 1, (500, 105): -v, (500, 244): -u*v**2/w,
        (500, 271): u**2*v**2/w**2, (500, 298): u*v/w, (500, 325):
        -u**2*v/w**2, (500, 352): u*v/w, (500, 379): -u/w, (500, 568):
        u*v/w, (500, 595): u**3*v**2/w**2, (500, 618): -u*v, (500,
        622): -u**3*v/w**2, (500, 645): u**2*v/w, (501, 103): w, (501,
        427): u*w, (502, 103): u, (502, 106): 1, (502, 271):
        u**2*v/w**2, (502, 325): -u**2/w**2, (502, 427): u**2, (502,
        430): u, (502, 595): u**3*v/w**2, (502, 616): u**2, (502,
        619): u, (502, 622): -u**3/w**2, (502, 643): -u**3/w, (502,
        646): -u**2/w, (503, 105): w, (503, 244): u*v, (503, 271):
        -u**2*v/w, (503, 298): -u, (503, 325): u**2/w, (503, 595):
        -u**3*v/w, (503, 622): u**3/w, (504, 441): 1, (504, 603): -v,
        (504, 630): u*v/w, (505, 136): v**2/w, (505, 163): -v/w, (505,
        190): -v/w, (505, 217): 1/w, (505, 265): -v*w, (505, 319):
        u*v, (505, 576): -u/w, (506, 244): v**2/w, (506, 298): -v/w,
        (506, 352): -v/w, (506, 379): 1/w, (506, 429): -v, (506, 568):
        -v/w, (507, 271): v**2/w, (507, 325): -v/w, (507, 514): -v/w,
        (507, 541): 1/w, (507, 577): -u, (507, 585): -u*v/w, (507,
        595): v*(u*v - w)/w, (507, 616): u*v**2, (507, 643): -u*v,
        (508, 271): -v/w, (508, 325): 1/w, (508, 595): -u*v/w, (508,
        622): u/w, (509, 595): w, (509, 622): -u, (510, 82): 1, (510,
        460): v/w, (510, 568): u*v/w, (510, 595): u, (510, 622):
        -u**2/w, (511, 244): -v, (511, 271): u*v/w, (511, 298): 1,
        (511, 325): -u/w, (511, 595): u**2*v/w, (511, 622): -u**2/w,
        (512, 1): 1/w, (512, 82): u/w, (512, 244): -u*v/w, (512, 271):
        u/w, (512, 298): u/w, (512, 325): -u**2/w**2, (512, 595):
        u**2/w, (512, 622): -u**3/w**2, (513, 36): -u/w, (513, 40): 1,
        (513, 271): -u*v*(u*v - w)/w**2, (513, 595): -u**2*v*(u*v -
        w)/w**2, (514, 616): v*w, (514, 631): 1, (514, 639): v/w,
        (515, 267): w, (516, 48): 1, (516, 144): -u/w, (516, 261):
        u*v/w, (516, 271): u*v**2/w**2, (516, 319): u*v**2/w, (516,
        346): -u*v/w, (516, 595): u**2*v**2/w**2, (516, 644):
        u**2*v/w**2, (517, 146): -v, (517, 171): -u/w, (517, 173): 1,
        (517, 271): u*v**3/w**2, (517, 288): u*v/w, (517, 319): v**2,
        (517, 346): -v, (517, 369): u*v/w, (517, 531): -u/w, (517,
        585): u*v/w, (517, 595): u**2*v**3/w**2, (517, 612): u**2*v/w,
        (517, 644): u*v/w, (518, 184): -v**2, (518, 265): -v**2*w,
        (518, 280): -v, (518, 288): -v**2/w, (518, 361): -v, (518,
        369): -v**2/w, (518, 373): -u*v**2, (518, 522): -u/w, (518,
        523): 1, (518, 531): v/w, (518, 577): -v, (518, 585): -v**2/w,
        (518, 604): -u*v, (518, 612): -u*v**2/w, (518, 643): -v**2,
        (518, 645): u*v, (519, 136): -v**2/w, (519, 163): v/w, (519,
        271): -v**3/w**2, (519, 288): -v/w, (519, 360): -u/w, (519,
        369): -v/w, (519, 531): 1/w, (519, 585): -v/w, (519, 595):
        -u*v**3/w**2, (519, 612): -u*v/w, (519, 643): -v, (520, 50):
        1, (520, 82): u*v/w, (520, 109): -u/w, (520, 136): u**2*v/w,
        (520, 163): -u**2/w, (520, 184): -v, (520, 271):
        2*u**2*v**2/w**2, (520, 279): -u/w, (520, 281): u*v/w, (520,
        373): -u*v, (520, 460): u*v**2/w**2, (520, 568):
        u**2*v**2/w**2, (520, 595): 2*u**3*v**2/w**2, (520, 605):
        u**2*v/w, (520, 645): u**2*v/w, (521, 51): 1, (521, 157): -v,
        (521, 252): -u/w, (521, 265): -u*v, (521, 643): -u*v/w, (522,
        185): v, (522, 369): v, (522, 376): v*w, (522, 518): 1, (522,
        522): v/w, (522, 536): v**2/w, (522, 541): v/w, (522, 617):
        v**2, (523, 360): -v/w, (523, 522): 1/w, (523, 630):
        v**2/w**2, (523, 645): -v, (524, 369): 1, (524, 514): v/w,
        (524, 568): -v**2/w, (524, 616): -u*v**2, (524, 622):
        -v**3/w**2, (524, 631): -u*v/w, (524, 639): -v*(u*v + w)/w**2,
        (525, 180): 1/w, (525, 352): v/w, (525, 369): u/w, (525, 622):
        -v**2/w**2, (526, 185): 1, (526, 265): -u*v*w, (526, 280): -u,
        (526, 288): -u*v/w, (526, 487): -u/w, (526, 514): -u**2/w,
        (526, 589): u**2*v, (526, 616): u**3*v, (526, 622): u*v/w,
        (527, 158): 1, (527, 159): -v, (527, 244): u**2*v/w, (527,
        271): -u**3*v/w**2, (527, 352): -u**2/w, (527, 406): u*v/w,
        (527, 433): -u/w, (527, 460): -u**2*v/w**2, (527, 568):
        -u**3*v/w**2, (527, 595): -u*v*(u**3 - w)/w**2, (527, 645):
        -u*v/w, (528, 157): w, (528, 265): u*w, (529, 157): u, (529,
        160): 1, (529, 265): u**2, (529, 268): u, (529, 271):
        -u**3/w**2, (529, 460): -u**2/w**2, (529, 568): -u**3/w**2,
        (529, 595): -u**4/w**2, (529, 643): u**2/w, (529, 646): u/w,
        (530, 159): w, (530, 244): -u**2, (530, 271): u**3/w, (530,
        406): -u, (530, 460): u**2/w, (530, 568): u**3/w, (530, 595):
        u**4/w, (531, 360): 1, (531, 630): -v/w, (532, 82): -v/w,
        (532, 109): 1/w, (532, 136): -u*v/w, (532, 163): u/w, (532,
        319): -v, (532, 603): -u/w, (533, 244): -u*v/w, (533, 267):
        -v, (533, 352): u/w, (533, 406): -v/w, (533, 433): 1/w, (533,
        595): -v/w, (534, 271): -u*v/w, (534, 460): -v/w, (534, 487):
        1/w, (534, 514): u/w, (534, 568): -u*v/w, (534, 589): -u*v,
        (534, 595): -u**2*v/w, (534, 604): -u, (534, 612): -u*v/w,
        (534, 616): -u**2*v, (534, 622): -v/w, (535, 271): u/w, (535,
        460): 1/w, (535, 568): u/w, (535, 595): u**2/w, (536, 622): 1,
        (537, 136): 1, (537, 271): v/w, (537, 595): u*v/w, (537, 622):
        u/w, (538, 244): u, (538, 271): -u**2/w, (538, 406): 1, (538,
        460): -u/w, (538, 568): -u**2/w, (538, 595): -u**3/w, (539,
        28): 1/w, (539, 136): u/w, (539, 244): u**2/w, (539, 325):
        u/w**2, (539, 406): u/w, (539, 622): u**2/w**2, (540, 63):
        -u/w, (540, 67): 1, (540, 325): -u*v*(u*v - w)/w**2, (540,
        622): -u**2*v*(u*v - w)/w**2, (541, 577): w, (541, 585): v,
        (541, 631): v, (541, 639): v**2/w, (541, 643): v*w, (542,
        321): w, (543, 75): 1, (543, 198): -u/w, (543, 315): u*v/w,
        (543, 319): u*v**3/w, (543, 325): u*v**2/w**2, (543, 346):
        -u*v**2/w, (543, 427): u*v**2, (543, 481): -u*v, (543, 590):
        u**2*v/w, (543, 622): u**2*v**2/w**2, (543, 644):
        u**2*v**2/w**2, (544, 200): -v, (544, 225): -u/w, (544, 227):
        1, (544, 319): v**3, (544, 325): u*v**3/w**2, (544, 342):
        u*v/w, (544, 346): -v**2, (544, 396): u*v/w, (544, 427):
        v**2*w, (544, 481): -v*w, (544, 558): -u/w, (544, 590): u*v,
        (544, 612): u*v, (544, 622): u**2*v**3/w**2, (544, 644):
        u*v**2/w, (545, 238): -v**2, (545, 319): -v**2*w, (545, 334):
        -v, (545, 342): -v**2/w, (545, 388): -v, (545, 396): -v**2/w,
        (545, 400): -u*v**2, (545, 549): -u/w, (545, 550): 1, (545,
        558): v/w, (545, 589): -v**2*w, (545, 591): u*v*w, (545, 604):
        -v*w, (545, 612): -v**2, (545, 643): -v**3, (545, 645):
        u*v**2, (546, 190): -v**2/w, (546, 217): v/w, (546, 325):
        -v**3/w**2, (546, 342): -v/w, (546, 387): -u/w, (546, 396):
        -v/w, (546, 558): 1/w, (546, 589): -v*w, (546, 612): -v, (546,
        622): -u*v**3/w**2, (546, 643): -v**2, (547, 77): 1, (547,
        136): u*v, (547, 163): -u, (547, 238): -v, (547, 271):
        u*v**2/w, (547, 325): u**2*v**2/w**2, (547, 333): -u/w, (547,
        335): u*v/w, (547, 400): -u*v, (547, 591): u**2*v, (547, 595):
        u**2*v**2/w, (547, 622): u**3*v**2/w**2, (547, 632): u**2*v/w,
        (547, 645): u**2*v**2/w, (548, 78): 1, (548, 211): -v, (548,
        306): -u/w, (548, 319): -u*v, (548, 589): -u*v, (548, 643):
        -u*v**2/w, (549, 239): v, (549, 396): v, (549, 403): v*w,
        (549, 487): v, (549, 541): v**2/w, (549, 545): 1, (549, 549):
        v/w, (549, 563): v**2/w, (549, 644): v**2, (550, 387): -v/w,
        (550, 549): 1/w, (550, 576): v**2/w, (550, 591): -v*w, (550,
        630): v**3/w**2, (550, 645): -v**2, (551, 396): 1, (551, 541):
        v/w, (551, 568): -v**3/w, (551, 577): -u*v, (551, 585):
        -v*(u*v + w)/w, (551, 595): -v**2, (551, 622): v**2*(u*w -
        v**2)/w**2, (551, 631): -u*v**2/w, (551, 639): -v**2*(u*v +
        w)/w**2, (551, 643): -u*v**2, (552, 234): 1/w, (552, 379):
        v/w, (552, 396): u/w, (552, 568): -v**2/w, (552, 622):
        -v**3/w**2, (553, 239): 1, (553, 319): -u*v*w, (553, 334): -u,
        (553, 342): -u*v/w, (553, 514): -u, (553, 568): u*v, (553,
        616): u**2*v*w, (553, 622): u*v**2/w, (554, 212): 1, (554,
        213): -v, (554, 244): u*v, (554, 271): -u**2*v/w, (554, 352):
        -u, (554, 591): -u*v, (554, 595): -u**3*v/w, (554, 622):
        u*v/w, (554, 645): -u*v**2/w, (555, 211): w, (555, 319): u*w,
        (556, 211): u, (556, 214): 1, (556, 271): -u**2/w, (556, 319):
        u**2, (556, 322): u, (556, 589): u**2, (556, 592): u, (556,
        595): -u**3/w, (556, 643): u**2*v/w, (556, 646): u*v/w, (557,
        213): w, (557, 244): -u*w, (557, 271): u**2, (557, 595): u**3,
        (558, 387): 1, (558, 576): -v, (558, 630): -v**2/w, (559,
        136): -v, (559, 163): 1, (559, 319): -v**2, (559, 427): -v*w,
        (559, 630): -u/w, (560, 244): -v, (560, 321): -v, (560, 352):
        1, (560, 622): -v/w, (561, 271): -v, (561, 514): 1, (561,
        568): -v, (561, 595): -u*v, (561, 616): -u*v*w, (561, 622):
        -v**2/w, (561, 631): -u, (561, 639): -u*v/w, (562, 271): 1,
        (562, 595): u, (563, 568): w, (563, 622): v, (564, 190): 1,
        (564, 325): v/w, (564, 568): u, (564, 622): 2*u*v/w, (565,
        244): w, (565, 271): -u, (565, 595): -u**2, (566, 55): 1/w,
        (566, 190): u/w, (566, 244): u, (566, 325): u*v/w**2, (566,
        460): u/w, (566, 568): u**2/w, (566, 622): u**2*v/w**2, (567,
        44): -v/w, (567, 45): u*v/w**2, (567, 71): 1/w, (567, 72):
        -u/w**2, (567, 105): u*v/w, (567, 132): -u/w, (567, 595):
        -u**2*(u*v - w)/w**2, (567, 622): u**3*(u*v - w)/w**3, (568,
        568): v/w, (568, 612): -v/w, (568, 639): 1/w, (569, 269): w,
        (569, 323): -u, (570, 29): -v/w, (570, 56): 1/w, (570, 265):
        -u*v**2/w, (570, 292): u*v/w, (570, 319): u*v/w, (570, 346):
        -u/w, (570, 428): -u/w, (570, 429): u*v/w, (570, 430): u*v/w,
        (570, 455): u**2/w**2, (570, 456): -u/w, (570, 482):
        u**2/w**2, (570, 484): -u/w, (570, 585): u**2/w**2, (570,
        595): u**2*v/w**2, (570, 617): -u**2*v/w**2, (570, 618):
        u*v/w, (570, 622): -u**3*v/w**3, (570, 644): u**2/w**2, (570,
        645): -u**2*v/w**2, (571, 1): -u/w, (571, 373): -u*v**2/w,
        (571, 400): u*v/w, (571, 431): v**2, (571, 457): u*v/w, (571,
        458): -v, (571, 483): u*v/w, (571, 485): -v, (571, 509):
        u**2/w**2, (571, 510): -u/w, (571, 511): -u/w, (571, 512): 1,
        (571, 535): u*v/w, (571, 562): -u/w, (571, 585): u**2*v/w**2,
        (571, 589): -u*v**2/w, (571, 595): u**2*v**2/w**2, (571, 616):
        -u*v*(u*v - w)/w, (571, 619): -u*v**2/w, (571, 620): v**2,
        (571, 622): -u**3*v**2/w**3, (571, 645): -u*v*(u*v - w)/w**2,
        (571, 646): u*v/w, (571, 647): -v, (572, 271):
        -u**2*v**2/w**2, (572, 325): u**2*v/w**2, (572, 352): u*v/w,
        (572, 373): u*v*(u*v - w)/w, (572, 379): -u/w, (572, 434):
        -v**2/w, (572, 452): -v, (572, 457): -v**2/w, (572, 488): v/w,
        (572, 506): 1, (572, 507): -u/w, (572, 509): -u*v/w**2, (572,
        511): v/w, (572, 568): u*v/w, (572, 577): -u*v/w, (572, 585):
        -u*v**2/w**2, (572, 595): -u**3*v**2/w**2, (572, 596): v**3/w,
        (572, 614): v**2, (572, 615): -u*v**2/w, (572, 616): u*v**3/w,
        (572, 617): -v**2/w, (572, 618): -u**2*v**2/w, (572, 619):
        v**3/w, (572, 622): u**3*v/w**2, (572, 623): -v**2/w, (572,
        641): -v, (572, 642): u*v/w, (572, 643): -u*v**2/w, (572,
        644): u*v**2/w**2, (572, 645): u**2*v/w, (572, 646): -v**2/w,
        (573, 244): u*v/w, (573, 271): -u**2*v/w**2, (573, 298): -u/w,
        (573, 325): u**2/w**2, (573, 457): -v/w, (573, 509): -u/w**2,
        (573, 511): 1/w, (573, 585): -u*v/w**2, (573, 595): -u*(u**2*v
        - u*w + v**2)/w**2, (573, 616): u*v**2/w, (573, 618): -v**2/w,
        (573, 619): v**2/w, (573, 622): u**2*v**2/w**3, (573, 643):
        -u*v/w, (573, 645): u*v**2/w**2, (573, 646): -v/w, (574, 82):
        u**2*v/w**2, (574, 265): u*v, (574, 271): -u**2*v*(u*v -
        w)/w**3, (574, 319): -u**2*v/w, (574, 373): -u, (574, 400):
        u**2/w, (574, 429): -u, (574, 431): u*v, (574, 434): -v/w,
        (574, 453): -u/w, (574, 455): -u*v/w**2, (574, 460):
        u**2*v**2/w**3, (574, 483): u**2/w, (574, 485): -u, (574,
        488): 1/w, (574, 568): u**3*v**2/w**3, (574, 589): -u**2*v/w,
        (574, 595): -u**2*(u**2*v**2 - 3*u*v*w + w**2)/w**3, (574,
        596): v**2/w, (574, 605): u**2/w, (574, 615): -u*v*(u*v -
        w)/w**2, (574, 616): -u*v**2*(u*v - w)/w**2, (574, 618):
        -u**3*v**2/w**2, (574, 622): -u**3*(2*u*v - w)/w**3, (574,
        623): -v/w, (574, 632): -u**3/w**2, (574, 645): u**2/w, (575,
        244): u**2*v/w**2, (575, 271): -u**3*v/w**3, (575, 298):
        -u**2/w**2, (575, 325): u**3/w**3, (575, 407): -v/w, (575,
        426): -u/w, (575, 429): -u**2/w, (575, 455): -u/w**2, (575,
        461): 1/w, (575, 595): -u**4*v/w**3, (575, 615): -u**2*v/w**2,
        (575, 616): -u*v*(u*v - w)/w**2, (575, 618): -u**3*v/w**2,
        (575, 622): u**4/w**3, (575, 642): u**2/w**2, (575, 643):
        u*(u*v - w)/w**2, (575, 645): u**3/w**2, (576, 434): v, (576,
        505): 1, (576, 507): v/w, (576, 514): -u*v**2/w**2, (576,
        536): v/w, (576, 537): -v**2/w, (576, 541): u*v/w**2, (576,
        563): -u*v/w**2, (576, 564): v/w, (576, 576): v/w, (577, 271):
        u*v**2/w**2, (577, 325): -u*v/w**2, (577, 507): 1/w, (577,
        508): v/w, (577, 577): v/w, (577, 585): v**2/w**2, (577, 595):
        u*v*(u*v + w)/w**2, (577, 615): v**2/w, (577, 618): u*v**2/w,
        (577, 622): -2*u**2*v/w**2, (577, 642): -v/w, (577, 645):
        -u*v/w, (578, 136): u*v/w, (578, 190): -u/w, (578, 271):
        u*v**2/w**2, (578, 325): -u*v/w**2, (578, 537): -v/w, (578,
        564): 1/w, (578, 568): -u*(u*w + v**2)/w**2, (578, 595):
        u**2*v**2/w**2, (578, 612): u*v**2/w**2, (578, 622):
        -u**2*v/w**2, (578, 639): -u*v/w**2, (579, 271): u*v/w**2,
        (579, 325): -u/w**2, (579, 508): 1/w, (579, 595): u**2*v/w**2,
        (579, 622): -u**2/w**2, (580, 265): -u*w, (580, 319): u**2,
        (580, 376): -u, (580, 377): u*v, (580, 403): u**2/w, (580,
        404): -u, (580, 434): (-u*v + w)/w, (580, 452): -u, (580,
        454): -u**2*v/w, (580, 588): -u*v/w, (580, 589): u*(u*w -
        v**2)/w, (580, 606): u**2, (580, 617): -u*v/w, (580, 618):
        u*v**2/w, (580, 633): -u**3/w, (580, 644): u**2*v/w**2, (580,
        645): -u*v/w, (581, 110): 1/w, (581, 265): -u**2, (581, 268):
        -u, (581, 269): u*v, (581, 319): u**3/w, (581, 322): u**2/w,
        (581, 323): -u**2*v/w, (581, 434): u/w, (581, 460):
        -u**3*v/w**3, (581, 568): -u**4*v/w**3, (581, 588):
        -u**2*v/w**2, (581, 589): u**2*(u*w - v**2)/w**2, (581, 591):
        -u**2*(u*v - w)/w**2, (581, 592): u**2/w, (581, 593): -u,
        (581, 618): u*v/w, (581, 645): -u/w, (582, 407): 1, (582,
        616): u**2*v/w, (582, 619): u*v/w, (582, 643): -u**2/w, (582,
        646): -u/w, (583, 83): 1/w, (583, 407): u/w, (583, 460):
        -u**3/w**3, (583, 568): -u**4/w**3, (583, 588): -u**2/w**2,
        (583, 589): -u**2*v/w**2, (583, 591): -u**3/w**2, (583, 596):
        u/w, (583, 623): -u**2/w**2, (584, 269): -u*w, (584, 271):
        u**2*v/w**2, (584, 323): u**2, (584, 325): -u**2/w**2, (584,
        373): u**2*v/w, (584, 400): -u**2/w, (584, 460): u**3/w**2,
        (584, 568): u**4/w**2, (584, 569): (-u*v + w)/w, (584, 587):
        -u, (584, 588): u**2/w, (584, 591): u**3/w, (584, 592):
        -u*v/w, (584, 595): u**3*v/w**2, (584, 615): u*v/w, (584,
        616): u*v**2/w, (584, 618): u**2*v/w, (584, 622): -u**3/w**2,
        (584, 642): -u/w, (584, 643): -u*v/w, (584, 645): -u**2/w,
        (585, 509): 1/w, (585, 595): -u, (585, 622): u**2/w, (586,
        82): -u*v/w**2, (586, 373): u*v/w, (586, 400): -u/w, (586,
        431): -v, (586, 460): -u*v**2/w**3, (586, 483): -u/w, (586,
        485): 1, (586, 568): -u**2*v**2/w**3, (586, 589): u*v/w, (586,
        595): -2*u**2*v/w**2, (586, 605): -u/w, (586, 622):
        2*u**3*v/w**3, (586, 632): u**2/w**2, (587, 269): -v, (587,
        323): u*v/w, (587, 589): -u**2/w, (587, 591): -u/w, (587,
        592): -u/w, (587, 593): 1, (588, 376): u*v/w, (588, 377): -v,
        (588, 403): -u/w, (588, 404): 1, (588, 460): -u*v/w**2, (588,
        568): -u**2*v/w**2, (588, 589): -u, (588, 591): -u*v/w, (588,
        606): -u, (588, 633): u**2/w, (589, 460): u/w**2, (589, 568):
        u**2/w**2, (589, 588): 1/w, (589, 589): v/w, (589, 591): u/w,
        (590, 353): -v**2/w, (590, 371): -v, (590, 373): -u*v**2/w,
        (590, 376): -v**2/w, (590, 380): v/w, (590, 398): 1, (590,
        400): u*v/w, (590, 403): v/w, (590, 590): v/w, (591, 376):
        -v/w, (591, 403): 1/w, (591, 591): v/w, (592, 373): -u*v/w,
        (592, 400): u/w, (592, 460): -u**2/w**2, (592, 568):
        -u**3/w**2, (592, 569): v/w, (592, 587): 1, (592, 588): -u/w,
        (592, 591): -u**2/w, (592, 592): v/w, (593, 589): u/w, (593,
        592): 1/w, (594, 17): 1/w, (594, 18): -u/w**2, (594, 44): u/w,
        (594, 45): -u**2/w**2, (594, 159): u*v/w, (594, 186): -u/w,
        (594, 622): -u**2*(u*v - w)/w**3, (595, 585): 1/w, (595, 595):
        v/w, (595, 612): u/w, (596, 323): 1, (597, 2): 1/w, (597, 29):
        u/w, (597, 265): u**2*v/w, (597, 266): -u/w, (597, 267):
        u*v/w, (597, 268): u*v/w, (597, 292): -u**2/w, (597, 293):
        u**2/w**2, (597, 295): -u/w, (597, 374): u**2/w**2, (597,
        375): -u/w, (597, 427): u*v/w, (597, 481): -u/w, (597, 590):
        u**2/w**2, (597, 612): u**2/w**2, (597, 617): u**3/w**2, (597,
        622): u**2*v/w**3, (597, 645): u*v/w**2, (598, 28): -u/w,
        (598, 269): v**2, (598, 294): u*v/w, (598, 296): -v, (598,
        373): u**2*v/w, (598, 376): u*v/w, (598, 377): -v, (598, 454):
        u*v/w, (598, 508): -u/w, (598, 535): -u**2/w, (598, 536):
        u**2/w**2, (598, 537): -u/w, (598, 538): -u/w, (598, 539): 1,
        (598, 589): u**2*v/w, (598, 591): u*v/w, (598, 592): u*v/w,
        (598, 593): -v, (598, 612): u**2*v/w**2, (598, 616): u*v*(u**2
        - v)/w, (598, 618): u**2*v/w, (598, 619): u**2*v/w, (598,
        620): -u*v, (598, 622): u**2*v**2/w**3, (598, 643): u*v/w,
        (598, 645): u*v**2/w**2, (599, 271): u**3*v/w**2, (599, 352):
        -u**2/w, (599, 353): -v**2/w, (599, 371): -v, (599, 373):
        -u**3*v/w, (599, 376): -v**2/w, (599, 400): -u*v/w, (599,
        433): -u/w, (599, 454): -u**2*v/w, (599, 460): u**2*v/w**2,
        (599, 515): v/w, (599, 533): 1, (599, 534): -u/w, (599, 536):
        -u*v/w**2, (599, 538): v/w, (599, 568): u**3*v/w**2, (599,
        569): -v**2/w, (599, 587): -v, (599, 588): u*v/w, (599, 589):
        -u*v**2/w, (599, 591): u**2*v/w, (599, 592): -v**2/w, (599,
        595): u*v*(u**3 + w)/w**2, (599, 596): -u*v**2/w, (599, 604):
        -u*v/w, (599, 612): -u*v**2/w**2, (599, 614): -u*v, (599,
        615): u**2*v/w, (599, 616): -u**2*v**2/w, (599, 618):
        u**3*v/w, (599, 619): -u*v**2/w, (599, 644): -v**2/w**2, (600,
        244): -u**2/w, (600, 271): u**3/w**2, (600, 376): -v/w, (600,
        406): -u/w, (600, 460): u**2/w**2, (600, 536): -u/w**2, (600,
        538): 1/w, (600, 568): u**3/w**2, (600, 589): -u*v/w, (600,
        592): -v/w, (600, 595): u**4/w**2, (600, 612): -u*v/w**2,
        (600, 616): -u**2*v/w, (600, 619): -u*v/w, (600, 622): u*(u*w
        - v**2)/w**3, (600, 645): -v**2/w**2, (601, 136): u**2*v/w**2,
        (601, 267): -u, (601, 269): u*v, (601, 271): u**2*v*(u**2 +
        v)/w**3, (601, 294): u**2/w, (601, 296): -u, (601, 319):
        u*v/w, (601, 325): u**2*v/w**3, (601, 353): -v/w, (601, 372):
        -u/w, (601, 374): -u*v/w**2, (601, 400): -u/w, (601, 460):
        u**3*v/w**3, (601, 515): 1/w, (601, 568): u**4*v/w**3, (601,
        569): -v/w, (601, 588): u**2*v/w**2, (601, 589):
        u**2*v**2/w**2, (601, 591): u**2*(u*v + w)/w**2, (601, 595):
        u**3*v*(u**2 + v)/w**3, (601, 596): -u*v/w, (601, 615):
        u**3*v/w**2, (601, 616): u**2*v*(u*v - w)/w**2, (601, 618):
        u**3*(u*v + w)/w**2, (601, 622): u**2*(3*u*v - w)/w**3, (601,
        632): u**2/w**2, (601, 642): u*v/w**2, (601, 643):
        u*v**2/w**2, (601, 645): u**2*v/w**2, (602, 244): -u**3/w**2,
        (602, 245): -v/w, (602, 264): -u/w, (602, 267): -u**2/w, (602,
        271): u**4/w**3, (602, 272): 1/w, (602, 374): -u/w**2, (602,
        406): -u**2/w**2, (602, 460): u**3/w**3, (602, 568):
        u**4/w**3, (602, 588): u**2/w**2, (602, 589): u*(u*v -
        w)/w**2, (602, 591): u**3/w**2, (602, 595): u**5/w**3, (602,
        615): u**3/w**2, (602, 616): u**2*(u*v - w)/w**2, (602, 618):
        u**4/w**2, (603, 353): v, (603, 487): u*v/w**2, (603, 510):
        v/w, (603, 514): u**2*v/w**2, (603, 532): 1, (603, 534): v/w,
        (603, 537): u*v/w, (603, 563): v/w**2, (603, 603): v/w, (604,
        271): -u**2*v/w**2, (604, 460): -u*v/w**2, (604, 534): 1/w,
        (604, 535): v/w, (604, 568): -u**2*v/w**2, (604, 588): -v/w,
        (604, 591): -u*v/w, (604, 595): -u**3*v/w**2, (604, 604): v/w,
        (604, 612): v**2/w**2, (604, 615): -u*v/w, (604, 618):
        -u**2*v/w, (604, 622): u*v/w**2, (605, 82): -u/w, (605, 136):
        -u**2/w, (605, 271): -u**2*v/w**2, (605, 460): -u*v/w**2,
        (605, 510): 1/w, (605, 537): u/w, (605, 568): -u**2*v/w**2,
        (605, 585): -u*v/w**2, (605, 595): -u*(u**2*v + u*w +
        v**2)/w**2, (605, 612): -u**2*v/w**2, (606, 271): -u**2/w**2,
        (606, 460): -u/w**2, (606, 535): 1/w, (606, 568): -u**2/w**2,
        (606, 595): -u**3/w**2, (607, 319): -u, (607, 353): (-u*v +
        w)/w, (607, 371): -u, (607, 373): -u**2*v/w, (607, 377):
        -u**2, (607, 403): -u/w, (607, 458): -u, (607, 591): -u*v/w,
        (607, 615): -u*v/w, (607, 616): u*(u*w - v**2)/w, (607, 618):
        -u**2*v/w, (607, 633): u**2/w, (607, 644): -u*v/w**2, (608,
        164): 1/w, (608, 271): -u**3*v/w**3, (608, 319): -u**2/w,
        (608, 322): -u/w, (608, 323): u*v/w, (608, 353): u/w, (608,
        591): -u/w, (608, 595): -u**4*v/w**3, (608, 615):
        -u**2*v/w**2, (608, 616): u**2*(u*w - v**2)/w**2, (608, 618):
        -u**3*v/w**2, (608, 619): u**2/w, (608, 620): -u, (609, 245):
        1, (609, 589): -u**2/w, (609, 592): -u/w, (609, 616): -u**3/w,
        (609, 619): -u**2/w, (610, 137): 1/w, (610, 245): u/w, (610,
        271): -u**3/w**3, (610, 595): -u**4/w**3, (610, 615):
        -u**2/w**2, (610, 616): -u**2*v/w**2, (610, 618): -u**3/w**2,
        (610, 623): u/w**2, (611, 323): -u, (611, 373): -u**3/w, (611,
        454): -u**2/w, (611, 460): -u**2/w**2, (611, 568): -u**3/w**2,
        (611, 588): -u/w, (611, 589): -u*v/w, (611, 591): -u**2/w,
        (611, 596): (-u*v + w)/w, (611, 614): -u, (611, 616):
        -u**2*v/w, (611, 619): -u*v/w, (612, 536): 1/w, (612, 622):
        -u/w, (613, 136): -u*v/w**2, (613, 269): -v, (613, 271):
        -u*v**2/w**3, (613, 294): -u/w, (613, 296): 1, (613, 373):
        -u**2/w, (613, 454): -u/w, (613, 595): -u**2*v**2/w**3, (613,
        616): u*v/w, (613, 622): -2*u**2*v/w**3, (613, 632): -u/w**2,
        (614, 323): -v/w, (614, 616): -u**2/w, (614, 618): -u/w, (614,
        619): -u/w, (614, 620): 1, (615, 271): -u*v/w**2, (615, 376):
        -u**2/w, (615, 377): u, (615, 457): -u/w, (615, 458): 1, (615,
        595): -u**2*v/w**2, (615, 616): -u, (615, 618): -u*v/w, (615,
        633): -u/w, (616, 271): u/w**2, (616, 595): u**2/w**2, (616,
        615): 1/w, (616, 616): v/w, (616, 618): u/w, (617, 353):
        u*v/w, (617, 371): u, (617, 373): u**2*v/w, (617, 376): u*v/w,
        (617, 434): v/w, (617, 452): 1, (617, 454): u*v/w, (617, 457):
        v/w, (617, 617): v/w, (618, 376): u/w, (618, 457): 1/w, (618,
        618): v/w, (619, 271): -u**2/w**2, (619, 373): u**2/w, (619,
        454): u/w, (619, 595): -u**3/w**2, (619, 596): v/w, (619,
        614): 1, (619, 615): -u/w, (619, 618): -u**2/w, (619, 619):
        v/w, (620, 616): u/w, (620, 619): 1/w, (621, 44): 1, (621,
        45): -u/w, (621, 213): u*v/w, (621, 240): -u/w, (621, 568):
        -u**2*(u*v - w)/w**2, (621, 622): -u**2*v*(u*v - w)/w**3,
        (622, 612): 1, (622, 622): v/w, (623, 323): v, (623, 431): w,
        (624, 29): 1, (624, 265): u*v, (624, 292): -u, (624, 320):
        -u/w, (624, 321): u*v/w, (624, 322): u*v/w, (624, 347):
        u**2/w**2, (624, 349): -u/w, (624, 401): u**2/w**2, (624,
        402): -u/w, (624, 568): u**2*v/w**2, (624, 591): u*v/w, (624,
        617): u**2/w, (624, 622): u**2*v**2/w**3, (624, 639):
        u**2/w**2, (624, 645): u*v**2/w**2, (625, 55): -u/w, (625,
        323): v**2, (625, 348): u*v/w, (625, 350): -v, (625, 373):
        u*v, (625, 403): u*v/w, (625, 404): -v, (625, 535): -u, (625,
        563): u**2/w**2, (625, 564): -u/w, (625, 565): -u/w, (625,
        566): 1, (625, 568): u**2*v**2/w**2, (625, 589): u*v, (625,
        591): u*v**2/w, (625, 616): u**2*v, (625, 618): u*v, (625,
        619): u*v, (625, 620): -v*w, (625, 622): u**2*v**3/w**3, (625,
        639): u**2*v/w**2, (625, 645): u*v**3/w**2, (626, 271):
        u**2*v/w, (626, 352): -u, (626, 373): -u**2*v, (626, 380):
        -v**2/w, (626, 398): -v, (626, 400): -u*v**2/w, (626, 403):
        -v**2/w, (626, 454): -u*v, (626, 542): v/w, (626, 560): 1,
        (626, 561): -u/w, (626, 563): -u*v/w**2, (626, 565): v/w,
        (626, 590): -v**2/w, (626, 595): u**3*v/w, (626, 596): -v**2,
        (626, 614): -v*w, (626, 615): u*v, (626, 616): -u*v**2, (626,
        618): u**2*v, (626, 619): -v**2, (626, 622): u*v/w, (626,
        631): -u*v/w, (626, 639): -u*v**2/w**2, (626, 644):
        -v**3/w**2, (627, 244): -u, (627, 271): u**2/w, (627, 403):
        -v/w, (627, 563): -u/w**2, (627, 565): 1/w, (627, 568): u*(u*w
        - v**2)/w**2, (627, 591): -v**2/w, (627, 595): u**3/w, (627,
        616): -u*v, (627, 619): -v, (627, 622): u*v*(u*w - v**2)/w**3,
        (627, 639): -u*v/w**2, (627, 645): -v**3/w**2, (628, 190):
        u**2*v/w**2, (628, 271): u**3*v/w**2, (628, 319): u*v**2/w,
        (628, 321): -u, (628, 323): u*v, (628, 325): 2*u**2*v**2/w**3,
        (628, 348): u**2/w, (628, 350): -u, (628, 380): -v/w, (628,
        399): -u/w, (628, 400): -u*v/w, (628, 401): -u*v/w**2, (628,
        427): u*v, (628, 454): -u, (628, 460): u**2*v/w**2, (628,
        542): 1/w, (628, 568): u**2*(3*u*v - w)/w**2, (628, 578):
        u**2/w, (628, 588): u*v/w, (628, 589): u*v**2/w, (628, 591):
        u**2*v/w, (628, 595): u**4*v/w**2, (628, 596): -v, (628, 615):
        u**2*v/w, (628, 616): u**2*v**2/w, (628, 618): u**2*(u*v +
        w)/w, (628, 622): u**2*v*(4*u*v - w)/w**3, (628, 632):
        u**2*v/w**2, (628, 642): u*v**2/w**2, (628, 643): -u*v*(u*w -
        v**2)/w**2, (628, 645): u**2*v**2/w**2, (629, 244): -u**2/w,
        (629, 271): u**3/w**2, (629, 299): -v/w, (629, 318): -u/w,
        (629, 321): -u**2/w, (629, 326): 1/w, (629, 401): -u/w**2,
        (629, 595): u**4/w**2, (629, 615): u**2/w, (629, 616): u*(u*v
        - w)/w, (629, 618): u**3/w, (630, 380): v, (630, 509): v/w,
        (630, 514): u*v/w, (630, 537): v, (630, 559): 1, (630, 561):
        v/w, (630, 563): v**2/w**2, (630, 630): v/w, (631, 271):
        -u*v/w, (631, 561): 1/w, (631, 562): v/w, (631, 568): u*v/w,
        (631, 595): -u**2*v/w, (631, 615): -v, (631, 618): -u*v, (631,
        622): u*v**2/w**2, (631, 631): v/w, (631, 639): v**2/w**2,
        (632, 136): -u, (632, 271): -u*v/w, (632, 537): 1, (632, 595):
        -u**2*v/w, (632, 612): -u*v/w, (632, 622): -u*(u*w +
        v**2)/w**2, (633, 271): -u/w, (633, 562): 1/w, (633, 595):
        -u**2/w, (634, 319): -u*v, (634, 377): -u*w, (634, 380): (-u*v
        + w)/w, (634, 398): -u, (634, 400): -u**2*v/w, (634, 403):
        -u*v/w, (634, 427): -u*w, (634, 457): -u, (634, 579): u**2,
        (634, 590): -u*v/w, (634, 618): -u*v, (634, 633): u**2*v/w,
        (634, 642): -u*v/w, (634, 643): u*(u*w - v**2)/w, (634, 644):
        -u*v**2/w**2, (635, 218): 1/w, (635, 319): -u**2*v/w, (635,
        322): -u*v/w, (635, 323): u*v**2/w, (635, 325): -u**3*v/w**3,
        (635, 380): u/w, (635, 427): -u**2, (635, 430): -u, (635,
        431): u*v, (635, 618): -u, (635, 622): -u**4*v/w**3, (635,
        642): -u**2*v/w**2, (635, 643): u**2*(u*w - v**2)/w**2, (635,
        645): -u**2*(u*v - w)/w**2, (635, 646): u**2/w, (635, 647):
        -u, (636, 299): 1, (636, 616): -u**2, (636, 619): -u, (637,
        191): 1/w, (637, 299): u/w, (637, 325): -u**3/w**3, (637,
        569): u/w, (637, 622): -u**4/w**3, (637, 623): u*v/w**2, (637,
        642): -u**2/w**2, (637, 643): -u**2*v/w**2, (637, 645):
        -u**3/w**2, (638, 271): -u**2/w, (638, 323): -u*v, (638, 325):
        u**3/w**2, (638, 373): -u**2, (638, 431): -u*w, (638, 595):
        -u**3/w, (638, 615): -u, (638, 616): -u*v, (638, 618): -u**2,
        (638, 622): u**4/w**2, (638, 623): (-u*v + w)/w, (638, 641):
        -u, (638, 642): u**2/w, (638, 645): u**3/w, (638, 646):
        -u*v/w, (639, 563): 1/w, (639, 568): -u, (639, 622): -u*v/w,
        (640, 190): -u*v/w**2, (640, 323): -v, (640, 325):
        -u*v**2/w**3, (640, 348): -u/w, (640, 350): 1, (640, 373): -u,
        (640, 568): -2*u**2*v/w**2, (640, 578): -u/w, (640, 622):
        -3*u**2*v**2/w**3, (640, 632): -u*v/w**2, (640, 643): u*v/w,
        (641, 323): -v**2/w, (641, 431): -v, (641, 643): -u**2/w,
        (641, 645): -u/w, (641, 646): -u/w, (641, 647): 1, (642, 325):
        -u*v/w**2, (642, 376): -u, (642, 377): w, (642, 579): -u,
        (642, 622): -u**2*v/w**2, (642, 633): -u*v/w, (642, 643): -u,
        (642, 645): -u*v/w, (643, 325): u/w**2, (643, 622): u**2/w**2,
        (643, 642): 1/w, (643, 643): v/w, (643, 645): u/w, (644, 353):
        v, (644, 371): w, (644, 373): u*v, (644, 376): v, (644, 644):
        v/w, (645, 376): 1, (645, 645): v/w, (646, 325): -u**2/w**2,
        (646, 373): u, (646, 622): -u**3/w**2, (646, 623): v/w, (646,
        641): 1, (646, 642): -u/w, (646, 645): -u**2/w, (646, 646):
        v/w, (647, 643): u/w, (647, 646): 1/w}]])
    return data

