"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallRuleGroupAssociation = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * A Firewall Rule Group Association
 */
class FirewallRuleGroupAssociation extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRuleGroupAssociationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (!core_1.Token.isUnresolved(props.priority) && (props.priority <= 100 || props.priority >= 9000)) {
            throw new Error(`Priority must be greater than 100 and less than 9000, got ${props.priority}`);
        }
        const association = new route53resolver_generated_1.CfnFirewallRuleGroupAssociation(this, 'Resource', {
            firewallRuleGroupId: props.firewallRuleGroup.firewallRuleGroupId,
            priority: props.priority,
            vpcId: props.vpc.vpcId,
        });
        this.firewallRuleGroupAssociationArn = association.attrArn;
        this.firewallRuleGroupAssociationCreationTime = association.attrCreationTime;
        this.firewallRuleGroupAssociationCreatorRequestId = association.attrCreatorRequestId;
        this.firewallRuleGroupAssociationId = association.attrId;
        this.firewallRuleGroupAssociationManagedOwnerName = association.attrManagedOwnerName;
        this.firewallRuleGroupAssociationModificationTime = association.attrModificationTime;
        this.firewallRuleGroupAssociationStatus = association.attrStatus;
        this.firewallRuleGroupAssociationStatusMessage = association.attrStatusMessage;
    }
}
exports.FirewallRuleGroupAssociation = FirewallRuleGroupAssociation;
_a = JSII_RTTI_SYMBOL_1;
FirewallRuleGroupAssociation[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleGroupAssociation", version: "1.156.0" };
//# sourceMappingURL=data:application/json;base64,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