"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroAppsTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const constructs_1 = require("constructs");
/**
 * Create a new MicroApps Table for apps / versions / rules
 *
 * @warning This construct is not intended for production use.
 * In a production stack the DynamoDB Table, API Gateway, S3 Buckets,
 * etc. should be created in a "durable" stack where the IDs will not
 * change and where changes to the MicroApps construct will not
 * cause failures to deploy or data to be deleted.
 */
class MicroAppsTable extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props === undefined) {
            throw new Error('props cannot be undefined');
        }
        const { removalPolicy, assetNameRoot, assetNameSuffix } = props;
        //
        // DynamoDB Table
        //
        this._table = new dynamodb.Table(this, 'table', {
            tableName: assetNameRoot
                ? `${assetNameRoot}${assetNameSuffix !== null && assetNameSuffix !== void 0 ? assetNameSuffix : ''}`
                : aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            partitionKey: {
                name: 'PK',
                type: dynamodb.AttributeType.STRING,
            },
            sortKey: {
                name: 'SK',
                type: dynamodb.AttributeType.STRING,
            },
            removalPolicy,
        });
    }
    get table() {
        return this._table;
    }
}
exports.MicroAppsTable = MicroAppsTable;
_a = JSII_RTTI_SYMBOL_1;
MicroAppsTable[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroAppsTable", version: "0.3.5-alpha.1" };
//# sourceMappingURL=data:application/json;base64,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