"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroAppsS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cf = require("aws-cdk-lib/aws-cloudfront");
const cforigins = require("aws-cdk-lib/aws-cloudfront-origins");
const s3 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
/**
 * Create the durable MicroApps S3 Buckets
 *
 * These should be created in a stack that will not be deleted if
 * there are breaking changes to MicroApps in the future.
 */
class MicroAppsS3 extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props === undefined) {
            throw new Error('props must be set');
        }
        const { removalPolicy, assetNameRoot, assetNameSuffix, originShieldRegion } = props;
        // Use Auto-Delete S3Bucket if removal policy is DESTROY
        const s3AutoDeleteItems = removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY;
        //
        // S3 Bucket for Logging - Usable by many stacks
        //
        this._bucketLogs = new s3.Bucket(this, 'logs', {
            bucketName: props.bucketLogsName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        //
        // S3 Buckets for Apps
        //
        this._bucketApps = new s3.Bucket(this, 'apps', {
            bucketName: props.bucketAppsName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        this._bucketAppsStaging = new s3.Bucket(this, 'staging', {
            bucketName: props.bucketAppsStagingName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        // Create S3 Origin Identity
        this._bucketAppsOAI = new cf.OriginAccessIdentity(this, 'oai', {
            comment: assetNameRoot !== undefined ? `${assetNameRoot}${assetNameSuffix}` : undefined,
        });
        if (removalPolicy !== undefined) {
            this._bucketAppsOAI.applyRemovalPolicy(removalPolicy);
        }
        // Add Origin for CloudFront
        this._bucketAppsOrigin = new cforigins.S3Origin(this._bucketApps, {
            originAccessIdentity: this.bucketAppsOAI,
            originShieldRegion,
        });
    }
    get bucketApps() {
        return this._bucketApps;
    }
    get bucketAppsOAI() {
        return this._bucketAppsOAI;
    }
    get bucketAppsOrigin() {
        return this._bucketAppsOrigin;
    }
    get bucketAppsStaging() {
        return this._bucketAppsStaging;
    }
    get bucketLogs() {
        return this._bucketLogs;
    }
}
exports.MicroAppsS3 = MicroAppsS3;
_a = JSII_RTTI_SYMBOL_1;
MicroAppsS3[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroAppsS3", version: "0.3.5-alpha.1" };
//# sourceMappingURL=data:application/json;base64,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