"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroApps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const MicroAppsAPIGwy_1 = require("./MicroAppsAPIGwy");
const MicroAppsCF_1 = require("./MicroAppsCF");
const MicroAppsEdgeToOrigin_1 = require("./MicroAppsEdgeToOrigin");
const MicroAppsS3_1 = require("./MicroAppsS3");
const MicroAppsSvcs_1 = require("./MicroAppsSvcs");
const ReverseDomain_1 = require("./utils/ReverseDomain");
/**
 * Create a new MicroApps "turnkey" construct for simple
 * deployments and for initial evaulation of the MicroApps framework.
 *
 * Use this construct to create a PoC working entire stack.
 *
 * Do not use this construct when adding MicroApps to an existing
 * CloudFront, API Gateway, S3 Bucket, etc. or where access
 * to all features of the AWS Resources are needed (e.g. to
 * add additional Behaviors to the CloudFront distribution, set authorizors
 * on API Gateway, etc.).
 *
 * @warning This construct is not intended for production use.
 * In a production stack the DynamoDB Table, API Gateway, S3 Buckets,
 * etc. should be created in a "durable" stack where the IDs will not
 * change and where changes to the MicroApps construct will not
 * cause failures to deploy or data to be deleted.
 *
 *  @see {@link https://github.com/pwrdrvr/microapps-core/blob/main/packages/cdk/lib/MicroApps.ts | example usage in a CDK Stack }
 */
class MicroApps extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        if (props === undefined) {
            throw new Error('props must be set');
        }
        const { domainNameEdge, domainNameOrigin, assetNameRoot, assetNameSuffix, r53Zone, certEdge, appEnv = 'dev', certOrigin, removalPolicy, s3PolicyBypassAROAs, s3PolicyBypassPrincipalARNs, s3StrictBucketPolicy, rootPathPrefix, createAPIGateway = false, createAPIPathRoute = true, createNextDataPathRoute = true, addXForwardedHostHeader = true, replaceHostHeader = true, signingMode = 'sign', originRegion, table, tableNameForEdgeToOrigin, originShieldRegion = originRegion, } = props;
        this._s3 = new MicroAppsS3_1.MicroAppsS3(this, 's3', {
            removalPolicy,
            bucketLogsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-logs` : undefined,
            bucketAppsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}` : undefined,
            bucketAppsStagingName: domainNameEdge
                ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-staging`
                : undefined,
            assetNameRoot,
            assetNameSuffix,
            originShieldRegion,
        });
        if (createAPIGateway) {
            this._apigwy = new MicroAppsAPIGwy_1.MicroAppsAPIGwy(this, 'api', {
                removalPolicy,
                assetNameRoot,
                assetNameSuffix,
                domainNameEdge,
                domainNameOrigin,
                r53Zone,
                certOrigin,
                rootPathPrefix,
                requireIAMAuthorization: signingMode !== 'none',
            });
        }
        this._svcs = new MicroAppsSvcs_1.MicroAppsSvcs(this, 'svcs', {
            ...(this._apigwy ? { httpApi: this._apigwy.httpApi } : {}),
            removalPolicy,
            bucketApps: this._s3.bucketApps,
            bucketAppsOAI: this._s3.bucketAppsOAI,
            bucketAppsStaging: this._s3.bucketAppsStaging,
            assetNameRoot,
            assetNameSuffix,
            appEnv,
            s3PolicyBypassAROAs,
            s3PolicyBypassPrincipalARNs,
            s3StrictBucketPolicy,
            rootPathPrefix,
            requireIAMAuthorization: signingMode !== 'none',
            table,
        });
        const edgeLambdas = [];
        if (signingMode !== 'none' || replaceHostHeader || addXForwardedHostHeader) {
            this._edgeToOrigin = new MicroAppsEdgeToOrigin_1.MicroAppsEdgeToOrigin(this, 'edgeToOrigin', {
                assetNameRoot,
                assetNameSuffix,
                removalPolicy,
                addXForwardedHostHeader,
                setupApiGatewayPermissions: createAPIGateway,
                replaceHostHeader,
                originRegion,
                signingMode,
                rootPathPrefix,
                tableRulesArn: tableNameForEdgeToOrigin || this._svcs.table.tableName,
            });
            edgeLambdas.push(...this._edgeToOrigin.edgeToOriginLambdas);
        }
        // Add any extra lambdas
        if ((_b = props.edgeLambdas) === null || _b === void 0 ? void 0 : _b.length) {
            edgeLambdas.push(...props.edgeLambdas);
        }
        this._cf = new MicroAppsCF_1.MicroAppsCF(this, 'cft', {
            removalPolicy,
            assetNameRoot,
            assetNameSuffix,
            domainNameEdge,
            domainNameOrigin,
            ...(this._apigwy ? { httpApi: this._apigwy.httpApi } : {}),
            r53Zone,
            certEdge,
            bucketAppsOrigin: this._s3.bucketAppsOrigin,
            bucketLogs: this._s3.bucketLogs,
            rootPathPrefix,
            createAPIPathRoute,
            createNextDataPathRoute,
            originShieldRegion,
            ...(edgeLambdas.length ? { edgeLambdas } : {}),
        });
    }
    get cf() {
        return this._cf;
    }
    get edgeToOrigin() {
        return this._edgeToOrigin;
    }
    get s3() {
        return this._s3;
    }
    get apigwy() {
        return this._apigwy;
    }
    get svcs() {
        return this._svcs;
    }
}
exports.MicroApps = MicroApps;
_a = JSII_RTTI_SYMBOL_1;
MicroApps[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroApps", version: "0.3.5-alpha.1" };
//# sourceMappingURL=data:application/json;base64,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