import xml.etree.ElementTree as ET

from  pygments.lexers.html import XmlLexer

from lens.parsers.base import LensParser

class Parser(LensParser):
    lexer = XmlLexer

    def treat(self, inpt, keys):
        loaded = ET.fromstring(inpt)

        for key in keys:
            if type(key) is int:
                loaded = loaded[key]
            else:
                if type(loaded) is list:
                    msg = "value under lens is list, but key was '{}'"
                    raise ValueError(msg.format(key))
                loaded = loaded.findall(key)

                if type(loaded) is list and len(loaded) == 1:
                    loaded = loaded[0]

        if type(loaded) is list:
            dummy = ET.Element("data")
            dummy.append(ET.Comment("Dummy generated by lens"))
            [dummy.append(l) for l in loaded]
            loaded = dummy

        return ET.tostring(loaded)
