<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://raw.githubusercontent.com/bokeh/pm/main/assets/logos/SVG/bokeh-logo-white-text-no-padding.svg">
  <img src="https://raw.githubusercontent.com/bokeh/pm/main/assets/logos/SVG/bokeh-logo-black-text-no-padding.svg" alt="Bokeh logo -- text is white in dark theme and black in light theme" height=60/>
</picture>

----

[Bokeh](https://bokeh.org) is an interactive visualization library for modern web browsers. It provides elegant, concise construction of versatile graphics and affords high-performance interactivity across large or streaming datasets. Bokeh can help anyone who wants to create interactive plots, dashboards, and data applications quickly and easily.

<table>

<tr>

  <td>Package</td>

  <td>
    <img src="https://img.shields.io/pypi/v/bokeh?label=Version&color=ECD078&style=for-the-badge"
         alt="Latest package version" />
  </td>

  <td>
    <a href="https://docs.bokeh.org/en/latest/docs/first_steps/installation.html">
    <img src="https://img.shields.io/pypi/pyversions/bokeh?color=ECD078&style=for-the-badge"
         alt="Supported Python versions" />
    </a>
  </td>

  <td>
    <a href="https://github.com/bokeh/bokeh/blob/main/LICENSE.txt">
    <img src="https://img.shields.io/github/license/bokeh/bokeh.svg?color=ECD078&style=for-the-badge"
         alt="Bokeh license (BSD 3-clause)" />
    </a>
  </td>

</tr>

<tr>

  <td>Project</td>

  <td>
    <img src="https://img.shields.io/github/contributors-anon/bokeh/bokeh?color=ECD078&style=for-the-badge"
         alt="Github contributors" />
  </td>

  <td>
    <a href="https://numfocus.org">
    <img src="https://img.shields.io/badge/sponsor-numfocus-ECD078?style=for-the-badge"
         alt="Link to NumFOCUS" />
    </a>
  </td>

  <td>
    <a href="https://docs.bokeh.org/en/latest/">
    <img src="https://img.shields.io/badge/documentation-latest-ECD078?style=for-the-badge"
         alt="Link to documentation" />
    </a>
  </td>

</tr>

<tr>

  <td>Downloads</td>

  <td>
    <a href="https://docs.bokeh.org/en/latest/docs/first_steps/installation.html">
    <img src="https://img.shields.io/pypi/dm/bokeh?color=D98B43&label=pypi&logo=python&logoColor=yellow&style=for-the-badge"
         alt="PyPI downloads per month" />
    </a>
  </td>

  <td>
    <a href="https://docs.bokeh.org/en/latest/docs/first_steps/installation.html">
    <img src="https://raw.githubusercontent.com/bokeh/badges/main/cache/bokeh-conda-monthly.svg"
         alt="Conda downloads per month" />
    </a>
  </td>

</tr>

<tr>

  <td>Build</td>

  <td>
    <a href="https://github.com/bokeh/bokeh/actions">
    <img src="https://img.shields.io/github/workflow/status/bokeh/bokeh/Bokeh-CI/branch-3.0?label=Bokeh-CI&logo=github&style=for-the-badge"
         alt="Current Bokeh-CI github actions build status" />
    </a>
  </td>

  <td>
    <a href="https://github.com/bokeh/bokeh/actions">
    <img src="https://img.shields.io/github/workflow/status/bokeh/bokeh/BokehJS-CI/branch-3.0?label=BokehJS-CI&logo=github&style=for-the-badge"
         alt="Current BokehJS-CI github actions build status" />
    </a>
  </td>

  <td>
    <a href="https://codecov.io/gh/bokeh/bokeh" >
    <img src="https://img.shields.io/codecov/c/github/bokeh/bokeh?logo=codecov&style=for-the-badge&token=bhEzGkDUaw"
         alt="Codecov coverage percentage" />
    </a>
  </td>

</tr>

<tr>

  <td>Community</td>

  <td>
    <a href="https://discourse.bokeh.org">
    <img src="https://img.shields.io/discourse/https/discourse.bokeh.org/posts.svg?color=blue&logo=discourse&style=for-the-badge"
         alt="Community support on discourse.bokeh.org" />
    </a>
  </td>

  <td>
    <a href="https://stackoverflow.com/questions/tagged/bokeh">
    <img src="https://raw.githubusercontent.com/bokeh/badges/main/cache/bokeh-stackoverflow-total.svg"
         alt="Bokeh-tagged questions on Stack Overflow" />
     </a>
  </td>

  <td>
    <a href="https://twitter.com/bokeh">
    <img src="https://img.shields.io/twitter/follow/bokeh?color=blue&logo=twitter&style=for-the-badge"
         alt="Follow Bokeh on Twitter" />
    </a>
  </td>

</tr>


</table>

*Consider [making a donation](https://opencollective.com/bokeh) if you enjoy using Bokeh and want to support its development.*

![4x9 image grid of Bokeh plots](https://user-images.githubusercontent.com/1078448/190840954-dc243c99-9295-44de-88e9-fafd0f4f7f8a.jpg)

## Installation

To install Bokeh and its required dependencies using `pip`, enter the following command at a Bash or Windows command prompt:
```
pip install bokeh
```

To install `conda`, enter the following command at a Bash or Windows command prompt:

```
conda install bokeh
```

Refer to the [installation documentation](https://docs.bokeh.org/en/latest/docs/first_steps/installation.html) for more details.

## Resources

Once Bokeh is installed, check out the [first steps guides](https://docs.bokeh.org/en/latest/docs/first_steps.html#first-steps-guides).

Visit the [full documentation site](https://docs.bokeh.org) to view the [User's Guide](https://docs.bokeh.org/en/latest/docs/user_guide.html) or [launch the Bokeh tutorial](https://mybinder.org/v2/gh/bokeh/bokeh-notebooks/HEAD?labpath=index.ipynb) to learn about Bokeh in live Jupyter Notebooks.

Community support is available on the [Project Discourse](https://discourse.bokeh.org).

If you would like to contribute to Bokeh, please review the [Contributor Guide](https://docs.bokeh.org/en/latest/docs/dev_guide.html) and [request an invitation to the Bokeh Dev Slack workspace](https://slack-invite.bokeh.org/).

*Note: Everyone who engages in the Bokeh project's discussion forums, codebases, and issue trackers is expected to follow the [Code of Conduct](https://github.com/bokeh/bokeh/blob/branch-3.0/docs/CODE_OF_CONDUCT.md).*

## Follow us

Follow us on Twitter [@bokeh](https://twitter.com/bokeh)

## Support

### Fiscal Support

The Bokeh project is grateful for [individual contributions](https://opencollective.com/bokeh), as well as for monetary support from the organizations and companies listed below:

<table align="center">
<tr>

  <td>
    <a href="https://www.numfocus.org/">
    <img src="https://static.bokeh.org/sponsor/numfocus.svg"
         alt="NumFocus Logo" width="200"/>
    </a>
  </td>

  <td>
    <a href="https://chanzuckerberg.com/">
    <img src="https://static.bokeh.org/sponsor/czi.svg"
         alt="CZI Logo" width="200"/>
    </a>
  </td>

  <td colspan="2">
    <a href="https://www.blackstone.com/the-firm/">
    <img src="https://static.bokeh.org/sponsor/blackstone.png"
         alt="Blackstone Logo" width="400"/>
    </a>
  </td>

 </tr>
 <tr>

  <td>
    <a href="https://tidelift.com/">
    <img src="https://static.bokeh.org/sponsor/tidelift.svg"
         alt="TideLift Logo" width="200"/>
    </a>
  </td>

  <td>
    <a href="https://www.anaconda.com/">
    <img src="https://static.bokeh.org/sponsor/anaconda.png"
         alt="Anaconda Logo" width="200"/>
    </a>
  </td>

  <td>
    <a href="https://www.nvidia.com">
    <img src="https://static.bokeh.org/sponsor/nvidia.png"
         alt="NVidia Logo" width="200"/>
    </a>
  </td>

  <td>
    <a href="https://developer.nvidia.com/rapids">
    <img src="https://static.bokeh.org/sponsor/rapids.png"
         alt="Rapids Logo" width="200"/>
    </a>
  </td>

</tr>
</table>

If your company uses Bokeh and is able to sponsor the project, please contact <a href="info@bokeh.org">info@bokeh.org</a>

*Bokeh is a Sponsored Project of NumFOCUS, a 501(c)(3) nonprofit charity in the United States. NumFOCUS provides Bokeh with fiscal, legal, and administrative support to help ensure the health and sustainability of the project. Visit [numfocus.org](https://numfocus.org) for more information.*

*Donations to Bokeh are managed by NumFOCUS. For donors in the United States, your gift is tax-deductible to the extent provided by law. As with any donation, you should consult with your tax adviser about your particular tax situation.*

### In-kind Support

Non-monetary support can help with development, collaboration, infrastructure, security, and vulnerability management. The Bokeh project is grateful to the following companies for their donation of services:

* [Amazon Web Services](https://aws.amazon.com/)
* [GitGuardian](https://gitguardian.com/)
* [GitHub](https://github.com/)
* [makepath](https://makepath.com/)
* [Pentest Tools](https://pentest-tools.com)
* [Pingdom](https://www.pingdom.com/website-monitoring)
* [Slack](https://slack.com)
* [QuestionScout](https://www.questionscout.com/)
* [1Password](https://1password.com/)
