"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Launcher = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const ui_components_1 = require("@elyra/ui-components");
const launcher_1 = require("@jupyterlab/launcher");
const algorithm_1 = require("@lumino/algorithm");
const React = __importStar(require("react"));
/**
 * The known categories of launcher items and their default ordering.
 */
const ELYRA_CATEGORY = 'Elyra';
const KNOWN_CATEGORIES = ['Notebook', 'Console', ELYRA_CATEGORY, 'Other'];
class Launcher extends launcher_1.Launcher {
    /**
     * Construct a new launcher widget.
     */
    constructor(options) {
        super(options);
    }
    replaceCategoryIcon(category, icon) {
        const children = React.Children.map(category.props.children, child => {
            if (child.props.className === 'jp-Launcher-sectionHeader') {
                const grandchildren = React.Children.map(child.props.children, grandchild => {
                    if (grandchild.props.className !== 'jp-Launcher-sectionTitle') {
                        return jsx_runtime_1.jsx(icon.react, { stylesheet: "launcherSection" }, void 0);
                    }
                    else {
                        return grandchild;
                    }
                });
                return React.cloneElement(child, child.props, grandchildren);
            }
            else {
                return child;
            }
        });
        return React.cloneElement(category, category.props, children);
    }
    /**
     * Render the launcher to virtual DOM nodes.
     */
    render() {
        // Bail if there is no model.
        if (!this.model) {
            return null;
        }
        // get the rendering from JupyterLab Launcher
        // and resort the categories
        const launcherBody = super.render();
        const launcherContent = launcherBody === null || launcherBody === void 0 ? void 0 : launcherBody.props.children;
        const launcherCategories = launcherContent.props.children;
        const categories = [];
        // Assemble the final ordered list of categories
        // based on KNOWN_CATEGORIES.
        algorithm_1.each(KNOWN_CATEGORIES, (category, index) => {
            React.Children.forEach(launcherCategories, cat => {
                if (cat.key === category) {
                    if (cat.key === ELYRA_CATEGORY) {
                        cat = this.replaceCategoryIcon(cat, ui_components_1.elyraIcon);
                    }
                    categories.push(cat);
                }
            });
        });
        // Wrap the sections in body and content divs.
        return (jsx_runtime_1.jsx("div", Object.assign({ className: "jp-Launcher-body" }, { children: jsx_runtime_1.jsxs("div", Object.assign({ className: "jp-Launcher-content" }, { children: [jsx_runtime_1.jsx("div", Object.assign({ className: "jp-Launcher-cwd" }, { children: jsx_runtime_1.jsx("h3", { children: this.cwd }, void 0) }), void 0), categories] }), void 0) }), void 0));
    }
}
exports.Launcher = Launcher;
//# sourceMappingURL=launcher.js.map