# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2016-09-30 18:47
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Album',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('normname', models.CharField(max_length=255)),
                ('year', models.IntegerField(default=0)),
                ('miscellaneous', models.BooleanField(default=False)),
                ('live', models.BooleanField(default=False)),
                ('time_added', models.DateTimeField(default=django.utils.timezone.now)),
                ('art_filename', models.CharField(default=None, max_length=4096, null=True)),
                ('art_mtime', models.IntegerField(default=0, null=True)),
                ('art_ext', models.CharField(default=None, max_length=4, null=True)),
                ('art_mime', models.CharField(default=None, max_length=64, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='AlbumArt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('size', models.CharField(choices=[('album', 'Album Listing'), ('list', 'Inside Lists')], max_length=5)),
                ('resolution', models.PositiveSmallIntegerField(default=0)),
                ('from_mtime', models.IntegerField(default=0)),
                ('image', models.BinaryField()),
                ('album', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='exordium.Album')),
            ],
        ),
        migrations.CreateModel(
            name='Artist',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('normname', models.CharField(max_length=255, unique=True)),
                ('prefix', models.CharField(max_length=32)),
                ('various', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Song',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filename', models.CharField(max_length=4096)),
                ('title', models.CharField(max_length=255)),
                ('normtitle', models.CharField(max_length=255)),
                ('year', models.IntegerField()),
                ('tracknum', models.SmallIntegerField(verbose_name='#')),
                ('raw_artist', models.CharField(max_length=255)),
                ('raw_group', models.CharField(default='', max_length=255)),
                ('raw_composer', models.CharField(default='', max_length=255)),
                ('raw_conductor', models.CharField(default='', max_length=255)),
                ('filetype', models.CharField(choices=[('mp3', 'mp3'), ('ogg', 'ogg')], max_length=3)),
                ('bitrate', models.IntegerField()),
                ('mode', models.CharField(choices=[('ABR', 'ABR'), ('CBR', 'CBR'), ('VBR', 'VBR')], max_length=3)),
                ('size', models.IntegerField()),
                ('length', models.IntegerField()),
                ('time_added', models.DateTimeField(default=django.utils.timezone.now)),
                ('time_updated', models.IntegerField(default=0)),
                ('sha256sum', models.CharField(max_length=64)),
                ('album', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='exordium.Album')),
                ('artist', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='exordium.Artist')),
                ('composer', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='composer_set', to='exordium.Artist')),
                ('conductor', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='conductor_set', to='exordium.Artist')),
                ('group', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='group_set', to='exordium.Artist')),
            ],
        ),
        migrations.AddField(
            model_name='album',
            name='artist',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='exordium.Artist'),
        ),
        migrations.AlterUniqueTogether(
            name='albumart',
            unique_together=set([('album', 'size')]),
        ),
        migrations.AlterUniqueTogether(
            name='album',
            unique_together=set([('artist', 'name')]),
        ),
    ]
