#!/usr/bin/env python3
#
# Copyright (C) 2020 Sébastien Helleu <flashcode@flashtux.org>
#
# This file is part of Tasksched.
#
# Tasksched is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Tasksched is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Tasksched.  If not, see <https://www.gnu.org/licenses/>.
#

"""Tests on export of work plan to text."""

from .utils import get_json_file


def test_workplan_to_text():
    """Test export of work plan to text."""
    from tasksched import workplan_to_text
    workplan = get_json_file('workplan_complete.json')
    text = workplan_to_text(workplan)
    assert '\x1b[0m' in text
    text = workplan_to_text(workplan, use_colors=False)
    assert ('Developer 1 > 2021-01-04   8d  89% ████▊███   '
            'task3, task2') in text
    assert ('Developer 2 > 2021-01-05   9d 100% ████▊█▊██  '
            'task3, task1, task2') in text
    text = workplan_to_text(workplan, use_colors=False, use_unicode=False)
    assert ('Developer 1 > 2021-01-04   8d  89% xxxx|xxx   '
            'task3, task2') in text
    assert ('Developer 2 > 2021-01-05   9d 100% xxxx|x|xx  '
            'task3, task1, task2') in text

    workplan = get_json_file('workplan_complete2.json')
    text = workplan_to_text(workplan)
    assert '\x1b[0m' in text
    text = workplan_to_text(workplan, use_colors=False)
    assert 'Developer 1 > 2020-12-29   5d 100% █████  task1' in text
    assert 'Developer 2 > 2020-12-29   5d 100% █████  task1' in text
    assert 'Developer 3 > 2020-12-23   2d  40% ██     task2' in text
