"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateProfile = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const consts_1 = require("./cluster-resource-handler/consts");
const cluster_resource_provider_1 = require("./cluster-resource-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * Fargate profiles allows an administrator to declare which pods run on
 * Fargate. This declaration is done through the profile’s selectors. Each
 * profile can have up to five selectors that contain a namespace and optional
 * labels. You must define a namespace for every selector. The label field
 * consists of multiple optional key-value pairs. Pods that match a selector (by
 * matching a namespace for the selector and all of the labels specified in the
 * selector) are scheduled on Fargate. If a namespace selector is defined
 * without any labels, Amazon EKS will attempt to schedule all pods that run in
 * that namespace onto Fargate using the profile. If a to-be-scheduled pod
 * matches any of the selectors in the Fargate profile, then that pod is
 * scheduled on Fargate.
 *
 * If a pod matches multiple Fargate profiles, Amazon EKS picks one of the
 * matches at random. In this case, you can specify which profile a pod should
 * use by adding the following Kubernetes label to the pod specification:
 * eks.amazonaws.com/fargate-profile: profile_name. However, the pod must still
 * match a selector in that profile in order to be scheduled onto Fargate.
 */
class FargateProfile extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_FargateProfileProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FargateProfile);
            }
            throw error;
        }
        const provider = cluster_resource_provider_1.ClusterResourceProvider.getOrCreate(this, {
            adminRole: props.cluster.adminRole,
            onEventLayer: props.cluster.onEventLayer,
        });
        this.podExecutionRole = props.podExecutionRole ?? new iam.Role(this, 'PodExecutionRole', {
            assumedBy: new iam.ServicePrincipal('eks-fargate-pods.amazonaws.com'),
            managedPolicies: [iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSFargatePodExecutionRolePolicy')],
        });
        this.podExecutionRole.grantPassRole(props.cluster.adminRole);
        if (props.subnetSelection && !props.vpc) {
            core_1.Annotations.of(this).addWarning('Vpc must be defined to use a custom subnet selection. All private subnets belonging to the EKS cluster will be used by default');
        }
        let subnets;
        if (props.vpc) {
            const selection = props.subnetSelection ?? { subnetType: ec2.SubnetType.PRIVATE_WITH_NAT };
            subnets = props.vpc.selectSubnets(selection).subnetIds;
        }
        if (props.selectors.length < 1) {
            throw new Error('Fargate profile requires at least one selector');
        }
        if (props.selectors.length > 5) {
            throw new Error('Fargate profile supports up to five selectors');
        }
        this.tags = new core_1.TagManager(core_1.TagType.MAP, 'AWS::EKS::FargateProfile');
        const resource = new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: consts_1.FARGATE_PROFILE_RESOURCE_TYPE,
            properties: {
                AssumeRoleArn: props.cluster.adminRole.roleArn,
                Config: {
                    clusterName: props.cluster.clusterName,
                    fargateProfileName: props.fargateProfileName,
                    podExecutionRoleArn: this.podExecutionRole.roleArn,
                    selectors: props.selectors,
                    subnets,
                    tags: core_1.Lazy.any({ produce: () => this.tags.renderTags() }),
                },
            },
        });
        this.fargateProfileArn = resource.getAttString('fargateProfileArn');
        this.fargateProfileName = resource.ref;
        // Fargate profiles must be created sequentially. If other profile(s) already
        // exist on the same cluster, create a dependency to force sequential creation.
        const clusterFargateProfiles = props.cluster._attachFargateProfile(this);
        if (clusterFargateProfiles.length > 1) {
            const previousProfile = clusterFargateProfiles[clusterFargateProfiles.length - 2];
            resource.node.addDependency(previousProfile);
        }
        // map the fargate pod execution role to the relevant groups in rbac
        // see https://github.com/aws/aws-cdk/issues/7981
        props.cluster.awsAuth.addRoleMapping(this.podExecutionRole, {
            username: 'system:node:{{SessionName}}',
            groups: [
                'system:bootstrappers',
                'system:nodes',
                'system:node-proxier',
            ],
        });
    }
}
exports.FargateProfile = FargateProfile;
_a = JSII_RTTI_SYMBOL_1;
FargateProfile[_a] = { fqn: "@aws-cdk/aws-eks.FargateProfile", version: "1.174.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmFyZ2F0ZS1wcm9maWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZmFyZ2F0ZS1wcm9maWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHdDQUF3QztBQUN4Qyx3Q0FBd0M7QUFDeEMsd0NBQWtHO0FBR2xHLDhEQUFrRjtBQUNsRiwyRUFBc0U7QUFFdEUsZ0hBQWdIO0FBQ2hILDJCQUEyQjtBQUMzQix3Q0FBMkQ7QUF3RjNEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FrQkc7QUFDSCxNQUFhLGNBQWUsU0FBUSxnQkFBYTtJQTZCL0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjtRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBOUJSLGNBQWM7Ozs7UUFnQ3ZCLE1BQU0sUUFBUSxHQUFHLG1EQUF1QixDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUU7WUFDekQsU0FBUyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsU0FBUztZQUNsQyxZQUFZLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxZQUFZO1NBQ3pDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLElBQUksSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxrQkFBa0IsRUFBRTtZQUN2RixTQUFTLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsZ0NBQWdDLENBQUM7WUFDckUsZUFBZSxFQUFFLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyx3QkFBd0IsQ0FBQyx3Q0FBd0MsQ0FBQyxDQUFDO1NBQ3hHLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUU3RCxJQUFJLEtBQUssQ0FBQyxlQUFlLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFO1lBQ3ZDLGtCQUFXLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnSUFBZ0ksQ0FBQyxDQUFDO1NBQ25LO1FBRUQsSUFBSSxPQUE2QixDQUFDO1FBQ2xDLElBQUksS0FBSyxDQUFDLEdBQUcsRUFBRTtZQUNiLE1BQU0sU0FBUyxHQUF3QixLQUFLLENBQUMsZUFBZSxJQUFJLEVBQUUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztZQUNoSCxPQUFPLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLENBQUMsU0FBUyxDQUFDO1NBQ3hEO1FBRUQsSUFBSSxLQUFLLENBQUMsU0FBUyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDOUIsTUFBTSxJQUFJLEtBQUssQ0FBQyxnREFBZ0QsQ0FBQyxDQUFDO1NBQ25FO1FBRUQsSUFBSSxLQUFLLENBQUMsU0FBUyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDOUIsTUFBTSxJQUFJLEtBQUssQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO1NBQ2xFO1FBRUQsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLGlCQUFVLENBQUMsY0FBTyxDQUFDLEdBQUcsRUFBRSwwQkFBMEIsQ0FBQyxDQUFDO1FBRXBFLE1BQU0sUUFBUSxHQUFHLElBQUkscUJBQWMsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3BELFlBQVksRUFBRSxRQUFRLENBQUMsWUFBWTtZQUNuQyxZQUFZLEVBQUUsc0NBQTZCO1lBQzNDLFVBQVUsRUFBRTtnQkFDVixhQUFhLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsT0FBTztnQkFDOUMsTUFBTSxFQUFFO29CQUNOLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFdBQVc7b0JBQ3RDLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7b0JBQzVDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPO29CQUNsRCxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7b0JBQzFCLE9BQU87b0JBQ1AsSUFBSSxFQUFFLFdBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsRUFBRSxDQUFDO2lCQUMxRDthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFFBQVEsQ0FBQyxZQUFZLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUNwRSxJQUFJLENBQUMsa0JBQWtCLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztRQUV2Qyw2RUFBNkU7UUFDN0UsK0VBQStFO1FBQy9FLE1BQU0sc0JBQXNCLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN6RSxJQUFJLHNCQUFzQixDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDckMsTUFBTSxlQUFlLEdBQUcsc0JBQXNCLENBQUMsc0JBQXNCLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQ2xGLFFBQVEsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1NBQzlDO1FBRUQsb0VBQW9FO1FBQ3BFLGlEQUFpRDtRQUNqRCxLQUFLLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLGdCQUFnQixFQUFFO1lBQzFELFFBQVEsRUFBRSw2QkFBNkI7WUFDdkMsTUFBTSxFQUFFO2dCQUNOLHNCQUFzQjtnQkFDdEIsY0FBYztnQkFDZCxxQkFBcUI7YUFDdEI7U0FDRixDQUFDLENBQUM7S0FDSjs7QUFyR0gsd0NBc0dDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZWMyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgQW5ub3RhdGlvbnMsIEN1c3RvbVJlc291cmNlLCBJVGFnZ2FibGUsIExhenksIFRhZ01hbmFnZXIsIFRhZ1R5cGUgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2x1c3RlciB9IGZyb20gJy4vY2x1c3Rlcic7XG5pbXBvcnQgeyBGQVJHQVRFX1BST0ZJTEVfUkVTT1VSQ0VfVFlQRSB9IGZyb20gJy4vY2x1c3Rlci1yZXNvdXJjZS1oYW5kbGVyL2NvbnN0cyc7XG5pbXBvcnQgeyBDbHVzdGVyUmVzb3VyY2VQcm92aWRlciB9IGZyb20gJy4vY2x1c3Rlci1yZXNvdXJjZS1wcm92aWRlcic7XG5cbi8vIHYyIC0ga2VlcCB0aGlzIGltcG9ydCBhcyBhIHNlcGFyYXRlIHNlY3Rpb24gdG8gcmVkdWNlIG1lcmdlIGNvbmZsaWN0IHdoZW4gZm9yd2FyZCBtZXJnaW5nIHdpdGggdGhlIHYyIGJyYW5jaC5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZVxuaW1wb3J0IHsgQ29uc3RydWN0IGFzIENvcmVDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuLyoqXG4gKiBPcHRpb25zIGZvciBkZWZpbmluZyBFS1MgRmFyZ2F0ZSBQcm9maWxlcy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBGYXJnYXRlUHJvZmlsZU9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIEZhcmdhdGUgcHJvZmlsZS5cbiAgICogQGRlZmF1bHQgLSBnZW5lcmF0ZWRcbiAgICovXG4gIHJlYWRvbmx5IGZhcmdhdGVQcm9maWxlTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHBvZCBleGVjdXRpb24gcm9sZSB0byB1c2UgZm9yIHBvZHMgdGhhdCBtYXRjaCB0aGUgc2VsZWN0b3JzIGluIHRoZVxuICAgKiBGYXJnYXRlIHByb2ZpbGUuIFRoZSBwb2QgZXhlY3V0aW9uIHJvbGUgYWxsb3dzIEZhcmdhdGUgaW5mcmFzdHJ1Y3R1cmUgdG9cbiAgICogcmVnaXN0ZXIgd2l0aCB5b3VyIGNsdXN0ZXIgYXMgYSBub2RlLCBhbmQgaXQgcHJvdmlkZXMgcmVhZCBhY2Nlc3MgdG8gQW1hem9uXG4gICAqIEVDUiBpbWFnZSByZXBvc2l0b3JpZXMuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Vrcy9sYXRlc3QvdXNlcmd1aWRlL3BvZC1leGVjdXRpb24tcm9sZS5odG1sXG4gICAqIEBkZWZhdWx0IC0gYSByb2xlIHdpbGwgYmUgYXV0b21hdGljYWxseSBjcmVhdGVkXG4gICAqL1xuICByZWFkb25seSBwb2RFeGVjdXRpb25Sb2xlPzogaWFtLklSb2xlO1xuXG4gIC8qKlxuICAgKiBUaGUgc2VsZWN0b3JzIHRvIG1hdGNoIGZvciBwb2RzIHRvIHVzZSB0aGlzIEZhcmdhdGUgcHJvZmlsZS4gRWFjaCBzZWxlY3RvclxuICAgKiBtdXN0IGhhdmUgYW4gYXNzb2NpYXRlZCBuYW1lc3BhY2UuIE9wdGlvbmFsbHksIHlvdSBjYW4gYWxzbyBzcGVjaWZ5IGxhYmVsc1xuICAgKiBmb3IgYSBuYW1lc3BhY2UuXG4gICAqXG4gICAqIEF0IGxlYXN0IG9uZSBzZWxlY3RvciBpcyByZXF1aXJlZCBhbmQgeW91IG1heSBzcGVjaWZ5IHVwIHRvIGZpdmUgc2VsZWN0b3JzLlxuICAgKi9cbiAgcmVhZG9ubHkgc2VsZWN0b3JzOiBTZWxlY3RvcltdO1xuXG4gIC8qKlxuICAgKiBUaGUgVlBDIGZyb20gd2hpY2ggdG8gc2VsZWN0IHN1Ym5ldHMgdG8gbGF1bmNoIHlvdXIgcG9kcyBpbnRvLlxuICAgKlxuICAgKiBCeSBkZWZhdWx0LCBhbGwgcHJpdmF0ZSBzdWJuZXRzIGFyZSBzZWxlY3RlZC4gWW91IGNhbiBjdXN0b21pemUgdGhpcyB1c2luZ1xuICAgKiBgc3VibmV0U2VsZWN0aW9uYC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBhbGwgcHJpdmF0ZSBzdWJuZXRzIHVzZWQgYnkgdGhlIEVLUyBjbHVzdGVyXG4gICAqL1xuICByZWFkb25seSB2cGM/OiBlYzIuSVZwYztcblxuICAvKipcbiAgICogU2VsZWN0IHdoaWNoIHN1Ym5ldHMgdG8gbGF1bmNoIHlvdXIgcG9kcyBpbnRvLiBBdCB0aGlzIHRpbWUsIHBvZHMgcnVubmluZ1xuICAgKiBvbiBGYXJnYXRlIGFyZSBub3QgYXNzaWduZWQgcHVibGljIElQIGFkZHJlc3Nlcywgc28gb25seSBwcml2YXRlIHN1Ym5ldHNcbiAgICogKHdpdGggbm8gZGlyZWN0IHJvdXRlIHRvIGFuIEludGVybmV0IEdhdGV3YXkpIGFyZSBhbGxvd2VkLlxuICAgKlxuICAgKiBZb3UgbXVzdCBzcGVjaWZ5IHRoZSBWUEMgdG8gY3VzdG9taXplIHRoZSBzdWJuZXQgc2VsZWN0aW9uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gYWxsIHByaXZhdGUgc3VibmV0cyBvZiB0aGUgVlBDIGFyZSBzZWxlY3RlZC5cbiAgICovXG4gIHJlYWRvbmx5IHN1Ym5ldFNlbGVjdGlvbj86IGVjMi5TdWJuZXRTZWxlY3Rpb247XG59XG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBwcm9wcyBmb3IgRUtTIEZhcmdhdGUgUHJvZmlsZXMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRmFyZ2F0ZVByb2ZpbGVQcm9wcyBleHRlbmRzIEZhcmdhdGVQcm9maWxlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgRUtTIGNsdXN0ZXIgdG8gYXBwbHkgdGhlIEZhcmdhdGUgcHJvZmlsZSB0by5cbiAgICogW2Rpc2FibGUtYXdzbGludDpyZWYtdmlhLWludGVyZmFjZV1cbiAgICovXG4gIHJlYWRvbmx5IGNsdXN0ZXI6IENsdXN0ZXI7XG59XG5cbi8qKlxuICogRmFyZ2F0ZSBwcm9maWxlIHNlbGVjdG9yLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNlbGVjdG9yIHtcbiAgLyoqXG4gICAqIFRoZSBLdWJlcm5ldGVzIG5hbWVzcGFjZSB0aGF0IHRoZSBzZWxlY3RvciBzaG91bGQgbWF0Y2guXG4gICAqXG4gICAqIFlvdSBtdXN0IHNwZWNpZnkgYSBuYW1lc3BhY2UgZm9yIGEgc2VsZWN0b3IuIFRoZSBzZWxlY3RvciBvbmx5IG1hdGNoZXMgcG9kc1xuICAgKiB0aGF0IGFyZSBjcmVhdGVkIGluIHRoaXMgbmFtZXNwYWNlLCBidXQgeW91IGNhbiBjcmVhdGUgbXVsdGlwbGUgc2VsZWN0b3JzXG4gICAqIHRvIHRhcmdldCBtdWx0aXBsZSBuYW1lc3BhY2VzLlxuICAgKi9cbiAgcmVhZG9ubHkgbmFtZXNwYWNlOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBLdWJlcm5ldGVzIGxhYmVscyB0aGF0IHRoZSBzZWxlY3RvciBzaG91bGQgbWF0Y2guIEEgcG9kIG11c3QgY29udGFpblxuICAgKiBhbGwgb2YgdGhlIGxhYmVscyB0aGF0IGFyZSBzcGVjaWZpZWQgaW4gdGhlIHNlbGVjdG9yIGZvciBpdCB0byBiZVxuICAgKiBjb25zaWRlcmVkIGEgbWF0Y2guXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gYWxsIHBvZHMgd2l0aGluIHRoZSBuYW1lc3BhY2Ugd2lsbCBiZSBzZWxlY3RlZC5cbiAgICovXG4gIHJlYWRvbmx5IGxhYmVscz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG59XG5cbi8qKlxuICogRmFyZ2F0ZSBwcm9maWxlcyBhbGxvd3MgYW4gYWRtaW5pc3RyYXRvciB0byBkZWNsYXJlIHdoaWNoIHBvZHMgcnVuIG9uXG4gKiBGYXJnYXRlLiBUaGlzIGRlY2xhcmF0aW9uIGlzIGRvbmUgdGhyb3VnaCB0aGUgcHJvZmlsZeKAmXMgc2VsZWN0b3JzLiBFYWNoXG4gKiBwcm9maWxlIGNhbiBoYXZlIHVwIHRvIGZpdmUgc2VsZWN0b3JzIHRoYXQgY29udGFpbiBhIG5hbWVzcGFjZSBhbmQgb3B0aW9uYWxcbiAqIGxhYmVscy4gWW91IG11c3QgZGVmaW5lIGEgbmFtZXNwYWNlIGZvciBldmVyeSBzZWxlY3Rvci4gVGhlIGxhYmVsIGZpZWxkXG4gKiBjb25zaXN0cyBvZiBtdWx0aXBsZSBvcHRpb25hbCBrZXktdmFsdWUgcGFpcnMuIFBvZHMgdGhhdCBtYXRjaCBhIHNlbGVjdG9yIChieVxuICogbWF0Y2hpbmcgYSBuYW1lc3BhY2UgZm9yIHRoZSBzZWxlY3RvciBhbmQgYWxsIG9mIHRoZSBsYWJlbHMgc3BlY2lmaWVkIGluIHRoZVxuICogc2VsZWN0b3IpIGFyZSBzY2hlZHVsZWQgb24gRmFyZ2F0ZS4gSWYgYSBuYW1lc3BhY2Ugc2VsZWN0b3IgaXMgZGVmaW5lZFxuICogd2l0aG91dCBhbnkgbGFiZWxzLCBBbWF6b24gRUtTIHdpbGwgYXR0ZW1wdCB0byBzY2hlZHVsZSBhbGwgcG9kcyB0aGF0IHJ1biBpblxuICogdGhhdCBuYW1lc3BhY2Ugb250byBGYXJnYXRlIHVzaW5nIHRoZSBwcm9maWxlLiBJZiBhIHRvLWJlLXNjaGVkdWxlZCBwb2RcbiAqIG1hdGNoZXMgYW55IG9mIHRoZSBzZWxlY3RvcnMgaW4gdGhlIEZhcmdhdGUgcHJvZmlsZSwgdGhlbiB0aGF0IHBvZCBpc1xuICogc2NoZWR1bGVkIG9uIEZhcmdhdGUuXG4gKlxuICogSWYgYSBwb2QgbWF0Y2hlcyBtdWx0aXBsZSBGYXJnYXRlIHByb2ZpbGVzLCBBbWF6b24gRUtTIHBpY2tzIG9uZSBvZiB0aGVcbiAqIG1hdGNoZXMgYXQgcmFuZG9tLiBJbiB0aGlzIGNhc2UsIHlvdSBjYW4gc3BlY2lmeSB3aGljaCBwcm9maWxlIGEgcG9kIHNob3VsZFxuICogdXNlIGJ5IGFkZGluZyB0aGUgZm9sbG93aW5nIEt1YmVybmV0ZXMgbGFiZWwgdG8gdGhlIHBvZCBzcGVjaWZpY2F0aW9uOlxuICogZWtzLmFtYXpvbmF3cy5jb20vZmFyZ2F0ZS1wcm9maWxlOiBwcm9maWxlX25hbWUuIEhvd2V2ZXIsIHRoZSBwb2QgbXVzdCBzdGlsbFxuICogbWF0Y2ggYSBzZWxlY3RvciBpbiB0aGF0IHByb2ZpbGUgaW4gb3JkZXIgdG8gYmUgc2NoZWR1bGVkIG9udG8gRmFyZ2F0ZS5cbiAqL1xuZXhwb3J0IGNsYXNzIEZhcmdhdGVQcm9maWxlIGV4dGVuZHMgQ29yZUNvbnN0cnVjdCBpbXBsZW1lbnRzIElUYWdnYWJsZSB7XG5cbiAgLyoqXG4gICAqIFRoZSBmdWxsIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBGYXJnYXRlIHByb2ZpbGUuXG4gICAqXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBmYXJnYXRlUHJvZmlsZUFybjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgRmFyZ2F0ZSBwcm9maWxlLlxuICAgKlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgZmFyZ2F0ZVByb2ZpbGVOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFJlc291cmNlIHRhZ3MuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdGFnczogVGFnTWFuYWdlcjtcblxuICAvKipcbiAgICogVGhlIHBvZCBleGVjdXRpb24gcm9sZSB0byB1c2UgZm9yIHBvZHMgdGhhdCBtYXRjaCB0aGUgc2VsZWN0b3JzIGluIHRoZVxuICAgKiBGYXJnYXRlIHByb2ZpbGUuIFRoZSBwb2QgZXhlY3V0aW9uIHJvbGUgYWxsb3dzIEZhcmdhdGUgaW5mcmFzdHJ1Y3R1cmUgdG9cbiAgICogcmVnaXN0ZXIgd2l0aCB5b3VyIGNsdXN0ZXIgYXMgYSBub2RlLCBhbmQgaXQgcHJvdmlkZXMgcmVhZCBhY2Nlc3MgdG8gQW1hem9uXG4gICAqIEVDUiBpbWFnZSByZXBvc2l0b3JpZXMuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcG9kRXhlY3V0aW9uUm9sZTogaWFtLklSb2xlO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBGYXJnYXRlUHJvZmlsZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHByb3ZpZGVyID0gQ2x1c3RlclJlc291cmNlUHJvdmlkZXIuZ2V0T3JDcmVhdGUodGhpcywge1xuICAgICAgYWRtaW5Sb2xlOiBwcm9wcy5jbHVzdGVyLmFkbWluUm9sZSxcbiAgICAgIG9uRXZlbnRMYXllcjogcHJvcHMuY2x1c3Rlci5vbkV2ZW50TGF5ZXIsXG4gICAgfSk7XG5cbiAgICB0aGlzLnBvZEV4ZWN1dGlvblJvbGUgPSBwcm9wcy5wb2RFeGVjdXRpb25Sb2xlID8/IG5ldyBpYW0uUm9sZSh0aGlzLCAnUG9kRXhlY3V0aW9uUm9sZScsIHtcbiAgICAgIGFzc3VtZWRCeTogbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdla3MtZmFyZ2F0ZS1wb2RzLmFtYXpvbmF3cy5jb20nKSxcbiAgICAgIG1hbmFnZWRQb2xpY2llczogW2lhbS5NYW5hZ2VkUG9saWN5LmZyb21Bd3NNYW5hZ2VkUG9saWN5TmFtZSgnQW1hem9uRUtTRmFyZ2F0ZVBvZEV4ZWN1dGlvblJvbGVQb2xpY3knKV0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnBvZEV4ZWN1dGlvblJvbGUuZ3JhbnRQYXNzUm9sZShwcm9wcy5jbHVzdGVyLmFkbWluUm9sZSk7XG5cbiAgICBpZiAocHJvcHMuc3VibmV0U2VsZWN0aW9uICYmICFwcm9wcy52cGMpIHtcbiAgICAgIEFubm90YXRpb25zLm9mKHRoaXMpLmFkZFdhcm5pbmcoJ1ZwYyBtdXN0IGJlIGRlZmluZWQgdG8gdXNlIGEgY3VzdG9tIHN1Ym5ldCBzZWxlY3Rpb24uIEFsbCBwcml2YXRlIHN1Ym5ldHMgYmVsb25naW5nIHRvIHRoZSBFS1MgY2x1c3RlciB3aWxsIGJlIHVzZWQgYnkgZGVmYXVsdCcpO1xuICAgIH1cblxuICAgIGxldCBzdWJuZXRzOiBzdHJpbmdbXSB8IHVuZGVmaW5lZDtcbiAgICBpZiAocHJvcHMudnBjKSB7XG4gICAgICBjb25zdCBzZWxlY3Rpb246IGVjMi5TdWJuZXRTZWxlY3Rpb24gPSBwcm9wcy5zdWJuZXRTZWxlY3Rpb24gPz8geyBzdWJuZXRUeXBlOiBlYzIuU3VibmV0VHlwZS5QUklWQVRFX1dJVEhfTkFUIH07XG4gICAgICBzdWJuZXRzID0gcHJvcHMudnBjLnNlbGVjdFN1Ym5ldHMoc2VsZWN0aW9uKS5zdWJuZXRJZHM7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLnNlbGVjdG9ycy5sZW5ndGggPCAxKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0ZhcmdhdGUgcHJvZmlsZSByZXF1aXJlcyBhdCBsZWFzdCBvbmUgc2VsZWN0b3InKTtcbiAgICB9XG5cbiAgICBpZiAocHJvcHMuc2VsZWN0b3JzLmxlbmd0aCA+IDUpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignRmFyZ2F0ZSBwcm9maWxlIHN1cHBvcnRzIHVwIHRvIGZpdmUgc2VsZWN0b3JzJyk7XG4gICAgfVxuXG4gICAgdGhpcy50YWdzID0gbmV3IFRhZ01hbmFnZXIoVGFnVHlwZS5NQVAsICdBV1M6OkVLUzo6RmFyZ2F0ZVByb2ZpbGUnKTtcblxuICAgIGNvbnN0IHJlc291cmNlID0gbmV3IEN1c3RvbVJlc291cmNlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIHNlcnZpY2VUb2tlbjogcHJvdmlkZXIuc2VydmljZVRva2VuLFxuICAgICAgcmVzb3VyY2VUeXBlOiBGQVJHQVRFX1BST0ZJTEVfUkVTT1VSQ0VfVFlQRSxcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgQXNzdW1lUm9sZUFybjogcHJvcHMuY2x1c3Rlci5hZG1pblJvbGUucm9sZUFybixcbiAgICAgICAgQ29uZmlnOiB7XG4gICAgICAgICAgY2x1c3Rlck5hbWU6IHByb3BzLmNsdXN0ZXIuY2x1c3Rlck5hbWUsXG4gICAgICAgICAgZmFyZ2F0ZVByb2ZpbGVOYW1lOiBwcm9wcy5mYXJnYXRlUHJvZmlsZU5hbWUsXG4gICAgICAgICAgcG9kRXhlY3V0aW9uUm9sZUFybjogdGhpcy5wb2RFeGVjdXRpb25Sb2xlLnJvbGVBcm4sXG4gICAgICAgICAgc2VsZWN0b3JzOiBwcm9wcy5zZWxlY3RvcnMsXG4gICAgICAgICAgc3VibmV0cyxcbiAgICAgICAgICB0YWdzOiBMYXp5LmFueSh7IHByb2R1Y2U6ICgpID0+IHRoaXMudGFncy5yZW5kZXJUYWdzKCkgfSksXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgdGhpcy5mYXJnYXRlUHJvZmlsZUFybiA9IHJlc291cmNlLmdldEF0dFN0cmluZygnZmFyZ2F0ZVByb2ZpbGVBcm4nKTtcbiAgICB0aGlzLmZhcmdhdGVQcm9maWxlTmFtZSA9IHJlc291cmNlLnJlZjtcblxuICAgIC8vIEZhcmdhdGUgcHJvZmlsZXMgbXVzdCBiZSBjcmVhdGVkIHNlcXVlbnRpYWxseS4gSWYgb3RoZXIgcHJvZmlsZShzKSBhbHJlYWR5XG4gICAgLy8gZXhpc3Qgb24gdGhlIHNhbWUgY2x1c3RlciwgY3JlYXRlIGEgZGVwZW5kZW5jeSB0byBmb3JjZSBzZXF1ZW50aWFsIGNyZWF0aW9uLlxuICAgIGNvbnN0IGNsdXN0ZXJGYXJnYXRlUHJvZmlsZXMgPSBwcm9wcy5jbHVzdGVyLl9hdHRhY2hGYXJnYXRlUHJvZmlsZSh0aGlzKTtcbiAgICBpZiAoY2x1c3RlckZhcmdhdGVQcm9maWxlcy5sZW5ndGggPiAxKSB7XG4gICAgICBjb25zdCBwcmV2aW91c1Byb2ZpbGUgPSBjbHVzdGVyRmFyZ2F0ZVByb2ZpbGVzW2NsdXN0ZXJGYXJnYXRlUHJvZmlsZXMubGVuZ3RoIC0gMl07XG4gICAgICByZXNvdXJjZS5ub2RlLmFkZERlcGVuZGVuY3kocHJldmlvdXNQcm9maWxlKTtcbiAgICB9XG5cbiAgICAvLyBtYXAgdGhlIGZhcmdhdGUgcG9kIGV4ZWN1dGlvbiByb2xlIHRvIHRoZSByZWxldmFudCBncm91cHMgaW4gcmJhY1xuICAgIC8vIHNlZSBodHRwczovL2dpdGh1Yi5jb20vYXdzL2F3cy1jZGsvaXNzdWVzLzc5ODFcbiAgICBwcm9wcy5jbHVzdGVyLmF3c0F1dGguYWRkUm9sZU1hcHBpbmcodGhpcy5wb2RFeGVjdXRpb25Sb2xlLCB7XG4gICAgICB1c2VybmFtZTogJ3N5c3RlbTpub2RlOnt7U2Vzc2lvbk5hbWV9fScsXG4gICAgICBncm91cHM6IFtcbiAgICAgICAgJ3N5c3RlbTpib290c3RyYXBwZXJzJyxcbiAgICAgICAgJ3N5c3RlbTpub2RlcycsXG4gICAgICAgICdzeXN0ZW06bm9kZS1wcm94aWVyJyxcbiAgICAgIF0sXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==