#pragma once

struct netIdName
{
	char name[30];
	int  id;
	int  vnetOffset;
};

struct keyNetIdName
{
	char name[30];
	int  protocol;
	int id;
};

const struct netIdName networkNames[] = { { "neoVI", 0, 0 },
{ "HS CAN", 1, 1},
{ "MS CAN", 2, 2},
{ "SW CAN", 3, 3},
{ "LSFT CAN", 4, 4},
{ "FORDSCP", 5, 5},
{ "J1708", 6, 6},
{ "AUX", 7, 7},
{ "J1850 VPW", 8, 8},
{ "ISO", 9, 9},
{ "ISOPIC", 10, 10},
{ "MAIN51", 11, 11},
{ "RED", 12, 12},
{ "SCI", 13, 13},
{ "ISO2", 14, 14},
{ "ISO14230", 15, 15},
{ "LIN", 16, 16},
{ "OP (BR) ETH1", 17, 0},
{ "OP (BR) ETH2", 18, 0},
{ "OP (BR) ETH3", 19, 0},
{ "ISO3", 41, 17},
{ "HS CAN2", 42, 18},
{ "HS CAN3", 44, 19},
{ "OP (BR) ETH4", 45, 0},
{ "OP (BR) ETH5", 46, 0},
{ "ISO4", 47, 20},
{ "LIN2", 48, 21},
{ "LIN3", 49, 22},
{ "LIN4", 50, 23},
{ "MOST", 51, 24},
{ "RED_APP_ERROR", 52, 46},
{ "CGI", 53, 25},
{ "3G_RESET_STATUS", 54, 0},
{ "3G_FB_STATUS", 55, 0},
{ "3G_APP_SIGNAL_STATUS", 56, 0},
{ "3G_READ_DATALINK_CM_TX_MSG", 57, 0},
{ "3G_READ_DATALINK_CM_RX_MSG", 58, 0},
{ "3G_LOGGING_OVERFLOW", 59, 0},
{ "3G_READ_SETTINGS_EX", 60, 0},
{ "HS CAN4", 61, 32},
{ "HS CAN5", 62, 33},
{ "RS232", 63, 34},
{ "UART", 64, 35},
{ "UART2", 65, 36},
{ "UART3", 66, 37},
{ "UART4", 67, 38},
{ "SW CAN2", 68, 39},
{ "Ethernet DAQ", 69, 45},
{ "DATA_TO_HOST", 70},
{ "I2C1", 71, 26},
{ "SPI1", 72, 27},
{ "OP (BR) ETH6", 73, 0},
{ "RED_VBAT", 74, 0},
{ "OP (BR) ETH7", 75, 0},
{ "OP (BR) ETH8", 76, 0},
{ "OP (BR) ETH9", 77, 0},
{ "OP (BR) ETH10", 78, 0},
{ "OP (BR) ETH11", 79, 0},
{ "FlexRay1A", 80, 28},
{ "FlexRay1B", 81, 40},
{ "FlexRay2A", 82, 41},
{ "FlexRay2B", 83, 42},
{ "LIN5", 84, 43},
{ "FlexRay", 85, 0},
{ "FlexRay2", 86, 0},
{ "OP (BR) ETH12", 87, 0},
{ "MOST25", 90, 29},
{ "MOST50", 91, 30},
{ "MOST150", 92, 31},
{ "Ethernet", 93, 44},
{ "GMFSA", 94, 0},
{ "TCP", 95, 0},
{ "HS CAN6", 96, 47},
{ "HS CAN7", 97, 48},
{ "LIN6", 98, 49},
{ "LSFT CAN2", 99, 50 },
{ "Ethernet2", 520, 44} };

const keyNetIdName keyBasedNetworkNames[] = { { "HS CAN", SPY_PROTOCOL_CAN},
{ "MS CAN", SPY_PROTOCOL_CAN},
{ "SW CAN", SPY_PROTOCOL_CAN},
{ "J1850 VPW", SPY_PROTOCOL_J1850VPW},
{ "ISO9141/KW2K", SPY_PROTOCOL_Keyword2000},
{ "LSFT CAN", SPY_PROTOCOL_CAN},
{ "J1850 PWM", SPY_PROTOCOL_J1850PWM},
{ "J1708", SPY_PROTOCOL_J1708},
{ "neoVI", SPY_PROTOCOL_CAN },
{ "HS CAN2", SPY_PROTOCOL_CAN},
{ "HS CAN3", SPY_PROTOCOL_CAN},
{ "LIN2", SPY_PROTOCOL_LIN},
{ "LIN3", SPY_PROTOCOL_LIN},
{ "LIN4", SPY_PROTOCOL_LIN},
{ "CGI", SPY_PROTOCOL_CGI},
{ "LIN", SPY_PROTOCOL_LIN},
{ "ISO9141/KW2K 2", SPY_PROTOCOL_Keyword2000},
{ "ISO9141/KW2K 3", SPY_PROTOCOL_Keyword2000},
{ "ISO9141/KW2K 4", SPY_PROTOCOL_Keyword2000},
{ "HS CAN4", SPY_PROTOCOL_CAN},
{ "HS CAN5", SPY_PROTOCOL_CAN},
{ "UART", SPY_PROTOCOL_UART},
{ "UART2", SPY_PROTOCOL_UART},
{ "LIN5", SPY_PROTOCOL_LIN},
{ "MOST (VNET A)", SPY_PROTOCOL_MOST},
{ "FlexRay1A (VNET A)", SPY_PROTOCOL_FLEXRAY},
{ "FlexRay1B (VNET A)", SPY_PROTOCOL_FLEXRAY},
{ "FlexRay2A (VNET A)", SPY_PROTOCOL_FLEXRAY},
{ "FlexRay2B (VNET A)", SPY_PROTOCOL_FLEXRAY},
{ "HS CAN (VNET A)", SPY_PROTOCOL_CAN},
{ "MS CAN (VNET A)", SPY_PROTOCOL_CAN},
{ "SW CAN (VNET A)", SPY_PROTOCOL_CAN},
{ "J1850 VPW (VNET A)", SPY_PROTOCOL_J1850VPW},
{ "LSFT CAN (VNET A)", SPY_PROTOCOL_CAN},
{ "J1708 (VNET A)", SPY_PROTOCOL_J1708},
{ "neoVI (VNET A)", SPY_PROTOCOL_CAN },
{ "HS CAN2 (VNET A)", SPY_PROTOCOL_CAN},
{ "HS CAN3 (VNET A)", SPY_PROTOCOL_CAN},
{ "LIN (VNET A)", SPY_PROTOCOL_LIN},
{ "LIN2 (VNET A)", SPY_PROTOCOL_LIN},
{ "LIN3 (VNET A)", SPY_PROTOCOL_LIN},
{ "LIN4 (VNET A)", SPY_PROTOCOL_LIN},
{ "CGI (VNET A)", SPY_PROTOCOL_CGI},
{ "ISO9141/KW2K (VNET A)", SPY_PROTOCOL_Keyword2000},
{ "ISO9141/KW2K 2 (VNET A)", SPY_PROTOCOL_Keyword2000},
{ "ISO9141/KW2K 3 (VNET A)", SPY_PROTOCOL_Keyword2000},
{ "ISO9141/KW2K 4 (VNET A)", SPY_PROTOCOL_Keyword2000},
{ "HS CAN (VNET B)", SPY_PROTOCOL_CAN},
{ "MS CAN (VNET B)", SPY_PROTOCOL_CAN},
{ "SW CAN (VNET B)", SPY_PROTOCOL_CAN},
{ "J1850 VPW (VNET B)", SPY_PROTOCOL_J1850VPW},
{ "LSFT CAN (VNET B)", SPY_PROTOCOL_CAN},
{ "J1708 (VNET B)", SPY_PROTOCOL_J1708},
{ "neoVI (VNET B)", SPY_PROTOCOL_CAN },
{ "HS CAN2 (VNET B)", SPY_PROTOCOL_CAN},
{ "HS CAN3 (VNET B)", SPY_PROTOCOL_CAN},
{ "LIN (VNET B)", SPY_PROTOCOL_LIN},
{ "LIN2 (VNET B)", SPY_PROTOCOL_LIN},
{ "LIN3 (VNET B)", SPY_PROTOCOL_LIN},
{ "LIN4 (VNET B)", SPY_PROTOCOL_LIN},
{ "CGI (VNET B)", SPY_PROTOCOL_CGI},
{ "ISO9141/KW2K (VNET B)", SPY_PROTOCOL_Keyword2000},
{ "ISO9141/KW2K 2 (VNET B)", SPY_PROTOCOL_Keyword2000},
{ "ISO9141/KW2K 3 (VNET B)", SPY_PROTOCOL_Keyword2000},
{ "ISO9141/KW2K 4 (VNET B)", SPY_PROTOCOL_Keyword2000},
{ "HS CAN4 (VNET A)", SPY_PROTOCOL_CAN},
{ "HS CAN5 (VNET A)", SPY_PROTOCOL_CAN},
{ "LIN5 (VNET A)", SPY_PROTOCOL_LIN},
{ "HS CAN4 (VNET B)", SPY_PROTOCOL_CAN},
{ "HS CAN5 (VNET B)", SPY_PROTOCOL_CAN},
{ "LIN5 (VNET B)", SPY_PROTOCOL_LIN},
{ "Ethernet DAQ", SPY_PROTOCOL_ETHERNET},
{ "Ethernet", SPY_PROTOCOL_ETHERNET},
{ "MOST (VNET B)", SPY_PROTOCOL_MOST},
{ "FlexRay1A (VNET B)", SPY_PROTOCOL_FLEXRAY},
{ "FlexRay1B (VNET B)", SPY_PROTOCOL_FLEXRAY},
{ "FlexRay2A (VNET B)", SPY_PROTOCOL_FLEXRAY},
{ "FlexRay2B (VNET B)", SPY_PROTOCOL_FLEXRAY},
{ "SW CAN2", SPY_PROTOCOL_CAN},
{ "SW CAN2 (VNET A)", SPY_PROTOCOL_CAN},
{ "SW CAN2 (VNET B)", SPY_PROTOCOL_CAN},
{ "FSA", SPY_PROTOCOL_GMFSA},
{ "TCP", SPY_PROTOCOL_TCP},
{ "HS CAN6", SPY_PROTOCOL_CAN},
{ "HS CAN7", SPY_PROTOCOL_CAN},
{ "LIN6", SPY_PROTOCOL_LIN},
{ "LSFT CAN2", SPY_PROTOCOL_CAN},
{ "OP (BR) ETH1", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH2", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH3", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH4", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH5", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH6", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH7", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH8", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH9", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH10", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH11", SPY_PROTOCOL_ETHERNET},
{ "OP (BR) ETH12", SPY_PROTOCOL_ETHERNET},
{ "FlexRay", SPY_PROTOCOL_FLEXRAY},
{ "FlexRay2", SPY_PROTOCOL_FLEXRAY},
{ "LIN6 (VNET A)", SPY_PROTOCOL_LIN },
{ "LIN6 (VNET B)", SPY_PROTOCOL_LIN },
{ "HS CAN6 (VNET A)", SPY_PROTOCOL_CAN },
{ "HS CAN6 (VNET B)", SPY_PROTOCOL_CAN },
{ "HS CAN7 (VNET A)", SPY_PROTOCOL_CAN },
{ "HS CAN7 (VNET B)", SPY_PROTOCOL_CAN },
{ "LSFT CAN2 (VNET A)", SPY_PROTOCOL_CAN },
{ "LSFT CAN2 (VNET B)", SPY_PROTOCOL_CAN },
{ "Ethernet (VNET A)", SPY_PROTOCOL_ETHERNET },
{ "Ethernet (VNET B)", SPY_PROTOCOL_ETHERNET },
{ "UDP", SPY_PROTOCOL_CUSTOM },
{ "AUTOSAR", SPY_PROTOCOL_CUSTOM },
{ "I2C1", SPY_PROTOCOL_I2C},
{ "I2C2", SPY_PROTOCOL_I2C },
{ "I2C3", SPY_PROTOCOL_I2C },
{ "I2C4", SPY_PROTOCOL_I2C },
{ "Ethernet2", SPY_PROTOCOL_ETHERNET } };

