# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.configuration import Configuration


class V1alpha1VirusDatasetSummary(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'assembly_count': 'int',
        'display_names': 'list[str]',
        'estimated_file_size_mb': 'int',
        'released_since': 'datetime',
        'resource_updated_on': 'datetime'
    }

    attribute_map = {
        'assembly_count': 'assembly_count',
        'display_names': 'display_names',
        'estimated_file_size_mb': 'estimated_file_size_mb',
        'released_since': 'released_since',
        'resource_updated_on': 'resource_updated_on'
    }

    def __init__(self, assembly_count=None, display_names=None, estimated_file_size_mb=None, released_since=None, resource_updated_on=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1VirusDatasetSummary - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._assembly_count = None
        self._display_names = None
        self._estimated_file_size_mb = None
        self._released_since = None
        self._resource_updated_on = None
        self.discriminator = None

        if assembly_count is not None:
            self.assembly_count = assembly_count
        if display_names is not None:
            self.display_names = display_names
        if estimated_file_size_mb is not None:
            self.estimated_file_size_mb = estimated_file_size_mb
        if released_since is not None:
            self.released_since = released_since
        if resource_updated_on is not None:
            self.resource_updated_on = resource_updated_on

    @property
    def assembly_count(self):
        """Gets the assembly_count of this V1alpha1VirusDatasetSummary.  # noqa: E501

        The number of assemblies for the requested filter.  # noqa: E501

        :return: The assembly_count of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :rtype: int
        """
        return self._assembly_count

    @assembly_count.setter
    def assembly_count(self, assembly_count):
        """Sets the assembly_count of this V1alpha1VirusDatasetSummary.

        The number of assemblies for the requested filter.  # noqa: E501

        :param assembly_count: The assembly_count of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :type: int
        """

        self._assembly_count = assembly_count

    @property
    def display_names(self):
        """Gets the display_names of this V1alpha1VirusDatasetSummary.  # noqa: E501


        :return: The display_names of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :rtype: list[str]
        """
        return self._display_names

    @display_names.setter
    def display_names(self, display_names):
        """Sets the display_names of this V1alpha1VirusDatasetSummary.


        :param display_names: The display_names of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :type: list[str]
        """

        self._display_names = display_names

    @property
    def estimated_file_size_mb(self):
        """Gets the estimated_file_size_mb of this V1alpha1VirusDatasetSummary.  # noqa: E501

        The estimated size of the file download.  # noqa: E501

        :return: The estimated_file_size_mb of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :rtype: int
        """
        return self._estimated_file_size_mb

    @estimated_file_size_mb.setter
    def estimated_file_size_mb(self, estimated_file_size_mb):
        """Sets the estimated_file_size_mb of this V1alpha1VirusDatasetSummary.

        The estimated size of the file download.  # noqa: E501

        :param estimated_file_size_mb: The estimated_file_size_mb of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :type: int
        """

        self._estimated_file_size_mb = estimated_file_size_mb

    @property
    def released_since(self):
        """Gets the released_since of this V1alpha1VirusDatasetSummary.  # noqa: E501


        :return: The released_since of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :rtype: datetime
        """
        return self._released_since

    @released_since.setter
    def released_since(self, released_since):
        """Sets the released_since of this V1alpha1VirusDatasetSummary.


        :param released_since: The released_since of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :type: datetime
        """

        self._released_since = released_since

    @property
    def resource_updated_on(self):
        """Gets the resource_updated_on of this V1alpha1VirusDatasetSummary.  # noqa: E501

        The latest date on which the resource was updated.  # noqa: E501

        :return: The resource_updated_on of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :rtype: datetime
        """
        return self._resource_updated_on

    @resource_updated_on.setter
    def resource_updated_on(self, resource_updated_on):
        """Sets the resource_updated_on of this V1alpha1VirusDatasetSummary.

        The latest date on which the resource was updated.  # noqa: E501

        :param resource_updated_on: The resource_updated_on of this V1alpha1VirusDatasetSummary.  # noqa: E501
        :type: datetime
        """

        self._resource_updated_on = resource_updated_on

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1VirusDatasetSummary):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1VirusDatasetSummary):
            return True

        return self.to_dict() != other.to_dict()
