# DO NOT EDIT! This file is automatically generated
import datetime
import enum
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._common import CreatedBy, LastModifiedBy, LocalizedString
__all__ = [
    "State",
    "StateAddRolesAction",
    "StateChangeInitialAction",
    "StateChangeKeyAction",
    "StateChangeTypeAction",
    "StateDraft",
    "StatePagedQueryResponse",
    "StateReference",
    "StateRemoveRolesAction",
    "StateResourceIdentifier",
    "StateRoleEnum",
    "StateSetDescriptionAction",
    "StateSetNameAction",
    "StateSetRolesAction",
    "StateSetTransitionsAction",
    "StateTypeEnum",
    "StateUpdate",
    "StateUpdateAction",
]


class State(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: :class:`str`
    key: str
    #: :class:`commercetools.types.StateTypeEnum`
    type: "StateTypeEnum"
    #: Optional :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: :class:`bool`
    initial: bool
    #: :class:`bool` `(Named` ``builtIn`` `in Commercetools)`
    built_in: bool
    #: Optional list of :class:`commercetools.types.StateRoleEnum`
    roles: typing.Optional[typing.List["StateRoleEnum"]]
    #: Optional list of :class:`commercetools.types.StateReference`
    transitions: typing.Optional[typing.List["StateReference"]]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        key: str,
        type: "StateTypeEnum",
        initial: bool,
        built_in: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        name: typing.Optional["LocalizedString"] = None,
        description: typing.Optional["LocalizedString"] = None,
        roles: typing.Optional[typing.List["StateRoleEnum"]] = None,
        transitions: typing.Optional[typing.List["StateReference"]] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.key = key
        self.type = type
        self.name = name
        self.description = description
        self.initial = initial
        self.built_in = built_in
        self.roles = roles
        self.transitions = transitions
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "State(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, key=%r, type=%r, name=%r, description=%r, initial=%r, built_in=%r, roles=%r, transitions=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.key,
                self.type,
                self.name,
                self.description,
                self.initial,
                self.built_in,
                self.roles,
                self.transitions,
            )
        )


class StateDraft(_BaseType):
    #: :class:`str`
    key: str
    #: :class:`commercetools.types.StateTypeEnum`
    type: "StateTypeEnum"
    #: Optional :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: Optional :class:`bool`
    initial: typing.Optional[bool]
    #: Optional list of :class:`commercetools.types.StateRoleEnum`
    roles: typing.Optional[typing.List["StateRoleEnum"]]
    #: Optional list of :class:`commercetools.types.StateResourceIdentifier`
    transitions: typing.Optional[typing.List["StateResourceIdentifier"]]

    def __init__(
        self,
        *,
        key: str,
        type: "StateTypeEnum",
        name: typing.Optional["LocalizedString"] = None,
        description: typing.Optional["LocalizedString"] = None,
        initial: typing.Optional[bool] = None,
        roles: typing.Optional[typing.List["StateRoleEnum"]] = None,
        transitions: typing.Optional[typing.List["StateResourceIdentifier"]] = None
    ) -> None:
        self.key = key
        self.type = type
        self.name = name
        self.description = description
        self.initial = initial
        self.roles = roles
        self.transitions = transitions
        super().__init__()

    def __repr__(self) -> str:
        return (
            "StateDraft(key=%r, type=%r, name=%r, description=%r, initial=%r, roles=%r, transitions=%r)"
            % (
                self.key,
                self.type,
                self.name,
                self.description,
                self.initial,
                self.roles,
                self.transitions,
            )
        )


class StatePagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.State`
    results: typing.Sequence["State"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["State"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "StatePagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class StateReference(Reference):
    #: Optional :class:`commercetools.types.State`
    obj: typing.Optional["State"]

    def __init__(self, *, id: str, obj: typing.Optional["State"] = None) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.STATE, id=id)

    def __repr__(self) -> str:
        return "StateReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class StateResourceIdentifier(ResourceIdentifier):
    def __init__(
        self, *, id: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.STATE, id=id, key=key)

    def __repr__(self) -> str:
        return "StateResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class StateRoleEnum(enum.Enum):
    REVIEW_INCLUDED_IN_STATISTICS = "ReviewIncludedInStatistics"
    RETURN_ = "Return"


class StateTypeEnum(enum.Enum):
    ORDER_STATE = "OrderState"
    LINE_ITEM_STATE = "LineItemState"
    PRODUCT_STATE = "ProductState"
    REVIEW_STATE = "ReviewState"
    PAYMENT_STATE = "PaymentState"


class StateUpdate(_BaseType):
    #: :class:`int`
    version: int
    #: :class:`list`
    actions: list

    def __init__(self, *, version: int, actions: list) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "StateUpdate(version=%r, actions=%r)" % (self.version, self.actions)


class StateUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "StateUpdateAction(action=%r)" % (self.action,)


class StateAddRolesAction(StateUpdateAction):
    #: List of :class:`commercetools.types.StateRoleEnum`
    roles: typing.List["StateRoleEnum"]

    def __init__(self, *, roles: typing.List["StateRoleEnum"]) -> None:
        self.roles = roles
        super().__init__(action="addRoles")

    def __repr__(self) -> str:
        return "StateAddRolesAction(action=%r, roles=%r)" % (self.action, self.roles)


class StateChangeInitialAction(StateUpdateAction):
    #: :class:`bool`
    initial: bool

    def __init__(self, *, initial: bool) -> None:
        self.initial = initial
        super().__init__(action="changeInitial")

    def __repr__(self) -> str:
        return "StateChangeInitialAction(action=%r, initial=%r)" % (
            self.action,
            self.initial,
        )


class StateChangeKeyAction(StateUpdateAction):
    #: :class:`str`
    key: str

    def __init__(self, *, key: str) -> None:
        self.key = key
        super().__init__(action="changeKey")

    def __repr__(self) -> str:
        return "StateChangeKeyAction(action=%r, key=%r)" % (self.action, self.key)


class StateChangeTypeAction(StateUpdateAction):
    #: :class:`commercetools.types.StateTypeEnum`
    type: "StateTypeEnum"

    def __init__(self, *, type: "StateTypeEnum") -> None:
        self.type = type
        super().__init__(action="changeType")

    def __repr__(self) -> str:
        return "StateChangeTypeAction(action=%r, type=%r)" % (self.action, self.type)


class StateRemoveRolesAction(StateUpdateAction):
    #: List of :class:`commercetools.types.StateRoleEnum`
    roles: typing.List["StateRoleEnum"]

    def __init__(self, *, roles: typing.List["StateRoleEnum"]) -> None:
        self.roles = roles
        super().__init__(action="removeRoles")

    def __repr__(self) -> str:
        return "StateRemoveRolesAction(action=%r, roles=%r)" % (self.action, self.roles)


class StateSetDescriptionAction(StateUpdateAction):
    #: :class:`commercetools.types.LocalizedString`
    description: "LocalizedString"

    def __init__(self, *, description: "LocalizedString") -> None:
        self.description = description
        super().__init__(action="setDescription")

    def __repr__(self) -> str:
        return "StateSetDescriptionAction(action=%r, description=%r)" % (
            self.action,
            self.description,
        )


class StateSetNameAction(StateUpdateAction):
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"

    def __init__(self, *, name: "LocalizedString") -> None:
        self.name = name
        super().__init__(action="setName")

    def __repr__(self) -> str:
        return "StateSetNameAction(action=%r, name=%r)" % (self.action, self.name)


class StateSetRolesAction(StateUpdateAction):
    #: List of :class:`commercetools.types.StateRoleEnum`
    roles: typing.List["StateRoleEnum"]

    def __init__(self, *, roles: typing.List["StateRoleEnum"]) -> None:
        self.roles = roles
        super().__init__(action="setRoles")

    def __repr__(self) -> str:
        return "StateSetRolesAction(action=%r, roles=%r)" % (self.action, self.roles)


class StateSetTransitionsAction(StateUpdateAction):
    #: Optional list of :class:`commercetools.types.StateResourceIdentifier`
    transitions: typing.Optional[typing.List["StateResourceIdentifier"]]

    def __init__(
        self,
        *,
        transitions: typing.Optional[typing.List["StateResourceIdentifier"]] = None
    ) -> None:
        self.transitions = transitions
        super().__init__(action="setTransitions")

    def __repr__(self) -> str:
        return "StateSetTransitionsAction(action=%r, transitions=%r)" % (
            self.action,
            self.transitions,
        )
