# DO NOT EDIT! This file is automatically generated
import datetime
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import BaseResource

if typing.TYPE_CHECKING:
    from ._cart import (
        DiscountCodeState,
        DiscountedLineItemPriceForQuantity,
        LineItem,
        ProductPublishScope,
        ShippingInfo,
        ShippingRateInput,
        TaxedItemPrice,
    )
    from ._category import Category, CategoryReference
    from ._channel import ChannelReference
    from ._common import (
        Address,
        CreatedBy,
        DiscountedPrice,
        Image,
        LastModifiedBy,
        LocalizedString,
        Money,
        Reference,
    )
    from ._customer import Customer, CustomerReference
    from ._customer_group import CustomerGroupReference
    from ._discount_code import DiscountCodeReference
    from ._inventory import InventoryEntry
    from ._order import (
        Delivery,
        DeliveryItem,
        Order,
        OrderState,
        Parcel,
        ParcelMeasurements,
        PaymentState,
        ReturnInfo,
        ReturnShipmentState,
        ShipmentState,
        TrackingData,
    )
    from ._order_edit import OrderEditApplied, OrderEditReference
    from ._payment import Payment, Transaction, TransactionState
    from ._product import ProductProjection, ProductVariant
    from ._review import Review
    from ._state import StateReference
    from ._store import StoreKeyReference
    from ._type import CustomFields
__all__ = [
    "CategoryCreatedMessage",
    "CategoryCreatedMessagePayload",
    "CategorySlugChangedMessage",
    "CategorySlugChangedMessagePayload",
    "CustomLineItemStateTransitionMessage",
    "CustomLineItemStateTransitionMessagePayload",
    "CustomerAddressAddedMessage",
    "CustomerAddressAddedMessagePayload",
    "CustomerAddressChangedMessage",
    "CustomerAddressChangedMessagePayload",
    "CustomerAddressRemovedMessage",
    "CustomerAddressRemovedMessagePayload",
    "CustomerCompanyNameSetMessage",
    "CustomerCompanyNameSetMessagePayload",
    "CustomerCreatedMessage",
    "CustomerCreatedMessagePayload",
    "CustomerDateOfBirthSetMessage",
    "CustomerDateOfBirthSetMessagePayload",
    "CustomerEmailChangedMessage",
    "CustomerEmailChangedMessagePayload",
    "CustomerEmailVerifiedMessage",
    "CustomerEmailVerifiedMessagePayload",
    "CustomerGroupSetMessage",
    "CustomerGroupSetMessagePayload",
    "DeliveryAddedMessage",
    "DeliveryAddedMessagePayload",
    "DeliveryAddressSetMessage",
    "DeliveryAddressSetMessagePayload",
    "DeliveryItemsUpdatedMessage",
    "DeliveryItemsUpdatedMessagePayload",
    "DeliveryRemovedMessage",
    "DeliveryRemovedMessagePayload",
    "InventoryEntryCreatedMessage",
    "InventoryEntryCreatedMessagePayload",
    "InventoryEntryDeletedMessage",
    "InventoryEntryDeletedMessagePayload",
    "InventoryEntryQuantitySetMessage",
    "InventoryEntryQuantitySetMessagePayload",
    "LineItemStateTransitionMessage",
    "LineItemStateTransitionMessagePayload",
    "Message",
    "MessageConfiguration",
    "MessageConfigurationDraft",
    "MessagePagedQueryResponse",
    "MessagePayload",
    "OrderBillingAddressSetMessage",
    "OrderBillingAddressSetMessagePayload",
    "OrderCreatedMessage",
    "OrderCreatedMessagePayload",
    "OrderCustomLineItemDiscountSetMessage",
    "OrderCustomLineItemDiscountSetMessagePayload",
    "OrderCustomerEmailSetMessage",
    "OrderCustomerEmailSetMessagePayload",
    "OrderCustomerGroupSetMessage",
    "OrderCustomerGroupSetMessagePayload",
    "OrderCustomerSetMessage",
    "OrderCustomerSetMessagePayload",
    "OrderDeletedMessage",
    "OrderDeletedMessagePayload",
    "OrderDiscountCodeAddedMessage",
    "OrderDiscountCodeAddedMessagePayload",
    "OrderDiscountCodeRemovedMessage",
    "OrderDiscountCodeRemovedMessagePayload",
    "OrderDiscountCodeStateSetMessage",
    "OrderDiscountCodeStateSetMessagePayload",
    "OrderEditAppliedMessage",
    "OrderEditAppliedMessagePayload",
    "OrderImportedMessage",
    "OrderImportedMessagePayload",
    "OrderLineItemAddedMessage",
    "OrderLineItemAddedMessagePayload",
    "OrderLineItemDiscountSetMessage",
    "OrderLineItemDiscountSetMessagePayload",
    "OrderPaymentStateChangedMessage",
    "OrderPaymentStateChangedMessagePayload",
    "OrderReturnInfoAddedMessage",
    "OrderReturnInfoAddedMessagePayload",
    "OrderReturnShipmentStateChangedMessage",
    "OrderReturnShipmentStateChangedMessagePayload",
    "OrderShipmentStateChangedMessage",
    "OrderShipmentStateChangedMessagePayload",
    "OrderShippingAddressSetMessage",
    "OrderShippingAddressSetMessagePayload",
    "OrderShippingInfoSetMessage",
    "OrderShippingInfoSetMessagePayload",
    "OrderShippingRateInputSetMessage",
    "OrderShippingRateInputSetMessagePayload",
    "OrderStateChangedMessage",
    "OrderStateChangedMessagePayload",
    "OrderStateTransitionMessage",
    "OrderStateTransitionMessagePayload",
    "OrderStoreSetMessage",
    "OrderStoreSetMessagePayload",
    "ParcelAddedToDeliveryMessage",
    "ParcelAddedToDeliveryMessagePayload",
    "ParcelItemsUpdatedMessage",
    "ParcelItemsUpdatedMessagePayload",
    "ParcelMeasurementsUpdatedMessage",
    "ParcelMeasurementsUpdatedMessagePayload",
    "ParcelRemovedFromDeliveryMessage",
    "ParcelRemovedFromDeliveryMessagePayload",
    "ParcelTrackingDataUpdatedMessage",
    "ParcelTrackingDataUpdatedMessagePayload",
    "PaymentCreatedMessage",
    "PaymentCreatedMessagePayload",
    "PaymentInteractionAddedMessage",
    "PaymentInteractionAddedMessagePayload",
    "PaymentStatusInterfaceCodeSetMessage",
    "PaymentStatusInterfaceCodeSetMessagePayload",
    "PaymentStatusStateTransitionMessage",
    "PaymentStatusStateTransitionMessagePayload",
    "PaymentTransactionAddedMessage",
    "PaymentTransactionAddedMessagePayload",
    "PaymentTransactionStateChangedMessage",
    "PaymentTransactionStateChangedMessagePayload",
    "ProductAddedToCategoryMessage",
    "ProductAddedToCategoryMessagePayload",
    "ProductCreatedMessage",
    "ProductCreatedMessagePayload",
    "ProductDeletedMessage",
    "ProductDeletedMessagePayload",
    "ProductImageAddedMessage",
    "ProductImageAddedMessagePayload",
    "ProductPriceDiscountsSetMessage",
    "ProductPriceDiscountsSetMessagePayload",
    "ProductPriceDiscountsSetUpdatedPrice",
    "ProductPriceExternalDiscountSetMessage",
    "ProductPriceExternalDiscountSetMessagePayload",
    "ProductPublishedMessage",
    "ProductPublishedMessagePayload",
    "ProductRemovedFromCategoryMessage",
    "ProductRemovedFromCategoryMessagePayload",
    "ProductRevertedStagedChangesMessage",
    "ProductRevertedStagedChangesMessagePayload",
    "ProductSlugChangedMessage",
    "ProductSlugChangedMessagePayload",
    "ProductStateTransitionMessage",
    "ProductStateTransitionMessagePayload",
    "ProductUnpublishedMessage",
    "ProductUnpublishedMessagePayload",
    "ProductVariantAddedMessage",
    "ProductVariantAddedMessagePayload",
    "ProductVariantDeletedMessage",
    "ProductVariantDeletedMessagePayload",
    "ReviewCreatedMessage",
    "ReviewCreatedMessagePayload",
    "ReviewRatingSetMessage",
    "ReviewRatingSetMessagePayload",
    "ReviewStateTransitionMessage",
    "ReviewStateTransitionMessagePayload",
    "UserProvidedIdentifiers",
]


class Message(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: :class:`int` `(Named` ``sequenceNumber`` `in Commercetools)`
    sequence_number: int
    #: :class:`commercetools.types.Reference`
    resource: "Reference"
    #: :class:`int` `(Named` ``resourceVersion`` `in Commercetools)`
    resource_version: int
    #: :class:`str`
    type: str
    #: Optional :class:`commercetools.types.UserProvidedIdentifiers` `(Named` ``resourceUserProvidedIdentifiers`` `in Commercetools)`
    resource_user_provided_identifiers: typing.Optional["UserProvidedIdentifiers"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        type: str,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.sequence_number = sequence_number
        self.resource = resource
        self.resource_version = resource_version
        self.type = type
        self.resource_user_provided_identifiers = resource_user_provided_identifiers
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "Message(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
            )
        )


class MessageConfiguration(_BaseType):
    #: :class:`bool`
    enabled: bool
    #: Optional :class:`int` `(Named` ``deleteDaysAfterCreation`` `in Commercetools)`
    delete_days_after_creation: typing.Optional[int]

    def __init__(
        self, *, enabled: bool, delete_days_after_creation: typing.Optional[int] = None
    ) -> None:
        self.enabled = enabled
        self.delete_days_after_creation = delete_days_after_creation
        super().__init__()

    def __repr__(self) -> str:
        return "MessageConfiguration(enabled=%r, delete_days_after_creation=%r)" % (
            self.enabled,
            self.delete_days_after_creation,
        )


class MessageConfigurationDraft(_BaseType):
    #: :class:`bool`
    enabled: bool
    #: :class:`int` `(Named` ``deleteDaysAfterCreation`` `in Commercetools)`
    delete_days_after_creation: int

    def __init__(self, *, enabled: bool, delete_days_after_creation: int) -> None:
        self.enabled = enabled
        self.delete_days_after_creation = delete_days_after_creation
        super().__init__()

    def __repr__(self) -> str:
        return (
            "MessageConfigurationDraft(enabled=%r, delete_days_after_creation=%r)"
            % (self.enabled, self.delete_days_after_creation)
        )


class MessagePagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.Message`
    results: typing.Sequence["Message"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["Message"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "MessagePagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class MessagePayload(_BaseType):
    #: :class:`str`
    type: str

    def __init__(self, *, type: str) -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "MessagePayload(type=%r)" % (self.type,)


class ProductPriceDiscountsSetUpdatedPrice(_BaseType):
    #: :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: int
    #: Optional :class:`str` `(Named` ``variantKey`` `in Commercetools)`
    variant_key: typing.Optional[str]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: :class:`str` `(Named` ``priceId`` `in Commercetools)`
    price_id: str
    #: Optional :class:`commercetools.types.DiscountedPrice`
    discounted: typing.Optional["DiscountedPrice"]
    #: :class:`bool`
    staged: bool

    def __init__(
        self,
        *,
        variant_id: int,
        price_id: str,
        staged: bool,
        variant_key: typing.Optional[str] = None,
        sku: typing.Optional[str] = None,
        discounted: typing.Optional["DiscountedPrice"] = None
    ) -> None:
        self.variant_id = variant_id
        self.variant_key = variant_key
        self.sku = sku
        self.price_id = price_id
        self.discounted = discounted
        self.staged = staged
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductPriceDiscountsSetUpdatedPrice(variant_id=%r, variant_key=%r, sku=%r, price_id=%r, discounted=%r, staged=%r)"
            % (
                self.variant_id,
                self.variant_key,
                self.sku,
                self.price_id,
                self.discounted,
                self.staged,
            )
        )


class UserProvidedIdentifiers(_BaseType):
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``externalId`` `in Commercetools)`
    external_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``orderNumber`` `in Commercetools)`
    order_number: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``customerNumber`` `in Commercetools)`
    customer_number: typing.Optional[str]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`commercetools.types.LocalizedString`
    slug: typing.Optional["LocalizedString"]

    def __init__(
        self,
        *,
        key: typing.Optional[str] = None,
        external_id: typing.Optional[str] = None,
        order_number: typing.Optional[str] = None,
        customer_number: typing.Optional[str] = None,
        sku: typing.Optional[str] = None,
        slug: typing.Optional["LocalizedString"] = None
    ) -> None:
        self.key = key
        self.external_id = external_id
        self.order_number = order_number
        self.customer_number = customer_number
        self.sku = sku
        self.slug = slug
        super().__init__()

    def __repr__(self) -> str:
        return (
            "UserProvidedIdentifiers(key=%r, external_id=%r, order_number=%r, customer_number=%r, sku=%r, slug=%r)"
            % (
                self.key,
                self.external_id,
                self.order_number,
                self.customer_number,
                self.sku,
                self.slug,
            )
        )


class CategoryCreatedMessage(Message):
    #: :class:`commercetools.types.Category`
    category: "Category"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        category: "Category",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.category = category
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CategoryCreated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CategoryCreatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, category=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.category,
            )
        )


class CategoryCreatedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Category`
    category: "Category"

    def __init__(self, *, category: "Category") -> None:
        self.category = category
        super().__init__(type="CategoryCreated")

    def __repr__(self) -> str:
        return "CategoryCreatedMessagePayload(type=%r, category=%r)" % (
            self.type,
            self.category,
        )


class CategorySlugChangedMessage(Message):
    #: :class:`commercetools.types.LocalizedString`
    slug: "LocalizedString"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        slug: "LocalizedString",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.slug = slug
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CategorySlugChanged",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CategorySlugChangedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, slug=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.slug,
            )
        )


class CategorySlugChangedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.LocalizedString`
    slug: "LocalizedString"

    def __init__(self, *, slug: "LocalizedString") -> None:
        self.slug = slug
        super().__init__(type="CategorySlugChanged")

    def __repr__(self) -> str:
        return "CategorySlugChangedMessagePayload(type=%r, slug=%r)" % (
            self.type,
            self.slug,
        )


class CustomLineItemStateTransitionMessage(Message):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`datetime.datetime` `(Named` ``transitionDate`` `in Commercetools)`
    transition_date: datetime.datetime
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.StateReference` `(Named` ``fromState`` `in Commercetools)`
    from_state: "StateReference"
    #: :class:`commercetools.types.StateReference` `(Named` ``toState`` `in Commercetools)`
    to_state: "StateReference"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        custom_line_item_id: str,
        transition_date: datetime.datetime,
        quantity: int,
        from_state: "StateReference",
        to_state: "StateReference",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.transition_date = transition_date
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomLineItemStateTransition",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomLineItemStateTransitionMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, custom_line_item_id=%r, transition_date=%r, quantity=%r, from_state=%r, to_state=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.custom_line_item_id,
                self.transition_date,
                self.quantity,
                self.from_state,
                self.to_state,
            )
        )


class CustomLineItemStateTransitionMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: :class:`datetime.datetime` `(Named` ``transitionDate`` `in Commercetools)`
    transition_date: datetime.datetime
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.StateReference` `(Named` ``fromState`` `in Commercetools)`
    from_state: "StateReference"
    #: :class:`commercetools.types.StateReference` `(Named` ``toState`` `in Commercetools)`
    to_state: "StateReference"

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        transition_date: datetime.datetime,
        quantity: int,
        from_state: "StateReference",
        to_state: "StateReference"
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.transition_date = transition_date
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        super().__init__(type="CustomLineItemStateTransition")

    def __repr__(self) -> str:
        return (
            "CustomLineItemStateTransitionMessagePayload(type=%r, custom_line_item_id=%r, transition_date=%r, quantity=%r, from_state=%r, to_state=%r)"
            % (
                self.type,
                self.custom_line_item_id,
                self.transition_date,
                self.quantity,
                self.from_state,
                self.to_state,
            )
        )


class CustomerAddressAddedMessage(Message):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        address: "Address",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.address = address
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomerAddressAdded",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomerAddressAddedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, address=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.address,
            )
        )


class CustomerAddressAddedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(type="CustomerAddressAdded")

    def __repr__(self) -> str:
        return "CustomerAddressAddedMessagePayload(type=%r, address=%r)" % (
            self.type,
            self.address,
        )


class CustomerAddressChangedMessage(Message):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        address: "Address",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.address = address
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomerAddressChanged",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomerAddressChangedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, address=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.address,
            )
        )


class CustomerAddressChangedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(type="CustomerAddressChanged")

    def __repr__(self) -> str:
        return "CustomerAddressChangedMessagePayload(type=%r, address=%r)" % (
            self.type,
            self.address,
        )


class CustomerAddressRemovedMessage(Message):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        address: "Address",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.address = address
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomerAddressRemoved",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomerAddressRemovedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, address=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.address,
            )
        )


class CustomerAddressRemovedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(type="CustomerAddressRemoved")

    def __repr__(self) -> str:
        return "CustomerAddressRemovedMessagePayload(type=%r, address=%r)" % (
            self.type,
            self.address,
        )


class CustomerCompanyNameSetMessage(Message):
    #: :class:`str` `(Named` ``companyName`` `in Commercetools)`
    company_name: str

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        company_name: str,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.company_name = company_name
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomerCompanyNameSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomerCompanyNameSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, company_name=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.company_name,
            )
        )


class CustomerCompanyNameSetMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``companyName`` `in Commercetools)`
    company_name: str

    def __init__(self, *, company_name: str) -> None:
        self.company_name = company_name
        super().__init__(type="CustomerCompanyNameSet")

    def __repr__(self) -> str:
        return "CustomerCompanyNameSetMessagePayload(type=%r, company_name=%r)" % (
            self.type,
            self.company_name,
        )


class CustomerCreatedMessage(Message):
    #: :class:`commercetools.types.Customer`
    customer: "Customer"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        customer: "Customer",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.customer = customer
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomerCreated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomerCreatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, customer=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.customer,
            )
        )


class CustomerCreatedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Customer`
    customer: "Customer"

    def __init__(self, *, customer: "Customer") -> None:
        self.customer = customer
        super().__init__(type="CustomerCreated")

    def __repr__(self) -> str:
        return "CustomerCreatedMessagePayload(type=%r, customer=%r)" % (
            self.type,
            self.customer,
        )


class CustomerDateOfBirthSetMessage(Message):
    #: :class:`datetime.date` `(Named` ``dateOfBirth`` `in Commercetools)`
    date_of_birth: datetime.date

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        date_of_birth: datetime.date,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.date_of_birth = date_of_birth
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomerDateOfBirthSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomerDateOfBirthSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, date_of_birth=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.date_of_birth,
            )
        )


class CustomerDateOfBirthSetMessagePayload(MessagePayload):
    #: :class:`datetime.date` `(Named` ``dateOfBirth`` `in Commercetools)`
    date_of_birth: datetime.date

    def __init__(self, *, date_of_birth: datetime.date) -> None:
        self.date_of_birth = date_of_birth
        super().__init__(type="CustomerDateOfBirthSet")

    def __repr__(self) -> str:
        return "CustomerDateOfBirthSetMessagePayload(type=%r, date_of_birth=%r)" % (
            self.type,
            self.date_of_birth,
        )


class CustomerEmailChangedMessage(Message):
    #: :class:`str`
    email: str

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        email: str,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.email = email
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomerEmailChanged",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomerEmailChangedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, email=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.email,
            )
        )


class CustomerEmailChangedMessagePayload(MessagePayload):
    #: :class:`str`
    email: str

    def __init__(self, *, email: str) -> None:
        self.email = email
        super().__init__(type="CustomerEmailChanged")

    def __repr__(self) -> str:
        return "CustomerEmailChangedMessagePayload(type=%r, email=%r)" % (
            self.type,
            self.email,
        )


class CustomerEmailVerifiedMessage(Message):
    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomerEmailVerified",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomerEmailVerifiedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
            )
        )


class CustomerEmailVerifiedMessagePayload(MessagePayload):
    def __init__(self) -> None:
        super().__init__(type="CustomerEmailVerified")

    def __repr__(self) -> str:
        return "CustomerEmailVerifiedMessagePayload(type=%r)" % (self.type,)


class CustomerGroupSetMessage(Message):
    #: :class:`commercetools.types.CustomerGroupReference` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: "CustomerGroupReference"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        customer_group: "CustomerGroupReference",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.customer_group = customer_group
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="CustomerGroupSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "CustomerGroupSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, customer_group=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.customer_group,
            )
        )


class CustomerGroupSetMessagePayload(MessagePayload):
    #: :class:`commercetools.types.CustomerGroupReference` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: "CustomerGroupReference"

    def __init__(self, *, customer_group: "CustomerGroupReference") -> None:
        self.customer_group = customer_group
        super().__init__(type="CustomerGroupSet")

    def __repr__(self) -> str:
        return "CustomerGroupSetMessagePayload(type=%r, customer_group=%r)" % (
            self.type,
            self.customer_group,
        )


class DeliveryAddedMessage(Message):
    #: :class:`commercetools.types.Delivery`
    delivery: "Delivery"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        delivery: "Delivery",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.delivery = delivery
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="DeliveryAdded",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "DeliveryAddedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, delivery=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.delivery,
            )
        )


class DeliveryAddedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Delivery`
    delivery: "Delivery"

    def __init__(self, *, delivery: "Delivery") -> None:
        self.delivery = delivery
        super().__init__(type="DeliveryAdded")

    def __repr__(self) -> str:
        return "DeliveryAddedMessagePayload(type=%r, delivery=%r)" % (
            self.type,
            self.delivery,
        )


class DeliveryAddressSetMessage(Message):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``oldAddress`` `in Commercetools)`
    old_address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        delivery_id: str,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        address: typing.Optional["Address"] = None,
        old_address: typing.Optional["Address"] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.address = address
        self.old_address = old_address
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="DeliveryAddressSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "DeliveryAddressSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, delivery_id=%r, address=%r, old_address=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.delivery_id,
                self.address,
                self.old_address,
            )
        )


class DeliveryAddressSetMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``oldAddress`` `in Commercetools)`
    old_address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        delivery_id: str,
        address: typing.Optional["Address"] = None,
        old_address: typing.Optional["Address"] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.address = address
        self.old_address = old_address
        super().__init__(type="DeliveryAddressSet")

    def __repr__(self) -> str:
        return (
            "DeliveryAddressSetMessagePayload(type=%r, delivery_id=%r, address=%r, old_address=%r)"
            % (self.type, self.delivery_id, self.address, self.old_address)
        )


class DeliveryItemsUpdatedMessage(Message):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.List["DeliveryItem"]
    #: List of :class:`commercetools.types.DeliveryItem` `(Named` ``oldItems`` `in Commercetools)`
    old_items: typing.List["DeliveryItem"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        delivery_id: str,
        items: typing.List["DeliveryItem"],
        old_items: typing.List["DeliveryItem"],
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.items = items
        self.old_items = old_items
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="DeliveryItemsUpdated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "DeliveryItemsUpdatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, delivery_id=%r, items=%r, old_items=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.delivery_id,
                self.items,
                self.old_items,
            )
        )


class DeliveryItemsUpdatedMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.List["DeliveryItem"]
    #: List of :class:`commercetools.types.DeliveryItem` `(Named` ``oldItems`` `in Commercetools)`
    old_items: typing.List["DeliveryItem"]

    def __init__(
        self,
        *,
        delivery_id: str,
        items: typing.List["DeliveryItem"],
        old_items: typing.List["DeliveryItem"]
    ) -> None:
        self.delivery_id = delivery_id
        self.items = items
        self.old_items = old_items
        super().__init__(type="DeliveryItemsUpdated")

    def __repr__(self) -> str:
        return (
            "DeliveryItemsUpdatedMessagePayload(type=%r, delivery_id=%r, items=%r, old_items=%r)"
            % (self.type, self.delivery_id, self.items, self.old_items)
        )


class DeliveryRemovedMessage(Message):
    #: :class:`commercetools.types.Delivery`
    delivery: "Delivery"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        delivery: "Delivery",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.delivery = delivery
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="DeliveryRemoved",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "DeliveryRemovedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, delivery=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.delivery,
            )
        )


class DeliveryRemovedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Delivery`
    delivery: "Delivery"

    def __init__(self, *, delivery: "Delivery") -> None:
        self.delivery = delivery
        super().__init__(type="DeliveryRemoved")

    def __repr__(self) -> str:
        return "DeliveryRemovedMessagePayload(type=%r, delivery=%r)" % (
            self.type,
            self.delivery,
        )


class InventoryEntryCreatedMessage(Message):
    #: :class:`commercetools.types.InventoryEntry` `(Named` ``inventoryEntry`` `in Commercetools)`
    inventory_entry: "InventoryEntry"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        inventory_entry: "InventoryEntry",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.inventory_entry = inventory_entry
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="InventoryEntryCreated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "InventoryEntryCreatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, inventory_entry=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.inventory_entry,
            )
        )


class InventoryEntryCreatedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.InventoryEntry` `(Named` ``inventoryEntry`` `in Commercetools)`
    inventory_entry: "InventoryEntry"

    def __init__(self, *, inventory_entry: "InventoryEntry") -> None:
        self.inventory_entry = inventory_entry
        super().__init__(type="InventoryEntryCreated")

    def __repr__(self) -> str:
        return "InventoryEntryCreatedMessagePayload(type=%r, inventory_entry=%r)" % (
            self.type,
            self.inventory_entry,
        )


class InventoryEntryDeletedMessage(Message):
    #: :class:`str`
    sku: str
    #: :class:`commercetools.types.ChannelReference` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: "ChannelReference"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        sku: str,
        supply_channel: "ChannelReference",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.sku = sku
        self.supply_channel = supply_channel
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="InventoryEntryDeleted",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "InventoryEntryDeletedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, sku=%r, supply_channel=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.sku,
                self.supply_channel,
            )
        )


class InventoryEntryDeletedMessagePayload(MessagePayload):
    #: :class:`str`
    sku: str
    #: :class:`commercetools.types.ChannelReference` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: "ChannelReference"

    def __init__(self, *, sku: str, supply_channel: "ChannelReference") -> None:
        self.sku = sku
        self.supply_channel = supply_channel
        super().__init__(type="InventoryEntryDeleted")

    def __repr__(self) -> str:
        return (
            "InventoryEntryDeletedMessagePayload(type=%r, sku=%r, supply_channel=%r)"
            % (self.type, self.sku, self.supply_channel)
        )


class InventoryEntryQuantitySetMessage(Message):
    #: :class:`int` `(Named` ``oldQuantityOnStock`` `in Commercetools)`
    old_quantity_on_stock: int
    #: :class:`int` `(Named` ``newQuantityOnStock`` `in Commercetools)`
    new_quantity_on_stock: int
    #: :class:`int` `(Named` ``oldAvailableQuantity`` `in Commercetools)`
    old_available_quantity: int
    #: :class:`int` `(Named` ``newAvailableQuantity`` `in Commercetools)`
    new_available_quantity: int

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        old_quantity_on_stock: int,
        new_quantity_on_stock: int,
        old_available_quantity: int,
        new_available_quantity: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.old_quantity_on_stock = old_quantity_on_stock
        self.new_quantity_on_stock = new_quantity_on_stock
        self.old_available_quantity = old_available_quantity
        self.new_available_quantity = new_available_quantity
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="InventoryEntryQuantitySet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "InventoryEntryQuantitySetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, old_quantity_on_stock=%r, new_quantity_on_stock=%r, old_available_quantity=%r, new_available_quantity=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.old_quantity_on_stock,
                self.new_quantity_on_stock,
                self.old_available_quantity,
                self.new_available_quantity,
            )
        )


class InventoryEntryQuantitySetMessagePayload(MessagePayload):
    #: :class:`int` `(Named` ``oldQuantityOnStock`` `in Commercetools)`
    old_quantity_on_stock: int
    #: :class:`int` `(Named` ``newQuantityOnStock`` `in Commercetools)`
    new_quantity_on_stock: int
    #: :class:`int` `(Named` ``oldAvailableQuantity`` `in Commercetools)`
    old_available_quantity: int
    #: :class:`int` `(Named` ``newAvailableQuantity`` `in Commercetools)`
    new_available_quantity: int

    def __init__(
        self,
        *,
        old_quantity_on_stock: int,
        new_quantity_on_stock: int,
        old_available_quantity: int,
        new_available_quantity: int
    ) -> None:
        self.old_quantity_on_stock = old_quantity_on_stock
        self.new_quantity_on_stock = new_quantity_on_stock
        self.old_available_quantity = old_available_quantity
        self.new_available_quantity = new_available_quantity
        super().__init__(type="InventoryEntryQuantitySet")

    def __repr__(self) -> str:
        return (
            "InventoryEntryQuantitySetMessagePayload(type=%r, old_quantity_on_stock=%r, new_quantity_on_stock=%r, old_available_quantity=%r, new_available_quantity=%r)"
            % (
                self.type,
                self.old_quantity_on_stock,
                self.new_quantity_on_stock,
                self.old_available_quantity,
                self.new_available_quantity,
            )
        )


class LineItemStateTransitionMessage(Message):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: :class:`datetime.datetime` `(Named` ``transitionDate`` `in Commercetools)`
    transition_date: datetime.datetime
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.StateReference` `(Named` ``fromState`` `in Commercetools)`
    from_state: "StateReference"
    #: :class:`commercetools.types.StateReference` `(Named` ``toState`` `in Commercetools)`
    to_state: "StateReference"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        line_item_id: str,
        transition_date: datetime.datetime,
        quantity: int,
        from_state: "StateReference",
        to_state: "StateReference",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.transition_date = transition_date
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="LineItemStateTransition",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "LineItemStateTransitionMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, line_item_id=%r, transition_date=%r, quantity=%r, from_state=%r, to_state=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.line_item_id,
                self.transition_date,
                self.quantity,
                self.from_state,
                self.to_state,
            )
        )


class LineItemStateTransitionMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: :class:`datetime.datetime` `(Named` ``transitionDate`` `in Commercetools)`
    transition_date: datetime.datetime
    #: :class:`int`
    quantity: int
    #: :class:`commercetools.types.StateReference` `(Named` ``fromState`` `in Commercetools)`
    from_state: "StateReference"
    #: :class:`commercetools.types.StateReference` `(Named` ``toState`` `in Commercetools)`
    to_state: "StateReference"

    def __init__(
        self,
        *,
        line_item_id: str,
        transition_date: datetime.datetime,
        quantity: int,
        from_state: "StateReference",
        to_state: "StateReference"
    ) -> None:
        self.line_item_id = line_item_id
        self.transition_date = transition_date
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        super().__init__(type="LineItemStateTransition")

    def __repr__(self) -> str:
        return (
            "LineItemStateTransitionMessagePayload(type=%r, line_item_id=%r, transition_date=%r, quantity=%r, from_state=%r, to_state=%r)"
            % (
                self.type,
                self.line_item_id,
                self.transition_date,
                self.quantity,
                self.from_state,
                self.to_state,
            )
        )


class OrderBillingAddressSetMessage(Message):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``oldAddress`` `in Commercetools)`
    old_address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        address: typing.Optional["Address"] = None,
        old_address: typing.Optional["Address"] = None
    ) -> None:
        self.address = address
        self.old_address = old_address
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderBillingAddressSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderBillingAddressSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, address=%r, old_address=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.address,
                self.old_address,
            )
        )


class OrderBillingAddressSetMessagePayload(MessagePayload):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``oldAddress`` `in Commercetools)`
    old_address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        address: typing.Optional["Address"] = None,
        old_address: typing.Optional["Address"] = None
    ) -> None:
        self.address = address
        self.old_address = old_address
        super().__init__(type="OrderBillingAddressSet")

    def __repr__(self) -> str:
        return (
            "OrderBillingAddressSetMessagePayload(type=%r, address=%r, old_address=%r)"
            % (self.type, self.address, self.old_address)
        )


class OrderCreatedMessage(Message):
    #: :class:`commercetools.types.Order`
    order: "Order"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        order: "Order",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.order = order
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderCreated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderCreatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, order=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.order,
            )
        )


class OrderCreatedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Order`
    order: "Order"

    def __init__(self, *, order: "Order") -> None:
        self.order = order
        super().__init__(type="OrderCreated")

    def __repr__(self) -> str:
        return "OrderCreatedMessagePayload(type=%r, order=%r)" % (self.type, self.order)


class OrderCustomLineItemDiscountSetMessage(Message):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: List of :class:`commercetools.types.DiscountedLineItemPriceForQuantity` `(Named` ``discountedPricePerQuantity`` `in Commercetools)`
    discounted_price_per_quantity: typing.List["DiscountedLineItemPriceForQuantity"]
    #: Optional :class:`commercetools.types.TaxedItemPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedItemPrice"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        custom_line_item_id: str,
        discounted_price_per_quantity: typing.List[
            "DiscountedLineItemPriceForQuantity"
        ],
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        taxed_price: typing.Optional["TaxedItemPrice"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.discounted_price_per_quantity = discounted_price_per_quantity
        self.taxed_price = taxed_price
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderCustomLineItemDiscountSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderCustomLineItemDiscountSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, custom_line_item_id=%r, discounted_price_per_quantity=%r, taxed_price=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.custom_line_item_id,
                self.discounted_price_per_quantity,
                self.taxed_price,
            )
        )


class OrderCustomLineItemDiscountSetMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: str
    #: List of :class:`commercetools.types.DiscountedLineItemPriceForQuantity` `(Named` ``discountedPricePerQuantity`` `in Commercetools)`
    discounted_price_per_quantity: typing.List["DiscountedLineItemPriceForQuantity"]
    #: Optional :class:`commercetools.types.TaxedItemPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedItemPrice"]

    def __init__(
        self,
        *,
        custom_line_item_id: str,
        discounted_price_per_quantity: typing.List[
            "DiscountedLineItemPriceForQuantity"
        ],
        taxed_price: typing.Optional["TaxedItemPrice"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.discounted_price_per_quantity = discounted_price_per_quantity
        self.taxed_price = taxed_price
        super().__init__(type="OrderCustomLineItemDiscountSet")

    def __repr__(self) -> str:
        return (
            "OrderCustomLineItemDiscountSetMessagePayload(type=%r, custom_line_item_id=%r, discounted_price_per_quantity=%r, taxed_price=%r)"
            % (
                self.type,
                self.custom_line_item_id,
                self.discounted_price_per_quantity,
                self.taxed_price,
            )
        )


class OrderCustomerEmailSetMessage(Message):
    #: Optional :class:`str`
    email: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``oldEmail`` `in Commercetools)`
    old_email: typing.Optional[str]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        email: typing.Optional[str] = None,
        old_email: typing.Optional[str] = None
    ) -> None:
        self.email = email
        self.old_email = old_email
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderCustomerEmailSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderCustomerEmailSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, email=%r, old_email=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.email,
                self.old_email,
            )
        )


class OrderCustomerEmailSetMessagePayload(MessagePayload):
    #: Optional :class:`str`
    email: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``oldEmail`` `in Commercetools)`
    old_email: typing.Optional[str]

    def __init__(
        self,
        *,
        email: typing.Optional[str] = None,
        old_email: typing.Optional[str] = None
    ) -> None:
        self.email = email
        self.old_email = old_email
        super().__init__(type="OrderCustomerEmailSet")

    def __repr__(self) -> str:
        return (
            "OrderCustomerEmailSetMessagePayload(type=%r, email=%r, old_email=%r)"
            % (self.type, self.email, self.old_email)
        )


class OrderCustomerGroupSetMessage(Message):
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupReference"]
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``oldCustomerGroup`` `in Commercetools)`
    old_customer_group: typing.Optional["CustomerGroupReference"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        customer_group: typing.Optional["CustomerGroupReference"] = None,
        old_customer_group: typing.Optional["CustomerGroupReference"] = None
    ) -> None:
        self.customer_group = customer_group
        self.old_customer_group = old_customer_group
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderCustomerGroupSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderCustomerGroupSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, customer_group=%r, old_customer_group=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.customer_group,
                self.old_customer_group,
            )
        )


class OrderCustomerGroupSetMessagePayload(MessagePayload):
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupReference"]
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``oldCustomerGroup`` `in Commercetools)`
    old_customer_group: typing.Optional["CustomerGroupReference"]

    def __init__(
        self,
        *,
        customer_group: typing.Optional["CustomerGroupReference"] = None,
        old_customer_group: typing.Optional["CustomerGroupReference"] = None
    ) -> None:
        self.customer_group = customer_group
        self.old_customer_group = old_customer_group
        super().__init__(type="OrderCustomerGroupSet")

    def __repr__(self) -> str:
        return (
            "OrderCustomerGroupSetMessagePayload(type=%r, customer_group=%r, old_customer_group=%r)"
            % (self.type, self.customer_group, self.old_customer_group)
        )


class OrderCustomerSetMessage(Message):
    #: Optional :class:`commercetools.types.CustomerReference`
    customer: typing.Optional["CustomerReference"]
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupReference"]
    #: Optional :class:`commercetools.types.CustomerReference` `(Named` ``oldCustomer`` `in Commercetools)`
    old_customer: typing.Optional["CustomerReference"]
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``oldCustomerGroup`` `in Commercetools)`
    old_customer_group: typing.Optional["CustomerGroupReference"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        customer: typing.Optional["CustomerReference"] = None,
        customer_group: typing.Optional["CustomerGroupReference"] = None,
        old_customer: typing.Optional["CustomerReference"] = None,
        old_customer_group: typing.Optional["CustomerGroupReference"] = None
    ) -> None:
        self.customer = customer
        self.customer_group = customer_group
        self.old_customer = old_customer
        self.old_customer_group = old_customer_group
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderCustomerSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderCustomerSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, customer=%r, customer_group=%r, old_customer=%r, old_customer_group=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.customer,
                self.customer_group,
                self.old_customer,
                self.old_customer_group,
            )
        )


class OrderCustomerSetMessagePayload(MessagePayload):
    #: Optional :class:`commercetools.types.CustomerReference`
    customer: typing.Optional["CustomerReference"]
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupReference"]
    #: Optional :class:`commercetools.types.CustomerReference` `(Named` ``oldCustomer`` `in Commercetools)`
    old_customer: typing.Optional["CustomerReference"]
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``oldCustomerGroup`` `in Commercetools)`
    old_customer_group: typing.Optional["CustomerGroupReference"]

    def __init__(
        self,
        *,
        customer: typing.Optional["CustomerReference"] = None,
        customer_group: typing.Optional["CustomerGroupReference"] = None,
        old_customer: typing.Optional["CustomerReference"] = None,
        old_customer_group: typing.Optional["CustomerGroupReference"] = None
    ) -> None:
        self.customer = customer
        self.customer_group = customer_group
        self.old_customer = old_customer
        self.old_customer_group = old_customer_group
        super().__init__(type="OrderCustomerSet")

    def __repr__(self) -> str:
        return (
            "OrderCustomerSetMessagePayload(type=%r, customer=%r, customer_group=%r, old_customer=%r, old_customer_group=%r)"
            % (
                self.type,
                self.customer,
                self.customer_group,
                self.old_customer,
                self.old_customer_group,
            )
        )


class OrderDeletedMessage(Message):
    #: :class:`commercetools.types.Order`
    order: "Order"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        order: "Order",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.order = order
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderDeleted",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderDeletedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, order=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.order,
            )
        )


class OrderDeletedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Order`
    order: "Order"

    def __init__(self, *, order: "Order") -> None:
        self.order = order
        super().__init__(type="OrderDeleted")

    def __repr__(self) -> str:
        return "OrderDeletedMessagePayload(type=%r, order=%r)" % (self.type, self.order)


class OrderDiscountCodeAddedMessage(Message):
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: "DiscountCodeReference"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        discount_code: "DiscountCodeReference",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.discount_code = discount_code
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderDiscountCodeAdded",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderDiscountCodeAddedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, discount_code=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.discount_code,
            )
        )


class OrderDiscountCodeAddedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: "DiscountCodeReference"

    def __init__(self, *, discount_code: "DiscountCodeReference") -> None:
        self.discount_code = discount_code
        super().__init__(type="OrderDiscountCodeAdded")

    def __repr__(self) -> str:
        return "OrderDiscountCodeAddedMessagePayload(type=%r, discount_code=%r)" % (
            self.type,
            self.discount_code,
        )


class OrderDiscountCodeRemovedMessage(Message):
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: "DiscountCodeReference"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        discount_code: "DiscountCodeReference",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.discount_code = discount_code
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderDiscountCodeRemoved",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderDiscountCodeRemovedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, discount_code=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.discount_code,
            )
        )


class OrderDiscountCodeRemovedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: "DiscountCodeReference"

    def __init__(self, *, discount_code: "DiscountCodeReference") -> None:
        self.discount_code = discount_code
        super().__init__(type="OrderDiscountCodeRemoved")

    def __repr__(self) -> str:
        return "OrderDiscountCodeRemovedMessagePayload(type=%r, discount_code=%r)" % (
            self.type,
            self.discount_code,
        )


class OrderDiscountCodeStateSetMessage(Message):
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: "DiscountCodeReference"
    #: :class:`commercetools.types.DiscountCodeState`
    state: "DiscountCodeState"
    #: Optional :class:`commercetools.types.DiscountCodeState` `(Named` ``oldState`` `in Commercetools)`
    old_state: typing.Optional["DiscountCodeState"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        discount_code: "DiscountCodeReference",
        state: "DiscountCodeState",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        old_state: typing.Optional["DiscountCodeState"] = None
    ) -> None:
        self.discount_code = discount_code
        self.state = state
        self.old_state = old_state
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderDiscountCodeStateSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderDiscountCodeStateSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, discount_code=%r, state=%r, old_state=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.discount_code,
                self.state,
                self.old_state,
            )
        )


class OrderDiscountCodeStateSetMessagePayload(MessagePayload):
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: "DiscountCodeReference"
    #: :class:`commercetools.types.DiscountCodeState`
    state: "DiscountCodeState"
    #: Optional :class:`commercetools.types.DiscountCodeState` `(Named` ``oldState`` `in Commercetools)`
    old_state: typing.Optional["DiscountCodeState"]

    def __init__(
        self,
        *,
        discount_code: "DiscountCodeReference",
        state: "DiscountCodeState",
        old_state: typing.Optional["DiscountCodeState"] = None
    ) -> None:
        self.discount_code = discount_code
        self.state = state
        self.old_state = old_state
        super().__init__(type="OrderDiscountCodeStateSet")

    def __repr__(self) -> str:
        return (
            "OrderDiscountCodeStateSetMessagePayload(type=%r, discount_code=%r, state=%r, old_state=%r)"
            % (self.type, self.discount_code, self.state, self.old_state)
        )


class OrderEditAppliedMessage(Message):
    #: :class:`commercetools.types.OrderEditReference`
    edit: "OrderEditReference"
    #: :class:`commercetools.types.OrderEditApplied`
    result: "OrderEditApplied"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        edit: "OrderEditReference",
        result: "OrderEditApplied",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.edit = edit
        self.result = result
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderEditApplied",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderEditAppliedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, edit=%r, result=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.edit,
                self.result,
            )
        )


class OrderEditAppliedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.OrderEditReference`
    edit: "OrderEditReference"
    #: :class:`commercetools.types.OrderEditApplied`
    result: "OrderEditApplied"

    def __init__(
        self, *, edit: "OrderEditReference", result: "OrderEditApplied"
    ) -> None:
        self.edit = edit
        self.result = result
        super().__init__(type="OrderEditApplied")

    def __repr__(self) -> str:
        return "OrderEditAppliedMessagePayload(type=%r, edit=%r, result=%r)" % (
            self.type,
            self.edit,
            self.result,
        )


class OrderImportedMessage(Message):
    #: :class:`commercetools.types.Order`
    order: "Order"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        order: "Order",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.order = order
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderImported",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderImportedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, order=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.order,
            )
        )


class OrderImportedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Order`
    order: "Order"

    def __init__(self, *, order: "Order") -> None:
        self.order = order
        super().__init__(type="OrderImported")

    def __repr__(self) -> str:
        return "OrderImportedMessagePayload(type=%r, order=%r)" % (
            self.type,
            self.order,
        )


class OrderLineItemAddedMessage(Message):
    #: :class:`commercetools.types.LineItem` `(Named` ``lineItem`` `in Commercetools)`
    line_item: "LineItem"
    #: :class:`int` `(Named` ``addedQuantity`` `in Commercetools)`
    added_quantity: int

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        line_item: "LineItem",
        added_quantity: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.line_item = line_item
        self.added_quantity = added_quantity
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderLineItemAdded",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderLineItemAddedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, line_item=%r, added_quantity=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.line_item,
                self.added_quantity,
            )
        )


class OrderLineItemAddedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.LineItem` `(Named` ``lineItem`` `in Commercetools)`
    line_item: "LineItem"
    #: :class:`int` `(Named` ``addedQuantity`` `in Commercetools)`
    added_quantity: int

    def __init__(self, *, line_item: "LineItem", added_quantity: int) -> None:
        self.line_item = line_item
        self.added_quantity = added_quantity
        super().__init__(type="OrderLineItemAdded")

    def __repr__(self) -> str:
        return (
            "OrderLineItemAddedMessagePayload(type=%r, line_item=%r, added_quantity=%r)"
            % (self.type, self.line_item, self.added_quantity)
        )


class OrderLineItemDiscountSetMessage(Message):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: List of :class:`commercetools.types.DiscountedLineItemPriceForQuantity` `(Named` ``discountedPricePerQuantity`` `in Commercetools)`
    discounted_price_per_quantity: typing.List["DiscountedLineItemPriceForQuantity"]
    #: :class:`commercetools.types.Money` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: "Money"
    #: Optional :class:`commercetools.types.TaxedItemPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedItemPrice"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        line_item_id: str,
        discounted_price_per_quantity: typing.List[
            "DiscountedLineItemPriceForQuantity"
        ],
        total_price: "Money",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        taxed_price: typing.Optional["TaxedItemPrice"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.discounted_price_per_quantity = discounted_price_per_quantity
        self.total_price = total_price
        self.taxed_price = taxed_price
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderLineItemDiscountSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderLineItemDiscountSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, line_item_id=%r, discounted_price_per_quantity=%r, total_price=%r, taxed_price=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.line_item_id,
                self.discounted_price_per_quantity,
                self.total_price,
                self.taxed_price,
            )
        )


class OrderLineItemDiscountSetMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: str
    #: List of :class:`commercetools.types.DiscountedLineItemPriceForQuantity` `(Named` ``discountedPricePerQuantity`` `in Commercetools)`
    discounted_price_per_quantity: typing.List["DiscountedLineItemPriceForQuantity"]
    #: :class:`commercetools.types.Money` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: "Money"
    #: Optional :class:`commercetools.types.TaxedItemPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedItemPrice"]

    def __init__(
        self,
        *,
        line_item_id: str,
        discounted_price_per_quantity: typing.List[
            "DiscountedLineItemPriceForQuantity"
        ],
        total_price: "Money",
        taxed_price: typing.Optional["TaxedItemPrice"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.discounted_price_per_quantity = discounted_price_per_quantity
        self.total_price = total_price
        self.taxed_price = taxed_price
        super().__init__(type="OrderLineItemDiscountSet")

    def __repr__(self) -> str:
        return (
            "OrderLineItemDiscountSetMessagePayload(type=%r, line_item_id=%r, discounted_price_per_quantity=%r, total_price=%r, taxed_price=%r)"
            % (
                self.type,
                self.line_item_id,
                self.discounted_price_per_quantity,
                self.total_price,
                self.taxed_price,
            )
        )


class OrderPaymentStateChangedMessage(Message):
    #: :class:`commercetools.types.PaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: "PaymentState"
    #: Optional :class:`commercetools.types.PaymentState` `(Named` ``oldPaymentState`` `in Commercetools)`
    old_payment_state: typing.Optional["PaymentState"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        payment_state: "PaymentState",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        old_payment_state: typing.Optional["PaymentState"] = None
    ) -> None:
        self.payment_state = payment_state
        self.old_payment_state = old_payment_state
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderPaymentStateChanged",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderPaymentStateChangedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, payment_state=%r, old_payment_state=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.payment_state,
                self.old_payment_state,
            )
        )


class OrderPaymentStateChangedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.PaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: "PaymentState"
    #: Optional :class:`commercetools.types.PaymentState` `(Named` ``oldPaymentState`` `in Commercetools)`
    old_payment_state: typing.Optional["PaymentState"]

    def __init__(
        self,
        *,
        payment_state: "PaymentState",
        old_payment_state: typing.Optional["PaymentState"] = None
    ) -> None:
        self.payment_state = payment_state
        self.old_payment_state = old_payment_state
        super().__init__(type="OrderPaymentStateChanged")

    def __repr__(self) -> str:
        return (
            "OrderPaymentStateChangedMessagePayload(type=%r, payment_state=%r, old_payment_state=%r)"
            % (self.type, self.payment_state, self.old_payment_state)
        )


class OrderReturnInfoAddedMessage(Message):
    #: :class:`commercetools.types.ReturnInfo` `(Named` ``returnInfo`` `in Commercetools)`
    return_info: "ReturnInfo"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        return_info: "ReturnInfo",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.return_info = return_info
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ReturnInfoAdded",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderReturnInfoAddedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, return_info=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.return_info,
            )
        )


class OrderReturnInfoAddedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.ReturnInfo` `(Named` ``returnInfo`` `in Commercetools)`
    return_info: "ReturnInfo"

    def __init__(self, *, return_info: "ReturnInfo") -> None:
        self.return_info = return_info
        super().__init__(type="ReturnInfoAdded")

    def __repr__(self) -> str:
        return "OrderReturnInfoAddedMessagePayload(type=%r, return_info=%r)" % (
            self.type,
            self.return_info,
        )


class OrderReturnShipmentStateChangedMessage(Message):
    #: :class:`str` `(Named` ``returnItemId`` `in Commercetools)`
    return_item_id: str
    #: :class:`commercetools.types.ReturnShipmentState` `(Named` ``returnShipmentState`` `in Commercetools)`
    return_shipment_state: "ReturnShipmentState"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        return_item_id: str,
        return_shipment_state: "ReturnShipmentState",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.return_item_id = return_item_id
        self.return_shipment_state = return_shipment_state
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderReturnShipmentStateChanged",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderReturnShipmentStateChangedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, return_item_id=%r, return_shipment_state=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.return_item_id,
                self.return_shipment_state,
            )
        )


class OrderReturnShipmentStateChangedMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``returnItemId`` `in Commercetools)`
    return_item_id: str
    #: :class:`commercetools.types.ReturnShipmentState` `(Named` ``returnShipmentState`` `in Commercetools)`
    return_shipment_state: "ReturnShipmentState"

    def __init__(
        self, *, return_item_id: str, return_shipment_state: "ReturnShipmentState"
    ) -> None:
        self.return_item_id = return_item_id
        self.return_shipment_state = return_shipment_state
        super().__init__(type="OrderReturnShipmentStateChanged")

    def __repr__(self) -> str:
        return (
            "OrderReturnShipmentStateChangedMessagePayload(type=%r, return_item_id=%r, return_shipment_state=%r)"
            % (self.type, self.return_item_id, self.return_shipment_state)
        )


class OrderShipmentStateChangedMessage(Message):
    #: :class:`commercetools.types.ShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: "ShipmentState"
    #: Optional :class:`commercetools.types.ShipmentState` `(Named` ``oldShipmentState`` `in Commercetools)`
    old_shipment_state: typing.Optional["ShipmentState"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        shipment_state: "ShipmentState",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        old_shipment_state: typing.Optional["ShipmentState"] = None
    ) -> None:
        self.shipment_state = shipment_state
        self.old_shipment_state = old_shipment_state
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderShipmentStateChanged",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderShipmentStateChangedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, shipment_state=%r, old_shipment_state=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.shipment_state,
                self.old_shipment_state,
            )
        )


class OrderShipmentStateChangedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.ShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: "ShipmentState"
    #: Optional :class:`commercetools.types.ShipmentState` `(Named` ``oldShipmentState`` `in Commercetools)`
    old_shipment_state: typing.Optional["ShipmentState"]

    def __init__(
        self,
        *,
        shipment_state: "ShipmentState",
        old_shipment_state: typing.Optional["ShipmentState"] = None
    ) -> None:
        self.shipment_state = shipment_state
        self.old_shipment_state = old_shipment_state
        super().__init__(type="OrderShipmentStateChanged")

    def __repr__(self) -> str:
        return (
            "OrderShipmentStateChangedMessagePayload(type=%r, shipment_state=%r, old_shipment_state=%r)"
            % (self.type, self.shipment_state, self.old_shipment_state)
        )


class OrderShippingAddressSetMessage(Message):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``oldAddress`` `in Commercetools)`
    old_address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        address: typing.Optional["Address"] = None,
        old_address: typing.Optional["Address"] = None
    ) -> None:
        self.address = address
        self.old_address = old_address
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderShippingAddressSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderShippingAddressSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, address=%r, old_address=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.address,
                self.old_address,
            )
        )


class OrderShippingAddressSetMessagePayload(MessagePayload):
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.Address` `(Named` ``oldAddress`` `in Commercetools)`
    old_address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        address: typing.Optional["Address"] = None,
        old_address: typing.Optional["Address"] = None
    ) -> None:
        self.address = address
        self.old_address = old_address
        super().__init__(type="OrderShippingAddressSet")

    def __repr__(self) -> str:
        return (
            "OrderShippingAddressSetMessagePayload(type=%r, address=%r, old_address=%r)"
            % (self.type, self.address, self.old_address)
        )


class OrderShippingInfoSetMessage(Message):
    #: Optional :class:`commercetools.types.ShippingInfo` `(Named` ``shippingInfo`` `in Commercetools)`
    shipping_info: typing.Optional["ShippingInfo"]
    #: Optional :class:`commercetools.types.ShippingInfo` `(Named` ``oldShippingInfo`` `in Commercetools)`
    old_shipping_info: typing.Optional["ShippingInfo"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        shipping_info: typing.Optional["ShippingInfo"] = None,
        old_shipping_info: typing.Optional["ShippingInfo"] = None
    ) -> None:
        self.shipping_info = shipping_info
        self.old_shipping_info = old_shipping_info
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderShippingInfoSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderShippingInfoSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, shipping_info=%r, old_shipping_info=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.shipping_info,
                self.old_shipping_info,
            )
        )


class OrderShippingInfoSetMessagePayload(MessagePayload):
    #: Optional :class:`commercetools.types.ShippingInfo` `(Named` ``shippingInfo`` `in Commercetools)`
    shipping_info: typing.Optional["ShippingInfo"]
    #: Optional :class:`commercetools.types.ShippingInfo` `(Named` ``oldShippingInfo`` `in Commercetools)`
    old_shipping_info: typing.Optional["ShippingInfo"]

    def __init__(
        self,
        *,
        shipping_info: typing.Optional["ShippingInfo"] = None,
        old_shipping_info: typing.Optional["ShippingInfo"] = None
    ) -> None:
        self.shipping_info = shipping_info
        self.old_shipping_info = old_shipping_info
        super().__init__(type="OrderShippingInfoSet")

    def __repr__(self) -> str:
        return (
            "OrderShippingInfoSetMessagePayload(type=%r, shipping_info=%r, old_shipping_info=%r)"
            % (self.type, self.shipping_info, self.old_shipping_info)
        )


class OrderShippingRateInputSetMessage(Message):
    #: Optional :class:`commercetools.types.ShippingRateInput` `(Named` ``shippingRateInput`` `in Commercetools)`
    shipping_rate_input: typing.Optional["ShippingRateInput"]
    #: Optional :class:`commercetools.types.ShippingRateInput` `(Named` ``oldShippingRateInput`` `in Commercetools)`
    old_shipping_rate_input: typing.Optional["ShippingRateInput"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        shipping_rate_input: typing.Optional["ShippingRateInput"] = None,
        old_shipping_rate_input: typing.Optional["ShippingRateInput"] = None
    ) -> None:
        self.shipping_rate_input = shipping_rate_input
        self.old_shipping_rate_input = old_shipping_rate_input
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderShippingRateInputSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderShippingRateInputSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, shipping_rate_input=%r, old_shipping_rate_input=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.shipping_rate_input,
                self.old_shipping_rate_input,
            )
        )


class OrderShippingRateInputSetMessagePayload(MessagePayload):
    #: Optional :class:`commercetools.types.ShippingRateInput` `(Named` ``shippingRateInput`` `in Commercetools)`
    shipping_rate_input: typing.Optional["ShippingRateInput"]
    #: Optional :class:`commercetools.types.ShippingRateInput` `(Named` ``oldShippingRateInput`` `in Commercetools)`
    old_shipping_rate_input: typing.Optional["ShippingRateInput"]

    def __init__(
        self,
        *,
        shipping_rate_input: typing.Optional["ShippingRateInput"] = None,
        old_shipping_rate_input: typing.Optional["ShippingRateInput"] = None
    ) -> None:
        self.shipping_rate_input = shipping_rate_input
        self.old_shipping_rate_input = old_shipping_rate_input
        super().__init__(type="OrderShippingRateInputSet")

    def __repr__(self) -> str:
        return (
            "OrderShippingRateInputSetMessagePayload(type=%r, shipping_rate_input=%r, old_shipping_rate_input=%r)"
            % (self.type, self.shipping_rate_input, self.old_shipping_rate_input)
        )


class OrderStateChangedMessage(Message):
    #: :class:`commercetools.types.OrderState` `(Named` ``orderState`` `in Commercetools)`
    order_state: "OrderState"
    #: :class:`commercetools.types.OrderState` `(Named` ``oldOrderState`` `in Commercetools)`
    old_order_state: "OrderState"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        order_state: "OrderState",
        old_order_state: "OrderState",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.order_state = order_state
        self.old_order_state = old_order_state
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderStateChanged",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderStateChangedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, order_state=%r, old_order_state=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.order_state,
                self.old_order_state,
            )
        )


class OrderStateChangedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.OrderState` `(Named` ``orderState`` `in Commercetools)`
    order_state: "OrderState"
    #: :class:`commercetools.types.OrderState` `(Named` ``oldOrderState`` `in Commercetools)`
    old_order_state: "OrderState"

    def __init__(
        self, *, order_state: "OrderState", old_order_state: "OrderState"
    ) -> None:
        self.order_state = order_state
        self.old_order_state = old_order_state
        super().__init__(type="OrderStateChanged")

    def __repr__(self) -> str:
        return (
            "OrderStateChangedMessagePayload(type=%r, order_state=%r, old_order_state=%r)"
            % (self.type, self.order_state, self.old_order_state)
        )


class OrderStateTransitionMessage(Message):
    #: :class:`commercetools.types.StateReference`
    state: "StateReference"
    #: :class:`bool`
    force: bool

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        state: "StateReference",
        force: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.state = state
        self.force = force
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderStateTransition",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderStateTransitionMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, state=%r, force=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.state,
                self.force,
            )
        )


class OrderStateTransitionMessagePayload(MessagePayload):
    #: :class:`commercetools.types.StateReference`
    state: "StateReference"
    #: :class:`bool`
    force: bool

    def __init__(self, *, state: "StateReference", force: bool) -> None:
        self.state = state
        self.force = force
        super().__init__(type="OrderStateTransition")

    def __repr__(self) -> str:
        return "OrderStateTransitionMessagePayload(type=%r, state=%r, force=%r)" % (
            self.type,
            self.state,
            self.force,
        )


class OrderStoreSetMessage(Message):
    #: :class:`commercetools.types.StoreKeyReference`
    store: "StoreKeyReference"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        store: "StoreKeyReference",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.store = store
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="OrderStoreSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "OrderStoreSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, store=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.store,
            )
        )


class OrderStoreSetMessagePayload(MessagePayload):
    #: :class:`commercetools.types.StoreKeyReference`
    store: "StoreKeyReference"

    def __init__(self, *, store: "StoreKeyReference") -> None:
        self.store = store
        super().__init__(type="OrderStoreSet")

    def __repr__(self) -> str:
        return "OrderStoreSetMessagePayload(type=%r, store=%r)" % (
            self.type,
            self.store,
        )


class ParcelAddedToDeliveryMessage(Message):
    #: :class:`commercetools.types.Delivery`
    delivery: "Delivery"
    #: :class:`commercetools.types.Parcel`
    parcel: "Parcel"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        delivery: "Delivery",
        parcel: "Parcel",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.delivery = delivery
        self.parcel = parcel
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ParcelAddedToDelivery",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ParcelAddedToDeliveryMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, delivery=%r, parcel=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.delivery,
                self.parcel,
            )
        )


class ParcelAddedToDeliveryMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Delivery`
    delivery: "Delivery"
    #: :class:`commercetools.types.Parcel`
    parcel: "Parcel"

    def __init__(self, *, delivery: "Delivery", parcel: "Parcel") -> None:
        self.delivery = delivery
        self.parcel = parcel
        super().__init__(type="ParcelAddedToDelivery")

    def __repr__(self) -> str:
        return (
            "ParcelAddedToDeliveryMessagePayload(type=%r, delivery=%r, parcel=%r)"
            % (self.type, self.delivery, self.parcel)
        )


class ParcelItemsUpdatedMessage(Message):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: typing.Optional[str]
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.List["DeliveryItem"]
    #: List of :class:`commercetools.types.DeliveryItem` `(Named` ``oldItems`` `in Commercetools)`
    old_items: typing.List["DeliveryItem"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        parcel_id: str,
        items: typing.List["DeliveryItem"],
        old_items: typing.List["DeliveryItem"],
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        delivery_id: typing.Optional[str] = None
    ) -> None:
        self.parcel_id = parcel_id
        self.delivery_id = delivery_id
        self.items = items
        self.old_items = old_items
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ParcelItemsUpdated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ParcelItemsUpdatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, parcel_id=%r, delivery_id=%r, items=%r, old_items=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.parcel_id,
                self.delivery_id,
                self.items,
                self.old_items,
            )
        )


class ParcelItemsUpdatedMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: typing.Optional[str]
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.List["DeliveryItem"]
    #: List of :class:`commercetools.types.DeliveryItem` `(Named` ``oldItems`` `in Commercetools)`
    old_items: typing.List["DeliveryItem"]

    def __init__(
        self,
        *,
        parcel_id: str,
        items: typing.List["DeliveryItem"],
        old_items: typing.List["DeliveryItem"],
        delivery_id: typing.Optional[str] = None
    ) -> None:
        self.parcel_id = parcel_id
        self.delivery_id = delivery_id
        self.items = items
        self.old_items = old_items
        super().__init__(type="ParcelItemsUpdated")

    def __repr__(self) -> str:
        return (
            "ParcelItemsUpdatedMessagePayload(type=%r, parcel_id=%r, delivery_id=%r, items=%r, old_items=%r)"
            % (self.type, self.parcel_id, self.delivery_id, self.items, self.old_items)
        )


class ParcelMeasurementsUpdatedMessage(Message):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        delivery_id: str,
        parcel_id: str,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        measurements: typing.Optional["ParcelMeasurements"] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.parcel_id = parcel_id
        self.measurements = measurements
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ParcelMeasurementsUpdated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ParcelMeasurementsUpdatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, delivery_id=%r, parcel_id=%r, measurements=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.delivery_id,
                self.parcel_id,
                self.measurements,
            )
        )


class ParcelMeasurementsUpdatedMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]

    def __init__(
        self,
        *,
        delivery_id: str,
        parcel_id: str,
        measurements: typing.Optional["ParcelMeasurements"] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.parcel_id = parcel_id
        self.measurements = measurements
        super().__init__(type="ParcelMeasurementsUpdated")

    def __repr__(self) -> str:
        return (
            "ParcelMeasurementsUpdatedMessagePayload(type=%r, delivery_id=%r, parcel_id=%r, measurements=%r)"
            % (self.type, self.delivery_id, self.parcel_id, self.measurements)
        )


class ParcelRemovedFromDeliveryMessage(Message):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: :class:`commercetools.types.Parcel`
    parcel: "Parcel"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        delivery_id: str,
        parcel: "Parcel",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.parcel = parcel
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ParcelRemovedFromDelivery",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ParcelRemovedFromDeliveryMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, delivery_id=%r, parcel=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.delivery_id,
                self.parcel,
            )
        )


class ParcelRemovedFromDeliveryMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: :class:`commercetools.types.Parcel`
    parcel: "Parcel"

    def __init__(self, *, delivery_id: str, parcel: "Parcel") -> None:
        self.delivery_id = delivery_id
        self.parcel = parcel
        super().__init__(type="ParcelRemovedFromDelivery")

    def __repr__(self) -> str:
        return (
            "ParcelRemovedFromDeliveryMessagePayload(type=%r, delivery_id=%r, parcel=%r)"
            % (self.type, self.delivery_id, self.parcel)
        )


class ParcelTrackingDataUpdatedMessage(Message):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        delivery_id: str,
        parcel_id: str,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        tracking_data: typing.Optional["TrackingData"] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.parcel_id = parcel_id
        self.tracking_data = tracking_data
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ParcelTrackingDataUpdated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ParcelTrackingDataUpdatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, delivery_id=%r, parcel_id=%r, tracking_data=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.delivery_id,
                self.parcel_id,
                self.tracking_data,
            )
        )


class ParcelTrackingDataUpdatedMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: str
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: str
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]

    def __init__(
        self,
        *,
        delivery_id: str,
        parcel_id: str,
        tracking_data: typing.Optional["TrackingData"] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.parcel_id = parcel_id
        self.tracking_data = tracking_data
        super().__init__(type="ParcelTrackingDataUpdated")

    def __repr__(self) -> str:
        return (
            "ParcelTrackingDataUpdatedMessagePayload(type=%r, delivery_id=%r, parcel_id=%r, tracking_data=%r)"
            % (self.type, self.delivery_id, self.parcel_id, self.tracking_data)
        )


class PaymentCreatedMessage(Message):
    #: :class:`commercetools.types.Payment`
    payment: "Payment"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        payment: "Payment",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.payment = payment
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="PaymentCreated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "PaymentCreatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, payment=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.payment,
            )
        )


class PaymentCreatedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Payment`
    payment: "Payment"

    def __init__(self, *, payment: "Payment") -> None:
        self.payment = payment
        super().__init__(type="PaymentCreated")

    def __repr__(self) -> str:
        return "PaymentCreatedMessagePayload(type=%r, payment=%r)" % (
            self.type,
            self.payment,
        )


class PaymentInteractionAddedMessage(Message):
    #: :class:`commercetools.types.CustomFields`
    interaction: "CustomFields"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        interaction: "CustomFields",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.interaction = interaction
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="PaymentInteractionAdded",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "PaymentInteractionAddedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, interaction=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.interaction,
            )
        )


class PaymentInteractionAddedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.CustomFields`
    interaction: "CustomFields"

    def __init__(self, *, interaction: "CustomFields") -> None:
        self.interaction = interaction
        super().__init__(type="PaymentInteractionAdded")

    def __repr__(self) -> str:
        return "PaymentInteractionAddedMessagePayload(type=%r, interaction=%r)" % (
            self.type,
            self.interaction,
        )


class PaymentStatusInterfaceCodeSetMessage(Message):
    #: :class:`str` `(Named` ``paymentId`` `in Commercetools)`
    payment_id: str
    #: :class:`str` `(Named` ``interfaceCode`` `in Commercetools)`
    interface_code: str

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        payment_id: str,
        interface_code: str,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.payment_id = payment_id
        self.interface_code = interface_code
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="PaymentStatusInterfaceCodeSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "PaymentStatusInterfaceCodeSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, payment_id=%r, interface_code=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.payment_id,
                self.interface_code,
            )
        )


class PaymentStatusInterfaceCodeSetMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``paymentId`` `in Commercetools)`
    payment_id: str
    #: :class:`str` `(Named` ``interfaceCode`` `in Commercetools)`
    interface_code: str

    def __init__(self, *, payment_id: str, interface_code: str) -> None:
        self.payment_id = payment_id
        self.interface_code = interface_code
        super().__init__(type="PaymentStatusInterfaceCodeSet")

    def __repr__(self) -> str:
        return (
            "PaymentStatusInterfaceCodeSetMessagePayload(type=%r, payment_id=%r, interface_code=%r)"
            % (self.type, self.payment_id, self.interface_code)
        )


class PaymentStatusStateTransitionMessage(Message):
    #: :class:`commercetools.types.StateReference`
    state: "StateReference"
    #: :class:`bool`
    force: bool

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        state: "StateReference",
        force: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.state = state
        self.force = force
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="PaymentStatusStateTransition",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "PaymentStatusStateTransitionMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, state=%r, force=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.state,
                self.force,
            )
        )


class PaymentStatusStateTransitionMessagePayload(MessagePayload):
    #: :class:`commercetools.types.StateReference`
    state: "StateReference"
    #: :class:`bool`
    force: bool

    def __init__(self, *, state: "StateReference", force: bool) -> None:
        self.state = state
        self.force = force
        super().__init__(type="PaymentStatusStateTransition")

    def __repr__(self) -> str:
        return (
            "PaymentStatusStateTransitionMessagePayload(type=%r, state=%r, force=%r)"
            % (self.type, self.state, self.force)
        )


class PaymentTransactionAddedMessage(Message):
    #: :class:`commercetools.types.Transaction`
    transaction: "Transaction"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        transaction: "Transaction",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.transaction = transaction
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="PaymentTransactionAdded",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "PaymentTransactionAddedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, transaction=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.transaction,
            )
        )


class PaymentTransactionAddedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Transaction`
    transaction: "Transaction"

    def __init__(self, *, transaction: "Transaction") -> None:
        self.transaction = transaction
        super().__init__(type="PaymentTransactionAdded")

    def __repr__(self) -> str:
        return "PaymentTransactionAddedMessagePayload(type=%r, transaction=%r)" % (
            self.type,
            self.transaction,
        )


class PaymentTransactionStateChangedMessage(Message):
    #: :class:`str` `(Named` ``transactionId`` `in Commercetools)`
    transaction_id: str
    #: :class:`commercetools.types.TransactionState`
    state: "TransactionState"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        transaction_id: str,
        state: "TransactionState",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.transaction_id = transaction_id
        self.state = state
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="PaymentTransactionStateChanged",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "PaymentTransactionStateChangedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, transaction_id=%r, state=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.transaction_id,
                self.state,
            )
        )


class PaymentTransactionStateChangedMessagePayload(MessagePayload):
    #: :class:`str` `(Named` ``transactionId`` `in Commercetools)`
    transaction_id: str
    #: :class:`commercetools.types.TransactionState`
    state: "TransactionState"

    def __init__(self, *, transaction_id: str, state: "TransactionState") -> None:
        self.transaction_id = transaction_id
        self.state = state
        super().__init__(type="PaymentTransactionStateChanged")

    def __repr__(self) -> str:
        return (
            "PaymentTransactionStateChangedMessagePayload(type=%r, transaction_id=%r, state=%r)"
            % (self.type, self.transaction_id, self.state)
        )


class ProductAddedToCategoryMessage(Message):
    #: :class:`commercetools.types.CategoryReference`
    category: "CategoryReference"
    #: :class:`bool`
    staged: bool

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        category: "CategoryReference",
        staged: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.category = category
        self.staged = staged
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductAddedToCategory",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductAddedToCategoryMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, category=%r, staged=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.category,
                self.staged,
            )
        )


class ProductAddedToCategoryMessagePayload(MessagePayload):
    #: :class:`commercetools.types.CategoryReference`
    category: "CategoryReference"
    #: :class:`bool`
    staged: bool

    def __init__(self, *, category: "CategoryReference", staged: bool) -> None:
        self.category = category
        self.staged = staged
        super().__init__(type="ProductAddedToCategory")

    def __repr__(self) -> str:
        return (
            "ProductAddedToCategoryMessagePayload(type=%r, category=%r, staged=%r)"
            % (self.type, self.category, self.staged)
        )


class ProductCreatedMessage(Message):
    #: :class:`commercetools.types.ProductProjection` `(Named` ``productProjection`` `in Commercetools)`
    product_projection: "ProductProjection"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        product_projection: "ProductProjection",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.product_projection = product_projection
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductCreated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductCreatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, product_projection=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.product_projection,
            )
        )


class ProductCreatedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.ProductProjection` `(Named` ``productProjection`` `in Commercetools)`
    product_projection: "ProductProjection"

    def __init__(self, *, product_projection: "ProductProjection") -> None:
        self.product_projection = product_projection
        super().__init__(type="ProductCreated")

    def __repr__(self) -> str:
        return "ProductCreatedMessagePayload(type=%r, product_projection=%r)" % (
            self.type,
            self.product_projection,
        )


class ProductDeletedMessage(Message):
    #: :class:`list` `(Named` ``removedImageUrls`` `in Commercetools)`
    removed_image_urls: list
    #: :class:`commercetools.types.ProductProjection` `(Named` ``currentProjection`` `in Commercetools)`
    current_projection: "ProductProjection"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        removed_image_urls: list,
        current_projection: "ProductProjection",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.removed_image_urls = removed_image_urls
        self.current_projection = current_projection
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductDeleted",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductDeletedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, removed_image_urls=%r, current_projection=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.removed_image_urls,
                self.current_projection,
            )
        )


class ProductDeletedMessagePayload(MessagePayload):
    #: :class:`list` `(Named` ``removedImageUrls`` `in Commercetools)`
    removed_image_urls: list
    #: :class:`commercetools.types.ProductProjection` `(Named` ``currentProjection`` `in Commercetools)`
    current_projection: "ProductProjection"

    def __init__(
        self, *, removed_image_urls: list, current_projection: "ProductProjection"
    ) -> None:
        self.removed_image_urls = removed_image_urls
        self.current_projection = current_projection
        super().__init__(type="ProductDeleted")

    def __repr__(self) -> str:
        return (
            "ProductDeletedMessagePayload(type=%r, removed_image_urls=%r, current_projection=%r)"
            % (self.type, self.removed_image_urls, self.current_projection)
        )


class ProductImageAddedMessage(Message):
    #: :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: int
    #: :class:`commercetools.types.Image`
    image: "Image"
    #: :class:`bool`
    staged: bool

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        variant_id: int,
        image: "Image",
        staged: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.variant_id = variant_id
        self.image = image
        self.staged = staged
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductImageAdded",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductImageAddedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, variant_id=%r, image=%r, staged=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.variant_id,
                self.image,
                self.staged,
            )
        )


class ProductImageAddedMessagePayload(MessagePayload):
    #: :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: int
    #: :class:`commercetools.types.Image`
    image: "Image"
    #: :class:`bool`
    staged: bool

    def __init__(self, *, variant_id: int, image: "Image", staged: bool) -> None:
        self.variant_id = variant_id
        self.image = image
        self.staged = staged
        super().__init__(type="ProductImageAdded")

    def __repr__(self) -> str:
        return (
            "ProductImageAddedMessagePayload(type=%r, variant_id=%r, image=%r, staged=%r)"
            % (self.type, self.variant_id, self.image, self.staged)
        )


class ProductPriceDiscountsSetMessage(Message):
    #: List of :class:`commercetools.types.ProductPriceDiscountsSetUpdatedPrice` `(Named` ``updatedPrices`` `in Commercetools)`
    updated_prices: typing.List["ProductPriceDiscountsSetUpdatedPrice"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        updated_prices: typing.List["ProductPriceDiscountsSetUpdatedPrice"],
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.updated_prices = updated_prices
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductPriceDiscountsSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductPriceDiscountsSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, updated_prices=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.updated_prices,
            )
        )


class ProductPriceDiscountsSetMessagePayload(MessagePayload):
    #: List of :class:`commercetools.types.ProductPriceDiscountsSetUpdatedPrice` `(Named` ``updatedPrices`` `in Commercetools)`
    updated_prices: typing.List["ProductPriceDiscountsSetUpdatedPrice"]

    def __init__(
        self, *, updated_prices: typing.List["ProductPriceDiscountsSetUpdatedPrice"]
    ) -> None:
        self.updated_prices = updated_prices
        super().__init__(type="ProductPriceDiscountsSet")

    def __repr__(self) -> str:
        return "ProductPriceDiscountsSetMessagePayload(type=%r, updated_prices=%r)" % (
            self.type,
            self.updated_prices,
        )


class ProductPriceExternalDiscountSetMessage(Message):
    #: :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: int
    #: Optional :class:`str` `(Named` ``variantKey`` `in Commercetools)`
    variant_key: typing.Optional[str]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: :class:`str` `(Named` ``priceId`` `in Commercetools)`
    price_id: str
    #: Optional :class:`commercetools.types.DiscountedPrice`
    discounted: typing.Optional["DiscountedPrice"]
    #: :class:`bool`
    staged: bool

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        variant_id: int,
        price_id: str,
        staged: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        variant_key: typing.Optional[str] = None,
        sku: typing.Optional[str] = None,
        discounted: typing.Optional["DiscountedPrice"] = None
    ) -> None:
        self.variant_id = variant_id
        self.variant_key = variant_key
        self.sku = sku
        self.price_id = price_id
        self.discounted = discounted
        self.staged = staged
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductPriceExternalDiscountSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductPriceExternalDiscountSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, variant_id=%r, variant_key=%r, sku=%r, price_id=%r, discounted=%r, staged=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.variant_id,
                self.variant_key,
                self.sku,
                self.price_id,
                self.discounted,
                self.staged,
            )
        )


class ProductPriceExternalDiscountSetMessagePayload(MessagePayload):
    #: :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: int
    #: Optional :class:`str` `(Named` ``variantKey`` `in Commercetools)`
    variant_key: typing.Optional[str]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: :class:`str` `(Named` ``priceId`` `in Commercetools)`
    price_id: str
    #: Optional :class:`commercetools.types.DiscountedPrice`
    discounted: typing.Optional["DiscountedPrice"]
    #: :class:`bool`
    staged: bool

    def __init__(
        self,
        *,
        variant_id: int,
        price_id: str,
        staged: bool,
        variant_key: typing.Optional[str] = None,
        sku: typing.Optional[str] = None,
        discounted: typing.Optional["DiscountedPrice"] = None
    ) -> None:
        self.variant_id = variant_id
        self.variant_key = variant_key
        self.sku = sku
        self.price_id = price_id
        self.discounted = discounted
        self.staged = staged
        super().__init__(type="ProductPriceExternalDiscountSet")

    def __repr__(self) -> str:
        return (
            "ProductPriceExternalDiscountSetMessagePayload(type=%r, variant_id=%r, variant_key=%r, sku=%r, price_id=%r, discounted=%r, staged=%r)"
            % (
                self.type,
                self.variant_id,
                self.variant_key,
                self.sku,
                self.price_id,
                self.discounted,
                self.staged,
            )
        )


class ProductPublishedMessage(Message):
    #: :class:`list` `(Named` ``removedImageUrls`` `in Commercetools)`
    removed_image_urls: list
    #: :class:`commercetools.types.ProductProjection` `(Named` ``productProjection`` `in Commercetools)`
    product_projection: "ProductProjection"
    #: :class:`commercetools.types.ProductPublishScope`
    scope: "ProductPublishScope"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        removed_image_urls: list,
        product_projection: "ProductProjection",
        scope: "ProductPublishScope",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.removed_image_urls = removed_image_urls
        self.product_projection = product_projection
        self.scope = scope
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductPublished",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductPublishedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, removed_image_urls=%r, product_projection=%r, scope=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.removed_image_urls,
                self.product_projection,
                self.scope,
            )
        )


class ProductPublishedMessagePayload(MessagePayload):
    #: :class:`list` `(Named` ``removedImageUrls`` `in Commercetools)`
    removed_image_urls: list
    #: :class:`commercetools.types.ProductProjection` `(Named` ``productProjection`` `in Commercetools)`
    product_projection: "ProductProjection"
    #: :class:`commercetools.types.ProductPublishScope`
    scope: "ProductPublishScope"

    def __init__(
        self,
        *,
        removed_image_urls: list,
        product_projection: "ProductProjection",
        scope: "ProductPublishScope"
    ) -> None:
        self.removed_image_urls = removed_image_urls
        self.product_projection = product_projection
        self.scope = scope
        super().__init__(type="ProductPublished")

    def __repr__(self) -> str:
        return (
            "ProductPublishedMessagePayload(type=%r, removed_image_urls=%r, product_projection=%r, scope=%r)"
            % (self.type, self.removed_image_urls, self.product_projection, self.scope)
        )


class ProductRemovedFromCategoryMessage(Message):
    #: :class:`commercetools.types.CategoryReference`
    category: "CategoryReference"
    #: :class:`bool`
    staged: bool

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        category: "CategoryReference",
        staged: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.category = category
        self.staged = staged
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductRemovedFromCategory",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductRemovedFromCategoryMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, category=%r, staged=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.category,
                self.staged,
            )
        )


class ProductRemovedFromCategoryMessagePayload(MessagePayload):
    #: :class:`commercetools.types.CategoryReference`
    category: "CategoryReference"
    #: :class:`bool`
    staged: bool

    def __init__(self, *, category: "CategoryReference", staged: bool) -> None:
        self.category = category
        self.staged = staged
        super().__init__(type="ProductRemovedFromCategory")

    def __repr__(self) -> str:
        return (
            "ProductRemovedFromCategoryMessagePayload(type=%r, category=%r, staged=%r)"
            % (self.type, self.category, self.staged)
        )


class ProductRevertedStagedChangesMessage(Message):
    #: :class:`list` `(Named` ``removedImageUrls`` `in Commercetools)`
    removed_image_urls: list

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        removed_image_urls: list,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.removed_image_urls = removed_image_urls
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductRevertedStagedChanges",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductRevertedStagedChangesMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, removed_image_urls=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.removed_image_urls,
            )
        )


class ProductRevertedStagedChangesMessagePayload(MessagePayload):
    #: :class:`list` `(Named` ``removedImageUrls`` `in Commercetools)`
    removed_image_urls: list

    def __init__(self, *, removed_image_urls: list) -> None:
        self.removed_image_urls = removed_image_urls
        super().__init__(type="ProductRevertedStagedChanges")

    def __repr__(self) -> str:
        return (
            "ProductRevertedStagedChangesMessagePayload(type=%r, removed_image_urls=%r)"
            % (self.type, self.removed_image_urls)
        )


class ProductSlugChangedMessage(Message):
    #: :class:`commercetools.types.LocalizedString`
    slug: "LocalizedString"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        slug: "LocalizedString",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.slug = slug
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductSlugChanged",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductSlugChangedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, slug=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.slug,
            )
        )


class ProductSlugChangedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.LocalizedString`
    slug: "LocalizedString"

    def __init__(self, *, slug: "LocalizedString") -> None:
        self.slug = slug
        super().__init__(type="ProductSlugChanged")

    def __repr__(self) -> str:
        return "ProductSlugChangedMessagePayload(type=%r, slug=%r)" % (
            self.type,
            self.slug,
        )


class ProductStateTransitionMessage(Message):
    #: :class:`commercetools.types.StateReference`
    state: "StateReference"
    #: :class:`bool`
    force: bool

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        state: "StateReference",
        force: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.state = state
        self.force = force
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductStateTransition",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductStateTransitionMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, state=%r, force=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.state,
                self.force,
            )
        )


class ProductStateTransitionMessagePayload(MessagePayload):
    #: :class:`commercetools.types.StateReference`
    state: "StateReference"
    #: :class:`bool`
    force: bool

    def __init__(self, *, state: "StateReference", force: bool) -> None:
        self.state = state
        self.force = force
        super().__init__(type="ProductStateTransition")

    def __repr__(self) -> str:
        return "ProductStateTransitionMessagePayload(type=%r, state=%r, force=%r)" % (
            self.type,
            self.state,
            self.force,
        )


class ProductUnpublishedMessage(Message):
    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductUnpublished",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductUnpublishedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
            )
        )


class ProductUnpublishedMessagePayload(MessagePayload):
    def __init__(self) -> None:
        super().__init__(type="ProductUnpublished")

    def __repr__(self) -> str:
        return "ProductUnpublishedMessagePayload(type=%r)" % (self.type,)


class ProductVariantAddedMessage(Message):
    #: :class:`commercetools.types.ProductVariant`
    variant: "ProductVariant"
    #: :class:`bool`
    staged: bool

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        variant: "ProductVariant",
        staged: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.variant = variant
        self.staged = staged
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductVariantAdded",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductVariantAddedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, variant=%r, staged=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.variant,
                self.staged,
            )
        )


class ProductVariantAddedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.ProductVariant`
    variant: "ProductVariant"
    #: :class:`bool`
    staged: bool

    def __init__(self, *, variant: "ProductVariant", staged: bool) -> None:
        self.variant = variant
        self.staged = staged
        super().__init__(type="ProductVariantAdded")

    def __repr__(self) -> str:
        return "ProductVariantAddedMessagePayload(type=%r, variant=%r, staged=%r)" % (
            self.type,
            self.variant,
            self.staged,
        )


class ProductVariantDeletedMessage(Message):
    #: :class:`commercetools.types.ProductVariant`
    variant: "ProductVariant"
    #: :class:`list` `(Named` ``removedImageUrls`` `in Commercetools)`
    removed_image_urls: list

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        variant: "ProductVariant",
        removed_image_urls: list,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.variant = variant
        self.removed_image_urls = removed_image_urls
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ProductVariantDeleted",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ProductVariantDeletedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, variant=%r, removed_image_urls=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.variant,
                self.removed_image_urls,
            )
        )


class ProductVariantDeletedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.ProductVariant`
    variant: "ProductVariant"
    #: :class:`list` `(Named` ``removedImageUrls`` `in Commercetools)`
    removed_image_urls: list

    def __init__(self, *, variant: "ProductVariant", removed_image_urls: list) -> None:
        self.variant = variant
        self.removed_image_urls = removed_image_urls
        super().__init__(type="ProductVariantDeleted")

    def __repr__(self) -> str:
        return (
            "ProductVariantDeletedMessagePayload(type=%r, variant=%r, removed_image_urls=%r)"
            % (self.type, self.variant, self.removed_image_urls)
        )


class ReviewCreatedMessage(Message):
    #: :class:`commercetools.types.Review`
    review: "Review"

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        review: "Review",
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.review = review
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ReviewCreated",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ReviewCreatedMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, review=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.review,
            )
        )


class ReviewCreatedMessagePayload(MessagePayload):
    #: :class:`commercetools.types.Review`
    review: "Review"

    def __init__(self, *, review: "Review") -> None:
        self.review = review
        super().__init__(type="ReviewCreated")

    def __repr__(self) -> str:
        return "ReviewCreatedMessagePayload(type=%r, review=%r)" % (
            self.type,
            self.review,
        )


class ReviewRatingSetMessage(Message):
    #: Optional :class:`int` `(Named` ``oldRating`` `in Commercetools)`
    old_rating: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``newRating`` `in Commercetools)`
    new_rating: typing.Optional[int]
    #: :class:`bool` `(Named` ``includedInStatistics`` `in Commercetools)`
    included_in_statistics: bool
    #: Optional :class:`commercetools.types.Reference`
    target: typing.Optional["Reference"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        included_in_statistics: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None,
        old_rating: typing.Optional[int] = None,
        new_rating: typing.Optional[int] = None,
        target: typing.Optional["Reference"] = None
    ) -> None:
        self.old_rating = old_rating
        self.new_rating = new_rating
        self.included_in_statistics = included_in_statistics
        self.target = target
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ReviewRatingSet",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ReviewRatingSetMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, old_rating=%r, new_rating=%r, included_in_statistics=%r, target=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.old_rating,
                self.new_rating,
                self.included_in_statistics,
                self.target,
            )
        )


class ReviewRatingSetMessagePayload(MessagePayload):
    #: Optional :class:`int` `(Named` ``oldRating`` `in Commercetools)`
    old_rating: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``newRating`` `in Commercetools)`
    new_rating: typing.Optional[int]
    #: :class:`bool` `(Named` ``includedInStatistics`` `in Commercetools)`
    included_in_statistics: bool
    #: Optional :class:`commercetools.types.Reference`
    target: typing.Optional["Reference"]

    def __init__(
        self,
        *,
        included_in_statistics: bool,
        old_rating: typing.Optional[int] = None,
        new_rating: typing.Optional[int] = None,
        target: typing.Optional["Reference"] = None
    ) -> None:
        self.old_rating = old_rating
        self.new_rating = new_rating
        self.included_in_statistics = included_in_statistics
        self.target = target
        super().__init__(type="ReviewRatingSet")

    def __repr__(self) -> str:
        return (
            "ReviewRatingSetMessagePayload(type=%r, old_rating=%r, new_rating=%r, included_in_statistics=%r, target=%r)"
            % (
                self.type,
                self.old_rating,
                self.new_rating,
                self.included_in_statistics,
                self.target,
            )
        )


class ReviewStateTransitionMessage(Message):
    #: :class:`commercetools.types.StateReference` `(Named` ``oldState`` `in Commercetools)`
    old_state: "StateReference"
    #: :class:`commercetools.types.StateReference` `(Named` ``newState`` `in Commercetools)`
    new_state: "StateReference"
    #: :class:`bool` `(Named` ``oldIncludedInStatistics`` `in Commercetools)`
    old_included_in_statistics: bool
    #: :class:`bool` `(Named` ``newIncludedInStatistics`` `in Commercetools)`
    new_included_in_statistics: bool
    #: :class:`commercetools.types.Reference`
    target: "Reference"
    #: :class:`bool`
    force: bool

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        sequence_number: int,
        resource: "Reference",
        resource_version: int,
        old_state: "StateReference",
        new_state: "StateReference",
        old_included_in_statistics: bool,
        new_included_in_statistics: bool,
        target: "Reference",
        force: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        resource_user_provided_identifiers: typing.Optional[
            "UserProvidedIdentifiers"
        ] = None
    ) -> None:
        self.old_state = old_state
        self.new_state = new_state
        self.old_included_in_statistics = old_included_in_statistics
        self.new_included_in_statistics = new_included_in_statistics
        self.target = target
        self.force = force
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            sequence_number=sequence_number,
            resource=resource,
            resource_version=resource_version,
            type="ReviewStateTransition",
            resource_user_provided_identifiers=resource_user_provided_identifiers,
        )

    def __repr__(self) -> str:
        return (
            "ReviewStateTransitionMessage(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, sequence_number=%r, resource=%r, resource_version=%r, type=%r, resource_user_provided_identifiers=%r, old_state=%r, new_state=%r, old_included_in_statistics=%r, new_included_in_statistics=%r, target=%r, force=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.sequence_number,
                self.resource,
                self.resource_version,
                self.type,
                self.resource_user_provided_identifiers,
                self.old_state,
                self.new_state,
                self.old_included_in_statistics,
                self.new_included_in_statistics,
                self.target,
                self.force,
            )
        )


class ReviewStateTransitionMessagePayload(MessagePayload):
    #: :class:`commercetools.types.StateReference` `(Named` ``oldState`` `in Commercetools)`
    old_state: "StateReference"
    #: :class:`commercetools.types.StateReference` `(Named` ``newState`` `in Commercetools)`
    new_state: "StateReference"
    #: :class:`bool` `(Named` ``oldIncludedInStatistics`` `in Commercetools)`
    old_included_in_statistics: bool
    #: :class:`bool` `(Named` ``newIncludedInStatistics`` `in Commercetools)`
    new_included_in_statistics: bool
    #: :class:`commercetools.types.Reference`
    target: "Reference"
    #: :class:`bool`
    force: bool

    def __init__(
        self,
        *,
        old_state: "StateReference",
        new_state: "StateReference",
        old_included_in_statistics: bool,
        new_included_in_statistics: bool,
        target: "Reference",
        force: bool
    ) -> None:
        self.old_state = old_state
        self.new_state = new_state
        self.old_included_in_statistics = old_included_in_statistics
        self.new_included_in_statistics = new_included_in_statistics
        self.target = target
        self.force = force
        super().__init__(type="ReviewStateTransition")

    def __repr__(self) -> str:
        return (
            "ReviewStateTransitionMessagePayload(type=%r, old_state=%r, new_state=%r, old_included_in_statistics=%r, new_included_in_statistics=%r, target=%r, force=%r)"
            % (
                self.type,
                self.old_state,
                self.new_state,
                self.old_included_in_statistics,
                self.new_included_in_statistics,
                self.target,
                self.force,
            )
        )
