# DO NOT EDIT! This file is automatically generated
import datetime
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._common import CreatedBy, LastModifiedBy
    from ._type import CustomFields, FieldContainer, TypeResourceIdentifier
__all__ = [
    "CustomerGroup",
    "CustomerGroupChangeNameAction",
    "CustomerGroupDraft",
    "CustomerGroupPagedQueryResponse",
    "CustomerGroupReference",
    "CustomerGroupResourceIdentifier",
    "CustomerGroupSetCustomFieldAction",
    "CustomerGroupSetCustomTypeAction",
    "CustomerGroupSetKeyAction",
    "CustomerGroupUpdate",
    "CustomerGroupUpdateAction",
]


class CustomerGroup(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`str`
    name: str
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        name: str,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        key: typing.Optional[str] = None,
        custom: typing.Optional["CustomFields"] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.key = key
        self.name = name
        self.custom = custom
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "CustomerGroup(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, key=%r, name=%r, custom=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.key,
                self.name,
                self.custom,
            )
        )


class CustomerGroupDraft(_BaseType):
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`str` `(Named` ``groupName`` `in Commercetools)`
    group_name: str
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]

    def __init__(
        self,
        *,
        group_name: str,
        key: typing.Optional[str] = None,
        custom: typing.Optional["CustomFields"] = None
    ) -> None:
        self.key = key
        self.group_name = group_name
        self.custom = custom
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerGroupDraft(key=%r, group_name=%r, custom=%r)" % (
            self.key,
            self.group_name,
            self.custom,
        )


class CustomerGroupPagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.CustomerGroup`
    results: typing.Sequence["CustomerGroup"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["CustomerGroup"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CustomerGroupPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class CustomerGroupReference(Reference):
    #: Optional :class:`commercetools.types.CustomerGroup`
    obj: typing.Optional["CustomerGroup"]

    def __init__(
        self, *, id: str, obj: typing.Optional["CustomerGroup"] = None
    ) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.CUSTOMER_GROUP, id=id)

    def __repr__(self) -> str:
        return "CustomerGroupReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class CustomerGroupResourceIdentifier(ResourceIdentifier):
    def __init__(
        self, *, id: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.CUSTOMER_GROUP, id=id, key=key)

    def __repr__(self) -> str:
        return "CustomerGroupResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class CustomerGroupUpdate(_BaseType):
    #: :class:`int`
    version: int
    #: :class:`list`
    actions: list

    def __init__(self, *, version: int, actions: list) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerGroupUpdate(version=%r, actions=%r)" % (
            self.version,
            self.actions,
        )


class CustomerGroupUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerGroupUpdateAction(action=%r)" % (self.action,)


class CustomerGroupChangeNameAction(CustomerGroupUpdateAction):
    #: :class:`str`
    name: str

    def __init__(self, *, name: str) -> None:
        self.name = name
        super().__init__(action="changeName")

    def __repr__(self) -> str:
        return "CustomerGroupChangeNameAction(action=%r, name=%r)" % (
            self.action,
            self.name,
        )


class CustomerGroupSetCustomFieldAction(CustomerGroupUpdateAction):
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(self, *, name: str, value: typing.Optional[typing.Any] = None) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "CustomerGroupSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class CustomerGroupSetCustomTypeAction(CustomerGroupUpdateAction):
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "CustomerGroupSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class CustomerGroupSetKeyAction(CustomerGroupUpdateAction):
    #: Optional :class:`str`
    key: typing.Optional[str]

    def __init__(self, *, key: typing.Optional[str] = None) -> None:
        self.key = key
        super().__init__(action="setKey")

    def __repr__(self) -> str:
        return "CustomerGroupSetKeyAction(action=%r, key=%r)" % (self.action, self.key)
