# DO NOT EDIT! This file is automatically generated
import typing

from commercetools._schemas._cart import CartPagedQueryResponseSchema
from commercetools._schemas._customer import CustomerSignInResultSchema
from commercetools._schemas._me import (
    MyCartDraftSchema,
    MyCartSchema,
    MyCustomerDraftSchema,
    MyCustomerSchema,
    MyOrderFromCartDraftSchema,
    MyOrderSchema,
    MyPaymentDraftSchema,
    MyPaymentPagedQueryResponseSchema,
    MyPaymentSchema,
    MyPaymentUpdateSchema,
    MyShoppingListDraftSchema,
    MyShoppingListUpdateSchema,
)
from commercetools._schemas._order import OrderPagedQueryResponseSchema
from commercetools._schemas._shopping_list import (
    MyShoppingListSchema,
    ShoppingListPagedQueryResponseSchema,
)
from commercetools.helpers import RemoveEmptyValuesMixin
from commercetools.types._cart import CartPagedQueryResponse
from commercetools.types._customer import CustomerSignInResult
from commercetools.types._me import (
    MyCart,
    MyCartDraft,
    MyCustomer,
    MyCustomerDraft,
    MyOrder,
    MyOrderFromCartDraft,
    MyPayment,
    MyPaymentDraft,
    MyPaymentPagedQueryResponse,
    MyPaymentUpdate,
    MyPaymentUpdateAction,
    MyShoppingListDraft,
    MyShoppingListUpdate,
    MyShoppingListUpdateAction,
)
from commercetools.types._order import OrderPagedQueryResponse
from commercetools.types._shopping_list import (
    MyShoppingList,
    ShoppingListPagedQueryResponse,
)
from commercetools.typing import OptionalListStr

from . import abstract, traits


class _MeQuerySchema(
    traits.SortableSchema,
    traits.PagingSchema,
    traits.ExpandableSchema,
    traits.QuerySchema,
):
    pass


class _MeUpdateSchema(traits.ExpandableSchema, traits.VersionedSchema):
    pass


class _MeDeleteSchema(traits.VersionedSchema, traits.ExpandableSchema):
    pass


class MeService(abstract.AbstractService):
    def my_cart_get_by_id(self, id: str, *, expand: OptionalListStr = None) -> MyCart:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/carts/{id}", params=params, schema_cls=MyCartSchema
        )

    def my_order_get_by_id(self, id: str, *, expand: OptionalListStr = None) -> MyOrder:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/orders/{id}", params=params, schema_cls=MyOrderSchema
        )

    def my_payment_get_by_id(
        self, id: str, *, expand: OptionalListStr = None
    ) -> MyPayment:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/payments/{id}", params=params, schema_cls=MyPaymentSchema
        )

    def my_payment_get_by_key(
        self, key: str, *, expand: OptionalListStr = None
    ) -> MyPayment:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/payments/key={key}", params=params, schema_cls=MyPaymentSchema
        )

    def my_shopping_list_get_by_id(
        self, id: str, *, expand: OptionalListStr = None
    ) -> MyShoppingList:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/shopping-lists/{id}",
            params=params,
            schema_cls=MyShoppingListSchema,
        )

    def my_shopping_list_get_by_key(
        self, key: str, *, expand: OptionalListStr = None
    ) -> MyShoppingList:
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"me/shopping-lists/key={key}",
            params=params,
            schema_cls=MyShoppingListSchema,
        )

    def my_cart_query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> CartPagedQueryResponse:
        """A shopping cart holds product variants and can be ordered.
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me/carts", params=params, schema_cls=CartPagedQueryResponseSchema
        )

    def my_order_query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> OrderPagedQueryResponse:
        """An order can be created from a cart, usually after a checkout process has
        been completed.
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me/orders",
            params=params,
            schema_cls=OrderPagedQueryResponseSchema,
        )

    def my_payment_query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> MyPaymentPagedQueryResponse:
        """The My Payments endpoint creates and provides access to payments scoped
        to a specific user.
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me/payments",
            params=params,
            schema_cls=MyPaymentPagedQueryResponseSchema,
        )

    def my_shopping_list_query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> ShoppingListPagedQueryResponse:
        """The My Shopping Lists endpoint creates and provides access to shopping
        lists scoped to a specific user.
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me/shopping-lists",
            params=params,
            schema_cls=ShoppingListPagedQueryResponseSchema,
        )

    def query(
        self,
        *,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        expand: OptionalListStr = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> MyCustomer:
        params = self._serialize_params(
            {
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "expand": expand,
                "where": where,
                "predicate_var": predicate_var,
            },
            _MeQuerySchema,
        )
        return self._client._get(
            endpoint="me", params=params, schema_cls=MyCustomerSchema
        )

    def create(self) -> MyCustomer:
        """Create my customer"""
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me",
            params=params,
            data_object=None,
            request_schema_cls=None,
            response_schema_cls=MyCustomerSchema,
        )

    def my_cart_create(
        self, draft: MyCartDraft, *, expand: OptionalListStr = None
    ) -> MyCart:
        """A shopping cart holds product variants and can be ordered.
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="me/carts",
            params=params,
            data_object=draft,
            request_schema_cls=MyCartDraftSchema,
            response_schema_cls=MyCartSchema,
        )

    def my_order_create(
        self, draft: MyOrderFromCartDraft, *, expand: OptionalListStr = None
    ) -> MyOrder:
        """An order can be created from a cart, usually after a checkout process has
        been completed.
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="me/orders",
            params=params,
            data_object=draft,
            request_schema_cls=MyOrderFromCartDraftSchema,
            response_schema_cls=MyOrderSchema,
        )

    def my_payment_create(
        self, draft: MyPaymentDraft, *, expand: OptionalListStr = None
    ) -> MyPayment:
        """The My Payments endpoint creates and provides access to payments scoped
        to a specific user.
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="me/payments",
            params=params,
            data_object=draft,
            request_schema_cls=MyPaymentDraftSchema,
            response_schema_cls=MyPaymentSchema,
        )

    def my_shopping_list_create(
        self, draft: MyShoppingListDraft, *, expand: OptionalListStr = None
    ) -> MyShoppingList:
        """The My Shopping Lists endpoint creates and provides access to shopping
        lists scoped to a specific user.
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="me/shopping-lists",
            params=params,
            data_object=draft,
            request_schema_cls=MyShoppingListDraftSchema,
            response_schema_cls=MyShoppingListSchema,
        )

    def my_payment_update_by_id(
        self,
        id: str,
        version: int,
        actions: typing.List[MyPaymentUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> MyPayment:
        params = self._serialize_params({"expand": expand}, _MeUpdateSchema)
        update_action = MyPaymentUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"me/payments/{id}",
            params=params,
            data_object=update_action,
            request_schema_cls=MyPaymentUpdateSchema,
            response_schema_cls=MyPaymentSchema,
            force_update=force_update,
        )

    def my_payment_update_by_key(
        self,
        key: str,
        version: int,
        actions: typing.List[MyPaymentUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> MyPayment:
        params = self._serialize_params({"expand": expand}, _MeUpdateSchema)
        update_action = MyPaymentUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"me/payments/key={key}",
            params=params,
            data_object=update_action,
            request_schema_cls=MyPaymentUpdateSchema,
            response_schema_cls=MyPaymentSchema,
            force_update=force_update,
        )

    def my_shopping_list_update_by_id(
        self,
        id: str,
        version: int,
        actions: typing.List[MyShoppingListUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> MyShoppingList:
        params = self._serialize_params({"expand": expand}, _MeUpdateSchema)
        update_action = MyShoppingListUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"me/shopping-lists/{id}",
            params=params,
            data_object=update_action,
            request_schema_cls=MyShoppingListUpdateSchema,
            response_schema_cls=MyShoppingListSchema,
            force_update=force_update,
        )

    def my_shopping_list_update_by_key(
        self,
        key: str,
        version: int,
        actions: typing.List[MyShoppingListUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> MyShoppingList:
        params = self._serialize_params({"expand": expand}, _MeUpdateSchema)
        update_action = MyShoppingListUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"me/shopping-lists/key={key}",
            params=params,
            data_object=update_action,
            request_schema_cls=MyShoppingListUpdateSchema,
            response_schema_cls=MyShoppingListSchema,
            force_update=force_update,
        )

    def my_cart_delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyCart:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/carts/{id}",
            params=params,
            response_schema_cls=MyCartSchema,
            force_delete=force_delete,
        )

    def my_payment_delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyPayment:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/payments/{id}",
            params=params,
            response_schema_cls=MyPaymentSchema,
            force_delete=force_delete,
        )

    def my_payment_delete_by_key(
        self,
        key: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyPayment:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/payments/key={key}",
            params=params,
            response_schema_cls=MyPaymentSchema,
            force_delete=force_delete,
        )

    def my_shopping_list_delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyShoppingList:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/shopping-lists/{id}",
            params=params,
            response_schema_cls=MyShoppingListSchema,
            force_delete=force_delete,
        )

    def my_shopping_list_delete_by_key(
        self,
        key: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> MyShoppingList:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _MeDeleteSchema
        )
        return self._client._delete(
            endpoint=f"me/shopping-lists/key={key}",
            params=params,
            response_schema_cls=MyShoppingListSchema,
            force_delete=force_delete,
        )

    def active_cart(self) -> MyCart:
        params: typing.Dict[str, str] = {}
        return self._client._get(
            endpoint="me/active-cart", params=params, schema_cls=MyCartSchema
        )

    def email_confirm(self):
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me/email/confirm",
            params=params,
            data_object=None,
            request_schema_cls=None,
        )

    def login(self) -> CustomerSignInResult:
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me/login",
            params=params,
            data_object=None,
            request_schema_cls=None,
            response_schema_cls=CustomerSignInResultSchema,
        )

    def password(self) -> MyCustomer:
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me/password",
            params=params,
            data_object=None,
            request_schema_cls=None,
            response_schema_cls=MyCustomerSchema,
        )

    def signup(self, draft: MyCustomerDraft) -> CustomerSignInResult:
        params: typing.Dict[str, str] = {}
        return self._client._post(
            endpoint="me/signup",
            params=params,
            data_object=draft,
            request_schema_cls=MyCustomerDraftSchema,
            response_schema_cls=CustomerSignInResultSchema,
        )
