# DO NOT EDIT! This file is automatically generated
import marshmallow
import marshmallow_enum

from commercetools import helpers, types
from commercetools._schemas._common import (
    BaseResourceSchema,
    LocalizedStringField,
    ReferenceSchema,
    ResourceIdentifierSchema,
)
from commercetools._schemas._type import FieldContainerField

__all__ = [
    "PaymentAddInterfaceInteractionActionSchema",
    "PaymentAddTransactionActionSchema",
    "PaymentChangeAmountPlannedActionSchema",
    "PaymentChangeTransactionInteractionIdActionSchema",
    "PaymentChangeTransactionStateActionSchema",
    "PaymentChangeTransactionTimestampActionSchema",
    "PaymentDraftSchema",
    "PaymentMethodInfoSchema",
    "PaymentPagedQueryResponseSchema",
    "PaymentReferenceSchema",
    "PaymentResourceIdentifierSchema",
    "PaymentSchema",
    "PaymentSetAmountPaidActionSchema",
    "PaymentSetAmountRefundedActionSchema",
    "PaymentSetAnonymousIdActionSchema",
    "PaymentSetAuthorizationActionSchema",
    "PaymentSetCustomFieldActionSchema",
    "PaymentSetCustomTypeActionSchema",
    "PaymentSetCustomerActionSchema",
    "PaymentSetExternalIdActionSchema",
    "PaymentSetInterfaceIdActionSchema",
    "PaymentSetKeyActionSchema",
    "PaymentSetMethodInfoInterfaceActionSchema",
    "PaymentSetMethodInfoMethodActionSchema",
    "PaymentSetMethodInfoNameActionSchema",
    "PaymentSetStatusInterfaceCodeActionSchema",
    "PaymentSetStatusInterfaceTextActionSchema",
    "PaymentStatusDraftSchema",
    "PaymentStatusSchema",
    "PaymentTransitionStateActionSchema",
    "PaymentUpdateActionSchema",
    "PaymentUpdateSchema",
    "TransactionDraftSchema",
    "TransactionSchema",
]


class PaymentDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.PaymentDraft`."""

    customer = helpers.LazyNestedField(
        nested="commercetools._schemas._customer.CustomerResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    anonymous_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="anonymousId"
    )
    external_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="externalId"
    )
    interface_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="interfaceId"
    )
    amount_planned = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="amountPlanned",
    )
    amount_authorized = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="amountAuthorized",
    )
    authorized_until = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="authorizedUntil"
    )
    amount_paid = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="amountPaid",
    )
    amount_refunded = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="amountRefunded",
    )
    payment_method_info = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentMethodInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="paymentMethodInfo",
    )
    payment_status = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentStatusDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="paymentStatus",
    )
    transactions = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.TransactionDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )
    interface_interactions = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="interfaceInteractions",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    key = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.PaymentDraft(**data)


class PaymentMethodInfoSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.PaymentMethodInfo`."""

    payment_interface = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="paymentInterface"
    )
    method = marshmallow.fields.String(allow_none=True, missing=None)
    name = LocalizedStringField(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.PaymentMethodInfo(**data)


class PaymentPagedQueryResponseSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.PaymentPagedQueryResponse`."""

    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.PaymentPagedQueryResponse(**data)


class PaymentReferenceSchema(ReferenceSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentReference`."""

    obj = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.PaymentReference(**data)


class PaymentResourceIdentifierSchema(ResourceIdentifierSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentResourceIdentifier`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.PaymentResourceIdentifier(**data)


class PaymentSchema(BaseResourceSchema):
    """Marshmallow schema for :class:`commercetools.types.Payment`."""

    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    last_modified_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.LastModifiedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="lastModifiedBy",
    )
    created_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.CreatedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="createdBy",
    )
    customer = helpers.LazyNestedField(
        nested="commercetools._schemas._customer.CustomerReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    anonymous_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="anonymousId"
    )
    external_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="externalId"
    )
    interface_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="interfaceId"
    )
    amount_planned = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="amountPlanned",
    )
    amount_authorized = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="amountAuthorized",
    )
    authorized_until = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="authorizedUntil"
    )
    amount_paid = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="amountPaid",
    )
    amount_refunded = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="amountRefunded",
    )
    payment_method_info = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentMethodInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="paymentMethodInfo",
    )
    payment_status = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentStatusSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="paymentStatus",
    )
    transactions = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.TransactionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    interface_interactions = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="interfaceInteractions",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    key = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.Payment(**data)


class PaymentStatusDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.PaymentStatusDraft`."""

    interface_code = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="interfaceCode"
    )
    interface_text = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="interfaceText"
    )
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.PaymentStatusDraft(**data)


class PaymentStatusSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.PaymentStatus`."""

    interface_code = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="interfaceCode"
    )
    interface_text = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="interfaceText"
    )
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.PaymentStatus(**data)


class PaymentUpdateActionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.PaymentUpdateAction`."""

    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentUpdateAction(**data)


class PaymentUpdateSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.PaymentUpdate`."""

    version = marshmallow.fields.Integer(allow_none=True)
    actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "addInterfaceInteraction": "commercetools._schemas._payment.PaymentAddInterfaceInteractionActionSchema",
                "addTransaction": "commercetools._schemas._payment.PaymentAddTransactionActionSchema",
                "changeAmountPlanned": "commercetools._schemas._payment.PaymentChangeAmountPlannedActionSchema",
                "changeTransactionInteractionId": "commercetools._schemas._payment.PaymentChangeTransactionInteractionIdActionSchema",
                "changeTransactionState": "commercetools._schemas._payment.PaymentChangeTransactionStateActionSchema",
                "changeTransactionTimestamp": "commercetools._schemas._payment.PaymentChangeTransactionTimestampActionSchema",
                "setAmountPaid": "commercetools._schemas._payment.PaymentSetAmountPaidActionSchema",
                "setAmountRefunded": "commercetools._schemas._payment.PaymentSetAmountRefundedActionSchema",
                "setAnonymousId": "commercetools._schemas._payment.PaymentSetAnonymousIdActionSchema",
                "setAuthorization": "commercetools._schemas._payment.PaymentSetAuthorizationActionSchema",
                "setCustomField": "commercetools._schemas._payment.PaymentSetCustomFieldActionSchema",
                "setCustomType": "commercetools._schemas._payment.PaymentSetCustomTypeActionSchema",
                "setCustomer": "commercetools._schemas._payment.PaymentSetCustomerActionSchema",
                "setExternalId": "commercetools._schemas._payment.PaymentSetExternalIdActionSchema",
                "setInterfaceId": "commercetools._schemas._payment.PaymentSetInterfaceIdActionSchema",
                "setKey": "commercetools._schemas._payment.PaymentSetKeyActionSchema",
                "setMethodInfoInterface": "commercetools._schemas._payment.PaymentSetMethodInfoInterfaceActionSchema",
                "setMethodInfoMethod": "commercetools._schemas._payment.PaymentSetMethodInfoMethodActionSchema",
                "setMethodInfoName": "commercetools._schemas._payment.PaymentSetMethodInfoNameActionSchema",
                "setStatusInterfaceCode": "commercetools._schemas._payment.PaymentSetStatusInterfaceCodeActionSchema",
                "setStatusInterfaceText": "commercetools._schemas._payment.PaymentSetStatusInterfaceTextActionSchema",
                "transitionState": "commercetools._schemas._payment.PaymentTransitionStateActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.PaymentUpdate(**data)


class TransactionDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TransactionDraft`."""

    timestamp = marshmallow.fields.DateTime(allow_none=True, missing=None)
    type = marshmallow_enum.EnumField(types.TransactionType, by_value=True)
    amount = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    interaction_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="interactionId"
    )
    state = marshmallow_enum.EnumField(
        types.TransactionState, by_value=True, missing=None
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TransactionDraft(**data)


class TransactionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.Transaction`."""

    id = marshmallow.fields.String(allow_none=True)
    timestamp = marshmallow.fields.DateTime(allow_none=True, missing=None)
    type = marshmallow_enum.EnumField(types.TransactionType, by_value=True)
    amount = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    interaction_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="interactionId"
    )
    state = marshmallow_enum.EnumField(
        types.TransactionState, by_value=True, missing=None
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.Transaction(**data)


class PaymentAddInterfaceInteractionActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentAddInterfaceInteractionAction`."""

    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentAddInterfaceInteractionAction(**data)


class PaymentAddTransactionActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentAddTransactionAction`."""

    transaction = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.TransactionDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentAddTransactionAction(**data)


class PaymentChangeAmountPlannedActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentChangeAmountPlannedAction`."""

    amount = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentChangeAmountPlannedAction(**data)


class PaymentChangeTransactionInteractionIdActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentChangeTransactionInteractionIdAction`."""

    transaction_id = marshmallow.fields.String(
        allow_none=True, data_key="transactionId"
    )
    interaction_id = marshmallow.fields.String(
        allow_none=True, data_key="interactionId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentChangeTransactionInteractionIdAction(**data)


class PaymentChangeTransactionStateActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentChangeTransactionStateAction`."""

    transaction_id = marshmallow.fields.String(
        allow_none=True, data_key="transactionId"
    )
    state = marshmallow_enum.EnumField(types.TransactionState, by_value=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentChangeTransactionStateAction(**data)


class PaymentChangeTransactionTimestampActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentChangeTransactionTimestampAction`."""

    transaction_id = marshmallow.fields.String(
        allow_none=True, data_key="transactionId"
    )
    timestamp = marshmallow.fields.DateTime(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentChangeTransactionTimestampAction(**data)


class PaymentSetAmountPaidActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetAmountPaidAction`."""

    amount = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetAmountPaidAction(**data)


class PaymentSetAmountRefundedActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetAmountRefundedAction`."""

    amount = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetAmountRefundedAction(**data)


class PaymentSetAnonymousIdActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetAnonymousIdAction`."""

    anonymous_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="anonymousId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetAnonymousIdAction(**data)


class PaymentSetAuthorizationActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetAuthorizationAction`."""

    amount = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    until = marshmallow.fields.DateTime(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetAuthorizationAction(**data)


class PaymentSetCustomFieldActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetCustomFieldAction`."""

    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetCustomFieldAction(**data)


class PaymentSetCustomTypeActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetCustomTypeAction`."""

    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetCustomTypeAction(**data)


class PaymentSetCustomerActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetCustomerAction`."""

    customer = helpers.LazyNestedField(
        nested="commercetools._schemas._customer.CustomerResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetCustomerAction(**data)


class PaymentSetExternalIdActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetExternalIdAction`."""

    external_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="externalId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetExternalIdAction(**data)


class PaymentSetInterfaceIdActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetInterfaceIdAction`."""

    interface_id = marshmallow.fields.String(allow_none=True, data_key="interfaceId")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetInterfaceIdAction(**data)


class PaymentSetKeyActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetKeyAction`."""

    key = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetKeyAction(**data)


class PaymentSetMethodInfoInterfaceActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetMethodInfoInterfaceAction`."""

    interface = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetMethodInfoInterfaceAction(**data)


class PaymentSetMethodInfoMethodActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetMethodInfoMethodAction`."""

    method = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetMethodInfoMethodAction(**data)


class PaymentSetMethodInfoNameActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetMethodInfoNameAction`."""

    name = LocalizedStringField(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetMethodInfoNameAction(**data)


class PaymentSetStatusInterfaceCodeActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetStatusInterfaceCodeAction`."""

    interface_code = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="interfaceCode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetStatusInterfaceCodeAction(**data)


class PaymentSetStatusInterfaceTextActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentSetStatusInterfaceTextAction`."""

    interface_text = marshmallow.fields.String(
        allow_none=True, data_key="interfaceText"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentSetStatusInterfaceTextAction(**data)


class PaymentTransitionStateActionSchema(PaymentUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.PaymentTransitionStateAction`."""

    state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.PaymentTransitionStateAction(**data)
