# DO NOT EDIT! This file is automatically generated
import marshmallow
import marshmallow_enum

from commercetools import helpers, types
from commercetools._schemas._common import (
    BaseResourceSchema,
    LocalizedStringField,
    ReferenceSchema,
    ResourceIdentifierSchema,
)
from commercetools._schemas._order import OrderSchema, StagedOrderUpdateActionSchema
from commercetools._schemas._type import FieldContainerField

__all__ = [
    "OrderEditAddStagedActionActionSchema",
    "OrderEditAppliedSchema",
    "OrderEditApplySchema",
    "OrderEditDraftSchema",
    "OrderEditNotProcessedSchema",
    "OrderEditPagedQueryResponseSchema",
    "OrderEditPreviewFailureSchema",
    "OrderEditPreviewSuccessSchema",
    "OrderEditReferenceSchema",
    "OrderEditResourceIdentifierSchema",
    "OrderEditResultSchema",
    "OrderEditSchema",
    "OrderEditSetCommentActionSchema",
    "OrderEditSetCustomFieldActionSchema",
    "OrderEditSetCustomTypeActionSchema",
    "OrderEditSetKeyActionSchema",
    "OrderEditSetStagedActionsActionSchema",
    "OrderEditUpdateActionSchema",
    "OrderEditUpdateSchema",
    "OrderExcerptSchema",
    "StagedOrderAddCustomLineItemActionSchema",
    "StagedOrderAddDeliveryActionSchema",
    "StagedOrderAddDiscountCodeActionSchema",
    "StagedOrderAddItemShippingAddressActionSchema",
    "StagedOrderAddLineItemActionSchema",
    "StagedOrderAddParcelToDeliveryActionSchema",
    "StagedOrderAddPaymentActionSchema",
    "StagedOrderAddReturnInfoActionSchema",
    "StagedOrderAddShoppingListActionSchema",
    "StagedOrderChangeCustomLineItemMoneyActionSchema",
    "StagedOrderChangeCustomLineItemQuantityActionSchema",
    "StagedOrderChangeLineItemQuantityActionSchema",
    "StagedOrderChangeOrderStateActionSchema",
    "StagedOrderChangePaymentStateActionSchema",
    "StagedOrderChangeShipmentStateActionSchema",
    "StagedOrderChangeTaxCalculationModeActionSchema",
    "StagedOrderChangeTaxModeActionSchema",
    "StagedOrderChangeTaxRoundingModeActionSchema",
    "StagedOrderImportCustomLineItemStateActionSchema",
    "StagedOrderImportLineItemStateActionSchema",
    "StagedOrderRemoveCustomLineItemActionSchema",
    "StagedOrderRemoveDeliveryActionSchema",
    "StagedOrderRemoveDiscountCodeActionSchema",
    "StagedOrderRemoveItemShippingAddressActionSchema",
    "StagedOrderRemoveLineItemActionSchema",
    "StagedOrderRemoveParcelFromDeliveryActionSchema",
    "StagedOrderRemovePaymentActionSchema",
    "StagedOrderSchema",
    "StagedOrderSetBillingAddressActionSchema",
    "StagedOrderSetCountryActionSchema",
    "StagedOrderSetCustomFieldActionSchema",
    "StagedOrderSetCustomLineItemCustomFieldActionSchema",
    "StagedOrderSetCustomLineItemCustomTypeActionSchema",
    "StagedOrderSetCustomLineItemShippingDetailsActionSchema",
    "StagedOrderSetCustomLineItemTaxAmountActionSchema",
    "StagedOrderSetCustomLineItemTaxRateActionSchema",
    "StagedOrderSetCustomShippingMethodActionSchema",
    "StagedOrderSetCustomTypeActionSchema",
    "StagedOrderSetCustomerEmailActionSchema",
    "StagedOrderSetCustomerGroupActionSchema",
    "StagedOrderSetCustomerIdActionSchema",
    "StagedOrderSetDeliveryAddressActionSchema",
    "StagedOrderSetDeliveryItemsActionSchema",
    "StagedOrderSetLineItemCustomFieldActionSchema",
    "StagedOrderSetLineItemCustomTypeActionSchema",
    "StagedOrderSetLineItemDistributionChannelActionSchema",
    "StagedOrderSetLineItemPriceActionSchema",
    "StagedOrderSetLineItemShippingDetailsActionSchema",
    "StagedOrderSetLineItemTaxAmountActionSchema",
    "StagedOrderSetLineItemTaxRateActionSchema",
    "StagedOrderSetLineItemTotalPriceActionSchema",
    "StagedOrderSetLocaleActionSchema",
    "StagedOrderSetOrderNumberActionSchema",
    "StagedOrderSetOrderTotalTaxActionSchema",
    "StagedOrderSetParcelItemsActionSchema",
    "StagedOrderSetParcelMeasurementsActionSchema",
    "StagedOrderSetParcelTrackingDataActionSchema",
    "StagedOrderSetReturnPaymentStateActionSchema",
    "StagedOrderSetReturnShipmentStateActionSchema",
    "StagedOrderSetShippingAddressActionSchema",
    "StagedOrderSetShippingAddressAndCustomShippingMethodActionSchema",
    "StagedOrderSetShippingAddressAndShippingMethodActionSchema",
    "StagedOrderSetShippingMethodActionSchema",
    "StagedOrderSetShippingMethodTaxAmountActionSchema",
    "StagedOrderSetShippingMethodTaxRateActionSchema",
    "StagedOrderSetShippingRateInputActionSchema",
    "StagedOrderTransitionCustomLineItemStateActionSchema",
    "StagedOrderTransitionLineItemStateActionSchema",
    "StagedOrderTransitionStateActionSchema",
    "StagedOrderUpdateItemShippingAddressActionSchema",
    "StagedOrderUpdateSyncInfoActionSchema",
]


class OrderEditApplySchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditApply`."""

    edit_version = marshmallow.fields.Integer(allow_none=True, data_key="editVersion")
    resource_version = marshmallow.fields.Integer(
        allow_none=True, data_key="resourceVersion"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderEditApply(**data)


class OrderEditDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditDraft`."""

    key = marshmallow.fields.String(allow_none=True, missing=None)
    resource = helpers.LazyNestedField(
        nested="commercetools._schemas._order.OrderReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    staged_actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "addCustomLineItem": "commercetools._schemas._order_edit.StagedOrderAddCustomLineItemActionSchema",
                "addDelivery": "commercetools._schemas._order_edit.StagedOrderAddDeliveryActionSchema",
                "addDiscountCode": "commercetools._schemas._order_edit.StagedOrderAddDiscountCodeActionSchema",
                "addItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderAddItemShippingAddressActionSchema",
                "addLineItem": "commercetools._schemas._order_edit.StagedOrderAddLineItemActionSchema",
                "addParcelToDelivery": "commercetools._schemas._order_edit.StagedOrderAddParcelToDeliveryActionSchema",
                "addPayment": "commercetools._schemas._order_edit.StagedOrderAddPaymentActionSchema",
                "addReturnInfo": "commercetools._schemas._order_edit.StagedOrderAddReturnInfoActionSchema",
                "addShoppingList": "commercetools._schemas._order_edit.StagedOrderAddShoppingListActionSchema",
                "changeCustomLineItemMoney": "commercetools._schemas._order_edit.StagedOrderChangeCustomLineItemMoneyActionSchema",
                "changeCustomLineItemQuantity": "commercetools._schemas._order_edit.StagedOrderChangeCustomLineItemQuantityActionSchema",
                "changeLineItemQuantity": "commercetools._schemas._order_edit.StagedOrderChangeLineItemQuantityActionSchema",
                "changeOrderState": "commercetools._schemas._order_edit.StagedOrderChangeOrderStateActionSchema",
                "changePaymentState": "commercetools._schemas._order_edit.StagedOrderChangePaymentStateActionSchema",
                "changeShipmentState": "commercetools._schemas._order_edit.StagedOrderChangeShipmentStateActionSchema",
                "changeTaxCalculationMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxCalculationModeActionSchema",
                "changeTaxMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxModeActionSchema",
                "changeTaxRoundingMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxRoundingModeActionSchema",
                "importCustomLineItemState": "commercetools._schemas._order_edit.StagedOrderImportCustomLineItemStateActionSchema",
                "importLineItemState": "commercetools._schemas._order_edit.StagedOrderImportLineItemStateActionSchema",
                "removeCustomLineItem": "commercetools._schemas._order_edit.StagedOrderRemoveCustomLineItemActionSchema",
                "removeDelivery": "commercetools._schemas._order_edit.StagedOrderRemoveDeliveryActionSchema",
                "removeDiscountCode": "commercetools._schemas._order_edit.StagedOrderRemoveDiscountCodeActionSchema",
                "removeItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderRemoveItemShippingAddressActionSchema",
                "removeLineItem": "commercetools._schemas._order_edit.StagedOrderRemoveLineItemActionSchema",
                "removeParcelFromDelivery": "commercetools._schemas._order_edit.StagedOrderRemoveParcelFromDeliveryActionSchema",
                "removePayment": "commercetools._schemas._order_edit.StagedOrderRemovePaymentActionSchema",
                "setBillingAddress": "commercetools._schemas._order_edit.StagedOrderSetBillingAddressActionSchema",
                "setCountry": "commercetools._schemas._order_edit.StagedOrderSetCountryActionSchema",
                "setCustomField": "commercetools._schemas._order_edit.StagedOrderSetCustomFieldActionSchema",
                "setCustomLineItemCustomField": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemCustomFieldActionSchema",
                "setCustomLineItemCustomType": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemCustomTypeActionSchema",
                "setCustomLineItemShippingDetails": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemShippingDetailsActionSchema",
                "setCustomLineItemTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemTaxAmountActionSchema",
                "setCustomLineItemTaxRate": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemTaxRateActionSchema",
                "setCustomShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetCustomShippingMethodActionSchema",
                "setCustomType": "commercetools._schemas._order_edit.StagedOrderSetCustomTypeActionSchema",
                "setCustomerEmail": "commercetools._schemas._order_edit.StagedOrderSetCustomerEmailActionSchema",
                "setCustomerGroup": "commercetools._schemas._order_edit.StagedOrderSetCustomerGroupActionSchema",
                "setCustomerId": "commercetools._schemas._order_edit.StagedOrderSetCustomerIdActionSchema",
                "setDeliveryAddress": "commercetools._schemas._order_edit.StagedOrderSetDeliveryAddressActionSchema",
                "setDeliveryItems": "commercetools._schemas._order_edit.StagedOrderSetDeliveryItemsActionSchema",
                "setLineItemCustomField": "commercetools._schemas._order_edit.StagedOrderSetLineItemCustomFieldActionSchema",
                "setLineItemCustomType": "commercetools._schemas._order_edit.StagedOrderSetLineItemCustomTypeActionSchema",
                "setLineItemDistributionChannel": "commercetools._schemas._order_edit.StagedOrderSetLineItemDistributionChannelActionSchema",
                "setLineItemPrice": "commercetools._schemas._order_edit.StagedOrderSetLineItemPriceActionSchema",
                "setLineItemShippingDetails": "commercetools._schemas._order_edit.StagedOrderSetLineItemShippingDetailsActionSchema",
                "setLineItemTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetLineItemTaxAmountActionSchema",
                "setLineItemTaxRate": "commercetools._schemas._order_edit.StagedOrderSetLineItemTaxRateActionSchema",
                "setLineItemTotalPrice": "commercetools._schemas._order_edit.StagedOrderSetLineItemTotalPriceActionSchema",
                "setLocale": "commercetools._schemas._order_edit.StagedOrderSetLocaleActionSchema",
                "setOrderNumber": "commercetools._schemas._order_edit.StagedOrderSetOrderNumberActionSchema",
                "setOrderTotalTax": "commercetools._schemas._order_edit.StagedOrderSetOrderTotalTaxActionSchema",
                "setParcelItems": "commercetools._schemas._order_edit.StagedOrderSetParcelItemsActionSchema",
                "setParcelMeasurements": "commercetools._schemas._order_edit.StagedOrderSetParcelMeasurementsActionSchema",
                "setParcelTrackingData": "commercetools._schemas._order_edit.StagedOrderSetParcelTrackingDataActionSchema",
                "setReturnPaymentState": "commercetools._schemas._order_edit.StagedOrderSetReturnPaymentStateActionSchema",
                "setReturnShipmentState": "commercetools._schemas._order_edit.StagedOrderSetReturnShipmentStateActionSchema",
                "setShippingAddress": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressActionSchema",
                "setShippingAddressAndCustomShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressAndCustomShippingMethodActionSchema",
                "setShippingAddressAndShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressAndShippingMethodActionSchema",
                "setShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodActionSchema",
                "setShippingMethodTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodTaxAmountActionSchema",
                "setShippingMethodTaxRate": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodTaxRateActionSchema",
                "setShippingRateInput": "commercetools._schemas._order_edit.StagedOrderSetShippingRateInputActionSchema",
                "transitionCustomLineItemState": "commercetools._schemas._order_edit.StagedOrderTransitionCustomLineItemStateActionSchema",
                "transitionLineItemState": "commercetools._schemas._order_edit.StagedOrderTransitionLineItemStateActionSchema",
                "transitionState": "commercetools._schemas._order_edit.StagedOrderTransitionStateActionSchema",
                "updateItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderUpdateItemShippingAddressActionSchema",
                "updateSyncInfo": "commercetools._schemas._order_edit.StagedOrderUpdateSyncInfoActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        missing=None,
        data_key="stagedActions",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    comment = marshmallow.fields.String(allow_none=True, missing=None)
    dry_run = marshmallow.fields.Bool(allow_none=True, missing=None, data_key="dryRun")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderEditDraft(**data)


class OrderEditPagedQueryResponseSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditPagedQueryResponse`."""

    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = helpers.LazyNestedField(
        nested="commercetools._schemas._order_edit.OrderEditSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderEditPagedQueryResponse(**data)


class OrderEditReferenceSchema(ReferenceSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditReference`."""

    obj = helpers.LazyNestedField(
        nested="commercetools._schemas._order_edit.OrderEditSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.OrderEditReference(**data)


class OrderEditResourceIdentifierSchema(ResourceIdentifierSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditResourceIdentifier`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.OrderEditResourceIdentifier(**data)


class OrderEditResultSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditResult`."""

    type = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderEditResult(**data)


class OrderEditSchema(BaseResourceSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEdit`."""

    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    last_modified_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.LastModifiedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="lastModifiedBy",
    )
    created_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.CreatedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="createdBy",
    )
    key = marshmallow.fields.String(allow_none=True, missing=None)
    resource = helpers.LazyNestedField(
        nested="commercetools._schemas._order.OrderReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    staged_actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "addCustomLineItem": "commercetools._schemas._order_edit.StagedOrderAddCustomLineItemActionSchema",
                "addDelivery": "commercetools._schemas._order_edit.StagedOrderAddDeliveryActionSchema",
                "addDiscountCode": "commercetools._schemas._order_edit.StagedOrderAddDiscountCodeActionSchema",
                "addItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderAddItemShippingAddressActionSchema",
                "addLineItem": "commercetools._schemas._order_edit.StagedOrderAddLineItemActionSchema",
                "addParcelToDelivery": "commercetools._schemas._order_edit.StagedOrderAddParcelToDeliveryActionSchema",
                "addPayment": "commercetools._schemas._order_edit.StagedOrderAddPaymentActionSchema",
                "addReturnInfo": "commercetools._schemas._order_edit.StagedOrderAddReturnInfoActionSchema",
                "addShoppingList": "commercetools._schemas._order_edit.StagedOrderAddShoppingListActionSchema",
                "changeCustomLineItemMoney": "commercetools._schemas._order_edit.StagedOrderChangeCustomLineItemMoneyActionSchema",
                "changeCustomLineItemQuantity": "commercetools._schemas._order_edit.StagedOrderChangeCustomLineItemQuantityActionSchema",
                "changeLineItemQuantity": "commercetools._schemas._order_edit.StagedOrderChangeLineItemQuantityActionSchema",
                "changeOrderState": "commercetools._schemas._order_edit.StagedOrderChangeOrderStateActionSchema",
                "changePaymentState": "commercetools._schemas._order_edit.StagedOrderChangePaymentStateActionSchema",
                "changeShipmentState": "commercetools._schemas._order_edit.StagedOrderChangeShipmentStateActionSchema",
                "changeTaxCalculationMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxCalculationModeActionSchema",
                "changeTaxMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxModeActionSchema",
                "changeTaxRoundingMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxRoundingModeActionSchema",
                "importCustomLineItemState": "commercetools._schemas._order_edit.StagedOrderImportCustomLineItemStateActionSchema",
                "importLineItemState": "commercetools._schemas._order_edit.StagedOrderImportLineItemStateActionSchema",
                "removeCustomLineItem": "commercetools._schemas._order_edit.StagedOrderRemoveCustomLineItemActionSchema",
                "removeDelivery": "commercetools._schemas._order_edit.StagedOrderRemoveDeliveryActionSchema",
                "removeDiscountCode": "commercetools._schemas._order_edit.StagedOrderRemoveDiscountCodeActionSchema",
                "removeItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderRemoveItemShippingAddressActionSchema",
                "removeLineItem": "commercetools._schemas._order_edit.StagedOrderRemoveLineItemActionSchema",
                "removeParcelFromDelivery": "commercetools._schemas._order_edit.StagedOrderRemoveParcelFromDeliveryActionSchema",
                "removePayment": "commercetools._schemas._order_edit.StagedOrderRemovePaymentActionSchema",
                "setBillingAddress": "commercetools._schemas._order_edit.StagedOrderSetBillingAddressActionSchema",
                "setCountry": "commercetools._schemas._order_edit.StagedOrderSetCountryActionSchema",
                "setCustomField": "commercetools._schemas._order_edit.StagedOrderSetCustomFieldActionSchema",
                "setCustomLineItemCustomField": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemCustomFieldActionSchema",
                "setCustomLineItemCustomType": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemCustomTypeActionSchema",
                "setCustomLineItemShippingDetails": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemShippingDetailsActionSchema",
                "setCustomLineItemTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemTaxAmountActionSchema",
                "setCustomLineItemTaxRate": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemTaxRateActionSchema",
                "setCustomShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetCustomShippingMethodActionSchema",
                "setCustomType": "commercetools._schemas._order_edit.StagedOrderSetCustomTypeActionSchema",
                "setCustomerEmail": "commercetools._schemas._order_edit.StagedOrderSetCustomerEmailActionSchema",
                "setCustomerGroup": "commercetools._schemas._order_edit.StagedOrderSetCustomerGroupActionSchema",
                "setCustomerId": "commercetools._schemas._order_edit.StagedOrderSetCustomerIdActionSchema",
                "setDeliveryAddress": "commercetools._schemas._order_edit.StagedOrderSetDeliveryAddressActionSchema",
                "setDeliveryItems": "commercetools._schemas._order_edit.StagedOrderSetDeliveryItemsActionSchema",
                "setLineItemCustomField": "commercetools._schemas._order_edit.StagedOrderSetLineItemCustomFieldActionSchema",
                "setLineItemCustomType": "commercetools._schemas._order_edit.StagedOrderSetLineItemCustomTypeActionSchema",
                "setLineItemDistributionChannel": "commercetools._schemas._order_edit.StagedOrderSetLineItemDistributionChannelActionSchema",
                "setLineItemPrice": "commercetools._schemas._order_edit.StagedOrderSetLineItemPriceActionSchema",
                "setLineItemShippingDetails": "commercetools._schemas._order_edit.StagedOrderSetLineItemShippingDetailsActionSchema",
                "setLineItemTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetLineItemTaxAmountActionSchema",
                "setLineItemTaxRate": "commercetools._schemas._order_edit.StagedOrderSetLineItemTaxRateActionSchema",
                "setLineItemTotalPrice": "commercetools._schemas._order_edit.StagedOrderSetLineItemTotalPriceActionSchema",
                "setLocale": "commercetools._schemas._order_edit.StagedOrderSetLocaleActionSchema",
                "setOrderNumber": "commercetools._schemas._order_edit.StagedOrderSetOrderNumberActionSchema",
                "setOrderTotalTax": "commercetools._schemas._order_edit.StagedOrderSetOrderTotalTaxActionSchema",
                "setParcelItems": "commercetools._schemas._order_edit.StagedOrderSetParcelItemsActionSchema",
                "setParcelMeasurements": "commercetools._schemas._order_edit.StagedOrderSetParcelMeasurementsActionSchema",
                "setParcelTrackingData": "commercetools._schemas._order_edit.StagedOrderSetParcelTrackingDataActionSchema",
                "setReturnPaymentState": "commercetools._schemas._order_edit.StagedOrderSetReturnPaymentStateActionSchema",
                "setReturnShipmentState": "commercetools._schemas._order_edit.StagedOrderSetReturnShipmentStateActionSchema",
                "setShippingAddress": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressActionSchema",
                "setShippingAddressAndCustomShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressAndCustomShippingMethodActionSchema",
                "setShippingAddressAndShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressAndShippingMethodActionSchema",
                "setShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodActionSchema",
                "setShippingMethodTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodTaxAmountActionSchema",
                "setShippingMethodTaxRate": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodTaxRateActionSchema",
                "setShippingRateInput": "commercetools._schemas._order_edit.StagedOrderSetShippingRateInputActionSchema",
                "transitionCustomLineItemState": "commercetools._schemas._order_edit.StagedOrderTransitionCustomLineItemStateActionSchema",
                "transitionLineItemState": "commercetools._schemas._order_edit.StagedOrderTransitionLineItemStateActionSchema",
                "transitionState": "commercetools._schemas._order_edit.StagedOrderTransitionStateActionSchema",
                "updateItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderUpdateItemShippingAddressActionSchema",
                "updateSyncInfo": "commercetools._schemas._order_edit.StagedOrderUpdateSyncInfoActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        data_key="stagedActions",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    result = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Applied": "commercetools._schemas._order_edit.OrderEditAppliedSchema",
            "NotProcessed": "commercetools._schemas._order_edit.OrderEditNotProcessedSchema",
            "PreviewFailure": "commercetools._schemas._order_edit.OrderEditPreviewFailureSchema",
            "PreviewSuccess": "commercetools._schemas._order_edit.OrderEditPreviewSuccessSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    comment = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderEdit(**data)


class OrderEditUpdateActionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditUpdateAction`."""

    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderEditUpdateAction(**data)


class OrderEditUpdateSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditUpdate`."""

    version = marshmallow.fields.Integer(allow_none=True)
    actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "addStagedAction": "commercetools._schemas._order_edit.OrderEditAddStagedActionActionSchema",
                "setComment": "commercetools._schemas._order_edit.OrderEditSetCommentActionSchema",
                "setCustomField": "commercetools._schemas._order_edit.OrderEditSetCustomFieldActionSchema",
                "setCustomType": "commercetools._schemas._order_edit.OrderEditSetCustomTypeActionSchema",
                "setKey": "commercetools._schemas._order_edit.OrderEditSetKeyActionSchema",
                "setStagedActions": "commercetools._schemas._order_edit.OrderEditSetStagedActionsActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        )
    )
    dry_run = marshmallow.fields.Bool(allow_none=True, missing=None, data_key="dryRun")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderEditUpdate(**data)


class OrderExcerptSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.OrderExcerpt`."""

    total_price = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalPrice",
    )
    taxed_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxedPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )
    version = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.OrderExcerpt(**data)


class StagedOrderAddCustomLineItemActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderAddCustomLineItemAction`."""

    money = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    name = LocalizedStringField(allow_none=True)
    quantity = marshmallow.fields.Integer(allow_none=True, missing=None)
    slug = marshmallow.fields.String(allow_none=True)
    tax_category = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxCategoryResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxCategory",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderAddCustomLineItemAction(**data)


class StagedOrderAddDeliveryActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderAddDeliveryAction`."""

    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )
    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    parcels = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ParcelDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderAddDeliveryAction(**data)


class StagedOrderAddDiscountCodeActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderAddDiscountCodeAction`."""

    code = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderAddDiscountCodeAction(**data)


class StagedOrderAddItemShippingAddressActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderAddItemShippingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderAddItemShippingAddressAction(**data)


class StagedOrderAddLineItemActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderAddLineItemAction`."""

    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )
    product_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="productId"
    )
    variant_id = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="variantId"
    )
    sku = marshmallow.fields.String(allow_none=True, missing=None)
    quantity = marshmallow.fields.Integer(allow_none=True, missing=None)
    added_at = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="addedAt"
    )
    supply_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    external_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalPrice",
    )
    external_total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalLineItemTotalPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTotalPrice",
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderAddLineItemAction(**data)


class StagedOrderAddParcelToDeliveryActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderAddParcelToDeliveryAction`."""

    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    measurements = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ParcelMeasurementsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    tracking_data = helpers.LazyNestedField(
        nested="commercetools._schemas._order.TrackingDataSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="trackingData",
    )
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderAddParcelToDeliveryAction(**data)


class StagedOrderAddPaymentActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderAddPaymentAction`."""

    payment = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderAddPaymentAction(**data)


class StagedOrderAddReturnInfoActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderAddReturnInfoAction`."""

    return_tracking_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="returnTrackingId"
    )
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ReturnItemDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    return_date = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="returnDate"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderAddReturnInfoAction(**data)


class StagedOrderAddShoppingListActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderAddShoppingListAction`."""

    shopping_list = helpers.LazyNestedField(
        nested="commercetools._schemas._shopping_list.ShoppingListResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="shoppingList",
    )
    supply_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderAddShoppingListAction(**data)


class StagedOrderChangeCustomLineItemMoneyActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderChangeCustomLineItemMoneyAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    money = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderChangeCustomLineItemMoneyAction(**data)


class StagedOrderChangeCustomLineItemQuantityActionSchema(
    StagedOrderUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderChangeCustomLineItemQuantityAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    quantity = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderChangeCustomLineItemQuantityAction(**data)


class StagedOrderChangeLineItemQuantityActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderChangeLineItemQuantityAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    quantity = marshmallow.fields.Integer(allow_none=True)
    external_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalPrice",
    )
    external_total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalLineItemTotalPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTotalPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderChangeLineItemQuantityAction(**data)


class StagedOrderChangeOrderStateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderChangeOrderStateAction`."""

    order_state = marshmallow_enum.EnumField(
        types.OrderState, by_value=True, data_key="orderState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderChangeOrderStateAction(**data)


class StagedOrderChangePaymentStateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderChangePaymentStateAction`."""

    payment_state = marshmallow_enum.EnumField(
        types.PaymentState, by_value=True, missing=None, data_key="paymentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderChangePaymentStateAction(**data)


class StagedOrderChangeShipmentStateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderChangeShipmentStateAction`."""

    shipment_state = marshmallow_enum.EnumField(
        types.ShipmentState, by_value=True, missing=None, data_key="shipmentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderChangeShipmentStateAction(**data)


class StagedOrderChangeTaxCalculationModeActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderChangeTaxCalculationModeAction`."""

    tax_calculation_mode = marshmallow_enum.EnumField(
        types.TaxCalculationMode, by_value=True, data_key="taxCalculationMode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderChangeTaxCalculationModeAction(**data)


class StagedOrderChangeTaxModeActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderChangeTaxModeAction`."""

    tax_mode = marshmallow_enum.EnumField(
        types.TaxMode, by_value=True, data_key="taxMode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderChangeTaxModeAction(**data)


class StagedOrderChangeTaxRoundingModeActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderChangeTaxRoundingModeAction`."""

    tax_rounding_mode = marshmallow_enum.EnumField(
        types.RoundingMode, by_value=True, data_key="taxRoundingMode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderChangeTaxRoundingModeAction(**data)


class StagedOrderImportCustomLineItemStateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderImportCustomLineItemStateAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ItemStateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderImportCustomLineItemStateAction(**data)


class StagedOrderImportLineItemStateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderImportLineItemStateAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ItemStateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderImportLineItemStateAction(**data)


class StagedOrderRemoveCustomLineItemActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderRemoveCustomLineItemAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderRemoveCustomLineItemAction(**data)


class StagedOrderRemoveDeliveryActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderRemoveDeliveryAction`."""

    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderRemoveDeliveryAction(**data)


class StagedOrderRemoveDiscountCodeActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderRemoveDiscountCodeAction`."""

    discount_code = helpers.LazyNestedField(
        nested="commercetools._schemas._discount_code.DiscountCodeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountCode",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderRemoveDiscountCodeAction(**data)


class StagedOrderRemoveItemShippingAddressActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderRemoveItemShippingAddressAction`."""

    address_key = marshmallow.fields.String(allow_none=True, data_key="addressKey")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderRemoveItemShippingAddressAction(**data)


class StagedOrderRemoveLineItemActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderRemoveLineItemAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    quantity = marshmallow.fields.Integer(allow_none=True, missing=None)
    external_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalPrice",
    )
    external_total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalLineItemTotalPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTotalPrice",
    )
    shipping_details_to_remove = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetailsToRemove",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderRemoveLineItemAction(**data)


class StagedOrderRemoveParcelFromDeliveryActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderRemoveParcelFromDeliveryAction`."""

    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderRemoveParcelFromDeliveryAction(**data)


class StagedOrderRemovePaymentActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderRemovePaymentAction`."""

    payment = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderRemovePaymentAction(**data)


class StagedOrderSchema(OrderSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrder`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.StagedOrder(**data)


class StagedOrderSetBillingAddressActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetBillingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetBillingAddressAction(**data)


class StagedOrderSetCountryActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCountryAction`."""

    country = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCountryAction(**data)


class StagedOrderSetCustomFieldActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomFieldAction`."""

    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomFieldAction(**data)


class StagedOrderSetCustomLineItemCustomFieldActionSchema(
    StagedOrderUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomLineItemCustomFieldAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomLineItemCustomFieldAction(**data)


class StagedOrderSetCustomLineItemCustomTypeActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomLineItemCustomTypeAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomLineItemCustomTypeAction(**data)


class StagedOrderSetCustomLineItemShippingDetailsActionSchema(
    StagedOrderUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomLineItemShippingDetailsAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomLineItemShippingDetailsAction(**data)


class StagedOrderSetCustomLineItemTaxAmountActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomLineItemTaxAmountAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    external_tax_amount = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxAmountDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxAmount",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomLineItemTaxAmountAction(**data)


class StagedOrderSetCustomLineItemTaxRateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomLineItemTaxRateAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomLineItemTaxRateAction(**data)


class StagedOrderSetCustomShippingMethodActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomShippingMethodAction`."""

    shipping_method_name = marshmallow.fields.String(
        allow_none=True, data_key="shippingMethodName"
    )
    shipping_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="shippingRate",
    )
    tax_category = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxCategoryResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxCategory",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomShippingMethodAction(**data)


class StagedOrderSetCustomTypeActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomTypeAction`."""

    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomTypeAction(**data)


class StagedOrderSetCustomerEmailActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomerEmailAction`."""

    email = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomerEmailAction(**data)


class StagedOrderSetCustomerGroupActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomerGroupAction`."""

    customer_group = helpers.LazyNestedField(
        nested="commercetools._schemas._customer_group.CustomerGroupResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomerGroupAction(**data)


class StagedOrderSetCustomerIdActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetCustomerIdAction`."""

    customer_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetCustomerIdAction(**data)


class StagedOrderSetDeliveryAddressActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetDeliveryAddressAction`."""

    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetDeliveryAddressAction(**data)


class StagedOrderSetDeliveryItemsActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetDeliveryItemsAction`."""

    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetDeliveryItemsAction(**data)


class StagedOrderSetLineItemCustomFieldActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetLineItemCustomFieldAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetLineItemCustomFieldAction(**data)


class StagedOrderSetLineItemCustomTypeActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetLineItemCustomTypeAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetLineItemCustomTypeAction(**data)


class StagedOrderSetLineItemDistributionChannelActionSchema(
    StagedOrderUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetLineItemDistributionChannelAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetLineItemDistributionChannelAction(**data)


class StagedOrderSetLineItemPriceActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetLineItemPriceAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    external_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetLineItemPriceAction(**data)


class StagedOrderSetLineItemShippingDetailsActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetLineItemShippingDetailsAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetLineItemShippingDetailsAction(**data)


class StagedOrderSetLineItemTaxAmountActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetLineItemTaxAmountAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    external_tax_amount = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxAmountDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxAmount",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetLineItemTaxAmountAction(**data)


class StagedOrderSetLineItemTaxRateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetLineItemTaxRateAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetLineItemTaxRateAction(**data)


class StagedOrderSetLineItemTotalPriceActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetLineItemTotalPriceAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    external_total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalLineItemTotalPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTotalPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetLineItemTotalPriceAction(**data)


class StagedOrderSetLocaleActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetLocaleAction`."""

    locale = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetLocaleAction(**data)


class StagedOrderSetOrderNumberActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetOrderNumberAction`."""

    order_number = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="orderNumber"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetOrderNumberAction(**data)


class StagedOrderSetOrderTotalTaxActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetOrderTotalTaxAction`."""

    external_total_gross = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="externalTotalGross",
    )
    external_tax_portions = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxPortionDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="externalTaxPortions",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetOrderTotalTaxAction(**data)


class StagedOrderSetParcelItemsActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetParcelItemsAction`."""

    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    items = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetParcelItemsAction(**data)


class StagedOrderSetParcelMeasurementsActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetParcelMeasurementsAction`."""

    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    measurements = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ParcelMeasurementsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetParcelMeasurementsAction(**data)


class StagedOrderSetParcelTrackingDataActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetParcelTrackingDataAction`."""

    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    tracking_data = helpers.LazyNestedField(
        nested="commercetools._schemas._order.TrackingDataSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="trackingData",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetParcelTrackingDataAction(**data)


class StagedOrderSetReturnPaymentStateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetReturnPaymentStateAction`."""

    return_item_id = marshmallow.fields.String(allow_none=True, data_key="returnItemId")
    payment_state = marshmallow_enum.EnumField(
        types.ReturnPaymentState, by_value=True, data_key="paymentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetReturnPaymentStateAction(**data)


class StagedOrderSetReturnShipmentStateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetReturnShipmentStateAction`."""

    return_item_id = marshmallow.fields.String(allow_none=True, data_key="returnItemId")
    shipment_state = marshmallow_enum.EnumField(
        types.ReturnShipmentState, by_value=True, data_key="shipmentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetReturnShipmentStateAction(**data)


class StagedOrderSetShippingAddressActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetShippingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetShippingAddressAction(**data)


class StagedOrderSetShippingAddressAndCustomShippingMethodActionSchema(
    StagedOrderUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetShippingAddressAndCustomShippingMethodAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    shipping_method_name = marshmallow.fields.String(
        allow_none=True, data_key="shippingMethodName"
    )
    shipping_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="shippingRate",
    )
    tax_category = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxCategoryResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxCategory",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetShippingAddressAndCustomShippingMethodAction(**data)


class StagedOrderSetShippingAddressAndShippingMethodActionSchema(
    StagedOrderUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetShippingAddressAndShippingMethodAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    shipping_method = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingMethodResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingMethod",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetShippingAddressAndShippingMethodAction(**data)


class StagedOrderSetShippingMethodActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetShippingMethodAction`."""

    shipping_method = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingMethodResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingMethod",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetShippingMethodAction(**data)


class StagedOrderSetShippingMethodTaxAmountActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetShippingMethodTaxAmountAction`."""

    external_tax_amount = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxAmountDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxAmount",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetShippingMethodTaxAmountAction(**data)


class StagedOrderSetShippingMethodTaxRateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetShippingMethodTaxRateAction`."""

    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetShippingMethodTaxRateAction(**data)


class StagedOrderSetShippingRateInputActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderSetShippingRateInputAction`."""

    shipping_rate_input = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Classification": "commercetools._schemas._cart.ClassificationShippingRateInputDraftSchema",
            "Score": "commercetools._schemas._cart.ScoreShippingRateInputDraftSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingRateInput",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderSetShippingRateInputAction(**data)


class StagedOrderTransitionCustomLineItemStateActionSchema(
    StagedOrderUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderTransitionCustomLineItemStateAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    quantity = marshmallow.fields.Integer(allow_none=True)
    from_state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="fromState",
    )
    to_state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="toState",
    )
    actual_transition_date = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="actualTransitionDate"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderTransitionCustomLineItemStateAction(**data)


class StagedOrderTransitionLineItemStateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderTransitionLineItemStateAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    quantity = marshmallow.fields.Integer(allow_none=True)
    from_state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="fromState",
    )
    to_state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="toState",
    )
    actual_transition_date = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="actualTransitionDate"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderTransitionLineItemStateAction(**data)


class StagedOrderTransitionStateActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderTransitionStateAction`."""

    state = helpers.LazyNestedField(
        nested="commercetools._schemas._state.StateResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderTransitionStateAction(**data)


class StagedOrderUpdateItemShippingAddressActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderUpdateItemShippingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderUpdateItemShippingAddressAction(**data)


class StagedOrderUpdateSyncInfoActionSchema(StagedOrderUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.StagedOrderUpdateSyncInfoAction`."""

    channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    external_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="externalId"
    )
    synced_at = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="syncedAt"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.StagedOrderUpdateSyncInfoAction(**data)


class OrderEditAddStagedActionActionSchema(OrderEditUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditAddStagedActionAction`."""

    staged_action = helpers.Discriminator(
        discriminator_field=("action", "action"),
        discriminator_schemas={
            "addCustomLineItem": "commercetools._schemas._order_edit.StagedOrderAddCustomLineItemActionSchema",
            "addDelivery": "commercetools._schemas._order_edit.StagedOrderAddDeliveryActionSchema",
            "addDiscountCode": "commercetools._schemas._order_edit.StagedOrderAddDiscountCodeActionSchema",
            "addItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderAddItemShippingAddressActionSchema",
            "addLineItem": "commercetools._schemas._order_edit.StagedOrderAddLineItemActionSchema",
            "addParcelToDelivery": "commercetools._schemas._order_edit.StagedOrderAddParcelToDeliveryActionSchema",
            "addPayment": "commercetools._schemas._order_edit.StagedOrderAddPaymentActionSchema",
            "addReturnInfo": "commercetools._schemas._order_edit.StagedOrderAddReturnInfoActionSchema",
            "addShoppingList": "commercetools._schemas._order_edit.StagedOrderAddShoppingListActionSchema",
            "changeCustomLineItemMoney": "commercetools._schemas._order_edit.StagedOrderChangeCustomLineItemMoneyActionSchema",
            "changeCustomLineItemQuantity": "commercetools._schemas._order_edit.StagedOrderChangeCustomLineItemQuantityActionSchema",
            "changeLineItemQuantity": "commercetools._schemas._order_edit.StagedOrderChangeLineItemQuantityActionSchema",
            "changeOrderState": "commercetools._schemas._order_edit.StagedOrderChangeOrderStateActionSchema",
            "changePaymentState": "commercetools._schemas._order_edit.StagedOrderChangePaymentStateActionSchema",
            "changeShipmentState": "commercetools._schemas._order_edit.StagedOrderChangeShipmentStateActionSchema",
            "changeTaxCalculationMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxCalculationModeActionSchema",
            "changeTaxMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxModeActionSchema",
            "changeTaxRoundingMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxRoundingModeActionSchema",
            "importCustomLineItemState": "commercetools._schemas._order_edit.StagedOrderImportCustomLineItemStateActionSchema",
            "importLineItemState": "commercetools._schemas._order_edit.StagedOrderImportLineItemStateActionSchema",
            "removeCustomLineItem": "commercetools._schemas._order_edit.StagedOrderRemoveCustomLineItemActionSchema",
            "removeDelivery": "commercetools._schemas._order_edit.StagedOrderRemoveDeliveryActionSchema",
            "removeDiscountCode": "commercetools._schemas._order_edit.StagedOrderRemoveDiscountCodeActionSchema",
            "removeItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderRemoveItemShippingAddressActionSchema",
            "removeLineItem": "commercetools._schemas._order_edit.StagedOrderRemoveLineItemActionSchema",
            "removeParcelFromDelivery": "commercetools._schemas._order_edit.StagedOrderRemoveParcelFromDeliveryActionSchema",
            "removePayment": "commercetools._schemas._order_edit.StagedOrderRemovePaymentActionSchema",
            "setBillingAddress": "commercetools._schemas._order_edit.StagedOrderSetBillingAddressActionSchema",
            "setCountry": "commercetools._schemas._order_edit.StagedOrderSetCountryActionSchema",
            "setCustomField": "commercetools._schemas._order_edit.StagedOrderSetCustomFieldActionSchema",
            "setCustomLineItemCustomField": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemCustomFieldActionSchema",
            "setCustomLineItemCustomType": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemCustomTypeActionSchema",
            "setCustomLineItemShippingDetails": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemShippingDetailsActionSchema",
            "setCustomLineItemTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemTaxAmountActionSchema",
            "setCustomLineItemTaxRate": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemTaxRateActionSchema",
            "setCustomShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetCustomShippingMethodActionSchema",
            "setCustomType": "commercetools._schemas._order_edit.StagedOrderSetCustomTypeActionSchema",
            "setCustomerEmail": "commercetools._schemas._order_edit.StagedOrderSetCustomerEmailActionSchema",
            "setCustomerGroup": "commercetools._schemas._order_edit.StagedOrderSetCustomerGroupActionSchema",
            "setCustomerId": "commercetools._schemas._order_edit.StagedOrderSetCustomerIdActionSchema",
            "setDeliveryAddress": "commercetools._schemas._order_edit.StagedOrderSetDeliveryAddressActionSchema",
            "setDeliveryItems": "commercetools._schemas._order_edit.StagedOrderSetDeliveryItemsActionSchema",
            "setLineItemCustomField": "commercetools._schemas._order_edit.StagedOrderSetLineItemCustomFieldActionSchema",
            "setLineItemCustomType": "commercetools._schemas._order_edit.StagedOrderSetLineItemCustomTypeActionSchema",
            "setLineItemDistributionChannel": "commercetools._schemas._order_edit.StagedOrderSetLineItemDistributionChannelActionSchema",
            "setLineItemPrice": "commercetools._schemas._order_edit.StagedOrderSetLineItemPriceActionSchema",
            "setLineItemShippingDetails": "commercetools._schemas._order_edit.StagedOrderSetLineItemShippingDetailsActionSchema",
            "setLineItemTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetLineItemTaxAmountActionSchema",
            "setLineItemTaxRate": "commercetools._schemas._order_edit.StagedOrderSetLineItemTaxRateActionSchema",
            "setLineItemTotalPrice": "commercetools._schemas._order_edit.StagedOrderSetLineItemTotalPriceActionSchema",
            "setLocale": "commercetools._schemas._order_edit.StagedOrderSetLocaleActionSchema",
            "setOrderNumber": "commercetools._schemas._order_edit.StagedOrderSetOrderNumberActionSchema",
            "setOrderTotalTax": "commercetools._schemas._order_edit.StagedOrderSetOrderTotalTaxActionSchema",
            "setParcelItems": "commercetools._schemas._order_edit.StagedOrderSetParcelItemsActionSchema",
            "setParcelMeasurements": "commercetools._schemas._order_edit.StagedOrderSetParcelMeasurementsActionSchema",
            "setParcelTrackingData": "commercetools._schemas._order_edit.StagedOrderSetParcelTrackingDataActionSchema",
            "setReturnPaymentState": "commercetools._schemas._order_edit.StagedOrderSetReturnPaymentStateActionSchema",
            "setReturnShipmentState": "commercetools._schemas._order_edit.StagedOrderSetReturnShipmentStateActionSchema",
            "setShippingAddress": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressActionSchema",
            "setShippingAddressAndCustomShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressAndCustomShippingMethodActionSchema",
            "setShippingAddressAndShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressAndShippingMethodActionSchema",
            "setShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodActionSchema",
            "setShippingMethodTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodTaxAmountActionSchema",
            "setShippingMethodTaxRate": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodTaxRateActionSchema",
            "setShippingRateInput": "commercetools._schemas._order_edit.StagedOrderSetShippingRateInputActionSchema",
            "transitionCustomLineItemState": "commercetools._schemas._order_edit.StagedOrderTransitionCustomLineItemStateActionSchema",
            "transitionLineItemState": "commercetools._schemas._order_edit.StagedOrderTransitionLineItemStateActionSchema",
            "transitionState": "commercetools._schemas._order_edit.StagedOrderTransitionStateActionSchema",
            "updateItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderUpdateItemShippingAddressActionSchema",
            "updateSyncInfo": "commercetools._schemas._order_edit.StagedOrderUpdateSyncInfoActionSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="stagedAction",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderEditAddStagedActionAction(**data)


class OrderEditAppliedSchema(OrderEditResultSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditApplied`."""

    applied_at = marshmallow.fields.DateTime(allow_none=True, data_key="appliedAt")
    excerpt_before_edit = helpers.LazyNestedField(
        nested="commercetools._schemas._order_edit.OrderExcerptSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="excerptBeforeEdit",
    )
    excerpt_after_edit = helpers.LazyNestedField(
        nested="commercetools._schemas._order_edit.OrderExcerptSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="excerptAfterEdit",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderEditApplied(**data)


class OrderEditNotProcessedSchema(OrderEditResultSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditNotProcessed`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderEditNotProcessed()


class OrderEditPreviewFailureSchema(OrderEditResultSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditPreviewFailure`."""

    errors = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("code", "code"),
            discriminator_schemas={
                "access_denied": "commercetools._schemas._error.AccessDeniedErrorSchema",
                "AnonymousIdAlreadyInUse": "commercetools._schemas._error.AnonymousIdAlreadyInUseErrorSchema",
                "AttributeDefinitionAlreadyExists": "commercetools._schemas._error.AttributeDefinitionAlreadyExistsErrorSchema",
                "AttributeDefinitionTypeConflict": "commercetools._schemas._error.AttributeDefinitionTypeConflictErrorSchema",
                "AttributeNameDoesNotExist": "commercetools._schemas._error.AttributeNameDoesNotExistErrorSchema",
                "ConcurrentModification": "commercetools._schemas._error.ConcurrentModificationErrorSchema",
                "DiscountCodeNonApplicable": "commercetools._schemas._error.DiscountCodeNonApplicableErrorSchema",
                "DuplicateAttributeValue": "commercetools._schemas._error.DuplicateAttributeValueErrorSchema",
                "DuplicateAttributeValues": "commercetools._schemas._error.DuplicateAttributeValuesErrorSchema",
                "DuplicateEnumValues": "commercetools._schemas._error.DuplicateEnumValuesErrorSchema",
                "DuplicateField": "commercetools._schemas._error.DuplicateFieldErrorSchema",
                "DuplicateFieldWithConflictingResource": "commercetools._schemas._error.DuplicateFieldWithConflictingResourceErrorSchema",
                "DuplicatePriceScope": "commercetools._schemas._error.DuplicatePriceScopeErrorSchema",
                "DuplicateVariantValues": "commercetools._schemas._error.DuplicateVariantValuesErrorSchema",
                "EditPreviewFailed": "commercetools._schemas._error.EditPreviewFailedErrorSchema",
                "EnumKeyAlreadyExists": "commercetools._schemas._error.EnumKeyAlreadyExistsErrorSchema",
                "EnumKeyDoesNotExist": "commercetools._schemas._error.EnumKeyDoesNotExistErrorSchema",
                "EnumValueIsUsed": "commercetools._schemas._error.EnumValueIsUsedErrorSchema",
                "EnumValuesMustMatch": "commercetools._schemas._error.EnumValuesMustMatchErrorSchema",
                "ExtensionBadResponse": "commercetools._schemas._error.ExtensionBadResponseErrorSchema",
                "ExtensionNoResponse": "commercetools._schemas._error.ExtensionNoResponseErrorSchema",
                "ExtensionUpdateActionsFailed": "commercetools._schemas._error.ExtensionUpdateActionsFailedErrorSchema",
                "ExternalOAuthFailed": "commercetools._schemas._error.ExternalOAuthFailedErrorSchema",
                "FeatureRemoved": "commercetools._schemas._error.FeatureRemovedErrorSchema",
                "General": "commercetools._schemas._error.GeneralErrorSchema",
                "insufficient_scope": "commercetools._schemas._error.InsufficientScopeErrorSchema",
                "InternalConstraintViolated": "commercetools._schemas._error.InternalConstraintViolatedErrorSchema",
                "InvalidCredentials": "commercetools._schemas._error.InvalidCredentialsErrorSchema",
                "InvalidCurrentPassword": "commercetools._schemas._error.InvalidCurrentPasswordErrorSchema",
                "InvalidField": "commercetools._schemas._error.InvalidFieldErrorSchema",
                "InvalidInput": "commercetools._schemas._error.InvalidInputErrorSchema",
                "InvalidItemShippingDetails": "commercetools._schemas._error.InvalidItemShippingDetailsErrorSchema",
                "InvalidJsonInput": "commercetools._schemas._error.InvalidJsonInputErrorSchema",
                "InvalidOperation": "commercetools._schemas._error.InvalidOperationErrorSchema",
                "InvalidSubject": "commercetools._schemas._error.InvalidSubjectErrorSchema",
                "invalid_token": "commercetools._schemas._error.InvalidTokenErrorSchema",
                "LanguageUsedInStores": "commercetools._schemas._error.LanguageUsedInStoresErrorSchema",
                "MatchingPriceNotFound": "commercetools._schemas._error.MatchingPriceNotFoundErrorSchema",
                "MaxResourceLimitExceeded": "commercetools._schemas._error.MaxResourceLimitExceededErrorSchema",
                "MissingRoleOnChannel": "commercetools._schemas._error.MissingRoleOnChannelErrorSchema",
                "MissingTaxRateForCountry": "commercetools._schemas._error.MissingTaxRateForCountryErrorSchema",
                "NoMatchingProductDiscountFound": "commercetools._schemas._error.NoMatchingProductDiscountFoundErrorSchema",
                "NotEnabled": "commercetools._schemas._error.NotEnabledErrorSchema",
                "ObjectNotFound": "commercetools._schemas._error.ObjectNotFoundErrorSchema",
                "OutOfStock": "commercetools._schemas._error.OutOfStockErrorSchema",
                "OverCapacity": "commercetools._schemas._error.OverCapacityErrorSchema",
                "PendingOperation": "commercetools._schemas._error.PendingOperationErrorSchema",
                "PriceChanged": "commercetools._schemas._error.PriceChangedErrorSchema",
                "ProjectNotConfiguredForLanguages": "commercetools._schemas._error.ProjectNotConfiguredForLanguagesErrorSchema",
                "QueryComplexityLimitExceeded": "commercetools._schemas._error.QueryComplexityLimitExceededErrorSchema",
                "QueryTimedOut": "commercetools._schemas._error.QueryTimedOutErrorSchema",
                "ReferenceExists": "commercetools._schemas._error.ReferenceExistsErrorSchema",
                "ReferencedResourceNotFound": "commercetools._schemas._error.ReferencedResourceNotFoundErrorSchema",
                "RequiredField": "commercetools._schemas._error.RequiredFieldErrorSchema",
                "ResourceNotFound": "commercetools._schemas._error.ResourceNotFoundErrorSchema",
                "ResourceSizeLimitExceeded": "commercetools._schemas._error.ResourceSizeLimitExceededErrorSchema",
                "SearchExecutionFailure": "commercetools._schemas._error.SearchExecutionFailureErrorSchema",
                "SearchFacetPathNotFound": "commercetools._schemas._error.SearchFacetPathNotFoundErrorSchema",
                "SemanticError": "commercetools._schemas._error.SemanticErrorErrorSchema",
                "ShippingMethodDoesNotMatchCart": "commercetools._schemas._error.ShippingMethodDoesNotMatchCartErrorSchema",
                "SyntaxError": "commercetools._schemas._error.SyntaxErrorErrorSchema",
                "WeakPassword": "commercetools._schemas._error.WeakPasswordErrorSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        )
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderEditPreviewFailure(**data)


class OrderEditPreviewSuccessSchema(OrderEditResultSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditPreviewSuccess`."""

    preview = helpers.LazyNestedField(
        nested="commercetools._schemas._order_edit.StagedOrderSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    message_payloads = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("type", "type"),
            discriminator_schemas={
                "CategoryCreated": "commercetools._schemas._message.CategoryCreatedMessagePayloadSchema",
                "CategorySlugChanged": "commercetools._schemas._message.CategorySlugChangedMessagePayloadSchema",
                "CustomLineItemStateTransition": "commercetools._schemas._message.CustomLineItemStateTransitionMessagePayloadSchema",
                "CustomerAddressAdded": "commercetools._schemas._message.CustomerAddressAddedMessagePayloadSchema",
                "CustomerAddressChanged": "commercetools._schemas._message.CustomerAddressChangedMessagePayloadSchema",
                "CustomerAddressRemoved": "commercetools._schemas._message.CustomerAddressRemovedMessagePayloadSchema",
                "CustomerCompanyNameSet": "commercetools._schemas._message.CustomerCompanyNameSetMessagePayloadSchema",
                "CustomerCreated": "commercetools._schemas._message.CustomerCreatedMessagePayloadSchema",
                "CustomerDateOfBirthSet": "commercetools._schemas._message.CustomerDateOfBirthSetMessagePayloadSchema",
                "CustomerEmailChanged": "commercetools._schemas._message.CustomerEmailChangedMessagePayloadSchema",
                "CustomerEmailVerified": "commercetools._schemas._message.CustomerEmailVerifiedMessagePayloadSchema",
                "CustomerGroupSet": "commercetools._schemas._message.CustomerGroupSetMessagePayloadSchema",
                "DeliveryAdded": "commercetools._schemas._message.DeliveryAddedMessagePayloadSchema",
                "DeliveryAddressSet": "commercetools._schemas._message.DeliveryAddressSetMessagePayloadSchema",
                "DeliveryItemsUpdated": "commercetools._schemas._message.DeliveryItemsUpdatedMessagePayloadSchema",
                "DeliveryRemoved": "commercetools._schemas._message.DeliveryRemovedMessagePayloadSchema",
                "InventoryEntryCreated": "commercetools._schemas._message.InventoryEntryCreatedMessagePayloadSchema",
                "InventoryEntryDeleted": "commercetools._schemas._message.InventoryEntryDeletedMessagePayloadSchema",
                "InventoryEntryQuantitySet": "commercetools._schemas._message.InventoryEntryQuantitySetMessagePayloadSchema",
                "LineItemStateTransition": "commercetools._schemas._message.LineItemStateTransitionMessagePayloadSchema",
                "OrderBillingAddressSet": "commercetools._schemas._message.OrderBillingAddressSetMessagePayloadSchema",
                "OrderCreated": "commercetools._schemas._message.OrderCreatedMessagePayloadSchema",
                "OrderCustomLineItemDiscountSet": "commercetools._schemas._message.OrderCustomLineItemDiscountSetMessagePayloadSchema",
                "OrderCustomerEmailSet": "commercetools._schemas._message.OrderCustomerEmailSetMessagePayloadSchema",
                "OrderCustomerGroupSet": "commercetools._schemas._message.OrderCustomerGroupSetMessagePayloadSchema",
                "OrderCustomerSet": "commercetools._schemas._message.OrderCustomerSetMessagePayloadSchema",
                "OrderDeleted": "commercetools._schemas._message.OrderDeletedMessagePayloadSchema",
                "OrderDiscountCodeAdded": "commercetools._schemas._message.OrderDiscountCodeAddedMessagePayloadSchema",
                "OrderDiscountCodeRemoved": "commercetools._schemas._message.OrderDiscountCodeRemovedMessagePayloadSchema",
                "OrderDiscountCodeStateSet": "commercetools._schemas._message.OrderDiscountCodeStateSetMessagePayloadSchema",
                "OrderEditApplied": "commercetools._schemas._message.OrderEditAppliedMessagePayloadSchema",
                "OrderImported": "commercetools._schemas._message.OrderImportedMessagePayloadSchema",
                "OrderLineItemAdded": "commercetools._schemas._message.OrderLineItemAddedMessagePayloadSchema",
                "OrderLineItemDiscountSet": "commercetools._schemas._message.OrderLineItemDiscountSetMessagePayloadSchema",
                "OrderPaymentStateChanged": "commercetools._schemas._message.OrderPaymentStateChangedMessagePayloadSchema",
                "ReturnInfoAdded": "commercetools._schemas._message.OrderReturnInfoAddedMessagePayloadSchema",
                "OrderReturnShipmentStateChanged": "commercetools._schemas._message.OrderReturnShipmentStateChangedMessagePayloadSchema",
                "OrderShipmentStateChanged": "commercetools._schemas._message.OrderShipmentStateChangedMessagePayloadSchema",
                "OrderShippingAddressSet": "commercetools._schemas._message.OrderShippingAddressSetMessagePayloadSchema",
                "OrderShippingInfoSet": "commercetools._schemas._message.OrderShippingInfoSetMessagePayloadSchema",
                "OrderShippingRateInputSet": "commercetools._schemas._message.OrderShippingRateInputSetMessagePayloadSchema",
                "OrderStateChanged": "commercetools._schemas._message.OrderStateChangedMessagePayloadSchema",
                "OrderStateTransition": "commercetools._schemas._message.OrderStateTransitionMessagePayloadSchema",
                "OrderStoreSet": "commercetools._schemas._message.OrderStoreSetMessagePayloadSchema",
                "ParcelAddedToDelivery": "commercetools._schemas._message.ParcelAddedToDeliveryMessagePayloadSchema",
                "ParcelItemsUpdated": "commercetools._schemas._message.ParcelItemsUpdatedMessagePayloadSchema",
                "ParcelMeasurementsUpdated": "commercetools._schemas._message.ParcelMeasurementsUpdatedMessagePayloadSchema",
                "ParcelRemovedFromDelivery": "commercetools._schemas._message.ParcelRemovedFromDeliveryMessagePayloadSchema",
                "ParcelTrackingDataUpdated": "commercetools._schemas._message.ParcelTrackingDataUpdatedMessagePayloadSchema",
                "PaymentCreated": "commercetools._schemas._message.PaymentCreatedMessagePayloadSchema",
                "PaymentInteractionAdded": "commercetools._schemas._message.PaymentInteractionAddedMessagePayloadSchema",
                "PaymentStatusInterfaceCodeSet": "commercetools._schemas._message.PaymentStatusInterfaceCodeSetMessagePayloadSchema",
                "PaymentStatusStateTransition": "commercetools._schemas._message.PaymentStatusStateTransitionMessagePayloadSchema",
                "PaymentTransactionAdded": "commercetools._schemas._message.PaymentTransactionAddedMessagePayloadSchema",
                "PaymentTransactionStateChanged": "commercetools._schemas._message.PaymentTransactionStateChangedMessagePayloadSchema",
                "ProductAddedToCategory": "commercetools._schemas._message.ProductAddedToCategoryMessagePayloadSchema",
                "ProductCreated": "commercetools._schemas._message.ProductCreatedMessagePayloadSchema",
                "ProductDeleted": "commercetools._schemas._message.ProductDeletedMessagePayloadSchema",
                "ProductImageAdded": "commercetools._schemas._message.ProductImageAddedMessagePayloadSchema",
                "ProductPriceDiscountsSet": "commercetools._schemas._message.ProductPriceDiscountsSetMessagePayloadSchema",
                "ProductPriceExternalDiscountSet": "commercetools._schemas._message.ProductPriceExternalDiscountSetMessagePayloadSchema",
                "ProductPublished": "commercetools._schemas._message.ProductPublishedMessagePayloadSchema",
                "ProductRemovedFromCategory": "commercetools._schemas._message.ProductRemovedFromCategoryMessagePayloadSchema",
                "ProductRevertedStagedChanges": "commercetools._schemas._message.ProductRevertedStagedChangesMessagePayloadSchema",
                "ProductSlugChanged": "commercetools._schemas._message.ProductSlugChangedMessagePayloadSchema",
                "ProductStateTransition": "commercetools._schemas._message.ProductStateTransitionMessagePayloadSchema",
                "ProductUnpublished": "commercetools._schemas._message.ProductUnpublishedMessagePayloadSchema",
                "ProductVariantAdded": "commercetools._schemas._message.ProductVariantAddedMessagePayloadSchema",
                "ProductVariantDeleted": "commercetools._schemas._message.ProductVariantDeletedMessagePayloadSchema",
                "ReviewCreated": "commercetools._schemas._message.ReviewCreatedMessagePayloadSchema",
                "ReviewRatingSet": "commercetools._schemas._message.ReviewRatingSetMessagePayloadSchema",
                "ReviewStateTransition": "commercetools._schemas._message.ReviewStateTransitionMessagePayloadSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        data_key="messagePayloads",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderEditPreviewSuccess(**data)


class OrderEditSetCommentActionSchema(OrderEditUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditSetCommentAction`."""

    comment = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderEditSetCommentAction(**data)


class OrderEditSetCustomFieldActionSchema(OrderEditUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditSetCustomFieldAction`."""

    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderEditSetCustomFieldAction(**data)


class OrderEditSetCustomTypeActionSchema(OrderEditUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditSetCustomTypeAction`."""

    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = marshmallow.fields.Dict(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderEditSetCustomTypeAction(**data)


class OrderEditSetKeyActionSchema(OrderEditUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditSetKeyAction`."""

    key = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderEditSetKeyAction(**data)


class OrderEditSetStagedActionsActionSchema(OrderEditUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.OrderEditSetStagedActionsAction`."""

    staged_actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "addCustomLineItem": "commercetools._schemas._order_edit.StagedOrderAddCustomLineItemActionSchema",
                "addDelivery": "commercetools._schemas._order_edit.StagedOrderAddDeliveryActionSchema",
                "addDiscountCode": "commercetools._schemas._order_edit.StagedOrderAddDiscountCodeActionSchema",
                "addItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderAddItemShippingAddressActionSchema",
                "addLineItem": "commercetools._schemas._order_edit.StagedOrderAddLineItemActionSchema",
                "addParcelToDelivery": "commercetools._schemas._order_edit.StagedOrderAddParcelToDeliveryActionSchema",
                "addPayment": "commercetools._schemas._order_edit.StagedOrderAddPaymentActionSchema",
                "addReturnInfo": "commercetools._schemas._order_edit.StagedOrderAddReturnInfoActionSchema",
                "addShoppingList": "commercetools._schemas._order_edit.StagedOrderAddShoppingListActionSchema",
                "changeCustomLineItemMoney": "commercetools._schemas._order_edit.StagedOrderChangeCustomLineItemMoneyActionSchema",
                "changeCustomLineItemQuantity": "commercetools._schemas._order_edit.StagedOrderChangeCustomLineItemQuantityActionSchema",
                "changeLineItemQuantity": "commercetools._schemas._order_edit.StagedOrderChangeLineItemQuantityActionSchema",
                "changeOrderState": "commercetools._schemas._order_edit.StagedOrderChangeOrderStateActionSchema",
                "changePaymentState": "commercetools._schemas._order_edit.StagedOrderChangePaymentStateActionSchema",
                "changeShipmentState": "commercetools._schemas._order_edit.StagedOrderChangeShipmentStateActionSchema",
                "changeTaxCalculationMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxCalculationModeActionSchema",
                "changeTaxMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxModeActionSchema",
                "changeTaxRoundingMode": "commercetools._schemas._order_edit.StagedOrderChangeTaxRoundingModeActionSchema",
                "importCustomLineItemState": "commercetools._schemas._order_edit.StagedOrderImportCustomLineItemStateActionSchema",
                "importLineItemState": "commercetools._schemas._order_edit.StagedOrderImportLineItemStateActionSchema",
                "removeCustomLineItem": "commercetools._schemas._order_edit.StagedOrderRemoveCustomLineItemActionSchema",
                "removeDelivery": "commercetools._schemas._order_edit.StagedOrderRemoveDeliveryActionSchema",
                "removeDiscountCode": "commercetools._schemas._order_edit.StagedOrderRemoveDiscountCodeActionSchema",
                "removeItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderRemoveItemShippingAddressActionSchema",
                "removeLineItem": "commercetools._schemas._order_edit.StagedOrderRemoveLineItemActionSchema",
                "removeParcelFromDelivery": "commercetools._schemas._order_edit.StagedOrderRemoveParcelFromDeliveryActionSchema",
                "removePayment": "commercetools._schemas._order_edit.StagedOrderRemovePaymentActionSchema",
                "setBillingAddress": "commercetools._schemas._order_edit.StagedOrderSetBillingAddressActionSchema",
                "setCountry": "commercetools._schemas._order_edit.StagedOrderSetCountryActionSchema",
                "setCustomField": "commercetools._schemas._order_edit.StagedOrderSetCustomFieldActionSchema",
                "setCustomLineItemCustomField": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemCustomFieldActionSchema",
                "setCustomLineItemCustomType": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemCustomTypeActionSchema",
                "setCustomLineItemShippingDetails": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemShippingDetailsActionSchema",
                "setCustomLineItemTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemTaxAmountActionSchema",
                "setCustomLineItemTaxRate": "commercetools._schemas._order_edit.StagedOrderSetCustomLineItemTaxRateActionSchema",
                "setCustomShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetCustomShippingMethodActionSchema",
                "setCustomType": "commercetools._schemas._order_edit.StagedOrderSetCustomTypeActionSchema",
                "setCustomerEmail": "commercetools._schemas._order_edit.StagedOrderSetCustomerEmailActionSchema",
                "setCustomerGroup": "commercetools._schemas._order_edit.StagedOrderSetCustomerGroupActionSchema",
                "setCustomerId": "commercetools._schemas._order_edit.StagedOrderSetCustomerIdActionSchema",
                "setDeliveryAddress": "commercetools._schemas._order_edit.StagedOrderSetDeliveryAddressActionSchema",
                "setDeliveryItems": "commercetools._schemas._order_edit.StagedOrderSetDeliveryItemsActionSchema",
                "setLineItemCustomField": "commercetools._schemas._order_edit.StagedOrderSetLineItemCustomFieldActionSchema",
                "setLineItemCustomType": "commercetools._schemas._order_edit.StagedOrderSetLineItemCustomTypeActionSchema",
                "setLineItemDistributionChannel": "commercetools._schemas._order_edit.StagedOrderSetLineItemDistributionChannelActionSchema",
                "setLineItemPrice": "commercetools._schemas._order_edit.StagedOrderSetLineItemPriceActionSchema",
                "setLineItemShippingDetails": "commercetools._schemas._order_edit.StagedOrderSetLineItemShippingDetailsActionSchema",
                "setLineItemTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetLineItemTaxAmountActionSchema",
                "setLineItemTaxRate": "commercetools._schemas._order_edit.StagedOrderSetLineItemTaxRateActionSchema",
                "setLineItemTotalPrice": "commercetools._schemas._order_edit.StagedOrderSetLineItemTotalPriceActionSchema",
                "setLocale": "commercetools._schemas._order_edit.StagedOrderSetLocaleActionSchema",
                "setOrderNumber": "commercetools._schemas._order_edit.StagedOrderSetOrderNumberActionSchema",
                "setOrderTotalTax": "commercetools._schemas._order_edit.StagedOrderSetOrderTotalTaxActionSchema",
                "setParcelItems": "commercetools._schemas._order_edit.StagedOrderSetParcelItemsActionSchema",
                "setParcelMeasurements": "commercetools._schemas._order_edit.StagedOrderSetParcelMeasurementsActionSchema",
                "setParcelTrackingData": "commercetools._schemas._order_edit.StagedOrderSetParcelTrackingDataActionSchema",
                "setReturnPaymentState": "commercetools._schemas._order_edit.StagedOrderSetReturnPaymentStateActionSchema",
                "setReturnShipmentState": "commercetools._schemas._order_edit.StagedOrderSetReturnShipmentStateActionSchema",
                "setShippingAddress": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressActionSchema",
                "setShippingAddressAndCustomShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressAndCustomShippingMethodActionSchema",
                "setShippingAddressAndShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingAddressAndShippingMethodActionSchema",
                "setShippingMethod": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodActionSchema",
                "setShippingMethodTaxAmount": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodTaxAmountActionSchema",
                "setShippingMethodTaxRate": "commercetools._schemas._order_edit.StagedOrderSetShippingMethodTaxRateActionSchema",
                "setShippingRateInput": "commercetools._schemas._order_edit.StagedOrderSetShippingRateInputActionSchema",
                "transitionCustomLineItemState": "commercetools._schemas._order_edit.StagedOrderTransitionCustomLineItemStateActionSchema",
                "transitionLineItemState": "commercetools._schemas._order_edit.StagedOrderTransitionLineItemStateActionSchema",
                "transitionState": "commercetools._schemas._order_edit.StagedOrderTransitionStateActionSchema",
                "updateItemShippingAddress": "commercetools._schemas._order_edit.StagedOrderUpdateItemShippingAddressActionSchema",
                "updateSyncInfo": "commercetools._schemas._order_edit.StagedOrderUpdateSyncInfoActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        data_key="stagedActions",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.OrderEditSetStagedActionsAction(**data)
