# DO NOT EDIT! This file is automatically generated
import re
import typing

import marshmallow

from commercetools import helpers, types

__all__ = [
    "GraphQLErrorLocationSchema",
    "GraphQLErrorSchema",
    "GraphQLRequestSchema",
    "GraphQLResponseSchema",
    "GraphQLVariablesMapSchema",
]


class GraphQLErrorLocationSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.GraphQLErrorLocation`."""

    line = marshmallow.fields.Integer(allow_none=True)
    column = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.GraphQLErrorLocation(**data)


class GraphQLErrorSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.GraphQLError`."""

    message = marshmallow.fields.String(allow_none=True)
    locations = marshmallow.fields.List(
        helpers.LazyNestedField(
            nested="commercetools._schemas._graph_ql.GraphQLErrorLocationSchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
    )
    path = marshmallow.fields.List(
        marshmallow.fields.Raw(allow_none=True), allow_none=True
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.GraphQLError(**data)


class GraphQLRequestSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.GraphQLRequest`."""

    query = marshmallow.fields.String(allow_none=True)
    operation_name = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="operationName"
    )
    variables = helpers.LazyNestedField(
        nested="commercetools._schemas._graph_ql.GraphQLVariablesMapSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.GraphQLRequest(**data)


class GraphQLResponseSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.GraphQLResponse`."""

    data = marshmallow.fields.Raw(allow_none=True, missing=None)
    errors = marshmallow.fields.List(
        helpers.LazyNestedField(
            nested="commercetools._schemas._graph_ql.GraphQLErrorSchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.GraphQLResponse(**data)


class GraphQLVariablesMapSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.GraphQLVariablesMap`."""

    _regex = helpers.RegexField(
        unknown=marshmallow.EXCLUDE,
        pattern=re.compile(""),
        type=marshmallow.fields.Raw(allow_none=True),
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        data = typing.cast(helpers.RegexField, self.fields["_regex"]).postprocess(data)
        return types.GraphQLVariablesMap(**data)

    @marshmallow.pre_load
    def pre_load(self, data, **kwargs):
        data = typing.cast(helpers.RegexField, self.fields["_regex"]).preprocess(data)
        return data

    @marshmallow.pre_dump
    def pre_dump(self, data, **kwargs):
        data = typing.cast(helpers.RegexField, self.fields["_regex"]).preprocess(data)
        return data

    @marshmallow.post_dump
    def post_dump(self, data, **kwargs):
        data = typing.cast(helpers.RegexField, self.fields["_regex"]).postprocess(data)
        return data
