# DO NOT EDIT! This file is automatically generated
import marshmallow
import marshmallow_enum

from commercetools import helpers, types
from commercetools._schemas._common import LocalizedStringField

__all__ = [
    "AccessDeniedErrorSchema",
    "AnonymousIdAlreadyInUseErrorSchema",
    "AttributeDefinitionAlreadyExistsErrorSchema",
    "AttributeDefinitionTypeConflictErrorSchema",
    "AttributeNameDoesNotExistErrorSchema",
    "ConcurrentModificationErrorSchema",
    "DiscountCodeNonApplicableErrorSchema",
    "DuplicateAttributeValueErrorSchema",
    "DuplicateAttributeValuesErrorSchema",
    "DuplicateEnumValuesErrorSchema",
    "DuplicateFieldErrorSchema",
    "DuplicateFieldWithConflictingResourceErrorSchema",
    "DuplicatePriceScopeErrorSchema",
    "DuplicateVariantValuesErrorSchema",
    "EditPreviewFailedErrorSchema",
    "EnumKeyAlreadyExistsErrorSchema",
    "EnumKeyDoesNotExistErrorSchema",
    "EnumValueIsUsedErrorSchema",
    "EnumValuesMustMatchErrorSchema",
    "ErrorByExtensionSchema",
    "ErrorObjectSchema",
    "ErrorResponseSchema",
    "ExtensionBadResponseErrorSchema",
    "ExtensionNoResponseErrorSchema",
    "ExtensionUpdateActionsFailedErrorSchema",
    "ExternalOAuthFailedErrorSchema",
    "FeatureRemovedErrorSchema",
    "GeneralErrorSchema",
    "InsufficientScopeErrorSchema",
    "InternalConstraintViolatedErrorSchema",
    "InvalidCredentialsErrorSchema",
    "InvalidCurrentPasswordErrorSchema",
    "InvalidFieldErrorSchema",
    "InvalidInputErrorSchema",
    "InvalidItemShippingDetailsErrorSchema",
    "InvalidJsonInputErrorSchema",
    "InvalidOperationErrorSchema",
    "InvalidSubjectErrorSchema",
    "InvalidTokenErrorSchema",
    "LanguageUsedInStoresErrorSchema",
    "MatchingPriceNotFoundErrorSchema",
    "MaxResourceLimitExceededErrorSchema",
    "MissingRoleOnChannelErrorSchema",
    "MissingTaxRateForCountryErrorSchema",
    "NoMatchingProductDiscountFoundErrorSchema",
    "NotEnabledErrorSchema",
    "ObjectNotFoundErrorSchema",
    "OutOfStockErrorSchema",
    "OverCapacityErrorSchema",
    "PendingOperationErrorSchema",
    "PriceChangedErrorSchema",
    "ProjectNotConfiguredForLanguagesErrorSchema",
    "QueryComplexityLimitExceededErrorSchema",
    "QueryTimedOutErrorSchema",
    "ReferenceExistsErrorSchema",
    "ReferencedResourceNotFoundErrorSchema",
    "RequiredFieldErrorSchema",
    "ResourceNotFoundErrorSchema",
    "ResourceSizeLimitExceededErrorSchema",
    "SearchExecutionFailureErrorSchema",
    "SearchFacetPathNotFoundErrorSchema",
    "SemanticErrorErrorSchema",
    "ShippingMethodDoesNotMatchCartErrorSchema",
    "SyntaxErrorErrorSchema",
    "VariantValuesSchema",
    "WeakPasswordErrorSchema",
]


class ErrorByExtensionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ErrorByExtension`."""

    id = marshmallow.fields.String(allow_none=True)
    key = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ErrorByExtension(**data)


class ErrorObjectSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ErrorObject`."""

    code = marshmallow.fields.String(allow_none=True)
    message = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ErrorObject(**data)


class ErrorResponseSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ErrorResponse`."""

    status_code = marshmallow.fields.Integer(allow_none=True, data_key="statusCode")
    message = marshmallow.fields.String(allow_none=True)
    error = marshmallow.fields.String(allow_none=True, missing=None)
    error_description = marshmallow.fields.String(allow_none=True, missing=None)
    errors = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("code", "code"),
            discriminator_schemas={
                "access_denied": "commercetools._schemas._error.AccessDeniedErrorSchema",
                "AnonymousIdAlreadyInUse": "commercetools._schemas._error.AnonymousIdAlreadyInUseErrorSchema",
                "AttributeDefinitionAlreadyExists": "commercetools._schemas._error.AttributeDefinitionAlreadyExistsErrorSchema",
                "AttributeDefinitionTypeConflict": "commercetools._schemas._error.AttributeDefinitionTypeConflictErrorSchema",
                "AttributeNameDoesNotExist": "commercetools._schemas._error.AttributeNameDoesNotExistErrorSchema",
                "ConcurrentModification": "commercetools._schemas._error.ConcurrentModificationErrorSchema",
                "DiscountCodeNonApplicable": "commercetools._schemas._error.DiscountCodeNonApplicableErrorSchema",
                "DuplicateAttributeValue": "commercetools._schemas._error.DuplicateAttributeValueErrorSchema",
                "DuplicateAttributeValues": "commercetools._schemas._error.DuplicateAttributeValuesErrorSchema",
                "DuplicateEnumValues": "commercetools._schemas._error.DuplicateEnumValuesErrorSchema",
                "DuplicateField": "commercetools._schemas._error.DuplicateFieldErrorSchema",
                "DuplicateFieldWithConflictingResource": "commercetools._schemas._error.DuplicateFieldWithConflictingResourceErrorSchema",
                "DuplicatePriceScope": "commercetools._schemas._error.DuplicatePriceScopeErrorSchema",
                "DuplicateVariantValues": "commercetools._schemas._error.DuplicateVariantValuesErrorSchema",
                "EditPreviewFailed": "commercetools._schemas._error.EditPreviewFailedErrorSchema",
                "EnumKeyAlreadyExists": "commercetools._schemas._error.EnumKeyAlreadyExistsErrorSchema",
                "EnumKeyDoesNotExist": "commercetools._schemas._error.EnumKeyDoesNotExistErrorSchema",
                "EnumValueIsUsed": "commercetools._schemas._error.EnumValueIsUsedErrorSchema",
                "EnumValuesMustMatch": "commercetools._schemas._error.EnumValuesMustMatchErrorSchema",
                "ExtensionBadResponse": "commercetools._schemas._error.ExtensionBadResponseErrorSchema",
                "ExtensionNoResponse": "commercetools._schemas._error.ExtensionNoResponseErrorSchema",
                "ExtensionUpdateActionsFailed": "commercetools._schemas._error.ExtensionUpdateActionsFailedErrorSchema",
                "ExternalOAuthFailed": "commercetools._schemas._error.ExternalOAuthFailedErrorSchema",
                "FeatureRemoved": "commercetools._schemas._error.FeatureRemovedErrorSchema",
                "General": "commercetools._schemas._error.GeneralErrorSchema",
                "insufficient_scope": "commercetools._schemas._error.InsufficientScopeErrorSchema",
                "InternalConstraintViolated": "commercetools._schemas._error.InternalConstraintViolatedErrorSchema",
                "InvalidCredentials": "commercetools._schemas._error.InvalidCredentialsErrorSchema",
                "InvalidCurrentPassword": "commercetools._schemas._error.InvalidCurrentPasswordErrorSchema",
                "InvalidField": "commercetools._schemas._error.InvalidFieldErrorSchema",
                "InvalidInput": "commercetools._schemas._error.InvalidInputErrorSchema",
                "InvalidItemShippingDetails": "commercetools._schemas._error.InvalidItemShippingDetailsErrorSchema",
                "InvalidJsonInput": "commercetools._schemas._error.InvalidJsonInputErrorSchema",
                "InvalidOperation": "commercetools._schemas._error.InvalidOperationErrorSchema",
                "InvalidSubject": "commercetools._schemas._error.InvalidSubjectErrorSchema",
                "invalid_token": "commercetools._schemas._error.InvalidTokenErrorSchema",
                "LanguageUsedInStores": "commercetools._schemas._error.LanguageUsedInStoresErrorSchema",
                "MatchingPriceNotFound": "commercetools._schemas._error.MatchingPriceNotFoundErrorSchema",
                "MaxResourceLimitExceeded": "commercetools._schemas._error.MaxResourceLimitExceededErrorSchema",
                "MissingRoleOnChannel": "commercetools._schemas._error.MissingRoleOnChannelErrorSchema",
                "MissingTaxRateForCountry": "commercetools._schemas._error.MissingTaxRateForCountryErrorSchema",
                "NoMatchingProductDiscountFound": "commercetools._schemas._error.NoMatchingProductDiscountFoundErrorSchema",
                "NotEnabled": "commercetools._schemas._error.NotEnabledErrorSchema",
                "ObjectNotFound": "commercetools._schemas._error.ObjectNotFoundErrorSchema",
                "OutOfStock": "commercetools._schemas._error.OutOfStockErrorSchema",
                "OverCapacity": "commercetools._schemas._error.OverCapacityErrorSchema",
                "PendingOperation": "commercetools._schemas._error.PendingOperationErrorSchema",
                "PriceChanged": "commercetools._schemas._error.PriceChangedErrorSchema",
                "ProjectNotConfiguredForLanguages": "commercetools._schemas._error.ProjectNotConfiguredForLanguagesErrorSchema",
                "QueryComplexityLimitExceeded": "commercetools._schemas._error.QueryComplexityLimitExceededErrorSchema",
                "QueryTimedOut": "commercetools._schemas._error.QueryTimedOutErrorSchema",
                "ReferenceExists": "commercetools._schemas._error.ReferenceExistsErrorSchema",
                "ReferencedResourceNotFound": "commercetools._schemas._error.ReferencedResourceNotFoundErrorSchema",
                "RequiredField": "commercetools._schemas._error.RequiredFieldErrorSchema",
                "ResourceNotFound": "commercetools._schemas._error.ResourceNotFoundErrorSchema",
                "ResourceSizeLimitExceeded": "commercetools._schemas._error.ResourceSizeLimitExceededErrorSchema",
                "SearchExecutionFailure": "commercetools._schemas._error.SearchExecutionFailureErrorSchema",
                "SearchFacetPathNotFound": "commercetools._schemas._error.SearchFacetPathNotFoundErrorSchema",
                "SemanticError": "commercetools._schemas._error.SemanticErrorErrorSchema",
                "ShippingMethodDoesNotMatchCart": "commercetools._schemas._error.ShippingMethodDoesNotMatchCartErrorSchema",
                "SyntaxError": "commercetools._schemas._error.SyntaxErrorErrorSchema",
                "WeakPassword": "commercetools._schemas._error.WeakPasswordErrorSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ErrorResponse(**data)


class VariantValuesSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.VariantValues`."""

    sku = marshmallow.fields.String(allow_none=True, missing=None)
    prices = helpers.LazyNestedField(
        nested="commercetools._schemas._common.PriceDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    attributes = helpers.LazyNestedField(
        nested="commercetools._schemas._product.AttributeSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.VariantValues(**data)


class AccessDeniedErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.AccessDeniedError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.AccessDeniedError(**data)


class AnonymousIdAlreadyInUseErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.AnonymousIdAlreadyInUseError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.AnonymousIdAlreadyInUseError(**data)


class AttributeDefinitionAlreadyExistsErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.AttributeDefinitionAlreadyExistsError`."""

    conflicting_product_type_id = marshmallow.fields.String(
        allow_none=True, data_key="conflictingProductTypeId"
    )
    conflicting_product_type_name = marshmallow.fields.String(
        allow_none=True, data_key="conflictingProductTypeName"
    )
    conflicting_attribute_name = marshmallow.fields.String(
        allow_none=True, data_key="conflictingAttributeName"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.AttributeDefinitionAlreadyExistsError(**data)


class AttributeDefinitionTypeConflictErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.AttributeDefinitionTypeConflictError`."""

    conflicting_product_type_id = marshmallow.fields.String(
        allow_none=True, data_key="conflictingProductTypeId"
    )
    conflicting_product_type_name = marshmallow.fields.String(
        allow_none=True, data_key="conflictingProductTypeName"
    )
    conflicting_attribute_name = marshmallow.fields.String(
        allow_none=True, data_key="conflictingAttributeName"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.AttributeDefinitionTypeConflictError(**data)


class AttributeNameDoesNotExistErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.AttributeNameDoesNotExistError`."""

    invalid_attribute_name = marshmallow.fields.String(
        allow_none=True, data_key="invalidAttributeName"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.AttributeNameDoesNotExistError(**data)


class ConcurrentModificationErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ConcurrentModificationError`."""

    current_version = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="currentVersion"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ConcurrentModificationError(**data)


class DiscountCodeNonApplicableErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.DiscountCodeNonApplicableError`."""

    discount_code = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="discountCode"
    )
    reason = marshmallow.fields.String(allow_none=True, missing=None)
    dicount_code_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="dicountCodeId"
    )
    valid_from = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validFrom"
    )
    valid_until = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validUntil"
    )
    validity_check_time = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validityCheckTime"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.DiscountCodeNonApplicableError(**data)


class DuplicateAttributeValueErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.DuplicateAttributeValueError`."""

    attribute = helpers.LazyNestedField(
        nested="commercetools._schemas._product.AttributeSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.DuplicateAttributeValueError(**data)


class DuplicateAttributeValuesErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.DuplicateAttributeValuesError`."""

    attributes = helpers.LazyNestedField(
        nested="commercetools._schemas._product.AttributeSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.DuplicateAttributeValuesError(**data)


class DuplicateEnumValuesErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.DuplicateEnumValuesError`."""

    duplicates = marshmallow.fields.List(marshmallow.fields.String(allow_none=True))

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.DuplicateEnumValuesError(**data)


class DuplicateFieldErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.DuplicateFieldError`."""

    field = marshmallow.fields.String(allow_none=True, missing=None)
    duplicate_value = marshmallow.fields.Raw(
        allow_none=True, missing=None, data_key="duplicateValue"
    )
    conflicting_resource = helpers.Discriminator(
        discriminator_field=("typeId", "type_id"),
        discriminator_schemas={
            "cart-discount": "commercetools._schemas._cart_discount.CartDiscountReferenceSchema",
            "cart": "commercetools._schemas._cart.CartReferenceSchema",
            "category": "commercetools._schemas._category.CategoryReferenceSchema",
            "channel": "commercetools._schemas._channel.ChannelReferenceSchema",
            "key-value-document": "commercetools._schemas._custom_object.CustomObjectReferenceSchema",
            "customer-group": "commercetools._schemas._customer_group.CustomerGroupReferenceSchema",
            "customer": "commercetools._schemas._customer.CustomerReferenceSchema",
            "discount-code": "commercetools._schemas._discount_code.DiscountCodeReferenceSchema",
            "inventory-entry": "commercetools._schemas._inventory.InventoryEntryReferenceSchema",
            "order-edit": "commercetools._schemas._order_edit.OrderEditReferenceSchema",
            "order": "commercetools._schemas._order.OrderReferenceSchema",
            "payment": "commercetools._schemas._payment.PaymentReferenceSchema",
            "product-discount": "commercetools._schemas._product_discount.ProductDiscountReferenceSchema",
            "product-type": "commercetools._schemas._product_type.ProductTypeReferenceSchema",
            "product": "commercetools._schemas._product.ProductReferenceSchema",
            "review": "commercetools._schemas._review.ReviewReferenceSchema",
            "shipping-method": "commercetools._schemas._shipping_method.ShippingMethodReferenceSchema",
            "shopping-list": "commercetools._schemas._shopping_list.ShoppingListReferenceSchema",
            "state": "commercetools._schemas._state.StateReferenceSchema",
            "store": "commercetools._schemas._store.StoreReferenceSchema",
            "tax-category": "commercetools._schemas._tax_category.TaxCategoryReferenceSchema",
            "type": "commercetools._schemas._type.TypeReferenceSchema",
            "zone": "commercetools._schemas._zone.ZoneReferenceSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="conflictingResource",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.DuplicateFieldError(**data)


class DuplicateFieldWithConflictingResourceErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.DuplicateFieldWithConflictingResourceError`."""

    field = marshmallow.fields.String(allow_none=True)
    duplicate_value = marshmallow.fields.Raw(allow_none=True, data_key="duplicateValue")
    conflicting_resource = helpers.Discriminator(
        discriminator_field=("typeId", "type_id"),
        discriminator_schemas={
            "cart-discount": "commercetools._schemas._cart_discount.CartDiscountReferenceSchema",
            "cart": "commercetools._schemas._cart.CartReferenceSchema",
            "category": "commercetools._schemas._category.CategoryReferenceSchema",
            "channel": "commercetools._schemas._channel.ChannelReferenceSchema",
            "key-value-document": "commercetools._schemas._custom_object.CustomObjectReferenceSchema",
            "customer-group": "commercetools._schemas._customer_group.CustomerGroupReferenceSchema",
            "customer": "commercetools._schemas._customer.CustomerReferenceSchema",
            "discount-code": "commercetools._schemas._discount_code.DiscountCodeReferenceSchema",
            "inventory-entry": "commercetools._schemas._inventory.InventoryEntryReferenceSchema",
            "order-edit": "commercetools._schemas._order_edit.OrderEditReferenceSchema",
            "order": "commercetools._schemas._order.OrderReferenceSchema",
            "payment": "commercetools._schemas._payment.PaymentReferenceSchema",
            "product-discount": "commercetools._schemas._product_discount.ProductDiscountReferenceSchema",
            "product-type": "commercetools._schemas._product_type.ProductTypeReferenceSchema",
            "product": "commercetools._schemas._product.ProductReferenceSchema",
            "review": "commercetools._schemas._review.ReviewReferenceSchema",
            "shipping-method": "commercetools._schemas._shipping_method.ShippingMethodReferenceSchema",
            "shopping-list": "commercetools._schemas._shopping_list.ShoppingListReferenceSchema",
            "state": "commercetools._schemas._state.StateReferenceSchema",
            "store": "commercetools._schemas._store.StoreReferenceSchema",
            "tax-category": "commercetools._schemas._tax_category.TaxCategoryReferenceSchema",
            "type": "commercetools._schemas._type.TypeReferenceSchema",
            "zone": "commercetools._schemas._zone.ZoneReferenceSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="conflictingResource",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.DuplicateFieldWithConflictingResourceError(**data)


class DuplicatePriceScopeErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.DuplicatePriceScopeError`."""

    conflicting_prices = helpers.LazyNestedField(
        nested="commercetools._schemas._common.PriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="conflictingPrices",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.DuplicatePriceScopeError(**data)


class DuplicateVariantValuesErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.DuplicateVariantValuesError`."""

    variant_values = helpers.LazyNestedField(
        nested="commercetools._schemas._error.VariantValuesSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="variantValues",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.DuplicateVariantValuesError(**data)


class EditPreviewFailedErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.EditPreviewFailedError`."""

    result = helpers.LazyNestedField(
        nested="commercetools._schemas._order_edit.OrderEditPreviewFailureSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.EditPreviewFailedError(**data)


class EnumKeyAlreadyExistsErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.EnumKeyAlreadyExistsError`."""

    conflicting_enum_key = marshmallow.fields.String(
        allow_none=True, data_key="conflictingEnumKey"
    )
    conflicting_attribute_name = marshmallow.fields.String(
        allow_none=True, data_key="conflictingAttributeName"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.EnumKeyAlreadyExistsError(**data)


class EnumKeyDoesNotExistErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.EnumKeyDoesNotExistError`."""

    conflicting_enum_key = marshmallow.fields.String(
        allow_none=True, data_key="conflictingEnumKey"
    )
    conflicting_attribute_name = marshmallow.fields.String(
        allow_none=True, data_key="conflictingAttributeName"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.EnumKeyDoesNotExistError(**data)


class EnumValueIsUsedErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.EnumValueIsUsedError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.EnumValueIsUsedError(**data)


class EnumValuesMustMatchErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.EnumValuesMustMatchError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.EnumValuesMustMatchError(**data)


class ExtensionBadResponseErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ExtensionBadResponseError`."""

    localized_message = LocalizedStringField(
        allow_none=True, missing=None, data_key="localizedMessage"
    )
    extension_extra_info = marshmallow.fields.Dict(
        allow_none=True, missing=None, data_key="extensionExtraInfo"
    )
    error_by_extension = helpers.LazyNestedField(
        nested="commercetools._schemas._error.ErrorByExtensionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="errorByExtension",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ExtensionBadResponseError(**data)


class ExtensionNoResponseErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ExtensionNoResponseError`."""

    localized_message = LocalizedStringField(
        allow_none=True, missing=None, data_key="localizedMessage"
    )
    extension_extra_info = marshmallow.fields.Dict(
        allow_none=True, missing=None, data_key="extensionExtraInfo"
    )
    error_by_extension = helpers.LazyNestedField(
        nested="commercetools._schemas._error.ErrorByExtensionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="errorByExtension",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ExtensionNoResponseError(**data)


class ExtensionUpdateActionsFailedErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ExtensionUpdateActionsFailedError`."""

    localized_message = LocalizedStringField(
        allow_none=True, missing=None, data_key="localizedMessage"
    )
    extension_extra_info = marshmallow.fields.Dict(
        allow_none=True, missing=None, data_key="extensionExtraInfo"
    )
    error_by_extension = helpers.LazyNestedField(
        nested="commercetools._schemas._error.ErrorByExtensionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="errorByExtension",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ExtensionUpdateActionsFailedError(**data)


class ExternalOAuthFailedErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ExternalOAuthFailedError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ExternalOAuthFailedError(**data)


class FeatureRemovedErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.FeatureRemovedError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.FeatureRemovedError(**data)


class GeneralErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.GeneralError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.GeneralError(**data)


class InsufficientScopeErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InsufficientScopeError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InsufficientScopeError(**data)


class InternalConstraintViolatedErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InternalConstraintViolatedError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InternalConstraintViolatedError(**data)


class InvalidCredentialsErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InvalidCredentialsError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InvalidCredentialsError(**data)


class InvalidCurrentPasswordErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InvalidCurrentPasswordError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InvalidCurrentPasswordError(**data)


class InvalidFieldErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InvalidFieldError`."""

    field = marshmallow.fields.String(allow_none=True)
    invalid_value = marshmallow.fields.Raw(allow_none=True, data_key="invalidValue")
    allowed_values = marshmallow.fields.List(
        marshmallow.fields.Raw(allow_none=True),
        allow_none=True,
        missing=None,
        data_key="allowedValues",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InvalidFieldError(**data)


class InvalidInputErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InvalidInputError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InvalidInputError(**data)


class InvalidItemShippingDetailsErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InvalidItemShippingDetailsError`."""

    subject = marshmallow.fields.String(allow_none=True)
    item_id = marshmallow.fields.String(allow_none=True, data_key="itemId")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InvalidItemShippingDetailsError(**data)


class InvalidJsonInputErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InvalidJsonInputError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InvalidJsonInputError(**data)


class InvalidOperationErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InvalidOperationError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InvalidOperationError(**data)


class InvalidSubjectErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InvalidSubjectError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InvalidSubjectError(**data)


class InvalidTokenErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.InvalidTokenError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.InvalidTokenError(**data)


class LanguageUsedInStoresErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.LanguageUsedInStoresError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.LanguageUsedInStoresError(**data)


class MatchingPriceNotFoundErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.MatchingPriceNotFoundError`."""

    product_id = marshmallow.fields.String(allow_none=True, data_key="productId")
    variant_id = marshmallow.fields.Integer(allow_none=True, data_key="variantId")
    currency = marshmallow.fields.String(allow_none=True, missing=None)
    country = marshmallow.fields.String(allow_none=True, missing=None)
    customer_group = helpers.LazyNestedField(
        nested="commercetools._schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )
    channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.MatchingPriceNotFoundError(**data)


class MaxResourceLimitExceededErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.MaxResourceLimitExceededError`."""

    exceeded_resource = marshmallow_enum.EnumField(
        types.ReferenceTypeId, by_value=True, data_key="exceededResource"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.MaxResourceLimitExceededError(**data)


class MissingRoleOnChannelErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.MissingRoleOnChannelError`."""

    channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    missing_role = marshmallow_enum.EnumField(
        types.ChannelRoleEnum, by_value=True, data_key="missingRole"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.MissingRoleOnChannelError(**data)


class MissingTaxRateForCountryErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.MissingTaxRateForCountryError`."""

    tax_category_id = marshmallow.fields.String(
        allow_none=True, data_key="taxCategoryId"
    )
    country = marshmallow.fields.String(allow_none=True, missing=None)
    state = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.MissingTaxRateForCountryError(**data)


class NoMatchingProductDiscountFoundErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.NoMatchingProductDiscountFoundError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.NoMatchingProductDiscountFoundError(**data)


class NotEnabledErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.NotEnabledError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.NotEnabledError(**data)


class ObjectNotFoundErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ObjectNotFoundError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ObjectNotFoundError(**data)


class OutOfStockErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.OutOfStockError`."""

    line_items = marshmallow.fields.List(
        marshmallow.fields.String(allow_none=True), data_key="lineItems"
    )
    skus = marshmallow.fields.List(marshmallow.fields.String(allow_none=True))

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.OutOfStockError(**data)


class OverCapacityErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.OverCapacityError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.OverCapacityError(**data)


class PendingOperationErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.PendingOperationError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.PendingOperationError(**data)


class PriceChangedErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.PriceChangedError`."""

    line_items = marshmallow.fields.List(
        marshmallow.fields.String(allow_none=True), data_key="lineItems"
    )
    shipping = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.PriceChangedError(**data)


class ProjectNotConfiguredForLanguagesErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ProjectNotConfiguredForLanguagesError`."""

    languages = marshmallow.fields.List(
        marshmallow.fields.String(allow_none=True), missing=None
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ProjectNotConfiguredForLanguagesError(**data)


class QueryComplexityLimitExceededErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.QueryComplexityLimitExceededError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.QueryComplexityLimitExceededError(**data)


class QueryTimedOutErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.QueryTimedOutError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.QueryTimedOutError(**data)


class ReferenceExistsErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ReferenceExistsError`."""

    referenced_by = marshmallow_enum.EnumField(
        types.ReferenceTypeId, by_value=True, missing=None, data_key="referencedBy"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ReferenceExistsError(**data)


class ReferencedResourceNotFoundErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ReferencedResourceNotFoundError`."""

    type_id = marshmallow_enum.EnumField(
        types.ReferenceTypeId, by_value=True, data_key="typeId"
    )
    id = marshmallow.fields.String(allow_none=True, missing=None)
    key = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ReferencedResourceNotFoundError(**data)


class RequiredFieldErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.RequiredFieldError`."""

    field = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.RequiredFieldError(**data)


class ResourceNotFoundErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ResourceNotFoundError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ResourceNotFoundError(**data)


class ResourceSizeLimitExceededErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ResourceSizeLimitExceededError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ResourceSizeLimitExceededError(**data)


class SearchExecutionFailureErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.SearchExecutionFailureError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.SearchExecutionFailureError(**data)


class SearchFacetPathNotFoundErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.SearchFacetPathNotFoundError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.SearchFacetPathNotFoundError(**data)


class SemanticErrorErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.SemanticErrorError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.SemanticErrorError(**data)


class ShippingMethodDoesNotMatchCartErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.ShippingMethodDoesNotMatchCartError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.ShippingMethodDoesNotMatchCartError(**data)


class SyntaxErrorErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.SyntaxErrorError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.SyntaxErrorError(**data)


class WeakPasswordErrorSchema(ErrorObjectSchema):
    """Marshmallow schema for :class:`commercetools.types.WeakPasswordError`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["code"]
        return types.WeakPasswordError(**data)
