# dash-admin-components

Creating a fully resposive, beautiful dashboard with [Plotly Dash][dash-homepage] has never been easier! 

*dash-admin-components* relies on [shinydashboard implementation][admin-homepage] of AdminLTE3 template. 

It comes with preloaded Bootstrap 4 stylesheet that is fully compatibile with [dash-bootstrap-components][dash-bootstrap-homepage]. 

## Installation

### PyPI

You can install *dash-admin-components* with `pip`:

```
pip install dash-admin-components
```

## Motivation
*dash-admin-components* was created by [Quantee][quantee-homepage], a company providing statistical and data science solutions in the insurance sector.
For our clients, it is extremely important to visualize results from statistical models and we have been looking for 
a powerful dashboard framework similar to shinydashboard. We have created a package on the top of [Plotly Dash][dash-homepage]
to simplify the implementation of dashboards and now, we share the results with you as an open-source solution!

## Example

You can analyze the example [here][dac-example] and code behind the example [here][dac-example-repo].

## Documentation

The documentation is available [here][dac-docs].

## Components

*dash-admin-components* includes several high-level components
and can be composed with other components from
[dash-core-components][dash-core-homepage] and
[dash-bootstrap-components][dash-bootstrap-homepage].

### Dynamic Page with Sidebar, Navbar, Controlbar, Body and Footer.

![page](./readme-images/page.gif)

---

### Collapsible and Closeable Boxes

![box](./readme-images/box.gif)

---

### InfoBoxes

![infobox](./readme-images/infobox.png)

---

### ValueBoxes

![valuebox](./readme-images/valuebox.png)

---

### UserBoxes

![userbox](./readme-images/userbox.png)

---


### TabBoxes

![tabbox](./readme-images/tabbox.gif)

For a full list of components, head over to [example code][dac-example-repo].

## Contributing
This project was generated by the [dash-component-boilerplate](https://github.com/plotly/dash-component-boilerplate) it contains the minimal set of code required to create your own custom Dash component.

[dash-homepage]: https://dash.plot.ly/
[quantee-homepage]: https://quantee.ai
[admin-homepage]: https://github.com/RinteRface/bs4Dash
[dash-core-homepage]: https://dash.plot.ly/dash-core-components
[dash-bootstrap-homepage]: https://dash-bootstrap-components.opensource.faculty.ai
[dac-example-repo]: /example
[dac-example]: http://dash-admin-components.opensource.quantee.ai/
[dac-docs]: https://docs-dash-admin-components.herokuapp.com/