# 🔐 burp-frame – Unified Android Penetration Testing Framework

[![Platform](https://img.shields.io/badge/Platform-Windows%20%7C%20macOS%20%7C%20Linux-blue)](#)
[![Python](https://img.shields.io/badge/Python-3.7%2B-blue)](https://www.python.org/)
[![License](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)
[![Author](https://img.shields.io/badge/Author-Gashaw%20Kidanu-orange)](#)

**burp-frame** is a **professional-grade, cross-platform automation tool** meticulously designed to streamline mobile security assessments on ​**rooted Android devices and emulators​**. It functions as a **"one-shot" tester's toolkit** 🎯, unifying essential tasks for **HTTPS traffic interception** and ​**dynamic analysis**​, encompassing comprehensive certificate management, flexible global and per-application proxy configurations, robust Frida server deployment, and advanced, **​**highly effective SSL pinning and security bypass techniques**​.

Built for  **security professionals**, **pen testers**, and **mobile developers**,`burp-frame` automates complex, multi-step workflows with a **user-friendly yet powerful command-line interface (CLI)**, supported by robust logging and cross-platform compatibility.

![Burp-Frame Workflow Diagram](docs/images/burp-frame-workflow.gif)

---


## ✨ Key Features

-   **Unified CLI**: A singular, intuitive command-line interface for orchestrating all Android pentesting operations, simplifying complex workflows.
    
-   **Certificate Installation (`install` module)**:
    
    -   **One-command certificate installation** of Burp Suite CA certificates directly onto the Android device.
        
    -   **Automates conversion** of Burp CA certificates from DER format to the Android-compatible `.0` format, complete with subject hash calculation.
        
    -   **Intelligent deployment**: Pushes converted certificates to the traditional `/system/etc/security/cacerts/` path, or leverages the systemless capabilities of Magisk.
        
    -   **Magisk Support**: Specifically designed to install certificates seamlessly into the systemless Magisk path, maintaining system integrity.
        
    -   **Dry-run mode**: Allows simulation of the entire certificate installation process without making any actual modifications to the device, ideal for testing and verification.
        
-   **Proxy Management (`proxy` module)**:
    
    -   **Flexible global HTTP proxy settings**: Easily set and clear system-wide HTTP proxy configurations on the Android device via ADB for comprehensive traffic interception.
        
    -   **(Conceptual) Per-application proxy settings**: Provides a framework for managing proxy settings for specific applications, though practical effectiveness may vary across Android versions and app implementations.
        
    -   **Connectivity testing**: Includes functionality to test the configured global proxy's connectivity, ensuring your interception setup is active and correctly routing traffic.
        
    -   **Network intelligence**: Discover and display active network interfaces and their associated IP addresses on the connected device.
        
-   **Frida Integration (`frida` module)**:
    
    -   **Automated Frida server deployment**: Deploys the appropriate `frida-server` binary to the connected Android device based on its architecture and intelligently attempts to start it in the background.
        
    -   **Process management**: List all running processes on the device, and kill processes efficiently by either their PID or package name.
        
    -   **Script injection**: Launch target applications with a custom Frida JavaScript script immediately injected, enabling early instrumentation.
        
    -   **Advanced Certificate Re-Pinning Bypass**: A specialized Frida capability to inject a custom CA certificate (like your Burp CA) directly into an application's trust store at runtime, effectively bypassing SSL pinning even when traditional certificate installation methods fail.
        
-   **SSL Pinning & Security Bypasses (`bypass-ssl` & `universal-bypass` modules)**:
    
    -   **Generic SSL Bypass**: Facilitates the management (listing, downloading) and application of general-purpose Frida scripts designed to bypass various forms of SSL pinning implemented in Android applications.
        
    - **Comprehensive Universal Bypass**: It provides **one-shot bypassing of common Android security mechanisms** directly from your terminal. Deploys a **powerful, all-in-one Frida  script (enhanced with the latest techniques)** to comprehensively bypass multiple crucial security checks, including:
      - **SSL pinning:** Covering multiple methods including OkHttp, Conscrypt, and HostnameVerifier.
      - **Root detection:** Bypassing checks via filesystem anomalies, Runtime exec calls, SystemProperties, and common libraries like RootBeer.
      - **Debugger checks:** Circumventing detection mechanisms for attached debuggers.
      - **Emulator checks:** Masking indicators that reveal an application is running in an emulated environment.

-   **Device Management (`device` module)**:
    
    -   **Essential device control**: Remotely reboot the connected Android device.
        
    -   **File system manipulation**: Remount the `/system` partition as either read-write (`remount-rw`) or read-only (`remount-ro`), crucial for system-level modifications (requires root).
        
    -   **Device discovery**: List all currently connected ADB devices and their properties.
        
    -   **Application lifecycle management**: Effortlessly install and uninstall APKs onto the device.
        
    -   **Flexible connectivity**: Connect to and disconnect from ADB devices over TCP/IP (e.g., for Wi-Fi debugging).
        
-   **Automation & Usability**:
    
    -   **Automated cleanup**: Ensures all temporary certificate files and directories created by the framework are removed upon application exit.
        
    -   **Interactive and intelligent CLI**: Provides clear prompts, auto-validation of inputs, and helpful, context-aware messages to guide the user.
        
    -   **Detailed logging**: Generates timestamped, categorized logs to a dedicated `logs/` directory, essential for auditing, troubleshooting, and documenting pentesting activities.
        
    -   **Cross-Platform Compatibility**: Fully supports Windows, macOS, and Linux operating systems.
---

## 📦 Requirements

- **Python 3.7+** The framework is built on modern Python features.
- **[ADB (Android Debug Bridge)](https://developer.android.com/studio/releases/platform-tools)** The primary tool for device communication. Ensure it's installed and accessible in your system's PATH.
- [OpenSSL](https://www.openssl.org/) available in `PATH`. It is required for certificate conversions. Ensure it's installed and available in your PATH.
- **Frida CLI (frida-tools):** Install via `pip install frida-tools` (note: `pip install frida` also covers the Python library requirement).
- **Frida Server:** The on-device component of Frida. `burp-frame frida deploy` automates its download and deployment, requiring a working internet connection for the initial setup.
- **Rooted Android device or emulator** Essential for modifying system partitions (e.g., for certificate installation) and for many advanced Frida operations.  (e.g., [Genymotion](https://www.genymotion.com/), or Magisk-patched Android Virtual Devices (AVDs))
- **Burp Suite CA certificate** Exported as a `.der` format file from Burp Suite. This is necessary for the `install` command and the `frida cert-repin` functionality.
---

## 🚀 Installation

### Option 1: From PyPI (recommended)

For the easiest installation, use pip:

```bash
pip install burp-frame

```

### Option 2: From source

For development or to access the latest features, clone the repository and install from source:

```bash
git clone https://github.com/Gashaw512/burp-frame
cd burp-frame/ # Navigate to the project root directory
pip install . # Installs the 'burp-frame' package from the current directory

```

> ✅ **Tip**: Always use a Python [virtual environment](https://docs.python.org/3/library/venv.html "null") (`python -m venv .venv` then `source .venv/bin/activate`) to isolate project dependencies and avoid conflicts with system-wide Python packages.

## ⚙️ Quick Start

Follow these steps to get started quickly with `burp-frame`:

### 1. Configure External Tool Paths

Before `burp-frame` can operate, you must tell it where to find your `adb` and `openssl` executables. You can also configure paths for Frida binaries if they are not in your system's `PATH`.

```
# Example for Windows:
burp-frame config --adb "C:\path\to\your\platform-tools\adb.exe" --openssl "C:\path\to\OpenSSL\bin\openssl.exe"

# Example for Linux/macOS:
burp-frame config --adb "/usr/local/bin/adb" --openssl "/usr/bin/openssl"

```

You can verify your current configuration settings at any time:

```bash
burp-frame config

```

### 2. Connect Your Android Device

Ensure your Android device (physical or emulator) is properly connected and recognized by ADB.

-   Enable **USB debugging** on your Android phone or emulator (typically found in Developer Options).
    
-   Verify your device is detected by ADB:
    
```bash
    adb devices
    
```
    

### 3. Deploy Frida Server

For all Frida-related commands to function, the `frida-server` must be running on your Android device. `burp-frame` automates this process:

```bash
burp-frame frida deploy

```
## 📝 Command-Specific Usage

This section provides detailed usage examples for each module within the `burp-frame` framework.

### **`install` Module: Certificate Installation**

This module streamlines the process of installing your Burp Suite CA certificate onto Android devices, crucial for intercepting HTTPS traffic.

-   **Before you begin**: In **Burp Suite**: Navigate to `Proxy → Proxy Settings/Options → Import/Export CA Certificate`. Choose **DER format** and save the exported file (e.g., `burp.der`) to your local machine.
    
-   **Standard interactive installation (prompt-based)**: This will guide you through selecting your `.der` certificate file and automatically manage the conversion and deployment process.
    
    ```
    burp-frame install
    
    ```
    
    > You’ll be prompted to select the certificate file path. The device will automatically reboot once the installation is successful.
    
-   **Install for Magisk systemless root**: If your device uses Magisk for systemless root, this option ensures the certificate is installed in the appropriate module path, preserving system integrity.
    
    ```
    burp-frame install --magisk
    
    ```
    
-   **Simulate installation without making changes (Dry-run mode)**: Useful for testing the installation workflow and verifying prerequisites without modifying the device.
    
    ```
    burp-frame install --dry-run
    
    ```
    

### **`proxy` Module: Device Proxy Configuration**

This module facilitates setting and managing HTTP proxy settings on the Android device, both globally and, conceptually, on a per-application basis.

-   **Set global HTTP proxy**: Configures the entire Android device to route all HTTP/S traffic through your specified proxy (e.g., Burp Suite).
    
    ```
    burp-frame proxy set <YOUR_HOST_IP>:8080
    # Example: burp-frame proxy set 192.168.1.100:8080
    
    ```
    
-   **Clear global HTTP proxy**: Removes any existing global HTTP proxy settings, reverting the device to direct internet access.
    
    ```
    burp-frame proxy clear
    
    ```
    
-   **Get current global HTTP proxy settings**: Retrieves and displays the currently configured global HTTP proxy settings on the Android device.
    
    ```
    burp-frame proxy get
    
    ```
    
-   **Test global HTTP proxy connection**: Initiates an HTTP request from the device through the currently configured global proxy to a specified URL, reporting on connectivity. Useful for verifying your proxy setup.
    
    ```
    burp-frame proxy test --url http://google.com
    
    ```
    
-   **Display device IP addresses**: Lists the active network interfaces and their associated IPv4 and IPv6 addresses on the connected Android device, aiding in network configuration and troubleshooting.
    
    ```
    burp-frame proxy ips
    
    ```
    
-   **(Conceptual) Set per-app proxy**: **Note:** This method attempts to set a proxy for a specific application but is not universally reliable across all apps or Android versions. For robust per-app proxying or certificate pinning bypass, leveraging the `frida` module (e.g., `frida cert-repin`) is often more effective.
    
    ```
    burp-frame proxy app set com.example.app <YOUR_HOST_IP>:8080
    
    ```
    
-   **(Conceptual) Clear per-app proxy**: Attempts to remove any proxy settings for a specific application previously set by this tool.
    
    ```
    burp-frame proxy app clear com.example.app
    
    ```
    
-   **(Conceptual) Get per-app proxy**: Attempts to retrieve proxy settings for a specific application.
    
    ```
    burp-frame proxy app get com.example.app
    
    ```
    
-   **(Conceptual) List apps with proxy settings**: Lists applications that _might_ have specific proxy settings applied by this tool.
    
    ```
    burp-frame proxy app list
    
    ```
    

### **`frida` Module: Dynamic Instrumentation**

This module provides extensive functionalities for deploying, managing, and interacting with Frida on your Android device, enabling powerful dynamic analysis and runtime manipulation.

-   **Deploy Frida server to the device**: This is the first step for any Frida operation. It automatically identifies the correct `frida-server` binary for your device's architecture, pushes it, sets permissions, and starts it.
    
    ```
    burp-frame frida deploy
    
    ```
    
-   **List all running processes on the device**: Provides an overview of active processes, useful for identifying target applications.
    
    ```
    burp-frame frida ps
    
    ```
    
-   **Kill a process by PID or package name**: Terminates a specified running process on the device.
    
    ```
    burp-frame frida kill <PID_OR_PACKAGE_NAME>
    # Example: burp-frame frida kill com.example.app
    # Example: burp-frame frida kill 12345
    
    ```
    
-   **Launch an app and inject a custom Frida script**: Starts a specified application and immediately injects your custom Frida JavaScript (`.js`) script into its process.
    
    ```
    burp-frame frida launch <PACKAGE_NAME> --script /path/to/your/custom_frida_script.js
    
    ```
    
-   **Apply certificate re-pinning bypass (using a custom CA)**: This is an advanced technique for bypassing SSL pinning. It first pushes a local certificate file (e.g., your Burp CA certificate in `.0` format) to the device. Then, it uses a specialized Frida script to hook the application's SSLContext and dynamically inject your custom CA into its trusted certificate store at runtime.
    
    ```
    burp-frame frida cert-repin <PACKAGE_NAME> --cert /path/to/your/burp_certificate_file.0
    # To attach to an already running app instead of launching:
    # burp-frame frida cert-repin <PACKAGE_NAME> --cert /path/to/your/burp_certificate_file.0 --attach
    
    ```
    
    > 💡 **Note**: The `.0` certificate file is an Android-specific format derived from your Burp CA. It can be generated automatically by the `burp-frame install` command, or manually converted from DER using `openssl`.
    

### **`bypass-ssl` Module: Generic SSL Pinning Bypasses**

This module focuses on managing and applying general-purpose Frida scripts specifically designed for SSL pinning bypasses, complementing the certificate re-pinning method.

-   **List available local SSL bypass scripts**: Shows a list of `.js` scripts available in your local `data/frida_scripts/bypass/` directory that can be applied for SSL pinning bypass.
    
    ```
    burp-frame bypass-ssl list
    
    ```
    
-   **Download a generic SSL bypass script**: Fetches a commonly used, generic SSL pinning bypass script from a public source and saves it to your local scripts directory.
    
    ```
    burp-frame bypass-ssl download
    
    ```
    
-   **Apply a local SSL bypass script to a target application**: Injects a chosen local `.js` script (from your scripts directory) into a target application to attempt SSL pinning bypass.
    
    ```
    burp-frame bypass-ssl apply <PACKAGE_NAME> --script universal_bypass.js
    # To attach to a running app instead of launching:
    # burp-frame bypass-ssl apply <PACKAGE_NAME> --script universal_bypass.js --target-running
    
    ```
    

### **`universal-bypass` Module: Comprehensive Security Bypasses**

This module provides an incredibly powerful, all-in-one Frida script that combines multiple advanced techniques to bypass a wide array of security checks commonly implemented in Android applications. This includes, but is not limited to, various forms of SSL pinning, sophisticated debugger detection, diverse root detection mechanisms (file system, command execution, property checks), and common emulator detection logic.
   -   **Apply universal bypass (launches app and injects)**: Starts the target application and immediately injects the comprehensive universal bypass script.
    
    
    burp-frame universal-bypass <PACKAGE_NAME>
    
    
    
   -   **Apply universal bypass (attaches to running app and injects)**: Attaches to an already running instance of the target application and injects the comprehensive universal bypass script.
    
    
    burp-frame universal-bypass <PACKAGE_NAME> --attach
    
   > ⚠️ **Important**: Both `frida cert-repin` and `universal-bypass` commands will keep your terminal session active to maintain the Frida injection. **Do not close your terminal** until you are finished with your testing, as closing it will detach Frida, and the bypasses will cease to function. To detach, simply press **Ctrl+C** in the terminal where the command is running.
    

### **`device` Module: Android Device Management**

This module offers a suite of commands for controlling your Android device's state and managing installed applications, leveraging ADB.

-   **Essential device control**: Remotely reboot the connected Android device.
    
    ```
    burp-frame device reboot
    
    ```
    
-   **File system manipulation**: Remount the `/system` partition as either read-write (`remount-rw`) or read-only (`remount-ro`), crucial for system-level modifications (requires root).
    
    ```
    burp-frame device remount-rw
    
    ```
    
-   **Device discovery**: List all currently connected ADB devices and their properties.
    
    ```
    burp-frame device ls
    
    ```
    
-   **Application lifecycle management**: Effortlessly install and uninstall APKs onto the device.
    
    ```
    burp-frame device install /path/to/your/app.apk
    
    ```
    
-   **Flexible connectivity**: Connect to and disconnect from ADB devices over TCP/IP (e.g., for Wi-Fi debugging).
    
    ```
    burp-frame device connect 192.168.1.10:5555
    
    ```
    
-   **Disconnect from a device over TCP/IP**: Terminates an existing network-based ADB connection.
    
    ```
    burp-frame device disconnect 192.168.1.10:5555
    
    ```
    

### **`config` Module: Tool Path Configuration**

This module allows you to easily manage and persist the absolute paths to external tools (`adb`, `openssl`, Frida binaries) that `burp-frame` depends on.

-   **Interactive configuration wizard**: Launches an interactive prompt to guide you through setting paths for all supported tools.
    
    ```
    burp-frame config
    
    ```
    
-   **Set specific paths directly**: Allows direct specification of tool paths via command-line arguments.
    
    ```
    burp-frame config --adb "/path/to/adb" --openssl "/path/to/openssl" --frida-server-binary "/path/to/frida-server" --frida-cli "/path/to/frida"
    
    ```
    
-   **View current configuration**: Displays all currently stored tool paths.
    
    ```
    burp-frame config
    
    ```
    
    > You can also manually inspect the `config.json` file. Its location varies by OS: typically `~/.config/burp-frame/config.json` on Linux/macOS, or `C:\Users\YOUR_USER\AppData\Roaming\burp-frame\config.json` on Windows.
    

### **`logs` Module: View Operation Logs**

This module provides easy access to `burp-frame`'s detailed operation logs, essential for troubleshooting, auditing, and understanding framework activity.

-   **View recent logs and select a log file to display**: Lists the most recent log files and allows you to choose one to display its contents directly in the terminal.
    
    ```
    burp-frame logs
    
    ```
        
## ⚠️ Troubleshooting

| Issue                                                | Solution                                                                                                          |
|------------------------------------------------------|------------------------------------------------------------------------------------------------------------------|
| ❌ adb or openssl not found                          | Run `burp-frame config` to set the correct paths.                                                               |
| ❌ Certificate conversion fails                       | Ensure OpenSSL is installed and accessible. Confirm the certificate is in DER format.                            |
| ❌ Device not detected                                | Run `adb devices` to confirm connection. Ensure USB debugging is enabled on your device. Check ADB drivers if on Windows. For remote connections, ensure `adb tcpip` is enabled on the device and firewall allows connection. |
| ❌ frida-server not running/found                    | After `burp-frame frida deploy`, verify `frida-server` is running on the device. Check device logs for errors if it fails to start. |
| ❌ Frida attachment fails                             | Ensure the target app is running (for `--attach`), correct package name is used, and device has `frida-server` running. Check device memory and process limits. |
| ⚠️ adb remount fails                                 | Ensure your device/emulator is rooted. Some devices have dm-verity enabled on `/system`. Try `adb disable-verity` followed by `adb reboot`, `adb root`, then `adb remount`. |
| ❌ ImportError after PyPI install                    | Ensure `pip install burp-frame` completed without errors. If running from source, make sure you ran `pip install .` from the project root (where `pyproject.toml` is). |
| ❌ TypeError: ArgumentParser.__init__() got an unexpected keyword argument 'formatter' | Update your `cli.py` to use `formatter_class=argparse.RawTextHelpFormatter` instead of `formatter=...` in all `add_parser` calls. |

## 📚 FAQ

-   **How do I export the certificate from Burp?** Go to: **Proxy → Options → Import/Export CA Certificate**. Choose **DER format** and save the file (e.g., `burp.der`).
    
-   **Why does `burp-frame` require root access for certificate installation?** Android mandates that trusted CA certificates are installed into the system's certificate store, which resides in a protected `/system` partition. Modifying this partition requires root privileges. Magisk provides a systemless way to do this, and `burp-frame` supports it.
    
-   **My emulator isn't rooted. What now?**  `burp-frame` requires root access for system-level certificate installation and many advanced Frida operations. If your emulator isn't rooted, consider using one of the following:
    
    -   ✅ **Genymotion**: Its emulators are rooted by default, offering a convenient testing environment.
        
    -   ✅ **Magisk-patched AVDs**: You can create or patch Android Virtual Devices to include Magisk for root access.
        
    -   ✅ **Custom rooted emulator images**: Utilize pre-built or custom-rooted Android emulator images.
        
-   **`adb remount` fails?** This issue often arises when `dm-verity` (a verified boot feature) is enabled on the system partition, preventing remounting. Try the following sequence:
    
    ```
    adb disable-verity
    adb reboot
    adb root
    adb remount
    
    ```
    

## 🤝 Contributing

Contributions, bug reports, and feature requests are highly welcomed and encouraged! If you’d like to help improve **burp-frame**, please follow these steps:

1.  **Fork the repository** on GitHub.
    
2.  **Create a feature branch** (`git checkout -b feature/your-feature-name`).
    
3.  **Implement your changes** and ensure tests pass.
    
4.  **Submit a pull request** describing your contributions clearly.

📄 **CONTRIBUTING.md** – _coming soon_ (This file will provide more detailed guidelines for contributions).

For suggestions, feedback, or collaboration inquiries, feel free to reach out: 📧 [kidanugashaw@gmail.com](mailto:kidanugashaw@gmail.com "null")

## 📝 License

**burp-frame** is distributed under the **MIT License**. This permissive license allows you to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the software. © 2025 [Gashaw Kidanu](https://github.com/Gashaw512/burp-frame "null"). See the [LICENSE](https://www.google.com/search?q=LICENSE "null") file for full details.

## 👋 Final Notes

**burp-frame** is an actively maintained and continuously evolving framework, designed with extensibility and usability in mind. Whether you're a dedicated red teamer, a meticulous security engineer, or a mobile developer focused on application security, this tool is crafted to streamline your workflow for HTTPS interception and dynamic analysis on Android platforms.

> **Intercept with confidence. Secure with precision.** — _burp-frame_



