# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/polywrap/wrap/master/manifest/wrap.info/0.1.json
#   timestamp: 2022-12-10T06:45:37+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field


class Version(Enum):
    """
    WRAP Standard Version
    """

    VERSION_0_1_0 = "0.1.0"
    VERSION_0_1 = "0.1"


class Type(Enum):
    """
    Wrapper Package Type
    """

    WASM = "wasm"
    INTERFACE = "interface"
    PLUGIN = "plugin"


class Env(BaseModel):
    required: Optional[bool] = None


class GetImplementations(BaseModel):
    enabled: bool


class CapabilityDefinition(BaseModel):
    get_implementations: Optional[GetImplementations] = Field(
        None, alias="getImplementations"
    )


class ImportedDefinition(BaseModel):
    uri: str
    namespace: str
    native_type: str = Field(..., alias="nativeType")


class WithKind(BaseModel):
    kind: float


class WithComment(BaseModel):
    comment: Optional[str] = None


class GenericDefinition(WithKind):
    type: Union[str, Enum, None]
    name: Optional[str] = None
    required: Optional[bool] = None


class ScalarType(Enum):
    U_INT = "UInt"
    U_INT8 = "UInt8"
    U_INT16 = "UInt16"
    U_INT32 = "UInt32"
    INT = "Int"
    INT8 = "Int8"
    INT16 = "Int16"
    INT32 = "Int32"
    STRING = "String"
    BOOLEAN = "Boolean"
    BYTES = "Bytes"
    BIG_INT = "BigInt"
    BIG_NUMBER = "BigNumber"
    JSON = "JSON"


class ScalarDefinition(GenericDefinition):
    type: ScalarType


class MapKeyType(Enum):
    U_INT = "UInt"
    U_INT8 = "UInt8"
    U_INT16 = "UInt16"
    U_INT32 = "UInt32"
    INT = "Int"
    INT8 = "Int8"
    INT16 = "Int16"
    INT32 = "Int32"
    STRING = "String"


class ObjectRef(GenericDefinition):
    pass


class EnumRef(GenericDefinition):
    pass


class UnresolvedObjectOrEnumRef(GenericDefinition):
    pass


class ImportedModuleRef(BaseModel):
    type: Optional[str] = None


class InterfaceImplementedDefinition(GenericDefinition):
    pass


class EnumDefinition(GenericDefinition, WithComment):
    constants: Optional[List[str]] = None


class InterfaceDefinition(GenericDefinition, ImportedDefinition):
    capabilities: Optional[CapabilityDefinition] = None


class ImportedEnumDefinition(EnumDefinition, ImportedDefinition):
    pass


class WrapManifest(BaseModel):
    class Config:
        extra = Extra.forbid

    version: Version = Field(..., description="WRAP Standard Version")
    type: Type = Field(..., description="Wrapper Package Type")
    name: str = Field(..., description="Wrapper Name", regex="^[a-zA-Z0-9\\-\\_]+$")
    abi: Abi = Field(..., description="Information of modules")


class Abi(BaseModel):
    version: Optional[str] = Field(None, description="ABI Version")
    object_types: Optional[List[ObjectDefinition]] = Field(None, alias="objectTypes")
    module_type: Optional[ModuleDefinition] = Field(None, alias="moduleType")
    enum_types: Optional[List[EnumDefinition]] = Field(None, alias="enumTypes")
    interface_types: Optional[List[InterfaceDefinition]] = Field(
        None, alias="interfaceTypes"
    )
    imported_object_types: Optional[List[ImportedObjectDefinition]] = Field(
        None, alias="importedObjectTypes"
    )
    imported_module_types: Optional[List[ImportedModuleDefinition]] = Field(
        None, alias="importedModuleTypes"
    )
    imported_enum_types: Optional[List[ImportedEnumDefinition]] = Field(
        None, alias="importedEnumTypes"
    )
    imported_env_types: Optional[List[ImportedEnvDefinition]] = Field(
        None, alias="importedEnvTypes"
    )
    env_type: Optional[EnvDefinition] = Field(None, alias="envType")


class ObjectDefinition(GenericDefinition, WithComment):
    properties: Optional[List[PropertyDefinition]] = None
    interfaces: Optional[List[InterfaceImplementedDefinition]] = None


class ModuleDefinition(GenericDefinition, WithComment):
    methods: Optional[List[MethodDefinition]] = None
    imports: Optional[List[ImportedModuleRef]] = None
    interfaces: Optional[List[InterfaceImplementedDefinition]] = None


class MethodDefinition(GenericDefinition, WithComment):
    arguments: Optional[List[PropertyDefinition]] = None
    env: Optional[Env] = None
    return_: Optional[PropertyDefinition] = Field(None, alias="return")


class ImportedModuleDefinition(GenericDefinition, ImportedDefinition, WithComment):
    methods: Optional[List[MethodDefinition]] = None
    is_interface: Optional[bool] = Field(None, alias="isInterface")


class AnyDefinition(GenericDefinition):
    array: Optional[ArrayDefinition] = None
    scalar: Optional[ScalarDefinition] = None
    map: Optional[MapDefinition] = None
    object: Optional[ObjectRef] = None
    enum: Optional[EnumRef] = None
    unresolved_object_or_enum: Optional[UnresolvedObjectOrEnumRef] = Field(
        None, alias="unresolvedObjectOrEnum"
    )


class EnvDefinition(ObjectDefinition):
    pass


class ImportedObjectDefinition(ObjectDefinition, ImportedDefinition, WithComment):
    pass


class PropertyDefinition(WithComment, AnyDefinition):
    pass


class ArrayDefinition(AnyDefinition):
    item: Optional[GenericDefinition] = None


class MapKeyDefinition(AnyDefinition):
    type: Optional[MapKeyType] = None


class MapDefinition(AnyDefinition, WithComment):
    key: Optional[MapKeyDefinition] = None
    value: Optional[GenericDefinition] = None


class ImportedEnvDefinition(ImportedObjectDefinition):
    pass


WrapManifest.update_forward_refs()
Abi.update_forward_refs()
ObjectDefinition.update_forward_refs()
ModuleDefinition.update_forward_refs()
MethodDefinition.update_forward_refs()
AnyDefinition.update_forward_refs()
EnvDefinition.update_forward_refs()
ImportedObjectDefinition.update_forward_refs()
PropertyDefinition.update_forward_refs()
ArrayDefinition.update_forward_refs()
MapKeyDefinition.update_forward_refs()
MapDefinition.update_forward_refs()
ImportedEnvDefinition.update_forward_refs()
