# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.configuration import Configuration


class V1alpha1AssemblyDatasetDescriptor(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'annotation_metadata': 'V1alpha1AnnotationForAssembly',
        'assembly_accession': 'str',
        'assembly_category': 'str',
        'assembly_level': 'str',
        'chromosomes': 'list[str]',
        'contig_n50': 'int',
        'display_name': 'str',
        'estimated_size': 'str',
        'org': 'V1alpha1Organism',
        'seq_length': 'str',
        'submission_date': 'str'
    }

    attribute_map = {
        'annotation_metadata': 'annotation_metadata',
        'assembly_accession': 'assembly_accession',
        'assembly_category': 'assembly_category',
        'assembly_level': 'assembly_level',
        'chromosomes': 'chromosomes',
        'contig_n50': 'contig_n50',
        'display_name': 'display_name',
        'estimated_size': 'estimated_size',
        'org': 'org',
        'seq_length': 'seq_length',
        'submission_date': 'submission_date'
    }

    def __init__(self, annotation_metadata=None, assembly_accession=None, assembly_category=None, assembly_level=None, chromosomes=None, contig_n50=None, display_name=None, estimated_size=None, org=None, seq_length=None, submission_date=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1AssemblyDatasetDescriptor - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._annotation_metadata = None
        self._assembly_accession = None
        self._assembly_category = None
        self._assembly_level = None
        self._chromosomes = None
        self._contig_n50 = None
        self._display_name = None
        self._estimated_size = None
        self._org = None
        self._seq_length = None
        self._submission_date = None
        self.discriminator = None

        if annotation_metadata is not None:
            self.annotation_metadata = annotation_metadata
        if assembly_accession is not None:
            self.assembly_accession = assembly_accession
        if assembly_category is not None:
            self.assembly_category = assembly_category
        if assembly_level is not None:
            self.assembly_level = assembly_level
        if chromosomes is not None:
            self.chromosomes = chromosomes
        if contig_n50 is not None:
            self.contig_n50 = contig_n50
        if display_name is not None:
            self.display_name = display_name
        if estimated_size is not None:
            self.estimated_size = estimated_size
        if org is not None:
            self.org = org
        if seq_length is not None:
            self.seq_length = seq_length
        if submission_date is not None:
            self.submission_date = submission_date

    @property
    def annotation_metadata(self):
        """Gets the annotation_metadata of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The annotation_metadata of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: V1alpha1AnnotationForAssembly
        """
        return self._annotation_metadata

    @annotation_metadata.setter
    def annotation_metadata(self, annotation_metadata):
        """Sets the annotation_metadata of this V1alpha1AssemblyDatasetDescriptor.


        :param annotation_metadata: The annotation_metadata of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: V1alpha1AnnotationForAssembly
        """

        self._annotation_metadata = annotation_metadata

    @property
    def assembly_accession(self):
        """Gets the assembly_accession of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The assembly_accession of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._assembly_accession

    @assembly_accession.setter
    def assembly_accession(self, assembly_accession):
        """Sets the assembly_accession of this V1alpha1AssemblyDatasetDescriptor.


        :param assembly_accession: The assembly_accession of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._assembly_accession = assembly_accession

    @property
    def assembly_category(self):
        """Gets the assembly_category of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501

        Category of assembly, like reference.  # noqa: E501

        :return: The assembly_category of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._assembly_category

    @assembly_category.setter
    def assembly_category(self, assembly_category):
        """Sets the assembly_category of this V1alpha1AssemblyDatasetDescriptor.

        Category of assembly, like reference.  # noqa: E501

        :param assembly_category: The assembly_category of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._assembly_category = assembly_category

    @property
    def assembly_level(self):
        """Gets the assembly_level of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The assembly_level of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._assembly_level

    @assembly_level.setter
    def assembly_level(self, assembly_level):
        """Sets the assembly_level of this V1alpha1AssemblyDatasetDescriptor.


        :param assembly_level: The assembly_level of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._assembly_level = assembly_level

    @property
    def chromosomes(self):
        """Gets the chromosomes of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501

        Which chromosomes are included in this dataset. NB: Mitochondria is encoded as 'MT'.  # noqa: E501

        :return: The chromosomes of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: list[str]
        """
        return self._chromosomes

    @chromosomes.setter
    def chromosomes(self, chromosomes):
        """Sets the chromosomes of this V1alpha1AssemblyDatasetDescriptor.

        Which chromosomes are included in this dataset. NB: Mitochondria is encoded as 'MT'.  # noqa: E501

        :param chromosomes: The chromosomes of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: list[str]
        """

        self._chromosomes = chromosomes

    @property
    def contig_n50(self):
        """Gets the contig_n50 of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The contig_n50 of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: int
        """
        return self._contig_n50

    @contig_n50.setter
    def contig_n50(self, contig_n50):
        """Sets the contig_n50 of this V1alpha1AssemblyDatasetDescriptor.


        :param contig_n50: The contig_n50 of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: int
        """

        self._contig_n50 = contig_n50

    @property
    def display_name(self):
        """Gets the display_name of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501

        The name of the Assembly dataset to be displayed in a user interface.  # noqa: E501

        :return: The display_name of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this V1alpha1AssemblyDatasetDescriptor.

        The name of the Assembly dataset to be displayed in a user interface.  # noqa: E501

        :param display_name: The display_name of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def estimated_size(self):
        """Gets the estimated_size of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The estimated_size of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._estimated_size

    @estimated_size.setter
    def estimated_size(self, estimated_size):
        """Sets the estimated_size of this V1alpha1AssemblyDatasetDescriptor.


        :param estimated_size: The estimated_size of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._estimated_size = estimated_size

    @property
    def org(self):
        """Gets the org of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The org of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: V1alpha1Organism
        """
        return self._org

    @org.setter
    def org(self, org):
        """Sets the org of this V1alpha1AssemblyDatasetDescriptor.


        :param org: The org of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: V1alpha1Organism
        """

        self._org = org

    @property
    def seq_length(self):
        """Gets the seq_length of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The seq_length of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._seq_length

    @seq_length.setter
    def seq_length(self, seq_length):
        """Sets the seq_length of this V1alpha1AssemblyDatasetDescriptor.


        :param seq_length: The seq_length of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._seq_length = seq_length

    @property
    def submission_date(self):
        """Gets the submission_date of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501


        :return: The submission_date of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._submission_date

    @submission_date.setter
    def submission_date(self, submission_date):
        """Sets the submission_date of this V1alpha1AssemblyDatasetDescriptor.


        :param submission_date: The submission_date of this V1alpha1AssemblyDatasetDescriptor.  # noqa: E501
        :type: str
        """

        self._submission_date = submission_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1AssemblyDatasetDescriptor):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1AssemblyDatasetDescriptor):
            return True

        return self.to_dict() != other.to_dict()
