/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf;

import java.util.BitSet;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.CharSink;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.Pipe;
import org.semarglproject.sink.TripleSink;

public class NTriplesSerializer
extends Pipe<CharSink>
implements TripleSink {
    protected static final String DOT_EOL = ".\n";
    protected static final char SPACE = ' ';
    private static final char QUOTE = '\"';
    private static final char URI_START = '<';
    private static final char URI_END = '>';
    private static final BitSet ESCAPABLE_CONTENT_CHARS = new BitSet();
    private static final BitSet ESCAPABLE_URI_CHARS = new BitSet();

    protected NTriplesSerializer(CharSink sink) {
        super((DataSink)sink);
    }

    public static TripleSink connect(CharSink sink) {
        return new NTriplesSerializer(sink);
    }

    public void addNonLiteral(String subj, String pred, String obj) {
        try {
            this.startTriple(subj, pred);
            this.serializeBnodeOrUri(obj);
            ((CharSink)this.sink).process(DOT_EOL);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void addPlainLiteral(String subj, String pred, String content, String lang) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            if (lang != null) {
                ((CharSink)this.sink).process('@').process(lang);
            }
            ((CharSink)this.sink).process(' ').process(DOT_EOL);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void addTypedLiteral(String subj, String pred, String content, String type) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            ((CharSink)this.sink).process("^^");
            this.serializeUri(type);
            ((CharSink)this.sink).process(DOT_EOL);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected boolean setPropertyInternal(String key, Object value) {
        return false;
    }

    public void setBaseUri(String baseUri) {
    }

    protected void startTriple(String subj, String pred) throws ParseException {
        this.serializeBnodeOrUri(subj);
        this.serializeBnodeOrUri(pred);
    }

    protected void serializeBnodeOrUri(String value) throws ParseException {
        if (value.startsWith("_:")) {
            ((CharSink)this.sink).process(value).process(' ');
        } else {
            this.serializeUri(value);
        }
    }

    protected void serializeUri(String uri) throws ParseException {
        String escapedUri = NTriplesSerializer.escapeUri(uri);
        ((CharSink)this.sink).process('<').process(escapedUri).process('>').process(' ');
    }

    protected void addContent(String content) throws ParseException {
        String escapedContent = NTriplesSerializer.escapeContent(content);
        ((CharSink)this.sink).process('\"').process(escapedContent).process('\"');
    }

    private static String escapeContent(String str) {
        char ch;
        int pos;
        int limit = str.length();
        for (pos = 0; pos < limit && (ch = str.charAt(pos)) <= '\u0080' && !ESCAPABLE_CONTENT_CHARS.get(ch); ++pos) {
        }
        if (pos == limit) {
            return str;
        }
        StringBuilder result = new StringBuilder(limit);
        result.append(str.substring(0, pos));
        while (pos < limit) {
            char ch2 = str.charAt(pos);
            if (ch2 < '\u0080') {
                switch (ch2) {
                    case '\"': 
                    case '\\': {
                        result.append('\\').append(ch2);
                        break;
                    }
                    case '\b': {
                        result.append("\\b");
                        break;
                    }
                    case '\f': {
                        result.append("\\f");
                        break;
                    }
                    case '\n': {
                        result.append("\\n");
                        break;
                    }
                    case '\r': {
                        result.append("\\r");
                        break;
                    }
                    case '\t': {
                        result.append("\\t");
                        break;
                    }
                    default: {
                        result.append(ch2);
                        break;
                    }
                }
            } else if (ch2 <= '\uffff') {
                result.append("\\u").append(String.format("%04X", ch2));
            } else {
                result.append("\\U").append(String.format("%08X", ch2));
            }
            ++pos;
        }
        return result.toString();
    }

    private static String escapeUri(String str) {
        char ch;
        int pos;
        int limit = str.length();
        for (pos = 0; pos < limit && (ch = str.charAt(pos)) <= '\u0080' && !ESCAPABLE_URI_CHARS.get(ch); ++pos) {
        }
        if (pos == limit) {
            return str;
        }
        StringBuilder result = new StringBuilder(limit);
        result.append(str.substring(0, pos));
        while (pos < limit) {
            char ch2 = str.charAt(pos);
            if (ESCAPABLE_URI_CHARS.get(ch2)) {
                result.append("\\u").append(String.format("%04X", ch2));
            } else if (ch2 < '\u0080') {
                result.append(ch2);
            } else if (ch2 <= '\uffff') {
                result.append("\\u").append(String.format("%04X", ch2));
            } else {
                result.append("\\U").append(String.format("%08X", ch2));
            }
            ++pos;
        }
        return result.toString();
    }

    static {
        ESCAPABLE_CONTENT_CHARS.set(92);
        ESCAPABLE_CONTENT_CHARS.set(34);
        ESCAPABLE_CONTENT_CHARS.set(8);
        ESCAPABLE_CONTENT_CHARS.set(12);
        ESCAPABLE_CONTENT_CHARS.set(10);
        ESCAPABLE_CONTENT_CHARS.set(13);
        ESCAPABLE_CONTENT_CHARS.set(9);
        for (int ch = 0; ch <= 32; ch = (int)((char)(ch + 1))) {
            ESCAPABLE_URI_CHARS.set(ch);
        }
        ESCAPABLE_URI_CHARS.set(92);
        ESCAPABLE_URI_CHARS.set(60);
        ESCAPABLE_URI_CHARS.set(62);
        ESCAPABLE_URI_CHARS.set(123);
        ESCAPABLE_URI_CHARS.set(125);
        ESCAPABLE_URI_CHARS.set(34);
        ESCAPABLE_URI_CHARS.set(96);
        ESCAPABLE_URI_CHARS.set(124);
        ESCAPABLE_URI_CHARS.set(94);
    }
}

