/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractShortCollection;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ShortArrays;
import com.carrotsearch.hppcrt.ShortContainer;
import com.carrotsearch.hppcrt.ShortIndexedContainer;
import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.lists.ShortLinkedList;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;
import com.carrotsearch.hppcrt.procedures.ShortProcedure;
import com.carrotsearch.hppcrt.sorting.ShortSort;
import com.carrotsearch.hppcrt.strategies.ShortComparator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortArrayList
extends AbstractShortCollection
implements ShortIndexedContainer,
Cloneable {
    public short[] buffer;
    protected int elementsCount;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<ShortCursor, ValueIterator> valueIteratorPool;

    public ShortArrayList() {
        this(8);
    }

    public ShortArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ShortArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = -1;
                obj.size = ShortArrayList.this.size();
                ValueIterator.access$102(obj, ShortArrayList.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
            }
        });
    }

    public ShortArrayList(ShortContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(short e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(short e1, short e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(short[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public void add(short ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(ShortContainer container) {
        return this.addAll((Iterable<? extends ShortCursor>)container);
    }

    public int addAll(Iterable<? extends ShortCursor> iterable) {
        int size = 0;
        for (ShortCursor shortCursor : iterable) {
            this.add(shortCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, short e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public short get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        return this.buffer[index];
    }

    @Override
    public short set(int index, short e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        short v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public short remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        short v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    @Override
    public int removeFirst(short e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLast(short e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAll(short e1) {
        int to = 0;
        short[] buffer = this.buffer;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == buffer[from]) continue;
            if (to != from) {
                buffer[to] = buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(short e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(short e1) {
        short[] buffer = this.buffer;
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short e1) {
        short[] buffer = this.buffer;
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            try {
                short[] newBuffer = new short[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize >= this.elementsCount) {
                Arrays.fill(this.buffer, this.elementsCount, newSize, (short)0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = ShortArrays.EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public short[] toArray(short[] target) {
        System.arraycopy(this.buffer, 0, target, 0, this.elementsCount);
        return target;
    }

    public ShortArrayList clone() {
        ShortArrayList cloned = new ShortArrayList(8, this.resizer);
        cloned.buffer = (short[])this.buffer.clone();
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        short[] buffer = this.buffer;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ShortArrayList) {
                ShortArrayList other = (ShortArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof ShortLinkedList) {
                ShortLinkedList other = (ShortLinkedList)obj;
                if (other.size() != this.size()) {
                    return false;
                }
                ValueIterator it = this.iterator();
                ShortLinkedList.ValueIterator itOther = other.iterator();
                while (it.hasNext()) {
                    short myVal = ((ShortCursor)it.next()).value;
                    short otherVal = ((ShortCursor)itOther.next()).value;
                    if (myVal == otherVal) continue;
                    it.release();
                    itOther.release();
                    return false;
                }
                itOther.release();
                return true;
            }
            if (obj instanceof ShortIndexedContainer) {
                ShortIndexedContainer other = (ShortIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(short[] b1, short[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(ShortIndexedContainer b1, ShortIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            short o2;
            short o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        short[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ShortPredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        short[] buffer = this.buffer;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(buffer[from])) continue;
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        short[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static ShortArrayList newInstance() {
        return new ShortArrayList();
    }

    public static ShortArrayList newInstance(int initialCapacity) {
        return new ShortArrayList(initialCapacity);
    }

    public static ShortArrayList from(short ... elements) {
        ShortArrayList list = new ShortArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static ShortArrayList from(ShortContainer container) {
        return new ShortArrayList(container);
    }

    public void sort(int beginIndex, int endIndex) {
        ShortSort.quicksort(this.buffer, beginIndex, endIndex);
    }

    public void sort() {
        this.sort(0, this.elementsCount);
    }

    public void sort(int beginIndex, int endIndex, ShortComparator comp) {
        ShortSort.quicksort(this.buffer, beginIndex, endIndex, comp);
    }

    public void sort(ShortComparator comp) {
        this.sort(0, this.elementsCount, comp);
    }

    public void pushLast(short e1) {
        this.add(e1);
    }

    public void pushLast(short e1, short e2) {
        this.add(e1, e2);
    }

    public void pushLast(short e1, short e2, short e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void pushLast(short e1, short e2, short e3, short e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void pushLast(short[] elements, int start, int len) {
        this.add(elements, start, len);
    }

    public final void pushLast(short ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int pushAllLast(ShortContainer container) {
        return this.addAll(container);
    }

    public int pushAllLast(Iterable<? extends ShortCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discardLast(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discardLast() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public short popLast() {
        assert (this.elementsCount > 0);
        short v = this.buffer[--this.elementsCount];
        return v;
    }

    public short peekLast() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.elementsCount) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.elementsCount + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<ShortCursor> {
        public final ShortCursor cursor = new ShortCursor();
        private short[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = -1;
            this.size = ShortArrayList.this.size();
            this.buffer = ShortArrayList.this.buffer;
        }

        @Override
        protected ShortCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (ShortCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ short[] access$102(ValueIterator x0, short[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

