/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.FloatArrays;
import com.carrotsearch.hppcrt.FloatContainer;
import com.carrotsearch.hppcrt.FloatIndexedContainer;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.lists.FloatLinkedList;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;
import com.carrotsearch.hppcrt.sorting.FloatSort;
import com.carrotsearch.hppcrt.strategies.FloatComparator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArrayList
extends AbstractFloatCollection
implements FloatIndexedContainer,
Cloneable {
    public float[] buffer;
    protected int elementsCount;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<FloatCursor, ValueIterator> valueIteratorPool;

    public FloatArrayList() {
        this(8);
    }

    public FloatArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public FloatArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = -1;
                obj.size = FloatArrayList.this.size();
                ValueIterator.access$102(obj, FloatArrayList.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
            }
        });
    }

    public FloatArrayList(FloatContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(float e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(float e1, float e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(float[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public void add(float ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(FloatContainer container) {
        return this.addAll((Iterable<? extends FloatCursor>)container);
    }

    public int addAll(Iterable<? extends FloatCursor> iterable) {
        int size = 0;
        for (FloatCursor floatCursor : iterable) {
            this.add(floatCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, float e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public float get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        return this.buffer[index];
    }

    @Override
    public float set(int index, float e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        float v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public float remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        float v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    @Override
    public int removeFirst(float e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLast(float e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAll(float e1) {
        int to = 0;
        float[] buffer = this.buffer;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (Float.floatToIntBits(e1) == Float.floatToIntBits(buffer[from])) continue;
            if (to != from) {
                buffer[to] = buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(float e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(float e1) {
        float[] buffer = this.buffer;
        for (int i = 0; i < this.elementsCount; ++i) {
            if (Float.floatToIntBits(e1) != Float.floatToIntBits(buffer[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float e1) {
        float[] buffer = this.buffer;
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (Float.floatToIntBits(e1) != Float.floatToIntBits(buffer[i])) continue;
            return i;
        }
        return -1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            try {
                float[] newBuffer = new float[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize >= this.elementsCount) {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0.0f);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = FloatArrays.EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public float[] toArray(float[] target) {
        System.arraycopy(this.buffer, 0, target, 0, this.elementsCount);
        return target;
    }

    public FloatArrayList clone() {
        FloatArrayList cloned = new FloatArrayList(8, this.resizer);
        cloned.buffer = (float[])this.buffer.clone();
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        float[] buffer = this.buffer;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FloatArrayList) {
                FloatArrayList other = (FloatArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof FloatLinkedList) {
                FloatLinkedList other = (FloatLinkedList)obj;
                if (other.size() != this.size()) {
                    return false;
                }
                ValueIterator it = this.iterator();
                FloatLinkedList.ValueIterator itOther = other.iterator();
                while (it.hasNext()) {
                    float myVal = ((FloatCursor)it.next()).value;
                    float otherVal = ((FloatCursor)itOther.next()).value;
                    if (Float.floatToIntBits(myVal) == Float.floatToIntBits(otherVal)) continue;
                    it.release();
                    itOther.release();
                    return false;
                }
                itOther.release();
                return true;
            }
            if (obj instanceof FloatIndexedContainer) {
                FloatIndexedContainer other = (FloatIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(float[] b1, float[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (Float.floatToIntBits(b1[i]) == Float.floatToIntBits(b2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(FloatIndexedContainer b1, FloatIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            float o1 = b1.get(i);
            float o2 = b2.get(i);
            if (Float.floatToIntBits(o1) == Float.floatToIntBits(o2)) continue;
            return false;
        }
        return true;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        float[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(FloatPredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        float[] buffer = this.buffer;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(buffer[from])) continue;
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        float[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static FloatArrayList newInstance() {
        return new FloatArrayList();
    }

    public static FloatArrayList newInstance(int initialCapacity) {
        return new FloatArrayList(initialCapacity);
    }

    public static FloatArrayList from(float ... elements) {
        FloatArrayList list = new FloatArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static FloatArrayList from(FloatContainer container) {
        return new FloatArrayList(container);
    }

    public void sort(int beginIndex, int endIndex) {
        FloatSort.quicksort(this.buffer, beginIndex, endIndex);
    }

    public void sort() {
        this.sort(0, this.elementsCount);
    }

    public void sort(int beginIndex, int endIndex, FloatComparator comp) {
        FloatSort.quicksort(this.buffer, beginIndex, endIndex, comp);
    }

    public void sort(FloatComparator comp) {
        this.sort(0, this.elementsCount, comp);
    }

    public void pushLast(float e1) {
        this.add(e1);
    }

    public void pushLast(float e1, float e2) {
        this.add(e1, e2);
    }

    public void pushLast(float e1, float e2, float e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void pushLast(float e1, float e2, float e3, float e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void pushLast(float[] elements, int start, int len) {
        this.add(elements, start, len);
    }

    public final void pushLast(float ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int pushAllLast(FloatContainer container) {
        return this.addAll(container);
    }

    public int pushAllLast(Iterable<? extends FloatCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discardLast(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discardLast() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public float popLast() {
        assert (this.elementsCount > 0);
        float v = this.buffer[--this.elementsCount];
        return v;
    }

    public float peekLast() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.elementsCount) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.elementsCount + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();
        private float[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = -1;
            this.size = FloatArrayList.this.size();
            this.buffer = FloatArrayList.this.buffer;
        }

        @Override
        protected FloatCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (FloatCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ float[] access$102(ValueIterator x0, float[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

