/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplus.owlapiv3;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNode;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import uk.ac.manchester.cs.factplusplus.AxiomPointer;
import uk.ac.manchester.cs.factplusplus.ClassPointer;
import uk.ac.manchester.cs.factplusplus.DataPropertyPointer;
import uk.ac.manchester.cs.factplusplus.DataTypeExpressionPointer;
import uk.ac.manchester.cs.factplusplus.DataTypeFacet;
import uk.ac.manchester.cs.factplusplus.DataTypePointer;
import uk.ac.manchester.cs.factplusplus.DataValuePointer;
import uk.ac.manchester.cs.factplusplus.FaCTPlusPlus;
import uk.ac.manchester.cs.factplusplus.FaCTPlusPlusProgressMonitor;
import uk.ac.manchester.cs.factplusplus.IndividualPointer;
import uk.ac.manchester.cs.factplusplus.NodePointer;
import uk.ac.manchester.cs.factplusplus.ObjectPropertyPointer;
import uk.ac.manchester.cs.factplusplus.Pointer;
import uk.ac.manchester.cs.factplusplus.owlapiv3.ModuleMethod;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class FaCTPlusPlusReasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    public static final String REASONER_NAME = "FaCT++";
    public static final Version VERSION = new Version(1, 6, 4, 0);
    protected final AtomicBoolean interrupted = new AtomicBoolean(false);
    private final FaCTPlusPlus kernel = new FaCTPlusPlus();
    private volatile AxiomTranslator axiomTranslator = new AxiomTranslator();
    private volatile ClassExpressionTranslator classExpressionTranslator;
    private volatile DataRangeTranslator dataRangeTranslator;
    private volatile ObjectPropertyTranslator objectPropertyTranslator;
    private volatile DataPropertyTranslator dataPropertyTranslator;
    private volatile IndividualTranslator individualTranslator;
    private volatile EntailmentChecker entailmentChecker;
    private final Map<OWLAxiom, AxiomPointer> axiom2PtrMap = new HashMap<OWLAxiom, AxiomPointer>();
    private final Map<AxiomPointer, OWLAxiom> ptr2AxiomMap = new HashMap<AxiomPointer, OWLAxiom>();
    private static final Set<InferenceType> SupportedInferenceTypes = new HashSet<InferenceType>(Arrays.asList(InferenceType.CLASS_ASSERTIONS, InferenceType.CLASS_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.SAME_INDIVIDUAL));
    private final OWLOntologyManager manager;
    private final OWLOntology rootOntology;
    private final BufferingMode bufferingMode;
    private final List<OWLOntologyChange> rawChanges = new ArrayList<OWLOntologyChange>();
    private final Set<OWLAxiom> reasonerAxioms = new HashSet<OWLAxiom>();
    private final long timeOut;
    private final OWLReasonerConfiguration configuration;
    private final boolean log = false;
    final EntityVisitorEx entityTranslator = new EntityVisitorEx();

    public void ontologiesChanged(List<? extends OWLOntologyChange> list) throws OWLException {
        this.handleRawOntologyChanges(list);
    }

    public OWLReasonerConfiguration getReasonerConfiguration() {
        return this.configuration;
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public OWLOntology getRootOntology() {
        return this.rootOntology;
    }

    private synchronized void handleRawOntologyChanges(List<? extends OWLOntologyChange> list) {
        this.rawChanges.addAll(list);
        if (this.bufferingMode.equals((Object)BufferingMode.NON_BUFFERING)) {
            this.flush();
        }
    }

    public synchronized List<OWLOntologyChange> getPendingChanges() {
        return new ArrayList<OWLOntologyChange>(this.rawChanges);
    }

    public synchronized Set<OWLAxiom> getPendingAxiomAdditions() {
        if (this.rawChanges.size() > 0) {
            HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
            this.computeDiff(hashSet, new HashSet<OWLAxiom>());
            return hashSet;
        }
        return Collections.emptySet();
    }

    public synchronized Set<OWLAxiom> getPendingAxiomRemovals() {
        if (this.rawChanges.size() > 0) {
            HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
            this.computeDiff(new HashSet<OWLAxiom>(), hashSet);
            return hashSet;
        }
        return Collections.emptySet();
    }

    public synchronized void flush() {
        if (this.rawChanges.size() > 0) {
            HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
            HashSet<OWLAxiom> hashSet2 = new HashSet<OWLAxiom>();
            this.computeDiff(hashSet, hashSet2);
            this.reasonerAxioms.removeAll(hashSet2);
            this.reasonerAxioms.addAll(hashSet);
            this.rawChanges.clear();
            if (!hashSet.isEmpty() || !hashSet2.isEmpty()) {
                this.handleChanges(hashSet, hashSet2);
            }
        }
    }

    private synchronized void computeDiff(Set<OWLAxiom> set, Set<OWLAxiom> set2) {
        for (OWLOntologyChange oWLOntologyChange : this.rawChanges) {
            if (oWLOntologyChange instanceof AddAxiom) {
                OWLAxiom oWLAxiom = oWLOntologyChange.getAxiom().getAxiomWithoutAnnotations();
                if (this.reasonerAxioms.contains(oWLAxiom)) continue;
                set.add(oWLAxiom);
                continue;
            }
            if (!(oWLOntologyChange instanceof RemoveAxiom)) continue;
            set2.add(oWLOntologyChange.getAxiom().getAxiomWithoutAnnotations());
        }
        set.removeAll(set2);
    }

    public synchronized Collection<OWLAxiom> getReasonerAxioms() {
        return new ArrayList<OWLAxiom>(this.reasonerAxioms);
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.configuration.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.configuration.getIndividualNodeSetPolicy();
    }

    public OWLDataFactory getOWLDataFactory() {
        return this.rootOntology.getOWLOntologyManager().getOWLDataFactory();
    }

    public FaCTPlusPlusReasoner(OWLOntology oWLOntology, OWLReasonerConfiguration oWLReasonerConfiguration, BufferingMode bufferingMode) {
        this.rootOntology = oWLOntology;
        this.bufferingMode = bufferingMode;
        this.configuration = oWLReasonerConfiguration;
        this.timeOut = oWLReasonerConfiguration.getTimeOut();
        this.manager = oWLOntology.getOWLOntologyManager();
        for (OWLOntology oWLOntology2 : oWLOntology.getImportsClosure()) {
            for (OWLLogicalAxiom oWLLogicalAxiom : oWLOntology2.getLogicalAxioms()) {
                this.reasonerAxioms.add(oWLLogicalAxiom.getAxiomWithoutAnnotations());
            }
            for (OWLLogicalAxiom oWLLogicalAxiom : oWLOntology2.getAxioms(AxiomType.DECLARATION)) {
                this.reasonerAxioms.add(oWLLogicalAxiom.getAxiomWithoutAnnotations());
            }
        }
        this.axiomTranslator = new AxiomTranslator();
        this.classExpressionTranslator = new ClassExpressionTranslator();
        this.dataRangeTranslator = new DataRangeTranslator();
        this.objectPropertyTranslator = new ObjectPropertyTranslator();
        this.dataPropertyTranslator = new DataPropertyTranslator();
        this.individualTranslator = new IndividualTranslator();
        this.entailmentChecker = new EntailmentChecker();
        this.kernel.setTopBottomPropertyNames("http://www.w3.org/2002/07/owl#topObjectProperty", "http://www.w3.org/2002/07/owl#bottomObjectProperty", "http://www.w3.org/2002/07/owl#topDataProperty", "http://www.w3.org/2002/07/owl#bottomDataProperty");
        this.kernel.setProgressMonitor(new ProgressMonitorAdapter(oWLReasonerConfiguration.getProgressMonitor(), this.interrupted));
        long l = oWLReasonerConfiguration.getTimeOut();
        if (l == Long.MAX_VALUE) {
            l = 0L;
        }
        this.kernel.setOperationTimeout(l);
        this.kernel.setFreshEntityPolicy(oWLReasonerConfiguration.getFreshEntityPolicy() == FreshEntityPolicy.ALLOW);
        this.loadReasonerAxioms();
    }

    private void loadAxiom(OWLAxiom oWLAxiom) {
        if (this.axiom2PtrMap.containsKey(oWLAxiom)) {
            return;
        }
        AxiomPointer axiomPointer = (AxiomPointer)oWLAxiom.accept((OWLAxiomVisitorEx)this.axiomTranslator);
        if (axiomPointer != null) {
            this.axiom2PtrMap.put(oWLAxiom, axiomPointer);
            this.ptr2AxiomMap.put(axiomPointer, oWLAxiom);
        }
    }

    private void retractAxiom(OWLAxiom oWLAxiom) {
        AxiomPointer axiomPointer = this.axiom2PtrMap.get(oWLAxiom);
        if (axiomPointer != null) {
            this.kernel.retract(axiomPointer);
            this.axiom2PtrMap.remove(oWLAxiom);
            this.ptr2AxiomMap.remove(axiomPointer);
        }
    }

    protected void handleChanges(Set<OWLAxiom> set, Set<OWLAxiom> set2) {
        this.kernel.startChanges();
        for (OWLAxiom oWLAxiom : set) {
            this.loadAxiom(oWLAxiom);
        }
        for (OWLAxiom oWLAxiom : set2) {
            this.retractAxiom(oWLAxiom);
        }
        this.kernel.endChanges();
    }

    private void loadReasonerAxioms() {
        this.getReasonerConfiguration().getProgressMonitor().reasonerTaskStarted("Loading");
        this.getReasonerConfiguration().getProgressMonitor().reasonerTaskBusy();
        this.kernel.clearKernel();
        this.axiomTranslator = new AxiomTranslator();
        this.classExpressionTranslator = new ClassExpressionTranslator();
        this.dataRangeTranslator = new DataRangeTranslator();
        this.objectPropertyTranslator = new ObjectPropertyTranslator();
        this.dataPropertyTranslator = new DataPropertyTranslator();
        this.individualTranslator = new IndividualTranslator();
        this.axiom2PtrMap.clear();
        this.ptr2AxiomMap.clear();
        for (OWLAxiom oWLAxiom : this.reasonerAxioms) {
            this.loadAxiom(oWLAxiom);
        }
        this.getReasonerConfiguration().getProgressMonitor().reasonerTaskStopped();
    }

    public String getReasonerName() {
        return REASONER_NAME;
    }

    public Version getReasonerVersion() {
        return VERSION;
    }

    public void interrupt() {
        this.interrupted.set(true);
    }

    public synchronized void precomputeInferences(InferenceType ... inferenceTypeArray) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        for (InferenceType inferenceType : inferenceTypeArray) {
            if (!SupportedInferenceTypes.contains(inferenceType)) continue;
            this.kernel.realise();
            return;
        }
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        if (SupportedInferenceTypes.contains(inferenceType)) {
            return this.kernel.isRealised();
        }
        return true;
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return SupportedInferenceTypes;
    }

    public synchronized boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        return this.kernel.isKBConsistent();
    }

    private void checkConsistency() {
        if (this.interrupted.get()) {
            throw new ReasonerInterruptedException();
        }
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
    }

    public synchronized boolean isSatisfiable(OWLClassExpression oWLClassExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.checkConsistency();
        return this.kernel.isClassSatisfiable(this.toClassPointer(oWLClassExpression));
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        return this.getBottomClassNode();
    }

    public synchronized boolean isEntailed(OWLAxiom oWLAxiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.checkConsistency();
        Boolean bl = (Boolean)oWLAxiom.accept((OWLAxiomVisitorEx)this.entailmentChecker);
        if (bl == null) {
            throw new UnsupportedEntailmentTypeException(oWLAxiom);
        }
        return bl;
    }

    public synchronized boolean isEntailed(Set<? extends OWLAxiom> set) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        for (OWLAxiom oWLAxiom : set) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return !axiomType.equals((Object)AxiomType.SWRL_RULE);
    }

    public Set<OWLAxiom> getTrace(OWLAxiom oWLAxiom) {
        this.kernel.needTracing();
        HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
        if (this.isEntailed(oWLAxiom)) {
            for (AxiomPointer axiomPointer : this.kernel.getTrace()) {
                hashSet.add(this.ptr2AxiomMap.get(axiomPointer));
            }
        }
        return hashSet;
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.getOWLDataFactory().getOWLThing());
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.getOWLDataFactory().getOWLNothing());
    }

    public synchronized NodeSet<OWLClass> getSubClasses(OWLClassExpression oWLClassExpression, boolean bl) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        this.checkConsistency();
        return this.classExpressionTranslator.getNodeSetFromPointers(this.kernel.askSubClasses(this.toClassPointer(oWLClassExpression), bl));
    }

    public synchronized NodeSet<OWLClass> getSuperClasses(OWLClassExpression oWLClassExpression, boolean bl) throws InconsistentOntologyException, ClassExpressionNotInProfileException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.classExpressionTranslator.getNodeSetFromPointers(this.kernel.askSuperClasses(this.toClassPointer(oWLClassExpression), bl));
    }

    public synchronized Node<OWLClass> getEquivalentClasses(OWLClassExpression oWLClassExpression) throws InconsistentOntologyException, ClassExpressionNotInProfileException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        Pointer[] pointerArray = this.kernel.askEquivalentClasses(this.toClassPointer(oWLClassExpression));
        return this.classExpressionTranslator.getNodeFromPointers(pointerArray);
    }

    public synchronized NodeSet<OWLClass> getDisjointClasses(OWLClassExpression oWLClassExpression) {
        this.checkConsistency();
        return this.classExpressionTranslator.getNodeSetFromPointers(this.kernel.askDisjointClasses(this.toClassPointer(oWLClassExpression)));
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.getOWLDataFactory().getOWLTopObjectProperty());
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.getOWLDataFactory().getOWLBottomObjectProperty());
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.objectPropertyTranslator.getNodeSetFromPointers(this.kernel.askSubObjectProperties(this.toObjectPropertyPointer(oWLObjectPropertyExpression), bl));
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.objectPropertyTranslator.getNodeSetFromPointers(this.kernel.askSuperObjectProperties(this.toObjectPropertyPointer(oWLObjectPropertyExpression), bl));
    }

    public synchronized Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.objectPropertyTranslator.getNodeFromPointers(this.kernel.askEquivalentObjectProperties(this.toObjectPropertyPointer(oWLObjectPropertyExpression)));
    }

    public synchronized NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        OWLObjectPropertyNodeSet oWLObjectPropertyNodeSet = new OWLObjectPropertyNodeSet();
        oWLObjectPropertyNodeSet.addNode(this.getBottomObjectPropertyNode());
        return oWLObjectPropertyNodeSet;
    }

    public synchronized Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.objectPropertyTranslator.getNodeFromPointers(this.kernel.askEquivalentObjectProperties(this.toObjectPropertyPointer(oWLObjectPropertyExpression.getInverseProperty())));
    }

    public synchronized NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.classExpressionTranslator.getNodeSetFromPointers(this.kernel.askObjectPropertyDomain(this.objectPropertyTranslator.createPointerForEntity(oWLObjectPropertyExpression), bl));
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression oWLObjectPropertyExpression, boolean bl) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.classExpressionTranslator.getNodeSetFromPointers(this.kernel.askObjectPropertyRange((ObjectPropertyPointer)this.objectPropertyTranslator.getPointerFromEntity(oWLObjectPropertyExpression), bl));
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        OWLDataPropertyNode oWLDataPropertyNode = new OWLDataPropertyNode();
        oWLDataPropertyNode.add((OWLObject)this.getOWLDataFactory().getOWLTopDataProperty());
        return oWLDataPropertyNode;
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.getEquivalentDataProperties(this.getOWLDataFactory().getOWLBottomDataProperty());
    }

    public synchronized NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.dataPropertyTranslator.getNodeSetFromPointers(this.kernel.askSubDataProperties(this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataProperty), bl));
    }

    public synchronized NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.dataPropertyTranslator.getNodeSetFromPointers(this.kernel.askSuperDataProperties(this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataProperty), bl));
    }

    public synchronized Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty oWLDataProperty) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.dataPropertyTranslator.getNodeFromPointers(this.kernel.askEquivalentDataProperties(this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataProperty)));
    }

    public synchronized NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression oWLDataPropertyExpression) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return new OWLDataPropertyNodeSet();
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty oWLDataProperty, boolean bl) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.classExpressionTranslator.getNodeSetFromPointers(this.kernel.askDataPropertyDomain(this.dataPropertyTranslator.createPointerForEntity(oWLDataProperty), bl));
    }

    public synchronized NodeSet<OWLClass> getTypes(OWLNamedIndividual oWLNamedIndividual, boolean bl) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.classExpressionTranslator.getNodeSetFromPointers(this.kernel.askIndividualTypes(this.toIndividualPointer((OWLIndividual)oWLNamedIndividual), bl));
    }

    public synchronized NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression oWLClassExpression, boolean bl) throws InconsistentOntologyException, ClassExpressionNotInProfileException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.translateIndividualPointersToNodeSet(this.kernel.askInstances(this.toClassPointer(oWLClassExpression), bl));
    }

    public synchronized NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLObjectPropertyExpression oWLObjectPropertyExpression) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.translateIndividualPointersToNodeSet(this.kernel.askRelatedIndividuals(this.toIndividualPointer((OWLIndividual)oWLNamedIndividual), this.toObjectPropertyPointer(oWLObjectPropertyExpression)));
    }

    public synchronized Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual oWLNamedIndividual, OWLDataProperty oWLDataProperty) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return Collections.emptySet();
    }

    public synchronized Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual oWLNamedIndividual) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        this.checkConsistency();
        return this.individualTranslator.getNodeFromPointers(this.kernel.askSameAs(this.toIndividualPointer((OWLIndividual)oWLNamedIndividual)));
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual oWLNamedIndividual) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException {
        OWLClassExpression oWLClassExpression = this.getOWLDataFactory().getOWLObjectOneOf(new OWLIndividual[]{oWLNamedIndividual}).getObjectComplementOf();
        return this.getInstances(oWLClassExpression, false);
    }

    public Node<OWLNamedIndividual> getDataRelatedIndividuals(Set<OWLIndividual> set, OWLDataProperty oWLDataProperty, OWLDataProperty oWLDataProperty2, int n) {
        this.checkConsistency();
        this.translateIndividualSet(set);
        return this.individualTranslator.getNodeFromPointers(this.kernel.getDataRelatedIndividuals(this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataProperty), this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataProperty2), n));
    }

    protected ClassPointer toClassPointer(OWLClassExpression oWLClassExpression) {
        return (ClassPointer)oWLClassExpression.accept((OWLClassExpressionVisitorEx)this.classExpressionTranslator);
    }

    protected DataTypeExpressionPointer toDataTypeExpressionPointer(OWLDataRange oWLDataRange) {
        return (DataTypeExpressionPointer)oWLDataRange.accept((OWLDataRangeVisitorEx)this.dataRangeTranslator);
    }

    protected ObjectPropertyPointer toObjectPropertyPointer(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        OWLObjectPropertyExpression oWLObjectPropertyExpression2 = oWLObjectPropertyExpression.getSimplified();
        if (oWLObjectPropertyExpression2.isAnonymous()) {
            OWLObjectInverseOf oWLObjectInverseOf = (OWLObjectInverseOf)oWLObjectPropertyExpression2;
            return this.kernel.getInverseProperty((ObjectPropertyPointer)this.objectPropertyTranslator.getPointerFromEntity(oWLObjectInverseOf.getInverse().asOWLObjectProperty()));
        }
        return (ObjectPropertyPointer)this.objectPropertyTranslator.getPointerFromEntity(oWLObjectPropertyExpression2.asOWLObjectProperty());
    }

    protected DataPropertyPointer toDataPropertyPointer(OWLDataPropertyExpression oWLDataPropertyExpression) {
        return (DataPropertyPointer)this.dataPropertyTranslator.getPointerFromEntity(oWLDataPropertyExpression.asOWLDataProperty());
    }

    protected synchronized IndividualPointer toIndividualPointer(OWLIndividual oWLIndividual) {
        if (!oWLIndividual.isAnonymous()) {
            return (IndividualPointer)this.individualTranslator.getPointerFromEntity(oWLIndividual.asOWLNamedIndividual());
        }
        return this.kernel.getIndividual(oWLIndividual.toStringID());
    }

    protected synchronized DataTypePointer toDataTypePointer(OWLDatatype oWLDatatype) {
        if (oWLDatatype == null) {
            throw new IllegalArgumentException("datatype cannot be null");
        }
        String string = FaCTPlusPlusReasoner.checkDateTime(oWLDatatype);
        return this.kernel.getBuiltInDataType(string);
    }

    protected static final String checkDateTime(OWLDatatype oWLDatatype) {
        OWL2Datatype oWL2Datatype;
        OWL2Datatype oWL2Datatype2;
        String string = oWLDatatype.toStringID();
        if (oWLDatatype.isBuiltIn() && (oWL2Datatype2 = oWLDatatype.getBuiltInDatatype()) == (oWL2Datatype = OWL2Datatype.XSD_DATE_TIME)) {
            string = string + "AsLong";
        }
        return string;
    }

    protected synchronized DataValuePointer toDataValuePointer(OWLLiteral oWLLiteral) {
        String string = oWLLiteral.getLiteral();
        if (oWLLiteral.getDatatype().isBuiltIn() && oWLLiteral.getDatatype().getBuiltInDatatype() == OWL2Datatype.XSD_DATE_TIME) {
            return this.kernel.getDataValue(FaCTPlusPlusReasoner.convertToLongDateTime(string), this.toDataTypePointer(oWLLiteral.getDatatype()));
        }
        return this.kernel.getDataValue(string, this.toDataTypePointer(oWLLiteral.getDatatype()));
    }

    private static final String convertToLongDateTime(String string) {
        try {
            XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(string);
            if (xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE) {
                xMLGregorianCalendar.setTimezone(0);
            }
            long l = xMLGregorianCalendar.toGregorianCalendar().getTimeInMillis();
            System.out.println("FaCTPlusPlusReasoner.convertToLongDateTime()\n" + string + "\n" + Long.toString(l));
            return Long.toString(l);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new OWLRuntimeException("Error: the datatype support in the Java VM is broken! Cannot parse: " + string, (Throwable)datatypeConfigurationException);
        }
    }

    private NodeSet<OWLNamedIndividual> translateIndividualPointersToNodeSet(IndividualPointer[] individualPointerArray) {
        OWLNamedIndividualNodeSet oWLNamedIndividualNodeSet = new OWLNamedIndividualNodeSet();
        for (IndividualPointer individualPointer : individualPointerArray) {
            OWLNamedIndividual oWLNamedIndividual;
            if (individualPointer == null || (oWLNamedIndividual = (OWLNamedIndividual)this.individualTranslator.getEntityFromPointer(individualPointer)) == null) continue;
            oWLNamedIndividualNodeSet.addEntity((OWLObject)oWLNamedIndividual);
        }
        return oWLNamedIndividualNodeSet;
    }

    protected synchronized void translateIndividualSet(Set<OWLIndividual> set) {
        this.kernel.initArgList();
        for (OWLIndividual oWLIndividual : set) {
            IndividualPointer individualPointer = this.toIndividualPointer(oWLIndividual);
            this.kernel.addArg(individualPointer);
        }
        this.kernel.closeArgList();
    }

    public synchronized void dispose() {
        this.manager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this.axiomTranslator = null;
        this.classExpressionTranslator = null;
        this.dataRangeTranslator = null;
        this.objectPropertyTranslator = null;
        this.dataPropertyTranslator = null;
        this.individualTranslator = null;
        this.entailmentChecker = null;
        this.axiom2PtrMap.clear();
        this.ptr2AxiomMap.clear();
        this.rawChanges.clear();
        this.reasonerAxioms.clear();
        this.kernel.dispose();
    }

    public void dumpClassHierarchy(PrintStream printStream, boolean bl) {
        this.dumpSubClasses(this.getTopClassNode(), printStream, 0, bl);
    }

    private void dumpSubClasses(Node<OWLClass> node, PrintStream printStream, int n, boolean bl) {
        if (bl || !node.isBottomNode()) {
            for (int i = 0; i < n; ++i) {
                printStream.print("    ");
            }
            printStream.println(node);
            for (Node node2 : this.getSubClasses((OWLClassExpression)node.getRepresentativeElement(), true)) {
                this.dumpSubClasses((Node<OWLClass>)node2, printStream, n + 1, bl);
            }
        }
    }

    public NodePointer getRoot(OWLClassExpression oWLClassExpression) {
        return this.kernel.buildCompletionTree(this.toClassPointer(oWLClassExpression));
    }

    public Node<? extends OWLObjectPropertyExpression> getObjectNeighbours(NodePointer nodePointer, boolean bl) {
        return this.objectPropertyTranslator.getNodeFromPointers(this.kernel.getObjectNeighbours(nodePointer, bl));
    }

    public Node<OWLDataProperty> getDataNeighbours(NodePointer nodePointer, boolean bl) {
        return this.dataPropertyTranslator.getNodeFromPointers(this.kernel.getDataNeighbours(nodePointer, bl));
    }

    public Collection<NodePointer> getObjectNeighbours(NodePointer nodePointer, OWLObjectProperty oWLObjectProperty) {
        return Arrays.asList(this.kernel.getObjectNeighbours(nodePointer, this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectProperty)));
    }

    public Collection<NodePointer> getDataNeighbours(NodePointer nodePointer, OWLDataProperty oWLDataProperty) {
        return Arrays.asList(this.kernel.getDataNeighbours(nodePointer, this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataProperty)));
    }

    public Node<? extends OWLClassExpression> getObjectLabel(NodePointer nodePointer, boolean bl) {
        return this.classExpressionTranslator.getNodeFromPointers(this.kernel.getObjectLabel(nodePointer, bl));
    }

    public Node<? extends OWLDataRange> getDataLabel(NodePointer nodePointer, boolean bl) {
        return this.dataRangeTranslator.getNodeFromPointers(this.kernel.getDataLabel(nodePointer, bl));
    }

    public NodePointer getBlocker(NodePointer nodePointer) {
        return this.kernel.getBlocker(nodePointer);
    }

    private int getIndexByModuleType(ModuleType moduleType) {
        switch (moduleType) {
            case BOT: {
                return 0;
            }
            case TOP: {
                return 1;
            }
            case STAR: {
                return 2;
            }
        }
        throw new ReasonerInternalException("Unsupported module type");
    }

    private int getIndexByModuleMethod(ModuleMethod moduleMethod) {
        switch (moduleMethod) {
            case SYNTACTIC_STANDARD: {
                return 0;
            }
            case SYNTACTIC_COUNTING: {
                return 1;
            }
            case SEMANTIC: {
                return 2;
            }
        }
        throw new ReasonerInternalException("Unsupported module method");
    }

    public int getAtomicDecompositionSize(ModuleMethod moduleMethod, ModuleType moduleType) {
        int n = this.getIndexByModuleMethod(moduleMethod);
        int n2 = this.getIndexByModuleType(moduleType);
        return this.kernel.getAtomicDecompositionSize(n, n2);
    }

    public Set<OWLAxiom> getAtomAxioms(int n) {
        AxiomPointer[] axiomPointerArray = this.kernel.getAtomAxioms(n);
        return this.axiomsToSet(axiomPointerArray);
    }

    public Set<OWLAxiom> getAtomModule(int n) {
        AxiomPointer[] axiomPointerArray = this.kernel.getAtomModule(n);
        return this.axiomsToSet(axiomPointerArray);
    }

    private Set<OWLAxiom> axiomsToSet(AxiomPointer[] axiomPointerArray) {
        HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
        for (AxiomPointer axiomPointer : axiomPointerArray) {
            OWLAxiom oWLAxiom = this.ptr2AxiomMap.get(axiomPointer);
            if (oWLAxiom == null) continue;
            hashSet.add(oWLAxiom);
        }
        return hashSet;
    }

    public int[] getAtomDependents(int n) {
        return this.kernel.getAtomDependents(n);
    }

    public int getLocCheckNumber() {
        return this.kernel.getLocCheckNumber();
    }

    public Set<OWLAxiom> getModule(Set<OWLEntity> set, ModuleMethod moduleMethod, ModuleType moduleType) {
        this.kernel.initArgList();
        for (OWLEntity oWLEntity : set) {
            if (!(oWLEntity instanceof OWLLogicalEntity)) continue;
            this.kernel.addArg((Pointer)oWLEntity.accept((OWLEntityVisitorEx)this.entityTranslator));
        }
        int n = this.getIndexByModuleMethod(moduleMethod);
        int n2 = this.getIndexByModuleType(moduleType);
        AxiomPointer[] axiomPointerArray = this.kernel.getModule(n, n2);
        return this.axiomsToSet(axiomPointerArray);
    }

    public Set<OWLAxiom> getNonLocal(Set<OWLEntity> set, ModuleMethod moduleMethod, ModuleType moduleType) {
        this.kernel.initArgList();
        for (OWLEntity oWLEntity : set) {
            if (!(oWLEntity instanceof OWLLogicalEntity)) continue;
            this.kernel.addArg((Pointer)oWLEntity.accept((OWLEntityVisitorEx)this.entityTranslator));
        }
        int n = this.getIndexByModuleMethod(moduleMethod);
        int n2 = this.getIndexByModuleType(moduleType);
        AxiomPointer[] axiomPointerArray = this.kernel.getNonLocal(n, n2);
        return this.axiomsToSet(axiomPointerArray);
    }

    public boolean checkSaveLoadContext(String string) {
        return this.kernel.checkSaveLoadContext(string);
    }

    public boolean setSaveLoadContext(String string) {
        return this.kernel.setSaveLoadContext(string);
    }

    public boolean clearSaveLoadContext(String string) {
        return this.kernel.clearSaveLoadContext(string);
    }

    private final class EntityVisitorEx
    implements OWLEntityVisitorEx<Pointer> {
        private EntityVisitorEx() {
        }

        public Pointer visit(OWLClass oWLClass) {
            return FaCTPlusPlusReasoner.this.toClassPointer((OWLClassExpression)oWLClass);
        }

        public Pointer visit(OWLObjectProperty oWLObjectProperty) {
            return FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectProperty);
        }

        public Pointer visit(OWLDataProperty oWLDataProperty) {
            return FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataProperty);
        }

        public Pointer visit(OWLNamedIndividual oWLNamedIndividual) {
            return FaCTPlusPlusReasoner.this.toIndividualPointer((OWLIndividual)oWLNamedIndividual);
        }

        public Pointer visit(OWLDatatype oWLDatatype) {
            return null;
        }

        public Pointer visit(OWLAnnotationProperty oWLAnnotationProperty) {
            return null;
        }
    }

    private static class ProgressMonitorAdapter
    implements FaCTPlusPlusProgressMonitor {
        private int count = 0;
        private int total = 0;
        private final ReasonerProgressMonitor progressMonitor;
        private final AtomicBoolean interrupted;

        public ProgressMonitorAdapter(ReasonerProgressMonitor reasonerProgressMonitor, AtomicBoolean atomicBoolean) {
            this.progressMonitor = reasonerProgressMonitor;
            this.interrupted = atomicBoolean;
        }

        @Override
        public void setClassificationStarted(int n) {
            this.count = 0;
            this.total = n;
            this.progressMonitor.reasonerTaskStarted("Classifying");
            this.progressMonitor.reasonerTaskProgressChanged(this.count, n);
        }

        @Override
        public void nextClass() {
            ++this.count;
            this.progressMonitor.reasonerTaskProgressChanged(this.count, this.total);
        }

        @Override
        public void setFinished() {
            this.progressMonitor.reasonerTaskStopped();
        }

        @Override
        public boolean isCancelled() {
            if (this.interrupted.get()) {
                throw new ReasonerInterruptedException();
            }
            return false;
        }
    }

    private class EntailmentChecker
    implements OWLAxiomVisitorEx<Boolean> {
        public Boolean visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
            if (oWLSubClassOfAxiom.getSuperClass().equals(FaCTPlusPlusReasoner.this.getOWLDataFactory().getOWLThing())) {
                return true;
            }
            if (oWLSubClassOfAxiom.getSubClass().equals(FaCTPlusPlusReasoner.this.getOWLDataFactory().getOWLNothing())) {
                return true;
            }
            return FaCTPlusPlusReasoner.this.kernel.isClassSubsumedBy(FaCTPlusPlusReasoner.this.toClassPointer(oWLSubClassOfAxiom.getSubClass()), FaCTPlusPlusReasoner.this.toClassPointer(oWLSubClassOfAxiom.getSuperClass()));
        }

        public Boolean visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
            return (Boolean)oWLNegativeObjectPropertyAssertionAxiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isObjectPropertyAsymmetric(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLAsymmetricObjectPropertyAxiom.getProperty()));
        }

        public Boolean visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isObjectPropertyReflexive(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLReflexiveObjectPropertyAxiom.getProperty()));
        }

        public Boolean visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
            Set set = oWLDisjointClassesAxiom.getClassExpressions();
            if (set.size() == 2) {
                Iterator iterator = set.iterator();
                return FaCTPlusPlusReasoner.this.kernel.isClassDisjointWith(FaCTPlusPlusReasoner.this.toClassPointer((OWLClassExpression)iterator.next()), FaCTPlusPlusReasoner.this.toClassPointer((OWLClassExpression)iterator.next()));
            }
            for (OWLSubClassOfAxiom oWLSubClassOfAxiom : oWLDisjointClassesAxiom.asOWLSubClassOfAxioms()) {
                if (((Boolean)oWLSubClassOfAxiom.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
            return (Boolean)oWLDataPropertyDomainAxiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
            return (Boolean)oWLObjectPropertyDomainAxiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
            for (OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom : oWLEquivalentObjectPropertiesAxiom.asSubObjectPropertyOfAxioms()) {
                if (((Boolean)oWLSubObjectPropertyOfAxiom.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
            return (Boolean)oWLNegativeDataPropertyAssertionAxiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
            for (OWLSubClassOfAxiom oWLSubClassOfAxiom : oWLDifferentIndividualsAxiom.asOWLSubClassOfAxioms()) {
                if (((Boolean)oWLSubClassOfAxiom.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
            FaCTPlusPlusReasoner.this.kernel.initArgList();
            for (OWLDataPropertyExpression oWLDataPropertyExpression : oWLDisjointDataPropertiesAxiom.getProperties()) {
                FaCTPlusPlusReasoner.this.kernel.addArg(FaCTPlusPlusReasoner.this.toDataPropertyPointer(oWLDataPropertyExpression));
            }
            FaCTPlusPlusReasoner.this.kernel.closeArgList();
            return FaCTPlusPlusReasoner.this.kernel.arePropertiesDisjoint();
        }

        public Boolean visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
            FaCTPlusPlusReasoner.this.kernel.initArgList();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLDisjointObjectPropertiesAxiom.getProperties()) {
                FaCTPlusPlusReasoner.this.kernel.addArg(FaCTPlusPlusReasoner.this.toObjectPropertyPointer(oWLObjectPropertyExpression));
            }
            FaCTPlusPlusReasoner.this.kernel.closeArgList();
            return FaCTPlusPlusReasoner.this.kernel.arePropertiesDisjoint();
        }

        public Boolean visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
            return (Boolean)oWLObjectPropertyRangeAxiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
            return (Boolean)oWLObjectPropertyAssertionAxiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isObjectPropertyFunctional(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty()));
        }

        public Boolean visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isObjectSubPropertyOf(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty()), FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty()));
        }

        public Boolean visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
            return (Boolean)oWLDisjointUnionAxiom.getOWLEquivalentClassesAxiom().accept((OWLAxiomVisitorEx)this) != false && (Boolean)oWLDisjointUnionAxiom.getOWLDisjointClassesAxiom().accept((OWLAxiomVisitorEx)this) != false;
        }

        public Boolean visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
            return false;
        }

        public Boolean visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
            return false;
        }

        public Boolean visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isObjectPropertySymmetric(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()));
        }

        public Boolean visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
            return (Boolean)oWLDataPropertyRangeAxiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isDataPropertyFunctional(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLFunctionalDataPropertyAxiom.getProperty()));
        }

        public Boolean visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
            return null;
        }

        public Boolean visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isInstanceOf(FaCTPlusPlusReasoner.this.toIndividualPointer(oWLClassAssertionAxiom.getIndividual()), FaCTPlusPlusReasoner.this.toClassPointer(oWLClassAssertionAxiom.getClassExpression()));
        }

        public Boolean visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
            Set set = oWLEquivalentClassesAxiom.getClassExpressions();
            if (set.size() == 2) {
                Iterator iterator = set.iterator();
                return FaCTPlusPlusReasoner.this.kernel.isClassEquivalentTo(FaCTPlusPlusReasoner.this.toClassPointer((OWLClassExpression)iterator.next()), FaCTPlusPlusReasoner.this.toClassPointer((OWLClassExpression)iterator.next()));
            }
            for (OWLSubClassOfAxiom oWLSubClassOfAxiom : oWLEquivalentClassesAxiom.asOWLSubClassOfAxioms()) {
                if (((Boolean)oWLSubClassOfAxiom.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
            return (Boolean)oWLDataPropertyAssertionAxiom.asOWLSubClassOfAxiom().accept((OWLAxiomVisitorEx)this);
        }

        public Boolean visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isObjectPropertyTransitive(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty()));
        }

        public Boolean visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isObjectPropertyIrreflexive(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty()));
        }

        public Boolean visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isDataSubPropertyOf(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSubProperty()), FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSuperProperty()));
        }

        public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.isObjectPropertyInverseFunctional(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLInverseFunctionalObjectPropertyAxiom.getProperty()));
        }

        public Boolean visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
            for (OWLSameIndividualAxiom oWLSameIndividualAxiom2 : oWLSameIndividualAxiom.asPairwiseAxioms()) {
                Iterator iterator = oWLSameIndividualAxiom2.getIndividuals().iterator();
                OWLIndividual oWLIndividual = (OWLIndividual)iterator.next();
                OWLIndividual oWLIndividual2 = (OWLIndividual)iterator.next();
                if (FaCTPlusPlusReasoner.this.kernel.isSameAs(FaCTPlusPlusReasoner.this.toIndividualPointer(oWLIndividual), FaCTPlusPlusReasoner.this.toIndividualPointer(oWLIndividual2))) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
            FaCTPlusPlusReasoner.this.kernel.initArgList();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLSubPropertyChainOfAxiom.getPropertyChain()) {
                FaCTPlusPlusReasoner.this.kernel.addArg(FaCTPlusPlusReasoner.this.toObjectPropertyPointer(oWLObjectPropertyExpression));
            }
            FaCTPlusPlusReasoner.this.kernel.closeArgList();
            return FaCTPlusPlusReasoner.this.kernel.isSubPropertyChainOf(FaCTPlusPlusReasoner.this.toObjectPropertyPointer(oWLSubPropertyChainOfAxiom.getSuperProperty()));
        }

        public Boolean visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
            for (OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom : oWLInverseObjectPropertiesAxiom.asSubObjectPropertyOfAxioms()) {
                if (((Boolean)oWLSubObjectPropertyOfAxiom.accept((OWLAxiomVisitorEx)this)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public Boolean visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
            return null;
        }

        public Boolean visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
            return null;
        }

        public Boolean visit(SWRLRule sWRLRule) {
            return null;
        }

        public Boolean visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
            return false;
        }

        public Boolean visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
            return false;
        }

        public Boolean visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
            return false;
        }
    }

    private class AxiomTranslator
    implements OWLAxiomVisitorEx<AxiomPointer> {
        private final DeclarationVisitorEx v = new DeclarationVisitorEx();

        public AxiomPointer visit(OWLSubClassOfAxiom oWLSubClassOfAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellSubClassOf(FaCTPlusPlusReasoner.this.toClassPointer(oWLSubClassOfAxiom.getSubClass()), FaCTPlusPlusReasoner.this.toClassPointer(oWLSubClassOfAxiom.getSuperClass()));
        }

        public AxiomPointer visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellNotRelatedIndividuals(FaCTPlusPlusReasoner.this.toIndividualPointer(oWLNegativeObjectPropertyAssertionAxiom.getSubject()), FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty()), FaCTPlusPlusReasoner.this.toIndividualPointer((OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject()));
        }

        public AxiomPointer visit(OWLAsymmetricObjectPropertyAxiom oWLAsymmetricObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellAsymmetricObjectProperty(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLAsymmetricObjectPropertyAxiom.getProperty()));
        }

        public AxiomPointer visit(OWLReflexiveObjectPropertyAxiom oWLReflexiveObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellReflexiveObjectProperty(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLReflexiveObjectPropertyAxiom.getProperty()));
        }

        public AxiomPointer visit(OWLDisjointClassesAxiom oWLDisjointClassesAxiom) {
            this.translateClassExpressionSet(oWLDisjointClassesAxiom.getClassExpressions());
            return FaCTPlusPlusReasoner.this.kernel.tellDisjointClasses();
        }

        private void translateClassExpressionSet(Collection<OWLClassExpression> collection) {
            FaCTPlusPlusReasoner.this.kernel.initArgList();
            for (OWLClassExpression oWLClassExpression : collection) {
                ClassPointer classPointer = FaCTPlusPlusReasoner.this.toClassPointer(oWLClassExpression);
                FaCTPlusPlusReasoner.this.kernel.addArg(classPointer);
            }
            FaCTPlusPlusReasoner.this.kernel.closeArgList();
        }

        public AxiomPointer visit(OWLDataPropertyDomainAxiom oWLDataPropertyDomainAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellDataPropertyDomain(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataPropertyDomainAxiom.getProperty()), FaCTPlusPlusReasoner.this.toClassPointer(oWLDataPropertyDomainAxiom.getDomain()));
        }

        public AxiomPointer visit(OWLObjectPropertyDomainAxiom oWLObjectPropertyDomainAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellObjectPropertyDomain(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectPropertyDomainAxiom.getProperty()), FaCTPlusPlusReasoner.this.toClassPointer(oWLObjectPropertyDomainAxiom.getDomain()));
        }

        public AxiomPointer visit(OWLEquivalentObjectPropertiesAxiom oWLEquivalentObjectPropertiesAxiom) {
            this.translateObjectPropertySet(oWLEquivalentObjectPropertiesAxiom.getProperties());
            return FaCTPlusPlusReasoner.this.kernel.tellEquivalentObjectProperties();
        }

        private void translateObjectPropertySet(Collection<OWLObjectPropertyExpression> collection) {
            FaCTPlusPlusReasoner.this.kernel.initArgList();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : collection) {
                ObjectPropertyPointer objectPropertyPointer = FaCTPlusPlusReasoner.this.toObjectPropertyPointer(oWLObjectPropertyExpression);
                FaCTPlusPlusReasoner.this.kernel.addArg(objectPropertyPointer);
            }
            FaCTPlusPlusReasoner.this.kernel.closeArgList();
        }

        public AxiomPointer visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellNotRelatedIndividualValue(FaCTPlusPlusReasoner.this.toIndividualPointer(oWLNegativeDataPropertyAssertionAxiom.getSubject()), FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty()), FaCTPlusPlusReasoner.this.toDataValuePointer((OWLLiteral)oWLNegativeDataPropertyAssertionAxiom.getObject()));
        }

        public AxiomPointer visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
            FaCTPlusPlusReasoner.this.translateIndividualSet(oWLDifferentIndividualsAxiom.getIndividuals());
            return FaCTPlusPlusReasoner.this.kernel.tellDifferentIndividuals();
        }

        public AxiomPointer visit(OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom) {
            this.translateDataPropertySet(oWLDisjointDataPropertiesAxiom.getProperties());
            return FaCTPlusPlusReasoner.this.kernel.tellDisjointDataProperties();
        }

        private void translateDataPropertySet(Set<OWLDataPropertyExpression> set) {
            FaCTPlusPlusReasoner.this.kernel.initArgList();
            for (OWLDataPropertyExpression oWLDataPropertyExpression : set) {
                DataPropertyPointer dataPropertyPointer = FaCTPlusPlusReasoner.this.toDataPropertyPointer(oWLDataPropertyExpression);
                FaCTPlusPlusReasoner.this.kernel.addArg(dataPropertyPointer);
            }
            FaCTPlusPlusReasoner.this.kernel.closeArgList();
        }

        public AxiomPointer visit(OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom) {
            this.translateObjectPropertySet(oWLDisjointObjectPropertiesAxiom.getProperties());
            return FaCTPlusPlusReasoner.this.kernel.tellDisjointObjectProperties();
        }

        public AxiomPointer visit(OWLObjectPropertyRangeAxiom oWLObjectPropertyRangeAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellObjectPropertyRange(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectPropertyRangeAxiom.getProperty()), FaCTPlusPlusReasoner.this.toClassPointer((OWLClassExpression)oWLObjectPropertyRangeAxiom.getRange()));
        }

        public AxiomPointer visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellRelatedIndividuals(FaCTPlusPlusReasoner.this.toIndividualPointer(oWLObjectPropertyAssertionAxiom.getSubject()), FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty()), FaCTPlusPlusReasoner.this.toIndividualPointer((OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject()));
        }

        public AxiomPointer visit(OWLFunctionalObjectPropertyAxiom oWLFunctionalObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellFunctionalObjectProperty(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLFunctionalObjectPropertyAxiom.getProperty()));
        }

        public AxiomPointer visit(OWLSubObjectPropertyOfAxiom oWLSubObjectPropertyOfAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellSubObjectProperties(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSubProperty()), FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLSubObjectPropertyOfAxiom.getSuperProperty()));
        }

        public AxiomPointer visit(OWLDisjointUnionAxiom oWLDisjointUnionAxiom) {
            this.translateClassExpressionSet(oWLDisjointUnionAxiom.getClassExpressions());
            return FaCTPlusPlusReasoner.this.kernel.tellDisjointUnion(FaCTPlusPlusReasoner.this.toClassPointer((OWLClassExpression)oWLDisjointUnionAxiom.getOWLClass()));
        }

        public AxiomPointer visit(OWLDeclarationAxiom oWLDeclarationAxiom) {
            OWLEntity oWLEntity = oWLDeclarationAxiom.getEntity();
            return (AxiomPointer)oWLEntity.accept((OWLEntityVisitorEx)this.v);
        }

        public AxiomPointer visit(OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom) {
            return null;
        }

        public AxiomPointer visit(OWLSymmetricObjectPropertyAxiom oWLSymmetricObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellSymmetricObjectProperty(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLSymmetricObjectPropertyAxiom.getProperty()));
        }

        public AxiomPointer visit(OWLDataPropertyRangeAxiom oWLDataPropertyRangeAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellDataPropertyRange(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataPropertyRangeAxiom.getProperty()), FaCTPlusPlusReasoner.this.toDataTypeExpressionPointer((OWLDataRange)oWLDataPropertyRangeAxiom.getRange()));
        }

        public AxiomPointer visit(OWLFunctionalDataPropertyAxiom oWLFunctionalDataPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellFunctionalDataProperty(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLFunctionalDataPropertyAxiom.getProperty()));
        }

        public AxiomPointer visit(OWLEquivalentDataPropertiesAxiom oWLEquivalentDataPropertiesAxiom) {
            this.translateDataPropertySet(oWLEquivalentDataPropertiesAxiom.getProperties());
            return FaCTPlusPlusReasoner.this.kernel.tellEquivalentDataProperties();
        }

        public AxiomPointer visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellIndividualType(FaCTPlusPlusReasoner.this.toIndividualPointer(oWLClassAssertionAxiom.getIndividual()), FaCTPlusPlusReasoner.this.toClassPointer(oWLClassAssertionAxiom.getClassExpression()));
        }

        public AxiomPointer visit(OWLEquivalentClassesAxiom oWLEquivalentClassesAxiom) {
            this.translateClassExpressionSet(oWLEquivalentClassesAxiom.getClassExpressions());
            return FaCTPlusPlusReasoner.this.kernel.tellEquivalentClass();
        }

        public AxiomPointer visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellRelatedIndividualValue(FaCTPlusPlusReasoner.this.toIndividualPointer(oWLDataPropertyAssertionAxiom.getSubject()), FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty()), FaCTPlusPlusReasoner.this.toDataValuePointer((OWLLiteral)oWLDataPropertyAssertionAxiom.getObject()));
        }

        public AxiomPointer visit(OWLTransitiveObjectPropertyAxiom oWLTransitiveObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellTransitiveObjectProperty(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLTransitiveObjectPropertyAxiom.getProperty()));
        }

        public AxiomPointer visit(OWLIrreflexiveObjectPropertyAxiom oWLIrreflexiveObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellIrreflexiveObjectProperty(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLIrreflexiveObjectPropertyAxiom.getProperty()));
        }

        public AxiomPointer visit(OWLSubDataPropertyOfAxiom oWLSubDataPropertyOfAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellSubDataProperties(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSubProperty()), FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLSubDataPropertyOfAxiom.getSuperProperty()));
        }

        public AxiomPointer visit(OWLInverseFunctionalObjectPropertyAxiom oWLInverseFunctionalObjectPropertyAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellInverseFunctionalObjectProperty(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLInverseFunctionalObjectPropertyAxiom.getProperty()));
        }

        public AxiomPointer visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
            FaCTPlusPlusReasoner.this.translateIndividualSet(oWLSameIndividualAxiom.getIndividuals());
            return FaCTPlusPlusReasoner.this.kernel.tellSameIndividuals();
        }

        public AxiomPointer visit(OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom) {
            this.translateObjectPropertySet(oWLSubPropertyChainOfAxiom.getPropertyChain());
            return FaCTPlusPlusReasoner.this.kernel.tellSubObjectProperties(FaCTPlusPlusReasoner.this.kernel.getPropertyComposition(), FaCTPlusPlusReasoner.this.toObjectPropertyPointer(oWLSubPropertyChainOfAxiom.getSuperProperty()));
        }

        public AxiomPointer visit(OWLInverseObjectPropertiesAxiom oWLInverseObjectPropertiesAxiom) {
            return FaCTPlusPlusReasoner.this.kernel.tellInverseProperties(FaCTPlusPlusReasoner.this.toObjectPropertyPointer(oWLInverseObjectPropertiesAxiom.getFirstProperty()), FaCTPlusPlusReasoner.this.toObjectPropertyPointer(oWLInverseObjectPropertiesAxiom.getSecondProperty()));
        }

        public AxiomPointer visit(OWLHasKeyAxiom oWLHasKeyAxiom) {
            this.translateObjectPropertySet(oWLHasKeyAxiom.getObjectPropertyExpressions());
            ObjectPropertyPointer objectPropertyPointer = FaCTPlusPlusReasoner.this.kernel.getObjectPropertyKey();
            this.translateDataPropertySet(oWLHasKeyAxiom.getDataPropertyExpressions());
            DataPropertyPointer dataPropertyPointer = FaCTPlusPlusReasoner.this.kernel.getDataPropertyKey();
            return FaCTPlusPlusReasoner.this.kernel.tellHasKey(FaCTPlusPlusReasoner.this.toClassPointer(oWLHasKeyAxiom.getClassExpression()), dataPropertyPointer, objectPropertyPointer);
        }

        public AxiomPointer visit(OWLDatatypeDefinitionAxiom oWLDatatypeDefinitionAxiom) {
            FaCTPlusPlusReasoner.this.kernel.getDataSubType(oWLDatatypeDefinitionAxiom.getDatatype().getIRI().toString(), FaCTPlusPlusReasoner.this.toDataTypeExpressionPointer(oWLDatatypeDefinitionAxiom.getDataRange()));
            return null;
        }

        public AxiomPointer visit(SWRLRule sWRLRule) {
            return null;
        }

        public AxiomPointer visit(OWLSubAnnotationPropertyOfAxiom oWLSubAnnotationPropertyOfAxiom) {
            return null;
        }

        public AxiomPointer visit(OWLAnnotationPropertyDomainAxiom oWLAnnotationPropertyDomainAxiom) {
            return null;
        }

        public AxiomPointer visit(OWLAnnotationPropertyRangeAxiom oWLAnnotationPropertyRangeAxiom) {
            return null;
        }

        private final class DeclarationVisitorEx
        implements OWLEntityVisitorEx<AxiomPointer> {
            private DeclarationVisitorEx() {
            }

            public AxiomPointer visit(OWLClass oWLClass) {
                return FaCTPlusPlusReasoner.this.kernel.tellClassDeclaration(FaCTPlusPlusReasoner.this.toClassPointer((OWLClassExpression)oWLClass));
            }

            public AxiomPointer visit(OWLObjectProperty oWLObjectProperty) {
                return FaCTPlusPlusReasoner.this.kernel.tellObjectPropertyDeclaration(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectProperty));
            }

            public AxiomPointer visit(OWLDataProperty oWLDataProperty) {
                return FaCTPlusPlusReasoner.this.kernel.tellDataPropertyDeclaration(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataProperty));
            }

            public AxiomPointer visit(OWLNamedIndividual oWLNamedIndividual) {
                return FaCTPlusPlusReasoner.this.kernel.tellIndividualDeclaration(FaCTPlusPlusReasoner.this.toIndividualPointer((OWLIndividual)oWLNamedIndividual));
            }

            public AxiomPointer visit(OWLDatatype oWLDatatype) {
                return FaCTPlusPlusReasoner.this.kernel.tellDatatypeDeclaration(FaCTPlusPlusReasoner.this.toDataTypePointer(oWLDatatype));
            }

            public AxiomPointer visit(OWLAnnotationProperty oWLAnnotationProperty) {
                return null;
            }
        }
    }

    private class DataPropertyTranslator
    extends OWLEntityTranslator<OWLDataProperty, DataPropertyPointer> {
        @Override
        protected DataPropertyPointer getTopEntityPointer() {
            return FaCTPlusPlusReasoner.this.kernel.getTopDataProperty();
        }

        @Override
        protected DataPropertyPointer getBottomEntityPointer() {
            return FaCTPlusPlusReasoner.this.kernel.getBottomDataProperty();
        }

        @Override
        protected DataPropertyPointer createPointerForEntity(OWLDataProperty oWLDataProperty) {
            return FaCTPlusPlusReasoner.this.kernel.getDataProperty(oWLDataProperty.toStringID());
        }

        @Override
        protected OWLDataProperty getTopEntity() {
            return FaCTPlusPlusReasoner.this.getOWLDataFactory().getOWLTopDataProperty();
        }

        @Override
        protected OWLDataProperty getBottomEntity() {
            return FaCTPlusPlusReasoner.this.getOWLDataFactory().getOWLBottomDataProperty();
        }

        @Override
        protected DefaultNode<OWLDataProperty> createDefaultNode() {
            return new OWLDataPropertyNode();
        }

        @Override
        protected DefaultNodeSet<OWLDataProperty> createDefaultNodeSet() {
            return new OWLDataPropertyNodeSet();
        }
    }

    private class ObjectPropertyTranslator
    extends OWLEntityTranslator<OWLObjectPropertyExpression, ObjectPropertyPointer> {
        @Override
        protected ObjectPropertyPointer getTopEntityPointer() {
            return FaCTPlusPlusReasoner.this.kernel.getTopObjectProperty();
        }

        @Override
        protected ObjectPropertyPointer getBottomEntityPointer() {
            return FaCTPlusPlusReasoner.this.kernel.getBottomObjectProperty();
        }

        @Override
        protected ObjectPropertyPointer registerNewEntity(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
            ObjectPropertyPointer objectPropertyPointer = this.createPointerForEntity(oWLObjectPropertyExpression);
            this.fillEntityPointerMaps(oWLObjectPropertyExpression, objectPropertyPointer);
            oWLObjectPropertyExpression = oWLObjectPropertyExpression.getInverseProperty().getSimplified();
            this.fillEntityPointerMaps(oWLObjectPropertyExpression, this.createPointerForEntity(oWLObjectPropertyExpression));
            return objectPropertyPointer;
        }

        @Override
        protected ObjectPropertyPointer createPointerForEntity(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
            ObjectPropertyPointer objectPropertyPointer = FaCTPlusPlusReasoner.this.kernel.getObjectProperty(oWLObjectPropertyExpression.getNamedProperty().toStringID());
            if (oWLObjectPropertyExpression.isAnonymous()) {
                objectPropertyPointer = FaCTPlusPlusReasoner.this.kernel.getInverseProperty(objectPropertyPointer);
            }
            return objectPropertyPointer;
        }

        @Override
        protected OWLObjectProperty getTopEntity() {
            return FaCTPlusPlusReasoner.this.getOWLDataFactory().getOWLTopObjectProperty();
        }

        @Override
        protected OWLObjectProperty getBottomEntity() {
            return FaCTPlusPlusReasoner.this.getOWLDataFactory().getOWLBottomObjectProperty();
        }

        @Override
        protected DefaultNode<OWLObjectPropertyExpression> createDefaultNode() {
            return new OWLObjectPropertyNode();
        }

        @Override
        protected DefaultNodeSet<OWLObjectPropertyExpression> createDefaultNodeSet() {
            return new OWLObjectPropertyNodeSet();
        }
    }

    private class IndividualTranslator
    extends OWLEntityTranslator<OWLNamedIndividual, IndividualPointer> {
        @Override
        protected IndividualPointer getTopEntityPointer() {
            return null;
        }

        @Override
        protected IndividualPointer getBottomEntityPointer() {
            return null;
        }

        @Override
        protected IndividualPointer createPointerForEntity(OWLNamedIndividual oWLNamedIndividual) {
            return FaCTPlusPlusReasoner.this.kernel.getIndividual(oWLNamedIndividual.toStringID());
        }

        @Override
        protected OWLNamedIndividual getTopEntity() {
            return null;
        }

        @Override
        protected OWLNamedIndividual getBottomEntity() {
            return null;
        }

        @Override
        protected DefaultNode<OWLNamedIndividual> createDefaultNode() {
            return new OWLNamedIndividualNode();
        }

        @Override
        protected DefaultNodeSet<OWLNamedIndividual> createDefaultNodeSet() {
            return new OWLNamedIndividualNodeSet();
        }
    }

    private class DataRangeTranslator
    extends OWLEntityTranslator<OWLDatatype, DataTypePointer>
    implements OWLDataRangeVisitorEx<DataTypeExpressionPointer> {
        @Override
        protected DataTypePointer getTopEntityPointer() {
            return FaCTPlusPlusReasoner.this.kernel.getDataTop();
        }

        @Override
        protected DataTypePointer getBottomEntityPointer() {
            return null;
        }

        @Override
        protected DefaultNode<OWLDatatype> createDefaultNode() {
            return new OWLDatatypeNode();
        }

        @Override
        protected OWLDatatype getTopEntity() {
            return FaCTPlusPlusReasoner.this.getOWLDataFactory().getTopDatatype();
        }

        @Override
        protected OWLDatatype getBottomEntity() {
            return null;
        }

        @Override
        protected DefaultNodeSet<OWLDatatype> createDefaultNodeSet() {
            return new OWLDatatypeNodeSet();
        }

        @Override
        protected DataTypePointer createPointerForEntity(OWLDatatype oWLDatatype) {
            return FaCTPlusPlusReasoner.this.kernel.getBuiltInDataType(FaCTPlusPlusReasoner.checkDateTime(oWLDatatype));
        }

        public DataTypeExpressionPointer visit(OWLDatatype oWLDatatype) {
            return FaCTPlusPlusReasoner.this.kernel.getBuiltInDataType(FaCTPlusPlusReasoner.checkDateTime(oWLDatatype));
        }

        public DataTypeExpressionPointer visit(OWLDataOneOf oWLDataOneOf) {
            FaCTPlusPlusReasoner.this.kernel.initArgList();
            for (OWLLiteral oWLLiteral : oWLDataOneOf.getValues()) {
                DataValuePointer dataValuePointer = FaCTPlusPlusReasoner.this.toDataValuePointer(oWLLiteral);
                FaCTPlusPlusReasoner.this.kernel.addArg(dataValuePointer);
            }
            FaCTPlusPlusReasoner.this.kernel.closeArgList();
            return FaCTPlusPlusReasoner.this.kernel.getDataEnumeration();
        }

        public DataTypeExpressionPointer visit(OWLDataComplementOf oWLDataComplementOf) {
            return FaCTPlusPlusReasoner.this.kernel.getDataNot((DataTypeExpressionPointer)oWLDataComplementOf.getDataRange().accept((OWLDataRangeVisitorEx)this));
        }

        public DataTypeExpressionPointer visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
            this.translateDataRangeSet(oWLDataIntersectionOf.getOperands());
            return FaCTPlusPlusReasoner.this.kernel.getDataIntersectionOf();
        }

        private void translateDataRangeSet(Set<OWLDataRange> set) {
            FaCTPlusPlusReasoner.this.kernel.initArgList();
            for (OWLDataRange oWLDataRange : set) {
                DataTypeExpressionPointer dataTypeExpressionPointer = (DataTypeExpressionPointer)oWLDataRange.accept((OWLDataRangeVisitorEx)this);
                FaCTPlusPlusReasoner.this.kernel.addArg(dataTypeExpressionPointer);
            }
            FaCTPlusPlusReasoner.this.kernel.closeArgList();
        }

        public DataTypeExpressionPointer visit(OWLDataUnionOf oWLDataUnionOf) {
            this.translateDataRangeSet(oWLDataUnionOf.getOperands());
            return FaCTPlusPlusReasoner.this.kernel.getDataUnionOf();
        }

        public DataTypeExpressionPointer visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
            DataTypeExpressionPointer dataTypeExpressionPointer = (DataTypeExpressionPointer)oWLDatatypeRestriction.getDatatype().accept((OWLDataRangeVisitorEx)this);
            for (OWLFacetRestriction oWLFacetRestriction : oWLDatatypeRestriction.getFacetRestrictions()) {
                DataTypeFacet dataTypeFacet;
                DataValuePointer dataValuePointer = FaCTPlusPlusReasoner.this.toDataValuePointer(oWLFacetRestriction.getFacetValue());
                if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.MIN_INCLUSIVE)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getMinInclusiveFacet(dataValuePointer);
                } else if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.MAX_INCLUSIVE)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getMaxInclusiveFacet(dataValuePointer);
                } else if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.MIN_EXCLUSIVE)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getMinExclusiveFacet(dataValuePointer);
                } else if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.MAX_EXCLUSIVE)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getMaxExclusiveFacet(dataValuePointer);
                } else if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.LENGTH)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getLength(dataValuePointer);
                } else if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.MIN_LENGTH)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getMinLength(dataValuePointer);
                } else if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.MAX_LENGTH)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getMaxLength(dataValuePointer);
                } else if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.FRACTION_DIGITS)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getFractionDigitsFacet(dataValuePointer);
                } else if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.PATTERN)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getPattern(dataValuePointer);
                } else if (oWLFacetRestriction.getFacet().equals((Object)OWLFacet.TOTAL_DIGITS)) {
                    dataTypeFacet = FaCTPlusPlusReasoner.this.kernel.getTotalDigitsFacet(dataValuePointer);
                } else {
                    throw new OWLRuntimeException("Unsupported facet: " + oWLFacetRestriction.getFacet());
                }
                dataTypeExpressionPointer = FaCTPlusPlusReasoner.this.kernel.getRestrictedDataType(dataTypeExpressionPointer, dataTypeFacet);
            }
            return dataTypeExpressionPointer;
        }
    }

    private class ClassExpressionTranslator
    extends OWLEntityTranslator<OWLClass, ClassPointer>
    implements OWLClassExpressionVisitorEx<ClassPointer> {
        @Override
        protected ClassPointer getTopEntityPointer() {
            return FaCTPlusPlusReasoner.this.kernel.getThing();
        }

        @Override
        protected ClassPointer getBottomEntityPointer() {
            return FaCTPlusPlusReasoner.this.kernel.getNothing();
        }

        @Override
        protected OWLClass getTopEntity() {
            return FaCTPlusPlusReasoner.this.getOWLDataFactory().getOWLThing();
        }

        @Override
        protected OWLClass getBottomEntity() {
            return FaCTPlusPlusReasoner.this.getOWLDataFactory().getOWLNothing();
        }

        @Override
        protected ClassPointer createPointerForEntity(OWLClass oWLClass) {
            return FaCTPlusPlusReasoner.this.kernel.getNamedClass(oWLClass.toStringID());
        }

        @Override
        protected DefaultNode<OWLClass> createDefaultNode() {
            return new OWLClassNode();
        }

        @Override
        protected DefaultNodeSet<OWLClass> createDefaultNodeSet() {
            return new OWLClassNodeSet();
        }

        public ClassPointer visit(OWLClass oWLClass) {
            return (ClassPointer)this.getPointerFromEntity(oWLClass);
        }

        public ClassPointer visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
            this.translateClassExpressionSet(oWLObjectIntersectionOf.getOperands());
            return FaCTPlusPlusReasoner.this.kernel.getConceptAnd();
        }

        private void translateClassExpressionSet(Set<OWLClassExpression> set) {
            FaCTPlusPlusReasoner.this.kernel.initArgList();
            for (OWLClassExpression oWLClassExpression : set) {
                ClassPointer classPointer = (ClassPointer)oWLClassExpression.accept((OWLClassExpressionVisitorEx)this);
                FaCTPlusPlusReasoner.this.kernel.addArg(classPointer);
            }
            FaCTPlusPlusReasoner.this.kernel.closeArgList();
        }

        public ClassPointer visit(OWLObjectUnionOf oWLObjectUnionOf) {
            this.translateClassExpressionSet(oWLObjectUnionOf.getOperands());
            return FaCTPlusPlusReasoner.this.kernel.getConceptOr();
        }

        public ClassPointer visit(OWLObjectComplementOf oWLObjectComplementOf) {
            return FaCTPlusPlusReasoner.this.kernel.getConceptNot((ClassPointer)oWLObjectComplementOf.getOperand().accept((OWLClassExpressionVisitorEx)this));
        }

        public ClassPointer visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
            return FaCTPlusPlusReasoner.this.kernel.getObjectSome(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty()), (ClassPointer)((OWLClassExpression)oWLObjectSomeValuesFrom.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ClassPointer visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
            return FaCTPlusPlusReasoner.this.kernel.getObjectAll(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectAllValuesFrom.getProperty()), (ClassPointer)((OWLClassExpression)oWLObjectAllValuesFrom.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ClassPointer visit(OWLObjectHasValue oWLObjectHasValue) {
            return FaCTPlusPlusReasoner.this.kernel.getObjectValue(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectHasValue.getProperty()), FaCTPlusPlusReasoner.this.toIndividualPointer((OWLIndividual)oWLObjectHasValue.getValue()));
        }

        public ClassPointer visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
            return FaCTPlusPlusReasoner.this.kernel.getObjectAtLeast(oWLObjectMinCardinality.getCardinality(), FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty()), (ClassPointer)((OWLClassExpression)oWLObjectMinCardinality.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ClassPointer visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
            return FaCTPlusPlusReasoner.this.kernel.getObjectExact(oWLObjectExactCardinality.getCardinality(), FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty()), (ClassPointer)((OWLClassExpression)oWLObjectExactCardinality.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ClassPointer visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
            return FaCTPlusPlusReasoner.this.kernel.getObjectAtMost(oWLObjectMaxCardinality.getCardinality(), FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty()), (ClassPointer)((OWLClassExpression)oWLObjectMaxCardinality.getFiller()).accept((OWLClassExpressionVisitorEx)this));
        }

        public ClassPointer visit(OWLObjectHasSelf oWLObjectHasSelf) {
            return FaCTPlusPlusReasoner.this.kernel.getSelf(FaCTPlusPlusReasoner.this.toObjectPropertyPointer((OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty()));
        }

        public ClassPointer visit(OWLObjectOneOf oWLObjectOneOf) {
            FaCTPlusPlusReasoner.this.translateIndividualSet(oWLObjectOneOf.getIndividuals());
            return FaCTPlusPlusReasoner.this.kernel.getOneOf();
        }

        public ClassPointer visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
            return FaCTPlusPlusReasoner.this.kernel.getDataSome(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty()), FaCTPlusPlusReasoner.this.toDataTypeExpressionPointer((OWLDataRange)oWLDataSomeValuesFrom.getFiller()));
        }

        public ClassPointer visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
            return FaCTPlusPlusReasoner.this.kernel.getDataAll(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataAllValuesFrom.getProperty()), FaCTPlusPlusReasoner.this.toDataTypeExpressionPointer((OWLDataRange)oWLDataAllValuesFrom.getFiller()));
        }

        public ClassPointer visit(OWLDataHasValue oWLDataHasValue) {
            return FaCTPlusPlusReasoner.this.kernel.getDataValue(FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataHasValue.getProperty()), FaCTPlusPlusReasoner.this.toDataValuePointer((OWLLiteral)oWLDataHasValue.getValue()));
        }

        public ClassPointer visit(OWLDataMinCardinality oWLDataMinCardinality) {
            return FaCTPlusPlusReasoner.this.kernel.getDataAtLeast(oWLDataMinCardinality.getCardinality(), FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataMinCardinality.getProperty()), FaCTPlusPlusReasoner.this.toDataTypeExpressionPointer((OWLDataRange)oWLDataMinCardinality.getFiller()));
        }

        public ClassPointer visit(OWLDataExactCardinality oWLDataExactCardinality) {
            return FaCTPlusPlusReasoner.this.kernel.getDataExact(oWLDataExactCardinality.getCardinality(), FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataExactCardinality.getProperty()), FaCTPlusPlusReasoner.this.toDataTypeExpressionPointer((OWLDataRange)oWLDataExactCardinality.getFiller()));
        }

        public ClassPointer visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
            return FaCTPlusPlusReasoner.this.kernel.getDataAtMost(oWLDataMaxCardinality.getCardinality(), FaCTPlusPlusReasoner.this.toDataPropertyPointer((OWLDataPropertyExpression)oWLDataMaxCardinality.getProperty()), FaCTPlusPlusReasoner.this.toDataTypeExpressionPointer((OWLDataRange)oWLDataMaxCardinality.getFiller()));
        }
    }

    private abstract class OWLEntityTranslator<E extends OWLObject, P extends Pointer> {
        private final Map<E, P> entity2PointerMap = new ConcurrentHashMap<E, P>();
        protected final Map<P, E> pointer2EntityMap = new ConcurrentHashMap<P, E>();

        protected void fillEntityPointerMaps(E e, P p) {
            this.entity2PointerMap.put(e, p);
            this.pointer2EntityMap.put(p, e);
        }

        protected OWLEntityTranslator() {
            E e;
            E e2 = this.getTopEntity();
            if (e2 != null) {
                this.fillEntityPointerMaps(e2, this.getTopEntityPointer());
            }
            if ((e = this.getBottomEntity()) != null) {
                this.fillEntityPointerMaps(e, this.getBottomEntityPointer());
            }
        }

        protected P registerNewEntity(E e) {
            P p = this.createPointerForEntity(e);
            this.fillEntityPointerMaps(e, p);
            return p;
        }

        public E getEntityFromPointer(P p) {
            return (E)((OWLObject)this.pointer2EntityMap.get(p));
        }

        public P getPointerFromEntity(E e) {
            if (e.isTopEntity()) {
                return this.getTopEntityPointer();
            }
            if (e.isBottomEntity()) {
                return this.getBottomEntityPointer();
            }
            Pointer pointer = (Pointer)this.entity2PointerMap.get(e);
            if (pointer == null) {
                pointer = this.registerNewEntity(e);
            }
            return (P)pointer;
        }

        public Node<E> getNodeFromPointers(P[] PArray) {
            DefaultNode<E> defaultNode = this.createDefaultNode();
            for (P p : PArray) {
                E e = this.getEntityFromPointer(p);
                if (e == null) continue;
                defaultNode.add(e);
            }
            return defaultNode;
        }

        public NodeSet<E> getNodeSetFromPointers(P[][] PArray) {
            DefaultNodeSet<E> defaultNodeSet = this.createDefaultNodeSet();
            for (P[] PArray2 : PArray) {
                defaultNodeSet.addNode(this.getNodeFromPointers((Pointer[])PArray2));
            }
            return defaultNodeSet;
        }

        protected abstract DefaultNode<E> createDefaultNode();

        protected abstract DefaultNodeSet<E> createDefaultNodeSet();

        protected abstract P getTopEntityPointer();

        protected abstract P getBottomEntityPointer();

        protected abstract P createPointerForEntity(E var1);

        protected abstract E getTopEntity();

        protected abstract E getBottomEntity();
    }
}

