/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.semanticweb.owlapi.annotations.HasPriority;
import org.semanticweb.owlapi.formats.RioRDFDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.rio.RioMemoryTripleSource;
import org.semanticweb.owlapi.rio.RioOWLRDFConsumerAdapter;
import org.semanticweb.owlapi.rio.RioParser;
import org.semanticweb.owlapi.util.AnonymousNodeChecker;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HasPriority(value=7.0)
public class RioParserImpl
extends AbstractOWLParser
implements RioParser {
    private static final long serialVersionUID = 40000L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(RioParserImpl.class);
    @Nonnull
    private final RioRDFDocumentFormatFactory owlFormatFactory;

    public RioParserImpl(@Nonnull RioRDFDocumentFormatFactory nextFormat) {
        this.owlFormatFactory = OWLAPIPreconditions.checkNotNull(nextFormat, "nextFormat cannot be null");
    }

    @Override
    @Nonnull
    public RioRDFDocumentFormatFactory getSupportedFormat() {
        return this.owlFormatFactory;
    }

    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        try {
            RioOWLRDFConsumerAdapter consumer = new RioOWLRDFConsumerAdapter(ontology, new AnonymousNodeChecker(){

                @Override
                public boolean isAnonymousNode(IRI iri) {
                    if (iri.toString().startsWith("_:") || iri.toString().contains("genid")) {
                        LOGGER.trace("isAnonymousNode(IRI {})", (Object)iri);
                        return true;
                    }
                    LOGGER.trace("NOT isAnonymousNode(IRI {})", (Object)iri);
                    return false;
                }

                @Override
                public boolean isAnonymousNode(String iri) {
                    if (iri.startsWith("_:") || iri.contains("genid")) {
                        LOGGER.trace("isAnonymousNode(String {})", (Object)iri);
                        return true;
                    }
                    LOGGER.trace("NOT isAnonymousNode(String {})", (Object)iri);
                    return false;
                }

                @Override
                public boolean isAnonymousSharedNode(String iri) {
                    if (iri.startsWith("_:") || iri.contains("genid")) {
                        LOGGER.trace("isAnonymousSharedNode(String {})", (Object)iri);
                        return true;
                    }
                    LOGGER.trace("NOT isAnonymousSharedNode(String {})", (Object)iri);
                    return false;
                }
            }, configuration);
            consumer.setOntologyFormat(this.owlFormatFactory.createFormat());
            String baseUri = "urn:default:baseUri:";
            baseUri = !ontology.getOntologyID().isAnonymous() && ontology.getOntologyID().getDefaultDocumentIRI().isPresent() ? ((IRI)ontology.getOntologyID().getDefaultDocumentIRI().get()).toString() : documentSource.getDocumentIRI().toString();
            RioParserRDFHandler handler = new RioParserRDFHandler(consumer);
            if (documentSource instanceof RioMemoryTripleSource) {
                RioMemoryTripleSource tripleSource = (RioMemoryTripleSource)documentSource;
                Map<String, String> namespaces = tripleSource.getNamespaces();
                Iterator<Statement> statementsIterator = tripleSource.getStatementIterator();
                handler.startRDF();
                for (Map.Entry<String, String> nextNamespace : namespaces.entrySet()) {
                    handler.handleNamespace(nextNamespace.getKey(), nextNamespace.getValue());
                }
                while (statementsIterator.hasNext()) {
                    handler.handleStatement(statementsIterator.next());
                }
                handler.endRDF();
            } else {
                this.parseDocumentSource(documentSource, baseUri, handler);
            }
            return consumer.getOntologyFormat();
        }
        catch (RDFParseException e) {
            throw new OWLParserException(e);
        }
        catch (RDFHandlerException e) {
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof UnloadableImportException) {
                throw (UnloadableImportException)e.getCause().getCause();
            }
            throw new OWLParserException(e);
        }
        catch (UnsupportedRDFormatException e) {
            throw new OWLParserException(e);
        }
        catch (MalformedURLException e) {
            throw new OWLParserException(e);
        }
    }

    protected void parseDocumentSource(OWLOntologyDocumentSource documentSource, String baseUri, RDFHandler handler) throws IOException, RDFParseException, RDFHandlerException {
        RDFParser createParser = Rio.createParser((RDFFormat)this.owlFormatFactory.getRioFormat());
        createParser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        createParser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        createParser.setRDFHandler(handler);
        long rioParseStart = System.currentTimeMillis();
        if (this.owlFormatFactory.isTextual() && documentSource.isReaderAvailable()) {
            createParser.parse(documentSource.getReader(), baseUri);
        } else if (documentSource.isInputStreamAvailable()) {
            createParser.parse(documentSource.getInputStream(), baseUri);
        } else {
            URL url = URI.create(documentSource.getDocumentIRI().toString()).toURL();
            URLConnection conn = url.openConnection();
            createParser.parse(conn.getInputStream(), baseUri);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("rioParse: timing={}", (Object)(System.currentTimeMillis() - rioParseStart));
        }
    }

    public String toString() {
        return this.getClass().getName() + " : " + this.owlFormatFactory;
    }

    private static class RioParserRDFHandler
    implements RDFHandler {
        private static final Logger LOG = LoggerFactory.getLogger(RioParserRDFHandler.class);
        private final RDFHandler consumer;
        private long owlParseStart;
        private final Set<Resource> typedLists = new HashSet<Resource>();
        private final ValueFactory vf = ValueFactoryImpl.getInstance();

        RioParserRDFHandler(RDFHandler consumer) {
            this.consumer = consumer;
        }

        public void startRDF() {
            this.owlParseStart = System.currentTimeMillis();
            try {
                this.consumer.startRDF();
            }
            catch (RDFHandlerException e) {
                throw new OWLParserException(e);
            }
        }

        public void endRDF() {
            try {
                this.consumer.endRDF();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("owlParse: timing={}", (Object)(System.currentTimeMillis() - this.owlParseStart));
                }
            }
            catch (RDFHandlerException e) {
                throw new OWLParserException(e);
            }
        }

        public void handleNamespace(String prefix, String uri) {
            try {
                this.consumer.handleNamespace(prefix, uri);
            }
            catch (RDFHandlerException e) {
                throw new OWLParserException(e);
            }
        }

        public void handleStatement(Statement nextStatement) {
            if (nextStatement.getPredicate().equals((Object)RDF.FIRST) || nextStatement.getPredicate().equals((Object)RDF.REST)) {
                if (!this.typedLists.contains(nextStatement.getSubject())) {
                    this.typedLists.add(nextStatement.getSubject());
                    try {
                        this.consumer.handleStatement(this.vf.createStatement(nextStatement.getSubject(), RDF.TYPE, (Value)RDF.LIST));
                    }
                    catch (RDFHandlerException e) {
                        throw new OWLParserException(e);
                    }
                    LOG.debug("Implicitly typing list={}", (Object)nextStatement);
                }
            } else if (nextStatement.getPredicate().equals((Object)RDF.TYPE) && nextStatement.getObject().equals(RDF.LIST)) {
                if (!this.typedLists.contains(nextStatement.getSubject())) {
                    LOG.debug("Explicit list type found={}", (Object)nextStatement);
                    this.typedLists.add(nextStatement.getSubject());
                } else {
                    LOG.debug("duplicate rdf:type rdf:List statements found={}", (Object)nextStatement);
                }
            }
            try {
                this.consumer.handleStatement(nextStatement);
            }
            catch (RDFHandlerException e) {
                throw new OWLParserException(e);
            }
        }

        public void handleComment(String comment) {
        }
    }
}

