/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.AnonymousIndividualProperties;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatImpl;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.rdf.AbsoluteIRIHelper;
import org.semanticweb.owlapi.rdf.model.RDFGraph;
import org.semanticweb.owlapi.rdf.model.RDFTranslator;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterPreferences;
import org.semanticweb.owlapi.util.AlwaysOutputId;
import org.semanticweb.owlapi.util.AxiomAppearance;
import org.semanticweb.owlapi.util.AxiomSubjectProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.IndividualAppearance;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAnonymousIndividualsWithMultipleOccurrences;
import org.semanticweb.owlapi.util.OWLAxiomsWithNestedAnnotations;
import org.semanticweb.owlapi.util.OWLEntityIRIComparator;
import org.semanticweb.owlapi.util.OWLObjectDesharer;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;
import org.semanticweb.owlapi.util.OWLObjectWalker;
import org.semanticweb.owlapi.util.SWRLVariableExtractor;
import org.semanticweb.owlapi.util.StructureWalker;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public abstract class RDFRendererBase {
    @Nonnull
    private static final String ANNOTATION_PROPERTIES_BANNER_TEXT = "Annotation properties";
    @Nonnull
    private static final String DATATYPES_BANNER_TEXT = "Datatypes";
    @Nonnull
    private static final String OBJECT_PROPERTIES_BANNER_TEXT = "Object Properties";
    @Nonnull
    private static final String DATA_PROPERTIES_BANNER_TEXT = "Data properties";
    @Nonnull
    private static final String CLASSES_BANNER_TEXT = "Classes";
    @Nonnull
    private static final String INDIVIDUALS_BANNER_TEXT = "Individuals";
    @Nonnull
    private static final String ANNOTATED_IRIS_BANNER_TEXT = "Annotations";
    @Nonnull
    private static final String GENERAL_AXIOMS_BANNER_TEXT = "General axioms";
    @Nonnull
    private static final String RULES_BANNER_TEXT = "Rules";
    @Nonnull
    private static final OWLEntityIRIComparator OWL_ENTITY_IRI_COMPARATOR = new OWLEntityIRIComparator();
    @Nonnull
    protected final OWLOntology ontology;
    protected RDFGraph graph;
    @Nonnull
    protected final Set<IRI> prettyPrintedTypes = RDFRendererBase.initPrettyTypes();
    private final OWLDocumentFormat format;
    private Set<IRI> punned;
    protected final IndividualAppearance occurrences;
    protected final AxiomAppearance axiomOccurrences;
    protected final Set<OWLAxiom> translatedAxioms = new HashSet<OWLAxiom>();
    protected final Set<RDFResource> pending = new HashSet<RDFResource>();
    private final Map<Object, Integer> blankNodeMap = new IdentityHashMap<Object, Integer>();
    private final Deque<RDFResourceBlankNode> nodesToRenderSeparately = new LinkedList<RDFResourceBlankNode>();
    private final Set<RDFResourceBlankNode> renderedNodes = new HashSet<RDFResourceBlankNode>();
    private final OWLObjectDesharer desharer;
    private final AtomicInteger nextBlankNodeId = new AtomicInteger(1);

    @Nonnull
    protected static Set<IRI> initPrettyTypes() {
        return new HashSet<IRI>(Arrays.asList(OWLRDFVocabulary.OWL_CLASS.getIRI(), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI(), OWLRDFVocabulary.OWL_THING.getIRI(), OWLRDFVocabulary.OWL_NOTHING.getIRI(), OWLRDFVocabulary.OWL_ONTOLOGY.getIRI(), OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI(), OWLRDFVocabulary.OWL_AXIOM.getIRI(), OWLRDFVocabulary.OWL_ANNOTATION.getIRI()));
    }

    public RDFRendererBase(@Nonnull OWLOntology ontology) {
        this(ontology, ontology.getOWLOntologyManager().getOntologyFormat(ontology));
    }

    protected RDFRendererBase(@Nonnull OWLOntology ontology, OWLDocumentFormat format) {
        this.ontology = ontology;
        this.format = format;
        this.desharer = new OWLObjectDesharer(this.ontology.getOWLOntologyManager());
        if (AnonymousIndividualProperties.shouldSaveIdsForAllAnonymousIndividuals()) {
            this.occurrences = new AlwaysOutputId();
            this.axiomOccurrences = new AlwaysOutputId();
        } else {
            OWLAnonymousIndividualsWithMultipleOccurrences visitor = new OWLAnonymousIndividualsWithMultipleOccurrences();
            this.occurrences = visitor;
            ontology.accept(visitor);
            this.axiomOccurrences = new OWLAxiomsWithNestedAnnotations();
        }
    }

    protected abstract void beginDocument() throws IOException;

    protected abstract void endDocument() throws IOException;

    protected void beginObject() throws IOException {
    }

    protected void endObject() throws IOException {
    }

    protected abstract void writeAnnotationPropertyComment(@Nonnull OWLAnnotationProperty var1) throws IOException;

    protected abstract void writeDataPropertyComment(@Nonnull OWLDataProperty var1) throws IOException;

    protected abstract void writeObjectPropertyComment(@Nonnull OWLObjectProperty var1) throws IOException;

    protected abstract void writeClassComment(@Nonnull OWLClass var1) throws IOException;

    protected abstract void writeDatatypeComment(@Nonnull OWLDatatype var1) throws IOException;

    protected abstract void writeIndividualComments(@Nonnull OWLNamedIndividual var1) throws IOException;

    public void render() throws IOException {
        this.graph = new RDFGraph();
        this.punned = this.ontology.getPunnedIRIs(Imports.EXCLUDED);
        this.beginDocument();
        this.renderOntologyHeader();
        this.renderOntologyComponents();
        this.endDocument();
    }

    private void renderOntologyComponents() throws IOException {
        this.renderInOntologySignatureEntities(OWLDocumentFormatImpl.determineIllegalPunnings(this.shouldInsertDeclarations(), this.ontology.getSignature(), this.ontology.getPunnedIRIs(Imports.INCLUDED)));
        this.renderAnonymousIndividuals();
        this.renderUntypedIRIAnnotationAssertions();
        this.renderGeneralAxioms();
        this.renderSWRLRules();
    }

    private void renderInOntologySignatureEntities(Collection<IRI> illegalPuns) throws IOException {
        Set<OWLAnnotationProperty> annotationProperties = this.ontology.getAnnotationPropertiesInSignature(Imports.EXCLUDED);
        this.renderEntities(annotationProperties, ANNOTATION_PROPERTIES_BANNER_TEXT, illegalPuns);
        Set<OWLDatatype> datatypes = this.ontology.getDatatypesInSignature();
        this.renderEntities(datatypes, DATATYPES_BANNER_TEXT, illegalPuns);
        Set<OWLObjectProperty> objectProperties = this.ontology.getObjectPropertiesInSignature();
        this.renderEntities(objectProperties, OBJECT_PROPERTIES_BANNER_TEXT, illegalPuns);
        Set<OWLDataProperty> dataProperties = this.ontology.getDataPropertiesInSignature();
        this.renderEntities(dataProperties, DATA_PROPERTIES_BANNER_TEXT, illegalPuns);
        Set<OWLClass> clses = this.ontology.getClassesInSignature();
        this.renderEntities(clses, CLASSES_BANNER_TEXT, illegalPuns);
        Set<OWLNamedIndividual> individuals = this.ontology.getIndividualsInSignature();
        this.renderEntities(individuals, INDIVIDUALS_BANNER_TEXT, illegalPuns);
    }

    private void renderEntities(@Nonnull Set<? extends OWLEntity> entities, @Nonnull String bannerText, Collection<IRI> illegalPuns) throws IOException {
        boolean firstRendering = XMLWriterPreferences.getInstance().isBannersEnabled();
        for (OWLEntity entity : RDFRendererBase.toSortedSet(entities)) {
            assert (entity != null);
            if (!this.createGraph(entity, illegalPuns)) continue;
            if (firstRendering) {
                firstRendering = false;
                if (!bannerText.isEmpty()) {
                    this.writeBanner(bannerText);
                }
            }
            this.renderEntity(entity);
        }
    }

    private void renderEntity(@Nonnull OWLEntity entity) throws IOException {
        this.beginObject();
        this.writeEntityComment(entity);
        this.render(new RDFResourceIRI(this.verifyAbsolute(entity.getIRI())), true);
        this.renderAnonRoots();
        this.endObject();
    }

    private void writeEntityComment(@Nonnull OWLEntity entity) throws IOException {
        if (entity.isOWLClass()) {
            this.writeClassComment(entity.asOWLClass());
        } else if (entity.isOWLDatatype()) {
            this.writeDatatypeComment(entity.asOWLDatatype());
        } else if (entity.isOWLObjectProperty()) {
            this.writeObjectPropertyComment(entity.asOWLObjectProperty());
        } else if (entity.isOWLDataProperty()) {
            this.writeDataPropertyComment(entity.asOWLDataProperty());
        } else if (entity.isOWLAnnotationProperty()) {
            this.writeAnnotationPropertyComment(entity.asOWLAnnotationProperty());
        } else if (entity.isOWLNamedIndividual()) {
            this.writeIndividualComments(entity.asOWLNamedIndividual());
        }
    }

    private void renderUntypedIRIAnnotationAssertions() throws IOException {
        TreeSet<IRI> annotatedIRIs = new TreeSet<IRI>();
        for (OWLAnnotationAssertionAxiom ax : this.ontology.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
            IRI iri;
            OWLAnnotationSubject subject = ax.getSubject();
            if (!(subject instanceof IRI) || !this.punned.contains(iri = (IRI)subject) && this.ontology.containsEntityInSignature(iri, Imports.EXCLUDED)) continue;
            annotatedIRIs.add(iri);
        }
        if (!annotatedIRIs.isEmpty()) {
            this.writeBanner(ANNOTATED_IRIS_BANNER_TEXT);
            for (IRI iri : annotatedIRIs) {
                assert (iri != null);
                this.beginObject();
                this.createGraph(this.ontology.getAnnotationAssertionAxioms(iri));
                this.render(new RDFResourceIRI(this.verifyAbsolute(iri)), true);
                this.renderAnonRoots();
                this.endObject();
            }
        }
    }

    private void renderAnonymousIndividuals() throws IOException {
        for (OWLAnonymousIndividual anonInd : CollectionFactory.sortOptionally(this.ontology.getReferencedAnonymousIndividuals(Imports.EXCLUDED))) {
            assert (anonInd != null);
            boolean anonRoot = true;
            TreeSet<OWLAxiom> axioms = new TreeSet<OWLAxiom>();
            for (OWLAxiom ax : CollectionFactory.sortOptionally(this.ontology.getReferencingAxioms((OWLPrimitive)anonInd, Imports.EXCLUDED))) {
                if (ax instanceof OWLDifferentIndividualsAxiom) continue;
                assert (ax != null);
                AxiomSubjectProvider subjectProvider = new AxiomSubjectProvider();
                OWLObject obj = subjectProvider.getSubject(ax);
                if (!obj.equals(anonInd)) {
                    anonRoot = false;
                    break;
                }
                axioms.add(ax);
            }
            if (!anonRoot) continue;
            this.createGraph(axioms);
            this.renderAnonRoots();
        }
    }

    private void renderSWRLRules() throws IOException {
        TreeSet<SWRLRule> ruleAxioms = new TreeSet<SWRLRule>(this.ontology.getAxioms(AxiomType.SWRL_RULE));
        if (!ruleAxioms.isEmpty()) {
            this.createGraph(ruleAxioms);
            this.writeBanner(RULES_BANNER_TEXT);
            SWRLVariableExtractor variableExtractor = new SWRLVariableExtractor();
            for (SWRLRule rule : ruleAxioms) {
                rule.accept(variableExtractor);
            }
            for (SWRLVariable var : variableExtractor.getVariables()) {
                this.render(new RDFResourceIRI(this.verifyAbsolute(var.getIRI())), true);
            }
            this.renderAnonRoots();
        }
    }

    protected IRI verifyAbsolute(IRI iri) {
        return AbsoluteIRIHelper.verifyAbsolute(iri, this.format, this.ontology);
    }

    private void renderGeneralAxioms() throws IOException {
        boolean haveWrittenBanner = false;
        Set<OWLAxiom> generalAxioms = this.getGeneralAxioms();
        for (OWLAxiom axiom : generalAxioms) {
            this.createGraph(Collections.singleton(axiom));
            Set<RDFResourceBlankNode> rootNodes = this.graph.getRootAnonymousNodes();
            if (rootNodes.isEmpty()) continue;
            if (!haveWrittenBanner) {
                this.writeBanner(GENERAL_AXIOMS_BANNER_TEXT);
                haveWrittenBanner = true;
            }
            this.beginObject();
            this.renderAnonRoots();
            this.endObject();
        }
    }

    protected RDFGraph getRDFGraph() {
        return OWLAPIPreconditions.verifyNotNull(this.graph, "rdfGraph not initialised yet");
    }

    @Nonnull
    private Set<OWLAxiom> getGeneralAxioms() {
        TreeSet<OWLAxiom> generalAxioms = new TreeSet<OWLAxiom>();
        generalAxioms.addAll(this.ontology.getGeneralClassAxioms());
        generalAxioms.addAll(this.ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS));
        for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (oWLDisjointClassesAxiom.getClassExpressions().size() <= 2) continue;
            generalAxioms.add(oWLDisjointClassesAxiom);
        }
        for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (oWLDisjointObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            generalAxioms.add(oWLDisjointObjectPropertiesAxiom);
        }
        for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (oWLDisjointDataPropertiesAxiom.getProperties().size() <= 2) continue;
            generalAxioms.add(oWLDisjointDataPropertiesAxiom);
        }
        for (OWLHasKeyAxiom oWLHasKeyAxiom : this.ontology.getAxioms(AxiomType.HAS_KEY)) {
            if (!oWLHasKeyAxiom.getClassExpression().isAnonymous()) continue;
            generalAxioms.add(oWLHasKeyAxiom);
        }
        return generalAxioms;
    }

    protected void renderOntologyHeader() throws IOException {
        this.createGraph(this.ontology);
        RDFResource node = this.getRDFGraph().getOntology();
        if (node != null) {
            this.render(node);
        }
    }

    protected void render(RDFResource node) throws IOException {
        this.render(node, true);
        for (RDFResource n : this.getRDFGraph().getSubjectsForObject(node)) {
            this.render(n, true);
        }
    }

    private boolean createGraph(@Nonnull OWLEntity entity, Collection<IRI> illegalPuns) {
        TreeSet<OWLAxiom> axioms = new TreeSet<OWLAxiom>();
        axioms.addAll(this.ontology.getDeclarationAxioms(entity));
        entity.accept(new GraphVisitor(axioms));
        if (axioms.isEmpty() && this.shouldInsertDeclarations() && !illegalPuns.contains(entity.getIRI()) && OWLDocumentFormatImpl.isMissingType(entity, this.ontology)) {
            axioms.add(this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(entity));
        }
        if (!this.punned.contains(entity.getIRI())) {
            axioms.addAll(this.ontology.getAnnotationAssertionAxioms(entity.getIRI()));
        }
        this.createGraph(axioms);
        return !axioms.isEmpty();
    }

    protected boolean shouldInsertDeclarations() {
        return this.format == null || this.format.isAddMissingTypes();
    }

    protected void createGraph(@Nonnull Set<? extends OWLObject> o) {
        ArrayList<? extends OWLObject> objects = new ArrayList<OWLObject>(o);
        objects.sort(null);
        RDFTranslator translator = new RDFTranslator(this.ontology.getOWLOntologyManager(), this.ontology, this.format, this.shouldInsertDeclarations(), this.occurrences, this.axiomOccurrences, this.nextBlankNodeId, this.blankNodeMap, this.translatedAxioms);
        for (OWLObject oWLObject : objects) {
            translator.translate(this.deshare(oWLObject));
        }
        this.graph = translator.getGraph();
        this.getRDFGraph().forceIdOutput();
    }

    protected void createGraph(OWLObject o) {
        this.createGraph(Collections.singleton(o));
    }

    protected OWLObject deshare(OWLObject o) {
        if (RDFRendererBase.hasSharedStructure(o)) {
            return o.accept(this.desharer);
        }
        return o;
    }

    private static boolean hasSharedStructure(OWLObject o) {
        final HashMap counters = new HashMap();
        OWLObjectWalker<OWLObject> walker = new OWLObjectWalker<OWLObject>(Collections.singleton(o), true, StructureWalker.AnnotationWalkingControl.DONT_WALK_ANNOTATIONS);
        walker.walkStructure(new OWLObjectVisitorAdapter(){

            @Override
            protected void handleDefault(OWLObject axiom) {
                if (RDFRendererBase.isNotAnonymousExpression(axiom)) {
                    return;
                }
                AtomicInteger i = (AtomicInteger)counters.get(axiom);
                if (i == null) {
                    i = new AtomicInteger();
                    counters.put(axiom, i);
                }
                i.incrementAndGet();
            }
        });
        for (AtomicInteger i : counters.values()) {
            if (i.get() <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotAnonymousExpression(OWLObject o) {
        boolean b;
        boolean bl = b = o instanceof OWLAxiom || o instanceof OWLOntology || o instanceof OWLPrimitive || o instanceof HasIRI;
        if (!b && o instanceof SWRLIndividualArgument) {
            b = RDFRendererBase.isNotAnonymousExpression(((SWRLIndividualArgument)o).getIndividual());
        }
        return b;
    }

    protected abstract void writeBanner(@Nonnull String var1) throws IOException;

    @Nonnull
    private static List<OWLEntity> toSortedSet(@Nonnull Set<? extends OWLEntity> entities) {
        ArrayList<OWLEntity> results = new ArrayList<OWLEntity>(entities);
        Collections.sort(results, OWL_ENTITY_IRI_COMPARATOR);
        return results;
    }

    public void renderAnonRoots() throws IOException {
        TreeSet<RDFResourceBlankNode> rootAnonymousNodes = new TreeSet<RDFResourceBlankNode>(this.graph.getRootAnonymousNodes());
        for (RDFResourceBlankNode node : rootAnonymousNodes) {
            assert (node != null);
            this.render(node, true);
        }
    }

    public abstract void render(@Nonnull RDFResource var1, boolean var2) throws IOException;

    protected boolean isObjectList(RDFResource node) {
        for (RDFTriple triple : this.graph.getTriplesForSubject(node)) {
            if (!triple.getPredicate().getIRI().equals(OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous() || !triple.getObject().getIRI().equals(OWLRDFVocabulary.RDF_LIST.getIRI())) continue;
            ArrayList<RDFNode> items = new ArrayList<RDFNode>();
            this.toJavaList(node, items);
            for (RDFNode n : items) {
                if (!n.isLiteral()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void toJavaList(RDFNode n, @Nonnull List<RDFNode> list) {
        RDFNode currentNode = n;
        while (currentNode != null) {
            for (RDFTriple triple : this.graph.getTriplesForSubject(currentNode)) {
                if (!triple.getPredicate().getIRI().equals(OWLRDFVocabulary.RDF_FIRST.getIRI())) continue;
                list.add(triple.getObject());
            }
            for (RDFTriple triple : this.graph.getTriplesForSubject(currentNode)) {
                if (!triple.getPredicate().getIRI().equals(OWLRDFVocabulary.RDF_REST.getIRI())) continue;
                if (!triple.getObject().isAnonymous()) {
                    if (!triple.getObject().getIRI().equals(OWLRDFVocabulary.RDF_NIL.getIRI())) continue;
                    currentNode = null;
                    continue;
                }
                if (!(triple.getObject() instanceof RDFResource)) continue;
                currentNode = triple.getObject();
            }
        }
    }

    protected void defer(RDFNode object) {
        this.nodesToRenderSeparately.add((RDFResourceBlankNode)object);
    }

    protected void deferredRendering() throws IOException {
        while (!this.nodesToRenderSeparately.isEmpty()) {
            RDFResourceBlankNode polled = this.nodesToRenderSeparately.poll();
            if (!this.renderedNodes.add(polled)) continue;
            this.render(polled, false);
        }
    }

    private class GraphVisitor
    implements OWLEntityVisitor {
        private final Set<OWLAxiom> axioms;

        public GraphVisitor(Set<OWLAxiom> axioms) {
            this.axioms = axioms;
        }

        boolean inverse(OWLAxiom ax, OWLNamedIndividual i) {
            OWLObjectPropertyAssertionAxiom candidate;
            return ax instanceof OWLObjectPropertyAssertionAxiom && ((OWLObjectPropertyExpression)(candidate = (OWLObjectPropertyAssertionAxiom)ax).getProperty()).isAnonymous() && ((OWLIndividual)candidate.getObject()).equals(i);
        }

        boolean inverseFirst(OWLAxiom ax, OWLNamedIndividual i) {
            OWLObjectPropertyAssertionAxiom candidate;
            return !(ax instanceof OWLObjectPropertyAssertionAxiom) || !((OWLObjectPropertyExpression)(candidate = (OWLObjectPropertyAssertionAxiom)ax).getProperty()).isAnonymous() || !candidate.getSubject().equals(i);
        }

        @Override
        public void visit(OWLClass cls) {
            for (OWLAxiom oWLAxiom : RDFRendererBase.this.ontology.getAxioms(cls, Imports.EXCLUDED)) {
                if (!this.threewayDisjoint(oWLAxiom) || !this.disjoint(oWLAxiom, cls) || !this.equiv(oWLAxiom, cls)) continue;
                this.axioms.add(oWLAxiom);
            }
            for (OWLHasKeyAxiom oWLHasKeyAxiom : RDFRendererBase.this.ontology.getAxioms(AxiomType.HAS_KEY)) {
                if (!oWLHasKeyAxiom.getClassExpression().equals(cls)) continue;
                this.axioms.add(oWLHasKeyAxiom);
            }
        }

        boolean equiv(OWLAxiom ax, OWLClass cls) {
            OWLEquivalentClassesAxiom invAxiom;
            return !(ax instanceof OWLEquivalentClassesAxiom) || (invAxiom = (OWLEquivalentClassesAxiom)ax).getClassExpressionsAsList().get(0).equals(cls);
        }

        boolean disjoint(OWLAxiom ax, OWLClass cls) {
            OWLDisjointClassesAxiom invAxiom;
            return !(ax instanceof OWLDisjointClassesAxiom) || (invAxiom = (OWLDisjointClassesAxiom)ax).getClassExpressionsAsList().get(0).equals(cls);
        }

        boolean disjoint(OWLAxiom ax, OWLDataProperty cls) {
            OWLDisjointDataPropertiesAxiom invAxiom;
            return !(ax instanceof OWLDisjointDataPropertiesAxiom) || ((OWLDataPropertyExpression)(invAxiom = (OWLDisjointDataPropertiesAxiom)ax).getProperties().iterator().next()).equals(cls);
        }

        boolean disjoint(OWLAxiom ax, OWLObjectProperty cls) {
            OWLDisjointObjectPropertiesAxiom invAxiom;
            return !(ax instanceof OWLDisjointObjectPropertiesAxiom) || ((OWLObjectPropertyExpression)(invAxiom = (OWLDisjointObjectPropertiesAxiom)ax).getProperties().iterator().next()).equals(cls);
        }

        boolean equiv(OWLAxiom ax, OWLDataProperty cls) {
            OWLEquivalentDataPropertiesAxiom invAxiom;
            return !(ax instanceof OWLEquivalentDataPropertiesAxiom) || ((OWLDataPropertyExpression)(invAxiom = (OWLEquivalentDataPropertiesAxiom)ax).getProperties().iterator().next()).equals(cls);
        }

        boolean equiv(OWLAxiom ax, OWLObjectProperty cls) {
            OWLEquivalentObjectPropertiesAxiom invAxiom;
            return !(ax instanceof OWLEquivalentObjectPropertiesAxiom) || ((OWLObjectPropertyExpression)(invAxiom = (OWLEquivalentObjectPropertiesAxiom)ax).getProperties().iterator().next()).equals(cls);
        }

        @Override
        public void visit(OWLDatatype datatype) {
            this.axioms.addAll(RDFRendererBase.this.ontology.getDatatypeDefinitions(datatype));
        }

        @Override
        public void visit(OWLNamedIndividual individual) {
            for (OWLAxiom oWLAxiom : CollectionFactory.sortOptionally(RDFRendererBase.this.ontology.getAxioms((OWLIndividual)individual, Imports.EXCLUDED))) {
                if (oWLAxiom instanceof OWLDifferentIndividualsAxiom || !this.same(oWLAxiom, individual) || !this.inverseFirst(oWLAxiom, individual)) continue;
                this.axioms.add(oWLAxiom);
            }
            for (OWLAxiom oWLAxiom : RDFRendererBase.this.ontology.getReferencingAxioms(individual)) {
                if (!this.inverse(oWLAxiom, individual)) continue;
                this.axioms.add(oWLAxiom);
            }
        }

        @Override
        public void visit(OWLDataProperty property) {
            for (OWLAxiom oWLAxiom : RDFRendererBase.this.ontology.getAxioms(property, Imports.EXCLUDED)) {
                if (!this.threewayDisjointData(oWLAxiom) || !this.equiv(oWLAxiom, property) || !this.disjoint(oWLAxiom, property)) continue;
                this.axioms.add(oWLAxiom);
            }
        }

        @Override
        public void visit(OWLObjectProperty property) {
            for (OWLAxiom oWLAxiom : RDFRendererBase.this.ontology.getAxioms((OWLObjectPropertyExpression)property, Imports.EXCLUDED)) {
                if (!this.threewayDisjointObject(oWLAxiom) || !this.inverse(oWLAxiom, property) || !this.equiv(oWLAxiom, property) || !this.disjoint(oWLAxiom, property)) continue;
                this.axioms.add(oWLAxiom);
            }
            for (OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom : RDFRendererBase.this.ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                if (!oWLSubPropertyChainOfAxiom.getSuperProperty().equals(property)) continue;
                this.axioms.add(oWLSubPropertyChainOfAxiom);
            }
            this.axioms.addAll(RDFRendererBase.this.ontology.getAxioms((OWLObjectPropertyExpression)RDFRendererBase.this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLObjectInverseOf(property), Imports.EXCLUDED));
        }

        @Override
        public void visit(OWLAnnotationProperty property) {
            this.axioms.addAll(RDFRendererBase.this.ontology.getAxioms(property, Imports.EXCLUDED));
        }

        boolean inverse(OWLAxiom ax, OWLObjectProperty p) {
            OWLInverseObjectPropertiesAxiom invAxiom;
            return !(ax instanceof OWLInverseObjectPropertiesAxiom) || (invAxiom = (OWLInverseObjectPropertiesAxiom)ax).getFirstProperty().equals(p);
        }

        boolean same(OWLAxiom ax, OWLIndividual i) {
            OWLSameIndividualAxiom invAxiom;
            return !(ax instanceof OWLSameIndividualAxiom) || (invAxiom = (OWLSameIndividualAxiom)ax).getIndividualsAsList().get(0).equals(i);
        }

        boolean threewayDisjoint(OWLAxiom ax) {
            OWLDisjointClassesAxiom disjAx;
            return !(ax instanceof OWLDisjointClassesAxiom) || (disjAx = (OWLDisjointClassesAxiom)ax).getClassExpressionsAsList().size() <= 2;
        }

        boolean threewayDisjointData(OWLAxiom ax) {
            return !(ax instanceof OWLDisjointDataPropertiesAxiom) || ((OWLDisjointDataPropertiesAxiom)ax).getProperties().size() <= 2;
        }

        boolean threewayDisjointObject(OWLAxiom ax) {
            return !(ax instanceof OWLDisjointObjectPropertiesAxiom) || ((OWLDisjointObjectPropertiesAxiom)ax).getProperties().size() <= 2;
        }
    }
}

