from .basic import *
from .data import *
from .mixer import *
from .query import *
from .template import *
from .thumbnail import *

__all__ = [
    # Basic commands
    "LOADBG",
    "LOAD",
    "PLAY",
    "PAUSE",
    "RESUME",
    "STOP",
    "CLEAR",
    "CALL",
    "SWAP",
    "ADD",
    "REMOVE",
    "PRINT",
    "LOG_LEVEL",
    "LOG_CATEGORY",
    "SET",
    "LOCK",
    # Data commands
    "DATA_STORE",
    "DATA_RETRIEVE",
    "DATA_LIST",
    "DATA_REMOVE",
    # Mixer commands
    "MIXER_KEYER",
    "MIXER_CHROMA",
    "MIXER_BLEND",
    "MIXER_INVERT",
    "MIXER_OPACITY",
    "MIXER_BRIGHTNESS",
    "MIXER_SATURATION",
    "MIXER_CONTRAST",
    "MIXER_LEVELS",
    "MIXER_FILL",
    "MIXER_CLIP",
    "MIXER_ANCHOR",
    "MIXER_CROP",
    "MIXER_ROTATION",
    "MIXER_PERSPECTIVE",
    "MIXER_MIPMAP",
    "MIXER_VOLUME",
    "MIXER_MASTERVOLUME",
    "MIXER_STRAIGHT_ALPHA_OUTPUT",
    "MIXER_GRID",
    "MIXER_COMMIT",
    "MIXER_CLEAR",
    "CHANNEL_GRID",
    # Query commands
    "CINF",
    "CLS",
    "FLS",
    "TLS",
    "VERSION",
    "INFO",
    "INFO_CHANNELS",
    "INFO_TEMPLATE",
    "INFO_CONFIG",
    "INFO_PATHS",
    "INFO_SYSTEM",
    "INFO_SERVER",
    "INFO_QUEUES",
    "INFO_THREADS",
    "INFO_DELAY",
    "DIAG",
    "GL_INFO",
    "GL_GC",
    "BYE",
    "KILL",
    "RESTART",
    "HELP",
    "HELP_PRODUCER",
    "HELP_CONSUMER",
    # Template commands
    "CG_ADD",
    "CG_PLAY",
    "CG_STOP",
    "CG_NEXT",
    "CG_REMOVE",
    "CG_CLEAR",
    "CG_UPDATE",
    "CG_INVOKE",
    "CG_INFO",
    # Thumbnail commands
    "THUMBNAIL_LIST",
    "THUMBNAIL_RETRIEVE",
    "THUMBNAIL_GENERATE",
    "THUMBNAIL_GENERATE_ALL",
]
