#!/usr/bin/env python3
# thoth-adviser
# Copyright(C) 2021 Fridolin Pokorny
#
# This program is free software: you can redistribute it and / or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

"""Schema v1 based prescription units."""

from .add_package_step import AddPackageStepPrescription
from .boot import BootPrescription
from .gh_release_notes import GHReleaseNotesWrapPrescription
from .group import GroupStepPrescription
from .pseudonym import PseudonymPrescription
from .sieve import SievePrescription
from .skip_package_sieve import SkipPackageSievePrescription
from .skip_package_step import SkipPackageStepPrescription
from .step import StepPrescription
from .stride import StridePrescription
from .unit import UnitPrescription
from .wrap import WrapPrescription


__all__ = [
    "AddPackageStepPrescription",
    "BootPrescription",
    "GHReleaseNotesWrapPrescription",
    "GroupStepPrescription",
    "PseudonymPrescription",
    "SievePrescription",
    "SkipPackageSievePrescription",
    "SkipPackageStepPrescription",
    "StepPrescription",
    "StridePrescription",
    "UnitPrescription",
    "WrapPrescription",
]
