"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const path = require("path");
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const s3 = new aws_sdk_1.S3();
async function handler(assetHashes) {
    if (!process.env.BUCKET_NAME) {
        throw new Error('Missing BUCKET_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextKeyMarker;
    let finished = false;
    while (!finished) {
        const response = await s3.listObjectVersions({
            Bucket: process.env.BUCKET_NAME,
            KeyMarker: nextKeyMarker,
        }).promise();
        const toDelete = response.Versions?.filter(v => {
            if (!v.Key) {
                return false;
            }
            const hash = path.basename(v.Key, path.extname(v.Key));
            let pred = !assetHashes.includes(hash);
            if (process.env.RETAIN_MILLISECONDS) {
                if (!v.LastModified) {
                    return false;
                }
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && v.LastModified < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await s3.deleteObjects({
                    Bucket: process.env.BUCKET_NAME,
                    Delete: {
                        Objects: toDelete.map(v => ({ Key: v.Key, VersionId: v.VersionId })),
                    },
                }).promise();
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => acc + (x.Size ?? 0), 0);
        }
        nextKeyMarker = response.NextKeyMarker;
        if (nextKeyMarker === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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