var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/url-shortener/redirect.edge-lambda.ts
var redirect_edge_lambda_exports = {};
__export(redirect_edge_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(redirect_edge_lambda_exports);
var import_aws_sdk = require("aws-sdk");
var s3 = new import_aws_sdk.S3({ apiVersion: "2006-03-01" });
async function handler(event) {
  var _a;
  const request = event.Records[0].cf.request;
  try {
    const s3Origin = (_a = request.origin) == null ? void 0 : _a.s3;
    if (!s3Origin) {
      throw new Error("No S3 origin");
    }
    const bucket = s3Origin.domainName.replace(new RegExp(`.s3.${s3Origin.region}.amazonaws.com$`), "");
    const key = request.uri.substring(1);
    const data = await s3.getObject({
      Bucket: bucket,
      Key: key
    }).promise();
    if (!data.Body) {
      throw new Error("No body");
    }
    const redirect = JSON.parse(data.Body.toString());
    return {
      status: "301",
      statusDescription: "Moved Permanently",
      headers: {
        location: [{
          key: "Location",
          value: redirect.url
        }]
      }
    };
  } catch (err) {
    console.log(err);
    return {
      status: "404",
      statusDescription: "Not Found"
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
