/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.insertionsort;

import org.apache.sysds.runtime.compress.colgroup.insertionsort.AInsertionSorter;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.MaterializeSort;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.MergeSort;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public final class InsertionSorterFactory {
    public static AInsertionSorter create(int numRows, IntArrayList[] offsets) {
        return InsertionSorterFactory.create(InsertionSorterFactory.getEndLength(offsets), numRows, offsets);
    }

    public static AInsertionSorter create(int endLength, int numRows, IntArrayList[] offsets) {
        return InsertionSorterFactory.create(endLength, numRows, offsets, -1, SORT_TYPE.MATERIALIZE);
    }

    public static AInsertionSorter create(int numRows, IntArrayList[] offsets, int negativeIndex) {
        if (negativeIndex < 0) {
            return InsertionSorterFactory.create(InsertionSorterFactory.getEndLength(offsets), numRows, offsets);
        }
        return InsertionSorterFactory.create(numRows - offsets[negativeIndex].size(), numRows, offsets, negativeIndex);
    }

    public static AInsertionSorter create(int endLength, int numRows, IntArrayList[] offsets, int negativeIndex) {
        return InsertionSorterFactory.create(endLength, numRows, offsets, negativeIndex, SORT_TYPE.MATERIALIZE);
    }

    public static AInsertionSorter create(int numRows, IntArrayList[] offsets, int negativeIndex, SORT_TYPE st) {
        if (negativeIndex < 0) {
            return InsertionSorterFactory.create(InsertionSorterFactory.getEndLength(offsets), numRows, offsets, negativeIndex, st);
        }
        return InsertionSorterFactory.create(numRows - offsets[negativeIndex].size(), numRows, offsets, negativeIndex, st);
    }

    public static AInsertionSorter create(int endLength, int numRows, IntArrayList[] offsets, int negativeIndex, SORT_TYPE st) {
        switch (st) {
            case MERGE: {
                return new MergeSort(endLength, numRows, offsets, negativeIndex);
            }
        }
        return new MaterializeSort(endLength, numRows, offsets, negativeIndex);
    }

    private static int getEndLength(IntArrayList[] offsets) {
        int endLength = 0;
        for (IntArrayList l : offsets) {
            endLength += l.size();
        }
        return endLength;
    }

    public static enum SORT_TYPE {
        MERGE,
        MATERIALIZE;

    }
}

